/***************************************************************************
 api_c.cpp
                             -------------------
    begin       : October 2002
    copyright   : (C) 2002, 2003 by Christian Stimming
    email       : stimming@tuhh.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "assert.h"

#include "api.h"
#include "api_c.h"
#include <hbcistring.h>


// ------------------ C Wrappers

// Helpers for non-deleting Pointer


static HBCI::Pointer<HBCI_Bank> bankPointer(HBCI_Bank *b)
{
    HBCI::Pointer<HBCI_Bank> bp = b;
    bp.setAutoDelete(false);
    return bp;
}


static HBCI::Pointer<HBCI_User> userPointer(HBCI_User *u)
{
    HBCI::Pointer<HBCI_User> up = u;
    up.setAutoDelete(false);
    return up;
}


// class HBCI_API
HBCI_API *HBCI_API_new(int readonly, int retrievalOnly)
{
    return new HBCI_API(readonly, retrievalOnly);
}


void HBCI_API_delete(HBCI_API *h)
{
    delete h;
}


HBCI_Hbci *HBCI_API_Hbci(HBCI_API *h)
{
    return h;
}


void HBCI_API_setMonitor(HBCI_API *h, HBCI_ProgressMonitor *m, int autoDelete)
{
    assert(h);
    assert(m);
    HBCI::Pointer<HBCI::ProgressMonitor> mp = m;
    mp.setAutoDelete(autoDelete);
    h->setMonitor(mp);
}


const list_HBCI_Bank *HBCI_API_bankList(const HBCI_API *h)
{
    assert(h);
    return &(h->banks());
}


HBCI_Bank *HBCI_API_findBank(const HBCI_API *h, int country,
			     const char *bankCode)
{
    assert(h);
    return (h->findBank(country, string(bankCode ? bankCode : ""))).ptr();
}


/*HBCI_Account *HBCI_API_findAccount(const HBCI_API *h, int country,
				   const char *bankCode,
				   const char *accnr)
{
    assert(h);
    return (h->findAccount(country, string(bankCode), string(accnr))).ptr();
    }*/
/*HBCI_Account *HBCI_API_findAccountWSuf(const HBCI_API *h, int country,
				       const char *bankCode,
				       const char *accnr,
				       const char *suffix)
{
    assert(h);
    return (h->findAccount(country, string(bankCode), string(accnr),
			   string(suffix))).ptr();
			   }*/
/*HBCI_User *HBCI_API_findUser(const HBCI_API *h,
			     int country,
			     const char *bankCode,
			     const char *userId)
{
    assert(h);
    return (h->findUser(country, string(bankCode), string(userId))).ptr();
    }*/


HBCI_Medium *HBCI_API_findMedium(const HBCI_API *h,
				 const char *name)
{
    assert(h);
    return (h->findMedium(string(name ? name : ""))).ptr();
}


HBCI_Error *HBCI_API_addBank(HBCI_API *h, HBCI_Bank *b, int autoDelete)
{
    assert(h);
    assert(b);
    HBCI::Pointer<HBCI_Bank> bp = b;
    bp.setAutoDelete(autoDelete);
    try {
	h->addBank(bp);
	return 0;
    }
    catch(HBCI_Error err) {
	return new HBCI_Error(err);
    }
    catch (...) {
	fprintf(stderr, "HBCI_API_addBank: Caught unknown exception.\n");
	return new HBCI_Error("HBCI_API_addBank",
			      ERROR_LEVEL_CRITICAL,
			      0,
			      ERROR_ADVISE_ABORT,
			      "Caught unknown exception.", "");
    }
}


HBCI_Bank *HBCI_API_bankFactory(const HBCI_API *h,
				int country,
				const char *bankCode,
				const char *server)
{
    assert(h);
    HBCI::Pointer<HBCI_Bank> bp = h->bankFactory(country, 
						 string(bankCode ? bankCode : ""), 
						 string(server ? server : ""));
    bp.setAutoDelete(false);
    return bp.ptr();
}


HBCI_User *HBCI_API_userFactory(HBCI_Bank *b,
				HBCI_Medium *m,
				int mediumAutoDelete,
				const char *userid)
{
    assert(b);
    assert(m);
    HBCI::Pointer<HBCI_Medium> mp = m;
    mp.setAutoDelete(mediumAutoDelete);
    HBCI::Pointer<HBCI_User> up = 
	HBCI_API::userFactory(bankPointer(b), 
			      mp, 
			      string(userid ? userid : ""));
    up.setAutoDelete(false);
    return up.ptr();
}
HBCI_Customer *HBCI_API_customerFactory(HBCI_User *u,
					const char *id,
					const char *custName)
{
    assert(u);
    HBCI::Pointer<HBCI_Customer> cp = 
	HBCI_API::customerFactory(userPointer(u),
				  string(id ? id : ""),
				  string(custName ? custName : ""));
    cp.setAutoDelete(false);
    return cp.ptr();
}
HBCI_Account *HBCI_API_accountFactory(HBCI_Bank *b,
				      const char *accountId,
				      const char *accountSubId)
{
    assert(b);
    HBCI::Pointer<HBCI_Account> ap = 
	(accountSubId ? 
	 HBCI_API::accountFactory(bankPointer(b),
				  string(accountId ? accountId : ""),
				  string(accountSubId ? accountSubId : ""))
	 : (accountId ?
	    HBCI_API::accountFactory(bankPointer(b),
				     string(accountId ? accountId : ""))
	    : HBCI_API::accountFactory(bankPointer(b))));

    ap.setAutoDelete(false);
    return ap.ptr();
}

HBCI_Medium *HBCI_API_createNewMedium(HBCI_API *h,
				      const char *mtype,
				      int readonly,
				      int country,
				      const char *bankId,
				      const char *userid,
				      const char *name,
				      HBCI_Error **err)
{
    assert(h);
    assert(err);
    try {
      HBCI::Pointer<HBCI::Medium> mp =
	h->createNewMedium(string(mtype ? mtype : ""),
			   readonly,
			   country,
			   string(bankId ? bankId : ""),
			   string(userid ? userid : ""),
			   string(name ? name : ""));
      mp.setAutoDelete(false);
      return mp.ptr();
    }
    catch(HBCI_Error xerr) {
	fprintf(stderr,"HBCI_API_createNewMedium: Caught error: %s\n",
		xerr.errorString().c_str());
	*err = new HBCI_Error(xerr);
	return 0;
    }
    catch (...) {
	fprintf(stderr, "HBCI_API_createNewMedium: Caught unknown exception.\n");
	*err = new HBCI_Error("HBCI_API_createNewMedium",
			      ERROR_LEVEL_CRITICAL,
			      0,
			      ERROR_ADVISE_ABORT,
			      "Caught unknown exception.", "");
	return 0;
    }
}

MediumType HBCI_API_mediumType(HBCI_API *h,
			       const char *mtype)
{
    assert(h);
    try {
	return h->mediumType(mtype ? string(mtype) : "");
    }
    catch (HBCI_Error err) {
	/*fprintf(stderr,"HBCI_API_mediumType: Caught error: %s\n",
	  err.errorString().c_str());*/
	return MediumTypeUnknown;
    }
    catch (...) {
	fprintf(stderr, "HBCI_API_mediumType: Caught unknown exception.\n");
	return MediumTypeUnknown;
    }
}

HBCI_MediumPluginList *HBCI_API_enumerateMediumPlugins(HBCI_API *h)
{
    assert(h);
    try {
	HBCI::Pointer<HBCI::MediumPluginList> p = 
	    h->enumerateMediumPlugins();
	p.setAutoDelete(false);
	return p.ptr();
    }
    catch (HBCI_Error err) {
	fprintf(stderr,"HBCI_API_enumerateMediumPlugins: Caught error: %s\n",
		err.errorString().c_str());
	return NULL;
    }
    catch (...) {
	fprintf(stderr, "HBCI_API_enumerateMediumPlugins: "
		"Caught unknown exception.\n");
	return NULL;
    }
}

HBCI_Error *HBCI_API_loadEnvironment(HBCI_API *h,
				     const char *filename)
{
    assert(h);
    try {
	return new HBCI_Error(h->loadEnvironment(string(filename ? filename : "")));
    }
    catch (HBCI_Error err) {
	fprintf(stderr,"HBCI_API_loadEnvironment: Caught error: %s\n",
		err.errorString().c_str());
	return new HBCI_Error(err);
    }
    catch (...) {
	fprintf(stderr, "HBCI_API_loadEnvironment: Caught unknown exception.\n");
	return new HBCI_Error("HBCI_API_loadEnvironment",
			      ERROR_LEVEL_CRITICAL,
			      0,
			      ERROR_ADVISE_ABORT,
			      "Caught unknown exception.", "");
    }
}
HBCI_Error *HBCI_API_saveEnvironment(const HBCI_API *h,
				     const char *filename)
{
    assert(h);
    try {
	return new HBCI_Error(h->saveEnvironment(string(filename ? filename : "")));
    }
    catch (HBCI_Error err) {
	fprintf(stderr,"HBCI_API_saveEnvironment: Caught error: %s\n",
		err.errorString().c_str());
	return new HBCI_Error(err);
    }
    catch (...) {
	fprintf(stderr, "HBCI_API_saveEnvironment: Caught unknown exception.\n");
	return new HBCI_Error("HBCI_API_saveEnvironment",
			      ERROR_LEVEL_CRITICAL,
			      0,
			      ERROR_ADVISE_ABORT,
			      "Caught unknown exception.", "");
    }
}
HBCI_Error *HBCI_API_addJob(HBCI_API *h, HBCI_OutboxJob *j)
{
    assert(h);
    try {
	return new HBCI_Error(h->addJob(j));
    }
    catch (HBCI_Error err) {
	fprintf(stderr,"HBCI_API_addJob: Caught error: %s\n",
		err.errorString().c_str());
	return new HBCI_Error(err);
    }
    catch (...) {
	fprintf(stderr, "HBCI_API_addJob: Caught unknown exception.\n");
	return new HBCI_Error("HBCI_API_addJob",
			      ERROR_LEVEL_CRITICAL,
			      0,
			      ERROR_ADVISE_ABORT,
			      "Caught unknown exception.", "");
    }
}
HBCI_Error *HBCI_API_executeQueue(HBCI_API *h, int changesAllowed)
{
    assert(h);
    try {
	return new HBCI_Error(h->executeQueue(changesAllowed));
    }
    catch (HBCI_Error err) {
	fprintf(stderr,"HBCI_API_executeQueue: Caught error: %s\n",
		err.errorString().c_str());
	return new HBCI_Error(err);
    }
    catch (...) {
	fprintf(stderr, "HBCI_API_executeQueue: Caught unknown exception.\n");
	return new HBCI_Error("HBCI_API_executeQueue",
			      ERROR_LEVEL_CRITICAL,
			      0,
			      ERROR_ADVISE_ABORT,
			      "Caught unknown exception.", "");
    }
}
void HBCI_API_clearQueueByResult(HBCI_API *h, OutboxJob_Result result)
{
    assert(h);
    h->clearQueueByResult(result);
}
void HBCI_API_clearQueueByStatus(HBCI_API *h, OutboxJob_Status status)
{
    assert(h);
    h->clearQueueByStatus(status);
}
void HBCI_API_removeQueuedJob(HBCI_API *h,
			      HBCI_OutboxJob *job)
{
    assert(h);
    try {
	HBCI::Pointer<HBCI::OutboxJob> job_p = job;
	job_p.setAutoDelete(false);
	h->removeQueuedJob(job_p);
    } 
    catch (HBCI_Error err) {
	fprintf(stderr,"HBCI_API_removeQueuedJob: Caught error: %s\n",
		err.errorString().c_str());
	return;
    }
    catch (...) {
	fprintf(stderr, "HBCI_API_removeQueuedJob: Caught unknown exception.\n");
	return;
    }
}
int HBCI_API_totalAccounts(const HBCI_API *h)
{
    assert(h);
    return h->totalAccounts();
}
int HBCI_API_totalUsers(const HBCI_API *h)
{
    assert(h);
    return h->totalUsers();
}
