/* readme.h
 */
#ifndef _README_H
#define _README_H

namespace osl
{
  /**
   * Moveを分類するクラス群.
   *
   * 標準インターフェース:
   * @code
   * template <Player P>
   * struct XXX
   * {
   *   template <class State>
   *   static bool isMember(const State& state, 
   *                        Ptype ptype,Position from,Position to)
   * };
   * @endcode
   * 
   * - P は Move.player() と一致
   * - ptype, from, to はそれぞれ Move の属性
   * - なぜMoveを直接渡さないかというと，move_generator の中から呼ぶ場合など
   *   ptype などに分解してあることを想定していたため．
   *
   * アダプタ: 標準インターフェースは使いにくいので，以下が用意されている．
   * - MoveAdaptor Player をtemplate引数で渡し，state と move を関数に渡す
   * - PlayerMoveAdaptor state と move だけを渡す
   * 
   * @code
   * if (! move_classifier::PlayerMoveAdaptor<move_classifier::PawnDropCheckmate>::isMember(state, move)) {
   *   // もしも打歩詰じゃなかったら...
   * }
   * @endcode
   */
  namespace move_classifier
  {
  }
}

#endif /* _README_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
