/* mobilityTable.t.cc
 */
#include "osl/mobility/mobilityTable.h"
#include "osl/record/csaString.h"
#include <iostream>

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class MobilityTableTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(MobilityTableTest);
  CPPUNIT_TEST(testCount);
  CPPUNIT_TEST_SUITE_END();
public:
  void testCount();
};

CPPUNIT_TEST_SUITE_REGISTRATION(MobilityTableTest);

using namespace osl;
using namespace osl::mobility;

void MobilityTableTest::testCount()
{
  {
    SimpleState sState=
      CsaString(
		"P1+NY+TO *  *  *  * -OU-KE-KY\n"
		"P2 *  *  *  *  * -GI-KI *  *\n"
		"P3 * +RY *  * +UM * -KI-FU-FU\n"
		"P4 *  * +FU-FU *  *  *  *  *\n"
		"P5 *  * -KE * +FU *  * +FU *\n"
		"P6+KE *  * +FU+GI-FU *  * +FU\n"
		"P7 *  * -UM *  *  *  *  *  *\n"
		"P8 *  *  *  *  *  *  *  *  * \n"
		"P9 * +OU * -GI *  *  *  * -NG\n"
		"P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
		"P-00KI00KY00FU00FU\n"
		"P-00AL\n"
		"+\n"
		).getInitialState();
    NumEffectState state(sState);
    MobilityTable mt(state);
    for(int num=32;num<=39;num++){
      if(state.getPieceOf(num).position()==Position(1,2)){
	// 11 KY
	CPPUNIT_ASSERT_EQUAL(Position::STAND(),mt.get(U,num));
	CPPUNIT_ASSERT_EQUAL(Position::STAND(),mt.get(L,num));
	CPPUNIT_ASSERT_EQUAL(Position::STAND(),mt.get(R,num));
	CPPUNIT_ASSERT_EQUAL(Position(1,3),mt.get(D,num));
      }
      else if(state.getPieceOf(num).position()==Position(9,1)){
	// 99 NY
	CPPUNIT_ASSERT_EQUAL(Position::STAND(),mt.get(U,num));
	CPPUNIT_ASSERT_EQUAL(Position::STAND(),mt.get(L,num));
	CPPUNIT_ASSERT_EQUAL(Position::STAND(),mt.get(R,num));
	CPPUNIT_ASSERT_EQUAL(Position::STAND(),mt.get(D,num));
      }
      else if(state.getPieceOf(num).position()==Position(5,3)){
	// 53 馬
	CPPUNIT_ASSERT_EQUAL(Position(7,1),mt.get(UL,num));
	CPPUNIT_ASSERT_EQUAL(Position(4,2),mt.get(UR,num));
	CPPUNIT_ASSERT_EQUAL(Position(6,4),mt.get(DL,num));
	CPPUNIT_ASSERT_EQUAL(Position(1,7),mt.get(DR,num));
      }
      else if(state.getPieceOf(num).position()==Position(7,7)){
	// 77 馬
	CPPUNIT_ASSERT_EQUAL(Position(9,5),mt.get(UL,num));
	CPPUNIT_ASSERT_EQUAL(Position(6,6),mt.get(UR,num));
	CPPUNIT_ASSERT_EQUAL(Position(9,9),mt.get(DL,num));
	CPPUNIT_ASSERT_EQUAL(Position(5,9),mt.get(DR,num));
      }
      else if(state.getPieceOf(num).position()==Position(8,3)){
	// 83 竜
	CPPUNIT_ASSERT_EQUAL(Position(8,1),mt.get(U,num));
	CPPUNIT_ASSERT_EQUAL(Position(9,3),mt.get(L,num));
	CPPUNIT_ASSERT_EQUAL(Position(5,3),mt.get(R,num));
	CPPUNIT_ASSERT_EQUAL(Position(8,9),mt.get(D,num));
      }
    }
  }
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
