/* ptypeOSquareVector.t.cc
 */
#include "osl/container/ptypeOSquareVector.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;

class PtypeOSquareVectorTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(PtypeOSquareVectorTest);
  CPPUNIT_TEST(testSort);
  CPPUNIT_TEST_SUITE_END();
 public:
  void testSort();
};

CPPUNIT_TEST_SUITE_REGISTRATION(PtypeOSquareVectorTest);

void PtypeOSquareVectorTest::testSort()
{
  Square dummy(1,1);
  {
    PtypeOSquareVector v;
    v.push_back(std::make_pair(newPtypeO(BLACK, PAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, PPAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, PAWN), dummy));
    v.sort();
    CPPUNIT_ASSERT_EQUAL(PPAWN, getPtype(v[2].first));
  }
  {
    PtypeOSquareVector v;
    v.push_back(std::make_pair(newPtypeO(BLACK, PPAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, PPAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, PAWN), dummy));
    v.push_back(std::make_pair(newPtypeO(BLACK, SILVER), dummy));
    v.sort();
    CPPUNIT_ASSERT_EQUAL(PAWN, getPtype(v[0].first));
    CPPUNIT_ASSERT_EQUAL(SILVER, getPtype(v[3].first));
  }
}


/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
