/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef PXMCHEM_FRAGOPT_H
#define PXMCHEM_FRAGOPT_H

#include "libpolyxmass-globals.h"
#include "pxmchem-fragspec.h"

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



typedef struct _PxmFragOpt PxmFragOpt;
  

struct _PxmFragOpt
{
  /* fragspec is a fragmentation specification in which the details of
     how the fragmentation in the polymer sequence is chemically
     performed.
  */
  PxmFragSpec *fragspec;

  /* What chemical entities pertaining to monomers should be stored in
     the oligomer? Default: PXMCHEMENT_MNM_NONE.
   */
  PxmMnmChement mnm_chement;

  /* What chemical entities pertaining to the polymer sequence should
     be stored in the oligomer? Default: PXMCHEMENT_PLM_NONE.
   */
  PxmPlmChement plm_chement;

  /* put_sequence indicates if the generated oligomers should have a
     property holding a copy of the parent polymer sequence
     corresponding to the oligomer.
  */
  gboolean put_sequence; 
};


PxmFragOpt *
pxmchem_fragopt_new (void);

gboolean
pxmchem_fragopt_set_default (PxmFragOpt *fragopt);

PxmFragOpt *
pxmchem_fragopt_dup (const PxmFragOpt *fragopt);

gboolean
pxmchem_fragopt_free  (PxmFragOpt *fragopt);


/* GPtrArray-RELATED FUNCTIONS
 */
gint
pxmchem_fragopt_GPA_free (GPtrArray *GPA);
  













#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* PXMCHEM_FRAGOPT_H */
