// -*- pike -*-
// #charset iso-8859-1
// ^- doesn't work in Pike0.6
constant cvs_version="$Id: imho.pike,v 1.247 2001/09/20 20:02:48 stewa Exp $";
constant imho_version="0.98.3";
/*
  
  IMHO - webmail module for Roxen
  
  Copyright  
  Stefan Wallstrm <stewa@lysator.liu.se>
  & Bosse Lincoln <lincoln@lysator.liu.se> 1998-2001
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
  
  See the file "LICENSE" for details.

  
  Contributions:

  LDAP support by 
    Mrten Svanfeldt 1999
  ESMTP DSN support by 
    Eric Doutreleau 1999
  Contributions from 
    Martin Bialasinski 1999
  Mail sorting by 
    Sten Eriksson <sten.eriksson@udac.se> 1999
  Multiserver support added by 
    Markus Mrtensson <mortis@acc.umu.se> 2000
    & Niklas Edumndsson <nikke@acc.umu.se> 2000
  HTML tag filtering by
    Karl Stevens <karl@maxim.ca> 2000
  Lots of extra features by
    Xavier Beaudouin <xbeaudouin@isdnet.net> 2000
  IMAP from LDAP by
    Lai Yiu Fai <ccyflai@ust.hk> 2000
  New mailbox listing style by
    Josh Walgenbach <jwalgenb@indiana.edu> 2000
  SMTP AUTH support, multiple from adresses and date format fixes by
    Jascha Franklin-Hodge <joeshmoe@joeshmoe.com> 2001
    

  RFCs:
  
  IMAP
  ============================================================
  2060 - INTERNET MESSAGE ACCESS PROTOCOL - VERSION 4rev1
  2088 - IMAP4 non-synchronizing literals
  2086 - IMAP4 ACL extension
  2193 - IMAP4 Mailbox Referrals
  2221 - IMAP4 Login Referrals
  2683 - IMAP4 Implementation Recommendations

  Mail & MIME
  ============================================================
  2045 - MIME Part One: Format of Internet Message Bodies 
  2045 - MIME Part Two: Media Types 
  2047 - MIME Part Three: Message Header Extensions for Non-ASCII Text
  2822 - Internet Message Format
  1641 - Using Unicode with MIME

  Misc
  ============================================================
  2070 - Internationalization of the Hypertext Markup Language
  2044 - UTF-8  
  2821 - Simple Mail Transfer Protocol (SMTP)
  2244 - ACAP -- Application Configuration Access Protocol
  2426 - vCard MIME Directory Profile
  2849 - The LDAP Data Interchange Format (LDIF) - Technical Specification

  RFCs can for example be found here: http://community.roxen.com/developers/idocs/rfc/
*/


#include <module.h>

inherit "module";
inherit "roxenlib";

constant thread_safe = 1;

#define IMHO_HOME "http://www.lysator.liu.se/~stewa/IMHO/"

#if ( ROXEN_MAJOR_VERSION == 2 && ROXEN_MINOR_VERSION >= 2 ) || ROXEN_MAJOR_VERSION > 2
#define __ROXEN_TWO_TWO__
#endif

#if ( ROXEN_MAJOR_VERSION == 2 && ROXEN_MINOR_VERSION >= 1 ) || ROXEN_MAJOR_VERSION > 2
#define __ROXEN_TWO_ONE__
#endif

#ifdef ROXEN_MAJOR_VERSION
#define __ROXEN_TWO_ZERO__
#endif

#ifdef __ROXEN_TWO_TWO__
#define perror werror
#endif

#if constant(FastIMHO) || constant(.FastIMHO)
#define HAVE_FASTIMHO
#endif

#if constant(.FastIMHO)
#define FastIMHO .FastIMHO
#endif

#define LOGINPROMPT -1
#define LOGINFAILED -2
#define LOGINFAILEDIMAP -3
#define INACTIVE -4

#define MAINMENU 3
#define LOGOUT 4
#define SETUP 5
#define COMPOSE 6
#define MAILINDEX 7
#define READMAIL 8
#define FOLDERLIST 9
#define FILES 10
#define DIALOGBOX 11
#define SPELLCHECK 12
#define ATTACHMENTS 13
#define ADDRESSBOOK 14
#define EDITADDRESS 15
#define IMPORTADDRESS 16
#define LDAPSEARCH 17
#define LDAPRESULT 18
#define ADMINMAIN 19
#define SEARCHMAIL 20

#define DATE_IDX      0
#define SUBJECT_IDX   1
#define FROM_IDX      2
#define SENDER_IDX    3
#define REPLAYTO_IDX  4
#define TO_IDX        5
#define CC_IDX        6
#define BCC_IDX       7
#define INREPLYTO_IDX 8
#define MESSAGEID_IDX 9

#define MB_NOSELECT 1
#define MB_NOINFERIORS 2
#define MB_IMPLICIT_FOLDER 4
#define MB_PREVIOUS_FOLDER 8
// ({ foldername, displayname, flags, separator, displayname/separator })
#define MB_FOLDERNAME_IDX 0
#define MB_DISPLAYNAME_IDX 1
#define MB_FLAGS_IDX 2
#define MB_SEPARATOR_IDX 3
#define MB_HIERARCHY_IDX 4

#ifdef __ROXEN_TWO_ZERO__
#define MULTILANG(ENG,SWE) (["standard":ENG,"svenska":SWE])
#else
#define MULTILANG(ENG,SWE) ENG
#endif

#ifndef VAR_INITIAL
#define VAR_INITIAL 0
#endif

#define TO_UNICODE(s) (Locale.Charset.decoder(session->charset)->feed(s)->drain())
#define TO_UTF8(s) (Locale.Charset.encoder("UTF-8")->feed(s)->drain())
#define FROM_UTF8(s) (Locale.Charset.decoder("UTF-8")->feed(s)->drain())

#define MSG(m) msg(session,m,0)
#define MSGA(m,a) msg(session,m,a)
string msg(object session,int m,array a);
mixed lang_progs = ([ "english":0 ]);
mixed lang_progs_short = ([ "en":"english" ]);
mapping lang_charsets = ([ "english": "iso-8859-1" ]);
mapping lang_replacement_strings = (["english":"" ]);
int langs_loaded = 0;
string global_addressbook = "";
string adminpasswd;

// BEGIN MESSAGES
// Messages
//

//login
#define M_LOGIN 1
#define M_PASSWORD 2
#define M_NOLOGIN 3
#define M_IMAPERROR 10
#define M_SMTPERROR 11
#define M_SAVEDUSERINTERFACE 12
#define M_USERINTERFACE 13
#define M_LOGIN_OK 14

// page header
#define M_NEWMAIL 50
#define M_MAILBOX 51
#define M_MAILBOXES 52
#define M_FILES 53
#define M_PREFS 54
#define M_LOGOUT 55
#define M_CURRMAILBOX 56
#define M_CHECKACTIVEMAILBOXES 57

// compose
#define M_SEND 100
#define M_CANCELSEND 101
#define M_SENDMOREFILES 102
#define M_COMPOSEMAIL 103
#define M_SPELLCHECK 104
#define M_DONTSAVEMAIL 105
#define M_ADDFILEASATTACHMENT 106
#define M_NOATTACHMENTS 107
#define M_ADDATTACHMENT 108
#define M_REMOVEMARKEDATTACHMENTS 109
#define M_UPLOADATTACHMENT 110
#define M_ADDMARKEDTOATTACHMENTS 111
#define M_UPLOADTOATTACHMENTS 112
#define M_BACKTOCOMPOSE 113
#define M_NOATTACHFILES 114
#define M_ATTACHMENTSHEADER 115
#define M_SENDSAVEFAILED 116
#define M_SENDNORECV 117
#define M_DSN_DELAY 118
#define M_DSN_SUCCESS 119
#define M_SAVEDRAFT 120
#define M_SAVEDRAFTINSESSION 121
#define M_COMPOSEDRAFT 122
#define M_DRAFTEXISTS 123
#define M_OVERWRITEDRAFT 124
#define M_DISCARDDRAFT 125
#define M_SENDBROKENADDR 126
#define M_SAVEMAILCOPY 127

// mailindex
#define M_DELETEMARKED 200
#define M_MOVEMARKED 201
#define M_SELECTMBOX 202
#define M_CHECKNEWMAIL 203
#define M_MAILSHOWN 204
#define M_BACKN 205
#define M_FORWARDN 206
#define M_NUMBER 207
#define M_DELETEMARKEDP 208
#define M_DELETEMARKEDNONE 209
#define M_CHANGESORTORDER 210
#define M_MOVETOTRASH 211
#define M_DELETEALLTRASH 212
#define M_NOMAILS 213
#define M_MARKALL 214
#define M_PAGEGO 215

// mailboxlist
#define M_MBOXNAME 300
#define M_DELETEMARKEDMBOX 301
#define M_CREATEMBOX 302
#define M_NEWMBOXNAME 303
#define M_MBOXREMOVEP 350
#define M_MBOXMARKONE 351
#define M_NEWMBOXNONAME 352
#define M_CREATEMBOXERROR 353
#define M_INBOX 354
#define M_PREVIOUS_LEVEL 355
#define M_FOLDER_PATH 356
#define M_BOXTRASH 357
#define M_BOXSENTMAIL 358
#define M_USEMARKEDINMENULIST 359
#define M_CHANGEINBOXESMSG 360

// files
#define M_FILENAME 400
#define M_SIZE 401
#define M_MIMETYPE 402
#define M_DELETEMARKEDFILES 403
#define M_UPLOAD 404
#define M_AVAILSPACE 405
#define M_WINDOWSBUG 406
#define M_NOFILES 407

// preferences
#define M_PNAME 500
#define M_PMAILADDRESS 501
#define M_PMAILPATH 502
#define M_PINCLUDEMAIL 503
#define M_PQUOTEPREFIX 504
#define M_PSIGNATURE 505
#define M_PINACTIVELOGOUT 506
#define M_PSAVEANDUSE 550
#define M_PVISIBLEMESSAGES 507
#define M_PSORTORDER 508
#define M_PSORTORDERS 509
#define M_PTRASHFOLDER 510
#define M_PSENTFOLDER 511
#define M_PDEFAULTBCC 512
#define M_PSAVEATTACHMENTS 513
#define M_PLANGUAGE 514
#define M_PUSERINTERFACE 515
#define M_PINBOXES 516
#define M_PCOMMASEPARATED 517
#define M_PHEADER 518
#define M_PHEADERDESC 519
#define M_PSORTCOLUMN 520
#define M_PSHOWHTML 521
#define M_PSHOWHIDDENHEADERS 522
#define M_PMAILADDRESSDESC 580
#define M_PPROCMAIL 596
#define M_PPROCMAILDESC 597
#define M_PFORWARDING 598
#define M_PFORWARDINGDESC 599

// logout
#define M_LOGOUTMSG 600
#define M_LOGGEDOUT 601

// dialog
#define M_QUESTION 700
#define M_INFO 701

// readmail
#define M_REPLY 800
#define M_READPREV 801
#define M_READNEXT 802
#define M_ATTACHMENTLINK 803
#define M_MAILMISSING 804
#define M_MAILMISSINGBACK 805
#define M_DELETE 806
#define M_FORWARD 807
#define M_MAIL 808
#define M_SHOWFULLHEADERS 809
#define M_HIDEFULLHEADERS 810
#define M_MAILTOOBIG 811
#define M_REPLYTOALL 812
#define M_MOVETHISTOTRASH 813
#define M_CHARSETWARNING 814

//spellcheck
#define M_SPELLDONE 900
#define M_SPELLPREV 901
#define M_SPELLNEXT 902
#define M_SPELLCHANGETO 903
#define M_SPELLSUGGESTIONS 904
#define M_NOSPELLINGERRORS 905

// mailheaders
#define M_FROM 1000
#define M_TO 1001
#define M_CC 1002
#define M_BCC 1003
#define M_SUBJECT 1004
#define M_ATTACHMENTS 1005
#define M_TIME 1006
#define M_DATE 1007

// table heads
#define M_MARKFLAG 1100
#define M_NEWFLAG 1101
#define M_ANSWEREDFLAG 1102

// address book
#define M_ADDRESSBOOKTITLE 1200
#define M_ADDRESSBOOK 1201
#define M_INDEXNAMERECIPIENT 1202
#define M_INDEXNAMEEDIT 1203
#define M_ADDRESS 1204
#define M_NOADDRESSES 1205
#define M_NEWADDRESS 1206
#define M_EDITADDRESS 1207
#define M_ADDADDRESS 1208
#define M_INDEXNAME 1209
#define M_ADDRESSFORMAT 1210
#define M_SAVEADDRESS 1211
#define M_DELETEADDRESS 1212
#define M_CANCELADDRESS 1213
#define M_CANNOTIMPORT 1214
#define M_IMPORTADDRESSBOOKTITLE 1215
#define M_UPLOADADDRESSBOOK 1216
#define M_PINELOCATION 1217
#define M_UPLOADANDIMPORT 1218
#define M_IMPORTADDRESSBOOK 1219
#define M_GLOBALADDRESSES 1220
#define M_INSERTMARKEDADDRESSES 1221
#define M_DELETEMARKEDADDRESSES 1222

//ldap support
#define M_LDAPTITLE 1300
#define M_LDAP 1301
#define M_SEARCHLDAP 1302
#define M_NAMECONT 1303
#define M_OU 1304

//mail notification
#define M_MAILNOTIFYWINDOW 1400
#define M_GETNEWMAIL 1401

//search mail
#define M_SEARCHMAILTITLE 1500
#define M_SEARCHMAIL 1501
#define M_SEARCHMAILBOX 1502
#define M_SEARCHANYWHERE 1503
#define M_SEARCHFROMFIELD 1504
#define M_SEARCHTOFIELD 1505
#define M_SEARCHSUBJECT 1506
#define M_SEARCHBODY 1507
#define M_SEARCHAND 1508
#define M_SEARCHSHOWINGMAIL 1509

//misc
#define M_YES 2000
#define M_NO 2001
#define M_DIALOGOK 2002
#define M_DIALOGCANCEL 2003

// END MESSAGES

constant screennames = ([ LOGINPROMPT : ({ "login", -1 }), 
			 LOGINFAILED : ({ "login", -1 }), 
			INACTIVE : ({ "inactive", -1 }), 
			LOGINFAILEDIMAP : ({ "login", -1 }), 
			LOGOUT : ({ "logout", M_LOGGEDOUT }), 
			SETUP : ({ "setup", M_PREFS }), 
			COMPOSE : ({ "compose", M_COMPOSEMAIL }),
			MAILINDEX : ({ "mailindex", M_CURRMAILBOX }),
			READMAIL : ({ "readmail", M_MAIL }),
			FOLDERLIST : ({ "folderlist", M_MAILBOXES }),
			FILES : ({ "files", M_FILES }),
			DIALOGBOX : ({ "dialogbox", M_INFO }),
			SPELLCHECK : ({ "spellcheck", M_SPELLCHECK }),
			ATTACHMENTS : ({ "attachments", M_ATTACHMENTSHEADER }),
			ADDRESSBOOK : ({ "addressbook", M_ADDRESSBOOKTITLE }),
			EDITADDRESS : ({ "editaddress", M_ADDRESSBOOKTITLE }),
			IMPORTADDRESS : ({ "importaddress", M_ADDRESSBOOKTITLE }),
			LDAPSEARCH : ({ "ldapsearch", M_LDAPTITLE}),
			LDAPRESULT : ({ "ldapresult", M_LDAPTITLE}),
			SEARCHMAIL : ({ "searchmail", M_SEARCHMAILTITLE}) ]);

// BEGIN DEFAULTLAYOUT
#define DEFAULTLAYOUT \
"<html>\n" \
"<head><title><imho_banner /></title>\n" \
"\n" \
"<if supports=\"stylesheets\">\n" \
"<style type=\"text/css\">\n" \
"body {font: 10pt arial, helvetica; color: black; background-color: #dde1f0}\n" \
"\n" \
"p {font: 10pt arial, helvetica}\n" \
"b {font-weight: bold}\n" \
"\n" \
"h1 {font: 22pt arial, helvetica}\n" \
"h2 {font: 18pt arial, helvetica}\n" \
"h3 {font: 14pt arial, helvetica}\n" \
"h4 {font: 10pt arial, helvetica}\n" \
"\n" \
"th {font: 13pt arial, helvetica; color: black; font-weight: bold; line-height: 110% }\n" \
"td {font: 10pt arial, helvetica; color: black}\n" \
"\n" \
"a {font: 10pt arial, helvetica; text-decoration: underline}\n" \
"a.mailbox {font: 10pt arial, helvetica; text-decoration: none}\n" \
"a:link {color: black}\n" \
"a:visited {color: black}\n" \
"a:active {color: black}\n" \
"\n" \
"input {font: 10pt arial, helvetica; text-decoration: none}\n" \
"textarea {font: 10pt courier; text-decoration: none}\n" \
"</style>\n" \
"</if>\n" \
"\n" \
"<if not defined=\"imhostate is login\">\n" \
" <if defined=\"imhostate is in\">\n" \
"\n" \
"  <if supports=\"frames\">\n" \
"   <if defined=\"imhoframe is idlemailnotify\"> \n" \
"    <comment>Mail Notify Window</comment>\n" \
"    </head>\n" \
"    <comment>Add a refresh timeout for mail notification</comment>\n" \
"    <cset preparse=\"\" scope=\"var\" variable=\"url\"><imho_url href=\"checkactivemailboxes\" /></cset>\n" \
"    <if match=\"&roxen.version; is Roxen*\">\n" \
"    <script>\n" \
"      window.setTimeout('window.location=\"&var.url;\";',300000);\n" \
"    </script>\n" \
"    </if>\n" \
"    <else>\n" \
"    <formoutput quote=\"$\">\n" \
"    <script>\n" \
"      window.setTimeout('window.location=\"$url$\";',300000);\n" \
"    </script>\n" \
"    </formoutput>\n" \
"    </else>\n" \
"    <if not defined=\"imhonewmail is 0\"><comment>No new mail</comment>\n" \
"     <body>\n" \
"     <center>\n" \
"     <table border=\"0\"><tr><td bgcolor=\"#000070\">\n" \
"      <imho_image image=\"newmail\" quant=\"250\" insideenvcolor=\"#202020\" bg=\"#000070\" scale=\"0.5\" /><br />\n" \
"     </td></tr>\n" \
"     <if supports=\"javascript\">\n" \
"      <script>\n" \
"      function openWin(url,name) {\n" \
"       window.open(url, name);\n" \
"      }\n" \
"      </script>\n" \
"      <cset preparse=\"\" scope=\"var\" variable=\"url\"><imho_url target=\"_top\" href=\"reloadactivemailboxes\" /></cset>\n" \
"      <if match=\"&roxen.version; is Roxen*\">\n" \
"      <tr><td><a href=\"javascript:openWin('&var.url;','IMHO')\" /><imho_string no=\"1401\" /></a></td></tr>\n" \
"      </if>\n" \
"      <else>\n" \
"      <formoutput quote=\"$\">\n" \
"      <tr><td><a href=\"javascript:openWin('$url$','IMHO')\" /><imho_string no=\"1401\" /></a></td></tr>\n" \
"      </formoutput>\n" \
"      </else>\n" \
"     </if>\n" \
"     </table>\n" \
"     </center>\n" \
"     </body>\n" \
"    </if>\n" \
"    <else>\n" \
"     <body>\n" \
"     <center>\n" \
"     <table bgcolor=\"#000070\" border=\"0\"><tr><td>\n" \
"      <imho_image image=\"nonewmail\" quant=\"250\" insideenvcolor=\"#202020\" bg=\"#000070\" scale=\"0.5\" />\n" \
"     </td></tr></table>\n" \
"     </center>\n" \
"     </body>\n" \
"    </else>\n" \
"   </if> <comment>End Mail Notify Window</comment>\n" \
"\n" \
"   <else>\n" \
"    <if defined=\"imhoframe is _top\">\n" \
"     <frameset rows=\"50,*\" frameborder=\"no\" border=\"0\" framespacing=\"0\">\n" \
"      <imho_frame scrolling=\"no\" name=\"banner\" />\n" \
"      <imho_frame scrolling=\"no\" name=\"notbanner\" />\n" \
"     </frameset>\n" \
"     </head>\n" \
"    </if> <comment>End Top frame</comment>\n" \
"\n" \
"    <else>\n" \
"     <if defined=\"imhoframe is notbanner\">\n" \
"      <frameset cols=\"153,*\" frameborder=\"no\" border=\"0\" framespacing=\"0\">\n" \
"       <imho_frame scrolling=\"no\" name=\"head\" />\n" \
"       <imho_frame scrolling=\"auto\" name=\"mail\" />\n" \
"      </frameset>\n" \
"      </head>\n" \
"     </if><comment>End Notbanner frame</comment>\n" \
"\n" \
"     <else>\n" \
"      <if defined=\"imhoframe is banner\">\n" \
"       </head>\n" \
"       <body text=\"black\" bgcolor=\"#dde1f0\" link=\"black\" vlink=\"black\" alink=\"black\">\n" \
"       <cset preparse=\"\" scope=\"var\" variable=\"banner\"><imho_banner /></cset>\n" \
"       <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td valign=\"top\">\n" \
"       <if match=\"&roxen.version; is Roxen*\">\n" \
"        <imho_image image=\"bannerleft\" text=\"&var.banner;\" quant=\"250\" clouds=\"white\" fg=\"white\" bg=\"#000070\" align=\"left\" border=\"0\" hspace=\"0\" />\n" \
"       </if>\n" \
"       <else>\n" \
"       <formoutput quote=\"$\">\n" \
"        <imho_image image=\"bannerleft\" text=\"$banner$\" quant=\"250\" clouds=\"white\" fg=\"white\" bg=\"#000070\" align=\"left\" border=\"0\" hspace=\"0\" />\n" \
"       </formoutput>\n" \
"       </else>\n" \
"       </td><td width=\"100%\" valign=\"top\">\n" \
"       <imho_image image=\"bannerright\" bg=\"#000070\" width=\"100%\" border=\"0\" hspace=\"0\" />\n" \
"       </td></tr></table>\n" \
"       </body>\n" \
"      </if><comment>End banner frame</comment>\n" \
"\n" \
"      <else>\n" \
"       <if defined=\"imhoframe is mail\">\n" \
"        <if defined=\"imhoscreen is readmail\">\n" \
"         <frameset rows=\"40%,*\" frameborder=\"yes\" border=\"2\" framespacing=\"0\">\n" \
"          <imho_frame scrolling=\"auto\" name=\"list\" />\n" \
"          <imho_frame scrolling=\"auto\" name=\"main\" />\n" \
"         </frameset>\n" \
"        </if><comment>End of mail readmail frame set (only used when\n" \
"                      imhoscreen is readmail</comment>\n" \
"\n" \
"        <else><comment>The main IMHO output if this frame is not split\n" \
"                       in \"list\" and \"main\"</comment>\n" \
"         </head>\n" \
"         <body bgcolor=\"#dde1f0\" text=\"black\" link=\"black\" vlink=\"black\" alink=\"black\">\n" \
"         <if defined=\"imhoscreen is mailindex\">\n" \
"          <h3><imho_mailbox />:</h3>\n" \
"         </if>\n" \
"         <imho_main nogtext=\"\" tdbgcolor=\"#f5f7ff\" thbgcolor=\"#000070\" thcolor=\"white\" checkcolor=\"black\" checksize=\"14\" arrowsize=\"14\" target=\"mail\" notopbuttons=\"\" columns=\"num,mark,new,answered,date,fromto,subject,size\" />\n" \
"         </body>\n" \
"        </else><comment>End IMHO main output</comment>\n" \
"       </if><comment>End mail frame</comment>\n" \
" \n" \
"       <else><comment>Frame is one of the output frames \"list\", \"mail\", \n" \
"                      \"head\"</comment>\n" \
"        </head>\n" \
"        <body bgcolor=\"#dde1f0\" text=\"black\" link=\"black\" vlink=\"black\" alink=\"black\">\n" \
"\n" \
"        <if defined=\"imhoframe is head\"><comment>Buttons etc</comment>\n" \
"         <imho_name /><br /><hr />\n" \
"         <table width=\"100%\" border=\"2\" cellspacing=\"0\" cellpadding=\"3\">\n" \
"         <imho_buttonoutput target=\"mail\" quote=\"$\" noupdate=\"\">\n" \
"           <tr><td bgcolor=#000070 align=\"center\">\n" \
"           <a href=\"$button-url$\" target=\"$button-target$\" style=\"text-decoration: none\"><font color=white>$button-text$</font></a>\n" \
"           </td></tr>\n" \
"         </imho_buttonoutput>\n" \
"         </table>\n" \
"         <br />\n" \
"         <table width=\"100%\" border=\"2\" cellspacing=\"0\" cellpadding=\"3\">\n" \
"         <imho_buttonoutput buttons=\"inboxes\" target=\"mail\" quote=\"$\" noupdate=\"\">\n" \
"           <tr><td bgcolor=\"#9099b4\" align=\"center\">\n" \
"           <a href=\"$button-url$\" target=\"$button-target$\" style=\"text-decoration: none\"><font color=\"white\">$button-text$</font></a>\n" \
"           </td></tr>\n" \
"         </imho_buttonoutput>\n" \
"	 <if supports=\"javascript\"><if defined=\"imhomailnotify is yes\">\n" \
"          <tr><td bgcolor=\"#000070\" align=\"center\"><font color=\"white\">\n" \
"           <cset preparse=\"\" scope=\"var\" variable=\"url\"><imho_url target=\"idlemailnotify\" href=\"checkactivemailboxes\" /></cset>\n" \
"	   <script>\n" \
"           function openWin(url,name,opts) {\n" \
"             window.open(url, name, opts);\n" \
"	   }\n" \
"	   </script>\n" \
"           <if match=\"&roxen.version; is Roxen*\">\n" \
"           <a style=\"text-decoration: none\" href=\"javascript:openWin('&var.url;','Notify','toolbar=no,directories=no,location=no,status=no,menubar=no,scrollbars=no,resizable=no,copyhistory=no,width=100,height=100');\"><font color=\"white\"><imho_string no=\"1400\" /></font></a>\n" \
"           </if>\n" \
"           <else>\n" \
"           <formoutput quote=\"$\">\n" \
"           <a style=\"text-decoration: none\" href=\"javascript:openWin('$url$','Notify','toolbar=no,directories=no,location=no,status=no,menubar=no,scrollbars=no,resizable=no,copyhistory=no,width=100,height=100');\"><font color=\"white\"><imho_string no=\"1400\" /></font></a>\n" \
"           </formoutput>\n" \
"           </else>\n" \
"	   </font>\n" \
"          </td></tr>\n" \
"	 </if></if>\n" \
"         <tr><td bgcolor=\"#000070\" align=\"center\">\n" \
"         <imho_a href=\"reloadactivemailboxes\" target=\"mail\" style=\"text-decoration: none\"><font color=\"white\"><imho_string no=\"203\" /></font></a>\n" \
"         </td></tr>\n" \
"         </table>\n" \
"         <br />\n" \
"         <imho_about />\n" \
"        </if><comment>End head frame (buttons etc)</comment>\n" \
"\n" \
"        <else>\n" \
" \n" \
"         <if defined=\"imhoframe is list\">\n" \
"          <h3><imho_mailbox />:</h3>\n" \
"          <imho_mailindex nogtext=\"\" tdbgcolor=\"#f5f7ff\" thbgcolor=\"#000070\" thcolor=\"white\" checkcolor=\"black\" checksize=\"14\" arrowsize=\"14\" uptarget=\"mail\" sidetarget=\"main\" notopbuttons=\"\" columns=\"num,mark,new,answered,date,fromto,subject,size\" />\n" \
"         </if><comment>End list frame</comment>\n" \
"\n" \
"         <else><comment>Finally! If no other frame, output imho_main</comment>\n" \
"          <imho_main nogtext=\"\" tdbgcolor=\"#f5f7ff\" thbgcolor=\"#000070\" thcolor=\"white\" checkcolor=\"black\" checksize=\"14\" arrowsize=\"14\" target=\"mail\" nobackbutton=\"\" />\n" \
"         </else>\n" \
"        </else><comment>End list or main frames</comment>\n" \
"        </body>\n" \
"       </else><comment>End output frames</comment>\n" \
"      </else><comment>End not banner frame</comment>\n" \
"     </else><comment>End not banner frameset</comment>\n" \
"    </else><comment>End not top frame</comment>\n" \
"   </else><comment>End not mail notify window</comment>\n" \
"  </if>\n" \
"\n" \
"  <else><comment>No frames</comment>\n" \
"   </head>\n" \
"   <body text=\"black\" bgcolor=\"#dde1f0\" link=\"black\" vlink=\"black\" alink=\"black\">\n" \
"   <cset preparse=\"\" scope=\"var\" variable=\"banner\"><imho_banner /></cset>\n" \
"   <table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td valign=\"top\">\n" \
"   <if match=\"&roxen.version; is Roxen*\">\n" \
"   <imho_image image=\"bannerleft\" text=\"&var.banner;\" quant=\"250\" clouds=\"white\" fg=\"white\" bg=\"#000070\" align=\"left\" border=\"0\" hspace=\"0\" />\n" \
"   </if>\n" \
"   <else>\n" \
"   <formoutput quote=\"$\">\n" \
"   <imho_image image=\"bannerleft\" text=\"$banner$\" quant=\"250\" clouds=\"white\" fg=\"white\" bg=\"#000070\" align=\"left\" border=\"0\" hspace=\"0\" /></formoutput>\n" \
"   </else>\n" \
"   </td><td width=\"100%\" valign=\"top\">\n" \
"   <imho_image image=\"bannerright\" bg=\"#000070\" width=\"100%\" border=\"0\" hspace=\"0\" />\n" \
"   </td></tr></table>\n" \
"\n" \
"   <table width=\"100%\" nowrap=\"nowrap\" cellpadding=\"2\" cellspacing=\"2\"><tr>\n" \
"    <td bgcolor=\"#9099b4\">\n" \
"     <table width=\"100%\"><tr><td>\n" \
"      <table border=\"1\" cellpadding=\"5\" cellspacing=\"2\"><tr>\n" \
"       <imho_buttonoutput quote=\"$\">\n" \
"         <td bgcolor=#000070 align=\"center\">\n" \
"         <a href=\"$button-url$\" target=\"$button-target$\" style=\"text-decoration: none\"><font color=white>$button-text$</font></a>\n" \
"         </td>\n" \
"       </imho_buttonoutput>\n" \
"       </tr></table>\n" \
"     </td></tr></table>\n" \
"    </td>\n" \
"    <td bgcolor=\"#000070\" align=\"center\">\n" \
"      <font color=\"#ffffff\"><imho_name /> : <imho_title /></font>\n" \
"    </td>\n" \
"   </tr></table>\n" \
"\n" \
"   <imho_main nogtext=\"\" tdbgcolor=\"#f5f7ff\" thbgcolor=\"#000070\" thcolor=\"white\" checkcolor=\"black\" checksize=\"14\" arrowsize=\"14\" columns=\"num,mark,new,answered,date,fromto,subject,size\" />\n" \
"   <hr /><imho_about />\n" \
"   </body>\n" \
"\n" \
"  </else>\n" \
"\n" \
" </if>\n" \
"\n" \
" <else> <comment>Logged out</comment>\n" \
"  </head>\n" \
"  <if supports=\"javascript\">\n" \
"  <script>\n" \
"    if (window.name == \"Notify\") {\n" \
"      window.close() \n" \
"    }\n" \
"  </script>\n" \
"  </if>\n" \
"  <body bgcolor=\"#dde1f0\" text=\"black\" link=\"black\" vlink=\"black\" alink=\"black\">\n" \
"  <cset preparse=\"\" scope=\"var\" variable=\"banner\"><imho_banner /></cset>\n" \
"  <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td valign=\"top\">\n" \
"  <if match=\"&roxen.version; is Roxen*\">\n" \
"  <imho_image image=\"bannerleft\" text=\"&var.banner;\" quant=\"250\" clouds=\"white\" fg=\"white\" bg=\"#000070\" align=\"left\" border=\"0\" hspace=\"0\" /></formoutput>\n" \
"  </td><td width=\"100%\" valign=\"top\">\n" \
"  <imho_image image=\"bannerright\" bg=\"#000070\" width=\"100%\" border=\"0\" hspace=\"0\" />\n" \
"  </if>\n" \
"  <else>\n" \
"  <formoutput quote=\"$\">\n" \
"  <imho_image image=\"bannerleft\" text=\"$banner$\" quant=\"250\" clouds=\"white\" fg=\"white\" bg=\"#000070\" align=\"left\" border=\"0\" hspace=\"0\" /></formoutput>\n" \
"  </td><td width=\"100%\" valign=\"top\">\n" \
"  <imho_image image=\"bannerright\" bg=\"#000070\" width=\"100%\" border=\"0\" hspace=\"0\" />\n" \
"  </else>\n" \
"  </td><tr></table>\n" \
"  <imho_main />\n" \
"  <hr /><imho_about />\n" \
"  </body>\n" \
" </else>\n" \
"</if>\n" \
"\n" \
"<else> <comment>Login screen</comment>\n" \
" </head>\n" \
" <killframe />\n" \
" <if supports=\"javascript\">\n" \
"  <script>\n" \
"    if (window.name == \"Notify\") {\n" \
"      window.close() \n" \
"    }\n" \
"  </script>\n" \
" </if>\n" \
" <body bgcolor=\"#dde1f0\" text=\"black\" link=\"black\" vlink=\"black\" alink=\"black\">\n" \
" <cset preparse=\"\" scope=\"var\" variable=\"banner\"><imho_banner /></cset>\n" \
" <table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr><td valign=\"top\">\n" \
" <if match=\"&roxen.version; is Roxen*\">\n" \
" <imho_image image=\"bannerleft\" text=\"&var.banner;\" quant=\"250\" clouds=\"white\" fg=\"white\" bg=\"#000070\" align=\"left\" border=\"0\" hspace=\"0\" />\n" \
" </if>\n" \
" <else>\n" \
" <formoutput quote=\"$\">\n" \
" <imho_image image=\"bannerleft\" text=\"$banner$\" quant=\"250\" clouds=\"white\" fg=\"white\" bg=\"#000070\" align=\"left\" border=\"0\" hspace=\"0\" />\n" \
" </formoutput>\n" \
" </else>\n" \
" </td><td width=\"100%\" valign=\"top\">\n" \
" <imho_image image=\"bannerright\" bg=\"#000070\" width=\"100%\" border=\"0\" hspace=\"0\" />\n" \
" </td></tr></table>\n" \
" <center>\n" \
"   <br /><h2><imho_banner /></h2>\n" \
"   <imho_main nogtext=\"\" />\n" \
" </center>\n" \
"  <hr /><imho_about />\n" \
" </body>\n" \
"</else>\n" \
"\n" \
"</html>\n" \
"\n"
// END DEFAULTLAYOUT


// These properties are saved and loaded for each user. To add a new, change
// here and in the SETUP menu. Also make sure there is a corresponding member
// in the _Session class.
mapping prefproperties=([ "name" : "", 
			"address" : "",
			"mailpath" : "", 
			"replymsgprefix" : "> ",
			"replyincludemsg" : "yes",
			"extraheader" : "",
			"signature" : "",
			"autologout" : "20",
			"visiblemail" : "20",
			"sortorder" : "forward",
			"sortcolumn" : "num",
			"trashfolder" : "Trash",
			"sentfolder" : "sent-mail",
			"autobcc" : "",
			"saveattachments" : "no", 
			"language" : "",
			"addressbook" : "",
			"layout" : "0", 
			"showhiddenheaders" : "yes",
			"activemailboxes" : "INBOX",
			"draftmail" : "",
			"showhtml" : "yes" ]);

mapping sessions=([ ]);
mapping stats = ([ ]);

#ifdef THREADS
// Lock for sessions
object global_lock = Thread.Mutex();
// Lock for logfile
object log_lock = Thread.Mutex();
#endif


#define FEAT_USERSETUP 0
#define FEAT_ADDRESSBOOK 1
#define FEAT_MAILBOXES 2
#define FEAT_USERMAILPATH 3
#define FEAT_ATTACHMENTS 4
#define FEAT_INBOXES 5
#define FEAT_USERADDRESS 6
#define FEAT_LDAP 7
#define FEAT_DSN 8
#define FEAT_FASTIMHO 9
#define FEAT_USEREDITSETUP 10
#define FEAT_EDITADDRESSBOOK 11
#define FEAT_USERHEADERS 12
#define FEAT_SAVEDRAFTONDISK 13
#define FEAT_MAILNOTIFY 14
#define FEAT_SHOWHTML 15
#define FEAT_USERLANGUAGE 16
#define FEAT_USERTRASHFOLDER 17
#define FEAT_USERSENTFOLDER 18
#define FEAT_USERSENTSAVEATTACHMENTS 19
#define FEAT_USERSPECIFYINBOXES 20
#define FEAT_SAVEMAILCOPY 21
#define FEAT_USERBCCCOPY 22
#define FEAT_USERCANCHANGENAME 23
#define FEAT_USERSETREPLYPREFIX 24
#define FEAT_USERSETUPSHOWHIDDENHEADERS 25

int feature(int f) {
  switch(f) {
  case FEAT_USERHEADERS:
    return (query("userheaders")=="yes" && feature(FEAT_USERSETUP));
    break;
  case FEAT_ADDRESSBOOK:
    return (query("addressbook")=="yes") && feature(FEAT_USERSETUP);
    break;
  case FEAT_EDITADDRESSBOOK:
    return (query("addressbook")=="yes") && feature(FEAT_USEREDITSETUP);
    break;
  case FEAT_USERSETUP:
    return (query("usersetup")=="yes") && !((query("mailboxes")=="no") &&
					    !sizeof(query("prefsdir")));
    break;
  case FEAT_USEREDITSETUP:
    return (query("usersetup")=="yes") && (query("usereditsetup")=="yes") &&
      !((query("mailboxes")=="no") && !sizeof(query("prefsdir")));
    break;
  case FEAT_MAILBOXES:
    return (query("mailboxes")=="yes");
    break;
  case FEAT_USERMAILPATH:
    return (query("usermailpath")=="yes") && feature(FEAT_USERSETUP);
    break;
  case FEAT_ATTACHMENTS:
    return query("attachments")=="yes";
    break;
  case FEAT_INBOXES:
    return query("inboxes")=="yes";
  case FEAT_USERADDRESS:
    return (query("useraddress")=="yes") && feature(FEAT_USERSETUP);
  case FEAT_LDAP:
#if constant(Protocols.LDAP)
    return (query("ldap")=="yes");
#else
    return 0;
#endif
  case FEAT_DSN:
     return query("dsn")=="yes";
  case FEAT_FASTIMHO:
#ifdef HAVE_FASTIMHO
    return query("fastimho")=="yes";
#else
    return 0;
#endif
  case FEAT_SAVEDRAFTONDISK:
    return (feature(FEAT_USEREDITSETUP));
  case FEAT_MAILNOTIFY:
    return (query("mailnotify")=="yes");
  case FEAT_SHOWHTML:
    return (query("showhtml")=="yes");
  case FEAT_USERLANGUAGE:
    return (query("userlanguage")=="yes") && feature(FEAT_USERSETUP);
  case FEAT_USERTRASHFOLDER:
    return (query("usertrashfolder")=="yes") && feature(FEAT_USERSETUP);
  case FEAT_USERSENTFOLDER:
    return (query("usersentfolder")=="yes") && feature(FEAT_USERSETUP);
  case FEAT_USERSENTSAVEATTACHMENTS:
    return (query("usersentsaveattachments")== "yes") && feature(FEAT_USERSENTFOLDER) &&
      feature(FEAT_USERSETUP);
  case FEAT_USERSPECIFYINBOXES:
    return (query("userspecifyinboxes")=="yes") && feature(FEAT_USERSETUP);
  case FEAT_USERBCCCOPY:
    return (query("userbcccopy")=="yes") && feature(FEAT_USERSETUP);
  case FEAT_USERCANCHANGENAME:
    return (query("usercanchangename")=="yes") && feature(FEAT_USERSETUP);
  case FEAT_SAVEMAILCOPY:
    return (query("composesavemail")=="yes");
  case FEAT_USERSETREPLYPREFIX:
    return (query("chgreplymsgprefix")) && feature(FEAT_USERSETUP);
  case FEAT_USERSETUPSHOWHIDDENHEADERS:
    return (query("showhiddenheaders")=="yes") && feature(FEAT_USERSETUP);
  default:
    return 0;
  }  
}

static object logfile = 0;

void imho_log(string event, mapping data){
  string now;

  if (!logfile && sizeof(query("logfile")) > 0) {
     logfile = Stdio.File();
     if (!(logfile->open(query("logfile"),"wca"))) {
       logfile = 0;
     }
  }
#ifdef THREADS
  object lock;
  lock = log_lock->lock();
#endif

  if(logfile)
    now=replace(ctime(time()),"\n","");

  switch(event) {
  case "startup":
    stats->starttime = time();
    if (logfile)
      logfile->write(now+" IMHO Starting up.\n");
    break;
  case "sendmail":
    stats->nomailsent++;
    stats->nobytessent+=data->size;
    if (logfile && query("logsendmail") == "yes")
      logfile->write(now+
		     sprintf(" Sent mail from %s to %s, size %d\n",
			     data->from, data->to, data->size));
    break;
  case "login":
    stats->nologins++;
    if (logfile && query("loglogin") == "yes")
      logfile->write(now+" Login:"+data->login+"\n");
    break;
  case "loginfailed":
    stats->nofailedlogins++;
    if (logfile && query("loglogin") == "yes")
      logfile->write(now+" Login failed:"+data->login+"\n");
    break;
  case "logout":
    stats->nologouts++;
    if (logfile && query("loglogin") == "yes")
      logfile->write(now+" Logout:"+data->login+"\n");
    break;
  case "autologout":
    stats->noautologouts++;
    if (logfile && query("loglogin") == "yes")
      logfile->write(now+" Auto logout:"+data->login+"\n");
    break;
  case "imapfail":
    stats->noimapfailures++;
    if (logfile && query("logerrors") == "yes")
      logfile->write(now+" IMAP Error, command: "+data->command+", response: " + 
		     data->line+"\n- History:\n- "+replace(data->history,"\n","\n- ")+"\n");
    break;
  case "smtpfail":
    stats->nosmtpfailures++;
    if (logfile && query("logerrors") == "yes")
      logfile->write(now+" SMTP Error, command: "+data->command+", response: "+data->line+"\n");
    break;
  }
#ifdef THREADS
  destruct(lock);
#endif
}

void load_global_addressbook() {
  object lock;
#ifdef THREADS
  lock = global_lock->lock();
#endif
  global_addressbook = "";
  array (string) entries = replace(query("globaladdressbook"),"\r\n","\n") / "\n";
  string fn = query("globaladdressbookfile");
  string filebook = "";
  if (sizeof(fn) > 0)
    filebook=Stdio.read_bytes(fn) || "";
  filebook = import_addressbook(filebook);
  entries += replace(filebook,"\r\n","\n") / "\n";
  entries = sort(entries);
  foreach(entries, string entry) {
    if (sizeof(entry) > 0)
      global_addressbook += (sizeof(global_addressbook)==0?"":"\n")+entry;
  }

#ifdef THREADS
  destruct(lock);
#endif
}



void load_langs() {
  object lock;
#ifdef THREADS
  lock = global_lock->lock();
#endif
  if(!langs_loaded) {
    mixed err;
    lang_progs=([ "english":0 ]);
    lang_progs_short=([ "en":"english" ]); 
    lang_charsets=([ "english": "iso-8859-1" ]);
    lang_replacement_strings=([ "english": "" ]);

    string msgdefs = Stdio.read_bytes(__FILE__);
    msgdefs = msgdefs[ search(msgdefs, "// BEGIN MESSAGES") ..
		       search(msgdefs, "// END MESSAGES") + 14 ] + "\n";

    if(sizeof(query("langfiledir"))) {
      array files=get_dir(query("langfiledir"));
      if(files) {
	foreach(files,string file) {
	  if(file[0..4]=="imho_" && (lower_case(file[sizeof(file)-5..])==".pike" ||
				     lower_case(file[sizeof(file)-8..])==".pike.gz")) {
	    if (query("debug")=="on")
	      perror("IMHO: Considering lang file "+file+"\n");
	    object lang_prog;
	    string lang_file=combine_path(query("langfiledir"),file);
	    master()->set_inhibit_compile_errors("");
	    err=catch(lang_prog=compile_string(msgdefs + Stdio.read_bytes(lang_file))());
#if constant(Gz.inflate)
	    if(err)
	      err=catch(lang_prog=compile_string(msgdefs + Gz.inflate()->
						 inflate(Stdio.read_bytes(lang_file)))());
#endif
	    master()->set_inhibit_compile_errors(0);
	    if(!err && lang_prog->imho_lang) {
	      if (query("debug")=="on")
		perror("IMHO: Loaded lang " + lang_prog->imho_lang() +
		       " from file " + file + "\n");
	      lang_progs[lang_prog->imho_lang()] = lang_prog;
	      if(lang_prog->imho_lang_short)
		lang_progs_short[lang_prog->imho_lang_short()] = (lang_prog->imho_lang());
	      if(lang_prog->imho_lang_charset)
		lang_charsets[lang_prog->imho_lang()] = (lang_prog->imho_lang_charset());
	      if(lang_prog->imho_lang_replacement_string)
		lang_replacement_strings[lang_prog->imho_lang()] = 
		  (lang_prog->imho_lang_replacement_string());
#if 0
	      if(roxen->dump)
		roxen->dump(lang_file);
#endif
	    }
	  }
	}
      }
    }
  }
  langs_loaded = 1;
#ifdef THREADS
  destruct(lock);
#endif
}

int plugin_loaded = 0;
object plugin = 0;

void load_plugin() {
  object lock;
#ifdef THREADS
  lock = global_lock->lock();
#endif
  if(!plugin_loaded) {
    mixed err;
    master()->set_inhibit_compile_errors("");
    err=catch(plugin=compile_string(Stdio.read_bytes(query("plugin")))());
    master()->set_inhibit_compile_errors(0);
  }
  plugin_loaded = 1;
#ifdef THREADS
  destruct(lock);
#endif
}


//FIXME: Use Calendar here?
array parse_date(string s){
  int year=-1,month=-1,day=-1,hour=-1,minute=-1,second=-1,timezone=-1;
  string _wday,_month;
  if(!s)
    return 0;
  if(sscanf(s,"%s, %d %s %d %d:%d:%d",_wday,day,_month,year,hour,
	    minute,second)<4)
    if(sscanf(s,"%d-%s-%d %d:%d:%d",day,_month,year,hour,minute,second,timezone)<6)
      return 0;

  if(year<100) {
    if(year<70)
      year+=2000;
    else
      year+=1900;
  }

  month = (["jan":1,"feb":2,"mar":3,"apr":4,"may":5,"jun":6,
	    "jul":7,"aug":8,"sep":9,"oct":10,"nov":11,"dec":12])[lower_case(_month[..2])];
  if(!month)
    month=-1;

  return ({ year,month,day,hour,minute,second });
}


string translate_date(string s, void|int gtext){
  string ret="";
  array datevals = parse_date (s);
  
  if (!s) {
    ret = "??????";
  } else {
    string datesep = query("datesep");
    if( datesep == "none")
      datesep = "";
    
    switch (query("dateformat")) {
    case "DD:MM":
      ret += sprintf ("%02d%s%02d", datevals[2], datesep, datevals[1]);
      break;
    case "MM:DD":
      ret += sprintf ("%02d%s%02d", datevals[1], datesep, datevals[2]);
      break;
    case "DD:MM:YY":
      ret += sprintf ("%02d%s%02d%s%02d", datevals[2], datesep, datevals[1],
		     datesep, datevals[0]%100);
      break;
    case "MM:DD:YY":
      ret += sprintf ("%02d%s%02d%s%02d", datevals[1], datesep, datevals[2],
		     datesep, datevals[0]%100);
      break;
    case "YY:DD:MM":
      ret += sprintf ("%02d%s%02d%s%02d", datevals[0]%100, datesep, 
		     datevals[2], datesep, datevals[1]);
      break;
    case "DD:MM:YYYY":
      ret += sprintf ("%02d%s%02d%s%04d", datevals[2], datesep, datevals[1],
		     datesep, datevals[0]);
      break;
    case "MM:DD:YYYY":
      ret += sprintf ("%02d%s%02d%s%04d", datevals[1], datesep, datevals[2],
		     datesep, datevals[0]);
      break;
    case "YYYY:MM:DD":
      ret += sprintf ("%04d%s%02d%s%02d", datevals[0], datesep, 
		     datevals[1], datesep, datevals[2]);
    case "YY:MM:DD":
      ret += sprintf ("%02d%s%02d%s%02d", datevals[0] % 100, datesep, 
		     datevals[1], datesep, datevals[2]);
      break;
    }

    if (query("timeformat") != "none") {
      switch (query("datetimesep")) {
      case "space":
	ret += " ";
	break;
      case "dash":
	ret += "-";
	break;
      case "slash":
	ret += "/";
	break;
      case "space-dash-space":
	ret += " - ";
	break;
      case "space-slash-space":
	ret += " / ";
	break;
      }

      switch (query("timeformat")) {
      case "HH:MM (24-hour)":
	ret += sprintf ("%02d:%02d", datevals[3], datevals[4]);
	break;
      case "HH:MM:SS (24-hour)":
	ret += sprintf ("%02d:%02d:%02d", datevals[3], datevals[4], 
			datevals[5]);
	break;
      case "HH:MMx (12-hour)":
	ret += sprintf ("%02d:%02d%s", datevals[3] == 0 ? 12 : datevals[3]%12,
			datevals[4], (datevals[3]%12 == datevals[3]?"a":"p"));
	break;
      case "HH:MM xx (12-hour)":
	ret += sprintf ("%02d:%02d %s", datevals[3] == 0 ? 12 : 
			datevals[3]%12, datevals[4], 
			(datevals[3]%12 == datevals[3]?"am":"pm"));
	break;
      case "HH:MM:SS xx (12-hour)":
	ret += sprintf ("%02d:%02d:%02d %s", datevals[3] == 0 ? 12 :
			datevals[3]%12, datevals[4], datevals[5],
			(datevals[3]%12 == datevals[3]?"am":"pm"));
	break;
      }
      
    }

  }
    
  return ret;
}

string make_links(object id, string text){
  string newstr="";
  //FIXME: 10000 ?
  string instr=text[0..(10000<sizeof(text)?10000:sizeof(text)-1)];

  array (string)keys = ({ "http://", "ftp://", "telnet://", "gopher://",
			  "wais://", "@","https://" });
  string stoptkn=" \n\r\"()[]{}<>'`;";

  int lenght=sizeof(instr);
  int ready=0;
  int position=0;
  int position2=0;

  while(!ready){
    int minpos=-1;
    int index;
    int foo,tmp;

    for(foo=0;foo<sizeof(keys);foo++){
      tmp=search(instr,keys[foo],position);
      if ((tmp!=-1) && ( minpos==-1 || tmp<minpos)){
	minpos=tmp;
	index=foo;
      }
    }
    
    if(minpos!=-1){
      if(keys[index]!="@"){
	if(minpos>position)
	  newstr+=instr[position..minpos-1];
	newstr+="<a target=\"_top\" href=\"";
	position=minpos;
	int amp = 0;
	while((position<lenght) && (amp || search(stoptkn,instr[position..position])==-1)) {
	  if (amp && instr[position] == ';')
	    amp = 0;
	  if (instr[position] == '&')
	    amp = 1;
	  position++;
	}
	newstr+=replace(instr[minpos..position-1],"&amp;","&")+"\">";
	newstr+=instr[minpos..position-1]+"</a>";
      }
      else{
	position2=minpos;
	while((position2>=0) && ((search(stoptkn,instr[position2..position2]))==-1))
	  position2--;
	newstr+=instr[position..position2];
	position=minpos;
	while((position<lenght) && ((search(stoptkn+"&",instr[position..position]))==-1))
	  position++;
	if((position2<minpos-1)&&(position>minpos+2)){
	  newstr+="<a target=\""+id->misc->imho->uptarget+"\" "
	    "href=\""+id->misc->imho->nextuptarget+"?actioncompose=1&to="+
	    http_encode_url(instr[position2+1..position-1])+"\">";
	newstr+=instr[position2+1..position-1]+"</a>";
	}
	else
	  newstr+=instr[position2+1..position-1];
      }
     }
    ready=(minpos==-1);
  }
  newstr+=instr[position..];
  //FIXME: 10000 ?
  if (sizeof(text) > 10001)
    newstr += text[10001..sizeof(text)-1];
  return newstr;
}

string
fix_coding(string str){
  if(!str)
    return "?";
  array a=Array.map(str/" ",MIME.decode_word);
  string spaces=" ";
  string ret="";
  if(sizeof(a))
    if(catch(ret+=Locale.Charset.decoder(a[0][1])->feed(a[0][0])->drain()))
      ret+=a[0][0];
  int last_coded=sizeof(a) && a[0][1];
  for(int i=1;i<sizeof(a);i++) {
    if(a[i][0]!="") {
      if(!(last_coded && a[i][1]))
	ret+=spaces;
      if(catch(ret+=Locale.Charset.decoder(a[i][1])->feed(a[i][0])->drain()))
	ret+=a[i][0];
      spaces=" ";
      last_coded=!!a[i][1];
    }
    else {
      if(last_coded)
	spaces+=" ";
      else
	ret+=" ";
    }
  }
  return ret;
}

// Convert submitted form data from browser to unicode. Test which charset
// is used by looking at the hidden variable "charsettest".
string formdata_to_unicode(mapping variables, object session, string s) {
  if (variables->charsettest) {
    switch(variables->charsettest) {
    case "": // iso-8859-1
      return s;
    case "åäö": // utf-8
      return Locale.Charset.decoder("utf-8")->feed(s)->drain();
    case "\0\0\0": // unicode
      return unicode_to_string(s);
    }
  }
  // No charsettest or unknown encoding, decode as if the browser returned in session->charset.
  return(TO_UNICODE(s));
}


array(string) split_from_address(string s) {
  return Array.map(replace(s-"\r",",","\n") / "\n",remove_blanks);
}

// Make sure the all email addresses are on correct form
array fixaddresses(string addr, string|void add_domain) {
  array ret = ({ "", "" });
  foreach(address_split(addr), string s) {
    string fixedaddr = "";
    string name = "", address = "";
    int endlimit = ')';
    int pos = 0,pos2=0, quote = 0;
    int broken = 0;
    while (pos < sizeof(s) && ( quote || 
				(s[pos] != '(' && s[pos] != '<'))) {
      if (s[pos] == '"')
	quote = quote?0:1;
      pos++;
    }
    if (pos < sizeof(s)) {
      if (s[pos] == '<') {
	endlimit = '>';
	if (pos > 1)
	  name = s[0..pos-2];
      } else {
	if (pos > 1)
	  address = s[0..pos-2];
      }
      pos++;
      pos2 = pos;
      while (pos < sizeof(s) && ( quote || s[pos] != endlimit)) {
	if (s[pos] == '"')
	  quote = quote?0:1;
	pos++;
      }
      if (pos == sizeof(s))
	broken = 1;
      if (endlimit == '>')
	address = s[pos2..pos-1];
      else
	name = s[pos2..pos-1];
    } else {
      address = s;
    }
    while (sizeof(name) > 0 && name[0] == ' ')
      name = name[1..];
    while (sizeof(name) > 0 && name[-1] == ' ')
      name = name[0..sizeof(name)-2];
    while (sizeof(address) > 0 && address[0] == ' ')
      address = address[1..];
    while (sizeof(address) > 0 && address[-1] == ' ')
      address = address[0..sizeof(address)-2];
    if (search(address, " ") >= 0)
      broken = 1;
    if(add_domain && sizeof(address) && search(address,"@") == -1)
      address += "@"+add_domain;
    if (name == "")
      fixedaddr = address;
    else {
      name = replace(name, "\"", "");
      //fixedaddr = "\""+name+"\" <"+address+">";
      // I suppose quotes around the name isn't necessary
      fixedaddr = name+" <"+address+">";
    }
    if (sizeof(ret[0]) == 0)
      ret[0] = fixedaddr;
    else
      ret[0] += ", "+fixedaddr;
    if (broken)
      ret[1] = s;
  }
  return(ret);
}

string fixstring(string s)
{
  if(!s) s="";
  return replace(s, 
		 ({"<",">","&","\n", "\r", "\""}),
		 ({"&lt;","&gt;","&amp;","<br />", "", "&quot;" }) );
}

string fix_header(string str) {
  if(!str || !sizeof(str))
    str="?";
  return replace(fix_coding(str), ({"<", ">", "&", "\n", "\r" }), 
		 ({"&lt;", "&gt;", "&amp;", "<br />", "" }) );
}

// safe_container and safe_tag used by safe_html to sort out safe tags
mixed safe_container( string tag, mapping m,
		      string contents, object id, mapping refparts, 
		      array tagreferences, array disallowedargs,
		      mapping tags, mapping containers, int depth) {
  foreach(tagreferences, string ref) {
    if (m[ref] && sizeof(m[ref]) > 4 && lower_case(m[ref][0..3]) == "cid:") {
      refparts["<"+m[ref][4..]+">"] = 1;
      m[ref] = id->misc->imho->nextpage+"/image?mailpart="+http_encode_url(m[ref]);
    } else if (ref != "href")
      m_delete(m,ref);
    if (m[ref] && sizeof(m[ref]) > 10 && lower_case(m[ref][0..10]) == "javascript:")
      m_delete(m,ref);
  }
  foreach(disallowedargs, string arg)
    if (m[arg])
      m_delete(m,arg);
  
  string q=make_tag_attributes(m);
  if (depth > 0)
    contents=parse_html(contents, tags, containers, id, refparts, 
			tagreferences, disallowedargs,tags, containers,
			depth-1);
  return ({ "{2"+tag+(strlen(q)?" "+q:"")+"}2"+contents+"{2/"+tag+"}2" });
}

mixed safe_tag( string tag, mapping m, object id, mapping refparts,
		array tagreferences, array disallowedargs,
		mapping tags, mapping containers) {
  foreach(tagreferences, string ref) {
    if (m[ref] && sizeof(m[ref]) > 4 && lower_case(m[ref][0..3]) == "cid:") {
      refparts["<"+m[ref][4..]+">"] = 1;
      m[ref] = id->misc->imho->nextpage+"/image?mailpart="+http_encode_url(m[ref]);
    } else if (ref != "href")
      m_delete(m,ref);
    if (m[ref] && sizeof(m[ref]) > 10 && lower_case(m[ref][0..10]) == "javascript:")
      m_delete(m,ref);
  }
  foreach(disallowedargs, string arg)
    if (m[arg])
      m_delete(m,arg);

  string q=make_tag_attributes(m);
  return ({ "{2"+tag+(strlen(q)?" "+q:"")+" /}2" });
}

string safe_ignorecontainer( string tag, mapping m,
			     string contents, object id, mapping refparts,
			     array tagreferences, array disallowedargs) {
  return "";
}

mixed safe_body( string tag, mapping m,
		 string contents, object id, mapping refparts,
		 array tagreferences, array disallowedargs,
		 mapping tags, mapping containers, int depth) {
  string ret="";
  foreach(tagreferences, string ref)
    if (m[ref] && sizeof(m[ref]) > 4 && m[ref][0..3] == "cid:") {
      refparts["<"+m[ref][4..]+">"] = 1;
      m[ref] = id->misc->imho->nextpage+"/image?mailpart="+http_encode_url(m[ref]);
    }

  ret +="{2table cellpadding=0 border=0 cellspacing=0";
  if (m->bgcolor)
    ret += " bgcolor=\""+m->bgcolor+"\"";
  if (m->background)
    ret += " background=\""+m->background+"\"";
  if (depth > 0)
    contents=parse_html(contents, tags, containers, id, refparts, 
			tagreferences, disallowedargs,tags, containers,
			depth-1);
  ret+="}2{2tr}2{2td}2"+contents+"{2/td}2{2/tr}2{2/table}2";
  return ({ ret });
}

// let only allowed tags through and make sure all containers are closed
string safe_html(string in, object id, mapping refparts) {
  string parsed;
  mapping containers=([]);
  mapping tags=([]);
  int start, stop;
  array allowedtags = ({ "img", "li","dt","dd","br","hr","q","dd","dt"});
  array allowedcontainers = ({"a","p","b","i","font","div", "h1", "h2", "h3", "h4", "h5", "h6",
			      "pre", "ul", "ol", "dl", "table", "th", "tr", "td", "span",
			      "address","blockquote","sub","sup" });
  array tagreferences = ({"src","href","background"});
  array disallowedcontainers = ({"style"});
  array disallowedargs = ({"onclick", "ondoubleclick", "onmousedown", "onmouseup", "onmouseover",
			   "onmousemove", "onmouseout", "onfocus", "onblur", "onkeypress", 
			   "onkeydown", "onkeyup", "onsubmit", 
			   "onreset", "onselect", "onchange"});

  foreach(allowedcontainers, string t) {
    containers+=([t:safe_container]);
  }
  foreach(disallowedcontainers, string t) {
    containers+=([t:safe_ignorecontainer]);
  }
  containers+=(["body":safe_body]);

  foreach(allowedtags, string t) {
    tags+=([t:safe_tag]);
  }

  in=replace(in,({"{","}"}),({"{1","}1"}));
  parsed=parse_html(in, tags, containers, id, refparts, 
		    tagreferences, disallowedargs, tags, containers, 10);
  parsed=Array.map(parsed/"<",
		   lambda(string s) {
		     array a = s/">";
		     if (sizeof(a) >= 2)
		       return(a[1]);
		     return("");
		   })*" ";
  return replace(parsed,({"{1","}1", "{2", "}2" }),({"{","}","<",">"}));
}

string strip(string s)
{
  if (!s)
    return "";
  return replace(s, ({ "\r" }), ({ "" })); 
}

string strip_path(string s)
{
  if (!s)
    return "";
  return replace(s, ({ ".." }), ({ "" })); 
}


//FIXME: Replace with String.trim_whites when we ditch Pike 0.6
string remove_blanks(string s) {
  sscanf(s, "%*[ ]%s", s);
  sscanf(reverse(s), "%*[ ]%s", s);
  return reverse(s);
}

//FIXME: String_width -> String.width
int String_width(string s) {
#if __VERSION__ > 0.6
  return String.width(s);
#else
  return 8;
#endif
}

array
address_split(string s) {
  array i=({ 0 });
  return (Array.map(s/"\"",
		    lambda(string s,array i){return (i[0]=i[0]?0:1)?replace(s,",","\0"):s;},
		    i)*"\"")/"\0";
}


string
rand_string(int len) {
  array chr = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKMNOPQRSTUVWXYZ0123456789" / "";
  string foo = "";
  int bar;
  int s = sizeof(chr);
  for(int i=0 ; i<len ; i++){
    bar = random(s);
    foo += chr[bar];
  }
  return foo;
}

string 
filetype(string fname) {
   return (my_configuration()->type_from_filename(fname,0));
}

string
mb_displayname_from_name(string mbox,object session) {
  foreach(session->mailboxes,array mbox_a)
    if(mbox_a[MB_FOLDERNAME_IDX]==mbox)
      return mbox_a[MB_DISPLAYNAME_IDX];
  return "";
}


string
server_url(void|int _norelativeurl, string|void user) {
  int norelativeurl=_norelativeurl?1:0;
  string s1,s2,server_url="",prot="";
  int port=443;
  if (sizeof(query("urloverride")) > 0)
    return(query("urloverride"));
  int ssl3=query("ssl3redir")=="yes";
  if(!ssl3 && !norelativeurl)
    return "";
  if(my_configuration()->server_ports) {
    foreach(indices(my_configuration()->server_ports),string s) {
      if(sscanf(s,"%s://%s/%s",prot,s1,s2)==3) {
	sscanf(s1,"%s:%d",s1,port);
	if (s1 == "ANY") {
#if efun(gethostname)
	   s1 = gethostname();
#else
	   s1 = "localhost";
#endif
	}
	server_url = (prot == "ssl3" ? "https" : prot) + 
	  "://"+s1+((port==443 && prot=="ssl3") ||
		    (port==80 || prot=="http") ? "": ":"+port );
	if(!ssl3 || prot=="ssl3")
	  break;
      }
    }
  } else {
    if(norelativeurl)
      server_url=my_configuration()->query("MyWorldLocation");
    else
      server_url="";
  }
  if(prot!="ssl3" && !norelativeurl)
    return "";
  if(sizeof(server_url) && user) {
    int i = search(server_url,"://");
    if(i != -1) 
      server_url = server_url[..i+2] + user + "@" + server_url[i+3..];
  }
  if(sizeof(server_url) && server_url[sizeof(server_url)-1]=='/')
    server_url=server_url[..sizeof(server_url)-2];
  return server_url;
}


mapping
redirect(object id,string session, string nextpage) {
  return http_redirect(server_url()+query("location")+session+(nextpage==""?"":"/")+nextpage);
}

string set_imho_cookie(string cookie, string value) {
  string ret="";
  
#ifdef __ROXEN_TWO_ZERO__
  ret+="<set-cookie name=\""+cookie+"\" value=\""+value+"\" path=\"\" />";
#else
  ret+="<set_cookie name=\""+cookie+"\" value=\""+value+"\" path=\"\" />";
#endif
  return(ret);
}

string remove_imho_cookie(string cookie) {
  string ret = "";
#ifdef __ROXEN_TWO_ZERO__
  ret+="<remove-cookie name=\""+cookie+"\" />";
#else
  ret+="<remove_cookie name=\""+cookie+"\" />";
#endif
  return(ret);
}

string smtp_format(string s, int keepbcc)
{ // Make sure each line is max 1000 bytes and that no lines begins with "."
 // Also remove BCC address
 string ret = "";
 int headers = 1;
 foreach(s/"\r\n", string l) {
   string bcc = "";
   if (!(headers && !keepbcc &&(sscanf(lower_case(l), "bcc%*[ ]:%s",bcc) > 0) &&
	 sizeof(bcc) > 0) ) {
     if (sizeof(l) == 0)
       headers = 0;
     while (sizeof(l) > 1000) {
       string first = l[0..999];
       if (headers)
	 l = " "+l[1000..];
       else
	 l = l[1000..];
       if (first[0] == '.')
	 ret+= ".";
       ret+=first+"\r\n";
     }
     if (sizeof(l) > 0 && l[0] == '.')
       ret+= ".";
     ret+=l+"\r\n";
   } 
 }
  return(ret);
}

string wrap_lines(string s, int len)
{ // Wrap lines in a text to max len chars (i.e insert CRLFs at
  // appropriate positions). Also make sure LF is really CRLF.
  // And: Remove spaces in the end by replacing them by "\0" and then
  // by nothing.
  s=replace(s,"\r","");
  return (replace(len>0 ? sprintf("%-=*~s",len,"\0",s):s, 
		  ({ "\n", "\0" }), 
		  ({ "\r\n", "" })));
}

// Find a mail with a certain key and return the array index.
int find_mail(array mails, string key, mixed value)
{ 
  int nr = Array.search_array(mails,
			      lambda(mapping mail, mixed value, string key) 
    {
      if(mail[key] == value)
      return 1;
      return 0;
    },
			      value, key);
  return(nr);
}


object find_session_for_login(string login) {
  foreach(values(sessions), object session)
    if(session->login == login)
      return session;
  return 0;
}


//
// The Session class
//

class _Session {
  string session = ""; // id for this session
  
  string login = ""; // login name
  string passwd = ""; // the password

  int loggedin = 0; // session is authenticated?
  int administrator = 0; // user is an administrator
  
  object lock;

  string ip; // user logged in from this ip

  object imapclient; // the IMAP and SMTP client object
  string imapserver = "localhost";
  int imapport = 143;
  int reqtrycreate = 0; // require [TRYCREATE] hints to create folders?
  int mboxencode = 1; // mailbox names encoded in modified UTF-7 encoding?
  string hidemboxes; // prefix for mailboxes that should be hidden
  int showprefsbox = 0; // should the preferences mailbox be shown?
  int imapidlelogout; // disconnect after this many seconds if there is no IMAP traffic.
  
  string maildomain = "";

  string defaultmailpath = "";

  string overridelayout;

  string mailboxstyle;

  string prefsdir;

  string smtpserver = "localhost";
  int smtpport = 25;

  int logintime = 0;
  int last = 0; // last access using this session

  int loadfiles = 0; // flag that attachments should be listed

  int status = LOGINPROMPT; // active screen

  object cmail = 0; // current mail
  int cmailidx = 0;
  int cmailuid = 0;

  string messageid;

  int mailheadersloaded = 0;

  object prefsmailobj;
  string prefsbox;
  array prefsmails = ({ });

  mapping lcfgmap = ([ ]);

  string mailssortcolumn = "";
  
  int visible = 20;
  int firstvisiblemail = 0;
  int lastvisiblemail = 0;
  
  int utf8 = 1; // client supports utf-8 encoding?
  int cookies = 1; // client accepts cookies?
  string charset = "iso-8859-1"; // charset currently in use
  
  mapping lang_progs; // language modules

  array mailbox = ({ }); // current mailbox
  array mails = ({ }); // mail in current mailbox
  array mailboxes = ({ }); // all mailboxes

  array activemailboxinfo = ({ });

  string usernamemethod;
  string namedb;
  
  array files = ({ }); // stored attachments
  
  int prefsloaded = 0; // user preferences has been loaded

  int debug = 0; // debug output on for this session?
  
  int showheaders = 0;

  object old_module; // reference to old copy of IMHO
  
  string lastpath = ""; // last selected path in mailbox browser

  string defaultsentfolder = "";
  string defaulttrashfolder = "";

  int ldap = 0;
  string ldapserver = "";
  string ldapsearchroot ="";
  string ldapadd;
  
  int wrapcolumn = 70;

  string displayerrors;

  string defaultaddress;

  string sessionsortorder = "forward";
  string sessionsortcolumn = "num";

  string searchstring = "";

  array prefuids = ({ });

  array deletemboxes = ({ });
  array deletemails = ({ });

  string copytobox;

  // send mail
  string sendmail;
  string sentmaildata;
  array sendrecipients;
  int dsnsuccess;
  int dsndelay;

  // compose
  string from; // currently selected from address
  string to;
  string cc;
  string bcc;
  string subject;
  string message;
  array attachments = ({ });
  int replytoidx = -1;
  string replytocharset;

  // address book
  string recipientfield;
  string editaddressmode;
  int editaddress;

  // dialogs
  array dialogstrings;
  array dialogactions;
  string dialogtext;
  string dialogtarget;

  // spell checker
  array spelling = ({ });
  array misspelled = ({ });
  int checkword = 0;
  string ispelldict;

  // prefs
  string name = "";
  string address = "";
  string mailpath = "";
  string replymsgprefix = "> ";
  string replyincludemsg = "yes";
  string extraheader = "";
  string signature = "";
  string autologout = "20";
  string visiblemail = "20";
  string sortorder = "forward";
  string sortcolumn = "num";
  string trashfolder = "Trash";
  string sentfolder = "sent-mail";
  string autobcc = "";
  string saveattachments = "no";
  string language = ""; // selected language
  string addressbook = "";
  string layout = "0";
  string showhiddenheaders = "yes";
  string activemailboxes = "INBOX";
  string draftmail = "";
  string showhtml = "yes";

  //
  int usersetup = 0;
  int usersetupautobcc = 0;
  int usersetuptrashfolder = 0;
  int usersetupmailpath = 0;
  int usersetuplanguage = 0;
  int usersetupsignature = 0;
  int usersetupreplyincludemsg = 0;
  int usersetupsaveattachments = 0;
  int usersetupaddress = 0;
  int usersetupdraftmail = 0;
  int usersetupactivemailboxes = 0;
  int usersetupactiveinboxes = 0;
  int usersetupaddressbook = 0;
  int usersetupshowhiddenheaders = 0;
  int usersetuplayout = 0;
  int usersetupsortcolumn = 0;
  int usersetupsortorder = 0;
  int usersetupautologout = 0;
  int usersetupextraheader = 0;
  int usersetupsentfolder = 0;
  int usersetupname = 0;
  int usersetupshowhtml = 0;
  int usersetupvisiblemail = 0;
  int usersetupreplymsgprefix = 0;

  // runtime admin interface
  array users = ({ });
  int showfrom;
  int adminsortcolumn;
  int sortup;

  int mysizeof(mixed m, void|int start) {
    int sz = 0;
    
    switch(sprintf("%O",_typeof(m))[..2]) {
    case "str":
      sz += (sizeof(m) * (String_width(m)/8)  );
      break;
    case "int":
      sz += 4;
      break;
    case "map":
    case "arr":
      foreach(values(m), mixed m2)
	sz += mysizeof(m2); 
      break;
    case "obj":
      if(start) {
	foreach(values(m) - ({ users }), mixed m2)
	  sz += mysizeof(m2); 
	if(m->cmail) {
	  sz += sizeof(cmail->getdata() || "");
	  sz += `+(@(Array.map(m->cmail->body_parts||({ }),lambda(object o){ return sizeof(o->getdata()||"");})+({0,0})));
	}
      }
      else {
	sz += sizeof(m);
	//werror("Object %O size: %O\n",m,sizeof(m));
      }
      break;
    }
    return sz;
  }
  
  int _sizeof() {
    return mysizeof(this_object(),1);
  }
  
  string dump_me() {
    return sprintf("%O\n",mkmapping(indices(this_object()),values(this_object())));
  }

  string _sprintf( int f )
  {
    return sprintf( "Session(/* login=%O */)", login);
  }
}

class Session
{
  inherit _Session;

#if 0
  // emulate a mapping...

  mapping compat = ([ ]);

  static mixed `[](string ind) {
    if(!zero_type(_Session::`[](ind)))
      return _Session::`[](ind);
    werror("Compat `[] for %O\n",ind);
    return compat[ind];
  }
 
 static mixed `->(string ind) {
    if(!zero_type(_Session::`[](ind)))
      return _Session::`->(ind);
    werror("Compat `-> for %O\n",ind);
    return compat[ind];
  }

  static mixed `[]=(string ind, mixed what) {
    if(!zero_type(_Session::`[](ind)))
      return _Session::`[]=(ind, what);
    werror("Compat `[]= for %O\n",ind);
    return compat[ind] = what;
  }

  static mixed `->=(string ind, mixed what ) {
    if(!zero_type(_Session::`[](ind)))
      return _Session::`->=(ind, what);
    werror("Compat `->= for %O\n",ind);
    return `[]=(ind, what );
  }
#endif
}





//
// IMAP-Client
//

#define MODE_LINE 0
#define MODE_PARSE 1


#define PS_EAT_BLANKS 0
#define PS_EXPECT_TOKEN 1
#define PS_PARSE_IDENT 2
#define PS_PARSE_QSTR 3
#define PS_PARSE_STR1 4
#define PS_PARSE_STR2 5
#define PS_PARSE_STR3 6
#define PS_PARSE_INTEGER 8

#define TOKEN_QSTRING 1
#define TOKEN_STRING 2
#define TOKEN_INTEGER 3
#define TOKEN_IDENT 4
#define TOKEN_LEFTPAR 5
#define TOKEN_RIGHTPAR 6
#define TOKEN_NIL 7

#define PT_MAPPING 0
#define PT_LIST 1
#define PT_QSTR 2
#define PT_TOKENS 3

#define TIMEOUT1 60

#define IMAP_LITERAL(x) ("{"+(string)sizeof(x)+"}\r\n"+x)
#define IMAP_QSTRING(x) ("\""+replace(x,({"\"","\\"}),({"\\\"","\\\\"}) )+"\"")

#define GLOBAL (session->old_module?session->old_module:function_object(find_file))


#define CMD_VAR_POINTER 0x12149313
#define IMAP_CMDS \
mapping imap_cmd(string cmd, mixed ... args) \
{ \
  mapping imap_cmd = ([ ]); \
  \
  imap_cmd->cmd = cmd; \
  imap_cmd->abortfail = 1; \
  for (int i = 0; i+1 < sizeof(args); i+=2) \
    imap_cmd[args[i]] = args[i+1]; \
  return(imap_cmd); \
} \
\
array (string) imap_cmd_var(string var) { \
  return ({ CMD_VAR_POINTER, var }); \
} 

IMAP_CMDS

class imapclient {
  inherit "roxenlib";

  IMAP_CMDS

  int abort=0, smtpabort = 0;
  int result_sent=0;
  object session;
  object id;
  string data="", smtpdata="", smtpwritedata="";
  string imapwritedata = "";
  string line=0;
  string tmp_line="";
  string dsn_comm="";
  int dsn=0;
  int parse_type;
  int parse_state;
  int parse_level;
  string parse_tmp;
  int parse_str_len;
  array (mixed) tokens = ({ });
  mixed parse_result=0;
  string parse_label="";
  int tokens_to_get=0;
  array(mapping) commands;
  static mapping command=0;
  int command_result=0;
  int mode;
  mixed imap_idle_call_out=0;
  object fd;
  object smtpfd;
  int imap_seq=0;
  int fetchingno=0;

  string selected="";
  array mailstodelete=({ });
  array deletedmail=({ });
  array folderstodelete=({ });
  array mailstocopy=({ });
  array mailboxestocheck=({ });
  int trycreate=0;
  int searchtries = 0;
  int reconnects=0;
  array parserstate = 0;
  mixed cmd_result = 0;
  mixed cmd_tmp = 0;

  int command_seq=0;
  string foo,bar;
  array tmp_array;
  int tmp_int;

  string selected_mailbox = 0;
  int selected_mailbox_size = 0;

  array (string) imaplinehist = ({ });
  
  string msg(object session,int m,array a) {
    return GLOBAL->msg(session,m,a);
  }

  // Return data from an argument in a command structure
  // If arg is a string, it is retuned untouched
  // If arg is an array, the variable with name in arg[0] contains the 
  // data to be returned. If the name is "-", the data is taken 
  // from cmd_result instead (a kind of inter-command-pipe).
  mixed get_cmd_arg(mixed arg) {
    if (arg && sizeof(arg) > 0) {
      if (arrayp(arg) && (sizeof(arg) > 0) && intp(arg[0]) && (arg[0] == CMD_VAR_POINTER)) {
	string var = arg[1];
	if (var == "-")
	  return(cmd_result);
	else
	  return(session[var]);
      } else {
	return(arg);
      }
    }
    return 0;
  }
  void set_cmd_arg(mixed arg, mixed data) {
    if (arg && sizeof(arg) > 0) {
      if (arrayp(arg) && (sizeof(arg) > 0) && intp(arg[0]) && (arg[0] == CMD_VAR_POINTER)) {
	string var = arg[1];
	if (var == "-")
	  cmd_result = data;
	else
	  session[var] = data;
      } else {
	perror("set_cmd_arg: Wrong argument name!");
      }
    }
  }
  
  string translate_frommbox(object session, string mbox) {
    if (mbox == "INBOX")
      mbox = MSG(M_INBOX); 
    if (mbox == session->trashfolder)
      mbox = MSG(M_BOXTRASH); 
    if (mbox == session->sentfolder)
      mbox = MSG(M_BOXSENTMAIL); 
    return(mbox);
  }
  
  string translate_tombox(object session, string name) {
    if (name == MSG(M_INBOX))
      name = "INBOX";
    if (name ==  MSG(M_BOXTRASH))
      name = session->trashfolder;
    if (name ==  MSG(M_BOXSENTMAIL))
      name = session->sentfolder;
    return(name);
  }

  string fixmail(string mail) {
    // Fix mails which the MIME module cannot parse. This function is
    // called recursively for each mailpart

    int headend1 = search(mail, "\n\n");
    int headend2 = search(mail, "\r\n\r\n");
    int headend = (headend1<0? headend2 :
		   (headend2<0? headend1 :
		    (headend1<headend2? headend1 : headend2)));
    array (string) headers = (replace(mail[0..headend-1], 
				      ({"\r", "\t", "\n "}), 
				      ({ "", " ", " "}) ))/"\n";
    string newheaders = "";
    string contenttype = "", boundary = "";
    foreach(headers, string h) {
      string key = "", data = "";
      if (sscanf(h, "%[!-9;-~]%*[ ]:%*[ ]%s", key, data) > 2) {
	if (lower_case(key) == "content-type") {
	  string k1 = "", k2 = "", opts = "";
	  sscanf(data, "%s/%s;%s", contenttype, k2, opts);
	  foreach(opts/";", string opt) {
	    string l1 = "", l2 = "";
	    if (sscanf(opt, "%*[ ]%s=%s", l1, l2) > 1) { 
	      if (lower_case(l1) == "boundary") {
		boundary = l2;
		sscanf(boundary, "\"%s\"", boundary);
	      }
	    }
	  }
	}
      }
    }
    foreach(headers, string h) {
      string key = "", data = "";
      if (sscanf(h, "%[!-9;-~]%*[ ]:%*[ ]%s", key, data) > 2) {
	if (lower_case(key) == "content-transfer-encoding" && 
	    lower_case(contenttype) == "multipart") {
	  data = "8bit";
	}
	if ((lower_case(key) == "content-type" || 
	    lower_case(key) == "content-description" ||
	    lower_case(key) == "content-disposition") && sizeof(data) > 0)
	  while (data[-1] == ' ' || data[-1] == '\t' || data[-1] == ';')
	    data = data[0..sizeof(data)-2];
          if (lower_case (key) == "content-disposition")
                {
                  array foo = data / " ";
                  for (int i = 1; i < sizeof (foo); i++)
                    if (search (foo[i], "=") == -1)
                      foo[i] += "=fixed";
                  data = foo * " ";
                }
	newheaders += key+": "+data+"\n";
      }
    }
    string newmail = "";
    if (sizeof(boundary) > 0) {
      array (string) mailparts = mail[headend+2..] / ("--"+boundary);
      newmail += newheaders+"\n"+mailparts[0];
      for (int i = 1; i < sizeof(mailparts)-1; i++)
	newmail += "--"+boundary+"\r\n"+fixmail(mailparts[i]);
      newmail += "--"+boundary+"--\r\n\r\n";
    }
    else
      newmail = newheaders + "\n" + mail[headend+2..];
    return(newmail);
  }

  int find_mailbox(object session, string name) {
    return Array.search_array(session->mailboxes,
			      lambda(array a,string mbox) 
			      {
				if(a[MB_DISPLAYNAME_IDX] == mbox)
				  return 1;
				return 0;
			      },
			      name);
  }
  
  void imapwrite(string data) { // Write data to a nonblocking socket
    if(imap_idle_call_out)
      remove_call_out(imap_idle_call_out);
    imap_idle_call_out=call_out(handle_imap_idle_timeout,session->imapidlelogout);
    int res;
    if (sizeof(imapwritedata) > 0)
      imapwritedata += data;
    else {
      res = fd->write(data);
      if (res < sizeof(data))
	imapwritedata = data[res..];
    }
  }

  void smtpwrite(string data) { // Write data to a nonblocking socket
    int res;
    if (sizeof(smtpwritedata) > 0)
      smtpwritedata += data;
    else {
      res = smtpfd->write(data);
      if (res < sizeof(data))
	smtpwritedata = data[res..];
    }
  }

  string encode_pref(string s) 
    {
      if (!s)
	return "";
      return replace(s, ({ "<br", "\n", "\r" }), ({ "<br0", "<br>\n", "" }));
    }
  
  string decode_pref(string s)
    {
      if (!s)
	return "";
      return replace(s, ({ "<br0", "<br>", "\r" }), ({ "<br", "\n", "" }));
    }
  
  void init_parser(int pt) {
    parse_type=pt;
    tokens=({ });
    line=0;
    parse_state=0; //PS_EAT_BLANKS;
    parse_result = ({ });
    parse_label = "";
    mode=MODE_PARSE;
  }
  

  
  string 
  imap_tag() {
    return sprintf("imho%04d",imap_seq);
  }
  
  void 
  imap_firsttag() {
    imap_seq = 0;
  }
  
  void 
  imap_newtag() {
    imap_seq++;
  }


  void handle_error() {
    if (smtpfd) {
      catch { smtpfd->close(); };
      smtpfd=0;
    }
    if(command && command->error && sizeof(command->error) > 0) {
      session->dialogstrings = ({ MSG(M_DIALOGOK) });
      if (command && command->erroraction)
	session->dialogactions = ({ command->erroraction });
      else
	session->dialogactions = ({ "actionfolderlist" });
      if (command && (command->cmd[0..3] == "smtp"))
	session->dialogtext = MSG(M_SMTPERROR);
      else {
	session->dialogtext = command->error;
	if (session->displayerrors == "yes") 
	  session->dialogtext += "\n"+line;
      }
      session->status = DIALOGBOX;
      return;
    }

    if(command && command->cmd=="low_login") {
      // don't keep connection to imapd open
      // if login fails.
      catch { fd->close(); };
      fd=0;
      selected_mailbox=0;
    }
    if(session->status<0) {
      if (command_result == -1) {
	GLOBAL->imho_log("loginfailed", ([ "login":session->address ]));
	session->status=LOGINFAILED;
      }
      else
	session->status=LOGINFAILEDIMAP;
    } else {
      session->dialogstrings = ({ MSG(M_DIALOGOK) });
      if (command && command->erroraction)
	session->dialogactions = ({ command->erroraction });
      else
	session->dialogactions = ({ "actionfolderlist" });
      if (command->cmd[0..3]=="smtp") {
	session->dialogtext = MSG(M_SMTPERROR);
	GLOBAL->imho_log("smtpfail", ([ "login":session->address, 
			      "command":command->cmd, "line":line ]));
      } else {
	session->dialogtext = MSG(M_IMAPERROR);
	GLOBAL->imho_log("imapfail", ([ "login":session->address, 
				      "command":command->cmd, "line":line,
				      "history":imaplinehist*"\n" ]));
	if (session->displayerrors) 
	  session->dialogtext += "\n"+line;

      }
      session->status = DIALOGBOX;
    }
  }


  void handle_timeout() {
    handle_error();
    command_result=-1;
    next_command();
  }

  void timeout(int s) {
    while(!zero_type(remove_call_out(handle_timeout)))
      ;
    if(s)
      call_out(handle_timeout,s);
  }

  void handle_imap_idle_timeout() {
    catch { fd->close(); }; // Close connection to IMAP server
    fd = 0;
    selected_mailbox=0;
  }

  void send_result() {
    if (id)
      id->send_result( GLOBAL->create_output( session,id ) );
  }

  void done() {
    timeout(0);
    if(!result_sent) {
      result_sent=1;
      call_out(send_result,0);
    }
  }

  void smtp_socket_close() {
    timeout(0);
    smtpfd = 0;
    if (!smtpabort)
      handle_error();
  }

  void socket_close() {
    timeout(0);
    fd = 0;
    selected_mailbox=0;
    if(!abort) {
      if (reconnects > 0) // Did we already try once?
	// other end closed unexpectedly
	handle_error();
      else {
	fd = 0;
	if (command != 0) { 
	  reconnects++; // Try to connect again
	  commands = ({ command }) + commands;
	  next_command();
	}
      }
    }
    else {
      if(!result_sent) {
	result_sent=1;
	call_out(send_result,0);
      }
    }
  }
  

  void imap_data_written() {
    int res;
    if (sizeof(imapwritedata) > 0) {
      res = fd->write(imapwritedata);
      if (res < sizeof(imapwritedata))
	imapwritedata = imapwritedata[res..];
      else
	imapwritedata = "";
    }
  }

  void smtp_data_written() {
    int res;
    if (sizeof(smtpwritedata) > 0) {
      res = smtpfd->write(smtpwritedata);
      if (res < sizeof(smtpwritedata))
	smtpwritedata = smtpwritedata[res..];
      else
	smtpwritedata = "";
    }
  }

  void smtp_got_data(mixed from, string input) {
    timeout(0); 
    bar="";
    smtpdata += input;
    while(sscanf(smtpdata,"%s%[\r\n]%s",line,bar,smtpdata) && sizeof(bar)) {
      smtp_handle_command();
    }
  }

  void got_data(mixed from, string input) {
    timeout(0);
    
    int going=1; // true when rows are available
    data += input;
    
    while(going && !abort) {
      switch(mode) {
      case MODE_LINE:
	bar="";
	if(sscanf(data,"%s%[\r\n]%s",foo,bar,data) && sizeof(bar)) {
	  line=tmp_line+foo;
	  tmp_line="";
	}
	else {
	  tmp_line+=foo;
	  line=0;
	  going=0;
	}
	break;
	
      case MODE_PARSE:
	if (GLOBAL->feature(FEAT_FASTIMHO)) {
#ifdef HAVE_FASTIMHO
	  parserstate = FastIMHO.parseimap(data, parse_type, tokens_to_get,
					   parserstate);
#endif
	  if (parserstate[0]) { // Done!
	    parse_result = parserstate[1];
	    data = parserstate[2];
	    parserstate = 0;
	    mode=MODE_LINE;
	    handle_command();
	  } else {
	    data = parserstate[2];
	    going = 0;
	  }
	} else {
	  
	  multiset blanks=(<' ','\r','\n','\t'>);
	  multiset notident = (< ' ','\r','\n','\t',')' >);
	  line=0;
	  int done=0;
	  int datapos=0;
	  if (parse_state == 1) {
	    if (parse_str_len <= sizeof(data)) {
	      parse_result = ({ parse_tmp+data[0..parse_str_len-1] }) + parse_result;
	      if (sizeof(parse_result) > 1 && parse_type != PT_TOKENS) {
		if (mappingp(parse_result[1])) {
		  if (sizeof(parse_label)) {
		    parse_result[1][parse_label] = parse_result[0];
		    parse_result = parse_result[1..];
		    parse_label = "";
		  } else {
		    parse_label = parse_result[0];
		    parse_result = parse_result[1..];
		  }
		} else {
		  parse_result[1] += ({ parse_result[0] });
		  parse_result = parse_result[1..];
		}
	      }
	      data = data[parse_str_len..];
	      parse_state = 0;
	    } else {
	      parse_tmp += data;
	      parse_str_len -= sizeof(data);
	      data = "";
	    }
	  }
	  int datasize=sizeof(data);
	  int lastn = search(reverse(data), "\n");
	  if (lastn < 0) lastn = 0;
	  int leaf = 0;
	

	  while(datapos < datasize-lastn && !done) {
	    parse_state = 0;
	    while (blanks[data[datapos]] && datapos < datasize-lastn)
	      datapos++;
	    leaf = 0;
	    switch(data[datapos]) {
	    case '(':
	      parse_level++;
	      if ((parse_level == 1) && (parse_type == PT_MAPPING)) {
		mapping m = ([ ]);
		parse_result = ({ m }) + parse_result;
	      }
	      else {
		array a = ({ });
		parse_result = ({ a }) + parse_result;
	      }
	      datapos++;
	      break;
	      
	    case ')':
	      if(!(--parse_level))
		done=1;
	      leaf = 1;
	      datapos++;
	      break;
	    	    
	    case '\"':
	      if (datapos+100 < datasize-lastn) {
		if (sscanf(replace(data[datapos..datapos+100],
				   ({ "\\\\", "\\\"" }), ({ "\\", "\\" })),
			   "\"%s\"", parse_tmp) == 0)
		  sscanf(replace(data[datapos..],
				 "\\\"", "\\"), "\"%s\"", parse_tmp);
	      } else
		sscanf(replace(data[datapos..],
			       ({ "\\\\", "\\\"" }), ({ "\\", "\\" })), 
		       "\"%s\"", parse_tmp);
	      if (parse_type==PT_QSTR)
		done=1;
	      parse_result = ({ replace(parse_tmp, 
					({"\\", "\\" }),({ "\"", "\\" })) })+
		parse_result;
		datapos += sizeof(parse_tmp)+2;
		leaf = 1;
		break;

	    case '{':
	      string junk = "";
	      if (datapos+15 < datasize-lastn)
		sscanf(data[datapos..datapos+15], "{%s}%s\n", parse_tmp, junk);
	      else
		sscanf(data[datapos..], "{%s}%s\n", parse_tmp, junk);
	      datapos += 3+sizeof(parse_tmp)+sizeof(junk);
	      parse_str_len = (int) parse_tmp;
	      if (datapos+parse_str_len <= datasize) {
		if (parse_str_len)
		  parse_result = ({ data[datapos..datapos+parse_str_len-1] }) + parse_result;
		else
		  parse_result = ({ "" }) + parse_result;
		datapos += parse_str_len;
		leaf = 1;
	      } else {
		parse_tmp = data[datapos..];
		parse_str_len -= (datasize-datapos);
		parse_state=1;
		datapos = datasize;
	      }
	      break;
	    default:
	      if (datapos +30 < datasize-lastn) {
		if (sscanf(replace(data[datapos..datapos+30], "]", ")"), "%[^ )\r\n\t]", 
			   parse_tmp) == 1 && !notident[data[datapos+sizeof(parse_tmp)]])
		  sscanf(replace(data[datapos..], "]", ")"), "%[^ )\r\n\t]", 
			 parse_tmp);
	      } else
		sscanf(replace(data[datapos..], "]", ")"), "%[^ )\r\n\t]", 
		       parse_tmp);
	      if(parse_tmp=="NIL")
		parse_result = ({ 0 }) + parse_result;
	      else {
		parse_result = ({ parse_tmp }) + parse_result;

	      }
	      datapos += sizeof(parse_tmp);
	      leaf = 1;
	    }
	    if(parse_type==PT_TOKENS && sizeof(parse_result)==tokens_to_get)
	      done=1;
	    if (leaf) {
	      if (sizeof(parse_result) > 1 && parse_type != PT_TOKENS) {
		if (parse_level == 1 && parse_type == PT_MAPPING) {
		  if (sizeof(parse_label)) {
		    parse_result[1][parse_label] = parse_result[0];
		    parse_result = parse_result[1..];
		    parse_label = "";
		  } else {
		    parse_label = parse_result[0];
		    parse_result = parse_result[1..];
		  }
		} else {
		  parse_result[1] += ({ parse_result[0] });
		  parse_result = parse_result[1..];
		}
	      }
	    }
	  }
	  data = data[datapos..];
	  if(done) {
	    if (parse_type != PT_TOKENS)
	      parse_result = parse_result[0];
	    else
	      parse_result = reverse(parse_result);
	    mode=MODE_LINE;
	    handle_command();
	  }
	  else {
	    going=0;
	  }
	}
	break;
	
        }
      if(going && (line && sizeof(line)))
	handle_command();
    }
  }


  string literal_string = 0;
  int literal_addcrlf = 0;
  int literal_continue = 0;

  string imapwrite_literal(string s,int addcrlf,int cont) {
    // addcrlf - if !0 : sends an additional \r\n after the string.
    //           usable when this string ends a command.
    // cont    - if !0 : calls handle_command after successfully
    //           sending the string
    //           NOTE! handle_command is always called if writing
    //           should fail.
    imapwrite("{" + sizeof(s) + "}\r\n");
    literal_string = s;
    literal_addcrlf = addcrlf;
    literal_continue = cont;
  }


  void handle_command() {
    if (session->debug) {
      perror("IMHO command: "+command->cmd+" : "+command_seq+"\n");
      perror("IMHO line: "+line+"\n");
    }
    if (line && sizeof(line) > 0) {
      if (sizeof(imaplinehist) > 4)
	imaplinehist -= ({ imaplinehist[4] });
      imaplinehist = ({ (sizeof(line) > 70)?line[0..69]:line }) +
	imaplinehist;
    }


    if(literal_string) {
      // see imapwrite_string above
      if(line && line[0..0]=="+") {
	imapwrite(literal_string+(literal_addcrlf?"\r\n":""));
	literal_string=0;
	if(literal_continue)
	  handle_command();
      }
      else {
	literal_string=0;
	handle_command();
      }
      return;
    }


    string cmd = "nocommand";
    if (command)
      cmd = command->cmd;
    switch(cmd) {

      //
      // LOGIN
      //
      
    case "low_login":
      switch(command_seq) {
      case 0: // expect greeting
	if(line && sscanf(line,"* OK%s",foo)) {
	  command_seq=1;
	  imapwrite(imap_tag()+" LOGIN "+IMAP_QSTRING(session->login)+" " +
		    IMAP_QSTRING(session->passwd)+"\r\n");
	}
	timeout(TIMEOUT1);
	break; // 0

      case 1: // wait for login result
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	    command_result=0;
	    session->loggedin=1;
	  }
	  else
	    command_result=-1;
	  next_command();
	}
	else
	  timeout(TIMEOUT1);
	break; // 1
      }
      break; // login
      
      //
      // SELECT FOLDER
      //

    case "low_select":
      if(sscanf(line,"* %d EXISTS%s",tmp_int,foo)==2) {
	selected_mailbox_size=tmp_int;
	timeout(TIMEOUT1);
	break; // select
      }
      if(sscanf(line,imap_tag()+" %s",foo)) {
	if (foo[0..1]=="OK") {
	  command_result=0;
	  selected_mailbox=command->mailbox;
	  next_command();
	} else {
	  command_result=-1;
	  selected_mailbox=0;
	  next_command();
	}
      }
      else
	timeout(TIMEOUT1);
      break; // low_select

      //
      // LIST FOLDERS
      //

    case "low_list":
      switch(command_seq) {
      case 0: //expect "* LIST" or command result
	if(sscanf(line,"* LIST %s",foo)) {
	  data=foo+"\n"+data;
	  init_parser(PT_LIST);
	  command_seq=1;
	}
	else
	  if(sscanf(line,imap_tag()+" %s",foo)) {
	    if(foo[0..1]=="OK") {
	      command_result=0;
	      // there should always be an INBOX...
	      if(Array.search_array(session->mailboxes,
				    lambda(array a) 
				    {
				      return (a[MB_FOLDERNAME_IDX] == "INBOX");
				    }) == -1) 
		 session->mailboxes += ({ ({ "INBOX","INBOX",
					     MB_NOINFERIORS,0,
					     ({"INBOX"})  }) });
	      // add folders that are missing in the hierarchy
	      for(int i;i<sizeof(session->mailboxes);i++) {
		if((Array.search_array(session->mailboxes,
				       lambda(array mbox_a,array hierarchy) 
				       {
					 if(sizeof(hierarchy)<2)
					   return 1;
					 if(sizeof(hierarchy)-1 != sizeof(mbox_a[MB_HIERARCHY_IDX]))
					   return 0;
					 int i;
					 for(i=0;i<sizeof(hierarchy)-1;i++)
					   if(hierarchy[i]!=mbox_a[MB_HIERARCHY_IDX][i])
					     return 0;
					 return 1;
				       },session->mailboxes[i][MB_HIERARCHY_IDX])) == -1) {
		  // add implicit folder
		  int foo=sizeof(session->mailboxes[i][MB_SEPARATOR_IDX])+
		          sizeof(session->mailboxes[i][MB_HIERARCHY_IDX][-1]);
		  string fname = session->mailboxes[i][MB_FOLDERNAME_IDX]
		    [0..sizeof(session->mailboxes[i][MB_FOLDERNAME_IDX])-1-foo];
		  string dname = session->mailboxes[i][MB_DISPLAYNAME_IDX]
		    [0..sizeof(session->mailboxes[i][MB_DISPLAYNAME_IDX])-1-foo];
		  session->mailboxes = session->mailboxes +
		    ({ ({ fname, dname, 
			  MB_NOSELECT|MB_IMPLICIT_FOLDER,session->mailboxes[i][MB_SEPARATOR_IDX],
			  session->mailboxes[i][MB_HIERARCHY_IDX]
			  [0..sizeof(session->mailboxes[i][MB_HIERARCHY_IDX])-2] }) });

		}
	      }
	      // sort mailboxes. INBOX should always be first.
	      session->mailboxes=Array.sort_array(session->mailboxes,lambda(array a1,array a2) 
						  {
						    if(a1[MB_FOLDERNAME_IDX]=="INBOX")
						      return 0;
						    if(a2[MB_FOLDERNAME_IDX]=="INBOX")
						      return 1;
						    int s1=sizeof(a1[MB_HIERARCHY_IDX]);
						    int s2=sizeof(a2[MB_HIERARCHY_IDX]);
						    int i;
						    for(i=0;i<(s1<s2?s1:s2);i++)
						      if( a1[MB_HIERARCHY_IDX][i] > 
							  a2[MB_HIERARCHY_IDX][i] )
						        return 1;
						    return(s1<s2);
						  });
	    }
	    else
	      command_result=-1;
	    next_command();
	  }
	timeout(TIMEOUT1);
	break;
	
      case 1: // we should have a list of flags now
	if(!parse_result) {
	  command_result=-1;
	  next_command();
	}
	else {
	  tmp_array=parse_result;
	  command_seq=2;
	  tokens_to_get=2;
	  init_parser(PT_TOKENS);
	  timeout(TIMEOUT1);
	}
	break; // 1
	
      case 2:
	if(!parse_result) {
	  command_result=-1;
	  next_command();
	}
	else {
	  // ({ foldername, displayname, flags, separator, displayname/separator })
	  {
	    string foldername=parse_result[1];
	    if(upper_case(foldername)=="INBOX")
	      foldername="INBOX";
	    string separator=parse_result[0];
	    int flags=0;
	    string displayname=foldername;
	    sscanf(foldername,command->path+"%s",displayname);
	    if(session->mboxencode)
	      displayname=GLOBAL->decode_mboxname(displayname);
	    if (displayname!="" && (session->showprefsbox || foldername!=session->prefsbox ) &&
		( !session->hidemboxes || ((separator ? displayname/separator : ({displayname}))
					   [-1][0..sizeof(session->hidemboxes)-1] != 
					   session->hidemboxes) ) ) {
	      array flag_a=Array.map(tmp_array,lambda(string s){return lower_case(s);});
	      if(search(flag_a,"\\noselect")!=-1)
		flags |= MB_NOSELECT;
	      if(search(flag_a,"\\noinferiors")!=-1)
		flags |= MB_NOINFERIORS;
	      session->mailboxes += ({ ({ foldername, displayname, flags, separator,
					  separator ? displayname/separator : ({displayname}) }) });
	    }
	  }


	  timeout(TIMEOUT1);
	  command_seq=0;
	}
	break; // 2
      }

      break; // low_list


      //
      // CLOSE
      // 
      
    case "low_close":

      switch(command_seq) {
      case 0:
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  // whatever
	  command_result=0;
	  selected_mailbox=0;
	  next_command();
	}
	else
	  timeout(TIMEOUT1);
	break; //0 
      }
      break; //close




      //
      // GET MAIL HEADERS
      //
      
    case "getheaders":
      switch(command_seq) {
      case 0: // expect mailheaders or command result
	if(sscanf(line,"* %d FETCH%s", fetchingno,foo) == 2) {
	  data=foo+"\n"+data;
	  init_parser(PT_MAPPING);
	  command_seq=1;
	  timeout(TIMEOUT1);
	}
	else
	  if(sscanf(line,imap_tag()+" %s",foo)) {
	    if(foo[0..1]=="OK") {
	      if(command->updatelistpos) { // Change the maillist position
		sscanf(session->visiblemail, "%d", session->visible);
		if (session->visible < selected_mailbox_size)
		  session->firstvisiblemail = selected_mailbox_size - session->visible;
		else
		  session->firstvisiblemail = 0;
	      }
	      command_result=0;
	      next_command();
	    }
	    else {
	      command_result=-1;
	      next_command();
	    }
	  }
	  else
	    timeout(TIMEOUT1);
	break; //0
	
      case 1: // expect parsed headers
	if(!parse_result) {
	  if (session->debug) {
	    perror("IMHO : IMAP parse error!\n");
	  }
	  command_result=-1;
	  next_command();
	}
	else {
	  data=line+"\n"+data;
	  set_cmd_arg(command->output, 
		      get_cmd_arg(command->output) +
		      ({ ([ "imap": parse_result, "number":fetchingno-1 ]) }));
	  set_cmd_arg(command->setsortcolumn, "num");
	  command_seq=0;
	  timeout(TIMEOUT1);
	}
	break; // 1

      }
      break; // getheaders 


      //
      // GET MAIL
      //
      
    case "getmail":
      switch(command_seq) {
      case 0: // expect data or command result
	if(sscanf(line,"* %*d FETCH%s",foo) == 2) {
	  data=foo+"\n"+data;
	  init_parser(PT_MAPPING);
	  command_seq=1;
	  timeout(TIMEOUT1);
	}
	else
	  if(sscanf(line,imap_tag()+" %s",foo)) {
	    if(foo[0..1]=="OK") {
	      command_result=0;
	      next_command();
	    }
	    else {
	      command_result=-1;
	      next_command();
	    }
	  }
	  else
	    timeout(TIMEOUT1);
	break; //0
	
      case 1: // expect parsed mapping
	if(!parse_result) {
	  command_result=-1;
	  next_command();
	}
	else {
	  data=line+"\n"+data;
	  if(parse_result->RFC822) {
	    if(command->setprefsloaded)
	      session->prefsloaded=1;
	    object mailobj = 0;
	    catch { mailobj = MIME.Message(parse_result->RFC822); } ;
	    if (!(mailobj)) {
	      // Fix a number of problems that makes the MIME module fail.
	      string mail = parse_result->RFC822;
	      mail = fixmail(mail);
	      catch { mailobj = MIME.Message(mail); };
	    }
	    set_cmd_arg(command->output, mailobj);
	  }
	  parse_result=0;
	  command_seq=0;
	  timeout(TIMEOUT1);
	}
	
	break; // 1


      }
      break; // getmail


      //
      // ADD FLAG
      //
      
    case "addflag":
      switch(command_seq) {
      case 0: // expect store command result
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	    command_result=0;
	    next_command();
	  } else {
	    command_result=-1;
	    next_command();
	  }
	}
	else
	  timeout(TIMEOUT1);
	  
	break; //0
	
      }
      break; // addflag



      //
      // DELETE MAIL
      //
      
    case "delete":
      switch(command_seq) {
      case 0: // expect store command result
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	    mailstodelete=mailstodelete[1..];
	    if(!sizeof(mailstodelete)) {
	      // all mails flagged. now expunge
	      imap_newtag();
	      imapwrite(imap_tag()+" EXPUNGE\r\n");
	      array delmails = ({ });
	      array mails = get_cmd_arg(command->updatembox);
	      if (mails) {
		foreach(indices(mails), int i)
		  if (Array.search_array(deletedmail,
					 lambda (string uid,int i,array mails)
		  { 
		    int i1=(int)uid;
		    int i2=i1;
		    sscanf(uid,"%*d:%d",i2);
		    if(((int) mails[i]->imap->UID) >= i1 &&
		       ((int) mails[i]->imap->UID) <= i2)
		      return 1;
		    return 0;
		  }
					 ,i,mails) != -1)
		    delmails += ({ mails[i] }); 
		set_cmd_arg(command->updatembox, mails - delmails);
	      }
	      command_seq=1;
	      timeout(TIMEOUT1);
	    } else {
	      // delete some more
	      imap_newtag();
	      string uid;
	      uid=mailstodelete[0];
	      deletedmail+= ({ uid });
	      imapwrite(imap_tag()+" UID STORE "+uid+" +FLAGS.SILENT (\\Deleted)\r\n");
	      timeout(TIMEOUT1);
	    }
	  }
	  else {
	    command_result=-1;
	    next_command();
	  }
	}
	else
	  timeout(TIMEOUT1);
	  
	break; //0
	
      case 1: // expect expunge result
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	    command_result=0;
	    next_command();
	  }
	  else {
	    command_result=-1;
	    next_command();
	  }
	}
	break; // 1

      }
      break; // delete


      //
      // COPY MAIL
      //
      
    case "copy":
      switch(command_seq) {
      case 0: // check COPY command result
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]!="OK") {
	    if(sscanf(foo,"NO %s",foo) && (!session->reqtrycreate || trycreate || 
					   search(foo, "[TRYCREATE]")!=-1 )) {
	      imap_newtag();
	      if(session->mboxencode)
		imapwrite(imap_tag()+" CREATE "+IMAP_QSTRING(session->copytobox)+"\r\n");
	      else {
		imapwrite(imap_tag()+" CREATE ");
		imapwrite_literal(session->copytobox,1,0);
	      }
	      command_seq = 2;
	      timeout(TIMEOUT1);
	    } else {
	      command_result=-1;
	      next_command();
	    }
	    break; //0
	  }
	} 
	else {
	  if (search(line, "[TRYCREATE]")!=-1)
	    trycreate = 1;
	  timeout(TIMEOUT1);
	  break; //0
	}

      case 1: // expect COPY command result
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	    mailstodelete+=({ mailstocopy[0] }); // if we were executing a "move"
	    mailstocopy=mailstocopy[1..];
	    if(!sizeof(mailstocopy)) {
		command_result=0;
		next_command();
	    } else {
	      // copy some more
	      imap_newtag();
	      string uid=mailstocopy[0];
	      if(session->mboxencode)
		imapwrite(imap_tag()+" UID COPY "+uid+" " + 
			  IMAP_QSTRING(session->copytobox)+"\r\n");
	      else {
		imapwrite(imap_tag()+" UID COPY "+uid+" ");
		imapwrite_literal(session->copytobox,1,0);
	      }
	      timeout(TIMEOUT1);
	    }
	  }
	  else {
	    command_result=-1;
	    next_command();
	  }
	}
	else
	  timeout(TIMEOUT1);
	break; //1

      case 2: // Retry copying after CREATE
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	    imap_newtag();
	    string uid=mailstocopy[0];
	    if(session->mboxencode)
	      imapwrite(imap_tag()+" UID COPY "+uid+" "+IMAP_QSTRING(session->copytobox)+"\r\n");
	    else {
	      imapwrite(imap_tag()+" UID COPY "+uid+" ");
	      imapwrite_literal(session->copytobox,1,0);
	    }
	    command_seq=1;
	    timeout(TIMEOUT1);
	  }
	  else {
	    command_result=-1;
	    next_command();
	  }
	}
	else
	  timeout(TIMEOUT1);
	break; //2
	
	
      }
      break; // copy
      
      
    
      //
      // LOW_APPEND
      //
      
    case "low_append":
      switch(command_seq) {

      case 0: // send appenddata
	if(line[0..0]!="+") {
	  command_seq=1;
	  handle_command();
	} else {
	  imapwrite(" ");
	  imapwrite_literal(get_cmd_arg(command->data),1,0);
	  command_seq=1;
	}
	break; //0

      case 1: // expect APPEND command result
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	    command_result=0;
	    next_command();
	  }
	  else {
	    if(sscanf(foo,"NO %s",foo) && (!session->reqtrycreate || trycreate ||
					   search(foo, "[TRYCREATE]")!=-1)) {
	      imap_newtag();
	      if(session->mboxencode)
		imapwrite(imap_tag()+" CREATE "+IMAP_QSTRING(command->tobox)+"\r\n");
	      else {
		imapwrite(imap_tag()+" CREATE ");
		imapwrite_literal(command->tobox,1,0);
	      }
	      command_seq=2;
	      timeout(TIMEOUT1);
	    } else {
	      command_result=-1;
	      next_command();
	    }
	  }
	}
	else { 
	  if (search(line, "[TRYCREATE]")!=-1)
	    trycreate = 1;
	  timeout(TIMEOUT1);
	}
	break; //1
	
      case 2: // expect create results
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	    imap_newtag();
	    if(session->mboxencode) {
	      imapwrite(imap_tag()+" APPEND "+IMAP_QSTRING(command->tobox)+" ");
	      imapwrite_literal(get_cmd_arg(command->data),1,0);
	      command_seq=4;
	    } else {
	      imapwrite(imap_tag()+" APPEND ");
	      imapwrite_literal(command->tobox,0,1);
	      command_seq=3;
	    }
	    timeout(TIMEOUT1);
	  }
	  else {
	    command_result=-1;
	    next_command();
	  }
	}
	else
	  timeout(TIMEOUT1);
	break; //2
	
      case 3: // send appenddata
	if(line[0..0]!="+") {
	  command_seq=4;
	  handle_command();
	} else {
	  imapwrite(" ");
	  imapwrite_literal(get_cmd_arg(command->data),1,0);
	  command_seq=1;
	}

	break; // 3

      case 4: // expect APPEND command result
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	      command_result=0;
	      next_command();
	  }
	  else {
	    command_result=-1;
	    next_command();
	  }
	}
	else
	  timeout(TIMEOUT1);

	break; // 4


      }
      break; // low_append


      //
      // LOW_CREATE
      //
      
    case "low_create":
      switch(command_seq) {
      case 0: // expect CREATE command result
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if(foo[0..1]=="OK") {
	    // ok. folder created
	    command_result=0;
	    next_command();
	  } else {
	    command_result=-1;
	    next_command();
	  }
	}
	else
	  timeout(TIMEOUT1);
	break; //0
	
      }
      break; // low_create

      


      //
      // DELETE FOLDERS
      //
      
    case "deletefolders":
       
      // expect DELETE command result
      if(sscanf(line,imap_tag()+" %s",foo)) {
	if(foo[0..1]=="OK") {
	  folderstodelete=folderstodelete[1..];
	  if(sizeof(folderstodelete)) {
	    imap_newtag();
	    if(session->mboxencode)
	      imapwrite(imap_tag()+" DELETE " + IMAP_QSTRING(folderstodelete[0])+"\r\n");
	    else {
	      imapwrite(imap_tag()+" DELETE ");
	      imapwrite_literal(folderstodelete[0],1,0);
	    }
	    timeout(TIMEOUT1);
	  } else {
	    command_result=0;
	    next_command();
	  }
	}
	else {
	  command_result=-1;
	  next_command();
	}
      }
      else
	timeout(TIMEOUT1);

      break; // deletefolders
    

      //
      // CHECK ACTIVE MAILBOXES
      //

    case "checkmailboxes":
      selected_mailbox = 0;
      switch (command_seq) { // Continue STATUS command after literal
      case 1: imapwrite("(UNSEEN MESSAGES RECENT)\r\n");
	command_seq = 0;
	timeout(TIMEOUT1);
	break;
      case 2:
	if (parse_result) {
	  if (parse_result->UNSEEN)
	    cmd_tmp[-1]->unseen = (int) parse_result->UNSEEN;
	  if (parse_result->MESSAGES)
	    cmd_tmp[-1]->total = (int) parse_result->MESSAGES;
	  if (parse_result->RECENT)
	    cmd_tmp[-1]->recent = (int) parse_result->RECENT;
	}
	timeout(TIMEOUT1);
	command_seq = 0;
	break;
      case 0:
	if(sscanf(line,imap_tag()+" %s",foo)) {
	  if (sizeof(mailboxestocheck) > 0) {
	    imap_newtag();
	    
	    if(session->mboxencode)
	      imapwrite(imap_tag()+" STATUS " +
			IMAP_QSTRING(session->mailboxes[mailboxestocheck[0]][MB_FOLDERNAME_IDX]) +
			" (UNSEEN MESSAGES RECENT)\r\n");
	    else {
	      imapwrite(imap_tag()+" STATUS ");
	      imapwrite_literal(session->mailboxes[mailboxestocheck[0]][MB_FOLDERNAME_IDX],0,1);
	      command_seq = 1; // Continue when literal sent
	    }
	    cmd_tmp += 
	      ({ ([ "mbox" : mailboxestocheck[0], 
		  "unseen" : 0,
		  "total" : 0, 
		  "recent" : 0 ]) });
	    if (sizeof(mailboxestocheck) > 1)
	      mailboxestocheck = mailboxestocheck[1..];
	    else
	      mailboxestocheck = ({ });
	    timeout(TIMEOUT1);
	  }
	  else {
	    // If new in current mailbox, stay
	    // otherwise jump to mailbox with new mail
	    int mboxchanged = 0;
	    foreach(cmd_tmp, mapping m) { 
	      if (session->mailboxes[m->mbox] == session->mailbox && ((int) m->unseen) > 0)
		mboxchanged = 1;
	    }
	    foreach(cmd_tmp, mapping m) { 
	      if (((int) m->unseen) > 0 && !mboxchanged) {
		session->mailbox = session->mailboxes[m->mbox];
		session->status = MAILINDEX;
		mboxchanged = 1;
	      }
	    }
	    set_cmd_arg(command->output, cmd_tmp);
	    command_result=0;
	    next_command();
	  }
	} else if(sscanf(line,"* STATUS \"%*s\" %s",foo) ||
		  sscanf(line,"* STATUS %*s %s", foo)) {
	  data=foo+"\n"+data;
	  init_parser(PT_MAPPING);
	  command_seq=2;
	  timeout(TIMEOUT1);
	} else {
	  timeout(TIMEOUT1);
	}
      }
      break; //checkmailboxes

      //
      // SEARCH
      //
      
    case "search":
       
      // expect SEARCH command result
      if(sscanf(line,imap_tag()+" %s",foo)) {
	if(foo[0..1]=="OK") {
	  command_result=0;
	  next_command();
	} else {
	  if(!searchtries++) {
	    //FIXME: only try utf-8 once for each session?
	    imapwrite(imap_tag()+" UID SEARCH CHARSET iso-8859-1 "+
		      command->searchfield+" ");
	    imapwrite_literal(Locale.Charset.encoder("iso-8859-1","")->
			      feed(command->searchtext)->drain(), 1, 0);
	    command_seq = 0;
	    timeout(TIMEOUT1);
	  } else {
	    command_result=-1;
	    next_command();
	  }
	}
      } else {
	timeout(TIMEOUT1);
	foo = "";
	if (sizeof(line)>=8 && line[0..7] == "* SEARCH") {
	  sscanf(line,"* SEARCH %s", foo);
	  array uids = ({ });
	  int uid = -1;
	  while (sscanf(foo, "%d %s", uid, foo) == 2)
	    uids += ({ (string) uid });
	  if (uid > -1)
	    uids += ({ (string) uid });
	  array mails = get_cmd_arg(command->headers);
	  mails = 
	    Array.filter(mails,
			 lambda(mapping mail, array uids) {
			   return(Array.search_array(uids,
						     lambda(string hay, 
							    string needle) {
							      return(hay == needle);
							    }, mail->imap->UID)>=0);
			       }, uids);
	  set_cmd_arg(command->headers, mails);
	}
      }

    case "nocommand": // Server info not asked for
      string response, code, text;
      if (sscanf(line, "* %s [%s] %s", response, code, text) > 0) {
	// Anything interesting?
      }
      break; // nocommand
    }
  }
  
  /////////////////////////////
  // SMTP commands
  ////////////////////////////
  void smtp_handle_command() {
    if (session->debug) {
      perror("IMHO SMTP command: "+command->cmd+" : "+command_seq+"\n");
      perror("IMHO line: "+line+"\n");
    }
    int resnr = 0;
    string code="", morecomm="";
    
    switch(command->cmd) {
      
    case "smtpopen":
      if (sscanf(line, "%d%[- ]%s", resnr, morecomm, code)) {
	if (resnr == 250 && morecomm!="-") { // Success
	  command_result=0;
	  next_command();
	} else {
	  if (resnr >= 500) {
	    command_result = -1;
	    next_command();
	  } else {
	    timeout(TIMEOUT1);
	  }
	}
      }
      else
	timeout(TIMEOUT1);
      break;
      
    case "smtpauth":
      switch (command_seq) {
      case 0: // SEND USERNAME
	if (sscanf(line, "%d%[- ]%s", resnr, morecomm, code) && 
	    morecomm != "-") {
	  if (resnr == 334) {
	    smtpwrite (MIME.encode_base64(session->login)+"\r\n");
	    command_seq = 1;
	    timeout(TIMEOUT1);
	  } else if (resnr >= 500) {
	    command_result = -1;
	    next_command();
	  } else {
	    timeout(TIMEOUT1);
	  }
	} else {
	  timeout(TIMEOUT1);
	}	  
	break;

      case 1: //SEND PASSWORD
	if (sscanf(line, "%d%[- ]%s", resnr, morecomm, code) && 
	    morecomm != "-") {
	  timeout(TIMEOUT1);
	  if (resnr == 334) {
	    smtpwrite (MIME.encode_base64(session->passwd)+"\r\n");
	    command_seq = 2;
	  } else {
	    timeout(TIMEOUT1);
	  }	  
	} else {
	    timeout(TIMEOUT1);
	}
	break;

      case 2: // Make sure we got 235
	if (sscanf(line, "%d%[- ]%s", resnr, morecomm, code)) {
	  if (resnr == 235 && morecomm!="-") { // Success
	    command_result=0;
	    next_command();
	  } else {
	    if (resnr >= 500) {
	      command_result = -1;
	      next_command();
	    } else {
	      timeout(TIMEOUT1);
	    }
	  }
	}
	else
	  timeout(TIMEOUT1);

	break;

      }
      break;

    case "smtpsend":
      switch(command_seq) {
      case 0: // MAIL FROM: or RCPT TO: results 
	//FIXME: rejection...
	if (sscanf(line, "%d%[- ]%s", resnr, morecomm, code) && 
	    morecomm != "-") {
	  if (resnr == 250 || (resnr >= 500 && resnr < 600)) {
	    while (sizeof(session->sendrecipients) && 
		   !sizeof(session->sendrecipients[0]))
	      session->sendrecipients = session->sendrecipients[1..];
	    if (sizeof(session->sendrecipients)) {
		dsn_comm="";
		if (session->dsndelay != 0)
		  dsn_comm = "DELAY";
		if (session->dsnsuccess != 0)
		  dsn_comm += (sizeof(dsn_comm)>0?",":"")+"SUCCESS";
 		if (sizeof(dsn_comm)>0)
		  dsn_comm += ",FAILURE";
		if (sizeof(dsn_comm)==0) { 
		  smtpwrite("RCPT TO:<"+session->sendrecipients[0]+">\r\n");
		  session->sendrecipients = session->sendrecipients[1..];
		  timeout(TIMEOUT1);
		} else { 
 	           smtpwrite("RCPT TO:<"+session->sendrecipients[0]+"> "
			     "NOTIFY="+dsn_comm+" ORCPT=rfc822;" + 
			     session->sendrecipients[0]+" \r\n");
 	           session->sendrecipients = session->sendrecipients[1..];
 	           timeout(TIMEOUT1);
		}
	    } else {
	      smtpwrite("DATA\r\n");
	      command_seq = 1;
	      timeout(TIMEOUT1);
	    }
	  } else {
	    timeout(TIMEOUT1);
	  }	  
	} else
	  timeout(TIMEOUT1);
	
	break;
      case 1: // DATA start send?
	if (sscanf(line, "%d%[- ]%s", resnr, morecomm, code) &&
	    morecomm != "-") {
	    if (resnr == 354)
	      {
		smtpwrite(GLOBAL->smtp_format(session->sendmail,0));
                smtpwrite(".\r\n");
		session->sendmail = 0;
		command_seq = 2;
		timeout(TIMEOUT1);
	      } else {
		if (resnr >= 500 && resnr < 600) {
		  command_result = -1;
		  next_command();
		} else    
		  timeout(TIMEOUT1);
	      }
	  }  else
	  timeout(TIMEOUT1);

	  break;
      case 2: // DATA results
	if (sscanf(line, "%d%[- ]%s", resnr, morecomm, code) &&
	    morecomm != "-") {
	  {
	    if (resnr == 250 || (resnr >= 500 && resnr < 600))
	      {
		command_result = 0;
		// KLUDGE: Remove all attachments from mem to save memory
		session->attachments = ({ }); 
		next_command();
	      }
	    else
	      timeout(TIMEOUT1);
	  }
	}  else
	  timeout(TIMEOUT1);
	break;
      }
      break;
      
    case "nocommand": // Server info not asked for
      string response, code, text;
      if (sscanf(line, "* %s [%s] %s", response, code, text) > 0) {
	// Anything interesting?
      }
      break; // nocommand
    }
  }

  void start_command(mapping com) {
    if (session->debug)
      perror("start command : "+com->cmd+"\n");
    command=com;
    command_seq=0;
    imap_newtag();

    switch(com->cmd) {

    case "low_login":
      timeout(TIMEOUT1);
      break;

    case "low_select":
      //perror("Select: "+(string) command->mailbox+"\n");
      if (command->mailbox == 0)
	command->mailbox = session->mailbox[MB_FOLDERNAME_IDX];
      if(command->mailbox == selected_mailbox) {
	command_result=0;
	next_command();
      }
      else {
	selected_mailbox_size=0;
	if(session->mboxencode)
	  imapwrite(imap_tag()+" SELECT "+IMAP_QSTRING(command->mailbox)+"\r\n");
	else {
	  imapwrite(imap_tag()+" SELECT ");
	  imapwrite_literal(command->mailbox,1,0);
	}
	timeout(TIMEOUT1);
      }
      break;

    case "low_list":
      session->mailboxes = ({ });
      imapwrite(imap_tag()+" LIST \""+command->path+"\" *\r\n");
      timeout(TIMEOUT1);
      break;

    case "low_logout":
      fd->set_close_callback(0);
      imapwrite(imap_tag()+" LOGOUT\r\n");
      catch { fd->close(); };
      fd = 0;
      selected_mailbox=0;
      command_result=0;
      abort=1;
      next_command();
      break;

    case "low_close":
      imapwrite(imap_tag()+" CLOSE\r\n");
      timeout(TIMEOUT1);
      break;

    case "getheaders":
      set_cmd_arg(command->output, ({  }));
      session->mailheadersloaded = 1;
      if(selected_mailbox && selected_mailbox_size) {
	imap_newtag();
	imapwrite(imap_tag() +
		  " FETCH 1:"+selected_mailbox_size + 
		  " (INTERNALDATE ENVELOPE UID FLAGS RFC822.SIZE)\r\n");
	timeout(TIMEOUT1);
      }
      else {
	command_result=0;
	next_command();
      }
      break;

    case "getprefsmail":
      command->uid=-1;
      foreach(indices(session->prefsmails),int i) {
	object mail=session->prefsmails[i];
	if (mail->imap->ENVELOPE[SUBJECT_IDX] ==  "IMHO Preferences")
	  command->uid = ((int) session->prefsmails[i]->imap->UID);
      }
      if(command->uid>=0) {
	command->abortfail = 0;
	command->subcommands = ({ 
	  imap_cmd("getmail", "uid", command->uid,"mailbox",session->prefsbox,
		   "setprefsloaded",1,"abortfail",1,"output",imap_cmd_var("prefsmailobj")) 
	});
	commands = ({ command }) + commands;
      }
      command_result=0;
      next_command();
      break;

    case "getmail":
      imapwrite(imap_tag()+" UID FETCH "+command->uid+" RFC822\r\n");
      timeout(TIMEOUT1);
      break;

    case "delete":
      mailstodelete=(get_cmd_arg(command->uids))+({ });
      deletedmail=({ });
      if(!sizeof(mailstodelete)) {
	command_result=0;
	next_command();
      } else {
	string uid;
	uid=mailstodelete[0];
	deletedmail+=({ uid });
	imapwrite(imap_tag()+" UID STORE "+uid+" +FLAGS.SILENT (\\Deleted)\r\n");
	timeout(TIMEOUT1);
      }
      break;

    case "move":
      // a move is a copy + a delete
      command->subcommands=
	({ imap_cmd("copy", "uids", command->uids, "updatembox", 
		    command->updatembox),
	     imap_cmd("delete", "uids", command->uids, "updatembox", 
		    command->updatembox) });
      commands=({ command }) + commands;
      command_result=0;
      next_command();
      break;

    case "copy":
      mailstocopy = ({ });
      foreach(id->misc->imho->selected, string muid)
	mailstocopy+=({ muid });
      if(!sizeof(mailstocopy)) {
	command_result=0;
	next_command();
      } else {
	string uid=mailstocopy[0];
	if(session->mboxencode)
	  imapwrite(imap_tag()+" UID COPY "+uid+" "+IMAP_QSTRING(session->copytobox)+"\r\n");
	else {
	  imapwrite(imap_tag()+" UID COPY "+uid+" ");
	  imapwrite_literal(session->copytobox,1,0);
	}
	trycreate = 0;
	timeout(TIMEOUT1);
      }
      break;
      
    case "low_create":
      if(session->mboxencode)
	imapwrite(imap_tag()+" CREATE "+IMAP_QSTRING(command->newmailbox)+"\r\n");
      else {
	imapwrite(imap_tag()+" CREATE ");
	imapwrite_literal(command->newmailbox,1,0);
      }
      timeout(TIMEOUT1);
      break;

    case "deletefolders":
      folderstodelete=({ });
      foreach(get_cmd_arg(command->folders),string mbox) {
	  folderstodelete+=({ mbox });
      }
      if (!sizeof(folderstodelete)) {
	command_result=0;
	next_command();
      } else {
	if(session->mboxencode)
	  imapwrite(imap_tag()+" DELETE "+IMAP_QSTRING(folderstodelete[0])+"\r\n");
	else {
	  imapwrite(imap_tag()+" DELETE ");
	  imapwrite_literal(folderstodelete[0],1,0);
	}
	timeout(TIMEOUT1);
      }
      break;
      
    case "low_append":
      if(session->mboxencode) {
	imapwrite(imap_tag()+" APPEND "+IMAP_QSTRING(command->tobox)+" ");
	imapwrite_literal(get_cmd_arg(command->data),1,0);
	command_seq=1;
      }
      else {
	imapwrite(imap_tag()+" APPEND ");
	imapwrite_literal(command->tobox,0,1);
      }
      trycreate=0;
      timeout(TIMEOUT1);
      break;
      
    case "addflag":
      imapwrite(imap_tag()+" UID STORE "+command->uid+" +FLAGS.SILENT ("+command->flag+")\r\n");
      command_result=0;
      timeout(TIMEOUT1);
      break;

    case "saveuserprefs":
      if(session->usersetup) {
	if(sizeof(session->prefsdir)) 
	  command->subcommands=
	    ({ imap_cmd("createprefsmail","output",imap_cmd_var("-"),"dataonly",1),
		 imap_cmd("saveprefsfile","data",imap_cmd_var("-")) });
	else
	  command->subcommands=
	    ({ imap_cmd("getheaders","mailbox",session->prefsbox,
			"output",imap_cmd_var("prefsmails"),
			"abortfail", 0),imap_cmd("createprefsmail","output",imap_cmd_var("-")),
	       imap_cmd("low_append","tobox",session->prefsbox,"data",imap_cmd_var("-")),
	       imap_cmd("delete","mailbox",session->prefsbox,"uids",imap_cmd_var("prefuids")) });
	commands = ({ command }) + commands;
      }
      command_result=0;
      next_command();
      break;

    case "saveprefsfile":
      object prefsfile=Stdio.File();
      if(prefsfile->open(session->prefsdir+"/"+lower_case(session->login)+".imhoprefs","wct")) {
	prefsfile->write(get_cmd_arg(command->data)||"");
	prefsfile->close();
      }
      else 
	report_warning("IMHO: Could not write prefsfile: "+
		       session->prefsdir+"/"+lower_case(session->login)+".imhoprefs"+"\n");
      command_result=0;
      next_command();
      break;
      
    case "createprefsmail":
      object prefsmailobj = 0;
      if(!command->dataonly) {
	prefsmailobj = MIME.Message("",
				    ([ "MIME-Version" : "1.0",
				       "Content-Type" : "text/plain; charset=UTF-8",
				       "User-Agent" : "IMHO/" + imho_version + 
				       " (Webmail for Roxen)" ]) );
	prefsmailobj->headers["to"]  = split_from_address(session->address)[0];
	prefsmailobj->headers["from"] = session->name +
	  " <"+split_from_address(session->address)[0]+">" ;
	prefsmailobj->headers["subject"] = "IMHO Preferences";
	prefsmailobj->setencoding("8bit");
      }
      foo = "2\r\n"; // Version 2
      foreach (indices(GLOBAL->prefproperties), string prop) {
	if (session[prop] && session["usersetup"+prop])
	  foo += "#"+ replace(prop +" = "+encode_pref((session)[prop]),
			      ({ "\\", "#"}), ({ "\\1", "\\2" }))+"\r\n";
      }
      if(command->dataonly) {
	set_cmd_arg(command->output,foo);
	command_result=0;
	next_command();
	break;
      }
      session->prefuids = ({ });
      prefsmailobj->setdata(TO_UTF8(foo));
      if (session->prefsmails) {
	foreach(indices(session->prefsmails),int i) {
	  object mail=session->prefsmails[i];
	  if (i < sizeof(session->prefsmails) && 
	      mail->imap->ENVELOPE[SUBJECT_IDX] ==  "IMHO Preferences") {
	    session->prefuids += ({ (int) mail->imap->UID });
	  }
	}
      }
      set_cmd_arg(command->output,(string)prefsmailobj);
      command_result=0;
      next_command();
      break;


    case "loaduserprefs":
      session->prefsmailobj=0;
      if(session->usersetup) { 
	if(!sizeof(session->prefsdir)){
	  command->subcommands = ({ 
	    imap_cmd("getheaders", "mailbox", session->prefsbox, 
		     "output", imap_cmd_var("prefsmails"), "abortfail",0),
	    imap_cmd("getprefsmail", "mailbox", session->prefsbox, 
		     "abortfail",0), imap_cmd("setprefs") });
	  commands = ({ command }) + commands;
	} else {
	  string prefs=Stdio.read_bytes(session->prefsdir + "/" + 
					lower_case(session->login)+".imhoprefs");
	  if(prefs) {
	    session->prefsmailobj=MIME.Message("");
	    session->prefsmailobj->setdata(prefs);
	    session->prefsloaded=1;
	  }
	  command->subcommands = ({ imap_cmd("setprefs") });
	  commands = ({ command }) + commands;
	}
      }
      else
	commands=({ imap_cmd("setprefs") })+commands;
      command_result=0;
      next_command();
      break;
      
    case "setprefs":
      if(session->prefsmailobj) {
	if (session->prefsmailobj->body_parts)
	  session->prefsmailobj = session->prefsmailobj->body_parts[0];
	string data=replace(session->prefsmailobj->getdata()||"","\r","");
	// UTF-8 encoded prefs starts with a '@' == prefs version 1
	// Prefs version 2 and up start with the version number
	// Prefs 2 lines start with #, and # is encoded \2 ,  \ is encoded \1
	///array (string) lines = (data[0..0]=="@"?FROM_UTF8(data):data) / "\n";
	//FIXME: sscanf doesn't work in Pike 0.6 on wide strings. decoding values separately instead.
	int utf8 = data[0..0]=="@";
	int version = 0;
	if (utf8)
	  version = 1;
	else
	  version = (int) data[0..0];
	array (string) lines;
	if (version >= 2)
	  lines= data / "\n#";
	else
	  lines= data / "\n";
	foreach(indices(lines), int i) {
	  string prop, value;
	  string line = ((version >= 2)?
			 replace(lines[i],({ "\n","\\2", "\\1" }),
				 ({ "","#", "\\" })):lines[i]);
	  if (sscanf(line, "%s = %s", prop, value ) > 0) {
	    if (GLOBAL->prefproperties[prop]) {
	      if (session["usersetup"+prop])
		session[prop] = decode_pref((version>=1)?FROM_UTF8(value):value);
	    }
	  }
	}
	if(!session->usersetupmailpath)
	  session->mailpath = session->defaultmailpath;
	if(!session->usersetupaddress)
	  session->address = session->defaultaddress;
	if(!session->usersetupsentfolder)
	  session->sentfolder = session->defaultsentfolder;
	if(!session->usersetuptrashfolder)
	  session->trashfolder = session->defaulttrashfolder;
	if(session->overridelayout)
	  session->layout = session->overridelayout;
	session->overridelayout = 0;
	session->sessionsortorder = session->sortorder;
	session->sessionsortcolumn = session->sortcolumn;
      }
      // If this is the first time for the user or he/she cannot 
      // change the full name => Fetch it from the specified place
      if (!session->prefsmailobj || !(session->usersetupname)) {
	string name=0;
	if(GLOBAL->plugin && GLOBAL->plugin->imho_default_name)
	  name=GLOBAL->plugin->imho_default_name(id,session->login);
	if(name)
	  session->name=name;
	else { 
	  switch(session->usernamemethod) {
	  case "auth module":
	    if (id->conf->userinfo) {
	      array (string) u = id->conf->userinfo(session->login, id);
	      if (u) { session->name=(u[4]/",")[0]; }
	    }
	    break;
	  case "file":
	    if(sizeof(session->namedb)) {
	      array lines=Stdio.read_bytes(session->namedb)/"\n";
	      foreach(lines,string line) {
		array a=line/":";
		if(sizeof(a)>=5 && a[0]==session->login) {
		  session->name=(a[4]/",")[0];
		}
	      }
	    }
	    break;
#if constant(Protocols.LDAP)
	    //FIXME: use ldapgetuser and reuse old query?
          case "ldap":
            name=getfullnamefromldap(session->defaultaddress);
            if(sizeof(name) > 1) { // Only set name if something was returned
              session->name = name;
            }
            break;
#endif
	  default:
	    break;
	  }
	}
      }
      command_result=0;
      next_command();
      break;
      
    case "start":
      GLOBAL->imho_log("login", ([ "login":session->address ]));
      if(session->prefsloaded || !session->usersetup)
	session->status = MAILINDEX;
      else
	session->status = SETUP;
      session->loadfiles = 1;
      command_result=0;
      next_command();
      break;
      

    case "checkmailboxes":
      array(string) mboxs = Array.map(get_cmd_arg(command->mailboxes) / ",",
				      lambda(string s) {
					while(sizeof(s) && s[0]==' ')
					  s=s[1..];
					while(sizeof(s) && s[sizeof(s)-1]==' ')
					  s=s[..sizeof(s)-2];
					return s;
				      } );
      mailboxestocheck = ({ });
      foreach(indices(mboxs), int i) { 
	mboxs[i] = translate_tombox(session, mboxs[i]);
	int mbnr = find_mailbox(session, mboxs[i]);
	if (mbnr >= 0) {
	  mailboxestocheck += ({ mbnr });
	}
      }
      cmd_tmp = ({ });
      if (sizeof(mailboxestocheck) > 0) {
	
	if(session->mboxencode)
	  imapwrite(imap_tag()+" STATUS "+
		    IMAP_QSTRING(session->mailboxes[mailboxestocheck[0]][MB_FOLDERNAME_IDX]) +
		    " (UNSEEN MESSAGES RECENT)\r\n");
	else {
	  imapwrite(imap_tag()+" STATUS ");
	  imapwrite_literal(session->mailboxes[mailboxestocheck[0]][MB_FOLDERNAME_IDX],0,1);
	  command_seq = 1; // Continue when literal sent
	}
	cmd_tmp += ({ ([ "mbox" : mailboxestocheck[0], 
		       "unseen" : 0,
		       "total" : 0, 
		       "recent" : 0 ]) });
	if (sizeof(mailboxestocheck) > 1)
	  mailboxestocheck = mailboxestocheck[1..];
	else
	  mailboxestocheck = ({ });
	timeout(TIMEOUT1);
      }
      else { 
	command_result=0;
	next_command();
      }
      break;


    case "search":
      if (command->searchtext && command->searchfield) {
	searchtries = 0;
	imapwrite(imap_tag()+" UID SEARCH CHARSET UTF-8 "+
		  command->searchfield+" ");
	imapwrite_literal(TO_UTF8(command->searchtext),1,0);
	command_seq = 0;
	timeout(TIMEOUT1);
      } else {
	command_result = 0;
	next_command();
      }
      break;

    case "smtpopen":
      if (!smtpfd) {
	smtpabort = 0;
	smtpdata = "";
	smtpfd=Stdio.File();
	smtpfd->open_socket();
	smtpfd->set_nonblocking(smtp_got_data,smtp_data_written,
				smtp_socket_close);
	smtpfd->connect(session->smtpserver,session->smtpport);
	smtpwrite("EHLO "+session->maildomain+"\r\n");
	timeout(TIMEOUT1);
      }
      else {
	command_result=0;
	next_command();
      }
      break;

    case "smtpauth":
      if (smtpfd) {
	if (query("smtpauth") != "yes") {
	  command_result=0;
	  next_command();
	} else {
	  smtpwrite ("AUTH LOGIN\r\n");
	  timeout(TIMEOUT1);
	}
      } else {
	command->subcommands=({ imap_cmd("smtpopen"), imap_cmd ("smtpauth"), 
				imap_cmd("smtpsend"), imap_cmd("smtpclose") });
	commands = ({ command }) + commands;
	command_result=0;
	next_command();
      }
      break;

    case "smtpsend":
      if (smtpfd) {
	if ((session->dsnsuccess == 0) && (session->dsndelay == 0)) {
	  smtpwrite("MAIL FROM:<"+(session->from || 
				   split_from_address(session->address)[0])+">\r\n");
	} else {
	  smtpwrite("MAIL FROM:<"+(session->from ||
				   split_from_address(session->address)[0])+"> "
		    "RET=HDRS ENVID=IMHOMSG\r\n");
	}
	timeout(TIMEOUT1);
      } else {
	command->subcommands=({ imap_cmd("smtpopen"), imap_cmd("smtpsend"), 
				imap_cmd("smtpclose") });
	commands = ({ command }) + commands;
	command_result=0;
	next_command();
      }
      break;

    case "smtpclose":
      smtpabort = 1;
      if (smtpfd) {
	catch { smtpfd->close(); };
	smtpfd = 0;
      }
      command_result=0;
      next_command();
      break;

    default:
      //oops. unimplemented command
      perror("IMHO: Unimplemented command.\n");
      command_result=-1;
      next_command();
      break;
    }
  }

 
  void next_command() {
    if (command_result < 0) { 
      if (command->abortfail) {
	if (command->container) {
	  command = command->container; // Step back
	  next_command();
	  return;
	}
	abort=1;
	commands=({ });
	handle_error();
      }
      if (command->subcommands)
	command->subcommands = ({ });
    }
    if(sizeof(commands)) {
      if (!fd) {
	fd=Stdio.File();
	fd->open_socket();
	fd->set_nonblocking(got_data,imap_data_written,socket_close);
	mixed error = catch { 
	  fd->connect(session->imapserver,session->imapport);
        };
        if (error!=0) {
	  abort=1; commands=({ }); 
	  handle_error(); 
	  done();
        }
	start_command(imap_cmd("low_login"));
      } else {
	if (session->loggedin) {
	  mapping com;
	  mapping container;
	  // Find the next command. 
	  com=commands[0];
	  while (sizeof(commands) && com->subcommands) {
	    com=commands[0];
	    container = 0;
	    while (com->subcommands && sizeof(com->subcommands)) { 
	      container = com;
	      com = com->subcommands[0];
	    }
	    if (com->subcommands) {
	      if (container)
		container->subcommands = container->subcommands[1..];
	      else
		commands=commands[1..];
	    }
	  }
	  if (sizeof(commands)) {
	    if (!com->noselect &&
		((com->mailbox  && com->mailbox != selected_mailbox) ||
		(!com->mailbox && session->mailbox[MB_FOLDERNAME_IDX] !=
		selected_mailbox))) {  // Make sure the right box is selected
	      if (com->tryselect) { // If we've already tried to select then
		// fail the command that needed the select
		if (container)
		  container->subcommands = container->subcommands[1..];
		else
		  commands=commands[1..];
		com->container = container;
		command = com;
		command_result = -1; // Muahaha
		next_command();
	      } else {
		com->tryselect = 1; // Try to select only once
		start_command(imap_cmd("low_select", "mailbox", com->mailbox, 
				       "abortfail", 0));
	      }
	    } else {
	      if (container)
		container->subcommands = container->subcommands[1..];
	      else
		commands=commands[1..];
	      com->container = container;
	      start_command(com);
	    }
	  } else {
	    command=0;
	    done();
	  }
	}
      }
    }
    else {
      command=0;
      done();
    }
  }

  int mysizeof(mixed m, void|int start) {
    int sz = 0;
    
    switch(sprintf("%O",_typeof(m))[..2]) {
    case "str":
      sz += (sizeof(m) * (String_width(m)/8)  );
      break;
    case "int":
      sz += 4;
      break;
    case "map":
    case "arr":
      foreach(values(m), mixed m2)
	sz += mysizeof(m2); 
      break;
    case "obj":
      if(start) {
	foreach(values(m), mixed m2)
	  sz += mysizeof(m2); 
      }
    }
    return sz;
  }
  
  int _sizeof() {
    return mysizeof(this_object(),1);
  }


  string _sprintf() {
    return sprintf("IMHO.imapclient()");
  }

  void create() {
    fd = 0;
    smtpfd = 0;
    command=0;
  }
  
  void destroy() {
    timeout(0);
    remove_call_out(imap_idle_call_out);
    if (fd) {
      fd->set_close_callback(0);
      fd->set_read_callback(0);
      fd->set_write_callback(0);
      catch { fd->close(); };
    }
  }
  
  void imap_command(object id_in,object session_in,
		    array (mapping) commands_in) {
    cmd_result = 0;
    abort=0;
    result_sent=0;
    command_result=0;
    reconnects=0;
    id=id_in;
    session=session_in;
    commands=commands_in;
    mode=MODE_LINE;
    id->do_not_disconnect=1;
    next_command();
  }
}



/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////


string
mailtime()
{
  int t = time();
  mapping lt = localtime(t);
  int timezone = (lt->timezone - (3600 * lt->isdst))*100/3600;
  // adjust for weird time zones (e.g., Newfoundland: -0330/-0230)
  if (timezone%100) {
    int q = abs(timezone)/100;
    int r = abs(timezone)%100;
    int s = sgn(timezone);
    timezone = s*(100*q+r*60/100);
  }
#if __VERSION__ > 7.0
  return sprintf("%s, %02d %s %d %02d:%02d:%02d %s%04d",
		 (Calendar_I.Gregorian.week_day_names[lt->wday-1])[0..2],
		 lt->mday, (Calendar_I.Gregorian.month_names[lt->mon])[0..2],
		 lt->year+1900, lt->hour, lt->min, lt->sec,
		 (timezone>=0 ? "-":"+"), abs(timezone));
#else
  return sprintf("%s, %02d %s %d %02d:%02d:%02d %s%04d",
		 (Calendar.Gregorian.week_day_names[lt->wday-1])[0..2],
		 lt->mday, (Calendar.Gregorian.month_names[lt->mon])[0..2],
		 lt->year+1900, lt->hour, lt->min, lt->sec,
		 (timezone>=0 ? "-":"+"), abs(timezone));
#endif

  /*  string wday, month;
  if (sscanf(ctime(t), "%s %s %*s", wday, month) < 2)
    return "";
  return sprintf("%s, %02d %s %d %02d:%02d:%02d %s%04d",
		 wday, lt->mday, month, lt->year+1900, lt->hour, lt->min,
		 lt->sec, -lt->timezone >=0 ? "+":"", -lt->timezone*100/3600);*/
}

string
decode_fname(string fname) {
  return replace(fname,({ "@0","@1" }),({ "@","_" }) );
}

string
encode_fname(string fname) {
  return replace(fname,({ "@","_" }),({ "@0","@1" }) );
}


//
// Modified UTF-7 encoding/decoding
//

string
decode_mboxname(string s) {
  string out="";
  int coded=0;
  string codeds="";
  string decodeds="";
  foreach(s/"",string s1) { 

    switch(s1) {
    case "&":
      coded=1;
      break;
 
    case "-":
      if(coded) {
	if(sizeof(codeds)) {
	  codeds+=({ "","===","==","=" })[sizeof(codeds)%4];
	  decodeds=MIME.decode_base64(replace(codeds,",","/"));
	  if(sizeof(decodeds)&1)
	    decodeds=decodeds[..sizeof(decodeds)-2];
	  out+=unicode_to_string(decodeds);
	} 
	else
	  out+="&";
	coded=0;
	codeds="";
      }
      else
	out+="-";
      break;
      
    default:
      if(coded)
	codeds+=s1;
      else
	out+=s1;
      break;
      
    }
  }

  if(coded) {
    if(sizeof(codeds)) {
    codeds+({ "","===","==","=" })[sizeof(codeds)%4];
    decodeds=MIME.decode_base64(replace(codeds,",","/"));
    if(sizeof(decodeds)&1)
      decodeds=decodeds[..sizeof(decodeds)-2];
    out+=unicode_to_string(decodeds);
    }
    else
      out+="&";
  }


  return out;
}

int
allowed_mbox_char(string s) {
  int i=s[0];
  return (i!='&' && i>=0x20 && i<=0x7e);
}

string
encode_mboxname(string s) {
  string out="";
  int coded=0;
  string codeds="";
  foreach(s/"",string s1) {
    if(s1=="&") {
      if(coded) {
	out+="&"+replace(MIME.encode_base64(string_to_unicode(codeds)),
			 ({ "/", "=" }),
			 ({ ",", ""  }) ) + "-";
	coded=0;
	codeds="";
      }
      out+="&-";
    }
    else {
      if(allowed_mbox_char(s1)) {
	if(coded) {
	  out+="&"+replace(MIME.encode_base64(string_to_unicode(codeds)), 
			   ({ "/", "=" }), 
			   ({ ",", ""  }) ) + "-";
	  coded=0;
	  codeds="";
	}
	out+=s1;
      }
      else {
	coded=1;
	codeds+=s1;
      }
    }
  }
    if(coded)
      out+="&"+replace(MIME.encode_base64(string_to_unicode(codeds)),
		       ({ "/", "=" }),
		       ({ ",", ""  }) ) + "-";

  return out;
}

string encode_header(string s,string|void cs) {
  //FIXME: doesn't honour the length limits, 75,76 chars.
  //       it would be very difficult due to the integral constraints
  //       for multibyte character sets
  if(!cs)
    cs = "UTF-8";
  array a1=(Locale.Charset.encoder(cs,"")->feed(s)->drain())/" ";
  array a2=Array.map(a1, lambda(string s,string cs)
			 { return MIME.encode_word(({s,cs}),"quoted-printable"); }, cs);
  array a3=Array.map(a2, lambda(string s) { return (s / "?"); } );

  for(int i=0;i<sizeof(a1);i++){
    if(a1[i]!=a3[i][3] && replace(a1[i],"_","=5F")!=a3[i][3]) { 
    //MIME word encode has changed this word
      if(i && a1[i-1][0..1]=="=?") {
	// if previous word was encoded, we encode those words as one
	a3[i][3] = a3[i-1][3]+"_"+a3[i][3];
	a1[i] = a3[i]*"?";
	a1[i-1] = "";
      }
      else
	a1[i]=a2[i];
    }
  }
  return a1*" ";
}


string
encode_addresses(array a,string cs) {
  array a2=({ });
  string s1,s2;
  foreach(a,string s) {
#if __VERSION__ > 0.6
    if(sscanf(s, "%s<%s>",s1,s2)==2)
      a2 += ({ encode_header(s1,cs)+" <"+s2+">"  });
#else
    if(sscanf(string_to_unicode(s), "%s\0<%s\0>",s1,s2)==2)
      a2 += ({ encode_header(unicode_to_string(s1),cs)+" <"+unicode_to_string(s2)+">"  });
#endif
    else 
      a2 += ({ s });
  }
  
  return a2*",";
}




void
sendmail(object session,int createonly){
  // Make a string of the mail in the session, and send it if "sendmail" 
  // is to be used. 
  // If createonly==1, the mail will be converted to a string, but no
  // other actions are taken. The mail string is found in
  // session->sendmail
  int parts=1;
  if (session->attachments)
    parts=sizeof(session->attachments)+1;
  string charset="";
  string header_charset="";
  string message="";
  mixed err=0;
  array charsets=({ });
  if(session->replytoidx !=-1 && session->replytocharset)
    charsets += ({ session->replytocharset });
  charsets +=({ "iso-8859-1",lang_charsets[session->language] });
  charsets+= ( Array.map(query("morecharsets")/",",remove_blanks) - ({ "" })  );
  charsets += ({ "utf-8" });
  foreach( charsets, charset ) {
    err=0;
    //KLUDGE: encoder for this character sets seems to allow 0x80-0xff
    if( String_width(session->message) == 8 && (<"us-ascii","us_ascii","ascii" >)[charset])
      if(search(session->message & ("\x80" * sizeof(session->message)), "\x80") != -1)
	continue;
    err=catch { message=Locale.Charset.encoder(charset)->feed(session->message)->drain();};
    if(!err)
      break;
  }


  object mail = MIME.Message("",
			     ([ "MIME-Version" : "1.0",
			      "Content-Type" : ((parts==1) ? "text/plain; charset="+charset : 
						"multipart/mixed"),
			      "User-Agent" : "IMHO/" + imho_version + 
				" (Webmail for Roxen)" ]) );

  if (session->messageid){
    mail->headers["in-reply-to"] = session->messageid;
  } 

  string headers=session->to+session->cc+session->bcc + session->name +
    " <"+ session->address + ">" + session->subject;
  foreach( charsets,header_charset) {
    err=0;
    //KLUDGE: encoder for this character sets seems to allow 0x80-0xff
    if( String_width(headers) == 8 && (<"us-ascii","us_ascii","ascii" >)[charset])
      if(search(headers & ("\x80" * sizeof(headers)), "\x80") != -1)
	continue;
    err=catch { Locale.Charset.encoder(header_charset)->feed(headers)->drain();};
    if(!err)
      break;
  }
  array addresses;
  session->sendrecipients = ({ });
  addresses = address_split(session->to);
  mail->headers["to"]  = encode_addresses(addresses,header_charset);
  session->sendrecipients += addresses;
  if (strlen(session->cc) > 0) {
    addresses = address_split(session->cc);
    mail->headers["cc"]  = encode_addresses(addresses,header_charset);
    session->sendrecipients += addresses;
  }
  if (strlen(session->bcc) > 0) {
    addresses = address_split(session->bcc);
    mail->headers["bcc"]  = encode_addresses(addresses,header_charset);
    session->sendrecipients += addresses;
  }

  foreach(indices(session->sendrecipients), int i) {
#if __VERSION__ > 0.6
    sscanf(session->sendrecipients[i], "%*s<%s>", session->sendrecipients[i]);
    sscanf(session->sendrecipients[i], "%*[ ]%s", session->sendrecipients[i]);
    if(sscanf(reverse(session->sendrecipients[i]), "%*[ ]%s", session->sendrecipients[i])==2)
      session->sendrecipients[i]=reverse(session->sendrecipients[i]);
#else
    if(sscanf(string_to_unicode(session->sendrecipients[i]),
	      "%*s\0<%s\0>", session->sendrecipients[i])==2)
      session->sendrecipients[i]=unicode_to_string(session->sendrecipients[i]);
    while(session->sendrecipients[i][0..0]==" ")
      session->sendrecipients[i]=session->sendrecipients[i][1..];
    session->sendrecipients[i]=reverse(session->sendrecipients[i]);
    while(session->sendrecipients[i][0..0]==" ")
      session->sendrecipients[i]=session->sendrecipients[i][1..];
    session->sendrecipients[i]=reverse(session->sendrecipients[i]);
#endif
  }
    
  // Do not encode the mail address. Right or wrong? Problem with "_".
  mail->headers["from"] = encode_header(session->name, header_charset) +
    " <" + (session->from || split_from_address(session->address)[0]) + ">";
  mail->headers["subject"] = encode_header(session->subject, header_charset);
  mail->headers["date"] = mailtime();
  if (query("includeipnumber")=="yes")
    mail->headers["X-Originating-IP"] = "["+session->ip+"]";

  if (sizeof(session->extraheader)) {
    string key   = "";
    string value = "";
    foreach(session->extraheader/"\n", string l) {
      string k = "";
      string v = "";
      if (sscanf(l," %s",v) && sizeof(v))
        value += v;
      else if (sscanf(l,"%s:%*[ \t]%s",k,v) > 0 &&
               sizeof(k) && sizeof(v)) {
        if (sizeof(key) && !(mail->headers[key]))
	  mail->headers[key] = value;
        key = k;
        value = v;
      }
    }
    if (sizeof(key) && !(mail->headers[key]))
      mail->headers[key] = value;
  }

  mail->setencoding("8bit");

  if(parts==1)
    mail->setdata(createonly?message:wrap_lines(message,session->wrapcolumn)); 
  else {
    mail["body_parts"]=({ });
    object mailpart = MIME.Message("",
			     ([ "MIME-Version" : "1.0",
			      "Content-Type" : "text/plain; charset="+charset ]) );
    mailpart->setencoding("8bit");
    mailpart->setdata(createonly?message:wrap_lines(message,session->wrapcolumn));
    mail->body_parts+=({ mailpart });

    foreach(session->attachments, mapping file) {
      object mailpart = MIME.Message("",
				     ([ "MIME-Version" : "1.0",
				      "Content-Type" : file->type ]) );
      mailpart->setdisp_param("filename",file->fname);
      mailpart->setparam("name",file->fname);
      mailpart->setencoding((file->type=="text/plain")?"8bit":"base64");
      if (!(file->data))
	mailpart->setdata(Stdio.read_bytes(query("uploaddir")+"/"+session->login + 
					   "_"+encode_fname(file->fname)));
      else
	mailpart->setdata(file->data);
      mail->body_parts+=({ mailpart });
    }	    
  }

  session->sendmail = (string)mail;
#ifndef __NT__
  if (!createonly && query("sendmethod") == "sendmail") {
    object in = Stdio.File("stdout");
    object out=in->pipe();
    Process.spawn(query("sendmail")+" -t -f " + session->address , out, 0, out);
    in->write(smtp_format(session->sendmail,1));
    in->close();
    session->sendmail = 0;
  }
#endif

  if (session->saveattachments != "yes") {
    if(parts>1) {
      mail->body_parts=({ mail->body_parts[0] });
    }
  }
  //FIXME: optimize: don't cast twice
  session->sentmaildata = (string)mail;
}



//
// Images
//

mapping find_internal(string f, object id)
{
  return image_cache->http_file_answer( f, id );
}


roxen.ImageCache image_cache;

mixed 
draw_image(mapping args, string text, object id) {

  object image;
  array fg=parse_color(args->fg||"white");
  array bg=parse_color(args->bg||"black");
  int size=(int)args->size||20;

  switch(args->image) {

  case "check":
    image=Image.image(size,size,@bg);
    image=image->setcolor(@fg)->polyfill( Array.map( ({ 10,50,50,90,90,10,70,20,50,80,20,40 }),
						     lambda(int i,int s) 
						     {return (int)(i*s/100); },size ) );
    break;
  case "arrowup":
  case "arrowdown":
    image=Image.image(size,size,@bg);
    image=image->setcolor(@fg)->polyfill( Array.map( ({ 20,80,80,80,50,20 }),
						     lambda(int i,int s) 
						     {return (int)(i*s/100); },size ) );
    if(args->image=="arrowdown")
      image=image->mirrory();
    break;
  case "arrownone":
    image=Image.image(size,size,@bg);
    image=image->setcolor(@fg)->polyfill( Array.map( ({ 20,60,80,60,80,40,20,40 }),
						     lambda(int i,int s) 
						     {return (int)(i*s/100); },size ) );
    break;
  case "bannerleft":
  case "bannerright":
    array clouds=parse_color(args->clouds||"white");
    string text=(args->image=="bannerright")?0:(args->text||"IMHO");
    image=Image.image(text?500:1,32,@bg);
  
    if(text) {
#if __VERSION__ > 0.6
      image=image->turbulence( ({ 0,bg,1,clouds }),3,0.1,0,0,0.7 );
      image->tuned_box(150,0,499,32,({ bg+({ 255 }),bg+({0 }),bg+({255 }),bg+({0 }) }) );
#else
      image=image->turbulence( ({ 0,bg,1,clouds }),1, 0.1 );
      image->tuned_box(150,0,499,32,({ bg+({ 0 }),bg+({255 }),bg+({0 }),bg+({255 }) }) );
#endif
    }
    image->setcolor(0,0,0 );
    for(int i=1 ; i<image->ysize() ; i+=2) {
      image->line(0, i, image->xsize()-1,i);
    }

    if(text) {
      object fnt=get_font("arial",32,0,0,"left",0.0,0.0);
      object textim=fnt->write(text);
      textim=textim->scale(40.0/textim->ysize() * 0.8);
      image->paste_alpha_color(textim->apply_matrix( ({({1,2,1}),
				       ({2,5,2}),
					 ({1,2,1})}) )
			    ,0,0,0,8,3);
      image->paste_alpha_color(textim,@fg,5,1);
    }
    break;
  case "newmail":
  case "nonewmail":
    int mail = 0;
    if (args->image == "newmail")
      mail = 1;
    image=Image.image(160,128,@bg);
  
    array envelopecolor=parse_color(args->envelopecolor||"white");
    array insideenvcolor=parse_color(args->insideenvcolor||"#808080");
    array mailcolor=parse_color(args->mailcolor||"#ffc030");
    array maillinecolor=parse_color(args->maillinecolor||"black");

#if __VERSION__ > 0.6
    image->tuned_box(16, 40, 140, 120, ({ envelopecolor + ({ 0 }),
					  envelopecolor + ({ 0 }), 
					  envelopecolor + ({ 0 }),
					  insideenvcolor+({ 0 }) }) );
    image->tuned_box(136, 40, 140, 120, ({ insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }) }) );
    image->tuned_box(16, 116, 140, 120, ({ insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }) }) );
#else
    image->tuned_box(16, 40, 140, 120, ({ envelopecolor + ({ 255 }),
					  envelopecolor + ({ 255 }),
					  envelopecolor + ({ 255 }),
					  insideenvcolor + ({ 255 }) }) );
    image->tuned_box(136, 40, 140, 120, ({ insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }) }) );
    image->tuned_box(16, 116, 140, 120, ({ insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }),
					   insideenvcolor + ({ 128 }) }) );
#endif
    
    if (!mail) {
      image->setcolor(@insideenvcolor);
      image->line(16,40,80,84);
      image->line(80,84,140,40);
    } else {
      image->setcolor(@envelopecolor);
      image->polyfill(({ 16,40, 80,84, 136,40, 80,8 }));
      image->setcolor(@insideenvcolor);
      image->polyfill(({ 20,40, 80,80, 132,40, 80,16 }));
      
      int h = 4;
      image->setcolor(@mailcolor);
      image->polyfill(({ 40,4*h, 40,52, 80,80, 116,52, 116,4*h }));
      image->setcolor(@maillinecolor);
      image->line(40,4*h,40,52);
      image->line(116,4*h,116,52);
      image->line(40,4*h,112,4*h);
      image->line(52,4*h+12,100,4*h+12);
      image->line(52,4*h+24,100,4*h+24);
    }

    break;
  default:
    image=Image.image(size,size,@bg);
  }
  return(image);
}

constant imho_img_args=({"align","border","hspace","vspace","class","alt","width","height"});

string 
tag_imho_image(string tag_name, mapping args,
	       object id,object file) {

  mapping img_args=([ ]);
  foreach(imho_img_args,string arg) {
   if(args[arg]) {
     img_args[arg]=args[arg];
     m_delete(args,arg);
   }
  }
  if(args->src && args->src!="")
    return (make_tag("img",img_args+(["src":args->src]) ));
  m_delete(args,"src");
  string num = image_cache->store( args,id );
  img_args->src=query_internal_location()+num ;
  if(tag_name=="imho_image_url")
    return img_args->src;
  mapping size = image_cache->metadata( num, id, 1 );
  if(size) {
    if(!img_args->width)
      img_args->width=(string)size->xsize;
    if(!img_args->height)
      img_args->height=(string)size->ysize;
  }
  return (make_tag("img",img_args));
}


//
//
//


array layouts = ({ });

void init_layouts() {
  string l = query("layouts");
  layouts = ({ });

  if (l) {
    array (string) lays = replace(l,"\n",",") / ",";
    foreach(lays, string lay) {
      string lfile = "", lname = "";
      if(sscanf(lay, "%*[ ]%s:%s", lfile, lname)<3)
	sscanf(lay, "%*[ ]%s", lfile);
      if (sizeof(lfile) > 0) {
	if(lname=="")
	  lname=lfile;
	layouts += ({ ([ "file":lfile, "name":lname, "modified":0, "layout":"" ]) });
      }
    }
  }
}

string get_layout(int i) {
  object lock;
  if(i < sizeof(layouts) && i>=0 && layouts[i]) {
    array fstat=(array)file_stat(layouts[i]->file);
    if (fstat) {
      if(fstat[3]>layouts[i]->modified) {
#ifdef THREADS
	lock = global_lock->lock();
#endif
	if(fstat[3]>layouts[i]->modified) {
	  layouts[i]->modified=fstat[3];
	  layouts[i]->layout=Stdio.read_bytes(layouts[i]->file);
	  if(!(layouts[i]->layout))
	    return (sizeof(layouts) && layouts[0]->layout && 
		    sizeof(layouts[0]->layout) ? layouts[0]->layout : DEFAULTLAYOUT);
	}
#ifdef THREADS
	destruct(lock);
#endif
      }
      return layouts[i]->layout;
    }
  }
  return (sizeof(layouts) && layouts[0]->layout && 
	  sizeof(layouts[0]->layout) ? layouts[0]->layout : DEFAULTLAYOUT);
}


void get_files(object session) {
  if(sizeof(query("uploaddir"))) {
    array (string) files;
    array (int) filestat;
    files=get_dir(query("uploaddir"));
    if(files) {
      string fname;
      foreach(files,string file){
	if(sscanf(file,lower_case(session->login)+"_%s",fname)) {
	  if(search(fname,"_")==-1) {
	    fname=decode_fname(fname);
	    filestat=(array)file_stat(query("uploaddir")+"/"+file);
	    session->files += ({ ([ "fname":fname, "size":filestat[1], 
				    "type": filetype(fname)  ]) });
	  }
	}
      }
    }
  }
}



void 
default_session(object session,object id) {

  session->smtpserver = query("smtpserver");
  session->smtpport = query("smtpport");
  session->debug = query("debug") == "yes";
  session->lang_progs = lang_progs;
  session->mailbox = ({ "INBOX","INBOX",MB_NOINFERIORS,0,({ "INBOX" }) });
  session->files = ({ });
  foreach(indices(prefproperties), string prop)
    session[prop] = prefproperties[prop];
  foreach(indices(prefproperties), string prop)
    session["usersetup"+prop] = 1; // User is allowed to change all (so far)
  session->name = "";
  session->lastpath = "";
  session->usersetupmailpath = feature(FEAT_USERMAILPATH);
  session->hidemboxes = query("hidemboxes");
  if(!sizeof(session->hidemboxes))
    session->hidemboxes = 0;
  session->usersetup = feature(FEAT_USERSETUP);
  session->usersetupaddress = feature(FEAT_USERADDRESS);
  session->usersetupextraheader = feature(FEAT_USERHEADERS);
  session->usersetupreplymsgprefix = feature(FEAT_USERSETREPLYPREFIX);
  session->usersetuptrashfolder = feature(FEAT_USERTRASHFOLDER);
  session->usersetupsentfolder = feature(FEAT_USERSENTFOLDER);
  session->usersetupsaveattachments = feature(FEAT_USERSENTSAVEATTACHMENTS);
  session->usersetupautobcc = feature(FEAT_USERBCCCOPY);
  session->usersetupname = feature(FEAT_USERCANCHANGENAME);
  session->usersetupactiveinboxes = feature(FEAT_USERSPECIFYINBOXES);
  session->usersetuplanguage = feature(FEAT_USERLANGUAGE);
  session->usersetupshowhiddenheaders = feature(FEAT_USERSETUPSHOWHIDDENHEADERS);
  session->sentfolder = session->defaultsentfolder = query("defaultsentfolder");
  session->trashfolder = session->defaulttrashfolder = query("defaulttrashfolder");
  session->showprefsbox = query("showprefsbox")=="yes" ? 1 : 0;
  session->prefsdir = query("prefsdir");
  session->wrapcolumn = (int) query("wrapcolumn");
  session->imapidlelogout = (int) query("imapidlelogout");
  session->displayerrors = query("displayerrors");
#ifdef THREADS
  session->lock = Thread.Mutex();
#endif
  session->language = 0;
  if(query("browserlang")=="yes" && (id->request_headers["accept-language"])) {
    mixed al = id->request_headers["accept-language"];
    if(stringp(al))
      al = al / ",";
    foreach((array)al, string foo) {
      foo=(foo/";")[0];
      if(lang_progs_short[foo]){
	session->language = lang_progs_short[foo];
	break;
      }
    }
    
  }
  if(!session->language)
    session->language = query("defaultlang");
  //FIXME: better UTF-8 detection?
  session->utf8 = 0;
  if (query("useutf-8") == "yes") {
    if(search(lower_case(id->request_headers["accept-charset"]||""),"utf-8")!=-1)
      session->utf8 = 1;
    else {
      int i;
      if((i=search(id->client,"MSIE"))!=-1)
	if(sizeof(id->client)>i)
	  session->utf8 = ((int)(id->client[i+1]))>=4;
    }
  }
    
  session->charset = session->utf8 ? "utf-8" : (lang_charsets[session->language]||"iso-8859-1");
  session->mails = ({ });
  session->cmail = 0;
  session->cmailidx = -1;
  session->cmailuid = -1;
  session->imapclient = imapclient();
  session->prefsloaded = 0;
  session->usernamemethod = query("usernamemethod");
  session->namedb = query("namedb");
  session->activemailboxinfo = ({ });
  session->mboxencode = query("mboxencode") == "encode";
  session->reqtrycreate = query("reqtrycreate") == "yes";
  session->mailboxstyle = query("mailboxstyle");
  session->ldap = feature(FEAT_LDAP);
#if constant(Protocols.LDAP)
  session->ldapserver = query("ldapserver");
  session->ldapsearchroot = query("ldapsearchroot");
#endif
}


array(mixed) register_module()
{
  return({ MODULE_LOCATION | MODULE_PARSER, "IMHO",
	   MULTILANG("IMAP Mail HOst. One of those webmail programs.<br />For more information: "
		     "<a href=\"" IMHO_HOME "\">" IMHO_HOME "</a>" ,
		     "IMAP Mail HOst. Ett snt dr webmailprogram.<br />Fr mer info: "
		     "<a href=\"" IMHO_HOME "\">" IMHO_HOME "</a>")
	   , ({}), 1});
}



#define DEFAULT_IMAPSERVERS "your.domain.com\tlocalhost"

#ifdef __ROXEN_TWO_ONE__

string make_input_tag(string name,string value,int size)
{
  string res="<input name=\""+name+"\" size=\""+size+"\"";;
  res+=" value=";
  if(!has_value(value, "\"")) res+="\""+value+"\"";
  else if(!has_value(value, "'")) res+="'"+value+"'";
  else res+="\""+replace(value, "'", "&#39;")+"\"";
  return res+" />";
}


class IMAPPrefs 
{
  inherit Variable.Variable;
  constant type="IMAPPrefs";

  static void create() {
    set_flags( VAR_INITIAL );
    _initial = DEFAULT_IMAPSERVERS;
    __name = "Incoming mail:IMAP servers";
    __doc = "List of servers to use. "
      "Optionally specify mail path to override the default IMAP mail folder path.<br />"
      "Optionally specify prefsbox to override the default prefs foldername.<br />"
      "Editing of .procmail and .forward files assumes local users.<br />";
  }

  static int _current_count = time()*100+(gethrtime()/10000);
  void set_from_form(RequestID id)
  {
    int rn, do_goto;
    array l = imap_servers(query());
    foreach(l,array foo)
      foo[2] = ([ ]);
    mapping vl = get_form_vars(id);
    // first do the assign...
    if( (int)vl[".count"] != _current_count )
      return;
    _current_count++;

    foreach( indices( vl ), string vv ) {
      //domain
      if( sscanf( vv, ".set.%d.d%*s", rn ) == 2 )
      {
        m_delete( id->variables, path()+vv );
        l[rn][0] = vl[vv];
        m_delete( vl, vv );
      }
      //imap-server
      if( sscanf( vv, ".set.%d.s%*s", rn ) == 2 )
      {
        m_delete( id->variables, path()+vv );
        l[rn][1] = vl[vv];
        m_delete( vl, vv );
      }
      //prefsbox
      if( sscanf( vv, ".set.%d.pb%*s", rn ) == 2 )
      {
        m_delete( id->variables, path()+vv );
	string s=String.trim_whites(vl[vv]);
	if(sizeof(s))
	   l[rn][2]->prefsbox = s;
        m_delete( vl, vv );
      }
      //mailpath
      if( sscanf( vv, ".set.%d.mp%*s", rn ) == 2 )
      {
        m_delete( id->variables, path()+vv );
	string s=String.trim_whites(vl[vv]);
	if(sizeof(s))
	   l[rn][2]->mailpath = s;
        m_delete( vl, vv );
      }
      //procmail
      if( sscanf( vv, ".set.%d.pm%*s", rn ) == 2 )
      {
        m_delete( id->variables, path()+vv );
	if(vl[vv]=="yes")
	   l[rn][2]->procmail = 1;
        m_delete( vl, vv );
      }
      //forward
      if( sscanf( vv, ".set.%d.fo%*s", rn ) == 2 )
      {
        m_delete( id->variables, path()+vv );
	if(vl[vv]=="yes")
	   l[rn][2]->forward = 1;
        m_delete( vl, vv );
      }
    }
    // then the move...
    foreach( indices(vl), string vv )
      if( sscanf( vv, ".up.%d.x%*s", rn ) == 2 )
      {
        do_goto = 1;
        m_delete( id->variables, path()+vv );
        m_delete( vl, vv );
        l = l[..rn-2] + l[rn..rn] + l[rn-1..rn-1] + l[rn+1..];
      }
      else  if( sscanf( vv, ".down.%d.x%*s", rn )==2 )
      {
        do_goto = 1;
        m_delete( id->variables, path()+vv );
        l = l[..rn-1] + l[rn+1..rn+1] + l[rn..rn] + l[rn+2..];
      }
    // then the possible add.
    if( vl[".new.x"] )
    {
      do_goto = 1;
      m_delete( id->variables, path()+".new.x" );
      l += ({ ({ "new.domain","imap.new.domain",([ ]) }) });
    }

    // .. and delete ..
    foreach( indices(vl), string vv )
      if( sscanf( vv, ".delete.%d.x%*s", rn )==2 )
      {
        do_goto = 1;
        m_delete( id->variables, path()+vv );
        l = l[..rn-1] + l[rn+1..];
      }
    if( do_goto )
    {
      if( !id->misc->do_not_goto )
      {
        id->misc->moreheads = ([
          "Location":Roxen.http_encode_string(id->raw_url+"?random="+
                                              random(4949494)+
                                              "&section="+
                                              id->variables->section+
                                              "#"+path()),
        ]);
        if( id->misc->defines )
          id->misc->defines[ " _error" ] = 302;
      }
    }
    set( encode_imap_servers(l) );
  }

  string render_form( RequestID id, void|mapping additional_args )
  {
    string prefix = path()+".";
    int i;

    string res = "<a name='"+path()+"'>\n</a><table>\n"
    "<input type='hidden' name='"+prefix+"count' value='"+_current_count+"' />\n";

    res += "<th>Mail Domain</th>";
    res += "<th>IMAP Server</th>";
    res += "<th>Mail path</th>";
    res += "<th>Prefsbox</th>";

    foreach( imap_servers(query()) , array serv )
    {
      string domain=serv[0];
      string server=serv[1];
      string mailpath=serv[2]->mailpath || "";
      string prefsbox=serv[2]->prefsbox || "";
      int procmail=!!serv[2]->procmail;
      int forward=!!serv[2]->forward;
      res += "<tr>\n<td><font size='-1'>" +
	make_input_tag(prefix+"set."+i+".d",domain,15) + "</font></td>\n";
      res += "<td><font size='-1'>" + 
	make_input_tag(prefix+"set."+i+".s",server,20) + "</font></td>\n";
      res += "<td><font size='-1'>" +
	make_input_tag(prefix+"set."+i+".mp",mailpath,8) + "</font></td>\n";
      res += "<td><font size='-1'>" +
	make_input_tag(prefix+"set."+i+".pb",prefsbox,8) + "</font></td>\n";
#define BUTTON(X,Y) ("<submit-gbutton2 name='"+X+"'>"+Y+"</submit-gbutton2>")
#define REORDER(X,Y) ("<submit-gbutton2 name='"+X+"' icon-src='"+Y+"'></submit-gbutton2>")
      if( i )
        res += "\n<td>"+
            REORDER(prefix+"up."+i, "/internal-roxen-up")+
            "</td>";
      else
        res += "\n<td></td>";
      if( i != sizeof( query()/"\n")- 1 )
        res += "\n<td>"+
            REORDER(prefix+"down."+i, "/internal-roxen-down")
            +"</td>";
      else
        res += "\n<td></td>";
      res += "\n<td>"+
            BUTTON(prefix+"delete."+i, "Delete" )
          +"</td>";
          "</tr>";
	  res += "<tr><td colspan='4'>"
	    "<input type=\"checkbox\" name=\""+prefix+"set."+i+".fo\" value=\"yes\"" +
	    (forward?" checked=\"checked\"":"")+" /> Enable editing of .forward files."
	    "<input type=\"checkbox\" name=\""+prefix+"set."+i+".pm\" value=\"yes\"" +
	    (procmail?" checked=\"checked\"":"")+" /> Enable editing of .procmail files."
	    "</td></tr>";

      i++;
    }
    res += 
        "\n<tr><td colspan='2'>"+
        BUTTON(prefix+"new", "New IMAP server" )+
        "</td></tr></table>\n\n";

    return res;
  }
}
#endif

#ifdef __ROXEN_TWO_ONE__

mapping query_action_buttons() {
  return ([
    "Reload all language files" : lambda() { langs_loaded = 0; },
  ]);
}

#endif

void create(mixed ... foo)
{
  if(sizeof(foo)==12){
    mapping g=foo[0];
    variables=foo[1];

    prefproperties=g["prefproperties"];
    lang_progs=g["lang_progs"];
    lang_progs_short=g["lang_progs_short"];
    lang_charsets=g["lang_charsets"];
    lang_replacement_strings=g["lang_replacement_strings"];
    langs_loaded=g["langs_loaded"];
    layouts=g["layouts"];
    sessions=g["sessions"];
#ifdef THREADS
    global_lock=g["global_lock"];
#endif
    plugin_loaded=g["plugin_loaded"];
    plugin=g["plugin"];
    global_addressbook=g["global_addressbook"];
    
    return;
  }

  adminpasswd=rand_string(20);

  set_module_url( IMHO_HOME );
#ifdef __ROXEN_TWO_ONE__
  set_module_creator( ({ "Stefan Wallstrm <stewa@lysator.liu.se>",
			 "Bosse Lincoln <lincoln@lysator.liu.se>" }) );
#else
  set_module_creator( "Stefan Wallstrm <stewa@lysator.liu.se>, Bosse Lincoln <lincoln@lysator.liu.se>" );
#endif

  defvar("location", "/mail/", "Misc:Mountpoint", TYPE_LOCATION|VAR_INITIAL,
	 "Mailreader server location.");

  defvar("loginmethod", "standard", "Misc:Login method", TYPE_STRING_LIST,
	 "FIXME.",
         ({ "standard", "http basic auth" }));

  defvar("globaladdressbook", "", "Global address book: Addresses",
	 TYPE_TEXT_FIELD, 
	 "List of addresses which will appear in all users' address books. "
	 "Format: \"&lt;name&gt;:&lt;address&gt;\", e.g \"IMHO:imho@lysator.liu.se\".\n");

  defvar("globaladdressbookfile", "", "Global address book: File",
	 TYPE_STRING, 
	 "A file containing global addressbook addresses. Can be of LDIF or "
	 "Pine format. (File in real file system or empty.)");

  defvar("layouts", "", "User interface:Layout files",
	 TYPE_TEXT_FIELD, 
	 "This file is used to define the appearance of IMHO. " 
	 "Special IMHO tags will be replaced with IMHO data. "
	 "See the README file for more info. "
	 "If this is left empty, the default layout will be used. "
         "The first specified layout file will be used as default. "
	 "This is a comma- or linefeed separated list defined as "
	 "&lt;file name&gt;:&lt;description&gt;, "
	 "&lt;file name 2&gt;:&lt;description 2&gt; etc., "
	 "where &lt;file name&gt; is a file name in the <i>real</i> file system. " );

  defvar("banner", "IMHO", "User interface:Banner text", TYPE_STRING|VAR_INITIAL,
	 "Banner text. This text is inserted on top of every page if you are "
	 "using the default layout. "
	 "Can be inserted using &lt;imho_banner&nbsp;/&gt; in a layout file.");


  defvar("displayerrors", "no", "User interface:Display IMAP errors to user", TYPE_STRING_LIST,
         "If this is set to 'yes', the IMAP error string from the server will be shown "
	 "to the user in the error dialog. The text comes from the server and cannot be "
	 "altered nor translated.",
         ({ "yes", "no" }));

  defvar("useutf-8", "yes", "User interface:Output UTF-8 (if possible)", 
	 TYPE_STRING_LIST,
         "UTF-8 is an encoding for 16-bit charcters, which is used in IMHO internally. "
	 "If this option is enabled, IMHO will output UTF-8 data to the browser if the "
	 "browser supports it. If it is disabled, the character set will be taken from "
	 "the current language file.",
         ({ "yes", "no" }));

  defvar("newusermsg", "", "User interface:New user message", TYPE_STRING,
	 "New users are first presented with the preferences screen. "
	 "This message is shown then.");



#ifdef __ROXEN_TWO_ONE__
  defvar("imapservers", IMAPPrefs() );
#else
  defvar("imapservers", DEFAULT_IMAPSERVERS , "Incoming mail:IMAP servers", 
	 TYPE_TEXT_FIELD|VAR_INITIAL,
         "List of servers to use. "
         "<i><b>Format:</b> Domain Server[:port]\t [options]</i><br />"
         "Example:\n"
         "<pre>acc.umu.se	imap.acc.umu.se<br />"
         "some.where	mail.some.where</pre>"
         "Option 'mailpath:path' to override the default IMAP mail folder path<br />"
         "Option 'prefsbox:name' to override the default Prefs foldername<br />"
         "Option 'forward' enable editing of .forward files (assumes local users)<br />"
         "Option 'procmail' enable simplified editing of .procmailrc files "
	 "(assumes local users)<br />"
         "Example:"
         "<pre>acc.umu.se	imap.acc.umu.se	prefsbox:imhoprefs,"
         "mailpath:~/mail/,forward,procmail</pre>"
         "<br />");
#endif

  defvar("imapidlelogout", 300,  "Incoming mail:Idle IMAP connection timeout", TYPE_INT,
	 "Close an open IMAP connection after this many seconds. The user session may still "
	 "be active, and will not be disturbed. The IMAP connection will be reopened when "
	 "the user issues an IMAP command.");

  defvar("mboxencode", "encode", "Incoming mail:Mailbox addressing", TYPE_STRING_LIST,
         "Chooses wether IMHO should use IMAPs modified UTF-7 coding when refering "
	 "to mailboxes or if it should send mailbox names unmodified. If you're having trouble "
	 "accessing mailboxes with non-USASCII characters, try changing this option.",
         ({ "encode", "8-bit" }));

  defvar("mailboxstyle", "Default", "User interface dialogs:Mailboxes - Mailbox listing style",
  	 TYPE_STRING_LIST,
  	 "Choose the style of the mailbox listing.",
  	 ({ "Default", "Plus" }));

  defvar("defaultmailpath", "", "Incoming mail:Default IMAP mail folder path", 
	 TYPE_STRING|VAR_INITIAL,
	 "The default mail folder path. Is usually \"~/mail/\" or empty. "
	 "Can be changed by the user, although the user's preferences is always saved "
	 "here.<br><b>Note:</b> If you choose this to be empty, the IMAP server may try "
	 "to list all files in your home directory, which takes a very long time "
	 "-- it may seem as Roxen/IMHO has crashed although it has not.");

  defvar("hidemboxes", "", "Incoming mail:Hide mailboxes starting with", 
	 TYPE_STRING,
	 "Optionally hide mailboxes starting with the specified string. "
         "Mailboxes starting with '.' are often not really mailboxes.");

  defvar("reqtrycreate", "no", "Incoming mail:Require [TRYCREATE]", TYPE_STRING_LIST,
	 "If set to yes, IMHO will not try to create folders when [TRYCREATE] hints are "
	 "supposed to be sent but are not. Set to no for compatibility with buggy servers "
	 "like Courier.",
         ({ "yes", "no" }));

#if constant(Protocols.LDAP)
  defvar("ldapimapsearch", "no", "Incoming mail:IMAP server from LDAP",
	 TYPE_STRING_LIST,
	 "Use LDAP for seaching users imapservers. Override default "+
         "IMAP server.<br />Note: all servers found from LDAP must be listed "+
         "in \"IMAP Servers\" for mail domain specific setting.",
	 ({"yes", "no"}));

  defvar("ldapimapsearchaddress", "no", "Incoming mail:Set user address from LDAP",
	 TYPE_STRING_LIST,
	 "Use LDAP for seaching users mail address.",
	 ({"yes", "no"}));

  defvar("ldapimapattr", "mailhost", "Incoming mail:LDAP user attribute for IMAP server",
	 TYPE_STRING,
	 "LDAP user attribute for IMAP server.");

  defvar("ldapmailattr", "mail", "Incoming mail:LDAP user attribute for address",
	 TYPE_STRING,
	 "LDAP user attribute for mail address.");

  defvar("ldapimapfilter", "(&(objectclass=person)(uid=%u%))",
	 "Incoming mail:IMAP filter",
	 TYPE_STRING,
	 "LDAP search filter template. <br /><b>%u%</b>: will be replaced by entered username.");
#endif

#ifndef __NT__
  defvar("sendmethod", "SMTP", "Outgoing mail:Method", TYPE_STRING_LIST,
         "Method to use when sending mail.",
         ({ "SMTP", "sendmail" }));

  defvar("sendmail", "/usr/lib/sendmail", "Outgoing mail:Sendmail", 
	 TYPE_STRING,
	 "Location of sendmail.");
#endif

  defvar("smtpserver", "localhost", "Outgoing mail:SMTP server address", 
	 TYPE_STRING|VAR_INITIAL,
	 "The address of the SMTP-server.");

  defvar("smtpport", 25,  "Outgoing mail:SMTP server-port", TYPE_INT,
	 "The portnumber of the SMTP-server.");

  defvar("smtpauth", "no", "Outgoing mail:Use SMTP Authentication", TYPE_STRING_LIST,
	 "If yes, the user's credentials will be supplied to SMTP when sending mail.", 
	 ({"yes", "no"}) );

  defvar("includeipnumber", "no", "Outgoing mail:Show IP-address", TYPE_STRING_LIST,
         "Include the header field 'X-Originating-IP' in outgoing mail "
	 "to indicate from where the mail was sent.",
         ({ "yes", "no" }));

  defvar("addmaildomain", "yes", "Outgoing mail:Complete unqualified addresses", TYPE_STRING_LIST,
         "If this is enabled, the default mail domain will be added to addresses "
	 "without a \"@\" before sending them to the SMTP server.",
         ({ "yes", "no" }));

  defvar("ssl3redir", "no", "URL:Redirect to SSL3", TYPE_STRING_LIST,
         "Tries to find a SSL3 port to redirect the initial requests to. Useful if your virtual "
	 "server has more than one listen port and you prefer SSL3 for IMHO.",
         ({ "yes", "no" }));

  defvar("urloverride", "", "URL:Server URL override", TYPE_STRING,
	 "Specify your server URL here if IMHO fails to guess the correct URL."
	 " Example: 'https://your.server.com'.");

  defvar("uploaddir", "", "Files:File upload directory", TYPE_STRING,
         "Directory to hold uploaded attachment files. Leave empty to disable "
	 "persistent attachment support. ");

  defvar("uploadquota", 0, "Files:File upload user quota", TYPE_INT,
         "Amount of Kb each user is allowed to upload. 0 gives unlimited quota.");

  defvar("uploadsoftquota", 0, "Files:File upload soft user quota", TYPE_INT,
         "Amount of Kb by wich the user can overrun the quouta for the last uploaded file.");

  defvar("maxmailsize", 50000,  "User interface:Max mail size", TYPE_INT,
	 "If the mail data exeeds this size (in bytes), "
	 "it will only be shown as a download link.");

  defvar("langfiledir", "", "User interface:Language files directory", TYPE_STRING,
         "The directory where you store the language files (imho_*.pike)."
	 "You can leave this empty if you're only going to use english.");

  defvar("defaultlang", "english", "User interface:Default language", TYPE_STRING,
	 "The default language for users. The language at the login prompt."
         "This is the name of the language as it's presented at the user "
         "preferences screen.");

  defvar("browserlang", "yes", "User interface:Default language from browser", TYPE_STRING_LIST,
         "Decides wheter the default language should be selected from the browser's "
         "settings if possible. If all your users use the same langauge you may want "
         "to disable this, since many users don't bother changing their language "
         "preferences in their browsers.",
         ({ "yes", "no" }));

  defvar("ispell",
#ifndef __NT__ 
	 file_stat("/usr/bin/ispell")?"/usr/bin/ispell":"",
#else
	 "",
#endif
	 "Spelling:Speller location", TYPE_STRING,
         "Location of ispell binary. Empty string disables spell-checking.");

  defvar("ispelldict", "american", "Spelling:Speller dictionaries",TYPE_STRING,
         "Commaseparated list of speller dictionaries, default first."
	 "(-d option). Display name can be specified after a colon (swedish:Svenska).");

  defvar("speller", "ispell", "Spelling:Spellchecker", TYPE_STRING_LIST,
         "IMHO supports ispell and aspell. ",
         ({ "ispell", "aspell" }));

  defvar("usernamemethod", 
#ifndef __NT__
	 "file", 
#else
	 "none",
#endif
	 "User names:Method", TYPE_STRING_LIST,
	 "Chooses method to set the users names.",
         ({ "file", "auth module","none"
#if constant(Protocols.LDAP)
            ,"ldap"
#endif 
            }));

  defvar("namedb", 
#ifndef __NT__
	 "/etc/passwd", 
#else
	 "",
#endif
	 "User names:File", TYPE_STRING,
         "If Method is set to file, this file is "
	 "searched for the users real name. Format: lines like "
	 "'login::::Real Name' (like in /etc/passwd). ");

  defvar("addressbook", "yes", "Features:Addressbook", TYPE_STRING_LIST,
	 "Enables the addressbook. Addressbook is disabled if User setup is.",
	 ({"yes","no" }));

  defvar("attachments", "yes", "Features:Attachments", TYPE_STRING_LIST,
	 "Enables sending of attachments.",
	 ({"yes","no" }));

  defvar("usermailpath", "no", "Features:User mail path", TYPE_STRING_LIST,
	 "Determines if users should be allowed to set the mail folder. Is disabled if "
	 "User setup is.",
	 ({"yes","no" }));

  defvar("mailboxes", "yes", "Features:Mailboxes", TYPE_STRING_LIST,
	 "If disabled, only INBOX can be accessed.",
	 ({"yes","no" }));

  defvar("usersetup", "yes", "Features:User setup", TYPE_STRING_LIST,
	 "If enabled, each user has a setup (including addressbook, signature etc.) "
	 "saved either in a mailbox or in a file."
	 "Is disabled if mailboxes is disabled and User preferences directory is empty.",
	 ({"yes","no" }));

  defvar("usereditsetup", "yes", "Features:User can change setup", TYPE_STRING_LIST,
	 "Determines if the users should be able to change their own setup. "
	 "This option is ignored if \"User setup\" is disabled.",
	 ({"yes","no" }));

  defvar("inboxes", "yes", "Features:User specified inboxes", TYPE_STRING_LIST,
	 "Lets the user specify a list of inboxes which may be presented "
	 "as a list in the user interface. ",
	 ({"yes","no" }));

  defvar("useraddress", "no", "Features:User specified address", TYPE_STRING_LIST,
	 "Enables a user to change his/her email address in the user setup.",
	 ({"yes","no" }));

  defvar("mailnotify", "yes", "Features:Mail notification window", TYPE_STRING_LIST,
	 "Enables a user to open a mail notification window which is reloaded periodically "
	 "(every five minutes). This feature is is built on javascript in the layout file, "
	 "so make sure you use an updated layout file.",
	 ({"yes","no" }));

  defvar("showhtml", "yes", "Features:Show HTML messages", TYPE_STRING_LIST,
	 "Enables a user to have messages in HTML format shown instead of "
	 "of the corresponding text version. HTML messages are parsed and "
	 "reformatted so that no unsecure HTML tags are displayed. For "
	 "example, links to mailparts are handled but all other links are "
	 "removed. Javascript is not allowed. "
	 "The parsing may be rather CPU-intensive.",
	 ({"yes","no" }));


  defvar("userheaders", "no", "Features:User specified mail headers", TYPE_STRING_LIST,
	 "Enables a user to add extra headers to outgoing mail.",
	 ({"yes","no" }));

  defvar("prefsdir", "", "User preferences:User preferences directory", TYPE_STRING,
         "Directory to hold user preferences. If this one is an empty string, user preferences "
	 "will be saved in a mail folder. ");

  defvar("prefsbox", ".imhoprefs", "User preferences:User default preferences folder", 
	 TYPE_STRING,
         "Mail folder to hold user preferences. Relative to the default mail folder path. "
	 "This option can be overridden by a different setting in the IMAP server list.");

  defvar("showprefsbox", "no", "User preferences:Show user preferences folder", TYPE_STRING_LIST,
	 "If \"no\", the preferences folder is not displayed.",
	 ({"yes","no" }));

  defvar("deletemethod", "move to trash", "Features:Delete method", TYPE_STRING_LIST,
	 "Choosed wether mail is deletede immediately or moved to a trash folder first, or "
         "wether both methods should be available.",
	 ({"both","move to trash","delete immediately" }));
  
  defvar("usercanchangename","yes","Features:User can change name", TYPE_STRING_LIST,
         "Enables users to change his/her name in the configuration "
	 "interface.",({ "yes","no" }));
  
  defvar("userlanguage", "yes", "Features:User can choose language", TYPE_STRING_LIST,
	 "Enable a user to choose a different language than the one setup in the configuration "
	 "interface.",
	 ({"yes","no"}));
  
  defvar("usertrashfolder","yes", "Features:User can specify trash folder", TYPE_STRING_LIST,
         "Enable a user to specify the name of the trash folder other than <i>\"Trash\"</i>.",
	 ({"yes","no"}));
  
  defvar("usersentfolder","yes", "Features:User can specify sentmail folder", TYPE_STRING_LIST,
         "Enable a user to specify the name of the sent-mail folder other than "
	 "<i>\"sent-mail\"</i>.",
	 ({"yes","no"}));
  
  defvar("userbcccopy","yes", "Features:User can specify a default Bcc", TYPE_STRING_LIST,
         "When enabled, user can specify a BCC address to be added to all outgoing mail.",
	 ({"yes","no"}));
  
  defvar("showhiddenheaders","yes", "Features:User configurable 'show full headers'-button", 
	 TYPE_STRING_LIST,
         "When reading a mail, users can show or hide the hidden headers of the mail. "
	 "If this option is enabled, the user can choose whether to show or hide this button.", 
	 ({"yes","no"}));

  defvar("usersentsaveattachments","yes","Features:User can choose to save attachments",
	 TYPE_STRING_LIST,
         "Enable a user to secify to save the attachments in the sentmail folder.<br><b>Note:</b>"
	 " if the sent mail folder cannot be specified, then this feature is automaticly disabled"
	 " and the attachement <b>will</b> be saved into sentmail folder.",
	 ({"yes","no"}));

  defvar("userspecifyinboxes","yes","Features:User can specify inboxes", TYPE_STRING_LIST,
         "Enable the user to specify which mailboxes to treat as inboxes.", ({"yes","no"}));

  defvar("chgreplymsgprefix",1,"Features:User can change reply prefix",TYPE_FLAG,
	 "If set, then user can change the default prefix added to lines of message they "
	 "reply to.");
  
  defvar("debug", "off", "Misc:Debug", TYPE_STRING_LIST,
	 "When on, debug messages will be logged in Roxen's debug logfile. "
	 "This information is very useful to the developers when fixing bugs.", 
	 ({"on","off" }));

#if constant(Protocols.LDAP)
  defvar("ldap", "no","LDAP:Enable LDAP search", TYPE_STRING_LIST,
	 "Enables a user to search for names in a ldap directory",
	 ({"yes","no"}));
  
  defvar("ldapserver", "localhost", "LDAP:LDAP server" , TYPE_STRING,
	 "Specifies the ldap server to use.");
  
  defvar("ldapsearchroot", "", "LDAP:Search root",TYPE_STRING,
	 "The searchroot for ldap searches. "
	 "For example: o=Your company, c=your country. "
	 "Could be empty");
  
  defvar("ldapuser", "", "LDAP:User", TYPE_STRING,
	 "The user you should use connect. NOTE! This is ldap user format. Could be empty");
  
  defvar("ldappass", "", "LDAP:Password", TYPE_STRING,
	 "The password you should use to connect. Could be empty.");
  
  defvar("ldapshowou", "yes", "LDAP:Show ou", TYPE_STRING_LIST,
	       "If \"yes\" include last level ou in result", ({"yes","no"}));

#endif
  defvar("dsn", "no", "Outgoing mail:DSN support", TYPE_STRING_LIST,
 	 "Add DSN (Delivery Status Notification) support when sending mail. "
	 "This requires the use of SMTP for outgoing mail (instead of sendmail). "
	 "You also have to make sure your SMTP server supports DSN.",
 	 ({"yes","no" }));

  defvar("wrapcolumn", 70, "Outgoing mail:Wrap line column", TYPE_INT,
	 "Wrap outgoing message lines at this column. If set to zero, no wrapping "
	 "will take place.");

#ifdef HAVE_FASTIMHO
  defvar("fastimho", "yes", "Misc:Use FastIMHO Pike module", TYPE_STRING_LIST,
         "You have the 'FastIMHO' Pike module in your system. "
	 "If you let IMHO use it, some operations like "
	 "IMAP parsing will be <b>much</b> faster.", 
         ({ "yes", "no" }));
#endif

  defvar("allowipchange", "yes", "Misc:Allow changing user IP-address", TYPE_STRING_LIST,
	 "Should IMHO allow one session to use different IP addresses? "
	 "If some users are using dynamic addresses which change even during a session "
	 "(e.g. while composing mail) then this option should be \"yes\". A reason to "
	 "set it to \"no\" is that a stolen session id (from cookie- or log file) cannot "
	 "easily be used from a remote machine.",
         ({ "yes", "no" }));

  defvar("adminlogin", "", "Runtime admin interface:Login Name", TYPE_STRING, 
	 "The IMHO Runtime Administration Interface can be reached by logging "
	 "in using this login name and the specified password.");

  defvar("adminpasswd", "", "Runtime admin interface:Password", TYPE_PASSWORD, 
	 "The IMHO Runtime Administration Interface can be reached by logging "
	 "in using this password and the specified login name.");

  defvar("adminshowsize", "no", "Runtime admin interface:Show session sizes", TYPE_STRING_LIST, 
	 "With this option set to 'yes', the runtime admin interface will show an esitimate "
	 "of each sessions memory consumption. This is a rather costly operation, so the default "
	 "setting will be 'no'.",
	 ({"yes","no" }));

  defvar("logfile", "", "Logging:Log file name", TYPE_STRING, 
	 "The file name of the log file in the real file system."
	 " If this is empty, logging is disabled.");

  defvar("loglogin", "yes", "Logging:Log login and logout", TYPE_STRING_LIST,
	 "Log information on users logging in and out.",
         ({ "yes", "no" }));

  defvar("logsendmail", "yes", "Logging:Log sending of mail", TYPE_STRING_LIST,
	 "Log information on all messages sent by users.",
         ({ "yes", "no" }));

  defvar("logerrors", "yes", "Logging:Log errors", TYPE_STRING_LIST,
	 "Log information on all errors that occur regarding IMAP and SMTP.",
         ({ "yes", "no" }));

  defvar("plugin", "", "General purpose plugin", TYPE_STRING|VAR_EXPERT,
         "Experimental plugin.");

  defvar("morecharsets", "", "Outgoing mail:Character sets",TYPE_STRING,
         "Commaseparated list of charctersets wich IMHO tries to use "
	 "for outgoing mail before the last resort, UTF-8. IMHO first tries "
	 "to fit the mail into the same characterset used by the mail the user "
	 "replied to. Then it tries iso-8859-1, the charcterset of the "
	 "active language file, this list of charactersets and UTF-8. "
	 "Specify those charactersets your users usually use to avoid their "
	 "mail being sent as UTF-8.");


  defvar("dateformat","YY:MM:DD","User interface dialogs:Folder index - Date format", 
	 TYPE_STRING_LIST,
	 "Choose your date format.",
	 ({"DD:MM", "MM:DD", "DD:MM:YY", "MM:DD:YY", "YY:MM:DD", "YY:DD:MM", 
	   "DD:MM:YYYY", "MM:DD:YYYY", "YYYY:MM:DD"}) );

  defvar("datesep","-","User interface dialogs:Folder index - Date separator", TYPE_STRING_LIST,
	 "Choose the separator character (represented by ':' in the above list) "
	 "for date display.",
	 ({"none", ":", "/", "-"}));

  defvar("timeformat","HH:MM (24-hour)","User interface dialogs:Folder index - Time format", 
	 TYPE_STRING_LIST,
	 "Choose your time format. x equals a or p.  xx equals am or pm.", 
	 ({"none", "HH:MM (24-hour)", "HH:MM:SS (24-hour)", "HH:MMx (12-hour)",
	   "HH:MM xx (12-hour)", "HH:MM:SS xx (12-hour)"}) );

  defvar ("datetimesep","space","User interface dialogs:Folder index - Date/time separator", 
	  TYPE_STRING_LIST, 
	  "The text to use to separate the date and time.", 
	  ({"space", "dash", "slash","space-slash-space", "space-dash-space"}) );


  defvar("signaturecols","55","User interface dialogs: Pages - Setup page, size of signature",
	 TYPE_STRING,
         "Change the max line length for signature box in the preferences page");

 defvar("replyseparator","-------------------","Outgoing mail:Reply Separator", TYPE_STRING,
        "Text separator for reply / reply to all messages.");

 defvar("forwardseparator","------ Forwarded message -------","Outgoing mail:Forward Separator",
	TYPE_STRING,
        "Text separator for forward messages.");

 defvar("composesavemail","yes",
	"Outgoing mail:By default save composed mail into sentmail folder", TYPE_STRING_LIST,
        "If enabled, mail will by default be saved when sending, but a checkbox with "
	"'Don't save this mail' is shown. If disabled, mail will not be sent by default.", 
	({"yes","no"}));

 defvar("defaultsentfolder","sent-mail","Outgoing mail:Default sent mail folder", TYPE_STRING,
        "The default name of the user's sent mail folder (if used).");

 defvar("defaulttrashfolder","Trash","Outgoing mail:Default trash folder", TYPE_STRING,
        "The default name of the user's trash folder (if used).");

  // **XB**

  // Compatibility variables

  defvar("imapserver", "localhost", "Incoming Mail:IMAP server address.", 
	 TYPE_STRING|VAR_EXPERT,
	 "FOR COMPATIBILITY ONLY. DON'T USE! The address of the IMAP-server.");
  defvar("imapport", 143,  "Incoming Mail:IMAP server-port", 
	 TYPE_INT|VAR_EXPERT,
	 "FOR COMPATIBILITY ONLY. DON'T USE! The portnumber of the IMAP-server.");
  defvar("maildomain", "your.domain.com", "Outgoing Mail:Default mail domain", 
	 TYPE_STRING|VAR_EXPERT,
	 "FOR COMPATIBILITY ONLY. DON'T USE! The default mail domain, i.e the string "
	 "after the '@' in the mail address in outgoing mail.");

 // 

  imho_log("startup", 0);

}

void
destroy() {
}

void 
destroy_clients() {
  foreach(indices(sessions),string s)
    if(sessions[s]->imapclient)
      destruct(sessions[s]->imapclient);
}

string check_variable(string var,mixed value) {

  switch(var) {

  case "uploadquota":
  case "uploadsoftquota":
    if (value <0)
      return "Must be positive integer or zero.";
    break;

  case "prefsdir":
  case "uploaddir":
    if(sizeof(value)) {
      array stat=(array)file_stat(value);
      if(!stat || stat[1]!=-2)
	return "Must be a directory or empty string.";
    }
    break;

#ifndef __ROXEN_TWO_ONE__
  case "imapservers":
    if (sizeof(value/" ") < 2 && sizeof(value / "\t") < 2)
      return("Must contain at least one server in format 'domain imapserver'");
    break;
#endif

  case "ispell":
    {
      if(!sizeof(value))
	break;
      array stat=(array)file_stat(value);
      if(!stat || !(stat[0] & 73))
	return "Must be empty or an executable file.";
    }
    break;

  case "ispelldict":
    if(!sizeof(value))
      return "Must not be empty.";
    break;


  case "sendmail":
    if(query("sendmethod")=="SMTP")
      break;
    {
      array stat=(array)file_stat(value);
      if(!stat || !(stat[0] & 73))
	return "Must be an executable file.";
    }
    break;
    
  case "langfiledir":
    langs_loaded=0;
    break;

  case "layouts":
    init_layouts();
    break;


  case "plugin":
    {
      if(!sizeof(value))
	break;
      plugin_loaded=0;
      plugin=0;
      array stat=(array)file_stat(value);
      if(!stat)
	return "Must be empty or existing file.";
    }
    break;



  }
  return 0;
}


mapping my_mkmapping(array a1,array a2) {
  int i = (sizeof(a1) < sizeof(a2)) ? sizeof(a1) : sizeof(a2);
  return mkmapping(a1[..i-1], a2[..i-1]);
}

string trim_quotes(string s) {
  int i = sizeof(s);
  if( s[i-1..i-1] == "\"" && s[0..0] == "\"")
    s = s[1..i-2];
  return s;
}

array csv_line_to_array(string line) {
  //FIXME: quoting
  line = line - "\0";
  array a = line / "\"";
  for (int i=1; i < sizeof(a); i+=2)
    a[i] = replace(a[i],",","\0");
  array a2 = (a * "\"") / ",";
  
  return replace(Array.map(a2, lambda(string s) { s = remove_blanks(s); s = trim_quotes(s); return s; } ) ,
		 "",0);
}
		   
  
string import_outlook_csv(string abook)
{
  array ab = ({ });
  array a = abook / "\n";
  
  array idx = csv_line_to_array( a[0] );

  foreach(a[1..], string line) {
    mapping m = my_mkmapping( idx, csv_line_to_array( line ) );
    if( ( m["First Name"] || m["Last Name"] ) && m["E-mail Address"] ) {
      string s = m["First Name"] || "";
      if( m["Last Name"] )
	s += " " + m["Last Name"];
      s = s + ":" + s + " <" + m["E-mail Address"] + ">";
      ab += ({ s });
    }
  }
    
  return(ab * "\n" );
}

string import_pinebook(string abook)
{
  string ab = "";
  array (string) words = ({ "", "", "" });
  int i = 0;
  while(sscanf(abook,"(%s)%s",words[i],abook) ||
	sscanf(abook, "%[^\t\n]%*c%s", words[i], abook) > 1) {
    i++;
    if (sizeof(abook) && abook[0] == '\n')
      abook = abook[1..];
    if (i > 2) {
      i = 0;
      words[2] = replace(words[2], "\n", "");
      array names=Array.map(ab/"\n",lambda(string s){return ((s/":")[0]);});
      string name=words[0];
      int no=0;
      while(search(names,name+(no?" - "+(string)no:""))!=-1)
	no++;
      if(no)
	name+=(" - "+(string)no);
      if (sizeof(ab))
	ab += "\n"+name+":"+words[2];
      else
	ab = name+":"+words[2];
    }
  }
  return(ab);
}

string import_addressbook(string file) {
  string ab = "";
  string adds = replace(file, "\r", "");
  array (string) lines = adds / "\n";
  if (sizeof(lines) > 0) {
    string name="", address="";
    //FIXME: improve detection
    if ( (search(lines[0],"First Name") != -1) && 
	 (search(lines[0],"Last Name") != -1) && 
	 (search(lines[0],"E-mail Address") != -1))
      ab = import_outlook_csv(adds);
    if (sscanf(lines[0], "%s\t%s", name, address) == 2)
      ab = import_pinebook(adds);
    else if (sscanf(lines[0], "dn: %s", address) == 1)
      ab = import_ldifbook(adds);
  }
  return(ab);
}


string import_ldifbook(string abook){
  string ab = "";
  array (string) lines = abook / "\n";
  string name = "", address = "", data, type;
  int i = 0;

  while(i < sizeof(lines)) {
    if (sscanf(lines[i], "%s: %s", type, data) == 2) {
      if (type == "dn") {
	if (sizeof(name) > 0) {
	  if (sizeof(ab) > 0)
	    ab += "\n"+name+":"+address;
	  else
	    ab = name+":"+address;
	}
	name = "";
	address = "";
	if (sscanf(data, "cn=%s,mail=%s", name, address) < 2)
	  sscanf(data, "cn=%s", name);
      }
      if (type == "member") {
	string na = "", ad = "";
	sscanf(data, "cn=%s,mail=%s", na, ad);
	if (sizeof(ad) > 0) {
	  if (sizeof(address) > 0)
	    address += ", "+ad;
	  else
	    address = ad;
	}
      }
    }
    i++;
  }
  if (sizeof(name) > 0) {
    array names=Array.map(ab/"\n",lambda(string s){return ((s/":")[0]);});
    int no=0;
    while(search(names,name+(no?" - "+(string)no:""))!=-1)
      no++;
    if(no)
      name+=(" - "+(string)no);
    if (sizeof(ab))
      ab += "\n"+name+":"+address;
    else
      ab = name+":"+address;
  }
  return(ab);
}


string status() {
  string user;
  if(query("loginmethod") == "http basic auth")
    user = query("adminlogin") + ":" + adminpasswd;
  return "Sessions: "+sizeof(sessions)+"<br />"
    "Go to the <a href=\""+server_url(1,user) + query("location") + 
    "newbie/_top?actionlogin=1&directloginkludge=1&login=" + 
    query("adminlogin")+"&passwd="+adminpasswd+"\">runtime admin interface</a>"
    " for more info.<br />"
    "Login <a href=\""+server_url(1)+query("location")+"\">here</a>.<br />";
  
}


void start(){
  foreach(call_out_info(),array a)
    if(sizeof(a)>5 && a[3]=="IMHO_Survivor" && (sizeof(a)<7 || a[6]==my_configuration())) {
      remove_call_out(a[5]);
      mapping _sessions=a[4]->sessions;
      foreach(indices(_sessions),string s) {
        if(!_sessions[s]["old_module"])
	  _sessions[s]["old_module"]=a[4];
      }
      sessions=_sessions;
      break;
    }


  if(!langs_loaded)
    load_langs();
  if(!plugin_loaded)
    load_plugin();
  load_global_addressbook();
  init_layouts();
  image_cache = roxen.ImageCache( "imho_image", draw_image );
}

void
stop() {
  mapping g=([ ]);
  g["prefproperties"]=prefproperties;
  g["lang_progs"]=lang_progs;
  g["lang_progs_short"]=lang_progs_short;
  g["lang_charsets"]=lang_charsets;
  g["lang_replacement_strings"]=lang_replacement_strings;
  g["langs_loaded"]=langs_loaded;
  g["layouts"]=layouts;
  g["sessions"]=sessions;
#ifdef THREADS
  g["global_lock"]=global_lock;
#endif
  g["plugin_loaded"]=plugin_loaded;
  g["plugin"]=plugin;
  g["global_addressbook"]=global_addressbook;
  
  array a=({ 0 });
  // Roxen tries to kill us. Escape...
  // Destroy all sessions after 60 seconds if the new IMHO hasn't been compiled by then.
  a[0]=call_out(lambda(mixed ... foo){foo[1]->destroy_clients();}, 60, 
		"IMHO_Survivor", new(object_program(this_object()), g, variables,
				     0,0,0,0,0,0,0,0,0,0), a, my_configuration() );
}


void setup_state(object id, mapping arg) 
  // Creates session->nextpage and
  // id->misc->imho->target
  // Parses arguments
{
  if(id->misc->imho && id->misc->imho->session) {
    object session=id->misc->imho->session;
    string target = "",sidetarget="",uptarget="";
    if (arg["target"])
      target = sidetarget = uptarget = arg["target"];
    if (arg["sidetarget"]) // Target to a frame in the same level
      sidetarget = arg["sidetarget"];
    if (arg["uptarget"]) // Target in a frame level up
      uptarget = arg["uptarget"];
    if (sizeof(target) == 0)
      target = uptarget;
    if (sizeof(target) == 0)
      target = sidetarget;
    if (sizeof(target) > 0)
      id->misc->imho->nexttarget = id->misc->imho->nexturl+target;
    else
      id->misc->imho->nexttarget = id->misc->imho->nexturl+id->misc->imho->frame;
    if (sizeof(sidetarget) > 0)
      id->misc->imho->nextsidetarget = id->misc->imho->nexturl+sidetarget;
    else
      id->misc->imho->nextsidetarget = id->misc->imho->nexturl+id->misc->imho->frame;
    if (sizeof(uptarget) > 0)
      id->misc->imho->nextuptarget = id->misc->imho->nexturl+uptarget;
    else
      id->misc->imho->nextuptarget = id->misc->imho->nexturl+id->misc->imho->frame;
    id->misc->imho->topframe = arg->topframe||"_top";
    id->misc->imho->nextpage = id->misc->imho->nexturl+id->misc->imho->frame;
    id->misc->imho->target = target;
    id->misc->imho->sidetarget = sidetarget;
    id->misc->imho->uptarget = uptarget;
    if (arg->face)
      id->misc->imho->face = arg->face;
    else
      id->misc->imho->face = 0;
    id->misc->imho->nogtext = 0;
    if (arg->nogtext)
      id->misc->imho->nogtext = 1;
    id->misc->imho->notopbuttons = 0;
    if (arg->notopbuttons)
      id->misc->imho->notopbuttons = 1;
    id->misc->imho->nobottombuttons = 0;
    if (arg->nobottombuttons)
      id->misc->imho->nobottombuttons = 1;
    if(arg->nobackbutton)
      id->misc->imho->nobackbutton=1;
    if(arg->columns)
      id->misc->imho->columns=arg->columns;
  }
}

string query_location() { return query("location"); }

string tag_imho_servers(string tag_name, mapping arg, object id, object file) {
  string tab = "<tablify nicer>";
  
  tab += "Domain\tServer\n"; 
  foreach (imap_servers(), array arr) {
    tab+= arr[0] + "\t" + arr[1] + "\n";
  }
  tab += "</tablify>";
  return tab;
}

string tag_imho_banner(string tag_name, mapping arg, object id, object file) {
  return query("banner");
}


// Create an inactive session, store login and password and set cookie for user
// Arguments: login, passwd, imapserver and autologout 
// autologout is the number of minutes before the session is removed 
// Does not create a new session if the user has one already (but updates idle time)

string tag_imho_createsession(string tag_name, mapping arg, object id, object file) {
  string ret = "";
  NOCACHE();
#ifdef THREADS
  object lock;
  lock = global_lock->lock();
#endif
  if (id->cookies["IMHOSession"] && sessions[id->cookies["IMHOSession"]]) {
    sessions[id->cookies["IMHOSession"]]->last = time();
#ifdef THREADS
    destruct(lock);
#endif
    return "";
  }

  //FIXME: don't duplicate code here...
  // create new session
  string s=rand_string(30);
  // fat chance, but anyway :)
  while(search(indices(sessions),s)!=-1)
    s=rand_string(30);
  sessions[s] = Session();
#ifdef THREADS
  destruct(lock);
#endif
  default_session(sessions[s],id);
  sessions[s]->status = INACTIVE; // Do not waste memory on mailboxes
  // etc yet, wait until first access.
  sessions[s]->last = time();
  sessions[s]->ip = id->remoteaddr;
  sessions[s]->session = s;
  sessions[s]->cookies = 0;
  if(arg["use-http-auth"]) {
    array auth = (id->realauth || "") / ":";
    if(sizeof(auth) > 1) {
      sessions[s]->passwd = auth[1];
      sessions[s]->login = auth[0];
    }
  } else {
    sessions[s]->passwd = (arg["passwd"]||"");
    sessions[s]->login = (arg["login"]||"");
  }
  sessions[s]->imapserver = (arg["imapserver"]||"");
  if (arg["autologout"])
    sessions[s]->autologout = (arg["autologout"]);

  ret += set_imho_cookie("IMHOSession",s);
  return ret;
}

// Kill the user's session
string tag_imho_removesession(string tag_name, mapping arg, object id, object file) {
  object session=0;
  string ret=remove_imho_cookie("IMHOSession");
  NOCACHE();
#ifdef THREADS
  object lock;
  lock = global_lock->lock();
#endif
  if (id->cookies["IMHOSession"] && sessions[id->cookies["IMHOSession"]])
    session = sessions[id->cookies["IMHOSession"]];
  if (!session) {
#ifdef THREADS
    destruct(lock);
#endif
    return(ret);
  }
  destruct(session->imapclient);
  m_delete(sessions,session->session);
#ifdef THREADS
  destruct(lock);
#endif
  return(ret);
}

string tag_imho_title(string tag_name, mapping arg, object id, object file) {
  if (id->misc->imho && id->misc->imho->session) {
    object session = id->misc->imho->session;
    if(session->old_module && session->old_module!=this_object())
      return session->old_module->tag_imho_title(tag_name,arg,id,file);
    if (screennames[session->status]) {
      return (MSG(screennames[session->status][1]));
    }
    return("");
  }
}


// This will return the current username that is using imho
//
// Arguments are optional -- without any the full user name is returned
// if arg is first,  the only the first part from username before the first 
//                   part before an " "
// if arg is second, the second part after the " " is given is exists. else
//                   and empty string is given.
string tag_imho_name(string tag_name, mapping args, object id, object file)
{
  if (id->misc->imho && id->misc->imho->session)
    {
      array username = id->misc->imho->session->name/" ";
      
      if (args->first)
	{
	  return username[0];
	}
      else
	{
	  if (args->second) {
	    if (sizeof(username) > 1)
	      return username[1];
	    else
	      return "";
	  }
	  return id->misc->imho->session->name;
	}
    }
  else
    return "";
}

string tag_imho_string(string tag_name, mapping arg, object id, object file) {
  if(id->misc->imho) {
    object session = id->misc->imho->session;
    if(session->old_module && session->old_module!=this_object())
      return session->old_module->tag_imho_string(tag_name,arg,id,file);
    if (arg["no"])
      return(MSG((int) arg["no"]));
  }
  else 
    return "";
}

string tag_imho_submit(string tag_name, mapping arg, object id, object file) {
  if(id->misc->imho) {
    object session = id->misc->imho->session;
    if(session->old_module && session->old_module!=this_object())
      return session->old_module->tag_imho_submit(tag_name,arg,id,file);

    mapping args = (["type":"submit","class":"button","value":arg->value]);
    // Allow all arguments. Lets e.g. javascript through.
    foreach(indices(arg),string a) {
      if (!(args[a]))
	args[a] = arg[a];
    }
    return make_tag("input",args);
  }
}


string tag_imho_mailbox(string tag_name, mapping arg, object id, object file) {
  if (id->misc->imho && id->misc->imho->session) {
    object session = id->misc->imho->session;
    
    if(session->old_module && session->old_module!=this_object())
      return session->old_module->tag_imho_mailbox(tag_name,arg,id,file);
    
    string mbox = session->mailbox[MB_HIERARCHY_IDX][-1];
    mbox = session->imapclient->translate_frommbox(session, mbox);
   
    return(html_encode_string(mbox));
  }
}

string tag_imho_frame(string tag_name, mapping arg, object id, object file) {
  object session = id->misc->imho->session;

    if(session->old_module && session->old_module!=this_object())
      return session->old_module->tag_imho_frame(tag_name,arg,id,file);

    // Changed from absolute URL to imho->nexturl 001109 /BL
  string src=id->misc->imho->nexturl+arg->name+"-"+rand_string(8);
  string ret="<frame src=\""+src+"\" ";
  foreach(indices(arg), string i)
    ret+=" "+i+"="+html_encode_tag_value(arg[i])+"";
  ret +=">";
  return ret;
}

string cont_imho_text(string tag_name, mapping arg, 
		      string content, object id) {
  // Container used instead of <gtext> and makes a normal text
  // if id->misc->imho->gtext == "no". Font face and foreground color
  // will be preserved even if nogtext.
 if (id->misc->imho && id->misc->imho->session) {
    object session = id->misc->imho->session;
    if(session->old_module && session->old_module!=this_object())
      return session->old_module->cont_imho_text(tag_name,arg,content,id);
 }


  string ret = "";
  if (id->misc->imho && id->misc->imho->nogtext) {
    if (arg->href) {
      ret += "<a";
      foreach(indices(arg), string a)
	ret += " "+a+"=\""+arg[a]+"\"";
      ret += ">";
    }
    if (arg->fg || id->misc->imho->face) {
      ret += "<font ";
      if (arg->fg)
	ret += " color="+arg->fg;
      if (id->misc->imho->face)
	ret += " face=\""+id->misc->imho->face+"\"";
      ret += ">";
      if (arg->href)
	ret += "[&nbsp;"+replace(content," ","&nbsp;")+"&nbsp;]";
      else
	ret += content;
      ret += "</font>";
    }
    else {
      if (arg->href)
	ret += "[&nbsp;"+replace(content," ","&nbsp;")+"&nbsp;]";
      else
	ret += content;
    }
    if (arg->href)
      ret += "</a> ";
  } else {
    ret += "<gtext";
    foreach(indices(arg), string a) {
      if (a == "nfont" && id->misc->imho->face)
	ret += " "+a+"=\""+id->misc->imho->face+"\"";
      else
	ret += " "+a+"="+html_encode_tag_value(arg[a])+"";
    }
    ret += ">"+content+"</gtext>";
  }
  return ret;
}

string cont_imho_href(string tag_name, mapping arg, string content, object id, object file) {
  if (id->misc->imho && id->misc->imho->session) {
    object session = id->misc->imho->session;
    if(session->old_module && session->old_module!=this_object())
      return session->old_module->cont_imho_href(tag_name,arg,content,id,file);
  }
  string ret = "", action="", mbox="";
  string tag = "";
  sscanf(tag_name,"imho_%s", tag);
  ret += "<"+tag;
  object session = id->misc->imho->session;
  string target = "";
  setup_state(id,arg);
  int mboxno = -1; 
  foreach(indices(arg), string a) {
    switch(a) {
    case "href":
      action = arg[a];
      break;
    case "mbox":
      mboxno = session->imapclient->find_mailbox(session, arg[a]);
      if (mboxno == -1)
	mboxno = 0;
      break;
    default:
      ret+=" "+a+"="+html_encode_tag_value(arg[a])+"";
    }
  }
  ret+=" href=\""+id->misc->imho->nexttarget+"?action"+action+"=1";
  if (mboxno >= 0)
    ret+="&mbox="+http_encode_url(session->mailboxes[mboxno][MB_FOLDERNAME_IDX]);
  ret+="\">"+content+"</"+tag+">";
  return(ret);
}

string
tag_imho_url(string tag_name, mapping arg, object id, object file) {
  if(id->misc->imho && id->misc->imho->session) {

    if(id->misc->imho->session->old_module && id->misc->imho->session->old_module!=this_object())
      return id->misc->imho->session->old_module->tag_imho_main(tag_name,arg,id,file);
  }
  string ret = "", action="", mbox="";
  string tag = "";
  object session = id->misc->imho->session;
  string target = "";
  setup_state(id,arg);
  int mboxno = -1; 
  foreach(indices(arg), string a) {
    switch(a) {
    case "href":
      action = arg[a];
      break;
    case "mbox":
      mboxno = session->imapclient->find_mailbox(session, arg[a]);
      if (mboxno == -1)
	mboxno = 0;
      break;
    case "target":
      break;
    default:
      ret += "&"+a+"="+arg[a];
      break;
    }
  }
  ret=id->misc->imho->nexttarget+"?action"+action+"=1"+ret;
  if (mboxno >= 0)
    ret+="&mbox="+http_encode_url(session->mailboxes[mboxno][MB_FOLDERNAME_IDX]);
  return(ret);
}

string
tag_imho_main(string tag_name, mapping arg, object id, object file) {
  if(id->misc->imho && id->misc->imho->session) {

    if(id->misc->imho->session->old_module && id->misc->imho->session->old_module!=this_object())
      return id->misc->imho->session->old_module->tag_imho_main(tag_name,arg,id,file);

    string thcolor=arg->thcolor || "#ffffff";
    string thbgcolor=arg->thbgcolor || "#000070";
    string tdbgcolor=arg->tdbgcolor || "#fcfce0";
    string checkcolor=arg->checkcolor || "#000000";
    int checksize=(int)arg->checksize || 15;
    int arrowsize=(int)arg->arrowsize || 15;
    string check=arg->check||"";
    string arrowup=arg->arrowup||"";
    string arrowdown=arg->arrowdown||"";
    string arrownone=arg->arrownone||"";
    string arrowcolor=arg->arrowcolor || thcolor;
    string folder=arg->folder||"";
    setup_state(id,arg);

    int screen = id->misc->imho->session->status;
    if (screen != DIALOGBOX) {
      switch(tag_name) {
      case "imho_mailindex":
	screen = MAILINDEX;
	break;
      case "imho_compose":
	screen = COMPOSE;
	break;
      case "imho_readmail":
	screen = READMAIL;
	break;
      case "imho_folderlist":
	screen = FOLDERLIST;
	break;
      case "imho_files":
	screen = FILES;
	break;
      case "imho_addressbook":
	screen = ADDRESSBOOK;
	break;
      case "imho_setup":
	screen = SETUP;
	break;
      }
    }
    string main = create_main(id,screen);

    
    return replace(main,
		   ({ "&imho_folder;","&imho_thcolor;","&imho_thbgcolor;",
		      "&imho_tdbgcolor;","&imhocheckfg;","&imhochecksrc;",
		      "&imhoarrowupsrc;","&imhoarrowdownsrc;","&imhoarrownonesrc;",
		      "&imho_arrowcolor;",
		      "&imhochecksize;","&imhoarrowsize;" 
		   }),
		   ({ sizeof(folder)?folder:"/internal-gopher-menu",thcolor,thbgcolor,
		      tdbgcolor, checkcolor,check,
		      arrowup,arrowdown,arrownone,
		      arrowcolor,
		      (string)(checksize*4),(string)(arrowsize*4) 
		   }) );
    
  }
  else
    return "";
}

string
tag_imho_about(string tag_name, mapping arg, object id, object file) {
 if (id->misc->imho && id->misc->imho->session) {
    object session = id->misc->imho->session;
    if(session->old_module && session->old_module!=this_object())
      return session->old_module->tag_imho_about(tag_name,arg,id,file);
 }
  return (arg->nolink?"":"<a target=\"_top\" href=\""+query("location")+"0/0/about\">")
    +"IMHO v"+imho_version+
    (arg->nolink?"":"</a>");
}

string
tag_imho_buttons(string tag_name, mapping arg, object id, object file) {
  if(id->misc->imho && id->misc->imho->session) {
    object session=id->misc->imho->session;

    if(session->old_module && session->old_module!=this_object())
      return session->old_module->tag_imho_buttons(tag_name,arg,id,file);

    string bg = arg->bg || "#c0c0c0";
    string fg = arg->fg || "#000000";
    string magic_fg = arg->magic_fg || "#303030";
    string scale = arg->scale || "0.4";
    string ret = "", folder="";
    setup_state(id,arg);

    if (id->misc->imho && id->misc->imho->session) {
      folder= id->misc->imho->session->mailbox[MB_HIERARCHY_IDX][-1];
      folder = session->imapclient->translate_frommbox(session, folder);
    }
    else
      folder = MSG(M_INBOX);
    string args="";
    if (arg->xsize)
      args += " xsize=\"" + arg->xsize+"\"";

    ret += "<imho_text bg=\"" + bg + "\"" + args + " scale=\"" + scale + "\" "
      "href=\"" + id->misc->imho->nexttarget + "?actioncompose=1\" "
      "target=\"" + id->misc->imho->target + "\" magic=\"magic\" magic_fg=\"" + magic_fg + "\" "
      "bevel=\"4\" fg=\"" + fg + "\" xspacing=\"10\" yspacing=\"5\">" +
      MSG(M_NEWMAIL) + "</imho_text>" + (arg->breakline ? "<br />" : "");
    ret += "<imho_text bg=\"" + bg + "\"" + args + " scale=\"" + scale + "\" "
      "href=\"" + id->misc->imho->nexttarget + "?actionindex=1\" "
      "target=\"" + id->misc->imho->target + "\" magic magic_fg=\"" + magic_fg + "\" "
      "bevel=\"4\" fg=\"" + fg + "\" xspacing=\"10\" yspacing=\"5\">" +
      (feature(FEAT_MAILBOXES) ? (arg->noupdate ? 
				  MSG(M_CURRMAILBOX) :
				  replace(MSGA(M_MAILBOX, ({"\0"})), "\0", folder)
				  ) : MSG(M_INBOX)) + 
      "</imho_text>" + (arg->breakline ? "<br />" : "");
    if(feature(FEAT_MAILBOXES))
      ret += "<imho_text bg=\"" + bg + "\"" + args + " scale=\"" + scale + "\" "
	"href=\"" + id->misc->imho->nexttarget + "?actionfolderlist=1\" "
	"target=\"" + id->misc->imho->target + "\" magic=\"magic\" magic_fg=\"" + magic_fg + "\" "
	"bevel=\"4\" fg=\"" + fg + "\" xspacing=\"10\" yspacing=\"5\">" +
	MSG(M_MAILBOXES) + "</imho_text>" + (arg->breakline ? "<br />" : "");
    if(feature(FEAT_ATTACHMENTS) && sizeof(query("uploaddir")))
      ret += "<imho_text bg=\"" + bg + args + "\" scale=\"" + scale + "\" "
	"href=\"" + id->misc->imho->nexttarget + "?actionfiles=1\" "
	"target=\"" + id->misc->imho->target + "\" magic=\"magic\" magic_fg=\"" + magic_fg + "\" "
	"bevel=\"4\" fg=\"" + fg + "\" xspacing=\"10\" yspacing=\"5\">" +
	MSG(M_FILES) + "</imho_text>" + (arg->breakline ? "<br />" : "");
    if(feature(FEAT_ADDRESSBOOK))
      ret += "<imho_text bg=\"" + bg + "\"" + args + " scale=\"" + scale + "\" "
	"href=\"" + id->misc->imho->nexttarget + "?actionaddressbook=1\" "
	"target=\"" + id->misc->imho->target + "\" magic=\"magic\" magic_fg=\"" + magic_fg + "\" "
	"bevel=\"4\" fg=\"" + fg + "\" xspacing=\"10\" yspacing=\"5\">" +
	MSG(M_ADDRESSBOOKTITLE) + "</imho_text>" + (arg->breakline ? "<br />" : "");
    if(feature(FEAT_USEREDITSETUP))
      ret += "<imho_text bg=\"" + bg + "\"" + args + " scale=\"" + scale + "\" "
	"href=\"" + id->misc->imho->nexttarget + "?actionsetup=1\" "
	"target=\"" + id->misc->imho->target + "\" magic=\"magic\" magic_fg=\"" + magic_fg + "\" "
	"bevel=\"4\" fg=\"" + fg + "\" xspacing=\"10\" yspacing=\"5\">" +
	MSG(M_PREFS) + "</imho_text>" + (arg->breakline ? "<br />" : "");
    ret += "<imho_text bg=\"" + bg + "\"" + args + " scale=\"" + scale + "\" "
      "href=\"" + id->misc->imho->nexturl + id->misc->imho->topframe + "-" + rand_string(8) + 
      "?actionlogout=1\" target=\""+id->misc->imho->topframe+"\" "
      "magic=\"magic\" magic_fg=\"" + magic_fg + "\" bevel=\"4\" fg=\"" + fg + "\" "
      "xspacing=\"10\" yspacing=\"5\">" + MSG(M_LOGOUT) + "</imho_text>" +
      (arg->breakline ? "<br />" : "");

    return(ret);
  }
  else
    return "";
}

string
cont_imho_buttonoutput(string tag_name, mapping args, string content,
		       object id, object file) {

  string ret = "";
  if(id->misc->imho && id->misc->imho->session) {

    object session = id->misc->imho->session;
    if(session->old_module && session->old_module!=this_object())
      return session->old_module->cont_imho_buttonoutput(tag_name,args,content,id,file);
    
    array vars=({ });
    string folder="";
    setup_state(id,args);

    if (id->misc->imho && id->misc->imho->session) {
      folder= id->misc->imho->session->mailbox[MB_HIERARCHY_IDX][-1];
      folder = session->imapclient->translate_frommbox(session, folder);
    }
    else
      folder = MSG(M_INBOX);

    if(lower_case(args->buttons||"main")=="inboxes") {
      foreach(indices(session->activemailboxinfo), int i) {
	int mboxno = session->activemailboxinfo[i]->mbox;
	string name = session->mailboxes[mboxno][MB_DISPLAYNAME_IDX];
	name = session->imapclient->translate_frommbox(session, name);
	if (mboxno < 0)
	mboxno = 0;
	vars += ({ ([ 
		     "button-url":id->misc->imho->nexttarget+"?actionindex=1&mbox=" + 
		     http_encode_url(session->mailboxes[mboxno][MB_FOLDERNAME_IDX]),
		     "button-target":id->misc->imho->target,
		     "button-text":name + (args->noupdate ? "" : 
					   (" "+((string) session->activemailboxinfo[i]->total)))
	           ]) });
      }
    }
    else {
      vars += ({ ([ 
		   "button-name":"compose",
		   "button-url":id->misc->imho->nexttarget+"?actioncompose=1", 
		   "button-target":id->misc->imho->target,
		   "button-text":MSG(M_NEWMAIL)
                  ]),
		 
		 ([
		   "button-name":"mailindex",
		   "button-url":id->misc->imho->nexttarget+"?actionindex=1", 
		   "button-target":id->misc->imho->target, 
		   "button-text": (feature(FEAT_MAILBOXES) ? 
				   (args->noupdate ? MSG(M_CURRMAILBOX) :
				    replace(MSGA(M_MAILBOX,({"\0"})),"\0",folder)  ) : 
				   "INBOX")
		  ]) 
               });

      if(feature(FEAT_MAILBOXES))
	vars += ({ ([ 
		     "button-name":"mailboxes",
		     "button-url":id->misc->imho->nexttarget+"?actionfolderlist=1", 
		     "button-target":id->misc->imho->target,
		     "button-text":MSG(M_MAILBOXES)
                    ])
	  	});
		 

      if(feature(FEAT_ATTACHMENTS) && sizeof(query("uploaddir")))
	vars += ({ ([ 
		     "button-name":"files",
		     "button-url":id->misc->imho->nexttarget+"?actionfiles=1", 
		     "button-target":id->misc->imho->target,
		     "button-text":MSG(M_FILES)
                    ])
		});

      if(feature(FEAT_ADDRESSBOOK))
	vars += ({ ([ 
		     "button-name":"addressbook",
		     "button-url":id->misc->imho->nexttarget+"?actionaddressbook=1", 
		     "button-target":id->misc->imho->target,
		     "button-text":MSG(M_ADDRESSBOOKTITLE)
                    ])
		});

      if(feature(FEAT_USEREDITSETUP))
	vars += ({ ([ 
		     "button-name":"preferences",
		     "button-url":id->misc->imho->nexttarget+"?actionsetup=1", 
		     "button-target":id->misc->imho->target,
		     "button-text":MSG(M_PREFS)
	])
		     });
      
      
      
      if(query("loginmethod") != "http basic auth")
	vars += ({ ([ 
		     "button-name":"logout",
		     "button-url":id->misc->imho->nexturl+id->misc->imho->topframe + 
		     "-" + rand_string(8) + "?actionlogout=1",
		     "button-target":id->misc->imho->topframe,
		     "button-text":MSG(M_LOGOUT)
                    ])
		 });
    }
    
    return(do_output_tag(args,vars,content,id));
  }
  else
    return "";

}


string
tag_imho_activemailboxbuttons(string tag_name, mapping arg, object id, object file) {
  if(id->misc->imho && id->misc->imho->session) {
    object session=id->misc->imho->session;

    if(session->old_module && session->old_module!=this_object())
      return session->old_module->tag_imho_activemailboxbuttons(tag_name,arg,id,file);

    string bg=arg->bg || "#c0c0c0";
    string fg=arg->fg || "#803000";
    string magic_fg=arg->magic_fg || "#402000";
    string scale=arg->scale || "0.3";
    string ret = "", folder;
    array mbox_parts;
    setup_state(id,arg);

    string args="";
    if (arg->xsize)
      args += " xsize="+arg->xsize+" ";

    foreach(indices(session->activemailboxinfo), int i) {
      int mboxno = session->activemailboxinfo[i]->mbox;
      string name = session->mailboxes[mboxno][MB_DISPLAYNAME_IDX];
      name = session->imapclient->translate_frommbox(session, name);
      if (mboxno < 0)
	mboxno = 0;
      ret += "<imho_text bg="+bg+args+" scale=" + scale + " href=\"" + 
	id->misc->imho->nexttarget + "?actionindex=1&mbox=" + 
	http_encode_url(session->mailboxes[mboxno][MB_FOLDERNAME_IDX]) + 
	"\" target=\"" + id->misc->imho->target + "\" magic magic_fg=" + magic_fg + 
	" bevel=4 fg=" + fg + " xspacing=10 yspacing=5>" + name + 
	(arg->noupdate ? "" : (" "+((string) session->activemailboxinfo[i]->total))) + 
	"</imho_text>" + (arg->breakline ? "<br />" : "");
    }
    return(ret);
  }
  else
    return "";
}

// This will return the number of new/unread mails in the inbox or <FALSE> if there
// is NO new mail at all in the mailbox... ;-)
// 
// if args nomessages, onemessage and messages exists all three
// then output is changed with thoses args.
// nomessages is the message to send when there is no new messages in the
//            current mailbox
// onemessage is the message to send when there is ONE message in the 
//            current mailbox
// messages   is the message to send when there is more than ONE message in the
//            current mailbox
// prefix    is the prefix to add when you have messages
string tag_imho_countnewmails(string tag_name, mapping args, object id, object file)
{
  if (id->misc->imho && id->misc->imho->session)
  {
    object session=id->misc->imho->session;
    array email;
    int cpt=0;
    int nbmessages=sizeof(session->mails);
    if (nbmessages) {
     foreach(session->mails, email)
     {
      if (sizeof(email->imap->FLAGS) == 0) cpt++;
      else
       if (search(email->imap->FLAGS,"Seen") != -1) cpt++;
     }
     nbmessages=cpt;
    }
    if ( args->nomessages && args->onemessage && args->messages && args->prefix)
    {
     if(nbmessages==0)
      return args->nomessages;

     // So there is at least one message here ;-)
     if(nbmessages==1)
      return sprintf("%s %d %s",args->prefix, nbmessages, args->onemessage);

     // So there is more than one message ;-)
     return sprintf("%s %d %s",args->prefix, nbmessages, args->messages);

    }
    else
    {
     return sprintf("%d%s", nbmessages,(nbmessages==0)?"<FALSE>":"<TRUE>");
    }
   }
   else
    return "";
}

// This will return the email address entred in the preferences or the current
// email addresse from the preferences
//
// If arg domain is given, then only the domain part is shown
string tag_imho_address(string tag_name, mapping args, object id, object file)
{
 if (id->misc->imho && id->misc->imho->session)
 {
    if (args->domain)
     return sprintf("%s",((id->misc->imho->session->defaultaddress)/"@")[1]);
    else
     return sprintf("%s",id->misc->imho->session->defaultaddress);
 }
 else
  return "";
}

// This will return the name of the current screen. Usefull for a
// help system
string tag_imho_screen(string tag_name, mapping arg, object id, object file)
{
 if (id->misc->imho && id->misc->imho->session)
 {
   string screen="unknown";
   object session=id->misc->imho->session;

   if (screennames[session->status])
     screen=screennames[session->status][0];
   return screen;
 }
 else
  return "";
}

// This will return the whole mapping from id
string tag_imho_dumpid(string tag_name, mapping args, object id, object file)
{
  return (sprintf("<pre>Id:%O\n</pre>",mkmapping(indices(id),values(id))));
}




mapping query_tag_callers()
{
  return([ 
	  "imho_servers":tag_imho_servers,
	  "imho_banner":tag_imho_banner,
	  "imho_title":tag_imho_title,
	  "imho_name":tag_imho_name,
	  "imho_frame":tag_imho_frame,
	  "imho_main":tag_imho_main,
	  "imho_about":tag_imho_about, 
	  "imho_buttons":tag_imho_buttons,
	  "imho_mailindex":tag_imho_main,
	  "imho_compose":tag_imho_main,
	  "imho_readmail":tag_imho_main,
	  "imho_folderlist":tag_imho_main,
	  "imho_files":tag_imho_main,
	  "imho_addressbook":tag_imho_main,
	  "imho_setup":tag_imho_main,
	  "imho_string":tag_imho_string,
	  "imho_submit":tag_imho_submit,
	  "imho_mailbox":tag_imho_mailbox,
	  "imho_activemailboxbuttons":tag_imho_activemailboxbuttons,
	  "imho_image":tag_imho_image,
	  "imho_image_url":tag_imho_image,
	  "imho_url":tag_imho_url,
	  "imho_countnewmails":tag_imho_countnewmails,
	  "imho_address":tag_imho_address,
	  "imho_screen":tag_imho_screen,
	  "imho_dumpid":tag_imho_dumpid,
	  "imho_createsession":tag_imho_createsession,
	  "imho_removesession":tag_imho_removesession
         ]);
}

mapping query_container_callers() { 
  return ([
	   "imho_text": cont_imho_text,
	   "imho_a":cont_imho_href,
	   "imho_gtext":cont_imho_href,
	   "imho_buttonoutput":cont_imho_buttonoutput
  ]); 
}


void
spellcheck(object session) {
  session->spelling= ({ });
  session->misspelled= ({ });
  session->checkword = 0;

  object file1=Stdio.File();
  //object file2=file1->pipe(Stdio.PROP_IPC);
  object file2=file1->pipe();
  object file3=Stdio.File();
  //object file4=file3->pipe(Stdio.PROP_IPC);
  object file4=file3->pipe();
  string res;

  Process.create_process(({query("ispell"),"-a","-d",session->ispelldict}) + 
			 ((query("speller")=="aspell") ? ({ "--ignore-repl" }) : ({ })),
			 (["stdin" : file2, "stdout" : file4 ]) );
  //add a space before each line to prevent ispell from interpreting single-word lines as commands
  //FIXME: how should charsets be treated?
  string stripped_message=Locale.Charset.encoder("iso-8859-1","")->
    feed(session->message)->drain();
  file1->write((Array.map((stripped_message)/"\n",lambda(string s){return " "+s;}))*"\n");
  file1->close();
  file2->close();
  file4->close();
  res=file3->read();
  file3->close();

  array ispell_data=res/"\n";
  array input_rows=(stripped_message)/"\n";
    
  if(sizeof(ispell_data)>1) {
    int i,row=0,pos=0,pos2;
    string word,suggestions;
    for(i=1;i<sizeof(ispell_data)-1 && row<sizeof(input_rows);i++) {
      if(!sizeof(ispell_data[i])){ // next row
	(session->spelling)+=({ input_rows[row][pos..]+"\n" });
	row++;
	pos=0;
      }
      else {
	// pos2 will be a position ahead original data, due to the extra space.
        switch(ispell_data[i][0]) {
        case '&': // misspelled, suggestions
          sscanf(ispell_data[i],"& %s %*d %d:%s",word,pos2,suggestions);
	  (session->spelling) += ({ input_rows[row][pos..pos2-2] ,({ word , word }) + 
				    Array.map(suggestions/",",remove_blanks) });
          (session->misspelled) += ({ sizeof(session->spelling)-1 });
          pos=pos2-1+sizeof(word);
          break;
	case '#': //misspelled
	  sscanf(ispell_data[i],"# %s %d",word,pos2);
	  (session->spelling)+=({ input_rows[row][pos..pos2-2] ,({ word , word }) });
	  (session->misspelled)+=({ sizeof(session->spelling)-1 });
	  pos=pos2-1+sizeof(word);
	  break;
	  
	}
      }
    }
  }
}

#if constant(Protocols.LDAP)

/* Generic LDAP query function. Searches using 'filter' and returns the
 * mapping:
 * string error:  "" on success, error message otherwise.
 * object obj:    result from query on success, undefined otherwise.
 */
mapping ldapquery(string filter)
{      	
  string server, basedn;
  mixed status;
  mixed error;
  string name, dn,ou, output="";
  object con;
  string uname="", passwd="";
  object en;
  string ldap_last_error;

  
  server = query("ldapserver");
  if(server == "")
    server = "localhost";
  basedn = query("ldapsearchroot");
  
  uname=query("ldapuser");
  passwd=query("ldappass");
  
#if __VERSION__ > 0.6
  //FIXME: hmm, seems to be a difference here. 
  error = catch(con = Protocols.LDAP.client("ldap://"+server));
  if(!error)
    error = catch(con->bind(uname||"",passwd||"",2));
#else
  error = catch(con = Protocols.LDAP.client(server));
  if(!error)
    error = catch(con->bind(sizeof(uname) ? uname : 0, sizeof(passwd) ? passwd : 0));
#endif
  
  if (error || !objectp(con)) {
    output = "<h1>Couldn't connect to LDAP-server</h1><br />\n";
    perror("IMHO: LDAP, couldn't connect to LDAP-server "+server+"\n");
    return(["error":output, "obj":en]);
  }
  
  status = con->set_basedn(basedn);
  status = con->set_scope(2);
  
  if (error = catch(en = con->search(filter))) {
    ldap_last_error = "LDAP search \"" + filter + "\" failed: " + con->error_string();
    perror("IMHO: LDAP, "+ldap_last_error+"\n");
    output = "<h1>" + ldap_last_error + "</h1>\n <br />\n";
  }

  con->unbind();
  
  return(["error":output, "obj":en]);
}


// Searches LDAP for an email-address belonging to the search-string 'namecont'.
string getldapaddr(string namecont)
{      	
  string filter, output="";
  mapping qmap;
  
  namecont=TO_UTF8(namecont);

  filter = "(|(cn=*" + namecont + "*)(sn=*" + namecont + "*))";

  qmap = ldapquery(filter);
  if(qmap["error"] == "") {
    object en=qmap["obj"];
    int inx;
    
    for(inx = 1; inx <= en->num_entries(); inx++) {
      string address = (en->fetch(inx)["mail"]||({ "" }))[0];
      string temp = (en->fetch(inx)["dn"]||({ "" }))[0];
      string name = (en->fetch(inx)["cn"]||({ "" }))[0];
      if(sizeof(name) == 0) {
	name = (en->fetch(inx)["givenname"]||({ "" }))[0] + " " +
	  (en->fetch(inx)["sn"]||({ "" }))[0];
      }
      if(query("ldapshowou")=="yes") {
	string ou = (en->fetch(inx)["ou"]||({ "" }))[0];
	if(output == "")
	  output = name + ":" +  address + ":" + ou;
	else
	  output += "\n" + name + ":" + address + ":" + ou;
      }
      else {
	if(output == "")
	  output = name + ":" +  address;
	else
	  output += "\n" + name + ":" + address;
      }
    }
    return FROM_UTF8(output);
  }
  
  perror("IMHO: LDAP, non-zero return from ldapquery " +qmap["error"]+"\n");
  return(qmap["error"]);
}


// Queries an LDAP server for the users fullname, based on a username.
string getfullnamefromldap(string login)
{
  string filter;
  mapping qmap;

  login=TO_UTF8(login);
  filter = "(mail="+login+")";

  qmap = ldapquery(filter);
  if(qmap["error"] == "") {
    object en = qmap["obj"];
  // return null if not exactly match 1 entry
  if (en->num_entries() == 1) {
      string name = (en->fetch(1)["cn"]||({ "" }))[0];
      if(sizeof(name) == 0) {
        name = (en->fetch(1)["givenname"]||({ "" }))[0] + " " + (en->fetch(1)["sn"]||({ "" }))[0];
      }
      return FROM_UTF8(name);
  }
  else {
    if (query("debug")=="on")
      perror("none or more than 1 entry returned\n");
    return "";
  }
}

  perror("IMHO: LDAP, non-zero return from ldapquery " +qmap["error"]+"\n");
    return "";
  }


// Queries and LDAP server for userinfo, based on a username
mapping ldapgetuser(string login)
{
  string filter;
  mapping qmap;

  login=TO_UTF8(login);
  filter = replace(query("ldapimapfilter"), "%u%", login);
  
  qmap = ldapquery(filter);
  if(qmap["error"] == "") {
    object en=qmap["obj"];
    
    // return null if not exactly match 1 entry
    if (en->num_entries() == 1)
      return en->fetch(1);
    else {
      if (query("debug")=="on")
	perror("none or more than 1 entry returned\n");
      return ([ ]);
    }
  }
  perror("IMHO: LDAP, non-zero return from ldapquery " +qmap["error"]+"\n");
  return ([ ]);
}
		
#endif		

string handle_admin_interface(object id, object session){
  string ret = "";
  string action = "";

  foreach(indices(id->variables),string var) {
    string foo;
    if (var)
      if(sscanf(var,"action%s",foo))
	action=foo;
  }

  ret+="<html><head><title>IMHO Runtime Admin</title></head>"
    "<body bgcolor=\"#ffffff\" text=\"#000000\" link=\"#0000ff\" "
    "vlink=\"#0000ff\" alink=\"#ff0000\">"
    "<table width=\"100%\" cellspacing=\"0\" cellpadding=\"0\" border=\"0\"><tr><td>"
    "<imho_image border=\"0\" quant=\"250\" fg=\"#ffffff\" bg=\"#3030c0\" "
    "align=\"left\" width=\"500\" height=\"32\" image=\"bannerleft\" "
    "hspace=\"0\" text=\"IMHO Runtime Admin\" /></td><td width=\"100%\">"
    "<imho_image width=\"100%\" quant=\"250\" fg=\"#ffffff\" hspace=\"0\" bg=\"#3030c0\" "
    "border=\"0\" height=\"32\" image=\"bannerright\" />"
    "</td></tr></table>";

  switch(action) {
  case "changesort":
    if (id->variables->col)
      session->adminsortcolumn = (int) id->variables->col;
    if (id->variables->dir)
      session->sortup = (int) id->variables->dir;
    session->users = Array.sort_array(session->users,
				      lambda(array a1,array a2, int col, int dir) {
					return( dir ?
						(a1[col] > a2[col]) :
						(a1[col] < a2[col]) ); }, 
				      session->adminsortcolumn, session->sortup);
    break;
  case "logout":
#ifdef THREADS
    object lock;
    lock = global_lock->lock();
#endif
    destruct(session->imapclient);
    m_delete(sessions,session->session);
#ifdef THREADS
    destruct(lock);
#endif
    ret+"<br /><br />";
    ret+=MSG(M_LOGOUTMSG);
    if (session->cookies) {
      ret+=remove_imho_cookie("IMHOSession");
    }
    ret+="</body></html>";
    return ret;
    break;  
  case "index":
    session->showfrom = (int) id->variables->showfrom;
    break;
  default:
    session->users = ({ });
#ifdef THREADS
    object lock2;
    lock2 = global_lock->lock();
#endif
    foreach(indices(sessions), string s) {
      object session2 = sessions[s];
      array user = ({ });
      if (session2->login) {
	user+=({ session2->address });
	user+=({ session2->logintime });
	user+=({ (time()-session2->last) });
	user+=({ session2->ip });
	user+=({ (session2->mails?sizeof(session2->mails):0) });
	user+=({ (int) (session2->layout?session2->layout:0) });
	user+=({ (session2->language) });
	user+=({ session2 });
	session->users += ({ user });
      }
#ifdef THREADS
      destruct(lock2);
#endif
    }
    session->users = Array.sort_array(session->users,
				      lambda(array a1,array a2, int col, int dir) {
					return( dir ? 
						(a1[col] < a2[col]) : 
						(a1[col] > a2[col]) ); },
				      session->adminsortcolumn, session->sortup);
    session->showfrom = 0;
    break;
  }


  ret+="<a name=\"activeusers\"><gh3>Active Users</gh3></a><br />";
  ret+="<table width=\"100%\"><tr>";
  array columns = ({ "Login", "Login Time", "Idle Time", "IP-Address",
		     "# Msgs in Box", "Layout", "Language" });
  if(query("adminshowsize") == "yes")
    columns += ({ "Size" });
  
  for (int i = 0; i < sizeof(columns); i++) {
    ret+="<th bgcolor=\"#000070\"><font color=\"white\"><b>"
      "<a href=\"" + id->misc->imho->nexturl + "?actionchangesort=1&col=" + i +
      "&dir="+(session->sortup==0 && session->adminsortcolumn == i ? "1" : "0") +
      "\"><imho_image bg=\"#000070\" border=\"0\" alt=\"" + MSG(M_CHANGESORTORDER) + "\" "
      "size=\"60\" scale=\"0.25\" image=\"" + ((session->adminsortcolumn == i) ? 
					       (session->sortup ? "arrowup" : "arrowdown") : 
					       "arrownone") +
      "\" /></a>&nbsp;"+columns[i]+"</b></font></th>";
  }
  ret+="</tr>\n";
  
  int i = 0;
  
  for (i = session->showfrom; i < sizeof(session->users) && i < session->showfrom+20; i++) {
    array user = session->users[i];
    ret+="<tr bgcolor=\""+((i/3)&1?"#fcfce0":"white")+"\">";
    ret+="<td>"+user[0]+"</td>";
    ret+="<td>"+ctime(user[1])+"</td>";
    ret+="<td>"+(user[2]/60)+" mins </td>";
    ret+="<td>"+user[3]+"</td>";
    ret+="<td>"+user[4]+"</td>";
    if (sizeof(layouts)-1 >= user[5])
      ret+="<td>"+(layouts[user[5]]["name"])+"</td>";
    else
      ret+="<td>"+"None"+"</td>";
    ret+="<td>"+user[6]+"</td>";
    if(query("adminshowsize") == "yes")
      ret+="<td>"+sizeof(user[7])+"</td>";
    ret+="</tr>";
  }
  ret += "</table>\n";
  ret += sprintf("&nbsp;Showing users %d-%d of %d", 
		 session->showfrom+1,
		 session->showfrom + 20 < sizeof(session->users) ? 
		  session->showfrom+20 : 
		 sizeof(session->users),
		 sizeof(session->users));
  if (session->showfrom > 0)
    ret += "<a href=\""+id->misc->imho->nexturl+"?actionindex=1&showfrom=" + 
      (session->showfrom - 20 > 0 ? session->showfrom - 20 : 0) + "\">[Previous]</a> ";
  if (session->showfrom + 20 < sizeof(session->users))
    ret+="<a href=\""+id->misc->imho->nexturl+"?actionindex=1&showfrom=" + 
      (session->showfrom +20 )+"\">[Next]</a> ";
  ret+="<br />";
  
  ret+="<form action=\""+id->misc->imho->nexturl+"#activeusers\" method=GET "
    "name=\"imhoupdateadmin\"><imho_submit name=\"actionupdate\" value=\"Update\" />"
    "<imho_submit name=\"actionlogout\" value=\"Logout\" />";
  ret+="</form><hr />\n";

  int uptime = time() - stats->starttime;
  ret+="<a name=stats><gh3>Statistics</gh3></a><br />";
  ret+="&nbsp;Statistics since last restart:";
  ret+="<table>\n";
  ret+="<tr><td><b>Uptime:</b></td><td>"+
    sprintf("%.1f hrs",((float) uptime)/3600.0)+"</td></tr>";
  ret+="<tr><td><b>Logins:</b></td><td>"+stats->nologins+"</td></tr>";
  ret+="<tr><td><b>Failed logins:</b></td><td>"+stats->nofailedlogins+"</td></tr>";
  ret+="<tr><td><b>Logouts:</b></td><td>"+stats->nologouts+"</td></tr>";
  ret+="<tr><td><b>Autologouts:</b></td><td>"+stats->noautologouts+"</td></tr>";
  ret+="<tr><td><b>Messages sent:</b></td><td>"+stats->nomailsent+"</td></tr>";
  ret+="<tr><td><b>Bytes sent:</b></td><td>"+stats->nobytessent+"</td></tr>";
  ret+="<tr><td><b>IMAP errors:</b></td><td>"+stats->noimapfailures+"</td></tr>";
  ret+="<tr><td><b>SMTP errors:</b></td><td>"+stats->nosmtpfailures+"</td></tr>";
  ret+="</table>";

  ret+="<form action=\""+id->misc->imho->nexturl+"#stats\" method=GET "
    "name=\"imhoupdateadmin\"><imho_submit name=\"actionupdate\" value=\"Update\" />"
    "<imho_submit name=\"actionlogout\" value=\"Logout\" />";
  ret+="</form><hr />\n";

  ret+="</body></html>";
  return ret;
}


mapping process_request(string file, object id, object session)
{
  string action="";
  array fileparts = file/"/";

   id->misc->imho->file = file;

  if (session->administrator)
    return create_output(session,id);

  if(id->variables->mailpart){
    object mail = session->cmail;    
    if (!mail)
      return(http_low_answer(404, "Mailpart not found."));
    int i = 0;
    string mp = id->variables->mailpart;
    if (sscanf(mp, "cid:%s", mp) == 1) {
      mp = "<"+mp+">";
      array mails = ({ mail });
      while(sizeof(mails) && mp != mail->headers["content-id"]) {
	mail = mails[0];
	mails = mails[1..];
	if (mail->body_parts)
	  mails += mail->body_parts;
      }
      if (mail->headers["content-id"] == mp)
	return http_string_answer(mail->getdata()||"",mail->type+"/"+mail->subtype);
      return(http_low_answer(404, "Mailpart not found."));
    } else {
      sscanf(mp,"%d,%s", i, mp);
      while (i >= 0 && mail && mail->body_parts && (sizeof(mail->body_parts)>i)){
	mail = mail->body_parts[i];
	i = -1;
	sscanf(mp,"%d,%s", i, mp);
      }
      return http_string_answer(mail->getdata()||"",mail->type+"/"+mail->subtype);
    }
  }

#if constant(Image.XFace.decode)
  if(id->variables->xface){
    object img;
    if(catch(img=Image.XFace.decode(MIME.decode_base64(id->variables->xface))))
      return 0;
#if constant(Image.GIF.encode)
    return http_string_answer(Image.GIF.encode(img),"image/gif");
#else
    return http_string_answer(Image.PNG.encode(img),"image/png");
#endif
  }
#endif

  if(id->variables->download){
    if((int)id->variables->download < sizeof(session->files)){
      mapping file = session->files[(int)id->variables->download];
      object downfile = open(query("uploaddir") + "/" + (session->login) + "_" + 
			     encode_fname(file->fname), "r");
      if (downfile)
	return http_file_answer(downfile,file->type,file->size);
      else
	return 0;
    }
    else
      return 0;
  }

  
  foreach(indices(id->variables),string var) {
    string foo;
    if(sscanf(var,"action%s",foo))
      action=foo;
  }
  {
    // if type=image in submit
    int foo;
    foo=sizeof(action);
    if(foo>2 && (action[foo-2..]==".x" || action[foo-2..]==".y") )
      action=action[..foo-3];
  }

  if (session->loadfiles) {
    session->loadfiles = 0;
    get_files(session);
  }

  if((session->status == INACTIVE))
    action="goactive";

  if (action!=""){
    id->misc->imho->selected = ({ });
    id->misc->imho->selectedfiles = ({ });
    id->misc->imho->selectedattachments = ({ });
    int nr,tonr=-1;
    foreach(indices(id->variables),string var) {
      tonr = -1;
      if(id->variables[var] == "1" && sscanf(var,"msg%d-%d",nr,tonr)) {
	if (tonr < nr)
	  tonr = nr;
	id->misc->imho->selected += ({ tonr==nr?(string)nr:(string)nr+":"+(string)tonr });
      }
      id->misc->imho->selected = Array.sort_array(id->misc->imho->selected,
						  lambda(string s1,string s2) {
						    return( (int)s1>(int)s2);
						  } );
      if(id->variables[var] == "1" && sscanf(var,"file%d",nr))
	id->misc->imho->selectedfiles += ({ nr });
      if(var=="attachments") {
	foreach(id->variables[var]/"\0", string s)
	  if (((int) s) >= 0)
	    id->misc->imho->selectedattachments += ({ (int) s });
      }
    }

    if((session->status < 0) && (action!="login" && action!="goactive"))
      action="";

    switch(action){
      
    case "login":
    case "goactive":
      if(session->status < 0) {
	session->logintime = time();
	array loginsplit;
	if (action == "login") {
	  if( query("loginmethod") == "http basic auth") {
	    array auth = (id->realauth || "") / ":";
	    session->login = auth[0];
	    session->passwd = ((sizeof(auth) > 1) && auth[1]) || "";
	    loginsplit =  ({ session->login });
	  } else {
	    loginsplit = id->variables->login / "@";
	    session->login = loginsplit[0];
	    session->passwd = id->variables->passwd||"";
	  }
	  session->imapserver = "";
	} else {
	  loginsplit = ({ session->login });
	}

	/* Figure out imap-server and domainname */
	/* If user entered user@domain, use @domain instead of the chosen value in the dialog */

#if constant(Protocols.LDAP)
	int ldapgetserver = (query("ldapimapsearch") == "yes");
	int ldapgetaddress = (query("ldapimapsearchaddress") == "yes");

	mapping res;
	
	if(ldapgetserver || ldapgetaddress)
	  res = ldapgetuser(session->login);

	// If not user@domain and use LDAP for searching user's imapserver
	if (sizeof(loginsplit)!=2 && ldapgetserver) {
	  session->imapserver = ((res[query("ldapimapattr")])||({ "" }))[0];
	  if (query("debug")=="on") {
	    perror("IMHO: LDAP get imapserver "+session->imapserver+"\n");
	  }
	}
	
	if (ldapgetaddress) {
	  session->address = session->defaultaddress = ((res[query("ldapmailattr")])||({ "" }))[0];
	}

#endif
	int i=1;
	foreach(imap_servers(), array arr) {
	  array servs = arr[1]/":";
	  string server = servs[0];
	  int port = 143;
	  string mailpath = query("defaultmailpath");
	  if (arr[2]->mailpath)
	    mailpath = arr[2]->mailpath;
	  string prefsbox = query("prefsbox");
	  if (arr[2]->prefsbox)
	    prefsbox = arr[2]->prefsbox;
	  if (sizeof(servs) > 1)
	    port = (int) servs[1];
	  if (sizeof(loginsplit) == 2) {
	    if(loginsplit[1] == arr[0]) {
	      /* Exact match, we're done */
	      session->imapserver = server;
	      session->imapport = port;
	      session->mailpath = session->defaultmailpath = mailpath;
	      session->prefsbox = session->defaultmailpath + prefsbox;
	      session->lcfgmap = arr[2];
	      session->address = session->defaultaddress = session->login+"@"+arr[0];
	      session->maildomain = arr[0];
	      if (query("debug")=="on")
		perror("IMHO: imap-server exact match on "+arr[0]+"\n");
	      break;
	    }
	    else if (search(arr[0], loginsplit[1]) >= 0) {
	      /* Best-effort match, continue through the */
	      /* list in case we find a better match */
	      session->imapserver = server;
	      session->imapport = port;
	      session->mailpath = session->defaultmailpath = mailpath;
	      session->prefsbox = session->defaultmailpath + prefsbox;
	      session->lcfgmap = arr[2];
	      session->address = session->defaultaddress = session->login+"@"+arr[0];
	      session->maildomain = arr[0];
	      if (query("debug")=="on")
		perror("IMHO: imap-server partial match on "+arr[0]+"\n");
	    }
	  }
	  else if (session->imapserver == server) {
	    /* server found from LDAP match one of the listed servers */
	    session->imapserver = server;
	    session->imapport = port;
	    session->mailpath = session->defaultmailpath = mailpath;
	    session->prefsbox = session->defaultmailpath + prefsbox;
	    session->lcfgmap = arr[2];
	    session->address = session->defaultaddress = session->login+"@"+arr[0];
	    session->maildomain = arr[0];
	    if (query("debug")=="on")
	      perror("IMHO: imap-server (from LDAP) match on "+server+"\n");
	    break;
	  }
	  else if (session->imapserver == "" &&
                   (!id->variables->imapserver ||
		    i == (int)id->variables["imapserver"])) {
	    session->imapserver = server;
	    session->imapport = port;
	    session->mailpath = session->defaultmailpath = mailpath;
	    session->prefsbox = session->defaultmailpath + prefsbox;
	    session->lcfgmap = arr[2];
	    session->address = session->defaultaddress = session->login+"@"+arr[0];
	    session->maildomain = arr[0];
	    break;
	  }
	  i++;
	}
	if (id->variables->layout && id->variables->layout != "-1")
	  session->overridelayout = id->variables->layout;
	session->status = LOGINFAILED;
	if (session->login == query("adminlogin") && 
	    ( session->passwd==adminpasswd || crypt(session->passwd,query("adminpasswd")))) {
	  session->address="ADMINISTRATOR";
	  session->administrator = 1;
	  session->status = ADMINMAIN;
	  return create_output(session,id);
	}
	else {
	  session->imapclient->imap_command(id,session,({ 
	    imap_cmd("loaduserprefs", "abortfail", 0),
	    imap_cmd("low_list", "path", session->mailpath), 
	    imap_cmd("checkmailboxes", "output", imap_cmd_var("activemailboxinfo"), "mailboxes", 
		     imap_cmd_var("activemailboxes")),
	    imap_cmd("getheaders", "output", imap_cmd_var("mails"), "updatelistpos", 1,
		     "setsortcolumn", imap_cmd_var("mailssortcolumn")),
	    imap_cmd("start") }));
	  return http_pipe_in_progress();
	}
      }
      break;

    case "logout":
      session->status = LOGOUT;
      imho_log("logout", ([ "login":session->address ]));
      session->imapclient->imap_command(id,session,({ imap_cmd("low_logout", "noselect", 1) }));
      return http_pipe_in_progress();
      break;


    case "compose":
    case "composenodraft":    
      session->replytoidx = -1;
      if (action != "composenodraft" && 
	  session->draftmail && sizeof(session->draftmail) > 0) {
	session->dialogstrings = ({ MSG(M_YES), 
					MSG(M_NO) });
	session->dialogactions = 
	  ({ "actioncomposedraft", 
	       "actioncomposenodraft" });
	session->dialogtext = 
	  MSG(M_COMPOSEDRAFT);
	session->dialogtarget = id->misc->imho->frame; 
	session->status = DIALOGBOX;
      } else {
	if (id->variables->to)
	  session->to = formdata_to_unicode(id->variables,session,id->variables->to);
	else
	  session->to = "";
	session->cc = "";
	session->bcc = session->autobcc;
	session->subject = "";
	session->attachments = ({ });
	session->message = "\n" + session->signature;
	session->status = COMPOSE;
      }
      break;

    case "composedraft":
      object mail = 0;
      catch { mail = MIME.Message(session->draftmail); } ;
      if (!mail) {  // Draftmail was broken
	session->draftmail = "";
	session->to = "";
	session->cc = "";
	session->bcc = session->autobcc;
	session->subject = "";
	session->attachments = ({ });
	session->message = "\n" + session->signature;
      } else { // Draftmail was fine, include all data
	session->attachments = ({ });
	session->subject = fix_coding(mail->headers->subject);
	if(mail->headers->to)
	  session->to = fix_coding(mail->headers->to);
	else
	  session->to = "";
	if(mail->headers->cc)
	  session->cc = fix_coding(mail->headers->cc);
	else
	  session->cc = "";
	if(mail->headers->bcc)
	  session->bcc = fix_coding(mail->headers->bcc);
	else
	  session->bcc = "";
	if(mail->headers->subject)
	  session->subject = fix_coding(mail->headers->subject);
	else
	  session->subject = "";
	  
	session->message = "";	  
	if(mail->body_parts){
	  int messageadded=0;
	  foreach(mail->body_parts, object mess) {
	    if(!messageadded && 
	       mess->type == "text" && 
	       mess->subtype != "html") {
	      session->message += mess->getdata()||"";
	      messageadded=1;
	    } else {
	      string name=mess->disp_params["filename"] || mess->params["name"] || "unknown";
	      mapping file=([ ]);
	      file["fname"]=name;
	      file["data"]=mess->getdata()||"";
	      file["size"]=sizeof(file->data);
	      file["type"]=filetype(name);
	      session->attachments += ({ file });
	    }
	  }
	}
	else 
	  session->message += mail->getdata()||"";
	session->draftmail = "";
      }
      session->status = COMPOSE;
      session->imapclient->imap_command(id,session,({ 
	imap_cmd("saveuserprefs") }));
      return http_pipe_in_progress();
      break;

    case "gotoaddattachment":
      if(session->usersetupaddress)
	session->from = formdata_to_unicode(id->variables,session,id->variables->from);
      session->to = formdata_to_unicode(id->variables,session,id->variables->to);
      session->cc = formdata_to_unicode(id->variables,session,id->variables->cc);
      session->bcc = formdata_to_unicode(id->variables,session,id->variables->bcc);
      session->subject = formdata_to_unicode(id->variables,session,id->variables->subject);
      session->message = formdata_to_unicode(id->variables,session,id->variables->message);
      session->status = ATTACHMENTS;
      break;

    case "removeattachment":
      array deletes = ({ });
      foreach(id->misc->imho->selectedattachments, int i)
	deletes += ({ session->attachments[i] });
      session->attachments -= deletes;
      session->status = COMPOSE;
      break;

    case "continuecompose":
      session->status = COMPOSE;
      break;

    case "addfileattachment":
      foreach(id->misc->imho->selectedattachments, int i)
	session->attachments += ({ session->files[i] });
      session->status = COMPOSE;
      break;

    case "uploadattachment":
      if(feature(FEAT_ATTACHMENTS) && sizeof(id->variables->file)) {
	string fname=(id->variables->fixedfilename && sizeof(id->variables->fixedfilename))?id->variables->fixedfilename:id->variables["file.filename"];
	fname=((((fname)/"/")[-1])/"\\")[-1];
	//perror(fname+"\n");
	session->attachments+= ({ ([ "fname" : TO_UNICODE(fname), "size" : sizeof(id->variables->file), "type" : filetype(fname), "data": id->variables->file ]) });
      }
      session->status = COMPOSE;
      break;

    case "addressbookto":
    case "addressbookcc":
    case "addressbookbcc":
      if(session->usersetupaddress)
	session->from = formdata_to_unicode(id->variables,session,id->variables->from);
      session->to = formdata_to_unicode(id->variables,session,id->variables->to);
      session->cc = formdata_to_unicode(id->variables,session,id->variables->cc);
      session->bcc = formdata_to_unicode(id->variables,session,id->variables->bcc);
      session->subject = formdata_to_unicode(id->variables,session,id->variables->subject);
      session->message = formdata_to_unicode(id->variables,session,id->variables->message);
      session->recipientfield = 0;
      sscanf(action, "addressbook%s", session->recipientfield);
      session->status = ADDRESSBOOK;
      break;

#if constant(Protocols.LDAP)

    case "ldapto":
    case "ldapcc":
    case "ldapbcc":
      if(session->usersetupaddress)
	session->from = formdata_to_unicode(id->variables,session,id->variables->from);
      session->to = formdata_to_unicode(id->variables,session,id->variables->to);
      session->cc = formdata_to_unicode(id->variables,session,id->variables->cc);
      session->bcc = formdata_to_unicode(id->variables,session,id->variables->bcc);
      session->subject = formdata_to_unicode(id->variables,session,id->variables->subject);
      session->message = formdata_to_unicode(id->variables,session,id->variables->message);
      session->recipientfield = 0;
      sscanf(action, "ldap%s", session->recipientfield);
      session->status = LDAPSEARCH;
      break;

    case "searchldap":
      session->ldapadd = getldapaddr(formdata_to_unicode(id->variables,session,id->variables->namecont));
      session->status = LDAPRESULT;
      break;    	
#endif

    case "addressbook":
      session->recipientfield = 0;
      session->status = ADDRESSBOOK;
      break;

    case "gotoimportaddress":
      session->status = IMPORTADDRESS;
      break;

    case "importaddress":
      //FIXME: coding of files?
      if(sizeof(id->variables->file)) {
	string newbook = import_addressbook(id->variables->file);
	if (sizeof(newbook) > 0) {
	  array (string) addresses = session->addressbook/"\n";
	  addresses += newbook / "\n";
	  session->addressbook = sort(Array.uniq(addresses))*"\n";
	  session->status = ADDRESSBOOK;
	  session->imapclient->imap_command(id,session, ({ imap_cmd("saveuserprefs") }));
	  return http_pipe_in_progress();
	} else {
	  session->dialogstrings = ({ MSG(M_DIALOGOK) });
	  session->dialogactions = 
	    ({ "actionaddressbook" });
	  session->dialogtext = 
	    MSG(M_CANNOTIMPORT);
	  session->dialogtarget = id->misc->imho->frame; 
	  session->status = DIALOGBOX;
	}
      }
      session->status = ADDRESSBOOK;
      break;

    case "editaddress":
      if (id->variables->address) {
	session->editaddress = ((int) id->variables->address);
	session->status = EDITADDRESS;
      }
      session->editaddressmode = "old";
      break;

    case "newaddress":
      string name="", address="";
      if (id->variables->address)
	address = fix_coding(id->variables->address);
      if (id->variables->name)
	name = id->variables->name;
      if (id->variables->take)
	session->editaddressmode = "take";
      else
	session->editaddressmode = "new";
      if (sizeof(session->addressbook) > 0)
	session->addressbook += "\n"+replace(name,":","")+":"+address;
      else
	session->addressbook = replace(name,":","")+":"+address;
      session->status = EDITADDRESS;
      session->editaddress = sizeof(session->addressbook/"\n")-1;
      break;

    case "editaddressdone":
      if (id->variables->address && id->variables->name) {
	array (string) addresses = session->addressbook/"\n";
	addresses[session->editaddress] = replace(formdata_to_unicode(id->variables,session,id->variables->name),":", "")+":"+formdata_to_unicode(id->variables,session,id->variables->address); 
	session->addressbook = sort(addresses)*"\n";
	if (session->editaddressmode == "take")
	  session->status = READMAIL;
	else
	  session->status = ADDRESSBOOK;
	session->imapclient->imap_command(id,session, ({ imap_cmd("saveuserprefs") }));
	return http_pipe_in_progress();
      }
      break;

    case "deleteaddress": 
      {
	array (string) addresses = session->addressbook/"\n";
	addresses -= ({ addresses[session->editaddress] });
	session->addressbook = addresses*"\n";
	if (session->editaddressmode == "take")
	  session->status = READMAIL;
	else
	  session->status = ADDRESSBOOK;
	session->imapclient->imap_command(id,session, ({ imap_cmd("saveuserprefs") }));
	return http_pipe_in_progress();
      }
      break;

    case "deleteaddresses":
      {
	array (string) addresses = session->addressbook/"\n";
	array (string) removed = ({ });
	foreach(indices(id->variables), string var) {
	  int addr = 0;
	  if (sscanf(var, "address%d", addr) >= 1)
	    removed += ({ addresses[addr] });
	}
	addresses -= removed;
	session->addressbook = addresses*"\n";
	session->status = ADDRESSBOOK;
	session->imapclient->imap_command(id,session, ({ imap_cmd("saveuserprefs") }));
	return http_pipe_in_progress();
      }
      break;

    case "canceleditaddress":
      if (session->editaddressmode != "old") {
	array (string) addresses = session->addressbook/"\n";
	addresses -= ({ addresses[-1] });
	session->addressbook = addresses*"\n";
      }
      if (session->editaddressmode == "take")
	session->status = READMAIL;
      else
	session->status = ADDRESSBOOK;
      break;

    case "searchmail":
      if (id->variables->text1 && id->variables->searchfield1) {
	if (session->searchstring && sizeof(session->searchstring) > 0)
	  session->searchstring+= " "+MSG(M_SEARCHAND)+" ";
	else
	  session->searchstring = "";
	session->searchstring += "\""+formdata_to_unicode(id->variables,session,id->variables->text1)+"\" ";
	switch(id->variables->searchfield1) {
	case "text": session->searchstring += MSG(M_SEARCHANYWHERE);
	  break;
	case "to": session->searchstring += MSG(M_SEARCHTOFIELD);
	  break;
	case "from": session->searchstring += MSG(M_SEARCHFROMFIELD);
	  break;
	case "subject": session->searchstring += MSG(M_SEARCHSUBJECT);    
	  break;
	case "body": session->searchstring += MSG(M_SEARCHBODY);
	  break;
	}
	session->status = MAILINDEX;
	session->imapclient->imap_command(id,session, ({ imap_cmd("search", "searchtext", formdata_to_unicode(id->variables,session,id->variables->text1), "searchfield", id->variables->searchfield1, "headers", imap_cmd_var("mails")) }));
	return http_pipe_in_progress();
      } else
	session->status = SEARCHMAIL;
      break;

    case "addrecipient":
      if (id->variables->address) {
	if (session->recipientfield == "to" ||
	    session->recipientfield == "cc" ||
	    session->recipientfield == "bcc") {
		if (sizeof(session[session->recipientfield]) > 0)
	    session[session->recipientfield] += ", "+formdata_to_unicode(id->variables,session,id->variables->address);
	  else
	    session[session->recipientfield] = formdata_to_unicode(id->variables,session,id->variables->address);
	}
      }
      session->status = COMPOSE;      
      break;

      // Add multiple marked addresses
    case "addrecipients":
      if (session->recipientfield == "to" ||
	  session->recipientfield == "cc" ||
	  session->recipientfield == "bcc") {
	array addrlines = (session->addressbook/"\n");
	foreach(indices(id->variables), string var) {
	  int addr = 0;
	  if (sscanf(var,"address%d", addr) >= 1 && id->variables[var]=="1") {
	    string name = "", address = ""; 
	    array s = (addrlines[addr]/":");
	    if (sizeof(s) > 1) {
	      string address = s[1..]*":";
	      if (sizeof(session[session->recipientfield]) > 0)
		session[session->recipientfield] += ", "+address;
	      else
		session[session->recipientfield] = address;
	    }
	  }
	}
	array addrlines2 = (global_addressbook/"\n");
	foreach(indices(id->variables), string var) {
	  int addr = 0;
	  if (sscanf(var,"globaladdress%d", addr) >= 1 && id->variables[var]=="1") {
	    string name = "", address = ""; 
	    array s = (addrlines2[addr]/":");
	    if (sizeof(s) > 1) {
	      string address = s[1..]*":";
	      if (sizeof(session[session->recipientfield]) > 0)
		session[session->recipientfield] += ", "+address;
	      else
		session[session->recipientfield] = address;
	    }
	  }
	}
      }
      session->status = COMPOSE;      
      break;

    case "createfolder":
      session->status = FOLDERLIST;
      if (id->variables->foldername && sizeof(id->variables->foldername)>0 &&
	  (id->variables->foldername=formdata_to_unicode(id->variables,session,id->variables->foldername)) != MSG(M_NEWMBOXNAME)) {

	string path=id->variables->path || "";
	int mbox_idx=-1;
	string newmbox="";
	int ok=0;
	if(path!="")
	  mbox_idx=Array.search_array(session->mailboxes,
				    lambda(array a,string path) 
				    {
				      if(a[MB_FOLDERNAME_IDX] == path)
				        return 1;
				      return 0;
				      },
				      path); 
	if(path=="") {
	  newmbox=session->mailpath+id->variables->foldername;
	  ok=1;
	}
	else
	  if(mbox_idx!=-1) {
	    newmbox=session->mailpath+session->mailboxes[mbox_idx][MB_DISPLAYNAME_IDX]+session->mailboxes[mbox_idx][MB_SEPARATOR_IDX]+id->variables->foldername;
	    ok=1;
	  }
	if(ok) {
	  if(session->mboxencode)
	    newmbox=encode_mboxname(newmbox);
	  session->imapclient->imap_command(id,session,({ imap_cmd("low_create","newmailbox",newmbox,"error",MSG(M_CREATEMBOXERROR)), imap_cmd("low_list", "path", session->mailpath) }));
	  return http_pipe_in_progress();
	}
      } else {
	session->dialogstrings = ({ MSG(M_DIALOGOK) });
	session->dialogactions = 
	  ({ "actionfolderlist" });
	session->dialogtext = 
	  MSG(M_NEWMBOXNONAME);
	session->dialogtarget = id->misc->imho->frame; 
	session->status = DIALOGBOX;
      }
      break;

    case "deletefolder":
      array (string) mboxes = ({});
      string mboxtext = "";
      foreach(indices(id->variables),string var) {
	if(id->variables[var] == "1" && sscanf(var,"delf_%s", string mbox)) {
	  mboxes += ({ mbox });
	  mboxtext += mb_displayname_from_name(mbox,session)+"\n";
	}
      }
      if (sizeof(mboxes) > 0) {
	session->dialogstrings = ({ MSG(M_DIALOGOK), 
				      MSG(M_DIALOGCANCEL) });
	session->deletemboxes = mboxes;
	session->dialogactions = 
	  ({ "actiondeletefoldersure", 
	     "actionfolderlist" });
	session->dialogtext = 
	  MSG(M_MBOXREMOVEP)+"\n"
	  +mboxtext;
      } else {
	session->dialogstrings = ({ MSG(M_DIALOGOK) });
	session->dialogactions = 
	  ({ "actionfolderlist" });
	session->dialogtext = 
	  MSG(M_MBOXMARKONE);
      }
      session->dialogtarget = id->misc->imho->frame; 
      session->status = DIALOGBOX;
      break;

    case "deletefoldersure":
      session->status = FOLDERLIST;
      session->imapclient->imap_command(id,session,({ imap_cmd("deletefolders", "folders", imap_cmd_var("deletemboxes")),imap_cmd("low_list", "path", session->mailpath) }));
      return http_pipe_in_progress();
      break;

      // Set new active inboxes
    case "changeinboxes":
      if (feature(FEAT_USERSPECIFYINBOXES)) {
	array (string) mboxes = ({});
	string inboxes = "INBOX";
	foreach(indices(id->variables),string var) {
	  if(id->variables[var] == "1" && sscanf(var,"delf_%s", string mbox)) {
	    inboxes += ", "+ mb_displayname_from_name(mbox,session);
	  }
	}
	session->dialogstrings = ({ MSG(M_DIALOGOK) });
	session->dialogactions = 
	  ({ "actionfolderlist" });
	session->dialogtext = 
	  MSG(M_CHANGEINBOXESMSG);
	session->status = DIALOGBOX;

	session->activemailboxes = inboxes;
	session->imapclient->imap_command(id,session, ({ imap_cmd("saveuserprefs") }));
	return http_pipe_in_progress();
      }
      break;

    case "folderlist":
      session->status = FOLDERLIST;
      session->imapclient->imap_command(id,session,({ imap_cmd("low_list", "path", session->mailpath) }));
      return http_pipe_in_progress();
      break;

    case "folderlistshow":
      session->status = FOLDERLIST;
      break;

    case "cancel":
      if(session->replytoidx == -1)
	session->status = MAILINDEX;
      else
	session->status = READMAIL;
      session->attachments = ({ });
      break;

    case "checkword":
      session->checkword = (int)id->variables->word;
      break;

    case "spellprev":
      session->checkword--;
      break;

    case "spellnext":
      session->checkword++;
      break;

    case "spellreplace":
      (session->spelling)[(session->misspelled)[session->checkword]][1]=formdata_to_unicode(id->variables,session,id->variables->newword);
      session->checkword++;
      break;

    case "spellselect":
      if( (((int)id->variables->selectedword) >= 0) && (((int)id->variables->selectedword) < sizeof((session->spelling[(session->misspelled)[session->checkword]]))-2)) {
	(session->spelling)[(session->misspelled)[session->checkword]][1]=(session->spelling)[(session->misspelled)[session->checkword]][(int)id->variables->selectedword + 2];
      }
      session->checkword++;
      break;

    case "spelldone":
      session->message="";
      foreach(session->spelling,mixed foo) {
	if(arrayp(foo))
	  session->message+=foo[1];
	else
	  session->message+=foo;
      }
      session->status = COMPOSE;
      break;

    case "spellcheck2":
      id->variables->ispelldict=id->variables->ispelldict2;
    case "spellcheck":
      if(sizeof(query("ispell"))) {
	if(session->usersetupaddress)
	  session->from = formdata_to_unicode(id->variables,session,id->variables->from);
	session->to = formdata_to_unicode(id->variables,session,id->variables->to);
	session->cc = formdata_to_unicode(id->variables,session,id->variables->cc);
	session->bcc = formdata_to_unicode(id->variables,session,id->variables->bcc);
	session->subject = formdata_to_unicode(id->variables,session,id->variables->subject);
	session->message = formdata_to_unicode(id->variables, 
						 session, id->variables->message);
	session->ispelldict = id->variables->ispelldict;
	spellcheck(session);
	if(sizeof(session->spelling))
	   session->status = SPELLCHECK;
      }
      break;

    case "send":
      array fixedaddr;
      string brokenaddr = "";
      if(session->usersetupaddress && id->variables->from)
	session->from = formdata_to_unicode(id->variables,session,id->variables->from);
      string add_domain = query("addmaildomain")=="yes" && session->maildomain;

      if (id->variables->to) {
	fixedaddr = fixaddresses(formdata_to_unicode(id->variables,session,id->variables->to), add_domain);
	session->to=fixedaddr[0];
	if (sizeof(brokenaddr) == 0) 
	  brokenaddr = fixedaddr[1];
      }
      if (id->variables->cc) {
	fixedaddr = fixaddresses(formdata_to_unicode(id->variables,session,id->variables->cc), add_domain);
	session->cc=fixedaddr[0];
	if (sizeof(brokenaddr) == 0) 
	  brokenaddr = fixedaddr[1];
      }
      if (id->variables->bcc) {
	fixedaddr = fixaddresses(formdata_to_unicode(id->variables,session,id->variables->bcc), add_domain);
	session->bcc=fixedaddr[0];
	if (sizeof(brokenaddr) == 0) 
	  brokenaddr = fixedaddr[1];
      }
      if (id->variables->subject)
	session->subject=formdata_to_unicode(id->variables,session,id->variables->subject);
      if (id->variables->message)
	session->message=formdata_to_unicode(id->variables,session,id->variables->message);
      if (sizeof(session->to) >= 1 && sizeof(brokenaddr) == 0) {
	if (id->variables->dsnsuccess)
	  session->dsnsuccess=((int) id->variables->dsnsuccess);
	else
	  session->dsnsuccess=0;
	if (id->variables->dsndelay)
	  session->dsndelay=((int) id->variables->dsndelay);
	else
	  session->dsndelay=0;
	if(session->replytoidx == -1)
	  session->status = MAILINDEX;
	else
	  session->status = READMAIL;
	id->misc->imho->selected = ({ });
	sendmail(session,0);
	imho_log("sendmail", ([ "from": session->from || split_from_address(session->address)[0],
			      "to":session->to, "cc":session->cc,
			      "bcc":session->bcc, 
			      "size":sizeof(session->sentmaildata) ]));
	array imap_commands=({ });
#ifndef __NT__
	if (query("sendmethod") == "SMTP")
#endif
	  imap_commands+=({ imap_cmd("smtpsend", "erroraction", "actioncontinuecompose") });
#ifndef __NT__
	else
#endif
	session->attachments = ({ }); // Remove all attachments from mem if already sent

	if (feature(FEAT_MAILBOXES) && 
	    ((feature(FEAT_SAVEMAILCOPY) && id->variables->nosavemail == 0) ||
	     (!feature(FEAT_SAVEMAILCOPY) && !(id->variables->dosavemail==0))) &&
	    sizeof(session->sentfolder)) {
	  string appendbox=session->mailpath + session->sentfolder;
	  if(session->mboxencode)
	    appendbox=encode_mboxname(appendbox);
	  imap_commands+= ({imap_cmd("low_append","tobox",appendbox,"data",session->sentmaildata,"error",MSG(M_SENDSAVEFAILED)) });
	  //m_delete(session,"sentmaildata");
	  session->sentmaildata = 0;
	}
	if(session->replytoidx != -1) {
	  session->mails[session->replytoidx]->imap->FLAGS+=
	    ({ "\\Answered" });
	  
	  imap_commands+=({ imap_cmd("addflag","uid",(int) session->mails[session->replytoidx]->imap->UID,"flag","\\Answered" )});
	}
	if(sizeof(imap_commands)) {
	  session->imapclient->imap_command(id,session,imap_commands);
	  return http_pipe_in_progress();
	}
      } else {
	session->dialogstrings = ({ MSG(M_DIALOGOK) });
	session->dialogactions = 
	  ({ "actioncontinuecompose" });
	if (sizeof(session->to) == 0) 
	  session->dialogtext = MSG(M_SENDNORECV);
	else
	  session->dialogtext = MSGA(M_SENDBROKENADDR, 
				       ({ fix_header(brokenaddr) }));
	session->status = DIALOGBOX;
      }
      break;
      
    case "savedraft":
    case "overwritedraft":
      if(session->usersetupaddress && id->variables->from)
	session->from = formdata_to_unicode(id->variables,session,id->variables->from);
      if (id->variables->to)
	session->to = formdata_to_unicode(id->variables,session,id->variables->to);
      if (id->variables->cc)
	session->cc = formdata_to_unicode(id->variables,session,id->variables->cc);
      if (id->variables->bcc)
	session->bcc = formdata_to_unicode(id->variables,session,id->variables->bcc);
      if (id->variables->subject)
	session->subject = formdata_to_unicode(id->variables,session,id->variables->subject);
      if (id->variables->message)
	session->message = formdata_to_unicode(id->variables,session,id->variables->message);
      if (session->draftmail && sizeof(session->draftmail) > 0 &&
	  action == "savedraft") {
	// There is already a draft mail!
	session->dialogstrings = ({ MSG(M_OVERWRITEDRAFT), 
				    MSG(M_DISCARDDRAFT), 
				    MSG(M_DIALOGCANCEL) });
	session->dialogactions = 
	  ({ "actionoverwritedraft", "actionindex", "actioncontinuecompose" });
	session->dialogtext = 
	  MSG(M_DRAFTEXISTS);
	session->dialogtarget = id->misc->imho->frame; 
	session->status = DIALOGBOX;
      } else {
	if(session->replytoidx == -1)
	  session->status = MAILINDEX;
	else
	  session->status = READMAIL;
	id->misc->imho->selected = ({ });
	sendmail(session,1);
	session->attachments = ({ }); // Remove all attachments from mem
	array imap_commands=({ });
	session->draftmail = session->sendmail;
	session->sendmail = 0;
	session->sentmaildata = 0;
	if (feature(FEAT_SAVEDRAFTONDISK))
	  imap_commands+=({ imap_cmd("saveuserprefs") });
	if(sizeof(imap_commands)) {
	  session->imapclient->imap_command(id,session,imap_commands);
	  return http_pipe_in_progress();
	}
      }
      break;

    case "deleteall":
      array uids = ({ });
      for(int i = 0; i < sizeof(session->mails); i++)
	uids += ({ (string)session->mails[i]->imap->UID });
      session->imapclient->imap_command(id,session,
					({ imap_cmd("delete","uids",uids,"updatembox",
						    imap_cmd_var("mails")) }) );
      return http_pipe_in_progress();
      break;

    case "delete":
      session->imapclient->imap_command(id, session,
					({ imap_cmd("delete","uids",
						    id->misc->imho->selected + ({ }),
						    "updatembox", imap_cmd_var("mails")) }) );
      return http_pipe_in_progress();
      break;

    case "deleteask":
      if (sizeof(id->misc->imho->selected) > 0) {
	session->dialogstrings = ({ MSG(M_DIALOGOK), 
				    MSG(M_DIALOGCANCEL) });
	session->deletemails = id->misc->imho->selected;
	session->dialogactions = 
	  ({ "actiondeletesure", 
	     "actionindex" });
	session->dialogtext = 
	  MSGA(M_DELETEMARKEDP, ({ sizeof(id->misc->imho->selected) }) );
      } else {
	session->dialogstrings = ({ MSG(M_DIALOGOK) });
	session->dialogactions = 
	  ({ "actionindex" });
	session->dialogtext = 
	  MSG(M_DELETEMARKEDNONE);
      }
      session->dialogtarget = id->misc->imho->frame; 
      session->status = DIALOGBOX;
      break;

    case "deletesure":
      //FIXME: move from session to url
      session->status = MAILINDEX;
      session->imapclient->imap_command(id,session,({ imap_cmd("delete", 
							       "uids",
							       session->deletemails+({ }),
							       "updatembox",
							       imap_cmd_var("mails")) }));
      return http_pipe_in_progress();
      break;

    case "trash":
      if (sizeof(id->misc->imho->selected) > 0) {
	session->copytobox = session->mailpath+session->trashfolder;
	if(session->mboxencode)
	  session->copytobox=encode_mboxname(session->copytobox);
	session->imapclient->imap_command(id, session, 
					  ({ imap_cmd("move","uids",
						      id->misc->imho->selected + ({ }),
						      "updatembox",imap_cmd_var("mails")) }) );
	return http_pipe_in_progress();
      }
      session->dialogstrings = ({ MSG(M_DIALOGOK) });
      session->dialogactions = ({ "actionindex" });
      session->dialogtarget = id->misc->imho->frame; 
      session->dialogtext = 
	MSG(M_DELETEMARKEDNONE);
      session->status = DIALOGBOX;
      break;


      string mboxtomoveto=0;
    case "move2":
      if(id->variables->mbox2 && id->variables->mbox2!="imhonomailbox")
	mboxtomoveto=id->variables->mbox2;
    case "move":
      if(!mboxtomoveto && id->variables->mbox && id->variables->mbox!="imhonomailbox")
	mboxtomoveto=id->variables->mbox;
      if(mboxtomoveto && sizeof(id->misc->imho->selected)) {
	session->copytobox = mboxtomoveto;
	session->imapclient->imap_command(id, session,
					  ({ imap_cmd("move", "uids", 
						      id->misc->imho->selected+({ }),
						      "updatembox", imap_cmd_var("mails") ) }) );
	return http_pipe_in_progress();
      }
      break;

    case "reload":
      //FIXME: use close?
      session->searchstring = "";
      session->imapclient->imap_command(id, session, 
					({ imap_cmd("low_close"), 
					   imap_cmd("getheaders","output", 
						    imap_cmd_var("mails"),"updatelistpos", 1,
						    "setsortcolumn", 
						    imap_cmd_var("mailssortcolumn")) }));
      return http_pipe_in_progress();
      break;

    case "checkactivemailboxes": // Just check, don't reload
      session->imapclient->imap_command(id,session,
					({ imap_cmd("checkmailboxes","output",
						    imap_cmd_var("activemailboxinfo"),
						    "mailboxes", session->activemailboxes,
						    "noselect", 1) }) );
      return http_pipe_in_progress();
      break;

    case "reloadactivemailboxes":
      session->searchstring = "";
      session->imapclient->imap_command(id,session,
					({ imap_cmd("checkmailboxes","output", 
						    imap_cmd_var("activemailboxinfo"),
						    "mailboxes", session->activemailboxes),
					   imap_cmd("getheaders", "output", 
						    imap_cmd_var("mails"),"updatelistpos", 1,
						    "setsortcolumn",
						    imap_cmd_var("mailssortcolumn")) }) );
      return http_pipe_in_progress();
      break;

    case "togglesortorder":
      if (session->sessionsortorder == "forward")
	session->sessionsortorder = "backward";
      else
	session->sessionsortorder = "forward";
      break;

    case "changesort":
      if (id->variables->col) {
 	session->sessionsortcolumn = id->variables->col;
      }
      break;
      
    case "trashthis":
      session->copytobox = session->mailpath + session->trashfolder;
      if(session->mboxencode)
	session->copytobox = encode_mboxname(session->copytobox);
      int prevuid = (int)id->variables->prevuid || -1;
      int nextuid = (int)id->variables->nextuid || -1;
      int uid = (nextuid==-1 ? prevuid : nextuid);
      session->cmailidx = find_mail(session->mails, "UID", uid);
      session->cmailuid = uid;
      if (uid ==-1) {
	session->status = MAILINDEX;
	session->imapclient->imap_command(id,session,
					  ({ imap_cmd("move", "uids",
						      id->misc->imho->selected + ({ }),
						      "updatembox", imap_cmd_var("mails") ) }) );
      } else {
	session->imapclient->imap_command(id, session,
					  ({ imap_cmd("move", "uids", 
						      id->misc->imho->selected + ({ }),
						      "updatembox", imap_cmd_var("mails") ),
					     imap_cmd("getmail", "uid", uid, "output",
						      imap_cmd_var("cmail")) }) );
      }
      return http_pipe_in_progress();
      break;

    case "deletethis":
      {
	int prevuid=(int)id->variables->prevuid || -1;
	int nextuid=(int)id->variables->nextuid || -1;
	int uid=(nextuid==-1?prevuid:nextuid);
	session->cmailidx = find_mail(session->mails, "UID", uid);
	session->cmailuid = uid;
	if (uid == -1) {
	  session->status = MAILINDEX;
	  session->imapclient->imap_command(id, session,
					    ({ imap_cmd("delete", "uids", 
							id->misc->imho->selected + ({ }),
							"updatembox",
							imap_cmd_var("mails") ) }) );
	} else {
	  session->imapclient->imap_command(id, session,
					    ({ imap_cmd("delete", "uids", 
							id->misc->imho->selected + ({ }),
							"updatembox", imap_cmd_var("mails") ),
					       imap_cmd("getmail", "uid", uid, "output",
							imap_cmd_var("cmail")) }) );
	}
	return http_pipe_in_progress();
      }
      break;

    case "readprev":
    case "readnext":
    case "read":
      {
	session->status = READMAIL;
	int uid;
	switch(action) {
	case "readprev":
	  uid=(int)id->variables->prevuid;
	  break;
	case "readnext":
	  uid=(int)id->variables->nextuid;
	  break;
	default:
	  uid=(int)id->variables->msguid;
	}
	session->cmailidx = find_mail(session->mails, "UID", uid);
	session->cmailuid = uid;
	session->imapclient->imap_command(id,session,
					  ({ imap_cmd("getmail", "mailbox",
						      id->variables->mbox || 0,
						      "uid", uid, "output", 
						      imap_cmd_var("cmail")) }) );
	return http_pipe_in_progress();
      }
      break;

    case "showheaders":
      session->showheaders = 1;
      break;

    case "hideheaders":
      session->showheaders = 0;
      break;

    case "reply":
    case "replytoall":
      {
	object mail = session->cmail;
	if(mail->headers["reply-to"] && sizeof(mail->headers["reply-to"])) 
	  session->to = fixaddresses(fix_coding(mail->headers["reply-to"]))[0];
	else
	  session->to = fixaddresses(fix_coding(mail->headers->from))[0];
	session->subject = fix_coding(mail->headers->subject);
	if (lower_case(session->subject[0..2]) != "re:")
	  session->subject = "Re: "+session->subject;
	if (mail->headers["message-id"]){
	  session->messageid = mail->headers["message-id"];
	}
	session->message = "";
	if (session->replyincludemsg == "yes") {
	  array(object) msgs = ({ mail });
	  while(sizeof(msgs) > 0) {
	    object mess = msgs[0];
	    msgs = msgs[1..];
	    if (mess->body_parts)
	      msgs = mess->body_parts + msgs;
	    else
	      if(mess->type == "text" && mess->subtype != "html") {
		mixed err=0;
		string msg;
		err=catch { msg = Locale.Charset.decoder(mess->charset)->
			      feed(mess->getdata()||"")->drain(); };
		if(err)
		  msg=mess->getdata()||"";
		session->message = session->replymsgprefix + 
		  replace(msg, "\n", "\n" + session->replymsgprefix);
		session->replytocharset = err ? "iso-8859-1" : mess->charset;
		msgs = ({ });
	      }
	  }
	}
	else
	  session->message="";

	session->message = query("replyseparator") + "\n" + session->message; 
	session->message += "\n" + session->signature;
	session->cc = "";

	if(action=="replytoall") {
	  array (string) ccs = address_split(mail->headers->to) + 
	    address_split((mail->headers->cc||"")) - ({ "" });
	  // Add all in "To:" and "CC:" as "CC:" 

	  // recipients, except ourselves
	  foreach (indices(ccs), int i) {
#if __VERSION__ > 0.6
	    sscanf(ccs[i],"%*[ ]%s",ccs[i]);
	    string ad = ccs[i];
	    sscanf(ccs[i], "%*s<%s>", ad);
#else
	    while(ccs[i][0..0]==" ")
	      ccs[i]=ccs[i][1..];
	    string ad = ccs[i];
	    if (sscanf(string_to_unicode(ccs[i]), "%*s\0<%s\0>", ad) == 1)
	      ad = unicode_to_string(ad);
#endif
	    if (lower_case(ad) != lower_case(session->address)) {
	      if (sizeof(session->cc))
		session->cc += ", ";
	      session->cc += ccs[i];
	    }
	  }
	}
	session->cc = fix_coding(session->cc);
	session->bcc = session->autobcc;
	session->replytoidx = session->cmailidx;
	session->status = COMPOSE;
	session->attachments = ({ });
      }
      break;

    case "forward":
      {
	object mail = session->cmail;
	session->message = session->signature;
	session->message += "\n" + query("forwardseparator") + "\n";
	session->to = "";
	session->cc = "";
	session->bcc = session->autobcc;
	session->replytoidx = -1;
	session->status = COMPOSE;
	session->attachments = ({ });
	session->subject = fix_coding(mail->headers->subject);
	if (session->subject[0..3] != "Fwd:")
	  session->subject = "Fwd: "+session->subject;
	session->message+="\n\nFrom: "+fix_coding(mail->headers->from)+"\n";
	if(mail->headers["reply-to"])
	  session->message+="Reply-to: "+ fix_coding(mail->headers["reply-to"]);
	session->message+="To: "+fix_coding(mail->headers->to)+"\n";
	if(mail->headers->cc)
	  session->message+="Cc: "+ fix_coding(mail->headers->cc )+"\n";
	session->message+="Date: "+ fix_coding(mail->headers->date || "");
	session->message+="\n\n";

      
	if(mail->body_parts){
	  int messageadded=0;
	  foreach(mail->body_parts, object mess) {
	    if(!messageadded && 
	       mess->type == "text" && 
	       mess->subtype != "html") {
	      session->message += mess->getdata()||"";
	      messageadded=1;
	    } else {
	      string name=mess->disp_params["filename"] || mess->params["name"] || "unknown";
	      mapping file=([ ]);
	      file["fname"]=name;
	      file["data"]=mess->getdata()||"";
	      file["size"]=sizeof(file->data);
	      file["type"]=filetype(name);
	      session->attachments += ({ file });
	    }
	  }
	}
	else 
	  session->message += mail->getdata()||"";
      }
      break;


    case "index":
    case "mailindex":
      session->status = MAILINDEX;
      int mbox_idx;
      if (id->variables->mbox && 
	  (mbox_idx=Array.search_array(session->mailboxes,
				       lambda(array a,string mbox) 
				       {
					 if(a[MB_FOLDERNAME_IDX] == mbox)
					   return 1;
					 return 0;
				       },
					 id->variables->mbox)) 
	  != -1 )
	
      {

	string newmbox=id->variables->mbox;
	if(session->mailbox[MB_FOLDERNAME_IDX] != newmbox)
	  session->mailheadersloaded = 0;
	session->mailbox = session->mailboxes[mbox_idx];
	if(!session->mailheadersloaded) {
	  session->searchstring = "";
	  session->imapclient->imap_command(id,session, 
					    ({ imap_cmd("getheaders", "output",
							imap_cmd_var("mails"), 
							"updatelistpos", 1, 
							"setsortcolumn", 
							imap_cmd_var("mailssortcolumn")) }) );
	  return http_pipe_in_progress();
	}
      }
      break;

    case "gotoblock":
      int from;
      if (id->variables->msg && 
	  sscanf(id->variables->msg, "%d", from) == 1)
	session->firstvisiblemail = from;
      session->status = MAILINDEX;
      break;

    case "nextblock":
      sscanf(session->visiblemail, "%d", session->visible);
      session->firstvisiblemail += session->visible; /* MI handles ovfl */
      session->status = MAILINDEX;
      break;

    case "prevblock":
      sscanf(session->visiblemail, "%d", session->visible);
      session->firstvisiblemail -= session->visible; /* MI handles underfl */
      session->status = MAILINDEX;
      break;

    case "files":
      if(sizeof(query("uploaddir")))
	session->status = FILES;
      break;

    case "upload":
      if(id->variables->file && sizeof(id->variables->file)) {
	int totsize=0;
	int allowupload=1;
	foreach(session->files, mapping file){
	  totsize+=file->size;
	}
	if((int)query("uploadquota")) {
	  if ((((((int)query("uploadquota")+(int)query("uploadsoftquota"))*1024)-totsize-sizeof(id->variables->file))) <= 0)
	    allowupload=0;
	  if ((((((int)query("uploadquota"))*1024)-totsize)) <= 0)
	    allowupload=0;
	}

	if(allowupload) {
	  string fname=(id->variables->fixedfilename && sizeof(id->variables->fixedfilename))?id->variables->fixedfilename:id->variables["file.filename"];
	  fname=((((fname)/"/")[-1])/"\\")[-1];
	  string encfname=query("uploaddir")+"/"+lower_case(session->login)+"_"+encode_fname(fname);
	  object file=open(encfname,"wct");
	  if(file) {
	    file->write(id->variables->file);
	    file->close();
	  
	    session->files += ({ ([ "fname" : formdata_to_unicode(id->variables,session,fname), "size" : sizeof(id->variables->file), "type" : filetype(fname) ]) });
	  }
	  else
	    report_warning("IMHO: Could not write uploaded file: "+encfname+"\n");
	}
      }
      break;

    case "deletefiles":
      array (mapping) files_to_delete = ({ });
      foreach(id->misc->imho->selectedfiles, int i)
	if(i < sizeof(session->files))
	  files_to_delete += ({ session->files[i] });
      foreach(files_to_delete,mapping file)
	rm(query("uploaddir")+"/"+session->login+"_"+encode_fname(file->fname));
      session->files -= files_to_delete;
      break;
	

    case "setup":
      if(feature(FEAT_USEREDITSETUP))
	session->status = SETUP;
      break;

    case "savesetup":
#ifndef __NT__
      if (session->lcfgmap->forward) {
          save_forward(session->login, strip(id->variables["forwarding"]));
      }
      if (session->lcfgmap->procmail) {
          save_procmail(session, strip(id->variables["procmailfilter"]));
      }
#endif
      foreach(indices(prefproperties), string prop) {
	if (id->variables[prop] && session["usersetup"+prop])
	  session[prop] = strip(formdata_to_unicode(id->variables,session,id->variables[prop]));
      }
      if (session->mailpath){
	//FIXME: What the **** is this?
	string mp = session->mailpath;
	session->mailpath = mp;
      }
      if(session->language!="english" && !lang_progs[session->language]) {
	// fuzzy select instead
	string lang=Array.filter(session->language/"",lambda(string s) { return (s[0]>='a' && s[0]<='z');} )*"";
	string lang2=0;
	array langs=indices(lang_progs);
	foreach(langs, string l) {
	  if(Array.filter(l/"",lambda(string s) { return (s[0]>='a' && s[0]<='z');} )*"" == lang) {
	    lang2=l;
	    break;
	  }
	}
	if(lang2)
	  session->language=lang2;
      }
      if(!feature(FEAT_USERMAILPATH))
	session->mailpath = session->defaultmailpath;
      if(!feature(FEAT_USERADDRESS))
	session->address = session->defaultaddress;
      if (session->signature) 
	session->signature = session->signature;
      if (session->sortorder)
	session->sessionsortorder = session->sortorder;
      session->sessionsortcolumn = session->sortcolumn;
      if (session->trashfolder)
	session->trashfolder = strip_path(session->trashfolder);
      if (session->sentfolder)
	session->sentfolder = strip_path(session->sentfolder);
      session->status = MAILINDEX;
      session->imapclient->imap_command(id,session, ({ imap_cmd("saveuserprefs"), imap_cmd("checkmailboxes","output", imap_cmd_var("activemailboxinfo"), "mailboxes", session->activemailboxes) }));
      return http_pipe_in_progress();
    }
  }
  
  return create_output(session,id);
}

mixed
create_output(object session,object id) {
  string ret="";
  id->misc->imho->session=session;

   string urlsession, urlfoo;
   if (sscanf(id->misc->imho->file, "%s/%s", urlsession, urlfoo) == 2 || session->status < 0) {
      if ((urlsession != "0" && session->cookies) || session->status < 0 ) // Cookies supp and session showed in URL or loginscreen => don't show session in url
       	 id->misc->imho->nexturl = server_url()+query("location")+"0/";
      else  {
	 if ((urlsession == "0" && !session->cookies)) // Cookies not supported and session not shown in URL => show session in URL
	    id->misc->imho->nexturl = server_url()+query("location")+session->session+"/";
	 else
	    id->misc->imho->nexturl = "";
      }
  } else {
    id->misc->imho->nexturl = server_url()+query("location")+session->session+"/";
  }

  string screen = "unknown";
  if (screennames[session->status])
    screen = screennames[session->status][0];
  ret+="<define name=\"imhoscreen\">"+screen+"</define>";
  string state = "in";
  if (session->status < 0)
    state = "login";
  if (session->status == LOGOUT)
    state = "out";
  ret+="<define name=\"imhostate\">"+state+"</define>";
  ret+="<define name=\"imhouser\">"+session->login+"</define>";
  ret+="<define name=\"imhoframe\">"+id->misc->imho->frame+"</define>";
  ret+="<define name=\"imhomailnotify\">"+(feature(FEAT_MAILNOTIFY)?"yes":"no")+"</define>";
  int newmail = 0;
  foreach(session->activemailboxinfo, mapping m)
    if (m->recent > 0)
      newmail = 1;
  ret+="<define name=\"imhonewmail\">"+((string) newmail)+"</define>";

  mapping answer;
  if (session->administrator)
    ret+=handle_admin_interface(id, session);
  else
    ret+=get_layout((int) session->layout);
  ret+="\n\n<!-- Page generated by IMHO - " IMHO_HOME " -->\n";
  session->charset = session->utf8 ? "utf-8" : (lang_charsets[session->language]||"iso-8859-1");

  //FIXME: use p-code here?
#ifdef __ROXEN_TWO_TWO__
  id->set_output_charset(session->charset);
  answer = http_low_answer(200, parse_rxml(ret,id));
#else
#if __VERSION__ > 0.6
  answer = http_low_answer(200, 
			   Locale.Charset.encoder(session->charset,
						  lang_replacement_strings[session->language] ||
						  "?",	 lambda(string char) {
							   return sprintf("&#x%x;", char[0]);
							 }
						  )->feed(parse_rxml(ret,id))->drain());
#else
  // The RXML parser doesn't handle wide strings very well in Pike 0.6
  answer = http_low_answer(200,
			   Locale.Charset.encoder(session->charset,
						  lang_replacement_strings[session->language] || "?")
			   ->feed(imho_kludge_parse_rxml(ret,id))
			   ->drain() );
#endif
#endif
  // Make sure all pages are reloaded and set Content-type
#ifdef __ROXEN_TWO_TWO__
  answer += ([ "expires": 1 ,"type": "text/html" ]); 
#else
  answer += ([ "expires": 1 ,"type": "text/html; charset="+session->charset ]); 
#endif
  answer->error = id->misc->defines[" _error"];
  answer->extra_heads = id->misc->defines[" _extra_heads"];
  answer->extra_heads["Cache-Control"] = "no-store";
  answer->extra_heads["Pragma"] = "no-cache";

  return answer;
}

#if __VERSION__ <= 0.6
string
imho_kludge_parse_rxml(string data,object id) {
  return imho_parse_rxml(parse_rxml(data,id),id,({ 
    // ({ tag,is_container,func,xrecurse })
    ({ "imho_image", 0, 
       id->misc->imho->main_module ? 
       id->misc->imho->main_module->tag_imho_image :
       tag_imho_image,
       0 }),
    ({ "imho_text", 1 ,cont_imho_text, 1 }),
    ({ "imho_sumbit", 0, 
       id->misc->imho->main_module ?
       id->misc->imho->main_module->tag_imho_submit : 
       tag_imho_submit,
       0 })
  }) );
}

string
imho_parse_rxml(string data,object id,array tags){

  foreach(tags,array tag) {
    int pos;
  
    while((pos=search(data,"<"+tag[0]))!=-1) {
      int pos2=search(data,">",pos);
      int pos3;
      int pos4=pos2;
      if(tag[1]) {
	pos3=search(data,"</"+tag[0],pos2);
	pos4=search(data,">",pos3);
      }
      string tag_all=data[pos..pos4];
      string tag_args=data[pos+sizeof(tag[0])+1..pos2-1];
      
      array i=({ 0 });
      array args_a=((Array.map(tag_args/"\"",
			       lambda(string s,array i) {
				 return (i[0] = (i[0] ? 0 : 1) ) ? replace(s," ","\0") : s;
			       },
			       i)*"\"")/"\0")-({ "" });
      mapping args=([  ]);
      string s1,s2;
      foreach(args_a,string s)
	if(sscanf(s,"%s=%s",s1,s2)==2){
	  args[s1]=replace(s2,"\"","");
	}

      string replacement;
      if(tag[1])
	replacement=tag[2](tag[0],args,data[pos2+1..pos3-1],id,0);
      else
	replacement=tag[2](tag[0],args,id,0);
      if(tag[3] && search(replacement,"gtext")!=-1)
	//strip down and run parse_rxml if gtext present
	data = replace(data, tag_all, 
		       parse_rxml(Locale.Charset.encoder("iso-8859-1","")
				  ->feed(replacement)->drain(), id) );
      else
	data=replace(data,tag_all,replacement);
    }
  }
  return data;
}

#endif

array imap_servers(void|string _imapservers) {
  string imapservers = _imapservers || query("imapservers");

  // Upgrade compatibility for IMHO < 0.98
  if(imapservers==DEFAULT_IMAPSERVERS)
    return ({ ({ query("maildomain"),query("imapserver")+":"+query("imapport"),([ ]) }) });

  array list = (imapservers-"\r")/"\n";
  array servers=({ });
  
  int i=0;
  foreach(list, string line) {
    if (strlen(line)>0) {
      string ldomain = "", lserver = "", lcfg = "";
      sscanf(line, "%*[ ]%s%*[\t ]%s%*[\t ]%s", ldomain, lserver, lcfg);
      if (strlen(lserver)==0) {
	sscanf(line, "%*[ ]%s%*[\t ]%s", ldomain, lserver);
      }
      if (sizeof(ldomain) > 0) {
	mapping lcfgmap = ([]);
	foreach ((lcfg / ",") , string param) {
	  array parsplt = param / ":";
	  if(sizeof(parsplt[0]-" "))
	    if (sizeof(parsplt)>1) {
	      lcfgmap[parsplt[0]] = parsplt[1];
	    } else {
	      lcfgmap[param] = 1;
	    }
	}
	servers += ({ ({ldomain, lserver, lcfgmap}) });
      }
    }
  }
  // Only the non-empty elements returned
  return servers;
}

string encode_imap_servers(array servers) {
  servers=Array.map(servers,lambda(array server) {
			string cfg;
			if(sizeof(server[2])) {
			  array _cfg = ({ });
			  foreach(indices(server[2]),string s)
			    _cfg += ({ s+":"+server[2][s] });
			  cfg = _cfg*",";
			}
			return server[0]+"\t"+server[1]+
			  (cfg?"\t"+cfg:"");
		      });
  return servers*"\n";
}

string imap_servers_selector() {
  string lst = "";
  array servers = imap_servers();
#if constant(Protocols.LDAP)
  if (sizeof(servers) > 1 && query("ldapimapsearch") != "yes") {
#else
    if (sizeof(servers) > 1) {
#endif
      lst = "<select name=\"imapserver\">\n";
      int i=1;
      foreach(servers, array arr) {
	lst +="<option value=\""+((string) i++);
	lst +="\">@"+arr[0]+"</option>\n";
      }
      lst += "</select>\n";
    }
    return lst;
}

#ifndef __NT__
// For pwent returned by getpw*
#define  PW_USER  0
#define  PW_PW    1
#define  PW_UID   2
#define  PW_GID   3
#define  PW_GECOS 4
#define  PW_HOME  5
#define  PW_SHELL 6

// Obtain privileges of username which are kept as long as the returned
// object is kept.
object become_user(string username) {
   array pwent;
   object privs;

   if(!(pwent=getpwnam(username))) {
      perror("IMHO: Unable to getpwnam("+username+")!\n");
      return 0;
   }

   if (query("debug")=="on") {
      string currgrp="";
      foreach(getgroups(), int g) {
         currgrp+=g+" ";
      }
      perror("IMHO: Before privs: UID: " + getuid() + " EUID: " + geteuid() + 
	     " GID: " + getgid() + " EGID: " + getegid() + " Groups: ["+currgrp+"]\n");
   }

   if(!(privs=Privs("IMHO: Becoming user "+username))) {
      perror("IMHO: Failed to obtain privileges when becoming user "+username+"\n");
      return 0;
   }

   if(setegid(pwent[PW_GID]) != 0) {
      perror("IMHO: Failed to setegid("+pwent[PW_GID]+")\n");
      return 0;
   }

   // FIXME: initgroups() seems to return bogus values? :/
   initgroups(username, pwent[PW_GID]);

   if(seteuid(pwent[PW_UID]) != 0) {
      perror("IMHO: Failed to seteuid("+pwent[PW_UID]+")\n");
      return 0;
   }

   if (query("debug")=="on") {
      string currgrp="";
      foreach(getgroups(), int g) {
         currgrp+=g+" ";
      }
      perror("IMHO: After privs: UID: " + getuid() + " EUID: " + geteuid() + 
	     " GID: " + getgid() + " EGID: " + getegid() + " Groups: ["+currgrp+"]\n");
   }

   return privs;
}

// Read file in users home directory.
string userfile_read(string username, string filename) {
   string res = "";

   array pwent;
   if(!(pwent=getpwnam(username))) {
      perror("IMHO: Unable to getpwnam("+username+")!\n");
      return "";
   }

   string filepath = pwent[PW_HOME] + "/" + filename;

   object privs;
   if(!(privs=become_user(username))) {
      perror("IMHO: Failed to become user  "+username+"\n");
      return "";
   }

   object fh=Stdio.File();
   if (fh->open(filepath, "r")) {
      if(!(res = fh->read()-"\r")) {
         perror("IMHO: read() of "+filepath+" failed with error "+
                 strerror(fh->errno())+"\n");
      }
      fh->close();
   }
   else if (query("debug")=="on") {
      perror("IMHO: Failed to open "+filepath+" for reading with error "+
              strerror(fh->errno())+"\n");
   }

   destruct(privs);  // Does not need to be done explicitly really.
   if (query("debug")=="on") {
      string currgrp="";
      foreach(getgroups(), int g) {
         currgrp+=g+" ";
      }
      perror("IMHO: After dropping privs: UID: " + getuid() + " EUID: " + geteuid() + 
	     " GID: " + getgid() + " EGID: " + getegid() + " Groups: ["+currgrp+"]\n");
   }

   return res;
}

// Write file in users home directory.
// Returns 1 on success
int userfile_write(string username, string filename, string contents) {
   int res=1;
   array pwent;
   if(!(pwent=getpwnam(username))) {
      perror("IMHO: Unable to getpwnam("+username+")!\n");
      return 0;
   }

   string filepath = pwent[PW_HOME] + "/" + filename;

   object privs;
   if(!(privs=become_user(username))) {
      perror("IMHO: Failed to become user  "+username+"\n");
      return 0;
   }

   object fh=Stdio.File();
   if (fh->open(filepath, "cwt")) {
      if(! fh->write(contents)) {
         res=0;
         perror("IMHO: write() of "+filepath+" failed with error "+
                 strerror(fh->errno())+"\n");
      }
      fh->close();
   }
   else {
      res=0;
      perror("IMHO: Failed to open "+filepath+" for writing with error "+
              strerror(fh->errno())+"\n");
   }

   destruct(privs);  // Does not need to be done explicitly really.
   if (query("debug")=="on") {
      string currgrp="";
      foreach(getgroups(), int g) {
         currgrp+=g+" ";
      }
      perror("IMHO: After dropping privs: UID: " + getuid() + " EUID: " + geteuid() + 
	     " GID: " + getgid() + " EGID: " + getegid() + " Groups: ["+currgrp+"]\n");
   }

   return res;
}

// Removes file in users home directory.
void userfile_remove(string username, string filename) {
   array pwent;
   if(!(pwent=getpwnam(username))) {
      perror("IMHO: Unable to getpwnam("+username+")!\n");
      return 0;
   }

   string filepath = pwent[PW_HOME] + "/" + filename;

   object privs;
   if(!(privs=become_user(username))) {
      perror("IMHO: Failed to become user  "+username+"\n");
      return 0;
   }
   if(rm(filepath) == 0 && query("debug")=="on") {
      perror("IMHO: Failed to remove "+filepath+"\n");
   }
   destruct(privs);
}

// Load the users .forward (if any)
string load_forward(string username) {
   if (query("debug")=="on") {
       perror("IMHO: Loading .forward for user "+username+"\n");
   }
   return userfile_read(username, ".forward");
}

// Save the users .forward unless empty, then the existing .forward is removed
void save_forward(string username, string newfwd) {
   string oldfwd = load_forward(username);

   newfwd = newfwd-"\r";

   if (newfwd!=oldfwd) {
      if (newfwd-"\r"-"\n"-"\t"-" " == "") {
         if (query("debug")=="on") {
             perror("IMHO: Removing .forward for user "+username+"\n");
         }
         userfile_remove(username, ".forward");
      }
      else {
         if (query("debug")=="on") {
             perror("IMHO: Saving .forward for user "+username+"\n");
         }
         userfile_write(username, ".forward", newfwd);
      }
   }
   else {
      if (query("debug")=="on") {
          perror("IMHO: .forward for user "+username+" unchanged\n");
      }
   }
}

mapping pmrcruletypes = (["^TO_":"to",
                      "^From: .*":"from",
                      "^Subject: ":"subject"]);
string pmrcruleid = "# Added with IMHO, remove this comment if edited manually!";
// Load the users .procmailrc (if any) and process it.
mapping load_procmaildata(string username) {
   if (query("debug")=="on") {
      perror("IMHO: Loading .procmailrc for user "+username+"\n");
   }
   array res=(userfile_read(username, ".procmailrc")-"\r") / "\n";

#define ACT_CONT      1
#define ACT_FINDSTART 2
#define ACT_GETRULE	 3
#define ACT_GETBOX    4

   int action=ACT_CONT,i=0, n;
   mapping rules=([]),boxes=([]), types=([]), addrs=([]);
   string heading="", processed="", lastheading="";
   foreach(res, string line) {
      switch(action) {
         case ACT_CONT:
            if(sizeof(processed)) {
               if (query("debug")=="on") {
                  perror("IMHO: -unknown:---------------------\n"+processed);
                  perror("IMHO:------------------------------\n");
               }
               heading += processed;
               processed="";
            }
            if(line == pmrcruleid) {
               action=ACT_FINDSTART;
            }
            else if(sizeof(line) || sizeof(lastheading)){
               if (query("debug")=="on") {
                  perror("IMHO: heading: "+line+"\n");
               }
               heading += line+"\n";
               lastheading=line;
            }
            break;
         case ACT_FINDSTART:
            processed += line+"\n";
            if(line == ":0:") {
               action=ACT_GETRULE;
            }
            else {
               action=ACT_CONT;
            }
            break;
         case ACT_GETRULE:
            processed += line+"\n";
            if(line[..1] == "* " && (2<(n=search(line, "("))) &&
                  reverse(line)[..0]==")" && pmrcruletypes[line[2..n-1]]) {
               rules[i]=line[2..];
               types[i]=pmrcruletypes[line[2..n-1]];
               addrs[i]=line[n+1..sizeof(line)-2];
               if (query("debug")=="on") {
                  perror("IMHO: Adding rule: "+line+"\n");
               }
               action=ACT_GETBOX;
            }
            else {
               action=ACT_CONT;
            }
            break;
         case ACT_GETBOX:
            processed += line+"\n";
            if(line[..0]!="!" && line[..0]!="|" && line[..0]!="/" && 
                  line[..0]!=" ") {
               boxes[i]=line-" ";
               i++;
               processed="";
            }
            else {
               if (query("debug")=="on") {
                  perror("IMHO: Bad mailbox: "+line+"\n");
               }
            }
            action=ACT_CONT;
            break;
      }

   }
   return(["heading":heading, "rules":rules, "boxes":boxes, "types":types,
         "addrs":addrs]);
}

// Load the relevant rules from the users .procmailrc
string load_procmail(string username) {
   mapping pmrules=load_procmaildata(username);
   string ret="";

   foreach (sort(indices(pmrules->rules)), string ruleno) {
      if (query("debug")=="on") {
         perror("IMHO: Rule: " + ruleno + " = " + pmrules->rules[ruleno] + 
		"\t\t" + pmrules->boxes[ruleno] + " " + pmrules->types[ruleno] +
		" " + pmrules->addrs[ruleno] + "\n" );
      }
      ret += pmrules->boxes[ruleno] + "\t" + pmrules->types[ruleno] + "\t" + 
	pmrules->addrs[ruleno] + "\n";
   }
    return ret;
}

// Save the relevant rules to the users .procmailrc
void save_procmail(object session, string newrules) {
   mapping oldpmrules=load_procmaildata(session->login);

   mapping typerules = ([ ]);
   foreach(indices(pmrcruletypes), string rule) {
      typerules[pmrcruletypes[rule]]=rule;
   }


   mapping boxes = ([ ]), types = ([ ]), addrs = ([ ]);
   int i=0;
   foreach((newrules-"\r")/"\n", string line) {
      string type, addr, box;
      if(5==sscanf(line, "%s%*[ \t]%s%*[ \t]%s", box, type, addr)) {
         string strip=reverse(addr);
         while(strip[..0]==" " || strip[..0]=="\t") {
            strip=strip[1..];
         }
         addr=reverse(strip);
         if(sizeof(type) && sizeof(addr) && sizeof(box) && typerules[type]) {
            boxes[i]=box;
            addrs[i]=addr;
            types[i]=type;
            i++;
         }
      }
   }

   int dowrite=0;
   if(i == sizeof(indices(oldpmrules->boxes))) {
      for(int j=0; j<i; j++) {
         if(oldpmrules->boxes[j] != boxes[j] || 
               oldpmrules->addrs[j] != addrs[j] ||
               oldpmrules->types[j] != types[j])
         {
            dowrite=1;
            break;
         }
      }
   }
   else {
      dowrite=1;
   }

   if(dowrite) {
      if (query("debug")=="on") {
          perror("IMHO: Writing .procmailrc for "+session->login+"\n");
      }
      string newpmrc=oldpmrules->heading;
      if(newpmrc=="") {
         newpmrc+="SHELL=/bin/sh\n";   // Uses user default otherwise, not good
         if(session->mailpath != "") {
            newpmrc+="MAILDIR="+replace(session->mailpath, "~", "$HOME")+"\n";
         }
         newpmrc+="\n";
      }
      foreach (sort(indices(boxes)), string ruleno) {
         newpmrc+=pmrcruleid+"\n";
         newpmrc+=":0:\n";
         newpmrc+="* "+typerules[types[ruleno]]+"("+addrs[ruleno]+")\n";
         newpmrc+=boxes[ruleno]+"\n\n";
      }
      userfile_write(session->login, ".procmailrc", newpmrc);
   }
   else {
      if (query("debug")=="on") {
         perror("IMHO: .procmailrc for user "+session->login+" unchanged\n");
      }
   }
}
#endif



string create_main(object id, int screen) {
  string main = "";
  object session = id->misc->imho->session;
  
#define MAIN main
  
  switch(screen) {

  case LOGINFAILEDIMAP:
  case LOGINFAILED:
  case LOGINPROMPT:
    {
      id->misc->imho->screen="login";

      if(query("loginmethod") == "http basic auth") {
#ifdef __ROXEN_TWO_ZERO__
	MAIN += "<auth-required />";
#else
	MAIN += "<auth_required />";
#endif
      }

      if(screen == LOGINFAILED)
	MAIN+=MSG(M_NOLOGIN)+"<br />\n<br />\n";
      else
	if(screen==LOGINFAILEDIMAP)
	  MAIN+=MSG(M_IMAPERROR)+"<br />\n<br />\n";
      string preset_login=0;
      if(plugin && plugin->imho_preset_login)
	preset_login=plugin->imho_preset_login(id);
      MAIN+="<form target=\"" + id->misc->imho->target + "\" action=\"" + 
	id->misc->imho->nexttarget + "\"" +
	" method=POST name=\"imhologinform\" autocomplete=\"off\">"+
	"<input type=\"hidden\" name=\"actionlogin\" value=\"1\">"+
	"<input type=hidden name=charsettest value=\"\" />";
      MAIN+="<table><tr><td><imho_text nfont=\"Arial Rounded\" scale=\"0.3\">"+
	MSG(M_LOGIN)+"</imho_text></td><td><imho_text nfont=\"Arial Rounded\" scale=\"0.3\">"+
	MSG(M_PASSWORD)+"</imho_text></td><td></td></tr>\n";
      MAIN+="<input type=hidden name=session value=\""+session->session+"\">";
      MAIN+="<tr><td><input name=\"login\"";
      if(id->supports->javascript)
	MAIN+=" onChange=\"this.form.passwd.focus()\"";
      if(preset_login)
	MAIN+=" value="+html_encode_tag_value(preset_login);
      MAIN+=" autocomplete=\"OFF\">"+imap_servers_selector();
      MAIN+="</td><td><input type=\"password\" name=\"passwd\"";
      // Doesnt work well with the layout chooser in Netscape 4.5 and Linux
      if(id->supports->javascript) 
	MAIN+=" onChange=\"this.form.submit()\"";
      MAIN+=" autocomplete=\"OFF\"></td><td><imho_submit value=\""+
	MSG(M_LOGIN_OK)+"\" /></td>";
      MAIN+="</tr></table>";
      if (sizeof(layouts) > 1) {
	MAIN+="<center><table><tr><td><imho_text nfont=\"Arial Rounded\" scale=\"0.3\">"+
	  MSG(M_USERINTERFACE)+"</imho_text></td></tr>";
	MAIN+="<tr><td><select name=\"layout\">";
	MAIN+="<option value=-1 SELECTED>"+MSG(M_SAVEDUSERINTERFACE)+"\n";
	foreach(indices(layouts), int i) {
	  MAIN+="<option value="+((string ) i);
	  MAIN+=">"+layouts[i]->name+"\n";
	} 
	MAIN+="</select></td></tr>";
	MAIN+="\n</table></center>";
      }
      MAIN+="</form>";
      if(id->supports->javascript) {
	MAIN+="<script language=\"JavaScript\">\n"
	  "<!--\n";
	if(preset_login)
	  MAIN+="document.imhologinform.passwd.focus();\n";
	else
	  MAIN+="document.imhologinform.login.focus();\n";
	MAIN+="// -->\n</script>\n";
      }
      MAIN+=set_imho_cookie("IMHOSession", session->session);
    }
    break;

    
  case LOGOUT: 
    {
      id->misc->imho->screen="logout";
      object lock;
      id->misc->imho->title=MSG(M_LOGGEDOUT);
      MAIN+=MSG(M_LOGOUTMSG);
      if (session->cookies) { 
	MAIN+=remove_imho_cookie("IMHOSession");
      }
#ifdef THREADS
      lock = global_lock->lock();
#endif
      destruct(session->imapclient);
      m_delete(sessions,session->session);
#ifdef THREADS
      destruct(lock);
#endif
    }
    break;

    
  case COMPOSE:
    {
      id->misc->imho->screen="compose";
      id->misc->imho->title=MSG(M_COMPOSEMAIL);
      int feature_addressbook=feature(FEAT_ADDRESSBOOK);
      int feature_ldap=feature(FEAT_LDAP);
      
      string buttons="";
      buttons+="<imho_submit name=\"actionsend\" value=\"" + MSG(M_SEND) + "\" />";
      if (feature(FEAT_SAVEDRAFTONDISK))
	buttons+="<imho_submit name=\"actionsavedraft\" value=\"" + MSG(M_SAVEDRAFT) + "\" />";
      else
	buttons+="<imho_submit name=\"actionsavedraft\" value=\"" + 
	  MSG(M_SAVEDRAFTINSESSION) + "\" />";
      buttons+=" <imho_submit name=\"actionindex\" value=\"" + MSG(M_CANCELSEND) + "\" />";
      if(sizeof(query("ispell"))) {
	buttons+=" <imho_submit name=\"actionspellcheck\" value=\"" + MSG(M_SPELLCHECK) + "\" />";
	buttons+="<select name=ispelldict>";
	foreach(query("ispelldict")/",", string dict) {
	  string dict2=dict;
	  sscanf(dict,"%s:%s",dict2,dict);
	  buttons+="<option value=\"" + dict2 + "\">" + html_encode_string(dict);
	}
	buttons+="</select>";
      }
      
      MAIN+="<table cellpadding=\"1\" cellspacing=\"0\" border=\"0\">" +
	"<form name=imhocomposeform target=\""+id->misc->imho->target+"\"" +
	" action="+id->misc->imho->nexttarget+" method=POST>" +
	"<input type=hidden name=charsettest value=\"\" />";
      if (!id->misc->imho->notopbuttons)
	MAIN+="<tr><td></td><td>"+buttons+"</td>";
      if(session->usersetupaddress) {
	MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">"+
	  MSG(M_FROM)+":</imho_text></td><td><SELECT name=\"from\" size=\"1\">";
	foreach(split_from_address(session->address), string l)
	  if (sizeof(l))
	    MAIN+="<OPTION"+(session->from == l ? " SELECTED=\"\"" : "") + " VALUE=" +
	      html_encode_tag_value(l) + ">" + session->name + " &lt;" + 
	      (html_encode_string(l)) + "&gt;</OPTION>\n";
	MAIN+="</select></td></tr>\n";
      }
      else 
	MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	  MSG(M_FROM)+":</imho_text></td><td>"+html_encode_string(session->name) +
	  " &lt;"+html_encode_string(session->address) + "&gt;</td></tr>\n";
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	MSG(M_TO)+":</imho_text></td><td><input name=to size=56 value=" +
	html_encode_tag_value(session->to) + ">"; 
      if(feature_addressbook)
	MAIN+=" <imho_submit name=\"actionaddressbookto\" value=\"" + 
	  MSG(M_ADDRESSBOOK) +  "\" />";
      if(feature_ldap)
    	MAIN+=" <imho_submit name=\"actionldapto\" value=\"" + MSG(M_LDAP) + "\" />";
      MAIN+="</td></tr>\n";
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	MSG(M_CC)+":</imho_text></td><td><input name=cc size=56 value=" +
	html_encode_tag_value(session->cc) + ">";
      if(feature_addressbook)
	MAIN+=" <imho_submit name=\"actionaddressbookcc\" value=\"" +
	  MSG(M_ADDRESSBOOK) + "\" />";
      if(feature_ldap)
    	MAIN+=" <imho_submit name=\"actionldapcc\" value=\""+MSG(M_LDAP)+"\" />";
      MAIN+="</td></tr>\n";
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	MSG(M_BCC)+":</imho_text></td><td><input name=bcc size=56 value=" +
	html_encode_tag_value(session->bcc) + ">";
      if(feature_addressbook)
	MAIN+=" <imho_submit name=\"actionaddressbookbcc\" value=\"" + 
	  MSG(M_ADDRESSBOOK) + "\" />";
      if(feature_ldap)
    	MAIN+=" <imho_submit name=\"actionldapbcc\" value=\""+MSG(M_LDAP)+"\" />";
      MAIN+="</td></tr>\n";
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	MSG(M_SUBJECT)+":</imho_text></td><td><input name=subject size=70 value=" +
	html_encode_tag_value(session->subject)+"></td></tr>\n";
      
      if(feature(FEAT_ATTACHMENTS)) {
	int no_att=sizeof(session->attachments);
	int s = no_att>4?4:(no_att<1?1:no_att);
	MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	  MSG(M_ATTACHMENTS)+":</imho_text></td><td><table cellspacing=\"0\" cellpadding=\"0\">" +
	  "<tr><td><select name=attachments multiple size="+(string) s+">";
	int i=0;
	if (sizeof(session->attachments) == 0) 
	  MAIN+= "<option value=-1>("+MSG(M_NOATTACHMENTS)+")";
	foreach(session->attachments,mapping file) {
	  MAIN+="<option value=\""+(string)i+"\">"+html_encode_string(file->fname+" ("+file->size+" bytes)");
	  i++;
	}
	MAIN+="</select></td><td><imho_submit name=\"actiongotoaddattachment\" value=\"" +
	  MSG(M_ADDATTACHMENT)+"\" /> <imho_submit name=\"actionremoveattachment\" value=\"" +
	  MSG(M_REMOVEMARKEDATTACHMENTS)+"\" /></td></tr>\n</table></tr>\n</td>";
      }
      MAIN+="<tr><td></td><td>";
      MAIN+="<textarea rows=\"20\" cols=\"70\" name=\"message\" wrap=\"physical\">" +
	html_encode_string(session->message)+"</textarea></td></tr>\n";
      if(feature(FEAT_MAILBOXES) && sizeof(session->sentfolder)) {
	if (feature(FEAT_SAVEMAILCOPY))
	  MAIN+="<tr><td></td>\n<td><input type=\"checkbox\" name=\"nosavemail\" value=\"1\" /> "+MSG(M_DONTSAVEMAIL);
	else
	  MAIN+="<tr><td></td>\n<td><input type=\"checkbox\" name=\"dosavemail\" value=\"1\" /> "+MSG(M_SAVEMAILCOPY);
      }
      if (feature(FEAT_DSN) && (query("sendmethod")=="SMTP"))
	MAIN+="&nbsp;<input type=\"checkbox\" name=\"dsndelay\" value=\"1\" /> " +
	  MSG(M_DSN_DELAY)+"<input type=\"checkbox\" name=\"dsnsuccess\" value=\"1\" /> "+MSG(M_DSN_SUCCESS);
      MAIN+="</td></tr>\n";
      MAIN+="<tr><td></td><td>";
      
      MAIN+=replace(buttons,({ "ispelldict","actionspellcheck"}),({"ispelldict2","actionspellcheck2" }) );
      
      MAIN+="</td></tr>\n</form></table>";
      if(id->supports->javascript) {
	MAIN+="<script language=\"JavaScript\">\n"
	  "<!--\n";
	MAIN+="document.imhocomposeform.to.focus();\n";
	MAIN+="// -->\n</script>\n";
      }
    }
    break;
    
  case ATTACHMENTS:
    {
      id->misc->imho->screen="attachments";
      id->misc->imho->title=MSG(M_ATTACHMENTSHEADER);
      int i=0;
      MAIN+="<center><br />\n<table ";
      if (!sizeof(query("uploaddir")))
	MAIN+="width=\"50%\""; 
      MAIN+="><tr>";
      if (sizeof(query("uploaddir"))) {
	MAIN+="<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
	MAIN+=MSG(M_ADDFILEASATTACHMENT)+"</font></th>";
      }
      MAIN+="<th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">";
      MAIN+=MSG(M_UPLOADATTACHMENT)+"</font></th></tr>\n<tr>";
      if (sizeof(query("uploaddir"))) {
	MAIN+="<td width=\"50%\" bgcolor=\"&imho_tdbgcolor;\"><form  target=\""+id->misc->imho->target+"\" method=\"post\" action=\""+id->misc->imho->nexttarget+"\"><input type=hidden name=charsettest value=\"\" />";
	MAIN+="<select name=\"attachments\" multiple size=\"3\">";
	int i=0;
	if (sizeof(session->files) == 0) 
	  MAIN+="<option value=-1>("+MSG(M_NOATTACHFILES)+")";
	foreach(session->files,mapping file) {
	  MAIN+="<option value=\""+(string)i+"\">"+html_encode_string(file->fname);
	  i++;
	}
	MAIN+="</select><br />\n<imho_submit name=\"actionaddfileattachment\" value=\""+MSG(M_ADDMARKEDTOATTACHMENTS)+"\" /></form></td>";
      }
      MAIN+="<td width=\"50%\" bgcolor=\"&imho_tdbgcolor;\"><form name=\"imhouploadform\" target=\""+id->misc->imho->target+"\" method=\"post\" enctype=\"multipart/form-data\" action=\""+id->misc->imho->nexttarget+"\"><br />\n";
      MAIN+="<input name=\"file\" type=\"file\">";
      if(id->supports->javascript)
	MAIN+="<input type=\"hidden\" name=\"fixedfilename\" value=\"\" /><br />\n";
      else
	MAIN+="<br />\n"+MSG(M_WINDOWSBUG);
      MAIN+="<br />\n<input type=\"hidden\" name=\"actionuploadattachment\" value=\"1\" />";
      MAIN+="<imho_submit value=\""+MSG(M_UPLOADTOATTACHMENTS)+"\"";
      if(id->supports->javascript)
	MAIN+=" onClick=\"document.forms.imhouploadform.fixedfilename.value=document.forms.imhouploadform.file.value.replace(/\\\\/g,'\\\\\\\\')\"";
      MAIN+=" /></form><br />\n";
      MAIN+="</td>";
      MAIN+="</tr>\n</form></table>";
      MAIN+="<table><tr><td><form target=\""+id->misc->imho->target+"\" method=\"post\" action=\""+id->misc->imho->nexttarget+"\"><imho_submit name=\"actioncontinuecompose\" value=\""+MSG(M_BACKTOCOMPOSE)+"\" /></form></td></tr>\n</table></center>";
    }
    break;

  case ADDRESSBOOK:
    {
      id->misc->imho->screen="addressbook";
      id->misc->imho->title=MSG(M_ADDRESSBOOKTITLE);
      MAIN+="<form target=\""+id->misc->imho->target+"\" method=\"post\" action=\""+id->misc->imho->nexttarget+"\"><input type=hidden name=charsettest value=\"\" />";
      MAIN+="<table width=\"100%\" cellspacing=\"1\" cellpadding=\"0\" border=\"0\"><tr>";
      MAIN+="<th class=\"mark\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\"><font class=\"mark\" color=\"&imho_thcolor;\">"+MSG(M_MARKFLAG)+"</font></th>";
      MAIN+="<th class=\"name\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+(session->recipientfield?MSG(M_INDEXNAMERECIPIENT):MSG(M_INDEXNAMEEDIT))+"</font></th>";
      MAIN+="<th class=\"address\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+MSG(M_ADDRESS)+"</font></th></tr>";
      int i = 0;
      if (sizeof(session->addressbook)==0)
	MAIN+="<tr><td>"+MSG(M_NOADDRESSES)+"</td></tr>";
      foreach(session->addressbook/"\n", string line) {
	string name = "", address = ""; 
#if __VERSION__ > 0.6
	if (sscanf(line, "%s:%s", name, address) == 2) {
#else
	  if (sscanf(string_to_unicode(line), "%s\0:%s", name, address) == 2) {
	    name=unicode_to_string(name);
	    address=unicode_to_string(address);
#endif
	    MAIN+="<tr><td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\"><input type=\"checkbox\" name=\"address"+((string) i)+"\" value=\"1\" /></td>";
	    MAIN+="<td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
	    if (session->recipientfield) {
	      MAIN+="<a target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget;
	      MAIN+="?actionaddrecipient=1&address="+http_encode_url(address)+"\">";
	      MAIN+=fix_header(name)+"</a>";
	    } else{
	      if (feature(FEAT_EDITADDRESSBOOK)) {
		MAIN+="<a target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget;
		MAIN+="?actioneditaddress=1&address="+(string) i+"\">";
		MAIN+=fix_header(name)+"</a>";
	      } else
		MAIN+=fix_header(name);
	    }
	    MAIN+="</td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">"+replace(fix_header(address),",","<br />")+"</td></tr>";
	  }
	  i++;
	}
	i = 0;
	if (sizeof(global_addressbook) > 0) {
	  MAIN+="<tr><td>&nbsp;</td>";
	  MAIN+="<td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
	  MAIN+="<b>"+MSG(M_GLOBALADDRESSES)+"</b></td></tr>";
	  foreach(global_addressbook/"\n", string line) {
	    string name = "", address = ""; 
#if __VERSION__ > 0.6
	    if (sscanf(line, "%s:%s", name, address) == 2) {
#else
	      if (sscanf(string_to_unicode(line), "%s\0:%s", name, address) == 2) {
		name=unicode_to_string(name);
		address=unicode_to_string(address);
#endif
		if (session->recipientfield)
		  MAIN+="<tr><td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\"><input type=\"checkbox\" name=\"globaladdress"+((string) i)+"\" value=\"1\" /></td>";
		else
		  MAIN+="<tr><td>&nbsp;</td>";
		MAIN+="<td class=\"name\" bgcolor=\"&imho_tdbgcolor;\">";
		if (session->recipientfield) {
		  MAIN+="<a  target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget;
		  MAIN+="?actionaddrecipient=1&address="+http_encode_url(address)+"\">";
		  MAIN+=fix_header(name)+"</a>";
		} else {
		  MAIN+=fix_header(name);
		}
		MAIN+="</td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">"+replace(fix_header(address),",","<br />")+"</td></tr>";
	      }
	      i++;
	    }
	  }

	  MAIN+="</table>";
	  if (session->recipientfield)
	    MAIN+="<imho_submit name=\"actionaddrecipients\" value=\"" +
	      MSG(M_INSERTMARKEDADDRESSES)+"\" /><imho_submit name=\"actioncontinuecompose\" value=\"" +
	      MSG(M_CANCELADDRESS)+"\" />";
	  if (feature(FEAT_EDITADDRESSBOOK))
	    MAIN+=" <imho_submit name=\"actiondeleteaddresses\" value=\"" +
	      MSG(M_DELETEMARKEDADDRESSES)+"\" /> <imho_submit name=\"actionnewaddress\" value=\"" +
	      MSG(M_NEWADDRESS)+"\" /> <imho_submit name=\"actiongotoimportaddress\" value=\"" +
	      MSG(M_IMPORTADDRESSBOOK)+"\" />";
	  MAIN+="</form><br />";
    }
    break;

  case LDAPRESULT:
    id->misc->imho->screen="ldapresult";
    id->misc->imho->title=MSG(M_LDAPTITLE);
    MAIN+="<table width=\"100%\"><tr>";
    MAIN+="<th class=\"name\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+(session->recipientfield?MSG(M_INDEXNAMERECIPIENT):MSG(M_INDEXNAMEEDIT))+"</font></th>";
    MAIN+="<th class=\"address\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+MSG(M_ADDRESS)+"</font></th>";
    if(query("ldapshowou")=="yes")
      MAIN+="<th class=\"ou\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+MSG(M_OU)+"</font></th>";
    MAIN+="<tr>";
    int i = 0;
    if (sizeof(session->ldapadd)==0)
      MAIN+="<tr><td>"+MSG(M_NOADDRESSES)+"</td></tr>";
    foreach(session->ldapadd/"\n", string line) {
      string name = "", address = "", ou="";
      if(query("ldapshowou")=="yes") {
#if __VERSION__ > 0.6
	if (sscanf(line, "%s:%s:%s", name, address, ou) == 3) {
#else
	if (sscanf(string_to_unicode(line), "%s\0:%s\0:%s", name, address, ou) == 3) {
	  name=unicode_to_string(name);
	  address=unicode_to_string(address);
	  ou=unicode_to_string(ou);
#endif
	  MAIN+="<tr><td class=\"name\" bgcolor=\"&imho_tdbgcolor;\"><a target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget;				
	  if (session->recipientfield)
	    MAIN+="?actionaddrecipient=1&address="+http_encode_url(address)+"\">";
	  MAIN+=fix_header(name)+"</a></td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">"+replace(fix_header(address),",","<br />")+"</td>";
	  MAIN+="<td class=\"ou\" bgcolor=\"&imho_tdbgcolor;\">" +replace(fix_header(ou),",","<br />")+"</td>";
	  MAIN+="</tr>";
	}
      }
      else {
#if __VERSION__ > 0.6
	if (sscanf(line, "%s:%s", name, address) == 2) {
#else
	if (sscanf(string_to_unicode(line), "%s\0:%s", name, address) == 2) {
	  name=unicode_to_string(name);
	  address=unicode_to_string(address);
#endif
	  MAIN+="<tr><td class=\"name\" bgcolor=\"&imho_tdbgcolor;\"><a target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget;
	  MAIN+="?actionaddrecipient=1&address="+http_encode_url(address)+"\">";
	  MAIN+=fix_header(name)+"</a></td><td class=\"address\" bgcolor=\"&imho_tdbgcolor;\">"+replace(fix_header(address),",","<br />")+"</td></tr>";
	}
      }
    }
    MAIN+="</table>";
    break;

  case LDAPSEARCH:
    id->misc->imho->screen="ldapsearch";
    id->misc->imho->title=MSG(M_LDAPTITLE);
    MAIN+="<form target=\""+id->misc->imho->target+"\" method=\"POST\" action=\"" + id->misc->imho->nexttarget +"\"><input type=hidden name=charsettest value=\"\" />";
    MAIN+="<center><table><th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+MSG(M_NAMECONT)+"</font></th>";
    MAIN+="<tr><td bgcolor=\"&imho_tdbgcolor;\">";
    MAIN+="<input name=\"namecont\" type=\"text\"> </td></tr>";
    MAIN+="<tr><td bgcolor=\"&imho_tdbgcolor;\">";
    MAIN+="<input name=\"actionsearchldap\" type=\"hidden\" value=\"1\"><imho_submit value=\""+MSG(M_SEARCHLDAP)+"\" /></td></tr></table></center></form>";
    break;

  case IMPORTADDRESS:
    id->misc->imho->screen="importaddress";
    id->misc->imho->title=MSG(M_ADDRESSBOOKTITLE);
    MAIN+="<form target=\""+id->misc->imho->target+"\" method=\"post\" enctype=\"multipart/form-data\"" +
      " action=\""+id->misc->imho->nexttarget+"\"><input type=hidden name=charsettest value=\"\" />";
    MAIN+="<center><table><th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" +
      MSG(M_IMPORTADDRESSBOOKTITLE)+"</font></th>";
    MAIN+="<tr><td bgcolor=\"&imho_tdbgcolor;\">";
    MAIN+=MSG(M_UPLOADADDRESSBOOK)+":<br />";
    MAIN+="<input name=\"file\" type=\"file\"><br />" + /* MSG(M_PINELOCATION) + */ "</td></tr>";
    MAIN+="<tr><td><input type=\"hidden\" name=\"actionimportaddress\" value=\"1\"><imho_submit value=\"" +
      MSG(M_UPLOADANDIMPORT)+"\" /></td></tr></table></center></form>";
    break;

  case EDITADDRESS:
    id->misc->imho->screen="editaddress";
    id->misc->imho->title=MSG(M_ADDRESSBOOKTITLE);
    MAIN+="<form target=\""+id->misc->imho->target+"\" method=\"POST\" action="+id->misc->imho->nexttarget+">" +
      "<input type=hidden name=charsettest value=\"\" />";
    MAIN+="<center><table><th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" +
      (session->editaddressmode=="old"?MSG(M_EDITADDRESS):MSG(M_ADDADDRESS))+"</font></th>";
    MAIN+="<tr><td bgcolor=\"&imho_tdbgcolor;\">";
    string name="", address="";
#if __VERSION__ > 0.6
    sscanf((session->addressbook/"\n")[((int) session->editaddress)], "%s:%s", name, address);
#else
    sscanf(string_to_unicode((session->addressbook/"\n")[((int) session->editaddress)]), "%s\0:%s", name, address);
    name=unicode_to_string(name);
    address=unicode_to_string(address);
#endif
    MAIN+=MSG(M_INDEXNAME)+":<br /><input name=\"name\" size=\"60\" value="+html_encode_tag_value(name)+"><br />";
    MAIN+=MSG(M_ADDRESSFORMAT)+":<br /><input name=\"address\" size=\"60\" value="+html_encode_tag_value(address)+"><br /></td></tr>";
    MAIN+="<tr><td><imho_submit name=\"actioneditaddressdone\" value=\""+MSG(M_SAVEADDRESS)+"\" /> <imho_submit name=\"actiondeleteaddress\" value=\""+MSG(M_DELETEADDRESS)+"\" /> <imho_submit name=\"actioncanceleditaddress\" value=\""+MSG(M_CANCELADDRESS)+"\" /></td></tr></table></center></form>";
    break;
    

  case MAILINDEX:
    id->misc->imho->screen="mailindex";
    int mails=sizeof(session->mails);
    MAIN+="<form method=\"POST\" target=\""+id->misc->imho->uptarget+"\" action=\""+id->misc->imho->nextuptarget+"\">";
    if (session->searchstring && sizeof(session->searchstring) > 0) {
      MAIN+=MSG(M_SEARCHSHOWINGMAIL);
      MAIN+= session->searchstring;
      MAIN+=":<br>";
    }
    if(mails) {
      if (session->mailssortcolumn && 
	  session->mailssortcolumn != session->sessionsortcolumn) {
	session->mailssortcolumn = session->sessionsortcolumn;
 	mapping colvals = ([ ]);
 	for(int i=0; i < mails ; i++) {
	  object mail = session->mails[i];
 	  switch(session->sessionsortcolumn) {
 	  case "date":
	    //FIXME: -1
 	    colvals[sprintf("%04d%02d%02d%02d%02d%02d",@parse_date(mail->imap->INTERNALDATE))+" "+sprintf("%08d", mail->number)]=i;
 	    break;
 	  case "from":
 	    string from_name,from_addr;
 	    if(mail->imap->ENVELOPE[FROM_IDX]) {
 	      from_name=mail->imap->ENVELOPE[FROM_IDX][0][0];
 	      from_addr=mail->imap->ENVELOPE[FROM_IDX][0][2]+"@"+mail->imap->ENVELOPE[FROM_IDX][0][3];
 	      from_addr=replace(from_addr,"@.MISSING-HOST-NAME.","");
 	    } else
 	      from_name="-";
 	    colvals[lower_case(fix_header(from_name?from_name:from_addr))+" "+(string) sprintf("%08d", mail->number)]=i;
 	    break;
 	  case "to":
 	    string to_name,to_addr;
 	    int to_no = 0;
 	    if(mail->imap->ENVELOPE[TO_IDX]) {
 	      to_name=mail->imap->ENVELOPE[TO_IDX][0][0];
 	      to_addr=mail->imap->ENVELOPE[TO_IDX][0][2]+"@"+mail->imap->ENVELOPE[TO_IDX][0][3];
 	      to_addr=replace(to_addr,"@.MISSING-HOST-NAME.","");	      
 	      to_no = sizeof(mail->imap->ENVELOPE[TO_IDX]);
 	    } else 
 	      to_name="-";
 	    colvals[lower_case(fix_header(to_name?to_name:to_addr)+(to_no>1?" ...":""))+" "+(string) sprintf("%08d", mail->number)]=i;
 	    break;
 	  case "subject":
 	    string nsub, subj = fix_header(mail->imap->ENVELOPE[SUBJECT_IDX])||"?";
 	    while (sscanf(lower_case(subj), "re:%*[ \t]%s", nsub)>=1) subj = nsub;
 	    colvals[subj+" "+(string) sprintf("%08d", mail->number)]=i;
 	    break;
 	  case "size":
 	    colvals[sprintf("%08d",((int) mail->imap["RFC822.SIZE"]))+" "+(string) sprintf("%08d", mail->number)]=i;
 	    break;
 	  default:
 	    colvals[(string) sprintf("%08d", mail->number)]=i;
 	    break;
 	  }
 	}
 
	array newmails = allocate(mails);
	//FIXME: stupid, sort both arrays at the same time.
	array order = sort(indices(colvals));
	for (int t = 0; t < mails; t++)
	  newmails[t] = session->mails[colvals[order[t]]];
	session->mails = newmails;
      }

      sscanf(session->visiblemail, "%d", session->visible);
      if (session->visible + session->firstvisiblemail > mails)
	session->firstvisiblemail = mails-session->visible;
      if (session->firstvisiblemail < 0)
	session->firstvisiblemail = 0;
      session->lastvisiblemail = session->firstvisiblemail + 
	session->visible - 1;
      if (session->lastvisiblemail+1 > mails)
	session->lastvisiblemail = mails-1;

      string buttons = "<table><tr><td>";
      if(feature(FEAT_MAILBOXES)) {
	if (session->mailbox[MB_DISPLAYNAME_IDX] == session->trashfolder) {
	  buttons+="<imho_submit name=\"actiondelete\" value=\""+MSG(M_DELETEMARKED)+"\" />";
	  buttons+="<imho_submit name=\"actiondeleteall\" value=\""+MSG(M_DELETEALLTRASH)+"\" />";
	} else {
	  if ( (<"both","move to trash">)[query("deletemethod")] &&  sizeof(session->trashfolder))
	    buttons+="<imho_submit name=\"actiontrash\" value=\""+MSG(M_MOVETOTRASH)+"\" />";
	  if ( query("deletemethod")!="move to trash" || !sizeof(session->trashfolder))
	    buttons+="<imho_submit name=\"actiondeleteask\" value=\""+MSG(M_DELETEMARKED)+"\" />";
	}
	buttons+=" <imho_submit name=\"actionmove\" value=\""+MSG(M_MOVEMARKED)+":\" />";
	buttons+="<select name=\"mbox\"><option value=\"imhonomailbox\">" + 
	  MSG(M_SELECTMBOX) + "</option>\n";
	for(int i=0;i<sizeof(session->mailboxes);i++){
	  if(!(session->mailboxes[i][MB_FLAGS_IDX] & MB_NOSELECT)) {
	    string mbox=session->mailboxes[i][MB_DISPLAYNAME_IDX];
	    if(session->mailboxes[i][MB_FOLDERNAME_IDX]!=session->mailbox[MB_FOLDERNAME_IDX]) {
	      mbox = session->imapclient->translate_frommbox(session, mbox);
	      buttons+="<option value=" + 
		html_encode_tag_value(session->mailboxes[i][MB_FOLDERNAME_IDX])+">" + 
		html_encode_string(mbox) + "</option>\n";
	    }
	  }
	}
	buttons+="</select>";
      } 
      else
	buttons+="<imho_submit name=\"actiondeleteask\" value=\"" + MSG(M_DELETEMARKED) + "\" />";
      buttons+=" <imho_submit name=\"actionsearchmail\" value=\"" + MSG(M_SEARCHMAIL) + "\" />";
      buttons+=" <imho_submit name=\"actionreload\" value=\"" + 
	MSG(M_CHECKNEWMAIL) + "\" /></td></tr>\n</table>"; 

      string mailnumbers = "";
      if (mails > session->visible) {
	int usepulldownmenu = (mails / session->visible) > 10; 

	mailnumbers+="<table><tr><td>";

	string mnrs = "" ;
	if(usepulldownmenu)
	  mnrs = "<option value=\""+(string)session->firstvisiblemail+"\" selected=\"selected\">" +
	    sprintf("%d-%d",session->firstvisiblemail+1,session->lastvisiblemail+1)+
	    "</option>\n";
	else
	  mnrs = sprintf("<bf>[%d-%d]</bf>",session->firstvisiblemail+1,
			 session->lastvisiblemail+1);
	int i = session->firstvisiblemail;
	while (i > 0) {
	  int t;
	  i -= session->visible;
	  if (i < 0)
	    i = 0;
	  t = (i+session->visible>=mails?mails-1:i+session->visible-1);
	  if(usepulldownmenu) 
	    mnrs = "<option value=\""+((string) i)+"\">" + sprintf("%d-%d",i+1,t+1) + "</option>\n" + mnrs;
	  else
	    mnrs = "<a href=\""+id->misc->imho->nextpage+"?actiongotoblock=1&msg="+((string) i)+"\">"+sprintf("[%d-%d]</a> ",i+1,t+1)+mnrs;
	}
	i = session->firstvisiblemail+session->visible;

	//FIXME: JS for autosubmit
	if(usepulldownmenu)
	  mnrs = 
	    "<select name=\"msg\">"
	    + mnrs;
	
	while (i < mails) {
	  int t;
	  t = (i+session->visible>=mails?mails-1:i+session->visible-1);
	  if(usepulldownmenu)
	    mnrs = mnrs + " <option value=\""+((string) i)+"\">" + sprintf("%d-%d",i+1,t+1) + "</option>\n";
	  else
	    mnrs = mnrs+" <a href=\""+id->misc->imho->nextpage+"?actiongotoblock=1&msg="+((string) i)+"\">"+sprintf("[%d-%d]</a>",i+1,t+1);
	  i+=session->visible;
	}
	
	if(usepulldownmenu)
	  mnrs += "</select><imho_submit name=\"actiongotoblock\" value=\"" + MSG(M_PAGEGO) + "\" /> ";

	mailnumbers+=mnrs+" ";
	if (session->firstvisiblemail > 0)
	  //FIXME: state in URL: use gotoblock instead.
	  mailnumbers += " <a href=\""+id->misc->imho->nextpage+"?actionprevblock=1\">"+html_encode_string(MSGA(M_BACKN, ({ session->visible })))+"</a>";
	if (session->lastvisiblemail+1 < mails)
	  mailnumbers += " <a href=\""+id->misc->imho->nextpage+"?actionnextblock=1\">"+html_encode_string(MSGA(M_FORWARDN, ({ session->visible })))+"</a>";
	mailnumbers += "</td></tr>\n</table>";
      }
      if (!id->misc->imho->notopbuttons)
	MAIN+=mailnumbers+buttons;
      MAIN+="<table width=\"100%\" cellspacing=\"1\" cellpadding=\"0\" border=\"0\"><tr>\n";

      array columns;
      if(!id->misc->imho->columns)
	columns=({ "num","mark","date","from","to","subject" });
      else {
	columns = Array.map(id->misc->imho->columns/",",lower_case);
	if(search(columns,"mark") == -1)
	  columns = ({ "mark" }) + columns;
	if(search(columns, "subject") == -1)
	  columns += ({ "subject" });
      }

      // hmm, replace on array no longer got side effect?
      // seems to be an optimizer bug in Pike7.2
      columns = replace(columns, 
			"fromto",
			(session->mailbox[MB_DISPLAYNAME_IDX] == session->sentfolder) ? 
			"to" : "from" );
      
      string sortarrow =
 	"<a href=\""+id->misc->imho->nextpage+"?actiontogglesortorder=1\">" +
 	"<imho_image fg=\"&imho_arrowcolor;\" bg=\"&imho_thbgcolor;\" border=\"0\" src=";
      if (session->sessionsortorder == "forward")
 	sortarrow+="\"&imhoarrowdownsrc;\" image=\"arrowdown\"";
      else 
 	sortarrow+="\"&imhoarrowupsrc;\" image=\"arrowup\"";
      
      sortarrow+=
 	" alt=\""+MSG(M_CHANGESORTORDER)+"\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
 
      foreach(columns,string column)
	switch(column) {
	case "num":
	  MAIN+="  <th class=\"num\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
	  if (session->sessionsortcolumn == column)
	    MAIN+=sortarrow;
	  else
 	    MAIN+=
 	      "<a href=\""+id->misc->imho->nextpage+"?actionchangesort=1" +
 	      "&col=" + column + "\"><imho_image fg=\"&imho_arrowcolor;\"" +
 	      " bg=\"&imho_thbgcolor;\" border=\"0\"" +
	      " src=\"&imhoarrownonesrc;\"" +
 	      " image=\"arrownone\" alt=\""+MSG(M_CHANGESORTORDER)+
 	      "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
	  MAIN+="<font class=\"num\" color=\"&imho_thcolor;\">"+MSG(M_NUMBER)+"</font></th>\n";
	  break;
	case "mark":
	  MAIN+="  <th class=\"mark\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">"
	    "<font class=\"mark\" color=\"&imho_thcolor;\">"+MSG(M_MARKFLAG)+"</font></th>\n";
	  break;
	case "new":
	  MAIN+="  <th class=\"new\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">"
	    "<font class=\"new\" color=\"&imho_thcolor;\">"+MSG(M_NEWFLAG)+"</font></th>\n";
	  break;
	case "answered":
	  MAIN+="  <th class=\"answered\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">"
	    "<font class=\"answered\" color=\"&imho_thcolor;\">" + 
	    MSG(M_ANSWEREDFLAG)+"</font></th>\n";
	  break;
	case "date":
	  MAIN+="  <th class=\"date\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
	  if (session->sessionsortcolumn == column)
	    MAIN+=sortarrow;
	  else
 	    MAIN+=
 	      "<a href=\""+id->misc->imho->nextpage+"?actionchangesort=1" +
 	      "&col=" + column + "\"><imho_image fg=\"&imho_arrowcolor;\"" +
 	      " bg=\"&imho_thbgcolor;\" border=\"0\"" +
	      " src=\"&imhoarrownonesrc;\"" +
 	      " image=\"arrownone\" alt=\""+MSG(M_CHANGESORTORDER)+
 	      "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
	  MAIN+="<font class=\"date\" color=\"&imho_thcolor;\">"+MSG(M_DATE)+"</font></th>\n";
	  break;
	case "from":
	  MAIN+="  <th class=\"from\" bgcolor=\"&imho_thbgcolor;\" width=\"20%\" valign=\"middle\">";
	  if (session->sessionsortcolumn == column)
	    MAIN+=sortarrow;
	  else
 	    MAIN+=
 	      "<a href=\""+id->misc->imho->nextpage+"?actionchangesort=1" +
 	      "&col=" + column + "\"><imho_image fg=\"&imho_arrowcolor;\"" +
 	      " bg=\"&imho_thbgcolor;\" border=\"0\"" +
	      " src=\"&imhoarrownonesrc;\"" +
 	      " image=\"arrownone\" alt=\""+MSG(M_CHANGESORTORDER)+
 	      "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
	  MAIN+="<font class=\"from\" color=\"&imho_thcolor;\">"+MSG(M_FROM)+"</font></th>\n";
	  break;
	case "to":
	  MAIN+="  <th class=\"to\" bgcolor=\"&imho_thbgcolor;\" width=\"20%\" valign=\"middle\">";
	  if (session->sessionsortcolumn == column)
	    MAIN+=sortarrow;
	  else
 	    MAIN+=
 	      "<a href=\""+id->misc->imho->nextpage+"?actionchangesort=1" +
 	      "&col=" + column + "\"><imho_image fg=\"&imho_arrowcolor;\"" +
 	      " bg=\"&imho_thbgcolor;\" border=\"0\"" +
	      " src=\"&imhoarrownonesrc;\"" +
 	      " image=\"arrownone\" alt=\""+MSG(M_CHANGESORTORDER)+
 	      "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
	  MAIN+="<font class=\"to\" color=\"&imho_thcolor;\">"+MSG(M_TO)+"</font></th>\n";
	  break;
	case "subject":
	  MAIN+="  <th class=\"subject\" bgcolor=\"&imho_thbgcolor;\" width=\"60%\" valign=\"middle\">";
	  if (session->sessionsortcolumn == column)
	    MAIN+=sortarrow;
	  else
 	    MAIN+=
 	      "<a href=\""+id->misc->imho->nextpage+"?actionchangesort=1" +
 	      "&col=" + column + "\"><imho_image fg=\"&imho_arrowcolor;\"" +
 	      " bg=\"&imho_thbgcolor;\" border=\"0\"" +
	      " src=\"&imhoarrownonesrc;\"" +
 	      " image=\"arrownone\" alt=\""+MSG(M_CHANGESORTORDER)+
 	      "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
	  MAIN+="<font class=\"subject\" color=\"&imho_thcolor;\">"+MSG(M_SUBJECT)+"</font></th>\n";
	  break;
	case "size":
	  MAIN+="  <th class=\"size\" bgcolor=\"&imho_thbgcolor;\" valign=\"middle\">";
	  if (session->sessionsortcolumn == column)
	    MAIN+=sortarrow;
	  else
 	    MAIN+=
 	      "<a href=\""+id->misc->imho->nextpage+"?actionchangesort=1" +
 	      "&col=" + column + "\"><imho_image fg=\"&imho_arrowcolor;\"" +
 	      " bg=\"&imho_thbgcolor;\" border=\"0\"" +
	      " src=\"&imhoarrownonesrc;\"" +
 	      " image=\"arrownone\" alt=\""+MSG(M_CHANGESORTORDER)+
 	      "\" size=\"&imhoarrowsize;\" scale=\"0.25\" /></a>";
	  MAIN+="<font class=\"size\" color=\"&imho_thcolor;\">"+MSG(M_SIZE)+"</font></th>\n";
	  break;
	}
      MAIN+="</tr>\n";

      if(session->sessionsortcolumn=="num") { // range select only works in mailbox order
	if (session->firstvisiblemail > 0 && session->sessionsortorder == "forward") {
	  MAIN+="<tr>\n";
	  foreach(columns,string column)
	    switch(column) {
	    case "num":
	      MAIN+="  <td class=\"num\" bgcolor=\"&imho_tdbgcolor;\">1-"+(string) ((int)session->firstvisiblemail)+"</td>\n";
	      break;
	    case "mark":
	      MAIN+="  <td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\"><input type=\"checkbox\" name=\"msg"+(string)session->mails[0]->imap->UID+"-"+(string)session->mails[(int)session->firstvisiblemail-1]->imap->UID+"\" value=\"1\" /></td>\n";
	      break;
	    case "subject":
	      MAIN+="  <td class=\"subject\" bgcolor=\"&imho_tdbgcolor;\">"+
		MSGA(M_MAILSHOWN, 
		     ({ 1, session->firstvisiblemail, mails }))+"</td>\n";
	      break;
	    default:
	      MAIN+="  <td class=\""+column+"\">&nbsp;</td>\n";
	      break;
	    }
	  MAIN+="</tr>\n";
	}
	if (session->lastvisiblemail+1 < mails && session->sessionsortorder != "forward") {
	  MAIN+="<tr>\n";
	  foreach(columns,string column)
	    switch(column) {
	    case "num":
	      MAIN+="  <td class=\"num\" bgcolor=\"&imho_tdbgcolor;\">"+(string) ((int) session->lastvisiblemail+2)+"-"+(string) ((int)mails)+"</td>\n";
	      break;
	    case "mark":
	      MAIN+="  <td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\"><input type=\"checkbox\" name=\"msg"+(string)session->mails[((int) session->lastvisiblemail+1)]->imap->UID+"-"+(string)session->mails[((int)mails-1)]->imap->UID+"\" value=\"1\" /></td>\n";
	      break;
	    case "subject":
	      MAIN+="  <td class=\"subject\" bgcolor=\"&imho_tdbgcolor;\">"+
		MSGA(M_MAILSHOWN, 
		     ({ session->lastvisiblemail+2, mails, mails }))+"</td>\n";
	      break;
	    default:
	      MAIN+="  <td class=\""+column+"\">&nbsp;</td>\n";
	      break;
	    }
	  MAIN+="</tr>\n";
	}
      }

      int frommail, tomail, deltamail;
      if (session->sessionsortorder == "forward") {
	frommail = session->firstvisiblemail;
	tomail = session->lastvisiblemail+1;
	deltamail = 1;
      } else {
	tomail = session->firstvisiblemail-1;
	frommail = session->lastvisiblemail;
	deltamail = -1;
      }
      for (int i = frommail; i != tomail; i+=deltamail) {
	object mail = session->mails[i];
	MAIN+="<tr>\n";
	// New mail?
	int seen = (search(mail->imap->FLAGS,"\\Seen")==-1);
	foreach(columns,string column)
	  switch(column) {
	  case "num": 
	    MAIN+="  <td class=\""+(seen?"h":"")+"num\" bgcolor=\"&imho_tdbgcolor;\"><b>"+(string)(session->mails[i]->number+1)+"</b></td>\n";
	    break;
	  case "mark":
	    MAIN+="  <td class=\""+(seen?"h":"")+"mark\" bgcolor=\"&imho_tdbgcolor;\"><input type=\"checkbox\" name=\"msg"+(string)session->mails[i]->imap->UID+"\" value=\"1\" /></td>\n";
	    break;
	  case "new":
	    MAIN+="  <td class=\""+(seen?"h":"")+"new\" bgcolor=\"&imho_tdbgcolor;\">"
	      +(seen?"<imho_image src=\"&imhochecksrc;\" fg=\"&imhocheckfg;\" bg=\"&imho_tdbgcolor;\" size=\"&imhochecksize;\" scale=\"0.25\" image=\"check\" alt=\"X\" />":"&nbsp;")+"</td>\n";
	    break;
	  case "answered":
	    // Answered?
	    MAIN+="  <td class=\""+(seen?"h":"")+"answered\" bgcolor=\"&imho_tdbgcolor;\">"
	      +(search(mail->imap->FLAGS,"\\Answered")==-1?"&nbsp;":"<imho_image src=\"&imhochecksrc;\" fg=\"&imhocheckfg;\" bg=\"&imho_tdbgcolor;\" size=\"&imhochecksize;\" scale=\"0.25\" image=\"check\" alt=\"X\" />")+"</td>\n";
	    break;
	  case "date":
	    // Date
	    MAIN+="  <td class=\""+(seen?"h":"")+"date\" bgcolor=\"&imho_tdbgcolor;\"><NOBR>"+(seen?"<b>":"")+translate_date(mail->imap->INTERNALDATE)+(seen?"</b>":"")+"</NOBR></td>\n";
	    break;
	  case "from":
	    // From
	    string from_name,from_addr;
	    if(mail->imap->ENVELOPE[FROM_IDX]) {
	      from_name = mail->imap->ENVELOPE[FROM_IDX][0][0];
	      from_addr = mail->imap->ENVELOPE[FROM_IDX][0][2] + "@" +
		mail->imap->ENVELOPE[FROM_IDX][0][3];
	      from_addr = replace(from_addr,"@.MISSING-HOST-NAME.","");	      
	    } else 
	      from_name = "-";
	    MAIN+="  <td class=\""+(seen?"h":"")+"from\" bgcolor=\"&imho_tdbgcolor;\">"+(seen?"<b>":"")+fix_header(from_name?from_name:from_addr)+(seen?"</b>":"")+"</td>\n";
	    break;
	  case "to":
	    // To
	    string to_name,to_addr;
	    int to_no = 0;
	    if(mail->imap->ENVELOPE[TO_IDX]) {
	      to_name=mail->imap->ENVELOPE[TO_IDX][0][0];
	      to_addr=mail->imap->ENVELOPE[TO_IDX][0][2]+"@"+mail->imap->ENVELOPE[TO_IDX][0][3];
	      to_addr=replace(to_addr,"@.MISSING-HOST-NAME.","");	      
	      to_no = sizeof(mail->imap->ENVELOPE[TO_IDX]);
	    } else 
	      to_name="-";
	    MAIN+="  <td class=\""+(seen?"h":"")+"to\" bgcolor=\"&imho_tdbgcolor;\">"+(seen?"<b>":"")+fix_header(to_name?to_name:to_addr)+(to_no>1?" ...":"")+(seen?"</b>":"")+"</td>\n";
	    break;
	  case "subject":
	    // Subject
	    MAIN+="  <td class=\""+(seen?"h":"")+"subject\" bgcolor=\"&imho_tdbgcolor;\">"+(seen?"<b>":"")+"<a target=\""+id->misc->imho->sidetarget+"\" href=\""+id->misc->imho->nextsidetarget+"?actionread=1&msguid="+(string)session->mails[i]->imap->UID+"&mbox="+http_encode_url(session->mailbox[MB_FOLDERNAME_IDX])+"\">";
	    string sub = fix_header(mail->imap->ENVELOPE[SUBJECT_IDX]);
	    if (strlen(sub) == 0)
	      MAIN+= "?";
	    else
	      MAIN+= sub;
	    MAIN+= "</a>"+(seen?"</b>":"")+"</td>\n";
	    break;
	  case "size":
	    // Size
	    int kb = (((int) mail->imap["RFC822.SIZE"]+512)/1024);
	    MAIN+="  <td align=\"right\" class=\""+(seen?"h":"")+"size\" bgcolor=\"&imho_tdbgcolor;\">"+(seen?"<b>":"")+((string) kb)+" K"+(seen?"</b>":"")+"</td>\n";
	    break;
	  }
	MAIN+="</tr>\n";
      }

      if(session->sessionsortcolumn == "num") { // range select only works in mailbox order
	if (session->firstvisiblemail > 0 && session->sessionsortorder != "forward") {
	  MAIN+="<tr>\n";
	  foreach(columns,string column)
	    switch(column) {
	    case "num":
	      MAIN+="  <td class=\"num\" bgcolor=\"&imho_tdbgcolor;\">1-"+(string) ((int)session->firstvisiblemail)+"</td>\n";
	      break;
	    case "mark":
	      MAIN+="  <td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\"><input type=\"checkbox\" name=\"msg"+(string)session->mails[0]->imap->UID+"-"+(string)session->mails[(int)session->firstvisiblemail-1]->imap->UID+"\" value=\"1\" /></td>\n";
	      break;
	    case "subject":
	      MAIN+="  <td class=\"subject\" bgcolor=\"&imho_tdbgcolor;\">"+
		MSGA(M_MAILSHOWN, 
		     ({ 1, session->firstvisiblemail, mails }))+"</td>\n";
	      break;
	    default:
	      MAIN+="  <td class=\""+column+"\">&nbsp;</td>\n";
	      break;
	    }
	  MAIN+="</tr>\n";
	}
	if (session->lastvisiblemail+1 < mails && session->sessionsortorder == "forward") {
	  MAIN+="<tr>\n";
	  foreach(columns,string column)
	    switch(column) {
	    case "num":
	      MAIN+="  <td class=\"num\" bgcolor=\"&imho_tdbgcolor;\">"+(string) ((int) session->lastvisiblemail+2)+"-"+(string) ((int)mails)+"</td>\n";
	      break;
	    case "mark":
	      MAIN+="  <td class=\"mark\" bgcolor=\"&imho_tdbgcolor;\"><input type=\"checkbox\" name=\"msg"+(string)session->mails[(int) session->lastvisiblemail+1]->imap->UID+"-"+(string)session->mails[(int)mails-1]->imap->UID+"\" value=\"1\" /></td>\n";
	      break;
	    case "subject":
	      MAIN+="  <td class=\"subject\" bgcolor=\"&imho_tdbgcolor;\">"+
		MSGA(M_MAILSHOWN, 
		     ({ session->lastvisiblemail+2, mails, mails }))+"</td>\n";
	      break;
	    default:
	      MAIN+="  <td class=\""+column+"\">&nbsp;</td>\n";
	      break;
	    }
	  MAIN+="</tr>\n";
	}
      }

      MAIN+="</table>";

      if(id->supports->javascript)
	MAIN+="<input type=\"checkbox\" name=\"all\" onClick=\"for(var i=0;i<this.form.elements.length;i++){var inpt=this.form.elements[i]; var m=inpt.name.match(/-/g);if((inpt.name.substr(0,3)=='msg') && (m<1)) inpt.checked=this.form.all.checked}\" />"+MSG(M_MARKALL);
      MAIN+="<br />\n";
      

      if (!id->misc->imho->nobottombuttons) {
	MAIN+=mailnumbers;
	MAIN+=replace(buttons, 
		      ({ "name=\"mbox\"", "name=\"actionmove\""  }), 
		      ({ "name=\"mbox2\"","name=\"actionmove2\"" }) );
      }
    }
    else
      MAIN+="<br />\n"+MSG(M_NOMAILS)+"<br />\n<imho_submit name=\"actionreload\" value=\""+MSG(M_CHECKNEWMAIL)+"\" />";
    MAIN+="</form>";
    
    break;
    
  case SEARCHMAIL:
    id->misc->imho->screen="searchmail";
    id->misc->imho->title=MSG(M_SEARCHMAILTITLE);
    
    MAIN+="<form target=\""+id->misc->imho->target+"\" method=\"POST\" action="+id->misc->imho->nexttarget+"><input type=hidden name=charsettest value=\"\" />";
    MAIN+="<center><table><th bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+
      MSG(M_SEARCHMAILTITLE)+"</font></th>";
    MAIN+="<tr><td bgcolor=\"&imho_tdbgcolor;\">";
    MAIN+=MSGA(M_SEARCHMAILBOX, ({ session->mailbox[MB_DISPLAYNAME_IDX] }));
    MAIN+="<br />";
    MAIN+="<input name=\"text1\" size=\"20\" />";
    MAIN+="<select name=\"searchfield1\">";
    MAIN+="<option value=\"text\" SELECTED=\"SELECTED\">"+MSG(M_SEARCHANYWHERE)+"</option>";
    MAIN+="<option value=\"to\">"+MSG(M_SEARCHTOFIELD)+"</option>";
    MAIN+="<option value=\"from\">"+MSG(M_SEARCHFROMFIELD)+"</option>";
    MAIN+="<option value=\"subject\">"+MSG(M_SEARCHSUBJECT)+"</option>";    
    MAIN+="<option value=\"body\">"+MSG(M_SEARCHBODY)+"</option>";
    MAIN+="</select><br /><br />";
    MAIN+="<imho_submit name=\"actionsearchmail\" value=\""+MSG(M_SEARCHMAIL)+"\" />";
    MAIN+="</td></tr></table></form>";
    break;

  case FOLDERLIST:
    {
      id->misc->imho->screen="folderlist";
      id->misc->imho->title=MSG(M_MAILBOXES);
      string path=id->variables->path || session->lastpath;
      string pathname;
      int deletable_folders=0;
      int can_create_folders=1;
      int mbox_idx=Array.search_array(session->mailboxes,
				      lambda(array a,string path) 
				      {
					if(a[MB_FOLDERNAME_IDX] == path)
					  return 1;
					return 0;
				      },
				      path); 
      array mbox_path=({ });
      if(mbox_idx==-1) {
	path="";
	pathname="";
      }
      else {
	pathname=session->mailboxes[mbox_idx][MB_DISPLAYNAME_IDX];
	mbox_path=session->mailboxes[mbox_idx][MB_HIERARCHY_IDX];
	if(session->mailboxes[mbox_idx][MB_FLAGS_IDX] & MB_IMPLICIT_FOLDER)
	  can_create_folders=0;
      }
      session->lastpath=path;
      array mboxes_to_show=Array.filter(session->mailboxes,
					lambda(array a,array mbox_path) 
					{
					  if(sizeof(a[MB_HIERARCHY_IDX]) != sizeof(mbox_path)+1)
					    return 0;
					  int i;
					  for(i=0;i<sizeof(mbox_path);i++)
					    if(mbox_path[i]!=a[MB_HIERARCHY_IDX][i])
					      return 0;
					
					  return 1;
					},
					mbox_path); 

      if(path!="") {
	mboxes_to_show=({ ({ "",(session->mailboxes[mbox_idx][MB_HIERARCHY_IDX][0..sizeof(session->mailboxes[mbox_idx][MB_HIERARCHY_IDX])-2])*session->mailboxes[mbox_idx][MB_SEPARATOR_IDX],MB_NOSELECT|MB_PREVIOUS_FOLDER,"",({ MSG(M_PREVIOUS_LEVEL) }) }) }) + mboxes_to_show;
      }


      string tmp_s="";
      int i=0;
      int i2=-1;
      foreach(mboxes_to_show,array mbox_a) {
	i2++;
	int deletable=!((mbox_a[MB_FLAGS_IDX] & MB_PREVIOUS_FOLDER) ||
			mbox_a[MB_FOLDERNAME_IDX]=="INBOX" ||
			(mbox_a[MB_FLAGS_IDX] & MB_IMPLICIT_FOLDER) ||
			// folder has children?
			(Array.search_array(session->mailboxes,
					    lambda(array a,array mbox_path) 
					    {
					      if(sizeof(a[MB_HIERARCHY_IDX]) <= sizeof(mbox_path))
						return 0;
					      int i;
					      for(i=0;i<sizeof(mbox_path);i++)
						if(mbox_path[i]!=a[MB_HIERARCHY_IDX][i])
						  return 0;
					      return 1;
					    },
					    mbox_a[MB_HIERARCHY_IDX]) 
			 != -1 )
			 
			);
      
	deletable_folders |= deletable;

	// jjw 11/2000
	if ( ( i % 3 ) == 0 )
	  tmp_s += "<tr>";
      
	string mbox_name = mbox_a[MB_HIERARCHY_IDX][-1];
	mbox_name = session->imapclient->translate_frommbox(session,mbox_name);
            
	tmp_s += "<td class=mark bgcolor=&imho_tdbgcolor;>";
      
	if ( deletable )
	  tmp_s+="<input type=\"checkbox\" name="+html_encode_tag_value("delf_"+mbox_a[MB_FOLDERNAME_IDX])+" value=\"1\" />";
	else
	  tmp_s += "&nbsp;";
      
	tmp_s += "</td><td class=\"mailbox\" bgcolor=\"&imho_tdbgcolor;\">";
      
	if((! (mbox_a[MB_FLAGS_IDX] & (MB_NOSELECT | MB_IMPLICIT_FOLDER))) &&
	   (! (mbox_a[MB_FLAGS_IDX] & (MB_NOINFERIORS)))) {
	  // Both mailbox and subdir
	  if (session->mailboxstyle == "Plus") {
	    tmp_s+="<a class=\"mailbox\" target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget+"?actionfolderlistshow=1&path="+http_encode_url(mbox_a[MB_FOLDERNAME_IDX])+"\">";
	    tmp_s+="(+)</a>";
	    tmp_s+="<a class=\"mailbox\" target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget+"?actionmailindex=1&mbox="+http_encode_url(mboxes_to_show[i2][MB_FOLDERNAME_IDX])+"\">";
	    tmp_s+="<img border=\"0\" src=\"&imho_folder;\"> ";
	    tmp_s += mbox_name+"</a></td>";
	  } else {
	    tmp_s+="<table cellspacing=\"0\" cellpadding=\"2\" border=\"0\"><tr>";
	    tmp_s+="<td class=\"mailbox\" bgcolor=\"&imho_tdbgcolor;\">";
	    tmp_s+="<a class=\"mailbox\" target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget+"?actionfolderlistshow=1&path="+http_encode_url(mbox_a[MB_FOLDERNAME_IDX])+"\">";
	    tmp_s+="<img border=\"0\" src=\"&imho_folder;\"></a> ";
	    tmp_s+="</td><td class=\"mailbox\" bgcolor=\"&imho_tdbgcolor;\">";
	    tmp_s+="<a class=\"mailbox\" target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget+"?actionmailindex=1&mbox="+http_encode_url(mboxes_to_show[i2][MB_FOLDERNAME_IDX])+"\">";
	    tmp_s += mbox_name+"</a></td></tr></table></td>";
	  }
	} else if (! (mbox_a[MB_FLAGS_IDX] & (MB_NOSELECT | MB_IMPLICIT_FOLDER))) {
	  // Only mailbox
	  tmp_s+="<a class=\"mailbox\" target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget+"?actionmailindex=1&mbox="+http_encode_url(mboxes_to_show[i2][MB_FOLDERNAME_IDX])+"\">";
	  if (session->mailboxstyle == "Plus")
	    tmp_s+="<img border=\"0\" src=\"&imho_folder;\"> ";
	  tmp_s += mbox_name+"</a></td>";
	
	} else if (! (mbox_a[MB_FLAGS_IDX] & (MB_NOINFERIORS))) {
	  // Only subdir
	  tmp_s+="<a class=\"mailbox\" target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget+"?actionfolderlistshow=1&path="+http_encode_url(mbox_a[MB_FOLDERNAME_IDX])+"\">";
	  if (session->mailboxstyle == "Plus")
	    tmp_s+="(+) ";
	  else
	    tmp_s+="<img border=\"0\" src=\"&imho_folder;\"> ";
	  tmp_s += mbox_name+"</a></td>";
	}
      
	if ( ( i % 3 ) == 2 )
	  tmp_s += "</tr>\n";
      
	i++;
      }

      int cols=i;
      if (cols>3)
	cols=3;
      if(pathname!="")
	MAIN+=MSG(M_FOLDER_PATH)+" "+html_encode_string(pathname)+"<br />";
      MAIN+="<form method=\"POST\" action="+id->misc->imho->nextpage+"><input type=\"hidden\" name=\"charsettest\" value=\"\" />";
      MAIN+="<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\">";
      MAIN+="<tr><th class=\"mark\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+MSG(M_MARKFLAG)+"</font></th>";
      MAIN+="<th class=\"mailbox\" bgcolor=\"&imho_thbgcolor;\" width=\""+(int)(100/cols)+"%\"><font color=\"&imho_thcolor;\">"+MSG(M_MBOXNAME)+"</font></th>";
      if(cols>=2) {
	MAIN+="<th class=\"mark\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+MSG(M_MARKFLAG)+"</font></th>";
	MAIN+="<th class=\"mailbox\" bgcolor=\"&imho_thbgcolor;\" width=\""+(int)(100/cols)+"%\"><font color=\"&imho_thcolor;\">"+MSG(M_MBOXNAME)+"</font></th>";
      }
      if(cols>=3) {
	MAIN+="<th class=\"mark\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">"+MSG(M_MARKFLAG)+"</font></th>";
	MAIN+="<th class=\"mailbox\" bgcolor=\"&imho_thbgcolor;\" width=\""+(int)(100/cols)+"%\"><font color=\"&imho_thcolor;\">"+MSG(M_MBOXNAME)+"</font></th>";
      }
      MAIN+="</tr>\n";

      MAIN+=tmp_s;

      if (cols==3 && (i % 3) == 0)
	tmp_s+="<td></td><td></td></tr>\n";
      if (cols>1 && (i % 3) == 1)
	tmp_s+="<td></td></tr>\n";


      MAIN+="</table><table><tr><td>";
      if(deletable_folders)
	MAIN+="<imho_submit name=\"actiondeletefolder\" value=\""+MSG(M_DELETEMARKEDMBOX)+"\" />";
      if(feature(FEAT_USERSPECIFYINBOXES))
	MAIN+="<imho_submit name=\"actionchangeinboxes\" value=\""+MSG(M_USEMARKEDINMENULIST)+"\" />";
      if(can_create_folders) {
	MAIN+=" <imho_submit name=\"actioncreatefolder\" value=\""+MSG(M_CREATEMBOX)+":\" />";
	MAIN+="<input name=\"foldername\" value=\""+MSG(M_NEWMBOXNAME)+"\" />";
      }
      MAIN+="<input type=\"hidden\" name=\"path\" value=\""+path+"\" />";
      MAIN+="</td></tr>\n</table></form>";
    }
    break;




  case READMAIL:
    id->misc->imho->screen="readmail";
    id->misc->imho->title=MSG(M_MAIL);
    session->cmailidx = -1;
    session->cmailidx = Array.search_array(session->mails,
					   lambda(mapping m,int uid){
					     return ((int) m->imap->UID)==uid;
					   },
					     session->cmailuid );
    object mail = session->cmail;
    if(!mail || session->cmailidx < 0) {
      MAIN+=MSG(M_MAILMISSING);
      if(id->misc->imho->nobackbutton) {
	MAIN+="<br />\n<form method=POST action="+id->misc->imho->nextpage+"><input type=hidden name=action value=index>";
	MAIN+=" <imho_submit value=\""+MSG(M_MAILMISSINGBACK)+"\" /></form>";
      }
      break;
    }
    if(sizeof(session->mails) > session->cmailidx && search((session->mails[session->cmailidx]->imap->FLAGS),"\\Seen")==-1)
      session->mails[session->cmailidx]->imap->FLAGS+=({ "\\Seen" });
    if (!mail->headers->to)
      mail->headers->to = "?"; 
    if (!mail->headers->from)
      mail->headers->from = "?"; 


    string buttons = "";
    buttons+="<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td><form target=\""+id->misc->imho->uptarget+"\" method=\"post\" action=\""+id->misc->imho->nextuptarget+"\">";
    // Reply
    buttons+="<imho_submit name=\"actionreply\" value=\""+MSG(M_REPLY)+"\" />";
    // Reply to all
    buttons+="<imho_submit name=\"actionreplytoall\" value=\""+MSG(M_REPLYTOALL)+"\" />";
    // Forward
    buttons+=" <imho_submit name=\"actionforward\" value=\""+MSG(M_FORWARD)+"\" />";
    buttons+="<input type=\"hidden\" name=\"mbox\" value="+html_encode_tag_value(session->mailbox[MB_FOLDERNAME_IDX])+" />";
    buttons+="<input type=\"hidden\" name=\"msg"+session->cmailuid+"\" value=\"1\" />";
    buttons+="</form></td><td>";
    buttons+="<form method=\"post\" action=\""+id->misc->imho->nextpage+"\">";
    buttons+="<input type=\"hidden\" name=\"mbox\" value="+html_encode_tag_value(session->mailbox[MB_FOLDERNAME_IDX])+" />";
    buttons+="<input type=\"hidden\" name=\"msg"+session->cmailuid+"\" value=\"1\" />";
    int nextuid=-1;
    int prevuid=-1;
    if (sizeof(session->mails) > session->cmailidx + 1)
      nextuid=((int) session->mails[(session->cmailidx)+1]->imap->UID);
    if (session->cmailidx > 0)
      prevuid=((int) session->mails[(session->cmailidx)-1]->imap->UID);
    buttons+="<input type=hidden name=nextuid value="+nextuid+">";
    buttons+="<input type=hidden name=prevuid value="+prevuid+"> ";
    if (session->mailbox[MB_DISPLAYNAME_IDX] != session->trashfolder) {
      if (feature(FEAT_MAILBOXES) && sizeof(session->trashfolder) && (<"both","move to trash">)[query("deletemethod")] )
	// Move to trash
	buttons+="<imho_submit name=\"actiontrashthis\" value=\""+MSG(M_MOVETHISTOTRASH)+"\" />";
      if ( !feature(FEAT_MAILBOXES) || query("deletemethod")!="move to trash" || !sizeof(session->trashfolder))
	// Delete
	buttons+="<imho_submit name=\"actiondeletethis\" value=\""+MSG(M_DELETE)+"\" />";
    }
    if (session->showhiddenheaders == "yes") {
      // Show/hide headers
      if (session->showheaders)
	buttons+=" <imho_submit name=\"actionhideheaders\" value=\""+MSG(M_HIDEFULLHEADERS)+"\" /> ";
      else
	buttons+=" <imho_submit name=\"actionshowheaders\" value=\""+MSG(M_SHOWFULLHEADERS)+"\" /> ";
    }
    // Read previous/next
    if (prevuid!=-1)
      buttons+="<nobr><imho_submit name=\"actionreadprev\" value=\"<- "+MSG(M_READPREV)+"\" />";
    if (nextuid!=-1)
      buttons+="<imho_submit name=\"actionreadnext\" value=\""+MSG(M_READNEXT)+" ->\" /></nobr>";
    buttons+="</form></td></tr></table>\n";

    int feature_addressbook=feature(FEAT_EDITADDRESSBOOK);
    
    if (!id->misc->imho->notopbuttons)
      MAIN+=buttons;

    MAIN+="<table cellpadding=\"0\" cellspacing=\"1\" border=\"0\">";
    MAIN+="<tr><td><b>";
    if(feature_addressbook)
      MAIN+="<a target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget+"?actionnewaddress=1&address="+http_encode_url(mail->headers->from)+"&take=1\">";
    MAIN+=""+MSG(M_FROM)+":";
    if(feature_addressbook)
      MAIN+="</a>";
    MAIN+="</b></td><td>"+fix_header(mail->headers->from);
#if constant(Image.XFace.decode)
    if(mail->headers["x-face"]) {
      MAIN+=" <img src=" +
	html_encode_tag_value(id->misc->imho->nextpage + "?xface=" + 
			      http_encode_url(MIME.encode_base64(mail->headers["x-face"]))) + 
	" alt=\":-)\">";
    }
#endif    
    MAIN+="</td></tr><tr><td><b>";
    if(feature_addressbook)
      MAIN+="<a target=\"" + id->misc->imho->target + "\" href=\"" + 
	id->misc->imho->nexttarget + "?actionnewaddress=1&address=" + 
	http_encode_url(mail->headers->to)+"&take=1\">";
    MAIN+=""+MSG(M_TO)+":";
    if(feature_addressbook)
      MAIN+="</a>";
    string fixedto = mail->headers->to, fixedtoadd;
    if (sscanf(mail->headers->to, "\"%s\" %s", fixedto, fixedtoadd) == 2)
      fixedto += " "+fixedtoadd;
    MAIN+="</b></td><td>"+fix_header(fixedto)+"</td></tr>";
    if (mail->headers->cc) {
      MAIN+="<tr><td><b>";
      if(feature_addressbook)
	MAIN+="<a target=\""+id->misc->imho->target+"\" href=\""+id->misc->imho->nexttarget+"?actionnewaddress=1&address="+http_encode_url(mail->headers->cc)+"&take=1\">";
      MAIN+=""+MSG(M_CC)+":";
      if(feature_addressbook)
	MAIN+="</a>";
      MAIN+="</b></td><td>"+fix_header(mail->headers->cc)+"</td></tr>";
    }
    MAIN+="<tr><td>";
    MAIN+="<b>"+MSG(M_TIME)+":</b></td><td>"+fix_header(mail->headers->date);
    MAIN+="</td></tr><tr><td>";
    MAIN+="<b>"+MSG(M_SUBJECT)+":</b></td><td>"+fix_header(mail->headers->subject);
    MAIN+="</td></tr>";

    if (session->showheaders) { 
      foreach(indices(mail->headers), string h) { 
	if (!(<"to","from","cc","date","subject">)[h]) {
	  foreach(mail->headers[h]/"\0",string h2) {
	    MAIN+="<tr><td>";
	    MAIN+="<b>"+h+":</b></td><td>"+fix_header(h2)+"</td></tr>";
	  }
	}
      }
    }
    MAIN+="</table>";

    array(object) msgs = ({ });
    if(mail->body_parts) 
      msgs += mail->body_parts;
    else
      msgs += ({ mail });

    int p=0, msgshown = 0, part = 0;
    mapping refparts = ([ ]);
    array(string) partnos = ({ });
    array parenttypes = ({ });
    mapping parenttype = 0;
    string partno;
    object mess;
    foreach (msgs, mess) {
      partnos += ({ ((string) p++) });
      parenttypes += ({ ([ "type":mail->type, "subtype":mail->subtype]) });
    }
    for(mess = msgs[0]; mess != 0;) {
      partno = partnos[0];
      parenttype = parenttypes[0];
      msgs = msgs[1..];
      partnos = partnos[1..];
      parenttypes = parenttypes[1..];
      if (mess->body_parts) {
	msgs = mess->body_parts + msgs;
	for (p = sizeof(mess->body_parts)-1; p >= 0; p--) {
	  partnos =  ({ partno +","+((string) p) }) + partnos;
	  parenttypes = ({ ([ "type":mess->type, "subtype":mess->subtype]) }) +
	    parenttypes;
	}
      } else {
	string name=fix_coding(mess->disp_params["filename"] || mess->params["name"] || "");
	MAIN+="<table width=\"100%\" bgcolor=\"&imho_tdbgcolor;\"><tr><td>";
	
	int linkshown = 0;
	if(!(!msgshown && mess->type == "text" &&
	   (parenttype->type == "multipart" && 
	    parenttype->subtype == "alternative")?((feature(FEAT_SHOWHTML)&&(session->showhtml=="yes"))?0:mess->subtype=="plain"):(mess->subtype == "plain"))) {
	  linkshown = 1;
	  MAIN+="<a href=\""+id->misc->imho->nextpage+"/"+(sizeof(name)?http_encode_url(name):"unknown")+"?mailpart="+partno+"\"><img src=\""+image_from_type(((mess->type)/"/")[0])+"\" alt=\"\" border=\"0\"> ";
	  MAIN+=replace(MSGA(M_ATTACHMENTLINK,({sizeof(name)?html_encode_string(name)+", ":"","\0" })),"\0",mess->type+"/"+mess->subtype )+"</a>";
	}
	// Big if-clause to find out whether this part should be shown...
	if(mess->type == "text" && 
	   (!mess->headers["content-id"] || 
	    !refparts[mess->headers["content-id"]]) &&
	   (parenttype->type == "multipart" && 
	    parenttype->subtype == "alternative")?((feature(FEAT_SHOWHTML)&&(session->showhtml=="yes"))?(mess->subtype == "html"):(mess->subtype == "plain")):(mess->subtype == "plain" || (feature(FEAT_SHOWHTML)&&(session->showhtml=="yes") && mess->subtype == "html"))) {
	  string data = mess->getdata()||"";
	  msgshown = 1;
	  if (linkshown)
	    MAIN+="<hr />";
	  if (sizeof(data) > ((int) query("maxmailsize"))) {
	    MAIN+="<a href=\""+id->misc->imho->nextpage+"/"+(sizeof(name)?http_encode_url(name):"mail.txt")+"?mailpart="+partno+"\"><img src=\""+image_from_type(((mess->type)/"/")[0])+"\" alt=\"\" border=\"0\">"+MSG(M_MAILTOOBIG)+"</a>";
	  }
	  else {
	    mixed err=0;
	    string _mess;
	    err=catch { _mess=Locale.Charset->decoder(mess->charset)->feed(data)->drain(); };
	    if(err)
	      MAIN+=" "+replace(MSGA(M_CHARSETWARNING,({ "\0" })),"\0",html_encode_string(mess->charset))+"<hr />";
	    if (mess->subtype != "html") {
	      MAIN+="<font face=\"Courier\">";
	      MAIN+=replace(make_links(id, fixstring(err?data:_mess)), 
			    "  ", "&nbsp;&nbsp;");
	      MAIN+="</font>";
	    } else {
	      MAIN+=safe_html((err?data:_mess),id, refparts);
	    }
	  }
	}
	else
	  if(mess->type == "image" && 
	     (!mess->headers["content-id"] || 
	      !refparts[mess->headers["content-id"]])) 
	    MAIN+="<hr /><img src=\""+id->misc->imho->nextpage+"/"+http_encode_url(name)+"?mailpart="+partno+"\" />";
	
	MAIN+="</td></tr>\n</table><br />\n";
	part++;
      }
      if (sizeof(msgs) > 0)
	mess = msgs[0];
      else
	mess = 0;
    }

    if (!id->misc->imho->nobottombuttons)
      MAIN+=buttons;
    
    break;


  case FILES:
    id->misc->imho->screen="files";
    id->misc->imho->title=MSG(M_FILES);
    int totsize=0;
    if(sizeof(session->files)) {
      MAIN+="<form method=\"post\" action=\""+id->misc->imho->nextpage+"\">"
	"<input type=hidden name=charsettest value=\"\" />";
      MAIN+="<table width=\"100%\"><tr><th class=\"mark\" bgcolor=\"&imho_thbgcolor;\">"
	"<font color=\"&imho_thcolor;\">"+MSG(M_MARKFLAG)+"</font></th>";
      MAIN+="<th class=\"filename\" bgcolor=\"&imho_thbgcolor;\" width=\"100%\">"
	"<font color=\"&imho_thcolor;\">"+MSG(M_FILENAME)+"</font></th>";
      MAIN+="<th class=\"size\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" + 
	MSG(M_SIZE)+"</font></th>";
      MAIN+="<th class=\"type\" bgcolor=\"&imho_thbgcolor;\"><font color=\"&imho_thcolor;\">" +
	MSG(M_MIMETYPE)+"</font></th></tr>\n";
      int i=0;
      foreach(session->files, mapping file) {
	MAIN+="<tr><td bgcolor=\"&imho_tdbgcolor;\"><input type=\"checkbox\" name=\"file"+(string)i+"\" value=\"1\"></td><td bgcolor=\"&imho_tdbgcolor;\"><a href=\""+id->misc->imho->nextpage+file->fname+"?download="+(string)i+"\">"+file->fname+"</td><td bgcolor=\"&imho_tdbgcolor;\">"+file->size+"</td><td bgcolor=\"&imho_tdbgcolor;\">"+file->type+"</td></tr>";
	i++;
	totsize+=file->size;
      }
      MAIN+="</table><table><tr><td><imho_submit name=\"actiondeletefiles\" value=\""+MSG(M_DELETEMARKEDFILES)+"\" /></td></tr>\n</table></form>";
    }
    else {
      MAIN+=MSG(M_NOFILES);
    }
    int allow_upload=1;
    if((int)query("uploadquota")) {
      int space=(((((int)query("uploadquota"))*1024)-totsize)/1024);
      MAIN+=MSGA(M_AVAILSPACE,({ space }))+"<br />\n";
      if(space<=0)
	allow_upload=0;
    }
    if(allow_upload) {
      MAIN+="<form name=\"imhouploadform\" method=\"post\" enctype=\"multipart/form-data\" action=\""+id->misc->imho->nextpage+"\"><input type=\"hidden\" name=\"charsettest\" value=\"\" /><table><tr><td>";
      MAIN+="<input name=\"file\" type=\"file\">";
      MAIN+="<input type=\"hidden\" name=\"actionupload\" value=\"1\">";
      MAIN+="<imho_submit value=\""+MSG(M_UPLOAD)+"\"";
      if(id->supports->javascript)
	MAIN+=" onClick=\"document.forms.imhouploadform.fixedfilename.value=document.forms.imhouploadform.file.value.replace(/\\\\/g,'\\\\\\\\')\" /><input type=\"hidden\" name=\"fixedfilename\" value=\"\"";
      MAIN+=" /></td></tr>\n</table></form>";
      if(!id->supports->javascript)
	MAIN+=MSG(M_WINDOWSBUG);
    }
    break;


  case SETUP:
    id->misc->imho->screen="setup";
    id->misc->imho->title=MSG(M_PREFS);
    if(!session->prefsloaded){
      session->prefsloaded=1;
      MAIN+=query("newusermsg");
    }
    MAIN+="<table border=\"0\" cellspacing=\"0\" cellpadding=\"1\"><form target=\""+id->misc->imho->topframe+"\" method=\"POST\" action=\""+id->misc->imho->nexturl+id->misc->imho->topframe+"\"><input type=\"hidden\" name=\"charsettest\" value=\"\" />";
    if (feature(FEAT_USERCANCHANGENAME))
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">"+MSG(M_PNAME)+":</imho_text></td><td><input name=\"name\" value=\"" + fixstring(session->name) + "\" /></td></tr>\n";
    if (feature(FEAT_USERADDRESS))
      MAIN+="<tr><td valign=\"top\"><imho_text nfont='Arial Rounded' scale=\"0.4\">"+MSG(M_PMAILADDRESS)+":</imho_text></td><td><textarea rows=\"4\" cols=\"50\" name=\"address\">"+html_encode_string(session->address)+"</textarea><br />"+MSG(M_PMAILADDRESSDESC)+"</td></tr>";
    if(feature(FEAT_USERMAILPATH))
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">"+MSG(M_PMAILPATH)+":</imho_text></td><td><input name=mailpath value=\""+fixstring(session->mailpath)+"\"></td></tr>\n";
    if(sizeof(lang_progs)>1 && feature(FEAT_USERLANGUAGE)) {
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">"+MSG(M_PLANGUAGE)+":</imho_text></td><td><select name=language>";
      foreach(sort(indices(lang_progs)), string opt) {
	MAIN+="<option value=\""+opt+"\"";
	if (session->language == opt)
	  MAIN+=" SELECTED=\"SELECTED\"";
	MAIN+=">"+upper_case(opt[0..0])+opt[1..]+"</option>\n";
      } 
      MAIN+="</select></td></tr>\n";
    }
    if (sizeof(layouts) > 1) {
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" + MSG(M_PUSERINTERFACE) + 
	":</imho_text></td><td><select name=layout>";
      foreach(indices(layouts), int i) {
	MAIN+="<option value=\""+((string ) i)+"\"";
	if (session->layout == ((string) i))
	  MAIN+=" SELECTED=\"SELECTED\"";
	MAIN+=">" + html_encode_string(layouts[i]->name) + "</option>\n";
      } 
      MAIN+="</select></td></tr>\n";
    }
    MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
      MSG(M_PINCLUDEMAIL) + ":</imho_text></td>";
    MAIN+="<td>";
    if (feature(FEAT_USERSETREPLYPREFIX))
      MAIN+="<table><tr><td>";
    MAIN+="<select name=\"replyincludemsg\">";
    MAIN+="<option value=\"yes\"";
    if (session->replyincludemsg == "yes")
      MAIN+=" SELECTED=\"SELECTED\"";
    MAIN+=">"+MSG(M_YES)+"</option>\n";
    MAIN+="<option value=\"no\"";
    if (session->replyincludemsg == "no")
      MAIN+=" SELECTED=\"SELECTED\"";
    MAIN+=">"+MSG(M_NO)+"</option>\n";

    MAIN+="</select>";
    if (feature(FEAT_USERSETREPLYPREFIX))
      {
	MAIN+="</td><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	  MSG(M_PQUOTEPREFIX)+":</imho_text></td><td>"
	  "<input name=\"replymsgprefix\" size=\"5\" value=\"" +
	  fixstring(session->replymsgprefix) + "\" /></td></tr></table>";
      }
    else
      {
	MAIN+="<input type=\"hidden\" name=\"replymsgprefix\" size=\"5\" value=\"" +
	  fixstring(session->replymsgprefix) + "\" />";
      }
    MAIN+="</td></tr>\n";
    
    MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" + MSG(M_PSIGNATURE) +
      ":</imho_text></td><td><textarea rows=\"4\" cols=\"" + query("signaturecols")+"\" "
      "name=\"signature\">"+html_encode_string(session->signature)+"</textarea></td></tr>";

    if (feature(FEAT_USERHEADERS))
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" + 
	MSG(M_PHEADER) + ":</imho_text></td><td><textarea rows=\"2\" cols=\"70\" "
	"name=\"extraheader\">" + html_encode_string(session->extraheader) + "</textarea><br />" +
	MSG(M_PHEADERDESC)+"</td></tr>";

    MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" + 
      MSG(M_PINACTIVELOGOUT) + ":</imho_text></td><td><select name=autologout>";
    foreach(({ "5", "10", "20", "60", "120" }), string opt) {
      MAIN+="<option value=" + opt;
      if (session->autologout == opt)
	MAIN+=" SELECTED=\"SELECTED\"";
      MAIN+=">" + opt + "</option>\n";
    } 
    MAIN+="</select></td>";
    MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
      MSG(M_PVISIBLEMESSAGES) + ":</imho_text></td><td><select name=visiblemail>";
    foreach(({ "10", "15", "20", "30", "40", "60", "100" }), string opt) {
      MAIN+="<option value="+opt;
      if (session->visiblemail == opt)
	MAIN+=" SELECTED=\"SELECTED\"";
      MAIN+=">" + opt + "</option>\n";
    } 
    MAIN+="</select></td>";
    MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" + 
      MSG(M_PSORTORDER) + ":</imho_text></td><td><select name=\"sortorder\">";
    foreach(({ "forward", "backward" }), string opt) {
      MAIN+="<option value=\"" + opt + "\"";
      if (session->sortorder == opt)
	MAIN+=" SELECTED=\"SELECTED\"";
      MAIN+=">";
      string sortord=MSGA(M_PSORTORDERS, ({ opt }) );
      MAIN+=upper_case(sortord[0..0])+sortord[1..];
      MAIN+="</option>\n";
    } 
    MAIN+="</select></td></tr>\n";
    MAIN+="<td><imho_text nfont='Arial Rounded' scale=\"0.4\">" + 
      MSG(M_PSORTCOLUMN) + ":</imho_text></td><td><select name=\"sortcolumn\">";
    array columns=({ "num", "date", "from", "to", "subject", "size" });
    foreach(columns, string col) {
      MAIN+="<option value=" + col;
      if (session->sortcolumn == col) MAIN+=" SELECTED=\"SELECTED\"";
      MAIN+=">";
      switch(col) {
      case "num":
	MAIN+=MSG(M_NUMBER);
	break;
      case "date":
	MAIN+=MSG(M_DATE);
	break;
      case "from":
	MAIN+=MSG(M_FROM);
	break;
      case "to":
	MAIN+=MSG(M_TO);
	break;
      case "subject":
	MAIN+=MSG(M_SUBJECT);
	break;
      case "size":
	MAIN+=MSG(M_SIZE);
	break;
      }
      MAIN += "</option>\n";
    }
    MAIN+="</select></td></tr>\n";

    if (feature(FEAT_SHOWHTML)) {
      MAIN+="<td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	MSG(M_PSHOWHTML) + ":</imho_text></td><td><select name=\"showhtml\">";
      MAIN+="<option value=\"yes\"";
      if (session->showhtml == "yes")
	MAIN+=" SELECTED=\"SELECTED\"";
      MAIN+=">" + MSG(M_YES) + "</option>\n";
      MAIN+="<option value=\"no\"";
      if (session->showhtml == "no")
	MAIN+=" SELECTED=\"SELECTED\"";
      MAIN+=">" + MSG(M_NO) + "</option>\n";
      MAIN+="</select></td>";
    }

    if(feature(FEAT_MAILBOXES)) {
      if ( (< "both", "move to trash" >)[query("deletemethod")])
	if (feature(FEAT_USERTRASHFOLDER))
	  MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	    MSG(M_PTRASHFOLDER) + ":</imho_text></td><td><input name=\"trashfolder\" value=\"" +
	    fixstring(session->trashfolder) + "\" /></td></tr>\n";
      if (feature(FEAT_USERSENTFOLDER))
	MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	  MSG(M_PSENTFOLDER) + ":</imho_text></td><td><input name=\"sentfolder\" value=\"" + fixstring(session->sentfolder) + "\" /> ";
      if(feature(FEAT_USERSENTSAVEATTACHMENTS)) {
	MAIN+="&nbsp;<imho_text nfont='Arial Rounded' scale=\"0.4\">"+MSG(M_PSAVEATTACHMENTS)+":</imho_text> <select name=saveattachments>";
	MAIN+="<option value=\"yes\"";
	if (session->saveattachments == "yes")
	  MAIN+=" SELECTED=\"SELECTED\"";
	MAIN+=">"+MSG(M_YES)+"</option>\n";
	MAIN+="<option value=\"no\"";
	if (session->saveattachments == "no")
	  MAIN+=" SELECTED=\"SELECTED\"";
	MAIN+=">"+MSG(M_NO)+"</option>\n";
	MAIN+="</select></td></tr>\n";
      }
    }

    if (feature(FEAT_INBOXES))
      if (feature(FEAT_USERSPECIFYINBOXES))
	MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	  MSG(M_PINBOXES) + ":</imho_text></td><td><input name=\"activemailboxes\" value=\"" +
	  fixstring(session->activemailboxes) + "\" />&nbsp;&nbsp;" +
	  MSG(M_PCOMMASEPARATED) + "</td></tr>\n ";
    if (feature(FEAT_USERBCCCOPY))
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	MSG(M_PDEFAULTBCC) + ":</imho_text></td><td><input name=\"autobcc\" value=\"" +
	fixstring(session->autobcc) + "\" /></td></tr>\n";

    if (feature(FEAT_USERSETUPSHOWHIDDENHEADERS)) {
      MAIN+="<tr><td><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	MSG(M_PSHOWHIDDENHEADERS) + ":</imho_text></td><td><select name=\"showhiddenheaders\">";
      MAIN+="<option value=\"yes\"";
      if (session->showhiddenheaders == "yes")
	MAIN+=" SELECTED=\"SELECTED\"";
      MAIN+=">" + MSG(M_YES) + "</option>\n";
      MAIN+="<option value=\"no\"";
      if (session->showhiddenheaders == "no")
	MAIN+=" SELECTED=\"SELECTED\"";
      MAIN+=">" + MSG(M_NO) + "\n";
      MAIN+="</select></td></tr>\n";
    }

#ifndef __NT__
    if (session->lcfgmap->forward) {
       MAIN+="<tr><td valign=\"top\"><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	 MSG(M_PFORWARDING) + ":</imho_text></td><td>"
	 "<textarea rows=\"4\" cols=\"50\" name=\"forwarding\">" +
	 html_encode_string(load_forward(session->login)) + "</textarea><br>" +
	 MSG(M_PFORWARDINGDESC)+"</td></tr>";
    }
    if (session->lcfgmap->procmail) {
       MAIN+="<tr><td valign=\"top\"><imho_text nfont='Arial Rounded' scale=\"0.4\">" +
	 MSG(M_PPROCMAIL) + ":</imho_text></td><td>"
	 "<textarea rows=\"6\" cols=\"50\" name=\"procmailfilter\">" +
	 html_encode_string(load_procmail(session->login)) + "</textarea><br>" +
	 MSG(M_PPROCMAILDESC)+"</td></tr>";
    }
#endif


    MAIN+="<tr><td></td><td><imho_submit name=\"actionsavesetup\" value=\"" +
      MSG(M_PSAVEANDUSE)+"\" /></td></tr>\n";
    MAIN+="</form></table>";
    break;

  case DIALOGBOX:
    id->misc->imho->screen="dialog";
    if(sizeof(session->dialogstrings)==1)
      id->misc->imho->title=MSG(M_INFO);
    else
      id->misc->imho->title=MSG(M_QUESTION);
    MAIN+="<br />\n<br />\n<center><table border=\"2\"><tr><td><table>";
    MAIN+="<tr><td bgcolor=\"&imho_thbgcolor;\"><br />\n</td><tr><tr><td>"
      "<table cellspacing=\"10\" bgcolor=\"&imho_tdbgcolor;\"><tr><td>" +
      fixstring(session->dialogtext) + "</td></tr>\n</table></td></tr>\n";
    MAIN+="<tr><td><center><form method=\"POST\" target=\"";
    if (session->dialogtarget)
      MAIN+=session->dialogtarget+"\" action="+id->misc->imho->nexturl+session->dialogtarget+">";
    else
      MAIN+=id->misc->imho->target+"\" action="+id->misc->imho->nexttarget+">";
    foreach(indices(session->dialogstrings), int i) {
      MAIN+="<imho_submit value=\""+session->dialogstrings[i]+
	"\" name="+session->dialogactions[i]+" />";
    }
    MAIN+="</form></center></td></tr>\n</table></td></tr>\n</table></center>";
    break;


  case SPELLCHECK:
    {
      id->misc->imho->screen="spellcheck";
      if(session->checkword<0 || session->checkword>=sizeof(session->misspelled))
	session->checkword=0;
      id->misc->imho->title=MSG(M_SPELLCHECK);
      string spellret="";
      int i=0,j=-1;
      foreach(session->spelling,mixed foo) {
	j++;
	if(arrayp(foo)) {
	  if((session->misspelled)[session->checkword] == j) {
	    spellret+="<b>"+html_encode_string(foo[1])+"</b>";
	    i++;
	  }
	  else
	    spellret+="<a href="+id->misc->imho->nextpage+"?actioncheckword=1&word="+(i++)+">"+html_encode_string(foo[1])+"</a>";
	}
	else
	  spellret+=html_encode_string(foo);
      }
    
      MAIN+="<table width=\"100%\" bgcolor=\"&imho_tdbgcolor;\"><tr><td><font face=\"Courier\">";
      MAIN+=replace(spellret,"\n","<br />\n");
      MAIN+="</font></td></tr>\n</table>";
      if (session->misspelled && sizeof(session->misspelled) == 0)
	MAIN+="<b>" + MSG(M_NOSPELLINGERRORS) + "</b>\n";

      if (sizeof(session->misspelled)) {
	MAIN+="<form method=\"POST\" action=\""+id->misc->imho->nextpage+"\">"
	  "<input type=\"hidden\" name=\"charsettest\" value=\"\" />";
	if (session->checkword > 0)
	  MAIN+="<imho_submit name=\"actionspellprev\" value=\"<- "+MSG(M_SPELLPREV)+"\" />";
	if (session->checkword < sizeof(session->misspelled)-1)
	  MAIN+="<imho_submit name=\"actionspellnext\" value=\""+MSG(M_SPELLNEXT)+" ->\" />";
	MAIN+="</form>";
      }

      // original word : (session->spelling)[(session->misspelled)[session->checkword]][0]
    
      if(sizeof(session->misspelled)) {
	MAIN+="<br />\n<form method=\"post\" action=\""+id->misc->imho->nextpage+"\"><input type=\"hidden\" name=\"charsettest\" value=\"\" /><imho_submit value=\""+html_encode_tag_value(MSG(M_SPELLCHANGETO)+":")+"\" /><input type=\"hidden\" name=\"actionspellreplace\" value=\"1\" /><input name=\"newword\" value=\""+html_encode_tag_value((session->spelling)[(session->misspelled)[session->checkword]][1])+"\" /></form>";
      
	if(sizeof((session->spelling)[(session->misspelled)[session->checkword]])>2) {
	  MAIN+=MSG(M_SPELLSUGGESTIONS)+":<br />\n";
	  MAIN+="<form method=\"post\" action=\""+id->misc->imho->nextpage+"\"><input type=\"hidden\" name=\"charsettest\" value=\"\" /><imho_submit value="+html_encode_tag_value(MSG(M_SPELLCHANGETO)+":")+" /><input type=\"hidden\" name=\"actionspellselect\" value=\"1\" /><select name=\"selectedword\">";
	  int k=0;
	  foreach((session->spelling)[(session->misspelled)[session->checkword]][2..],string word){
	    MAIN+="<option value=\""+k+"\">"+html_encode_string(word)+"</option>";
	    k++;
	  }
	  MAIN+="</select></form>";
	}
      }
    
      MAIN+="<form target=\""+id->misc->imho->target+"\" method=\"post\" action="+id->misc->imho->nexttarget+"><input type=\"hidden\" name=\"actionspelldone\" value=\"1\" />"
	"<imho_submit value="+html_encode_tag_value(MSG(M_SPELLDONE))+" /></form>";
    }
    break;
    
    
  }

  return (MAIN);
}


mapping
find_file(string file, object id)
{
  array(string) fileparts=file/"/";
  string sessionid="";
  string frame="";
  object lock;

  if(sizeof(fileparts)>2 && fileparts[2]=="about")
    return http_redirect( IMHO_HOME );

  //diable the ram cache
  id->misc->cacheable = 0;

  if(sizeof(fileparts) >= 2) {
    sessionid=fileparts[0];
    frame=fileparts[1];
  }
  sscanf(frame, "%s-%*s", frame);
  if (sizeof(frame) < 1)
    frame = "_top";

  int foo,bar=time();
#ifdef THREADS
  lock = global_lock->lock();
#endif
  foreach(indices(sessions),foo){
    int tmax;
    if (!sessions[foo]["autologout"] 
	|| !sscanf(sessions[foo]["autologout"], "%d", tmax))
      tmax = 20;
    if (sessions[foo]->status == COMPOSE)
      tmax = 180; // Do not timeout when composing mail...
    if(bar - sessions[foo]->last > tmax*60) {
      imho_log("autologout", ([ "login":sessions[foo]->address ]));
      m_delete(sessions,foo);
    }
  }
  
  if(sessionid=="")
    sessionid = "0";

  if (id->cookies["IMHOSession"] && sessions[id->cookies["IMHOSession"]]) {
    sessionid = id->cookies["IMHOSession"];
  }

  if (id->variables->session)
    sessionid = id->variables->session;

  if(query("loginmethod") == "http basic auth") {
    sessionid = id->rawauth;
  }
  
  if(search(indices(sessions),sessionid) == -1)
    sessionid = "0";
  
  if(sessionid == "0" || (query("allowipchange") == "no" && sessions[sessionid]["ip"] != id->remoteaddr)){
    string s;
    if(query("loginmethod") == "http basic auth")
      s = id->rawauth;
    else {
      // create new session
      s = rand_string(30);
      // fat chance, but anyway :)
      while(search(indices(sessions),s)!=-1)
	s=rand_string(30);
      if (!id->variables->directloginkludge &&
	  (query("ssl3redir")=="yes" || sizeof(query("urloverride")) > 0 ) &&
	  fileparts[0] != "newbie") {
	// To make sure the session has been
	//redirected (to a safe port) without sending the session in clear
	//during the redirect.
#ifdef THREADS
	destruct(lock);
#endif
	return redirect(id,"newbie", "_top"); //+rand_string(8));
      }
    }
    sessions[s]= Session();
    default_session(sessions[s],id);
    sessions[s]->status = LOGINPROMPT;
    // For example automatic reloads should not reset idle counter
    sessions[s]->last = time();
    sessions[s]->ip = id->remoteaddr;
    sessions[s]->session = s;
    sessions[s]->cookies = 0;
    frame = "_top";
    sessionid = s;

    if(id->variables->directloginkludge)
      return redirect(id,s,"_top?actionlogin=1&login="+id->variables->login+"&passwd="+id->variables->passwd);
  }

  if ((query("loginmethod") == "http basic auth") || (id->cookies["IMHOSession"] && id->cookies["IMHOSession"] == sessionid))
    sessions[sessionid]->cookies = 1;

  object session = sessions[sessionid];
#ifdef THREADS
  // Removed, some kind of deadlock situation occured
  //id->misc->imholock = session->lock->lock();
  destruct(lock);
#endif
  if (sscanf(frame, "idle%s",foo) == 0) 
    session->last = time();
  if(!id->misc->imho)
    id->misc->imho = ([ ]);
  id->misc->imho->frame = frame;
  //FIXME: only needed for the parse_rxml kludge
  id->misc->imho["main_module"]=this_object();

  if ((query("loginmethod") == "http basic auth") && !session->loggedin && !id->variables->actionlogin)
    return redirect(id,"0","_top?actionlogin=1");

  return (session->old_module?session->old_module->process_request(file, id, session):process_request(file, id, session));
}

// 
// Messages
//

string
msg(object session,int m,array arg) {
  object lang_prog=session->lang_progs[session->language];
  if(lang_prog) {
    string s=lang_prog->msg(session,m,arg);
    if(s && (lang_charsets[session->language]||"iso-8859-1" != "iso-8859-1"))
      s=Locale.Charset.decoder(lang_charsets[session->language])->feed(s)->drain();
    if (s)
      return s;
  }

  switch(m) {
  case M_LOGIN:
    return "Login:";
  case M_PASSWORD:
    return "Password:";
  case M_NOLOGIN:
    return "<b>Could not log in:</b> Wrong login or password. Try again. ";
  case M_IMAPERROR:
    return "There was a problem talking to the mail (IMAP) server. Please contact the administrator.";
  case M_SMTPERROR:
    return "There was a problem talking to the outgoing mail (SMTP) server, and the mail was not sent. The recipient of the mail might not exist.";
  case M_SAVEDUSERINTERFACE:
    return "From preferences";
  case M_USERINTERFACE:
    return "User interface:";
  case M_LOGIN_OK:
    return "OK";

  case M_NEWMAIL:
    return "Compose";
  case M_MAILBOX:
    return sprintf("Mailbox: %s",@arg);
  case M_MAILBOXES:
    return "Mailboxes";
  case M_FILES:
    return "Files";
  case M_PREFS:
    return "Preferences";
  case M_LOGOUT:
    return "Logout";
  case M_CURRMAILBOX:
    return "Current Mailbox";
  case M_CHECKACTIVEMAILBOXES:
    return "Check inboxes";

  case M_FROM:
    return "From";
  case M_TO:
    return "To";
  case M_CC:
    return "Cc";
  case M_BCC:
    return "Bcc";
  case M_SUBJECT:
    return "Subject";
  case M_ATTACHMENTS:
    return "Attachments";
  case M_TIME:
    return "Time";
  case M_DATE:
    return "Date";

  case  M_MARKFLAG:
    return "M";
  case M_NEWFLAG:
    return "N";
  case M_ANSWEREDFLAG:
    return "A";


  case M_SEND:
    return "Send";
  case M_CANCELSEND:
    return "Cancel";
  case M_SENDMOREFILES:
    return "Select files to send. Press 'Ctrl' to toggle-select multiple files.";
  case M_COMPOSEMAIL:
    return "Compose mail";
  case M_SPELLCHECK:
    return "Spell check";
  case M_DONTSAVEMAIL:
    return "Do not save this mail.";
  case M_ADDFILEASATTACHMENT:
    return "Add file as attachment";
  case M_NOATTACHMENTS:
    return "No attachments";
  case M_ADDATTACHMENT:
    return "Add attachment...";
  case M_REMOVEMARKEDATTACHMENTS:
    return "Remove marked attachments";
  case M_UPLOADATTACHMENT:
    return "Upload attachment";
  case M_ADDMARKEDTOATTACHMENTS:
    return "Add marked to attachments";
  case M_UPLOADTOATTACHMENTS:
    return "Upload to attachments";
  case M_BACKTOCOMPOSE:
    return "Back to compose";
  case M_NOATTACHFILES:
    return "No files";
  case M_ATTACHMENTSHEADER:
    return "Attachments";
  case M_SENDSAVEFAILED:
    return "Mail was sent successfully, but save in folder failed.";
  case M_SENDNORECV:
    return "You must specify a recipient of the mail.";
   case M_DSN_DELAY:
     return("Report delayed delivery.");
   case M_DSN_SUCCESS:
     return("Report successful delivery.");
  case M_SAVEDRAFT:
    return("Save draft");
  case M_SAVEDRAFTINSESSION:
    return("Save draft (during session)");
  case M_COMPOSEDRAFT:
    return("You have a draft mail saved. Do you want to start from it now?");
  case M_DRAFTEXISTS:
    return("There is already another draft mail saved.");
  case M_OVERWRITEDRAFT:
    return("Owerwrite current draft");
  case M_DISCARDDRAFT:
    return("Discard current mail, keep draft");
  case M_SENDBROKENADDR:
    return(sprintf("The address \"%s\" is not a correct email address. Please correct it and try again.", arg[0]));
  case M_SAVEMAILCOPY:
    return("Save a copy");  

  case M_DELETEMARKED:
    return "Delete marked";
  case M_MOVEMARKED:
    return "Move marked to";
  case M_SELECTMBOX:
    return "(Select a mailbox)";
  case M_CHECKNEWMAIL:
    return "Check for new mail";
  case M_MAILSHOWN:
    return sprintf("Mail %d-%d of %d", @arg);
  case M_BACKN:
    return sprintf("[<< Prev %d]", @arg);
  case M_FORWARDN:
    return sprintf("[Next %d >>]", @arg);
  case M_NUMBER:
    return "#";
  case M_DELETEMARKEDP:
    return 
      sprintf("Are you sure you want to delete the %d marked message(s)?", 
	      @arg);
  case M_DELETEMARKEDNONE:
    return "Please mark some messages first.";
  case M_CHANGESORTORDER:
    return "Change sort order";
  case M_MOVETOTRASH:
    return "Move marked to trash";
  case M_DELETEALLTRASH:
    return "Delete ALL trash";
  case M_NOMAILS:
    return "[No mail]";
  case M_MARKALL:
    return "Mark all";
  case M_PAGEGO:
    return "Go";

  case M_MBOXNAME:
    return "Mailbox";
  case M_DELETEMARKEDMBOX:
    return "Delete marked";
  case M_CREATEMBOX:
    return "Create a new mailbox";
  case M_NEWMBOXNAME:
    return "(Name)";
  case M_MBOXREMOVEP:
    return "Are you sure you want to delete the following mailboxes?";
  case M_MBOXMARKONE:
    return "Mark at least one mailbox.";
  case M_NEWMBOXNONAME:
    return "Type in a name first.";
  case M_CREATEMBOXERROR:
    return "Failed to create mailbox. The name may be illegal or the mailbox may exist.";
  case M_INBOX:
    return "Inbox";
  case M_PREVIOUS_LEVEL:
    return "[Previous level]";
  case M_FOLDER_PATH:
    return "Path:";
  case M_BOXTRASH:
    return "Trash";
  case M_BOXSENTMAIL:
    return "Sent";
  case M_USEMARKEDINMENULIST:
    return "Use marked in menu list";
  case M_CHANGEINBOXESMSG:
    return "The marked mailboxes will appear in the menu after you\n"
      "reload the whole page or re-login.";

  case M_FILENAME:
    return "Filename";
  case M_SIZE:
    return "Size";
  case M_MIMETYPE:
    return "Type";
  case M_DELETEMARKEDFILES:
    return "Delete marked";
  case M_UPLOAD:
    return "Upload";
  case M_AVAILSPACE:
    return sprintf("You have %d Kb available for upload.",@arg);
  case M_WINDOWSBUG :
    return "Windows users: Due to a bug in some browsers, filenames can be crippled. Avoid this by replacing the last \\ with \\\\ before pressing 'Upload'.";
  case M_NOFILES:
    return "You have no uploaded files.";

  case M_PNAME:
    return "Name";
  case M_PMAILADDRESS:
    return "Mail address(es)";
  case M_PMAILPATH:
    return "Mail searchpath";
  case M_PINCLUDEMAIL:
    return "Include mail when replying";
  case M_PQUOTEPREFIX :
    return "Prefix";
  case M_PSIGNATURE:
    return "Signature";
  case M_PINACTIVELOGOUT:
    return "Inactive logout (minutes)";
  case M_PSAVEANDUSE:
    return "Save and use";
  case M_PVISIBLEMESSAGES:
    return "Messages shown in mailbox";
  case M_PSORTORDER:
    return "Mail sort order";
  case M_PSORTORDERS:
    return ([ "forward": "forward", "backward":"backward"])[arg[0]];
  case M_PTRASHFOLDER:
    return "Trash folder";
  case M_PSENTFOLDER:
    return "Sent mail folder";
  case M_PDEFAULTBCC:
    return "Default Bcc address";
  case M_PSAVEATTACHMENTS:
    return "Include attachments";
  case M_PLANGUAGE:
    return "Language";
  case M_PUSERINTERFACE:
    return "User interface";
  case M_PINBOXES:
    return "Mailboxes in menu list";
  case M_PCOMMASEPARATED: 
    return "(Comma separated list of mailboxes, \"box1, box2, ...\")";
  case M_PHEADER:
    return "Extra headers";
  case M_PHEADERDESC:
    return "(Lines with headers in this format: header:value )";
  case M_PSORTCOLUMN:
    return "Sort on column";
  case M_PSHOWHTML:
    return "Show HTML messages";
  case M_PSHOWHIDDENHEADERS:
    return "Enable <i>\"Show full headers\"</i>-button";
  case M_PMAILADDRESSDESC:
    return "(List of addresses from which you would like to be able to send mail. One per line or comma-separated.)";
  case M_PPROCMAIL:
    return "Filtering";
  case M_PPROCMAILDESC:
    return "(Filtering directives in the form <code>mailbox to/from/subject toaddr/fromaddr/subject (regexp))</code><br><i><b>Note:</b> Only rules created using this interface are affected</i><br>Examples:<pre>hugbox    from     hugs@someplace.cozy\nlistbox   to       list@lots.of.maillists\nspambox   subject  .*SPAM.*</pre>";
  case M_PFORWARDING:
    return "Forwarding";
  case M_PFORWARDINGDESC:
    return "(List of addresses to forward your incoming mail to. One per line or comma-separated.)";

  case M_SPELLDONE:
    return "Done";
  case M_SPELLPREV:
    return "Previous";
  case M_SPELLNEXT:
    return "Next";
  case  M_SPELLCHANGETO:
    return "Change to";
  case M_SPELLSUGGESTIONS:
    return "Suggestions";
  case M_NOSPELLINGERRORS:
    return "No spelling errors found.";

  case M_LOGOUTMSG:
    return "<b>You are logged out.</b> Close this browser window to make sure no one can read your mail.<br /><br />Reload this page to login.";
  case M_LOGGEDOUT:
    return "Logged out";

  case M_QUESTION:
    return "Question";
  case M_INFO:
    return "Info";

  case M_REPLY:
    return "Reply";
  case M_READPREV:
    return "Read previous";
  case M_READNEXT:
    return "Read next";
  case M_ATTACHMENTLINK:
    return sprintf("%sattachment of type %s",@arg);
  case M_MAILMISSING:
    return "<b>Error:</b> Failed to fetch mail. The mail might have a faulty format.<br />";
  case M_MAILMISSINGBACK:
    return "Back";
  case M_DELETE:
    return "Delete";
  case M_FORWARD:
    return "Forward";
  case M_MAIL:
    return "Mail";
  case M_SHOWFULLHEADERS:
    return "Show full headers";
  case M_HIDEFULLHEADERS:
    return "Hide full headers";
  case M_MAILTOOBIG:
    return "Mail is too big to be shown. Click here to download it.";
  case M_REPLYTOALL:
    return "Reply to all";
  case M_MOVETHISTOTRASH:
    return "Move to trash";
  case M_CHARSETWARNING:
    return sprintf("Warning! Unable to decode the characterset \"%s\". Message is presented undecoded.",@arg);

  case M_ADDRESSBOOKTITLE: 
    return("Address Book");         
  case M_ADDRESSBOOK:
    return("Address book...");
  case M_INDEXNAMERECIPIENT:
    return("Index name (click to add as recipient)");
  case M_INDEXNAMEEDIT:
    return("Index name (click to edit)");
  case M_ADDRESS:
    return("Address");
  case M_NOADDRESSES:
    return("No addresses");
  case M_NEWADDRESS:
    return("New address...");
  case M_EDITADDRESS:
    return("Edit address");
  case M_ADDADDRESS:
    return("Add to address book");
  case M_INDEXNAME:
    return("Index name");
  case M_ADDRESSFORMAT:
    return("Address(es), comma separated");
  case M_SAVEADDRESS:
    return("Save and use");
  case M_DELETEADDRESS:
    return("Delete address");
  case M_CANCELADDRESS:
    return("Cancel");
  case M_CANNOTIMPORT:
    return("Cannot import this addressbook, since its\nformat is not recognized.");
  case M_IMPORTADDRESSBOOKTITLE:
    return("Import address book");
  case M_UPLOADADDRESSBOOK:
    return("Upload a Pine or exported Netscape (.ldif) address book");
  case M_PINELOCATION:
    // Not used any more
    return("The Pine address book is often in ~/.addressbook");
  case M_UPLOADANDIMPORT:
    return("Upload and import");
  case M_IMPORTADDRESSBOOK:
    return("Import address book...");
  case M_GLOBALADDRESSES:
    return("Common addresses:");
  case M_INSERTMARKEDADDRESSES:
    return("Insert marked");
  case M_DELETEMARKEDADDRESSES:
    return("Delete marked");

  case M_LDAPTITLE:
    return("LDAP addresses");
  case M_LDAP:
    return("LDAP search");
  case M_SEARCHLDAP:
    return("Search LDAP");
  case M_NAMECONT:
    return("Search name containing:");
  case M_OU:
    return("OU");

  case M_MAILNOTIFYWINDOW:
    return("Mail notification...");
  case M_GETNEWMAIL:
    return("Get new mail...");

  case M_SEARCHMAILTITLE:
    return("Search mail");
  case M_SEARCHMAIL:
    return("Search...");
  case M_SEARCHMAILBOX:
    return(sprintf("Find mail in mailbox <b>%s</b> which contains",arg[0]));
  case M_SEARCHANYWHERE:
    return("anywhere");
  case M_SEARCHFROMFIELD:
    return("in 'from' field");
  case M_SEARCHTOFIELD:
    return("in 'to' field");
  case M_SEARCHSUBJECT:
    return("in subject");
  case M_SEARCHBODY:
    return("in mail body");
  case M_SEARCHAND:
    return("AND");
  case M_SEARCHSHOWINGMAIL:
    return("Showing mail with ");

  case M_YES:
    return "Yes";
  case M_NO:
    return "No";
  case M_DIALOGOK:
    return "OK";
  case M_DIALOGCANCEL:
    return "Cancel";

  }
  return " ** MISSING MESSAGE ** ";
}

