#ifndef PACKAGE_NAMESPACE_POINTER_STRIPPER_H_INCLUDED
#define PACKAGE_NAMESPACE_POINTER_STRIPPER_H_INCLUDED 1

namespace PACKAGE_NAMESPACE {
        /**
           Helper class to strip pointers from value_type
           typedefs. It's value_type represents T, minus any
           leading pointer part.
                   
           example:
<pre>
typedef pointer_stripper<std::list<int *>::value_type> value_type;
</pre>
		value_type is int, not (int *).

        */

        template <typename T>
        struct pointer_stripper
        {
                /**
                   value_type is always equivalent to T.
                */
                typedef T value_type;
        };

        /**
           Specialization to make (T *) equivalent to
           (T).
        */
        template <typename T>
        struct pointer_stripper<T *>
        {
                /**
                   value_type is always equivalent to T.
                */
                typedef T value_type;
        };
        template <typename T>
        struct pointer_stripper<T &>
        {
                /**
                   value_type is always equivalent to T.
                */
                typedef T value_type;
        };

}

#endif // PACKAGE_NAMESPACE_POINTER_STRIPPER_H_INCLUDED
