/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  An interface to an XML input stream.
 */

public class XMLInputStream {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected XMLInputStream(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(XMLInputStream obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (XMLInputStream obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_XMLInputStream(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  
/**
   * Creates a new {@link XMLInputStream}.
   <p>
   * <code>content</code> the source of the stream.
   <p>
   * <code>isFile</code> boolean flag to indicate whether <code>content</code> is a file name.
   * If <code>true</code>, <code>content</code> is assumed to be the file from which the XML
   * content is to be read.  If <code>false</code>, <code>content</code> is taken to be a
   * string that <em>is</em> the content to be read.
   <p>
   * <code>library</code> the name of the parser library to use.
   <p>
   * <code>errorLog</code> the {@link XMLErrorLog} object to use.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLInputStream(String content, boolean isFile, String library, XMLErrorLog errorLog) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_0(content, isFile, library, XMLErrorLog.getCPtr(errorLog), errorLog), true);
  }

  
/**
   * Creates a new {@link XMLInputStream}.
   <p>
   * <code>content</code> the source of the stream.
   <p>
   * <code>isFile</code> boolean flag to indicate whether <code>content</code> is a file name.
   * If <code>true</code>, <code>content</code> is assumed to be the file from which the XML
   * content is to be read.  If <code>false</code>, <code>content</code> is taken to be a
   * string that <em>is</em> the content to be read.
   <p>
   * <code>library</code> the name of the parser library to use.
   <p>
   * <code>errorLog</code> the {@link XMLErrorLog} object to use.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLInputStream(String content, boolean isFile, String library) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_1(content, isFile, library), true);
  }

  
/**
   * Creates a new {@link XMLInputStream}.
   <p>
   * <code>content</code> the source of the stream.
   <p>
   * <code>isFile</code> boolean flag to indicate whether <code>content</code> is a file name.
   * If <code>true</code>, <code>content</code> is assumed to be the file from which the XML
   * content is to be read.  If <code>false</code>, <code>content</code> is taken to be a
   * string that <em>is</em> the content to be read.
   <p>
   * <code>library</code> the name of the parser library to use.
   <p>
   * <code>errorLog</code> the {@link XMLErrorLog} object to use.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLInputStream(String content, boolean isFile) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_2(content, isFile), true);
  }

  
/**
   * Creates a new {@link XMLInputStream}.
   <p>
   * <code>content</code> the source of the stream.
   <p>
   * <code>isFile</code> boolean flag to indicate whether <code>content</code> is a file name.
   * If <code>true</code>, <code>content</code> is assumed to be the file from which the XML
   * content is to be read.  If <code>false</code>, <code>content</code> is taken to be a
   * string that <em>is</em> the content to be read.
   <p>
   * <code>library</code> the name of the parser library to use.
   <p>
   * <code>errorLog</code> the {@link XMLErrorLog} object to use.
   <p>
   * 
</dl><dl class="docnote"><dt><b>Documentation note:</b></dt><dd>
The native C++ implementation of this method defines a default argument
value. In the documentation generated for different libSBML language
bindings, you may or may not see corresponding arguments in the method
declarations. For example, in Java and C#, a default argument is handled by
declaring two separate methods, with one of them having the argument and
the other one lacking the argument. However, the libSBML documentation will
be <em>identical</em> for both methods. Consequently, if you are reading
this and do not see an argument even though one is described, please look
for descriptions of other variants of this method near where this one
appears in the documentation.
</dd></dl>
 
   */ public
 XMLInputStream(String content) {
    this(libsbmlJNI.new_XMLInputStream__SWIG_3(content), true);
  }

  
/**
   * Returns the encoding of the XML stream.
   <p>
   * @return the encoding of the XML stream.
   */ public
 String getEncoding() {
    return libsbmlJNI.XMLInputStream_getEncoding(swigCPtr, this);
  }

  
/**
   * Returns the version of the XML stream.
   <p>
   * @return the version of the XML stream.
   */ public
 String getVersion() {
    return libsbmlJNI.XMLInputStream_getVersion(swigCPtr, this);
  }

  
/**
   * Returns an {@link XMLErrorLog} which can be used to log XML parse errors and
   * other validation errors (and messages).
   <p>
   * @return an {@link XMLErrorLog} which can be used to log XML parse errors and
   * other validation errors (and messages).
   */ public
 XMLErrorLog getErrorLog() {
    long cPtr = libsbmlJNI.XMLInputStream_getErrorLog(swigCPtr, this);
    return (cPtr == 0) ? null : new XMLErrorLog(cPtr, false);
  }

  
/**
   * Returns true if end of file (stream) has been reached, false
   * otherwise.
   <p>
   * @return true if end of file (stream) has been reached, false
   * otherwise.
   */ public
 boolean isEOF() {
    return libsbmlJNI.XMLInputStream_isEOF(swigCPtr, this);
  }

  
/**
   * Returns true if a fatal error occurred while reading from this stream.
   <p>
   * @return true if a fatal error occurred while reading from this stream.
   */ public
 boolean isError() {
    return libsbmlJNI.XMLInputStream_isError(swigCPtr, this);
  }

  
/**
   * Returns true if the stream is in a good state (i.e. isEOF() and
   * isError() are both false), false otherwise.
   <p>
   * @return true if the stream is in a good state (i.e. isEOF() and
   * isError() are both false), false otherwise.
   */ public
 boolean isGood() {
    return libsbmlJNI.XMLInputStream_isGood(swigCPtr, this);
  }

  
/**
   * Consumes the next {@link XMLToken} and return it.
   <p>
   * @return the next {@link XMLToken} or EOF (XMLToken.isEOF() == true).
   */ public
 XMLToken next() {
    return new XMLToken(libsbmlJNI.XMLInputStream_next(swigCPtr, this), true);
  }

  
/**
   * Returns the next {@link XMLToken} without consuming it.  A subsequent call to
   * either peek() or next() will return the same token.
   <p>
   * @return the next {@link XMLToken} or EOF (XMLToken.isEOF() == true).
   */ public
 XMLToken peek() {
    return new XMLToken(libsbmlJNI.XMLInputStream_peek(swigCPtr, this), false);
  }

  
/**
   * Consume zero or more XMLTokens up to and including the corresponding
   * end XML element or EOF.
   */ public
 void skipPastEnd(XMLToken element) {
    libsbmlJNI.XMLInputStream_skipPastEnd(swigCPtr, this, XMLToken.getCPtr(element), element);
  }

  
/**
   * Consume zero or more XMLTokens up to but not including the next XML
   * element or EOF.
   */ public
 void skipText() {
    libsbmlJNI.XMLInputStream_skipText(swigCPtr, this);
  }

  
/**
   * Sets the {@link XMLErrorLog} this stream will use to log errors.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int setErrorLog(XMLErrorLog log) {
    return libsbmlJNI.XMLInputStream_setErrorLog(swigCPtr, this, XMLErrorLog.getCPtr(log), log);
  }

  
/**
   * Prints a string representation of the underlying token stream, for
   * debugging purposes.
   */ public
 String toString() {
    return libsbmlJNI.XMLInputStream_toString(swigCPtr, this);
  }

  
/**
   * Returns the {@link SBMLNamespaces} object attached to this {@link XMLInputStream}
   * if it has been set, null otherwise.
   <p>
   * @return the {@link SBMLNamespaces} object or null if none has been set.
   */ public
 SBMLNamespaces getSBMLNamespaces() {
  return libsbml.DowncastSBMLNamespaces(libsbmlJNI.XMLInputStream_getSBMLNamespaces(swigCPtr, this), false);
}

  
/**
   * Sets the {@link SBMLNamespaces} object to allow this stream to reference
   * the available SBML namespaces being read.
   */ public
 void setSBMLNamespaces(SBMLNamespaces sbmlns) {
    libsbmlJNI.XMLInputStream_setSBMLNamespaces(swigCPtr, this, SBMLNamespaces.getCPtr(sbmlns), sbmlns);
  }

  
/**
   * Analyses the tokens in the stream and returns the number of 
   * child tokens of the given element.
   <p>
   * @param elementName a string representing the name of the element
   * for which the number of children are to be determined.
   <p>
   * This function allows information from the input stream to be determined
   * without the  need to actually read and consume the tokens in
   * the stream. This functionality
   * is particularly utilized when reading MathML. 
   <p>
   * The function will return the number of child elements of the
   * element represented by the elementName supplied, i.e. the number
   * of child elements encountered before the closing tag for the
   * elementname supplied.  If the elementName
   * has not been supplied then the function assumes that it is reading
   * an apply element followed by a function element.
   <p>
   * @note This function assumes the stream has been read up to and 
   * including the element elementName.
   <p>
   * @return a long integer giving the number of children of the
   * element specified.
   */ public
 long determineNumberChildren(String elementName) {
    return libsbmlJNI.XMLInputStream_determineNumberChildren__SWIG_0(swigCPtr, this, elementName);
  }

  
/**
   * Analyses the tokens in the stream and returns the number of 
   * child tokens of the given element.
   <p>
   * @param elementName a string representing the name of the element
   * for which the number of children are to be determined.
   <p>
   * This function allows information from the input stream to be determined
   * without the  need to actually read and consume the tokens in
   * the stream. This functionality
   * is particularly utilized when reading MathML. 
   <p>
   * The function will return the number of child elements of the
   * element represented by the elementName supplied, i.e. the number
   * of child elements encountered before the closing tag for the
   * elementname supplied.  If the elementName
   * has not been supplied then the function assumes that it is reading
   * an apply element followed by a function element.
   <p>
   * @note This function assumes the stream has been read up to and 
   * including the element elementName.
   <p>
   * @return a long integer giving the number of children of the
   * element specified.
   */ public
 long determineNumberChildren() {
    return libsbmlJNI.XMLInputStream_determineNumberChildren__SWIG_1(swigCPtr, this);
  }

  
/**
   * Analyses the tokens in the stream and returns the number of 
   * child tokens of the specified type within the given element.
   <p>
   * @param childName a string representing the name of the child
   * element whose number is to be determined.
   * @param container a string representing the name of the element
   * for which the number of children are to be determined.
   <p>
   * This function allows information from the input stream to be determined
   * without the  need to actually read and consume the tokens in
   * the stream. This functionality
   * is particularly utilized when reading MathML. 
   <p>
   * The function will return the number of child elements of the
   * element represented by the childName supplied within the element
   * specified by the container, i.e. the number
   * of child elements encountered before the closing tag for the
   * container supplied. 
   <p>
   * @note This function assumes the stream has been read up to and 
   * including the element container.
   <p>
   * @return a long integer giving the number of children of type childName
   * within the container element specified.
   */ public
 long determineNumSpecificChildren(String childName, String container) {
    return libsbmlJNI.XMLInputStream_determineNumSpecificChildren(swigCPtr, this, childName, container);
  }

}
