/*
    LIBSNSP - A C Library for the Simple Network Scanning Protocol
    Copyright (C) 2001 Michael R. Kllejan 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: const.h,v 1.3 2001/09/29 15:13:09 michael Exp $ */

#ifndef CONST_H
#define CONST_H 1

/* Debugging */
#define DEBUG_NO_TELNET

/* General constants */
#define SNSP_VERSION_MAJOR	            "1"
#define SNSP_VERSION_MINOR	            "0"

#define SNSP_WELCOME_MSG   	            "Welcome hax0r...."	

#define PROGNAME           	            "PORZ" 

/* reply.c reply.h */
#define SNSP_WHITESPACE_MAX             10 /* RFC !! */

#define SNSP_REPLYLINE_PARA_MAX         30
#define SNSP_REPLYLINE_PARA_LEN_MAX     300

#define SNSP_REPLYLINE_CODE_MIN         2 /* RFC */
#define SNSP_REPLYLINE_CODE_MAX         6 /* RFC */
#define SNSP_REPLYLINE_CODE_LEN         4 /* RFC */

#define SNSP_REPLYLINE_TERMINATION_LEN  2 /* RFC */

#define SNSP_REPLYLINE_LEN_MAX \
  (SNSP_REPLYLINE_PARA_MAX * \
    (SNSP_REPLYLINE_PARA_LEN_MAX + SNSP_WHITESPACE_MAX)) + \
  (SNSP_REPLYLINE_CODE_MAX * SNSP_REPLYLINE_CODE_LEN) + \
  SNSP_WHITESPACE_MAX + SNSP_REPLYLINE_TERMINATION_LEN

#define SNSP_REPLYLINE_MAX              50

/* cmd.h cmd.c */
#define SNSP_CMD_CMD_LEN	              4 /* RFC */
#define SNSP_CMD_PARA_MAX	              SNSP_REPLYLINE_PARA_MAX
#define SNSP_CMD_LEN_MAX	              SNSP_REPLYLINE_LEN_MAX
#define SNSP_CMD_PARA_LEN_MAX           SNSP_REPLYLINE_PARA_LEN_MAX

/* report.c report.h cmdport.h */
#define SNSP_PORTVAL_MAX                5
#define SNSP_PORTRANGE_STR_MAX          SNSP_PORTVAL_MAX*2+1
#define SNSP_PORTLIST_MAX               30
#define SNSP_PORTLIST_STR_MAX \
  SNSP_PORTLIST_MAX * SNSP_PORTRANGE_STR_MAX

#define SNSP_BANNER_LINE_MAX            10
#define SNSP_BANNER_LINE_LEN_MAX        72 

#endif /* CONST_H */
