/*
    LIBSNSP - A C Library for the Simple Network Scanning Protocol
    Copyright (C) 2001 Michael R. Kllejan 

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: snsp_errno.h,v 1.1 2001/09/26 17:39:20 michael Exp $ */

#ifndef SNSP_ERRNO_H
#define SNSP_ERRNO_H 1

extern int libsnsp_errno;

#define SNSPG_ENOMEM 1 /* Out of memory */
#define SNSPG_EPARA 11 
#define SNSPG_EUKWN 12

#define SNSPC_ECMDILLGCHR 2 /* Illegal char in commandname */
#define SNSPC_ECMDFLSLEN 3 /* Commandname != four characters */
#define SNSPC_ELINETOOLONG 6 /* Commandline too long */
#define SNSPC_EILLGQUOTE 10 /* Quoted parameter in allquote commandline */
#define SNSPC_EPARATOOLONG 5 /* Parameter value too long */
#define SNSPC_EPARATOOMUCH 7 /* Too much parameters */
#define SNSPC_EPARAILLGCHR 8 /* Illegal character in Parameter */
#define SNSPC_EPARAQUOTEOPEN 4 /* Doublequote not closed */
#define SNSPC_ETERMERR 9 /* Commandline was not terminated correctly */
#define SNSPC_EPARACONTQUOTE 13 /* Parameter contains doublequote (renderer) */

#endif /* SNSP_ERRNO_H */
