/*
 * Copyright (c) 1994 Regents of the University of Michigan.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that this notice is preserved and that due credit is given
 * to the University of Michigan at Ann Arbor. The name of the University
 * may not be used to endorse or promote products derived from this
 * software without specific prior written permission. This software
 * is provided ``as is'' without express or implied warranty.
 */

/* Tcl_LdapBindCmd - simple function to bind to a server using LDAP */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <lber.h>
#include <ldap.h>
#include <tcl.h>

extern int ldcnt;
extern LDAP *ldprime[1024];

int Tcl_LdapBindCmd (dummy, interp, argc, argv)
     ClientData dummy;
     Tcl_Interp *interp;
     int argc;
     char **argv;
{
    char *ldaphost, *binddn, *passwd;
    int ldapport = 389;

    if (argc < 5) {
	Tcl_AppendResult (interp, "Usage: ", argv[0], (char *) NULL);
	Tcl_AppendResult (interp, " Host Port BindDN Password ", (char *) NULL);
	return TCL_ERROR;
    }
    ldcnt++;
    if (ldcnt > 1023) {
	ldcnt--;
	Tcl_AppendResult (interp, "Too many connections! ", (char *) NULL);
	return TCL_ERROR;
    }

    ldaphost = argv[1];
    ldapport = atoi (argv[2]);
    binddn = argv[3];
    passwd = argv[4];

    if ((ldprime[ldcnt] = ldap_open (ldaphost, ldapport)) == NULL) {
	ldcnt--;
	Tcl_AppendResult (interp, "Cannot connect to host!", (char *) NULL);
	return TCL_ERROR;
    }
    if (ldap_bind_s (ldprime[ldcnt], binddn, passwd, LDAP_AUTH_SIMPLE) != LDAP_SUCCESS) {
	ldcnt--;
	Tcl_AppendResult (interp, "Invalid name or password!", (char *) NULL);
	return TCL_ERROR;
    }
    sprintf (interp->result, "%d", ldcnt);
    return TCL_OK;
}
