/************************************************************************************
TerraView - visualization and exploration of geographical databases
using TerraLib.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.
This file is part of TerraView. TerraView is free software; you can redistribute it 
and/or modify it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

You should have received a copy of the GNU General Public License
along with TerraView.
The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The software provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use of
this program and its documentation.
*************************************************************************************/

#ifndef  __TERRALIB_INTERNAL_QTVIEWSLISTVIEW_H
#define  __TERRALIB_INTERNAL_QTVIEWSLISTVIEW_H

#include <qlistview.h>
#include <TeDataTypes.h>

class QPopupMenu;
class TeView;
class TeQtThemeItem;
class TeQtViewItem;
class TeQtCheckListItem;
class TeTheme;

class TeQtViewsListView : public QListView
{
	Q_OBJECT

public:

    TeQtViewsListView(QWidget *parent = 0, const char *name = 0);

	~TeQtViewsListView();

	TeQtViewItem* currentViewItem() 
	{ return currentViewItem_; }

	TeQtThemeItem* currentThemeItem() 
	{ return currentThemeItem_; }

	TeQtCheckListItem *popupItem()
		{ return popupItem_; }

	QPopupMenu* popupView()
		{ return popupView_; }

	QPopupMenu* popupTheme()
		{ return popupTheme_; }

	QPopupMenu* popupLegendTitle()
		{ return popupLegendTitle_; }

	QPopupMenu* popupLegend()
		{ return popupLegend_; }

	QPopupMenu* popupChartTitle()
		{ return popupChartTitle_; }

	QPopupMenu* popupChart()
		{ return popupChart_; }

	QPopupMenu* popupOutItem()
		{ return popupOutItem_; }

	void selectItem(QListViewItem *item);

	void selectViewItem(TeView *view);

	TeQtViewItem* getViewItem(TeView *view);

	TeQtThemeItem* getThemeItem(TeTheme *theme);

	void removeViewItem(TeView *view);

	void removeThemeItem(TeTheme *theme);

	void removeItem(QListViewItem *item);

	void checkItemStateChanged(QCheckListItem*, bool);

	void openViewItems();

	void reset();

	void setOn(QCheckListItem*, bool);

	map<TePolyBasicType, Qt::BrushStyle>& getBrushStyleMap() {return brushStyleMap_;}

	map<TeLnBasicType, Qt::PenStyle>& getPenStyleMap() {return penStyleMap_;}

signals:
	void itemChanged(QListViewItem*);
	void popupSignal();
	void checkListItemVisChanged(QCheckListItem*, bool);
	void dragDropItems(TeQtThemeItem*, TeQtViewItem*, TeQtViewItem*);

protected slots:
	void clicked(QListViewItem *item);
	void contextMenuRequested(QListViewItem*, const QPoint&, int);

protected:
	TeQtViewItem		*currentViewItem_;
	TeQtThemeItem		*currentThemeItem_;
	bool				rightMouseWasClicked_;
	bool				checkItemStateChanged_;
	bool				drag_;
	bool				themeOpen_;
	bool				leftButtonPressed_;
	QPoint				pressedPosition_;
	TeQtCheckListItem	*popupItem_;
	QPopupMenu			*popupView_;
	QPopupMenu			*popupTheme_;
	QPopupMenu			*popupLegendTitle_;
	QPopupMenu			*popupLegend_;
	QPopupMenu			*popupChartTitle_;
	QPopupMenu			*popupChart_;
	QPopupMenu			*popupOutItem_;
	map<TePolyBasicType, Qt::BrushStyle>	brushStyleMap_;
	map<TeLnBasicType, Qt::PenStyle>		penStyleMap_;
	TeQtThemeItem		*pressedThemeItem_;

	void contentsMousePressEvent(QMouseEvent *e);

	void contentsMouseReleaseEvent(QMouseEvent *e);

	void contentsMouseMoveEvent(QMouseEvent* e);

	void contentsDragMoveEvent(QDragMoveEvent *e);

	void contentsDropEvent(QDropEvent *e);

	void unselectAllItems();
};


#endif
