/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

/*! \file TeBufferRegion.h
    This file contains structures and definitions for buffer region operation on objects.
 */

/**
  *@author Gilberto Ribeiro de Queiroz
  */

#ifndef  __TERRALIB_INTERNAL_BUFFER_H
#define  __TERRALIB_INTERNAL_BUFFER_H

#include "TeCoord2D.h"

class TeLine2D;
class TePolygon;
class TePolygonSet;

namespace TeBUFFERREGION
{	
	bool TeBufferRegion(const TeCoord2D& coord, const double& bufferDistance, const short& numPoints, TePolygon& pol);

	bool TeBufferRegion(const TeLine2D& line, const double& bufferDistance, const short& numPoints, TePolygonSet& ps);

	bool TeBufferRegion(const TePolygon& pol, const double& bufferDistance, const short& numPoints, TePolygonSet& ps);

}	// end namespace TeBUFFER

#endif //__TERRALIB_INTERNAL_BUFFER_H

