/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#ifdef WIN32
#pragma warning ( disable: 4786 )
#endif

#include "TeFragmentation.h"
#include "TeGeometryAlgorithms.h"


// Is Crescent?
struct xyOrder
{
	bool operator()(const TeCoord2D& c1, const TeCoord2D& c2) const
	{
		if(c1.x_ < c2.x_)
			return true;

		if(c1.x_ > c2.x_)
			return false;

		if(c1.y_ < c2.y_)
			return true;		

		return false;
	}
};


struct ipRedOrder	// XY order
{
	/*
	 * TODO: Talvez desempatar pela segunda coordenada no caso de overlap
	 *
	 */
	bool operator()(const TeINTERSECTOR2::TeBoundaryIP& ip1, const TeINTERSECTOR2::TeBoundaryIP& ip2) const
	{
		if(ip1.redPartNum_ < ip2.redPartNum_)
			return true;

		if(ip1.redPartNum_ > ip2.redPartNum_)
			return false;

		if(ip1.redSegNum_ < ip2.redSegNum_)
			return true;

		if(ip1.redSegNum_ > ip2.redSegNum_)
			return false;

		if(ip1.coords_[0].x_ < ip2.coords_[0].x_)
			return true;

		if(ip1.coords_[0].x_ > ip2.coords_[0].x_)
			return false;

		if(ip1.coords_[0].y_ < ip2.coords_[0].y_)
			return true;
		
		if(ip1.coords_.size() < ip2.coords_.size())
			return true;

		return false;
	}
};

struct yxIPOrder	// YX order
{
	/*
	 * TODO: Talvez desempatar pela segunda coordenada no caso de overlap
	 *
	 */
	bool operator()(const TeINTERSECTOR2::TeBoundaryIP& ip1, const TeINTERSECTOR2::TeBoundaryIP& ip2) const
	{
		if(ip1.coords_[0].x_ > ip2.coords_[0].x_)
			return true;

		if(ip1.coords_[0].x_ < ip2.coords_[0].x_)
			return false;

		if(ip1.coords_[0].y_ > ip2.coords_[0].y_)
			return true;		
		
		return false;
	}
};

inline void cleanIntersections(TeINTERSECTOR2::TeVectorBoundaryIP& ips)
{
	// Eliminar os pontos de interseo 1p que estiverem em cima ou no meio de outros
	// pontos de interseco 2p
	// +
	// Eliminar os segmentos de overlap que estiverem entre algum outro de overlap
	for(unsigned int i = 1; i < ips.size(); ++i)
	{	
		unsigned int currentSize = ips[i].coords_.size();

		for(unsigned int j = 0; j < i; ++j)
		{
			if(currentSize == 1)	// Verificar se ele no se encontra entre algum de overlap
			{
				// Se o ponto j-th  nico, ir p/ o prximo
				// pois ele no tem problemas
				if(ips[j].coords_.size() == 1)
					continue;

				// Se o ponto estiver fora do intervalo x, ir p/ o prximo
				if(ips[i].coords_[0].x_ < ips[j].coords_[0].x_ ||
				   ips[i].coords_[0].x_ > ips[j].coords_[1].x_)
				   continue;

				// Caso contrrio, verificar se ele se encontra no intervalo y tambm
				if(ips[i].coords_[0].y_ < ips[j].coords_[0].y_ &&
				   ips[i].coords_[0].y_ < ips[j].coords_[1].x_)
				   continue;

				if(ips[i].coords_[0].y_ > ips[j].coords_[0].y_ &&
				   ips[i].coords_[0].y_ > ips[j].coords_[1].x_)
				   continue;

				// Remove o ponto e j move o cursor p/ um ponto anterior
				// pois ele ser incremementado
				ips.erase(ips.begin() + i);
				--i;
				break;
			}
			else	// Verificar se ele no  um de overlap entre algum outro de overlap
			{
				// Se o ponto j-th  nico, ir p/ o prximo
				// pois ele no te problemas
				if(ips[j].coords_.size() == 1)
					continue;
		
				// Remover os segmentos iguais
				if(TeEquals(ips[i].coords_[0], ips[j].coords_[0]) &&
				   TeEquals(ips[i].coords_[1], ips[j].coords_[1]))
				{
					ips.erase(ips.begin() + i);
					--i;
					break;
				}

			}
		}
	}
}

inline void TeFragmentSegmentByNonOverlapping(const TeCoord2D& s1, const TeCoord2D& s2,
									   TeINTERSECTOR2::TeVectorBoundaryIP& ips, 
									   TeLine2D& currentFragment,
									   TeLineSet& fragments)
{
	// Se a orientao do segmento no for esquerda/direita
	//  preciso reverter os pontos de interseco
	if(s1.x_ > s2.x_)
	{
		reverse(ips.begin(), ips.end());
	}
	else if(s1.x_ < s2.x_)
	{
	}
	else if(s1.y_ > s2.y_)
	{
		reverse(ips.begin(), ips.end());
	}


	//  s fragmentar o segmento at o ltimo ponto de interseco dele
	for(unsigned int k = 0; k < ips.size(); ++k)
	{
		if(TeEquals(ips[k].coords_[0], currentFragment[currentFragment.size() - 1]))	// Se o ponto de interseco est sobre o vrtice do segmento
		{
			// fragmenta a linha caso haja mais de um ponto nela
			if(currentFragment.size() > 1)								
			{
				fragments.add(currentFragment);

				currentFragment = TeLine2D();
				currentFragment.add(ips[k].coords_[0]);
			}
			else
			{
				continue;
			}
		}
		else
		{
			currentFragment.add(ips[k].coords_[0]);

			fragments.add(currentFragment);

			currentFragment = TeLine2D();
			currentFragment.add(ips[k].coords_[0]);
		}
	}
}

inline void TeFragmentSegmentByOverlapping(const TeCoord2D& s1, const TeCoord2D& s2,
									   TeINTERSECTOR2::TeVectorBoundaryIP& ips,
									   TeLine2D& currentFragment,
									   TeLineSet& fragments, TeLineSet& boundaryFragments)
{
	cleanIntersections(ips);

	unsigned int i = 0;


	// Se a orientao do segmento no for esquerda/direita
	//  preciso reverter os pontos de interseco
	if(s1.x_ > s2.x_)
	{
		for(i = 0; i < ips.size(); ++i)
		{
			if(ips[i].coords_.size() == 2)
			{
				swap(ips[i].coords_[0], ips[i].coords_[1]);
			}
		}

		reverse(ips.begin(), ips.end());
	}
	else if(s1.x_ < s2.x_)
	{
	}
	else if(s1.y_ > s2.y_)
	{
		for(i = 0; i < ips.size(); ++i)
		{
			if(ips[i].coords_.size() == 2)
			{
				swap(ips[i].coords_[0], ips[i].coords_[1]);
			}
		}

		reverse(ips.begin(), ips.end());
	}

	
	//  s fragmentar o segmento at o ltimo ponto de interseco dele
	for(i = 0; i < ips.size(); ++i)
	{
		if(TeEquals(ips[i].coords_[0], currentFragment[currentFragment.size() - 1]))	// Se o ponto de interseco est sobre o vrtice do segmento
		{
			// fragmenta a linha caso haja mais de um ponto nela
			if(currentFragment.size() > 1)
			{
				fragments.add(currentFragment);

				currentFragment = TeLine2D();

				if(ips[i].coords_.size() == 2)
				{
					TeLine2D l;
					l.add(ips[i].coords_[0]);
					l.add(ips[i].coords_[1]);
					
					boundaryFragments.add(l);

					currentFragment.add(ips[i].coords_[1]);
				}
				else
				{
					currentFragment.add(ips[i].coords_[0]);
				}
			}
			else
			{
				if(ips[i].coords_.size() == 2)
				{
					TeLine2D l;
					l.add(ips[i].coords_[0]);
					l.add(ips[i].coords_[1]);
					
					boundaryFragments.add(l);

					currentFragment.clear();
					currentFragment.add(ips[i].coords_[1]);
				}
			}
		}
		else
		{

			currentFragment.add(ips[i].coords_[0]);

			if(ips[i].coords_.size() == 2)
			{
				fragments.add(currentFragment);

				currentFragment = TeLine2D();
				
				currentFragment.add(ips[i].coords_[1]);

				TeLine2D l;
				l.add(ips[i].coords_[0]);
				l.add(ips[i].coords_[1]);
				
				boundaryFragments.add(l);
			}
			else
			{
				fragments.add(currentFragment);

				currentFragment = TeLine2D();
				
				currentFragment.add(ips[i].coords_[0]);
			}			
		}
	}
}

void TeFragmentBoundary(const TeLineSet& lines, TeINTERSECTOR2::TeVectorBoundaryIP& ips, TeLineSet& boundaryFragments, TeLineSet& fragments)
{
	// Informaes sobre os pontos de interseo
	unsigned int currentIP = 0;
	unsigned int nthIP = ips.size();

	// Informaes sobre nmero de linhas
	unsigned int nthLine = lines.size();

	// Ordena os pontos de interseo
	sort(ips.begin(), ips.end(), ipRedOrder());

	for(unsigned int i = 0; i < nthLine; ++i)
	{
		if((currentIP < nthIP) && (ips[currentIP].redPartNum_ == i))	
		{
			// Se a linha corrente possui um ponto de interseo ento ela dever ser fragmentada
			TeLine2D& currentLine = lines[i];
			
			TeLine2D lFrag;

			//unsigned int currentSegment = 0;
			unsigned int nthSegment = currentLine.size() - 1;

			for(unsigned int j = 0; j < nthSegment; ++j)
			{
				if((currentIP < nthIP) && (j == ips[currentIP].redSegNum_) && (ips[currentIP].redPartNum_ == i))	// Se ainda tenho pontos de interseco e 
				{															// o corrente pertence ao segmento atual
					// Adiciona o primeiro ponto da linha na lista do fragmento atual
					if((lFrag.size() == 0) || TeDisjoint(currentLine[j], lFrag[lFrag.size() - 1]))
						lFrag.add(currentLine[j]);

					// Copias todos os pontos de interseco do segmento para
					// um vetor auxiliar e j avana o currentIP
					TeINTERSECTOR2::TeVectorBoundaryIP ipsAux;

					bool hasOverlap = false;

					while((currentIP < nthIP) && (ips[currentIP].redSegNum_ == j) && (ips[currentIP].redPartNum_ == i))
					{
						if(ips[currentIP].coords_.size() == 2)
							hasOverlap = true;

						ipsAux.push_back(ips[currentIP]);

						++currentIP;
					}

					if(hasOverlap)	// Se houverem pontos de interseco que fazem overlap
					{						
						TeFragmentSegmentByOverlapping(currentLine[j], currentLine[j + 1], ipsAux, lFrag, fragments, boundaryFragments);
					}
					else	// Se no houver pontos de interseco que fazem overlap
					{
						TeFragmentSegmentByNonOverlapping(currentLine[j], currentLine[j + 1], ipsAux, lFrag, fragments);
					}
				}
				else
				{
					// Caso no haja ponto de interseco sobre o segmento,
					// apenas insere o ponto no fragmento de linha
					lFrag.add(currentLine[j]);
				}
			}
			
			//if((lFrag.size() > 0u) && TeDisjoint(currentLine[nthSegment], lFrag[lFrag.size() - 1u]))
			if(lFrag.size() > 0)
			{
				//unsigned int st = lFrag.size();

				if(TeDisjoint(currentLine[nthSegment], lFrag[lFrag.size() - 1]))
				{
					lFrag.add(currentLine[nthSegment]);

					fragments.add(lFrag);
				}
				else if(lFrag.size() > 1)
				{
					fragments.add(lFrag);
				}
			}
		}
		else
		{
			// Caso contrrio, se a linha no possui ponto de interseo
			//  s colocar ela na lista de linhas fragmentadas
			fragments.add(lines[i]);
		}
	}
	
	return;
}

