/************************************************************************************
TerraLib - a library for developing GIS applications.
Copyright  2001-2004 INPE and Tecgraf/PUC-Rio.

This code is part of the TerraLib library.
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

You should have received a copy of the GNU Lesser General Public
License along with this library.

The authors reassure the license terms regarding the warranties.
They specifically disclaim any warranties, including, but not limited to,
the implied warranties of merchantability and fitness for a particular purpose.
The library provided hereunder is on an "as is" basis, and the authors have no
obligation to provide maintenance, support, updates, enhancements, or modifications.
In no event shall INPE and Tecgraf / PUC-Rio be held liable to any party for direct,
indirect, special, incidental, or consequential damages arising out of the use
of this library and its documentation.
*************************************************************************************/

#include "TeInitRasterDecoders.h"
#include "TeDecoderMemoryMap.h"
#include "TeDecoderMemory.h"
#include "TeDecoderTIFF.h"
#ifdef WIN32
#ifdef _MRSIDSUPPORT
#include "TeDecoderMrSID.h"
#endif
#include "TeDecoderJPEG.h"
#endif
#include "TeDecoderDatabase.h"
#include "TeDecoderFile.h"
#include "TeDecoderSPR.h"
#include "TeDecoderASCIIGrid.h"

#include <map>

void 
TeInitRasterDecoders()
{
	static TeDecoderDatabaseFactory theDecoderDatabaseFactory("DB");

	static TeDecoderMemoryFactory theDecoderMemoryFactory("MEM");

	static TeDecoderMemoryMapFactory theDecoderMemoryMapFactory("MEMMAP");
	TeDecoderFactory::instanceName2Dec()["raw"]  = "MEMMAP";	
	TeDecoderFactory::instanceName2Dec()["RAW"]  = "MEMMAP";	


	static TeDecoderTIFFFactory theDecoderTIFFFactory("TIF");
	TeDecoderFactory::instanceName2Dec()["tif"]  = "TIF";	
	TeDecoderFactory::instanceName2Dec()["tiff"] = "TIF";	
	TeDecoderFactory::instanceName2Dec()["TIF"] = "TIF";	
	TeDecoderFactory::instanceName2Dec()["TIFF"] = "TIF";

	static TeDecoderSPRFactory theDecoderSPRFactory("SPR");
	TeDecoderFactory::instanceName2Dec()["spr"]  = "SPR";	
	TeDecoderFactory::instanceName2Dec()["SPR"] = "SPR";
	
	static TeDecoderASCIIGridFactory theDecoderASCIIGridFactory("ASCIIGRID");
	TeDecoderFactory::instanceName2Dec()["ascii"]  = "ASCIIGRID";	
	TeDecoderFactory::instanceName2Dec()["asc"]  = "ASCIIGRID";	
	TeDecoderFactory::instanceName2Dec()["ASCII"]  = "ASCIIGRID";	
	TeDecoderFactory::instanceName2Dec()["txt"]  = "ASCIIGRID";	
	TeDecoderFactory::instanceName2Dec()["TXT"]  = "ASCIIGRID";	


#ifdef WIN32
	static TeDecoderJPEGFactory theDecoderJPEGFactory("JPEG");
	TeDecoderFactory::instanceName2Dec()["jpg"]  = "JPEG";	
	TeDecoderFactory::instanceName2Dec()["jpeg"] = "JPEG";

	static TeDecoderFileFactory theDecoderFileFactory("RAW");

#ifdef _MRSIDSUPPORT
	static TeDecoderMrSIDFactory theDecoderMrSIDFactory("MrSID");
	TeDecoderFactory::instanceName2Dec()["sid"] = "MrSID";
	TeDecoderFactory::instanceName2Dec()["SID"] = "MrSID";
	TeDecoderFactory::instanceName2Dec()["Sid"] = "MrSID";
#endif
#endif	

}
