#ifndef TeSTDIOPROGRESS_H
#define TeSTDIOPROGRESS_H

#include "TeProgressBase.h"
#include <iostream>

class TeStdIOProgress : public TeProgressBase
{
public:

	//! Constructor
	TeStdIOProgress() :
		totsteps(0),
		nsteps(0),
		curstep(-1)
	{}

	//! Destructor
	~TeStdIOProgress() {}

	//! Sets the total number of steps to n 
	void setTotalSteps(int n) { totsteps = n; }

	//! Sets the current amount of progress made to n
	void setProgress(int n) 
	{ 
		if (totsteps > 0) 
		{
			int aux = (int)((n*100)/totsteps);
			if (aux != curstep)
			{
				curstep = aux;
				cout << curstep << "% ";
				cout.flush();
			}
		}
	}

	//! Resets the progress interface
	void reset() { totsteps = nsteps = 0; curstep = -1; }

	//! Resets the progress dialog
	void cancel() {};

	//! Sets the label's text
	void setMessage(const string& text) { cout << endl << text << endl;}

	//! Returns true whether the process was cancelled
	bool wasCancelled() { return false; }
	
	//! Sets the caption associated to the progress interface
	void setCaption(const string& /*cap*/) {};

private:
	int totsteps;
	int nsteps;
	int curstep;

};
#endif
