/*  gtktiemu - a TI89/92/92+ emulator
 *  (c) Copyright 2000, Romain Lievin and Thomas Corvazier
 *  (c) Copyright 2001, Romain Lievin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __TI68K_ROM__
#define __TI68K_ROM__

#include "sysdeps.h"

extern ROM_INFO current_rom_info;
extern TIB_INFO current_tib_info;

/*
  Functions
*/
int convertTibToRom(char *f_in, char *f_out);

int loadImage(char *filename, char *file_loaded); // a wrapper for loadRom/Tib
int loadRom(char *filename);
int loadTib(char *filename);

int getRomType(void);

int getRomFileInfo(const char *filename, ROM_INFO *ri);
int getTibFileInfo(const char *filename, TIB_INFO *ri);

int getRomInfo(ROM_INFO *ri);
int getTibInfo(TIB_INFO *ri);

int scanRomImages(const char *dirname, const char *filename);
int dumpRom(char *filename);
int autoDetect(char *rom, int romsize);

#endif
