/****************************************************************************

COPYRIGHT NOTICE:

  The source code in this file is provided free of charge
  to the author's consulting clients.  It is in the
  public domain and therefore may be used by anybody for
  any purpose.

AUTHOR:

  Will Naylor

****************************************************************************/
#include "wnlib.h"

#include "wnhash.h"



void wn_cumhasho(int *paccum,int i)
{
  struct
  {
    int i1,i2;
  } joint;

  joint.i1 = *paccum;
  joint.i2 = i;

  *paccum = wn_memhash(&joint,sizeof(joint));
}



#define MASK (0x3fffffff)

void wn_cumhashu(int *paccum,int i)
{
  int tmp;

  tmp = ((*paccum)&MASK) + (i&MASK);
  *paccum = ((tmp)&MASK) + 0x2fc2ee1d;
}



