/*
 * Copyright (c) 2001, 2002 The XDoclet team
 * All rights reserved.
 */
package xdoclet.modules.jsf;

import java.util.*;

import xdoclet.*;
import xdoclet.template.*;
import xdoclet.util.*;

/**
 * Generate the faces.config.xml for Java Server Faces
 *
 * @author               <a href="mailto:markus.plattner at plattners.de">Markus Plattner</a> Date: 03.06.2004 Time:
 *      14:15:27
 * @created              27. Juni 2004
 * @version              $Revision: 1.2 $
 * @ant.element          display-name="Java Server Faces" name="facesconfigxml"
 *      parent="xdoclet.modules.web.WebDocletTask"
 * @ant.attribute        name="destDir" description="the target directory for the faces-config.xml file" required="true"
 * @xdoclet.merge-file   file="jsf-beans.xml" relates-to="faces-config.xml" description="An XML document containing the
 *      optional backing beans."
 * @xdoclet.merge-file   file="jsf-navigations.xml" relates-to="faces-config.xml" description="An XML document
 *      containing the additional navigation rules."
 * @xdoclet.merge-file   file="jsf-validators.xml" relates-to="faces-config.xml" description="An XML document containing
 *      additional validator configurations."
 * @xdoclet.merge-file   file="jsf-application.xml" relates-to="faces-config.xml" description="An XML document
 *      containing application level settings (language resources)."
 * @xdoclet.merge-file   file="jsf-converters.xml" relates-to="faces-config.xml" description="An XML document containing
 *      additional converters."
 */
public class FacesConfigXmlSubTask extends XmlSubTask
{

    private final static String V_10 = "1.0";
    private final static String V_11 = "1.1";

    //private enum FacesVersion {V_10,V_11};

    private final static String FACES_PUBLICID_10 = "-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.0//EN";
    private final static String FACES_SYSTEMID_10 = "http://java.sun.com/dtd/web-facesconfig_1_0.dtd";

    private final static String FACES_PUBLICID_11 = "-//Sun Microsystems, Inc.//DTD JavaServer Faces Config 1.1//EN";
    private final static String FACES_SYSTEMID_11 = "http://java.sun.com/dtd/web-facesconfig_1_1.dtd";

    private static String DEFAULT_TEMPLATE_FILE = "resources/faces_config_xml.xdt";
    private static String GENERATED_FILE_NAME = "faces-config.xml";

    private String  version = V_10;
    private String  messageBundle = null;
    private String  defaultLocale = null;
    private String  supportedLocales = null;
    private String  currentSupportedLocale = null;

    public FacesConfigXmlSubTask()
    {
        setTemplateURL(getClass().getResource(DEFAULT_TEMPLATE_FILE));
        setDestinationFile(GENERATED_FILE_NAME);
    }

    public String getVersion()
    {
        return this.version;
    }

    public String getDefaultLocale()
    {
        return this.defaultLocale;
    }

    public String getMessageBundle()
    {
        return this.messageBundle;
    }

    public String getSupportedLocales()
    {
        return this.supportedLocales;
    }

    /**
     * @return
     * @doc.tag   type="content"
     */
    public String getSupportedLocale()
    {
        return this.currentSupportedLocale;
    }

    /**
     * @param v
     * @ant.not-required   No. Default is "1.0".
     */
    public void setVersion(String v)
    {
        this.version = v;
    }

    /**
     * @param loc
     * @ant.not-required   No. If not specified, no bundle is used
     */
    public void setDefaultLocale(String loc)
    {
        this.defaultLocale = loc;
    }

    /**
     * @param bundle
     * @ant.not-required   No. If not specified, no bundle is used
     */
    public void setMessageBundle(String bundle)
    {
        this.messageBundle = bundle;
    }

    /**
     * @param listOfLocales
     * @ant.not-required     No. If not specified, no bundle supported locales are used
     */
    public void setSupportedLocales(String listOfLocales)
    {
        this.supportedLocales = listOfLocales;
    }

    /**
     * @param template
     * @throws XDocletException
     * @doc.tag                  type="block"
     */
    public void forAllSupportedLocales(String template) throws XDocletException
    {
        try {
            if (this.supportedLocales != null) {
                for (Iterator it = Arrays.asList(DocletUtil.tokenizeDelimitedToArray(this.supportedLocales, ",")).iterator(); it.hasNext(); ) {
                    //for (String it : Arrays.asList(DocletUtil.tokenizeDelimitedToArray(this.supportedLocales, ","))) {
                    currentSupportedLocale = (String) it.next();
                    getEngine().generate(template);
                }
            }
        }
        catch (TemplateException e) {
            if (e instanceof XDocletException) {
                throw (XDocletException) e;
            }
            else {
                throw new XDocletException(e, Translator.getString(XDocletMessages.class, XDocletMessages.RUNNING_FAILED) + ": " + e.toString());
            }
        }
    }

    public void execute() throws XDocletException
    {

        if (getVersion().equals(V_10)) {
            setPublicId(FACES_PUBLICID_10);
            setSystemId(FACES_SYSTEMID_10);
        }
        else {
            setPublicId(FACES_PUBLICID_11);
            setSystemId(FACES_SYSTEMID_11);
        }
        super.startProcess();
    }

}
