/**************/
/*            */
/* DOMStrings */
/*            */
/**************/

/***************************************************************************/
/*                                                                         */
/* FOR FUNCTIONS TAKING DOMString AS AN ARGUMENT --                        */
/*    NOW YOU CAN JUST SUPPLY A STRING                                     */ 
/* THIS TYPEMAP CONVERTS PERL-STRINGS TO DOMStrings AUTOMATICALLY          */
/*                                                                         */
/***************************************************************************/
%typemap(perl5, in) DOMString * (DOMString temp) {
  if (SvPOK($source)||SvIOK($source)||SvNOK($source)) {
    STRLEN length;
    char *ptr = (char *)SvPV($source,length);
    if (DEBUG_UTF8_IN) {
	printf("Perl in length = %d: ",length);
	for (unsigned int i=0;i<length;i++){
	    printf("<0x%.4X>",ptr[i]);
	}
	printf("\n");
    }
    XMLCh* temp_XMLCh;
    if (SvUTF8($source)) {
	unsigned int charsEaten = 0;
        unsigned char* sizes = new unsigned char[length+1];
        temp_XMLCh = new XMLCh[length+1];
	unsigned int chars_stored = 
	    UTF8_TRANSCODER->transcodeFrom((const XMLByte*) ptr,
					   (unsigned int) length,
					   (XMLCh*) temp_XMLCh, 
					   (unsigned int) length,
					   charsEaten,
					   (unsigned char*)sizes
					   );
	delete [] sizes;
	if (DEBUG_UTF8_IN) {
	    printf("Xerces in length = %d: ",chars_stored);
	    for (unsigned int i=0;i<chars_stored;i++){
		printf("<0x%.4X>",temp_XMLCh[i]);
	    }
	    printf("\n");
	}
	    // indicate the end of the string
	temp_XMLCh[chars_stored] = '\0';
	temp = DOMString(temp_XMLCh,chars_stored);
	delete [] temp_XMLCh;
    } else {
	temp_XMLCh = XMLString::transcode(ptr);
	if (DEBUG_UTF8_IN) {
	    printf("Xerces: ");
	    for (int i=0;temp_XMLCh[i];i++){
		printf("<0x%.4X>",temp_XMLCh[i]);
	    }
	    printf("\n");
	}
	temp = DOMString(temp_XMLCh);
	delete [] temp_XMLCh;
    }
    $target = &temp;
  } else if(SWIG_ConvertPtr($source,(void **) &$target,SWIGTYPE_p_DOMString)) {
    croak("Type error in argument 2 of $name, Expected perl-string or DOMString.");
    XSRETURN(1);
  }
}

/***********************************************/
/*                                             */
/* COVER ALL THE BASES FOR DOMString ARGUMENTS */
/*                                             */
/***********************************************/
%typemap(perl5, in) const DOMString * = DOMString *;
%typemap(perl5, in)       DOMString & = DOMString *;
%typemap(perl5, in) const DOMString & = DOMString *;


/*************************************************************************/
/*                                                                       */
/* RETURN VALUE OF DOMString IS AUTOMATICALLY CONVERTED TO A PERL-STRING */
/* (WITHOUT A CALL TO transcode IN THE PERL SCRIPT)                      */
/*                                                                       */
/*************************************************************************/
%typemap(perl5, out) DOMString {
  unsigned int charsEaten = 0;
  int length  = $source->length();      // string length
  XMLByte* res = new XMLByte[length * UTF8_MAXLEN];          // output string
  unsigned int total_chars =
    UTF8_TRANSCODER->transcodeTo((const XMLCh*) $source->rawBuffer(), 
				   (unsigned int) length,
				   (XMLByte*) res,
				   (unsigned int) length*UTF8_MAXLEN,
				   charsEaten,
				   XMLTranscoder::UnRep_Throw
				   );
  res[total_chars] = '\0';
  if (DEBUG_UTF8_OUT) {
      printf("Xerces out length = %d: ",total_chars);
      for (int i=0;i<length;i++){
	  printf("<0x%.4X>",res[i]);
      }
      printf("\n");
  }
  $target = sv_newmortal();
  sv_setpv((SV*)$target, (char *)res );
  SvUTF8_on((SV*)$target);
  delete $source;
  ++argvi;
}

/***************************************************/
/*                                                 */
/* COVER ALL THE BASES FOR DOMString RETURN VALUES */
/*                                                 */
/***************************************************/
%typemap(perl5, out) const DOMString = DOMString;



/***********/
/*         */
/* XMLCh * */
/*         */
/***********/

/************************************************************************/
/*                                                                      */
/* FOR FUNCTIONS TAKING XMLCh * (I.E AN XMLCh STRING) AS AN ARGUMENT -- */
/* NOW YOU CAN JUST SUPPLY A STRING.  THIS TYPEMAP CONVERTS             */
/* PERL-STRINGS TO XMLCh STRINGS AUTOMATICALLY                          */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/*                                                                      */
/* CAVEAT:                                                              */
/* TO CONVERT STRINGS TO XMLCh STRINGS, A TEMPORARY POINTER MUST BE     */
/* CREATED IN THE in TYPEMAP TO POINT TO MEMORY THAT HOLDS THE          */
/* CONVERSION.  THE MEMORY IS DYNAMIC, SO IT MUST BE FREED AFTER THE C  */
/* FUNCTION THAT USES IT IS CALLED.  THIS IS DONE VIA A "freearg"       */
/* TYPEMAP.  IT IS MAJORLY KLUDGY, BUT IT WORKS.                        */
/*                                                                      */
/* ONE PROBLEM:  A FEW XERCES FUNCTIONS TAKE MULTIPLE ARGUMENTS OF      */
/* TYPE XMLCh STRING.  THEREFORE, A DIFFERENT TEMPORARY VARIABLE MUST   */
/* BE USED FOR EACH ONE.  THIS IS ACCOMPLISHED BY MAKING SEPERATE       */
/* in AND freearg TYPEMAPS FOR EACH ARGUMENT OF A GIVEN NAME. ONCE      */
/* AGAIN, THIS IS KLUDGY, BUT IT WORKS.                                 */
/*                                                                      */
/************************************************************************/

/********************/
/*                  */
/* GENERIC ARGUMENT */
/*                  */
/********************/
%typemap(perl5, in) XMLCh * {
  if (SvPOK($source)||SvIOK($source)||SvNOK($source)) {
    STRLEN length;
    char *ptr = (char *)SvPV($source,length);
    if (DEBUG_UTF8_IN) {
	printf("Perl in length = %d: ",length);
	for (unsigned int i=0;i<length;i++){
	    printf("<0x%.4X>",ptr[i]);
	}
	printf("\n");
    }
    if (SvUTF8($source)) {
	unsigned int charsEaten = 0;
        unsigned char* sizes = new unsigned char[length+1];
        $1 = new XMLCh[length+1];
	unsigned int chars_stored = 
	    UTF8_TRANSCODER->transcodeFrom((const XMLByte*) ptr,
					   (unsigned int) length,
					   (XMLCh*) $1, 
					   (unsigned int) length,
					   charsEaten,
					   (unsigned char*)sizes
					   );
	delete [] sizes;
	if (DEBUG_UTF8_IN) {
	    printf("Xerces in length = %d: ",chars_stored);
	    for (unsigned int i=0;i<chars_stored;i++){
		printf("<0x%.4X>",$1[i]);
	    }
	    printf("\n");
	}
	    // indicate the end of the string
	$1[chars_stored] = '\0';
    } else {
	$1 = XMLString::transcode(ptr);
	if (DEBUG_UTF8_IN) {
	    printf("Xerces: ");
	    for (int i=0;$1[i];i++){
		printf("<0x%.4X>",$1[i]);
	    }
	    printf("\n");
	}
    }
  } else {
    croak("Type error in argument 2 of $name, Expected perl-string.");
    XSRETURN(1);
  }
}

%typemap(perl5, freearg) XMLCh * {
  delete[] $1;
}

// 
// RETURN VALUE OF getMessage METHOD ON A saxException (WHAT A 
// perlErrorHandler) FUNCTION SUCH AS "warning" RECEIVES AS AN ARGUMENT
// 
%typemap(perl5, out) XMLCh * {
  unsigned int charsEaten = 0;
  int length  = XMLString::stringLen($source);      // string length
  XMLByte* res = new XMLByte[length * UTF8_MAXLEN];          // output string
  unsigned int total_chars =
    UTF8_TRANSCODER->transcodeTo((const XMLCh*) $source, 
				   (unsigned int) length,
				   (XMLByte*) res,
				   (unsigned int) length*UTF8_MAXLEN,
				   charsEaten,
				   XMLTranscoder::UnRep_Throw
				   );
  res[total_chars] = '\0';
  if (DEBUG_UTF8_OUT) {
      printf("Xerces out length = %d: ",total_chars);
      for (int i=0;i<length;i++){
	  printf("<0x%.4X>",res[i]);
      }
      printf("\n");
  }
  $target = sv_newmortal();
  sv_setpv((SV*)$target, (char *)res );
  SvUTF8_on((SV*)$target);
  delete[] res;
  ++argvi;
}

//
//  MemBufInputSource::MemBufInputSource()
// 

// 
// ALWAYS ADOPT BUFFER (I.E. MAKE A COPY OF IT) SINCE IT IS TAKEN FROM
// PERL, AND WHO KNOWS WHAT WILL HAPPEN TO IT AFTER IT IS GIVEN TO THE
// CONSTRUCTOR
// 

%typemap(perl5, in) (const XMLByte* const srcDocBytes, unsigned int byteCount) {
  if (SvPOK($input)||SvIOK($input)||SvNOK($input)) {
    XMLByte *xmlbytes = (XMLByte *)SvPV($input, $2);
    $1 = new XMLByte[$2];
    memcpy($1, xmlbytes, $2);
  } else {
    croak("Type error in argument 2 of $name, Expected perl-string.");
    XSRETURN(1);
  }
}

// PERL SHOULD IGNORE THIS ARGUMENT -- CALCULATE IN KLUDGE ABOVE FOR MemBufInputSource 
%typemap(perl5, ignore) const unsigned int byteCount {
}

// 
// FOR Perl*Handler MEMBER FUNCTIONS, SO PERL SCALAR DOESN'T GET WRAPPED 
// BY SWIG
// 
%typemap(perl5, in) SV * {
  $target = $source;
}
