/***************************************************************************
 $RCSfile$
                             -------------------
    cvs         : $Id: ktimport.cpp 388 2006-03-08 15:38:34Z aquamaniac $
    begin       : Mon Mar 01 2004
    copyright   : (C) 2004 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *          Please see toplevel file COPYING for license details           *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
# include <config.h>
#endif


#include "ktimport.h"
#include "askaccount.h"
#include "askdate.h"
#include "accountlist.h"
#include "handledupe.h"
#include "selectpayee.h"
#include "selectcategory.h"

#include "transactionwindow.h"

#include "kbanking.h"

#include <qbanking/qbanking.h>

#include <gwenhywfar/debug.h>

#include <qmessagebox.h>



KTransactionImporter::KTransactionImporter(KBanking *kb,
                                           AB_IMEXPORTER_CONTEXT *ctx,
                                           GWEN_TYPE_UINT32 flags)
:TransactionImporter((App*)kb, ctx, flags), _kb(kb) {

}



KTransactionImporter::~KTransactionImporter(){
}



Account*
KTransactionImporter::askUserForAccount(const std::string &bankCode,
                                        const std::string &accountNumber){
  AskAccount *w;
  Account *a;

  a=0;
  w=new AskAccount(_kb,
                   bankCode.c_str(), accountNumber.c_str(),
                   0, "AskAccount", true);
  if (w->exec()==QDialog::Accepted) {
    a=w->selectedAccount();
    assert(a);
    DBG_NOTICE(0, "User selected account");
  }
  delete w;
  return a;
}



GWEN_TIME *KTransactionImporter::askUserForDate(const Transaction *t,
                                                const GWEN_TIME *lastDate){
  AskDate *w;
  GWEN_TIME *ti;

  ti=0;
  w=new AskDate(_kb,
                t, lastDate,
                0, "AskDate", true);
  if (w->exec()==QDialog::Accepted) {
    ti=w->selectedDate();
  }
  delete w;
  return ti;
}



TransactionImporter::DupeCheckResult
KTransactionImporter::askUserForDuplicate(Account *a,
                                          RefPointer<Transaction> tnew,
                                          RefPointer<Transaction> told,
                                          const std::list<RefPointer<Transaction> > &dnl,
                                          const std::list<RefPointer<Transaction> > &dol,
                                          bool &dontAskAgain){
  return HandleDupe::askUser(a, tnew, told, dnl, dol, dontAskAgain, 0);
}



Payee *KTransactionImporter::askUserForPayee(RefPointer<Transaction> t,
                                             bool &aborted,
                                             bool &askNoMore){
  return SelectPayee::assignPayee(_kb, t.ptr(), aborted, askNoMore, 0);
}



Category *KTransactionImporter::askUserForCategory(RefPointer<Transaction> t,
                                                   bool &aborted,
                                                   bool &askNoMore){
  return SelectCategory::assignCategory(_kb, t.ptr(), aborted, askNoMore,
                                        _kb->getParentWidget());
}



bool
KTransactionImporter::presentTransactionsToUser(std::list<RefPointer<Transaction> > &toAdd,
                                                std::list<RefPointer<Transaction> > &toDel) {
  return true;

  TransactionWindow *tv;

  tv=new TransactionWindow(_kb, toAdd,
                           "ImportAddTransactions",
                           0,
                           "TransactionWindow",
                           Qt::WDestructiveClose);
  tv->setCaption(QWidget::tr("Transactions"));
  if (!tv->init()) {
    QMessageBox::critical(_kb->getParentWidget(),
                          QWidget::tr("Internal Error"),
                          QWidget::tr("Couldn't initialize transaction view."),
                          QWidget::tr("Dismiss"), QString::null);
    delete tv;
    return false;
  }
  tv->show();

  return true;
}










