/***************************************************************************
                          rhatchdialog.cpp  -  description
                             -------------------
    begin                : Tue Oct 19 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : mustun@ribbonsoft.com
 ***************************************************************************/



#include "rhatchdialog.h"

#include "rmath.h"

/**
 * Constructor
 */
RHatchDialog::RHatchDialog(const QString& _caption,
                           const QString& _label,
                           QWidget* _parent)
  :QDialog(_parent, _caption, true, WStyle_NormalBorder)
{
  setCaption(_caption);

  setFixedSize(DEF_HATCHDLG_WIDTH, DEF_HATCHDLG_HEIGHT);

  // Create label:
  //
  lText = new QLabel(_label, this, "ltext");
  lText->setAlignment(AlignCenter);
  if(lText->sizeHint().width()+20>DEF_HATCHDLG_WIDTH) {
    setFixedWidth(lText->sizeHint().width()+20);
  }
  if(lText->sizeHint().height()+70>DEF_HATCHDLG_HEIGHT) {
    setFixedHeight(lText->sizeHint().height()+70);
  }
  lText->setGeometry(10, 10, width()-10, 30);


  // Create comboboxes:
  //
  cbPattern = new RComboBox(false, this, "pattern");
  cbPattern->fillInPatterns();
  QToolTip::add(cbPattern, tr("Pattern"));
  cbPattern->setGeometry(10, 50, (width()-20)/2, 20);

  cbFactor = new RComboBox(true, this, "width");
  cbFactor->insertItem("0.5");
  cbFactor->insertItem("1.0");
  cbFactor->insertItem("1.5");
  cbFactor->insertItem("2.0");
  cbFactor->insertItem("5.0");
  cbFactor->insertItem("10.0");

  cbFactor->setEditText("1.0");
  QToolTip::add(cbFactor, tr("Factor"));
  cbFactor->setGeometry(10+(width()-20)/2, 50, (width()-20)/2, 20);

  // Create buttons:
  //
  bOk = new QPushButton(tr("Ok"), this);
  bOk->setGeometry(10+(width()-20)/3*1, 80, (width()-20)/3, 20);
  bOk->setAccel(Key_Return);
  connect(bOk, SIGNAL(clicked()), SLOT(accept()));

  bCancel = new QPushButton(tr("Cancel"), this);
  bCancel->setGeometry(10+(width()-20)/3*2, 80, (width()-20)/3, 20);
  bCancel->setAccel(Key_Escape);
  connect(bCancel, SIGNAL(clicked()), SLOT(reject()));

  //bHelp = new QPushButton(tr("Help"), this);
  //bHelp->setGeometry(10+(width()-20)/3*2, 80, (width()-20)/3, 20);
  //bHelp->setAccel(Key_F1);
}


/**
 * Destructor
 */
RHatchDialog::~RHatchDialog()
{

}



// Get the chosen pattern as string:
//
QString
RHatchDialog::getPattern()
{
  if(cbPattern) {
    return cbPattern->currentText();
  }

  return "45";
}



// Get the chosen factor:
//
double
RHatchDialog::getFactor()
{
  double ret=1.0;

  if(cbFactor) {
    //bool ok;
    //ret = cbFactor->currentText().toFloat(&ok);
    
    ret = mtCalculate( cbFactor->currentText(), 1.0 );
    if(ret<0.00001) ret=1.0;
    
    /*
    ExprParser parser;
    parser.setExpression( cbFactor->currentText() );
    ret = parser.getValue();
    if( !parser.errorOccurred() ) {
      if(ret<0.00001) ret=1.0;
    }
    else {
      ret=1.0;
    }
    */
  }

  return ret;
}







