/***************************************************************************
                          rmultilinedit.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rmultilinedit.h 1998/09/19 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RMULTILINEDIT_H
#define RMULTILINEDIT_H

#include <qmultilinedit.h>


class RMultiLineEdit : public QMultiLineEdit
{
  Q_OBJECT
public:
  RMultiLineEdit(QWidget* _parent=0, const char* _name=0);
  ~RMultiLineEdit();

	void keyPressEvent( QKeyEvent *e );
  
  /*! Load a file. Ask User for a Filename */
  //
  void loadFile();
  
  /*! Load a file by its filename 
      \param _name file name
      \return true if loading was successful
  */
  bool loadFile(const QString& _name);
  
  /*! Save the text in a file. Ask User for a Filename */
  //
  void saveFile();
  
  /*! Save a file with its filename given
      \param _name file name
      \return true if loading was successful
  */
  bool saveFile(const QString& _name);

protected:
  void resizeEvent(QResizeEvent *_ev);

};


#endif

// EOF


