/***************************************************************************
                          rsettings.h  -  description
                             -------------------
    begin                : Sun Sep 12 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RSETTINGS_H
#define RSETTINGS_H

#include <qlist.h>
#include <qstring.h>

#include "rprgdef.h"
#include "rmath.h"


/**
 * \class Setting
 * Class Setting wraps a single setting with a name and a value.
 * This class is for internal use only.
 */
class RSetting
{
public:
  /**
   * Constructor.
   */
  RSetting() { autoValue=true; }

  /**
   * Constructor.
   *
   * \param _name Name of this setting.
   * \param _value Value of this setting.
   * \param _autoValue Value is generated automatically
   *                     (used for knowing wheter the user can
   *                      edit values or not)
   */
  RSetting( QString _name, QString _value, bool _autoValue=true )
    { name=_name; value=_value; autoValue=_autoValue; }

  /** Destructor */
  ~RSetting() {}

  /** Sets the name of this setting. */
  void setName(QString _name)
    { name=_name; }

  /** Gets the name of this setting. */
  QString getName()
    { return name; }

  /** Sets the value of this setting. */
  void setValue(QString _value)
    { value=_value; }

  /** Gets the value of the setting. */
  QString getValue()
    { return value; }

  /** Sets the auto value flag. */
  void setAutoValue(bool _av)
    { autoValue=_av; }

  /** Gets the auto value flag. */
  bool isAutoValue()
    { return autoValue; }

private:
  QString name;
  QString value;
  bool autoValue;
};



class RSettings
{
private:
  QString sectionName;
  QChar nameStarter;
  QChar nameStopper;
  QChar valueStarter;
  QChar valueStopper;

protected:
  /** The list which contains all stored settings. */
  QList<RSetting> settingList;

public:
  /** Constructor. */
  RSettings() { settingList.setAutoDelete(true); }
  RSettings(QString _sectionName,
            QChar _nameStarter, QChar _nameStopper,
            QChar _valueStarter, QChar _valueStopper);
  RSettings(QString _sectionName,
            QChar _nameStarter, QChar _separator,
            QChar _valueStopper);
  RSettings(QChar _nameStopper, QChar _valueStarter,
            QChar _valueStopper);
  virtual ~RSettings();

  /** Returns the list of settings as a QList. */
  QList<RSetting>* getSettingList() { return &settingList; }

  /** Sets the name of the section where this settings are saved. */
  virtual void setSectionName(QString name) { sectionName=name; }

  virtual void    clear();
  virtual void    addSetting(QString _name, QString _value, bool _autoValue=true);
  virtual void    addSetting(QString _name, int _value, bool _autoValue=true);
  virtual void    addSetting(QString _name, double _value, bool _autoValue=true);
  virtual bool    removeSettings(QString name);
  virtual void    removeNonAutoSettings();
  virtual QString getSetting(QString name);
  virtual int     getSettingInt(QString name, bool* ok=0);
  virtual double  getSettingDouble(QString name, bool* ok=0);
  virtual Unit    getSettingUnit(QString name, bool* ok=0);
  virtual AngleUnit getSettingAngleUnit(QString name, bool* ok=0);
  virtual bool    readFromFile(QString fileName);
  virtual bool    readFromString(QString s);
  virtual QString replace(QString str);

};

#endif





