/***************************************************************************
                          rsnap.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rsnap.h 1998/09/01 A. Mustun RibbonSoft 
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RSNAP_H
#define RSNAP_H

#include "raction.h"
#include "relement.h"
#include "rsnapdef.h"

//class RElement;

/*! Handling of Snap functions
*/
class RSnap : public RAction
{
  Q_OBJECT
public:
  /*! Constructor
  */
  RSnap();
  /*! Destructor
  */
  ~RSnap();
  
  /*! Snap a point of the graphic doc
     \param _x Pointer to return the snapped x-coordinate
     \param _y Pointer to return the snapped y-coordinate
     \param _definitive Is this the definitive point we snap or must we call it again 
                        (for manual intersections)
     \param _onlyElement Pointer to the only element we can snap to
     \param _showPreview true: Show preview
                         false: Show no preview
     \param _calcDirection true: Calculate the direction (elemnent angle of endpoints)
     \param _direction Pointer to variable for direction
  */
  bool snapPoint(double* _x=0, double* _y=0,
                 bool _definitive=false,
                 RElement* _onlyElement=0,
                 bool _showPreview=true,
                 bool _calcDirection=false,
                 double* _direction=0);
  /*! Stop
  */
  void stop();
  uint getSnapMode() { return snapMode; }
  double getSnapDistance() { return snapDistance; }

  RElement* getSnappedElement() { return cEl; }

  double getLastUsedXPos()    { return lastUsedXPos; }
  double getLastUsedYPos()    { return lastUsedYPos; }
  double getLastUsedAngle()   { return lastUsedAngle; }
  double getLastUsedRadius()  { return lastUsedRadius; }

  int   getLastUsedPosMode() { return lastUsedPosMode; }

public slots:
  void setFreeMode()       { snapMode=SNAP_FREE;      }
  void setGridMode()       { snapMode=SNAP_GRID;      }
  void setEndpointsMode()  { snapMode=SNAP_ENDPOINTS; }
  void setCentersMode()    { snapMode=SNAP_CENTERS;   }
  void setMiddlesMode()    { snapMode=SNAP_MIDDLES;   }
  void setAutoInterMode()  { snapMode=SNAP_AUTOINTER; }
  void setManInterMode()   { snapMode=SNAP_MANINTER;  }
  void setDistMode(double _dist) { snapMode=SNAP_DIST; snapDistance=_dist; }
  void setOnElementMode()  { snapMode=SNAP_ONELEMENT; }
  void setKeyXYMode()      { snapMode=SNAP_KEYXY; }
  void setKeyARMode()      { snapMode=SNAP_KEYAR; }
  
  void recalculateSnapRange();

private:
  bool snapFree();
  bool snapGrid();
  bool snapEndpoints();
  bool snapCenters();
  bool snapMiddles();
  bool snapAutoInter();
  bool snapManInter(bool _definitive);
  bool snapDist();
  bool snapOnElement();

public:
  bool snapElement(bool _show=true,
                   int _types=T_ALL,
                   RElement* _exception=0);

private:
  uint snapMode;              // Current Snap Mode

  double cx, cy;               // snapped point
  RElement* cEl;              // snapped element

  RElement* firstElement;     // First snapped element 
                              //   (for manual intersections)
  double snapDistance;         // distance fro snapDist() mode
  
  double snapRange;            // Real snap range

  RElement* onlyElement;      // Snap only to this element 
                              //   (set /unset by snapPoint())
  bool showPreview;           // Draw preview?
  bool calcDirection;         // Calculate direction (for arrow prev)?
  double direction;            // The direction of the arrow

  double lastUsedXPos;         // Remembers last used X Pos from the input box
  double lastUsedYPos;         // Remembers last used Y Pos from the input box
  double lastUsedAngle;        // Remembers last used Angle from the input box
  double lastUsedRadius;       // Remembers last used Radius from the input box

  int   lastUsedPosMode;      // Remembers last used position mode (0=abs/1=rel) from the input box

};


#endif

// EOF

