/***************************************************************************
                          rstatuspanel.h  -  description
                             -------------------
    begin                : Mon Sep 27 1999
    copyright            : (C) 1999 by Andreas Mustun
    email                : andrew@ribbonsoft.com
 ***************************************************************************/

/****************************************************************************
** rstatuspanel.h 1998/09/20 A. Mustun RibbonSoft
**
** Copyright (C) 1998 RibbonSoft.  All rights reserved.
**
*****************************************************************************/

#ifndef RSTATUSPANEL_H
#define RSTATUSPANEL_H

#include "rwidget.h"

class QToolButton;
class QLabel;
class QProgressBar;
class RGraphic;

/*! Status Panel with three separate parts
*/
class RStatusPanel : public RWidget
{

  Q_OBJECT
public:
  /*! Constructor
      \param _parent The parent widget
      \param _name Name
      \param _f Flags
  */
  RStatusPanel(QWidget* _parent=0, 
               const char* _name=0,
               WFlags _f=0);
  /*! Destructor
  */
  ~RStatusPanel();

  /*! Re-Initialize
  */
  void reinit();
  
  /*! Resize child widgets
  */
  void resizeChildren();
  
  /*! Set the pointer to the graphic document
      \param _graphic The graphic doc
  */
  void      setGraphic(RGraphic* _graphic);
  /*! Get the pointer to the graphic document
      \return Pointer to graphic or 0
  */
  RGraphic* getGraphic() { return graphic; }
  
  /*! Set the current status Text (most left part)
  */
  void setStatus(const QString& _stat=0);
  /*! Set the status text for the left mouse button
      (left side of middle part)
      \param _lButStat Status text for the left mouse button
  */
  void setLeftButtonStatus(const QString& _lButStat=0);
  /*! Set the status text for the right mouse button
      (right side of middle part)
      \param _rButStat Status text for the right mouse button
  */
  void setRightButtonStatus(const QString& _rButStat=0);
  /*! Set the status text for the current function
      (left part)
      \param _fStat Status text for the current function
  */
  void setFunctionStatus(const QString& _fStat=0);
  /*! Set the status texts for the current action. This function calles setStatus(), 
      setLeftButtonStatus() and setRightButonStatus()
      \param _lButStat Status for left mouse button
      \param _rButStat Status for right mouse button
      \param _fStat Status for current function
  */
  void setActionStatus(const QString& _lButStat=0, 
                       const QString& _rButStat=0, 
                       const QString& _fStat=0);
  /*! Clear the whole status bar
  */
  void clear();

public slots:
  /*! Initialize progress bar (bottom of the main window)
      \param _prgSteps Number of progress steps (100% of progress)
   */
  void iniProgress(int _prgSteps, const QString& _label=QString::null);

  /*! Set progress to a value
      \param _prg value of progress (in steps given by function iniProgress)
      \param _every don't update always, only update every ... steps
      \sa iniProgress()
   */
  void setProgress(int _prg, int _every);

  /*! Deletes progress bar completely (remove from screen)
   */
  void delProgress();

protected:
  /*! Resize event
  */
  virtual void resizeEvent(QResizeEvent* _ev);
    
private:
  /*! Pointer to graphic doc
  */
  RGraphic* graphic;
  
  /*! 1st seperator
  */
  QFrame*       fSep1;
  /*! 2nd seperator
  */
  QFrame*       fSep2;
  
  /*! Label for status output
  */
  QLabel*       lStatus;
  
  /*! Label for mouse icon
  */
  QLabel*       lMouse;
  /*! Label for left button info
  */
  QLabel*       lLeftButton;
  /*! Label for right button info
  */
  QLabel*       lRightButton;
  /*! Label for function info
  */
  QLabel*       lFunction;
  
  /*! The progress bar
  */
  QProgressBar* progressBar;
  
};


#endif

// EOF


