/*
	Author: Marco Costalba (C) 2005-2006

	Copyright: See COPYING file that comes with this distribution

*/
#ifndef MAINIMPL_H
#define MAINIMPL_H

#include <qguardedptr.h>
#include <qregexp.h>
#include <qprocess.h>
#include <qptrvector.h>
#include "exceptionmanager.h"
#include "common.h"
#include "mainbase.h"

class QListViewItem;
class QListBoxItem;
class Git;
class Rev;
class Domain;
class CommitImpl;
class QProcess;
class QPopupMenu;
class QCustomEvent;
class QAccel;
class QTextEdit;
class ListViewItem;
class TreeView;
class PatchView;
class FileView;
class RevsView;
class TabFile;
class FileHistory;

class MainImpl : public MainBase {
Q_OBJECT
public:
	MainImpl(const QString& curDir = "", QWidget* parent = 0, const char* name = 0);

signals:
	void highlightPatch(const QString&, bool);
	void closeAllWindows();
	void closeAllTabs();
	void tabClosed(int tabPos);

public slots:
	void tabWdg_currentChanged(QWidget*);
	void on_newRevsAdded(const FileHistory*, const QValueVector<QString>&);

protected:
	void customEvent(QCustomEvent* e);

private slots:
	void initWithEventLoopActive();
	void refreshRepo(bool setCurRevAfterLoad = true);
	void on_listViewLog_doubleClicked(QListViewItem*);
	void on_fileList_doubleClicked(QListBoxItem*);
	void on_treeView_doubleClicked(QListViewItem*);
	void on_histListView_doubleClicked(QListViewItem* item);
	void on_customActionListChanged(const QStringList& list);
	void on_openRecent_activated(int id);
	void on_customAction_activated(int id);
	void on_customAction_exited(const QString& name);
	void on_goRef_activated(int id);
	void slotCommitViewerClosed();
	void lineEditSHA_returnPressed();
	void lineEditFilter_returnPressed();
	void pushButtonCloseTab_clicked();
	void toolButtonFilter_toggled(bool);
	void toolButtonBold_toggled(bool);
	void accelActivated(int);
	void ActBack_activated();
	void ActForward_activated();
	void ActFind_activated();
	void ActFindNext_activated();
	void ActViewRev_activated();
	void ActViewFile_activated();
	void ActViewFileNewTab_activated();
	void ActViewDiff_activated();
	void ActViewDiffNewTab_activated();
	void ActExternalDiff_activated();
	void ActSplitView_activated();
	void ActOpenRepo_activated();
	void ActOpenRepoNewWindow_activated();
	void ActRefresh_activated();
	void ActSaveFile_activated();
	void ActMailFormatPatch_activated();
	void ActMailApplyPatch_activated();
	void ActSettings_activated();
	void ActCommit_activated();
	void ActTag_activated();
	void ActTagDelete_activated();
	void ActPush_activated();
	void ActPop_activated();
	void ActClose_activated();
	void ActExit_activated();
	void ActCustomActionSetup_activated();
	void ActCheckWorkDir_toggled(bool);
	void ActShowTree_toggled(bool);
	void ActFilterTree_toggled(bool);
	void ActAbout_activated();
	void ActHelp_activated();
	void closeEvent(QCloseEvent* ce);

private:
	friend class FileView;
	friend class RevsView;
	friend class ListView;
	friend class PatchView;

	bool eventFilter(QObject* obj, QEvent* ev);
	void updateGlobalActions(bool b);
	void updateContextActions(SCRef newRevSha, SCRef newFileName, bool isDir, bool found);
	void setupPixmaps(int h);
	void setupAccelerator(QAccel* accel);
	int currentTabType(QObject** t);
	void filterList(bool isOn, bool onlyHighlight);
	bool passFilter(ListViewItem* i, SCRef f, int cn, const QMap<QString,bool>& sm);
	void setRepository(SCRef wd, bool r, bool ks, QStringList* fl = NULL);
	void diffViewerUpdate(QListViewItem* item, bool newDiff);
	void getExternalDiffArgs(QStringList* args);
	void lineEditSHASetText(SCRef text);
	void updateCommitMenu(bool isStGITStack);
	void updateRecentRepoMenu(SCRef newEntry = "");
	void doUpdateRecentRepoMenu(SCRef newEntry);
	void doUpdateCustomActionMenu(const QStringList& list);
	void ActCommit_setEnabled(bool b);
	void doContexPopup(SCRef sha);
	void doFileContexPopup(SCRef fileName, int type);
	void adjustFontSize(int delta);
	void scrollTextEdit(int delta);
	void scrollListView(int delta);
	void goMatch(int delta);
	bool askApplyPatchParameters(bool* commit, bool* fold);
	QTextEdit* getCurrentTextEdit();
	template<class X> QPtrList<X>* getTabs(int tabPos = -1);
	template<class X> X* firstTab(int startPos = -1);
	void openFileTab(FileView* fv = NULL);

	EM_DECLARE(exSetRepositoryCalled);
	EM_DECLARE(exExiting);

	Git* git;
	RevsView* rv;
	QAccel* accel;

	// curDir is the repository working dir, could be different from qgit running
	// directory QDir::current(). Note that qgit could be run from subdirectory
	// so only after git->isArchive() that updates curDir to point to working dir
	// we are sure is correct.
	QString curDir;
	QRegExp shortLogRE;
	QRegExp longLogRE;
	QGuardedPtr<QPopupMenu> contextMenu;
	QGuardedPtr<QPopupMenu> contextSubMenu;
	QPtrVector<QPixmap> pixmaps;
	QString startUpDir;
	QString textToFind;
	bool changesCommitted;
	int ph; // pixmaps height
	int pw; // pixmaps width
	unsigned long secs;
	bool setRepositoryBusy;
	int recentRepoMenuPos;
};

class ExternalDiffProc : public QProcess {
Q_OBJECT
public:
	ExternalDiffProc(const QStringList& args, QObject* p) : QProcess(args, p) {

		connect(this, SIGNAL(processExited()), this, SLOT(exit()));
	}
	~ExternalDiffProc() {

		tryTerminate();
		removeFiles();
	}
public slots:
	void exit() { deleteLater(); }

private:
	void removeFiles() {

		if (!arguments().empty()) {
			QDir d; // remove temporary files to diff on
			d.remove(arguments()[1]);
			d.remove(arguments()[2]);
		}
	}
};

#endif
