/*
 * Decompiled with CFR 0.152.
 */
package driftwood.data;

public class TinyMap {
    int keyMap = 0;
    Object[] values = null;

    public static int countSetBits(int n) {
        int n2 = n - (n >>> 1 & 0x55555555);
        int n3 = (n2 & 0x33333333) + (n2 >>> 2 & 0x33333333);
        int n4 = (n3 + (n3 >>> 4) & 0xF0F0F0F) * 0x1010101 >>> 24;
        return n4;
    }

    public static int indexOf(int n, int n2) {
        int n3 = (1 << n) - 1;
        return TinyMap.countSetBits(n2 & n3);
    }

    public int indexOf(int n) {
        return TinyMap.indexOf(n, this.keyMap);
    }

    public static boolean contains(int n, int n2) {
        int n3 = 1 << n;
        return (n3 & n2) != 0;
    }

    public boolean contains(int n) {
        return TinyMap.contains(n, this.keyMap);
    }

    public static int size(int n) {
        return TinyMap.countSetBits(n);
    }

    public int size() {
        return TinyMap.size(this.keyMap);
    }

    public Object get(int n) {
        if (!TinyMap.contains(n, this.keyMap)) {
            return null;
        }
        return this.values[TinyMap.indexOf(n, this.keyMap)];
    }

    public Object put(int n, Object object) {
        int n2;
        int n3 = TinyMap.indexOf(n, this.keyMap);
        if (TinyMap.contains(n, this.keyMap)) {
            Object object2 = this.values[n3];
            this.values[n3] = object;
            return object2;
        }
        int n4 = TinyMap.size(this.keyMap);
        this.keyMap |= 1 << n;
        Object[] objectArray = new Object[n4 + 1];
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray[n2] = this.values[n2];
        }
        objectArray[n3] = object;
        for (n2 = n3; n2 < n4; ++n2) {
            objectArray[n2 + 1] = this.values[n2];
        }
        this.values = objectArray;
        return null;
    }

    public Object remove(int n) {
        int n2;
        if (!TinyMap.contains(n, this.keyMap)) {
            return null;
        }
        int n3 = TinyMap.indexOf(n, this.keyMap);
        Object object = this.values[n3];
        this.keyMap &= ~(1 << n);
        Object[] objectArray = new Object[this.values.length - 1];
        for (n2 = 0; n2 < n3; ++n2) {
            objectArray[n2] = this.values[n2];
        }
        for (n2 = n3 + 1; n2 < this.values.length; ++n2) {
            objectArray[n2 - 1] = this.values[n2];
        }
        this.values = objectArray;
        if (this.values.length == 0) {
            this.values = null;
        }
        return object;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[").append(this.size()).append(" items");
        for (int i = 0; i < 32; ++i) {
            if (!this.contains(i)) continue;
            stringBuffer.append(", ").append(i).append(":").append(this.get(i));
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

