/***************************************************************************
 *   Copyright (C) 2009 by Ilya Kotov                                      *
 *   forkotov02@hotmail.ru                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef POSITIONBAR_H
#define POSITIONBAR_H

#include "pixmapwidget.h"

/**
	@author Ilya Kotov <forkotov02@hotmail.ru>
*/

class QMouseEvent;

class MainWindow;
class Skin;


class PositionBar : public PixmapWidget
{
    Q_OBJECT
public:
    PositionBar(QWidget *parent = 0);

    ~PositionBar();

public slots:
    void setValue(qint64);
    qint64 value()const{return m_value;}
    void setMax(qint64);

signals:
    void sliderMoved (qint64);

private slots:
    void updateSkin();

private:
    Skin *m_skin;
    bool m_moving;
    qint64 press_pos;
    qint64 m_max, m_min, m_pos, m_value, m_old;
    QPixmap m_pixmap;
    MainWindow *mw;
    qint64 convert(qint64);   // value = convert(position);
    void draw(bool pressed = true);

protected:
    void mousePressEvent(QMouseEvent*);
    void mouseReleaseEvent(QMouseEvent*);
    void mouseMoveEvent(QMouseEvent*);


};

#endif
