#ifndef RIGCONTROL_H
#define RIGCONTROL_H
#include <QObject>
#include <QComboBox>
#include <hamlib/rig.h>
#include "rigparams.h"
#include "xmlrpc/xmlinterface.h"

bool model_Sort(const rig_caps *caps1,const rig_caps *caps2);


class rigControl: public QObject
{
	Q_OBJECT
public:
  rigControl(int radioIndex);
	~rigControl();
	bool init();
	bool enabled() {return rigControlEnabled;}
	bool getFrequency(double &frequency);
	bool setFrequency(double frequency);
	bool getMode(QString &mode);
  bool setMode(QString mode);
  bool setPTT(bool On);
  int getModelNumber(int idx);
  int getRadioModelIndex();
  bool getRadioList(QComboBox *cb);
  void disable();
  scatParams* params() {return &catParams;}
  void activatePTT(bool b);
  double getTxDelay() {return catParams.txOnDelay;}


private:
 	hamlib_port_t myport;
  RIG *my_rig;            // handle to rig (nstance)
	freq_t freq;            // frequency  
	rmode_t rmode;          // radio mode of operation 
	pbwidth_t width;
	vfo_t vfo;              // vfo selection 
	int strength;           // S-Meter level 
	int retcode;            // generic return code from functions 
	rig_model_t myrig_model;
	bool rigControlEnabled;
  void errorMessage(int errorCode,QString command);
  void getRadioList();
  scatParams catParams;
  int serialP;


};

extern rigControl *rigControllerR1;
extern rigControl *rigControllerR2;
extern rigControl *rigController;
#endif
