/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitAnimationEvent.h"

#include "KURL.h"
#include "WebKitAnimationEvent.h"
#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitAnimationEvent);

/* Hash table */

static const HashTableValue JSWebKitAnimationEventTableValues[4] =
{
    { "animationName", DontDelete|ReadOnly, (intptr_t)jsWebKitAnimationEventAnimationName, (intptr_t)0 },
    { "elapsedTime", DontDelete|ReadOnly, (intptr_t)jsWebKitAnimationEventElapsedTime, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsWebKitAnimationEventConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationEventTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSWebKitAnimationEventTableValues, 0 };
#else
    { 9, 7, JSWebKitAnimationEventTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSWebKitAnimationEventConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationEventConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebKitAnimationEventConstructorTableValues, 0 };
#else
    { 1, 0, JSWebKitAnimationEventConstructorTableValues, 0 };
#endif

class JSWebKitAnimationEventConstructor : public DOMConstructorObject {
public:
    JSWebKitAnimationEventConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSWebKitAnimationEventConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSWebKitAnimationEventPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags)); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSWebKitAnimationEventConstructor::s_info = { "WebKitAnimationEventConstructor", 0, &JSWebKitAnimationEventConstructorTable, 0 };

bool JSWebKitAnimationEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationEventConstructor, DOMObject>(exec, &JSWebKitAnimationEventConstructorTable, this, propertyName, slot);
}

bool JSWebKitAnimationEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitAnimationEventConstructor, DOMObject>(exec, &JSWebKitAnimationEventConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSWebKitAnimationEventPrototypeTableValues[2] =
{
    { "initWebKitAnimationEvent", DontDelete|Function, (intptr_t)jsWebKitAnimationEventPrototypeFunctionInitWebKitAnimationEvent, (intptr_t)5 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationEventPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSWebKitAnimationEventPrototypeTableValues, 0 };
#else
    { 2, 1, JSWebKitAnimationEventPrototypeTableValues, 0 };
#endif

const ClassInfo JSWebKitAnimationEventPrototype::s_info = { "WebKitAnimationEventPrototype", 0, &JSWebKitAnimationEventPrototypeTable, 0 };

JSObject* JSWebKitAnimationEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitAnimationEvent>(exec, globalObject);
}

bool JSWebKitAnimationEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitAnimationEventPrototypeTable, this, propertyName, slot);
}

bool JSWebKitAnimationEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebKitAnimationEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSWebKitAnimationEvent::s_info = { "WebKitAnimationEvent", &JSEvent::s_info, &JSWebKitAnimationEventTable, 0 };

JSWebKitAnimationEvent::JSWebKitAnimationEvent(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitAnimationEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

JSObject* JSWebKitAnimationEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSWebKitAnimationEventPrototype(JSWebKitAnimationEventPrototype::createStructure(JSEventPrototype::self(exec, globalObject)));
}

bool JSWebKitAnimationEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationEvent, Base>(exec, &JSWebKitAnimationEventTable, this, propertyName, slot);
}

bool JSWebKitAnimationEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitAnimationEvent, Base>(exec, &JSWebKitAnimationEventTable, this, propertyName, descriptor);
}

JSValue jsWebKitAnimationEventAnimationName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebKitAnimationEvent* castedThis = static_cast<JSWebKitAnimationEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(castedThis->impl());
    return jsString(exec, imp->animationName());
}

JSValue jsWebKitAnimationEventElapsedTime(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebKitAnimationEvent* castedThis = static_cast<JSWebKitAnimationEvent*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(castedThis->impl());
    return jsNumber(exec, imp->elapsedTime());
}

JSValue jsWebKitAnimationEventConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSWebKitAnimationEvent* domObject = static_cast<JSWebKitAnimationEvent*>(asObject(slot.slotBase()));
    return JSWebKitAnimationEvent::getConstructor(exec, domObject->globalObject());
}
JSValue JSWebKitAnimationEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitAnimationEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsWebKitAnimationEventPrototypeFunctionInitWebKitAnimationEvent(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSWebKitAnimationEvent::s_info))
        return throwError(exec, TypeError);
    JSWebKitAnimationEvent* castedThisObj = static_cast<JSWebKitAnimationEvent*>(asObject(thisValue));
    WebKitAnimationEvent* imp = static_cast<WebKitAnimationEvent*>(castedThisObj->impl());
    const UString& typeArg = args.at(0).toString(exec);
    bool canBubbleArg = args.at(1).toBoolean(exec);
    bool cancelableArg = args.at(2).toBoolean(exec);
    const UString& animationNameArg = args.at(3).toString(exec);
    double elapsedTimeArg = args.at(4).toNumber(exec);

    imp->initWebKitAnimationEvent(typeArg, canBubbleArg, cancelableArg, animationNameArg, elapsedTimeArg);
    return jsUndefined();
}


}
