/***************************************************************************
                          qcupsconfigdialog.cpp  -  description
                             -------------------
    begin                : Mon Jan 22 2001
    copyright            : (C) 2001 by Michael Goffioul
    email                : goffioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "qcupsconfigdialog.h"

#include <qlineedit.h>
#include <qcheckbox.h>

QCupsConfigDialog::QCupsConfigDialog(QWidget *parent, const char *name)
: QCupsConfigDialogBase(parent,name,true)
{
}

QCupsConfigDialog::~QCupsConfigDialog()
{
}

const char* QCupsConfigDialog::login()
{
	if (anonymous_->isChecked()) return "";
	else return (const char*)(login_->text());
}

const char* QCupsConfigDialog::password()
{
	if (anonymous_->isChecked()) return "";
	else return (const char*)(password_->text());
}

const char* QCupsConfigDialog::server()
{
	return (const char*)(server_->text());
}

int QCupsConfigDialog::port()
{
	bool	ok;
	int	p = port_->text().toInt(&ok);
	if (ok) return p;
	else return (-1);
}

void QCupsConfigDialog::setServerInfo(const QString& server, int port)
{
	server_->setText(server);
	port_->setText(QString::number(port));
}

void QCupsConfigDialog::setLoginInfo(const QString& login, const QString& passwd)
{
	if (login.isEmpty())
	{
		anonymous_->setChecked(true);
		login_->setText("");
		password_->setText("");
	}
	else
	{
		anonymous_->setChecked(false);
		login_->setText(login);
		password_->setText(passwd);
	}
}
