from qt import *
from torrentwidget import TorrentWidget

class TorrentWin(TorrentWidget):
	def __init__(self, parent):
		self.current = ""
		self.label = "Stop"
		TorrentWidget.__init__(self, parent)
		self.connect(self.listButton, SIGNAL('clicked()'), PYSIGNAL('showList'))
		self.connect(self.stopButton, SIGNAL('clicked()'), self.stopStart)
		self.connect(self.removeButton, SIGNAL('clicked()'), self.remove)
		self.connect(self.leftButton, SIGNAL('clicked()'), self.next)
		self.connect(self.rightButton, SIGNAL('clicked()'), self.prev)
	
	def stopStart(self):
		self.emit(PYSIGNAL('stopTorrent'), (self.current,))
	
	def remove(self):
		self.emit(PYSIGNAL('removeTorrent'), (self.current,))
	
	def next(self):
		self.emit(PYSIGNAL('nextTorrent'), (self.current,))
	
	def prev(self):
		self.emit(PYSIGNAL('prevTorrent'), (self.current,))
	
	def stats(self, stats):
		self.fileName.setText(stats[0])
		self.fileSize.setText("%.1f MB / %.1f MB (%i of %i pieces)" % (stats[1] * stats[3] / 1048576.0, stats[1] / 1048576.0, stats[15], stats[14]))
		if stats[2] == 'downloading':
			def fmttime(s):
				days = int(s / 86400)
				s = s % 86400
				hours = int(s / 3600)
				s = s % 3600
				minutes = int(s / 60)
				s = s % 60
				return '%id%ih%im%is' % (days, hours, minutes, s)
			if stats[4] < 0:
				self.status.setText('unknown')
			else:
				self.status.setText('still remaining: ' + fmttime(stats[4]))
		else:
			self.status.setText(stats[2])
		self.downspeed.setText('%.1f KB/s' % (stats[5] / 1024.0))
		self.upspeed.setText('%.1f KB/s' % (stats[6] / 1024.0))
		self.topDownspeed.setText('(%.1f KB/s)' % (stats[7] / 1024.0))
		self.topUpspeed.setText('(%.1f KB/s)' % (stats[8] / 1024.0))
		if stats[7]:
			self.downspeedRatio.setProgress(int((stats[5] * 100) / stats[7]))
		else:
			self.downspeedRatio.setProgress(100)
		if stats[8]:
			self.upspeedRatio.setProgress(int((stats[6] * 100) / stats[8]))
		else:
			self.upspeedRatio.setProgress(100)
		
		self.downAmount.setText('%.1f MB' % (stats[9] / 1048576.0))
		self.upAmount.setText('%.1f MB' % (stats[10] / 1048576.0))
		if stats[9] == 0:
			self.shareRatio.setText('infinite')
		else:
			self.shareRatio.setText('%.3f' % (float(stats[10]) / float(stats[9])))
		self.numSeeds.setText(str(stats[11]))
		self.numPeers.setText(str(stats[12]))
		self.distCopies.setText('(+%.1f copies)' % stats[13])
		self.peerStats.setText('')
		if stats[2] == 'stopped':
			label = 'Start'
		else:
			label = 'Stop'
		
		if label != self.label:
			self.label = label
			self.stopButton.setText(label)
