// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2018 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_1_0_autogen.cpp:
//   Defines the GLES 1.0 entry points.

#include "libGLESv2/entry_points_gles_1_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/validationES1.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY ActiveTexture(GLenum texture)
{
    EVENT("(GLenum texture = 0x%X)", texture);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ActiveTexture>(texture);

        if (context->skipValidation() || ValidateActiveTexture(context, texture))
        {
            context->activeTexture(texture);
        }
    }
}

void GL_APIENTRY AlphaFunc(GLenum func, GLfloat ref)
{
    EVENT("(GLenum func = 0x%X, GLfloat ref = %f)", func, ref);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::AlphaFunc>(func, ref);

        if (context->skipValidation() || ValidateAlphaFunc(context, func, ref))
        {
            context->alphaFunc(func, ref);
        }
    }
}

void GL_APIENTRY AlphaFuncx(GLenum func, GLfixed ref)
{
    EVENT("(GLenum func = 0x%X, GLfixed ref = 0x%X)", func, ref);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::AlphaFuncx>(func, ref);

        if (context->skipValidation() || ValidateAlphaFuncx(context, func, ref))
        {
            context->alphaFuncx(func, ref);
        }
    }
}

void GL_APIENTRY BindBuffer(GLenum target, GLuint buffer)
{
    EVENT("(GLenum target = 0x%X, GLuint buffer = %u)", target, buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        context->gatherParams<EntryPoint::BindBuffer>(targetPacked, buffer);

        if (context->skipValidation() || ValidateBindBuffer(context, targetPacked, buffer))
        {
            context->bindBuffer(targetPacked, buffer);
        }
    }
}

void GL_APIENTRY BindTexture(GLenum target, GLuint texture)
{
    EVENT("(GLenum target = 0x%X, GLuint texture = %u)", target, texture);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BindTexture>(target, texture);

        if (context->skipValidation() || ValidateBindTexture(context, target, texture))
        {
            context->bindTexture(target, texture);
        }
    }
}

void GL_APIENTRY BlendFunc(GLenum sfactor, GLenum dfactor)
{
    EVENT("(GLenum sfactor = 0x%X, GLenum dfactor = 0x%X)", sfactor, dfactor);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::BlendFunc>(sfactor, dfactor);

        if (context->skipValidation() || ValidateBlendFunc(context, sfactor, dfactor))
        {
            context->blendFunc(sfactor, dfactor);
        }
    }
}

void GL_APIENTRY BufferData(GLenum target, GLsizeiptr size, const void *data, GLenum usage)
{
    EVENT(
        "(GLenum target = 0x%X, GLsizeiptr size = %d, const void *data = 0x%0.8p, GLenum usage = "
        "0x%X)",
        target, size, data, usage);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        BufferUsage usagePacked    = FromGLenum<BufferUsage>(usage);
        context->gatherParams<EntryPoint::BufferData>(targetPacked, size, data, usagePacked);

        if (context->skipValidation() ||
            ValidateBufferData(context, targetPacked, size, data, usagePacked))
        {
            context->bufferData(targetPacked, size, data, usagePacked);
        }
    }
}

void GL_APIENTRY BufferSubData(GLenum target, GLintptr offset, GLsizeiptr size, const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLintptr offset = %d, GLsizeiptr size = %d, const void *data = "
        "0x%0.8p)",
        target, offset, size, data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        context->gatherParams<EntryPoint::BufferSubData>(targetPacked, offset, size, data);

        if (context->skipValidation() ||
            ValidateBufferSubData(context, targetPacked, offset, size, data))
        {
            context->bufferSubData(targetPacked, offset, size, data);
        }
    }
}

void GL_APIENTRY Clear(GLbitfield mask)
{
    EVENT("(GLbitfield mask = 0x%X)", mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Clear>(mask);

        if (context->skipValidation() || ValidateClear(context, mask))
        {
            context->clear(mask);
        }
    }
}

void GL_APIENTRY ClearColor(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ClearColor>(red, green, blue, alpha);

        if (context->skipValidation() || ValidateClearColor(context, red, green, blue, alpha))
        {
            context->clearColor(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ClearColorx(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    EVENT("(GLfixed red = 0x%X, GLfixed green = 0x%X, GLfixed blue = 0x%X, GLfixed alpha = 0x%X)",
          red, green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ClearColorx>(red, green, blue, alpha);

        if (context->skipValidation() || ValidateClearColorx(context, red, green, blue, alpha))
        {
            context->clearColorx(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ClearDepthf(GLfloat d)
{
    EVENT("(GLfloat d = %f)", d);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ClearDepthf>(d);

        if (context->skipValidation() || ValidateClearDepthf(context, d))
        {
            context->clearDepthf(d);
        }
    }
}

void GL_APIENTRY ClearDepthx(GLfixed depth)
{
    EVENT("(GLfixed depth = 0x%X)", depth);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ClearDepthx>(depth);

        if (context->skipValidation() || ValidateClearDepthx(context, depth))
        {
            context->clearDepthx(depth);
        }
    }
}

void GL_APIENTRY ClearStencil(GLint s)
{
    EVENT("(GLint s = %d)", s);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ClearStencil>(s);

        if (context->skipValidation() || ValidateClearStencil(context, s))
        {
            context->clearStencil(s);
        }
    }
}

void GL_APIENTRY ClientActiveTexture(GLenum texture)
{
    EVENT("(GLenum texture = 0x%X)", texture);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ClientActiveTexture>(texture);

        if (context->skipValidation() || ValidateClientActiveTexture(context, texture))
        {
            context->clientActiveTexture(texture);
        }
    }
}

void GL_APIENTRY ClipPlanef(GLenum p, const GLfloat *eqn)
{
    EVENT("(GLenum p = 0x%X, const GLfloat *eqn = 0x%0.8p)", p, eqn);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ClipPlanef>(p, eqn);

        if (context->skipValidation() || ValidateClipPlanef(context, p, eqn))
        {
            context->clipPlanef(p, eqn);
        }
    }
}

void GL_APIENTRY ClipPlanex(GLenum plane, const GLfixed *equation)
{
    EVENT("(GLenum plane = 0x%X, const GLfixed *equation = 0x%0.8p)", plane, equation);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ClipPlanex>(plane, equation);

        if (context->skipValidation() || ValidateClipPlanex(context, plane, equation))
        {
            context->clipPlanex(plane, equation);
        }
    }
}

void GL_APIENTRY Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Color4f>(red, green, blue, alpha);

        if (context->skipValidation() || ValidateColor4f(context, red, green, blue, alpha))
        {
            context->color4f(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    EVENT("(GLubyte red = %d, GLubyte green = %d, GLubyte blue = %d, GLubyte alpha = %d)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Color4ub>(red, green, blue, alpha);

        if (context->skipValidation() || ValidateColor4ub(context, red, green, blue, alpha))
        {
            context->color4ub(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    EVENT("(GLfixed red = 0x%X, GLfixed green = 0x%X, GLfixed blue = 0x%X, GLfixed alpha = 0x%X)",
          red, green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Color4x>(red, green, blue, alpha);

        if (context->skipValidation() || ValidateColor4x(context, red, green, blue, alpha))
        {
            context->color4x(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ColorMask(GLboolean red, GLboolean green, GLboolean blue, GLboolean alpha)
{
    EVENT("(GLboolean red = %u, GLboolean green = %u, GLboolean blue = %u, GLboolean alpha = %u)",
          red, green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ColorMask>(red, green, blue, alpha);

        if (context->skipValidation() || ValidateColorMask(context, red, green, blue, alpha))
        {
            context->colorMask(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ColorPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%0.8p)",
        size, type, stride, pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ColorPointer>(size, type, stride, pointer);

        if (context->skipValidation() || ValidateColorPointer(context, size, type, stride, pointer))
        {
            context->colorPointer(size, type, stride, pointer);
        }
    }
}

void GL_APIENTRY CompressedTexImage2D(GLenum target,
                                      GLint level,
                                      GLenum internalformat,
                                      GLsizei width,
                                      GLsizei height,
                                      GLint border,
                                      GLsizei imageSize,
                                      const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLsizei width = "
        "%d, GLsizei height = %d, GLint border = %d, GLsizei imageSize = %d, const void *data = "
        "0x%0.8p)",
        target, level, internalformat, width, height, border, imageSize, data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::CompressedTexImage2D>(
            target, level, internalformat, width, height, border, imageSize, data);

        if (context->skipValidation() ||
            ValidateCompressedTexImage2D(context, target, level, internalformat, width, height,
                                         border, imageSize, data))
        {
            context->compressedTexImage2D(target, level, internalformat, width, height, border,
                                          imageSize, data);
        }
    }
}

void GL_APIENTRY CompressedTexSubImage2D(GLenum target,
                                         GLint level,
                                         GLint xoffset,
                                         GLint yoffset,
                                         GLsizei width,
                                         GLsizei height,
                                         GLenum format,
                                         GLsizei imageSize,
                                         const void *data)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLsizei "
        "width = %d, GLsizei height = %d, GLenum format = 0x%X, GLsizei imageSize = %d, const void "
        "*data = 0x%0.8p)",
        target, level, xoffset, yoffset, width, height, format, imageSize, data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::CompressedTexSubImage2D>(
            target, level, xoffset, yoffset, width, height, format, imageSize, data);

        if (context->skipValidation() ||
            ValidateCompressedTexSubImage2D(context, target, level, xoffset, yoffset, width, height,
                                            format, imageSize, data))
        {
            context->compressedTexSubImage2D(target, level, xoffset, yoffset, width, height, format,
                                             imageSize, data);
        }
    }
}

void GL_APIENTRY CopyTexImage2D(GLenum target,
                                GLint level,
                                GLenum internalformat,
                                GLint x,
                                GLint y,
                                GLsizei width,
                                GLsizei height,
                                GLint border)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLenum internalformat = 0x%X, GLint x = %d, "
        "GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLint border = %d)",
        target, level, internalformat, x, y, width, height, border);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::CopyTexImage2D>(target, level, internalformat, x, y,
                                                          width, height, border);

        if (context->skipValidation() ||
            ValidateCopyTexImage2D(context, target, level, internalformat, x, y, width, height,
                                   border))
        {
            context->copyTexImage2D(target, level, internalformat, x, y, width, height, border);
        }
    }
}

void GL_APIENTRY CopyTexSubImage2D(GLenum target,
                                   GLint level,
                                   GLint xoffset,
                                   GLint yoffset,
                                   GLint x,
                                   GLint y,
                                   GLsizei width,
                                   GLsizei height)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLint x "
        "= %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)",
        target, level, xoffset, yoffset, x, y, width, height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::CopyTexSubImage2D>(target, level, xoffset, yoffset, x, y,
                                                             width, height);

        if (context->skipValidation() || ValidateCopyTexSubImage2D(context, target, level, xoffset,
                                                                   yoffset, x, y, width, height))
        {
            context->copyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
        }
    }
}

void GL_APIENTRY CullFace(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        CullFaceMode modePacked = FromGLenum<CullFaceMode>(mode);
        context->gatherParams<EntryPoint::CullFace>(modePacked);

        if (context->skipValidation() || ValidateCullFace(context, modePacked))
        {
            context->cullFace(modePacked);
        }
    }
}

void GL_APIENTRY DeleteBuffers(GLsizei n, const GLuint *buffers)
{
    EVENT("(GLsizei n = %d, const GLuint *buffers = 0x%0.8p)", n, buffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteBuffers>(n, buffers);

        if (context->skipValidation() || ValidateDeleteBuffers(context, n, buffers))
        {
            context->deleteBuffers(n, buffers);
        }
    }
}

void GL_APIENTRY DeleteTextures(GLsizei n, const GLuint *textures)
{
    EVENT("(GLsizei n = %d, const GLuint *textures = 0x%0.8p)", n, textures);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DeleteTextures>(n, textures);

        if (context->skipValidation() || ValidateDeleteTextures(context, n, textures))
        {
            context->deleteTextures(n, textures);
        }
    }
}

void GL_APIENTRY DepthFunc(GLenum func)
{
    EVENT("(GLenum func = 0x%X)", func);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DepthFunc>(func);

        if (context->skipValidation() || ValidateDepthFunc(context, func))
        {
            context->depthFunc(func);
        }
    }
}

void GL_APIENTRY DepthMask(GLboolean flag)
{
    EVENT("(GLboolean flag = %u)", flag);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DepthMask>(flag);

        if (context->skipValidation() || ValidateDepthMask(context, flag))
        {
            context->depthMask(flag);
        }
    }
}

void GL_APIENTRY DepthRangef(GLfloat n, GLfloat f)
{
    EVENT("(GLfloat n = %f, GLfloat f = %f)", n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DepthRangef>(n, f);

        if (context->skipValidation() || ValidateDepthRangef(context, n, f))
        {
            context->depthRangef(n, f);
        }
    }
}

void GL_APIENTRY DepthRangex(GLfixed n, GLfixed f)
{
    EVENT("(GLfixed n = 0x%X, GLfixed f = 0x%X)", n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DepthRangex>(n, f);

        if (context->skipValidation() || ValidateDepthRangex(context, n, f))
        {
            context->depthRangex(n, f);
        }
    }
}

void GL_APIENTRY Disable(GLenum cap)
{
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Disable>(cap);

        if (context->skipValidation() || ValidateDisable(context, cap))
        {
            context->disable(cap);
        }
    }
}

void GL_APIENTRY DisableClientState(GLenum array)
{
    EVENT("(GLenum array = 0x%X)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DisableClientState>(array);

        if (context->skipValidation() || ValidateDisableClientState(context, array))
        {
            context->disableClientState(array);
        }
    }
}

void GL_APIENTRY DrawArrays(GLenum mode, GLint first, GLsizei count)
{
    EVENT("(GLenum mode = 0x%X, GLint first = %d, GLsizei count = %d)", mode, first, count);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawArrays>(mode, first, count);

        if (context->skipValidation() || ValidateDrawArrays(context, mode, first, count))
        {
            context->drawArrays(mode, first, count);
        }
    }
}

void GL_APIENTRY DrawElements(GLenum mode, GLsizei count, GLenum type, const void *indices)
{
    EVENT(
        "(GLenum mode = 0x%X, GLsizei count = %d, GLenum type = 0x%X, const void *indices = "
        "0x%0.8p)",
        mode, count, type, indices);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::DrawElements>(mode, count, type, indices);

        if (context->skipValidation() || ValidateDrawElements(context, mode, count, type, indices))
        {
            context->drawElements(mode, count, type, indices);
        }
    }
}

void GL_APIENTRY Enable(GLenum cap)
{
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Enable>(cap);

        if (context->skipValidation() || ValidateEnable(context, cap))
        {
            context->enable(cap);
        }
    }
}

void GL_APIENTRY EnableClientState(GLenum array)
{
    EVENT("(GLenum array = 0x%X)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::EnableClientState>(array);

        if (context->skipValidation() || ValidateEnableClientState(context, array))
        {
            context->enableClientState(array);
        }
    }
}

void GL_APIENTRY Finish()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Finish>();

        if (context->skipValidation() || ValidateFinish(context))
        {
            context->finish();
        }
    }
}

void GL_APIENTRY Flush()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Flush>();

        if (context->skipValidation() || ValidateFlush(context))
        {
            context->flush();
        }
    }
}

void GL_APIENTRY Fogf(GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Fogf>(pname, param);

        if (context->skipValidation() || ValidateFogf(context, pname, param))
        {
            context->fogf(pname, param);
        }
    }
}

void GL_APIENTRY Fogfv(GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%0.8p)", pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Fogfv>(pname, params);

        if (context->skipValidation() || ValidateFogfv(context, pname, params))
        {
            context->fogfv(pname, params);
        }
    }
}

void GL_APIENTRY Fogx(GLenum pname, GLfixed param)
{
    EVENT("(GLenum pname = 0x%X, GLfixed param = 0x%X)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Fogx>(pname, param);

        if (context->skipValidation() || ValidateFogx(context, pname, param))
        {
            context->fogx(pname, param);
        }
    }
}

void GL_APIENTRY Fogxv(GLenum pname, const GLfixed *param)
{
    EVENT("(GLenum pname = 0x%X, const GLfixed *param = 0x%0.8p)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Fogxv>(pname, param);

        if (context->skipValidation() || ValidateFogxv(context, pname, param))
        {
            context->fogxv(pname, param);
        }
    }
}

void GL_APIENTRY FrontFace(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::FrontFace>(mode);

        if (context->skipValidation() || ValidateFrontFace(context, mode))
        {
            context->frontFace(mode);
        }
    }
}

void GL_APIENTRY Frustumf(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    EVENT(
        "(GLfloat l = %f, GLfloat r = %f, GLfloat b = %f, GLfloat t = %f, GLfloat n = %f, GLfloat "
        "f = %f)",
        l, r, b, t, n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Frustumf>(l, r, b, t, n, f);

        if (context->skipValidation() || ValidateFrustumf(context, l, r, b, t, n, f))
        {
            context->frustumf(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY Frustumx(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    EVENT(
        "(GLfixed l = 0x%X, GLfixed r = 0x%X, GLfixed b = 0x%X, GLfixed t = 0x%X, GLfixed n = "
        "0x%X, GLfixed f = 0x%X)",
        l, r, b, t, n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Frustumx>(l, r, b, t, n, f);

        if (context->skipValidation() || ValidateFrustumx(context, l, r, b, t, n, f))
        {
            context->frustumx(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY GenBuffers(GLsizei n, GLuint *buffers)
{
    EVENT("(GLsizei n = %d, GLuint *buffers = 0x%0.8p)", n, buffers);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GenBuffers>(n, buffers);

        if (context->skipValidation() || ValidateGenBuffers(context, n, buffers))
        {
            context->genBuffers(n, buffers);
        }
    }
}

void GL_APIENTRY GenTextures(GLsizei n, GLuint *textures)
{
    EVENT("(GLsizei n = %d, GLuint *textures = 0x%0.8p)", n, textures);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GenTextures>(n, textures);

        if (context->skipValidation() || ValidateGenTextures(context, n, textures))
        {
            context->genTextures(n, textures);
        }
    }
}

void GL_APIENTRY GetBooleanv(GLenum pname, GLboolean *data)
{
    EVENT("(GLenum pname = 0x%X, GLboolean *data = 0x%0.8p)", pname, data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetBooleanv>(pname, data);

        if (context->skipValidation() || ValidateGetBooleanv(context, pname, data))
        {
            context->getBooleanv(pname, data);
        }
    }
}

void GL_APIENTRY GetBufferParameteriv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        BufferBinding targetPacked = FromGLenum<BufferBinding>(target);
        context->gatherParams<EntryPoint::GetBufferParameteriv>(targetPacked, pname, params);

        if (context->skipValidation() ||
            ValidateGetBufferParameteriv(context, targetPacked, pname, params))
        {
            context->getBufferParameteriv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY GetClipPlanef(GLenum plane, GLfloat *equation)
{
    EVENT("(GLenum plane = 0x%X, GLfloat *equation = 0x%0.8p)", plane, equation);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetClipPlanef>(plane, equation);

        if (context->skipValidation() || ValidateGetClipPlanef(context, plane, equation))
        {
            context->getClipPlanef(plane, equation);
        }
    }
}

void GL_APIENTRY GetClipPlanex(GLenum plane, GLfixed *equation)
{
    EVENT("(GLenum plane = 0x%X, GLfixed *equation = 0x%0.8p)", plane, equation);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetClipPlanex>(plane, equation);

        if (context->skipValidation() || ValidateGetClipPlanex(context, plane, equation))
        {
            context->getClipPlanex(plane, equation);
        }
    }
}

GLenum GL_APIENTRY GetError()
{
    EVENT("()");

    Context *context = GetGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetError>();

        if (context->skipValidation() || ValidateGetError(context))
        {
            return context->getError();
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetError, GLenum>();
}

void GL_APIENTRY GetFixedv(GLenum pname, GLfixed *params)
{
    EVENT("(GLenum pname = 0x%X, GLfixed *params = 0x%0.8p)", pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetFixedv>(pname, params);

        if (context->skipValidation() || ValidateGetFixedv(context, pname, params))
        {
            context->getFixedv(pname, params);
        }
    }
}

void GL_APIENTRY GetFloatv(GLenum pname, GLfloat *data)
{
    EVENT("(GLenum pname = 0x%X, GLfloat *data = 0x%0.8p)", pname, data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetFloatv>(pname, data);

        if (context->skipValidation() || ValidateGetFloatv(context, pname, data))
        {
            context->getFloatv(pname, data);
        }
    }
}

void GL_APIENTRY GetIntegerv(GLenum pname, GLint *data)
{
    EVENT("(GLenum pname = 0x%X, GLint *data = 0x%0.8p)", pname, data);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetIntegerv>(pname, data);

        if (context->skipValidation() || ValidateGetIntegerv(context, pname, data))
        {
            context->getIntegerv(pname, data);
        }
    }
}

void GL_APIENTRY GetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%0.8p)", light, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetLightfv>(light, pname, params);

        if (context->skipValidation() || ValidateGetLightfv(context, light, pname, params))
        {
            context->getLightfv(light, pname, params);
        }
    }
}

void GL_APIENTRY GetLightxv(GLenum light, GLenum pname, GLfixed *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%0.8p)", light, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetLightxv>(light, pname, params);

        if (context->skipValidation() || ValidateGetLightxv(context, light, pname, params))
        {
            context->getLightxv(light, pname, params);
        }
    }
}

void GL_APIENTRY GetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%0.8p)", face, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetMaterialfv>(face, pname, params);

        if (context->skipValidation() || ValidateGetMaterialfv(context, face, pname, params))
        {
            context->getMaterialfv(face, pname, params);
        }
    }
}

void GL_APIENTRY GetMaterialxv(GLenum face, GLenum pname, GLfixed *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%0.8p)", face, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetMaterialxv>(face, pname, params);

        if (context->skipValidation() || ValidateGetMaterialxv(context, face, pname, params))
        {
            context->getMaterialxv(face, pname, params);
        }
    }
}

void GL_APIENTRY GetPointerv(GLenum pname, void **params)
{
    EVENT("(GLenum pname = 0x%X, void **params = 0x%0.8p)", pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetPointerv>(pname, params);

        if (context->skipValidation() || ValidateGetPointerv(context, pname, params))
        {
            context->getPointerv(pname, params);
        }
    }
}

const GLubyte *GL_APIENTRY GetString(GLenum name)
{
    EVENT("(GLenum name = 0x%X)", name);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetString>(name);

        if (context->skipValidation() || ValidateGetString(context, name))
        {
            return context->getString(name);
        }
    }

    return GetDefaultReturnValue<EntryPoint::GetString, const GLubyte *>();
}

void GL_APIENTRY GetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetTexEnvfv>(target, pname, params);

        if (context->skipValidation() || ValidateGetTexEnvfv(context, target, pname, params))
        {
            context->getTexEnvfv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetTexEnviv>(target, pname, params);

        if (context->skipValidation() || ValidateGetTexEnviv(context, target, pname, params))
        {
            context->getTexEnviv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetTexEnvxv(GLenum target, GLenum pname, GLfixed *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetTexEnvxv>(target, pname, params);

        if (context->skipValidation() || ValidateGetTexEnvxv(context, target, pname, params))
        {
            context->getTexEnvxv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterfv(GLenum target, GLenum pname, GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetTexParameterfv>(target, pname, params);

        if (context->skipValidation() || ValidateGetTexParameterfv(context, target, pname, params))
        {
            context->getTexParameterfv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameteriv(GLenum target, GLenum pname, GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetTexParameteriv>(target, pname, params);

        if (context->skipValidation() || ValidateGetTexParameteriv(context, target, pname, params))
        {
            context->getTexParameteriv(target, pname, params);
        }
    }
}

void GL_APIENTRY GetTexParameterxv(GLenum target, GLenum pname, GLfixed *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%0.8p)", target, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::GetTexParameterxv>(target, pname, params);

        if (context->skipValidation() || ValidateGetTexParameterxv(context, target, pname, params))
        {
            context->getTexParameterxv(target, pname, params);
        }
    }
}

void GL_APIENTRY Hint(GLenum target, GLenum mode)
{
    EVENT("(GLenum target = 0x%X, GLenum mode = 0x%X)", target, mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Hint>(target, mode);

        if (context->skipValidation() || ValidateHint(context, target, mode))
        {
            context->hint(target, mode);
        }
    }
}

GLboolean GL_APIENTRY IsBuffer(GLuint buffer)
{
    EVENT("(GLuint buffer = %u)", buffer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsBuffer>(buffer);

        if (context->skipValidation() || ValidateIsBuffer(context, buffer))
        {
            return context->isBuffer(buffer);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsBuffer, GLboolean>();
}

GLboolean GL_APIENTRY IsEnabled(GLenum cap)
{
    EVENT("(GLenum cap = 0x%X)", cap);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsEnabled>(cap);

        if (context->skipValidation() || ValidateIsEnabled(context, cap))
        {
            return context->isEnabled(cap);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsEnabled, GLboolean>();
}

GLboolean GL_APIENTRY IsTexture(GLuint texture)
{
    EVENT("(GLuint texture = %u)", texture);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::IsTexture>(texture);

        if (context->skipValidation() || ValidateIsTexture(context, texture))
        {
            return context->isTexture(texture);
        }
    }

    return GetDefaultReturnValue<EntryPoint::IsTexture, GLboolean>();
}

void GL_APIENTRY LightModelf(GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LightModelf>(pname, param);

        if (context->skipValidation() || ValidateLightModelf(context, pname, param))
        {
            context->lightModelf(pname, param);
        }
    }
}

void GL_APIENTRY LightModelfv(GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%0.8p)", pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LightModelfv>(pname, params);

        if (context->skipValidation() || ValidateLightModelfv(context, pname, params))
        {
            context->lightModelfv(pname, params);
        }
    }
}

void GL_APIENTRY LightModelx(GLenum pname, GLfixed param)
{
    EVENT("(GLenum pname = 0x%X, GLfixed param = 0x%X)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LightModelx>(pname, param);

        if (context->skipValidation() || ValidateLightModelx(context, pname, param))
        {
            context->lightModelx(pname, param);
        }
    }
}

void GL_APIENTRY LightModelxv(GLenum pname, const GLfixed *param)
{
    EVENT("(GLenum pname = 0x%X, const GLfixed *param = 0x%0.8p)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LightModelxv>(pname, param);

        if (context->skipValidation() || ValidateLightModelxv(context, pname, param))
        {
            context->lightModelxv(pname, param);
        }
    }
}

void GL_APIENTRY Lightf(GLenum light, GLenum pname, GLfloat param)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", light, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Lightf>(light, pname, param);

        if (context->skipValidation() || ValidateLightf(context, light, pname, param))
        {
            context->lightf(light, pname, param);
        }
    }
}

void GL_APIENTRY Lightfv(GLenum light, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%0.8p)", light,
          pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Lightfv>(light, pname, params);

        if (context->skipValidation() || ValidateLightfv(context, light, pname, params))
        {
            context->lightfv(light, pname, params);
        }
    }
}

void GL_APIENTRY Lightx(GLenum light, GLenum pname, GLfixed param)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", light, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Lightx>(light, pname, param);

        if (context->skipValidation() || ValidateLightx(context, light, pname, param))
        {
            context->lightx(light, pname, param);
        }
    }
}

void GL_APIENTRY Lightxv(GLenum light, GLenum pname, const GLfixed *params)
{
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%0.8p)", light,
          pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Lightxv>(light, pname, params);

        if (context->skipValidation() || ValidateLightxv(context, light, pname, params))
        {
            context->lightxv(light, pname, params);
        }
    }
}

void GL_APIENTRY LineWidth(GLfloat width)
{
    EVENT("(GLfloat width = %f)", width);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LineWidth>(width);

        if (context->skipValidation() || ValidateLineWidth(context, width))
        {
            context->lineWidth(width);
        }
    }
}

void GL_APIENTRY LineWidthx(GLfixed width)
{
    EVENT("(GLfixed width = 0x%X)", width);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LineWidthx>(width);

        if (context->skipValidation() || ValidateLineWidthx(context, width))
        {
            context->lineWidthx(width);
        }
    }
}

void GL_APIENTRY LoadIdentity()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LoadIdentity>();

        if (context->skipValidation() || ValidateLoadIdentity(context))
        {
            context->loadIdentity();
        }
    }
}

void GL_APIENTRY LoadMatrixf(const GLfloat *m)
{
    EVENT("(const GLfloat *m = 0x%0.8p)", m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LoadMatrixf>(m);

        if (context->skipValidation() || ValidateLoadMatrixf(context, m))
        {
            context->loadMatrixf(m);
        }
    }
}

void GL_APIENTRY LoadMatrixx(const GLfixed *m)
{
    EVENT("(const GLfixed *m = 0x%0.8p)", m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LoadMatrixx>(m);

        if (context->skipValidation() || ValidateLoadMatrixx(context, m))
        {
            context->loadMatrixx(m);
        }
    }
}

void GL_APIENTRY LogicOp(GLenum opcode)
{
    EVENT("(GLenum opcode = 0x%X)", opcode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::LogicOp>(opcode);

        if (context->skipValidation() || ValidateLogicOp(context, opcode))
        {
            context->logicOp(opcode);
        }
    }
}

void GL_APIENTRY Materialf(GLenum face, GLenum pname, GLfloat param)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", face, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Materialf>(face, pname, param);

        if (context->skipValidation() || ValidateMaterialf(context, face, pname, param))
        {
            context->materialf(face, pname, param);
        }
    }
}

void GL_APIENTRY Materialfv(GLenum face, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%0.8p)", face, pname,
          params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Materialfv>(face, pname, params);

        if (context->skipValidation() || ValidateMaterialfv(context, face, pname, params))
        {
            context->materialfv(face, pname, params);
        }
    }
}

void GL_APIENTRY Materialx(GLenum face, GLenum pname, GLfixed param)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", face, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Materialx>(face, pname, param);

        if (context->skipValidation() || ValidateMaterialx(context, face, pname, param))
        {
            context->materialx(face, pname, param);
        }
    }
}

void GL_APIENTRY Materialxv(GLenum face, GLenum pname, const GLfixed *param)
{
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, const GLfixed *param = 0x%0.8p)", face, pname,
          param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Materialxv>(face, pname, param);

        if (context->skipValidation() || ValidateMaterialxv(context, face, pname, param))
        {
            context->materialxv(face, pname, param);
        }
    }
}

void GL_APIENTRY MatrixMode(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::MatrixMode>(mode);

        if (context->skipValidation() || ValidateMatrixMode(context, mode))
        {
            context->matrixMode(mode);
        }
    }
}

void GL_APIENTRY MultMatrixf(const GLfloat *m)
{
    EVENT("(const GLfloat *m = 0x%0.8p)", m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::MultMatrixf>(m);

        if (context->skipValidation() || ValidateMultMatrixf(context, m))
        {
            context->multMatrixf(m);
        }
    }
}

void GL_APIENTRY MultMatrixx(const GLfixed *m)
{
    EVENT("(const GLfixed *m = 0x%0.8p)", m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::MultMatrixx>(m);

        if (context->skipValidation() || ValidateMultMatrixx(context, m))
        {
            context->multMatrixx(m);
        }
    }
}

void GL_APIENTRY MultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    EVENT("(GLenum target = 0x%X, GLfloat s = %f, GLfloat t = %f, GLfloat r = %f, GLfloat q = %f)",
          target, s, t, r, q);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::MultiTexCoord4f>(target, s, t, r, q);

        if (context->skipValidation() || ValidateMultiTexCoord4f(context, target, s, t, r, q))
        {
            context->multiTexCoord4f(target, s, t, r, q);
        }
    }
}

void GL_APIENTRY MultiTexCoord4x(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
    EVENT(
        "(GLenum texture = 0x%X, GLfixed s = 0x%X, GLfixed t = 0x%X, GLfixed r = 0x%X, GLfixed q = "
        "0x%X)",
        texture, s, t, r, q);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::MultiTexCoord4x>(texture, s, t, r, q);

        if (context->skipValidation() || ValidateMultiTexCoord4x(context, texture, s, t, r, q))
        {
            context->multiTexCoord4x(texture, s, t, r, q);
        }
    }
}

void GL_APIENTRY Normal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    EVENT("(GLfloat nx = %f, GLfloat ny = %f, GLfloat nz = %f)", nx, ny, nz);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Normal3f>(nx, ny, nz);

        if (context->skipValidation() || ValidateNormal3f(context, nx, ny, nz))
        {
            context->normal3f(nx, ny, nz);
        }
    }
}

void GL_APIENTRY Normal3x(GLfixed nx, GLfixed ny, GLfixed nz)
{
    EVENT("(GLfixed nx = 0x%X, GLfixed ny = 0x%X, GLfixed nz = 0x%X)", nx, ny, nz);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Normal3x>(nx, ny, nz);

        if (context->skipValidation() || ValidateNormal3x(context, nx, ny, nz))
        {
            context->normal3x(nx, ny, nz);
        }
    }
}

void GL_APIENTRY NormalPointer(GLenum type, GLsizei stride, const void *pointer)
{
    EVENT("(GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%0.8p)", type, stride,
          pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::NormalPointer>(type, stride, pointer);

        if (context->skipValidation() || ValidateNormalPointer(context, type, stride, pointer))
        {
            context->normalPointer(type, stride, pointer);
        }
    }
}

void GL_APIENTRY Orthof(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    EVENT(
        "(GLfloat l = %f, GLfloat r = %f, GLfloat b = %f, GLfloat t = %f, GLfloat n = %f, GLfloat "
        "f = %f)",
        l, r, b, t, n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Orthof>(l, r, b, t, n, f);

        if (context->skipValidation() || ValidateOrthof(context, l, r, b, t, n, f))
        {
            context->orthof(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY Orthox(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    EVENT(
        "(GLfixed l = 0x%X, GLfixed r = 0x%X, GLfixed b = 0x%X, GLfixed t = 0x%X, GLfixed n = "
        "0x%X, GLfixed f = 0x%X)",
        l, r, b, t, n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Orthox>(l, r, b, t, n, f);

        if (context->skipValidation() || ValidateOrthox(context, l, r, b, t, n, f))
        {
            context->orthox(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY PixelStorei(GLenum pname, GLint param)
{
    EVENT("(GLenum pname = 0x%X, GLint param = %d)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PixelStorei>(pname, param);

        if (context->skipValidation() || ValidatePixelStorei(context, pname, param))
        {
            context->pixelStorei(pname, param);
        }
    }
}

void GL_APIENTRY PointParameterf(GLenum pname, GLfloat param)
{
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PointParameterf>(pname, param);

        if (context->skipValidation() || ValidatePointParameterf(context, pname, param))
        {
            context->pointParameterf(pname, param);
        }
    }
}

void GL_APIENTRY PointParameterfv(GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%0.8p)", pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PointParameterfv>(pname, params);

        if (context->skipValidation() || ValidatePointParameterfv(context, pname, params))
        {
            context->pointParameterfv(pname, params);
        }
    }
}

void GL_APIENTRY PointParameterx(GLenum pname, GLfixed param)
{
    EVENT("(GLenum pname = 0x%X, GLfixed param = 0x%X)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PointParameterx>(pname, param);

        if (context->skipValidation() || ValidatePointParameterx(context, pname, param))
        {
            context->pointParameterx(pname, param);
        }
    }
}

void GL_APIENTRY PointParameterxv(GLenum pname, const GLfixed *params)
{
    EVENT("(GLenum pname = 0x%X, const GLfixed *params = 0x%0.8p)", pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PointParameterxv>(pname, params);

        if (context->skipValidation() || ValidatePointParameterxv(context, pname, params))
        {
            context->pointParameterxv(pname, params);
        }
    }
}

void GL_APIENTRY PointSize(GLfloat size)
{
    EVENT("(GLfloat size = %f)", size);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PointSize>(size);

        if (context->skipValidation() || ValidatePointSize(context, size))
        {
            context->pointSize(size);
        }
    }
}

void GL_APIENTRY PointSizex(GLfixed size)
{
    EVENT("(GLfixed size = 0x%X)", size);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PointSizex>(size);

        if (context->skipValidation() || ValidatePointSizex(context, size))
        {
            context->pointSizex(size);
        }
    }
}

void GL_APIENTRY PolygonOffset(GLfloat factor, GLfloat units)
{
    EVENT("(GLfloat factor = %f, GLfloat units = %f)", factor, units);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PolygonOffset>(factor, units);

        if (context->skipValidation() || ValidatePolygonOffset(context, factor, units))
        {
            context->polygonOffset(factor, units);
        }
    }
}

void GL_APIENTRY PolygonOffsetx(GLfixed factor, GLfixed units)
{
    EVENT("(GLfixed factor = 0x%X, GLfixed units = 0x%X)", factor, units);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PolygonOffsetx>(factor, units);

        if (context->skipValidation() || ValidatePolygonOffsetx(context, factor, units))
        {
            context->polygonOffsetx(factor, units);
        }
    }
}

void GL_APIENTRY PopMatrix()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PopMatrix>();

        if (context->skipValidation() || ValidatePopMatrix(context))
        {
            context->popMatrix();
        }
    }
}

void GL_APIENTRY PushMatrix()
{
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::PushMatrix>();

        if (context->skipValidation() || ValidatePushMatrix(context))
        {
            context->pushMatrix();
        }
    }
}

void GL_APIENTRY ReadPixels(GLint x,
                            GLint y,
                            GLsizei width,
                            GLsizei height,
                            GLenum format,
                            GLenum type,
                            void *pixels)
{
    EVENT(
        "(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d, GLenum format = "
        "0x%X, GLenum type = 0x%X, void *pixels = 0x%0.8p)",
        x, y, width, height, format, type, pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ReadPixels>(x, y, width, height, format, type, pixels);

        if (context->skipValidation() ||
            ValidateReadPixels(context, x, y, width, height, format, type, pixels))
        {
            context->readPixels(x, y, width, height, format, type, pixels);
        }
    }
}

void GL_APIENTRY Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat angle = %f, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", angle, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Rotatef>(angle, x, y, z);

        if (context->skipValidation() || ValidateRotatef(context, angle, x, y, z))
        {
            context->rotatef(angle, x, y, z);
        }
    }
}

void GL_APIENTRY Rotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    EVENT("(GLfixed angle = 0x%X, GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X)", angle, x,
          y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Rotatex>(angle, x, y, z);

        if (context->skipValidation() || ValidateRotatex(context, angle, x, y, z))
        {
            context->rotatex(angle, x, y, z);
        }
    }
}

void GL_APIENTRY SampleCoverage(GLfloat value, GLboolean invert)
{
    EVENT("(GLfloat value = %f, GLboolean invert = %u)", value, invert);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::SampleCoverage>(value, invert);

        if (context->skipValidation() || ValidateSampleCoverage(context, value, invert))
        {
            context->sampleCoverage(value, invert);
        }
    }
}

void GL_APIENTRY SampleCoveragex(GLclampx value, GLboolean invert)
{
    EVENT("(GLclampx value = 0x%X, GLboolean invert = %u)", value, invert);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::SampleCoveragex>(value, invert);

        if (context->skipValidation() || ValidateSampleCoveragex(context, value, invert))
        {
            context->sampleCoveragex(value, invert);
        }
    }
}

void GL_APIENTRY Scalef(GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Scalef>(x, y, z);

        if (context->skipValidation() || ValidateScalef(context, x, y, z))
        {
            context->scalef(x, y, z);
        }
    }
}

void GL_APIENTRY Scalex(GLfixed x, GLfixed y, GLfixed z)
{
    EVENT("(GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Scalex>(x, y, z);

        if (context->skipValidation() || ValidateScalex(context, x, y, z))
        {
            context->scalex(x, y, z);
        }
    }
}

void GL_APIENTRY Scissor(GLint x, GLint y, GLsizei width, GLsizei height)
{
    EVENT("(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)", x, y, width,
          height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Scissor>(x, y, width, height);

        if (context->skipValidation() || ValidateScissor(context, x, y, width, height))
        {
            context->scissor(x, y, width, height);
        }
    }
}

void GL_APIENTRY ShadeModel(GLenum mode)
{
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::ShadeModel>(mode);

        if (context->skipValidation() || ValidateShadeModel(context, mode))
        {
            context->shadeModel(mode);
        }
    }
}

void GL_APIENTRY StencilFunc(GLenum func, GLint ref, GLuint mask)
{
    EVENT("(GLenum func = 0x%X, GLint ref = %d, GLuint mask = %u)", func, ref, mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::StencilFunc>(func, ref, mask);

        if (context->skipValidation() || ValidateStencilFunc(context, func, ref, mask))
        {
            context->stencilFunc(func, ref, mask);
        }
    }
}

void GL_APIENTRY StencilMask(GLuint mask)
{
    EVENT("(GLuint mask = %u)", mask);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::StencilMask>(mask);

        if (context->skipValidation() || ValidateStencilMask(context, mask))
        {
            context->stencilMask(mask);
        }
    }
}

void GL_APIENTRY StencilOp(GLenum fail, GLenum zfail, GLenum zpass)
{
    EVENT("(GLenum fail = 0x%X, GLenum zfail = 0x%X, GLenum zpass = 0x%X)", fail, zfail, zpass);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::StencilOp>(fail, zfail, zpass);

        if (context->skipValidation() || ValidateStencilOp(context, fail, zfail, zpass))
        {
            context->stencilOp(fail, zfail, zpass);
        }
    }
}

void GL_APIENTRY TexCoordPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%0.8p)",
        size, type, stride, pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexCoordPointer>(size, type, stride, pointer);

        if (context->skipValidation() ||
            ValidateTexCoordPointer(context, size, type, stride, pointer))
        {
            context->texCoordPointer(size, type, stride, pointer);
        }
    }
}

void GL_APIENTRY TexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexEnvf>(target, pname, param);

        if (context->skipValidation() || ValidateTexEnvf(context, target, pname, param))
        {
            context->texEnvf(target, pname, param);
        }
    }
}

void GL_APIENTRY TexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%0.8p)", target,
          pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexEnvfv>(target, pname, params);

        if (context->skipValidation() || ValidateTexEnvfv(context, target, pname, params))
        {
            context->texEnvfv(target, pname, params);
        }
    }
}

void GL_APIENTRY TexEnvi(GLenum target, GLenum pname, GLint param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexEnvi>(target, pname, param);

        if (context->skipValidation() || ValidateTexEnvi(context, target, pname, param))
        {
            context->texEnvi(target, pname, param);
        }
    }
}

void GL_APIENTRY TexEnviv(GLenum target, GLenum pname, const GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%0.8p)", target,
          pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexEnviv>(target, pname, params);

        if (context->skipValidation() || ValidateTexEnviv(context, target, pname, params))
        {
            context->texEnviv(target, pname, params);
        }
    }
}

void GL_APIENTRY TexEnvx(GLenum target, GLenum pname, GLfixed param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", target, pname,
          param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexEnvx>(target, pname, param);

        if (context->skipValidation() || ValidateTexEnvx(context, target, pname, param))
        {
            context->texEnvx(target, pname, param);
        }
    }
}

void GL_APIENTRY TexEnvxv(GLenum target, GLenum pname, const GLfixed *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%0.8p)", target,
          pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexEnvxv>(target, pname, params);

        if (context->skipValidation() || ValidateTexEnvxv(context, target, pname, params))
        {
            context->texEnvxv(target, pname, params);
        }
    }
}

void GL_APIENTRY TexImage2D(GLenum target,
                            GLint level,
                            GLint internalformat,
                            GLsizei width,
                            GLsizei height,
                            GLint border,
                            GLenum format,
                            GLenum type,
                            const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint internalformat = %d, GLsizei width = %d, "
        "GLsizei height = %d, GLint border = %d, GLenum format = 0x%X, GLenum type = 0x%X, const "
        "void *pixels = 0x%0.8p)",
        target, level, internalformat, width, height, border, format, type, pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexImage2D>(target, level, internalformat, width, height,
                                                      border, format, type, pixels);

        if (context->skipValidation() ||
            ValidateTexImage2D(context, target, level, internalformat, width, height, border,
                               format, type, pixels))
        {
            context->texImage2D(target, level, internalformat, width, height, border, format, type,
                                pixels);
        }
    }
}

void GL_APIENTRY TexParameterf(GLenum target, GLenum pname, GLfloat param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexParameterf>(target, pname, param);

        if (context->skipValidation() || ValidateTexParameterf(context, target, pname, param))
        {
            context->texParameterf(target, pname, param);
        }
    }
}

void GL_APIENTRY TexParameterfv(GLenum target, GLenum pname, const GLfloat *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%0.8p)", target,
          pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexParameterfv>(target, pname, params);

        if (context->skipValidation() || ValidateTexParameterfv(context, target, pname, params))
        {
            context->texParameterfv(target, pname, params);
        }
    }
}

void GL_APIENTRY TexParameteri(GLenum target, GLenum pname, GLint param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexParameteri>(target, pname, param);

        if (context->skipValidation() || ValidateTexParameteri(context, target, pname, param))
        {
            context->texParameteri(target, pname, param);
        }
    }
}

void GL_APIENTRY TexParameteriv(GLenum target, GLenum pname, const GLint *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%0.8p)", target,
          pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexParameteriv>(target, pname, params);

        if (context->skipValidation() || ValidateTexParameteriv(context, target, pname, params))
        {
            context->texParameteriv(target, pname, params);
        }
    }
}

void GL_APIENTRY TexParameterx(GLenum target, GLenum pname, GLfixed param)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", target, pname,
          param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexParameterx>(target, pname, param);

        if (context->skipValidation() || ValidateTexParameterx(context, target, pname, param))
        {
            context->texParameterx(target, pname, param);
        }
    }
}

void GL_APIENTRY TexParameterxv(GLenum target, GLenum pname, const GLfixed *params)
{
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%0.8p)", target,
          pname, params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexParameterxv>(target, pname, params);

        if (context->skipValidation() || ValidateTexParameterxv(context, target, pname, params))
        {
            context->texParameterxv(target, pname, params);
        }
    }
}

void GL_APIENTRY TexSubImage2D(GLenum target,
                               GLint level,
                               GLint xoffset,
                               GLint yoffset,
                               GLsizei width,
                               GLsizei height,
                               GLenum format,
                               GLenum type,
                               const void *pixels)
{
    EVENT(
        "(GLenum target = 0x%X, GLint level = %d, GLint xoffset = %d, GLint yoffset = %d, GLsizei "
        "width = %d, GLsizei height = %d, GLenum format = 0x%X, GLenum type = 0x%X, const void "
        "*pixels = 0x%0.8p)",
        target, level, xoffset, yoffset, width, height, format, type, pixels);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::TexSubImage2D>(target, level, xoffset, yoffset, width,
                                                         height, format, type, pixels);

        if (context->skipValidation() ||
            ValidateTexSubImage2D(context, target, level, xoffset, yoffset, width, height, format,
                                  type, pixels))
        {
            context->texSubImage2D(target, level, xoffset, yoffset, width, height, format, type,
                                   pixels);
        }
    }
}

void GL_APIENTRY Translatef(GLfloat x, GLfloat y, GLfloat z)
{
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Translatef>(x, y, z);

        if (context->skipValidation() || ValidateTranslatef(context, x, y, z))
        {
            context->translatef(x, y, z);
        }
    }
}

void GL_APIENTRY Translatex(GLfixed x, GLfixed y, GLfixed z)
{
    EVENT("(GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Translatex>(x, y, z);

        if (context->skipValidation() || ValidateTranslatex(context, x, y, z))
        {
            context->translatex(x, y, z);
        }
    }
}

void GL_APIENTRY VertexPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%0.8p)",
        size, type, stride, pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::VertexPointer>(size, type, stride, pointer);

        if (context->skipValidation() ||
            ValidateVertexPointer(context, size, type, stride, pointer))
        {
            context->vertexPointer(size, type, stride, pointer);
        }
    }
}

void GL_APIENTRY Viewport(GLint x, GLint y, GLsizei width, GLsizei height)
{
    EVENT("(GLint x = %d, GLint y = %d, GLsizei width = %d, GLsizei height = %d)", x, y, width,
          height);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        context->gatherParams<EntryPoint::Viewport>(x, y, width, height);

        if (context->skipValidation() || ValidateViewport(context, x, y, width, height))
        {
            context->viewport(x, y, width, height);
        }
    }
}
}  // namespace gl
