/* -*- buffer-read-only: t -*- vi: set ro: */
#define SWIG_MODULE "QuantLib"
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.33
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */


#ifdef __cplusplus
template<typename T> class SwigValueWrapper {
    T *tt;
public:
    SwigValueWrapper() : tt(0) { }
    SwigValueWrapper(const SwigValueWrapper<T>& rhs) : tt(new T(*rhs.tt)) { }
    SwigValueWrapper(const T& t) : tt(new T(t)) { }
    ~SwigValueWrapper() { delete tt; } 
    SwigValueWrapper& operator=(const T& t) { delete tt; tt = new T(t); return *this; }
    operator T&() const { return *tt; }
    T *operator&() { return tt; }
private:
    SwigValueWrapper& operator=(const SwigValueWrapper<T>& rhs);
};

template <typename T> T SwigValueInit() {
  return T();
}
#endif

/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC) && (__SUNPRO_CC <= 0x560)
#  define SWIGTEMPLATEDISAMBIGUATOR template
# elif defined(__HP_aCC)
/* Needed even with `aCC -AA' when `aCC -V' reports HP ANSI C++ B3910B A.03.55 */
/* If we find a maximum version that requires this, the test would be __HP_aCC <= 35500 for A.03.55 */
#  define SWIGTEMPLATEDISAMBIGUATOR template
# else
#  define SWIGTEMPLATEDISAMBIGUATOR
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* Deal with Microsoft's attempt at deprecating methods in the standard C++ library */
#if !defined(SWIG_NO_SCL_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_SCL_SECURE_NO_DEPRECATE)
# define _SCL_SECURE_NO_DEPRECATE
#endif



#define SWIGSTATIC static

/* -----------------------------------------------------------------------------
 * swigrun.swg
 *
 * This file contains generic CAPI SWIG runtime support for pointer
 * type checking.
 * ----------------------------------------------------------------------------- */

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "3"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

/*  Generic buffer size */
#ifndef SWIG_BUFFER_SIZE
# define SWIG_BUFFER_SIZE 1024
#endif

/* Flags for pointer conversions */
#define SWIG_POINTER_DISOWN        0x1

/* Flags for new pointer objects */
#define SWIG_POINTER_OWN           0x1


/* 
   Flags/methods for returning states.
   
   The swig conversion methods, as ConvertPtr, return and integer 
   that tells if the conversion was successful or not. And if not,
   an error code can be returned (see swigerrors.swg for the codes).
   
   Use the following macros/flags to set or process the returning
   states.
   
   In old swig versions, you usually write code as:

     if (SWIG_ConvertPtr(obj,vptr,ty.flags) != -1) {
       // success code
     } else {
       //fail code
     }

   Now you can be more explicit as:

    int res = SWIG_ConvertPtr(obj,vptr,ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
    } else {
      // fail code
    }

   that seems to be the same, but now you can also do

    Type *ptr;
    int res = SWIG_ConvertPtr(obj,(void **)(&ptr),ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
      if (SWIG_IsNewObj(res) {
        ...
	delete *ptr;
      } else {
        ...
      }
    } else {
      // fail code
    }
    
   I.e., now SWIG_ConvertPtr can return new objects and you can
   identify the case and take care of the deallocation. Of course that
   requires also to SWIG_ConvertPtr to return new result values, as

      int SWIG_ConvertPtr(obj, ptr,...) {         
        if (<obj is ok>) {			       
          if (<need new object>) {		       
            *ptr = <ptr to new allocated object>; 
            return SWIG_NEWOBJ;		       
          } else {				       
            *ptr = <ptr to old object>;	       
            return SWIG_OLDOBJ;		       
          } 				       
        } else {				       
          return SWIG_BADOBJ;		       
        }					       
      }

   Of course, returning the plain '0(success)/-1(fail)' still works, but you can be
   more explicit by returning SWIG_BADOBJ, SWIG_ERROR or any of the
   swig errors code.

   Finally, if the SWIG_CASTRANK_MODE is enabled, the result code
   allows to return the 'cast rank', for example, if you have this

       int food(double)
       int fooi(int);

   and you call
 
      food(1)   // cast rank '1'  (1 -> 1.0)
      fooi(1)   // cast rank '0'

   just use the SWIG_AddCast()/SWIG_CheckState()


 */
#define SWIG_OK                    (0) 
#define SWIG_ERROR                 (-1)
#define SWIG_IsOK(r)               (r >= 0)
#define SWIG_ArgError(r)           ((r != SWIG_ERROR) ? r : SWIG_TypeError)  

/* The CastRankLimit says how many bits are used for the cast rank */
#define SWIG_CASTRANKLIMIT         (1 << 8)
/* The NewMask denotes the object was created (using new/malloc) */
#define SWIG_NEWOBJMASK            (SWIG_CASTRANKLIMIT  << 1)
/* The TmpMask is for in/out typemaps that use temporal objects */
#define SWIG_TMPOBJMASK            (SWIG_NEWOBJMASK << 1)
/* Simple returning values */
#define SWIG_BADOBJ                (SWIG_ERROR)
#define SWIG_OLDOBJ                (SWIG_OK)
#define SWIG_NEWOBJ                (SWIG_OK | SWIG_NEWOBJMASK)
#define SWIG_TMPOBJ                (SWIG_OK | SWIG_TMPOBJMASK)
/* Check, add and del mask methods */
#define SWIG_AddNewMask(r)         (SWIG_IsOK(r) ? (r | SWIG_NEWOBJMASK) : r)
#define SWIG_DelNewMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_NEWOBJMASK) : r)
#define SWIG_IsNewObj(r)           (SWIG_IsOK(r) && (r & SWIG_NEWOBJMASK))
#define SWIG_AddTmpMask(r)         (SWIG_IsOK(r) ? (r | SWIG_TMPOBJMASK) : r)
#define SWIG_DelTmpMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_TMPOBJMASK) : r)
#define SWIG_IsTmpObj(r)           (SWIG_IsOK(r) && (r & SWIG_TMPOBJMASK))


/* Cast-Rank Mode */
#if defined(SWIG_CASTRANK_MODE)
#  ifndef SWIG_TypeRank
#    define SWIG_TypeRank             unsigned long
#  endif
#  ifndef SWIG_MAXCASTRANK            /* Default cast allowed */
#    define SWIG_MAXCASTRANK          (2)
#  endif
#  define SWIG_CASTRANKMASK          ((SWIG_CASTRANKLIMIT) -1)
#  define SWIG_CastRank(r)           (r & SWIG_CASTRANKMASK)
SWIGINTERNINLINE int SWIG_AddCast(int r) { 
  return SWIG_IsOK(r) ? ((SWIG_CastRank(r) < SWIG_MAXCASTRANK) ? (r + 1) : SWIG_ERROR) : r;
}
SWIGINTERNINLINE int SWIG_CheckState(int r) { 
  return SWIG_IsOK(r) ? SWIG_CastRank(r) + 1 : 0; 
}
#else /* no cast-rank mode */
#  define SWIG_AddCast
#  define SWIG_CheckState(r) (SWIG_IsOK(r) ? 1 : 0)
#endif




#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
  int                    owndata;		/* flag if the structure owns the clientdata */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;

/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (*f1 > *f2) ? 1 : -1;
  }
  return (int)((l1 - f1) - (l2 - f2));
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (!type) return NULL;
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}
SWIGRUNTIME void
SWIG_TypeNewClientData(swig_type_info *ti, void *clientdata) {
  SWIG_TypeClientData(ti, clientdata);
  ti->owndata = 1;
}
  
/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}

/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------
 * See the LICENSE file for information on copyright, usage and redistribution
 * of SWIG, and the README file for authors - http://www.swig.org/release.html.
 *
 * ocamldec.swg
 *
 * Ocaml runtime code -- declarations
 * ----------------------------------------------------------------------------- */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef __cplusplus
#define SWIGEXT extern "C"
SWIGEXT {
#else
#define SWIGEXT 
#endif
#define value caml_value_t
#define CAML_VALUE caml_value_t
#include <caml/alloc.h>
#include <caml/custom.h>
#include <caml/mlvalues.h>
#include <caml/memory.h>
#include <caml/callback.h>
#include <caml/fail.h>
#include <caml/misc.h>

#define caml_array_set swig_caml_array_set

// Adapted from memory.h and mlvalues.h

#define SWIG_CAMLlocal1(x) \
  caml_value_t x = 0; \
  CAMLxparam1 (x)

#define SWIG_CAMLlocal2(x, y) \
  caml_value_t x = 0, y = 0; \
  CAMLxparam2 (x, y)

#define SWIG_CAMLlocal3(x, y, z) \
  caml_value_t x = 0, y = 0, z = 0; \
  CAMLxparam3 (x, y, z)

#define SWIG_CAMLlocal4(x, y, z, t) \
  caml_value_t x = 0, y = 0, z = 0, t = 0; \
  CAMLxparam4 (x, y, z, t)

#define SWIG_CAMLlocal5(x, y, z, t, u) \
  caml_value_t x = 0, y = 0, z = 0, t = 0, u = 0; \
  CAMLxparam5 (x, y, z, t, u)

#define SWIG_CAMLlocalN(x, size) \
  caml_value_t x [(size)] = { 0, /* 0, 0, ... */ }; \
  CAMLxparamN (x, (size))

#define SWIG_Field(x, i) (((caml_value_t *)(x)) [i])           /* Also an l-value. */
#define SWIG_Store_field(block, offset, val) do{ \
  mlsize_t caml__temp_offset = (offset); \
  caml_value_t caml__temp_val = (val); \
  modify (&SWIG_Field ((block), caml__temp_offset), caml__temp_val); \
}while(0)

#define SWIG_Data_custom_val(v) ((void *) &SWIG_Field((v), 1))
#ifdef ARCH_BIG_ENDIAN
#define SWIG_Tag_val(val) (((unsigned char *) (val)) [-1])
                                                 /* Also an l-value. */
#define SWIG_Tag_hp(hp) (((unsigned char *) (hp)) [sizeof(caml_value_t)-1])
                                                 /* Also an l-value. */
#else
#define SWIG_Tag_val(val) (((unsigned char *) (val)) [-sizeof(caml_value_t)])
                                                 /* Also an l-value. */
#define SWIG_Tag_hp(hp) (((unsigned char *) (hp)) [0])
                                                 /* Also an l-value. */
#endif

#ifdef CAMLreturn0
#undef CAMLreturn0
#endif
#define CAMLreturn0 do{ \
  caml_local_roots = caml__frame; \
  return; \
}while (0)

#ifdef CAMLreturn
#undef CAMLreturn
#endif
#define CAMLreturn(result) do{ \
  caml_value_t caml__temp_result = (result); \
  caml_local_roots = caml__frame; \
  return (caml__temp_result); \
}while(0)

#define CAMLreturn_type(result) do{ \
  caml_local_roots = caml__frame; \
  return result; \
}while(0)

#ifdef CAMLnoreturn
#undef CAMLnoreturn
#endif
#define CAMLnoreturn ((void) caml__frame)


#ifndef ARCH_ALIGN_INT64
#define SWIG_Int64_val(v) (*((int64 *) SWIG_Data_custom_val(v)))
#else
CAMLextern int64 Int64_val(caml_value_t v);
#define SWIG_Int64_val(v) Int64_val(v)
#endif

#define SWIG_NewPointerObj(p,type,flags) caml_val_ptr(p,type)
#define SWIG_GetModule(clientdata) SWIG_Ocaml_GetModule()
#define SWIG_SetModule(clientdata, pointer) SWIG_Ocaml_SetModule(pointer)

#define SWIG_contract_assert(expr, msg) if(!(expr)) {failwith(msg);} else

    SWIGSTATIC int
    SWIG_GetPtr(void *source, void **result, swig_type_info *type, swig_type_info *result_type);
    
    SWIGSTATIC void *
    SWIG_MustGetPtr (CAML_VALUE v,  swig_type_info *type);
    
    SWIGSTATIC CAML_VALUE _wrap_delete_void( CAML_VALUE );
    
    SWIGSTATIC int enum_to_int( char *name, CAML_VALUE v );
    SWIGSTATIC CAML_VALUE int_to_enum( char *name, int v );

    SWIGSTATIC CAML_VALUE caml_list_nth( CAML_VALUE lst, int n );
    SWIGSTATIC CAML_VALUE caml_list_append( CAML_VALUE lst, CAML_VALUE elt );
    SWIGSTATIC int caml_list_length( CAML_VALUE lst );
    SWIGSTATIC CAML_VALUE caml_array_new( int n );
    SWIGSTATIC void caml_array_set( CAML_VALUE arr, int n, CAML_VALUE item );
    SWIGSTATIC CAML_VALUE caml_array_nth( CAML_VALUE arr, int n );
    SWIGSTATIC int caml_array_length( CAML_VALUE arr );

    SWIGSTATIC CAML_VALUE caml_val_char( char c );
    SWIGSTATIC CAML_VALUE caml_val_uchar( unsigned char c );

    SWIGSTATIC CAML_VALUE caml_val_short( short s );
    SWIGSTATIC CAML_VALUE caml_val_ushort( unsigned short s );
    
    SWIGSTATIC CAML_VALUE caml_val_int( int x );
    SWIGSTATIC CAML_VALUE caml_val_uint( unsigned int x );

    SWIGSTATIC CAML_VALUE caml_val_long( long x );
    SWIGSTATIC CAML_VALUE caml_val_ulong( unsigned long x );

    SWIGSTATIC CAML_VALUE caml_val_float( float f );
    SWIGSTATIC CAML_VALUE caml_val_double( double d );

    SWIGSTATIC CAML_VALUE caml_val_ptr( void *p, swig_type_info *descriptor );

    SWIGSTATIC CAML_VALUE caml_val_string( const char *str );
    SWIGSTATIC CAML_VALUE caml_val_string_len( const char *str, int len );

    SWIGSTATIC long caml_long_val( CAML_VALUE v );
    SWIGSTATIC double caml_double_val( CAML_VALUE v );

    SWIGSTATIC int caml_ptr_val_internal( CAML_VALUE v, void **out,
				      swig_type_info *descriptor );
    SWIGSTATIC void *caml_ptr_val( CAML_VALUE v, swig_type_info *descriptor );

    SWIGSTATIC char *caml_string_val( CAML_VALUE v );
    SWIGSTATIC int caml_string_len( CAML_VALUE v );

#ifdef __cplusplus
}
#endif

/* mzschemedec.swg ends here */

/* -*-c-*- */

/* SWIG pointer structure */

#include <string.h>
#include <assert.h>

#ifdef __cplusplus
extern "C" {
#endif

#define C_bool 0
#define C_char 1
#define C_uchar 2
#define C_short 3
#define C_ushort 4
#define C_int 5
#define C_uint 6
#define C_int32 7
#define C_int64 8
#define C_float 9
#define C_double 10
#define C_ptr 11
#define C_array 12
#define C_list 13
#define C_obj 14
#define C_string 15
#define C_enum 16
#define C_director_core 17


/* Cast a pointer if possible; returns 1 if successful */
    
    SWIGSTATIC int
    SWIG_Cast (void *source, swig_type_info *source_type,
	       void **ptr, swig_type_info *dest_type)
    {
	if( !source ) { // Special case for NULL.  This is a popular question
	    // for other modules on the list, so I want an easy way out...
	    *ptr = 0;
	    return 0;
	}

#ifdef TYPE_CAST_VERBOSE
	fprintf( stderr, "Trying to cast %s to %s\n", 
		 source_type ? source_type->str : "<none>",
		 dest_type ? dest_type->str : "<none>" );
#endif
	if (dest_type != source_type) {
	    /* We have a type mismatch.  Will have to look through our type
	       mapping table to figure out whether or not we can accept this
	       datatype. 
	       --
	       Ignore typechecks for void *.  Allow any conversion. */
	    if( !dest_type || !source_type || 
		!strcmp(dest_type->name,"_p_void") ||
		!strcmp(source_type->name,"_p_void") ) {
		*ptr = source;
		return 0;
	    } else {
		swig_cast_info *tc = 
		    SWIG_TypeCheckStruct(source_type, dest_type );
#ifdef TYPE_CAST_VERBOSE
		fprintf( stderr, "Typecheck -> %s\n",
			 tc ? tc->str : "<none>" );
#endif
		if( tc ) {
		    *ptr = SWIG_TypeCast( tc, source );
		    return 0;
		} else
		    return -1;
	    }
	} else {
	    *ptr = source;
	    return 0;
	}
    }

/* Return 0 if successful. */
    SWIGSTATIC int
    SWIG_GetPtr(void *inptr, void **outptr, 
		swig_type_info *intype, swig_type_info *outtype) {
	if (intype) {
	    return SWIG_Cast(inptr, intype,
			     outptr, outtype) == -1;
	} else {
	    *outptr = inptr;
	    return 0;
	}
    }

    SWIGSTATIC void caml_print_list( CAML_VALUE v );

    SWIGSTATIC void caml_print_val( CAML_VALUE v ) {
	switch( SWIG_Tag_val(v) ) {
	case C_bool:
	    if( Bool_val(SWIG_Field(v,0)) ) fprintf( stderr, "true " );
	    else fprintf( stderr, "false " );
	    break;
	case C_char:
	case C_uchar:
	    fprintf( stderr, "'%c' (\\%03d) ", 
		     (Int_val(SWIG_Field(v,0)) >= ' ' &&
		      Int_val(SWIG_Field(v,0)) < 127) ? Int_val(SWIG_Field(v,0)) : '.',
		     Int_val(SWIG_Field(v,0)) );
	    break;
	case C_short:
	case C_ushort:
	case C_int:
	    fprintf( stderr, "%d ", (int)caml_long_val(v) );
	    break;

	case C_uint:
	case C_int32:
	    fprintf( stderr, "%ud ", (unsigned int)caml_long_val(v) );
	    break;
	case C_int64:
	    fprintf( stderr, "%ld ", caml_long_val(v) );
	    break;
	case C_float:
	case C_double:
	    fprintf( stderr, "%f ", caml_double_val(v) );
	    break;

	case C_ptr:
	{
	    void *vout = 0;
	    swig_type_info *ty = (swig_type_info *)(long)SWIG_Int64_val(SWIG_Field(v,1));
	    caml_ptr_val_internal(v,&vout,0);
	    fprintf( stderr, "PTR(%p,%s) ", 
		     vout,
		     ty ? ty->name : "(null)" );
	}
	break;
	case C_array:
	{
	    unsigned int i;
	    for( i = 0; i < Wosize_val( SWIG_Field(v,0) ); i++ ) 
		caml_print_val( SWIG_Field(SWIG_Field(v,0),i) );
	}
	break;
	case C_list:
	    caml_print_list( SWIG_Field(v,0) );
	    break;
	case C_obj:
	    fprintf( stderr, "OBJ(%p) ", (void *)SWIG_Field(v,0) );
	    break;
	case C_string:
	{
	    void *cout;
	    caml_ptr_val_internal(v,&cout,0);
	    fprintf( stderr, "'%s' ", (char *)cout );
	} 
	break;
	}
    }

    SWIGSTATIC void caml_print_list( CAML_VALUE v ) {
	CAMLparam1(v);
	while( v && Is_block(v) ) {
	    fprintf( stderr, "[ " );
	    caml_print_val( SWIG_Field(v,0) );
	    fprintf( stderr, "]\n" );
	    v = SWIG_Field(v,1);
	}
	CAMLreturn0;
    }

    SWIGSTATIC CAML_VALUE caml_list_nth( CAML_VALUE lst, int n ) {
	CAMLparam1(lst);
	int i = 0;
	while( i < n && lst && Is_block(lst) ) {
	    i++; lst = SWIG_Field(lst,1);
	}
	if( lst == Val_unit ) CAMLreturn(Val_unit);
	else CAMLreturn(SWIG_Field(lst,0));
    }
    
    SWIGSTATIC CAML_VALUE caml_list_append( CAML_VALUE lst, CAML_VALUE elt ) {
	CAMLparam2(lst,elt);
	SWIG_CAMLlocal3(v,vt,lh);
	lh = Val_unit;
	v = Val_unit;

	/* Appending C_void should have no effect */
	if( !Is_block(elt) ) return lst;

	while( lst && Is_block(lst) ) {
	    if( v && v != Val_unit ) {
		vt = alloc_tuple(2);
		SWIG_Store_field(v,1,vt);
		v = vt;
	    } else {
		v = lh = alloc_tuple(2);
	    }
	    SWIG_Store_field(v,0,SWIG_Field(lst,0));
	    lst = SWIG_Field(lst,1);
	}

	if( v && Is_block(v) ) {
	    vt = alloc_tuple(2);
	    SWIG_Store_field(v,1,vt);
	    v = vt;
	} else {
	    v = lh = alloc_tuple(2);
	}
	SWIG_Store_field(v,0,elt);
	SWIG_Store_field(v,1,Val_unit);

	CAMLreturn(lh);
    }

    SWIGSTATIC int caml_list_length( CAML_VALUE lst ) {
	CAMLparam1(lst);
	int i = 0;
	while( lst && Is_block(lst) ) { i++; lst = SWIG_Field(lst,1); }
	CAMLreturn(i);
    }

    SWIGSTATIC void caml_array_set( CAML_VALUE arr, int n, CAML_VALUE item ) {
	CAMLparam2(arr,item);
	SWIG_Store_field(SWIG_Field(arr,0),n,item);
	CAMLreturn0;
    }

    SWIGSTATIC value caml_array_nth( CAML_VALUE arr, int n ) {
	CAMLparam1(arr);
	if( SWIG_Tag_val(arr) == C_array )
	    CAMLreturn(SWIG_Field(SWIG_Field(arr,0),n));
	else if( SWIG_Tag_val(arr) == C_list )
	    CAMLreturn(caml_list_nth(arr,0));
	else
	    failwith("Need array or list");
    }

    SWIGSTATIC int caml_array_len( CAML_VALUE arr ) {
	CAMLparam1(arr);
	if( SWIG_Tag_val(arr) == C_array )
	    CAMLreturn(Wosize_val(SWIG_Field(arr,0)));
	else if( SWIG_Tag_val(arr) == C_list )
	    CAMLreturn(caml_list_length(arr));
	else
	    failwith("Need array or list");
    }

    SWIGSTATIC CAML_VALUE caml_swig_alloc(int x,int y) {
	return caml_alloc(x,y);
    }

    SWIGSTATIC value caml_array_new( int n ) {
	CAMLparam0();
	SWIG_CAMLlocal1(vv);
	vv = caml_swig_alloc(1,C_array);
	SWIG_Store_field(vv,0,alloc_tuple(n));
	CAMLreturn(vv);
    }
    
    SWIGSTATIC CAML_VALUE caml_val_bool( int b ) {
	CAMLparam0();
	SWIG_CAMLlocal1(bv);
	bv = caml_swig_alloc(1,C_bool);
	SWIG_Store_field(bv,0,Val_bool(b));
	CAMLreturn(bv);
    }

    SWIGSTATIC CAML_VALUE caml_val_char( char c ) {
	CAMLparam0();
	SWIG_CAMLlocal1(cv);
	cv = caml_swig_alloc(1,C_char);
	SWIG_Store_field(cv,0,Val_int(c));
	CAMLreturn(cv);
    }

    SWIGSTATIC CAML_VALUE caml_val_uchar( unsigned char uc ) {
	CAMLparam0();
	SWIG_CAMLlocal1(ucv);
	ucv = caml_swig_alloc(1,C_uchar);
	SWIG_Store_field(ucv,0,Val_int(uc));
	CAMLreturn(ucv);
    }

    SWIGSTATIC CAML_VALUE caml_val_short( short s ) {
	CAMLparam0();
	SWIG_CAMLlocal1(sv);
	sv = caml_swig_alloc(1,C_short);
	SWIG_Store_field(sv,0,Val_int(s));
	CAMLreturn(sv);
    }

    SWIGSTATIC CAML_VALUE caml_val_ushort( unsigned short us ) {
	CAMLparam0();
	SWIG_CAMLlocal1(usv);
	usv = caml_swig_alloc(1,C_ushort);
	SWIG_Store_field(usv,0,Val_int(us));
	CAMLreturn(usv);
    }

    SWIGSTATIC CAML_VALUE caml_val_int( int i ) {
	CAMLparam0();
	SWIG_CAMLlocal1(iv);
	iv = caml_swig_alloc(1,C_int);
	SWIG_Store_field(iv,0,Val_int(i));
	CAMLreturn(iv);
    }

    SWIGSTATIC CAML_VALUE caml_val_uint( unsigned int ui ) {
	CAMLparam0();
	SWIG_CAMLlocal1(uiv);
	uiv = caml_swig_alloc(1,C_int);
	SWIG_Store_field(uiv,0,Val_int(ui));
	CAMLreturn(uiv);
    }

    SWIGSTATIC CAML_VALUE caml_val_long( long l ) {
	CAMLparam0();
	SWIG_CAMLlocal1(lv);
	lv = caml_swig_alloc(1,C_int64);
	SWIG_Store_field(lv,0,copy_int64(l));
	CAMLreturn(lv);
    }

    SWIGSTATIC CAML_VALUE caml_val_ulong( unsigned long ul ) {
	CAMLparam0();
	SWIG_CAMLlocal1(ulv);
	ulv = caml_swig_alloc(1,C_int64);
	SWIG_Store_field(ulv,0,copy_int64(ul));
	CAMLreturn(ulv);
    }

    SWIGSTATIC CAML_VALUE caml_val_float( float f ) {
	CAMLparam0();
	SWIG_CAMLlocal1(fv);
	fv = caml_swig_alloc(1,C_float);
	SWIG_Store_field(fv,0,copy_double((double)f));
	CAMLreturn(fv);
    }

    SWIGSTATIC CAML_VALUE caml_val_double( double d ) {
	CAMLparam0();
	SWIG_CAMLlocal1(fv);
	fv = caml_swig_alloc(1,C_double);
	SWIG_Store_field(fv,0,copy_double(d));
	CAMLreturn(fv);
    }

    SWIGSTATIC CAML_VALUE caml_val_ptr( void *p, swig_type_info *info ) {
	CAMLparam0();
	SWIG_CAMLlocal1(vv);
	vv = caml_swig_alloc(2,C_ptr);
	SWIG_Store_field(vv,0,copy_int64((long)p));
	SWIG_Store_field(vv,1,copy_int64((long)info));
	CAMLreturn(vv);
    }

    SWIGSTATIC CAML_VALUE caml_val_string( const char *p ) {
	CAMLparam0();
	SWIG_CAMLlocal1(vv);
	if( !p ) CAMLreturn(caml_val_ptr( (void *)p, 0 ));
	vv = caml_swig_alloc(1,C_string);
	SWIG_Store_field(vv,0,copy_string(p));
	CAMLreturn(vv);
    }

    SWIGSTATIC CAML_VALUE caml_val_string_len( const char *p, int len ) {
	CAMLparam0();
	SWIG_CAMLlocal1(vv);
	if( !p || len < 0 ) CAMLreturn(caml_val_ptr( (void *)p, 0 ));
	vv = caml_swig_alloc(1,C_string);
	SWIG_Store_field(vv,0,alloc_string(len));
	memcpy(String_val(SWIG_Field(vv,0)),p,len);
	CAMLreturn(vv);
    }

    #define caml_val_obj(v, name) caml_val_obj_helper(v, SWIG_TypeQuery((name)), name)
    SWIGSTATIC CAML_VALUE caml_val_obj_helper( void *v, swig_type_info *type, char *name) {
	CAMLparam0();
	CAMLreturn(callback2(*caml_named_value("caml_create_object_fn"),
			     caml_val_ptr(v,type),
			     copy_string(name)));
    }

    SWIGSTATIC long caml_long_val_full( CAML_VALUE v, char *name ) {
	CAMLparam1(v);
	if( !Is_block(v) ) return 0;

	switch( SWIG_Tag_val(v) ) {
	case C_bool:
	case C_char:
	case C_uchar:
	case C_short:
	case C_ushort:
	case C_int:
	    CAMLreturn(Int_val(SWIG_Field(v,0)));
	case C_uint:
	case C_int32:
	    CAMLreturn(Int32_val(SWIG_Field(v,0)));
	case C_int64:
	    CAMLreturn((long)SWIG_Int64_val(SWIG_Field(v,0)));
	case C_float:
	case C_double:
	    CAMLreturn((long)Double_val(SWIG_Field(v,0)));
	case C_string:
	    CAMLreturn((long)String_val(SWIG_Field(v,0)));
	case C_ptr:
	    CAMLreturn((long)SWIG_Int64_val(SWIG_Field(SWIG_Field(v,0),0)));
	case C_enum: {
	    SWIG_CAMLlocal1(ret);
	    CAML_VALUE *enum_to_int = caml_named_value(SWIG_MODULE "_enum_to_int");
	    if( !name ) failwith( "Not an enum conversion" );
	    ret = callback2(*enum_to_int,*caml_named_value(name),v);
	    CAMLreturn(caml_long_val(ret));
	}
	default:
	    failwith("No conversion to int");
	}
    }

    SWIGSTATIC long caml_long_val( CAML_VALUE v ) {
	return caml_long_val_full(v,0);
    }

    SWIGSTATIC double caml_double_val( CAML_VALUE v ) {
	CAMLparam1(v);
	if( !Is_block(v) ) return 0.0;
	switch( SWIG_Tag_val(v) ) {
	case C_bool:
	case C_char:
	case C_uchar:
	case C_short:
	case C_ushort:
	case C_int:
	    CAMLreturn_type(Int_val(SWIG_Field(v,0)));
	case C_uint:
	case C_int32:
	    CAMLreturn_type(Int32_val(SWIG_Field(v,0)));
	case C_int64:
	    CAMLreturn_type(SWIG_Int64_val(SWIG_Field(v,0)));
	case C_float:
	case C_double:
	    CAMLreturn_type(Double_val(SWIG_Field(v,0)));
	default:
	    fprintf( stderr, "Unknown block tag %d\n", SWIG_Tag_val(v) );
	    failwith("No conversion to double");
	}
    }

    SWIGSTATIC int caml_ptr_val_internal( CAML_VALUE v, void **out, 
					  swig_type_info *descriptor ) {
	CAMLparam1(v);
	void *outptr = NULL;
        swig_type_info *outdescr = NULL;

	if( v == Val_unit ) {
	    *out = 0;
	    CAMLreturn(0);
	}
	if( !Is_block(v) ) return -1;
	switch( SWIG_Tag_val(v) ) {
	case C_int:
	    if( !caml_long_val( v ) ) {
		*out = 0;
		CAMLreturn(0);
	    } else {
		*out = 0;
		CAMLreturn(1);
	    }
	    break;
	case C_obj:
	    CAMLreturn
		(caml_ptr_val_internal
		 (callback(*caml_named_value("caml_obj_ptr"),v),
		  out,descriptor));
	case C_string:
	    outptr = (void *)String_val(SWIG_Field(v,0));
	    break;
	case C_ptr:
	    outptr = (void *)(long)SWIG_Int64_val(SWIG_Field(v,0));
            outdescr = (swig_type_info *)(long)SWIG_Int64_val(SWIG_Field(v,1));
	    break;
	default:
	    *out = 0;
	    CAMLreturn(1);
	    break;
	}
	
	CAMLreturn(SWIG_GetPtr(outptr,out,outdescr,descriptor));
    }

    SWIGSTATIC void *caml_ptr_val( CAML_VALUE v, swig_type_info *descriptor ) {
        CAMLparam0();
#ifdef TYPE_CAST_VERBOSE
	caml_print_val( v );
#endif
	void *out = NULL;
	if( !caml_ptr_val_internal( v, &out, descriptor ) )
	    CAMLreturn_type(out);
	else
	    failwith( "No appropriate conversion found." );
    }

    SWIGSTATIC char *caml_string_val( CAML_VALUE v ) {
	return (char *)caml_ptr_val( v, 0 );
    }

    SWIGSTATIC int caml_string_len( CAML_VALUE v ) {
	switch( SWIG_Tag_val(v) ) {
	case C_string:
	    return string_length(SWIG_Field(v,0));
	default:
	    return strlen((char *)caml_ptr_val(v,0));
	}
    }

    SWIGSTATIC int caml_bool_check( CAML_VALUE v ) {
	CAMLparam1(v);
	
	if( !Is_block(v) ) return 0;
	
	switch( SWIG_Tag_val(v) ) {
	case C_bool:
	case C_ptr:
	case C_string:
	    CAMLreturn(1);
	default:
	    CAMLreturn(0);
	}
    }

    SWIGSTATIC int caml_int_check( CAML_VALUE v ) {
	CAMLparam1(v);
	
	if( !Is_block(v) ) return 0;
	
	switch( SWIG_Tag_val(v) ) {
	case C_char:
	case C_uchar:
	case C_short:
	case C_ushort:
	case C_int:
	case C_uint:
	case C_int32:
	case C_int64:
	    CAMLreturn(1);

	default:
	    CAMLreturn(0);
	}
    }

    SWIGSTATIC int caml_float_check( CAML_VALUE v ) {
	CAMLparam1(v);
	if( !Is_block(v) ) return 0;

	switch( SWIG_Tag_val(v) ) {
	case C_float:
	case C_double:
	    CAMLreturn(1);

	default:
	    CAMLreturn(0);
	}	
    }

    SWIGSTATIC int caml_ptr_check( CAML_VALUE v ) {
	CAMLparam1(v);
	if( !Is_block(v) ) return 0;

	switch( SWIG_Tag_val(v) ) {
	case C_string:
	case C_ptr:
	case C_int64:
	    CAMLreturn(1);

	default:
	    CAMLreturn(0);
	}	
    }

    static swig_module_info *SWIG_Ocaml_GetModule() {
      CAML_VALUE pointer;

      pointer = callback(*caml_named_value("swig_find_type_info"), caml_val_int(0));
      if (Is_block(pointer) && SWIG_Tag_val(pointer) == C_ptr) {
        return (swig_module_info *)(void *)(long)SWIG_Int64_val(SWIG_Field(pointer,0));
      }
      return 0;
    }

    static void SWIG_Ocaml_SetModule(swig_module_info *pointer) {
      CAML_VALUE mod_pointer;

      mod_pointer = caml_val_ptr(pointer, NULL);
      callback(*caml_named_value("swig_set_type_info"), mod_pointer);
    }

#ifdef __cplusplus
}
#endif
#undef value


/*  Errors in SWIG */
#define  SWIG_UnknownError    	   -1 
#define  SWIG_IOError        	   -2 
#define  SWIG_RuntimeError   	   -3 
#define  SWIG_IndexError     	   -4 
#define  SWIG_TypeError      	   -5 
#define  SWIG_DivisionByZero 	   -6 
#define  SWIG_OverflowError  	   -7 
#define  SWIG_SyntaxError    	   -8 
#define  SWIG_ValueError     	   -9 
#define  SWIG_SystemError    	   -10
#define  SWIG_AttributeError 	   -11
#define  SWIG_MemoryError    	   -12 
#define  SWIG_NullReferenceError   -13




/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_AUDLiborPtr swig_types[0]
#define SWIGTYPE_p_AmericanExercisePtr swig_types[1]
#define SWIGTYPE_p_AnalyticBarrierEnginePtr swig_types[2]
#define SWIGTYPE_p_AnalyticCapFloorEnginePtr swig_types[3]
#define SWIGTYPE_p_AnalyticDigitalAmericanEnginePtr swig_types[4]
#define SWIGTYPE_p_AnalyticDividendEuropeanEnginePtr swig_types[5]
#define SWIGTYPE_p_AnalyticEuropeanEnginePtr swig_types[6]
#define SWIGTYPE_p_Array swig_types[7]
#define SWIGTYPE_p_AssetOrNothingPayoffPtr swig_types[8]
#define SWIGTYPE_p_AverageBasketPayoffPtr swig_types[9]
#define SWIGTYPE_p_BackwardFlat swig_types[10]
#define SWIGTYPE_p_BaroneAdesiWhaleyApproximationEnginePtr swig_types[11]
#define SWIGTYPE_p_Barrier swig_types[12]
#define SWIGTYPE_p_BarrierOptionPtr swig_types[13]
#define SWIGTYPE_p_BasketOptionPtr swig_types[14]
#define SWIGTYPE_p_BasketPayoffPtr swig_types[15]
#define SWIGTYPE_p_BermudanExercisePtr swig_types[16]
#define SWIGTYPE_p_BinomialConvertibleEnginePtr swig_types[17]
#define SWIGTYPE_p_BinomialVanillaEnginePtr swig_types[18]
#define SWIGTYPE_p_Bisection swig_types[19]
#define SWIGTYPE_p_BivariateCumulativeNormalDistribution swig_types[20]
#define SWIGTYPE_p_BjerksundStenslandApproximationEnginePtr swig_types[21]
#define SWIGTYPE_p_BlackCapFloorEnginePtr swig_types[22]
#define SWIGTYPE_p_BlackConstantVolPtr swig_types[23]
#define SWIGTYPE_p_BlackKarasinskiPtr swig_types[24]
#define SWIGTYPE_p_BlackProcessPtr swig_types[25]
#define SWIGTYPE_p_BlackScholesMertonProcessPtr swig_types[26]
#define SWIGTYPE_p_BlackScholesProcessPtr swig_types[27]
#define SWIGTYPE_p_BlackSwaptionEnginePtr swig_types[28]
#define SWIGTYPE_p_BlackVarianceSurfacePtr swig_types[29]
#define SWIGTYPE_p_BlackVolTermStructure swig_types[30]
#define SWIGTYPE_p_BondPtr swig_types[31]
#define SWIGTYPE_p_BoundaryConstraint swig_types[32]
#define SWIGTYPE_p_BoxMullerGaussianRngTKnuthUniformRng_t swig_types[33]
#define SWIGTYPE_p_BoxMullerGaussianRngTLecuyerUniformRng_t swig_types[34]
#define SWIGTYPE_p_BoxMullerGaussianRngTMersenneTwisterUniformRng_t swig_types[35]
#define SWIGTYPE_p_Brent swig_types[36]
#define SWIGTYPE_p_CADLiborPtr swig_types[37]
#define SWIGTYPE_p_CHFLiborPtr swig_types[38]
#define SWIGTYPE_p_CLGaussianRngTKnuthUniformRng_t swig_types[39]
#define SWIGTYPE_p_CLGaussianRngTLecuyerUniformRng_t swig_types[40]
#define SWIGTYPE_p_CLGaussianRngTMersenneTwisterUniformRng_t swig_types[41]
#define SWIGTYPE_p_Calendar swig_types[42]
#define SWIGTYPE_p_CalibrationHelper swig_types[43]
#define SWIGTYPE_p_Callability swig_types[44]
#define SWIGTYPE_p_CallabilityPrice swig_types[45]
#define SWIGTYPE_p_CapFloorPtr swig_types[46]
#define SWIGTYPE_p_CapFloorTermVolCurvePtr swig_types[47]
#define SWIGTYPE_p_CapFloorTermVolatilityStructure swig_types[48]
#define SWIGTYPE_p_CapHelperPtr swig_types[49]
#define SWIGTYPE_p_CapPtr swig_types[50]
#define SWIGTYPE_p_CashFlow swig_types[51]
#define SWIGTYPE_p_CashFlows swig_types[52]
#define SWIGTYPE_p_CashOrNothingPayoffPtr swig_types[53]
#define SWIGTYPE_p_CdorPtr swig_types[54]
#define SWIGTYPE_p_CeilingTruncation swig_types[55]
#define SWIGTYPE_p_ClosestRounding swig_types[56]
#define SWIGTYPE_p_CollarPtr swig_types[57]
#define SWIGTYPE_p_CompositeInstrumentPtr swig_types[58]
#define SWIGTYPE_p_CompoundForwardPtr swig_types[59]
#define SWIGTYPE_p_ConjugateGradient swig_types[60]
#define SWIGTYPE_p_ConstantEstimator swig_types[61]
#define SWIGTYPE_p_ConstantOptionletVolPtr swig_types[62]
#define SWIGTYPE_p_Constraint swig_types[63]
#define SWIGTYPE_p_ConvertibleFixedCouponBondPtr swig_types[64]
#define SWIGTYPE_p_ConvertibleFloatingRateBondPtr swig_types[65]
#define SWIGTYPE_p_ConvertibleZeroCouponBondPtr swig_types[66]
#define SWIGTYPE_p_CubicSpline swig_types[67]
#define SWIGTYPE_p_CumulativeNormalDistribution swig_types[68]
#define SWIGTYPE_p_Currency swig_types[69]
#define SWIGTYPE_p_DKKLiborPtr swig_types[70]
#define SWIGTYPE_p_DMinus swig_types[71]
#define SWIGTYPE_p_DPlus swig_types[72]
#define SWIGTYPE_p_DPlusDMinus swig_types[73]
#define SWIGTYPE_p_DZero swig_types[74]
#define SWIGTYPE_p_Date swig_types[75]
#define SWIGTYPE_p_DateGeneration swig_types[76]
#define SWIGTYPE_p_DateParser swig_types[77]
#define SWIGTYPE_p_DayCounter swig_types[78]
#define SWIGTYPE_p_DefaultBoundaryCondition swig_types[79]
#define SWIGTYPE_p_DefaultLexicographicalView swig_types[80]
#define SWIGTYPE_p_DepositRateHelperPtr swig_types[81]
#define SWIGTYPE_p_DirichletBCPtr swig_types[82]
#define SWIGTYPE_p_Discount swig_types[83]
#define SWIGTYPE_p_DiscountCurvePtr swig_types[84]
#define SWIGTYPE_p_DiscountingBondEnginePtr swig_types[85]
#define SWIGTYPE_p_DiscountingSwapEnginePtr swig_types[86]
#define SWIGTYPE_p_DiscreteGeometricASO swig_types[87]
#define SWIGTYPE_p_Dividend swig_types[88]
#define SWIGTYPE_p_DividendVanillaOptionPtr swig_types[89]
#define SWIGTYPE_p_DownRounding swig_types[90]
#define SWIGTYPE_p_Duration swig_types[91]
#define SWIGTYPE_p_EURLibor10MPtr swig_types[92]
#define SWIGTYPE_p_EURLibor11MPtr swig_types[93]
#define SWIGTYPE_p_EURLibor1MPtr swig_types[94]
#define SWIGTYPE_p_EURLibor1YPtr swig_types[95]
#define SWIGTYPE_p_EURLibor2MPtr swig_types[96]
#define SWIGTYPE_p_EURLibor2WPtr swig_types[97]
#define SWIGTYPE_p_EURLibor3MPtr swig_types[98]
#define SWIGTYPE_p_EURLibor4MPtr swig_types[99]
#define SWIGTYPE_p_EURLibor5MPtr swig_types[100]
#define SWIGTYPE_p_EURLibor6MPtr swig_types[101]
#define SWIGTYPE_p_EURLibor7MPtr swig_types[102]
#define SWIGTYPE_p_EURLibor8MPtr swig_types[103]
#define SWIGTYPE_p_EURLibor9MPtr swig_types[104]
#define SWIGTYPE_p_EURLiborPtr swig_types[105]
#define SWIGTYPE_p_EURLiborSWPtr swig_types[106]
#define SWIGTYPE_p_EndCriteria swig_types[107]
#define SWIGTYPE_p_EndCriteria__Type swig_types[108]
#define SWIGTYPE_p_Euribor10MPtr swig_types[109]
#define SWIGTYPE_p_Euribor11MPtr swig_types[110]
#define SWIGTYPE_p_Euribor1MPtr swig_types[111]
#define SWIGTYPE_p_Euribor1YPtr swig_types[112]
#define SWIGTYPE_p_Euribor2MPtr swig_types[113]
#define SWIGTYPE_p_Euribor2WPtr swig_types[114]
#define SWIGTYPE_p_Euribor365Ptr swig_types[115]
#define SWIGTYPE_p_Euribor365_10MPtr swig_types[116]
#define SWIGTYPE_p_Euribor365_11MPtr swig_types[117]
#define SWIGTYPE_p_Euribor365_1MPtr swig_types[118]
#define SWIGTYPE_p_Euribor365_1YPtr swig_types[119]
#define SWIGTYPE_p_Euribor365_2MPtr swig_types[120]
#define SWIGTYPE_p_Euribor365_2WPtr swig_types[121]
#define SWIGTYPE_p_Euribor365_3MPtr swig_types[122]
#define SWIGTYPE_p_Euribor365_3WPtr swig_types[123]
#define SWIGTYPE_p_Euribor365_4MPtr swig_types[124]
#define SWIGTYPE_p_Euribor365_5MPtr swig_types[125]
#define SWIGTYPE_p_Euribor365_6MPtr swig_types[126]
#define SWIGTYPE_p_Euribor365_7MPtr swig_types[127]
#define SWIGTYPE_p_Euribor365_8MPtr swig_types[128]
#define SWIGTYPE_p_Euribor365_9MPtr swig_types[129]
#define SWIGTYPE_p_Euribor365_SWPtr swig_types[130]
#define SWIGTYPE_p_Euribor3MPtr swig_types[131]
#define SWIGTYPE_p_Euribor3WPtr swig_types[132]
#define SWIGTYPE_p_Euribor4MPtr swig_types[133]
#define SWIGTYPE_p_Euribor5MPtr swig_types[134]
#define SWIGTYPE_p_Euribor6MPtr swig_types[135]
#define SWIGTYPE_p_Euribor7MPtr swig_types[136]
#define SWIGTYPE_p_Euribor8MPtr swig_types[137]
#define SWIGTYPE_p_Euribor9MPtr swig_types[138]
#define SWIGTYPE_p_EuriborPtr swig_types[139]
#define SWIGTYPE_p_EuriborSWPtr swig_types[140]
#define SWIGTYPE_p_EuriborSwapFixA10YPtr swig_types[141]
#define SWIGTYPE_p_EuriborSwapFixA12YPtr swig_types[142]
#define SWIGTYPE_p_EuriborSwapFixA15YPtr swig_types[143]
#define SWIGTYPE_p_EuriborSwapFixA1YPtr swig_types[144]
#define SWIGTYPE_p_EuriborSwapFixA20YPtr swig_types[145]
#define SWIGTYPE_p_EuriborSwapFixA25YPtr swig_types[146]
#define SWIGTYPE_p_EuriborSwapFixA2YPtr swig_types[147]
#define SWIGTYPE_p_EuriborSwapFixA30YPtr swig_types[148]
#define SWIGTYPE_p_EuriborSwapFixA3YPtr swig_types[149]
#define SWIGTYPE_p_EuriborSwapFixA4YPtr swig_types[150]
#define SWIGTYPE_p_EuriborSwapFixA5YPtr swig_types[151]
#define SWIGTYPE_p_EuriborSwapFixA6YPtr swig_types[152]
#define SWIGTYPE_p_EuriborSwapFixA7YPtr swig_types[153]
#define SWIGTYPE_p_EuriborSwapFixA8YPtr swig_types[154]
#define SWIGTYPE_p_EuriborSwapFixA9YPtr swig_types[155]
#define SWIGTYPE_p_EuriborSwapFixAPtr swig_types[156]
#define SWIGTYPE_p_EuriborSwapFixIFR10YPtr swig_types[157]
#define SWIGTYPE_p_EuriborSwapFixIFR12YPtr swig_types[158]
#define SWIGTYPE_p_EuriborSwapFixIFR15YPtr swig_types[159]
#define SWIGTYPE_p_EuriborSwapFixIFR1YPtr swig_types[160]
#define SWIGTYPE_p_EuriborSwapFixIFR20YPtr swig_types[161]
#define SWIGTYPE_p_EuriborSwapFixIFR25YPtr swig_types[162]
#define SWIGTYPE_p_EuriborSwapFixIFR2YPtr swig_types[163]
#define SWIGTYPE_p_EuriborSwapFixIFR30YPtr swig_types[164]
#define SWIGTYPE_p_EuriborSwapFixIFR3YPtr swig_types[165]
#define SWIGTYPE_p_EuriborSwapFixIFR4YPtr swig_types[166]
#define SWIGTYPE_p_EuriborSwapFixIFR5YPtr swig_types[167]
#define SWIGTYPE_p_EuriborSwapFixIFR6YPtr swig_types[168]
#define SWIGTYPE_p_EuriborSwapFixIFR7YPtr swig_types[169]
#define SWIGTYPE_p_EuriborSwapFixIFR8YPtr swig_types[170]
#define SWIGTYPE_p_EuriborSwapFixIFR9YPtr swig_types[171]
#define SWIGTYPE_p_EuriborSwapFixIFRPtr swig_types[172]
#define SWIGTYPE_p_EurliborSwapFixA10YPtr swig_types[173]
#define SWIGTYPE_p_EurliborSwapFixA12YPtr swig_types[174]
#define SWIGTYPE_p_EurliborSwapFixA15YPtr swig_types[175]
#define SWIGTYPE_p_EurliborSwapFixA1YPtr swig_types[176]
#define SWIGTYPE_p_EurliborSwapFixA20YPtr swig_types[177]
#define SWIGTYPE_p_EurliborSwapFixA25YPtr swig_types[178]
#define SWIGTYPE_p_EurliborSwapFixA2YPtr swig_types[179]
#define SWIGTYPE_p_EurliborSwapFixA30YPtr swig_types[180]
#define SWIGTYPE_p_EurliborSwapFixA3YPtr swig_types[181]
#define SWIGTYPE_p_EurliborSwapFixA4YPtr swig_types[182]
#define SWIGTYPE_p_EurliborSwapFixA5YPtr swig_types[183]
#define SWIGTYPE_p_EurliborSwapFixA6YPtr swig_types[184]
#define SWIGTYPE_p_EurliborSwapFixA7YPtr swig_types[185]
#define SWIGTYPE_p_EurliborSwapFixA8YPtr swig_types[186]
#define SWIGTYPE_p_EurliborSwapFixA9YPtr swig_types[187]
#define SWIGTYPE_p_EurliborSwapFixAPtr swig_types[188]
#define SWIGTYPE_p_EurliborSwapFixB10YPtr swig_types[189]
#define SWIGTYPE_p_EurliborSwapFixB12YPtr swig_types[190]
#define SWIGTYPE_p_EurliborSwapFixB15YPtr swig_types[191]
#define SWIGTYPE_p_EurliborSwapFixB1YPtr swig_types[192]
#define SWIGTYPE_p_EurliborSwapFixB20YPtr swig_types[193]
#define SWIGTYPE_p_EurliborSwapFixB25YPtr swig_types[194]
#define SWIGTYPE_p_EurliborSwapFixB2YPtr swig_types[195]
#define SWIGTYPE_p_EurliborSwapFixB30YPtr swig_types[196]
#define SWIGTYPE_p_EurliborSwapFixB3YPtr swig_types[197]
#define SWIGTYPE_p_EurliborSwapFixB4YPtr swig_types[198]
#define SWIGTYPE_p_EurliborSwapFixB5YPtr swig_types[199]
#define SWIGTYPE_p_EurliborSwapFixB6YPtr swig_types[200]
#define SWIGTYPE_p_EurliborSwapFixB7YPtr swig_types[201]
#define SWIGTYPE_p_EurliborSwapFixB8YPtr swig_types[202]
#define SWIGTYPE_p_EurliborSwapFixB9YPtr swig_types[203]
#define SWIGTYPE_p_EurliborSwapFixBPtr swig_types[204]
#define SWIGTYPE_p_EurliborSwapFixIFR10YPtr swig_types[205]
#define SWIGTYPE_p_EurliborSwapFixIFR12YPtr swig_types[206]
#define SWIGTYPE_p_EurliborSwapFixIFR15YPtr swig_types[207]
#define SWIGTYPE_p_EurliborSwapFixIFR1YPtr swig_types[208]
#define SWIGTYPE_p_EurliborSwapFixIFR20YPtr swig_types[209]
#define SWIGTYPE_p_EurliborSwapFixIFR25YPtr swig_types[210]
#define SWIGTYPE_p_EurliborSwapFixIFR2YPtr swig_types[211]
#define SWIGTYPE_p_EurliborSwapFixIFR30YPtr swig_types[212]
#define SWIGTYPE_p_EurliborSwapFixIFR3YPtr swig_types[213]
#define SWIGTYPE_p_EurliborSwapFixIFR4YPtr swig_types[214]
#define SWIGTYPE_p_EurliborSwapFixIFR5YPtr swig_types[215]
#define SWIGTYPE_p_EurliborSwapFixIFR6YPtr swig_types[216]
#define SWIGTYPE_p_EurliborSwapFixIFR7YPtr swig_types[217]
#define SWIGTYPE_p_EurliborSwapFixIFR8YPtr swig_types[218]
#define SWIGTYPE_p_EurliborSwapFixIFR9YPtr swig_types[219]
#define SWIGTYPE_p_EurliborSwapFixIFRPtr swig_types[220]
#define SWIGTYPE_p_EuropeanExercisePtr swig_types[221]
#define SWIGTYPE_p_EuropeanOptionPtr swig_types[222]
#define SWIGTYPE_p_ExchangeRate swig_types[223]
#define SWIGTYPE_p_ExchangeRateManager swig_types[224]
#define SWIGTYPE_p_Exercise swig_types[225]
#define SWIGTYPE_p_Extrapolator swig_types[226]
#define SWIGTYPE_p_FDAmericanEnginePtr swig_types[227]
#define SWIGTYPE_p_FDBermudanEnginePtr swig_types[228]
#define SWIGTYPE_p_FDDividendAmericanEnginePtr swig_types[229]
#define SWIGTYPE_p_FDDividendEuropeanEnginePtr swig_types[230]
#define SWIGTYPE_p_FDEuropeanEnginePtr swig_types[231]
#define SWIGTYPE_p_FDShoutEnginePtr swig_types[232]
#define SWIGTYPE_p_FalsePosition swig_types[233]
#define SWIGTYPE_p_FixedDividendPtr swig_types[234]
#define SWIGTYPE_p_FixedRateBondHelperPtr swig_types[235]
#define SWIGTYPE_p_FixedRateBondPtr swig_types[236]
#define SWIGTYPE_p_FixedRateCouponPtr swig_types[237]
#define SWIGTYPE_p_FlatForwardPtr swig_types[238]
#define SWIGTYPE_p_FloatingRateBondPtr swig_types[239]
#define SWIGTYPE_p_FloatingRateCouponPtr swig_types[240]
#define SWIGTYPE_p_FloorPtr swig_types[241]
#define SWIGTYPE_p_FloorTruncation swig_types[242]
#define SWIGTYPE_p_ForwardCurvePtr swig_types[243]
#define SWIGTYPE_p_ForwardEuropeanEnginePtr swig_types[244]
#define SWIGTYPE_p_ForwardFlat swig_types[245]
#define SWIGTYPE_p_ForwardRate swig_types[246]
#define SWIGTYPE_p_ForwardSpreadedTermStructurePtr swig_types[247]
#define SWIGTYPE_p_ForwardVanillaOptionPtr swig_types[248]
#define SWIGTYPE_p_FraRateHelperPtr swig_types[249]
#define SWIGTYPE_p_FractionalDividendPtr swig_types[250]
#define SWIGTYPE_p_FuturesRateHelperPtr swig_types[251]
#define SWIGTYPE_p_G2Ptr swig_types[252]
#define SWIGTYPE_p_G2SwaptionEnginePtr swig_types[253]
#define SWIGTYPE_p_GBPLiborPtr swig_types[254]
#define SWIGTYPE_p_GapPayoffPtr swig_types[255]
#define SWIGTYPE_p_GarmanKlassSigma1 swig_types[256]
#define SWIGTYPE_p_GarmanKlassSigma3 swig_types[257]
#define SWIGTYPE_p_GarmanKlassSigma4 swig_types[258]
#define SWIGTYPE_p_GarmanKlassSigma5 swig_types[259]
#define SWIGTYPE_p_GarmanKlassSigma6 swig_types[260]
#define SWIGTYPE_p_GarmanKohlagenProcessPtr swig_types[261]
#define SWIGTYPE_p_GaussKronrodAdaptive swig_types[262]
#define SWIGTYPE_p_GaussKronrodNonAdaptive swig_types[263]
#define SWIGTYPE_p_GaussianLowDiscrepancySequenceGenerator swig_types[264]
#define SWIGTYPE_p_GaussianMultiPathGenerator swig_types[265]
#define SWIGTYPE_p_GaussianPathGenerator swig_types[266]
#define SWIGTYPE_p_GaussianRandomGenerator swig_types[267]
#define SWIGTYPE_p_GaussianRandomSequenceGenerator swig_types[268]
#define SWIGTYPE_p_GeneralizedBlackScholesProcessPtr swig_types[269]
#define SWIGTYPE_p_GenericSequenceStatisticsTRiskStatistics_t swig_types[270]
#define SWIGTYPE_p_GenericSequenceStatisticsTStatistics_t swig_types[271]
#define SWIGTYPE_p_HaltonRsg swig_types[272]
#define SWIGTYPE_p_HandleTBlackVolTermStructure_t swig_types[273]
#define SWIGTYPE_p_HandleTCapFloorTermVolatilityStructure_t swig_types[274]
#define SWIGTYPE_p_HandleTLocalVolTermStructure_t swig_types[275]
#define SWIGTYPE_p_HandleTOptionletVolatilityStructure_t swig_types[276]
#define SWIGTYPE_p_HandleTQuote_t swig_types[277]
#define SWIGTYPE_p_HandleTShortRateModel_t swig_types[278]
#define SWIGTYPE_p_HandleTSwaptionVolatilityStructure_t swig_types[279]
#define SWIGTYPE_p_HandleTYieldTermStructure_t swig_types[280]
#define SWIGTYPE_p_HullWhitePtr swig_types[281]
#define SWIGTYPE_p_IMM swig_types[282]
#define SWIGTYPE_p_IborCouponPtr swig_types[283]
#define SWIGTYPE_p_IborIndexPtr swig_types[284]
#define SWIGTYPE_p_ImpliedTermStructurePtr swig_types[285]
#define SWIGTYPE_p_Index swig_types[286]
#define SWIGTYPE_p_IndexManager swig_types[287]
#define SWIGTYPE_p_Instrument swig_types[288]
#define SWIGTYPE_p_IntegralEnginePtr swig_types[289]
#define SWIGTYPE_p_InterestRate swig_types[290]
#define SWIGTYPE_p_InterestRateIndexPtr swig_types[291]
#define SWIGTYPE_p_IntervalPrice swig_types[292]
#define SWIGTYPE_p_InverseCumulativeNormal swig_types[293]
#define SWIGTYPE_p_InverseCumulativeRngTKnuthUniformRng_InverseCumulativeNormal_t swig_types[294]
#define SWIGTYPE_p_InverseCumulativeRngTKnuthUniformRng_MoroInverseCumulativeNormal_t swig_types[295]
#define SWIGTYPE_p_InverseCumulativeRngTLecuyerUniformRng_InverseCumulativeNormal_t swig_types[296]
#define SWIGTYPE_p_InverseCumulativeRngTLecuyerUniformRng_MoroInverseCumulativeNormal_t swig_types[297]
#define SWIGTYPE_p_InverseCumulativeRngTMersenneTwisterUniformRng_InverseCumulativeNormal_t swig_types[298]
#define SWIGTYPE_p_InverseCumulativeRngTMersenneTwisterUniformRng_MoroInverseCumulativeNormal_t swig_types[299]
#define SWIGTYPE_p_InverseCumulativeRsgTHaltonRsg_InverseCumulativeNormal_t swig_types[300]
#define SWIGTYPE_p_InverseCumulativeRsgTHaltonRsg_MoroInverseCumulativeNormal_t swig_types[301]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_InverseCumulativeNormal_t swig_types[302]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTKnuthUniformRng_t_MoroInverseCumulativeNormal_t swig_types[303]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_InverseCumulativeNormal_t swig_types[304]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTLecuyerUniformRng_t_MoroInverseCumulativeNormal_t swig_types[305]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_InverseCumulativeNormal_t swig_types[306]
#define SWIGTYPE_p_InverseCumulativeRsgTRandomSequenceGeneratorTMersenneTwisterUniformRng_t_MoroInverseCumulativeNormal_t swig_types[307]
#define SWIGTYPE_p_JPYLiborPtr swig_types[308]
#define SWIGTYPE_p_JamshidianSwaptionEnginePtr swig_types[309]
#define SWIGTYPE_p_JibarPtr swig_types[310]
#define SWIGTYPE_p_KnuthUniformRng swig_types[311]
#define SWIGTYPE_p_LecuyerUniformRng swig_types[312]
#define SWIGTYPE_p_Linear swig_types[313]
#define SWIGTYPE_p_LocalConstantVolPtr swig_types[314]
#define SWIGTYPE_p_LocalVolTermStructure swig_types[315]
#define SWIGTYPE_p_LogLinear swig_types[316]
#define SWIGTYPE_p_MCAmericanBasketEnginePtr swig_types[317]
#define SWIGTYPE_p_MCBarrierEnginePtr swig_types[318]
#define SWIGTYPE_p_MCBasketEnginePtr swig_types[319]
#define SWIGTYPE_p_MCEuropeanEnginePtr swig_types[320]
#define SWIGTYPE_p_Matrix swig_types[321]
#define SWIGTYPE_p_MaxBasketPayoffPtr swig_types[322]
#define SWIGTYPE_p_McDiscreteArithmeticASO swig_types[323]
#define SWIGTYPE_p_McEverest swig_types[324]
#define SWIGTYPE_p_McHimalaya swig_types[325]
#define SWIGTYPE_p_McPagoda swig_types[326]
#define SWIGTYPE_p_MersenneTwisterUniformRng swig_types[327]
#define SWIGTYPE_p_Merton76ProcessPtr swig_types[328]
#define SWIGTYPE_p_MinBasketPayoffPtr swig_types[329]
#define SWIGTYPE_p_Money swig_types[330]
#define SWIGTYPE_p_MoroInverseCumulativeNormal swig_types[331]
#define SWIGTYPE_p_MultiAssetOptionPtr swig_types[332]
#define SWIGTYPE_p_MultiPath swig_types[333]
#define SWIGTYPE_p_NZDLiborPtr swig_types[334]
#define SWIGTYPE_p_NeumannBCPtr swig_types[335]
#define SWIGTYPE_p_NoConstraint swig_types[336]
#define SWIGTYPE_p_NormalDistribution swig_types[337]
#define SWIGTYPE_p_Observable swig_types[338]
#define SWIGTYPE_p_OptimizationMethod swig_types[339]
#define SWIGTYPE_p_Optimizer swig_types[340]
#define SWIGTYPE_p_Option swig_types[341]
#define SWIGTYPE_p_OptionletVolatilityStructure swig_types[342]
#define SWIGTYPE_p_ParkinsonSigma swig_types[343]
#define SWIGTYPE_p_Path swig_types[344]
#define SWIGTYPE_p_Payoff swig_types[345]
#define SWIGTYPE_p_PercentageStrikePayoffPtr swig_types[346]
#define SWIGTYPE_p_Period swig_types[347]
#define SWIGTYPE_p_PeriodParser swig_types[348]
#define SWIGTYPE_p_PiecewiseFlatForwardPtr swig_types[349]
#define SWIGTYPE_p_PlainVanillaPayoffPtr swig_types[350]
#define SWIGTYPE_p_PositiveConstraint swig_types[351]
#define SWIGTYPE_p_PricingEngine swig_types[352]
#define SWIGTYPE_p_QuantLib__ARSCurrency swig_types[353]
#define SWIGTYPE_p_QuantLib__ATSCurrency swig_types[354]
#define SWIGTYPE_p_QuantLib__AUDCurrency swig_types[355]
#define SWIGTYPE_p_QuantLib__Actual360 swig_types[356]
#define SWIGTYPE_p_QuantLib__Actual365Fixed swig_types[357]
#define SWIGTYPE_p_QuantLib__ActualActual swig_types[358]
#define SWIGTYPE_p_QuantLib__Argentina swig_types[359]
#define SWIGTYPE_p_QuantLib__Australia swig_types[360]
#define SWIGTYPE_p_QuantLib__BDTCurrency swig_types[361]
#define SWIGTYPE_p_QuantLib__BEFCurrency swig_types[362]
#define SWIGTYPE_p_QuantLib__BGLCurrency swig_types[363]
#define SWIGTYPE_p_QuantLib__BRLCurrency swig_types[364]
#define SWIGTYPE_p_QuantLib__BYRCurrency swig_types[365]
#define SWIGTYPE_p_QuantLib__Brazil swig_types[366]
#define SWIGTYPE_p_QuantLib__CADCurrency swig_types[367]
#define SWIGTYPE_p_QuantLib__CHFCurrency swig_types[368]
#define SWIGTYPE_p_QuantLib__CLPCurrency swig_types[369]
#define SWIGTYPE_p_QuantLib__CNYCurrency swig_types[370]
#define SWIGTYPE_p_QuantLib__COPCurrency swig_types[371]
#define SWIGTYPE_p_QuantLib__CYPCurrency swig_types[372]
#define SWIGTYPE_p_QuantLib__CZKCurrency swig_types[373]
#define SWIGTYPE_p_QuantLib__Canada swig_types[374]
#define SWIGTYPE_p_QuantLib__China swig_types[375]
#define SWIGTYPE_p_QuantLib__CzechRepublic swig_types[376]
#define SWIGTYPE_p_QuantLib__DEMCurrency swig_types[377]
#define SWIGTYPE_p_QuantLib__DKKCurrency swig_types[378]
#define SWIGTYPE_p_QuantLib__Denmark swig_types[379]
#define SWIGTYPE_p_QuantLib__EEKCurrency swig_types[380]
#define SWIGTYPE_p_QuantLib__ESPCurrency swig_types[381]
#define SWIGTYPE_p_QuantLib__EURCurrency swig_types[382]
#define SWIGTYPE_p_QuantLib__FIMCurrency swig_types[383]
#define SWIGTYPE_p_QuantLib__FRFCurrency swig_types[384]
#define SWIGTYPE_p_QuantLib__Finland swig_types[385]
#define SWIGTYPE_p_QuantLib__GBPCurrency swig_types[386]
#define SWIGTYPE_p_QuantLib__GRDCurrency swig_types[387]
#define SWIGTYPE_p_QuantLib__Germany swig_types[388]
#define SWIGTYPE_p_QuantLib__HKDCurrency swig_types[389]
#define SWIGTYPE_p_QuantLib__HUFCurrency swig_types[390]
#define SWIGTYPE_p_QuantLib__HongKong swig_types[391]
#define SWIGTYPE_p_QuantLib__Hungary swig_types[392]
#define SWIGTYPE_p_QuantLib__IEPCurrency swig_types[393]
#define SWIGTYPE_p_QuantLib__ILSCurrency swig_types[394]
#define SWIGTYPE_p_QuantLib__INRCurrency swig_types[395]
#define SWIGTYPE_p_QuantLib__IQDCurrency swig_types[396]
#define SWIGTYPE_p_QuantLib__IRRCurrency swig_types[397]
#define SWIGTYPE_p_QuantLib__ISKCurrency swig_types[398]
#define SWIGTYPE_p_QuantLib__ITLCurrency swig_types[399]
#define SWIGTYPE_p_QuantLib__Iceland swig_types[400]
#define SWIGTYPE_p_QuantLib__India swig_types[401]
#define SWIGTYPE_p_QuantLib__Indonesia swig_types[402]
#define SWIGTYPE_p_QuantLib__Italy swig_types[403]
#define SWIGTYPE_p_QuantLib__JPYCurrency swig_types[404]
#define SWIGTYPE_p_QuantLib__Japan swig_types[405]
#define SWIGTYPE_p_QuantLib__JointCalendar swig_types[406]
#define SWIGTYPE_p_QuantLib__KRWCurrency swig_types[407]
#define SWIGTYPE_p_QuantLib__KWDCurrency swig_types[408]
#define SWIGTYPE_p_QuantLib__LTLCurrency swig_types[409]
#define SWIGTYPE_p_QuantLib__LUFCurrency swig_types[410]
#define SWIGTYPE_p_QuantLib__LVLCurrency swig_types[411]
#define SWIGTYPE_p_QuantLib__MTLCurrency swig_types[412]
#define SWIGTYPE_p_QuantLib__MXNCurrency swig_types[413]
#define SWIGTYPE_p_QuantLib__Mexico swig_types[414]
#define SWIGTYPE_p_QuantLib__NLGCurrency swig_types[415]
#define SWIGTYPE_p_QuantLib__NOKCurrency swig_types[416]
#define SWIGTYPE_p_QuantLib__NPRCurrency swig_types[417]
#define SWIGTYPE_p_QuantLib__NZDCurrency swig_types[418]
#define SWIGTYPE_p_QuantLib__NewZealand swig_types[419]
#define SWIGTYPE_p_QuantLib__Norway swig_types[420]
#define SWIGTYPE_p_QuantLib__NullCalendar swig_types[421]
#define SWIGTYPE_p_QuantLib__OneDayCounter swig_types[422]
#define SWIGTYPE_p_QuantLib__PKRCurrency swig_types[423]
#define SWIGTYPE_p_QuantLib__PLNCurrency swig_types[424]
#define SWIGTYPE_p_QuantLib__PTECurrency swig_types[425]
#define SWIGTYPE_p_QuantLib__Poland swig_types[426]
#define SWIGTYPE_p_QuantLib__ROLCurrency swig_types[427]
#define SWIGTYPE_p_QuantLib__RONCurrency swig_types[428]
#define SWIGTYPE_p_QuantLib__SARCurrency swig_types[429]
#define SWIGTYPE_p_QuantLib__SEKCurrency swig_types[430]
#define SWIGTYPE_p_QuantLib__SGDCurrency swig_types[431]
#define SWIGTYPE_p_QuantLib__SITCurrency swig_types[432]
#define SWIGTYPE_p_QuantLib__SKKCurrency swig_types[433]
#define SWIGTYPE_p_QuantLib__SaudiArabia swig_types[434]
#define SWIGTYPE_p_QuantLib__SimpleDayCounter swig_types[435]
#define SWIGTYPE_p_QuantLib__Singapore swig_types[436]
#define SWIGTYPE_p_QuantLib__Slovakia swig_types[437]
#define SWIGTYPE_p_QuantLib__SouthAfrica swig_types[438]
#define SWIGTYPE_p_QuantLib__SouthKorea swig_types[439]
#define SWIGTYPE_p_QuantLib__Sweden swig_types[440]
#define SWIGTYPE_p_QuantLib__Switzerland swig_types[441]
#define SWIGTYPE_p_QuantLib__TARGET swig_types[442]
#define SWIGTYPE_p_QuantLib__THBCurrency swig_types[443]
#define SWIGTYPE_p_QuantLib__TRLCurrency swig_types[444]
#define SWIGTYPE_p_QuantLib__TRYCurrency swig_types[445]
#define SWIGTYPE_p_QuantLib__TTDCurrency swig_types[446]
#define SWIGTYPE_p_QuantLib__TWDCurrency swig_types[447]
#define SWIGTYPE_p_QuantLib__Taiwan swig_types[448]
#define SWIGTYPE_p_QuantLib__Thirty360 swig_types[449]
#define SWIGTYPE_p_QuantLib__Turkey swig_types[450]
#define SWIGTYPE_p_QuantLib__USDCurrency swig_types[451]
#define SWIGTYPE_p_QuantLib__Ukraine swig_types[452]
#define SWIGTYPE_p_QuantLib__UnitedKingdom swig_types[453]
#define SWIGTYPE_p_QuantLib__UnitedStates swig_types[454]
#define SWIGTYPE_p_QuantLib__VEBCurrency swig_types[455]
#define SWIGTYPE_p_QuantLib__ZARCurrency swig_types[456]
#define SWIGTYPE_p_QuantoEuropeanEnginePtr swig_types[457]
#define SWIGTYPE_p_QuantoForwardEuropeanEnginePtr swig_types[458]
#define SWIGTYPE_p_QuantoForwardVanillaOptionPtr swig_types[459]
#define SWIGTYPE_p_QuantoVanillaOptionPtr swig_types[460]
#define SWIGTYPE_p_Quote swig_types[461]
#define SWIGTYPE_p_RandomSequenceGeneratorTKnuthUniformRng_t swig_types[462]
#define SWIGTYPE_p_RandomSequenceGeneratorTLecuyerUniformRng_t swig_types[463]
#define SWIGTYPE_p_RandomSequenceGeneratorTMersenneTwisterUniformRng_t swig_types[464]
#define SWIGTYPE_p_RateHelper swig_types[465]
#define SWIGTYPE_p_RelinkableHandleTBlackVolTermStructure_t swig_types[466]
#define SWIGTYPE_p_RelinkableHandleTCapFloorTermVolatilityStructure_t swig_types[467]
#define SWIGTYPE_p_RelinkableHandleTLocalVolTermStructure_t swig_types[468]
#define SWIGTYPE_p_RelinkableHandleTOptionletVolatilityStructure_t swig_types[469]
#define SWIGTYPE_p_RelinkableHandleTQuote_t swig_types[470]
#define SWIGTYPE_p_RelinkableHandleTShortRateModel_t swig_types[471]
#define SWIGTYPE_p_RelinkableHandleTSwaptionVolatilityStructure_t swig_types[472]
#define SWIGTYPE_p_RelinkableHandleTYieldTermStructure_t swig_types[473]
#define SWIGTYPE_p_Ridder swig_types[474]
#define SWIGTYPE_p_RiskStatistics swig_types[475]
#define SWIGTYPE_p_Rounding swig_types[476]
#define SWIGTYPE_p_SVD swig_types[477]
#define SWIGTYPE_p_SafeBackwardFlatInterpolation swig_types[478]
#define SWIGTYPE_p_SafeBicubicSpline swig_types[479]
#define SWIGTYPE_p_SafeBilinearInterpolation swig_types[480]
#define SWIGTYPE_p_SafeForwardFlatInterpolation swig_types[481]
#define SWIGTYPE_p_SafeLinearInterpolation swig_types[482]
#define SWIGTYPE_p_SafeLogLinearInterpolation swig_types[483]
#define SWIGTYPE_p_SafeNaturalCubicSpline swig_types[484]
#define SWIGTYPE_p_SafeNaturalMonotonicCubicSpline swig_types[485]
#define SWIGTYPE_p_SalvagingAlgorithm swig_types[486]
#define SWIGTYPE_p_SampleTArray_t swig_types[487]
#define SWIGTYPE_p_SampleTMultiPath_t swig_types[488]
#define SWIGTYPE_p_SampleTPath_t swig_types[489]
#define SWIGTYPE_p_SampleTdouble_t swig_types[490]
#define SWIGTYPE_p_SampleTstd__vectorTdouble_t_t swig_types[491]
#define SWIGTYPE_p_SampledCurve swig_types[492]
#define SWIGTYPE_p_Schedule swig_types[493]
#define SWIGTYPE_p_Secant swig_types[494]
#define SWIGTYPE_p_SegmentIntegral swig_types[495]
#define SWIGTYPE_p_Settings swig_types[496]
#define SWIGTYPE_p_Settlement swig_types[497]
#define SWIGTYPE_p_ShortRateModel swig_types[498]
#define SWIGTYPE_p_SimpleCashFlowPtr swig_types[499]
#define SWIGTYPE_p_SimpleQuotePtr swig_types[500]
#define SWIGTYPE_p_Simplex swig_types[501]
#define SWIGTYPE_p_SimpsonIntegral swig_types[502]
#define SWIGTYPE_p_SobolRsg swig_types[503]
#define SWIGTYPE_p_SoftCallabilityPtr swig_types[504]
#define SWIGTYPE_p_Statistics swig_types[505]
#define SWIGTYPE_p_SteepestDescent swig_types[506]
#define SWIGTYPE_p_StochasticProcess swig_types[507]
#define SWIGTYPE_p_StochasticProcess1DPtr swig_types[508]
#define SWIGTYPE_p_StochasticProcessArrayPtr swig_types[509]
#define SWIGTYPE_p_StockPtr swig_types[510]
#define SWIGTYPE_p_StulzEnginePtr swig_types[511]
#define SWIGTYPE_p_SuperSharePayoffPtr swig_types[512]
#define SWIGTYPE_p_Surface swig_types[513]
#define SWIGTYPE_p_SwapIndexPtr swig_types[514]
#define SWIGTYPE_p_SwapPtr swig_types[515]
#define SWIGTYPE_p_SwapRateHelperPtr swig_types[516]
#define SWIGTYPE_p_SwaptionHelperPtr swig_types[517]
#define SWIGTYPE_p_SwaptionPtr swig_types[518]
#define SWIGTYPE_p_SwaptionVolatilityMatrixPtr swig_types[519]
#define SWIGTYPE_p_SwaptionVolatilityStructure swig_types[520]
#define SWIGTYPE_p_TRLiborPtr swig_types[521]
#define SWIGTYPE_p_TestSurfacePtr swig_types[522]
#define SWIGTYPE_p_TiborPtr swig_types[523]
#define SWIGTYPE_p_TimeBasket swig_types[524]
#define SWIGTYPE_p_TimeGrid swig_types[525]
#define SWIGTYPE_p_TimeSeriesTIntervalPrice_std__mapTDate_IntervalPrice_t_t swig_types[526]
#define SWIGTYPE_p_TimeSeriesTdouble_std__mapTDate_double_t_t swig_types[527]
#define SWIGTYPE_p_TrapezoidIntegralTDefault_t swig_types[528]
#define SWIGTYPE_p_TrapezoidIntegralTMidPoint_t swig_types[529]
#define SWIGTYPE_p_TreeCapFloorEnginePtr swig_types[530]
#define SWIGTYPE_p_TreeSwaptionEnginePtr swig_types[531]
#define SWIGTYPE_p_TridiagonalOperator swig_types[532]
#define SWIGTYPE_p_USDLiborPtr swig_types[533]
#define SWIGTYPE_p_UniformLowDiscrepancySequenceGenerator swig_types[534]
#define SWIGTYPE_p_UniformRandomGenerator swig_types[535]
#define SWIGTYPE_p_UniformRandomSequenceGenerator swig_types[536]
#define SWIGTYPE_p_UpRounding swig_types[537]
#define SWIGTYPE_p_VanillaOptionPtr swig_types[538]
#define SWIGTYPE_p_VanillaSwapPtr swig_types[539]
#define SWIGTYPE_p_VasicekPtr swig_types[540]
#define SWIGTYPE_p_YieldTermStructure swig_types[541]
#define SWIGTYPE_p_ZeroCouponBondPtr swig_types[542]
#define SWIGTYPE_p_ZeroCurvePtr swig_types[543]
#define SWIGTYPE_p_ZeroSpreadedTermStructurePtr swig_types[544]
#define SWIGTYPE_p_ZeroYield swig_types[545]
#define SWIGTYPE_p_ZiborPtr swig_types[546]
#define SWIGTYPE_p_boost__shared_ptrTBlackVolTermStructure_t swig_types[547]
#define SWIGTYPE_p_boost__shared_ptrTCalibrationHelper_t swig_types[548]
#define SWIGTYPE_p_boost__shared_ptrTCallability_t swig_types[549]
#define SWIGTYPE_p_boost__shared_ptrTCapFloorTermVolatilityStructure_t swig_types[550]
#define SWIGTYPE_p_boost__shared_ptrTCashFlow_t swig_types[551]
#define SWIGTYPE_p_boost__shared_ptrTDefaultBoundaryCondition_t swig_types[552]
#define SWIGTYPE_p_boost__shared_ptrTDividend_t swig_types[553]
#define SWIGTYPE_p_boost__shared_ptrTDomain_t swig_types[554]
#define SWIGTYPE_p_boost__shared_ptrTExercise_t swig_types[555]
#define SWIGTYPE_p_boost__shared_ptrTIndex_t swig_types[556]
#define SWIGTYPE_p_boost__shared_ptrTInstrument_t swig_types[557]
#define SWIGTYPE_p_boost__shared_ptrTLocalVolTermStructure_t swig_types[558]
#define SWIGTYPE_p_boost__shared_ptrTObservable_t swig_types[559]
#define SWIGTYPE_p_boost__shared_ptrTOptionletVolatilityStructure_t swig_types[560]
#define SWIGTYPE_p_boost__shared_ptrTPayoff_t swig_types[561]
#define SWIGTYPE_p_boost__shared_ptrTPricingEngine_t swig_types[562]
#define SWIGTYPE_p_boost__shared_ptrTQuote_t swig_types[563]
#define SWIGTYPE_p_boost__shared_ptrTRateHelper_t swig_types[564]
#define SWIGTYPE_p_boost__shared_ptrTShortRateModel_t swig_types[565]
#define SWIGTYPE_p_boost__shared_ptrTStochasticProcess_t swig_types[566]
#define SWIGTYPE_p_boost__shared_ptrTSurface_t swig_types[567]
#define SWIGTYPE_p_boost__shared_ptrTSwaptionVolatilityStructure_t swig_types[568]
#define SWIGTYPE_p_boost__shared_ptrTYieldTermStructure_t swig_types[569]
#define SWIGTYPE_p_double swig_types[570]
#define SWIGTYPE_p_doubleOrNull swig_types[571]
#define SWIGTYPE_p_int swig_types[572]
#define SWIGTYPE_p_intOrNull swig_types[573]
#define SWIGTYPE_p_std__basic_stringTchar_t swig_types[574]
#define SWIGTYPE_p_std__basic_stringTwchar_t_t swig_types[575]
#define SWIGTYPE_p_std__pairTDate_double_t swig_types[576]
#define SWIGTYPE_p_std__size_t swig_types[577]
#define SWIGTYPE_p_std__vectorTDate_t swig_types[578]
#define SWIGTYPE_p_std__vectorTHandleTBlackVolTermStructure_t_t swig_types[579]
#define SWIGTYPE_p_std__vectorTHandleTQuote_t_t swig_types[580]
#define SWIGTYPE_p_std__vectorTHandleTYieldTermStructure_t_t swig_types[581]
#define SWIGTYPE_p_std__vectorTIntervalPrice_t swig_types[582]
#define SWIGTYPE_p_std__vectorTPeriod_t swig_types[583]
#define SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t swig_types[584]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTCalibrationHelper_t_t swig_types[585]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTCallability_t_t swig_types[586]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTCashFlow_t_t swig_types[587]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTDividend_t_t swig_types[588]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t swig_types[589]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTRateHelper_t_t swig_types[590]
#define SWIGTYPE_p_std__vectorTboost__shared_ptrTStochasticProcess_t_t swig_types[591]
#define SWIGTYPE_p_std__vectorTdouble_t swig_types[592]
#define SWIGTYPE_p_std__vectorTint_t swig_types[593]
#define SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t swig_types[594]
#define SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t swig_types[595]
#define SWIGTYPE_p_std__vectorTunsigned_int_t swig_types[596]
#define SWIGTYPE_p_wchar_t swig_types[597]
static swig_type_info *swig_types[599];
static swig_module_info swig_module = {swig_types, 598, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */


#define OCAML_MSG_BUF_LEN 1024
SWIGINTERN void SWIG_exception_(int code, const char *msg) {
  char msg_buf[OCAML_MSG_BUF_LEN];
  sprintf( msg_buf, "Exception(%d): %s\n", code, msg );
  failwith( msg_buf );
}
#define SWIG_exception(a,b) SWIG_exception_((a),(b))


#include <stdexcept>


#include <ql/quantlib.hpp>

#if QL_HEX_VERSION < 0x000900f0
    #error using an old version of QuantLib, please update
#endif

// add here SWIG version check

#if defined(_MSC_VER)         // Microsoft Visual C++ 6.0
// disable Swig-dependent warnings

// 'identifier1' has C-linkage specified,
// but returns UDT 'identifier2' which is incompatible with C
#pragma warning(disable: 4190)

// 'int' : forcing value to bool 'true' or 'false' (performance warning)
#pragma warning(disable: 4800)

// debug info too long etc etc
#pragma warning(disable: 4786)
#endif


#include <stdexcept>


#include <string>
    CAML_VALUE SwigString_FromString(const std::string& s) {
	return caml_val_string((char *)s.c_str());
    }
    std::string SwigString_AsString(CAML_VALUE o) {
	return std::string((char *)caml_ptr_val(o,0));
    }


#include <string>
#include <vector>
    using std::string;
    using std::vector;


#include <vector>
#include <algorithm>
#include <stdexcept>

SWIGINTERN bool std_basic_string_Sl_char_Sg__operator_Se__Se_(std::basic_string<char > const *self,std::basic_string<char > const &other){
		return self->compare( other ) == 0;
	    }
SWIGINTERN bool std_basic_string_Sl_char_Sg__operator_SN__Se_(std::basic_string<char > const *self,std::basic_string<char > const &other){
		return self->compare( other ) != 0;
	    }
SWIGINTERN bool std_basic_string_Sl_char_Sg__operator_Sl_(std::basic_string<char > const *self,std::basic_string<char > const &other){
		return self->compare( other ) == -1;
	    }
SWIGINTERN bool std_basic_string_Sl_char_Sg__operator_Sg_(std::basic_string<char > const *self,std::basic_string<char > const &other){
		return self->compare( other ) == 1;
	    }
SWIGINTERN bool std_basic_string_Sl_char_Sg__operator_Sl__Se_(std::basic_string<char > const *self,std::basic_string<char > const &other){
		return self->compare( other ) != 1;
	    }
SWIGINTERN bool std_basic_string_Sl_char_Sg__operator_Sg__Se_(std::basic_string<char > const *self,std::basic_string<char > const &other){
		return self->compare( other ) != -1;
	    }
SWIGINTERN bool std_basic_string_Sl_wchar_t_Sg__operator_Se__Se_(std::basic_string<wchar_t > const *self,std::basic_string<wchar_t > const &other){
		return self->compare( other ) == 0;
	    }
SWIGINTERN bool std_basic_string_Sl_wchar_t_Sg__operator_SN__Se_(std::basic_string<wchar_t > const *self,std::basic_string<wchar_t > const &other){
		return self->compare( other ) != 0;
	    }
SWIGINTERN bool std_basic_string_Sl_wchar_t_Sg__operator_Sl_(std::basic_string<wchar_t > const *self,std::basic_string<wchar_t > const &other){
		return self->compare( other ) == -1;
	    }
SWIGINTERN bool std_basic_string_Sl_wchar_t_Sg__operator_Sg_(std::basic_string<wchar_t > const *self,std::basic_string<wchar_t > const &other){
		return self->compare( other ) == 1;
	    }
SWIGINTERN bool std_basic_string_Sl_wchar_t_Sg__operator_Sl__Se_(std::basic_string<wchar_t > const *self,std::basic_string<wchar_t > const &other){
		return self->compare( other ) != 1;
	    }
SWIGINTERN bool std_basic_string_Sl_wchar_t_Sg__operator_Sg__Se_(std::basic_string<wchar_t > const *self,std::basic_string<wchar_t > const &other){
		return self->compare( other ) != -1;
	    }

#include <map>
#include <algorithm>
#include <stdexcept>


#include <utility>


#include <boost/algorithm/string/case_conv.hpp>


// generally useful classes
using QuantLib::Error;
using QuantLib::Handle;
using QuantLib::RelinkableHandle;


using QuantLib::Integer;
using QuantLib::BigInteger;
using QuantLib::Natural;
using QuantLib::BigNatural;
using QuantLib::Real;
using QuantLib::Decimal;
using QuantLib::Time;
using QuantLib::Rate;
using QuantLib::Spread;
using QuantLib::DiscountFactor;
using QuantLib::Volatility;
using QuantLib::Size;


using QuantLib::Day;
using QuantLib::Year;


using QuantLib::Weekday;
using QuantLib::Sunday;
using QuantLib::Monday;
using QuantLib::Tuesday;
using QuantLib::Wednesday;
using QuantLib::Thursday;
using QuantLib::Friday;
using QuantLib::Saturday;

static int SWIG_ENUM__Sunday = Sunday;
static int SWIG_ENUM__Monday = Monday;
static int SWIG_ENUM__Tuesday = Tuesday;
static int SWIG_ENUM__Wednesday = Wednesday;
static int SWIG_ENUM__Thursday = Thursday;
static int SWIG_ENUM__Friday = Friday;
static int SWIG_ENUM__Saturday = Saturday;

using QuantLib::Month;
using QuantLib::January;
using QuantLib::February;
using QuantLib::March;
using QuantLib::April;
using QuantLib::May;
using QuantLib::June;
using QuantLib::July;
using QuantLib::August;
using QuantLib::September;
using QuantLib::October;
using QuantLib::November;
using QuantLib::December;

static int SWIG_ENUM__January = January;
static int SWIG_ENUM__February = February;
static int SWIG_ENUM__March = March;
static int SWIG_ENUM__April = April;
static int SWIG_ENUM__May = May;
static int SWIG_ENUM__June = June;
static int SWIG_ENUM__July = July;
static int SWIG_ENUM__August = August;
static int SWIG_ENUM__September = September;
static int SWIG_ENUM__October = October;
static int SWIG_ENUM__November = November;
static int SWIG_ENUM__December = December;

using QuantLib::TimeUnit;
using QuantLib::Days;
using QuantLib::Weeks;
using QuantLib::Months;
using QuantLib::Years;

static int SWIG_ENUM__Days = Days;
static int SWIG_ENUM__Weeks = Weeks;
static int SWIG_ENUM__Months = Months;
static int SWIG_ENUM__Years = Years;

using QuantLib::Frequency;
using QuantLib::NoFrequency;
using QuantLib::Once;
using QuantLib::Annual;
using QuantLib::Semiannual;
using QuantLib::EveryFourthMonth;
using QuantLib::Quarterly;
using QuantLib::Bimonthly;
using QuantLib::Monthly;
using QuantLib::Biweekly;
using QuantLib::Weekly;
using QuantLib::Daily;

static int SWIG_ENUM__NoFrequency = NoFrequency;
static int SWIG_ENUM__Once = Once;
static int SWIG_ENUM__Annual = Annual;
static int SWIG_ENUM__Semiannual = Semiannual;
static int SWIG_ENUM__EveryFourthMonth = EveryFourthMonth;
static int SWIG_ENUM__Quarterly = Quarterly;
static int SWIG_ENUM__Bimonthly = Bimonthly;
static int SWIG_ENUM__Monthly = Monthly;
static int SWIG_ENUM__Biweekly = Biweekly;
static int SWIG_ENUM__Weekly = Weekly;
static int SWIG_ENUM__Daily = Daily;

using QuantLib::Period;
using QuantLib::PeriodParser;

SWIGINTERN Period *new_Period__SWIG_3(std::string const &str){
            return new Period(PeriodParser::parse(str));
        }
SWIGINTERN std::string Period___str__(Period *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Period___repr__(Period *self){
            std::ostringstream out;
            out << "Period(\"" << QuantLib::io::short_period(*self) << "\")";
            return out.str();
        }
SWIGINTERN void std_vector_Sl_Period_Sg__set(std::vector<Period > *self,int i,Period const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN Period *std_vector_Sl_Period_Sg__to_array(std::vector<Period > *self){
		Period *array = new Period[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

using QuantLib::Date;
using QuantLib::DateParser;

SWIGINTERN Date *new_Date__SWIG_3(std::string const &str,std::string const &fmt){
            return new Date(DateParser::parse(str,fmt));
        }
SWIGINTERN Integer Date_weekdayNumber(Date *self){
            return int(self->weekday());
        }
SWIGINTERN std::string Date___str__(Date *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }
SWIGINTERN std::string Date___repr__(Date *self){
            std::ostringstream out;
            if (*self == Date())
                out << "Date()";
            else
                out << "Date(" << self->dayOfMonth() << ","
                    << int(self->month()) << "," << self->year() << ")";
            return out.str();
        }
SWIGINTERN std::string Date_ISO(Date *self){
            std::ostringstream out;
            out << QuantLib::io::iso_date(*self);
            return out.str();
        }
SWIGINTERN void std_vector_Sl_Date_Sg__set(std::vector<Date > *self,int i,Date const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN Date *std_vector_Sl_Date_Sg__to_array(std::vector<Date > *self){
		Date *array = new Date[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

using QuantLib::IMM;

static int SWIG_ENUM__IMM__F = IMM::F;
static int SWIG_ENUM__IMM__G = IMM::G;
static int SWIG_ENUM__IMM__H = IMM::H;
static int SWIG_ENUM__IMM__J = IMM::J;
static int SWIG_ENUM__IMM__K = IMM::K;
static int SWIG_ENUM__IMM__M = IMM::M;
static int SWIG_ENUM__IMM__N = IMM::N;
static int SWIG_ENUM__IMM__Q = IMM::Q;
static int SWIG_ENUM__IMM__U = IMM::U;
static int SWIG_ENUM__IMM__V = IMM::V;
static int SWIG_ENUM__IMM__X = IMM::X;
static int SWIG_ENUM__IMM__Z = IMM::Z;
SWIGINTERN void std_vector_Sl_int_Sg__set(std::vector<int > *self,int i,int const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN int *std_vector_Sl_int_Sg__to_array(std::vector<int > *self){
		int *array = new int[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }
SWIGINTERN void std_vector_Sl_double_Sg__set(std::vector<double > *self,int i,double const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN double *std_vector_Sl_double_Sg__to_array(std::vector<double > *self){
		double *array = new double[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }
SWIGINTERN void std_vector_Sl_string_Sg__set(std::vector<string > *self,int i,std::basic_string<char > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN std::basic_string<char > *std_vector_Sl_string_Sg__to_array(std::vector<string > *self){
		std::basic_string<char > *array = new std::basic_string<char >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }
SWIGINTERN void std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__set(std::vector<std::pair<Date,double > > *self,int i,std::pair<Date,double > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN std::pair<Date,double > *std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__to_array(std::vector<std::pair<Date,double > > *self){
		std::pair<Date,double > *array = new std::pair<Date,double >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

using QuantLib::Exercise;

SWIGINTERN bool boost_shared_ptr_Sl_Exercise_Sg__isNull(boost::shared_ptr<Exercise > *self){
                return !(*self);
            }
static enum Exercise::Type _swig_wrap_Exercise_xxAmerican = Exercise::American;
static enum Exercise::Type _swig_wrap_Exercise_xxBermudan = Exercise::Bermudan;
static enum Exercise::Type _swig_wrap_Exercise_xxEuropean = Exercise::European;

using QuantLib::EuropeanExercise;
using QuantLib::AmericanExercise;
using QuantLib::BermudanExercise;
typedef boost::shared_ptr<Exercise> EuropeanExercisePtr;
typedef boost::shared_ptr<Exercise> AmericanExercisePtr;
typedef boost::shared_ptr<Exercise> BermudanExercisePtr;

SWIGINTERN EuropeanExercisePtr *new_EuropeanExercisePtr(Date const &date){
            return new EuropeanExercisePtr(new EuropeanExercise(date));
        }
SWIGINTERN AmericanExercisePtr *new_AmericanExercisePtr__SWIG_0(Date const &earliestDate,Date const &latestDate,bool payoffAtExpiry=false){
            return new AmericanExercisePtr(
                                        new AmericanExercise(earliestDate,
                                                             latestDate,
                                                             payoffAtExpiry));
        }
SWIGINTERN BermudanExercisePtr *new_BermudanExercisePtr__SWIG_0(std::vector<Date > const &dates,bool payoffAtExpiry=false){
            return new BermudanExercisePtr(
                                        new BermudanExercise(dates,
                                                             payoffAtExpiry));
        }

using QuantLib::Observer;
using QuantLib::Observable;

SWIGINTERN bool boost_shared_ptr_Sl_Observable_Sg__isNull(boost::shared_ptr<Observable > *self){
                return !(*self);
            }

using QuantLib::Array;
using QuantLib::Matrix;
using QuantLib::SampledCurve;

SWIGINTERN std::string Array___str__(Array *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

typedef QuantLib::LexicographicalView<Array::iterator>
    DefaultLexicographicalView;
typedef QuantLib::LexicographicalView<Array::iterator>::y_iterator
    DefaultLexicographicalViewColumn;

SWIGINTERN DefaultLexicographicalView *new_DefaultLexicographicalView(Array &a,Size xSize){
            return new DefaultLexicographicalView(a.begin(),a.end(),xSize);
        }
SWIGINTERN std::string DefaultLexicographicalView___str__(DefaultLexicographicalView *self){
            std::ostringstream s;
            for (Size j=0; j<self->ySize(); j++) {
                s << "\n";
                for (Size i=0; i<self->xSize(); i++) {
                    if (i != 0)
                        s << ",";
                    s << (*self)[i][j];
                }
            }
            s << "\n";
            return s.str();
        }

typedef QuantLib::Matrix::row_iterator MatrixRow;
using QuantLib::outerProduct;
using QuantLib::transpose;
using QuantLib::SVD;

SWIGINTERN std::string Matrix___str__(Matrix *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

using QuantLib::pseudoSqrt;
using QuantLib::SalvagingAlgorithm;

static int SWIG_ENUM__SalvagingAlgorithm__None = SalvagingAlgorithm::None;
static int SWIG_ENUM__SalvagingAlgorithm__Spectral = SalvagingAlgorithm::Spectral;

using QuantLib::CostFunction;
using QuantLib::Disposable;


using QuantLib::Quote;

SWIGINTERN bool boost_shared_ptr_Sl_Quote_Sg__isNull(boost::shared_ptr<Quote > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_Quote_Sg__asObservable(boost::shared_ptr<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_Quote_Sg__asObservable(Handle<Quote > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleQuote;
typedef boost::shared_ptr<Quote> SimpleQuotePtr;

SWIGINTERN SimpleQuotePtr *new_SimpleQuotePtr(Real value){
            return new SimpleQuotePtr(new SimpleQuote(value));
        }
SWIGINTERN void SimpleQuotePtr_setValue(SimpleQuotePtr *self,Real value){
            boost::dynamic_pointer_cast<SimpleQuote>(*self)->setValue(value);
        }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(std::vector<boost::shared_ptr<Quote > > *self,int i,boost::shared_ptr<Quote > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN boost::shared_ptr<Quote > *std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__to_array(std::vector<boost::shared_ptr<Quote > > *self){
		boost::shared_ptr<Quote > *array = new boost::shared_ptr<Quote >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }
SWIGINTERN void std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(std::vector<Handle<Quote > > *self,int i,Handle<Quote > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN Handle<Quote > *std_vector_Sl_Handle_Sl_Quote_Sg__Sg__to_array(std::vector<Handle<Quote > > *self){
		Handle<Quote > *array = new Handle<Quote >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }
SWIGINTERN void std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__set(std::vector<RelinkableHandle<Quote > > *self,int i,RelinkableHandle<Quote > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN RelinkableHandle<Quote > *std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__to_array(std::vector<RelinkableHandle<Quote > > *self){
		RelinkableHandle<Quote > *array = new RelinkableHandle<Quote >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

using QuantLib::Null;
typedef int intOrNull;
typedef double doubleOrNull;


int nullInt() { return Null<int>(); }
double nullDouble() { return Null<double>(); }


using QuantLib::DayCounter;

SWIGINTERN std::string DayCounter___str__(DayCounter *self){
            return self->name()+" day counter";
        }
static int SWIG_ENUM__QuantLib__Thirty360__USA = QuantLib::Thirty360::USA;
static int SWIG_ENUM__QuantLib__Thirty360__BondBasis = QuantLib::Thirty360::BondBasis;
static int SWIG_ENUM__QuantLib__Thirty360__European = QuantLib::Thirty360::European;
static int SWIG_ENUM__QuantLib__Thirty360__EurobondBasis = QuantLib::Thirty360::EurobondBasis;
static int SWIG_ENUM__QuantLib__Thirty360__Italian = QuantLib::Thirty360::Italian;
static int SWIG_ENUM__QuantLib__ActualActual__ISMA = QuantLib::ActualActual::ISMA;
static int SWIG_ENUM__QuantLib__ActualActual__Bond = QuantLib::ActualActual::Bond;
static int SWIG_ENUM__QuantLib__ActualActual__ISDA = QuantLib::ActualActual::ISDA;
static int SWIG_ENUM__QuantLib__ActualActual__Historical = QuantLib::ActualActual::Historical;
static int SWIG_ENUM__QuantLib__ActualActual__Actual365 = QuantLib::ActualActual::Actual365;
static int SWIG_ENUM__QuantLib__ActualActual__AFB = QuantLib::ActualActual::AFB;
static int SWIG_ENUM__QuantLib__ActualActual__Euro = QuantLib::ActualActual::Euro;

using QuantLib::Compounding;
using QuantLib::Simple;
using QuantLib::Compounded;
using QuantLib::Continuous;
using QuantLib::SimpleThenCompounded;

static int SWIG_ENUM__Simple = Simple;
static int SWIG_ENUM__Compounded = Compounded;
static int SWIG_ENUM__Continuous = Continuous;
static int SWIG_ENUM__SimpleThenCompounded = SimpleThenCompounded;

using QuantLib::InterestRate;

SWIGINTERN std::string InterestRate___str__(InterestRate *self){
            std::ostringstream out;
            out << *self;
            return out.str();
        }

using QuantLib::Calendar;


using QuantLib::BusinessDayConvention;
using QuantLib::Unadjusted;
using QuantLib::ModifiedFollowing;
using QuantLib::Preceding;
using QuantLib::ModifiedPreceding;
using QuantLib::Following;

static int SWIG_ENUM__Following = Following;
static int SWIG_ENUM__ModifiedFollowing = ModifiedFollowing;
static int SWIG_ENUM__Preceding = Preceding;
static int SWIG_ENUM__ModifiedPreceding = ModifiedPreceding;
static int SWIG_ENUM__Unadjusted = Unadjusted;

using QuantLib::JointCalendarRule;
using QuantLib::JoinHolidays;
using QuantLib::JoinBusinessDays;

static int SWIG_ENUM__JoinHolidays = JoinHolidays;
static int SWIG_ENUM__JoinBusinessDays = JoinBusinessDays;
SWIGINTERN std::string Calendar___str__(Calendar *self){
            return self->name()+" calendar";
        }
static int SWIG_ENUM__QuantLib__Argentina__Merval = QuantLib::Argentina::Merval;
static int SWIG_ENUM__Settlement = QuantLib::Brazil::Settlement;
static int SWIG_ENUM__QuantLib__Brazil__Exchange = QuantLib::Brazil::Exchange;
static int SWIG_ENUM__QuantLib__Canada__TSX = QuantLib::Canada::TSX;
static int SWIG_ENUM__QuantLib__CzechRepublic__PSE = QuantLib::CzechRepublic::PSE;
static int SWIG_ENUM__QuantLib__Germany__FrankfurtStockExchange = QuantLib::Germany::FrankfurtStockExchange;
static int SWIG_ENUM__QuantLib__Germany__Xetra = QuantLib::Germany::Xetra;
static int SWIG_ENUM__QuantLib__Germany__Eurex = QuantLib::Germany::Eurex;
static int SWIG_ENUM__QuantLib__HongKong__HKEx = QuantLib::HongKong::HKEx;
static int SWIG_ENUM__QuantLib__Iceland__ICEX = QuantLib::Iceland::ICEX;
static int SWIG_ENUM__QuantLib__India__NSE = QuantLib::India::NSE;
static int SWIG_ENUM__QuantLib__Indonesia__BEJ = QuantLib::Indonesia::BEJ;
static int SWIG_ENUM__QuantLib__Indonesia__JSX = QuantLib::Indonesia::JSX;
static int SWIG_ENUM__QuantLib__Mexico__BMV = QuantLib::Mexico::BMV;
static int SWIG_ENUM__QuantLib__SaudiArabia__Tadawul = QuantLib::SaudiArabia::Tadawul;
static int SWIG_ENUM__QuantLib__Singapore__SGX = QuantLib::Singapore::SGX;
static int SWIG_ENUM__QuantLib__Slovakia__BSSE = QuantLib::Slovakia::BSSE;
static int SWIG_ENUM__QuantLib__SouthKorea__KRX = QuantLib::SouthKorea::KRX;
static int SWIG_ENUM__QuantLib__Taiwan__TSEC = QuantLib::Taiwan::TSEC;
static int SWIG_ENUM__QuantLib__Ukraine__USE = QuantLib::Ukraine::USE;
static int SWIG_ENUM__QuantLib__UnitedKingdom__Metals = QuantLib::UnitedKingdom::Metals;
static int SWIG_ENUM__QuantLib__UnitedStates__NYSE = QuantLib::UnitedStates::NYSE;
static int SWIG_ENUM__QuantLib__UnitedStates__GovernmentBond = QuantLib::UnitedStates::GovernmentBond;
static int SWIG_ENUM__QuantLib__UnitedStates__NERC = QuantLib::UnitedStates::NERC;

using QuantLib::Rounding;
using QuantLib::UpRounding;
using QuantLib::DownRounding;
using QuantLib::ClosestRounding;
using QuantLib::CeilingTruncation;
using QuantLib::FloorTruncation;


using QuantLib::Currency;

SWIGINTERN std::string Currency___str__(Currency *self){
            return self->name();
        }

using QuantLib::Extrapolator;


// safe versions which copy their arguments
template <class I>
class SafeInterpolation {
  public:
    SafeInterpolation(const Array& x, const Array& y)
    : x_(x), y_(y), f_(x_.begin(),x_.end(),y_.begin()) {}
    Real operator()(Real x, bool allowExtrapolation=false) {
        return f_(x, allowExtrapolation);
    }
    Array x_, y_;
    I f_;
};


typedef SafeInterpolation<QuantLib::LinearInterpolation> SafeLinearInterpolation;


typedef SafeInterpolation<QuantLib::LogLinearInterpolation> SafeLogLinearInterpolation;


typedef SafeInterpolation<QuantLib::BackwardFlatInterpolation> SafeBackwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::ForwardFlatInterpolation> SafeForwardFlatInterpolation;


typedef SafeInterpolation<QuantLib::NaturalCubicSpline> SafeNaturalCubicSpline;

SWIGINTERN Real SafeNaturalCubicSpline_derivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeNaturalCubicSpline_secondDerivative__SWIG_0(SafeNaturalCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

typedef SafeInterpolation<QuantLib::NaturalMonotonicCubicSpline> SafeNaturalMonotonicCubicSpline;

SWIGINTERN Real SafeNaturalMonotonicCubicSpline_derivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.derivative(x,extrapolate);
    }
SWIGINTERN Real SafeNaturalMonotonicCubicSpline_secondDerivative__SWIG_0(SafeNaturalMonotonicCubicSpline *self,Real x,bool extrapolate=false){
        return self->f_.secondDerivative(x,extrapolate);
    }

// safe versions which copy their arguments
template <class I>
class SafeInterpolation2D {
  public:
    SafeInterpolation2D(const Array& x, const Array& y, const Matrix& m)
    : x_(x), y_(y), m_(m), f_(x_.begin(),x_.end(),y_.begin(),y_.end(),m_) {}
    Real operator()(Real x, Real y, bool allowExtrapolation=false) {
        return f_(x,y, allowExtrapolation);
    }
  protected:
    Array x_, y_;
    Matrix m_;
    I f_;
};


typedef SafeInterpolation2D<QuantLib::BilinearInterpolation> SafeBilinearInterpolation;


typedef SafeInterpolation2D<QuantLib::BicubicSpline> SafeBicubicSpline;


using QuantLib::BackwardFlat;
using QuantLib::ForwardFlat;
using QuantLib::Linear;
using QuantLib::LogLinear;
using QuantLib::CubicSpline;


using QuantLib::YieldTermStructure;

SWIGINTERN bool boost_shared_ptr_Sl_YieldTermStructure_Sg__isNull(boost::shared_ptr<YieldTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_YieldTermStructure_Sg__asObservable(boost::shared_ptr<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_YieldTermStructure_Sg__asObservable(Handle<YieldTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::ImpliedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ImpliedTermStructurePtr;

SWIGINTERN ImpliedTermStructurePtr *new_ImpliedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Date const &referenceDate){
            return new ImpliedTermStructurePtr(
                new ImpliedTermStructure(curveHandle, referenceDate));
        }

using QuantLib::ZeroSpreadedTermStructure;
using QuantLib::ForwardSpreadedTermStructure;
typedef boost::shared_ptr<YieldTermStructure> ZeroSpreadedTermStructurePtr;
typedef boost::shared_ptr<YieldTermStructure> ForwardSpreadedTermStructurePtr;

SWIGINTERN ZeroSpreadedTermStructurePtr *new_ZeroSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
            return new ZeroSpreadedTermStructurePtr(
                new ZeroSpreadedTermStructure(curveHandle,spreadHandle));
        }
SWIGINTERN ForwardSpreadedTermStructurePtr *new_ForwardSpreadedTermStructurePtr(Handle<YieldTermStructure > const &curveHandle,Handle<Quote > const &spreadHandle){
            return new ForwardSpreadedTermStructurePtr(
                new ForwardSpreadedTermStructure(curveHandle,spreadHandle));
        }

using QuantLib::FlatForward;
typedef boost::shared_ptr<YieldTermStructure> FlatForwardPtr;

SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_0(Date const &referenceDate,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_3(Date const &referenceDate,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                           new FlatForward(referenceDate,forward,dayCounter,
                                           compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_6(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }
SWIGINTERN FlatForwardPtr *new_FlatForwardPtr__SWIG_9(Integer settlementDays,Calendar const &calendar,Rate forward,DayCounter const &dayCounter,Compounding compounding=QuantLib::Continuous,Frequency frequency=QuantLib::Annual){
            return new FlatForwardPtr(
                 new FlatForward(settlementDays,calendar,forward,dayCounter,
                                 compounding,frequency));
        }

using QuantLib::BlackVolTermStructure;
using QuantLib::LocalVolTermStructure;
using QuantLib::OptionletVolatilityStructure;
using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_BlackVolTermStructure_Sg__isNull(boost::shared_ptr<BlackVolTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_BlackVolTermStructure_Sg__asObservable(boost::shared_ptr<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_BlackVolTermStructure_Sg__asObservable(Handle<BlackVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN bool boost_shared_ptr_Sl_LocalVolTermStructure_Sg__isNull(boost::shared_ptr<LocalVolTermStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_LocalVolTermStructure_Sg__asObservable(boost::shared_ptr<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_LocalVolTermStructure_Sg__asObservable(Handle<LocalVolTermStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN bool boost_shared_ptr_Sl_OptionletVolatilityStructure_Sg__isNull(boost::shared_ptr<OptionletVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_OptionletVolatilityStructure_Sg__asObservable(boost::shared_ptr<OptionletVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_OptionletVolatilityStructure_Sg__asObservable(Handle<OptionletVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SwaptionVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__isNull(boost::shared_ptr<SwaptionVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_SwaptionVolatilityStructure_Sg__asObservable(boost::shared_ptr<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_SwaptionVolatilityStructure_Sg__asObservable(Handle<SwaptionVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::BlackConstantVol;
typedef boost::shared_ptr<BlackVolTermStructure> BlackConstantVolPtr;

SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_0(Date const &referenceDate,Calendar const &c,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, c,
		volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_1(Date const &referenceDate,Calendar const &c,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(referenceDate, c, 
		volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_2(Natural settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
SWIGINTERN BlackConstantVolPtr *new_BlackConstantVolPtr__SWIG_3(Natural settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new BlackConstantVolPtr(
                new BlackConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::BlackVarianceSurface;
typedef boost::shared_ptr<BlackVolTermStructure> BlackVarianceSurfacePtr;

SWIGINTERN BlackVarianceSurfacePtr *new_BlackVarianceSurfacePtr__SWIG_0(Date const &referenceDate,Calendar const &cal,std::vector<Date > const &dates,std::vector<Real > const &strikes,Matrix const &blackVols,DayCounter const &dayCounter,BlackVarianceSurface::Extrapolation lower=BlackVarianceSurface::InterpolatorDefaultExtrapolation,BlackVarianceSurface::Extrapolation upper=BlackVarianceSurface::InterpolatorDefaultExtrapolation){
            return new BlackVarianceSurfacePtr(
                new BlackVarianceSurface(referenceDate,cal,
					dates,strikes,
				blackVols,dayCounter,lower,upper));
        }
static enum BlackVarianceSurface::Extrapolation _swig_wrap_BlackVarianceSurface_xxConstantExtrapolation = BlackVarianceSurface::ConstantExtrapolation;
static enum BlackVarianceSurface::Extrapolation _swig_wrap_BlackVarianceSurface_xxInterpolatorDefaultExtrapolation = BlackVarianceSurface::InterpolatorDefaultExtrapolation;

using QuantLib::LocalConstantVol;
typedef boost::shared_ptr<LocalVolTermStructure> LocalConstantVolPtr;

SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(referenceDate, volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_2(Integer settlementDays,Calendar const &calendar,Volatility volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }
SWIGINTERN LocalConstantVolPtr *new_LocalConstantVolPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,Handle<Quote > const &volatility,DayCounter const &dayCounter){
            return new LocalConstantVolPtr(
                new LocalConstantVol(settlementDays, calendar,
                                     volatility, dayCounter));
        }

using QuantLib::ConstantOptionletVol;
typedef boost::shared_ptr<OptionletVolatilityStructure>
    ConstantOptionletVolPtr;

SWIGINTERN ConstantOptionletVolPtr *new_ConstantOptionletVolPtr__SWIG_0(Date const &referenceDate,Volatility volatility,Calendar const &cal,DayCounter const &dayCounter){
            return new ConstantOptionletVolPtr(
                new ConstantOptionletVol(referenceDate, volatility,cal,
                                             dayCounter));
        }
SWIGINTERN ConstantOptionletVolPtr *new_ConstantOptionletVolPtr__SWIG_1(Date const &referenceDate,Handle<Quote > const &volatility,Calendar const &cal,DayCounter const &dayCounter){
            return new ConstantOptionletVolPtr(
                new ConstantOptionletVol(referenceDate, volatility,
                                    	cal, dayCounter));
        }
SWIGINTERN ConstantOptionletVolPtr *new_ConstantOptionletVolPtr__SWIG_2(Volatility volatility,Calendar const &cal,DayCounter const &dayCounter){
            return new ConstantOptionletVolPtr(
                new ConstantOptionletVol(volatility, cal, dayCounter));
        }
SWIGINTERN ConstantOptionletVolPtr *new_ConstantOptionletVolPtr__SWIG_3(Handle<Quote > const &volatility,Calendar const &cal,DayCounter const &dayCounter){
            return new ConstantOptionletVolPtr(
                new ConstantOptionletVol(volatility, cal, dayCounter));
        }

using QuantLib::SwaptionVolatilityMatrix;
typedef boost::shared_ptr<SwaptionVolatilityStructure>
    SwaptionVolatilityMatrixPtr;

SWIGINTERN SwaptionVolatilityMatrixPtr *new_SwaptionVolatilityMatrixPtr(Date const &referenceDate,std::vector<Date > const &dates,std::vector<Period > const &lengths,Matrix const &vols,DayCounter const &dayCounter){
            return new SwaptionVolatilityMatrixPtr(
                new SwaptionVolatilityMatrix(referenceDate,dates,lengths,
                                             vols,dayCounter));
        }

using QuantLib::StochasticProcess;

SWIGINTERN bool boost_shared_ptr_Sl_StochasticProcess_Sg__isNull(boost::shared_ptr<StochasticProcess > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_StochasticProcess_Sg__asObservable(boost::shared_ptr<StochasticProcess > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::StochasticProcess1D;
typedef boost::shared_ptr<StochasticProcess> StochasticProcess1DPtr;


using QuantLib::GeneralizedBlackScholesProcess;
typedef boost::shared_ptr<StochasticProcess> GeneralizedBlackScholesProcessPtr;

SWIGINTERN GeneralizedBlackScholesProcessPtr *new_GeneralizedBlackScholesProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new GeneralizedBlackScholesProcessPtr(
                       new GeneralizedBlackScholesProcess(s0, dividendTS,
                                                          riskFreeTS, volTS));
      }

using QuantLib::BlackScholesProcess;
typedef boost::shared_ptr<StochasticProcess> BlackScholesProcessPtr;

SWIGINTERN BlackScholesProcessPtr *new_BlackScholesProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackScholesProcessPtr(
                            new BlackScholesProcess(s0, riskFreeTS, volTS));
      }

using QuantLib::BlackScholesMertonProcess;
typedef boost::shared_ptr<StochasticProcess> BlackScholesMertonProcessPtr;

SWIGINTERN BlackScholesMertonProcessPtr *new_BlackScholesMertonProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackScholesMertonProcessPtr(
                            new BlackScholesMertonProcess(s0, dividendTS,
                                                          riskFreeTS, volTS));
      }

using QuantLib::BlackProcess;
typedef boost::shared_ptr<StochasticProcess> BlackProcessPtr;

SWIGINTERN BlackProcessPtr *new_BlackProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new BlackProcessPtr(new BlackProcess(s0, riskFreeTS, volTS));
      }

using QuantLib::GarmanKohlagenProcess;
typedef boost::shared_ptr<StochasticProcess> GarmanKohlagenProcessPtr;

SWIGINTERN GarmanKohlagenProcessPtr *new_GarmanKohlagenProcessPtr(Handle<Quote > const &s0,Handle<YieldTermStructure > const &foreignRiskFreeTS,Handle<YieldTermStructure > const &domesticRiskFreeTS,Handle<BlackVolTermStructure > const &volTS){
          return new GarmanKohlagenProcessPtr(
                        new GarmanKohlagenProcess(s0, foreignRiskFreeTS,
                                                  domesticRiskFreeTS, volTS));
      }

using QuantLib::Merton76Process;
typedef boost::shared_ptr<StochasticProcess> Merton76ProcessPtr;

SWIGINTERN Merton76ProcessPtr *new_Merton76ProcessPtr(Handle<Quote > const &stateVariable,Handle<YieldTermStructure > const &dividendTS,Handle<YieldTermStructure > const &riskFreeTS,Handle<BlackVolTermStructure > const &volTS,Handle<Quote > const &jumpIntensity,Handle<Quote > const &meanLogJump,Handle<Quote > const &jumpVolatility){
            return new Merton76ProcessPtr(
                              new Merton76Process(stateVariable, dividendTS,
                                                  riskFreeTS, volTS,
                                                  jumpIntensity, meanLogJump,
                                                  jumpVolatility));
      }

using QuantLib::StochasticProcessArray;
typedef boost::shared_ptr<StochasticProcess> StochasticProcessArrayPtr;

SWIGINTERN StochasticProcessArrayPtr *new_StochasticProcessArrayPtr(std::vector<boost::shared_ptr<StochasticProcess > > const &array,Matrix const &correlation){
          std::vector<boost::shared_ptr<StochasticProcess1D> > in_array;
          for (Size j=0; j < array.size(); j++)
              in_array.push_back(
                  boost::dynamic_pointer_cast<StochasticProcess1D>(array[j]));
          return new StochasticProcessArrayPtr(
                           new StochasticProcessArray(in_array, correlation));
      }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__set(std::vector<boost::shared_ptr<StochasticProcess > > *self,int i,boost::shared_ptr<StochasticProcess > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN boost::shared_ptr<StochasticProcess > *std_vector_Sl_boost_shared_ptr_Sl_StochasticProcess_Sg__Sg__to_array(std::vector<boost::shared_ptr<StochasticProcess > > *self){
		boost::shared_ptr<StochasticProcess > *array = new boost::shared_ptr<StochasticProcess >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

using QuantLib::PricingEngine;

SWIGINTERN bool boost_shared_ptr_Sl_PricingEngine_Sg__isNull(boost::shared_ptr<PricingEngine > *self){
                return !(*self);
            }

using QuantLib::Instrument;

SWIGINTERN bool boost_shared_ptr_Sl_Instrument_Sg__isNull(boost::shared_ptr<Instrument > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_Instrument_Sg__asObservable(boost::shared_ptr<Instrument > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::Stock;
typedef boost::shared_ptr<Instrument> StockPtr;

SWIGINTERN StockPtr *new_StockPtr(Handle<Quote > const &quote){
            return new StockPtr(new Stock(quote));
        }

using QuantLib::CompositeInstrument;
typedef boost::shared_ptr<Instrument> CompositeInstrumentPtr;

SWIGINTERN CompositeInstrumentPtr *new_CompositeInstrumentPtr(){
            return new CompositeInstrumentPtr(new CompositeInstrument);
        }
SWIGINTERN void CompositeInstrumentPtr_add__SWIG_0(CompositeInstrumentPtr *self,boost::shared_ptr<Instrument > const &instrument,Real multiplier=1.0){
            boost::dynamic_pointer_cast<CompositeInstrument>(*self)
                ->add(instrument, multiplier);
        }
SWIGINTERN void CompositeInstrumentPtr_subtract__SWIG_0(CompositeInstrumentPtr *self,boost::shared_ptr<Instrument > const &instrument,Real multiplier=1.0){
            boost::dynamic_pointer_cast<CompositeInstrument>(*self)
                ->subtract(instrument, multiplier);
        }

using QuantLib::Option;
using QuantLib::Barrier;

static int SWIG_ENUM__Option__Put = Option::Put;
static int SWIG_ENUM__Option__Call = Option::Call;
static int SWIG_ENUM__Barrier__DownIn = Barrier::DownIn;
static int SWIG_ENUM__Barrier__UpIn = Barrier::UpIn;
static int SWIG_ENUM__Barrier__DownOut = Barrier::DownOut;
static int SWIG_ENUM__Barrier__UpOut = Barrier::UpOut;

using QuantLib::Payoff;
using QuantLib::StrikedTypePayoff;

SWIGINTERN bool boost_shared_ptr_Sl_Payoff_Sg__isNull(boost::shared_ptr<Payoff > *self){
                return !(*self);
            }

using QuantLib::VanillaOption;
using QuantLib::ForwardVanillaOption;
typedef boost::shared_ptr<Instrument> VanillaOptionPtr;
typedef boost::shared_ptr<Instrument> MultiAssetOptionPtr;

SWIGINTERN VanillaOptionPtr *new_VanillaOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new VanillaOptionPtr(new VanillaOption(stPayoff,exercise));
        }
SWIGINTERN Real VanillaOptionPtr_delta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->delta();
        }
SWIGINTERN Real VanillaOptionPtr_gamma(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->gamma();
        }
SWIGINTERN Real VanillaOptionPtr_theta(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->theta();
        }
SWIGINTERN Real VanillaOptionPtr_thetaPerDay(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                ->thetaPerDay();
        }
SWIGINTERN Real VanillaOptionPtr_vega(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->vega();
        }
SWIGINTERN Real VanillaOptionPtr_rho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)->rho();
        }
SWIGINTERN Real VanillaOptionPtr_dividendRho(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->dividendRho();
        }
SWIGINTERN Real VanillaOptionPtr_strikeSensitivity(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                 ->strikeSensitivity();
        }
SWIGINTERN SampledCurve VanillaOptionPtr_priceCurve(VanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                ->result<SampledCurve>("priceCurve");
        }
SWIGINTERN Volatility VanillaOptionPtr_impliedVolatility__SWIG_0(VanillaOptionPtr *self,Real targetValue,GeneralizedBlackScholesProcessPtr const &process,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return boost::dynamic_pointer_cast<VanillaOption>(*self)
                ->impliedVolatility(targetValue, bsProcess, accuracy,
                                    maxEvaluations, minVol, maxVol);
        }

using QuantLib::EuropeanOption;
typedef boost::shared_ptr<Instrument> EuropeanOptionPtr;

SWIGINTERN EuropeanOptionPtr *new_EuropeanOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new EuropeanOptionPtr(new EuropeanOption(stPayoff,exercise));
        }

using QuantLib::ForwardVanillaOption;
typedef boost::shared_ptr<Instrument> ForwardVanillaOptionPtr;

SWIGINTERN ForwardVanillaOptionPtr *new_ForwardVanillaOptionPtr(Real moneyness,Date resetDate,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new ForwardVanillaOptionPtr(
                                new ForwardVanillaOption(moneyness, resetDate,
                                                         stPayoff, exercise));
        }

using QuantLib::QuantoVanillaOption;
typedef boost::shared_ptr<Instrument> QuantoVanillaOptionPtr;

SWIGINTERN QuantoVanillaOptionPtr *new_QuantoVanillaOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new QuantoVanillaOptionPtr(
                                 new QuantoVanillaOption(stPayoff, exercise));
        }
SWIGINTERN Real QuantoVanillaOptionPtr_qvega(QuantoVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoVanillaOption>(*self)
                ->qvega();
        }
SWIGINTERN Real QuantoVanillaOptionPtr_qrho(QuantoVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoVanillaOption>(*self)
                ->qrho();
        }
SWIGINTERN Real QuantoVanillaOptionPtr_qlambda(QuantoVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<QuantoVanillaOption>(*self)
                ->qlambda();
        }

using QuantLib::QuantoForwardVanillaOption;
typedef boost::shared_ptr<Instrument> QuantoForwardVanillaOptionPtr;

SWIGINTERN QuantoForwardVanillaOptionPtr *new_QuantoForwardVanillaOptionPtr(Real moneyness,Date resetDate,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new QuantoForwardVanillaOptionPtr(
                          new QuantoForwardVanillaOption(moneyness, resetDate,
                                                         stPayoff, exercise));
        }

using QuantLib::MultiAssetOption;

SWIGINTERN Real MultiAssetOptionPtr_delta(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->delta();
        }
SWIGINTERN Real MultiAssetOptionPtr_gamma(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->gamma();
        }
SWIGINTERN Real MultiAssetOptionPtr_theta(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->theta();
        }
SWIGINTERN Real MultiAssetOptionPtr_vega(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)->vega();
        }
SWIGINTERN Real MultiAssetOptionPtr_rho(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)->rho();
        }
SWIGINTERN Real MultiAssetOptionPtr_dividendRho(MultiAssetOptionPtr *self){
            return boost::dynamic_pointer_cast<MultiAssetOption>(*self)
                ->dividendRho();
        }

using QuantLib::AnalyticEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticEuropeanEnginePtr;

SWIGINTERN AnalyticEuropeanEnginePtr *new_AnalyticEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticEuropeanEnginePtr(
                                       new AnalyticEuropeanEngine(bsProcess));
        }

using QuantLib::IntegralEngine;
typedef boost::shared_ptr<PricingEngine> IntegralEnginePtr;

SWIGINTERN IntegralEnginePtr *new_IntegralEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new IntegralEnginePtr(new IntegralEngine(bsProcess));
        }

using QuantLib::FDBermudanEngine;
typedef boost::shared_ptr<PricingEngine> FDBermudanEnginePtr;

SWIGINTERN FDBermudanEnginePtr *new_FDBermudanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDBermudanEnginePtr(
                              new FDBermudanEngine(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::FDEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> FDEuropeanEnginePtr;

SWIGINTERN FDEuropeanEnginePtr *new_FDEuropeanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDEuropeanEnginePtr(
                              new FDEuropeanEngine(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::BinomialVanillaEngine;
using QuantLib::CoxRossRubinstein;
using QuantLib::JarrowRudd;
using QuantLib::AdditiveEQPBinomialTree;
using QuantLib::Trigeorgis;
using QuantLib::Tian;
using QuantLib::LeisenReimer;
using QuantLib::Joshi4;
typedef boost::shared_ptr<PricingEngine> BinomialVanillaEnginePtr;

SWIGINTERN BinomialVanillaEnginePtr *new_BinomialVanillaEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &type,Size steps){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<CoxRossRubinstein>(
                                                            bsProcess,steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<JarrowRudd>(bsProcess,steps));
            else if (s == "eqp" || s == "additiveeqpbinomialtree")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<AdditiveEQPBinomialTree>(
                                                            bsProcess,steps));
            else if (s == "trigeorgis")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Trigeorgis>(bsProcess,steps));
            else if (s == "tian")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Tian>(bsProcess,steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<LeisenReimer>(bsProcess,steps));
            else if (s == "j4" || s == "joshi4")
                return new BinomialVanillaEnginePtr(
                    new BinomialVanillaEngine<Joshi4>(bsProcess,steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::MCEuropeanEngine;
using QuantLib::PseudoRandom;
using QuantLib::LowDiscrepancy;
typedef boost::shared_ptr<PricingEngine> MCEuropeanEnginePtr;

SWIGINTERN MCEuropeanEnginePtr *new_MCEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &traits,intOrNull timeSteps=Null<Size >(),intOrNull timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            QL_REQUIRE(Size(timeSteps) != Null<Size>() ||
                       Size(timeStepsPerYear) != Null<Size>(),
                       "number of steps not specified");
            if (s == "pseudorandom" || s == "pr")
                return new MCEuropeanEnginePtr(
                         new MCEuropeanEngine<PseudoRandom>(bsProcess,
                                                            timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCEuropeanEnginePtr(
                       new MCEuropeanEngine<LowDiscrepancy>(bsProcess,
                                                            timeSteps,
                                                            timeStepsPerYear,
                                                            brownianBridge,
                                                            antitheticVariate,
                                                            controlVariate,
                                                            requiredSamples,
                                                            requiredTolerance,
                                                            maxSamples,
                                                            seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::FDAmericanEngine;
using QuantLib::FDShoutEngine;
typedef boost::shared_ptr<PricingEngine> FDAmericanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDShoutEnginePtr;

SWIGINTERN FDAmericanEnginePtr *new_FDAmericanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDAmericanEnginePtr(
                              new FDAmericanEngine(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }
SWIGINTERN FDShoutEnginePtr *new_FDShoutEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDShoutEnginePtr(
                                 new FDShoutEngine(bsProcess,timeSteps,
                                                   gridPoints,timeDependent));
        }

using QuantLib::BaroneAdesiWhaleyApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BaroneAdesiWhaleyApproximationEnginePtr;

SWIGINTERN BaroneAdesiWhaleyApproximationEnginePtr *new_BaroneAdesiWhaleyApproximationEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new BaroneAdesiWhaleyApproximationEnginePtr(
                         new BaroneAdesiWhaleyApproximationEngine(bsProcess));
        }

using QuantLib::BjerksundStenslandApproximationEngine;
typedef boost::shared_ptr<PricingEngine>
    BjerksundStenslandApproximationEnginePtr;

SWIGINTERN BjerksundStenslandApproximationEnginePtr *new_BjerksundStenslandApproximationEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new BjerksundStenslandApproximationEnginePtr(
                        new BjerksundStenslandApproximationEngine(bsProcess));
        }

using QuantLib::AnalyticDigitalAmericanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDigitalAmericanEnginePtr;

SWIGINTERN AnalyticDigitalAmericanEnginePtr *new_AnalyticDigitalAmericanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDigitalAmericanEnginePtr(
                                new AnalyticDigitalAmericanEngine(bsProcess));
        }

using QuantLib::DividendVanillaOption;
typedef boost::shared_ptr<Instrument> DividendVanillaOptionPtr;

SWIGINTERN DividendVanillaOptionPtr *new_DividendVanillaOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise,std::vector<Date > const &dividendDates,std::vector<Real > const &dividends){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new DividendVanillaOptionPtr(
                          new DividendVanillaOption(stPayoff,exercise,
                                                    dividendDates,dividends));
        }
SWIGINTERN Real DividendVanillaOptionPtr_delta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->delta();
        }
SWIGINTERN Real DividendVanillaOptionPtr_gamma(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->gamma();
        }
SWIGINTERN Real DividendVanillaOptionPtr_theta(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->theta();
        }
SWIGINTERN Real DividendVanillaOptionPtr_vega(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->vega();
        }
SWIGINTERN Real DividendVanillaOptionPtr_rho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->rho();
        }
SWIGINTERN Real DividendVanillaOptionPtr_dividendRho(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->dividendRho();
        }
SWIGINTERN Real DividendVanillaOptionPtr_strikeSensitivity(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                 ->strikeSensitivity();
        }
SWIGINTERN SampledCurve DividendVanillaOptionPtr_priceCurve(DividendVanillaOptionPtr *self){
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->result<SampledCurve>("priceCurve");
        }
SWIGINTERN Volatility DividendVanillaOptionPtr_impliedVolatility__SWIG_0(DividendVanillaOptionPtr *self,Real targetValue,GeneralizedBlackScholesProcessPtr const &process,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return boost::dynamic_pointer_cast<DividendVanillaOption>(*self)
                ->impliedVolatility(targetValue, bsProcess, accuracy,
                                    maxEvaluations, minVol, maxVol);
        }

using QuantLib::AnalyticDividendEuropeanEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticDividendEuropeanEnginePtr;

SWIGINTERN AnalyticDividendEuropeanEnginePtr *new_AnalyticDividendEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticDividendEuropeanEnginePtr(
                               new AnalyticDividendEuropeanEngine(bsProcess));
        }

using QuantLib::FDDividendEuropeanEngine;
using QuantLib::FDDividendAmericanEngine;
typedef boost::shared_ptr<PricingEngine> FDDividendEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> FDDividendAmericanEnginePtr;

SWIGINTERN FDDividendEuropeanEnginePtr *new_FDDividendEuropeanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDDividendEuropeanEnginePtr(
                     new FDDividendEuropeanEngine(bsProcess,timeSteps,
                                                  gridPoints, timeDependent));
        }
SWIGINTERN FDDividendAmericanEnginePtr *new_FDDividendAmericanEnginePtr__SWIG_0(GeneralizedBlackScholesProcessPtr const &process,Size timeSteps=100,Size gridPoints=100,bool timeDependent=false){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new FDDividendAmericanEnginePtr(
                     new FDDividendAmericanEngine(bsProcess,timeSteps,
                                                  gridPoints, timeDependent));
        }

using QuantLib::BarrierOption;
typedef boost::shared_ptr<Instrument> BarrierOptionPtr;

SWIGINTERN BarrierOptionPtr *new_BarrierOptionPtr(Barrier::Type barrierType,Real barrier,Real rebate,boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<StrikedTypePayoff> stPayoff =
                 boost::dynamic_pointer_cast<StrikedTypePayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BarrierOptionPtr(
                               new BarrierOption(barrierType, barrier, rebate,
                                                 stPayoff,exercise));
        }
SWIGINTERN Real BarrierOptionPtr_delta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->delta();
        }
SWIGINTERN Real BarrierOptionPtr_gamma(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->gamma();
        }
SWIGINTERN Real BarrierOptionPtr_theta(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->theta();
        }
SWIGINTERN Real BarrierOptionPtr_vega(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->vega();
        }
SWIGINTERN Real BarrierOptionPtr_rho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)->rho();
        }
SWIGINTERN Real BarrierOptionPtr_dividendRho(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->dividendRho();
        }
SWIGINTERN Real BarrierOptionPtr_strikeSensitivity(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->strikeSensitivity();
        }
SWIGINTERN SampledCurve BarrierOptionPtr_priceCurve(BarrierOptionPtr *self){
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                ->result<SampledCurve>("priceCurve");
        }
SWIGINTERN Volatility BarrierOptionPtr_impliedVolatility__SWIG_0(BarrierOptionPtr *self,Real targetValue,GeneralizedBlackScholesProcessPtr const &process,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-4,Volatility maxVol=4.0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return boost::dynamic_pointer_cast<BarrierOption>(*self)
                 ->impliedVolatility(targetValue, bsProcess, accuracy,
                                     maxEvaluations, minVol, maxVol);
        }

using QuantLib::AnalyticBarrierEngine;
typedef boost::shared_ptr<PricingEngine> AnalyticBarrierEnginePtr;

SWIGINTERN AnalyticBarrierEnginePtr *new_AnalyticBarrierEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new AnalyticBarrierEnginePtr(
                                        new AnalyticBarrierEngine(bsProcess));
        }

using QuantLib::MCBarrierEngine;
typedef boost::shared_ptr<PricingEngine> MCBarrierEnginePtr;

SWIGINTERN MCBarrierEnginePtr *new_MCBarrierEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &traits,Size timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),bool isBiased=false,BigInteger seed=0){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCBarrierEnginePtr(
                         new MCBarrierEngine<PseudoRandom>(bsProcess,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           isBiased,
                                                           seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCBarrierEnginePtr(
                       new MCBarrierEngine<LowDiscrepancy>(bsProcess,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           isBiased,
                                                           seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::QuantoEngine;
using QuantLib::ForwardVanillaEngine;
typedef boost::shared_ptr<PricingEngine> ForwardEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> QuantoEuropeanEnginePtr;
typedef boost::shared_ptr<PricingEngine> QuantoForwardEuropeanEnginePtr;

SWIGINTERN ForwardEuropeanEnginePtr *new_ForwardEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new ForwardEuropeanEnginePtr(
                 new ForwardVanillaEngine<AnalyticEuropeanEngine>(bsProcess));
        }
SWIGINTERN QuantoEuropeanEnginePtr *new_QuantoEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process,Handle<YieldTermStructure > const &foreignRiskFreeRate,Handle<BlackVolTermStructure > const &exchangeRateVolatility,Handle<Quote > const &correlation){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new QuantoEuropeanEnginePtr(
                new QuantoEngine<VanillaOption,AnalyticEuropeanEngine>(
                                                       bsProcess,
                                                       foreignRiskFreeRate,
                                                       exchangeRateVolatility,
                                                       correlation));
        }
SWIGINTERN QuantoForwardEuropeanEnginePtr *new_QuantoForwardEuropeanEnginePtr(GeneralizedBlackScholesProcessPtr const &process,Handle<YieldTermStructure > const &foreignRiskFreeRate,Handle<BlackVolTermStructure > const &exchangeRateVolatility,Handle<Quote > const &correlation){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            return new QuantoForwardEuropeanEnginePtr(
                new QuantoEngine<ForwardVanillaOption,AnalyticEuropeanEngine>(
                                                       bsProcess,
                                                       foreignRiskFreeRate,
                                                       exchangeRateVolatility,
                                                       correlation));
        }

using QuantLib::PlainVanillaPayoff;
using QuantLib::PercentageStrikePayoff;
using QuantLib::CashOrNothingPayoff;
using QuantLib::AssetOrNothingPayoff;
using QuantLib::SuperSharePayoff;
using QuantLib::GapPayoff;
typedef boost::shared_ptr<Payoff> PlainVanillaPayoffPtr;
typedef boost::shared_ptr<Payoff> PercentageStrikePayoffPtr;
typedef boost::shared_ptr<Payoff> CashOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> AssetOrNothingPayoffPtr;
typedef boost::shared_ptr<Payoff> SuperSharePayoffPtr;
typedef boost::shared_ptr<Payoff> GapPayoffPtr;

SWIGINTERN PlainVanillaPayoffPtr *new_PlainVanillaPayoffPtr(Option::Type type,Real strike){
            return new PlainVanillaPayoffPtr(
                                        new PlainVanillaPayoff(type, strike));
        }
SWIGINTERN PercentageStrikePayoffPtr *new_PercentageStrikePayoffPtr(Option::Type type,Real moneyness){
            return new PercentageStrikePayoffPtr(
                                 new PercentageStrikePayoff(type, moneyness));
        }
SWIGINTERN CashOrNothingPayoffPtr *new_CashOrNothingPayoffPtr(Option::Type type,Real strike,Real payoff){
            return new CashOrNothingPayoffPtr(
                               new CashOrNothingPayoff(type, strike, payoff));
        }
SWIGINTERN AssetOrNothingPayoffPtr *new_AssetOrNothingPayoffPtr(Option::Type type,Real strike){
            return new AssetOrNothingPayoffPtr(
                                      new AssetOrNothingPayoff(type, strike));
        }
SWIGINTERN SuperSharePayoffPtr *new_SuperSharePayoffPtr(Option::Type type,Real strike,Real increment){
            return new SuperSharePayoffPtr(
                               new SuperSharePayoff(type, strike, increment));
        }
SWIGINTERN GapPayoffPtr *new_GapPayoffPtr(Option::Type type,Real strike,Real strikePayoff){
            return new GapPayoffPtr(
                               new GapPayoff(type, strike, strikePayoff));
        }

using QuantLib::BasketOption;
using QuantLib::BasketPayoff;
using QuantLib::MinBasketPayoff;
using QuantLib::MaxBasketPayoff;
using QuantLib::AverageBasketPayoff;
typedef boost::shared_ptr<Instrument> BasketOptionPtr;
typedef boost::shared_ptr<Payoff> BasketPayoffPtr;
typedef boost::shared_ptr<Payoff> MinBasketPayoffPtr;
typedef boost::shared_ptr<Payoff> MaxBasketPayoffPtr;
typedef boost::shared_ptr<Payoff> AverageBasketPayoffPtr;

SWIGINTERN MinBasketPayoffPtr *new_MinBasketPayoffPtr(boost::shared_ptr<Payoff > const p){
            return new MinBasketPayoffPtr(new MinBasketPayoff(p));
        }
SWIGINTERN MaxBasketPayoffPtr *new_MaxBasketPayoffPtr(boost::shared_ptr<Payoff > const p){
            return new MaxBasketPayoffPtr(new MaxBasketPayoff(p));
        }
SWIGINTERN AverageBasketPayoffPtr *new_AverageBasketPayoffPtr__SWIG_0(boost::shared_ptr<Payoff > const p,Array const &a){
            return new AverageBasketPayoffPtr(new AverageBasketPayoff(p, a));
        }
SWIGINTERN AverageBasketPayoffPtr *new_AverageBasketPayoffPtr__SWIG_1(boost::shared_ptr<Payoff > const p,Size n){
            return new AverageBasketPayoffPtr(new AverageBasketPayoff(p, n));
        }
SWIGINTERN BasketOptionPtr *new_BasketOptionPtr(boost::shared_ptr<Payoff > const &payoff,boost::shared_ptr<Exercise > const &exercise){
            boost::shared_ptr<BasketPayoff> stPayoff =
                 boost::dynamic_pointer_cast<BasketPayoff>(payoff);
            QL_REQUIRE(stPayoff, "wrong payoff given");
            return new BasketOptionPtr(new BasketOption(stPayoff,exercise));
        }

using QuantLib::MCBasketEngine;
typedef boost::shared_ptr<PricingEngine> MCBasketEnginePtr;

SWIGINTERN MCBasketEnginePtr *new_MCBasketEnginePtr(StochasticProcessArrayPtr const &process,std::string const &traits,Size timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            boost::shared_ptr<StochasticProcessArray> processes =
                 boost::dynamic_pointer_cast<StochasticProcessArray>(process);
            QL_REQUIRE(processes, "stochastic-process array required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                return new MCBasketEnginePtr(
                         new MCBasketEngine<PseudoRandom>(processes,
                                                          timeStepsPerYear,
                                                          brownianBridge,
                                                          antitheticVariate,
                                                          controlVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCBasketEnginePtr(
                       new MCBasketEngine<LowDiscrepancy>(processes,
                                                          timeStepsPerYear,
                                                          brownianBridge,
                                                          antitheticVariate,
                                                          controlVariate,
                                                          requiredSamples,
                                                          requiredTolerance,
                                                          maxSamples,
                                                          seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::MCAmericanBasketEngine;
typedef boost::shared_ptr<PricingEngine> MCAmericanBasketEnginePtr;

SWIGINTERN MCAmericanBasketEnginePtr *new_MCAmericanBasketEnginePtr(StochasticProcessArrayPtr const &process,std::string const &traits,Size timeSteps=Null<Size >(),Size timeStepsPerYear=Null<Size >(),bool brownianBridge=false,bool antitheticVariate=false,bool controlVariate=false,intOrNull requiredSamples=Null<Size >(),doubleOrNull requiredTolerance=Null<Real >(),intOrNull maxSamples=Null<Size >(),BigInteger seed=0){
            boost::shared_ptr<StochasticProcessArray> processes =
                 boost::dynamic_pointer_cast<StochasticProcessArray>(process);
            QL_REQUIRE(processes, "stochastic-process array required");
            std::string s = boost::algorithm::to_lower_copy(traits);
            if (s == "pseudorandom" || s == "pr")
                  return new MCAmericanBasketEnginePtr(
                  new MCAmericanBasketEngine<PseudoRandom>(processes,
                                                           timeSteps,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           seed));
            else if (s == "lowdiscrepancy" || s == "ld")
                return new MCAmericanBasketEnginePtr(
                new MCAmericanBasketEngine<LowDiscrepancy>(processes,
                                                           timeSteps,
                                                           timeStepsPerYear,
                                                           brownianBridge,
                                                           antitheticVariate,
                                                           controlVariate,
                                                           requiredSamples,
                                                           requiredTolerance,
                                                           maxSamples,
                                                           seed));
            else
                QL_FAIL("unknown Monte Carlo engine type: "+s);
        }

using QuantLib::StulzEngine;
typedef boost::shared_ptr<PricingEngine> StulzEnginePtr;

SWIGINTERN StulzEnginePtr *new_StulzEnginePtr(GeneralizedBlackScholesProcessPtr const &process1,GeneralizedBlackScholesProcessPtr const &process2,Real correlation){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess1 =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                    process1);
            QL_REQUIRE(bsProcess1, "Black-Scholes process required");
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess2 =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                    process2);
            QL_REQUIRE(bsProcess2, "Black-Scholes process required");
            return new StulzEnginePtr(
                          new StulzEngine(bsProcess1,bsProcess2,correlation));
        }

using QuantLib::TimeSeries;
using QuantLib::IntervalPrice;

SWIGINTERN TimeSeries<Real > *new_TimeSeries_Sl_Real_Sg___SWIG_1(std::vector<Date > const &d,std::vector<double > const &v){
            return new TimeSeries<double>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN TimeSeries<IntervalPrice > *new_TimeSeries_Sl_IntervalPrice_Sg___SWIG_1(std::vector<Date > const &d,std::vector<IntervalPrice > const &v){
            return new TimeSeries<IntervalPrice>(d.begin(), d.end(), v.begin());
        }
SWIGINTERN void std_vector_Sl_IntervalPrice_Sg__set(std::vector<IntervalPrice > *self,int i,IntervalPrice const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN IntervalPrice *std_vector_Sl_IntervalPrice_Sg__to_array(std::vector<IntervalPrice > *self){
		IntervalPrice *array = new IntervalPrice[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }
static int SWIG_ENUM__IntervalPrice__Open = IntervalPrice::Open;
static int SWIG_ENUM__IntervalPrice__Close = IntervalPrice::Close;
static int SWIG_ENUM__IntervalPrice__High = IntervalPrice::High;
static int SWIG_ENUM__IntervalPrice__Low = IntervalPrice::Low;

using QuantLib::IndexManager;


using QuantLib::Index;

SWIGINTERN bool boost_shared_ptr_Sl_Index_Sg__isNull(boost::shared_ptr<Index > *self){
                return !(*self);
            }
SWIGINTERN void boost_shared_ptr_Sl_Index_Sg__addFixings(boost::shared_ptr<Index > *self,std::vector<Date > const &fixingDates,std::vector<Rate > const &fixings){
        (*self)->addFixings(fixingDates.begin(),fixingDates.end(),
                            fixings.begin());
    }
SWIGINTERN std::string boost_shared_ptr_Sl_Index_Sg____str__(boost::shared_ptr<Index > *self){
        if (*self)
            return (*self)->name()+" index";
        else
            return "Null index";
    }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_Index_Sg__asObservable(boost::shared_ptr<Index > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::InterestRateIndex;
typedef boost::shared_ptr<Index> InterestRateIndexPtr;

SWIGINTERN std::string InterestRateIndexPtr_familyName(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->familyName();
        }
SWIGINTERN Period InterestRateIndexPtr_tenor(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->tenor();
        }
SWIGINTERN Natural InterestRateIndexPtr_fixingDays(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->fixingDays();
        }
SWIGINTERN Date InterestRateIndexPtr_fixingDate(InterestRateIndexPtr *self,Date const &valueDate){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->fixingDate(valueDate);
        }
SWIGINTERN Currency InterestRateIndexPtr_currency(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->currency();
        }
SWIGINTERN DayCounter InterestRateIndexPtr_dayCounter(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->dayCounter();
        }
SWIGINTERN Handle<YieldTermStructure > InterestRateIndexPtr_termStructure(InterestRateIndexPtr *self){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->termStructure();
        }
SWIGINTERN Date InterestRateIndexPtr_maturityDate(InterestRateIndexPtr *self,Date const &valueDate){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->maturityDate(valueDate);
        }
SWIGINTERN Date InterestRateIndexPtr_valueDate(InterestRateIndexPtr *self,Date const &fixingDate){
            return boost::dynamic_pointer_cast<InterestRateIndex>(*self)
                ->valueDate(fixingDate);
        }

using QuantLib::IborIndex;
typedef boost::shared_ptr<Index> IborIndexPtr;

SWIGINTERN IborIndexPtr *new_IborIndexPtr__SWIG_0(std::string const &familyName,Period const &tenor,Integer settlementDays,Currency const &currency,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,DayCounter const &dayCounter,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
            return new IborIndexPtr(new IborIndex(familyName, tenor,
                                                  settlementDays,
                                                  currency, calendar,
                                                  convention,
                                                  endOfMonth,
                                                  dayCounter, h));
        }
SWIGINTERN BusinessDayConvention IborIndexPtr_businessDayConvention(IborIndexPtr *self){
            return boost::dynamic_pointer_cast<IborIndex>(*self)
                ->businessDayConvention();
        }
SWIGINTERN bool IborIndexPtr_endOfMonth(IborIndexPtr *self){
            return boost::dynamic_pointer_cast<IborIndex>(*self)->endOfMonth();
        }

using QuantLib::SwapIndex;
typedef boost::shared_ptr<Index> SwapIndexPtr;

SWIGINTERN SwapIndexPtr *new_SwapIndexPtr(std::string const &familyName,Period const &tenor,Integer settlementDays,Currency &currency,Calendar const &calendar,Period const &fixedLegTenor,BusinessDayConvention fixedLegConvention,DayCounter const &fixedLegDayCounter,IborIndexPtr const &iborIndex){
            boost::shared_ptr<IborIndex> xibor =
                boost::dynamic_pointer_cast<IborIndex>(iborIndex);
            return new SwapIndexPtr(new SwapIndex(familyName,
                                                  tenor, settlementDays,
                                                  currency, calendar,
                                                  fixedLegTenor,
                                                  fixedLegConvention,
                                                  fixedLegDayCounter,
                                                  xibor));
        }
SWIGINTERN Period SwapIndexPtr_fixedLegTenor(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                ->fixedLegTenor();
        }
SWIGINTERN BusinessDayConvention SwapIndexPtr_fixedLegConvention(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                 ->fixedLegConvention();
        }
SWIGINTERN IborIndexPtr SwapIndexPtr_iborIndex(SwapIndexPtr *self){
            return boost::dynamic_pointer_cast<SwapIndex>(*self)
                ->iborIndex();
        }

using QuantLib::AUDLibor;
typedef boost::shared_ptr<Index> AUDLiborPtr;

SWIGINTERN AUDLiborPtr *new_AUDLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new AUDLiborPtr(new AUDLibor(tenor,h));
      }

using QuantLib::CADLibor;
typedef boost::shared_ptr<Index> CADLiborPtr;

SWIGINTERN CADLiborPtr *new_CADLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new CADLiborPtr(new CADLibor(tenor,h));
      }

using QuantLib::Cdor;
typedef boost::shared_ptr<Index> CdorPtr;

SWIGINTERN CdorPtr *new_CdorPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new CdorPtr(new Cdor(tenor,h));
      }

using QuantLib::CHFLibor;
typedef boost::shared_ptr<Index> CHFLiborPtr;

SWIGINTERN CHFLiborPtr *new_CHFLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new CHFLiborPtr(new CHFLibor(tenor,h));
      }

using QuantLib::DKKLibor;
typedef boost::shared_ptr<Index> DKKLiborPtr;

SWIGINTERN DKKLiborPtr *new_DKKLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new DKKLiborPtr(new DKKLibor(tenor,h));
      }

using QuantLib::Euribor;
typedef boost::shared_ptr<Index> EuriborPtr;

SWIGINTERN EuriborPtr *new_EuriborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborPtr(new Euribor(tenor,h));
      }

using QuantLib::EuriborSW;
typedef boost::shared_ptr<Index> EuriborSWPtr;

SWIGINTERN EuriborSWPtr *new_EuriborSWPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSWPtr(new EuriborSW(h));
      }

using QuantLib::Euribor2W;
typedef boost::shared_ptr<Index> Euribor2WPtr;

SWIGINTERN Euribor2WPtr *new_Euribor2WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor2WPtr(new Euribor2W(h));
      }

using QuantLib::Euribor3W;
typedef boost::shared_ptr<Index> Euribor3WPtr;

SWIGINTERN Euribor3WPtr *new_Euribor3WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor3WPtr(new Euribor3W(h));
      }

using QuantLib::Euribor1M;
typedef boost::shared_ptr<Index> Euribor1MPtr;

SWIGINTERN Euribor1MPtr *new_Euribor1MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor1MPtr(new Euribor1M(h));
      }

using QuantLib::Euribor2M;
typedef boost::shared_ptr<Index> Euribor2MPtr;

SWIGINTERN Euribor2MPtr *new_Euribor2MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor2MPtr(new Euribor2M(h));
      }

using QuantLib::Euribor3M;
typedef boost::shared_ptr<Index> Euribor3MPtr;

SWIGINTERN Euribor3MPtr *new_Euribor3MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor3MPtr(new Euribor3M(h));
      }

using QuantLib::Euribor4M;
typedef boost::shared_ptr<Index> Euribor4MPtr;

SWIGINTERN Euribor4MPtr *new_Euribor4MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor4MPtr(new Euribor4M(h));
      }

using QuantLib::Euribor5M;
typedef boost::shared_ptr<Index> Euribor5MPtr;

SWIGINTERN Euribor5MPtr *new_Euribor5MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor5MPtr(new Euribor5M(h));
      }

using QuantLib::Euribor6M;
typedef boost::shared_ptr<Index> Euribor6MPtr;

SWIGINTERN Euribor6MPtr *new_Euribor6MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor6MPtr(new Euribor6M(h));
      }

using QuantLib::Euribor7M;
typedef boost::shared_ptr<Index> Euribor7MPtr;

SWIGINTERN Euribor7MPtr *new_Euribor7MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor7MPtr(new Euribor7M(h));
      }

using QuantLib::Euribor8M;
typedef boost::shared_ptr<Index> Euribor8MPtr;

SWIGINTERN Euribor8MPtr *new_Euribor8MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor8MPtr(new Euribor8M(h));
      }

using QuantLib::Euribor9M;
typedef boost::shared_ptr<Index> Euribor9MPtr;

SWIGINTERN Euribor9MPtr *new_Euribor9MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor9MPtr(new Euribor9M(h));
      }

using QuantLib::Euribor10M;
typedef boost::shared_ptr<Index> Euribor10MPtr;

SWIGINTERN Euribor10MPtr *new_Euribor10MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor10MPtr(new Euribor10M(h));
      }

using QuantLib::Euribor11M;
typedef boost::shared_ptr<Index> Euribor11MPtr;

SWIGINTERN Euribor11MPtr *new_Euribor11MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor11MPtr(new Euribor11M(h));
      }

using QuantLib::Euribor1Y;
typedef boost::shared_ptr<Index> Euribor1YPtr;

SWIGINTERN Euribor1YPtr *new_Euribor1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor1YPtr(new Euribor1Y(h));
      }

using QuantLib::Euribor365;
typedef boost::shared_ptr<Index> Euribor365Ptr;

SWIGINTERN Euribor365Ptr *new_Euribor365Ptr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365Ptr(new Euribor365(tenor,h));
      }

using QuantLib::Euribor365_SW;
typedef boost::shared_ptr<Index> Euribor365_SWPtr;

SWIGINTERN Euribor365_SWPtr *new_Euribor365_SWPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_SWPtr(new Euribor365_SW(h));
      }

using QuantLib::Euribor365_2W;
typedef boost::shared_ptr<Index> Euribor365_2WPtr;

SWIGINTERN Euribor365_2WPtr *new_Euribor365_2WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_2WPtr(new Euribor365_2W(h));
      }

using QuantLib::Euribor365_3W;
typedef boost::shared_ptr<Index> Euribor365_3WPtr;

SWIGINTERN Euribor365_3WPtr *new_Euribor365_3WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_3WPtr(new Euribor365_3W(h));
      }

using QuantLib::Euribor365_1M;
typedef boost::shared_ptr<Index> Euribor365_1MPtr;

SWIGINTERN Euribor365_1MPtr *new_Euribor365_1MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_1MPtr(new Euribor365_1M(h));
      }

using QuantLib::Euribor365_2M;
typedef boost::shared_ptr<Index> Euribor365_2MPtr;

SWIGINTERN Euribor365_2MPtr *new_Euribor365_2MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_2MPtr(new Euribor365_2M(h));
      }

using QuantLib::Euribor365_3M;
typedef boost::shared_ptr<Index> Euribor365_3MPtr;

SWIGINTERN Euribor365_3MPtr *new_Euribor365_3MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_3MPtr(new Euribor365_3M(h));
      }

using QuantLib::Euribor365_4M;
typedef boost::shared_ptr<Index> Euribor365_4MPtr;

SWIGINTERN Euribor365_4MPtr *new_Euribor365_4MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_4MPtr(new Euribor365_4M(h));
      }

using QuantLib::Euribor365_5M;
typedef boost::shared_ptr<Index> Euribor365_5MPtr;

SWIGINTERN Euribor365_5MPtr *new_Euribor365_5MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_5MPtr(new Euribor365_5M(h));
      }

using QuantLib::Euribor365_6M;
typedef boost::shared_ptr<Index> Euribor365_6MPtr;

SWIGINTERN Euribor365_6MPtr *new_Euribor365_6MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_6MPtr(new Euribor365_6M(h));
      }

using QuantLib::Euribor365_7M;
typedef boost::shared_ptr<Index> Euribor365_7MPtr;

SWIGINTERN Euribor365_7MPtr *new_Euribor365_7MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_7MPtr(new Euribor365_7M(h));
      }

using QuantLib::Euribor365_8M;
typedef boost::shared_ptr<Index> Euribor365_8MPtr;

SWIGINTERN Euribor365_8MPtr *new_Euribor365_8MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_8MPtr(new Euribor365_8M(h));
      }

using QuantLib::Euribor365_9M;
typedef boost::shared_ptr<Index> Euribor365_9MPtr;

SWIGINTERN Euribor365_9MPtr *new_Euribor365_9MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_9MPtr(new Euribor365_9M(h));
      }

using QuantLib::Euribor365_10M;
typedef boost::shared_ptr<Index> Euribor365_10MPtr;

SWIGINTERN Euribor365_10MPtr *new_Euribor365_10MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_10MPtr(new Euribor365_10M(h));
      }

using QuantLib::Euribor365_11M;
typedef boost::shared_ptr<Index> Euribor365_11MPtr;

SWIGINTERN Euribor365_11MPtr *new_Euribor365_11MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_11MPtr(new Euribor365_11M(h));
      }

using QuantLib::Euribor365_1Y;
typedef boost::shared_ptr<Index> Euribor365_1YPtr;

SWIGINTERN Euribor365_1YPtr *new_Euribor365_1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new Euribor365_1YPtr(new Euribor365_1Y(h));
      }

using QuantLib::EURLibor;
typedef boost::shared_ptr<Index> EURLiborPtr;

SWIGINTERN EURLiborPtr *new_EURLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLiborPtr(new EURLibor(tenor,h));
      }

using QuantLib::EURLiborSW;
typedef boost::shared_ptr<Index> EURLiborSWPtr;

SWIGINTERN EURLiborSWPtr *new_EURLiborSWPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLiborSWPtr(new EURLiborSW(h));
      }

using QuantLib::EURLibor2W;
typedef boost::shared_ptr<Index> EURLibor2WPtr;

SWIGINTERN EURLibor2WPtr *new_EURLibor2WPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor2WPtr(new EURLibor2W(h));
      }

using QuantLib::EURLibor1M;
typedef boost::shared_ptr<Index> EURLibor1MPtr;

SWIGINTERN EURLibor1MPtr *new_EURLibor1MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor1MPtr(new EURLibor1M(h));
      }

using QuantLib::EURLibor2M;
typedef boost::shared_ptr<Index> EURLibor2MPtr;

SWIGINTERN EURLibor2MPtr *new_EURLibor2MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor2MPtr(new EURLibor2M(h));
      }

using QuantLib::EURLibor3M;
typedef boost::shared_ptr<Index> EURLibor3MPtr;

SWIGINTERN EURLibor3MPtr *new_EURLibor3MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor3MPtr(new EURLibor3M(h));
      }

using QuantLib::EURLibor4M;
typedef boost::shared_ptr<Index> EURLibor4MPtr;

SWIGINTERN EURLibor4MPtr *new_EURLibor4MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor4MPtr(new EURLibor4M(h));
      }

using QuantLib::EURLibor5M;
typedef boost::shared_ptr<Index> EURLibor5MPtr;

SWIGINTERN EURLibor5MPtr *new_EURLibor5MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor5MPtr(new EURLibor5M(h));
      }

using QuantLib::EURLibor6M;
typedef boost::shared_ptr<Index> EURLibor6MPtr;

SWIGINTERN EURLibor6MPtr *new_EURLibor6MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor6MPtr(new EURLibor6M(h));
      }

using QuantLib::EURLibor7M;
typedef boost::shared_ptr<Index> EURLibor7MPtr;

SWIGINTERN EURLibor7MPtr *new_EURLibor7MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor7MPtr(new EURLibor7M(h));
      }

using QuantLib::EURLibor8M;
typedef boost::shared_ptr<Index> EURLibor8MPtr;

SWIGINTERN EURLibor8MPtr *new_EURLibor8MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor8MPtr(new EURLibor8M(h));
      }

using QuantLib::EURLibor9M;
typedef boost::shared_ptr<Index> EURLibor9MPtr;

SWIGINTERN EURLibor9MPtr *new_EURLibor9MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor9MPtr(new EURLibor9M(h));
      }

using QuantLib::EURLibor10M;
typedef boost::shared_ptr<Index> EURLibor10MPtr;

SWIGINTERN EURLibor10MPtr *new_EURLibor10MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor10MPtr(new EURLibor10M(h));
      }

using QuantLib::EURLibor11M;
typedef boost::shared_ptr<Index> EURLibor11MPtr;

SWIGINTERN EURLibor11MPtr *new_EURLibor11MPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor11MPtr(new EURLibor11M(h));
      }

using QuantLib::EURLibor1Y;
typedef boost::shared_ptr<Index> EURLibor1YPtr;

SWIGINTERN EURLibor1YPtr *new_EURLibor1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EURLibor1YPtr(new EURLibor1Y(h));
      }

using QuantLib::GBPLibor;
typedef boost::shared_ptr<Index> GBPLiborPtr;

SWIGINTERN GBPLiborPtr *new_GBPLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new GBPLiborPtr(new GBPLibor(tenor,h));
      }

using QuantLib::Jibar;
typedef boost::shared_ptr<Index> JibarPtr;

SWIGINTERN JibarPtr *new_JibarPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new JibarPtr(new Jibar(tenor,h));
      }

using QuantLib::JPYLibor;
typedef boost::shared_ptr<Index> JPYLiborPtr;

SWIGINTERN JPYLiborPtr *new_JPYLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new JPYLiborPtr(new JPYLibor(tenor,h));
      }

using QuantLib::NZDLibor;
typedef boost::shared_ptr<Index> NZDLiborPtr;

SWIGINTERN NZDLiborPtr *new_NZDLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new NZDLiborPtr(new NZDLibor(tenor,h));
      }

using QuantLib::Tibor;
typedef boost::shared_ptr<Index> TiborPtr;

SWIGINTERN TiborPtr *new_TiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new TiborPtr(new Tibor(tenor,h));
      }

using QuantLib::TRLibor;
typedef boost::shared_ptr<Index> TRLiborPtr;

SWIGINTERN TRLiborPtr *new_TRLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new TRLiborPtr(new TRLibor(tenor,h));
      }

using QuantLib::USDLibor;
typedef boost::shared_ptr<Index> USDLiborPtr;

SWIGINTERN USDLiborPtr *new_USDLiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new USDLiborPtr(new USDLibor(tenor,h));
      }

using QuantLib::Zibor;
typedef boost::shared_ptr<Index> ZiborPtr;

SWIGINTERN ZiborPtr *new_ZiborPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new ZiborPtr(new Zibor(tenor,h));
      }

using QuantLib::EuriborSwapFixA;
typedef boost::shared_ptr<Index> EuriborSwapFixAPtr;

SWIGINTERN EuriborSwapFixAPtr *new_EuriborSwapFixAPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixAPtr(new EuriborSwapFixA(tenor,h));
      }

using QuantLib::EuriborSwapFixA1Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA1YPtr;

SWIGINTERN EuriborSwapFixA1YPtr *new_EuriborSwapFixA1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA1YPtr(new EuriborSwapFixA1Y(h));
      }

using QuantLib::EuriborSwapFixA2Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA2YPtr;

SWIGINTERN EuriborSwapFixA2YPtr *new_EuriborSwapFixA2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA2YPtr(new EuriborSwapFixA2Y(h));
      }

using QuantLib::EuriborSwapFixA3Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA3YPtr;

SWIGINTERN EuriborSwapFixA3YPtr *new_EuriborSwapFixA3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA3YPtr(new EuriborSwapFixA3Y(h));
      }

using QuantLib::EuriborSwapFixA4Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA4YPtr;

SWIGINTERN EuriborSwapFixA4YPtr *new_EuriborSwapFixA4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA4YPtr(new EuriborSwapFixA4Y(h));
      }

using QuantLib::EuriborSwapFixA5Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA5YPtr;

SWIGINTERN EuriborSwapFixA5YPtr *new_EuriborSwapFixA5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA5YPtr(new EuriborSwapFixA5Y(h));
      }

using QuantLib::EuriborSwapFixA6Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA6YPtr;

SWIGINTERN EuriborSwapFixA6YPtr *new_EuriborSwapFixA6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA6YPtr(new EuriborSwapFixA6Y(h));
      }

using QuantLib::EuriborSwapFixA7Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA7YPtr;

SWIGINTERN EuriborSwapFixA7YPtr *new_EuriborSwapFixA7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA7YPtr(new EuriborSwapFixA7Y(h));
      }

using QuantLib::EuriborSwapFixA8Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA8YPtr;

SWIGINTERN EuriborSwapFixA8YPtr *new_EuriborSwapFixA8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA8YPtr(new EuriborSwapFixA8Y(h));
      }

using QuantLib::EuriborSwapFixA9Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA9YPtr;

SWIGINTERN EuriborSwapFixA9YPtr *new_EuriborSwapFixA9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA9YPtr(new EuriborSwapFixA9Y(h));
      }

using QuantLib::EuriborSwapFixA10Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA10YPtr;

SWIGINTERN EuriborSwapFixA10YPtr *new_EuriborSwapFixA10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA10YPtr(new EuriborSwapFixA10Y(h));
      }

using QuantLib::EuriborSwapFixA12Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA12YPtr;

SWIGINTERN EuriborSwapFixA12YPtr *new_EuriborSwapFixA12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA12YPtr(new EuriborSwapFixA12Y(h));
      }

using QuantLib::EuriborSwapFixA15Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA15YPtr;

SWIGINTERN EuriborSwapFixA15YPtr *new_EuriborSwapFixA15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA15YPtr(new EuriborSwapFixA15Y(h));
      }

using QuantLib::EuriborSwapFixA20Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA20YPtr;

SWIGINTERN EuriborSwapFixA20YPtr *new_EuriborSwapFixA20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA20YPtr(new EuriborSwapFixA20Y(h));
      }

using QuantLib::EuriborSwapFixA25Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA25YPtr;

SWIGINTERN EuriborSwapFixA25YPtr *new_EuriborSwapFixA25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA25YPtr(new EuriborSwapFixA25Y(h));
      }

using QuantLib::EuriborSwapFixA30Y;
typedef boost::shared_ptr<Index> EuriborSwapFixA30YPtr;

SWIGINTERN EuriborSwapFixA30YPtr *new_EuriborSwapFixA30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixA30YPtr(new EuriborSwapFixA30Y(h));
      }

using QuantLib::EuriborSwapFixIFR;
typedef boost::shared_ptr<Index> EuriborSwapFixIFRPtr;

SWIGINTERN EuriborSwapFixIFRPtr *new_EuriborSwapFixIFRPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFRPtr(new EuriborSwapFixIFR(tenor,h));
      }

using QuantLib::EuriborSwapFixIFR1Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR1YPtr;

SWIGINTERN EuriborSwapFixIFR1YPtr *new_EuriborSwapFixIFR1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR1YPtr(new EuriborSwapFixIFR1Y(h));
      }

using QuantLib::EuriborSwapFixIFR2Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR2YPtr;

SWIGINTERN EuriborSwapFixIFR2YPtr *new_EuriborSwapFixIFR2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR2YPtr(new EuriborSwapFixIFR2Y(h));
      }

using QuantLib::EuriborSwapFixIFR3Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR3YPtr;

SWIGINTERN EuriborSwapFixIFR3YPtr *new_EuriborSwapFixIFR3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR3YPtr(new EuriborSwapFixIFR3Y(h));
      }

using QuantLib::EuriborSwapFixIFR4Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR4YPtr;

SWIGINTERN EuriborSwapFixIFR4YPtr *new_EuriborSwapFixIFR4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR4YPtr(new EuriborSwapFixIFR4Y(h));
      }

using QuantLib::EuriborSwapFixIFR5Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR5YPtr;

SWIGINTERN EuriborSwapFixIFR5YPtr *new_EuriborSwapFixIFR5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR5YPtr(new EuriborSwapFixIFR5Y(h));
      }

using QuantLib::EuriborSwapFixIFR6Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR6YPtr;

SWIGINTERN EuriborSwapFixIFR6YPtr *new_EuriborSwapFixIFR6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR6YPtr(new EuriborSwapFixIFR6Y(h));
      }

using QuantLib::EuriborSwapFixIFR7Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR7YPtr;

SWIGINTERN EuriborSwapFixIFR7YPtr *new_EuriborSwapFixIFR7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR7YPtr(new EuriborSwapFixIFR7Y(h));
      }

using QuantLib::EuriborSwapFixIFR8Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR8YPtr;

SWIGINTERN EuriborSwapFixIFR8YPtr *new_EuriborSwapFixIFR8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR8YPtr(new EuriborSwapFixIFR8Y(h));
      }

using QuantLib::EuriborSwapFixIFR9Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR9YPtr;

SWIGINTERN EuriborSwapFixIFR9YPtr *new_EuriborSwapFixIFR9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR9YPtr(new EuriborSwapFixIFR9Y(h));
      }

using QuantLib::EuriborSwapFixIFR10Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR10YPtr;

SWIGINTERN EuriborSwapFixIFR10YPtr *new_EuriborSwapFixIFR10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR10YPtr(new EuriborSwapFixIFR10Y(h));
      }

using QuantLib::EuriborSwapFixIFR12Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR12YPtr;

SWIGINTERN EuriborSwapFixIFR12YPtr *new_EuriborSwapFixIFR12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR12YPtr(new EuriborSwapFixIFR12Y(h));
      }

using QuantLib::EuriborSwapFixIFR15Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR15YPtr;

SWIGINTERN EuriborSwapFixIFR15YPtr *new_EuriborSwapFixIFR15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR15YPtr(new EuriborSwapFixIFR15Y(h));
      }

using QuantLib::EuriborSwapFixIFR20Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR20YPtr;

SWIGINTERN EuriborSwapFixIFR20YPtr *new_EuriborSwapFixIFR20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR20YPtr(new EuriborSwapFixIFR20Y(h));
      }

using QuantLib::EuriborSwapFixIFR25Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR25YPtr;

SWIGINTERN EuriborSwapFixIFR25YPtr *new_EuriborSwapFixIFR25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR25YPtr(new EuriborSwapFixIFR25Y(h));
      }

using QuantLib::EuriborSwapFixIFR30Y;
typedef boost::shared_ptr<Index> EuriborSwapFixIFR30YPtr;

SWIGINTERN EuriborSwapFixIFR30YPtr *new_EuriborSwapFixIFR30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EuriborSwapFixIFR30YPtr(new EuriborSwapFixIFR30Y(h));
      }

using QuantLib::EurliborSwapFixA;
typedef boost::shared_ptr<Index> EurliborSwapFixAPtr;

SWIGINTERN EurliborSwapFixAPtr *new_EurliborSwapFixAPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixAPtr(new EurliborSwapFixA(tenor,h));
      }

using QuantLib::EurliborSwapFixA1Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA1YPtr;

SWIGINTERN EurliborSwapFixA1YPtr *new_EurliborSwapFixA1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA1YPtr(new EurliborSwapFixA1Y(h));
      }

using QuantLib::EurliborSwapFixA2Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA2YPtr;

SWIGINTERN EurliborSwapFixA2YPtr *new_EurliborSwapFixA2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA2YPtr(new EurliborSwapFixA2Y(h));
      }

using QuantLib::EurliborSwapFixA3Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA3YPtr;

SWIGINTERN EurliborSwapFixA3YPtr *new_EurliborSwapFixA3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA3YPtr(new EurliborSwapFixA3Y(h));
      }

using QuantLib::EurliborSwapFixA4Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA4YPtr;

SWIGINTERN EurliborSwapFixA4YPtr *new_EurliborSwapFixA4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA4YPtr(new EurliborSwapFixA4Y(h));
      }

using QuantLib::EurliborSwapFixA5Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA5YPtr;

SWIGINTERN EurliborSwapFixA5YPtr *new_EurliborSwapFixA5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA5YPtr(new EurliborSwapFixA5Y(h));
      }

using QuantLib::EurliborSwapFixA6Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA6YPtr;

SWIGINTERN EurliborSwapFixA6YPtr *new_EurliborSwapFixA6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA6YPtr(new EurliborSwapFixA6Y(h));
      }

using QuantLib::EurliborSwapFixA7Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA7YPtr;

SWIGINTERN EurliborSwapFixA7YPtr *new_EurliborSwapFixA7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA7YPtr(new EurliborSwapFixA7Y(h));
      }

using QuantLib::EurliborSwapFixA8Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA8YPtr;

SWIGINTERN EurliborSwapFixA8YPtr *new_EurliborSwapFixA8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA8YPtr(new EurliborSwapFixA8Y(h));
      }

using QuantLib::EurliborSwapFixA9Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA9YPtr;

SWIGINTERN EurliborSwapFixA9YPtr *new_EurliborSwapFixA9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA9YPtr(new EurliborSwapFixA9Y(h));
      }

using QuantLib::EurliborSwapFixA10Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA10YPtr;

SWIGINTERN EurliborSwapFixA10YPtr *new_EurliborSwapFixA10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA10YPtr(new EurliborSwapFixA10Y(h));
      }

using QuantLib::EurliborSwapFixA12Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA12YPtr;

SWIGINTERN EurliborSwapFixA12YPtr *new_EurliborSwapFixA12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA12YPtr(new EurliborSwapFixA12Y(h));
      }

using QuantLib::EurliborSwapFixA15Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA15YPtr;

SWIGINTERN EurliborSwapFixA15YPtr *new_EurliborSwapFixA15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA15YPtr(new EurliborSwapFixA15Y(h));
      }

using QuantLib::EurliborSwapFixA20Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA20YPtr;

SWIGINTERN EurliborSwapFixA20YPtr *new_EurliborSwapFixA20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA20YPtr(new EurliborSwapFixA20Y(h));
      }

using QuantLib::EurliborSwapFixA25Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA25YPtr;

SWIGINTERN EurliborSwapFixA25YPtr *new_EurliborSwapFixA25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA25YPtr(new EurliborSwapFixA25Y(h));
      }

using QuantLib::EurliborSwapFixA30Y;
typedef boost::shared_ptr<Index> EurliborSwapFixA30YPtr;

SWIGINTERN EurliborSwapFixA30YPtr *new_EurliborSwapFixA30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixA30YPtr(new EurliborSwapFixA30Y(h));
      }

using QuantLib::EurliborSwapFixB;
typedef boost::shared_ptr<Index> EurliborSwapFixBPtr;

SWIGINTERN EurliborSwapFixBPtr *new_EurliborSwapFixBPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixBPtr(new EurliborSwapFixB(tenor,h));
      }

using QuantLib::EurliborSwapFixB1Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB1YPtr;

SWIGINTERN EurliborSwapFixB1YPtr *new_EurliborSwapFixB1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB1YPtr(new EurliborSwapFixB1Y(h));
      }

using QuantLib::EurliborSwapFixB2Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB2YPtr;

SWIGINTERN EurliborSwapFixB2YPtr *new_EurliborSwapFixB2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB2YPtr(new EurliborSwapFixB2Y(h));
      }

using QuantLib::EurliborSwapFixB3Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB3YPtr;

SWIGINTERN EurliborSwapFixB3YPtr *new_EurliborSwapFixB3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB3YPtr(new EurliborSwapFixB3Y(h));
      }

using QuantLib::EurliborSwapFixB4Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB4YPtr;

SWIGINTERN EurliborSwapFixB4YPtr *new_EurliborSwapFixB4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB4YPtr(new EurliborSwapFixB4Y(h));
      }

using QuantLib::EurliborSwapFixB5Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB5YPtr;

SWIGINTERN EurliborSwapFixB5YPtr *new_EurliborSwapFixB5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB5YPtr(new EurliborSwapFixB5Y(h));
      }

using QuantLib::EurliborSwapFixB6Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB6YPtr;

SWIGINTERN EurliborSwapFixB6YPtr *new_EurliborSwapFixB6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB6YPtr(new EurliborSwapFixB6Y(h));
      }

using QuantLib::EurliborSwapFixB7Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB7YPtr;

SWIGINTERN EurliborSwapFixB7YPtr *new_EurliborSwapFixB7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB7YPtr(new EurliborSwapFixB7Y(h));
      }

using QuantLib::EurliborSwapFixB8Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB8YPtr;

SWIGINTERN EurliborSwapFixB8YPtr *new_EurliborSwapFixB8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB8YPtr(new EurliborSwapFixB8Y(h));
      }

using QuantLib::EurliborSwapFixB9Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB9YPtr;

SWIGINTERN EurliborSwapFixB9YPtr *new_EurliborSwapFixB9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB9YPtr(new EurliborSwapFixB9Y(h));
      }

using QuantLib::EurliborSwapFixB10Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB10YPtr;

SWIGINTERN EurliborSwapFixB10YPtr *new_EurliborSwapFixB10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB10YPtr(new EurliborSwapFixB10Y(h));
      }

using QuantLib::EurliborSwapFixB12Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB12YPtr;

SWIGINTERN EurliborSwapFixB12YPtr *new_EurliborSwapFixB12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB12YPtr(new EurliborSwapFixB12Y(h));
      }

using QuantLib::EurliborSwapFixB15Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB15YPtr;

SWIGINTERN EurliborSwapFixB15YPtr *new_EurliborSwapFixB15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB15YPtr(new EurliborSwapFixB15Y(h));
      }

using QuantLib::EurliborSwapFixB20Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB20YPtr;

SWIGINTERN EurliborSwapFixB20YPtr *new_EurliborSwapFixB20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB20YPtr(new EurliborSwapFixB20Y(h));
      }

using QuantLib::EurliborSwapFixB25Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB25YPtr;

SWIGINTERN EurliborSwapFixB25YPtr *new_EurliborSwapFixB25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB25YPtr(new EurliborSwapFixB25Y(h));
      }

using QuantLib::EurliborSwapFixB30Y;
typedef boost::shared_ptr<Index> EurliborSwapFixB30YPtr;

SWIGINTERN EurliborSwapFixB30YPtr *new_EurliborSwapFixB30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixB30YPtr(new EurliborSwapFixB30Y(h));
      }

using QuantLib::EurliborSwapFixIFR;
typedef boost::shared_ptr<Index> EurliborSwapFixIFRPtr;

SWIGINTERN EurliborSwapFixIFRPtr *new_EurliborSwapFixIFRPtr__SWIG_0(Period const &tenor,Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFRPtr(new EurliborSwapFixIFR(tenor,h));
      }

using QuantLib::EurliborSwapFixIFR1Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR1YPtr;

SWIGINTERN EurliborSwapFixIFR1YPtr *new_EurliborSwapFixIFR1YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR1YPtr(new EurliborSwapFixIFR1Y(h));
      }

using QuantLib::EurliborSwapFixIFR2Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR2YPtr;

SWIGINTERN EurliborSwapFixIFR2YPtr *new_EurliborSwapFixIFR2YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR2YPtr(new EurliborSwapFixIFR2Y(h));
      }

using QuantLib::EurliborSwapFixIFR3Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR3YPtr;

SWIGINTERN EurliborSwapFixIFR3YPtr *new_EurliborSwapFixIFR3YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR3YPtr(new EurliborSwapFixIFR3Y(h));
      }

using QuantLib::EurliborSwapFixIFR4Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR4YPtr;

SWIGINTERN EurliborSwapFixIFR4YPtr *new_EurliborSwapFixIFR4YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR4YPtr(new EurliborSwapFixIFR4Y(h));
      }

using QuantLib::EurliborSwapFixIFR5Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR5YPtr;

SWIGINTERN EurliborSwapFixIFR5YPtr *new_EurliborSwapFixIFR5YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR5YPtr(new EurliborSwapFixIFR5Y(h));
      }

using QuantLib::EurliborSwapFixIFR6Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR6YPtr;

SWIGINTERN EurliborSwapFixIFR6YPtr *new_EurliborSwapFixIFR6YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR6YPtr(new EurliborSwapFixIFR6Y(h));
      }

using QuantLib::EurliborSwapFixIFR7Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR7YPtr;

SWIGINTERN EurliborSwapFixIFR7YPtr *new_EurliborSwapFixIFR7YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR7YPtr(new EurliborSwapFixIFR7Y(h));
      }

using QuantLib::EurliborSwapFixIFR8Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR8YPtr;

SWIGINTERN EurliborSwapFixIFR8YPtr *new_EurliborSwapFixIFR8YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR8YPtr(new EurliborSwapFixIFR8Y(h));
      }

using QuantLib::EurliborSwapFixIFR9Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR9YPtr;

SWIGINTERN EurliborSwapFixIFR9YPtr *new_EurliborSwapFixIFR9YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR9YPtr(new EurliborSwapFixIFR9Y(h));
      }

using QuantLib::EurliborSwapFixIFR10Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR10YPtr;

SWIGINTERN EurliborSwapFixIFR10YPtr *new_EurliborSwapFixIFR10YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR10YPtr(new EurliborSwapFixIFR10Y(h));
      }

using QuantLib::EurliborSwapFixIFR12Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR12YPtr;

SWIGINTERN EurliborSwapFixIFR12YPtr *new_EurliborSwapFixIFR12YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR12YPtr(new EurliborSwapFixIFR12Y(h));
      }

using QuantLib::EurliborSwapFixIFR15Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR15YPtr;

SWIGINTERN EurliborSwapFixIFR15YPtr *new_EurliborSwapFixIFR15YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR15YPtr(new EurliborSwapFixIFR15Y(h));
      }

using QuantLib::EurliborSwapFixIFR20Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR20YPtr;

SWIGINTERN EurliborSwapFixIFR20YPtr *new_EurliborSwapFixIFR20YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR20YPtr(new EurliborSwapFixIFR20Y(h));
      }

using QuantLib::EurliborSwapFixIFR25Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR25YPtr;

SWIGINTERN EurliborSwapFixIFR25YPtr *new_EurliborSwapFixIFR25YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR25YPtr(new EurliborSwapFixIFR25Y(h));
      }

using QuantLib::EurliborSwapFixIFR30Y;
typedef boost::shared_ptr<Index> EurliborSwapFixIFR30YPtr;

SWIGINTERN EurliborSwapFixIFR30YPtr *new_EurliborSwapFixIFR30YPtr__SWIG_0(Handle<YieldTermStructure > const &h=Handle<YieldTermStructure >()){
          return new EurliborSwapFixIFR30YPtr(new EurliborSwapFixIFR30Y(h));
      }

using QuantLib::Schedule;
using QuantLib::DateGeneration;

static int SWIG_ENUM__DateGeneration__Backward = DateGeneration::Backward;
static int SWIG_ENUM__DateGeneration__Forward = DateGeneration::Forward;
static int SWIG_ENUM__DateGeneration__Zero = DateGeneration::Zero;
static int SWIG_ENUM__DateGeneration__ThirdWednesday = DateGeneration::ThirdWednesday;

using QuantLib::CashFlow;

SWIGINTERN bool boost_shared_ptr_Sl_CashFlow_Sg__isNull(boost::shared_ptr<CashFlow > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_CashFlow_Sg__asObservable(boost::shared_ptr<CashFlow > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::SimpleCashFlow;
using QuantLib::FixedRateCoupon;
using QuantLib::IborCoupon;
using QuantLib::Leg;
using QuantLib::FloatingRateCoupon;

typedef boost::shared_ptr<CashFlow> SimpleCashFlowPtr;
typedef boost::shared_ptr<CashFlow> IborCouponPtr;
typedef boost::shared_ptr<CashFlow> FixedRateCouponPtr;
typedef boost::shared_ptr<CashFlow> FloatingRateCouponPtr;

SWIGINTERN SimpleCashFlowPtr *new_SimpleCashFlowPtr(Real amount,Date const &date){
            return new SimpleCashFlowPtr(new SimpleCashFlow(amount,date));
        }
SWIGINTERN FixedRateCouponPtr *new_FixedRateCouponPtr__SWIG_0(Real nominal,Date const &paymentDate,Rate rate,DayCounter const &dayCounter,Date const &startDate,Date const &endDate,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date()){
            return new FixedRateCouponPtr(
                new FixedRateCoupon(nominal, paymentDate, rate,
                                    dayCounter, startDate, endDate,
                                    refPeriodStart, refPeriodEnd));
        }
SWIGINTERN IborCouponPtr *new_IborCouponPtr__SWIG_0(Date const &paymentDate,Real nominal,Date const &startDate,Date const &endDate,Integer fixingDays,InterestRateIndexPtr &index,Real gearing=1.0,Spread spread=0.0,Date const &refPeriodStart=Date(),Date const &refPeriodEnd=Date(),DayCounter const &dayCounter=DayCounter()){
            const boost::shared_ptr<IborIndex> iri =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new IborCouponPtr(
                new IborCoupon(paymentDate, nominal, startDate, endDate,
                              fixingDays, iri, gearing, spread,
                              refPeriodStart, refPeriodEnd, dayCounter));
        }
SWIGINTERN Rate IborCouponPtr_rate(IborCouponPtr *self){
            return boost::dynamic_pointer_cast<IborCoupon>(*self)->rate();
        }
SWIGINTERN Rate IborCouponPtr_indexFixing(IborCouponPtr *self){
            return boost::dynamic_pointer_cast<IborCoupon>(*self)
                ->indexFixing();
        }
SWIGINTERN Real IborCouponPtr_nominal(IborCouponPtr *self){
            return boost::dynamic_pointer_cast<IborCoupon>(*self)->nominal();
        }
SWIGINTERN Rate FloatingRateCouponPtr_rate(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->rate();
        }
SWIGINTERN Integer FloatingRateCouponPtr_fixingDays(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->fixingDays();
        }
SWIGINTERN Rate FloatingRateCouponPtr_spread(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->spread();
        }
SWIGINTERN Rate FloatingRateCouponPtr_indexFixing(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->indexFixing();
        }
SWIGINTERN Date FloatingRateCouponPtr_fixingDate(FloatingRateCouponPtr *self){
            return boost::dynamic_pointer_cast<FloatingRateCoupon>(*self)
                ->fixingDate();
        }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__set(std::vector<boost::shared_ptr<CashFlow > > *self,int i,boost::shared_ptr<CashFlow > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN boost::shared_ptr<CashFlow > *std_vector_Sl_boost_shared_ptr_Sl_CashFlow_Sg__Sg__to_array(std::vector<boost::shared_ptr<CashFlow > > *self){
		boost::shared_ptr<CashFlow > *array = new boost::shared_ptr<CashFlow >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

Leg _FixedRateLeg(const Schedule& schedule,
                  const DayCounter& dayCount,
                  const std::vector<Real>& nominals,
                  const std::vector<Rate>& couponRates,
                  BusinessDayConvention paymentAdjustment = Following,
                  const DayCounter& firstPeriodDayCount = DayCounter()) {
    return QuantLib::FixedRateLeg(schedule,dayCount)
        .withNotionals(nominals)
        .withCouponRates(couponRates)
        .withPaymentAdjustment(paymentAdjustment)
        .withFirstPeriodDayCounter(firstPeriodDayCount);
}


Leg _IborLeg(const std::vector<Real>& nominals,
             const Schedule& schedule,
             const boost::shared_ptr<Index>& index,
             const DayCounter& paymentDayCounter = DayCounter(),
             const BusinessDayConvention paymentConvention = Following,
             const std::vector<Natural>& fixingDays = std::vector<Natural>(),
             const std::vector<Real>& gearings = std::vector<Real>(),
             const std::vector<Spread>& spreads = std::vector<Spread>(),
             const std::vector<Rate>& caps = std::vector<Rate>(),
             const std::vector<Rate>& floors = std::vector<Rate>(),
             bool isInArrears = false) {
    boost::shared_ptr<IborIndex> libor =
        boost::dynamic_pointer_cast<IborIndex>(index);
    return QuantLib::IborLeg(schedule, libor)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


Leg _CmsLeg(const std::vector<Real>& nominals,
            const Schedule& schedule,
            const boost::shared_ptr<Index>& index,
            const DayCounter& paymentDayCounter = DayCounter(),
            const BusinessDayConvention paymentConvention = Following,
            const std::vector<Natural>& fixingDays = std::vector<Natural>(),
            const std::vector<Real>& gearings = std::vector<Real>(),
            const std::vector<Spread>& spreads = std::vector<Spread>(),
            const std::vector<Rate>& caps = std::vector<Rate>(),
            const std::vector<Rate>& floors = std::vector<Rate>(),
            bool isInArrears = false) {
    boost::shared_ptr<SwapIndex> swapIndex =
        boost::dynamic_pointer_cast<SwapIndex>(index);
    return QuantLib::CmsLeg(schedule, swapIndex)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .inArrears(isInArrears);
}


Leg _CmsZeroLeg(const std::vector<Real>& nominals,
                const Schedule& schedule,
                const boost::shared_ptr<Index>& index,
                const DayCounter& paymentDayCounter = DayCounter(),
                const BusinessDayConvention paymentConvention = Following,
                const std::vector<Natural>& fixingDays = std::vector<Natural>(),
                const std::vector<Real>& gearings = std::vector<Real>(),
                const std::vector<Spread>& spreads = std::vector<Spread>(),
                const std::vector<Rate>& caps = std::vector<Rate>(),
                const std::vector<Rate>& floors = std::vector<Rate>()) {
    boost::shared_ptr<SwapIndex> swapIndex =
        boost::dynamic_pointer_cast<SwapIndex>(index);
    return QuantLib::CmsLeg(schedule, swapIndex)
        .withNotionals(nominals)
        .withPaymentDayCounter(paymentDayCounter)
        .withPaymentAdjustment(paymentConvention)
        .withFixingDays(fixingDays)
        .withGearings(gearings)
        .withSpreads(spreads)
        .withCaps(caps)
        .withFloors(floors)
        .withZeroPayments();
}


using QuantLib::CashFlows;
using QuantLib::Duration;

static int SWIG_ENUM__Duration__Macaulay = Duration::Macaulay;
static int SWIG_ENUM__Duration__Modified = Duration::Modified;

using QuantLib::Bond;
using QuantLib::ZeroCouponBond;
using QuantLib::FixedRateBond;
using QuantLib::FloatingRateBond;
using QuantLib::DiscountingBondEngine;

typedef boost::shared_ptr<Instrument> BondPtr;
typedef boost::shared_ptr<Instrument> ZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> FixedRateBondPtr;
typedef boost::shared_ptr<Instrument> FloatingRateBondPtr;
typedef boost::shared_ptr<PricingEngine> DiscountingBondEnginePtr;

SWIGINTERN Date BondPtr_settlementDate(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->settlementDate();
        }
SWIGINTERN std::vector<boost::shared_ptr<CashFlow > > BondPtr_cashflows(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cashflows();
        }
SWIGINTERN boost::shared_ptr<CashFlow > BondPtr_redemption(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->redemption();
        }
SWIGINTERN Calendar BondPtr_calendar(BondPtr const *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->calendar();
        }
SWIGINTERN Real BondPtr_cleanPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->cleanPrice();
        }
SWIGINTERN Real BondPtr_cleanPrice__SWIG_1(BondPtr *self,Rate yield,DayCounter const &dc,Compounding compounding,Frequency frequency,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->cleanPrice(yield,dc, compounding, frequency, settlement);
        }
SWIGINTERN Real BondPtr_dirtyPrice__SWIG_0(BondPtr *self){
            return boost::dynamic_pointer_cast<Bond>(*self)->dirtyPrice();
        }
SWIGINTERN Real BondPtr_dirtyPrice__SWIG_1(BondPtr *self,Rate yield,DayCounter const &dc,Compounding compounding,Frequency frequency,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->dirtyPrice(yield,dc, compounding,
        frequency,
        settlement);
        }
SWIGINTERN Real BondPtr_yield__SWIG_0(BondPtr *self,DayCounter const &dc,Compounding compounding,Frequency freq,Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(dc,compounding,freq,accuracy,maxEvaluations);
        }
SWIGINTERN Real BondPtr_yield__SWIG_3(BondPtr *self,Real cleanPrice,DayCounter const &dc,Compounding compounding,Frequency freq,Date const &settlement=Date(),Real accuracy=1.0e-8,Size maxEvaluations=100){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->yield(cleanPrice,dc,compounding,freq,
            settlement,
                        accuracy,maxEvaluations);
        }
SWIGINTERN Real BondPtr_accruedAmount__SWIG_0(BondPtr *self,Date const &settlement=Date()){
            return boost::dynamic_pointer_cast<Bond>(*self)
                ->accruedAmount(settlement);
        }
SWIGINTERN ZeroCouponBondPtr *new_ZeroCouponBondPtr(Natural settlementDays,Calendar const &calendar,Real faceAmount,Date const &maturityDate,BusinessDayConvention paymentConvention=QuantLib::Following,Real redemption=100.0,Date const &issueDate=Date()){
            return new ZeroCouponBondPtr(
                new ZeroCouponBond(settlementDays, calendar, faceAmount,
                                   maturityDate,
                                   paymentConvention, redemption,
                                   issueDate));
        }
SWIGINTERN FixedRateBondPtr *new_FixedRateBondPtr(Integer settlementDays,Real faceAmount,Schedule const &schedule,std::vector<Rate > const &coupons,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention=QuantLib::Following,Real redemption=100.0,Date issueDate=Date()){
            return new FixedRateBondPtr(
                new FixedRateBond(settlementDays, faceAmount,
                                  schedule, coupons, paymentDayCounter,
                                  paymentConvention, redemption,
                                  issueDate));
        }
SWIGINTERN FloatingRateBondPtr *new_FloatingRateBondPtr(Size settlementDays,Real faceAmount,Schedule const &schedule,IborIndexPtr const &index,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention,Size fixingDays,std::vector<Real > const &gearings,std::vector<Spread > const &spreads,std::vector<Rate > const &caps,std::vector<Rate > const &floors,bool inArrears,Real redemption,Date const &issueDate){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new FloatingRateBondPtr(
                new FloatingRateBond(settlementDays,
                                     faceAmount,
                                     schedule,
                                     libor,
                                     paymentDayCounter,
                                     paymentConvention,
                                     fixingDays,
                                     gearings,
                                     spreads,
                                     caps,
                                     floors,
                                     inArrears,
                                     redemption,
                                     issueDate));
        }
SWIGINTERN DiscountingBondEnginePtr *new_DiscountingBondEnginePtr(Handle<YieldTermStructure > const &discountCurve){
            return new DiscountingBondEnginePtr(
                                    new DiscountingBondEngine(discountCurve));
        }

using QuantLib::Callability;
using QuantLib::SoftCallability;
typedef boost::shared_ptr<Callability> CallabilityPtr;
typedef boost::shared_ptr<Callability> SoftCallabilityPtr;
typedef Callability::Price CallabilityPrice;
using QuantLib::CallabilitySchedule;

static int SWIG_ENUM__CallabilityPrice__Dirty = CallabilityPrice::Dirty;
static int SWIG_ENUM__CallabilityPrice__Clean = CallabilityPrice::Clean;
SWIGINTERN bool boost_shared_ptr_Sl_Callability_Sg__isNull(boost::shared_ptr<Callability > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Callability > *new_boost_shared_ptr_Sl_Callability_Sg_(CallabilityPrice const &price,Callability::Type type,Date const &date){
        return new boost::shared_ptr<Callability>(
                                            new Callability(price,type,date));
    }
static enum Callability::Type _swig_wrap_Callability_xxCall = Callability::Call;
static enum Callability::Type _swig_wrap_Callability_xxPut = Callability::Put;

using QuantLib::SoftCallability;
typedef boost::shared_ptr<Callability> SoftCallabilityPtr;

SWIGINTERN SoftCallabilityPtr *new_SoftCallabilityPtr(CallabilityPrice const &price,Date const &date,Real trigger){
            return new SoftCallabilityPtr(new SoftCallability(price,date,
                                                              trigger));
        }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__set(std::vector<boost::shared_ptr<Callability > > *self,int i,boost::shared_ptr<Callability > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN boost::shared_ptr<Callability > *std_vector_Sl_boost_shared_ptr_Sl_Callability_Sg__Sg__to_array(std::vector<boost::shared_ptr<Callability > > *self){
		boost::shared_ptr<Callability > *array = new boost::shared_ptr<Callability >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

using QuantLib::CapFloor;
using QuantLib::Cap;
using QuantLib::Floor;
using QuantLib::Collar;

typedef boost::shared_ptr<Instrument> CapFloorPtr;
typedef boost::shared_ptr<Instrument> CapPtr;
typedef boost::shared_ptr<Instrument> FloorPtr;
typedef boost::shared_ptr<Instrument> CollarPtr;

SWIGINTERN Volatility CapFloorPtr_impliedVolatility__SWIG_0(CapFloorPtr const *self,Real price,Handle<YieldTermStructure > const &curve,Real accuracy=1.0e-4,Size maxEvaluations=100,Volatility minVol=1.0e-7,Volatility maxVol=4.0){
            return boost::dynamic_pointer_cast<CapFloor>(*self)->
                impliedVolatility(price, curve, accuracy, maxEvaluations,
                                  minVol, maxVol);
        }
SWIGINTERN CapPtr *new_CapPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates){
            return new CapPtr(new Cap(leg,capRates));
        }
SWIGINTERN FloorPtr *new_FloorPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &floorRates){
            return new FloorPtr(new Floor(leg,floorRates));
        }
SWIGINTERN CollarPtr *new_CollarPtr(std::vector<boost::shared_ptr<CashFlow > > const &leg,std::vector<Rate > const &capRates,std::vector<Rate > const &floorRates){
            return new CollarPtr(new Collar(leg,capRates,floorRates));
        }

using QuantLib::BlackCapFloorEngine;
typedef boost::shared_ptr<PricingEngine> BlackCapFloorEnginePtr;

SWIGINTERN BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Handle<Quote > const &vol){
            return new BlackCapFloorEnginePtr(
                                  new BlackCapFloorEngine(termStructure,vol));
        }
SWIGINTERN BlackCapFloorEnginePtr *new_BlackCapFloorEnginePtr__SWIG_1(Handle<YieldTermStructure > const &termStructure,Handle<OptionletVolatilityStructure > const &vol){
            return new BlackCapFloorEnginePtr(
                                  new BlackCapFloorEngine(termStructure,vol));
        }

using QuantLib::CompoundForward;
typedef boost::shared_ptr<YieldTermStructure> CompoundForwardPtr;

SWIGINTERN CompoundForwardPtr *new_CompoundForwardPtr(Date const &settlementDate,std::vector<Date > const &dates,std::vector<Rate > const &rates,Calendar calendar,BusinessDayConvention roll,Integer compounding,DayCounter const &dayCounter){
            return new CompoundForwardPtr(
                new CompoundForward(settlementDate,
                                    dates, rates, calendar, roll,
                                    compounding, dayCounter));
        }
SWIGINTERN std::vector<Date > const &CompoundForwardPtr_dates(CompoundForwardPtr *self){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                 ->dates();
        }
SWIGINTERN Rate CompoundForwardPtr_compoundForward__SWIG_0(CompoundForwardPtr const *self,Date const &d,Integer f,bool extrapolate=false){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                ->compoundForward(d, f, extrapolate);
        }
SWIGINTERN Rate CompoundForwardPtr_compoundForward__SWIG_2(CompoundForwardPtr const *self,Time const t,Integer f,bool extrapolate=false){
            return boost::dynamic_pointer_cast<CompoundForward>(*self)
                ->compoundForward(t, f, extrapolate);
        }

using QuantLib::Dividend;

SWIGINTERN bool boost_shared_ptr_Sl_Dividend_Sg__isNull(boost::shared_ptr<Dividend > *self){
                return !(*self);
            }

using QuantLib::FixedDividend;
using QuantLib::FractionalDividend;

typedef boost::shared_ptr<Dividend> FixedDividendPtr;
typedef boost::shared_ptr<Dividend> FractionalDividendPtr;

SWIGINTERN FixedDividendPtr *new_FixedDividendPtr(Real amount,Date const &date){
            return new FixedDividendPtr(new FixedDividend(amount,date));
        }
SWIGINTERN FractionalDividendPtr *new_FractionalDividendPtr(Rate rate,Date const &date){
            return new FractionalDividendPtr(
                                     new FractionalDividend(rate,date));
        }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__set(std::vector<boost::shared_ptr<Dividend > > *self,int i,boost::shared_ptr<Dividend > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN boost::shared_ptr<Dividend > *std_vector_Sl_boost_shared_ptr_Sl_Dividend_Sg__Sg__to_array(std::vector<boost::shared_ptr<Dividend > > *self){
		boost::shared_ptr<Dividend > *array = new boost::shared_ptr<Dividend >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

using QuantLib::ConvertibleZeroCouponBond;
using QuantLib::ConvertibleFixedCouponBond;
using QuantLib::ConvertibleFloatingRateBond;
using QuantLib::BinomialConvertibleEngine;
typedef boost::shared_ptr<Instrument> ConvertibleZeroCouponBondPtr;
typedef boost::shared_ptr<Instrument> ConvertibleFixedCouponBondPtr;
typedef boost::shared_ptr<Instrument> ConvertibleFloatingRateBondPtr;
typedef boost::shared_ptr<PricingEngine> BinomialConvertibleEnginePtr;

SWIGINTERN ConvertibleZeroCouponBondPtr *new_ConvertibleZeroCouponBondPtr__SWIG_0(boost::shared_ptr<Exercise > const &exercise,Real conversionRatio,std::vector<boost::shared_ptr<Dividend > > const &dividends,std::vector<boost::shared_ptr<Callability > > const &callability,Handle<Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100.0){
            return new ConvertibleZeroCouponBondPtr(
                     new ConvertibleZeroCouponBond(exercise, conversionRatio,
                                                   dividends, callability,
                                                   creditSpread,
                                                   issueDate, settlementDays,
                                                   dayCounter, schedule,
                                                   redemption));
        }
SWIGINTERN ConvertibleFixedCouponBondPtr *new_ConvertibleFixedCouponBondPtr__SWIG_0(boost::shared_ptr<Exercise > const &exercise,Real conversionRatio,std::vector<boost::shared_ptr<Dividend > > const &dividends,std::vector<boost::shared_ptr<Callability > > const &callability,Handle<Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,std::vector<Rate > const &coupons,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100.0){
            return new ConvertibleFixedCouponBondPtr(
                    new ConvertibleFixedCouponBond(exercise, conversionRatio,
                                                   dividends, callability,
                                                   creditSpread,
                                                   issueDate, settlementDays,
                                                   coupons, dayCounter,
                                                   schedule, redemption));
        }
SWIGINTERN ConvertibleFloatingRateBondPtr *new_ConvertibleFloatingRateBondPtr__SWIG_0(boost::shared_ptr<Exercise > const &exercise,Real conversionRatio,std::vector<boost::shared_ptr<Dividend > > const &dividends,std::vector<boost::shared_ptr<Callability > > const &callability,Handle<Quote > const &creditSpread,Date const &issueDate,Integer settlementDays,IborIndexPtr const &index,Integer fixingDays,std::vector<Spread > const &spreads,DayCounter const &dayCounter,Schedule const &schedule,Real redemption=100.0){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new ConvertibleFloatingRateBondPtr(
                   new ConvertibleFloatingRateBond(exercise, conversionRatio,
                                                   dividends, callability,
                                                   creditSpread,
                                                   issueDate, settlementDays,
                                                   libor, fixingDays, spreads,
                                                   dayCounter, schedule,
                                                   redemption));
        }
SWIGINTERN BinomialConvertibleEnginePtr *new_BinomialConvertibleEnginePtr(GeneralizedBlackScholesProcessPtr const &process,std::string const &type,Size steps){
            boost::shared_ptr<GeneralizedBlackScholesProcess> bsProcess =
                 boost::dynamic_pointer_cast<GeneralizedBlackScholesProcess>(
                                                                     process);
            QL_REQUIRE(bsProcess, "Black-Scholes process required");
            std::string s = boost::algorithm::to_lower_copy(type);
            if (s == "crr" || s == "coxrossrubinstein")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<CoxRossRubinstein>(
                                                            bsProcess,steps));
            else if (s == "jr" || s == "jarrowrudd")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<JarrowRudd>(
                                                            bsProcess,steps));
            else if (s == "eqp")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<AdditiveEQPBinomialTree>(
                                                            bsProcess,steps));
            else if (s == "trigeorgis")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Trigeorgis>(
                                                            bsProcess,steps));
            else if (s == "tian")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Tian>(bsProcess,steps));
            else if (s == "lr" || s == "leisenreimer")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<LeisenReimer>(
                                                            bsProcess,steps));
            else if (s == "j4" || s == "joshi4")
                return new BinomialConvertibleEnginePtr(
                    new BinomialConvertibleEngine<Joshi4>(bsProcess,steps));
            else
                QL_FAIL("unknown binomial engine type: "+s);
        }

using QuantLib::InterpolatedDiscountCurve;


typedef boost::shared_ptr<YieldTermStructure> DiscountCurvePtr;

SWIGINTERN DiscountCurvePtr *new_DiscountCurvePtr__SWIG_0(std::vector<Date > const &dates,std::vector<DiscountFactor > const &discounts,DayCounter const &dayCounter,Calendar const &calendar=Calendar(),LogLinear const &i=LogLinear()){
            return new DiscountCurvePtr(
                new InterpolatedDiscountCurve<LogLinear>(dates,discounts,
                                                            dayCounter,
                                                            calendar,i));
        }
SWIGINTERN std::vector<Date > const &DiscountCurvePtr_dates(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->dates();
        }
SWIGINTERN std::vector<DiscountFactor > const &DiscountCurvePtr_discounts(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->discounts();
        }
SWIGINTERN std::vector<std::pair<Date,DiscountFactor > > DiscountCurvePtr_nodes(DiscountCurvePtr *self){
            typedef InterpolatedDiscountCurve<LogLinear> DiscountCurve;
            return boost::dynamic_pointer_cast<DiscountCurve>(*self)->nodes();
        }

using QuantLib::NormalDistribution;
using QuantLib::CumulativeNormalDistribution;
using QuantLib::MoroInverseCumulativeNormal;
using QuantLib::InverseCumulativeNormal;
using QuantLib::BivariateCumulativeNormalDistribution;


using QuantLib::Money;

static int SWIG_ENUM__Money__NoConversion = Money::NoConversion;
static int SWIG_ENUM__Money__BaseCurrencyConversion = Money::BaseCurrencyConversion;
static int SWIG_ENUM__Money__AutomatedConversion = Money::AutomatedConversion;
SWIGINTERN void Money_setConversionType(Money::ConversionType type){
            Money::conversionType = type;
        }
SWIGINTERN void Money_setBaseCurrency(Currency const &c){
            Money::baseCurrency = c;
        }

using QuantLib::ExchangeRate;
using QuantLib::ExchangeRateManager;

static int SWIG_ENUM__ExchangeRate__Direct = ExchangeRate::Direct;
static int SWIG_ENUM__ExchangeRate__Derived = ExchangeRate::Derived;

using QuantLib::InterpolatedForwardCurve;


typedef boost::shared_ptr<YieldTermStructure> ForwardCurvePtr;

SWIGINTERN ForwardCurvePtr *new_ForwardCurvePtr__SWIG_0(std::vector<Date > const &dates,std::vector<Rate > const &forwards,DayCounter const &dayCounter,BackwardFlat const &i=BackwardFlat()){
            return new ForwardCurvePtr(
                new InterpolatedForwardCurve<BackwardFlat>(dates,forwards,
                                                           dayCounter,i));
        }
SWIGINTERN std::vector<Date > const &ForwardCurvePtr_dates(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->dates();
        }
SWIGINTERN std::vector<Rate > const &ForwardCurvePtr_forwards(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->forwards();
        }
SWIGINTERN std::vector<std::pair<Date,Rate > > ForwardCurvePtr_nodes(ForwardCurvePtr *self){
            typedef InterpolatedForwardCurve<BackwardFlat> ForwardCurve;
            return boost::dynamic_pointer_cast<ForwardCurve>(*self)->nodes();
        }

using QuantLib::TimeGrid;

SWIGINTERN TimeGrid *new_TimeGrid__SWIG_2(std::vector<Time > const &times){
            return new TimeGrid(times.begin(), times.end());
        }
SWIGINTERN TimeGrid *new_TimeGrid__SWIG_3(std::vector<Time > const &times,Size steps){
            return new TimeGrid(times.begin(), times.end(), steps);
        }

using QuantLib::SegmentIntegral;
using QuantLib::TrapezoidIntegral;
using QuantLib::Default;
using QuantLib::MidPoint;
using QuantLib::SimpsonIntegral;
using QuantLib::GaussKronrodAdaptive;
using QuantLib::GaussKronrodNonAdaptive;


using QuantLib::Sample;

using QuantLib::LecuyerUniformRng;
using QuantLib::KnuthUniformRng;
using QuantLib::MersenneTwisterUniformRng;

typedef QuantLib::PseudoRandom::urng_type UniformRandomGenerator;

using QuantLib::CLGaussianRng;
using QuantLib::BoxMullerGaussianRng;
using QuantLib::InverseCumulativeRng;

typedef QuantLib::PseudoRandom::rng_type GaussianRandomGenerator;

using QuantLib::RandomSequenceGenerator;

typedef QuantLib::PseudoRandom::ursg_type UniformRandomSequenceGenerator;

using QuantLib::HaltonRsg;
using QuantLib::SobolRsg;

typedef QuantLib::LowDiscrepancy::ursg_type
    UniformLowDiscrepancySequenceGenerator;

using QuantLib::InverseCumulativeRsg;

typedef QuantLib::PseudoRandom::rsg_type GaussianRandomSequenceGenerator;
typedef QuantLib::LowDiscrepancy::rsg_type
    GaussianLowDiscrepancySequenceGenerator;

SWIGINTERN double Sample_Sl_Real_Sg__value(Sample<Real > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Real_Sg__weight(Sample<Real > *self){ return self->weight; }
SWIGINTERN Array Sample_Sl_Array_Sg__value(Sample<Array > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Array_Sg__weight(Sample<Array > *self){ return self->weight; }
SWIGINTERN std::vector<double > Sample_Sl_std_vector_Sl_Real_Sg__Sg__value(Sample<std::vector<Real > > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_std_vector_Sl_Real_Sg__Sg__weight(Sample<std::vector<Real > > *self){ return self->weight; }

Matrix getCovariance(const Array& volatilities, const Matrix& correlations) {
    return QuantLib::getCovariance(volatilities.begin(),
                                   volatilities.end(),
                                   correlations);
}


using QuantLib::Path;


typedef QuantLib::PathGenerator<GaussianRandomSequenceGenerator>
    GaussianPathGenerator;

SWIGINTERN Path Sample_Sl_Path_Sg__value(Sample<Path > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_Path_Sg__weight(Sample<Path > *self){ return self->weight; }
SWIGINTERN GaussianPathGenerator *new_GaussianPathGenerator(StochasticProcess1DPtr const &process,Time length,Size steps,GaussianRandomSequenceGenerator const &rsg,bool brownianBridge){
            boost::shared_ptr<StochasticProcess1D> process1d =
                boost::dynamic_pointer_cast<StochasticProcess1D>(process);
            return new GaussianPathGenerator(process1d,length,steps,
                                             rsg,brownianBridge);
        }

using QuantLib::MultiPath;


typedef QuantLib::MultiPathGenerator<GaussianRandomSequenceGenerator>
    GaussianMultiPathGenerator;

SWIGINTERN MultiPath Sample_Sl_MultiPath_Sg__value(Sample<MultiPath > *self){ return self->value; }
SWIGINTERN Real Sample_Sl_MultiPath_Sg__weight(Sample<MultiPath > *self){ return self->weight; }
SWIGINTERN GaussianMultiPathGenerator *new_GaussianMultiPathGenerator__SWIG_0(boost::shared_ptr<StochasticProcess > const &process,std::vector<Time > const &times,GaussianRandomSequenceGenerator const &generator,bool brownianBridge=false){
          return new GaussianMultiPathGenerator(process,
                                                QuantLib::TimeGrid(
                                                    times.begin(),
                                                    times.end()),
                                                generator,
                                                brownianBridge);
      }

typedef QuantLib::BoundaryCondition<QuantLib::TridiagonalOperator>
        DefaultBoundaryCondition;

SWIGINTERN bool boost_shared_ptr_Sl_DefaultBoundaryCondition_Sg__isNull(boost::shared_ptr<DefaultBoundaryCondition > *self){
                return !(*self);
            }
static enum DefaultBoundaryCondition::Side _swig_wrap_DefaultBoundaryCondition_xxNone = DefaultBoundaryCondition::None;
static enum DefaultBoundaryCondition::Side _swig_wrap_DefaultBoundaryCondition_xxUpper = DefaultBoundaryCondition::Upper;
static enum DefaultBoundaryCondition::Side _swig_wrap_DefaultBoundaryCondition_xxLower = DefaultBoundaryCondition::Lower;

using QuantLib::NeumannBC;
using QuantLib::DirichletBC;
typedef boost::shared_ptr<DefaultBoundaryCondition> NeumannBCPtr;
typedef boost::shared_ptr<DefaultBoundaryCondition> DirichletBCPtr;

SWIGINTERN NeumannBCPtr *new_NeumannBCPtr(Real value,DefaultBoundaryCondition::Side side){
            return new NeumannBCPtr(new NeumannBC(value, side));
        }
SWIGINTERN DirichletBCPtr *new_DirichletBCPtr(Real value,DefaultBoundaryCondition::Side side){
            return new DirichletBCPtr(new DirichletBC(value, side));
        }

using QuantLib::TridiagonalOperator;


using QuantLib::DPlus;
using QuantLib::DMinus;
using QuantLib::DZero;
using QuantLib::DPlusDMinus;


using QuantLib::Bisection;
using QuantLib::Brent;
using QuantLib::FalsePosition;
using QuantLib::Newton;
using QuantLib::NewtonSafe;
using QuantLib::Ridder;
using QuantLib::Secant;


using QuantLib::Constraint;
using QuantLib::BoundaryConstraint;
using QuantLib::NoConstraint;
using QuantLib::PositiveConstraint;


using QuantLib::EndCriteria;

static int SWIG_ENUM__EndCriteria__MaxIterations = EndCriteria::MaxIterations;
static int SWIG_ENUM__EndCriteria__StationaryPoint = EndCriteria::StationaryPoint;
static int SWIG_ENUM__EndCriteria__StationaryFunctionValue = EndCriteria::StationaryFunctionValue;
static int SWIG_ENUM__EndCriteria__StationaryFunctionAccuracy = EndCriteria::StationaryFunctionAccuracy;
static int SWIG_ENUM__EndCriteria__ZeroGradientNorm = EndCriteria::ZeroGradientNorm;
static int SWIG_ENUM__EndCriteria__Unknown = EndCriteria::Unknown;

using QuantLib::OptimizationMethod;
using QuantLib::ConjugateGradient;
using QuantLib::Simplex;
using QuantLib::SteepestDescent;


using QuantLib::Problem;


    class Optimizer {};


using QuantLib::RateHelper;
using QuantLib::DepositRateHelper;
using QuantLib::FraRateHelper;
using QuantLib::FuturesRateHelper;
using QuantLib::SwapRateHelper;
using QuantLib::FixedRateBondHelper;
typedef boost::shared_ptr<RateHelper> DepositRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FraRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FuturesRateHelperPtr;
typedef boost::shared_ptr<RateHelper> SwapRateHelperPtr;
typedef boost::shared_ptr<RateHelper> FixedRateBondHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_RateHelper_Sg__isNull(boost::shared_ptr<RateHelper > *self){
                return !(*self);
            }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Period const &tenor,Natural settlementDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,Natural fixingDays,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,tenor,settlementDays,
                                      calendar,convention,
                                      endOfMonth, fixingDays,
                                      dayCounter));
        }
SWIGINTERN DepositRateHelperPtr *new_DepositRateHelperPtr__SWIG_1(Rate rate,Period const &tenor,Natural settlementDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,Natural fixingDays,DayCounter const &dayCounter){
            return new DepositRateHelperPtr(
                new DepositRateHelper(rate,tenor,settlementDays,
                                      calendar,convention,
                                      endOfMonth, fixingDays,
                                      dayCounter));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Natural monthsToStart,Natural monthsToEnd,Natural settlementDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,Natural fixingDays,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  endOfMonth, fixingDays,
                                  dayCounter));
        }
SWIGINTERN FraRateHelperPtr *new_FraRateHelperPtr__SWIG_1(Rate rate,Natural monthsToStart,Natural monthsToEnd,Natural settlementDays,Calendar const &calendar,BusinessDayConvention convention,bool endOfMonth,Natural fixingDays,DayCounter const &dayCounter){
            return new FraRateHelperPtr(
                new FraRateHelper(rate,monthsToStart,monthsToEnd,
                                  settlementDays,calendar,convention,
                                  endOfMonth, fixingDays,
                                  dayCounter));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_0(Handle<Quote > const &price,Date const &immDate,Natural nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Handle<Quote > const &convexityAdjustment){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter,
                                      convexityAdjustment));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_1(Handle<Quote > const &price,Date const &immDate,Natural nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Rate convexityAdjustment=0.0){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter,
                                      convexityAdjustment));
        }
SWIGINTERN FuturesRateHelperPtr *new_FuturesRateHelperPtr__SWIG_3(Real price,Date const &immDate,Natural nMonths,Calendar const &calendar,BusinessDayConvention convention,DayCounter const &dayCounter,Rate convexityAdjustment=0.0){
            return new FuturesRateHelperPtr(
                new FuturesRateHelper(price,immDate,nMonths,
                                      calendar,convention,dayCounter,
                                      convexityAdjustment));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_0(Handle<Quote > const &rate,Period const &tenor,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,IborIndexPtr const &index){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, tenor, calendar,
                                   fixedFrequency, fixedConvention,
                                   fixedDayCount, libor));
        }
SWIGINTERN SwapRateHelperPtr *new_SwapRateHelperPtr__SWIG_1(Rate rate,Period const &tenor,Calendar const &calendar,Frequency fixedFrequency,BusinessDayConvention fixedConvention,DayCounter const &fixedDayCount,IborIndexPtr const &index){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwapRateHelperPtr(
                new SwapRateHelper(rate, tenor, calendar,
                                   fixedFrequency, fixedConvention,
                                   fixedDayCount, libor));
        }
SWIGINTERN FixedRateBondHelperPtr *new_FixedRateBondHelperPtr__SWIG_0(Handle<Quote > const &cleanPrice,Size settlementDays,Schedule const &schedule,std::vector<Rate > const &coupons,DayCounter const &paymentDayCounter,BusinessDayConvention paymentConvention=Following,Real redemption=100.0,Date const &issueDate=Date()){
            return new FixedRateBondHelperPtr(
                new FixedRateBondHelper(cleanPrice, settlementDays,
                                        schedule, coupons, paymentDayCounter,
                                        paymentConvention, redemption,
                                        issueDate));
        }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__set(std::vector<boost::shared_ptr<RateHelper > > *self,int i,boost::shared_ptr<RateHelper > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN boost::shared_ptr<RateHelper > *std_vector_Sl_boost_shared_ptr_Sl_RateHelper_Sg__Sg__to_array(std::vector<boost::shared_ptr<RateHelper > > *self){
		boost::shared_ptr<RateHelper > *array = new boost::shared_ptr<RateHelper >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

using QuantLib::Discount;
using QuantLib::ZeroYield;
using QuantLib::ForwardRate;


using QuantLib::PiecewiseYieldCurve;


typedef boost::shared_ptr<YieldTermStructure> PiecewiseFlatForwardPtr;

SWIGINTERN PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_0(Date const &referenceDate,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12,BackwardFlat const &i=BackwardFlat()){
            return new PiecewiseFlatForwardPtr(
                new PiecewiseYieldCurve<ForwardRate,BackwardFlat>(
                                                    referenceDate,instruments,
                                                    dayCounter,accuracy,i));
        }
SWIGINTERN PiecewiseFlatForwardPtr *new_PiecewiseFlatForwardPtr__SWIG_3(Integer settlementDays,Calendar const &calendar,std::vector<boost::shared_ptr<RateHelper > > const &instruments,DayCounter const &dayCounter,Real accuracy=1.0e-12,BackwardFlat const &i=BackwardFlat()){
            return new PiecewiseFlatForwardPtr(
                new PiecewiseYieldCurve<ForwardRate,BackwardFlat>(
                                        settlementDays, calendar, instruments,
                                        dayCounter, accuracy, i));
        }
SWIGINTERN std::vector<Date > const &PiecewiseFlatForwardPtr_dates(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,BackwardFlat> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->dates();
        }
SWIGINTERN std::vector<Time > const &PiecewiseFlatForwardPtr_times(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,BackwardFlat> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->times();
        }
SWIGINTERN std::vector<std::pair<Date,Real > > PiecewiseFlatForwardPtr_nodes(PiecewiseFlatForwardPtr *self){
            typedef PiecewiseYieldCurve<ForwardRate,BackwardFlat> PiecewiseFlatForward;
            return boost::dynamic_pointer_cast<PiecewiseFlatForward>(*self)->nodes();
        }

using QuantLib::Settings;

SWIGINTERN Date Settings_getEvaluationDate(Settings *self){
            return self->evaluationDate();
        }
SWIGINTERN void Settings_setEvaluationDate(Settings *self,Date const &d){
            self->evaluationDate() = d;
        }

using QuantLib::CalibrationHelper;
using QuantLib::SwaptionHelper;
using QuantLib::CapHelper;
typedef boost::shared_ptr<CalibrationHelper> SwaptionHelperPtr;
typedef boost::shared_ptr<CalibrationHelper> CapHelperPtr;

SWIGINTERN bool boost_shared_ptr_Sl_CalibrationHelper_Sg__isNull(boost::shared_ptr<CalibrationHelper > *self){
                return !(*self);
            }
SWIGINTERN SwaptionHelperPtr *new_SwaptionHelperPtr__SWIG_0(Period const &maturity,Period const &length,Handle<Quote > const &volatility,IborIndexPtr const &index,Period const &fixedLegTenor,DayCounter const &fixedLegDayCounter,DayCounter const &floatingLegDayCounter,Handle<YieldTermStructure > const &termStructure,bool calibrateVolatility=false){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new SwaptionHelperPtr(
                new SwaptionHelper(maturity,length,volatility,
                                   libor,fixedLegTenor,
                                   fixedLegDayCounter,
                                   floatingLegDayCounter,
                                   termStructure,
                                   calibrateVolatility));
        }
SWIGINTERN std::vector<Time > SwaptionHelperPtr_times(SwaptionHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN CapHelperPtr *new_CapHelperPtr(Period const &length,Handle<Quote > const &volatility,IborIndexPtr const &index,Frequency fixedLegFrequency,DayCounter const &fixedLegDayCounter,bool includeFirstSwaplet,Handle<YieldTermStructure > const &termStructure){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new CapHelperPtr(
                new CapHelper(length,volatility,libor,fixedLegFrequency,
                              fixedLegDayCounter,includeFirstSwaplet,
                              termStructure));
        }
SWIGINTERN std::vector<Time > CapHelperPtr_times(CapHelperPtr *self){
            std::list<Time> l;
            (*self)->addTimesTo(l);
            std::vector<Time> v;
            std::copy(l.begin(),l.end(),std::back_inserter(v));
            return v;
        }
SWIGINTERN void std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__set(std::vector<boost::shared_ptr<CalibrationHelper > > *self,int i,boost::shared_ptr<CalibrationHelper > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN boost::shared_ptr<CalibrationHelper > *std_vector_Sl_boost_shared_ptr_Sl_CalibrationHelper_Sg__Sg__to_array(std::vector<boost::shared_ptr<CalibrationHelper > > *self){
		boost::shared_ptr<CalibrationHelper > *array = new boost::shared_ptr<CalibrationHelper >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }

using QuantLib::ShortRateModel;

SWIGINTERN bool boost_shared_ptr_Sl_ShortRateModel_Sg__isNull(boost::shared_ptr<ShortRateModel > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_ShortRateModel_Sg__asObservable(boost::shared_ptr<ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_ShortRateModel_Sg__asObservable(Handle<ShortRateModel > *self){
        return boost::shared_ptr<Observable>(*self);
    }

    using QuantLib::Vasicek;
    using QuantLib::HullWhite;
    using QuantLib::BlackKarasinski;
    using QuantLib::G2;
    typedef boost::shared_ptr<ShortRateModel> VasicekPtr;
    typedef boost::shared_ptr<ShortRateModel> HullWhitePtr;
    typedef boost::shared_ptr<ShortRateModel> BlackKarasinskiPtr;
    typedef boost::shared_ptr<ShortRateModel> G2Ptr;

SWIGINTERN VasicekPtr *new_VasicekPtr__SWIG_0(Rate r0=0.05,Real a=0.1,Real b=0.05,Real sigma=0.01,Real lambda=0.0){
            return new VasicekPtr(new Vasicek(r0, a, b, sigma, lambda));
        }
SWIGINTERN DiscountFactor VasicekPtr_discount(VasicekPtr const *self,Time t){
            return boost::dynamic_pointer_cast<Vasicek>(*self)->discount(t);
        }
SWIGINTERN HullWhitePtr *new_HullWhitePtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01){
            return new HullWhitePtr(
                new HullWhite(termStructure, a, sigma));
        }
SWIGINTERN DiscountFactor HullWhitePtr_discount(HullWhitePtr const *self,Time t){
            return boost::dynamic_pointer_cast<HullWhite>(*self)->discount(t);
        }
SWIGINTERN BlackKarasinskiPtr *new_BlackKarasinskiPtr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.1){
            return new BlackKarasinskiPtr(
                new BlackKarasinski(termStructure, a, sigma));
        }
SWIGINTERN G2Ptr *new_G2Ptr__SWIG_0(Handle<YieldTermStructure > const &termStructure,Real a=0.1,Real sigma=0.01,Real b=0.1,Real eta=0.01,Real rho=-0.75){
            return new G2Ptr(new G2(termStructure, a, sigma, b, eta, rho));
        }
SWIGINTERN DiscountFactor G2Ptr_discount(G2Ptr const *self,Time t){
            return boost::dynamic_pointer_cast<G2>(*self)->discount(t);
        }

using QuantLib::JamshidianSwaptionEngine;
using QuantLib::TreeSwaptionEngine;
using QuantLib::AnalyticCapFloorEngine;
using QuantLib::TreeCapFloorEngine;
using QuantLib::G2SwaptionEngine;
typedef boost::shared_ptr<PricingEngine> JamshidianSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeSwaptionEnginePtr;
typedef boost::shared_ptr<PricingEngine> AnalyticCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> TreeCapFloorEnginePtr;
typedef boost::shared_ptr<PricingEngine> G2SwaptionEnginePtr;

SWIGINTERN JamshidianSwaptionEnginePtr *new_JamshidianSwaptionEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new JamshidianSwaptionEnginePtr(
                               new JamshidianSwaptionEngine(m,termStructure));
        }
SWIGINTERN TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            return new TreeSwaptionEnginePtr(
                       new TreeSwaptionEngine(model,timeSteps,termStructure));
        }
SWIGINTERN TreeSwaptionEnginePtr *new_TreeSwaptionEnginePtr__SWIG_2(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            return new TreeSwaptionEnginePtr(
                            new TreeSwaptionEngine(model,grid,termStructure));
        }
SWIGINTERN AnalyticCapFloorEnginePtr *new_AnalyticCapFloorEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            using QuantLib::OneFactorAffineModel;
            boost::shared_ptr<OneFactorAffineModel> m =
                 boost::dynamic_pointer_cast<OneFactorAffineModel>(model);
            QL_REQUIRE(model, "affine model required");
            return new AnalyticCapFloorEnginePtr(
                                 new AnalyticCapFloorEngine(m,termStructure));
        }
SWIGINTERN TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_0(boost::shared_ptr<ShortRateModel > const &model,Size timeSteps,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            return new TreeCapFloorEnginePtr(
                       new TreeCapFloorEngine(model,timeSteps,termStructure));
        }
SWIGINTERN TreeCapFloorEnginePtr *new_TreeCapFloorEnginePtr__SWIG_2(boost::shared_ptr<ShortRateModel > const &model,TimeGrid const &grid,Handle<YieldTermStructure > const &termStructure=Handle<YieldTermStructure >()){
            return new TreeCapFloorEnginePtr(
                            new TreeCapFloorEngine(model,grid,termStructure));
        }
SWIGINTERN G2SwaptionEnginePtr *new_G2SwaptionEnginePtr(boost::shared_ptr<ShortRateModel > const &model,Real range,Size intervals){
            boost::shared_ptr<G2> g2 =
                boost::dynamic_pointer_cast<G2>(model);
            return new G2SwaptionEnginePtr(
                                    new G2SwaptionEngine(g2,range,intervals));
        }

using QuantLib::Statistics;
using QuantLib::RiskStatistics;
using QuantLib::GenericSequenceStatistics;

SWIGINTERN void Statistics_add__SWIG_2(Statistics *self,std::vector<Real > const &values){
            self->addSequence(values.begin(), values.end());
        }
SWIGINTERN void Statistics_add__SWIG_3(Statistics *self,std::vector<Real > const &values,std::vector<Real > const &weights){
            self->addSequence(values.begin(), values.end(), weights.begin());
        }

using QuantLib::TimeBasket;


using QuantLib::Swap;
using QuantLib::VanillaSwap;
using QuantLib::DiscountingSwapEngine;

typedef boost::shared_ptr<Instrument> SwapPtr;
typedef boost::shared_ptr<Instrument> VanillaSwapPtr;
typedef boost::shared_ptr<PricingEngine> DiscountingSwapEnginePtr;

SWIGINTERN SwapPtr *new_SwapPtr(std::vector<boost::shared_ptr<CashFlow > > const &firstLeg,std::vector<boost::shared_ptr<CashFlow > > const &secondLeg){
            return new SwapPtr(new Swap(firstLeg, secondLeg));
        }
SWIGINTERN Date SwapPtr_startDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->startDate();
        }
SWIGINTERN Date SwapPtr_maturityDate(SwapPtr *self){
            return boost::dynamic_pointer_cast<Swap>(*self)->maturityDate();
        }
static enum VanillaSwap::Type _swig_wrap_VanillaSwap_xxReceiver = VanillaSwap::Receiver;
static enum VanillaSwap::Type _swig_wrap_VanillaSwap_xxPayer = VanillaSwap::Payer;
SWIGINTERN VanillaSwapPtr *new_VanillaSwapPtr(VanillaSwap::Type type,Real nominal,Schedule const &fixedSchedule,Rate fixedRate,DayCounter const &fixedDayCount,Schedule const &floatSchedule,IborIndexPtr const &index,Spread spread,DayCounter const &floatingDayCount){
            boost::shared_ptr<IborIndex> libor =
                boost::dynamic_pointer_cast<IborIndex>(index);
            return new VanillaSwapPtr(
                    new VanillaSwap(type, nominal,fixedSchedule,fixedRate,
                                    fixedDayCount,floatSchedule,libor,
                                    spread, floatingDayCount));
        }
SWIGINTERN Rate VanillaSwapPtr_fairRate(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)->fairRate();
        }
SWIGINTERN Spread VanillaSwapPtr_fairSpread(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->fairSpread();
        }
SWIGINTERN Real VanillaSwapPtr_fixedLegBPS(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->fixedLegBPS();
        }
SWIGINTERN Real VanillaSwapPtr_floatingLegBPS(VanillaSwapPtr *self){
            return boost::dynamic_pointer_cast<VanillaSwap>(*self)
                 ->floatingLegBPS();
        }
SWIGINTERN DiscountingSwapEnginePtr *new_DiscountingSwapEnginePtr(Handle<YieldTermStructure > const &discountCurve){
            return new DiscountingSwapEnginePtr(
                                    new DiscountingSwapEngine(discountCurve));
        }

using QuantLib::CapFloorTermVolatilityStructure;

SWIGINTERN bool boost_shared_ptr_Sl_CapFloorTermVolatilityStructure_Sg__isNull(boost::shared_ptr<CapFloorTermVolatilityStructure > *self){
                return !(*self);
            }
SWIGINTERN boost::shared_ptr<Observable > boost_shared_ptr_Sl_CapFloorTermVolatilityStructure_Sg__asObservable(boost::shared_ptr<CapFloorTermVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }
SWIGINTERN boost::shared_ptr<Observable > Handle_Sl_CapFloorTermVolatilityStructure_Sg__asObservable(Handle<CapFloorTermVolatilityStructure > *self){
        return boost::shared_ptr<Observable>(*self);
    }

using QuantLib::CapFloorTermVolCurve;
typedef boost::shared_ptr<CapFloorTermVolatilityStructure> CapFloorTermVolCurvePtr;

SWIGINTERN CapFloorTermVolCurvePtr *new_CapFloorTermVolCurvePtr__SWIG_0(Date const &referenceDate,Calendar const &calendar,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,BusinessDayConvention bdc=Following,DayCounter const &dc=QuantLib::Actual365Fixed()){
            return new CapFloorTermVolCurvePtr(
                new CapFloorTermVolCurve(referenceDate,calendar,
                                          lengths,vols,bdc,dc));
        }
SWIGINTERN CapFloorTermVolCurvePtr *new_CapFloorTermVolCurvePtr__SWIG_3(Natural settlementDays,Calendar const &calendar,std::vector<Period > const &lengths,std::vector<Volatility > const &vols,BusinessDayConvention bdc=Following,DayCounter const &dc=QuantLib::Actual365Fixed()){
            return new CapFloorTermVolCurvePtr(
                new CapFloorTermVolCurve(settlementDays,calendar,
                                          lengths,vols,bdc,dc));
        }

using QuantLib::Swaption;
using QuantLib::Settlement;
typedef boost::shared_ptr<Instrument> SwaptionPtr;

static int SWIG_ENUM__Settlement__Physical = Settlement::Physical;
static int SWIG_ENUM__Settlement__Cash = Settlement::Cash;
SWIGINTERN SwaptionPtr *new_SwaptionPtr__SWIG_0(VanillaSwapPtr const &simpleSwap,boost::shared_ptr<Exercise > const &exercise,Settlement::Type type=Settlement::Physical){
            boost::shared_ptr<VanillaSwap> swap =
                 boost::dynamic_pointer_cast<VanillaSwap>(simpleSwap);
            QL_REQUIRE(swap, "simple swap required");
            return new SwaptionPtr(new Swaption(swap,exercise,type));
        }

using QuantLib::BlackSwaptionEngine;
typedef boost::shared_ptr<PricingEngine> BlackSwaptionEnginePtr;

SWIGINTERN BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr__SWIG_0(Handle<YieldTermStructure > const &discountCurve,Handle<Quote > const &vol){
            return new BlackSwaptionEnginePtr(
                                 new BlackSwaptionEngine(discountCurve, vol));
        }
SWIGINTERN BlackSwaptionEnginePtr *new_BlackSwaptionEnginePtr__SWIG_1(Handle<YieldTermStructure > const &discountCurve,Handle<SwaptionVolatilityStructure > const &v){
            return new BlackSwaptionEnginePtr(
                                   new BlackSwaptionEngine(discountCurve, v));
        }

using QuantLib::Surface;
using QuantLib::Domain;

SWIGINTERN bool boost_shared_ptr_Sl_Surface_Sg__isNull(boost::shared_ptr<Surface > *self){
                return !(*self);
            }

using QuantLib::TestSurface;
typedef boost::shared_ptr<Surface> TestSurfacePtr;

SWIGINTERN TestSurfacePtr *new_TestSurfacePtr(){
            return new TestSurfacePtr(new TestSurface);
        }

using QuantLib::ConstantEstimator;
using QuantLib::SimpleLocalEstimator;
using QuantLib::GarmanKlassSigma1;
using QuantLib::ParkinsonSigma;
using QuantLib::GarmanKlassSigma3;
using QuantLib::GarmanKlassSigma4;
using QuantLib::GarmanKlassSigma5;
using QuantLib::GarmanKlassSigma6;


using QuantLib::InterpolatedZeroCurve;


typedef boost::shared_ptr<YieldTermStructure> ZeroCurvePtr;

SWIGINTERN ZeroCurvePtr *new_ZeroCurvePtr__SWIG_0(std::vector<Date > const &dates,std::vector<Rate > const &yields,DayCounter const &dayCounter,Linear const &i=Linear()){
            return new ZeroCurvePtr(
                new InterpolatedZeroCurve<Linear>(dates,yields,
                                                        dayCounter,i));
        }
SWIGINTERN std::vector<Date > const &ZeroCurvePtr_dates(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->dates();
        }
SWIGINTERN std::vector<Rate > const &ZeroCurvePtr_zeroRates(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->zeroRates();
        }
SWIGINTERN std::vector<std::pair<Date,Rate > > ZeroCurvePtr_nodes(ZeroCurvePtr *self){
            typedef InterpolatedZeroCurve<Linear> ZeroCurve;
            return boost::dynamic_pointer_cast<ZeroCurve>(*self)->nodes();
        }

using QuantLib::DiscreteGeometricASO;


// single asset
using QuantLib::McDiscreteArithmeticASO;

// multi asset
using QuantLib::McEverest;
using QuantLib::McHimalaya;
using QuantLib::McPagoda;

SWIGINTERN void std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__set(std::vector<Handle<YieldTermStructure > > *self,int i,Handle<YieldTermStructure > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN Handle<YieldTermStructure > *std_vector_Sl_Handle_Sl_YieldTermStructure_Sg__Sg__to_array(std::vector<Handle<YieldTermStructure > > *self){
		Handle<YieldTermStructure > *array = new Handle<YieldTermStructure >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }
SWIGINTERN void std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__set(std::vector<Handle<BlackVolTermStructure > > *self,int i,Handle<BlackVolTermStructure > const &x){
		self->resize(i+1);
		(*self)[i] = x;
	    }
SWIGINTERN Handle<BlackVolTermStructure > *std_vector_Sl_Handle_Sl_BlackVolTermStructure_Sg__Sg__to_array(std::vector<Handle<BlackVolTermStructure > > *self){
		Handle<BlackVolTermStructure > *array = new Handle<BlackVolTermStructure >[self->size() + 1];
		for( int i = 0; i < self->size(); i++ ) 
		    array[i] = (*self)[i];
		return array;
	    }
SWIGEXT CAML_VALUE _wrap_new_string__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::basic_string<char > *)new std::basic_string<char >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_string__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  char *arg1 = (char *) 0 ;
  std::basic_string<char > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) char * ... */
    arg1 = (char *)caml_string_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::basic_string<char > *)new std::basic_string<char >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_stringQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_string__SWIG_0QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_string: _v = 1; break;
          case C_ptr: {
            swig_type_info *typeinfo = 
            (swig_type_info *)(long)SWIG_Int64_val(SWIG_Field(argv[0],1));
            _v = SWIG_TypeCheck("char *",typeinfo) ||
            SWIG_TypeCheck("signed char *",typeinfo) ||
            SWIG_TypeCheck("unsigned char *",typeinfo) ||
            SWIG_TypeCheck("const char *",typeinfo) ||
            SWIG_TypeCheck("const signed char *",typeinfo) ||
            SWIG_TypeCheck("const unsigned char *",typeinfo) ||
            SWIG_TypeCheck("std::string",typeinfo);
          } break;
          default: _v = 0; break;
        }
      }    
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_string__SWIG_1QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_string'");
}


SWIGEXT CAML_VALUE _wrap_string_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  size_t result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  int arg2 ;
  char result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (char)((std::basic_string<char > const *)arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_char(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_c_strQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  char *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (char *)((std::basic_string<char > const *)arg1)->c_str();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string((char *)result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_operator_e_____SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  std::basic_string<char > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      {
        std::basic_string<char > &_result_ref = (arg1)->operator =((std::basic_string<char > const &)*arg2);
        result = (std::basic_string<char > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_operator_e_____SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  char *arg2 = (char *) 0 ;
  std::basic_string<char > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) char * ... */
    arg2 = (char *)caml_string_val(caml_list_nth(args,1));
  }
  {
    try {
      {
        std::basic_string<char > &_result_ref = (arg1)->operator =((char const *)arg2);
        result = (std::basic_string<char > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_operator_e___QuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_string_operator_e_____SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_string: _v = 1; break;
            case C_ptr: {
              swig_type_info *typeinfo = 
              (swig_type_info *)(long)SWIG_Int64_val(SWIG_Field(argv[1],1));
              _v = SWIG_TypeCheck("char *",typeinfo) ||
              SWIG_TypeCheck("signed char *",typeinfo) ||
              SWIG_TypeCheck("unsigned char *",typeinfo) ||
              SWIG_TypeCheck("const char *",typeinfo) ||
              SWIG_TypeCheck("const signed char *",typeinfo) ||
              SWIG_TypeCheck("const unsigned char *",typeinfo) ||
              SWIG_TypeCheck("std::string",typeinfo);
            } break;
            default: _v = 0; break;
          }
        }    
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_string_operator_e_____SWIG_1QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'string_operator ='");
}


SWIGEXT CAML_VALUE _wrap_string_append__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  std::basic_string<char > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      {
        std::basic_string<char > &_result_ref = (arg1)->append((std::basic_string<char > const &)*arg2);
        result = (std::basic_string<char > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_append__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  char *arg2 = (char *) 0 ;
  std::basic_string<char > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) char * ... */
    arg2 = (char *)caml_string_val(caml_list_nth(args,1));
  }
  {
    try {
      {
        std::basic_string<char > &_result_ref = (arg1)->append((char const *)arg2);
        result = (std::basic_string<char > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_appendQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_string_append__SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_string: _v = 1; break;
            case C_ptr: {
              swig_type_info *typeinfo = 
              (swig_type_info *)(long)SWIG_Int64_val(SWIG_Field(argv[1],1));
              _v = SWIG_TypeCheck("char *",typeinfo) ||
              SWIG_TypeCheck("signed char *",typeinfo) ||
              SWIG_TypeCheck("unsigned char *",typeinfo) ||
              SWIG_TypeCheck("const char *",typeinfo) ||
              SWIG_TypeCheck("const signed char *",typeinfo) ||
              SWIG_TypeCheck("const unsigned char *",typeinfo) ||
              SWIG_TypeCheck("std::string",typeinfo);
            } break;
            default: _v = 0; break;
          }
        }    
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_string_append__SWIG_1QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'string_append'");
}


SWIGEXT CAML_VALUE _wrap_string_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  char arg2 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      (arg1)->push_back(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_reserveQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char >::size_type arg2 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_resize__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char >::size_type arg2 ;
  char arg3 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    try {
      (arg1)->resize(arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_resize__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char >::size_type arg2 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      (arg1)->resize(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_resizeQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_string_resize__SWIG_1QuantLib(args));
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[2]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[2]) ) {
            case C_char: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_string_resize__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'string_resize'");
}


SWIGEXT CAML_VALUE _wrap_string_compare__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  int result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (int)((std::basic_string<char > const *)arg1)->compare((std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_compare__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  char *arg2 = (char *) 0 ;
  int result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) char * ... */
    arg2 = (char *)caml_string_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (int)((std::basic_string<char > const *)arg1)->compare((char const *)arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_compareQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_string_compare__SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_string: _v = 1; break;
            case C_ptr: {
              swig_type_info *typeinfo = 
              (swig_type_info *)(long)SWIG_Int64_val(SWIG_Field(argv[1],1));
              _v = SWIG_TypeCheck("char *",typeinfo) ||
              SWIG_TypeCheck("signed char *",typeinfo) ||
              SWIG_TypeCheck("unsigned char *",typeinfo) ||
              SWIG_TypeCheck("const char *",typeinfo) ||
              SWIG_TypeCheck("const signed char *",typeinfo) ||
              SWIG_TypeCheck("const unsigned char *",typeinfo) ||
              SWIG_TypeCheck("std::string",typeinfo);
            } break;
            default: _v = 0; break;
          }
        }    
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_string_compare__SWIG_1QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'string_compare'");
}


SWIGEXT CAML_VALUE _wrap_string_insertQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char >::size_type arg2 ;
  std::basic_string<char > *arg3 = 0 ;
  std::basic_string<char > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      {
        std::basic_string<char > &_result_ref = (arg1)->insert(arg2,(std::basic_string<char > const &)*arg3);
        result = (std::basic_string<char > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_find__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  int arg3 ;
  std::basic_string<char >::size_type result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    try {
      result = ((std::basic_string<char > const *)arg1)->find((std::basic_string<char > const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_find__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  std::basic_string<char >::size_type result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = ((std::basic_string<char > const *)arg1)->find((std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_find__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  char arg2 ;
  int arg3 ;
  std::basic_string<char >::size_type result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    try {
      result = ((std::basic_string<char > const *)arg1)->find(arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_find__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  char arg2 ;
  std::basic_string<char >::size_type result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = ((std::basic_string<char > const *)arg1)->find(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_findQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_string_find__SWIG_1QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_char: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_string_find__SWIG_3QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_string_find__SWIG_0QuantLib(args));
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_char: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_string_find__SWIG_2QuantLib(args));
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'string_find'");
}


SWIGEXT CAML_VALUE _wrap_string_operator_ee___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_char_Sg__operator_Se__Se_((std::basic_string<char > const *)arg1,(std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_operator_Ne___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_char_Sg__operator_SN__Se_((std::basic_string<char > const *)arg1,(std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_operator_l___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_char_Sg__operator_Sl_((std::basic_string<char > const *)arg1,(std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_operator_g___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_char_Sg__operator_Sg_((std::basic_string<char > const *)arg1,(std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_operator_le___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_char_Sg__operator_Sl__Se_((std::basic_string<char > const *)arg1,(std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_string_operator_ge___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_char_Sg__operator_Sg__Se_((std::basic_string<char > const *)arg1,(std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_stringQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<char > *arg1 = (std::basic_string<char > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<char > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_wstring__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::basic_string<wchar_t > *)new std::basic_string<wchar_t >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<wchar_t >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__basic_stringTwchar_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_wstring__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  wchar_t *arg1 = (wchar_t *) 0 ;
  std::basic_string<wchar_t > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (wchar_t *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_wchar_t);
  }
  {
    try {
      result = (std::basic_string<wchar_t > *)new std::basic_string<wchar_t >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<wchar_t >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__basic_stringTwchar_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_wstringQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_wstring__SWIG_0QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_wchar_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_wstring__SWIG_1QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_wstring'");
}


SWIGEXT CAML_VALUE _wrap_wstring_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  size_t result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = (arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  int arg2 ;
  wchar_t result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = ((std::basic_string<wchar_t > const *)arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_short(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_c_strQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  wchar_t *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = (wchar_t *)((std::basic_string<wchar_t > const *)arg1)->c_str();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_wchar_t_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_wchar_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_wchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_e_____SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  std::basic_string<wchar_t > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      {
        std::basic_string<wchar_t > &_result_ref = (arg1)->operator =((std::basic_string<wchar_t > const &)*arg2);
        result = (std::basic_string<wchar_t > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<wchar_t >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_e_____SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  wchar_t *arg2 = (wchar_t *) 0 ;
  std::basic_string<wchar_t > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE * */
    arg2 = (wchar_t *)caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_wchar_t);
  }
  {
    try {
      {
        std::basic_string<wchar_t > &_result_ref = (arg1)->operator =((wchar_t const *)arg2);
        result = (std::basic_string<wchar_t > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<wchar_t >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_e___QuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_wstring_operator_e_____SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_wchar_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_wstring_operator_e_____SWIG_1QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'wstring_operator ='");
}


SWIGEXT CAML_VALUE _wrap_wstring_append__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  std::basic_string<wchar_t > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      {
        std::basic_string<wchar_t > &_result_ref = (arg1)->append((std::basic_string<wchar_t > const &)*arg2);
        result = (std::basic_string<wchar_t > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<wchar_t >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_append__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  wchar_t *arg2 = (wchar_t *) 0 ;
  std::basic_string<wchar_t > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE * */
    arg2 = (wchar_t *)caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_wchar_t);
  }
  {
    try {
      {
        std::basic_string<wchar_t > &_result_ref = (arg1)->append((wchar_t const *)arg2);
        result = (std::basic_string<wchar_t > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<wchar_t >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_appendQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_wstring_append__SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_wchar_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_wstring_append__SWIG_1QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'wstring_append'");
}


SWIGEXT CAML_VALUE _wrap_wstring_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  wchar_t arg2 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      (arg1)->push_back(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_reserveQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t >::size_type arg2 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      (arg1)->reserve(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_resize__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t >::size_type arg2 ;
  wchar_t arg3 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    try {
      (arg1)->resize(arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_resize__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t >::size_type arg2 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      (arg1)->resize(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_resizeQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_wstring_resize__SWIG_1QuantLib(args));
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[2]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[2]) ) {
            case C_short: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_wstring_resize__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'wstring_resize'");
}


SWIGEXT CAML_VALUE _wrap_wstring_compare__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  int result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = (int)((std::basic_string<wchar_t > const *)arg1)->compare((std::basic_string<wchar_t > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_compare__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  wchar_t *arg2 = (wchar_t *) 0 ;
  int result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE * */
    arg2 = (wchar_t *)caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_wchar_t);
  }
  {
    try {
      result = (int)((std::basic_string<wchar_t > const *)arg1)->compare((wchar_t const *)arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_compareQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_wstring_compare__SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_wchar_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_wstring_compare__SWIG_1QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'wstring_compare'");
}


SWIGEXT CAML_VALUE _wrap_wstring_insertQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t >::size_type arg2 ;
  std::basic_string<wchar_t > *arg3 = 0 ;
  std::basic_string<wchar_t > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      {
        std::basic_string<wchar_t > &_result_ref = (arg1)->insert(arg2,(std::basic_string<wchar_t > const &)*arg3);
        result = (std::basic_string<wchar_t > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<wchar_t >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_find__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  int arg3 ;
  std::basic_string<wchar_t >::size_type result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    try {
      result = ((std::basic_string<wchar_t > const *)arg1)->find((std::basic_string<wchar_t > const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_find__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  std::basic_string<wchar_t >::size_type result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = ((std::basic_string<wchar_t > const *)arg1)->find((std::basic_string<wchar_t > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_find__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  wchar_t arg2 ;
  int arg3 ;
  std::basic_string<wchar_t >::size_type result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    try {
      result = ((std::basic_string<wchar_t > const *)arg1)->find(arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_find__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  wchar_t arg2 ;
  std::basic_string<wchar_t >::size_type result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = ((std::basic_string<wchar_t > const *)arg1)->find(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_findQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_wstring_find__SWIG_1QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_short: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_wstring_find__SWIG_3QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_wstring_find__SWIG_0QuantLib(args));
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTwchar_t_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_short: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_wstring_find__SWIG_2QuantLib(args));
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'wstring_find'");
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_ee___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_wchar_t_Sg__operator_Se__Se_((std::basic_string<wchar_t > const *)arg1,(std::basic_string<wchar_t > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_Ne___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_wchar_t_Sg__operator_SN__Se_((std::basic_string<wchar_t > const *)arg1,(std::basic_string<wchar_t > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_l___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_wchar_t_Sg__operator_Sl_((std::basic_string<wchar_t > const *)arg1,(std::basic_string<wchar_t > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_g___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_wchar_t_Sg__operator_Sg_((std::basic_string<wchar_t > const *)arg1,(std::basic_string<wchar_t > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_le___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_wchar_t_Sg__operator_Sl__Se_((std::basic_string<wchar_t > const *)arg1,(std::basic_string<wchar_t > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_wstring_operator_ge___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  std::basic_string<wchar_t > *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<wchar_t > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      result = (bool)std_basic_string_Sl_wchar_t_Sg__operator_Sg__Se_((std::basic_string<wchar_t > const *)arg1,(std::basic_string<wchar_t > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_wstringQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::basic_string<wchar_t > *arg1 = (std::basic_string<wchar_t > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::basic_string<wchar_t > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__basic_stringTwchar_t_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Sunday(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Sunday);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Monday(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Monday);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Tuesday(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Tuesday);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Wednesday(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Wednesday);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Thursday(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Thursday);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Friday(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Friday);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Saturday(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Saturday);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_January(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__January);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_February(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__February);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_March(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__March);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_April(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__April);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_May(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__May);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_June(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__June);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_July(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__July);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_August(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__August);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_September(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__September);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_October(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__October);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_November(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__November);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_December(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__December);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Days(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Days);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Weeks(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Weeks);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Months(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Months);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Years(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Years);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_NoFrequency(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__NoFrequency);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Once(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Once);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Annual(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Annual);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Semiannual(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Semiannual);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_EveryFourthMonth(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__EveryFourthMonth);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Quarterly(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Quarterly);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Bimonthly(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Bimonthly);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Monthly(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Monthly);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Biweekly(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Biweekly);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Weekly(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Weekly);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Daily(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Daily);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Period__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Period *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (Period *)new Period();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Period_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Period));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Period);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Period__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  TimeUnit arg2 ;
  Period *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = (TimeUnit)caml_long_val_full(caml_list_nth(args,1),"TimeUnit_marker");
  }
  {
    try {
      result = (Period *)new Period(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Period_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Period));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Period);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Period__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Frequency arg1 ;
  Period *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (Frequency)caml_long_val_full(caml_list_nth(args,0),"Frequency_marker");
  }
  {
    try {
      result = (Period *)new Period(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Period_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Period));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Period);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Period_lengthQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Period *arg1 = (Period *) 0 ;
  Integer result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Period *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Period);
  }
  {
    try {
      result = (Integer)((Period const *)arg1)->length();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Period_unitsQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Period *arg1 = (Period *) 0 ;
  TimeUnit result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Period *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Period);
  }
  {
    try {
      result = (TimeUnit)((Period const *)arg1)->units();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("TimeUnit_marker"),Val_int((int)result));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Period_frequencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Period *arg1 = (Period *) 0 ;
  Frequency result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Period *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Period);
  }
  {
    try {
      result = (Frequency)((Period const *)arg1)->frequency();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("Frequency_marker"),Val_int((int)result));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Period__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  Period *result = 0 ;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    try {
      result = (Period *)new_Period__SWIG_3((std::basic_string<char > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Period_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Period));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Period);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_PeriodQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Period__SWIG_0QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Period__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Period__SWIG_2QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_Period__SWIG_1QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_Period'");
}


SWIGEXT CAML_VALUE _wrap_Period___str__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Period *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Period);
  }
  {
    try {
      result = Period___str__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Period___repr__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Period *arg1 = (Period *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Period *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Period);
  }
  {
    try {
      result = Period___repr__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_PeriodQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Period *arg1 = (Period *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Period *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Period);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_PeriodVector__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::vector<Period > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::vector<Period > *)new std::vector<Period >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Period >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTPeriod_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTPeriod_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_PeriodVector__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<Period > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::vector<Period > *)new std::vector<Period >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Period >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTPeriod_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTPeriod_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_PeriodVector__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  Period *arg2 = 0 ;
  std::vector<Period > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Period *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Period);
  }
  {
    try {
      result = (std::vector<Period > *)new std::vector<Period >(arg1,(Period const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Period >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTPeriod_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTPeriod_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_PeriodVector__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<Period > *arg1 = 0 ;
  std::vector<Period > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<Period > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    try {
      result = (std::vector<Period > *)new std::vector<Period >((std::vector<Period > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Period >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTPeriod_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTPeriod_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_PeriodVectorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_PeriodVector__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTPeriod_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_PeriodVector__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_PeriodVector__SWIG_0QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Period);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_PeriodVector__SWIG_2QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_PeriodVector'");
}


SWIGEXT CAML_VALUE _wrap_PeriodVector_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  unsigned int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Period > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    try {
      result = (unsigned int)((std::vector<Period > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_uint(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_PeriodVector_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Period > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    try {
      result = (bool)((std::vector<Period > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_PeriodVector_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Period > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_PeriodVector_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  Period *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Period > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Period *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Period);
  }
  {
    try {
      (arg1)->push_back((Period const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_PeriodVector_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  Period result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Period > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Period * temp = new Period((Period &) result);
    CAML_VALUE *fromval = caml_named_value("create_Period_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Period));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Period);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_PeriodVector_operator_e___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  std::vector<Period > *arg2 = 0 ;
  std::vector<Period > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Period > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::vector<Period > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    try {
      {
        std::vector<Period > &_result_ref = (arg1)->operator =(*arg2);
        result = (std::vector<Period > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Period >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__vectorTPeriod_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__vectorTPeriod_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_PeriodVector_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  int arg2 ;
  Period *arg3 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Period > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Period *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Period);
  }
  {
    try {
      std_vector_Sl_Period_Sg__set(arg1,arg2,(Period const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_PeriodVector_to_arrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  Period *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Period > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    try {
      result = (Period *)std_vector_Sl_Period_Sg__to_array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Period_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Period));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Period);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_PeriodVectorQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Period > *arg1 = (std::vector<Period > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Period > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTPeriod_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Date__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (Date *)new Date();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Date__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Day arg1 ;
  Month arg2 ;
  Year arg3 ;
  Date *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = (Month)caml_long_val_full(caml_list_nth(args,1),"Month_marker");
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    try {
      result = (Date *)new Date(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Date__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  BigInteger arg1 ;
  Date *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (Date *)new Date(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_weekdayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  Weekday result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (Weekday)((Date const *)arg1)->weekday();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("Weekday_marker"),Val_int((int)result));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_dayOfMonthQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfMonth();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_dayOfYearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  Day result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (Day)((Date const *)arg1)->dayOfYear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_monthQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  Month result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (Month)((Date const *)arg1)->month();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("Month_marker"),Val_int((int)result));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_yearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  Year result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (Year)((Date const *)arg1)->year();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_serialNumberQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  BigInteger result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (BigInteger)((Date const *)arg1)->serialNumber();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_long(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_isLeapQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Year arg1 ;
  bool result;
  
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (bool)Date::isLeap(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_minDateQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date result;
  
  swig_result = Val_unit;
  {
    try {
      result = Date::minDate();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_maxDateQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date result;
  
  swig_result = Val_unit;
  {
    try {
      result = Date::maxDate();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_todaysDateQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date result;
  
  swig_result = Val_unit;
  {
    try {
      result = Date::todaysDate();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_endOfMonthQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = 0 ;
  Date result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = Date::endOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_isEndOfMonthQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (bool)Date::isEndOfMonth((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_nextWeekdayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = 0 ;
  Weekday arg2 ;
  Date result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    arg2 = (Weekday)caml_long_val_full(caml_list_nth(args,1),"Weekday_marker");
  }
  {
    try {
      result = Date::nextWeekday((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_nthWeekdayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Size arg1 ;
  Weekday arg2 ;
  Month arg3 ;
  Year arg4 ;
  Date result;
  
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = (Weekday)caml_long_val_full(caml_list_nth(args,1),"Weekday_marker");
  }
  {
    arg3 = (Month)caml_long_val_full(caml_list_nth(args,2),"Month_marker");
  }
  {
    arg4 = caml_long_val(caml_list_nth(args,3));
  }
  {
    try {
      result = Date::nthWeekday(arg1,arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Date__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Date *result = 0 ;
  std::string temp1 ;
  std::string temp2 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    if (caml_ptr_check(caml_list_nth(args,1))) {
      temp2.assign((char *)caml_ptr_val(caml_list_nth(args,1),0),
        caml_string_len(caml_list_nth(args,1)));
      arg2 = &temp2;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    try {
      result = (Date *)new_Date__SWIG_3((std::basic_string<char > const &)*arg1,(std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Date);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg2).c_str(),
        (*arg2).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DateQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Date__SWIG_0QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int64: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Date__SWIG_2QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_Date__SWIG_3QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_new_Date__SWIG_1QuantLib(args));
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_Date'");
}


SWIGEXT CAML_VALUE _wrap_Date_weekdayNumberQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  Integer result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (Integer)Date_weekdayNumber(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date___str__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = Date___str__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date___repr__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = Date___repr__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Date_ISOQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = Date_ISO(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_DateQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = (Date *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Date *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DateParser_parseQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::string *arg1 = 0 ;
  std::string *arg2 = 0 ;
  Date result;
  std::string temp1 ;
  std::string temp2 ;
  
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    if (caml_ptr_check(caml_list_nth(args,1))) {
      temp2.assign((char *)caml_ptr_val(caml_list_nth(args,1),0),
        caml_string_len(caml_list_nth(args,1)));
      arg2 = &temp2;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    try {
      result = DateParser::parse((std::basic_string<char > const &)*arg1,(std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg2).c_str(),
        (*arg2).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DateParser_parseISOQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::string *arg1 = 0 ;
  Date result;
  std::string temp1 ;
  
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    try {
      result = DateParser::parseISO((std::basic_string<char > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DateParserQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DateParser *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (DateParser *)new DateParser();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_DateParser_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_DateParser));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_DateParser);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_DateParserQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DateParser *arg1 = (DateParser *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DateParser *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DateParser);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_PeriodParser_parseQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::string *arg1 = 0 ;
  Period result;
  std::string temp1 ;
  
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    try {
      result = PeriodParser::parse((std::basic_string<char > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Period * temp = new Period((Period &) result);
    CAML_VALUE *fromval = caml_named_value("create_Period_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Period));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Period);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_PeriodParserQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  PeriodParser *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (PeriodParser *)new PeriodParser();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_PeriodParser_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_PeriodParser));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_PeriodParser);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_PeriodParserQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  PeriodParser *arg1 = (PeriodParser *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (PeriodParser *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_PeriodParser);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DateVector__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::vector<Date > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::vector<Date > *)new std::vector<Date >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Date >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTDate_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTDate_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DateVector__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<Date > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::vector<Date > *)new std::vector<Date >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Date >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTDate_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTDate_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DateVector__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  Date *arg2 = 0 ;
  std::vector<Date > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (std::vector<Date > *)new std::vector<Date >(arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Date >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTDate_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTDate_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DateVector__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<Date > *arg1 = 0 ;
  std::vector<Date > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<Date > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    try {
      result = (std::vector<Date > *)new std::vector<Date >((std::vector<Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Date >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTDate_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTDate_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DateVectorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_DateVector__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTDate_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_DateVector__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_DateVector__SWIG_0QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_DateVector__SWIG_2QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_DateVector'");
}


SWIGEXT CAML_VALUE _wrap_DateVector_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  unsigned int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Date > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    try {
      result = (unsigned int)((std::vector<Date > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_uint(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DateVector_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Date > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    try {
      result = (bool)((std::vector<Date > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DateVector_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Date > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DateVector_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  Date *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Date > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      (arg1)->push_back((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DateVector_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  Date result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Date > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DateVector_operator_e___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  std::vector<Date > *arg2 = 0 ;
  std::vector<Date > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Date > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::vector<Date > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    try {
      {
        std::vector<Date > &_result_ref = (arg1)->operator =(*arg2);
        result = (std::vector<Date > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Date >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__vectorTDate_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__vectorTDate_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DateVector_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  int arg2 ;
  Date *arg3 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Date > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    try {
      std_vector_Sl_Date_Sg__set(arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DateVector_to_arrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  Date *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Date > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    try {
      result = (Date *)std_vector_Sl_Date_Sg__to_array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_DateVectorQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Date > *arg1 = (std::vector<Date > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Date > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_F(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__F);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_G(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__G);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_H(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__H);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_J(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__J);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_K(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__K);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_M(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__M);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_N(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__N);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Q(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__Q);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_U(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__U);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_V(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__V);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_X(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__X);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Z(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__IMM__Z);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_IMM_isIMMdate__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date *arg1 = 0 ;
  bool arg2 ;
  bool result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_isIMMdate__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date *arg1 = 0 ;
  bool result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (bool)IMM::isIMMdate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_isIMMdateQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Date);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_IMM_isIMMdate__SWIG_1QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Date);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_bool: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_IMM_isIMMdate__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'IMM_isIMMdate'");
}


SWIGEXT CAML_VALUE _wrap_IMM_isIMMcode__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  bool arg2 ;
  bool result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (bool)IMM::isIMMcode((std::basic_string<char > const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_isIMMcode__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  bool result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    try {
      result = (bool)IMM::isIMMcode((std::basic_string<char > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_isIMMcodeQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_IMM_isIMMcode__SWIG_1QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_bool: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_IMM_isIMMcode__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'IMM_isIMMcode'");
}


SWIGEXT CAML_VALUE _wrap_IMM_codeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = IMM::code((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_date__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  Date *arg2 = 0 ;
  Date result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      result = IMM::date((std::basic_string<char > const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_date__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  Date result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    try {
      result = IMM::date((std::basic_string<char > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_dateQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_IMM_date__SWIG_1QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_IMM_date__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'IMM_date'");
}


SWIGEXT CAML_VALUE _wrap_IMM_nextDate__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date *arg1 = 0 ;
  bool arg2 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = IMM::nextDate((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextDate__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date *arg1 = 0 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = IMM::nextDate((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextDate__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = IMM::nextDate();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextDate__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  Date result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    try {
      result = IMM::nextDate((std::basic_string<char > const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextDate__SWIG_4QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = IMM::nextDate((std::basic_string<char > const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextDate__SWIG_5QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  Date result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    try {
      result = IMM::nextDate((std::basic_string<char > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextDateQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_IMM_nextDate__SWIG_2QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Date);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_IMM_nextDate__SWIG_1QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_IMM_nextDate__SWIG_5QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_bool: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_IMM_nextDate__SWIG_4QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Date);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_bool: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_IMM_nextDate__SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_bool: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_IMM_nextDate__SWIG_3QuantLib(args));
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'IMM_nextDate'");
}


SWIGEXT CAML_VALUE _wrap_IMM_nextCode__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = IMM::nextCode((Date const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextCode__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date *arg1 = 0 ;
  std::string result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = IMM::nextCode((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextCode__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = IMM::nextCode();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextCode__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  bool arg2 ;
  Date *arg3 = 0 ;
  std::string result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    try {
      result = IMM::nextCode((std::basic_string<char > const &)*arg1,arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextCode__SWIG_4QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  bool arg2 ;
  std::string result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = IMM::nextCode((std::basic_string<char > const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextCode__SWIG_5QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::string *arg1 = 0 ;
  std::string result;
  std::string temp1 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    if (caml_ptr_check(caml_list_nth(args,0))) {
      temp1.assign((char *)caml_ptr_val(caml_list_nth(args,0),0),
        caml_string_len(caml_list_nth(args,0)));
      arg1 = &temp1;
    } else {
      SWIG_exception(SWIG_TypeError, "string expected");
    }
  }
  {
    try {
      result = IMM::nextCode((std::basic_string<char > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  {
    caml_list_append(swig_result,caml_val_string_len((*arg1).c_str(),
        (*arg1).size()));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IMM_nextCodeQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_IMM_nextCode__SWIG_2QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Date);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_IMM_nextCode__SWIG_1QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_IMM_nextCode__SWIG_5QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_bool: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_IMM_nextCode__SWIG_4QuantLib(args));
      }
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Date);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_bool: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_IMM_nextCode__SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_bool: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_IMM_nextCode__SWIG_3QuantLib(args));
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'IMM_nextCode'");
}


SWIGEXT CAML_VALUE _wrap_new_IMMQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  IMM *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (IMM *)new IMM();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_IMM_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_IMM));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_IMM);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_IMMQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  IMM *arg1 = (IMM *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (IMM *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_IMM);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_IntVector__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::vector<int > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::vector<int > *)new std::vector<int >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<int >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTint_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTint_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_IntVector__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<int > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::vector<int > *)new std::vector<int >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<int >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTint_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTint_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_IntVector__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  int *arg2 = 0 ;
  std::vector<int > *result = 0 ;
  int temp2 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    temp2 = (int) caml_long_val(caml_list_nth(args,1));
    arg2 = &temp2;
  }
  {
    try {
      result = (std::vector<int > *)new std::vector<int >(arg1,(int const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<int >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTint_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTint_t);
    }
  }
  {
    swig_result = caml_list_append(swig_result,caml_val_int((long)*arg2));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_IntVector__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<int > *arg1 = 0 ;
  std::vector<int > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<int > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    try {
      result = (std::vector<int > *)new std::vector<int >((std::vector<int > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<int >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTint_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTint_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_IntVectorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_IntVector__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTint_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_IntVector__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_IntVector__SWIG_0QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_IntVector__SWIG_2QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_IntVector'");
}


SWIGEXT CAML_VALUE _wrap_IntVector_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  unsigned int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<int > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    try {
      result = (unsigned int)((std::vector<int > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_uint(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IntVector_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<int > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    try {
      result = (bool)((std::vector<int > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IntVector_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<int > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IntVector_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int *arg2 = 0 ;
  int temp2 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<int > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    temp2 = (int) caml_long_val(caml_list_nth(args,1));
    arg2 = &temp2;
  }
  {
    try {
      (arg1)->push_back((int const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    swig_result = caml_list_append(swig_result,caml_val_int((long)*arg2));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IntVector_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<int > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (int)(arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IntVector_operator_e___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  std::vector<int > *arg2 = 0 ;
  std::vector<int > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<int > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::vector<int > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    try {
      {
        std::vector<int > &_result_ref = (arg1)->operator =(*arg2);
        result = (std::vector<int > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<int >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__vectorTint_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__vectorTint_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IntVector_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int arg2 ;
  int *arg3 = 0 ;
  int temp3 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<int > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    temp3 = (int) caml_long_val(caml_list_nth(args,2));
    arg3 = &temp3;
  }
  {
    try {
      std_vector_Sl_int_Sg__set(arg1,arg2,(int const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    swig_result = caml_list_append(swig_result,caml_val_int((long)*arg3));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_IntVector_to_arrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  int *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<int > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    try {
      result = (int *)std_vector_Sl_int_Sg__to_array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_int_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_int));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_int);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_IntVectorQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<int > *arg1 = (std::vector<int > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<int > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTint_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DoubleVector__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::vector<double > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::vector<double > *)new std::vector<double >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTdouble_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTdouble_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DoubleVector__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<double > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::vector<double > *)new std::vector<double >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTdouble_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTdouble_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DoubleVector__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  double *arg2 = 0 ;
  std::vector<double > *result = 0 ;
  double temp2 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    temp2 = (double) caml_double_val(caml_list_nth(args,1));
    arg2 = &temp2;
  }
  {
    try {
      result = (std::vector<double > *)new std::vector<double >(arg1,(double const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTdouble_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTdouble_t);
    }
  }
  {
    swig_result = caml_list_append(swig_result,caml_val_double((long)*arg2));
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DoubleVector__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<double > *arg1 = 0 ;
  std::vector<double > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<double > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    try {
      result = (std::vector<double > *)new std::vector<double >((std::vector<double > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTdouble_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTdouble_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DoubleVectorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_DoubleVector__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTdouble_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_DoubleVector__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_DoubleVector__SWIG_0QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_double: _v = 1; break;
            default: _v = 0; break;
          }
        }  
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_DoubleVector__SWIG_2QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_DoubleVector'");
}


SWIGEXT CAML_VALUE _wrap_DoubleVector_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  unsigned int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    try {
      result = (unsigned int)((std::vector<double > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_uint(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DoubleVector_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    try {
      result = (bool)((std::vector<double > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DoubleVector_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DoubleVector_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  double *arg2 = 0 ;
  double temp2 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    temp2 = (double) caml_double_val(caml_list_nth(args,1));
    arg2 = &temp2;
  }
  {
    try {
      (arg1)->push_back((double const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    swig_result = caml_list_append(swig_result,caml_val_double((long)*arg2));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DoubleVector_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  double result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (double)(arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DoubleVector_operator_e___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  std::vector<double > *arg2 = 0 ;
  std::vector<double > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::vector<double > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    try {
      {
        std::vector<double > &_result_ref = (arg1)->operator =(*arg2);
        result = (std::vector<double > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__vectorTdouble_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__vectorTdouble_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DoubleVector_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  int arg2 ;
  double *arg3 = 0 ;
  double temp3 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    temp3 = (double) caml_double_val(caml_list_nth(args,2));
    arg3 = &temp3;
  }
  {
    try {
      std_vector_Sl_double_Sg__set(arg1,arg2,(double const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    swig_result = caml_list_append(swig_result,caml_val_double((long)*arg3));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DoubleVector_to_arrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  double *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    try {
      result = (double *)std_vector_Sl_double_Sg__to_array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_double_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_double));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_double);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_DoubleVectorQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<double > *arg1 = (std::vector<double > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTdouble_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_StrVector__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::vector<std::string > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::vector<string > *)new std::vector<string >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<string >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_StrVector__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<std::string > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::vector<string > *)new std::vector<string >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<string >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_StrVector__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::basic_string<char > *arg2 = 0 ;
  std::vector<std::string > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      result = (std::vector<string > *)new std::vector<string >(arg1,(std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<string >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_StrVector__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<std::basic_string<char > > *arg1 = 0 ;
  std::vector<std::string > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<std::basic_string<char > > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    try {
      result = (std::vector<string > *)new std::vector<string >((std::vector<std::basic_string<char > > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<string >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_StrVectorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_StrVector__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_StrVector__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_StrVector__SWIG_0QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__basic_stringTchar_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_StrVector__SWIG_2QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_StrVector'");
}


SWIGEXT CAML_VALUE _wrap_StrVector_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<string > *arg1 = (std::vector<string > *) 0 ;
  unsigned int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<string > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    try {
      result = (unsigned int)((std::vector<string > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_uint(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_StrVector_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<string > *arg1 = (std::vector<string > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<string > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    try {
      result = (bool)((std::vector<string > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_StrVector_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<string > *arg1 = (std::vector<string > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<string > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_StrVector_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<string > *arg1 = (std::vector<string > *) 0 ;
  std::basic_string<char > *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<string > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      (arg1)->push_back((std::basic_string<char > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_StrVector_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<string > *arg1 = (std::vector<string > *) 0 ;
  int arg2 ;
  std::basic_string<char > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<string > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    std::basic_string<char > * temp = new std::basic_string<char >((std::basic_string<char > &) result);
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_StrVector_operator_e___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<string > *arg1 = (std::vector<string > *) 0 ;
  std::vector<std::basic_string<char > > *arg2 = 0 ;
  std::vector<std::basic_string<char > > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<string > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::vector<std::basic_string<char > > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    try {
      {
        std::vector<std::basic_string<char > > &_result_ref = (arg1)->operator =(*arg2);
        result = (std::vector<std::basic_string<char > > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<std::basic_string<char > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_StrVector_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<string > *arg1 = (std::vector<string > *) 0 ;
  int arg2 ;
  std::basic_string<char > *arg3 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<string > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (std::basic_string<char > *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_std__basic_stringTchar_t);
  }
  {
    try {
      std_vector_Sl_string_Sg__set(arg1,arg2,(std::basic_string<char > const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_StrVector_to_arrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<string > *arg1 = (std::vector<string > *) 0 ;
  std::basic_string<char > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<string > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    try {
      result = (std::basic_string<char > *)std_vector_Sl_string_Sg__to_array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_StrVectorQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<string > *arg1 = (std::vector<string > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<string > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__basic_stringTchar_t_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NodePair__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::pair<Date,double > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::pair<Date,double > *)new std::pair<Date,double >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::pair<Date,double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__pairTDate_double_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__pairTDate_double_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NodePair__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date arg1 ;
  double arg2 ;
  std::pair<Date,double > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = *((Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date)) ;
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (std::pair<Date,double > *)new std::pair<Date,double >(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::pair<Date,double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__pairTDate_double_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__pairTDate_double_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NodePair__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::pair<Date,double > *arg1 = 0 ;
  std::pair<Date,double > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::pair<Date,double > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__pairTDate_double_t);
  }
  {
    try {
      result = (std::pair<Date,double > *)new std::pair<Date,double >((std::pair<Date,double > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::pair<Date,double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__pairTDate_double_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__pairTDate_double_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NodePairQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_NodePair__SWIG_0QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__pairTDate_double_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_NodePair__SWIG_2QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[1]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[1]) ) {
          case C_double: _v = 1; break;
          default: _v = 0; break;
        }
      }  
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_NodePair__SWIG_1QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_NodePair'");
}


SWIGEXT CAML_VALUE _wrap_NodePair_first_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  Date *arg2 = (Date *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::pair<Date,double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__pairTDate_double_t);
  }
  {
    /* %typemap(in) SWIGTYPE * */
    arg2 = (Date *)caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  if (arg1) (arg1)->first = *arg2;
  
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodePair_first_getQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  Date *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::pair<Date,double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__pairTDate_double_t);
  }
  result = (Date *)& ((arg1)->first);
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Date);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodePair_second_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  double arg2 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::pair<Date,double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__pairTDate_double_t);
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  if (arg1) (arg1)->second = arg2;
  
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodePair_second_getQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  double result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::pair<Date,double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__pairTDate_double_t);
  }
  result = (double) ((arg1)->second);
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_NodePairQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::pair<Date,double > *arg1 = (std::pair<Date,double > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::pair<Date,double > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__pairTDate_double_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NodeVector__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::vector<std::pair<Date,double > > *)new std::vector<std::pair<Date,double > >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<std::pair<Date,double > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NodeVector__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::vector<std::pair<Date,double > > *)new std::vector<std::pair<Date,double > >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<std::pair<Date,double > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NodeVector__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::pair<Date,double > *arg2 = 0 ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::pair<Date,double > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__pairTDate_double_t);
  }
  {
    try {
      result = (std::vector<std::pair<Date,double > > *)new std::vector<std::pair<Date,double > >(arg1,(std::pair<Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<std::pair<Date,double > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NodeVector__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<std::pair<Date,double > > *arg1 = 0 ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<std::pair<Date,double > > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    try {
      result = (std::vector<std::pair<Date,double > > *)new std::vector<std::pair<Date,double > >((std::vector<std::pair<Date,double > > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<std::pair<Date,double > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NodeVectorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_NodeVector__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_NodeVector__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_NodeVector__SWIG_0QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_std__pairTDate_double_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_NodeVector__SWIG_2QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_NodeVector'");
}


SWIGEXT CAML_VALUE _wrap_NodeVector_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  unsigned int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<std::pair<Date,double > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    try {
      result = (unsigned int)((std::vector<std::pair<Date,double > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_uint(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodeVector_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<std::pair<Date,double > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    try {
      result = (bool)((std::vector<std::pair<Date,double > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodeVector_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<std::pair<Date,double > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodeVector_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::pair<Date,double > *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<std::pair<Date,double > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::pair<Date,double > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__pairTDate_double_t);
  }
  {
    try {
      (arg1)->push_back((std::pair<Date,double > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodeVector_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::pair<Date,double > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<std::pair<Date,double > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    std::pair<Date,double > * temp = new std::pair<Date,double >((std::pair<Date,double > &) result);
    CAML_VALUE *fromval = caml_named_value("create_std::pair<Date,double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_std__pairTDate_double_t));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_std__pairTDate_double_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodeVector_operator_e___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::vector<std::pair<Date,double > > *arg2 = 0 ;
  std::vector<std::pair<Date,double > > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<std::pair<Date,double > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::vector<std::pair<Date,double > > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    try {
      {
        std::vector<std::pair<Date,double > > &_result_ref = (arg1)->operator =(*arg2);
        result = (std::vector<std::pair<Date,double > > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<std::pair<Date,double > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodeVector_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  int arg2 ;
  std::pair<Date,double > *arg3 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<std::pair<Date,double > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (std::pair<Date,double > *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_std__pairTDate_double_t);
  }
  {
    try {
      std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__set(arg1,arg2,(std::pair<Date,double > const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NodeVector_to_arrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  std::pair<Date,double > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<std::pair<Date,double > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    try {
      result = (std::pair<Date,double > *)std_vector_Sl_std_pair_Sl_Date_Sc_double_Sg__Sg__to_array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::pair<Date,double >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__pairTDate_double_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__pairTDate_double_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_NodeVectorQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<std::pair<Date,double > > *arg1 = (std::vector<std::pair<Date,double > > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<std::pair<Date,double > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTstd__pairTDate_double_t_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Exercise___deref__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  Exercise *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Exercise > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTExercise_t);
  }
  {
    try {
      result = (Exercise *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Exercise_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Exercise));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Exercise);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Exercise_isNullQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Exercise > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTExercise_t);
  }
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Exercise_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Exercise_American(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("enum Exercise::Type_marker"),Val_int((int)_swig_wrap_Exercise_xxAmerican));
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Exercise_Bermudan(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("enum Exercise::Type_marker"),Val_int((int)_swig_wrap_Exercise_xxBermudan));
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Exercise_European(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("enum Exercise::Type_marker"),Val_int((int)_swig_wrap_Exercise_xxEuropean));
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_ExerciseQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Exercise > *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (boost::shared_ptr<Exercise > *)new boost::shared_ptr<Exercise >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_boost::shared_ptr<Exercise >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_boost__shared_ptrTExercise_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_boost__shared_ptrTExercise_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_ExerciseQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Exercise > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTExercise_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Exercise_typeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  Exercise::Type result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Exercise > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTExercise_t);
  }
  {
    try {
      result = (Exercise::Type)(*arg1)->type();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("Exercise::Type_marker"),Val_int((int)result));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Exercise_datesQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Exercise > *arg1 = (boost::shared_ptr<Exercise > *) 0 ;
  std::vector<Date > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Exercise > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTExercise_t);
  }
  {
    try {
      result = (*arg1)->dates();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    std::vector<Date > * temp = new std::vector<Date >((std::vector<Date > &) result);
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Date >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_std__vectorTDate_t));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_std__vectorTDate_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_EuropeanExerciseQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Date *arg1 = 0 ;
  EuropeanExercisePtr *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (EuropeanExercisePtr *)new_EuropeanExercisePtr((Date const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_EuropeanExercisePtr_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_EuropeanExercisePtr));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_EuropeanExercisePtr);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_EuropeanExerciseQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  EuropeanExercisePtr *arg1 = (EuropeanExercisePtr *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (EuropeanExercisePtr *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_EuropeanExercisePtr);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_AmericanExercise__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  bool arg3 ;
  AmericanExercisePtr *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    try {
      result = (AmericanExercisePtr *)new_AmericanExercisePtr__SWIG_0((Date const &)*arg1,(Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_AmericanExercisePtr_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_AmericanExercisePtr));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_AmericanExercisePtr);
    }
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_AmericanExercise__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Date *arg1 = 0 ;
  Date *arg2 = 0 ;
  AmericanExercisePtr *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Date *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (AmericanExercisePtr *)new_AmericanExercisePtr__SWIG_0((Date const &)*arg1,(Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_AmericanExercisePtr_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_AmericanExercisePtr));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_AmericanExercisePtr);
    }
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_AmericanExerciseQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Date);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_AmericanExercise__SWIG_1QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Date);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_bool: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_new_AmericanExercise__SWIG_0QuantLib(args));
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_AmericanExercise'");
}


SWIGEXT CAML_VALUE _wrap_delete_AmericanExerciseQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  AmericanExercisePtr *arg1 = (AmericanExercisePtr *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (AmericanExercisePtr *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_AmericanExercisePtr);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_BermudanExercise__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<Date > *arg1 = 0 ;
  bool arg2 ;
  BermudanExercisePtr *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<Date > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (BermudanExercisePtr *)new_BermudanExercisePtr__SWIG_0((std::vector<Date > const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_BermudanExercisePtr_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_BermudanExercisePtr));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_BermudanExercisePtr);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_BermudanExercise__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<Date > *arg1 = 0 ;
  BermudanExercisePtr *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<Date > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTDate_t);
  }
  {
    try {
      result = (BermudanExercisePtr *)new_BermudanExercisePtr__SWIG_0((std::vector<Date > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_BermudanExercisePtr_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_BermudanExercisePtr));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_BermudanExercisePtr);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_BermudanExerciseQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTDate_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_BermudanExercise__SWIG_1QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTDate_t);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_bool: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_BermudanExercise__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_BermudanExercise'");
}


SWIGEXT CAML_VALUE _wrap_delete_BermudanExerciseQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  BermudanExercisePtr *arg1 = (BermudanExercisePtr *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (BermudanExercisePtr *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_BermudanExercisePtr);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Observable___deref__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
  Observable *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Observable > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTObservable_t);
  }
  {
    try {
      result = (Observable *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Observable_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Observable));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Observable);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Observable_isNullQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Observable > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTObservable_t);
  }
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Observable_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ObservableQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Observable > *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (boost::shared_ptr<Observable > *)new boost::shared_ptr<Observable >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_boost::shared_ptr<Observable >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_boost__shared_ptrTObservable_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_boost__shared_ptrTObservable_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_ObservableQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Observable > *arg1 = (boost::shared_ptr<Observable > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Observable > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTObservable_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Array__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Array *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (Array *)new Array();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Array_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Array));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Array);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Array__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Size arg1 ;
  Real arg2 ;
  Array *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (Array *)new Array(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Array_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Array));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Array);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Array__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Size arg1 ;
  Array *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (Array *)new Array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Array_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Array));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Array);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Array__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Array *arg1 = 0 ;
  Array *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Array *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Array);
  }
  {
    try {
      result = (Array *)new Array((Array const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Array_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Array));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Array);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ArrayQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Array__SWIG_0QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Array);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Array__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int64: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Array__SWIG_2QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int64: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_double: _v = 1; break;
            default: _v = 0; break;
          }
        }  
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_Array__SWIG_1QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_Array'");
}


SWIGEXT CAML_VALUE _wrap_Array_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Array *arg1 = (Array *) 0 ;
  Size result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Array *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Array);
  }
  {
    try {
      result = ((Array const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Array___str__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Array *arg1 = (Array *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Array *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Array);
  }
  {
    try {
      result = Array___str__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_ArrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Array *arg1 = (Array *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Array *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Array);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_LexicographicalView_xSizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DefaultLexicographicalView *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DefaultLexicographicalView);
  }
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->xSize();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_LexicographicalView_ySizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  Size result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DefaultLexicographicalView *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DefaultLexicographicalView);
  }
  {
    try {
      result = ((DefaultLexicographicalView const *)arg1)->ySize();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_LexicographicalViewQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Array *arg1 = 0 ;
  Size arg2 ;
  DefaultLexicographicalView *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Array *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Array);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (DefaultLexicographicalView *)new_DefaultLexicographicalView(*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_DefaultLexicographicalView_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_DefaultLexicographicalView));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_DefaultLexicographicalView);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_LexicographicalView___str__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DefaultLexicographicalView *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DefaultLexicographicalView);
  }
  {
    try {
      result = DefaultLexicographicalView___str__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_LexicographicalViewQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DefaultLexicographicalView *arg1 = (DefaultLexicographicalView *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DefaultLexicographicalView *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DefaultLexicographicalView);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Matrix__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Matrix *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (Matrix *)new Matrix();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Matrix_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Matrix);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Matrix__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Size arg1 ;
  Size arg2 ;
  Real arg3 ;
  Matrix *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    arg3 = caml_double_val(caml_list_nth(args,2));
  }
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Matrix_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Matrix);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Matrix__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Size arg1 ;
  Size arg2 ;
  Matrix *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (Matrix *)new Matrix(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Matrix_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Matrix);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Matrix__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Matrix *arg1 = 0 ;
  Matrix *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Matrix *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Matrix);
  }
  {
    try {
      result = (Matrix *)new Matrix((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Matrix_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Matrix);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_MatrixQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Matrix__SWIG_0QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Matrix);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Matrix__SWIG_3QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int64: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int64: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_Matrix__SWIG_2QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int64: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int64: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_double: _v = 1; break;
              default: _v = 0; break;
            }
          }  
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_new_Matrix__SWIG_1QuantLib(args));
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_Matrix'");
}


SWIGEXT CAML_VALUE _wrap_Matrix_rowsQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Matrix *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Matrix);
  }
  {
    try {
      result = ((Matrix const *)arg1)->rows();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Matrix_columnsQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Matrix *arg1 = (Matrix *) 0 ;
  Size result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Matrix *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Matrix);
  }
  {
    try {
      result = ((Matrix const *)arg1)->columns();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Matrix___str__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Matrix *arg1 = (Matrix *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Matrix *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Matrix);
  }
  {
    try {
      result = Matrix___str__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_MatrixQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Matrix *arg1 = (Matrix *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Matrix *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Matrix);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_None(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__SalvagingAlgorithm__None);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Spectral(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__SalvagingAlgorithm__Spectral);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_SalvagingAlgorithmQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  SalvagingAlgorithm *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (SalvagingAlgorithm *)new SalvagingAlgorithm();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_SalvagingAlgorithm_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_SalvagingAlgorithm));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_SalvagingAlgorithm);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_SalvagingAlgorithmQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  SalvagingAlgorithm *arg1 = (SalvagingAlgorithm *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (SalvagingAlgorithm *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_SalvagingAlgorithm);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_transposeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Matrix *arg1 = 0 ;
  Matrix result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Matrix *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Matrix);
  }
  {
    try {
      result = transpose((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Matrix * temp = new Matrix((Matrix &) result);
    CAML_VALUE *fromval = caml_named_value("create_Matrix_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Matrix);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_outerProductQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Array *arg1 = 0 ;
  Array *arg2 = 0 ;
  Matrix result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Array *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Array);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Array *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Array);
  }
  {
    try {
      result = outerProduct((Array const &)*arg1,(Array const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Matrix * temp = new Matrix((Matrix &) result);
    CAML_VALUE *fromval = caml_named_value("create_Matrix_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Matrix);
    }
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_pseudoSqrtQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Matrix *arg1 = 0 ;
  SalvagingAlgorithm::Type arg2 ;
  Matrix result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Matrix *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Matrix);
  }
  {
    arg2 = (SalvagingAlgorithm::Type)caml_long_val_full(caml_list_nth(args,1),"SalvagingAlgorithm::Type_marker");
  }
  {
    try {
      result = pseudoSqrt((Matrix const &)*arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Matrix * temp = new Matrix((Matrix &) result);
    CAML_VALUE *fromval = caml_named_value("create_Matrix_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Matrix);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SVDQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Matrix *arg1 = 0 ;
  SVD *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Matrix *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Matrix);
  }
  {
    try {
      result = (SVD *)new SVD((Matrix const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_SVD_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_SVD));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_SVD);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_SVD_UQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (SVD *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_SVD);
  }
  {
    try {
      {
        Matrix const &_result_ref = ((SVD const *)arg1)->U();
        result = (Matrix *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_Matrix const_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_Matrix);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_SVD_VQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  SVD *arg1 = (SVD *) 0 ;
  Matrix *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (SVD *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_SVD);
  }
  {
    try {
      {
        Matrix const &_result_ref = ((SVD const *)arg1)->V();
        result = (Matrix *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_Matrix const_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_Matrix);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_SVD_SQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  SVD *arg1 = (SVD *) 0 ;
  Matrix result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (SVD *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_SVD);
  }
  {
    try {
      result = ((SVD const *)arg1)->S();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Matrix * temp = new Matrix((Matrix &) result);
    CAML_VALUE *fromval = caml_named_value("create_Matrix_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Matrix));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Matrix);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_SVD_singularValuesQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  SVD *arg1 = (SVD *) 0 ;
  Array *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (SVD *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_SVD);
  }
  {
    try {
      {
        Array const &_result_ref = ((SVD const *)arg1)->singularValues();
        result = (Array *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_Array const_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_Array));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_Array);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_SVDQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  SVD *arg1 = (SVD *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (SVD *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_SVD);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Quote___deref__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  Quote *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      result = (Quote *)(arg1)->operator ->();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Quote_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Quote));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Quote);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Quote_isNullQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      result = (bool)boost_shared_ptr_Sl_Quote_Sg__isNull(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Quote_asObservableQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      result = boost_shared_ptr_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    boost::shared_ptr<Observable > * temp = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &) result);
    CAML_VALUE *fromval = caml_named_value("create_boost::shared_ptr<Observable >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_boost__shared_ptrTObservable_t));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_boost__shared_ptrTObservable_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Quote > *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (boost::shared_ptr<Quote > *)new boost::shared_ptr<Quote >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_boost::shared_ptr<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_boost__shared_ptrTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_boost__shared_ptrTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_QuoteQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Quote_valueQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  boost::shared_ptr<Quote > *arg1 = (boost::shared_ptr<Quote > *) 0 ;
  Real result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (boost::shared_ptr<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteHandle__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  boost::shared_ptr<Quote > *arg1 = 0 ;
  Handle<Quote > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (boost::shared_ptr<Quote > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      result = (Handle<Quote > *)new Handle<Quote >((boost::shared_ptr<Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Handle<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_HandleTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_HandleTQuote_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteHandle__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Handle<Quote > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (Handle<Quote > *)new Handle<Quote >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Handle<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_HandleTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_HandleTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteHandleQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_QuoteHandle__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_boost__shared_ptrTQuote_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_QuoteHandle__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_QuoteHandle'");
}


SWIGEXT CAML_VALUE _wrap_QuoteHandle___deref__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  boost::shared_ptr<Quote > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Handle<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_HandleTQuote_t);
  }
  {
    try {
      result = (arg1)->operator ->();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    boost::shared_ptr<Quote > * temp = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &) result);
    CAML_VALUE *fromval = caml_named_value("create_boost::shared_ptr<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_boost__shared_ptrTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_boost__shared_ptrTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandle_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Handle<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_HandleTQuote_t);
  }
  {
    try {
      result = (bool)(arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandle_asObservableQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  boost::shared_ptr<Observable > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Handle<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_HandleTQuote_t);
  }
  {
    try {
      result = Handle_Sl_Quote_Sg__asObservable(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    boost::shared_ptr<Observable > * temp = new boost::shared_ptr<Observable >((boost::shared_ptr<Observable > &) result);
    CAML_VALUE *fromval = caml_named_value("create_boost::shared_ptr<Observable >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_boost__shared_ptrTObservable_t));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_boost__shared_ptrTObservable_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_QuoteHandleQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Handle<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_HandleTQuote_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandle_valueQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Handle<Quote > *arg1 = (Handle<Quote > *) 0 ;
  Real result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Handle<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_HandleTQuote_t);
  }
  {
    try {
      result = (Real)(*arg1)->value();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_RelinkableQuoteHandle__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  boost::shared_ptr<Quote > *arg1 = 0 ;
  RelinkableHandle<Quote > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (boost::shared_ptr<Quote > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      result = (RelinkableHandle<Quote > *)new RelinkableHandle<Quote >((boost::shared_ptr<Quote > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_RelinkableHandle<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_RelinkableHandleTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_RelinkableHandleTQuote_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_RelinkableQuoteHandle__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  RelinkableHandle<Quote > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (RelinkableHandle<Quote > *)new RelinkableHandle<Quote >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_RelinkableHandle<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_RelinkableHandleTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_RelinkableHandleTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_RelinkableQuoteHandleQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_RelinkableQuoteHandle__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_boost__shared_ptrTQuote_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_RelinkableQuoteHandle__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_RelinkableQuoteHandle'");
}


SWIGEXT CAML_VALUE _wrap_RelinkableQuoteHandle_linkToQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  RelinkableHandle<Quote > *arg1 = (RelinkableHandle<Quote > *) 0 ;
  boost::shared_ptr<Quote > *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (RelinkableHandle<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_RelinkableHandleTQuote_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (boost::shared_ptr<Quote > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      (arg1)->linkTo((boost::shared_ptr<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_RelinkableQuoteHandleQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  RelinkableHandle<Quote > *arg1 = (RelinkableHandle<Quote > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (RelinkableHandle<Quote > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_RelinkableHandleTQuote_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SimpleQuoteQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Real arg1 ;
  SimpleQuotePtr *result = 0 ;
  
  swig_result = Val_unit;
  {
    arg1 = caml_double_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (SimpleQuotePtr *)new_SimpleQuotePtr(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_SimpleQuotePtr_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_SimpleQuotePtr));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_SimpleQuotePtr);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_SimpleQuote_setValueQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
  Real arg2 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (SimpleQuotePtr *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_SimpleQuotePtr);
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    try {
      SimpleQuotePtr_setValue(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_SimpleQuoteQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  SimpleQuotePtr *arg1 = (SimpleQuotePtr *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (SimpleQuotePtr *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_SimpleQuotePtr);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteVector__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<boost::shared_ptr<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteVector__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<boost::shared_ptr<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteVector__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  boost::shared_ptr<Quote > *arg2 = 0 ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (boost::shared_ptr<Quote > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >(arg1,(boost::shared_ptr<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<boost::shared_ptr<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteVector__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<boost::shared_ptr<Quote > > *arg1 = 0 ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    try {
      result = (std::vector<boost::shared_ptr<Quote > > *)new std::vector<boost::shared_ptr<Quote > >((std::vector<boost::shared_ptr<Quote > > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<boost::shared_ptr<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteVectorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_QuoteVector__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_QuoteVector__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_QuoteVector__SWIG_0QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_boost__shared_ptrTQuote_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_QuoteVector__SWIG_2QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_QuoteVector'");
}


SWIGEXT CAML_VALUE _wrap_QuoteVector_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  unsigned int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    try {
      result = (unsigned int)((std::vector<boost::shared_ptr<Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_uint(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteVector_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    try {
      result = (bool)((std::vector<boost::shared_ptr<Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteVector_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteVector_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  boost::shared_ptr<Quote > *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (boost::shared_ptr<Quote > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      (arg1)->push_back((boost::shared_ptr<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteVector_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  boost::shared_ptr<Quote > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    boost::shared_ptr<Quote > * temp = new boost::shared_ptr<Quote >((boost::shared_ptr<Quote > &) result);
    CAML_VALUE *fromval = caml_named_value("create_boost::shared_ptr<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_boost__shared_ptrTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_boost__shared_ptrTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteVector_operator_e___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  std::vector<boost::shared_ptr<Quote > > *arg2 = 0 ;
  std::vector<boost::shared_ptr<Quote > > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::vector<boost::shared_ptr<Quote > > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    try {
      {
        std::vector<boost::shared_ptr<Quote > > &_result_ref = (arg1)->operator =(*arg2);
        result = (std::vector<boost::shared_ptr<Quote > > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<boost::shared_ptr<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteVector_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  int arg2 ;
  boost::shared_ptr<Quote > *arg3 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (boost::shared_ptr<Quote > *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_boost__shared_ptrTQuote_t);
  }
  {
    try {
      std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__set(arg1,arg2,(boost::shared_ptr<Quote > const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteVector_to_arrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  boost::shared_ptr<Quote > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    try {
      result = (boost::shared_ptr<Quote > *)std_vector_Sl_boost_shared_ptr_Sl_Quote_Sg__Sg__to_array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_boost::shared_ptr<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_boost__shared_ptrTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_boost__shared_ptrTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_QuoteVectorQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<boost::shared_ptr<Quote > > *arg1 = (std::vector<boost::shared_ptr<Quote > > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<boost::shared_ptr<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTboost__shared_ptrTQuote_t_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteHandleVector__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Handle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteHandleVector__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<Handle<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Handle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteHandleVector__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  Handle<Quote > *arg2 = 0 ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Handle<Quote > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_HandleTQuote_t);
  }
  {
    try {
      result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >(arg1,(Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Handle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteHandleVector__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<Handle<Quote > > *arg1 = 0 ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<Handle<Quote > > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    try {
      result = (std::vector<Handle<Quote > > *)new std::vector<Handle<Quote > >((std::vector<Handle<Quote > > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Handle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_QuoteHandleVectorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_QuoteHandleVector__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_QuoteHandleVector__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_QuoteHandleVector__SWIG_0QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_HandleTQuote_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_QuoteHandleVector__SWIG_2QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_QuoteHandleVector'");
}


SWIGEXT CAML_VALUE _wrap_QuoteHandleVector_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  unsigned int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Handle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    try {
      result = (unsigned int)((std::vector<Handle<Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_uint(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandleVector_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Handle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    try {
      result = (bool)((std::vector<Handle<Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandleVector_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Handle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandleVector_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  Handle<Quote > *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Handle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Handle<Quote > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_HandleTQuote_t);
  }
  {
    try {
      (arg1)->push_back((Handle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandleVector_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  Handle<Quote > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Handle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Handle<Quote > * temp = new Handle<Quote >((Handle<Quote > &) result);
    CAML_VALUE *fromval = caml_named_value("create_Handle<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_HandleTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_HandleTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandleVector_operator_e___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  std::vector<Handle<Quote > > *arg2 = 0 ;
  std::vector<Handle<Quote > > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Handle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::vector<Handle<Quote > > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    try {
      {
        std::vector<Handle<Quote > > &_result_ref = (arg1)->operator =(*arg2);
        result = (std::vector<Handle<Quote > > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<Handle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandleVector_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  int arg2 ;
  Handle<Quote > *arg3 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Handle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Handle<Quote > *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_HandleTQuote_t);
  }
  {
    try {
      std_vector_Sl_Handle_Sl_Quote_Sg__Sg__set(arg1,arg2,(Handle<Quote > const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_QuoteHandleVector_to_arrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  Handle<Quote > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Handle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    try {
      result = (Handle<Quote > *)std_vector_Sl_Handle_Sl_Quote_Sg__Sg__to_array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Handle<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_HandleTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_HandleTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_QuoteHandleVectorQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<Handle<Quote > > *arg1 = (std::vector<Handle<Quote > > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<Handle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTHandleTQuote_t_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_RelinkableQuoteHandleVector__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  std::vector<RelinkableHandle<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (std::vector<RelinkableHandle<Quote > > *)new std::vector<RelinkableHandle<Quote > >(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<RelinkableHandle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_RelinkableQuoteHandleVector__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<RelinkableHandle<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (std::vector<RelinkableHandle<Quote > > *)new std::vector<RelinkableHandle<Quote > >();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<RelinkableHandle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_RelinkableQuoteHandleVector__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  unsigned int arg1 ;
  RelinkableHandle<Quote > *arg2 = 0 ;
  std::vector<RelinkableHandle<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (RelinkableHandle<Quote > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_RelinkableHandleTQuote_t);
  }
  {
    try {
      result = (std::vector<RelinkableHandle<Quote > > *)new std::vector<RelinkableHandle<Quote > >(arg1,(RelinkableHandle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<RelinkableHandle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_RelinkableQuoteHandleVector__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  std::vector<RelinkableHandle<Quote > > *arg1 = 0 ;
  std::vector<RelinkableHandle<Quote > > *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (std::vector<RelinkableHandle<Quote > > *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    try {
      result = (std::vector<RelinkableHandle<Quote > > *)new std::vector<RelinkableHandle<Quote > >((std::vector<RelinkableHandle<Quote > > const &)*arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<RelinkableHandle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_RelinkableQuoteHandleVectorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_RelinkableQuoteHandleVector__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_RelinkableQuoteHandleVector__SWIG_3QuantLib(args));
    }
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_RelinkableQuoteHandleVector__SWIG_0QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_uint: _v = 1; break;
          case C_int32: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_RelinkableHandleTQuote_t);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_RelinkableQuoteHandleVector__SWIG_2QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_RelinkableQuoteHandleVector'");
}


SWIGEXT CAML_VALUE _wrap_RelinkableQuoteHandleVector_sizeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  unsigned int result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<RelinkableHandle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    try {
      result = (unsigned int)((std::vector<RelinkableHandle<Quote > > const *)arg1)->size();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_uint(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_RelinkableQuoteHandleVector_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<RelinkableHandle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    try {
      result = (bool)((std::vector<RelinkableHandle<Quote > > const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_RelinkableQuoteHandleVector_clearQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<RelinkableHandle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    try {
      (arg1)->clear();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_RelinkableQuoteHandleVector_push_backQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  RelinkableHandle<Quote > *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<RelinkableHandle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (RelinkableHandle<Quote > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_RelinkableHandleTQuote_t);
  }
  {
    try {
      (arg1)->push_back((RelinkableHandle<Quote > const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_RelinkableQuoteHandleVector_operator_bB___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  int arg2 ;
  RelinkableHandle<Quote > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<RelinkableHandle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (arg1)->operator [](arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    RelinkableHandle<Quote > * temp = new RelinkableHandle<Quote >((RelinkableHandle<Quote > &) result);
    CAML_VALUE *fromval = caml_named_value("create_RelinkableHandle<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_RelinkableHandleTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_RelinkableHandleTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_RelinkableQuoteHandleVector_operator_e___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  std::vector<RelinkableHandle<Quote > > *arg2 = 0 ;
  std::vector<RelinkableHandle<Quote > > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<RelinkableHandle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (std::vector<RelinkableHandle<Quote > > *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    try {
      {
        std::vector<RelinkableHandle<Quote > > &_result_ref = (arg1)->operator =(*arg2);
        result = (std::vector<RelinkableHandle<Quote > > *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::vector<RelinkableHandle<Quote > >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_RelinkableQuoteHandleVector_setQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  int arg2 ;
  RelinkableHandle<Quote > *arg3 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<RelinkableHandle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (RelinkableHandle<Quote > *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_RelinkableHandleTQuote_t);
  }
  {
    try {
      std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__set(arg1,arg2,(RelinkableHandle<Quote > const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_RelinkableQuoteHandleVector_to_arrayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  RelinkableHandle<Quote > *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<RelinkableHandle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    try {
      result = (RelinkableHandle<Quote > *)std_vector_Sl_RelinkableHandle_Sl_Quote_Sg__Sg__to_array(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_RelinkableHandle<Quote >_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_RelinkableHandleTQuote_t));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_RelinkableHandleTQuote_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_RelinkableQuoteHandleVectorQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  std::vector<RelinkableHandle<Quote > > *arg1 = (std::vector<RelinkableHandle<Quote > > *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (std::vector<RelinkableHandle<Quote > > *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_std__vectorTRelinkableHandleTQuote_t_t);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_nullIntQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int result;
  
  swig_result = Val_unit;
  {
    try {
      result = (int)nullInt();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_nullDoubleQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  double result;
  
  swig_result = Val_unit;
  {
    try {
      result = (double)nullDouble();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DayCounter_dayCountQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DayCounter *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DayCounter);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (BigInteger)(arg1)->dayCount((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_long(result);
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DayCounter_yearFraction__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Date *arg5 = 0 ;
  Time result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DayCounter *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DayCounter);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg4 = (Date *) caml_ptr_val(caml_list_nth(args,3),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg5 = (Date *) caml_ptr_val(caml_list_nth(args,4),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4,(Date const &)*arg5);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  {
    
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DayCounter_yearFraction__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Date *arg4 = 0 ;
  Time result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DayCounter *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DayCounter);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg4 = (Date *) caml_ptr_val(caml_list_nth(args,3),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3,(Date const &)*arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DayCounter_yearFraction__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  DayCounter *arg1 = (DayCounter *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  Time result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DayCounter *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DayCounter);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (Time)(arg1)->yearFraction((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_DayCounter_yearFractionQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_DayCounter);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_DayCounter_yearFraction__SWIG_2QuantLib(args));
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_DayCounter);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          {
            void *ptr;
            _v = !caml_ptr_val_internal(argv[3], &ptr,SWIGTYPE_p_Date);
          }
          if (_v) {
            free(argv);
            CAMLreturn(_wrap_DayCounter_yearFraction__SWIG_1QuantLib(args));
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_DayCounter);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          {
            void *ptr;
            _v = !caml_ptr_val_internal(argv[3], &ptr,SWIGTYPE_p_Date);
          }
          if (_v) {
            {
              void *ptr;
              _v = !caml_ptr_val_internal(argv[4], &ptr,SWIGTYPE_p_Date);
            }
            if (_v) {
              free(argv);
              CAMLreturn(_wrap_DayCounter_yearFraction__SWIG_0QuantLib(args));
            }
          }
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'DayCounter_yearFraction'");
}


SWIGEXT CAML_VALUE _wrap_DayCounter___str__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DayCounter *arg1 = (DayCounter *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DayCounter *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DayCounter);
  }
  {
    try {
      result = DayCounter___str__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_DayCounterQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DayCounter *arg1 = (DayCounter *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DayCounter *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DayCounter);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Actual360QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Actual360 *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Actual360 *)new QuantLib::Actual360();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Actual360_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Actual360));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Actual360);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_Actual360QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Actual360 *arg1 = (QuantLib::Actual360 *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Actual360 *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Actual360);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Actual365FixedQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Actual365Fixed *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Actual365Fixed *)new QuantLib::Actual365Fixed();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Actual365Fixed_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Actual365Fixed));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Actual365Fixed);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_Actual365FixedQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Actual365Fixed *arg1 = (QuantLib::Actual365Fixed *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Actual365Fixed *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Actual365Fixed);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_USA(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Thirty360__USA);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_BondBasis(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Thirty360__BondBasis);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_European(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Thirty360__European);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_EurobondBasis(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Thirty360__EurobondBasis);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Italian(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Thirty360__Italian);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Thirty360__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Thirty360::Convention arg1 ;
  QuantLib::Thirty360 *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Thirty360::Convention)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Thirty360::Convention_marker");
  }
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Thirty360_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Thirty360));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Thirty360);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Thirty360__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Thirty360 *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Thirty360 *)new QuantLib::Thirty360();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Thirty360_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Thirty360));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Thirty360);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Thirty360QuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Thirty360__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Thirty360__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Thirty360'");
}


SWIGEXT CAML_VALUE _wrap_delete_Thirty360QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Thirty360 *arg1 = (QuantLib::Thirty360 *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Thirty360 *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Thirty360);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_ISMA(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__ActualActual__ISMA);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Bond(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__ActualActual__Bond);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_ISDA(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__ActualActual__ISDA);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Historical(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__ActualActual__Historical);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Actual365(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__ActualActual__Actual365);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_AFB(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__ActualActual__AFB);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Euro(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__ActualActual__Euro);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_ActualActual__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::ActualActual::Convention arg1 ;
  QuantLib::ActualActual *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::ActualActual::Convention)caml_long_val_full(caml_list_nth(args,0),"QuantLib::ActualActual::Convention_marker");
  }
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::ActualActual_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__ActualActual));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__ActualActual);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ActualActual__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::ActualActual *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::ActualActual *)new QuantLib::ActualActual();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::ActualActual_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__ActualActual));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__ActualActual);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ActualActualQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_ActualActual__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_ActualActual__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_ActualActual'");
}


SWIGEXT CAML_VALUE _wrap_delete_ActualActualQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::ActualActual *arg1 = (QuantLib::ActualActual *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::ActualActual *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__ActualActual);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_OneDayCounterQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::OneDayCounter *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::OneDayCounter *)new QuantLib::OneDayCounter();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::OneDayCounter_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__OneDayCounter));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__OneDayCounter);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_OneDayCounterQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::OneDayCounter *arg1 = (QuantLib::OneDayCounter *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::OneDayCounter *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__OneDayCounter);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SimpleDayCounterQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::SimpleDayCounter *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::SimpleDayCounter *)new QuantLib::SimpleDayCounter();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::SimpleDayCounter_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__SimpleDayCounter));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__SimpleDayCounter);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_SimpleDayCounterQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::SimpleDayCounter *arg1 = (QuantLib::SimpleDayCounter *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::SimpleDayCounter *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__SimpleDayCounter);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Simple(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Simple);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Compounded(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Compounded);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Continuous(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Continuous);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_SimpleThenCompounded(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__SimpleThenCompounded);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_InterestRate__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  InterestRate *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (InterestRate *)new InterestRate();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_InterestRate);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_InterestRate__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Rate arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_double_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (DayCounter *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_DayCounter);
  }
  {
    arg3 = (Compounding)caml_long_val_full(caml_list_nth(args,2),"Compounding_marker");
  }
  {
    arg4 = (Frequency)caml_long_val_full(caml_list_nth(args,3),"Frequency_marker");
  }
  {
    try {
      result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_InterestRate);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_InterestRate__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Rate arg1 ;
  DayCounter *arg2 = 0 ;
  Compounding arg3 ;
  InterestRate *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_double_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (DayCounter *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_DayCounter);
  }
  {
    arg3 = (Compounding)caml_long_val_full(caml_list_nth(args,2),"Compounding_marker");
  }
  {
    try {
      result = (InterestRate *)new InterestRate(arg1,(DayCounter const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_InterestRate);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_InterestRateQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_InterestRate__SWIG_0QuantLib(args));
  }
  if (argc == 3) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_double: _v = 1; break;
          default: _v = 0; break;
        }
      }  
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_DayCounter);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_new_InterestRate__SWIG_2QuantLib(args));
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_double: _v = 1; break;
          default: _v = 0; break;
        }
      }  
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_DayCounter);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            free(argv);
            CAMLreturn(_wrap_new_InterestRate__SWIG_1QuantLib(args));
          }
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_InterestRate'");
}


SWIGEXT CAML_VALUE _wrap_InterestRate_rateQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Rate result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    try {
      result = (Rate)((InterestRate const *)arg1)->rate();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_dayCounterQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  InterestRate *arg1 = (InterestRate *) 0 ;
  SwigValueWrapper< DayCounter > result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    try {
      result = ((InterestRate const *)arg1)->dayCounter();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    DayCounter * temp = new DayCounter((DayCounter &) result);
    CAML_VALUE *fromval = caml_named_value("create_DayCounter_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_DayCounter));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_DayCounter);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_compoundingQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Compounding result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    try {
      result = (Compounding)((InterestRate const *)arg1)->compounding();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("Compounding_marker"),Val_int((int)result));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_frequencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Frequency result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    try {
      result = (Frequency)((InterestRate const *)arg1)->frequency();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = callback2(*caml_named_value(SWIG_MODULE "_int_to_enum"),*caml_named_value("Frequency_marker"),Val_int((int)result));
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_discountFactor__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  DiscountFactor result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_discountFactor__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date arg2 ;
  Date arg3 ;
  DiscountFactor result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    arg2 = *((Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date)) ;
  }
  {
    arg3 = *((Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date)) ;
  }
  {
    try {
      result = (DiscountFactor)((InterestRate const *)arg1)->discountFactor(arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_discountFactorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_InterestRate);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_double: _v = 1; break;
            default: _v = 0; break;
          }
        }  
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_InterestRate_discountFactor__SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_InterestRate);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_InterestRate_discountFactor__SWIG_1QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'InterestRate_discountFactor'");
}


SWIGEXT CAML_VALUE _wrap_InterestRate_compoundFactor__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Real result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_compoundFactor__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date arg2 ;
  Date arg3 ;
  Real result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    arg2 = *((Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date)) ;
  }
  {
    arg3 = *((Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date)) ;
  }
  {
    try {
      result = (Real)((InterestRate const *)arg1)->compoundFactor(arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_compoundFactorQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_InterestRate);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_double: _v = 1; break;
            default: _v = 0; break;
          }
        }  
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_InterestRate_compoundFactor__SWIG_0QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_InterestRate);
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_InterestRate_compoundFactor__SWIG_1QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'InterestRate_compoundFactor'");
}


SWIGEXT CAML_VALUE _wrap_InterestRate_impliedRate__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Real arg1 ;
  Time arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  Frequency arg5 ;
  InterestRate result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_double_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (DayCounter *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_DayCounter);
  }
  {
    arg4 = (Compounding)caml_long_val_full(caml_list_nth(args,3),"Compounding_marker");
  }
  {
    arg5 = (Frequency)caml_long_val_full(caml_list_nth(args,4),"Frequency_marker");
  }
  {
    try {
      result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    InterestRate * temp = new InterestRate((InterestRate &) result);
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_InterestRate);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_impliedRate__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Real arg1 ;
  Time arg2 ;
  DayCounter *arg3 = 0 ;
  Compounding arg4 ;
  InterestRate result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_double_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (DayCounter *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_DayCounter);
  }
  {
    arg4 = (Compounding)caml_long_val_full(caml_list_nth(args,3),"Compounding_marker");
  }
  {
    try {
      result = InterestRate::impliedRate(arg1,arg2,(DayCounter const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    InterestRate * temp = new InterestRate((InterestRate &) result);
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_InterestRate);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_impliedRate__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Real arg1 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_double_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg4 = (DayCounter *) caml_ptr_val(caml_list_nth(args,3),SWIGTYPE_p_DayCounter);
  }
  {
    arg5 = (Compounding)caml_long_val_full(caml_list_nth(args,4),"Compounding_marker");
  }
  {
    arg6 = (Frequency)caml_long_val_full(caml_list_nth(args,5),"Frequency_marker");
  }
  {
    try {
      result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    InterestRate * temp = new InterestRate((InterestRate &) result);
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_InterestRate);
    }
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_impliedRate__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Real arg1 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_double_val(caml_list_nth(args,0));
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg4 = (DayCounter *) caml_ptr_val(caml_list_nth(args,3),SWIGTYPE_p_DayCounter);
  }
  {
    arg5 = (Compounding)caml_long_val_full(caml_list_nth(args,4),"Compounding_marker");
  }
  {
    try {
      result = InterestRate::impliedRate(arg1,(Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    InterestRate * temp = new InterestRate((InterestRate &) result);
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_InterestRate);
    }
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_impliedRateQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 4) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_double: _v = 1; break;
          default: _v = 0; break;
        }
      }  
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_double: _v = 1; break;
            default: _v = 0; break;
          }
        }  
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_DayCounter);
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            free(argv);
            CAMLreturn(_wrap_InterestRate_impliedRate__SWIG_1QuantLib(args));
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_double: _v = 1; break;
          default: _v = 0; break;
        }
      }  
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          {
            void *ptr;
            _v = !caml_ptr_val_internal(argv[3], &ptr,SWIGTYPE_p_DayCounter);
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_int: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              free(argv);
              CAMLreturn(_wrap_InterestRate_impliedRate__SWIG_3QuantLib(args));
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_double: _v = 1; break;
          default: _v = 0; break;
        }
      }  
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_double: _v = 1; break;
            default: _v = 0; break;
          }
        }  
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_DayCounter);
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_int: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              free(argv);
              CAMLreturn(_wrap_InterestRate_impliedRate__SWIG_0QuantLib(args));
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_double: _v = 1; break;
          default: _v = 0; break;
        }
      }  
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          {
            void *ptr;
            _v = !caml_ptr_val_internal(argv[3], &ptr,SWIGTYPE_p_DayCounter);
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_int: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              {
                if( !Is_block(argv[5]) ) _v = 0;
                else {
                  switch( SWIG_Tag_val(argv[5]) ) {
                    case C_int: _v = 1; break;
                    default: _v = 0; break;
                  }
                }
              }
              if (_v) {
                free(argv);
                CAMLreturn(_wrap_InterestRate_impliedRate__SWIG_2QuantLib(args));
              }
            }
          }
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'InterestRate_impliedRate'");
}


SWIGEXT CAML_VALUE _wrap_InterestRate_equivalentRate__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  Frequency arg4 ;
  InterestRate result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    arg3 = (Compounding)caml_long_val_full(caml_list_nth(args,2),"Compounding_marker");
  }
  {
    arg4 = (Frequency)caml_long_val_full(caml_list_nth(args,3),"Frequency_marker");
  }
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    InterestRate * temp = new InterestRate((InterestRate &) result);
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_InterestRate);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_equivalentRate__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Time arg2 ;
  Compounding arg3 ;
  InterestRate result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    arg3 = (Compounding)caml_long_val_full(caml_list_nth(args,2),"Compounding_marker");
  }
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate(arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    InterestRate * temp = new InterestRate((InterestRate &) result);
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_InterestRate);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_equivalentRate__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  Frequency arg6 ;
  InterestRate result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg4 = (DayCounter *) caml_ptr_val(caml_list_nth(args,3),SWIGTYPE_p_DayCounter);
  }
  {
    arg5 = (Compounding)caml_long_val_full(caml_list_nth(args,4),"Compounding_marker");
  }
  {
    arg6 = (Frequency)caml_long_val_full(caml_list_nth(args,5),"Frequency_marker");
  }
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    InterestRate * temp = new InterestRate((InterestRate &) result);
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_InterestRate);
    }
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_equivalentRate__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  InterestRate *arg1 = (InterestRate *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  DayCounter *arg4 = 0 ;
  Compounding arg5 ;
  InterestRate result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg4 = (DayCounter *) caml_ptr_val(caml_list_nth(args,3),SWIGTYPE_p_DayCounter);
  }
  {
    arg5 = (Compounding)caml_long_val_full(caml_list_nth(args,4),"Compounding_marker");
  }
  {
    try {
      result = ((InterestRate const *)arg1)->equivalentRate((Date const &)*arg2,(Date const &)*arg3,(DayCounter const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    InterestRate * temp = new InterestRate((InterestRate &) result);
    CAML_VALUE *fromval = caml_named_value("create_InterestRate_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_InterestRate));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_InterestRate);
    }
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_InterestRate_equivalentRateQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_InterestRate);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_double: _v = 1; break;
            default: _v = 0; break;
          }
        }  
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_InterestRate_equivalentRate__SWIG_1QuantLib(args));
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_InterestRate);
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_double: _v = 1; break;
            default: _v = 0; break;
          }
        }  
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            free(argv);
            CAMLreturn(_wrap_InterestRate_equivalentRate__SWIG_0QuantLib(args));
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_InterestRate);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          {
            void *ptr;
            _v = !caml_ptr_val_internal(argv[3], &ptr,SWIGTYPE_p_DayCounter);
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_int: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              free(argv);
              CAMLreturn(_wrap_InterestRate_equivalentRate__SWIG_3QuantLib(args));
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_InterestRate);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          {
            void *ptr;
            _v = !caml_ptr_val_internal(argv[3], &ptr,SWIGTYPE_p_DayCounter);
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_int: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              {
                if( !Is_block(argv[5]) ) _v = 0;
                else {
                  switch( SWIG_Tag_val(argv[5]) ) {
                    case C_int: _v = 1; break;
                    default: _v = 0; break;
                  }
                }
              }
              if (_v) {
                free(argv);
                CAMLreturn(_wrap_InterestRate_equivalentRate__SWIG_2QuantLib(args));
              }
            }
          }
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'InterestRate_equivalentRate'");
}


SWIGEXT CAML_VALUE _wrap_InterestRate___str__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  InterestRate *arg1 = (InterestRate *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    try {
      result = InterestRate___str__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_InterestRateQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  InterestRate *arg1 = (InterestRate *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (InterestRate *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_InterestRate);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Following(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Following);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_ModifiedFollowing(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__ModifiedFollowing);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Preceding(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Preceding);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_ModifiedPreceding(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__ModifiedPreceding);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Unadjusted(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__Unadjusted);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_JoinHolidays(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__JoinHolidays);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_JoinBusinessDays(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    try {
      {
        swig_result = caml_val_int(SWIG_ENUM__JoinBusinessDays);
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Calendar_isBusinessDayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (bool)(arg1)->isBusinessDay((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_isHolidayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (bool)(arg1)->isHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_isEndOfMonthQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (bool)(arg1)->isEndOfMonth((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_addHolidayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      (arg1)->addHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_removeHolidayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      (arg1)->removeHoliday((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_adjust__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  BusinessDayConvention arg3 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    arg3 = (BusinessDayConvention)caml_long_val_full(caml_list_nth(args,2),"BusinessDayConvention_marker");
  }
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_adjust__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (arg1)->adjust((Date const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_adjustQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_Calendar_adjust__SWIG_1QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_Calendar_adjust__SWIG_0QuantLib(args));
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'Calendar_adjust'");
}


SWIGEXT CAML_VALUE _wrap_Calendar_advance__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  bool arg6 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    arg4 = (TimeUnit)caml_long_val_full(caml_list_nth(args,3),"TimeUnit_marker");
  }
  {
    arg5 = (BusinessDayConvention)caml_long_val_full(caml_list_nth(args,4),"BusinessDayConvention_marker");
  }
  {
    arg6 = caml_long_val(caml_list_nth(args,5));
  }
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5,arg6);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_advance__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  BusinessDayConvention arg5 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    arg4 = (TimeUnit)caml_long_val_full(caml_list_nth(args,3),"TimeUnit_marker");
  }
  {
    arg5 = (BusinessDayConvention)caml_long_val_full(caml_list_nth(args,4),"BusinessDayConvention_marker");
  }
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_advance__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Integer arg3 ;
  TimeUnit arg4 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    arg3 = caml_long_val(caml_list_nth(args,2));
  }
  {
    arg4 = (TimeUnit)caml_long_val_full(caml_list_nth(args,3),"TimeUnit_marker");
  }
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,arg3,arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_advance__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  bool arg5 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Period *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Period);
  }
  {
    arg4 = (BusinessDayConvention)caml_long_val_full(caml_list_nth(args,3),"BusinessDayConvention_marker");
  }
  {
    arg5 = caml_long_val(caml_list_nth(args,4));
  }
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_advance__SWIG_4QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  BusinessDayConvention arg4 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Period *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Period);
  }
  {
    arg4 = (BusinessDayConvention)caml_long_val_full(caml_list_nth(args,3),"BusinessDayConvention_marker");
  }
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_advance__SWIG_5QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Period *arg3 = 0 ;
  Date result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Period *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Period);
  }
  {
    try {
      result = (arg1)->advance((Date const &)*arg2,(Period const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE */
    Date * temp = new Date((Date &) result);
    CAML_VALUE *fromval = caml_named_value("create_Date_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)temp,SWIGTYPE_p_Date));
    } else {
      rv = caml_val_ptr ((void *)temp,SWIGTYPE_p_Date);
    }
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_advanceQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Period);
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_Calendar_advance__SWIG_5QuantLib(args));
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Period);
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            free(argv);
            CAMLreturn(_wrap_Calendar_advance__SWIG_4QuantLib(args));
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            free(argv);
            CAMLreturn(_wrap_Calendar_advance__SWIG_2QuantLib(args));
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Period);
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_bool: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              free(argv);
              CAMLreturn(_wrap_Calendar_advance__SWIG_3QuantLib(args));
            }
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_int: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              free(argv);
              CAMLreturn(_wrap_Calendar_advance__SWIG_1QuantLib(args));
            }
          }
        }
      }
    }
  }
  if (argc == 6) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_int: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              {
                if( !Is_block(argv[5]) ) _v = 0;
                else {
                  switch( SWIG_Tag_val(argv[5]) ) {
                    case C_bool: _v = 1; break;
                    default: _v = 0; break;
                  }
                }
              }
              if (_v) {
                free(argv);
                CAMLreturn(_wrap_Calendar_advance__SWIG_0QuantLib(args));
              }
            }
          }
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'Calendar_advance'");
}


SWIGEXT CAML_VALUE _wrap_Calendar_businessDaysBetween__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  bool arg5 ;
  BigInteger result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    arg4 = caml_long_val(caml_list_nth(args,3));
  }
  {
    arg5 = caml_long_val(caml_list_nth(args,4));
  }
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4,arg5);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_long(result);
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_businessDaysBetween__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  bool arg4 ;
  BigInteger result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    arg4 = caml_long_val(caml_list_nth(args,3));
  }
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_long(result);
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_businessDaysBetween__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = (Calendar *) 0 ;
  Date *arg2 = 0 ;
  Date *arg3 = 0 ;
  BigInteger result;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Date *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Date);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Date *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Date);
  }
  {
    try {
      result = (BigInteger)(arg1)->businessDaysBetween((Date const &)*arg2,(Date const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_long(result);
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Calendar_businessDaysBetweenQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_Calendar_businessDaysBetween__SWIG_2QuantLib(args));
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_bool: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            free(argv);
            CAMLreturn(_wrap_Calendar_businessDaysBetween__SWIG_1QuantLib(args));
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Date);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Date);
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_bool: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_bool: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              free(argv);
              CAMLreturn(_wrap_Calendar_businessDaysBetween__SWIG_0QuantLib(args));
            }
          }
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'Calendar_businessDaysBetween'");
}


SWIGEXT CAML_VALUE _wrap_Calendar___str__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Calendar *arg1 = (Calendar *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    try {
      result = Calendar___str__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_CalendarQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Calendar *arg1 = (Calendar *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Calendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Merval(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Argentina__Merval);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Argentina__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Argentina::Market arg1 ;
  QuantLib::Argentina *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Argentina::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Argentina::Market_marker");
  }
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Argentina_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Argentina));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Argentina);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Argentina__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Argentina *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Argentina *)new QuantLib::Argentina();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Argentina_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Argentina));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Argentina);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ArgentinaQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Argentina__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Argentina__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Argentina'");
}


SWIGEXT CAML_VALUE _wrap_delete_ArgentinaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Argentina *arg1 = (QuantLib::Argentina *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Argentina *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Argentina);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_AustraliaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Australia *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Australia *)new QuantLib::Australia();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Australia_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Australia));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Australia);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_AustraliaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Australia *arg1 = (QuantLib::Australia *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Australia *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Australia);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Settlement(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__Settlement);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Exchange(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Brazil__Exchange);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Brazil__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Brazil::Market arg1 ;
  QuantLib::Brazil *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Brazil::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Brazil::Market_marker");
  }
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Brazil_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Brazil));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Brazil);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Brazil__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Brazil *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Brazil *)new QuantLib::Brazil();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Brazil_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Brazil));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Brazil);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_BrazilQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Brazil__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Brazil__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Brazil'");
}


SWIGEXT CAML_VALUE _wrap_delete_BrazilQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Brazil *arg1 = (QuantLib::Brazil *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Brazil *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Brazil);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_TSX(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Canada__TSX);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Canada__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Canada::Market arg1 ;
  QuantLib::Canada *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Canada::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Canada::Market_marker");
  }
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Canada_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Canada));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Canada);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Canada__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Canada *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Canada *)new QuantLib::Canada();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Canada_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Canada));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Canada);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_CanadaQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Canada__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Canada__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Canada'");
}


SWIGEXT CAML_VALUE _wrap_delete_CanadaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Canada *arg1 = (QuantLib::Canada *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Canada *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Canada);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ChinaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::China *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::China *)new QuantLib::China();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::China_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__China));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__China);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_ChinaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::China *arg1 = (QuantLib::China *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::China *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__China);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_PSE(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__CzechRepublic__PSE);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_CzechRepublic__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::CzechRepublic::Market arg1 ;
  QuantLib::CzechRepublic *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::CzechRepublic::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::CzechRepublic::Market_marker");
  }
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::CzechRepublic_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__CzechRepublic));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__CzechRepublic);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_CzechRepublic__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::CzechRepublic *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::CzechRepublic *)new QuantLib::CzechRepublic();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::CzechRepublic_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__CzechRepublic));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__CzechRepublic);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_CzechRepublicQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_CzechRepublic__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_CzechRepublic__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_CzechRepublic'");
}


SWIGEXT CAML_VALUE _wrap_delete_CzechRepublicQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::CzechRepublic *arg1 = (QuantLib::CzechRepublic *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::CzechRepublic *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__CzechRepublic);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DenmarkQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Denmark *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Denmark *)new QuantLib::Denmark();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Denmark_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Denmark));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Denmark);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_DenmarkQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Denmark *arg1 = (QuantLib::Denmark *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Denmark *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Denmark);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_FinlandQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Finland *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Finland *)new QuantLib::Finland();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Finland_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Finland));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Finland);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_FinlandQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Finland *arg1 = (QuantLib::Finland *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Finland *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Finland);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_FrankfurtStockExchange(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Germany__FrankfurtStockExchange);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Xetra(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Germany__Xetra);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_Eurex(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Germany__Eurex);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Germany__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Germany::Market arg1 ;
  QuantLib::Germany *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Germany::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Germany::Market_marker");
  }
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Germany_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Germany));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Germany);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Germany__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Germany *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Germany *)new QuantLib::Germany();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Germany_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Germany));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Germany);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_GermanyQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Germany__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Germany__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Germany'");
}


SWIGEXT CAML_VALUE _wrap_delete_GermanyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Germany *arg1 = (QuantLib::Germany *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Germany *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Germany);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_HKEx(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__HongKong__HKEx);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_HongKong__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::HongKong::Market arg1 ;
  QuantLib::HongKong *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::HongKong::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::HongKong::Market_marker");
  }
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::HongKong_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__HongKong));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__HongKong);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_HongKong__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::HongKong *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::HongKong *)new QuantLib::HongKong();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::HongKong_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__HongKong));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__HongKong);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_HongKongQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_HongKong__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_HongKong__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_HongKong'");
}


SWIGEXT CAML_VALUE _wrap_delete_HongKongQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::HongKong *arg1 = (QuantLib::HongKong *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::HongKong *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__HongKong);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_HungaryQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Hungary *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Hungary *)new QuantLib::Hungary();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Hungary_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Hungary));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Hungary);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_HungaryQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Hungary *arg1 = (QuantLib::Hungary *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Hungary *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Hungary);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_ICEX(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Iceland__ICEX);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Iceland__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Iceland::Market arg1 ;
  QuantLib::Iceland *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Iceland::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Iceland::Market_marker");
  }
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Iceland_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Iceland));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Iceland);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Iceland__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Iceland *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Iceland *)new QuantLib::Iceland();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Iceland_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Iceland));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Iceland);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_IcelandQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Iceland__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Iceland__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Iceland'");
}


SWIGEXT CAML_VALUE _wrap_delete_IcelandQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Iceland *arg1 = (QuantLib::Iceland *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Iceland *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Iceland);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NSE(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__India__NSE);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_India__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::India::Market arg1 ;
  QuantLib::India *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::India::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::India::Market_marker");
  }
  {
    try {
      result = (QuantLib::India *)new QuantLib::India(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::India_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__India));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__India);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_India__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::India *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::India *)new QuantLib::India();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::India_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__India));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__India);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_IndiaQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_India__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_India__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_India'");
}


SWIGEXT CAML_VALUE _wrap_delete_IndiaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::India *arg1 = (QuantLib::India *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::India *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__India);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_BEJ(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Indonesia__BEJ);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_JSX(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Indonesia__JSX);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Indonesia__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Indonesia::Market arg1 ;
  QuantLib::Indonesia *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Indonesia::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Indonesia::Market_marker");
  }
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Indonesia_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Indonesia));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Indonesia);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Indonesia__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Indonesia *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Indonesia *)new QuantLib::Indonesia();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Indonesia_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Indonesia));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Indonesia);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_IndonesiaQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Indonesia__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Indonesia__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Indonesia'");
}


SWIGEXT CAML_VALUE _wrap_delete_IndonesiaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Indonesia *arg1 = (QuantLib::Indonesia *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Indonesia *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Indonesia);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Italy__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Italy::Market arg1 ;
  QuantLib::Italy *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Italy::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Italy::Market_marker");
  }
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Italy_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Italy));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Italy);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Italy__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Italy *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Italy *)new QuantLib::Italy();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Italy_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Italy));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Italy);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ItalyQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Italy__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Italy__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Italy'");
}


SWIGEXT CAML_VALUE _wrap_delete_ItalyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Italy *arg1 = (QuantLib::Italy *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Italy *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Italy);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_JapanQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Japan *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Japan *)new QuantLib::Japan();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Japan_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Japan));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Japan);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_JapanQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Japan *arg1 = (QuantLib::Japan *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Japan *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Japan);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_BMV(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Mexico__BMV);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Mexico__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Mexico::Market arg1 ;
  QuantLib::Mexico *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Mexico::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Mexico::Market_marker");
  }
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Mexico_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Mexico));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Mexico);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Mexico__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Mexico *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Mexico *)new QuantLib::Mexico();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Mexico_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Mexico));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Mexico);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_MexicoQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Mexico__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Mexico__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Mexico'");
}


SWIGEXT CAML_VALUE _wrap_delete_MexicoQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Mexico *arg1 = (QuantLib::Mexico *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Mexico *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Mexico);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NewZealandQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::NewZealand *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::NewZealand *)new QuantLib::NewZealand();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::NewZealand_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__NewZealand));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__NewZealand);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_NewZealandQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::NewZealand *arg1 = (QuantLib::NewZealand *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::NewZealand *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__NewZealand);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NorwayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Norway *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Norway *)new QuantLib::Norway();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Norway_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Norway));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Norway);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_NorwayQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Norway *arg1 = (QuantLib::Norway *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Norway *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Norway);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_PolandQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Poland *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Poland *)new QuantLib::Poland();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Poland_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Poland));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Poland);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_PolandQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Poland *arg1 = (QuantLib::Poland *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Poland *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Poland);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Tadawul(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__SaudiArabia__Tadawul);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_SaudiArabia__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::SaudiArabia::Market arg1 ;
  QuantLib::SaudiArabia *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::SaudiArabia::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::SaudiArabia::Market_marker");
  }
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::SaudiArabia_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__SaudiArabia));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__SaudiArabia);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SaudiArabia__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::SaudiArabia *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::SaudiArabia *)new QuantLib::SaudiArabia();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::SaudiArabia_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__SaudiArabia));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__SaudiArabia);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SaudiArabiaQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_SaudiArabia__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_SaudiArabia__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_SaudiArabia'");
}


SWIGEXT CAML_VALUE _wrap_delete_SaudiArabiaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::SaudiArabia *arg1 = (QuantLib::SaudiArabia *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::SaudiArabia *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__SaudiArabia);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_SGX(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Singapore__SGX);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Singapore__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Singapore::Market arg1 ;
  QuantLib::Singapore *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Singapore::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Singapore::Market_marker");
  }
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Singapore_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Singapore));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Singapore);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Singapore__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Singapore *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Singapore *)new QuantLib::Singapore();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Singapore_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Singapore));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Singapore);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SingaporeQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Singapore__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Singapore__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Singapore'");
}


SWIGEXT CAML_VALUE _wrap_delete_SingaporeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Singapore *arg1 = (QuantLib::Singapore *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Singapore *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Singapore);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_BSSE(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Slovakia__BSSE);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Slovakia__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Slovakia::Market arg1 ;
  QuantLib::Slovakia *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Slovakia::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Slovakia::Market_marker");
  }
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Slovakia_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Slovakia));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Slovakia);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Slovakia__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Slovakia *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Slovakia *)new QuantLib::Slovakia();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Slovakia_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Slovakia));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Slovakia);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SlovakiaQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Slovakia__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Slovakia__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Slovakia'");
}


SWIGEXT CAML_VALUE _wrap_delete_SlovakiaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Slovakia *arg1 = (QuantLib::Slovakia *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Slovakia *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Slovakia);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SouthAfricaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::SouthAfrica *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::SouthAfrica *)new QuantLib::SouthAfrica();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::SouthAfrica_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__SouthAfrica));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__SouthAfrica);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_SouthAfricaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::SouthAfrica *arg1 = (QuantLib::SouthAfrica *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::SouthAfrica *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__SouthAfrica);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_KRX(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__SouthKorea__KRX);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_SouthKorea__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::SouthKorea::Market arg1 ;
  QuantLib::SouthKorea *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::SouthKorea::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::SouthKorea::Market_marker");
  }
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::SouthKorea_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__SouthKorea));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__SouthKorea);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SouthKorea__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::SouthKorea *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::SouthKorea *)new QuantLib::SouthKorea();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::SouthKorea_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__SouthKorea));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__SouthKorea);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SouthKoreaQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_SouthKorea__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_SouthKorea__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_SouthKorea'");
}


SWIGEXT CAML_VALUE _wrap_delete_SouthKoreaQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::SouthKorea *arg1 = (QuantLib::SouthKorea *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::SouthKorea *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__SouthKorea);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SwedenQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Sweden *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Sweden *)new QuantLib::Sweden();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Sweden_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Sweden));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Sweden);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_SwedenQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Sweden *arg1 = (QuantLib::Sweden *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Sweden *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Sweden);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_SwitzerlandQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Switzerland *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Switzerland *)new QuantLib::Switzerland();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Switzerland_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Switzerland));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Switzerland);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_SwitzerlandQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Switzerland *arg1 = (QuantLib::Switzerland *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Switzerland *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Switzerland);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_TSEC(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Taiwan__TSEC);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Taiwan__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Taiwan::Market arg1 ;
  QuantLib::Taiwan *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Taiwan::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Taiwan::Market_marker");
  }
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Taiwan_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Taiwan));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Taiwan);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Taiwan__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Taiwan *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Taiwan *)new QuantLib::Taiwan();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Taiwan_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Taiwan));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Taiwan);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_TaiwanQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Taiwan__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Taiwan__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Taiwan'");
}


SWIGEXT CAML_VALUE _wrap_delete_TaiwanQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Taiwan *arg1 = (QuantLib::Taiwan *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Taiwan *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Taiwan);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_TARGETQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::TARGET *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::TARGET *)new QuantLib::TARGET();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::TARGET_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__TARGET));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__TARGET);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_TARGETQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::TARGET *arg1 = (QuantLib::TARGET *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::TARGET *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__TARGET);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_TurkeyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Turkey *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Turkey *)new QuantLib::Turkey();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Turkey_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Turkey));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Turkey);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_TurkeyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Turkey *arg1 = (QuantLib::Turkey *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Turkey *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Turkey);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_USE(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__Ukraine__USE);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_Ukraine__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Ukraine::Market arg1 ;
  QuantLib::Ukraine *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::Ukraine::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::Ukraine::Market_marker");
  }
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Ukraine_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Ukraine));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Ukraine);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_Ukraine__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::Ukraine *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::Ukraine *)new QuantLib::Ukraine();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::Ukraine_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__Ukraine));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__Ukraine);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_UkraineQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_Ukraine__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_Ukraine__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_Ukraine'");
}


SWIGEXT CAML_VALUE _wrap_delete_UkraineQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::Ukraine *arg1 = (QuantLib::Ukraine *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::Ukraine *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__Ukraine);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Metals(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__UnitedKingdom__Metals);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_UnitedKingdom__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::UnitedKingdom::Market arg1 ;
  QuantLib::UnitedKingdom *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::UnitedKingdom::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::UnitedKingdom::Market_marker");
  }
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::UnitedKingdom_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__UnitedKingdom));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__UnitedKingdom);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_UnitedKingdom__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::UnitedKingdom *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::UnitedKingdom *)new QuantLib::UnitedKingdom();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::UnitedKingdom_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__UnitedKingdom));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__UnitedKingdom);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_UnitedKingdomQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_UnitedKingdom__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_UnitedKingdom__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_UnitedKingdom'");
}


SWIGEXT CAML_VALUE _wrap_delete_UnitedKingdomQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::UnitedKingdom *arg1 = (QuantLib::UnitedKingdom *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::UnitedKingdom *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__UnitedKingdom);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_NYSE(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__UnitedStates__NYSE);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_GovernmentBond(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__UnitedStates__GovernmentBond);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_NERC(CAML_VALUE args) {
  CAML_VALUE swig_result;
  
  {
    swig_result = caml_val_int(SWIG_ENUM__QuantLib__UnitedStates__NERC);
  }
  
  return swig_result;
}


SWIGEXT CAML_VALUE _wrap_new_UnitedStates__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::UnitedStates::Market arg1 ;
  QuantLib::UnitedStates *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = (QuantLib::UnitedStates::Market)caml_long_val_full(caml_list_nth(args,0),"QuantLib::UnitedStates::Market_marker");
  }
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::UnitedStates_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__UnitedStates));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__UnitedStates);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_UnitedStates__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  QuantLib::UnitedStates *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::UnitedStates *)new QuantLib::UnitedStates();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::UnitedStates_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__UnitedStates));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__UnitedStates);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_UnitedStatesQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 0) {
    free(argv);
    CAMLreturn(_wrap_new_UnitedStates__SWIG_1QuantLib(args));
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_UnitedStates__SWIG_0QuantLib(args));
    }
  }
  
  failwith("No matching function for overloaded 'new_UnitedStates'");
}


SWIGEXT CAML_VALUE _wrap_delete_UnitedStatesQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::UnitedStates *arg1 = (QuantLib::UnitedStates *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::UnitedStates *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__UnitedStates);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_NullCalendarQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::NullCalendar *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::NullCalendar *)new QuantLib::NullCalendar();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::NullCalendar_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__NullCalendar));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__NullCalendar);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_NullCalendarQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::NullCalendar *arg1 = (QuantLib::NullCalendar *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::NullCalendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__NullCalendar);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_JointCalendar__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  JointCalendarRule arg3 ;
  QuantLib::JointCalendar *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Calendar *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Calendar *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Calendar);
  }
  {
    arg3 = (JointCalendarRule)caml_long_val_full(caml_list_nth(args,2),"JointCalendarRule_marker");
  }
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::JointCalendar_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__JointCalendar));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__JointCalendar);
    }
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_JointCalendar__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Calendar *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Calendar *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Calendar);
  }
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::JointCalendar_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__JointCalendar));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__JointCalendar);
    }
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_JointCalendar__SWIG_2QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  JointCalendarRule arg4 ;
  QuantLib::JointCalendar *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Calendar *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Calendar *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Calendar *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Calendar);
  }
  {
    arg4 = (JointCalendarRule)caml_long_val_full(caml_list_nth(args,3),"JointCalendarRule_marker");
  }
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::JointCalendar_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__JointCalendar));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__JointCalendar);
    }
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_JointCalendar__SWIG_3QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Calendar *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Calendar *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Calendar *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Calendar);
  }
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::JointCalendar_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__JointCalendar));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__JointCalendar);
    }
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_JointCalendar__SWIG_4QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  JointCalendarRule arg5 ;
  QuantLib::JointCalendar *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Calendar *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Calendar *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Calendar *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg4 = (Calendar *) caml_ptr_val(caml_list_nth(args,3),SWIGTYPE_p_Calendar);
  }
  {
    arg5 = (JointCalendarRule)caml_long_val_full(caml_list_nth(args,4),"JointCalendarRule_marker");
  }
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4,arg5);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::JointCalendar_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__JointCalendar));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__JointCalendar);
    }
  }
  {
    
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_JointCalendar__SWIG_5QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Calendar *arg1 = 0 ;
  Calendar *arg2 = 0 ;
  Calendar *arg3 = 0 ;
  Calendar *arg4 = 0 ;
  QuantLib::JointCalendar *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE & */
    arg1 = (Calendar *) caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg2 = (Calendar *) caml_ptr_val(caml_list_nth(args,1),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg3 = (Calendar *) caml_ptr_val(caml_list_nth(args,2),SWIGTYPE_p_Calendar);
  }
  {
    /* %typemap(in) SWIGTYPE & */
    arg4 = (Calendar *) caml_ptr_val(caml_list_nth(args,3),SWIGTYPE_p_Calendar);
  }
  {
    try {
      result = (QuantLib::JointCalendar *)new QuantLib::JointCalendar((Calendar const &)*arg1,(Calendar const &)*arg2,(Calendar const &)*arg3,(Calendar const &)*arg4);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::JointCalendar_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__JointCalendar));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__JointCalendar);
    }
  }
  {
    
  }
  {
    
  }
  {
    
  }
  {
    
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_JointCalendarQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 2) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Calendar);
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_JointCalendar__SWIG_1QuantLib(args));
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Calendar);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Calendar);
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_new_JointCalendar__SWIG_3QuantLib(args));
        }
      }
    }
  }
  if (argc == 3) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Calendar);
      }
      if (_v) {
        {
          if( !Is_block(argv[2]) ) _v = 0;
          else {
            switch( SWIG_Tag_val(argv[2]) ) {
              case C_int: _v = 1; break;
              default: _v = 0; break;
            }
          }
        }
        if (_v) {
          free(argv);
          CAMLreturn(_wrap_new_JointCalendar__SWIG_0QuantLib(args));
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Calendar);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Calendar);
        }
        if (_v) {
          {
            void *ptr;
            _v = !caml_ptr_val_internal(argv[3], &ptr,SWIGTYPE_p_Calendar);
          }
          if (_v) {
            free(argv);
            CAMLreturn(_wrap_new_JointCalendar__SWIG_5QuantLib(args));
          }
        }
      }
    }
  }
  if (argc == 4) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Calendar);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Calendar);
        }
        if (_v) {
          {
            if( !Is_block(argv[3]) ) _v = 0;
            else {
              switch( SWIG_Tag_val(argv[3]) ) {
                case C_int: _v = 1; break;
                default: _v = 0; break;
              }
            }
          }
          if (_v) {
            free(argv);
            CAMLreturn(_wrap_new_JointCalendar__SWIG_2QuantLib(args));
          }
        }
      }
    }
  }
  if (argc == 5) {
    int _v;
    {
      void *ptr;
      _v = !caml_ptr_val_internal(argv[0], &ptr,SWIGTYPE_p_Calendar);
    }
    if (_v) {
      {
        void *ptr;
        _v = !caml_ptr_val_internal(argv[1], &ptr,SWIGTYPE_p_Calendar);
      }
      if (_v) {
        {
          void *ptr;
          _v = !caml_ptr_val_internal(argv[2], &ptr,SWIGTYPE_p_Calendar);
        }
        if (_v) {
          {
            void *ptr;
            _v = !caml_ptr_val_internal(argv[3], &ptr,SWIGTYPE_p_Calendar);
          }
          if (_v) {
            {
              if( !Is_block(argv[4]) ) _v = 0;
              else {
                switch( SWIG_Tag_val(argv[4]) ) {
                  case C_int: _v = 1; break;
                  default: _v = 0; break;
                }
              }
            }
            if (_v) {
              free(argv);
              CAMLreturn(_wrap_new_JointCalendar__SWIG_4QuantLib(args));
            }
          }
        }
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_JointCalendar'");
}


SWIGEXT CAML_VALUE _wrap_delete_JointCalendarQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::JointCalendar *arg1 = (QuantLib::JointCalendar *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::JointCalendar *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__JointCalendar);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_RoundingQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Rounding *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (Rounding *)new Rounding();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Rounding_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Rounding));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Rounding);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Rounding_operator_pP___QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Rounding *arg1 = (Rounding *) 0 ;
  Decimal arg2 ;
  Decimal result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Rounding *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Rounding);
  }
  {
    arg2 = caml_double_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (Decimal)((Rounding const *)arg1)->operator ()(arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_double(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_RoundingQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Rounding *arg1 = (Rounding *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Rounding *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Rounding);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_UpRounding__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  Integer arg2 ;
  UpRounding *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (UpRounding *)new UpRounding(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_UpRounding_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_UpRounding));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_UpRounding);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_UpRounding__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  UpRounding *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (UpRounding *)new UpRounding(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_UpRounding_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_UpRounding));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_UpRounding);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_UpRoundingQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_UpRounding__SWIG_1QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_UpRounding__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_UpRounding'");
}


SWIGEXT CAML_VALUE _wrap_delete_UpRoundingQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  UpRounding *arg1 = (UpRounding *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (UpRounding *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_UpRounding);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DownRounding__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  Integer arg2 ;
  DownRounding *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (DownRounding *)new DownRounding(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_DownRounding_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_DownRounding));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_DownRounding);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DownRounding__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  DownRounding *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (DownRounding *)new DownRounding(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_DownRounding_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_DownRounding));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_DownRounding);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_DownRoundingQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_DownRounding__SWIG_1QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_DownRounding__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_DownRounding'");
}


SWIGEXT CAML_VALUE _wrap_delete_DownRoundingQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  DownRounding *arg1 = (DownRounding *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (DownRounding *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_DownRounding);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ClosestRounding__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  Integer arg2 ;
  ClosestRounding *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (ClosestRounding *)new ClosestRounding(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_ClosestRounding_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_ClosestRounding));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_ClosestRounding);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ClosestRounding__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  ClosestRounding *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (ClosestRounding *)new ClosestRounding(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_ClosestRounding_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_ClosestRounding));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_ClosestRounding);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ClosestRoundingQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_ClosestRounding__SWIG_1QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_ClosestRounding__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_ClosestRounding'");
}


SWIGEXT CAML_VALUE _wrap_delete_ClosestRoundingQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  ClosestRounding *arg1 = (ClosestRounding *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (ClosestRounding *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_ClosestRounding);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_CeilingTruncation__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  Integer arg2 ;
  CeilingTruncation *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (CeilingTruncation *)new CeilingTruncation(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_CeilingTruncation_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_CeilingTruncation));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_CeilingTruncation);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_CeilingTruncation__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  CeilingTruncation *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (CeilingTruncation *)new CeilingTruncation(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_CeilingTruncation_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_CeilingTruncation));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_CeilingTruncation);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_CeilingTruncationQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_CeilingTruncation__SWIG_1QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_CeilingTruncation__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_CeilingTruncation'");
}


SWIGEXT CAML_VALUE _wrap_delete_CeilingTruncationQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  CeilingTruncation *arg1 = (CeilingTruncation *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (CeilingTruncation *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_CeilingTruncation);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_FloorTruncation__SWIG_0QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  Integer arg2 ;
  FloorTruncation *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    arg2 = caml_long_val(caml_list_nth(args,1));
  }
  {
    try {
      result = (FloorTruncation *)new FloorTruncation(arg1,arg2);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_FloorTruncation_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_FloorTruncation));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_FloorTruncation);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_FloorTruncation__SWIG_1QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  int i;
  int argc = caml_list_length(args);
  CAML_VALUE *argv;
  Integer arg1 ;
  FloorTruncation *result = 0 ;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  swig_result = Val_unit;
  {
    arg1 = caml_long_val(caml_list_nth(args,0));
  }
  {
    try {
      result = (FloorTruncation *)new FloorTruncation(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_FloorTruncation_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_FloorTruncation));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_FloorTruncation);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  free(argv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_FloorTruncationQuantLib(CAML_VALUE args) {
  CAMLparam1(args);
  int i;
  int argc = caml_list_length(args);
  
  int _v = 0;
  CAML_VALUE *argv;
  
  argv = (CAML_VALUE *)malloc( argc * sizeof( CAML_VALUE ) );
  for( i = 0; i < argc; i++ ) {
    argv[i] = caml_list_nth(args,i);
  }
  if (argc == 1) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      free(argv);
      CAMLreturn(_wrap_new_FloorTruncation__SWIG_1QuantLib(args));
    }
  }
  if (argc == 2) {
    int _v;
    {
      if( !Is_block(argv[0]) ) _v = 0;
      else {
        switch( SWIG_Tag_val(argv[0]) ) {
          case C_int: _v = 1; break;
          default: _v = 0; break;
        }
      }
    }
    if (_v) {
      {
        if( !Is_block(argv[1]) ) _v = 0;
        else {
          switch( SWIG_Tag_val(argv[1]) ) {
            case C_int: _v = 1; break;
            default: _v = 0; break;
          }
        }
      }
      if (_v) {
        free(argv);
        CAMLreturn(_wrap_new_FloorTruncation__SWIG_0QuantLib(args));
      }
    }
  }
  
  failwith("No matching function for overloaded 'new_FloorTruncation'");
}


SWIGEXT CAML_VALUE _wrap_delete_FloorTruncationQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  FloorTruncation *arg1 = (FloorTruncation *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (FloorTruncation *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_FloorTruncation);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_nameQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->name();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char > const_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_codeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->code();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char > const_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_numericCodeQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  Integer result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      result = (Integer)((Currency const *)arg1)->numericCode();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_symbolQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->symbol();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char > const_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_fractionSymbolQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  std::string *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      {
        std::string const &_result_ref = ((Currency const *)arg1)->fractionSymbol();
        result = (std::string *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_std::basic_string<char > const_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_std__basic_stringTchar_t);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_fractionsPerUnitQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  Integer result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      result = (Integer)((Currency const *)arg1)->fractionsPerUnit();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_int(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_roundingQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  Rounding *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      {
        Rounding const &_result_ref = ((Currency const *)arg1)->rounding();
        result = (Rounding *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_Rounding const_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_Rounding));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_Rounding);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_formatQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      result = ((Currency const *)arg1)->format();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_emptyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  bool result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      result = (bool)((Currency const *)arg1)->empty();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_bool(result);
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency_triangulationCurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  Currency *result = 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      {
        Currency const &_result_ref = ((Currency const *)arg1)->triangulationCurrency();
        result = (Currency *) &_result_ref;
      }
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(out) SWIGTYPE & */
    CAML_VALUE *fromval = caml_named_value("create_Currency const_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *) &result,SWIGTYPE_p_Currency));
    } else {
      rv = caml_val_ptr ((void *) &result,SWIGTYPE_p_Currency);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_Currency___str__QuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  std::string result;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      result = Currency___str__(arg1);
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    rv = caml_val_string_len((&result)->c_str(),(&result)->size());
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_CurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (Currency *)new Currency();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_Currency_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_Currency));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_Currency);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_CurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  Currency *arg1 = (Currency *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (Currency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_Currency);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ARSCurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::ARSCurrency *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::ARSCurrency *)new QuantLib::ARSCurrency();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::ARSCurrency_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__ARSCurrency));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__ARSCurrency);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_ARSCurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::ARSCurrency *arg1 = (QuantLib::ARSCurrency *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::ARSCurrency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__ARSCurrency);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_ATSCurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::ATSCurrency *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::ATSCurrency *)new QuantLib::ATSCurrency();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::ATSCurrency_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__ATSCurrency));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__ATSCurrency);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_ATSCurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::ATSCurrency *arg1 = (QuantLib::ATSCurrency *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::ATSCurrency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__ATSCurrency);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_AUDCurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::AUDCurrency *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::AUDCurrency *)new QuantLib::AUDCurrency();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::AUDCurrency_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__AUDCurrency));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__AUDCurrency);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_AUDCurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::AUDCurrency *arg1 = (QuantLib::AUDCurrency *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::AUDCurrency *)caml_ptr_val(caml_list_nth(args,0),SWIGTYPE_p_QuantLib__AUDCurrency);
  }
  {
    try {
      delete arg1;
      
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  rv = Val_unit;
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_new_BDTCurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::BDTCurrency *result = 0 ;
  
  swig_result = Val_unit;
  {
    try {
      result = (QuantLib::BDTCurrency *)new QuantLib::BDTCurrency();
    } catch (std::out_of_range& e) {
      SWIG_exception(SWIG_IndexError,const_cast<char*>(e.what()));
    } catch (std::exception& e) {
      SWIG_exception(SWIG_RuntimeError,const_cast<char*>(e.what()));
    } catch (...) {
      SWIG_exception(SWIG_UnknownError,"unknown error");
    }
  }
  {
    /* %typemap(directorin) SWIGTYPE *, SWIGTYPE (CLASS::*) */
    CAML_VALUE *fromval = caml_named_value("create_QuantLib::BDTCurrency_from_ptr");
    if( fromval ) {
      rv = callback(*fromval,caml_val_ptr((void *)result,SWIGTYPE_p_QuantLib__BDTCurrency));
    } else {
      rv = caml_val_ptr ((void *)result,SWIGTYPE_p_QuantLib__BDTCurrency);
    }
  }
  swig_result = caml_list_append(swig_result,rv);
  CAMLreturn(swig_result);
}


SWIGEXT CAML_VALUE _wrap_delete_BDTCurrencyQuantLib (CAML_VALUE args)
{
  CAMLparam1(args);
  SWIG_CAMLlocal2(swig_result,rv);
  int _v = 0;
  QuantLib::BDTCurrency *arg1 = (QuantLib::BDTCurrency *) 0 ;
  
  swig_result = Val_unit;
  {
    /* %typemap(in) SWIGTYPE * */
    arg1 = (QuantLib::BDTCurrency *)caml_ptr_val(caml_list_nth(args,0)