/*
 * hicumL2V2p23.core.cpp - device implementations for hicumL2V2p23 module
 *
 * This is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 */

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "hicumL2V2p23.analogfunction.h"
#include "component.h"
#include "device.h"
#include "hicumL2V2p23.core.h"

#ifndef CIR_hicumL2V2p23
#define CIR_hicumL2V2p23 -1
#endif

// external nodes
#define c 0
#define b 1
#define e 2
#define s 3
#define tnode 4
// internal nodes
#define ci 5
#define ei 6
#define bp 7
#define bi 8
#define si 9
#define xf1 10
#define xf2 11
#define xf3 12
#define xf4 13
#define n1 14
#define n2 15

// useful macro definitions
#define NP(node) real (getV (node))
#define BP(pnode,nnode) (NP(pnode) - NP(nnode))
#define _load_static_residual2(pnode,nnode,current)\
	_rhs[pnode] -= current;\
	_rhs[nnode] += current;
#define _load_static_augmented_residual2(pnode,nnode,current)\
	_rhs[pnode] -= current;\
	_rhs[nnode] += current;
#define _load_static_residual1(node,current)\
	_rhs[node] -= current;
#define _load_static_augmented_residual1(node,current)\
	_rhs[node] -= current;
#define _load_static_jacobian4(pnode,nnode,vpnode,vnnode,conductance)\
	_jstat[pnode][vpnode] += conductance;\
	_jstat[nnode][vnnode] += conductance;\
	_jstat[pnode][vnnode] -= conductance;\
	_jstat[nnode][vpnode] -= conductance;\
	if (doHB) {\
	_ghs[pnode] += conductance * BP(vpnode,vnnode);\
	_ghs[nnode] -= conductance * BP(vpnode,vnnode);\
        } else {\
	_rhs[pnode] += conductance * BP(vpnode,vnnode);\
	_rhs[nnode] -= conductance * BP(vpnode,vnnode);\
	}
#define _load_static_jacobian2p(node,vpnode,vnnode,conductance)\
	_jstat[node][vpnode] += conductance;\
	_jstat[node][vnnode] -= conductance;\
	if (doHB) {\
        _ghs[node] += conductance * BP(vpnode,vnnode);\
        } else {\
        _rhs[node] += conductance * BP(vpnode,vnnode);\
	}
#define _load_static_jacobian2s(pnode,nnode,node,conductance)\
	_jstat[pnode][node] += conductance;\
	_jstat[nnode][node] -= conductance;\
	if (doHB) {\
	_ghs[pnode] += conductance * NP(node);\
	_ghs[nnode] -= conductance * NP(node);\
        } else {\
	_rhs[pnode] += conductance * NP(node);\
	_rhs[nnode] -= conductance * NP(node);\
	}
#define _load_static_jacobian1(node,vnode,conductance)\
	_jstat[node][vnode] += conductance;\
	if (doHB) {\
	_ghs[node] += conductance * NP(vnode);\
        } else {\
	_rhs[node] += conductance * NP(vnode);\
	}
#define _load_dynamic_residual2(pnode,nnode,charge)\
	if (doTR) _charges[pnode][nnode] += charge;\
	if (doHB) {\
	_qhs[pnode] -= charge;\
	_qhs[nnode] += charge;\
	}
#define _load_dynamic_residual1(node,charge)\
	if (doTR) _charges[node][node] += charge;\
	if (doHB) {\
	_qhs[node] -= charge;\
	}
#define _load_dynamic_jacobian4(pnode,nnode,vpnode,vnnode,capacitance)\
	if (doAC) {\
	_jdyna[pnode][vpnode] += capacitance;\
	_jdyna[nnode][vnnode] += capacitance;\
	_jdyna[pnode][vnnode] -= capacitance;\
	_jdyna[nnode][vpnode] -= capacitance;\
	}\
        if (doTR) {\
        _caps[pnode][nnode][vpnode][vnnode] += capacitance;\
  	}\
	if (doHB) {\
	_chs[pnode] += capacitance * BP(vpnode,vnnode);\
	_chs[nnode] -= capacitance * BP(vpnode,vnnode);\
	}
#define _load_dynamic_jacobian2s(pnode,nnode,vnode,capacitance)\
	if (doAC) {\
	_jdyna[pnode][vnode] += capacitance;\
	_jdyna[nnode][vnode] -= capacitance;\
	}\
	if (doTR) {\
	_caps[pnode][nnode][vnode][vnode] += capacitance;\
	}\
	if (doHB) {\
	_chs[pnode] += capacitance * NP(vnode);\
	_chs[nnode] -= capacitance * NP(vnode);\
	}
#define _load_dynamic_jacobian2p(node,vpnode,vnnode,capacitance)\
	if (doAC) {\
	_jdyna[node][vpnode] += capacitance;\
        _jdyna[node][vnnode] -= capacitance;\
        }\
	if (doTR) {\
        _caps[node][node][vpnode][vnnode] += capacitance;\
	}\
	if (doHB) {\
	_chs[node] += capacitance * BP(vpnode,vnnode);\
	}
#define _load_dynamic_jacobian1(node,vnode,capacitance)\
	if (doAC) {\
	_jdyna[node][vnode] += capacitance;\
	}\
	if (doTR) {\
	_caps[node][node][vnode][vnode] += capacitance;\
	}\
	if (doHB) {\
	_chs[node] += capacitance * NP(vnode);\
	}

#define _save_whitenoise1(n1,pwr,type)\
	_white_pwr[n1][n1] += pwr;
#define _save_whitenoise2(n1,n2,pwr,type)\
	_white_pwr[n1][n2] += pwr;
#define _save_flickernoise1(n1,pwr,exp,type)\
	_flicker_pwr[n1][n1] += pwr;\
	_flicker_exp[n1][n1] += exp;
#define _save_flickernoise2(n1,n2,pwr,exp,type)\
	_flicker_pwr[n1][n2] += pwr;\
	_flicker_exp[n1][n2] += exp;
#define _load_whitenoise2(n1,n2,pwr)\
	cy (n1,n2) -= pwr/kB/T0; cy (n2,n1) -= pwr/kB/T0;\
	cy (n1,n1) += pwr/kB/T0; cy (n2,n2) += pwr/kB/T0;
#define _load_whitenoise1(n1,pwr)\
	cy (n1,n1) += pwr/kB/T0;
#define _load_flickernoise2(n1,n2,pwr,exp)\
	cy (n1,n2) -= pwr*pow(_freq,-exp)/kB/T0;\
	cy (n2,n1) -= pwr*pow(_freq,-exp)/kB/T0;\
	cy (n1,n1) += pwr*pow(_freq,-exp)/kB/T0;\
	cy (n2,n2) += pwr*pow(_freq,-exp)/kB/T0;
#define _load_flickernoise1(n1,pwr,exp)\
	cy (n1,n1) += pwr*pow(_freq,-exp)/kB/T0;

// derivative helper macros
#define m00_hypot(v00,x,y)      v00 = xhypot(x,y);
#define m10_hypot(v10,v00,x,y)  v10 = (x)/(v00);
#define m11_hypot(v11,v00,x,y)  v11 = (y)/(v00);
#define m00_max(v00,x,y)        v00 = ((x)>(y))?(x):(y);
#define m10_max(v10,v00,x,y)    v10 = ((x)>(y))?1.0:0.0;
#define m11_max(v11,v00,x,y)    v11 = ((x)>(y))?0.0:1.0;
#define m00_min(v00,x,y)        v00 = ((x)<(y))?(x):(y);
#define m10_min(v10,v00,x,y)    v10 = ((x)<(y))?1.0:0.0;
#define m11_min(v11,v00,x,y)    v11 = ((x)<(y))?0.0:1.0;
#define m00_pow(v00,x,y)        v00 = pow(x,y);
#define m10_pow(v10,v00,x,y)    v10 = (x==0.0)?0.0:(v00)*(y)/(x);
#define m11_pow(v11,v00,x,y)    v11 = (x==0.0)?0.0:(log(x)*(v00));

#define m00_div(v00,v10,x,y)    double v10=1/(y); double v00=(x)*v10;
#define m10_div(v10,v00,vv,x,y)
#define m11_div(v11,v00,vv,x,y) double v11 = -v00*vv;

#define m00_mult(v00,v10,v11,x,y) double v10=(x); double v11=(y); double v00=v10*v11;
#define m00_add(v00,x,y)        double v00=(x)+(y);

#define m00_cos(v00,x)          v00 = cos(x);
#define m10_cos(v10,v00,x)      v10 = (-sin(x));
#define m00_sin(v00,x)          v00 = sin(x);
#define m10_sin(v10,v00,x)      v10 = (cos(x));
#define m00_tan(v00,x)          v00 = tan(x);
#define m10_tan(v10,v00,x)      v10 = (1.0/cos(x)/cos(x));
#define m00_cosh(v00,x)         v00 = cosh(x);
#define m10_cosh(v10,v00,x)     v10 = (sinh(x));
#define m00_sinh(v00,x)         v00 = sinh(x);
#define m10_sinh(v10,v00,x)     v10 = (cosh(x));
#define m00_tanh(v00,x)         v00 = tanh(x);
#define m10_tanh(v10,v00,x)     v10 = (1.0/cosh(x)/cosh(x));
#define m00_acos(v00,x)         v00 = acos(x);
#define m10_acos(v10,v00,x)     v10 = (-1.0/sqrt(1-x*x));
#define m00_asin(v00,x)         v00 = asin(x);
#define m10_asin(v10,v00,x)     v10 = (+1.0/sqrt(1-x*x));
#define m00_atan(v00,x)         v00 = atan(x);
#define m10_atan(v10,v00,x)     v10 = (+1.0/(1+x*x));
#define m00_logE(v00,x)         v00 = log(x);
#define m10_logE(v10,v00,x)     v10 = (1.0/x);
#define m00_log10(v00,x)        v00 = log10(x);
#define m10_log10(v10,v00,x)    v10 = (1.0/x/M_LN10);
#define m00_sqrt(v00,x)         v00 = sqrt(x);
#define m10_sqrt(v10,v00,x)     v10 = (0.5/v00);
#define m00_fabs(v00,x)         v00 = fabs(x);
#define m10_fabs(v10,v00,x)     v10 = (((x)>=0)?(+1.0):(-1.0));

#define m00_exp(v00,x)          v00 = exp(x);
#define m10_exp(v10,v00,x)      v10 = v00;

#define m00_abs(v00)            ((v00)<(0)?(-(v00)):(v00))
#define m00_floor(v00,x)        v00 = floor(x);
#define m00_limexp(v00,x)       v00 = ((x)<80.0?exp(x):exp(80.0)*(x-79.0));
#define m10_limexp(v10,v00,x)   v10 = ((x)<80.0?(v00):exp(80.0));

#define m20_logE(v00)           (-1.0/v00/v00)
#define m20_exp(v00)            exp(v00)
#define m20_limexp(v00)         ((v00)<80.0?exp(v00):0.0)
#define m20_sqrt(v00)           (-0.25/(v00)/sqrt(v00))
#define m20_fabs(v00)           0.0
#define m20_pow(x,y)            ((y)*((y)-1.0)*pow(x,y)/(x)/(x))
#define m00_vt(x)               (kBoverQ*(x))
#define m10_vt(x)               (kBoverQ)

// simulator specific definitions
#define _modelname              "hicumL2V2p23"
#define _instancename           getName()
#define _circuit_temp	        (getPropertyDouble("Temp")+273.15)
#define _param_given(p)		(isPropertyGiven(p)?1:0)


// $vt and $vt() functions 
#define _vt_nom                 (kBoverQ*_circuit_temp)

using namespace device;

/* Device constructor. */
hicumL2V2p23::hicumL2V2p23() : circuit (16)
{
  type = CIR_hicumL2V2p23;
}

/* Initialization of model. */
void hicumL2V2p23::initModel (void)
{
  // create internal nodes
  setInternalNode (ci, "ci");
  setInternalNode (ei, "ei");
  setInternalNode (bp, "bp");
  setInternalNode (bi, "bi");
  setInternalNode (si, "si");
  setInternalNode (xf1, "xf1");
  setInternalNode (xf2, "xf2");
  setInternalNode (xf3, "xf3");
  setInternalNode (xf4, "xf4");
  setInternalNode (n1, "n1");
  setInternalNode (n2, "n2");

  // get device model parameters
  loadVariables ();
  // evaluate global model equations
  initializeModel ();
  // evaluate initial step equations
  initialStep ();
  // evaluate global instance equations
  initializeInstance ();
}

/* Initialization of DC analysis. */
void hicumL2V2p23::initDC (void)
{
  allocMatrixMNA ();
  initModel ();
  pol = 1;
  restartDC ();
  doAC = 1;
  doTR = 0;
  doHB = 0;
}

/* Run when DC is restarted (fallback algorithms). */
void hicumL2V2p23::restartDC (void)
{
}

/* Initialize Verilog-AMS code. */
void hicumL2V2p23::initVerilog (void)
{
  // initialization of noise variables
  _white_pwr[n2][n2] = 0.0;
  _white_pwr[n1][n1] = 0.0;
  _white_pwr[ci][bi] = 0.0;
  _white_pwr[si][s] = 0.0;
  _white_pwr[ei][e] = 0.0;
  _white_pwr[ci][c] = 0.0;
  _white_pwr[si][ci] = 0.0;
  _white_pwr[bp][ei] = 0.0;
  _white_pwr[bp][bi] = 0.0;
  _white_pwr[b][bp] = 0.0;
  _white_pwr[bp][ci] = 0.0;
  _white_pwr[bi][ci] = 0.0;
  _flicker_pwr[bp][ei] = 0.0;
  _flicker_exp[bp][ei] = 0.0;
  _flicker_pwr[bi][ei] = 0.0;
  _flicker_exp[bi][ei] = 0.0;

  int i1, i2, i3, i4;

  // zero charges
  for (i1 = 0; i1 < 16; i1++) {
  for (i2 = 0; i2 < 16; i2++) {
    _charges[i1][i2] = 0.0;
  } }

  // zero capacitances
  for (i1 = 0; i1 < 16; i1++) {
  for (i2 = 0; i2 < 16; i2++) {
  for (i3 = 0; i3 < 16; i3++) {
  for (i4 = 0; i4 < 16; i4++) {
    _caps[i1][i2][i3][i4] = 0.0;
  } } } }

  // zero right hand side, static and dynamic jacobian
  for (i1 = 0; i1 < 16; i1++) {
    _rhs[i1] = 0.0;
    _qhs[i1] = 0.0;
    _chs[i1] = 0.0;
    _ghs[i1] = 0.0;
    for (i2 = 0; i2 < 16; i2++) {
      _jstat[i1][i2] = 0.0;
      _jdyna[i1][i2] = 0.0;
    }
  }
}

/* Load device model input parameters. */
void hicumL2V2p23::loadVariables (void)
{
  c10 = getPropertyDouble ("c10");
  qp0 = getPropertyDouble ("qp0");
  ich = getPropertyDouble ("ich");
  hfe = getPropertyDouble ("hfe");
  hfc = getPropertyDouble ("hfc");
  hjei = getPropertyDouble ("hjei");
  hjci = getPropertyDouble ("hjci");
  ibeis = getPropertyDouble ("ibeis");
  mbei = getPropertyDouble ("mbei");
  ireis = getPropertyDouble ("ireis");
  mrei = getPropertyDouble ("mrei");
  ibeps = getPropertyDouble ("ibeps");
  mbep = getPropertyDouble ("mbep");
  ireps = getPropertyDouble ("ireps");
  mrep = getPropertyDouble ("mrep");
  mcf = getPropertyDouble ("mcf");
  tbhrec = getPropertyDouble ("tbhrec");
  ibcis = getPropertyDouble ("ibcis");
  mbci = getPropertyDouble ("mbci");
  ibcxs = getPropertyDouble ("ibcxs");
  mbcx = getPropertyDouble ("mbcx");
  ibets = getPropertyDouble ("ibets");
  abet = getPropertyDouble ("abet");
  tunode = getPropertyInteger ("tunode");
  favl = getPropertyDouble ("favl");
  qavl = getPropertyDouble ("qavl");
  alfav = getPropertyDouble ("alfav");
  alqav = getPropertyDouble ("alqav");
  rbi0 = getPropertyDouble ("rbi0");
  rbx = getPropertyDouble ("rbx");
  fgeo = getPropertyDouble ("fgeo");
  fdqr0 = getPropertyDouble ("fdqr0");
  fcrbi = getPropertyDouble ("fcrbi");
  fqi = getPropertyDouble ("fqi");
  re = getPropertyDouble ("re");
  rcx = getPropertyDouble ("rcx");
  itss = getPropertyDouble ("itss");
  msf = getPropertyDouble ("msf");
  iscs = getPropertyDouble ("iscs");
  msc = getPropertyDouble ("msc");
  tsf = getPropertyDouble ("tsf");
  rsu = getPropertyDouble ("rsu");
  csu = getPropertyDouble ("csu");
  cjei0 = getPropertyDouble ("cjei0");
  vdei = getPropertyDouble ("vdei");
  zei = getPropertyDouble ("zei");
  ajei = getPropertyDouble ("ajei");
  cjep0 = getPropertyDouble ("cjep0");
  vdep = getPropertyDouble ("vdep");
  zep = getPropertyDouble ("zep");
  ajep = getPropertyDouble ("ajep");
  cjci0 = getPropertyDouble ("cjci0");
  vdci = getPropertyDouble ("vdci");
  zci = getPropertyDouble ("zci");
  vptci = getPropertyDouble ("vptci");
  cjcx0 = getPropertyDouble ("cjcx0");
  vdcx = getPropertyDouble ("vdcx");
  zcx = getPropertyDouble ("zcx");
  vptcx = getPropertyDouble ("vptcx");
  fbcpar = getPropertyDouble ("fbcpar");
  fbepar = getPropertyDouble ("fbepar");
  cjs0 = getPropertyDouble ("cjs0");
  vds = getPropertyDouble ("vds");
  zs = getPropertyDouble ("zs");
  vpts = getPropertyDouble ("vpts");
  t0 = getPropertyDouble ("t0");
  dt0h = getPropertyDouble ("dt0h");
  tbvl = getPropertyDouble ("tbvl");
  tef0 = getPropertyDouble ("tef0");
  gtfe = getPropertyDouble ("gtfe");
  thcs = getPropertyDouble ("thcs");
  ahc = getPropertyDouble ("ahc");
  fthc = getPropertyDouble ("fthc");
  rci0 = getPropertyDouble ("rci0");
  vlim = getPropertyDouble ("vlim");
  vces = getPropertyDouble ("vces");
  vpt = getPropertyDouble ("vpt");
  tr = getPropertyDouble ("tr");
  cbepar = getPropertyDouble ("cbepar");
  cbcpar = getPropertyDouble ("cbcpar");
  alqf = getPropertyDouble ("alqf");
  alit = getPropertyDouble ("alit");
  flnqs = getPropertyInteger ("flnqs");
  kf = getPropertyDouble ("kf");
  af = getPropertyDouble ("af");
  cfbe = getPropertyInteger ("cfbe");
  latb = getPropertyDouble ("latb");
  latl = getPropertyDouble ("latl");
  vgb = getPropertyDouble ("vgb");
  alt0 = getPropertyDouble ("alt0");
  kt0 = getPropertyDouble ("kt0");
  zetaci = getPropertyDouble ("zetaci");
  alvs = getPropertyDouble ("alvs");
  alces = getPropertyDouble ("alces");
  zetarbi = getPropertyDouble ("zetarbi");
  zetarbx = getPropertyDouble ("zetarbx");
  zetarcx = getPropertyDouble ("zetarcx");
  zetare = getPropertyDouble ("zetare");
  zetacx = getPropertyDouble ("zetacx");
  vge = getPropertyDouble ("vge");
  vgc = getPropertyDouble ("vgc");
  vgs = getPropertyDouble ("vgs");
  f1vg = getPropertyDouble ("f1vg");
  f2vg = getPropertyDouble ("f2vg");
  zetact = getPropertyDouble ("zetact");
  zetabet = getPropertyDouble ("zetabet");
  alb = getPropertyDouble ("alb");
  flsh = getPropertyInteger ("flsh");
  rth = getPropertyDouble ("rth");
  cth = getPropertyDouble ("cth");
  flcomp = getPropertyDouble ("flcomp");
  tnom = getPropertyDouble ("tnom");
  dt = getPropertyDouble ("dt");
}

/* #define's for translated code */
#undef  _DDT
#define _DDT(q) q
#define _DYNAMIC
#define _DERIVATE
#define _DDX
#define _DERIVATEFORDDX

/* Evaluate Verilog-AMS equations in model initialization. */
void hicumL2V2p23::initializeModel (void)
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double vpts_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double cjs0_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double vds_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double tsf_t_Vtnode_GND;
#endif
#endif
#if defined(_DERIVATE)
double re_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double rbx_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double rcx_t_Vtnode_GND;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double cjcx02_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double cjcx01_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double vptcx_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double cratio_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double vdcx_t_Vtnode_GND;
#endif
#endif
#if defined(_DERIVATE)
double abet_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibets_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ajep_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double cjep0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdep_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double rbi0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double qavl_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double favl_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double thcs_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double t0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vptci_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double cjci0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdci_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vces_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double rci0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double c10_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double tef0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vlim_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double k_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double qp0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double iscs_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double itss_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibcxs_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibcis_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ireps_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibeps_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ireis_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibeis_t_Vtnode_GND;
#endif
#if defined(_DERIVATEFORDDX)
double a_Vbi_ei;
double a_Vbi_ci;
double a_Vci_ei;
double a_Vtnode_GND;
#if defined(_DERIVATE)
  double a_Vci_ei_Vbi_ei;
  double a_Vci_ei_Vbi_ci;
  double a_Vci_ei_Vci_ei;
  double a_Vci_ei_Vtnode_GND;
  double a_Vbi_ci_Vbi_ei;
  double a_Vbi_ci_Vbi_ci;
  double a_Vbi_ci_Vci_ei;
  double a_Vbi_ci_Vtnode_GND;
  double a_Vbi_ei_Vbi_ei;
  double a_Vbi_ei_Vbi_ci;
  double a_Vbi_ei_Vci_ei;
  double a_Vbi_ei_Vtnode_GND;
#endif
#endif
#if defined(_DERIVATE)
double r_VgVT_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double V_gT_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ajei_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double cjei0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdei_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdt_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdjt_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vgbe_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vge_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vgb_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double k2_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double k1_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ln_qtt0_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double qtt0_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double dT_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double VT_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double Tdev_Vtnode_GND;
#endif
#if defined(_DYNAMIC)
#endif
#if defined(_DYNAMIC)
#endif
#if defined(_DYNAMIC)
#endif
#if defined(_DYNAMIC)
#endif
#if defined(_DYNAMIC)
#endif
#if defined(_DYNAMIC)
#endif
#if defined(_DYNAMIC)
double C_1;
#endif
double vge_t0;
double vgb_t0;
double k20;
double k10;
{
Tnom=(tnom+273.15);
Tamb=_circuit_temp;
vt0=((1.3806503e-23*Tnom)/1.602176462e-19);
{
double m00_logE(d00_logE0,Tnom)
k10=((f1vg*Tnom)*d00_logE0);
}
k20=(f2vg*Tnom);
avs=(alvs*Tnom);
vgb_t0=((vgb+k10)+k20);
vge_t0=((vge+k10)+k20);
vgbe_t0=((vgb_t0+vge_t0)/2);
vgbe0=((vgb+vge)/2);
vgbc0=((vgb+vgc)/2);
vgsc0=((vgs+vgc)/2);
mg=(3-((1.602176462e-19*f1vg)/1.3806503e-23));
zetabci=((mg+1)-zetaci);
zetabcxt=((mg+1)-zetacx);
zetasct=(mg-1.5);
#if defined(_DYNAMIC)
C_1=((1.0-fbcpar)*(cjcx0+cbcpar));
#endif
#ifdef _DYNAMIC
if
((C_1>=cbcpar))
{
#if defined(_DYNAMIC)
cbcpar1=cbcpar;
#endif
#if defined(_DYNAMIC)
cbcpar2=0.0;
#endif
#if defined(_DYNAMIC)
cjcx01=(C_1-cbcpar);
#endif
#if defined(_DYNAMIC)
cjcx02=(cjcx0-cjcx01);
#endif
}
else
{
#if defined(_DYNAMIC)
cbcpar1=C_1;
#endif
#if defined(_DYNAMIC)
cbcpar2=(cbcpar-cbcpar1);
#endif
#if defined(_DYNAMIC)
cjcx01=0.0;
#endif
#if defined(_DYNAMIC)
cjcx02=cjcx0;
#endif
}
#endif /* if (...) */
#if defined(_DYNAMIC)
cbepar2=(fbepar*cbepar);
#endif
#if defined(_DYNAMIC)
cbepar1=(cbepar-cbepar2);
#endif
if
((ich!=0.0))
{
Oich=(1.0/ich);
}
else
{
Oich=0.0;
}
if
((tbhrec!=0.0))
{
Otbhrec=(1.0/tbhrec);
}
else
{
Otbhrec=0.0;
}
if
((vpt!=0.0))
{
Ovpt=(1.0/vpt);
}
else
{
Ovpt=0.0;
}
if
(((flsh==0)||(rth<0.001)))
{
#if defined(_DERIVATE)
Tdev_Vtnode_GND=0.0;
#endif
Tdev=(Tamb+dt);
if
((Tdev<((-100.0)+273.15)))
{
#if defined(_DERIVATE)
Tdev_Vtnode_GND=0.0;
#endif
Tdev=((-100.0)+273.15);
}
else
{
if
((Tdev>(326.85+273.15)))
{
#if defined(_DERIVATE)
Tdev_Vtnode_GND=0.0;
#endif
Tdev=(326.85+273.15);
}
}
#if defined(_DERIVATE)
VT_Vtnode_GND=0.0;
#endif
VT=((1.3806503e-23*Tdev)/1.602176462e-19);
#if defined(_DERIVATE)
dT_Vtnode_GND=0.0;
#endif
dT=(Tdev-Tnom);
#if defined(_DERIVATE)
qtt0_Vtnode_GND=0.0;
#endif
qtt0=(Tdev/Tnom);
{
double m00_logE(d00_logE0,qtt0)
#if defined(_DERIVATE)
ln_qtt0_Vtnode_GND=0.0;
#endif
ln_qtt0=d00_logE0;
}
{
double m00_logE(d00_logE0,Tdev)
#if defined(_DERIVATE)
k1_Vtnode_GND=0.0;
#endif
k1=((f1vg*Tdev)*d00_logE0);
}
#if defined(_DERIVATE)
k2_Vtnode_GND=0.0;
#endif
k2=(f2vg*Tdev);
#if defined(_DERIVATE)
vgb_t_Vtnode_GND=0.0;
#endif
vgb_t=((vgb+k1)+k2);
#if defined(_DERIVATE)
vge_t_Vtnode_GND=0.0;
#endif
vge_t=((vge+k1)+k2);
#if defined(_DERIVATE)
vgbe_t_Vtnode_GND=0.0;
#endif
vgbe_t=((vgb_t+vge_t)/2);
if
((cjei0>0.0))
{
{
double m00_exp(d00_exp0,((vdei*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vdei)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#if defined(_DERIVATE)
vdjt_Vtnode_GND=0.0;
#endif
vdjt=(((vdj0*qtt0)+(vgbe0*(1-qtt0)))-((mg*VT)*ln_qtt0));
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
vdt_Vtnode_GND=0.0;
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#if defined(_DERIVATE)
vdei_t_Vtnode_GND=0.0;
#endif
vdei_t=vdt;
{
double m00_logE(d00_logE0,(vdei/vdei_t))
double m00_exp(d00_exp1,(zei*d00_logE0))
#if defined(_DERIVATE)
cjei0_t_Vtnode_GND=0.0;
#endif
cjei0_t=(cjei0*d00_exp1);
}
if
((1==1))
{
#if defined(_DERIVATE)
ajei_t_Vtnode_GND=0.0;
#endif
ajei_t=((ajei*vdei_t)/vdei);
}
else
{
#if defined(_DERIVATE)
ajei_t_Vtnode_GND=0.0;
#endif
ajei_t=ajei;
}
}
else
{
#if defined(_DERIVATE)
cjei0_t_Vtnode_GND=0.0;
#endif
cjei0_t=cjei0;
#if defined(_DERIVATE)
vdei_t_Vtnode_GND=0.0;
#endif
vdei_t=vdei;
#if defined(_DERIVATE)
ajei_t_Vtnode_GND=0.0;
#endif
ajei_t=ajei;
}
if
(((flcomp==0.0)||(flcomp==2.1)))
{
#if defined(_DERIVATE)
V_gT_Vtnode_GND=0.0;
#endif
V_gT=(((3.0*VT)*ln_qtt0)+(vgb*(qtt0-1.0)));
#if defined(_DERIVATE)
r_VgVT_Vtnode_GND=0.0;
#endif
r_VgVT=(V_gT/VT);
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(((mcf*r_VgVT)/mbei)-(alb*dT));
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
ibeis_t_Vtnode_GND=0.0;
#endif
ibeis_t=(ibeis*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(((mcf*r_VgVT)/mrei)-(alb*dT));
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
ireis_t_Vtnode_GND=0.0;
#endif
ireis_t=(ireis*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(((mcf*r_VgVT)/mbep)-(alb*dT));
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
ibeps_t_Vtnode_GND=0.0;
#endif
ibeps_t=(ibeps*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(((mcf*r_VgVT)/mrep)-(alb*dT));
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
ireps_t_Vtnode_GND=0.0;
#endif
ireps_t=(ireps*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(r_VgVT/mbci);
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
ibcis_t_Vtnode_GND=0.0;
#endif
ibcis_t=(ibcis*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(r_VgVT/mbcx);
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
ibcxs_t_Vtnode_GND=0.0;
#endif
ibcxs_t=(ibcxs*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(r_VgVT/msf);
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
itss_t_Vtnode_GND=0.0;
#endif
itss_t=(itss*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(r_VgVT/msc);
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
iscs_t_Vtnode_GND=0.0;
#endif
iscs_t=(iscs*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(vdei_t/vdei);
#if defined(_DERIVATE)
qp0_t_Vtnode_GND=0.0;
#endif
qp0_t=(qp0*(1.0+((0.5*zei)*(1.0-a))));
{
double m00_exp(d00_exp0,(zetaci*ln_qtt0))
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=((vlim*(1.0-(alvs*dT)))*d00_exp0);
}
#if defined(_DERIVATE)
k_Vtnode_GND=0.0;
#endif
k=((a-VT)/VT);
if
((k<11.0))
{
{
double m00_exp(d00_exp0,k)
double m00_logE(d00_logE1,(1.0+d00_exp0))
#if defined(_DERIVATE)
vlim_t_Vtnode_GND=0.0;
#endif
vlim_t=(VT+(VT*d00_logE1));
}
}
else
{
#if defined(_DERIVATE)
vlim_t_Vtnode_GND=0.0;
#endif
vlim_t=a;
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=(1.0+(alb*dT));
{
double m00_sqrt(d00_sqrt0,((a*a)+0.01))
#if defined(_DERIVATE)
k_Vtnode_GND=0.0;
#endif
k=(0.5*(a+d00_sqrt0));
}
#if defined(_DERIVATE)
tef0_t_Vtnode_GND=0.0;
#endif
tef0_t=((tef0*qtt0)/k);
}
else
{
{
double m00_exp(d00_exp0,((zetabet*ln_qtt0)+((vge/VT)*(qtt0-1))))
#if defined(_DERIVATE)
ibeis_t_Vtnode_GND=0.0;
#endif
ibeis_t=(ibeis*d00_exp0);
}
{
double m00_exp(d00_exp0,(((0.5*mg)*ln_qtt0)+(((0.5*vgbe0)/VT)*(qtt0-1))))
#if defined(_DERIVATE)
ireis_t_Vtnode_GND=0.0;
#endif
ireis_t=(ireis*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetabet*ln_qtt0)+((vge/VT)*(qtt0-1))))
#if defined(_DERIVATE)
ibeps_t_Vtnode_GND=0.0;
#endif
ibeps_t=(ibeps*d00_exp0);
}
{
double m00_exp(d00_exp0,(((0.5*mg)*ln_qtt0)+(((0.5*vgbe0)/VT)*(qtt0-1))))
#if defined(_DERIVATE)
ireps_t_Vtnode_GND=0.0;
#endif
ireps_t=(ireps*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetabci*ln_qtt0)+((vgc/VT)*(qtt0-1))))
#if defined(_DERIVATE)
ibcis_t_Vtnode_GND=0.0;
#endif
ibcis_t=(ibcis*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetabcxt*ln_qtt0)+((vgc/VT)*(qtt0-1))))
#if defined(_DERIVATE)
ibcxs_t_Vtnode_GND=0.0;
#endif
ibcxs_t=(ibcxs*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetasct*ln_qtt0)+((vgc/VT)*(qtt0-1))))
#if defined(_DERIVATE)
itss_t_Vtnode_GND=0.0;
#endif
itss_t=(itss*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetasct*ln_qtt0)+((vgs/VT)*(qtt0-1))))
#if defined(_DERIVATE)
iscs_t_Vtnode_GND=0.0;
#endif
iscs_t=(iscs*d00_exp0);
}
{
double m00_logE(d00_logE0,(vdei_t/vdei))
double m00_exp(d00_exp1,(zei*d00_logE0))
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=0.0;
#endif
#endif
a=d00_exp1;
}
#if defined(_DERIVATE)
qp0_t_Vtnode_GND=0.0;
#endif
qp0_t=(qp0*(2.0-a));
{
double m00_exp(d00_exp0,((zetaci-avs)*ln_qtt0))
#if defined(_DERIVATE)
vlim_t_Vtnode_GND=0.0;
#endif
vlim_t=(vlim*d00_exp0);
}
zetatef=((zetabet-zetact)-0.5);
dvg0=(vgb-vge);
{
double m00_exp(d00_exp0,((zetatef*ln_qtt0)-((dvg0/VT)*(qtt0-1))))
#if defined(_DERIVATE)
tef0_t_Vtnode_GND=0.0;
#endif
tef0_t=(tef0*d00_exp0);
}
}
{
double m00_exp(d00_exp0,((zetact*ln_qtt0)+((vgb/VT)*(qtt0-1))))
#if defined(_DERIVATE)
c10_t_Vtnode_GND=0.0;
#endif
c10_t=(c10*d00_exp0);
}
{
double m00_exp(d00_exp0,(zetaci*ln_qtt0))
#if defined(_DERIVATE)
rci0_t_Vtnode_GND=0.0;
#endif
rci0_t=(rci0*d00_exp0);
}
#if defined(_DERIVATE)
vces_t_Vtnode_GND=0.0;
#endif
vces_t=(vces*(1+(alces*dT)));
if
((cjci0>0.0))
{
{
double m00_exp(d00_exp0,((vdci*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vdci)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#if defined(_DERIVATE)
vdjt_Vtnode_GND=0.0;
#endif
vdjt=(((vdj0*qtt0)+(vgbc0*(1-qtt0)))-((mg*VT)*ln_qtt0));
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
vdt_Vtnode_GND=0.0;
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#if defined(_DERIVATE)
vdci_t_Vtnode_GND=0.0;
#endif
vdci_t=vdt;
{
double m00_logE(d00_logE0,(vdci/vdci_t))
double m00_exp(d00_exp1,(zci*d00_logE0))
#if defined(_DERIVATE)
cjci0_t_Vtnode_GND=0.0;
#endif
cjci0_t=(cjci0*d00_exp1);
}
if
((0==1))
{
#if defined(_DERIVATE)
vptci_t_Vtnode_GND=0.0;
#endif
vptci_t=((vptci*vdci_t)/vdci);
}
else
{
#if defined(_DERIVATE)
vptci_t_Vtnode_GND=0.0;
#endif
vptci_t=vptci;
}
}
else
{
#if defined(_DERIVATE)
cjci0_t_Vtnode_GND=0.0;
#endif
cjci0_t=cjci0;
#if defined(_DERIVATE)
vdci_t_Vtnode_GND=0.0;
#endif
vdci_t=vdci;
#if defined(_DERIVATE)
vptci_t_Vtnode_GND=0.0;
#endif
vptci_t=vptci;
}
#if defined(_DERIVATE)
t0_t_Vtnode_GND=0.0;
#endif
t0_t=(t0*((1+(alt0*dT))+((kt0*dT)*dT)));
{
double m00_exp(d00_exp0,((zetaci-1)*ln_qtt0))
#if defined(_DERIVATE)
thcs_t_Vtnode_GND=0.0;
#endif
thcs_t=(thcs*d00_exp0);
}
{
double m00_exp(d00_exp0,(alfav*dT))
#if defined(_DERIVATE)
favl_t_Vtnode_GND=0.0;
#endif
favl_t=(favl*d00_exp0);
}
{
double m00_exp(d00_exp0,(alqav*dT))
#if defined(_DERIVATE)
qavl_t_Vtnode_GND=0.0;
#endif
qavl_t=(qavl*d00_exp0);
}
{
double m00_exp(d00_exp0,(zetarbi*ln_qtt0))
#if defined(_DERIVATE)
rbi0_t_Vtnode_GND=0.0;
#endif
rbi0_t=(rbi0*d00_exp0);
}
if
((cjep0>0.0))
{
{
double m00_exp(d00_exp0,((vdep*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vdep)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#if defined(_DERIVATE)
vdjt_Vtnode_GND=0.0;
#endif
vdjt=(((vdj0*qtt0)+(vgbe0*(1-qtt0)))-((mg*VT)*ln_qtt0));
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
vdt_Vtnode_GND=0.0;
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#if defined(_DERIVATE)
vdep_t_Vtnode_GND=0.0;
#endif
vdep_t=vdt;
{
double m00_logE(d00_logE0,(vdep/vdep_t))
double m00_exp(d00_exp1,(zep*d00_logE0))
#if defined(_DERIVATE)
cjep0_t_Vtnode_GND=0.0;
#endif
cjep0_t=(cjep0*d00_exp1);
}
if
((1==1))
{
#if defined(_DERIVATE)
ajep_t_Vtnode_GND=0.0;
#endif
ajep_t=((ajep*vdep_t)/vdep);
}
else
{
#if defined(_DERIVATE)
ajep_t_Vtnode_GND=0.0;
#endif
ajep_t=ajep;
}
}
else
{
#if defined(_DERIVATE)
cjep0_t_Vtnode_GND=0.0;
#endif
cjep0_t=cjep0;
#if defined(_DERIVATE)
vdep_t_Vtnode_GND=0.0;
#endif
vdep_t=vdep;
#if defined(_DERIVATE)
ajep_t_Vtnode_GND=0.0;
#endif
ajep_t=ajep;
}
{
double a_eg;
double ab;
double aa;
ab=1.0;
aa=1.0;
a_eg=(vgbe_t0/vgbe_t);
if
((((tunode==1)&&(cjep0>0.0))&&(vdep>0.0)))
{
{
double m00_sqrt(d00_sqrt0,a_eg)
ab=(((((cjep0_t/cjep0)*d00_sqrt0)*vdep_t)*vdep_t)/(vdep*vdep));
}
{
double m00_pow(d00_pow0,a_eg,(-1.5))
aa=(((vdep/vdep_t)*(cjep0/cjep0_t))*d00_pow0);
}
}
else
{
if
((((tunode==0)&&(cjei0>0.0))&&(vdei>0.0)))
{
{
double m00_sqrt(d00_sqrt0,a_eg)
ab=(((((cjei0_t/cjei0)*d00_sqrt0)*vdei_t)*vdei_t)/(vdei*vdei));
}
{
double m00_pow(d00_pow0,a_eg,(-1.5))
aa=(((vdei/vdei_t)*(cjei0/cjei0_t))*d00_pow0);
}
}
}
#if defined(_DERIVATE)
ibets_t_Vtnode_GND=0.0;
#endif
ibets_t=(ibets*ab);
#if defined(_DERIVATE)
abet_t_Vtnode_GND=0.0;
#endif
abet_t=(abet*aa);
}
if
((1.0>0.0))
{
{
double m00_exp(d00_exp0,((vdcx*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vdcx)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#if defined(_DERIVATE)
vdjt_Vtnode_GND=0.0;
#endif
vdjt=(((vdj0*qtt0)+(vgbc0*(1-qtt0)))-((mg*VT)*ln_qtt0));
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
vdt_Vtnode_GND=0.0;
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vdcx_t_Vtnode_GND=0.0;
#endif
vdcx_t=vdt;
#endif
#if defined(_DYNAMIC)
{
double m00_logE(d00_logE0,(vdcx/vdcx_t))
double m00_exp(d00_exp1,(zcx*d00_logE0))
#if defined(_DERIVATE)
cratio_t_Vtnode_GND=0.0;
#endif
cratio_t=(1.0*d00_exp1);
}
#endif
#ifdef _DYNAMIC
if
((0==1))
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vptcx_t_Vtnode_GND=0.0;
#endif
vptcx_t=((vptcx*vdcx_t)/vdcx);
#endif
}
else
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vptcx_t_Vtnode_GND=0.0;
#endif
vptcx_t=vptcx;
#endif
}
#endif /* if (...) */
}
else
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
cratio_t_Vtnode_GND=0.0;
#endif
cratio_t=1.0;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vdcx_t_Vtnode_GND=0.0;
#endif
vdcx_t=vdcx;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vptcx_t_Vtnode_GND=0.0;
#endif
vptcx_t=vptcx;
#endif
}
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
cjcx01_t_Vtnode_GND=0.0;
#endif
cjcx01_t=(cratio_t*cjcx01);
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
cjcx02_t_Vtnode_GND=0.0;
#endif
cjcx02_t=(cratio_t*cjcx02);
#endif
{
double m00_exp(d00_exp0,(zetarcx*ln_qtt0))
#if defined(_DERIVATE)
rcx_t_Vtnode_GND=0.0;
#endif
rcx_t=(rcx*d00_exp0);
}
{
double m00_exp(d00_exp0,(zetarbx*ln_qtt0))
#if defined(_DERIVATE)
rbx_t_Vtnode_GND=0.0;
#endif
rbx_t=(rbx*d00_exp0);
}
{
double m00_exp(d00_exp0,(zetare*ln_qtt0))
#if defined(_DERIVATE)
re_t_Vtnode_GND=0.0;
#endif
re_t=(re*d00_exp0);
}
#if defined(_DYNAMIC)
{
double m00_exp(d00_exp0,((zetacx-1.0)*ln_qtt0))
#if defined(_DERIVATE)
tsf_t_Vtnode_GND=0.0;
#endif
tsf_t=(tsf*d00_exp0);
}
#endif
if
((cjs0>0.0))
{
{
double m00_exp(d00_exp0,((vds*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vds)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#if defined(_DERIVATE)
vdjt_Vtnode_GND=0.0;
#endif
vdjt=(((vdj0*qtt0)+(vgsc0*(1-qtt0)))-((mg*VT)*ln_qtt0));
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
vdt_Vtnode_GND=0.0;
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vds_t_Vtnode_GND=0.0;
#endif
vds_t=vdt;
#endif
#if defined(_DYNAMIC)
{
double m00_logE(d00_logE0,(vds/vds_t))
double m00_exp(d00_exp1,(zs*d00_logE0))
#if defined(_DERIVATE)
cjs0_t_Vtnode_GND=0.0;
#endif
cjs0_t=(cjs0*d00_exp1);
}
#endif
#ifdef _DYNAMIC
if
((0==1))
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vpts_t_Vtnode_GND=0.0;
#endif
vpts_t=((vpts*vds_t)/vds);
#endif
}
else
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vpts_t_Vtnode_GND=0.0;
#endif
vpts_t=vpts;
#endif
}
#endif /* if (...) */
}
else
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
cjs0_t_Vtnode_GND=0.0;
#endif
cjs0_t=cjs0;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vds_t_Vtnode_GND=0.0;
#endif
vds_t=vds;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vpts_t_Vtnode_GND=0.0;
#endif
vpts_t=vpts;
#endif
}
}
}
}

/* Evaluate Verilog-AMS equations in instance initialization. */
void hicumL2V2p23::initializeInstance (void)
{
}

/* Evaluate Verilog-AMS equations in initial step. */
void hicumL2V2p23::initialStep (void)
{
}

/* Evaluate Verilog-AMS equations in final step. */
void hicumL2V2p23::finalStep (void)
{
}

/* Evaluate Verilog-AMS equations in analog block. */
void hicumL2V2p23::calcVerilog (void)
{

/* ----------------- evaluate verilog analog equations -------------------- */
#if defined(_DYNAMIC)
double Qxf4;
#if defined(_DERIVATE)
double Qxf4_Vxf4_GND;
#endif
#endif
#if defined(_DYNAMIC)
double Qxf3;
#if defined(_DERIVATE)
double Qxf3_Vxf3_GND;
#endif
#endif
double Ixf4;
#if defined(_DERIVATE)
double Ixf4_Vxf4_GND;
double Ixf4_Vxf3_GND;
double Ixf4_Vci_ei;
double Ixf4_Vbi_ei;
double Ixf4_Vtnode_GND;
double Ixf4_Vbi_ci;
#endif
double Ixf3;
#if defined(_DERIVATE)
double Ixf3_Vxf4_GND;
double Ixf3_Vci_ei;
double Ixf3_Vtnode_GND;
double Ixf3_Vbi_ci;
double Ixf3_Vbi_ei;
#endif
#if defined(_DYNAMIC)
double Qxf2;
#if defined(_DERIVATE)
double Qxf2_Vxf2_GND;
#endif
#endif
#if defined(_DYNAMIC)
double Qxf1;
#if defined(_DERIVATE)
double Qxf1_Vxf1_GND;
#endif
#endif
double Ixf2;
#if defined(_DERIVATE)
double Ixf2_Vxf2_GND;
double Ixf2_Vxf1_GND;
double Ixf2_Vci_ei;
double Ixf2_Vbi_ei;
double Ixf2_Vtnode_GND;
double Ixf2_Vbi_ci;
#endif
double Ixf1;
#if defined(_DERIVATE)
double Ixf1_Vxf2_GND;
double Ixf1_Vci_ei;
double Ixf1_Vtnode_GND;
double Ixf1_Vbi_ei;
double Ixf1_Vbi_ci;
#endif
#if defined(_DYNAMIC)
double Qdeix;
#if defined(_DERIVATE)
double Qdeix_Vxf4_GND;
double Qdeix_Vci_ei;
double Qdeix_Vtnode_GND;
double Qdeix_Vbi_ci;
double Qdeix_Vbi_ei;
#endif
#endif
double Itxf;
#if defined(_DERIVATE)
double Itxf_Vxf2_GND;
double Itxf_Vci_ei;
double Itxf_Vtnode_GND;
double Itxf_Vbi_ei;
double Itxf_Vbi_ci;
#endif
double pterm;
#if defined(_DERIVATE)
double pterm_Vb_bp;
double pterm_Vci_c;
double pterm_Vei_e;
double pterm_Vbp_bi;
double pterm_Vbp_ei;
double pterm_Vbp_ci;
double pterm_Vsi_ci;
double pterm_Vci_ei;
double pterm_Vtnode_GND;
double pterm_Vbi_ei;
double pterm_Vbi_ci;
#endif
#if defined(_DERIVATE)
double ijsc_Vtnode_GND;
double ijsc_Vsi_ci;
double ijsc_Vbp_ci;
double ijsc_Vbp_ei;
double ijsc_Vbi_ci;
double ijsc_Vbi_ei;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double betadc_Vci_ei;
double betadc_Vtnode_GND;
double betadc_Vbi_ei;
double betadc_Vbi_ci;
#endif
#endif
#if defined(_DYNAMIC)
double betan;
#if defined(_DERIVATE)
double betan_Vci_ei;
double betan_Vtnode_GND;
double betan_Vbi_ei;
double betan_Vbi_ci;
#endif
#endif
double betadin;
#if defined(_DYNAMIC)
double betad;
#if defined(_DERIVATE)
double betad_Vtnode_GND;
double betad_Vbi_ei;
#endif
#endif
#if defined(_DYNAMIC)
double Qdsu;
#if defined(_DERIVATE)
double Qdsu_Vtnode_GND;
double Qdsu_Vbp_ci;
#endif
#endif
double HSI_Tsu;
#if defined(_DERIVATE)
double HSI_Tsu_Vtnode_GND;
double HSI_Tsu_Vbp_ci;
double HSI_Tsu_Vsi_ci;
#endif
double HSb;
#if defined(_DERIVATE)
double HSb_Vsi_ci;
double HSb_Vtnode_GND;
#endif
double HSa;
#if defined(_DERIVATE)
double HSa_Vbp_ci;
double HSa_Vtnode_GND;
#endif
double HSUM;
#if defined(_DERIVATE)
double HSUM_Vtnode_GND;
#endif
#if defined(_DYNAMIC)
double Qjs;
#if defined(_DERIVATE)
double Qjs_Vbi_ei;
double Qjs_Vsi_ci;
double Qjs_Vb_ci;
double Qjs_Vbp_ci;
double Qjs_Vtnode_GND;
double Qjs_Vbi_ci;
#endif
#endif
#if defined(_DYNAMIC)
double qjcx0_t_i;
#if defined(_DERIVATE)
double qjcx0_t_i_Vbi_ei;
double qjcx0_t_i_Vb_ci;
double qjcx0_t_i_Vbp_ci;
double qjcx0_t_i_Vtnode_GND;
double qjcx0_t_i_Vbi_ci;
#endif
#endif
#if defined(_DERIVATE)
double ijbcx_Vtnode_GND;
double ijbcx_Vbp_ci;
double ijbcx_Vbp_ei;
double ijbcx_Vbi_ci;
double ijbcx_Vbi_ei;
#endif
#if defined(_DYNAMIC)
double qjcx0_t_ii;
#if defined(_DERIVATE)
double qjcx0_t_ii_Vbi_ei;
double qjcx0_t_ii_Vbp_ci;
double qjcx0_t_ii_Vtnode_GND;
double qjcx0_t_ii_Vbi_ci;
#endif
#endif
double ibet;
#if defined(_DERIVATE)
double ibet_Vbi_ei;
double ibet_Vbp_ei;
double ibet_Vtnode_GND;
#endif
double Cjep;
#if defined(_DERIVATE)
double Cjep_Vtnode_GND;
double Cjep_Vbp_ei;
#endif
double Qjep;
#if defined(_DERIVATEFORDDX)
double Qjep_Vtnode_GND;
double Qjep_Vbp_ei;
#if defined(_DERIVATE)
  double Qjep_Vbp_ei_Vtnode_GND;
  double Qjep_Vbp_ei_Vbp_ei;
#endif
#endif
double irep;
#if defined(_DERIVATE)
double irep_Vtnode_GND;
double irep_Vbp_ei;
double irep_Vbi_ci;
double irep_Vbi_ei;
#endif
#if defined(_DERIVATE)
double ibep_Vtnode_GND;
double ibep_Vbp_ei;
double ibep_Vbi_ci;
double ibep_Vbi_ei;
#endif
#if defined(_DERIVATE)
double rbi_Vtnode_GND;
double rbi_Vbi_ei;
double rbi_Vbi_ci;
double rbi_Vci_ei;
#endif
double ibh_rec;
#if defined(_DERIVATE)
double ibh_rec_Vtnode_GND;
double ibh_rec_Vbi_ei;
double ibh_rec_Vbi_ci;
double ibh_rec_Vci_ei;
#endif
#if defined(_DERIVATE)
double iavl_Vci_ei;
double iavl_Vtnode_GND;
double iavl_Vbi_ei;
double iavl_Vbi_ci;
#endif
#if defined(_DERIVATE)
double ibci_Vtnode_GND;
double ibci_Vbi_ci;
double ibci_Vbi_ei;
#endif
#if defined(_DYNAMIC)
double qrbi;
#if defined(_DERIVATE)
double qrbi_Vtnode_GND;
double qrbi_Vbi_ei;
double qrbi_Vbi_ci;
double qrbi_Vci_ei;
double qrbi_Vbp_bi;
#endif
#endif
#if defined(_DYNAMIC)
double Crbi;
#if defined(_DERIVATE)
double Crbi_Vtnode_GND;
double Crbi_Vbi_ei;
double Crbi_Vbi_ci;
double Crbi_Vci_ei;
#endif
#endif
#if defined(_DYNAMIC)
double Cdci;
#if defined(_DERIVATE)
double Cdci_Vci_ei;
double Cdci_Vtnode_GND;
double Cdci_Vbi_ci;
double Cdci_Vbi_ei;
#endif
#endif
#if defined(_DYNAMIC)
double Cdei;
#if defined(_DERIVATE)
double Cdei_Vci_ei;
double Cdei_Vtnode_GND;
double Cdei_Vbi_ci;
double Cdei_Vbi_ei;
#endif
#endif
#if defined(_DYNAMIC)
double Qdci;
#if defined(_DERIVATEFORDDX)
double Qdci_Vci_ei;
double Qdci_Vtnode_GND;
double Qdci_Vbi_ci;
double Qdci_Vbi_ei;
#if defined(_DERIVATE)
  double Qdci_Vbi_ci_Vci_ei;
  double Qdci_Vbi_ci_Vtnode_GND;
  double Qdci_Vbi_ci_Vbi_ci;
  double Qdci_Vbi_ci_Vbi_ei;
  double Qdci_Vci_ei_Vci_ei;
  double Qdci_Vci_ei_Vtnode_GND;
  double Qdci_Vci_ei_Vbi_ci;
  double Qdci_Vci_ei_Vbi_ei;
#endif
#endif
#endif
double Qdei;
#if defined(_DERIVATEFORDDX)
double Qdei_Vci_ei;
double Qdei_Vtnode_GND;
double Qdei_Vbi_ci;
double Qdei_Vbi_ei;
#if defined(_DERIVATE)
  double Qdei_Vbi_ei_Vci_ei;
  double Qdei_Vbi_ei_Vtnode_GND;
  double Qdei_Vbi_ei_Vbi_ci;
  double Qdei_Vbi_ei_Vbi_ei;
  double Qdei_Vci_ei_Vci_ei;
  double Qdei_Vci_ei_Vtnode_GND;
  double Qdei_Vci_ei_Vbi_ci;
  double Qdei_Vci_ei_Vbi_ei;
#endif
#endif
#if defined(_DERIVATE)
double it_Vci_ei;
double it_Vtnode_GND;
double it_Vbi_ei;
double it_Vbi_ci;
#endif
double d_Q0;
double d_Q;
#if defined(_DERIVATEFORDDX)
double d_Q_Vtnode_GND;
double d_Q_Vbi_ei;
double d_Q_Vbi_ci;
double d_Q_Vci_ei;
#if defined(_DERIVATE)
  double d_Q_Vci_ei_Vtnode_GND;
  double d_Q_Vci_ei_Vbi_ei;
  double d_Q_Vci_ei_Vbi_ci;
  double d_Q_Vci_ei_Vci_ei;
  double d_Q_Vbi_ci_Vtnode_GND;
  double d_Q_Vbi_ci_Vbi_ei;
  double d_Q_Vbi_ci_Vbi_ci;
  double d_Q_Vbi_ci_Vci_ei;
  double d_Q_Vbi_ei_Vtnode_GND;
  double d_Q_Vbi_ei_Vbi_ei;
  double d_Q_Vbi_ei_Vbi_ci;
  double d_Q_Vbi_ei_Vci_ei;
#endif
#endif
double Q_pT;
#if defined(_DERIVATEFORDDX)
double Q_pT_Vtnode_GND;
double Q_pT_Vbi_ei;
double Q_pT_Vbi_ci;
double Q_pT_Vci_ei;
#if defined(_DERIVATE)
  double Q_pT_Vci_ei_Vtnode_GND;
  double Q_pT_Vci_ei_Vbi_ei;
  double Q_pT_Vci_ei_Vbi_ci;
  double Q_pT_Vci_ei_Vci_ei;
  double Q_pT_Vbi_ci_Vtnode_GND;
  double Q_pT_Vbi_ci_Vbi_ei;
  double Q_pT_Vbi_ci_Vbi_ci;
  double Q_pT_Vbi_ci_Vci_ei;
  double Q_pT_Vbi_ei_Vtnode_GND;
  double Q_pT_Vbi_ei_Vbi_ei;
  double Q_pT_Vbi_ei_Vbi_ci;
  double Q_pT_Vbi_ei_Vci_ei;
#endif
#endif
int l_it;
double Qr;
#if defined(_DERIVATEFORDDX)
double Qr_Vci_ei;
double Qr_Vtnode_GND;
double Qr_Vbi_ci;
double Qr_Vbi_ei;
#if defined(_DERIVATE)
  double Qr_Vbi_ei_Vci_ei;
  double Qr_Vbi_ei_Vtnode_GND;
  double Qr_Vbi_ei_Vbi_ci;
  double Qr_Vbi_ei_Vbi_ei;
  double Qr_Vbi_ci_Vci_ei;
  double Qr_Vbi_ci_Vtnode_GND;
  double Qr_Vbi_ci_Vbi_ci;
  double Qr_Vbi_ci_Vbi_ei;
  double Qr_Vci_ei_Vci_ei;
  double Qr_Vci_ei_Vtnode_GND;
  double Qr_Vci_ei_Vbi_ci;
  double Qr_Vci_ei_Vbi_ei;
#endif
#endif
double FCd_f;
#if defined(_DERIVATEFORDDX)
double FCd_f_Vci_ei;
double FCd_f_Vtnode_GND;
double FCd_f_Vbi_ei;
double FCd_f_Vbi_ci;
#if defined(_DERIVATE)
  double FCd_f_Vbi_ci_Vci_ei;
  double FCd_f_Vbi_ci_Vtnode_GND;
  double FCd_f_Vbi_ci_Vbi_ei;
  double FCd_f_Vbi_ci_Vbi_ci;
  double FCd_f_Vbi_ei_Vci_ei;
  double FCd_f_Vbi_ei_Vtnode_GND;
  double FCd_f_Vbi_ei_Vbi_ei;
  double FCd_f_Vbi_ei_Vbi_ci;
  double FCd_f_Vci_ei_Vci_ei;
  double FCd_f_Vci_ei_Vtnode_GND;
  double FCd_f_Vci_ei_Vbi_ei;
  double FCd_f_Vci_ei_Vbi_ci;
#endif
#endif
double FCz_1;
#if defined(_DERIVATEFORDDX)
double FCz_1_Vci_ei;
double FCz_1_Vtnode_GND;
double FCz_1_Vbi_ei;
double FCz_1_Vbi_ci;
#if defined(_DERIVATE)
  double FCz_1_Vbi_ci_Vci_ei;
  double FCz_1_Vbi_ci_Vtnode_GND;
  double FCz_1_Vbi_ci_Vbi_ei;
  double FCz_1_Vbi_ci_Vbi_ci;
  double FCz_1_Vbi_ei_Vci_ei;
  double FCz_1_Vbi_ei_Vtnode_GND;
  double FCz_1_Vbi_ei_Vbi_ei;
  double FCz_1_Vbi_ei_Vbi_ci;
  double FCz_1_Vci_ei_Vci_ei;
  double FCz_1_Vci_ei_Vtnode_GND;
  double FCz_1_Vci_ei_Vbi_ei;
  double FCz_1_Vci_ei_Vbi_ci;
#endif
#endif
double FCdfCT_ditf;
#if defined(_DERIVATEFORDDX)
double FCdfCT_ditf_Vbi_ei;
double FCdfCT_ditf_Vbi_ci;
double FCdfCT_ditf_Vci_ei;
double FCdfCT_ditf_Vtnode_GND;
#if defined(_DERIVATE)
  double FCdfCT_ditf_Vci_ei_Vbi_ei;
  double FCdfCT_ditf_Vci_ei_Vbi_ci;
  double FCdfCT_ditf_Vci_ei_Vci_ei;
  double FCdfCT_ditf_Vci_ei_Vtnode_GND;
  double FCdfCT_ditf_Vbi_ci_Vbi_ei;
  double FCdfCT_ditf_Vbi_ci_Vbi_ci;
  double FCdfCT_ditf_Vbi_ci_Vci_ei;
  double FCdfCT_ditf_Vbi_ci_Vtnode_GND;
  double FCdfCT_ditf_Vbi_ei_Vbi_ei;
  double FCdfCT_ditf_Vbi_ei_Vbi_ci;
  double FCdfCT_ditf_Vbi_ei_Vci_ei;
  double FCdfCT_ditf_Vbi_ei_Vtnode_GND;
#endif
#endif
double FCdfCT_dw;
#if defined(_DERIVATEFORDDX)
double FCdfCT_dw_Vbi_ei;
double FCdfCT_dw_Vbi_ci;
double FCdfCT_dw_Vci_ei;
double FCdfCT_dw_Vtnode_GND;
#if defined(_DERIVATE)
  double FCdfCT_dw_Vci_ei_Vbi_ei;
  double FCdfCT_dw_Vci_ei_Vbi_ci;
  double FCdfCT_dw_Vci_ei_Vci_ei;
  double FCdfCT_dw_Vci_ei_Vtnode_GND;
  double FCdfCT_dw_Vbi_ci_Vbi_ei;
  double FCdfCT_dw_Vbi_ci_Vbi_ci;
  double FCdfCT_dw_Vbi_ci_Vci_ei;
  double FCdfCT_dw_Vbi_ci_Vtnode_GND;
  double FCdfCT_dw_Vbi_ei_Vbi_ei;
  double FCdfCT_dw_Vbi_ei_Vbi_ci;
  double FCdfCT_dw_Vbi_ei_Vci_ei;
  double FCdfCT_dw_Vbi_ei_Vtnode_GND;
#endif
#endif
double lnz;
#if defined(_DERIVATEFORDDX)
double lnz_Vci_ei;
double lnz_Vtnode_GND;
double lnz_Vbi_ei;
double lnz_Vbi_ci;
#if defined(_DERIVATE)
  double lnz_Vbi_ci_Vci_ei;
  double lnz_Vbi_ci_Vtnode_GND;
  double lnz_Vbi_ci_Vbi_ei;
  double lnz_Vbi_ci_Vbi_ci;
  double lnz_Vbi_ei_Vci_ei;
  double lnz_Vbi_ei_Vtnode_GND;
  double lnz_Vbi_ei_Vbi_ei;
  double lnz_Vbi_ei_Vbi_ci;
  double lnz_Vci_ei_Vci_ei;
  double lnz_Vci_ei_Vtnode_GND;
  double lnz_Vci_ei_Vbi_ei;
  double lnz_Vci_ei_Vbi_ci;
#endif
#endif
double FCdfc_ditf;
#if defined(_DERIVATEFORDDX)
double FCdfc_ditf_Vci_ei;
double FCdfc_ditf_Vtnode_GND;
double FCdfc_ditf_Vbi_ei;
double FCdfc_ditf_Vbi_ci;
#if defined(_DERIVATE)
  double FCdfc_ditf_Vbi_ci_Vci_ei;
  double FCdfc_ditf_Vbi_ci_Vtnode_GND;
  double FCdfc_ditf_Vbi_ci_Vbi_ei;
  double FCdfc_ditf_Vbi_ci_Vbi_ci;
  double FCdfc_ditf_Vbi_ei_Vci_ei;
  double FCdfc_ditf_Vbi_ei_Vtnode_GND;
  double FCdfc_ditf_Vbi_ei_Vbi_ei;
  double FCdfc_ditf_Vbi_ei_Vbi_ci;
  double FCdfc_ditf_Vci_ei_Vci_ei;
  double FCdfc_ditf_Vci_ei_Vtnode_GND;
  double FCdfc_ditf_Vci_ei_Vbi_ei;
  double FCdfc_ditf_Vci_ei_Vbi_ci;
#endif
#endif
double FCdw_ditf;
#if defined(_DERIVATEFORDDX)
double FCdw_ditf_Vci_ei;
double FCdw_ditf_Vtnode_GND;
double FCdw_ditf_Vbi_ei;
double FCdw_ditf_Vbi_ci;
#if defined(_DERIVATE)
  double FCdw_ditf_Vbi_ci_Vci_ei;
  double FCdw_ditf_Vbi_ci_Vtnode_GND;
  double FCdw_ditf_Vbi_ci_Vbi_ei;
  double FCdw_ditf_Vbi_ci_Vbi_ci;
  double FCdw_ditf_Vbi_ei_Vci_ei;
  double FCdw_ditf_Vbi_ei_Vtnode_GND;
  double FCdw_ditf_Vbi_ei_Vbi_ei;
  double FCdw_ditf_Vbi_ei_Vbi_ci;
  double FCdw_ditf_Vci_ei_Vci_ei;
  double FCdw_ditf_Vci_ei_Vtnode_GND;
  double FCdw_ditf_Vci_ei_Vbi_ei;
  double FCdw_ditf_Vci_ei_Vbi_ci;
#endif
#endif
double FCdfc_dw;
#if defined(_DERIVATEFORDDX)
double FCdfc_dw_Vci_ei;
double FCdfc_dw_Vtnode_GND;
double FCdfc_dw_Vbi_ei;
double FCdfc_dw_Vbi_ci;
#if defined(_DERIVATE)
  double FCdfc_dw_Vbi_ci_Vci_ei;
  double FCdfc_dw_Vbi_ci_Vtnode_GND;
  double FCdfc_dw_Vbi_ci_Vbi_ei;
  double FCdfc_dw_Vbi_ci_Vbi_ci;
  double FCdfc_dw_Vbi_ei_Vci_ei;
  double FCdfc_dw_Vbi_ei_Vtnode_GND;
  double FCdfc_dw_Vbi_ei_Vbi_ei;
  double FCdfc_dw_Vbi_ei_Vbi_ci;
  double FCdfc_dw_Vci_ei_Vci_ei;
  double FCdfc_dw_Vci_ei_Vtnode_GND;
  double FCdfc_dw_Vci_ei_Vbi_ei;
  double FCdfc_dw_Vci_ei_Vbi_ci;
#endif
#endif
double FCf_ci;
#if defined(_DERIVATEFORDDX)
double FCf_ci_Vci_ei;
double FCf_ci_Vtnode_GND;
double FCf_ci_Vbi_ei;
double FCf_ci_Vbi_ci;
#if defined(_DERIVATE)
  double FCf_ci_Vbi_ci_Vci_ei;
  double FCf_ci_Vbi_ci_Vtnode_GND;
  double FCf_ci_Vbi_ci_Vbi_ei;
  double FCf_ci_Vbi_ci_Vbi_ci;
  double FCf_ci_Vbi_ei_Vci_ei;
  double FCf_ci_Vbi_ei_Vtnode_GND;
  double FCf_ci_Vbi_ei_Vbi_ei;
  double FCf_ci_Vbi_ei_Vbi_ci;
  double FCf_ci_Vci_ei_Vci_ei;
  double FCf_ci_Vci_ei_Vtnode_GND;
  double FCf_ci_Vci_ei_Vbi_ei;
  double FCf_ci_Vci_ei_Vbi_ci;
#endif
#endif
double FCdf3_dw;
#if defined(_DERIVATEFORDDX)
double FCdf3_dw_Vci_ei;
double FCdf3_dw_Vtnode_GND;
double FCdf3_dw_Vbi_ei;
double FCdf3_dw_Vbi_ci;
#if defined(_DERIVATE)
  double FCdf3_dw_Vbi_ci_Vci_ei;
  double FCdf3_dw_Vbi_ci_Vtnode_GND;
  double FCdf3_dw_Vbi_ci_Vbi_ei;
  double FCdf3_dw_Vbi_ci_Vbi_ci;
  double FCdf3_dw_Vbi_ei_Vci_ei;
  double FCdf3_dw_Vbi_ei_Vtnode_GND;
  double FCdf3_dw_Vbi_ei_Vbi_ei;
  double FCdf3_dw_Vbi_ei_Vbi_ci;
  double FCdf3_dw_Vci_ei_Vci_ei;
  double FCdf3_dw_Vci_ei_Vtnode_GND;
  double FCdf3_dw_Vci_ei_Vbi_ei;
  double FCdf3_dw_Vci_ei_Vbi_ci;
#endif
#endif
double FCf3;
#if defined(_DERIVATEFORDDX)
double FCf3_Vbi_ei;
double FCf3_Vbi_ci;
double FCf3_Vci_ei;
double FCf3_Vtnode_GND;
#if defined(_DERIVATE)
  double FCf3_Vci_ei_Vbi_ei;
  double FCf3_Vci_ei_Vbi_ci;
  double FCf3_Vci_ei_Vci_ei;
  double FCf3_Vci_ei_Vtnode_GND;
  double FCf3_Vbi_ci_Vbi_ei;
  double FCf3_Vbi_ci_Vbi_ci;
  double FCf3_Vbi_ci_Vci_ei;
  double FCf3_Vbi_ci_Vtnode_GND;
  double FCf3_Vbi_ei_Vbi_ei;
  double FCf3_Vbi_ei_Vbi_ci;
  double FCf3_Vbi_ei_Vci_ei;
  double FCf3_Vbi_ei_Vtnode_GND;
#endif
#endif
double FCdf2_dw;
#if defined(_DERIVATEFORDDX)
double FCdf2_dw_Vci_ei;
double FCdf2_dw_Vtnode_GND;
double FCdf2_dw_Vbi_ei;
double FCdf2_dw_Vbi_ci;
#if defined(_DERIVATE)
  double FCdf2_dw_Vbi_ci_Vci_ei;
  double FCdf2_dw_Vbi_ci_Vtnode_GND;
  double FCdf2_dw_Vbi_ci_Vbi_ei;
  double FCdf2_dw_Vbi_ci_Vbi_ci;
  double FCdf2_dw_Vbi_ei_Vci_ei;
  double FCdf2_dw_Vbi_ei_Vtnode_GND;
  double FCdf2_dw_Vbi_ei_Vbi_ei;
  double FCdf2_dw_Vbi_ei_Vbi_ci;
  double FCdf2_dw_Vci_ei_Vci_ei;
  double FCdf2_dw_Vci_ei_Vtnode_GND;
  double FCdf2_dw_Vci_ei_Vbi_ei;
  double FCdf2_dw_Vci_ei_Vbi_ci;
#endif
#endif
double FCf2;
#if defined(_DERIVATEFORDDX)
double FCf2_Vbi_ei;
double FCf2_Vbi_ci;
double FCf2_Vci_ei;
double FCf2_Vtnode_GND;
#if defined(_DERIVATE)
  double FCf2_Vci_ei_Vbi_ei;
  double FCf2_Vci_ei_Vbi_ci;
  double FCf2_Vci_ei_Vci_ei;
  double FCf2_Vci_ei_Vtnode_GND;
  double FCf2_Vbi_ci_Vbi_ei;
  double FCf2_Vbi_ci_Vbi_ci;
  double FCf2_Vbi_ci_Vci_ei;
  double FCf2_Vbi_ci_Vtnode_GND;
  double FCf2_Vbi_ei_Vbi_ei;
  double FCf2_Vbi_ei_Vbi_ci;
  double FCf2_Vbi_ei_Vci_ei;
  double FCf2_Vbi_ei_Vtnode_GND;
#endif
#endif
double r;
double a3;
#if defined(_DERIVATEFORDDX)
double a3_Vbi_ei;
double a3_Vbi_ci;
double a3_Vci_ei;
double a3_Vtnode_GND;
#if defined(_DERIVATE)
  double a3_Vci_ei_Vbi_ei;
  double a3_Vci_ei_Vbi_ci;
  double a3_Vci_ei_Vci_ei;
  double a3_Vci_ei_Vtnode_GND;
  double a3_Vbi_ci_Vbi_ei;
  double a3_Vbi_ci_Vbi_ci;
  double a3_Vbi_ci_Vci_ei;
  double a3_Vbi_ci_Vtnode_GND;
  double a3_Vbi_ei_Vbi_ei;
  double a3_Vbi_ei_Vbi_ci;
  double a3_Vbi_ei_Vci_ei;
  double a3_Vbi_ei_Vtnode_GND;
#endif
#endif
double a2;
#if defined(_DERIVATEFORDDX)
double a2_Vbi_ei;
double a2_Vbi_ci;
double a2_Vci_ei;
double a2_Vtnode_GND;
#if defined(_DERIVATE)
  double a2_Vci_ei_Vbi_ei;
  double a2_Vci_ei_Vbi_ci;
  double a2_Vci_ei_Vci_ei;
  double a2_Vci_ei_Vtnode_GND;
  double a2_Vbi_ci_Vbi_ei;
  double a2_Vbi_ci_Vbi_ci;
  double a2_Vbi_ci_Vci_ei;
  double a2_Vbi_ci_Vtnode_GND;
  double a2_Vbi_ei_Vbi_ei;
  double a2_Vbi_ei_Vbi_ci;
  double a2_Vbi_ei_Vci_ei;
  double a2_Vbi_ei_Vtnode_GND;
#endif
#endif
double x;
#if defined(_DERIVATEFORDDX)
double x_Vci_ei;
double x_Vtnode_GND;
double x_Vbi_ei;
double x_Vbi_ci;
#if defined(_DERIVATE)
  double x_Vbi_ci_Vci_ei;
  double x_Vbi_ci_Vtnode_GND;
  double x_Vbi_ci_Vbi_ei;
  double x_Vbi_ci_Vbi_ci;
  double x_Vbi_ei_Vci_ei;
  double x_Vbi_ei_Vtnode_GND;
  double x_Vbi_ei_Vbi_ei;
  double x_Vbi_ei_Vbi_ci;
  double x_Vci_ei_Vci_ei;
  double x_Vci_ei_Vtnode_GND;
  double x_Vci_ei_Vbi_ei;
  double x_Vci_ei_Vbi_ci;
#endif
#endif
double lnzb;
#if defined(_DERIVATEFORDDX)
double lnzb_Vci_ei;
double lnzb_Vtnode_GND;
double lnzb_Vbi_ei;
double lnzb_Vbi_ci;
#if defined(_DERIVATE)
  double lnzb_Vbi_ci_Vci_ei;
  double lnzb_Vbi_ci_Vtnode_GND;
  double lnzb_Vbi_ci_Vbi_ei;
  double lnzb_Vbi_ci_Vbi_ci;
  double lnzb_Vbi_ei_Vci_ei;
  double lnzb_Vbi_ei_Vtnode_GND;
  double lnzb_Vbi_ei_Vbi_ei;
  double lnzb_Vbi_ei_Vbi_ci;
  double lnzb_Vci_ei_Vci_ei;
  double lnzb_Vci_ei_Vtnode_GND;
  double lnzb_Vci_ei_Vbi_ei;
  double lnzb_Vci_ei_Vbi_ci;
#endif
#endif
double z;
#if defined(_DERIVATEFORDDX)
double z_Vci_ei;
double z_Vtnode_GND;
double z_Vbi_ei;
double z_Vbi_ci;
#if defined(_DERIVATE)
  double z_Vbi_ci_Vci_ei;
  double z_Vbi_ci_Vtnode_GND;
  double z_Vbi_ci_Vbi_ei;
  double z_Vbi_ci_Vbi_ci;
  double z_Vbi_ei_Vci_ei;
  double z_Vbi_ei_Vtnode_GND;
  double z_Vbi_ei_Vbi_ei;
  double z_Vbi_ei_Vbi_ci;
  double z_Vci_ei_Vci_ei;
  double z_Vci_ei_Vtnode_GND;
  double z_Vci_ei_Vbi_ei;
  double z_Vci_ei_Vbi_ci;
#endif
#endif
double FCdf1_dw;
#if defined(_DERIVATEFORDDX)
double FCdf1_dw_Vci_ei;
double FCdf1_dw_Vtnode_GND;
double FCdf1_dw_Vbi_ei;
double FCdf1_dw_Vbi_ci;
#if defined(_DERIVATE)
  double FCdf1_dw_Vbi_ci_Vci_ei;
  double FCdf1_dw_Vbi_ci_Vtnode_GND;
  double FCdf1_dw_Vbi_ci_Vbi_ei;
  double FCdf1_dw_Vbi_ci_Vbi_ci;
  double FCdf1_dw_Vbi_ei_Vci_ei;
  double FCdf1_dw_Vbi_ei_Vtnode_GND;
  double FCdf1_dw_Vbi_ei_Vbi_ei;
  double FCdf1_dw_Vbi_ei_Vbi_ci;
  double FCdf1_dw_Vci_ei_Vci_ei;
  double FCdf1_dw_Vci_ei_Vtnode_GND;
  double FCdf1_dw_Vci_ei_Vbi_ei;
  double FCdf1_dw_Vci_ei_Vbi_ci;
#endif
#endif
double FCw2;
#if defined(_DERIVATEFORDDX)
double FCw2_Vci_ei;
double FCw2_Vtnode_GND;
double FCw2_Vbi_ei;
double FCw2_Vbi_ci;
#if defined(_DERIVATE)
  double FCw2_Vbi_ci_Vci_ei;
  double FCw2_Vbi_ci_Vtnode_GND;
  double FCw2_Vbi_ci_Vbi_ei;
  double FCw2_Vbi_ci_Vbi_ci;
  double FCw2_Vbi_ei_Vci_ei;
  double FCw2_Vbi_ei_Vtnode_GND;
  double FCw2_Vbi_ei_Vbi_ei;
  double FCw2_Vbi_ei_Vbi_ci;
  double FCw2_Vci_ei_Vci_ei;
  double FCw2_Vci_ei_Vtnode_GND;
  double FCw2_Vci_ei_Vbi_ei;
  double FCw2_Vci_ei_Vbi_ci;
#endif
#endif
double FCf_CT;
#if defined(_DERIVATEFORDDX)
double FCf_CT_Vbi_ei;
double FCf_CT_Vbi_ci;
double FCf_CT_Vci_ei;
double FCf_CT_Vtnode_GND;
#if defined(_DERIVATE)
  double FCf_CT_Vci_ei_Vbi_ei;
  double FCf_CT_Vci_ei_Vbi_ci;
  double FCf_CT_Vci_ei_Vci_ei;
  double FCf_CT_Vci_ei_Vtnode_GND;
  double FCf_CT_Vbi_ci_Vbi_ei;
  double FCf_CT_Vbi_ci_Vbi_ci;
  double FCf_CT_Vbi_ci_Vci_ei;
  double FCf_CT_Vbi_ci_Vtnode_GND;
  double FCf_CT_Vbi_ei_Vbi_ei;
  double FCf_CT_Vbi_ei_Vbi_ci;
  double FCf_CT_Vbi_ei_Vci_ei;
  double FCf_CT_Vbi_ei_Vtnode_GND;
#endif
#endif
double FCf1;
#if defined(_DERIVATEFORDDX)
double FCf1_Vci_ei;
double FCf1_Vtnode_GND;
double FCf1_Vbi_ei;
double FCf1_Vbi_ci;
#if defined(_DERIVATE)
  double FCf1_Vbi_ci_Vci_ei;
  double FCf1_Vbi_ci_Vtnode_GND;
  double FCf1_Vbi_ci_Vbi_ei;
  double FCf1_Vbi_ci_Vbi_ci;
  double FCf1_Vbi_ei_Vci_ei;
  double FCf1_Vbi_ei_Vtnode_GND;
  double FCf1_Vbi_ei_Vbi_ei;
  double FCf1_Vbi_ei_Vbi_ci;
  double FCf1_Vci_ei_Vci_ei;
  double FCf1_Vci_ei_Vtnode_GND;
  double FCf1_Vci_ei_Vbi_ei;
  double FCf1_Vci_ei_Vbi_ci;
#endif
#endif
double FCda1_dw;
#if defined(_DERIVATEFORDDX)
double FCda1_dw_Vci_ei;
double FCda1_dw_Vtnode_GND;
double FCda1_dw_Vbi_ei;
double FCda1_dw_Vbi_ci;
#if defined(_DERIVATE)
  double FCda1_dw_Vbi_ci_Vci_ei;
  double FCda1_dw_Vbi_ci_Vtnode_GND;
  double FCda1_dw_Vbi_ci_Vbi_ei;
  double FCda1_dw_Vbi_ci_Vbi_ci;
  double FCda1_dw_Vbi_ei_Vci_ei;
  double FCda1_dw_Vbi_ei_Vtnode_GND;
  double FCda1_dw_Vbi_ei_Vbi_ei;
  double FCda1_dw_Vbi_ei_Vbi_ci;
  double FCda1_dw_Vci_ei_Vci_ei;
  double FCda1_dw_Vci_ei_Vtnode_GND;
  double FCda1_dw_Vci_ei_Vbi_ei;
  double FCda1_dw_Vci_ei_Vbi_ci;
#endif
#endif
double FCdw_daick;
#if defined(_DERIVATEFORDDX)
double FCdw_daick_Vci_ei;
double FCdw_daick_Vtnode_GND;
double FCdw_daick_Vbi_ei;
double FCdw_daick_Vbi_ci;
#if defined(_DERIVATE)
  double FCdw_daick_Vbi_ci_Vci_ei;
  double FCdw_daick_Vbi_ci_Vtnode_GND;
  double FCdw_daick_Vbi_ci_Vbi_ei;
  double FCdw_daick_Vbi_ci_Vbi_ci;
  double FCdw_daick_Vbi_ei_Vci_ei;
  double FCdw_daick_Vbi_ei_Vtnode_GND;
  double FCdw_daick_Vbi_ei_Vbi_ei;
  double FCdw_daick_Vbi_ei_Vbi_ci;
  double FCdw_daick_Vci_ei_Vci_ei;
  double FCdw_daick_Vci_ei_Vtnode_GND;
  double FCdw_daick_Vci_ei_Vbi_ei;
  double FCdw_daick_Vci_ei_Vbi_ci;
#endif
#endif
double FCw;
#if defined(_DERIVATEFORDDX)
double FCw_Vci_ei;
double FCw_Vtnode_GND;
double FCw_Vbi_ei;
double FCw_Vbi_ci;
#if defined(_DERIVATE)
  double FCw_Vbi_ci_Vci_ei;
  double FCw_Vbi_ci_Vtnode_GND;
  double FCw_Vbi_ci_Vbi_ei;
  double FCw_Vbi_ci_Vbi_ci;
  double FCw_Vbi_ei_Vci_ei;
  double FCw_Vbi_ei_Vtnode_GND;
  double FCw_Vbi_ei_Vbi_ei;
  double FCw_Vbi_ei_Vbi_ci;
  double FCw_Vci_ei_Vci_ei;
  double FCw_Vci_ei_Vtnode_GND;
  double FCw_Vci_ei_Vbi_ei;
  double FCw_Vci_ei_Vbi_ci;
#endif
#endif
double FCd_a;
#if defined(_DERIVATEFORDDX)
double FCd_a_Vci_ei;
double FCd_a_Vtnode_GND;
double FCd_a_Vbi_ei;
double FCd_a_Vbi_ci;
#if defined(_DERIVATE)
  double FCd_a_Vbi_ci_Vci_ei;
  double FCd_a_Vbi_ci_Vtnode_GND;
  double FCd_a_Vbi_ci_Vbi_ei;
  double FCd_a_Vbi_ci_Vbi_ci;
  double FCd_a_Vbi_ei_Vci_ei;
  double FCd_a_Vbi_ei_Vtnode_GND;
  double FCd_a_Vbi_ei_Vbi_ei;
  double FCd_a_Vbi_ei_Vbi_ci;
  double FCd_a_Vci_ei_Vci_ei;
  double FCd_a_Vci_ei_Vtnode_GND;
  double FCd_a_Vci_ei_Vbi_ei;
  double FCd_a_Vci_ei_Vbi_ci;
#endif
#endif
double FCa1;
#if defined(_DERIVATEFORDDX)
double FCa1_Vci_ei;
double FCa1_Vtnode_GND;
double FCa1_Vbi_ei;
double FCa1_Vbi_ci;
#if defined(_DERIVATE)
  double FCa1_Vbi_ci_Vci_ei;
  double FCa1_Vbi_ci_Vtnode_GND;
  double FCa1_Vbi_ci_Vbi_ei;
  double FCa1_Vbi_ci_Vbi_ci;
  double FCa1_Vbi_ei_Vci_ei;
  double FCa1_Vbi_ei_Vtnode_GND;
  double FCa1_Vbi_ei_Vbi_ei;
  double FCa1_Vbi_ei_Vbi_ci;
  double FCa1_Vci_ei_Vci_ei;
  double FCa1_Vci_ei_Vtnode_GND;
  double FCa1_Vci_ei_Vbi_ei;
  double FCa1_Vci_ei_Vbi_ci;
#endif
#endif
double FCln;
double FCxb;
double FCxl;
double FCz;
#if defined(_DERIVATEFORDDX)
double FCz_Vci_ei;
double FCz_Vtnode_GND;
double FCz_Vbi_ei;
double FCz_Vbi_ci;
#if defined(_DERIVATE)
  double FCz_Vbi_ci_Vci_ei;
  double FCz_Vbi_ci_Vtnode_GND;
  double FCz_Vbi_ci_Vbi_ei;
  double FCz_Vbi_ci_Vbi_ci;
  double FCz_Vbi_ei_Vci_ei;
  double FCz_Vbi_ei_Vtnode_GND;
  double FCz_Vbi_ei_Vbi_ei;
  double FCz_Vbi_ei_Vbi_ci;
  double FCz_Vci_ei_Vci_ei;
  double FCz_Vci_ei_Vtnode_GND;
  double FCz_Vci_ei_Vbi_ei;
  double FCz_Vci_ei_Vbi_ci;
#endif
#endif
double FCdaick_ditf;
#if defined(_DERIVATEFORDDX)
double FCdaick_ditf_Vci_ei;
double FCdaick_ditf_Vtnode_GND;
double FCdaick_ditf_Vbi_ei;
double FCdaick_ditf_Vbi_ci;
#if defined(_DERIVATE)
  double FCdaick_ditf_Vbi_ci_Vci_ei;
  double FCdaick_ditf_Vbi_ci_Vtnode_GND;
  double FCdaick_ditf_Vbi_ci_Vbi_ei;
  double FCdaick_ditf_Vbi_ci_Vbi_ci;
  double FCdaick_ditf_Vbi_ei_Vci_ei;
  double FCdaick_ditf_Vbi_ei_Vtnode_GND;
  double FCdaick_ditf_Vbi_ei_Vbi_ei;
  double FCdaick_ditf_Vbi_ei_Vbi_ci;
  double FCdaick_ditf_Vci_ei_Vci_ei;
  double FCdaick_ditf_Vci_ei_Vtnode_GND;
  double FCdaick_ditf_Vci_ei_Vbi_ei;
  double FCdaick_ditf_Vci_ei_Vbi_ci;
#endif
#endif
double FCa_ck;
#if defined(_DERIVATEFORDDX)
double FCa_ck_Vci_ei;
double FCa_ck_Vtnode_GND;
double FCa_ck_Vbi_ei;
double FCa_ck_Vbi_ci;
#if defined(_DERIVATE)
  double FCa_ck_Vbi_ci_Vci_ei;
  double FCa_ck_Vbi_ci_Vtnode_GND;
  double FCa_ck_Vbi_ci_Vbi_ei;
  double FCa_ck_Vbi_ci_Vbi_ci;
  double FCa_ck_Vbi_ei_Vci_ei;
  double FCa_ck_Vbi_ei_Vtnode_GND;
  double FCa_ck_Vbi_ei_Vbi_ei;
  double FCa_ck_Vbi_ei_Vbi_ci;
  double FCa_ck_Vci_ei_Vci_ei;
  double FCa_ck_Vci_ei_Vtnode_GND;
  double FCa_ck_Vci_ei_Vbi_ei;
  double FCa_ck_Vci_ei_Vbi_ci;
#endif
#endif
double FCrt;
#if defined(_DERIVATEFORDDX)
double FCrt_Vci_ei;
double FCrt_Vtnode_GND;
double FCrt_Vbi_ei;
double FCrt_Vbi_ci;
#if defined(_DERIVATE)
  double FCrt_Vbi_ci_Vci_ei;
  double FCrt_Vbi_ci_Vtnode_GND;
  double FCrt_Vbi_ci_Vbi_ei;
  double FCrt_Vbi_ci_Vbi_ci;
  double FCrt_Vbi_ei_Vci_ei;
  double FCrt_Vbi_ei_Vtnode_GND;
  double FCrt_Vbi_ei_Vbi_ei;
  double FCrt_Vbi_ei_Vbi_ci;
  double FCrt_Vci_ei_Vci_ei;
  double FCrt_Vci_ei_Vtnode_GND;
  double FCrt_Vci_ei_Vbi_ei;
  double FCrt_Vci_ei_Vbi_ci;
#endif
#endif
double FCa;
#if defined(_DERIVATEFORDDX)
double FCa_Vci_ei;
double FCa_Vtnode_GND;
double FCa_Vbi_ei;
double FCa_Vbi_ci;
#if defined(_DERIVATE)
  double FCa_Vbi_ci_Vci_ei;
  double FCa_Vbi_ci_Vtnode_GND;
  double FCa_Vbi_ci_Vbi_ei;
  double FCa_Vbi_ci_Vbi_ci;
  double FCa_Vbi_ei_Vci_ei;
  double FCa_Vbi_ei_Vtnode_GND;
  double FCa_Vbi_ei_Vbi_ei;
  double FCa_Vbi_ei_Vbi_ci;
  double FCa_Vci_ei_Vci_ei;
  double FCa_Vci_ei_Vtnode_GND;
  double FCa_Vci_ei_Vbi_ei;
  double FCa_Vci_ei_Vbi_ci;
#endif
#endif
double FFT_cT;
#if defined(_DERIVATEFORDDX)
double FFT_cT_Vtnode_GND;
double FFT_cT_Vci_ei;
double FFT_cT_Vbi_ei;
double FFT_cT_Vbi_ci;
#if defined(_DERIVATE)
  double FFT_cT_Vbi_ci_Vtnode_GND;
  double FFT_cT_Vbi_ci_Vci_ei;
  double FFT_cT_Vbi_ci_Vbi_ei;
  double FFT_cT_Vbi_ci_Vbi_ci;
  double FFT_cT_Vbi_ei_Vtnode_GND;
  double FFT_cT_Vbi_ei_Vci_ei;
  double FFT_cT_Vbi_ei_Vbi_ei;
  double FFT_cT_Vbi_ei_Vbi_ci;
  double FFT_cT_Vci_ei_Vtnode_GND;
  double FFT_cT_Vci_ei_Vci_ei;
  double FFT_cT_Vci_ei_Vbi_ei;
  double FFT_cT_Vci_ei_Vbi_ci;
#endif
#endif
double FFQ_cT;
#if defined(_DERIVATEFORDDX)
double FFQ_cT_Vtnode_GND;
double FFQ_cT_Vbi_ei;
double FFQ_cT_Vbi_ci;
double FFQ_cT_Vci_ei;
#if defined(_DERIVATE)
  double FFQ_cT_Vci_ei_Vtnode_GND;
  double FFQ_cT_Vci_ei_Vbi_ei;
  double FFQ_cT_Vci_ei_Vbi_ci;
  double FFQ_cT_Vci_ei_Vci_ei;
  double FFQ_cT_Vbi_ci_Vtnode_GND;
  double FFQ_cT_Vbi_ci_Vbi_ei;
  double FFQ_cT_Vbi_ci_Vbi_ci;
  double FFQ_cT_Vbi_ci_Vci_ei;
  double FFQ_cT_Vbi_ei_Vtnode_GND;
  double FFQ_cT_Vbi_ei_Vbi_ei;
  double FFQ_cT_Vbi_ei_Vbi_ci;
  double FFQ_cT_Vbi_ei_Vci_ei;
#endif
#endif
double FFT_fC;
#if defined(_DERIVATEFORDDX)
double FFT_fC_Vtnode_GND;
double FFT_fC_Vci_ei;
double FFT_fC_Vbi_ei;
double FFT_fC_Vbi_ci;
#if defined(_DERIVATE)
  double FFT_fC_Vbi_ci_Vtnode_GND;
  double FFT_fC_Vbi_ci_Vci_ei;
  double FFT_fC_Vbi_ci_Vbi_ei;
  double FFT_fC_Vbi_ci_Vbi_ci;
  double FFT_fC_Vbi_ei_Vtnode_GND;
  double FFT_fC_Vbi_ei_Vci_ei;
  double FFT_fC_Vbi_ei_Vbi_ei;
  double FFT_fC_Vbi_ei_Vbi_ci;
  double FFT_fC_Vci_ei_Vtnode_GND;
  double FFT_fC_Vci_ei_Vci_ei;
  double FFT_fC_Vci_ei_Vbi_ei;
  double FFT_fC_Vci_ei_Vbi_ci;
#endif
#endif
double FFQ_fC;
#if defined(_DERIVATEFORDDX)
double FFQ_fC_Vtnode_GND;
double FFQ_fC_Vbi_ei;
double FFQ_fC_Vbi_ci;
double FFQ_fC_Vci_ei;
#if defined(_DERIVATE)
  double FFQ_fC_Vci_ei_Vtnode_GND;
  double FFQ_fC_Vci_ei_Vbi_ei;
  double FFQ_fC_Vci_ei_Vbi_ci;
  double FFQ_fC_Vci_ei_Vci_ei;
  double FFQ_fC_Vbi_ci_Vtnode_GND;
  double FFQ_fC_Vbi_ci_Vbi_ei;
  double FFQ_fC_Vbi_ci_Vbi_ci;
  double FFQ_fC_Vbi_ci_Vci_ei;
  double FFQ_fC_Vbi_ei_Vtnode_GND;
  double FFQ_fC_Vbi_ei_Vbi_ei;
  double FFQ_fC_Vbi_ei_Vbi_ci;
  double FFQ_fC_Vbi_ei_Vci_ei;
#endif
#endif
double FFT_pcS;
#if defined(_DERIVATE)
double FFT_pcS_Vtnode_GND;
#endif
double FFd_TfB;
#if defined(_DERIVATEFORDDX)
double FFd_TfB_Vtnode_GND;
double FFd_TfB_Vci_ei;
double FFd_TfB_Vbi_ei;
double FFd_TfB_Vbi_ci;
#if defined(_DERIVATE)
  double FFd_TfB_Vbi_ci_Vtnode_GND;
  double FFd_TfB_Vbi_ci_Vci_ei;
  double FFd_TfB_Vbi_ci_Vbi_ei;
  double FFd_TfB_Vbi_ci_Vbi_ci;
  double FFd_TfB_Vbi_ei_Vtnode_GND;
  double FFd_TfB_Vbi_ei_Vci_ei;
  double FFd_TfB_Vbi_ei_Vbi_ei;
  double FFd_TfB_Vbi_ei_Vbi_ci;
  double FFd_TfB_Vci_ei_Vtnode_GND;
  double FFd_TfB_Vci_ei_Vci_ei;
  double FFd_TfB_Vci_ei_Vbi_ei;
  double FFd_TfB_Vci_ei_Vbi_ci;
#endif
#endif
double FFa_w;
#if defined(_DERIVATEFORDDX)
double FFa_w_Vci_ei;
double FFa_w_Vtnode_GND;
double FFa_w_Vbi_ei;
double FFa_w_Vbi_ci;
#if defined(_DERIVATE)
  double FFa_w_Vbi_ci_Vci_ei;
  double FFa_w_Vbi_ci_Vtnode_GND;
  double FFa_w_Vbi_ci_Vbi_ei;
  double FFa_w_Vbi_ci_Vbi_ci;
  double FFa_w_Vbi_ei_Vci_ei;
  double FFa_w_Vbi_ei_Vtnode_GND;
  double FFa_w_Vbi_ei_Vbi_ei;
  double FFa_w_Vbi_ei_Vbi_ci;
  double FFa_w_Vci_ei_Vci_ei;
  double FFa_w_Vci_ei_Vtnode_GND;
  double FFa_w_Vci_ei_Vbi_ei;
  double FFa_w_Vci_ei_Vbi_ci;
#endif
#endif
double FFd_QfB;
#if defined(_DERIVATEFORDDX)
double FFd_QfB_Vtnode_GND;
double FFd_QfB_Vbi_ei;
double FFd_QfB_Vbi_ci;
double FFd_QfB_Vci_ei;
#if defined(_DERIVATE)
  double FFd_QfB_Vci_ei_Vtnode_GND;
  double FFd_QfB_Vci_ei_Vbi_ei;
  double FFd_QfB_Vci_ei_Vbi_ci;
  double FFd_QfB_Vci_ei_Vci_ei;
  double FFd_QfB_Vbi_ci_Vtnode_GND;
  double FFd_QfB_Vbi_ci_Vbi_ei;
  double FFd_QfB_Vbi_ci_Vbi_ci;
  double FFd_QfB_Vbi_ci_Vci_ei;
  double FFd_QfB_Vbi_ei_Vtnode_GND;
  double FFd_QfB_Vbi_ei_Vbi_ei;
  double FFd_QfB_Vbi_ei_Vbi_ci;
  double FFd_QfB_Vbi_ei_Vci_ei;
#endif
#endif
double FFw_2;
#if defined(_DERIVATEFORDDX)
double FFw_2_Vci_ei;
double FFw_2_Vtnode_GND;
double FFw_2_Vbi_ei;
double FFw_2_Vbi_ci;
#if defined(_DERIVATE)
  double FFw_2_Vbi_ci_Vci_ei;
  double FFw_2_Vbi_ci_Vtnode_GND;
  double FFw_2_Vbi_ci_Vbi_ei;
  double FFw_2_Vbi_ci_Vbi_ci;
  double FFw_2_Vbi_ei_Vci_ei;
  double FFw_2_Vbi_ei_Vtnode_GND;
  double FFw_2_Vbi_ei_Vbi_ei;
  double FFw_2_Vbi_ei_Vbi_ci;
  double FFw_2_Vci_ei_Vci_ei;
  double FFw_2_Vci_ei_Vtnode_GND;
  double FFw_2_Vci_ei_Vbi_ei;
  double FFw_2_Vci_ei_Vbi_ci;
#endif
#endif
double FFw;
#if defined(_DERIVATEFORDDX)
double FFw_Vci_ei;
double FFw_Vtnode_GND;
double FFw_Vbi_ei;
double FFw_Vbi_ci;
#if defined(_DERIVATE)
  double FFw_Vbi_ci_Vci_ei;
  double FFw_Vbi_ci_Vtnode_GND;
  double FFw_Vbi_ci_Vbi_ei;
  double FFw_Vbi_ci_Vbi_ci;
  double FFw_Vbi_ei_Vci_ei;
  double FFw_Vbi_ei_Vtnode_GND;
  double FFw_Vbi_ei_Vbi_ei;
  double FFw_Vbi_ei_Vbi_ci;
  double FFw_Vci_ei_Vci_ei;
  double FFw_Vci_ei_Vtnode_GND;
  double FFw_Vci_ei_Vbi_ei;
  double FFw_Vci_ei_Vbi_ci;
#endif
#endif
double FFs;
#if defined(_DERIVATEFORDDX)
double FFs_Vci_ei;
double FFs_Vtnode_GND;
double FFs_Vbi_ei;
double FFs_Vbi_ci;
#if defined(_DERIVATE)
  double FFs_Vbi_ci_Vci_ei;
  double FFs_Vbi_ci_Vtnode_GND;
  double FFs_Vbi_ci_Vbi_ei;
  double FFs_Vbi_ci_Vbi_ci;
  double FFs_Vbi_ei_Vci_ei;
  double FFs_Vbi_ei_Vtnode_GND;
  double FFs_Vbi_ei_Vbi_ei;
  double FFs_Vbi_ei_Vbi_ci;
  double FFs_Vci_ei_Vci_ei;
  double FFs_Vci_ei_Vtnode_GND;
  double FFs_Vci_ei_Vbi_ei;
  double FFs_Vci_ei_Vbi_ci;
#endif
#endif
double FFx;
#if defined(_DERIVATEFORDDX)
double FFx_Vci_ei;
double FFx_Vtnode_GND;
double FFx_Vbi_ei;
double FFx_Vbi_ci;
#if defined(_DERIVATE)
  double FFx_Vbi_ci_Vci_ei;
  double FFx_Vbi_ci_Vtnode_GND;
  double FFx_Vbi_ci_Vbi_ei;
  double FFx_Vbi_ci_Vbi_ci;
  double FFx_Vbi_ei_Vci_ei;
  double FFx_Vbi_ei_Vtnode_GND;
  double FFx_Vbi_ei_Vbi_ei;
  double FFx_Vbi_ei_Vbi_ci;
  double FFx_Vci_ei_Vci_ei;
  double FFx_Vci_ei_Vtnode_GND;
  double FFx_Vci_ei_Vbi_ei;
  double FFx_Vci_ei_Vbi_ci;
#endif
#endif
double FFT_fbS;
#if defined(_DERIVATE)
double FFT_fbS_Vtnode_GND;
#endif
double FFd_QfE;
#if defined(_DERIVATEFORDDX)
double FFd_QfE_Vtnode_GND;
double FFd_QfE_Vci_ei;
double FFd_QfE_Vbi_ei;
double FFd_QfE_Vbi_ci;
#if defined(_DERIVATE)
  double FFd_QfE_Vbi_ci_Vtnode_GND;
  double FFd_QfE_Vbi_ci_Vci_ei;
  double FFd_QfE_Vbi_ci_Vbi_ei;
  double FFd_QfE_Vbi_ci_Vbi_ci;
  double FFd_QfE_Vbi_ei_Vtnode_GND;
  double FFd_QfE_Vbi_ei_Vci_ei;
  double FFd_QfE_Vbi_ei_Vbi_ei;
  double FFd_QfE_Vbi_ei_Vbi_ci;
  double FFd_QfE_Vci_ei_Vtnode_GND;
  double FFd_QfE_Vci_ei_Vci_ei;
  double FFd_QfE_Vci_ei_Vbi_ei;
  double FFd_QfE_Vci_ei_Vbi_ci;
#endif
#endif
double FFd_TfE;
#if defined(_DERIVATEFORDDX)
double FFd_TfE_Vtnode_GND;
double FFd_TfE_Vci_ei;
double FFd_TfE_Vbi_ei;
double FFd_TfE_Vbi_ci;
#if defined(_DERIVATE)
  double FFd_TfE_Vbi_ci_Vtnode_GND;
  double FFd_TfE_Vbi_ci_Vci_ei;
  double FFd_TfE_Vbi_ci_Vbi_ei;
  double FFd_TfE_Vbi_ci_Vbi_ci;
  double FFd_TfE_Vbi_ei_Vtnode_GND;
  double FFd_TfE_Vbi_ei_Vci_ei;
  double FFd_TfE_Vbi_ei_Vbi_ei;
  double FFd_TfE_Vbi_ei_Vbi_ci;
  double FFd_TfE_Vci_ei_Vtnode_GND;
  double FFd_TfE_Vci_ei_Vci_ei;
  double FFd_TfE_Vci_ei_Vbi_ei;
  double FFd_TfE_Vci_ei_Vbi_ci;
#endif
#endif
double FFa;
#if defined(_DERIVATEFORDDX)
double FFa_Vci_ei;
double FFa_Vtnode_GND;
double FFa_Vbi_ei;
double FFa_Vbi_ci;
#if defined(_DERIVATE)
  double FFa_Vbi_ci_Vci_ei;
  double FFa_Vbi_ci_Vtnode_GND;
  double FFa_Vbi_ci_Vbi_ei;
  double FFa_Vbi_ci_Vbi_ci;
  double FFa_Vbi_ei_Vci_ei;
  double FFa_Vbi_ei_Vtnode_GND;
  double FFa_Vbi_ei_Vbi_ei;
  double FFa_Vbi_ei_Vbi_ci;
  double FFa_Vci_ei_Vci_ei;
  double FFa_Vci_ei_Vtnode_GND;
  double FFa_Vci_ei_Vbi_ei;
  double FFa_Vci_ei_Vbi_ci;
#endif
#endif
double T_fT;
#if defined(_DERIVATEFORDDX)
double T_fT_Vci_ei;
double T_fT_Vbi_ei;
double T_fT_Vtnode_GND;
double T_fT_Vbi_ci;
#if defined(_DERIVATE)
  double T_fT_Vbi_ci_Vci_ei;
  double T_fT_Vbi_ci_Vbi_ei;
  double T_fT_Vbi_ci_Vtnode_GND;
  double T_fT_Vbi_ci_Vbi_ci;
  double T_fT_Vbi_ei_Vci_ei;
  double T_fT_Vbi_ei_Vbi_ei;
  double T_fT_Vbi_ei_Vtnode_GND;
  double T_fT_Vbi_ei_Vbi_ci;
  double T_fT_Vci_ei_Vci_ei;
  double T_fT_Vci_ei_Vbi_ei;
  double T_fT_Vci_ei_Vtnode_GND;
  double T_fT_Vci_ei_Vbi_ci;
#endif
#endif
double Q_fT;
#if defined(_DERIVATEFORDDX)
double Q_fT_Vci_ei;
double Q_fT_Vtnode_GND;
double Q_fT_Vbi_ci;
double Q_fT_Vbi_ei;
#if defined(_DERIVATE)
  double Q_fT_Vbi_ei_Vci_ei;
  double Q_fT_Vbi_ei_Vtnode_GND;
  double Q_fT_Vbi_ei_Vbi_ci;
  double Q_fT_Vbi_ei_Vbi_ei;
  double Q_fT_Vbi_ci_Vci_ei;
  double Q_fT_Vbi_ci_Vtnode_GND;
  double Q_fT_Vbi_ci_Vbi_ci;
  double Q_fT_Vbi_ci_Vbi_ei;
  double Q_fT_Vci_ei_Vci_ei;
  double Q_fT_Vci_ei_Vtnode_GND;
  double Q_fT_Vci_ei_Vbi_ci;
  double Q_fT_Vci_ei_Vbi_ei;
#endif
#endif
double Qf;
#if defined(_DERIVATEFORDDX)
double Qf_Vci_ei;
double Qf_Vtnode_GND;
double Qf_Vbi_ci;
double Qf_Vbi_ei;
#if defined(_DERIVATE)
  double Qf_Vbi_ei_Vci_ei;
  double Qf_Vbi_ei_Vtnode_GND;
  double Qf_Vbi_ei_Vbi_ci;
  double Qf_Vbi_ei_Vbi_ei;
  double Qf_Vbi_ci_Vci_ei;
  double Qf_Vbi_ci_Vtnode_GND;
  double Qf_Vbi_ci_Vbi_ci;
  double Qf_Vbi_ci_Vbi_ei;
  double Qf_Vci_ei_Vci_ei;
  double Qf_Vci_ei_Vtnode_GND;
  double Qf_Vci_ei_Vbi_ci;
  double Qf_Vci_ei_Vbi_ei;
#endif
#endif
#if defined(_DERIVATEFORDDX)
double Tf_Vci_ei;
double Tf_Vbi_ei;
double Tf_Vtnode_GND;
double Tf_Vbi_ci;
#if defined(_DERIVATE)
  double Tf_Vbi_ci_Vci_ei;
  double Tf_Vbi_ci_Vbi_ei;
  double Tf_Vbi_ci_Vtnode_GND;
  double Tf_Vbi_ci_Vbi_ci;
  double Tf_Vbi_ei_Vci_ei;
  double Tf_Vbi_ei_Vbi_ei;
  double Tf_Vbi_ei_Vtnode_GND;
  double Tf_Vbi_ei_Vbi_ci;
  double Tf_Vci_ei_Vci_ei;
  double Tf_Vci_ei_Vbi_ei;
  double Tf_Vci_ei_Vtnode_GND;
  double Tf_Vci_ei_Vbi_ci;
#endif
#endif
double Q_bf;
#if defined(_DERIVATE)
double Q_bf_Vtnode_GND;
double Q_bf_Vbi_ei;
double Q_bf_Vbi_ci;
double Q_bf_Vci_ei;
#endif
double itr;
#if defined(_DERIVATEFORDDX)
double itr_Vci_ei;
double itr_Vtnode_GND;
double itr_Vbi_ci;
double itr_Vbi_ei;
#if defined(_DERIVATE)
  double itr_Vbi_ei_Vci_ei;
  double itr_Vbi_ei_Vtnode_GND;
  double itr_Vbi_ei_Vbi_ci;
  double itr_Vbi_ei_Vbi_ei;
  double itr_Vbi_ci_Vci_ei;
  double itr_Vbi_ci_Vtnode_GND;
  double itr_Vbi_ci_Vbi_ci;
  double itr_Vbi_ci_Vbi_ei;
  double itr_Vci_ei_Vci_ei;
  double itr_Vci_ei_Vtnode_GND;
  double itr_Vci_ei_Vbi_ci;
  double itr_Vci_ei_Vbi_ei;
#endif
#endif
double itf;
#if defined(_DERIVATEFORDDX)
double itf_Vci_ei;
double itf_Vtnode_GND;
double itf_Vbi_ei;
double itf_Vbi_ci;
#if defined(_DERIVATE)
  double itf_Vbi_ci_Vci_ei;
  double itf_Vbi_ci_Vtnode_GND;
  double itf_Vbi_ci_Vbi_ei;
  double itf_Vbi_ci_Vbi_ci;
  double itf_Vbi_ei_Vci_ei;
  double itf_Vbi_ei_Vtnode_GND;
  double itf_Vbi_ei_Vbi_ei;
  double itf_Vbi_ei_Vbi_ci;
  double itf_Vci_ei_Vci_ei;
  double itf_Vci_ei_Vtnode_GND;
  double itf_Vci_ei_Vbi_ei;
  double itf_Vci_ei_Vbi_ci;
#endif
#endif
double a_h;
#if defined(_DERIVATEFORDDX)
double a_h_Vci_ei;
double a_h_Vtnode_GND;
double a_h_Vbi_ei;
double a_h_Vbi_ci;
#if defined(_DERIVATE)
  double a_h_Vbi_ci_Vci_ei;
  double a_h_Vbi_ci_Vtnode_GND;
  double a_h_Vbi_ci_Vbi_ei;
  double a_h_Vbi_ci_Vbi_ci;
  double a_h_Vbi_ei_Vci_ei;
  double a_h_Vbi_ei_Vtnode_GND;
  double a_h_Vbi_ei_Vbi_ei;
  double a_h_Vbi_ei_Vbi_ci;
  double a_h_Vci_ei_Vci_ei;
  double a_h_Vci_ei_Vtnode_GND;
  double a_h_Vci_ei_Vbi_ei;
  double a_h_Vci_ei_Vbi_ci;
#endif
#endif
double I_Tf1;
#if defined(_DERIVATEFORDDX)
double I_Tf1_Vci_ei;
double I_Tf1_Vtnode_GND;
double I_Tf1_Vbi_ei;
double I_Tf1_Vbi_ci;
#if defined(_DERIVATE)
  double I_Tf1_Vbi_ci_Vci_ei;
  double I_Tf1_Vbi_ci_Vtnode_GND;
  double I_Tf1_Vbi_ci_Vbi_ei;
  double I_Tf1_Vbi_ci_Vbi_ci;
  double I_Tf1_Vbi_ei_Vci_ei;
  double I_Tf1_Vbi_ei_Vtnode_GND;
  double I_Tf1_Vbi_ei_Vbi_ei;
  double I_Tf1_Vbi_ei_Vbi_ci;
  double I_Tf1_Vci_ei_Vci_ei;
  double I_Tf1_Vci_ei_Vtnode_GND;
  double I_Tf1_Vci_ei_Vbi_ei;
  double I_Tf1_Vci_ei_Vbi_ci;
#endif
#endif
double A;
#if defined(_DERIVATEFORDDX)
double A_Vtnode_GND;
double A_Vbi_ei;
double A_Vbi_ci;
#if defined(_DERIVATE)
  double A_Vbi_ci_Vtnode_GND;
  double A_Vbi_ci_Vbi_ei;
  double A_Vbi_ci_Vbi_ci;
  double A_Vbi_ei_Vtnode_GND;
  double A_Vbi_ei_Vbi_ei;
  double A_Vbi_ei_Vbi_ci;
#endif
#endif
double Q_p;
#if defined(_DERIVATEFORDDX)
double Q_p_Vtnode_GND;
double Q_p_Vbi_ei;
double Q_p_Vbi_ci;
#if defined(_DERIVATE)
  double Q_p_Vbi_ci_Vtnode_GND;
  double Q_p_Vbi_ci_Vbi_ei;
  double Q_p_Vbi_ci_Vbi_ci;
  double Q_p_Vbi_ei_Vtnode_GND;
  double Q_p_Vbi_ei_Vbi_ei;
  double Q_p_Vbi_ei_Vbi_ci;
#endif
#endif
double ICKa;
#if defined(_DERIVATEFORDDX)
double ICKa_Vci_ei;
double ICKa_Vtnode_GND;
#if defined(_DERIVATE)
  double ICKa_Vci_ei_Vci_ei;
  double ICKa_Vci_ei_Vtnode_GND;
#endif
#endif
double ick;
#if defined(_DERIVATEFORDDX)
double ick_Vci_ei;
double ick_Vtnode_GND;
#if defined(_DERIVATE)
  double ick_Vci_ei_Vci_ei;
  double ick_Vci_ei_Vtnode_GND;
#endif
#endif
double vceff;
#if defined(_DERIVATEFORDDX)
double vceff_Vci_ei;
double vceff_Vtnode_GND;
#if defined(_DERIVATE)
  double vceff_Vci_ei_Vci_ei;
  double vceff_Vci_ei_Vtnode_GND;
#endif
#endif
double d1;
#if defined(_DERIVATEFORDDX)
double d1_Vci_ei;
double d1_Vtnode_GND;
#if defined(_DERIVATE)
  double d1_Vci_ei_Vci_ei;
  double d1_Vci_ei_Vtnode_GND;
#endif
#endif
double vc;
#if defined(_DERIVATEFORDDX)
double vc_Vci_ei;
double vc_Vtnode_GND;
#if defined(_DERIVATE)
  double vc_Vci_ei_Vci_ei;
  double vc_Vci_ei_Vtnode_GND;
#endif
#endif
double T_f0;
#if defined(_DERIVATEFORDDX)
double T_f0_Vtnode_GND;
double T_f0_Vbi_ci;
#if defined(_DERIVATE)
  double T_f0_Vbi_ci_Vtnode_GND;
  double T_f0_Vbi_ci_Vbi_ci;
#endif
#endif
double cc;
#if defined(_DERIVATEFORDDX)
double cc_Vtnode_GND;
double cc_Vbi_ci;
#if defined(_DERIVATE)
  double cc_Vbi_ci_Vtnode_GND;
  double cc_Vbi_ci_Vbi_ci;
#endif
#endif
double Cjcit;
#if defined(_DERIVATEFORDDX)
double Cjcit_Vtnode_GND;
double Cjcit_Vbi_ci;
#if defined(_DERIVATE)
  double Cjcit_Vbi_ci_Vtnode_GND;
  double Cjcit_Vbi_ci_Vbi_ci;
#endif
#endif
double b_q;
#if defined(_DERIVATEFORDDX)
double b_q_Vtnode_GND;
double b_q_Vbi_ei;
double b_q_Vbi_ci;
#if defined(_DERIVATE)
  double b_q_Vbi_ci_Vtnode_GND;
  double b_q_Vbi_ci_Vbi_ei;
  double b_q_Vbi_ci_Vbi_ci;
  double b_q_Vbi_ei_Vtnode_GND;
  double b_q_Vbi_ei_Vbi_ei;
  double b_q_Vbi_ei_Vbi_ci;
#endif
#endif
double Q_bpt;
#if defined(_DERIVATE)
double Q_bpt_Vtnode_GND;
#endif
double Q_0;
#if defined(_DERIVATEFORDDX)
double Q_0_Vtnode_GND;
double Q_0_Vbi_ei;
double Q_0_Vbi_ci;
#if defined(_DERIVATE)
  double Q_0_Vbi_ci_Vtnode_GND;
  double Q_0_Vbi_ci_Vbi_ei;
  double Q_0_Vbi_ci_Vbi_ci;
  double Q_0_Vbi_ei_Vtnode_GND;
  double Q_0_Vbi_ei_Vbi_ei;
  double Q_0_Vbi_ei_Vbi_ci;
#endif
#endif
double a_bpt;
double Cjci;
#if defined(_DERIVATE)
double Cjci_Vbi_ei;
double Cjci_Vtnode_GND;
double Cjci_Vbi_ci;
#endif
double Qjci;
#if defined(_DERIVATEFORDDX)
double Qjci_Vbi_ei;
double Qjci_Vtnode_GND;
double Qjci_Vbi_ci;
#if defined(_DERIVATE)
  double Qjci_Vbi_ci_Vbi_ei;
  double Qjci_Vbi_ci_Vtnode_GND;
  double Qjci_Vbi_ci_Vbi_ci;
  double Qjci_Vbi_ei_Vbi_ei;
  double Qjci_Vbi_ei_Vtnode_GND;
  double Qjci_Vbi_ei_Vbi_ci;
#endif
#endif
double DQ_j3;
#if defined(_DERIVATEFORDDX)
double DQ_j3_Vsi_ci;
double DQ_j3_Vb_ci;
double DQ_j3_Vbp_ci;
double DQ_j3_Vtnode_GND;
double DQ_j3_Vbi_ci;
#if defined(_DERIVATE)
  double DQ_j3_Vbi_ci_Vsi_ci;
  double DQ_j3_Vbi_ci_Vb_ci;
  double DQ_j3_Vbi_ci_Vbp_ci;
  double DQ_j3_Vbi_ci_Vtnode_GND;
  double DQ_j3_Vbi_ci_Vbi_ci;
  double DQ_j3_Vbp_ci_Vsi_ci;
  double DQ_j3_Vbp_ci_Vb_ci;
  double DQ_j3_Vbp_ci_Vbp_ci;
  double DQ_j3_Vbp_ci_Vtnode_GND;
  double DQ_j3_Vbp_ci_Vbi_ci;
  double DQ_j3_Vb_ci_Vsi_ci;
  double DQ_j3_Vb_ci_Vb_ci;
  double DQ_j3_Vb_ci_Vbp_ci;
  double DQ_j3_Vb_ci_Vtnode_GND;
  double DQ_j3_Vb_ci_Vbi_ci;
  double DQ_j3_Vsi_ci_Vsi_ci;
  double DQ_j3_Vsi_ci_Vb_ci;
  double DQ_j3_Vsi_ci_Vbp_ci;
  double DQ_j3_Vsi_ci_Vtnode_GND;
  double DQ_j3_Vsi_ci_Vbi_ci;
#endif
#endif
double DQ_j2;
#if defined(_DERIVATEFORDDX)
double DQ_j2_Vsi_ci;
double DQ_j2_Vb_ci;
double DQ_j2_Vbp_ci;
double DQ_j2_Vtnode_GND;
double DQ_j2_Vbi_ci;
#if defined(_DERIVATE)
  double DQ_j2_Vbi_ci_Vsi_ci;
  double DQ_j2_Vbi_ci_Vb_ci;
  double DQ_j2_Vbi_ci_Vbp_ci;
  double DQ_j2_Vbi_ci_Vtnode_GND;
  double DQ_j2_Vbi_ci_Vbi_ci;
  double DQ_j2_Vbp_ci_Vsi_ci;
  double DQ_j2_Vbp_ci_Vb_ci;
  double DQ_j2_Vbp_ci_Vbp_ci;
  double DQ_j2_Vbp_ci_Vtnode_GND;
  double DQ_j2_Vbp_ci_Vbi_ci;
  double DQ_j2_Vb_ci_Vsi_ci;
  double DQ_j2_Vb_ci_Vb_ci;
  double DQ_j2_Vb_ci_Vbp_ci;
  double DQ_j2_Vb_ci_Vtnode_GND;
  double DQ_j2_Vb_ci_Vbi_ci;
  double DQ_j2_Vsi_ci_Vsi_ci;
  double DQ_j2_Vsi_ci_Vb_ci;
  double DQ_j2_Vsi_ci_Vbp_ci;
  double DQ_j2_Vsi_ci_Vtnode_GND;
  double DQ_j2_Vsi_ci_Vbi_ci;
#endif
#endif
double DQ_j1;
#if defined(_DERIVATEFORDDX)
double DQ_j1_Vsi_ci;
double DQ_j1_Vb_ci;
double DQ_j1_Vbp_ci;
double DQ_j1_Vtnode_GND;
double DQ_j1_Vbi_ci;
#if defined(_DERIVATE)
  double DQ_j1_Vbi_ci_Vsi_ci;
  double DQ_j1_Vbi_ci_Vb_ci;
  double DQ_j1_Vbi_ci_Vbp_ci;
  double DQ_j1_Vbi_ci_Vtnode_GND;
  double DQ_j1_Vbi_ci_Vbi_ci;
  double DQ_j1_Vbp_ci_Vsi_ci;
  double DQ_j1_Vbp_ci_Vb_ci;
  double DQ_j1_Vbp_ci_Vbp_ci;
  double DQ_j1_Vbp_ci_Vtnode_GND;
  double DQ_j1_Vbp_ci_Vbi_ci;
  double DQ_j1_Vb_ci_Vsi_ci;
  double DQ_j1_Vb_ci_Vb_ci;
  double DQ_j1_Vb_ci_Vbp_ci;
  double DQ_j1_Vb_ci_Vtnode_GND;
  double DQ_j1_Vb_ci_Vbi_ci;
  double DQ_j1_Vsi_ci_Vsi_ci;
  double DQ_j1_Vsi_ci_Vb_ci;
  double DQ_j1_Vsi_ci_Vbp_ci;
  double DQ_j1_Vsi_ci_Vtnode_GND;
  double DQ_j1_Vsi_ci_Vbi_ci;
#endif
#endif
double Dzr1;
double Dz1;
double DCln2;
#if defined(_DERIVATEFORDDX)
double DCln2_Vsi_ci;
double DCln2_Vb_ci;
double DCln2_Vbp_ci;
double DCln2_Vtnode_GND;
double DCln2_Vbi_ci;
#if defined(_DERIVATE)
  double DCln2_Vbi_ci_Vsi_ci;
  double DCln2_Vbi_ci_Vb_ci;
  double DCln2_Vbi_ci_Vbp_ci;
  double DCln2_Vbi_ci_Vtnode_GND;
  double DCln2_Vbi_ci_Vbi_ci;
  double DCln2_Vbp_ci_Vsi_ci;
  double DCln2_Vbp_ci_Vb_ci;
  double DCln2_Vbp_ci_Vbp_ci;
  double DCln2_Vbp_ci_Vtnode_GND;
  double DCln2_Vbp_ci_Vbi_ci;
  double DCln2_Vb_ci_Vsi_ci;
  double DCln2_Vb_ci_Vb_ci;
  double DCln2_Vb_ci_Vbp_ci;
  double DCln2_Vb_ci_Vtnode_GND;
  double DCln2_Vb_ci_Vbi_ci;
  double DCln2_Vsi_ci_Vsi_ci;
  double DCln2_Vsi_ci_Vb_ci;
  double DCln2_Vsi_ci_Vbp_ci;
  double DCln2_Vsi_ci_Vtnode_GND;
  double DCln2_Vsi_ci_Vbi_ci;
#endif
#endif
double DCln1;
#if defined(_DERIVATEFORDDX)
double DCln1_Vsi_ci;
double DCln1_Vb_ci;
double DCln1_Vbp_ci;
double DCln1_Vtnode_GND;
double DCln1_Vbi_ci;
#if defined(_DERIVATE)
  double DCln1_Vbi_ci_Vsi_ci;
  double DCln1_Vbi_ci_Vb_ci;
  double DCln1_Vbi_ci_Vbp_ci;
  double DCln1_Vbi_ci_Vtnode_GND;
  double DCln1_Vbi_ci_Vbi_ci;
  double DCln1_Vbp_ci_Vsi_ci;
  double DCln1_Vbp_ci_Vb_ci;
  double DCln1_Vbp_ci_Vbp_ci;
  double DCln1_Vbp_ci_Vtnode_GND;
  double DCln1_Vbp_ci_Vbi_ci;
  double DCln1_Vb_ci_Vsi_ci;
  double DCln1_Vb_ci_Vb_ci;
  double DCln1_Vb_ci_Vbp_ci;
  double DCln1_Vb_ci_Vtnode_GND;
  double DCln1_Vb_ci_Vbi_ci;
  double DCln1_Vsi_ci_Vsi_ci;
  double DCln1_Vsi_ci_Vb_ci;
  double DCln1_Vsi_ci_Vbp_ci;
  double DCln1_Vsi_ci_Vtnode_GND;
  double DCln1_Vsi_ci_Vbi_ci;
#endif
#endif
double Dv_j4;
#if defined(_DERIVATEFORDDX)
double Dv_j4_Vsi_ci;
double Dv_j4_Vb_ci;
double Dv_j4_Vbp_ci;
double Dv_j4_Vbi_ci;
double Dv_j4_Vtnode_GND;
#if defined(_DERIVATE)
  double Dv_j4_Vbi_ci_Vsi_ci;
  double Dv_j4_Vbi_ci_Vb_ci;
  double Dv_j4_Vbi_ci_Vbp_ci;
  double Dv_j4_Vbi_ci_Vbi_ci;
  double Dv_j4_Vbi_ci_Vtnode_GND;
  double Dv_j4_Vbp_ci_Vsi_ci;
  double Dv_j4_Vbp_ci_Vb_ci;
  double Dv_j4_Vbp_ci_Vbp_ci;
  double Dv_j4_Vbp_ci_Vbi_ci;
  double Dv_j4_Vbp_ci_Vtnode_GND;
  double Dv_j4_Vb_ci_Vsi_ci;
  double Dv_j4_Vb_ci_Vb_ci;
  double Dv_j4_Vb_ci_Vbp_ci;
  double Dv_j4_Vb_ci_Vbi_ci;
  double Dv_j4_Vb_ci_Vtnode_GND;
  double Dv_j4_Vsi_ci_Vsi_ci;
  double Dv_j4_Vsi_ci_Vb_ci;
  double Dv_j4_Vsi_ci_Vbp_ci;
  double Dv_j4_Vsi_ci_Vbi_ci;
  double Dv_j4_Vsi_ci_Vtnode_GND;
#endif
#endif
double Dv_j2;
#if defined(_DERIVATEFORDDX)
double Dv_j2_Vsi_ci;
double Dv_j2_Vb_ci;
double Dv_j2_Vbp_ci;
double Dv_j2_Vtnode_GND;
double Dv_j2_Vbi_ci;
#if defined(_DERIVATE)
  double Dv_j2_Vbi_ci_Vsi_ci;
  double Dv_j2_Vbi_ci_Vb_ci;
  double Dv_j2_Vbi_ci_Vbp_ci;
  double Dv_j2_Vbi_ci_Vtnode_GND;
  double Dv_j2_Vbi_ci_Vbi_ci;
  double Dv_j2_Vbp_ci_Vsi_ci;
  double Dv_j2_Vbp_ci_Vb_ci;
  double Dv_j2_Vbp_ci_Vbp_ci;
  double Dv_j2_Vbp_ci_Vtnode_GND;
  double Dv_j2_Vbp_ci_Vbi_ci;
  double Dv_j2_Vb_ci_Vsi_ci;
  double Dv_j2_Vb_ci_Vb_ci;
  double Dv_j2_Vb_ci_Vbp_ci;
  double Dv_j2_Vb_ci_Vtnode_GND;
  double Dv_j2_Vb_ci_Vbi_ci;
  double Dv_j2_Vsi_ci_Vsi_ci;
  double Dv_j2_Vsi_ci_Vb_ci;
  double Dv_j2_Vsi_ci_Vbp_ci;
  double Dv_j2_Vsi_ci_Vtnode_GND;
  double Dv_j2_Vsi_ci_Vbi_ci;
#endif
#endif
double Dv_r;
#if defined(_DERIVATEFORDDX)
double Dv_r_Vsi_ci;
double Dv_r_Vb_ci;
double Dv_r_Vbp_ci;
double Dv_r_Vtnode_GND;
double Dv_r_Vbi_ci;
#if defined(_DERIVATE)
  double Dv_r_Vbi_ci_Vsi_ci;
  double Dv_r_Vbi_ci_Vb_ci;
  double Dv_r_Vbi_ci_Vbp_ci;
  double Dv_r_Vbi_ci_Vtnode_GND;
  double Dv_r_Vbi_ci_Vbi_ci;
  double Dv_r_Vbp_ci_Vsi_ci;
  double Dv_r_Vbp_ci_Vb_ci;
  double Dv_r_Vbp_ci_Vbp_ci;
  double Dv_r_Vbp_ci_Vtnode_GND;
  double Dv_r_Vbp_ci_Vbi_ci;
  double Dv_r_Vb_ci_Vsi_ci;
  double Dv_r_Vb_ci_Vb_ci;
  double Dv_r_Vb_ci_Vbp_ci;
  double Dv_r_Vb_ci_Vtnode_GND;
  double Dv_r_Vb_ci_Vbi_ci;
  double Dv_r_Vsi_ci_Vsi_ci;
  double Dv_r_Vsi_ci_Vb_ci;
  double Dv_r_Vsi_ci_Vbp_ci;
  double Dv_r_Vsi_ci_Vtnode_GND;
  double Dv_r_Vsi_ci_Vbi_ci;
#endif
#endif
double Da;
#if defined(_DERIVATE)
double Da_Vtnode_GND;
#endif
double Dv_j1;
#if defined(_DERIVATEFORDDX)
double Dv_j1_Vsi_ci;
double Dv_j1_Vb_ci;
double Dv_j1_Vbp_ci;
double Dv_j1_Vtnode_GND;
double Dv_j1_Vbi_ci;
#if defined(_DERIVATE)
  double Dv_j1_Vbi_ci_Vsi_ci;
  double Dv_j1_Vbi_ci_Vb_ci;
  double Dv_j1_Vbi_ci_Vbp_ci;
  double Dv_j1_Vbi_ci_Vtnode_GND;
  double Dv_j1_Vbi_ci_Vbi_ci;
  double Dv_j1_Vbp_ci_Vsi_ci;
  double Dv_j1_Vbp_ci_Vb_ci;
  double Dv_j1_Vbp_ci_Vbp_ci;
  double Dv_j1_Vbp_ci_Vtnode_GND;
  double Dv_j1_Vbp_ci_Vbi_ci;
  double Dv_j1_Vb_ci_Vsi_ci;
  double Dv_j1_Vb_ci_Vb_ci;
  double Dv_j1_Vb_ci_Vbp_ci;
  double Dv_j1_Vb_ci_Vtnode_GND;
  double Dv_j1_Vb_ci_Vbi_ci;
  double Dv_j1_Vsi_ci_Vsi_ci;
  double Dv_j1_Vsi_ci_Vb_ci;
  double Dv_j1_Vsi_ci_Vbp_ci;
  double Dv_j1_Vsi_ci_Vtnode_GND;
  double Dv_j1_Vsi_ci_Vbi_ci;
#endif
#endif
double De;
#if defined(_DERIVATEFORDDX)
double De_Vsi_ci;
double De_Vb_ci;
double De_Vbp_ci;
double De_Vtnode_GND;
double De_Vbi_ci;
#if defined(_DERIVATE)
  double De_Vbi_ci_Vsi_ci;
  double De_Vbi_ci_Vb_ci;
  double De_Vbi_ci_Vbp_ci;
  double De_Vbi_ci_Vtnode_GND;
  double De_Vbi_ci_Vbi_ci;
  double De_Vbp_ci_Vsi_ci;
  double De_Vbp_ci_Vb_ci;
  double De_Vbp_ci_Vbp_ci;
  double De_Vbp_ci_Vtnode_GND;
  double De_Vbp_ci_Vbi_ci;
  double De_Vb_ci_Vsi_ci;
  double De_Vb_ci_Vb_ci;
  double De_Vb_ci_Vbp_ci;
  double De_Vb_ci_Vtnode_GND;
  double De_Vb_ci_Vbi_ci;
  double De_Vsi_ci_Vsi_ci;
  double De_Vsi_ci_Vb_ci;
  double De_Vsi_ci_Vbp_ci;
  double De_Vsi_ci_Vtnode_GND;
  double De_Vsi_ci_Vbi_ci;
#endif
#endif
double Dv_e;
#if defined(_DERIVATEFORDDX)
double Dv_e_Vsi_ci;
double Dv_e_Vb_ci;
double Dv_e_Vbp_ci;
double Dv_e_Vtnode_GND;
double Dv_e_Vbi_ci;
#if defined(_DERIVATE)
  double Dv_e_Vbi_ci_Vsi_ci;
  double Dv_e_Vbi_ci_Vb_ci;
  double Dv_e_Vbi_ci_Vbp_ci;
  double Dv_e_Vbi_ci_Vtnode_GND;
  double Dv_e_Vbi_ci_Vbi_ci;
  double Dv_e_Vbp_ci_Vsi_ci;
  double Dv_e_Vbp_ci_Vb_ci;
  double Dv_e_Vbp_ci_Vbp_ci;
  double Dv_e_Vbp_ci_Vtnode_GND;
  double Dv_e_Vbp_ci_Vbi_ci;
  double Dv_e_Vb_ci_Vsi_ci;
  double Dv_e_Vb_ci_Vb_ci;
  double Dv_e_Vb_ci_Vbp_ci;
  double Dv_e_Vb_ci_Vtnode_GND;
  double Dv_e_Vb_ci_Vbi_ci;
  double Dv_e_Vsi_ci_Vsi_ci;
  double Dv_e_Vsi_ci_Vb_ci;
  double Dv_e_Vsi_ci_Vbp_ci;
  double Dv_e_Vsi_ci_Vtnode_GND;
  double Dv_e_Vsi_ci_Vbi_ci;
#endif
#endif
double DC_c;
#if defined(_DERIVATE)
double DC_c_Vtnode_GND;
#endif
double DC_max;
#if defined(_DERIVATE)
double DC_max_Vtnode_GND;
#endif
double DV_f;
#if defined(_DERIVATE)
double DV_f_Vtnode_GND;
#endif
double Dv_p;
#if defined(_DERIVATE)
double Dv_p_Vtnode_GND;
#endif
double Dz_r;
double Cjei;
#if defined(_DERIVATE)
double Cjei_Vtnode_GND;
double Cjei_Vbi_ei;
#endif
double Qjei;
#if defined(_DERIVATEFORDDX)
double Qjei_Vtnode_GND;
double Qjei_Vbi_ei;
#if defined(_DERIVATE)
  double Qjei_Vbi_ei_Vtnode_GND;
  double Qjei_Vbi_ei_Vbi_ei;
#endif
#endif
double DFQ_j;
#if defined(_DERIVATEFORDDX)
double DFQ_j_Vsi_ci;
double DFQ_j_Vb_ci;
double DFQ_j_Vbp_ci;
double DFQ_j_Vbi_ci;
double DFQ_j_Vtnode_GND;
double DFQ_j_Vbi_ei;
#if defined(_DERIVATE)
  double DFQ_j_Vbi_ei_Vsi_ci;
  double DFQ_j_Vbi_ei_Vb_ci;
  double DFQ_j_Vbi_ei_Vbp_ci;
  double DFQ_j_Vbi_ei_Vbi_ci;
  double DFQ_j_Vbi_ei_Vtnode_GND;
  double DFQ_j_Vbi_ei_Vbi_ei;
  double DFQ_j_Vbi_ci_Vsi_ci;
  double DFQ_j_Vbi_ci_Vb_ci;
  double DFQ_j_Vbi_ci_Vbp_ci;
  double DFQ_j_Vbi_ci_Vbi_ci;
  double DFQ_j_Vbi_ci_Vtnode_GND;
  double DFQ_j_Vbi_ci_Vbi_ei;
  double DFQ_j_Vbp_ci_Vsi_ci;
  double DFQ_j_Vbp_ci_Vb_ci;
  double DFQ_j_Vbp_ci_Vbp_ci;
  double DFQ_j_Vbp_ci_Vbi_ci;
  double DFQ_j_Vbp_ci_Vtnode_GND;
  double DFQ_j_Vbp_ci_Vbi_ei;
  double DFQ_j_Vb_ci_Vsi_ci;
  double DFQ_j_Vb_ci_Vb_ci;
  double DFQ_j_Vb_ci_Vbp_ci;
  double DFQ_j_Vb_ci_Vbi_ci;
  double DFQ_j_Vb_ci_Vtnode_GND;
  double DFQ_j_Vb_ci_Vbi_ei;
  double DFQ_j_Vsi_ci_Vsi_ci;
  double DFQ_j_Vsi_ci_Vb_ci;
  double DFQ_j_Vsi_ci_Vbp_ci;
  double DFQ_j_Vsi_ci_Vbi_ci;
  double DFQ_j_Vsi_ci_Vtnode_GND;
  double DFQ_j_Vsi_ci_Vbi_ei;
#endif
#endif
double DFb;
#if defined(_DERIVATEFORDDX)
double DFb_Vsi_ci;
double DFb_Vb_ci;
double DFb_Vbp_ci;
double DFb_Vbi_ci;
double DFb_Vtnode_GND;
double DFb_Vbi_ei;
#if defined(_DERIVATE)
  double DFb_Vbi_ei_Vsi_ci;
  double DFb_Vbi_ei_Vb_ci;
  double DFb_Vbi_ei_Vbp_ci;
  double DFb_Vbi_ei_Vbi_ci;
  double DFb_Vbi_ei_Vtnode_GND;
  double DFb_Vbi_ei_Vbi_ei;
  double DFb_Vbi_ci_Vsi_ci;
  double DFb_Vbi_ci_Vb_ci;
  double DFb_Vbi_ci_Vbp_ci;
  double DFb_Vbi_ci_Vbi_ci;
  double DFb_Vbi_ci_Vtnode_GND;
  double DFb_Vbi_ci_Vbi_ei;
  double DFb_Vbp_ci_Vsi_ci;
  double DFb_Vbp_ci_Vb_ci;
  double DFb_Vbp_ci_Vbp_ci;
  double DFb_Vbp_ci_Vbi_ci;
  double DFb_Vbp_ci_Vtnode_GND;
  double DFb_Vbp_ci_Vbi_ei;
  double DFb_Vb_ci_Vsi_ci;
  double DFb_Vb_ci_Vb_ci;
  double DFb_Vb_ci_Vbp_ci;
  double DFb_Vb_ci_Vbi_ci;
  double DFb_Vb_ci_Vtnode_GND;
  double DFb_Vb_ci_Vbi_ei;
  double DFb_Vsi_ci_Vsi_ci;
  double DFb_Vsi_ci_Vb_ci;
  double DFb_Vsi_ci_Vbp_ci;
  double DFb_Vsi_ci_Vbi_ci;
  double DFb_Vsi_ci_Vtnode_GND;
  double DFb_Vsi_ci_Vbi_ei;
#endif
#endif
double DFv_j;
#if defined(_DERIVATEFORDDX)
double DFv_j_Vsi_ci;
double DFv_j_Vb_ci;
double DFv_j_Vbp_ci;
double DFv_j_Vbi_ci;
double DFv_j_Vtnode_GND;
double DFv_j_Vbi_ei;
#if defined(_DERIVATE)
  double DFv_j_Vbi_ei_Vsi_ci;
  double DFv_j_Vbi_ei_Vb_ci;
  double DFv_j_Vbi_ei_Vbp_ci;
  double DFv_j_Vbi_ei_Vbi_ci;
  double DFv_j_Vbi_ei_Vtnode_GND;
  double DFv_j_Vbi_ei_Vbi_ei;
  double DFv_j_Vbi_ci_Vsi_ci;
  double DFv_j_Vbi_ci_Vb_ci;
  double DFv_j_Vbi_ci_Vbp_ci;
  double DFv_j_Vbi_ci_Vbi_ci;
  double DFv_j_Vbi_ci_Vtnode_GND;
  double DFv_j_Vbi_ci_Vbi_ei;
  double DFv_j_Vbp_ci_Vsi_ci;
  double DFv_j_Vbp_ci_Vb_ci;
  double DFv_j_Vbp_ci_Vbp_ci;
  double DFv_j_Vbp_ci_Vbi_ci;
  double DFv_j_Vbp_ci_Vtnode_GND;
  double DFv_j_Vbp_ci_Vbi_ei;
  double DFv_j_Vb_ci_Vsi_ci;
  double DFv_j_Vb_ci_Vb_ci;
  double DFv_j_Vb_ci_Vbp_ci;
  double DFv_j_Vb_ci_Vbi_ci;
  double DFv_j_Vb_ci_Vtnode_GND;
  double DFv_j_Vb_ci_Vbi_ei;
  double DFv_j_Vsi_ci_Vsi_ci;
  double DFv_j_Vsi_ci_Vb_ci;
  double DFv_j_Vsi_ci_Vbp_ci;
  double DFv_j_Vsi_ci_Vbi_ci;
  double DFv_j_Vsi_ci_Vtnode_GND;
  double DFv_j_Vsi_ci_Vbi_ei;
#endif
#endif
double DFs_q2;
#if defined(_DERIVATEFORDDX)
double DFs_q2_Vsi_ci;
double DFs_q2_Vb_ci;
double DFs_q2_Vbp_ci;
double DFs_q2_Vbi_ci;
double DFs_q2_Vtnode_GND;
double DFs_q2_Vbi_ei;
#if defined(_DERIVATE)
  double DFs_q2_Vbi_ei_Vsi_ci;
  double DFs_q2_Vbi_ei_Vb_ci;
  double DFs_q2_Vbi_ei_Vbp_ci;
  double DFs_q2_Vbi_ei_Vbi_ci;
  double DFs_q2_Vbi_ei_Vtnode_GND;
  double DFs_q2_Vbi_ei_Vbi_ei;
  double DFs_q2_Vbi_ci_Vsi_ci;
  double DFs_q2_Vbi_ci_Vb_ci;
  double DFs_q2_Vbi_ci_Vbp_ci;
  double DFs_q2_Vbi_ci_Vbi_ci;
  double DFs_q2_Vbi_ci_Vtnode_GND;
  double DFs_q2_Vbi_ci_Vbi_ei;
  double DFs_q2_Vbp_ci_Vsi_ci;
  double DFs_q2_Vbp_ci_Vb_ci;
  double DFs_q2_Vbp_ci_Vbp_ci;
  double DFs_q2_Vbp_ci_Vbi_ci;
  double DFs_q2_Vbp_ci_Vtnode_GND;
  double DFs_q2_Vbp_ci_Vbi_ei;
  double DFs_q2_Vb_ci_Vsi_ci;
  double DFs_q2_Vb_ci_Vb_ci;
  double DFs_q2_Vb_ci_Vbp_ci;
  double DFs_q2_Vb_ci_Vbi_ci;
  double DFs_q2_Vb_ci_Vtnode_GND;
  double DFs_q2_Vb_ci_Vbi_ei;
  double DFs_q2_Vsi_ci_Vsi_ci;
  double DFs_q2_Vsi_ci_Vb_ci;
  double DFs_q2_Vsi_ci_Vbp_ci;
  double DFs_q2_Vsi_ci_Vbi_ci;
  double DFs_q2_Vsi_ci_Vtnode_GND;
  double DFs_q2_Vsi_ci_Vbi_ei;
#endif
#endif
double DFs_q;
#if defined(_DERIVATEFORDDX)
double DFs_q_Vsi_ci;
double DFs_q_Vb_ci;
double DFs_q_Vbp_ci;
double DFs_q_Vbi_ci;
double DFs_q_Vtnode_GND;
double DFs_q_Vbi_ei;
#if defined(_DERIVATE)
  double DFs_q_Vbi_ei_Vsi_ci;
  double DFs_q_Vbi_ei_Vb_ci;
  double DFs_q_Vbi_ei_Vbp_ci;
  double DFs_q_Vbi_ei_Vbi_ci;
  double DFs_q_Vbi_ei_Vtnode_GND;
  double DFs_q_Vbi_ei_Vbi_ei;
  double DFs_q_Vbi_ci_Vsi_ci;
  double DFs_q_Vbi_ci_Vb_ci;
  double DFs_q_Vbi_ci_Vbp_ci;
  double DFs_q_Vbi_ci_Vbi_ci;
  double DFs_q_Vbi_ci_Vtnode_GND;
  double DFs_q_Vbi_ci_Vbi_ei;
  double DFs_q_Vbp_ci_Vsi_ci;
  double DFs_q_Vbp_ci_Vb_ci;
  double DFs_q_Vbp_ci_Vbp_ci;
  double DFs_q_Vbp_ci_Vbi_ci;
  double DFs_q_Vbp_ci_Vtnode_GND;
  double DFs_q_Vbp_ci_Vbi_ei;
  double DFs_q_Vb_ci_Vsi_ci;
  double DFs_q_Vb_ci_Vb_ci;
  double DFs_q_Vb_ci_Vbp_ci;
  double DFs_q_Vb_ci_Vbi_ci;
  double DFs_q_Vb_ci_Vtnode_GND;
  double DFs_q_Vb_ci_Vbi_ei;
  double DFs_q_Vsi_ci_Vsi_ci;
  double DFs_q_Vsi_ci_Vb_ci;
  double DFs_q_Vsi_ci_Vbp_ci;
  double DFs_q_Vsi_ci_Vbi_ci;
  double DFs_q_Vsi_ci_Vtnode_GND;
  double DFs_q_Vsi_ci_Vbi_ei;
#endif
#endif
double DFv_e;
#if defined(_DERIVATEFORDDX)
double DFv_e_Vsi_ci;
double DFv_e_Vb_ci;
double DFv_e_Vbp_ci;
double DFv_e_Vbi_ci;
double DFv_e_Vtnode_GND;
double DFv_e_Vbi_ei;
#if defined(_DERIVATE)
  double DFv_e_Vbi_ei_Vsi_ci;
  double DFv_e_Vbi_ei_Vb_ci;
  double DFv_e_Vbi_ei_Vbp_ci;
  double DFv_e_Vbi_ei_Vbi_ci;
  double DFv_e_Vbi_ei_Vtnode_GND;
  double DFv_e_Vbi_ei_Vbi_ei;
  double DFv_e_Vbi_ci_Vsi_ci;
  double DFv_e_Vbi_ci_Vb_ci;
  double DFv_e_Vbi_ci_Vbp_ci;
  double DFv_e_Vbi_ci_Vbi_ci;
  double DFv_e_Vbi_ci_Vtnode_GND;
  double DFv_e_Vbi_ci_Vbi_ei;
  double DFv_e_Vbp_ci_Vsi_ci;
  double DFv_e_Vbp_ci_Vb_ci;
  double DFv_e_Vbp_ci_Vbp_ci;
  double DFv_e_Vbp_ci_Vbi_ci;
  double DFv_e_Vbp_ci_Vtnode_GND;
  double DFv_e_Vbp_ci_Vbi_ei;
  double DFv_e_Vb_ci_Vsi_ci;
  double DFv_e_Vb_ci_Vb_ci;
  double DFv_e_Vb_ci_Vbp_ci;
  double DFv_e_Vb_ci_Vbi_ci;
  double DFv_e_Vb_ci_Vtnode_GND;
  double DFv_e_Vb_ci_Vbi_ei;
  double DFv_e_Vsi_ci_Vsi_ci;
  double DFv_e_Vsi_ci_Vb_ci;
  double DFv_e_Vsi_ci_Vbp_ci;
  double DFv_e_Vsi_ci_Vbi_ci;
  double DFv_e_Vsi_ci_Vtnode_GND;
  double DFv_e_Vsi_ci_Vbi_ei;
#endif
#endif
double DFV_f;
#if defined(_DERIVATE)
double DFV_f_Vtnode_GND;
#endif
double i_0r;
#if defined(_DERIVATEFORDDX)
double i_0r_Vtnode_GND;
double i_0r_Vbi_ci;
#if defined(_DERIVATE)
  double i_0r_Vbi_ci_Vtnode_GND;
  double i_0r_Vbi_ci_Vbi_ci;
#endif
#endif
double i_0f;
#if defined(_DERIVATEFORDDX)
double i_0f_Vtnode_GND;
double i_0f_Vbi_ei;
#if defined(_DERIVATE)
  double i_0f_Vbi_ei_Vtnode_GND;
  double i_0f_Vbi_ei_Vbi_ei;
#endif
#endif
double VT_f;
#if defined(_DERIVATE)
double VT_f_Vtnode_GND;
#endif
double Tr;
double Orci0_t;
#if defined(_DERIVATE)
double Orci0_t_Vtnode_GND;
#endif
double irei;
#if defined(_DERIVATE)
double irei_Vtnode_GND;
double irei_Vbi_ei;
#endif
#if defined(_DERIVATE)
double ibei_Vtnode_GND;
double ibei_Vbi_ei;
#endif
double le;
#if defined(_DERIVATE)
double le_Vsi_ci;
double le_Vbp_ci;
double le_Vbp_ei;
double le_Vbi_ci;
double le_Vbi_ei;
double le_Vtnode_GND;
#endif
double DIOY;
#if defined(_DERIVATE)
double DIOY_Vsi_ci;
double DIOY_Vbp_ci;
double DIOY_Vbp_ei;
double DIOY_Vbi_ci;
double DIOY_Vbi_ei;
double DIOY_Vtnode_GND;
#endif
double Vxf4;
#if defined(_DERIVATE)
double Vxf4_Vxf4_GND;
#endif
double Vxf3;
#if defined(_DERIVATE)
double Vxf3_Vxf3_GND;
#endif
double Vxf2;
#if defined(_DERIVATE)
double Vxf2_Vxf2_GND;
#endif
double Vxf1;
#if defined(_DERIVATE)
double Vxf1_Vxf1_GND;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double vpts_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double cjs0_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double vds_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double tsf_t_Vtnode_GND;
#endif
#endif
#if defined(_DERIVATE)
double re_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double rbx_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double rcx_t_Vtnode_GND;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double cjcx02_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double cjcx01_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double vptcx_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double cratio_t_Vtnode_GND;
#endif
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
double vdcx_t_Vtnode_GND;
#endif
#endif
#if defined(_DERIVATE)
double abet_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibets_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ajep_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double cjep0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdep_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double rbi0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double qavl_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double favl_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double thcs_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double t0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vptci_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double cjci0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdci_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vces_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double rci0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double c10_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double tef0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vlim_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double k_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double qp0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double iscs_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double itss_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibcxs_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibcis_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ireps_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibeps_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ireis_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ibeis_t_Vtnode_GND;
#endif
#if defined(_DERIVATEFORDDX)
double a_Vbi_ei;
double a_Vbi_ci;
double a_Vci_ei;
double a_Vtnode_GND;
#if defined(_DERIVATE)
  double a_Vci_ei_Vbi_ei;
  double a_Vci_ei_Vbi_ci;
  double a_Vci_ei_Vci_ei;
  double a_Vci_ei_Vtnode_GND;
  double a_Vbi_ci_Vbi_ei;
  double a_Vbi_ci_Vbi_ci;
  double a_Vbi_ci_Vci_ei;
  double a_Vbi_ci_Vtnode_GND;
  double a_Vbi_ei_Vbi_ei;
  double a_Vbi_ei_Vbi_ci;
  double a_Vbi_ei_Vci_ei;
  double a_Vbi_ei_Vtnode_GND;
#endif
#endif
#if defined(_DERIVATE)
double r_VgVT_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double V_gT_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ajei_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double cjei0_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdei_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdt_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vdjt_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vgbe_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vge_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double vgb_t_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double k2_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double k1_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ln_qtt0_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double qtt0_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double dT_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double VT_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double Tdev_Vtnode_GND;
#endif
if
(((flsh!=0)&&(rth>=0.001)))
{
#if defined(_DERIVATE)
Tdev_Vtnode_GND=1.0;
#endif
Tdev=((Tamb+dt)+NP(tnode));
if
((Tdev<((-100.0)+273.15)))
{
#if defined(_DERIVATE)
Tdev_Vtnode_GND=0.0;
#endif
Tdev=((-100.0)+273.15);
}
else
{
if
((Tdev>(326.85+273.15)))
{
#if defined(_DERIVATE)
Tdev_Vtnode_GND=0.0;
#endif
Tdev=(326.85+273.15);
}
}
#if defined(_DERIVATE)
VT_Vtnode_GND=((1.3806503e-23*Tdev_Vtnode_GND)/1.602176462e-19);
#endif
VT=((1.3806503e-23*Tdev)/1.602176462e-19);
#if defined(_DERIVATE)
dT_Vtnode_GND=Tdev_Vtnode_GND;
#endif
dT=(Tdev-Tnom);
#if defined(_DERIVATE)
qtt0_Vtnode_GND=(Tdev_Vtnode_GND/Tnom);
#endif
qtt0=(Tdev/Tnom);
{
double m00_logE(d00_logE0,qtt0)
#if defined(_DERIVATE)
double m10_logE(d10_logE0,d00_logE0,qtt0)
#endif
#if defined(_DERIVATE)
ln_qtt0_Vtnode_GND=qtt0_Vtnode_GND*d10_logE0;
#endif
ln_qtt0=d00_logE0;
}
{
double m00_logE(d00_logE0,Tdev)
#if defined(_DERIVATE)
double m10_logE(d10_logE0,d00_logE0,Tdev)
#endif
#if defined(_DERIVATE)
k1_Vtnode_GND=(((f1vg*Tdev_Vtnode_GND)*d00_logE0)+((f1vg*Tdev)*Tdev_Vtnode_GND*d10_logE0));
#endif
k1=((f1vg*Tdev)*d00_logE0);
}
#if defined(_DERIVATE)
k2_Vtnode_GND=(f2vg*Tdev_Vtnode_GND);
#endif
k2=(f2vg*Tdev);
#if defined(_DERIVATE)
vgb_t_Vtnode_GND=(k1_Vtnode_GND+k2_Vtnode_GND);
#endif
vgb_t=((vgb+k1)+k2);
#if defined(_DERIVATE)
vge_t_Vtnode_GND=(k1_Vtnode_GND+k2_Vtnode_GND);
#endif
vge_t=((vge+k1)+k2);
#if defined(_DERIVATE)
vgbe_t_Vtnode_GND=((vgb_t_Vtnode_GND+vge_t_Vtnode_GND)/2);
#endif
vgbe_t=((vgb_t+vge_t)/2);
if
((cjei0>0.0))
{
{
double m00_exp(d00_exp0,((vdei*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vdei)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#if defined(_DERIVATE)
vdjt_Vtnode_GND=(((vdj0*qtt0_Vtnode_GND)+(vgbe0*(-qtt0_Vtnode_GND)))-(((mg*VT_Vtnode_GND)*ln_qtt0)+((mg*VT)*ln_qtt0_Vtnode_GND)));
#endif
vdjt=(((vdj0*qtt0)+(vgbe0*(1-qtt0)))-((mg*VT)*ln_qtt0));
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
double m10_sqrt(d10_sqrt1,d00_sqrt1,(1+(4*d00_exp0)))
double m10_logE(d10_logE2,d00_logE2,(0.5*(1+d00_sqrt1)))
#endif
#if defined(_DERIVATE)
vdt_Vtnode_GND=(vdjt_Vtnode_GND+(((2*VT_Vtnode_GND)*d00_logE2)+((2*VT)*(0.5*(4*(((-vdjt_Vtnode_GND)*VT-(-vdjt)*VT_Vtnode_GND)/VT/VT)*d10_exp0)*d10_sqrt1)*d10_logE2)));
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#if defined(_DERIVATE)
vdei_t_Vtnode_GND=vdt_Vtnode_GND;
#endif
vdei_t=vdt;
{
double m00_logE(d00_logE0,(vdei/vdei_t))
double m00_exp(d00_exp1,(zei*d00_logE0))
#if defined(_DERIVATE)
double m10_logE(d10_logE0,d00_logE0,(vdei/vdei_t))
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATE)
cjei0_t_Vtnode_GND=(cjei0*(zei*(-vdei*vdei_t_Vtnode_GND/vdei_t/vdei_t)*d10_logE0)*d10_exp1);
#endif
cjei0_t=(cjei0*d00_exp1);
}
if
((1==1))
{
#if defined(_DERIVATE)
ajei_t_Vtnode_GND=((ajei*vdei_t_Vtnode_GND)/vdei);
#endif
ajei_t=((ajei*vdei_t)/vdei);
}
else
{
#if defined(_DERIVATE)
ajei_t_Vtnode_GND=0.0;
#endif
ajei_t=ajei;
}
}
else
{
#if defined(_DERIVATE)
cjei0_t_Vtnode_GND=0.0;
#endif
cjei0_t=cjei0;
#if defined(_DERIVATE)
vdei_t_Vtnode_GND=0.0;
#endif
vdei_t=vdei;
#if defined(_DERIVATE)
ajei_t_Vtnode_GND=0.0;
#endif
ajei_t=ajei;
}
if
(((flcomp==0.0)||(flcomp==2.1)))
{
#if defined(_DERIVATE)
V_gT_Vtnode_GND=((((3.0*VT_Vtnode_GND)*ln_qtt0)+((3.0*VT)*ln_qtt0_Vtnode_GND))+(vgb*qtt0_Vtnode_GND));
#endif
V_gT=(((3.0*VT)*ln_qtt0)+(vgb*(qtt0-1.0)));
#if defined(_DERIVATE)
r_VgVT_Vtnode_GND=((V_gT_Vtnode_GND*VT-V_gT*VT_Vtnode_GND)/VT/VT);
#endif
r_VgVT=(V_gT/VT);
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(((mcf*r_VgVT_Vtnode_GND)/mbei)-(alb*dT_Vtnode_GND));
#endif
#endif
a=(((mcf*r_VgVT)/mbei)-(alb*dT));
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ibeis_t_Vtnode_GND=(ibeis*a_Vtnode_GND*d10_exp0);
#endif
ibeis_t=(ibeis*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(((mcf*r_VgVT_Vtnode_GND)/mrei)-(alb*dT_Vtnode_GND));
#endif
#endif
a=(((mcf*r_VgVT)/mrei)-(alb*dT));
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ireis_t_Vtnode_GND=(ireis*a_Vtnode_GND*d10_exp0);
#endif
ireis_t=(ireis*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(((mcf*r_VgVT_Vtnode_GND)/mbep)-(alb*dT_Vtnode_GND));
#endif
#endif
a=(((mcf*r_VgVT)/mbep)-(alb*dT));
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ibeps_t_Vtnode_GND=(ibeps*a_Vtnode_GND*d10_exp0);
#endif
ibeps_t=(ibeps*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(((mcf*r_VgVT_Vtnode_GND)/mrep)-(alb*dT_Vtnode_GND));
#endif
#endif
a=(((mcf*r_VgVT)/mrep)-(alb*dT));
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ireps_t_Vtnode_GND=(ireps*a_Vtnode_GND*d10_exp0);
#endif
ireps_t=(ireps*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(r_VgVT_Vtnode_GND/mbci);
#endif
#endif
a=(r_VgVT/mbci);
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ibcis_t_Vtnode_GND=(ibcis*a_Vtnode_GND*d10_exp0);
#endif
ibcis_t=(ibcis*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(r_VgVT_Vtnode_GND/mbcx);
#endif
#endif
a=(r_VgVT/mbcx);
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ibcxs_t_Vtnode_GND=(ibcxs*a_Vtnode_GND*d10_exp0);
#endif
ibcxs_t=(ibcxs*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(r_VgVT_Vtnode_GND/msf);
#endif
#endif
a=(r_VgVT/msf);
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
itss_t_Vtnode_GND=(itss*a_Vtnode_GND*d10_exp0);
#endif
itss_t=(itss*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(r_VgVT_Vtnode_GND/msc);
#endif
#endif
a=(r_VgVT/msc);
{
double m00_exp(d00_exp0,a)
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
iscs_t_Vtnode_GND=(iscs*a_Vtnode_GND*d10_exp0);
#endif
iscs_t=(iscs*d00_exp0);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(vdei_t_Vtnode_GND/vdei);
#endif
#endif
a=(vdei_t/vdei);
#if defined(_DERIVATE)
qp0_t_Vtnode_GND=(qp0*((0.5*zei)*(-a_Vtnode_GND)));
#endif
qp0_t=(qp0*(1.0+((0.5*zei)*(1.0-a))));
{
double m00_exp(d00_exp0,(zetaci*ln_qtt0))
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(((vlim*(-(alvs*dT_Vtnode_GND)))*d00_exp0)+((vlim*(1.0-(alvs*dT)))*(zetaci*ln_qtt0_Vtnode_GND)*d10_exp0));
#endif
#endif
a=((vlim*(1.0-(alvs*dT)))*d00_exp0);
}
#if defined(_DERIVATE)
k_Vtnode_GND=(((a_Vtnode_GND-VT_Vtnode_GND)*VT-(a-VT)*VT_Vtnode_GND)/VT/VT);
#endif
k=((a-VT)/VT);
if
((k<11.0))
{
{
double m00_exp(d00_exp0,k)
double m00_logE(d00_logE1,(1.0+d00_exp0))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
double m10_logE(d10_logE1,d00_logE1,(1.0+d00_exp0))
#endif
#if defined(_DERIVATE)
vlim_t_Vtnode_GND=(VT_Vtnode_GND+((VT_Vtnode_GND*d00_logE1)+(VT*k_Vtnode_GND*d10_exp0*d10_logE1)));
#endif
vlim_t=(VT+(VT*d00_logE1));
}
}
else
{
#if defined(_DERIVATE)
vlim_t_Vtnode_GND=a_Vtnode_GND;
#endif
vlim_t=a;
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(alb*dT_Vtnode_GND);
#endif
#endif
a=(1.0+(alb*dT));
{
double m00_sqrt(d00_sqrt0,((a*a)+0.01))
#if defined(_DERIVATE)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((a*a)+0.01))
#endif
#if defined(_DERIVATE)
k_Vtnode_GND=(0.5*(a_Vtnode_GND+((a_Vtnode_GND*a)+(a*a_Vtnode_GND))*d10_sqrt0));
#endif
k=(0.5*(a+d00_sqrt0));
}
#if defined(_DERIVATE)
tef0_t_Vtnode_GND=(((tef0*qtt0_Vtnode_GND)*k-(tef0*qtt0)*k_Vtnode_GND)/k/k);
#endif
tef0_t=((tef0*qtt0)/k);
}
else
{
{
double m00_exp(d00_exp0,((zetabet*ln_qtt0)+((vge/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ibeis_t_Vtnode_GND=(ibeis*((zetabet*ln_qtt0_Vtnode_GND)+(((-vge*VT_Vtnode_GND/VT/VT)*(qtt0-1))+((vge/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
ibeis_t=(ibeis*d00_exp0);
}
{
double m00_exp(d00_exp0,(((0.5*mg)*ln_qtt0)+(((0.5*vgbe0)/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ireis_t_Vtnode_GND=(ireis*(((0.5*mg)*ln_qtt0_Vtnode_GND)+(((-(0.5*vgbe0)*VT_Vtnode_GND/VT/VT)*(qtt0-1))+(((0.5*vgbe0)/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
ireis_t=(ireis*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetabet*ln_qtt0)+((vge/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ibeps_t_Vtnode_GND=(ibeps*((zetabet*ln_qtt0_Vtnode_GND)+(((-vge*VT_Vtnode_GND/VT/VT)*(qtt0-1))+((vge/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
ibeps_t=(ibeps*d00_exp0);
}
{
double m00_exp(d00_exp0,(((0.5*mg)*ln_qtt0)+(((0.5*vgbe0)/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ireps_t_Vtnode_GND=(ireps*(((0.5*mg)*ln_qtt0_Vtnode_GND)+(((-(0.5*vgbe0)*VT_Vtnode_GND/VT/VT)*(qtt0-1))+(((0.5*vgbe0)/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
ireps_t=(ireps*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetabci*ln_qtt0)+((vgc/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ibcis_t_Vtnode_GND=(ibcis*((zetabci*ln_qtt0_Vtnode_GND)+(((-vgc*VT_Vtnode_GND/VT/VT)*(qtt0-1))+((vgc/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
ibcis_t=(ibcis*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetabcxt*ln_qtt0)+((vgc/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
ibcxs_t_Vtnode_GND=(ibcxs*((zetabcxt*ln_qtt0_Vtnode_GND)+(((-vgc*VT_Vtnode_GND/VT/VT)*(qtt0-1))+((vgc/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
ibcxs_t=(ibcxs*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetasct*ln_qtt0)+((vgc/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
itss_t_Vtnode_GND=(itss*((zetasct*ln_qtt0_Vtnode_GND)+(((-vgc*VT_Vtnode_GND/VT/VT)*(qtt0-1))+((vgc/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
itss_t=(itss*d00_exp0);
}
{
double m00_exp(d00_exp0,((zetasct*ln_qtt0)+((vgs/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
iscs_t_Vtnode_GND=(iscs*((zetasct*ln_qtt0_Vtnode_GND)+(((-vgs*VT_Vtnode_GND/VT/VT)*(qtt0-1))+((vgs/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
iscs_t=(iscs*d00_exp0);
}
{
double m00_logE(d00_logE0,(vdei_t/vdei))
double m00_exp(d00_exp1,(zei*d00_logE0))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(vdei_t/vdei))
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=0.0;
  a_Vci_ei_Vbi_ci=0.0;
  a_Vci_ei_Vci_ei=0.0;
  a_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(zei*(vdei_t_Vtnode_GND/vdei)*d10_logE0)*d10_exp1;
#endif
#endif
a=d00_exp1;
}
#if defined(_DERIVATE)
qp0_t_Vtnode_GND=(qp0*(-a_Vtnode_GND));
#endif
qp0_t=(qp0*(2.0-a));
{
double m00_exp(d00_exp0,((zetaci-avs)*ln_qtt0))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
vlim_t_Vtnode_GND=(vlim*((zetaci-avs)*ln_qtt0_Vtnode_GND)*d10_exp0);
#endif
vlim_t=(vlim*d00_exp0);
}
zetatef=((zetabet-zetact)-0.5);
dvg0=(vgb-vge);
{
double m00_exp(d00_exp0,((zetatef*ln_qtt0)-((dvg0/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
tef0_t_Vtnode_GND=(tef0*((zetatef*ln_qtt0_Vtnode_GND)-(((-dvg0*VT_Vtnode_GND/VT/VT)*(qtt0-1))+((dvg0/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
tef0_t=(tef0*d00_exp0);
}
}
{
double m00_exp(d00_exp0,((zetact*ln_qtt0)+((vgb/VT)*(qtt0-1))))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
c10_t_Vtnode_GND=(c10*((zetact*ln_qtt0_Vtnode_GND)+(((-vgb*VT_Vtnode_GND/VT/VT)*(qtt0-1))+((vgb/VT)*qtt0_Vtnode_GND)))*d10_exp0);
#endif
c10_t=(c10*d00_exp0);
}
{
double m00_exp(d00_exp0,(zetaci*ln_qtt0))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
rci0_t_Vtnode_GND=(rci0*(zetaci*ln_qtt0_Vtnode_GND)*d10_exp0);
#endif
rci0_t=(rci0*d00_exp0);
}
#if defined(_DERIVATE)
vces_t_Vtnode_GND=(vces*(alces*dT_Vtnode_GND));
#endif
vces_t=(vces*(1+(alces*dT)));
if
((cjci0>0.0))
{
{
double m00_exp(d00_exp0,((vdci*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vdci)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#if defined(_DERIVATE)
vdjt_Vtnode_GND=(((vdj0*qtt0_Vtnode_GND)+(vgbc0*(-qtt0_Vtnode_GND)))-(((mg*VT_Vtnode_GND)*ln_qtt0)+((mg*VT)*ln_qtt0_Vtnode_GND)));
#endif
vdjt=(((vdj0*qtt0)+(vgbc0*(1-qtt0)))-((mg*VT)*ln_qtt0));
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
double m10_sqrt(d10_sqrt1,d00_sqrt1,(1+(4*d00_exp0)))
double m10_logE(d10_logE2,d00_logE2,(0.5*(1+d00_sqrt1)))
#endif
#if defined(_DERIVATE)
vdt_Vtnode_GND=(vdjt_Vtnode_GND+(((2*VT_Vtnode_GND)*d00_logE2)+((2*VT)*(0.5*(4*(((-vdjt_Vtnode_GND)*VT-(-vdjt)*VT_Vtnode_GND)/VT/VT)*d10_exp0)*d10_sqrt1)*d10_logE2)));
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#if defined(_DERIVATE)
vdci_t_Vtnode_GND=vdt_Vtnode_GND;
#endif
vdci_t=vdt;
{
double m00_logE(d00_logE0,(vdci/vdci_t))
double m00_exp(d00_exp1,(zci*d00_logE0))
#if defined(_DERIVATE)
double m10_logE(d10_logE0,d00_logE0,(vdci/vdci_t))
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATE)
cjci0_t_Vtnode_GND=(cjci0*(zci*(-vdci*vdci_t_Vtnode_GND/vdci_t/vdci_t)*d10_logE0)*d10_exp1);
#endif
cjci0_t=(cjci0*d00_exp1);
}
if
((0==1))
{
#if defined(_DERIVATE)
vptci_t_Vtnode_GND=((vptci*vdci_t_Vtnode_GND)/vdci);
#endif
vptci_t=((vptci*vdci_t)/vdci);
}
else
{
#if defined(_DERIVATE)
vptci_t_Vtnode_GND=0.0;
#endif
vptci_t=vptci;
}
}
else
{
#if defined(_DERIVATE)
cjci0_t_Vtnode_GND=0.0;
#endif
cjci0_t=cjci0;
#if defined(_DERIVATE)
vdci_t_Vtnode_GND=0.0;
#endif
vdci_t=vdci;
#if defined(_DERIVATE)
vptci_t_Vtnode_GND=0.0;
#endif
vptci_t=vptci;
}
#if defined(_DERIVATE)
t0_t_Vtnode_GND=(t0*((alt0*dT_Vtnode_GND)+(((kt0*dT_Vtnode_GND)*dT)+((kt0*dT)*dT_Vtnode_GND))));
#endif
t0_t=(t0*((1+(alt0*dT))+((kt0*dT)*dT)));
{
double m00_exp(d00_exp0,((zetaci-1)*ln_qtt0))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
thcs_t_Vtnode_GND=(thcs*((zetaci-1)*ln_qtt0_Vtnode_GND)*d10_exp0);
#endif
thcs_t=(thcs*d00_exp0);
}
{
double m00_exp(d00_exp0,(alfav*dT))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
favl_t_Vtnode_GND=(favl*(alfav*dT_Vtnode_GND)*d10_exp0);
#endif
favl_t=(favl*d00_exp0);
}
{
double m00_exp(d00_exp0,(alqav*dT))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
qavl_t_Vtnode_GND=(qavl*(alqav*dT_Vtnode_GND)*d10_exp0);
#endif
qavl_t=(qavl*d00_exp0);
}
{
double m00_exp(d00_exp0,(zetarbi*ln_qtt0))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
rbi0_t_Vtnode_GND=(rbi0*(zetarbi*ln_qtt0_Vtnode_GND)*d10_exp0);
#endif
rbi0_t=(rbi0*d00_exp0);
}
if
((cjep0>0.0))
{
{
double m00_exp(d00_exp0,((vdep*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vdep)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#if defined(_DERIVATE)
vdjt_Vtnode_GND=(((vdj0*qtt0_Vtnode_GND)+(vgbe0*(-qtt0_Vtnode_GND)))-(((mg*VT_Vtnode_GND)*ln_qtt0)+((mg*VT)*ln_qtt0_Vtnode_GND)));
#endif
vdjt=(((vdj0*qtt0)+(vgbe0*(1-qtt0)))-((mg*VT)*ln_qtt0));
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
double m10_sqrt(d10_sqrt1,d00_sqrt1,(1+(4*d00_exp0)))
double m10_logE(d10_logE2,d00_logE2,(0.5*(1+d00_sqrt1)))
#endif
#if defined(_DERIVATE)
vdt_Vtnode_GND=(vdjt_Vtnode_GND+(((2*VT_Vtnode_GND)*d00_logE2)+((2*VT)*(0.5*(4*(((-vdjt_Vtnode_GND)*VT-(-vdjt)*VT_Vtnode_GND)/VT/VT)*d10_exp0)*d10_sqrt1)*d10_logE2)));
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#if defined(_DERIVATE)
vdep_t_Vtnode_GND=vdt_Vtnode_GND;
#endif
vdep_t=vdt;
{
double m00_logE(d00_logE0,(vdep/vdep_t))
double m00_exp(d00_exp1,(zep*d00_logE0))
#if defined(_DERIVATE)
double m10_logE(d10_logE0,d00_logE0,(vdep/vdep_t))
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATE)
cjep0_t_Vtnode_GND=(cjep0*(zep*(-vdep*vdep_t_Vtnode_GND/vdep_t/vdep_t)*d10_logE0)*d10_exp1);
#endif
cjep0_t=(cjep0*d00_exp1);
}
if
((1==1))
{
#if defined(_DERIVATE)
ajep_t_Vtnode_GND=((ajep*vdep_t_Vtnode_GND)/vdep);
#endif
ajep_t=((ajep*vdep_t)/vdep);
}
else
{
#if defined(_DERIVATE)
ajep_t_Vtnode_GND=0.0;
#endif
ajep_t=ajep;
}
}
else
{
#if defined(_DERIVATE)
cjep0_t_Vtnode_GND=0.0;
#endif
cjep0_t=cjep0;
#if defined(_DERIVATE)
vdep_t_Vtnode_GND=0.0;
#endif
vdep_t=vdep;
#if defined(_DERIVATE)
ajep_t_Vtnode_GND=0.0;
#endif
ajep_t=ajep;
}
if
(((BP(bp,ei)<0.0)||(BP(bi,ei)<0.0)))
{
double a_eg;
double ab;
double aa;
#if defined(_DERIVATE)
double a_eg_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double ab_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double aa_Vtnode_GND;
#endif
#if defined(_DERIVATE)
ab_Vtnode_GND=0.0;
#endif
ab=1.0;
#if defined(_DERIVATE)
aa_Vtnode_GND=0.0;
#endif
aa=1.0;
#if defined(_DERIVATE)
a_eg_Vtnode_GND=(-vgbe_t0*vgbe_t_Vtnode_GND/vgbe_t/vgbe_t);
#endif
a_eg=(vgbe_t0/vgbe_t);
if
((((tunode==1)&&(cjep0>0.0))&&(vdep>0.0)))
{
{
double m00_sqrt(d00_sqrt0,a_eg)
#if defined(_DERIVATE)
double m10_sqrt(d10_sqrt0,d00_sqrt0,a_eg)
#endif
#if defined(_DERIVATE)
ab_Vtnode_GND=((((((((cjep0_t_Vtnode_GND/cjep0)*d00_sqrt0)+((cjep0_t/cjep0)*a_eg_Vtnode_GND*d10_sqrt0))*vdep_t)+(((cjep0_t/cjep0)*d00_sqrt0)*vdep_t_Vtnode_GND))*vdep_t)+((((cjep0_t/cjep0)*d00_sqrt0)*vdep_t)*vdep_t_Vtnode_GND))/(vdep*vdep));
#endif
ab=(((((cjep0_t/cjep0)*d00_sqrt0)*vdep_t)*vdep_t)/(vdep*vdep));
}
{
double m00_pow(d00_pow0,a_eg,(-1.5))
#if defined(_DERIVATE)
double m10_pow(d10_pow0,d00_pow0,a_eg,(-1.5))
#endif
#if defined(_DERIVATE)
aa_Vtnode_GND=(((((-vdep*vdep_t_Vtnode_GND/vdep_t/vdep_t)*(cjep0/cjep0_t))+((vdep/vdep_t)*(-cjep0*cjep0_t_Vtnode_GND/cjep0_t/cjep0_t)))*d00_pow0)+(((vdep/vdep_t)*(cjep0/cjep0_t))*(d10_pow0*a_eg_Vtnode_GND)));
#endif
aa=(((vdep/vdep_t)*(cjep0/cjep0_t))*d00_pow0);
}
}
else
{
if
((((tunode==0)&&(cjei0>0.0))&&(vdei>0.0)))
{
{
double m00_sqrt(d00_sqrt0,a_eg)
#if defined(_DERIVATE)
double m10_sqrt(d10_sqrt0,d00_sqrt0,a_eg)
#endif
#if defined(_DERIVATE)
ab_Vtnode_GND=((((((((cjei0_t_Vtnode_GND/cjei0)*d00_sqrt0)+((cjei0_t/cjei0)*a_eg_Vtnode_GND*d10_sqrt0))*vdei_t)+(((cjei0_t/cjei0)*d00_sqrt0)*vdei_t_Vtnode_GND))*vdei_t)+((((cjei0_t/cjei0)*d00_sqrt0)*vdei_t)*vdei_t_Vtnode_GND))/(vdei*vdei));
#endif
ab=(((((cjei0_t/cjei0)*d00_sqrt0)*vdei_t)*vdei_t)/(vdei*vdei));
}
{
double m00_pow(d00_pow0,a_eg,(-1.5))
#if defined(_DERIVATE)
double m10_pow(d10_pow0,d00_pow0,a_eg,(-1.5))
#endif
#if defined(_DERIVATE)
aa_Vtnode_GND=(((((-vdei*vdei_t_Vtnode_GND/vdei_t/vdei_t)*(cjei0/cjei0_t))+((vdei/vdei_t)*(-cjei0*cjei0_t_Vtnode_GND/cjei0_t/cjei0_t)))*d00_pow0)+(((vdei/vdei_t)*(cjei0/cjei0_t))*(d10_pow0*a_eg_Vtnode_GND)));
#endif
aa=(((vdei/vdei_t)*(cjei0/cjei0_t))*d00_pow0);
}
}
}
#if defined(_DERIVATE)
ibets_t_Vtnode_GND=(ibets*ab_Vtnode_GND);
#endif
ibets_t=(ibets*ab);
#if defined(_DERIVATE)
abet_t_Vtnode_GND=(abet*aa_Vtnode_GND);
#endif
abet_t=(abet*aa);
}
#ifdef _DYNAMIC
if
((1.0>0.0))
{
#if defined(_DYNAMIC)
{
double m00_exp(d00_exp0,((vdcx*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vdcx)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vdjt_Vtnode_GND=(((vdj0*qtt0_Vtnode_GND)+(vgbc0*(-qtt0_Vtnode_GND)))-(((mg*VT_Vtnode_GND)*ln_qtt0)+((mg*VT)*ln_qtt0_Vtnode_GND)));
#endif
vdjt=(((vdj0*qtt0)+(vgbc0*(1-qtt0)))-((mg*VT)*ln_qtt0));
#endif
#if defined(_DYNAMIC)
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
double m10_sqrt(d10_sqrt1,d00_sqrt1,(1+(4*d00_exp0)))
double m10_logE(d10_logE2,d00_logE2,(0.5*(1+d00_sqrt1)))
#endif
#if defined(_DERIVATE)
vdt_Vtnode_GND=(vdjt_Vtnode_GND+(((2*VT_Vtnode_GND)*d00_logE2)+((2*VT)*(0.5*(4*(((-vdjt_Vtnode_GND)*VT-(-vdjt)*VT_Vtnode_GND)/VT/VT)*d10_exp0)*d10_sqrt1)*d10_logE2)));
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vdcx_t_Vtnode_GND=vdt_Vtnode_GND;
#endif
vdcx_t=vdt;
#endif
#if defined(_DYNAMIC)
{
double m00_logE(d00_logE0,(vdcx/vdcx_t))
double m00_exp(d00_exp1,(zcx*d00_logE0))
#if defined(_DERIVATE)
double m10_logE(d10_logE0,d00_logE0,(vdcx/vdcx_t))
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATE)
cratio_t_Vtnode_GND=(1.0*(zcx*(-vdcx*vdcx_t_Vtnode_GND/vdcx_t/vdcx_t)*d10_logE0)*d10_exp1);
#endif
cratio_t=(1.0*d00_exp1);
}
#endif
#ifdef _DYNAMIC
if
((0==1))
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vptcx_t_Vtnode_GND=((vptcx*vdcx_t_Vtnode_GND)/vdcx);
#endif
vptcx_t=((vptcx*vdcx_t)/vdcx);
#endif
}
else
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vptcx_t_Vtnode_GND=0.0;
#endif
vptcx_t=vptcx;
#endif
}
#endif /* if (...) */
}
else
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
cratio_t_Vtnode_GND=0.0;
#endif
cratio_t=1.0;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vdcx_t_Vtnode_GND=0.0;
#endif
vdcx_t=vdcx;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vptcx_t_Vtnode_GND=0.0;
#endif
vptcx_t=vptcx;
#endif
}
#endif /* if (...) */
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
cjcx01_t_Vtnode_GND=cratio_t_Vtnode_GND*cjcx01;
#endif
cjcx01_t=(cratio_t*cjcx01);
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
cjcx02_t_Vtnode_GND=cratio_t_Vtnode_GND*cjcx02;
#endif
cjcx02_t=(cratio_t*cjcx02);
#endif
{
double m00_exp(d00_exp0,(zetarcx*ln_qtt0))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
rcx_t_Vtnode_GND=(rcx*(zetarcx*ln_qtt0_Vtnode_GND)*d10_exp0);
#endif
rcx_t=(rcx*d00_exp0);
}
{
double m00_exp(d00_exp0,(zetarbx*ln_qtt0))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
rbx_t_Vtnode_GND=(rbx*(zetarbx*ln_qtt0_Vtnode_GND)*d10_exp0);
#endif
rbx_t=(rbx*d00_exp0);
}
{
double m00_exp(d00_exp0,(zetare*ln_qtt0))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
re_t_Vtnode_GND=(re*(zetare*ln_qtt0_Vtnode_GND)*d10_exp0);
#endif
re_t=(re*d00_exp0);
}
#if defined(_DYNAMIC)
{
double m00_exp(d00_exp0,((zetacx-1.0)*ln_qtt0))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATE)
tsf_t_Vtnode_GND=(tsf*((zetacx-1.0)*ln_qtt0_Vtnode_GND)*d10_exp0);
#endif
tsf_t=(tsf*d00_exp0);
}
#endif
#ifdef _DYNAMIC
if
((cjs0>0.0))
{
#if defined(_DYNAMIC)
{
double m00_exp(d00_exp0,((vds*0.5)/vt0))
double m00_exp(d00_exp1,(((-0.5)*vds)/vt0))
double m00_logE(d00_logE2,(d00_exp0-d00_exp1))
vdj0=((2*vt0)*d00_logE2);
}
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vdjt_Vtnode_GND=(((vdj0*qtt0_Vtnode_GND)+(vgsc0*(-qtt0_Vtnode_GND)))-(((mg*VT_Vtnode_GND)*ln_qtt0)+((mg*VT)*ln_qtt0_Vtnode_GND)));
#endif
vdjt=(((vdj0*qtt0)+(vgsc0*(1-qtt0)))-((mg*VT)*ln_qtt0));
#endif
#if defined(_DYNAMIC)
{
double m00_exp(d00_exp0,((-vdjt)/VT))
double m00_sqrt(d00_sqrt1,(1+(4*d00_exp0)))
double m00_logE(d00_logE2,(0.5*(1+d00_sqrt1)))
#if defined(_DERIVATE)
#define d10_exp0 d00_exp0
double m10_sqrt(d10_sqrt1,d00_sqrt1,(1+(4*d00_exp0)))
double m10_logE(d10_logE2,d00_logE2,(0.5*(1+d00_sqrt1)))
#endif
#if defined(_DERIVATE)
vdt_Vtnode_GND=(vdjt_Vtnode_GND+(((2*VT_Vtnode_GND)*d00_logE2)+((2*VT)*(0.5*(4*(((-vdjt_Vtnode_GND)*VT-(-vdjt)*VT_Vtnode_GND)/VT/VT)*d10_exp0)*d10_sqrt1)*d10_logE2)));
#endif
vdt=(vdjt+((2*VT)*d00_logE2));
}
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vds_t_Vtnode_GND=vdt_Vtnode_GND;
#endif
vds_t=vdt;
#endif
#if defined(_DYNAMIC)
{
double m00_logE(d00_logE0,(vds/vds_t))
double m00_exp(d00_exp1,(zs*d00_logE0))
#if defined(_DERIVATE)
double m10_logE(d10_logE0,d00_logE0,(vds/vds_t))
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATE)
cjs0_t_Vtnode_GND=(cjs0*(zs*(-vds*vds_t_Vtnode_GND/vds_t/vds_t)*d10_logE0)*d10_exp1);
#endif
cjs0_t=(cjs0*d00_exp1);
}
#endif
#ifdef _DYNAMIC
if
((0==1))
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vpts_t_Vtnode_GND=((vpts*vds_t_Vtnode_GND)/vds);
#endif
vpts_t=((vpts*vds_t)/vds);
#endif
}
else
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vpts_t_Vtnode_GND=0.0;
#endif
vpts_t=vpts;
#endif
}
#endif /* if (...) */
}
else
{
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
cjs0_t_Vtnode_GND=0.0;
#endif
cjs0_t=cjs0;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vds_t_Vtnode_GND=0.0;
#endif
vds_t=vds;
#endif
#if defined(_DYNAMIC)
#if defined(_DERIVATE)
vpts_t_Vtnode_GND=0.0;
#endif
vpts_t=vpts;
#endif
}
#endif /* if (...) */
}
{
if
((flnqs!=0))
{
#if defined(_DERIVATE)
Vxf1_Vxf1_GND=1.0;
#endif
Vxf1=NP(xf1);
#if defined(_DERIVATE)
Vxf2_Vxf2_GND=1.0;
#endif
Vxf2=NP(xf2);
#if defined(_DERIVATE)
Vxf3_Vxf3_GND=1.0;
#endif
Vxf3=NP(xf3);
#if defined(_DERIVATE)
Vxf4_Vxf4_GND=1.0;
#endif
Vxf4=NP(xf4);
}
#if defined(_DERIVATE)
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=(1/(mbei*VT));
DIOY_Vtnode_GND=(-BP(bi,ei)*(mbei*VT_Vtnode_GND)/(mbei*VT)/(mbei*VT));
#endif
DIOY=(BP(bi,ei)/(mbei*VT));
if
((ibeis>0.0))
{
if
((DIOY>80.0))
{
#if defined(_DERIVATE)
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=DIOY_Vbi_ei;
le_Vtnode_GND=DIOY_Vtnode_GND;
#endif
le=(1+(DIOY-80.0));
#if defined(_DERIVATE)
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
DIOY_Vtnode_GND=0.0;
#endif
DIOY=80.0;
}
else
{
#if defined(_DERIVATE)
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=0.0;
le_Vtnode_GND=0.0;
#endif
le=1;
}
{
double m00_limexp(d00_limexp0,DIOY)
#if defined(_DERIVATE)
double m10_limexp(d10_limexp0,d00_limexp0,DIOY)
#endif
#if defined(_DERIVATE)
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=((le_Vbi_ei*d00_limexp0)+(le*DIOY_Vbi_ei*d10_limexp0));
le_Vtnode_GND=((le_Vtnode_GND*d00_limexp0)+(le*DIOY_Vtnode_GND*d10_limexp0));
#endif
le=(le*d00_limexp0);
}
#if defined(_DERIVATE)
ibei_Vtnode_GND=((ibeis_t_Vtnode_GND*(le-1.0))+(ibeis_t*le_Vtnode_GND));
ibei_Vbi_ei=(ibeis_t*le_Vbi_ei);
#endif
ibei=(ibeis_t*(le-1.0));
if
((DIOY<=(-14.0)))
{
#if defined(_DERIVATE)
ibei_Vtnode_GND=(-ibeis_t_Vtnode_GND);
ibei_Vbi_ei=0.0;
#endif
ibei=(-ibeis_t);
}
}
else
{
#if defined(_DERIVATE)
ibei_Vtnode_GND=0.0;
ibei_Vbi_ei=0.0;
#endif
ibei=0.0;
}
#if defined(_DERIVATE)
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=(1/(mrei*VT));
DIOY_Vtnode_GND=(-BP(bi,ei)*(mrei*VT_Vtnode_GND)/(mrei*VT)/(mrei*VT));
#endif
DIOY=(BP(bi,ei)/(mrei*VT));
if
((ireis>0.0))
{
if
((DIOY>80.0))
{
#if defined(_DERIVATE)
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=DIOY_Vbi_ei;
le_Vtnode_GND=DIOY_Vtnode_GND;
#endif
le=(1+(DIOY-80.0));
#if defined(_DERIVATE)
DIOY_Vsi_ci=0.0;
DIOY_Vbp_ci=0.0;
DIOY_Vbp_ei=0.0;
DIOY_Vbi_ci=0.0;
DIOY_Vbi_ei=0.0;
DIOY_Vtnode_GND=0.0;
#endif
DIOY=80.0;
}
else
{
#if defined(_DERIVATE)
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=0.0;
le_Vtnode_GND=0.0;
#endif
le=1;
}
{
double m00_limexp(d00_limexp0,DIOY)
#if defined(_DERIVATE)
double m10_limexp(d10_limexp0,d00_limexp0,DIOY)
#endif
#if defined(_DERIVATE)
le_Vsi_ci=0.0;
le_Vbp_ci=0.0;
le_Vbp_ei=0.0;
le_Vbi_ci=0.0;
le_Vbi_ei=((le_Vbi_ei*d00_limexp0)+(le*DIOY_Vbi_ei*d10_limexp0));
le_Vtnode_GND=((le_Vtnode_GND*d00_limexp0)+(le*DIOY_Vtnode_GND*d10_limexp0));
#endif
le=(le*d00_limexp0);
}
#if defined(_DERIVATE)
irei_Vtnode_GND=((ireis_t_Vtnode_GND*(le-1.0))+(ireis_t*le_Vtnode_GND));
irei_Vbi_ei=(ireis_t*le_Vbi_ei);
#endif
irei=(ireis_t*(le-1.0));
if
((DIOY<=(-14.0)))
{
#if defined(_DERIVATE)
irei_Vtnode_GND=(-ireis_t_Vtnode_GND);
irei_Vbi_ei=0.0;
#endif
irei=(-ireis_t);
}
}
else
{
#if defined(_DERIVATE)
irei_Vtnode_GND=0.0;
irei_Vbi_ei=0.0;
#endif
irei=0.0;
}
#if defined(_DERIVATE)
Orci0_t_Vtnode_GND=(-rci0_t_Vtnode_GND/rci0_t/rci0_t);
#endif
Orci0_t=(1.0/rci0_t);
Tr=tr;
#if defined(_DERIVATE)
VT_f_Vtnode_GND=(mcf*VT_Vtnode_GND);
#endif
VT_f=(mcf*VT);
{
double m00_limexp(d00_limexp0,(BP(bi,ei)/VT_f))
#if defined(_DERIVATEFORDDX)
double m10_limexp(d10_limexp0,d00_limexp0,(BP(bi,ei)/VT_f))
#endif
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
i_0f_Vtnode_GND=((c10_t_Vtnode_GND*d00_limexp0)+(c10_t*(-BP(bi,ei)*VT_f_Vtnode_GND/VT_f/VT_f)*d10_limexp0));
#endif
i_0f_Vbi_ei=(c10_t*(1/VT_f)*d10_limexp0);
#if defined(_DERIVATE)
  i_0f_Vbi_ei_Vtnode_GND=(+0.0*d00_limexp0+0.0*(-BP(bi,ei)*VT_f_Vtnode_GND/VT_f/VT_f)*d10_limexp0+c10_t_Vtnode_GND*(1/VT_f)*d10_limexp0+c10_t*(m20_limexp((BP(bi,ei)/VT_f))*(-BP(bi,ei)*VT_f_Vtnode_GND/VT_f/VT_f)*(1/VT_f)+d10_limexp0*(0.0/VT_f-(1.0*VT_f_Vtnode_GND+0.0*0.0+BP(bi,ei)*0.0)/VT_f/VT_f+2*BP(bi,ei)*0.0*VT_f_Vtnode_GND/VT_f/VT_f/VT_f)));
  i_0f_Vbi_ei_Vbi_ei=(+0.0*d00_limexp0+0.0*(1/VT_f)*d10_limexp0+0.0*(1/VT_f)*d10_limexp0+c10_t*(m20_limexp((BP(bi,ei)/VT_f))*(1/VT_f)*(1/VT_f)+d10_limexp0*(0.0/VT_f-(1.0*0.0+1.0*0.0+BP(bi,ei)*0.0)/VT_f/VT_f+2*BP(bi,ei)*0.0*0.0/VT_f/VT_f/VT_f)));
#endif
#endif
i_0f=(c10_t*d00_limexp0);
}
{
double m00_limexp(d00_limexp0,(BP(bi,ci)/VT))
#if defined(_DERIVATEFORDDX)
double m10_limexp(d10_limexp0,d00_limexp0,(BP(bi,ci)/VT))
#endif
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
i_0r_Vtnode_GND=((c10_t_Vtnode_GND*d00_limexp0)+(c10_t*(-BP(bi,ci)*VT_Vtnode_GND/VT/VT)*d10_limexp0));
#endif
i_0r_Vbi_ci=(c10_t*(1/VT)*d10_limexp0);
#if defined(_DERIVATE)
  i_0r_Vbi_ci_Vtnode_GND=(+0.0*d00_limexp0+0.0*(-BP(bi,ci)*VT_Vtnode_GND/VT/VT)*d10_limexp0+c10_t_Vtnode_GND*(1/VT)*d10_limexp0+c10_t*(m20_limexp((BP(bi,ci)/VT))*(-BP(bi,ci)*VT_Vtnode_GND/VT/VT)*(1/VT)+d10_limexp0*(0.0/VT-(1.0*VT_Vtnode_GND+0.0*0.0+BP(bi,ci)*0.0)/VT/VT+2*BP(bi,ci)*0.0*VT_Vtnode_GND/VT/VT/VT)));
  i_0r_Vbi_ci_Vbi_ci=(+0.0*d00_limexp0+0.0*(1/VT)*d10_limexp0+0.0*(1/VT)*d10_limexp0+c10_t*(m20_limexp((BP(bi,ci)/VT))*(1/VT)*(1/VT)+d10_limexp0*(0.0/VT-(1.0*0.0+1.0*0.0+BP(bi,ci)*0.0)/VT/VT+2*BP(bi,ci)*0.0*0.0/VT/VT/VT)));
#endif
#endif
i_0r=(c10_t*d00_limexp0);
}
if
((cjei0_t>0.0))
{
{
double m00_logE(d00_logE0,ajei_t)
double m00_exp(d00_exp1,((-d00_logE0)/zei))
#if defined(_DERIVATE)
double m10_logE(d10_logE0,d00_logE0,ajei_t)
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATE)
DFV_f_Vtnode_GND=((vdei_t_Vtnode_GND*(1.0-d00_exp1))+(vdei_t*(-((-ajei_t_Vtnode_GND*d10_logE0)/zei)*d10_exp1)));
#endif
DFV_f=(vdei_t*(1.0-d00_exp1));
}
#if defined(_DERIVATEFORDDX)
DFv_e_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFv_e_Vsi_ci_Vsi_ci=0.0;
  DFv_e_Vsi_ci_Vb_ci=0.0;
  DFv_e_Vsi_ci_Vbp_ci=0.0;
  DFv_e_Vsi_ci_Vbi_ci=0.0;
  DFv_e_Vsi_ci_Vtnode_GND=0.0;
  DFv_e_Vsi_ci_Vbi_ei=0.0;
#endif
DFv_e_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFv_e_Vb_ci_Vsi_ci=0.0;
  DFv_e_Vb_ci_Vb_ci=0.0;
  DFv_e_Vb_ci_Vbp_ci=0.0;
  DFv_e_Vb_ci_Vbi_ci=0.0;
  DFv_e_Vb_ci_Vtnode_GND=0.0;
  DFv_e_Vb_ci_Vbi_ei=0.0;
#endif
DFv_e_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFv_e_Vbp_ci_Vsi_ci=0.0;
  DFv_e_Vbp_ci_Vb_ci=0.0;
  DFv_e_Vbp_ci_Vbp_ci=0.0;
  DFv_e_Vbp_ci_Vbi_ci=0.0;
  DFv_e_Vbp_ci_Vtnode_GND=0.0;
  DFv_e_Vbp_ci_Vbi_ei=0.0;
#endif
DFv_e_Vbi_ci=0.0;
#if defined(_DERIVATE)
  DFv_e_Vbi_ci_Vsi_ci=0.0;
  DFv_e_Vbi_ci_Vb_ci=0.0;
  DFv_e_Vbi_ci_Vbp_ci=0.0;
  DFv_e_Vbi_ci_Vbi_ci=0.0;
  DFv_e_Vbi_ci_Vtnode_GND=0.0;
  DFv_e_Vbi_ci_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
DFv_e_Vtnode_GND=((DFV_f_Vtnode_GND*VT-(DFV_f-BP(bi,ei))*VT_Vtnode_GND)/VT/VT);
#endif
DFv_e_Vbi_ei=((-1.0)/VT);
#if defined(_DERIVATE)
  DFv_e_Vbi_ei_Vsi_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DFV_f-BP(bi,ei))*0.0)/VT/VT+2*(DFV_f-BP(bi,ei))*0.0*0.0/VT/VT/VT);
  DFv_e_Vbi_ei_Vb_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DFV_f-BP(bi,ei))*0.0)/VT/VT+2*(DFV_f-BP(bi,ei))*0.0*0.0/VT/VT/VT);
  DFv_e_Vbi_ei_Vbp_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DFV_f-BP(bi,ei))*0.0)/VT/VT+2*(DFV_f-BP(bi,ei))*0.0*0.0/VT/VT/VT);
  DFv_e_Vbi_ei_Vbi_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DFV_f-BP(bi,ei))*0.0)/VT/VT+2*(DFV_f-BP(bi,ei))*0.0*0.0/VT/VT/VT);
  DFv_e_Vbi_ei_Vtnode_GND=((+0.0-0.0)/VT-((-1.0)*VT_Vtnode_GND+DFV_f_Vtnode_GND*0.0+(DFV_f-BP(bi,ei))*0.0)/VT/VT+2*(DFV_f-BP(bi,ei))*0.0*VT_Vtnode_GND/VT/VT/VT);
  DFv_e_Vbi_ei_Vbi_ei=((+0.0-0.0)/VT-((-1.0)*0.0+(-1.0)*0.0+(DFV_f-BP(bi,ei))*0.0)/VT/VT+2*(DFV_f-BP(bi,ei))*0.0*0.0/VT/VT/VT);
#endif
#endif
DFv_e=((DFV_f-BP(bi,ei))/VT);
{
double m00_sqrt(d00_sqrt0,((DFv_e*DFv_e)+1.921812))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((DFv_e*DFv_e)+1.921812))
#endif
#if defined(_DERIVATEFORDDX)
DFs_q_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFs_q_Vsi_ci_Vsi_ci=0.0;
  DFs_q_Vsi_ci_Vb_ci=0.0;
  DFs_q_Vsi_ci_Vbp_ci=0.0;
  DFs_q_Vsi_ci_Vbi_ci=0.0;
  DFs_q_Vsi_ci_Vtnode_GND=0.0;
  DFs_q_Vsi_ci_Vbi_ei=0.0;
#endif
DFs_q_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFs_q_Vb_ci_Vsi_ci=0.0;
  DFs_q_Vb_ci_Vb_ci=0.0;
  DFs_q_Vb_ci_Vbp_ci=0.0;
  DFs_q_Vb_ci_Vbi_ci=0.0;
  DFs_q_Vb_ci_Vtnode_GND=0.0;
  DFs_q_Vb_ci_Vbi_ei=0.0;
#endif
DFs_q_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFs_q_Vbp_ci_Vsi_ci=0.0;
  DFs_q_Vbp_ci_Vb_ci=0.0;
  DFs_q_Vbp_ci_Vbp_ci=0.0;
  DFs_q_Vbp_ci_Vbi_ci=0.0;
  DFs_q_Vbp_ci_Vtnode_GND=0.0;
  DFs_q_Vbp_ci_Vbi_ei=0.0;
#endif
DFs_q_Vbi_ci=0.0;
#if defined(_DERIVATE)
  DFs_q_Vbi_ci_Vsi_ci=0.0;
  DFs_q_Vbi_ci_Vb_ci=0.0;
  DFs_q_Vbi_ci_Vbp_ci=0.0;
  DFs_q_Vbi_ci_Vbi_ci=0.0;
  DFs_q_Vbi_ci_Vtnode_GND=0.0;
  DFs_q_Vbi_ci_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
DFs_q_Vtnode_GND=((DFv_e_Vtnode_GND*DFv_e)+(DFv_e*DFv_e_Vtnode_GND))*d10_sqrt0;
#endif
DFs_q_Vbi_ei=((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  DFs_q_Vbi_ei_Vsi_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vsi_ci*DFv_e)+(DFv_e*DFv_e_Vsi_ci)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vsi_ci*DFv_e+DFv_e_Vbi_ei*DFv_e_Vsi_ci+DFv_e_Vsi_ci*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vsi_ci)+0.0));
  DFs_q_Vbi_ei_Vb_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vb_ci*DFv_e)+(DFv_e*DFv_e_Vb_ci)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vb_ci*DFv_e+DFv_e_Vbi_ei*DFv_e_Vb_ci+DFv_e_Vb_ci*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vb_ci)+0.0));
  DFs_q_Vbi_ei_Vbp_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vbp_ci*DFv_e)+(DFv_e*DFv_e_Vbp_ci)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vbp_ci*DFv_e+DFv_e_Vbi_ei*DFv_e_Vbp_ci+DFv_e_Vbp_ci*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vbp_ci)+0.0));
  DFs_q_Vbi_ei_Vbi_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vbi_ci*DFv_e+DFv_e_Vbi_ei*DFv_e_Vbi_ci+DFv_e_Vbi_ci*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vbi_ci)+0.0));
  DFs_q_Vbi_ei_Vtnode_GND=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vtnode_GND*DFv_e)+(DFv_e*DFv_e_Vtnode_GND)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vtnode_GND*DFv_e+DFv_e_Vbi_ei*DFv_e_Vtnode_GND+DFv_e_Vtnode_GND*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vtnode_GND)+0.0));
  DFs_q_Vbi_ei_Vbi_ei=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vbi_ei*DFv_e+DFv_e_Vbi_ei*DFv_e_Vbi_ei+DFv_e_Vbi_ei*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vbi_ei)+0.0));
#endif
#endif
DFs_q=d00_sqrt0;
}
#if defined(_DERIVATEFORDDX)
DFs_q2_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFs_q2_Vsi_ci_Vsi_ci=0.0;
  DFs_q2_Vsi_ci_Vb_ci=0.0;
  DFs_q2_Vsi_ci_Vbp_ci=0.0;
  DFs_q2_Vsi_ci_Vbi_ci=0.0;
  DFs_q2_Vsi_ci_Vtnode_GND=0.0;
  DFs_q2_Vsi_ci_Vbi_ei=0.0;
#endif
DFs_q2_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFs_q2_Vb_ci_Vsi_ci=0.0;
  DFs_q2_Vb_ci_Vb_ci=0.0;
  DFs_q2_Vb_ci_Vbp_ci=0.0;
  DFs_q2_Vb_ci_Vbi_ci=0.0;
  DFs_q2_Vb_ci_Vtnode_GND=0.0;
  DFs_q2_Vb_ci_Vbi_ei=0.0;
#endif
DFs_q2_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFs_q2_Vbp_ci_Vsi_ci=0.0;
  DFs_q2_Vbp_ci_Vb_ci=0.0;
  DFs_q2_Vbp_ci_Vbp_ci=0.0;
  DFs_q2_Vbp_ci_Vbi_ci=0.0;
  DFs_q2_Vbp_ci_Vtnode_GND=0.0;
  DFs_q2_Vbp_ci_Vbi_ei=0.0;
#endif
DFs_q2_Vbi_ci=0.0;
#if defined(_DERIVATE)
  DFs_q2_Vbi_ci_Vsi_ci=0.0;
  DFs_q2_Vbi_ci_Vb_ci=0.0;
  DFs_q2_Vbi_ci_Vbp_ci=0.0;
  DFs_q2_Vbi_ci_Vbi_ci=0.0;
  DFs_q2_Vbi_ci_Vtnode_GND=0.0;
  DFs_q2_Vbi_ci_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
DFs_q2_Vtnode_GND=(DFv_e_Vtnode_GND+DFs_q_Vtnode_GND)*0.5;
#endif
DFs_q2_Vbi_ei=(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.5;
#if defined(_DERIVATE)
  DFs_q2_Vbi_ei_Vsi_ci=(+(+DFv_e_Vbi_ei_Vsi_ci+DFs_q_Vbi_ei_Vsi_ci)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vsi_ci+DFs_q_Vsi_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vb_ci=(+(+DFv_e_Vbi_ei_Vb_ci+DFs_q_Vbi_ei_Vb_ci)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vb_ci+DFs_q_Vb_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vbp_ci=(+(+DFv_e_Vbi_ei_Vbp_ci+DFs_q_Vbi_ei_Vbp_ci)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vbp_ci+DFs_q_Vbp_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vbi_ci=(+(+DFv_e_Vbi_ei_Vbi_ci+DFs_q_Vbi_ei_Vbi_ci)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vtnode_GND=(+(+DFv_e_Vbi_ei_Vtnode_GND+DFs_q_Vbi_ei_Vtnode_GND)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vtnode_GND+DFs_q_Vtnode_GND)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vbi_ei=(+(+DFv_e_Vbi_ei_Vbi_ei+DFs_q_Vbi_ei_Vbi_ei)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e+DFs_q)*0.0);
#endif
#endif
DFs_q2=((DFv_e+DFs_q)*0.5);
#if defined(_DERIVATEFORDDX)
DFv_j_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFv_j_Vsi_ci_Vsi_ci=0.0;
  DFv_j_Vsi_ci_Vb_ci=0.0;
  DFv_j_Vsi_ci_Vbp_ci=0.0;
  DFv_j_Vsi_ci_Vbi_ci=0.0;
  DFv_j_Vsi_ci_Vtnode_GND=0.0;
  DFv_j_Vsi_ci_Vbi_ei=0.0;
#endif
DFv_j_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFv_j_Vb_ci_Vsi_ci=0.0;
  DFv_j_Vb_ci_Vb_ci=0.0;
  DFv_j_Vb_ci_Vbp_ci=0.0;
  DFv_j_Vb_ci_Vbi_ci=0.0;
  DFv_j_Vb_ci_Vtnode_GND=0.0;
  DFv_j_Vb_ci_Vbi_ei=0.0;
#endif
DFv_j_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFv_j_Vbp_ci_Vsi_ci=0.0;
  DFv_j_Vbp_ci_Vb_ci=0.0;
  DFv_j_Vbp_ci_Vbp_ci=0.0;
  DFv_j_Vbp_ci_Vbi_ci=0.0;
  DFv_j_Vbp_ci_Vtnode_GND=0.0;
  DFv_j_Vbp_ci_Vbi_ei=0.0;
#endif
DFv_j_Vbi_ci=0.0;
#if defined(_DERIVATE)
  DFv_j_Vbi_ci_Vsi_ci=0.0;
  DFv_j_Vbi_ci_Vb_ci=0.0;
  DFv_j_Vbi_ci_Vbp_ci=0.0;
  DFv_j_Vbi_ci_Vbi_ci=0.0;
  DFv_j_Vbi_ci_Vtnode_GND=0.0;
  DFv_j_Vbi_ci_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
DFv_j_Vtnode_GND=(DFV_f_Vtnode_GND-((VT_Vtnode_GND*DFs_q2)+(VT*DFs_q2_Vtnode_GND)));
#endif
DFv_j_Vbi_ei=(-(VT*DFs_q2_Vbi_ei));
#if defined(_DERIVATE)
  DFv_j_Vbi_ei_Vsi_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vsi_ci+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vsi_ci));
  DFv_j_Vbi_ei_Vb_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vb_ci+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vb_ci));
  DFv_j_Vbi_ei_Vbp_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vbp_ci+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vbp_ci));
  DFv_j_Vbi_ei_Vbi_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vbi_ci+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vbi_ci));
  DFv_j_Vbi_ei_Vtnode_GND=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vtnode_GND+VT_Vtnode_GND*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vtnode_GND));
  DFv_j_Vbi_ei_Vbi_ei=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vbi_ei+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vbi_ei));
#endif
#endif
DFv_j=(DFV_f-(VT*DFs_q2));
{
double m00_logE(d00_logE0,(1.0-(DFv_j/vdei_t)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1.0-(DFv_j/vdei_t)))
#endif
#if defined(_DERIVATEFORDDX)
DFb_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFb_Vsi_ci_Vsi_ci=0.0;
  DFb_Vsi_ci_Vb_ci=0.0;
  DFb_Vsi_ci_Vbp_ci=0.0;
  DFb_Vsi_ci_Vbi_ci=0.0;
  DFb_Vsi_ci_Vtnode_GND=0.0;
  DFb_Vsi_ci_Vbi_ei=0.0;
#endif
DFb_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFb_Vb_ci_Vsi_ci=0.0;
  DFb_Vb_ci_Vb_ci=0.0;
  DFb_Vb_ci_Vbp_ci=0.0;
  DFb_Vb_ci_Vbi_ci=0.0;
  DFb_Vb_ci_Vtnode_GND=0.0;
  DFb_Vb_ci_Vbi_ei=0.0;
#endif
DFb_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFb_Vbp_ci_Vsi_ci=0.0;
  DFb_Vbp_ci_Vb_ci=0.0;
  DFb_Vbp_ci_Vbp_ci=0.0;
  DFb_Vbp_ci_Vbi_ci=0.0;
  DFb_Vbp_ci_Vtnode_GND=0.0;
  DFb_Vbp_ci_Vbi_ei=0.0;
#endif
DFb_Vbi_ci=0.0;
#if defined(_DERIVATE)
  DFb_Vbi_ci_Vsi_ci=0.0;
  DFb_Vbi_ci_Vb_ci=0.0;
  DFb_Vbi_ci_Vbp_ci=0.0;
  DFb_Vbi_ci_Vbi_ci=0.0;
  DFb_Vbi_ci_Vtnode_GND=0.0;
  DFb_Vbi_ci_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
DFb_Vtnode_GND=(-((DFv_j_Vtnode_GND*vdei_t-DFv_j*vdei_t_Vtnode_GND)/vdei_t/vdei_t))*d10_logE0;
#endif
DFb_Vbi_ei=(-(DFv_j_Vbi_ei/vdei_t))*d10_logE0;
#if defined(_DERIVATE)
  DFb_Vbi_ei_Vsi_ci=(m20_logE((1.0-(DFv_j/vdei_t)))*(-(DFv_j_Vsi_ci/vdei_t))*(-(DFv_j_Vbi_ei/vdei_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vsi_ci/vdei_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vsi_ci*0.0+DFv_j*0.0)/vdei_t/vdei_t+2*DFv_j*0.0*0.0/vdei_t/vdei_t/vdei_t)));
  DFb_Vbi_ei_Vb_ci=(m20_logE((1.0-(DFv_j/vdei_t)))*(-(DFv_j_Vb_ci/vdei_t))*(-(DFv_j_Vbi_ei/vdei_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vb_ci/vdei_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vb_ci*0.0+DFv_j*0.0)/vdei_t/vdei_t+2*DFv_j*0.0*0.0/vdei_t/vdei_t/vdei_t)));
  DFb_Vbi_ei_Vbp_ci=(m20_logE((1.0-(DFv_j/vdei_t)))*(-(DFv_j_Vbp_ci/vdei_t))*(-(DFv_j_Vbi_ei/vdei_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vbp_ci/vdei_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vbp_ci*0.0+DFv_j*0.0)/vdei_t/vdei_t+2*DFv_j*0.0*0.0/vdei_t/vdei_t/vdei_t)));
  DFb_Vbi_ei_Vbi_ci=(m20_logE((1.0-(DFv_j/vdei_t)))*(-(DFv_j_Vbi_ci/vdei_t))*(-(DFv_j_Vbi_ei/vdei_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vbi_ci/vdei_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vbi_ci*0.0+DFv_j*0.0)/vdei_t/vdei_t+2*DFv_j*0.0*0.0/vdei_t/vdei_t/vdei_t)));
  DFb_Vbi_ei_Vtnode_GND=(m20_logE((1.0-(DFv_j/vdei_t)))*(-((DFv_j_Vtnode_GND*vdei_t-DFv_j*vdei_t_Vtnode_GND)/vdei_t/vdei_t))*(-(DFv_j_Vbi_ei/vdei_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vtnode_GND/vdei_t-(DFv_j_Vbi_ei*vdei_t_Vtnode_GND+DFv_j_Vtnode_GND*0.0+DFv_j*0.0)/vdei_t/vdei_t+2*DFv_j*0.0*vdei_t_Vtnode_GND/vdei_t/vdei_t/vdei_t)));
  DFb_Vbi_ei_Vbi_ei=(m20_logE((1.0-(DFv_j/vdei_t)))*(-(DFv_j_Vbi_ei/vdei_t))*(-(DFv_j_Vbi_ei/vdei_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vbi_ei/vdei_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vbi_ei*0.0+DFv_j*0.0)/vdei_t/vdei_t+2*DFv_j*0.0*0.0/vdei_t/vdei_t/vdei_t)));
#endif
#endif
DFb=d00_logE0;
}
{
double m00_exp(d00_exp0,(DFb*(1.0-zei)))
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
DFQ_j_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFQ_j_Vsi_ci_Vsi_ci=0.0;
  DFQ_j_Vsi_ci_Vb_ci=0.0;
  DFQ_j_Vsi_ci_Vbp_ci=0.0;
  DFQ_j_Vsi_ci_Vbi_ci=0.0;
  DFQ_j_Vsi_ci_Vtnode_GND=0.0;
  DFQ_j_Vsi_ci_Vbi_ei=0.0;
#endif
DFQ_j_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFQ_j_Vb_ci_Vsi_ci=0.0;
  DFQ_j_Vb_ci_Vb_ci=0.0;
  DFQ_j_Vb_ci_Vbp_ci=0.0;
  DFQ_j_Vb_ci_Vbi_ci=0.0;
  DFQ_j_Vb_ci_Vtnode_GND=0.0;
  DFQ_j_Vb_ci_Vbi_ei=0.0;
#endif
DFQ_j_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFQ_j_Vbp_ci_Vsi_ci=0.0;
  DFQ_j_Vbp_ci_Vb_ci=0.0;
  DFQ_j_Vbp_ci_Vbp_ci=0.0;
  DFQ_j_Vbp_ci_Vbi_ci=0.0;
  DFQ_j_Vbp_ci_Vtnode_GND=0.0;
  DFQ_j_Vbp_ci_Vbi_ei=0.0;
#endif
DFQ_j_Vbi_ci=0.0;
#if defined(_DERIVATE)
  DFQ_j_Vbi_ci_Vsi_ci=0.0;
  DFQ_j_Vbi_ci_Vb_ci=0.0;
  DFQ_j_Vbi_ci_Vbp_ci=0.0;
  DFQ_j_Vbi_ci_Vbi_ci=0.0;
  DFQ_j_Vbi_ci_Vtnode_GND=0.0;
  DFQ_j_Vbi_ci_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
DFQ_j_Vtnode_GND=(((((cjei0_t_Vtnode_GND*vdei_t)+(cjei0_t*vdei_t_Vtnode_GND))*(1.0-d00_exp0))+((cjei0_t*vdei_t)*(-DFb_Vtnode_GND*(1.0-zei)*d10_exp0)))/(1.0-zei));
#endif
DFQ_j_Vbi_ei=(((cjei0_t*vdei_t)*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0))/(1.0-zei));
#if defined(_DERIVATE)
  DFQ_j_Vbi_ei_Vsi_ci=((+(+0.0*vdei_t+0.0*0.0+0.0*0.0+cjei0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vsi_ci*(1.0-zei))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0)+(cjei0_t*vdei_t)*(+0.0-(m20_exp((DFb*(1.0-zei)))*(DFb_Vsi_ci*(1.0-zei))*DFb_Vbi_ei*(1.0-zei)+d10_exp0*(+DFb_Vbi_ei_Vsi_ci*(1.0-zei)+DFb_Vbi_ei*0.0+DFb_Vsi_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zei)-(((cjei0_t*vdei_t)*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0))*0.0+(((cjei0_t*vdei_t)*(-(DFb_Vsi_ci*(1.0-zei))*d10_exp0)))*0.0+((cjei0_t*vdei_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zei)/(1.0-zei)+2*((cjei0_t*vdei_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zei)/(1.0-zei)/(1.0-zei));
  DFQ_j_Vbi_ei_Vb_ci=((+(+0.0*vdei_t+0.0*0.0+0.0*0.0+cjei0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vb_ci*(1.0-zei))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0)+(cjei0_t*vdei_t)*(+0.0-(m20_exp((DFb*(1.0-zei)))*(DFb_Vb_ci*(1.0-zei))*DFb_Vbi_ei*(1.0-zei)+d10_exp0*(+DFb_Vbi_ei_Vb_ci*(1.0-zei)+DFb_Vbi_ei*0.0+DFb_Vb_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zei)-(((cjei0_t*vdei_t)*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0))*0.0+(((cjei0_t*vdei_t)*(-(DFb_Vb_ci*(1.0-zei))*d10_exp0)))*0.0+((cjei0_t*vdei_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zei)/(1.0-zei)+2*((cjei0_t*vdei_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zei)/(1.0-zei)/(1.0-zei));
  DFQ_j_Vbi_ei_Vbp_ci=((+(+0.0*vdei_t+0.0*0.0+0.0*0.0+cjei0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vbp_ci*(1.0-zei))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0)+(cjei0_t*vdei_t)*(+0.0-(m20_exp((DFb*(1.0-zei)))*(DFb_Vbp_ci*(1.0-zei))*DFb_Vbi_ei*(1.0-zei)+d10_exp0*(+DFb_Vbi_ei_Vbp_ci*(1.0-zei)+DFb_Vbi_ei*0.0+DFb_Vbp_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zei)-(((cjei0_t*vdei_t)*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0))*0.0+(((cjei0_t*vdei_t)*(-(DFb_Vbp_ci*(1.0-zei))*d10_exp0)))*0.0+((cjei0_t*vdei_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zei)/(1.0-zei)+2*((cjei0_t*vdei_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zei)/(1.0-zei)/(1.0-zei));
  DFQ_j_Vbi_ei_Vbi_ci=((+(+0.0*vdei_t+0.0*0.0+0.0*0.0+cjei0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vbi_ci*(1.0-zei))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0)+(cjei0_t*vdei_t)*(+0.0-(m20_exp((DFb*(1.0-zei)))*(DFb_Vbi_ci*(1.0-zei))*DFb_Vbi_ei*(1.0-zei)+d10_exp0*(+DFb_Vbi_ei_Vbi_ci*(1.0-zei)+DFb_Vbi_ei*0.0+DFb_Vbi_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zei)-(((cjei0_t*vdei_t)*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0))*0.0+(((cjei0_t*vdei_t)*(-(DFb_Vbi_ci*(1.0-zei))*d10_exp0)))*0.0+((cjei0_t*vdei_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zei)/(1.0-zei)+2*((cjei0_t*vdei_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zei)/(1.0-zei)/(1.0-zei));
  DFQ_j_Vbi_ei_Vtnode_GND=((+(+0.0*vdei_t+0.0*vdei_t_Vtnode_GND+cjei0_t_Vtnode_GND*0.0+cjei0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vtnode_GND*(1.0-zei))*d10_exp0)+(((cjei0_t_Vtnode_GND*vdei_t)+(cjei0_t*vdei_t_Vtnode_GND)))*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0)+(cjei0_t*vdei_t)*(+0.0-(m20_exp((DFb*(1.0-zei)))*(DFb_Vtnode_GND*(1.0-zei))*DFb_Vbi_ei*(1.0-zei)+d10_exp0*(+DFb_Vbi_ei_Vtnode_GND*(1.0-zei)+DFb_Vbi_ei*0.0+DFb_Vtnode_GND*0.0+DFb*(+0.0-0.0)))))/(1.0-zei)-(((cjei0_t*vdei_t)*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0))*0.0+((((((cjei0_t_Vtnode_GND*vdei_t)+(cjei0_t*vdei_t_Vtnode_GND)))*(1.0-d00_exp0))+((cjei0_t*vdei_t)*(-(DFb_Vtnode_GND*(1.0-zei))*d10_exp0))))*0.0+((cjei0_t*vdei_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zei)/(1.0-zei)+2*((cjei0_t*vdei_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zei)/(1.0-zei)/(1.0-zei));
  DFQ_j_Vbi_ei_Vbi_ei=((+(+0.0*vdei_t+0.0*0.0+0.0*0.0+cjei0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vbi_ei*(1.0-zei))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0)+(cjei0_t*vdei_t)*(+0.0-(m20_exp((DFb*(1.0-zei)))*(DFb_Vbi_ei*(1.0-zei))*DFb_Vbi_ei*(1.0-zei)+d10_exp0*(+DFb_Vbi_ei_Vbi_ei*(1.0-zei)+DFb_Vbi_ei*0.0+DFb_Vbi_ei*0.0+DFb*(+0.0-0.0)))))/(1.0-zei)-(((cjei0_t*vdei_t)*(-DFb_Vbi_ei*(1.0-zei)*d10_exp0))*0.0+(((cjei0_t*vdei_t)*(-(DFb_Vbi_ei*(1.0-zei))*d10_exp0)))*0.0+((cjei0_t*vdei_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zei)/(1.0-zei)+2*((cjei0_t*vdei_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zei)/(1.0-zei)/(1.0-zei));
#endif
#endif
DFQ_j=(((cjei0_t*vdei_t)*(1.0-d00_exp0))/(1.0-zei));
}
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
Qjei_Vtnode_GND=(DFQ_j_Vtnode_GND+((((ajei_t_Vtnode_GND*cjei0_t)+(ajei_t*cjei0_t_Vtnode_GND))*(BP(bi,ei)-DFv_j))+((ajei_t*cjei0_t)*(-DFv_j_Vtnode_GND))));
#endif
Qjei_Vbi_ei=(DFQ_j_Vbi_ei+((ajei_t*cjei0_t)*(1.0-DFv_j_Vbi_ei)));
#if defined(_DERIVATE)
  Qjei_Vbi_ei_Vtnode_GND=(+DFQ_j_Vbi_ei_Vtnode_GND+(+(+0.0*cjei0_t+0.0*cjei0_t_Vtnode_GND+ajei_t_Vtnode_GND*0.0+ajei_t*0.0)*(BP(bi,ei)-DFv_j)+0.0*(-DFv_j_Vtnode_GND)+(((ajei_t_Vtnode_GND*cjei0_t)+(ajei_t*cjei0_t_Vtnode_GND)))*(1.0-DFv_j_Vbi_ei)+(ajei_t*cjei0_t)*(+0.0-DFv_j_Vbi_ei_Vtnode_GND)));
  Qjei_Vbi_ei_Vbi_ei=(+DFQ_j_Vbi_ei_Vbi_ei+(+(+0.0*cjei0_t+0.0*0.0+0.0*0.0+ajei_t*0.0)*(BP(bi,ei)-DFv_j)+0.0*(1.0-DFv_j_Vbi_ei)+0.0*(1.0-DFv_j_Vbi_ei)+(ajei_t*cjei0_t)*(+0.0-DFv_j_Vbi_ei_Vbi_ei)));
#endif
#endif
Qjei=(DFQ_j+((ajei_t*cjei0_t)*(BP(bi,ei)-DFv_j)));
}
else
{
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
Qjei_Vtnode_GND=0.0;
#endif
Qjei_Vbi_ei=0.0;
#if defined(_DERIVATE)
  Qjei_Vbi_ei_Vtnode_GND=0.0;
  Qjei_Vbi_ei_Vbi_ei=0.0;
#endif
#endif
Qjei=0.0;
}
#if defined(_DDX)
#if defined(_DERIVATE)
Cjei_Vtnode_GND=+(Qjei_Vbi_ei_Vtnode_GND);
Cjei_Vbi_ei=+(Qjei_Vbi_ei_Vbi_ei);
#endif
Cjei=+(Qjei_Vbi_ei);
#endif
if
((vptci_t<1.0e2))
{
if
((cjci0_t>0.0))
{
Dz_r=(zci/4.0);
#if defined(_DERIVATE)
Dv_p_Vtnode_GND=(vptci_t_Vtnode_GND-vdci_t_Vtnode_GND);
#endif
Dv_p=(vptci_t-vdci_t);
{
double m00_logE(d00_logE0,2.4)
double m00_exp(d00_exp1,((-d00_logE0)/zci))
#if defined(_DERIVATE)
DV_f_Vtnode_GND=vdci_t_Vtnode_GND*(1.0-d00_exp1);
#endif
DV_f=(vdci_t*(1.0-d00_exp1));
}
#if defined(_DERIVATE)
DC_max_Vtnode_GND=(2.4*cjci0_t_Vtnode_GND);
#endif
DC_max=(2.4*cjci0_t);
{
double m00_logE(d00_logE0,(vptci_t/vdci_t))
double m00_exp(d00_exp1,((Dz_r-zci)*d00_logE0))
#if defined(_DERIVATE)
double m10_logE(d10_logE0,d00_logE0,(vptci_t/vdci_t))
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATE)
DC_c_Vtnode_GND=((cjci0_t_Vtnode_GND*d00_exp1)+(cjci0_t*((Dz_r-zci)*((vptci_t_Vtnode_GND*vdci_t-vptci_t*vdci_t_Vtnode_GND)/vdci_t/vdci_t)*d10_logE0)*d10_exp1));
#endif
DC_c=(cjci0_t*d00_exp1);
}
#if defined(_DERIVATEFORDDX)
Dv_e_Vsi_ci=0.0;
#if defined(_DERIVATE)
  Dv_e_Vsi_ci_Vsi_ci=0.0;
  Dv_e_Vsi_ci_Vb_ci=0.0;
  Dv_e_Vsi_ci_Vbp_ci=0.0;
  Dv_e_Vsi_ci_Vtnode_GND=0.0;
  Dv_e_Vsi_ci_Vbi_ci=0.0;
#endif
Dv_e_Vb_ci=0.0;
#if defined(_DERIVATE)
  Dv_e_Vb_ci_Vsi_ci=0.0;
  Dv_e_Vb_ci_Vb_ci=0.0;
  Dv_e_Vb_ci_Vbp_ci=0.0;
  Dv_e_Vb_ci_Vtnode_GND=0.0;
  Dv_e_Vb_ci_Vbi_ci=0.0;
#endif
Dv_e_Vbp_ci=0.0;
#if defined(_DERIVATE)
  Dv_e_Vbp_ci_Vsi_ci=0.0;
  Dv_e_Vbp_ci_Vb_ci=0.0;
  Dv_e_Vbp_ci_Vbp_ci=0.0;
  Dv_e_Vbp_ci_Vtnode_GND=0.0;
  Dv_e_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Dv_e_Vtnode_GND=((DV_f_Vtnode_GND*VT-(DV_f-BP(bi,ci))*VT_Vtnode_GND)/VT/VT);
#endif
Dv_e_Vbi_ci=((-1.0)/VT);
#if defined(_DERIVATE)
  Dv_e_Vbi_ci_Vsi_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DV_f-BP(bi,ci))*0.0)/VT/VT+2*(DV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
  Dv_e_Vbi_ci_Vb_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DV_f-BP(bi,ci))*0.0)/VT/VT+2*(DV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
  Dv_e_Vbi_ci_Vbp_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DV_f-BP(bi,ci))*0.0)/VT/VT+2*(DV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
  Dv_e_Vbi_ci_Vtnode_GND=((+0.0-0.0)/VT-((-1.0)*VT_Vtnode_GND+DV_f_Vtnode_GND*0.0+(DV_f-BP(bi,ci))*0.0)/VT/VT+2*(DV_f-BP(bi,ci))*0.0*VT_Vtnode_GND/VT/VT/VT);
  Dv_e_Vbi_ci_Vbi_ci=((+0.0-0.0)/VT-((-1.0)*0.0+(-1.0)*0.0+(DV_f-BP(bi,ci))*0.0)/VT/VT+2*(DV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
#endif
#endif
Dv_e=((DV_f-BP(bi,ci))/VT);
if
((Dv_e<80.0))
{
{
double m00_exp(d00_exp0,Dv_e)
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
De_Vsi_ci=0.0;
#if defined(_DERIVATE)
  De_Vsi_ci_Vsi_ci=0.0;
  De_Vsi_ci_Vb_ci=0.0;
  De_Vsi_ci_Vbp_ci=0.0;
  De_Vsi_ci_Vtnode_GND=0.0;
  De_Vsi_ci_Vbi_ci=0.0;
#endif
De_Vb_ci=0.0;
#if defined(_DERIVATE)
  De_Vb_ci_Vsi_ci=0.0;
  De_Vb_ci_Vb_ci=0.0;
  De_Vb_ci_Vbp_ci=0.0;
  De_Vb_ci_Vtnode_GND=0.0;
  De_Vb_ci_Vbi_ci=0.0;
#endif
De_Vbp_ci=0.0;
#if defined(_DERIVATE)
  De_Vbp_ci_Vsi_ci=0.0;
  De_Vbp_ci_Vb_ci=0.0;
  De_Vbp_ci_Vbp_ci=0.0;
  De_Vbp_ci_Vtnode_GND=0.0;
  De_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
De_Vtnode_GND=Dv_e_Vtnode_GND*d10_exp0;
#endif
De_Vbi_ci=Dv_e_Vbi_ci*d10_exp0;
#if defined(_DERIVATE)
  De_Vbi_ci_Vsi_ci=(m20_exp(Dv_e)*Dv_e_Vsi_ci*Dv_e_Vbi_ci+d10_exp0*Dv_e_Vbi_ci_Vsi_ci);
  De_Vbi_ci_Vb_ci=(m20_exp(Dv_e)*Dv_e_Vb_ci*Dv_e_Vbi_ci+d10_exp0*Dv_e_Vbi_ci_Vb_ci);
  De_Vbi_ci_Vbp_ci=(m20_exp(Dv_e)*Dv_e_Vbp_ci*Dv_e_Vbi_ci+d10_exp0*Dv_e_Vbi_ci_Vbp_ci);
  De_Vbi_ci_Vtnode_GND=(m20_exp(Dv_e)*Dv_e_Vtnode_GND*Dv_e_Vbi_ci+d10_exp0*Dv_e_Vbi_ci_Vtnode_GND);
  De_Vbi_ci_Vbi_ci=(m20_exp(Dv_e)*Dv_e_Vbi_ci*Dv_e_Vbi_ci+d10_exp0*Dv_e_Vbi_ci_Vbi_ci);
#endif
#endif
De=d00_exp0;
}
{
double m00_logE(d00_logE0,(1.0+De))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1.0+De))
#endif
#if defined(_DERIVATEFORDDX)
Dv_j1_Vsi_ci=0.0;
#if defined(_DERIVATE)
  Dv_j1_Vsi_ci_Vsi_ci=0.0;
  Dv_j1_Vsi_ci_Vb_ci=0.0;
  Dv_j1_Vsi_ci_Vbp_ci=0.0;
  Dv_j1_Vsi_ci_Vtnode_GND=0.0;
  Dv_j1_Vsi_ci_Vbi_ci=0.0;
#endif
Dv_j1_Vb_ci=0.0;
#if defined(_DERIVATE)
  Dv_j1_Vb_ci_Vsi_ci=0.0;
  Dv_j1_Vb_ci_Vb_ci=0.0;
  Dv_j1_Vb_ci_Vbp_ci=0.0;
  Dv_j1_Vb_ci_Vtnode_GND=0.0;
  Dv_j1_Vb_ci_Vbi_ci=0.0;
#endif
Dv_j1_Vbp_ci=0.0;
#if defined(_DERIVATE)
  Dv_j1_Vbp_ci_Vsi_ci=0.0;
  Dv_j1_Vbp_ci_Vb_ci=0.0;
  Dv_j1_Vbp_ci_Vbp_ci=0.0;
  Dv_j1_Vbp_ci_Vtnode_GND=0.0;
  Dv_j1_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Dv_j1_Vtnode_GND=(DV_f_Vtnode_GND-((VT_Vtnode_GND*d00_logE0)+(VT*De_Vtnode_GND*d10_logE0)));
#endif
Dv_j1_Vbi_ci=(-(VT*De_Vbi_ci*d10_logE0));
#if defined(_DERIVATE)
  Dv_j1_Vbi_ci_Vsi_ci=(+0.0-(+0.0*d00_logE0+0.0*De_Vsi_ci*d10_logE0+0.0*De_Vbi_ci*d10_logE0+VT*(m20_logE((1.0+De))*De_Vsi_ci*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vsi_ci))));
  Dv_j1_Vbi_ci_Vb_ci=(+0.0-(+0.0*d00_logE0+0.0*De_Vb_ci*d10_logE0+0.0*De_Vbi_ci*d10_logE0+VT*(m20_logE((1.0+De))*De_Vb_ci*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vb_ci))));
  Dv_j1_Vbi_ci_Vbp_ci=(+0.0-(+0.0*d00_logE0+0.0*De_Vbp_ci*d10_logE0+0.0*De_Vbi_ci*d10_logE0+VT*(m20_logE((1.0+De))*De_Vbp_ci*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vbp_ci))));
  Dv_j1_Vbi_ci_Vtnode_GND=(+0.0-(+0.0*d00_logE0+0.0*De_Vtnode_GND*d10_logE0+VT_Vtnode_GND*De_Vbi_ci*d10_logE0+VT*(m20_logE((1.0+De))*De_Vtnode_GND*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vtnode_GND))));
  Dv_j1_Vbi_ci_Vbi_ci=(+0.0-(+0.0*d00_logE0+0.0*De_Vbi_ci*d10_logE0+0.0*De_Vbi_ci*d10_logE0+VT*(m20_logE((1.0+De))*De_Vbi_ci*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vbi_ci))));
#endif
#endif
Dv_j1=(DV_f-(VT*d00_logE0));
}
}
else
{
#if defined(_DERIVATEFORDDX)
Dv_j1_Vsi_ci=0.0;
#if defined(_DERIVATE)
  Dv_j1_Vsi_ci_Vsi_ci=0.0;
  Dv_j1_Vsi_ci_Vb_ci=0.0;
  Dv_j1_Vsi_ci_Vbp_ci=0.0;
  Dv_j1_Vsi_ci_Vtnode_GND=0.0;
  Dv_j1_Vsi_ci_Vbi_ci=0.0;
#endif
Dv_j1_Vb_ci=0.0;
#if defined(_DERIVATE)
  Dv_j1_Vb_ci_Vsi_ci=0.0;
  Dv_j1_Vb_ci_Vb_ci=0.0;
  Dv_j1_Vb_ci_Vbp_ci=0.0;
  Dv_j1_Vb_ci_Vtnode_GND=0.0;
  Dv_j1_Vb_ci_Vbi_ci=0.0;
#endif
Dv_j1_Vbp_ci=0.0;
#if defined(_DERIVATE)
  Dv_j1_Vbp_ci_Vsi_ci=0.0;
  Dv_j1_Vbp_ci_Vb_ci=0.0;
  Dv_j1_Vbp_ci_Vbp_ci=0.0;
  Dv_j1_Vbp_ci_Vtnode_GND=0.0;
  Dv_j1_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Dv_j1_Vtnode_GND=0.0;
#endif
Dv_j1_Vbi_ci=1.0;
#if defined(_DERIVATE)
  Dv_j1_Vbi_ci_Vsi_ci=0.0;
  Dv_j1_Vbi_ci_Vb_ci=0.0;
  Dv_j1_Vbi_ci_Vbp_ci=0.0;
  Dv_j1_Vbi_ci_Vtnode_GND=0.0;
  Dv_j1_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
Dv_j1=BP(bi,ci);
}
#if defined(_DERIVATE)
Da_Vtnode_GND=((0.1*Dv_p_Vtnode_GND)+(4.0*VT_Vtnode_GND));
#endif
Da=((0.1*Dv_p)+(4.0*VT));
#if defined(_DERIVATEFORDDX)
Dv_r_Vsi_ci=0.0;
#if defined(_DERIVATE)
  Dv_r_Vsi_ci_Vsi_ci=0.0;
  Dv_r_Vsi_ci_Vb_ci=0.0;
  Dv_r_Vsi_ci_Vbp_ci=0.0;
  Dv_r_Vsi_ci_Vtnode_GND=0.0;
  Dv_r_Vsi_ci_Vbi_ci=0.0;
#endif
Dv_r_Vb_ci=0.0;
#if defined(_DERIVATE)
  Dv_r_Vb_ci_Vsi_ci=0.0;
  Dv_r_Vb_ci_Vb_ci=0.0;
  Dv_r_Vb_ci_Vbp_ci=0.0;
  Dv_r_Vb_ci_Vtnode_GND=0.0;
  Dv_r_Vb_ci_Vbi_ci=0.0;
#endif
Dv_r_Vbp_ci=0.0;
#if defined(_DERIVATE)
  Dv_r_Vbp_ci_Vsi_ci=0.0;
  Dv_r_Vbp_ci_Vb_ci=0.0;
  Dv_r_Vbp_ci_Vbp_ci=0.0;
  Dv_r_Vbp_ci_Vtnode_GND=0.0;
  Dv_r_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Dv_r_Vtnode_GND=(((Dv_p_Vtnode_GND+Dv_j1_Vtnode_GND)*Da-(Dv_p+Dv_j1)*Da_Vtnode_GND)/Da/Da);
#endif
Dv_r_Vbi_ci=(Dv_j1_Vbi_ci/Da);
#if defined(_DERIVATE)
  Dv_r_Vbi_ci_Vsi_ci=((+0.0+Dv_j1_Vbi_ci_Vsi_ci)/Da-(Dv_j1_Vbi_ci*0.0+Dv_j1_Vsi_ci*0.0+(Dv_p+Dv_j1)*0.0)/Da/Da+2*(Dv_p+Dv_j1)*0.0*0.0/Da/Da/Da);
  Dv_r_Vbi_ci_Vb_ci=((+0.0+Dv_j1_Vbi_ci_Vb_ci)/Da-(Dv_j1_Vbi_ci*0.0+Dv_j1_Vb_ci*0.0+(Dv_p+Dv_j1)*0.0)/Da/Da+2*(Dv_p+Dv_j1)*0.0*0.0/Da/Da/Da);
  Dv_r_Vbi_ci_Vbp_ci=((+0.0+Dv_j1_Vbi_ci_Vbp_ci)/Da-(Dv_j1_Vbi_ci*0.0+Dv_j1_Vbp_ci*0.0+(Dv_p+Dv_j1)*0.0)/Da/Da+2*(Dv_p+Dv_j1)*0.0*0.0/Da/Da/Da);
  Dv_r_Vbi_ci_Vtnode_GND=((+0.0+Dv_j1_Vbi_ci_Vtnode_GND)/Da-(Dv_j1_Vbi_ci*Da_Vtnode_GND+(Dv_p_Vtnode_GND+Dv_j1_Vtnode_GND)*0.0+(Dv_p+Dv_j1)*0.0)/Da/Da+2*(Dv_p+Dv_j1)*0.0*Da_Vtnode_GND/Da/Da/Da);
  Dv_r_Vbi_ci_Vbi_ci=((+0.0+Dv_j1_Vbi_ci_Vbi_ci)/Da-(Dv_j1_Vbi_ci*0.0+Dv_j1_Vbi_ci*0.0+(Dv_p+Dv_j1)*0.0)/Da/Da+2*(Dv_p+Dv_j1)*0.0*0.0/Da/Da/Da);
#endif
#endif
Dv_r=((Dv_p+Dv_j1)/Da);
if
((Dv_r<80.0))
{
{
double m00_exp(d00_exp0,Dv_r)
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
De_Vsi_ci=0.0;
#if defined(_DERIVATE)
  De_Vsi_ci_Vsi_ci=0.0;
  De_Vsi_ci_Vb_ci=0.0;
  De_Vsi_ci_Vbp_ci=0.0;
  De_Vsi_ci_Vtnode_GND=0.0;
  De_Vsi_ci_Vbi_ci=0.0;
#endif
De_Vb_ci=0.0;
#if defined(_DERIVATE)
  De_Vb_ci_Vsi_ci=0.0;
  De_Vb_ci_Vb_ci=0.0;
  De_Vb_ci_Vbp_ci=0.0;
  De_Vb_ci_Vtnode_GND=0.0;
  De_Vb_ci_Vbi_ci=0.0;
#endif
De_Vbp_ci=0.0;
#if defined(_DERIVATE)
  De_Vbp_ci_Vsi_ci=0.0;
  De_Vbp_ci_Vb_ci=0.0;
  De_Vbp_ci_Vbp_ci=0.0;
  De_Vbp_ci_Vtnode_GND=0.0;
  De_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
De_Vtnode_GND=Dv_r_Vtnode_GND*d10_exp0;
#endif
De_Vbi_ci=Dv_r_Vbi_ci*d10_exp0;
#if defined(_DERIVATE)
  De_Vbi_ci_Vsi_ci=(m20_exp(Dv_r)*Dv_r_Vsi_ci*Dv_r_Vbi_ci+d10_exp0*Dv_r_Vbi_ci_Vsi_ci);
  De_Vbi_ci_Vb_ci=(m20_exp(Dv_r)*Dv_r_Vb_ci*Dv_r_Vbi_ci+d10_exp0*Dv_r_Vbi_ci_Vb_ci);
  De_Vbi_ci_Vbp_ci=(m20_exp(Dv_r)*Dv_r_Vbp_ci*Dv_r_Vbi_ci+d10_exp0*Dv_r_Vbi_ci_Vbp_ci);
  De_Vbi_ci_Vtnode_GND=(m20_exp(Dv_r)*Dv_r_Vtnode_GND*Dv_r_Vbi_ci+d10_exp0*Dv_r_Vbi_ci_Vtnode_GND);
  De_Vbi_ci_Vbi_ci=(m20_exp(Dv_r)*Dv_r_Vbi_ci*Dv_r_Vbi_ci+d10_exp0*Dv_r_Vbi_ci_Vbi_ci);
#endif
#endif
De=d00_exp0;
}
{
double m00_logE(d00_logE0,(1.0+De))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1.0+De))
#endif
#if defined(_DERIVATEFORDDX)
Dv_j2_Vsi_ci=0.0;
#if defined(_DERIVATE)
  Dv_j2_Vsi_ci_Vsi_ci=0.0;
  Dv_j2_Vsi_ci_Vb_ci=0.0;
  Dv_j2_Vsi_ci_Vbp_ci=0.0;
  Dv_j2_Vsi_ci_Vtnode_GND=0.0;
  Dv_j2_Vsi_ci_Vbi_ci=0.0;
#endif
Dv_j2_Vb_ci=0.0;
#if defined(_DERIVATE)
  Dv_j2_Vb_ci_Vsi_ci=0.0;
  Dv_j2_Vb_ci_Vb_ci=0.0;
  Dv_j2_Vb_ci_Vbp_ci=0.0;
  Dv_j2_Vb_ci_Vtnode_GND=0.0;
  Dv_j2_Vb_ci_Vbi_ci=0.0;
#endif
Dv_j2_Vbp_ci=0.0;
#if defined(_DERIVATE)
  Dv_j2_Vbp_ci_Vsi_ci=0.0;
  Dv_j2_Vbp_ci_Vb_ci=0.0;
  Dv_j2_Vbp_ci_Vbp_ci=0.0;
  Dv_j2_Vbp_ci_Vtnode_GND=0.0;
  Dv_j2_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Dv_j2_Vtnode_GND=((-Dv_p_Vtnode_GND)+((Da_Vtnode_GND*d00_logE0)+(Da*De_Vtnode_GND*d10_logE0)));
#endif
Dv_j2_Vbi_ci=(Da*De_Vbi_ci*d10_logE0);
#if defined(_DERIVATE)
  Dv_j2_Vbi_ci_Vsi_ci=(+0.0+(+0.0*d00_logE0+0.0*De_Vsi_ci*d10_logE0+0.0*De_Vbi_ci*d10_logE0+Da*(m20_logE((1.0+De))*De_Vsi_ci*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vsi_ci))));
  Dv_j2_Vbi_ci_Vb_ci=(+0.0+(+0.0*d00_logE0+0.0*De_Vb_ci*d10_logE0+0.0*De_Vbi_ci*d10_logE0+Da*(m20_logE((1.0+De))*De_Vb_ci*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vb_ci))));
  Dv_j2_Vbi_ci_Vbp_ci=(+0.0+(+0.0*d00_logE0+0.0*De_Vbp_ci*d10_logE0+0.0*De_Vbi_ci*d10_logE0+Da*(m20_logE((1.0+De))*De_Vbp_ci*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vbp_ci))));
  Dv_j2_Vbi_ci_Vtnode_GND=(+0.0+(+0.0*d00_logE0+0.0*De_Vtnode_GND*d10_logE0+Da_Vtnode_GND*De_Vbi_ci*d10_logE0+Da*(m20_logE((1.0+De))*De_Vtnode_GND*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vtnode_GND))));
  Dv_j2_Vbi_ci_Vbi_ci=(+0.0+(+0.0*d00_logE0+0.0*De_Vbi_ci*d10_logE0+0.0*De_Vbi_ci*d10_logE0+Da*(m20_logE((1.0+De))*De_Vbi_ci*De_Vbi_ci+d10_logE0*(+0.0+De_Vbi_ci_Vbi_ci))));
#endif
#endif
Dv_j2=((-Dv_p)+(Da*d00_logE0));
}
}
else
{
#if defined(_DERIVATEFORDDX)
Dv_j2_Vsi_ci=0.0;
#if defined(_DERIVATE)
  Dv_j2_Vsi_ci_Vsi_ci=0.0;
  Dv_j2_Vsi_ci_Vb_ci=0.0;
  Dv_j2_Vsi_ci_Vbp_ci=0.0;
  Dv_j2_Vsi_ci_Vtnode_GND=0.0;
  Dv_j2_Vsi_ci_Vbi_ci=0.0;
#endif
Dv_j2_Vb_ci=0.0;
#if defined(_DERIVATE)
  Dv_j2_Vb_ci_Vsi_ci=0.0;
  Dv_j2_Vb_ci_Vb_ci=0.0;
  Dv_j2_Vb_ci_Vbp_ci=0.0;
  Dv_j2_Vb_ci_Vtnode_GND=0.0;
  Dv_j2_Vb_ci_Vbi_ci=0.0;
#endif
Dv_j2_Vbp_ci=0.0;
#if defined(_DERIVATE)
  Dv_j2_Vbp_ci_Vsi_ci=0.0;
  Dv_j2_Vbp_ci_Vb_ci=0.0;
  Dv_j2_Vbp_ci_Vbp_ci=0.0;
  Dv_j2_Vbp_ci_Vtnode_GND=0.0;
  Dv_j2_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Dv_j2_Vtnode_GND=Dv_j1_Vtnode_GND;
#endif
Dv_j2_Vbi_ci=Dv_j1_Vbi_ci;
#if defined(_DERIVATE)
  Dv_j2_Vbi_ci_Vsi_ci=Dv_j1_Vbi_ci_Vsi_ci;
  Dv_j2_Vbi_ci_Vb_ci=Dv_j1_Vbi_ci_Vb_ci;
  Dv_j2_Vbi_ci_Vbp_ci=Dv_j1_Vbi_ci_Vbp_ci;
  Dv_j2_Vbi_ci_Vtnode_GND=Dv_j1_Vbi_ci_Vtnode_GND;
  Dv_j2_Vbi_ci_Vbi_ci=Dv_j1_Vbi_ci_Vbi_ci;
#endif
#endif
Dv_j2=Dv_j1;
}
#if defined(_DERIVATEFORDDX)
Dv_j4_Vsi_ci=0.0;
#if defined(_DERIVATE)
  Dv_j4_Vsi_ci_Vsi_ci=0.0;
  Dv_j4_Vsi_ci_Vb_ci=0.0;
  Dv_j4_Vsi_ci_Vbp_ci=0.0;
  Dv_j4_Vsi_ci_Vbi_ci=0.0;
  Dv_j4_Vsi_ci_Vtnode_GND=0.0;
#endif
Dv_j4_Vb_ci=0.0;
#if defined(_DERIVATE)
  Dv_j4_Vb_ci_Vsi_ci=0.0;
  Dv_j4_Vb_ci_Vb_ci=0.0;
  Dv_j4_Vb_ci_Vbp_ci=0.0;
  Dv_j4_Vb_ci_Vbi_ci=0.0;
  Dv_j4_Vb_ci_Vtnode_GND=0.0;
#endif
Dv_j4_Vbp_ci=0.0;
#if defined(_DERIVATE)
  Dv_j4_Vbp_ci_Vsi_ci=0.0;
  Dv_j4_Vbp_ci_Vb_ci=0.0;
  Dv_j4_Vbp_ci_Vbp_ci=0.0;
  Dv_j4_Vbp_ci_Vbi_ci=0.0;
  Dv_j4_Vbp_ci_Vtnode_GND=0.0;
#endif
Dv_j4_Vbi_ci=(1.0-Dv_j1_Vbi_ci);
#if defined(_DERIVATE)
  Dv_j4_Vbi_ci_Vsi_ci=(+0.0-Dv_j1_Vbi_ci_Vsi_ci);
  Dv_j4_Vbi_ci_Vb_ci=(+0.0-Dv_j1_Vbi_ci_Vb_ci);
  Dv_j4_Vbi_ci_Vbp_ci=(+0.0-Dv_j1_Vbi_ci_Vbp_ci);
  Dv_j4_Vbi_ci_Vbi_ci=(+0.0-Dv_j1_Vbi_ci_Vbi_ci);
  Dv_j4_Vbi_ci_Vtnode_GND=(+0.0-Dv_j1_Vbi_ci_Vtnode_GND);
#endif
#if defined(_DERIVATE)
Dv_j4_Vtnode_GND=(-Dv_j1_Vtnode_GND);
#endif
#endif
Dv_j4=(BP(bi,ci)-Dv_j1);
{
double m00_logE(d00_logE0,(1.0-(Dv_j1/vdci_t)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1.0-(Dv_j1/vdci_t)))
#endif
#if defined(_DERIVATEFORDDX)
DCln1_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DCln1_Vsi_ci_Vsi_ci=0.0;
  DCln1_Vsi_ci_Vb_ci=0.0;
  DCln1_Vsi_ci_Vbp_ci=0.0;
  DCln1_Vsi_ci_Vtnode_GND=0.0;
  DCln1_Vsi_ci_Vbi_ci=0.0;
#endif
DCln1_Vb_ci=0.0;
#if defined(_DERIVATE)
  DCln1_Vb_ci_Vsi_ci=0.0;
  DCln1_Vb_ci_Vb_ci=0.0;
  DCln1_Vb_ci_Vbp_ci=0.0;
  DCln1_Vb_ci_Vtnode_GND=0.0;
  DCln1_Vb_ci_Vbi_ci=0.0;
#endif
DCln1_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DCln1_Vbp_ci_Vsi_ci=0.0;
  DCln1_Vbp_ci_Vb_ci=0.0;
  DCln1_Vbp_ci_Vbp_ci=0.0;
  DCln1_Vbp_ci_Vtnode_GND=0.0;
  DCln1_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
DCln1_Vtnode_GND=(-((Dv_j1_Vtnode_GND*vdci_t-Dv_j1*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*d10_logE0;
#endif
DCln1_Vbi_ci=(-(Dv_j1_Vbi_ci/vdci_t))*d10_logE0;
#if defined(_DERIVATE)
  DCln1_Vbi_ci_Vsi_ci=(m20_logE((1.0-(Dv_j1/vdci_t)))*(-(Dv_j1_Vsi_ci/vdci_t))*(-(Dv_j1_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j1_Vbi_ci_Vsi_ci/vdci_t-(Dv_j1_Vbi_ci*0.0+Dv_j1_Vsi_ci*0.0+Dv_j1*0.0)/vdci_t/vdci_t+2*Dv_j1*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DCln1_Vbi_ci_Vb_ci=(m20_logE((1.0-(Dv_j1/vdci_t)))*(-(Dv_j1_Vb_ci/vdci_t))*(-(Dv_j1_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j1_Vbi_ci_Vb_ci/vdci_t-(Dv_j1_Vbi_ci*0.0+Dv_j1_Vb_ci*0.0+Dv_j1*0.0)/vdci_t/vdci_t+2*Dv_j1*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DCln1_Vbi_ci_Vbp_ci=(m20_logE((1.0-(Dv_j1/vdci_t)))*(-(Dv_j1_Vbp_ci/vdci_t))*(-(Dv_j1_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j1_Vbi_ci_Vbp_ci/vdci_t-(Dv_j1_Vbi_ci*0.0+Dv_j1_Vbp_ci*0.0+Dv_j1*0.0)/vdci_t/vdci_t+2*Dv_j1*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DCln1_Vbi_ci_Vtnode_GND=(m20_logE((1.0-(Dv_j1/vdci_t)))*(-((Dv_j1_Vtnode_GND*vdci_t-Dv_j1*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*(-(Dv_j1_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j1_Vbi_ci_Vtnode_GND/vdci_t-(Dv_j1_Vbi_ci*vdci_t_Vtnode_GND+Dv_j1_Vtnode_GND*0.0+Dv_j1*0.0)/vdci_t/vdci_t+2*Dv_j1*0.0*vdci_t_Vtnode_GND/vdci_t/vdci_t/vdci_t)));
  DCln1_Vbi_ci_Vbi_ci=(m20_logE((1.0-(Dv_j1/vdci_t)))*(-(Dv_j1_Vbi_ci/vdci_t))*(-(Dv_j1_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j1_Vbi_ci_Vbi_ci/vdci_t-(Dv_j1_Vbi_ci*0.0+Dv_j1_Vbi_ci*0.0+Dv_j1*0.0)/vdci_t/vdci_t+2*Dv_j1*0.0*0.0/vdci_t/vdci_t/vdci_t)));
#endif
#endif
DCln1=d00_logE0;
}
{
double m00_logE(d00_logE0,(1.0-(Dv_j2/vdci_t)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1.0-(Dv_j2/vdci_t)))
#endif
#if defined(_DERIVATEFORDDX)
DCln2_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DCln2_Vsi_ci_Vsi_ci=0.0;
  DCln2_Vsi_ci_Vb_ci=0.0;
  DCln2_Vsi_ci_Vbp_ci=0.0;
  DCln2_Vsi_ci_Vtnode_GND=0.0;
  DCln2_Vsi_ci_Vbi_ci=0.0;
#endif
DCln2_Vb_ci=0.0;
#if defined(_DERIVATE)
  DCln2_Vb_ci_Vsi_ci=0.0;
  DCln2_Vb_ci_Vb_ci=0.0;
  DCln2_Vb_ci_Vbp_ci=0.0;
  DCln2_Vb_ci_Vtnode_GND=0.0;
  DCln2_Vb_ci_Vbi_ci=0.0;
#endif
DCln2_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DCln2_Vbp_ci_Vsi_ci=0.0;
  DCln2_Vbp_ci_Vb_ci=0.0;
  DCln2_Vbp_ci_Vbp_ci=0.0;
  DCln2_Vbp_ci_Vtnode_GND=0.0;
  DCln2_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
DCln2_Vtnode_GND=(-((Dv_j2_Vtnode_GND*vdci_t-Dv_j2*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*d10_logE0;
#endif
DCln2_Vbi_ci=(-(Dv_j2_Vbi_ci/vdci_t))*d10_logE0;
#if defined(_DERIVATE)
  DCln2_Vbi_ci_Vsi_ci=(m20_logE((1.0-(Dv_j2/vdci_t)))*(-(Dv_j2_Vsi_ci/vdci_t))*(-(Dv_j2_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j2_Vbi_ci_Vsi_ci/vdci_t-(Dv_j2_Vbi_ci*0.0+Dv_j2_Vsi_ci*0.0+Dv_j2*0.0)/vdci_t/vdci_t+2*Dv_j2*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DCln2_Vbi_ci_Vb_ci=(m20_logE((1.0-(Dv_j2/vdci_t)))*(-(Dv_j2_Vb_ci/vdci_t))*(-(Dv_j2_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j2_Vbi_ci_Vb_ci/vdci_t-(Dv_j2_Vbi_ci*0.0+Dv_j2_Vb_ci*0.0+Dv_j2*0.0)/vdci_t/vdci_t+2*Dv_j2*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DCln2_Vbi_ci_Vbp_ci=(m20_logE((1.0-(Dv_j2/vdci_t)))*(-(Dv_j2_Vbp_ci/vdci_t))*(-(Dv_j2_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j2_Vbi_ci_Vbp_ci/vdci_t-(Dv_j2_Vbi_ci*0.0+Dv_j2_Vbp_ci*0.0+Dv_j2*0.0)/vdci_t/vdci_t+2*Dv_j2*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DCln2_Vbi_ci_Vtnode_GND=(m20_logE((1.0-(Dv_j2/vdci_t)))*(-((Dv_j2_Vtnode_GND*vdci_t-Dv_j2*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*(-(Dv_j2_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j2_Vbi_ci_Vtnode_GND/vdci_t-(Dv_j2_Vbi_ci*vdci_t_Vtnode_GND+Dv_j2_Vtnode_GND*0.0+Dv_j2*0.0)/vdci_t/vdci_t+2*Dv_j2*0.0*vdci_t_Vtnode_GND/vdci_t/vdci_t/vdci_t)));
  DCln2_Vbi_ci_Vbi_ci=(m20_logE((1.0-(Dv_j2/vdci_t)))*(-(Dv_j2_Vbi_ci/vdci_t))*(-(Dv_j2_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(Dv_j2_Vbi_ci_Vbi_ci/vdci_t-(Dv_j2_Vbi_ci*0.0+Dv_j2_Vbi_ci*0.0+Dv_j2*0.0)/vdci_t/vdci_t+2*Dv_j2*0.0*0.0/vdci_t/vdci_t/vdci_t)));
#endif
#endif
DCln2=d00_logE0;
}
Dz1=(1.0-zci);
Dzr1=(1.0-Dz_r);
{
double m00_exp(d00_exp0,(DCln2*Dz1))
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
DQ_j1_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DQ_j1_Vsi_ci_Vsi_ci=0.0;
  DQ_j1_Vsi_ci_Vb_ci=0.0;
  DQ_j1_Vsi_ci_Vbp_ci=0.0;
  DQ_j1_Vsi_ci_Vtnode_GND=0.0;
  DQ_j1_Vsi_ci_Vbi_ci=0.0;
#endif
DQ_j1_Vb_ci=0.0;
#if defined(_DERIVATE)
  DQ_j1_Vb_ci_Vsi_ci=0.0;
  DQ_j1_Vb_ci_Vb_ci=0.0;
  DQ_j1_Vb_ci_Vbp_ci=0.0;
  DQ_j1_Vb_ci_Vtnode_GND=0.0;
  DQ_j1_Vb_ci_Vbi_ci=0.0;
#endif
DQ_j1_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DQ_j1_Vbp_ci_Vsi_ci=0.0;
  DQ_j1_Vbp_ci_Vb_ci=0.0;
  DQ_j1_Vbp_ci_Vbp_ci=0.0;
  DQ_j1_Vbp_ci_Vtnode_GND=0.0;
  DQ_j1_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
DQ_j1_Vtnode_GND=(((cjci0_t_Vtnode_GND*(1.0-d00_exp0))+(cjci0_t*(-DCln2_Vtnode_GND*Dz1*d10_exp0)))/Dz1);
#endif
DQ_j1_Vbi_ci=((cjci0_t*(-DCln2_Vbi_ci*Dz1*d10_exp0))/Dz1);
#if defined(_DERIVATE)
  DQ_j1_Vbi_ci_Vsi_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vsi_ci*Dz1)*d10_exp0)+0.0*(-DCln2_Vbi_ci*Dz1*d10_exp0)+cjci0_t*(+0.0-(m20_exp((DCln2*Dz1))*(DCln2_Vsi_ci*Dz1)*DCln2_Vbi_ci*Dz1+d10_exp0*(+DCln2_Vbi_ci_Vsi_ci*Dz1+DCln2_Vbi_ci*0.0+DCln2_Vsi_ci*0.0+DCln2*0.0))))/Dz1-((cjci0_t*(-DCln2_Vbi_ci*Dz1*d10_exp0))*0.0+((cjci0_t*(-(DCln2_Vsi_ci*Dz1)*d10_exp0)))*0.0+(cjci0_t*(1.0-d00_exp0))*0.0)/Dz1/Dz1+2*(cjci0_t*(1.0-d00_exp0))*0.0*0.0/Dz1/Dz1/Dz1);
  DQ_j1_Vbi_ci_Vb_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vb_ci*Dz1)*d10_exp0)+0.0*(-DCln2_Vbi_ci*Dz1*d10_exp0)+cjci0_t*(+0.0-(m20_exp((DCln2*Dz1))*(DCln2_Vb_ci*Dz1)*DCln2_Vbi_ci*Dz1+d10_exp0*(+DCln2_Vbi_ci_Vb_ci*Dz1+DCln2_Vbi_ci*0.0+DCln2_Vb_ci*0.0+DCln2*0.0))))/Dz1-((cjci0_t*(-DCln2_Vbi_ci*Dz1*d10_exp0))*0.0+((cjci0_t*(-(DCln2_Vb_ci*Dz1)*d10_exp0)))*0.0+(cjci0_t*(1.0-d00_exp0))*0.0)/Dz1/Dz1+2*(cjci0_t*(1.0-d00_exp0))*0.0*0.0/Dz1/Dz1/Dz1);
  DQ_j1_Vbi_ci_Vbp_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vbp_ci*Dz1)*d10_exp0)+0.0*(-DCln2_Vbi_ci*Dz1*d10_exp0)+cjci0_t*(+0.0-(m20_exp((DCln2*Dz1))*(DCln2_Vbp_ci*Dz1)*DCln2_Vbi_ci*Dz1+d10_exp0*(+DCln2_Vbi_ci_Vbp_ci*Dz1+DCln2_Vbi_ci*0.0+DCln2_Vbp_ci*0.0+DCln2*0.0))))/Dz1-((cjci0_t*(-DCln2_Vbi_ci*Dz1*d10_exp0))*0.0+((cjci0_t*(-(DCln2_Vbp_ci*Dz1)*d10_exp0)))*0.0+(cjci0_t*(1.0-d00_exp0))*0.0)/Dz1/Dz1+2*(cjci0_t*(1.0-d00_exp0))*0.0*0.0/Dz1/Dz1/Dz1);
  DQ_j1_Vbi_ci_Vtnode_GND=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vtnode_GND*Dz1)*d10_exp0)+cjci0_t_Vtnode_GND*(-DCln2_Vbi_ci*Dz1*d10_exp0)+cjci0_t*(+0.0-(m20_exp((DCln2*Dz1))*(DCln2_Vtnode_GND*Dz1)*DCln2_Vbi_ci*Dz1+d10_exp0*(+DCln2_Vbi_ci_Vtnode_GND*Dz1+DCln2_Vbi_ci*0.0+DCln2_Vtnode_GND*0.0+DCln2*0.0))))/Dz1-((cjci0_t*(-DCln2_Vbi_ci*Dz1*d10_exp0))*0.0+(((cjci0_t_Vtnode_GND*(1.0-d00_exp0))+(cjci0_t*(-(DCln2_Vtnode_GND*Dz1)*d10_exp0))))*0.0+(cjci0_t*(1.0-d00_exp0))*0.0)/Dz1/Dz1+2*(cjci0_t*(1.0-d00_exp0))*0.0*0.0/Dz1/Dz1/Dz1);
  DQ_j1_Vbi_ci_Vbi_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vbi_ci*Dz1)*d10_exp0)+0.0*(-DCln2_Vbi_ci*Dz1*d10_exp0)+cjci0_t*(+0.0-(m20_exp((DCln2*Dz1))*(DCln2_Vbi_ci*Dz1)*DCln2_Vbi_ci*Dz1+d10_exp0*(+DCln2_Vbi_ci_Vbi_ci*Dz1+DCln2_Vbi_ci*0.0+DCln2_Vbi_ci*0.0+DCln2*0.0))))/Dz1-((cjci0_t*(-DCln2_Vbi_ci*Dz1*d10_exp0))*0.0+((cjci0_t*(-(DCln2_Vbi_ci*Dz1)*d10_exp0)))*0.0+(cjci0_t*(1.0-d00_exp0))*0.0)/Dz1/Dz1+2*(cjci0_t*(1.0-d00_exp0))*0.0*0.0/Dz1/Dz1/Dz1);
#endif
#endif
DQ_j1=((cjci0_t*(1.0-d00_exp0))/Dz1);
}
{
double m00_exp(d00_exp0,(DCln1*Dzr1))
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
DQ_j2_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DQ_j2_Vsi_ci_Vsi_ci=0.0;
  DQ_j2_Vsi_ci_Vb_ci=0.0;
  DQ_j2_Vsi_ci_Vbp_ci=0.0;
  DQ_j2_Vsi_ci_Vtnode_GND=0.0;
  DQ_j2_Vsi_ci_Vbi_ci=0.0;
#endif
DQ_j2_Vb_ci=0.0;
#if defined(_DERIVATE)
  DQ_j2_Vb_ci_Vsi_ci=0.0;
  DQ_j2_Vb_ci_Vb_ci=0.0;
  DQ_j2_Vb_ci_Vbp_ci=0.0;
  DQ_j2_Vb_ci_Vtnode_GND=0.0;
  DQ_j2_Vb_ci_Vbi_ci=0.0;
#endif
DQ_j2_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DQ_j2_Vbp_ci_Vsi_ci=0.0;
  DQ_j2_Vbp_ci_Vb_ci=0.0;
  DQ_j2_Vbp_ci_Vbp_ci=0.0;
  DQ_j2_Vbp_ci_Vtnode_GND=0.0;
  DQ_j2_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
DQ_j2_Vtnode_GND=(((DC_c_Vtnode_GND*(1.0-d00_exp0))+(DC_c*(-DCln1_Vtnode_GND*Dzr1*d10_exp0)))/Dzr1);
#endif
DQ_j2_Vbi_ci=((DC_c*(-DCln1_Vbi_ci*Dzr1*d10_exp0))/Dzr1);
#if defined(_DERIVATE)
  DQ_j2_Vbi_ci_Vsi_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln1_Vsi_ci*Dzr1)*d10_exp0)+0.0*(-DCln1_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln1*Dzr1))*(DCln1_Vsi_ci*Dzr1)*DCln1_Vbi_ci*Dzr1+d10_exp0*(+DCln1_Vbi_ci_Vsi_ci*Dzr1+DCln1_Vbi_ci*0.0+DCln1_Vsi_ci*0.0+DCln1*0.0))))/Dzr1-((DC_c*(-DCln1_Vbi_ci*Dzr1*d10_exp0))*0.0+((DC_c*(-(DCln1_Vsi_ci*Dzr1)*d10_exp0)))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
  DQ_j2_Vbi_ci_Vb_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln1_Vb_ci*Dzr1)*d10_exp0)+0.0*(-DCln1_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln1*Dzr1))*(DCln1_Vb_ci*Dzr1)*DCln1_Vbi_ci*Dzr1+d10_exp0*(+DCln1_Vbi_ci_Vb_ci*Dzr1+DCln1_Vbi_ci*0.0+DCln1_Vb_ci*0.0+DCln1*0.0))))/Dzr1-((DC_c*(-DCln1_Vbi_ci*Dzr1*d10_exp0))*0.0+((DC_c*(-(DCln1_Vb_ci*Dzr1)*d10_exp0)))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
  DQ_j2_Vbi_ci_Vbp_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln1_Vbp_ci*Dzr1)*d10_exp0)+0.0*(-DCln1_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln1*Dzr1))*(DCln1_Vbp_ci*Dzr1)*DCln1_Vbi_ci*Dzr1+d10_exp0*(+DCln1_Vbi_ci_Vbp_ci*Dzr1+DCln1_Vbi_ci*0.0+DCln1_Vbp_ci*0.0+DCln1*0.0))))/Dzr1-((DC_c*(-DCln1_Vbi_ci*Dzr1*d10_exp0))*0.0+((DC_c*(-(DCln1_Vbp_ci*Dzr1)*d10_exp0)))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
  DQ_j2_Vbi_ci_Vtnode_GND=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln1_Vtnode_GND*Dzr1)*d10_exp0)+DC_c_Vtnode_GND*(-DCln1_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln1*Dzr1))*(DCln1_Vtnode_GND*Dzr1)*DCln1_Vbi_ci*Dzr1+d10_exp0*(+DCln1_Vbi_ci_Vtnode_GND*Dzr1+DCln1_Vbi_ci*0.0+DCln1_Vtnode_GND*0.0+DCln1*0.0))))/Dzr1-((DC_c*(-DCln1_Vbi_ci*Dzr1*d10_exp0))*0.0+(((DC_c_Vtnode_GND*(1.0-d00_exp0))+(DC_c*(-(DCln1_Vtnode_GND*Dzr1)*d10_exp0))))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
  DQ_j2_Vbi_ci_Vbi_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln1_Vbi_ci*Dzr1)*d10_exp0)+0.0*(-DCln1_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln1*Dzr1))*(DCln1_Vbi_ci*Dzr1)*DCln1_Vbi_ci*Dzr1+d10_exp0*(+DCln1_Vbi_ci_Vbi_ci*Dzr1+DCln1_Vbi_ci*0.0+DCln1_Vbi_ci*0.0+DCln1*0.0))))/Dzr1-((DC_c*(-DCln1_Vbi_ci*Dzr1*d10_exp0))*0.0+((DC_c*(-(DCln1_Vbi_ci*Dzr1)*d10_exp0)))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
#endif
#endif
DQ_j2=((DC_c*(1.0-d00_exp0))/Dzr1);
}
{
double m00_exp(d00_exp0,(DCln2*Dzr1))
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
DQ_j3_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DQ_j3_Vsi_ci_Vsi_ci=0.0;
  DQ_j3_Vsi_ci_Vb_ci=0.0;
  DQ_j3_Vsi_ci_Vbp_ci=0.0;
  DQ_j3_Vsi_ci_Vtnode_GND=0.0;
  DQ_j3_Vsi_ci_Vbi_ci=0.0;
#endif
DQ_j3_Vb_ci=0.0;
#if defined(_DERIVATE)
  DQ_j3_Vb_ci_Vsi_ci=0.0;
  DQ_j3_Vb_ci_Vb_ci=0.0;
  DQ_j3_Vb_ci_Vbp_ci=0.0;
  DQ_j3_Vb_ci_Vtnode_GND=0.0;
  DQ_j3_Vb_ci_Vbi_ci=0.0;
#endif
DQ_j3_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DQ_j3_Vbp_ci_Vsi_ci=0.0;
  DQ_j3_Vbp_ci_Vb_ci=0.0;
  DQ_j3_Vbp_ci_Vbp_ci=0.0;
  DQ_j3_Vbp_ci_Vtnode_GND=0.0;
  DQ_j3_Vbp_ci_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
DQ_j3_Vtnode_GND=(((DC_c_Vtnode_GND*(1.0-d00_exp0))+(DC_c*(-DCln2_Vtnode_GND*Dzr1*d10_exp0)))/Dzr1);
#endif
DQ_j3_Vbi_ci=((DC_c*(-DCln2_Vbi_ci*Dzr1*d10_exp0))/Dzr1);
#if defined(_DERIVATE)
  DQ_j3_Vbi_ci_Vsi_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vsi_ci*Dzr1)*d10_exp0)+0.0*(-DCln2_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln2*Dzr1))*(DCln2_Vsi_ci*Dzr1)*DCln2_Vbi_ci*Dzr1+d10_exp0*(+DCln2_Vbi_ci_Vsi_ci*Dzr1+DCln2_Vbi_ci*0.0+DCln2_Vsi_ci*0.0+DCln2*0.0))))/Dzr1-((DC_c*(-DCln2_Vbi_ci*Dzr1*d10_exp0))*0.0+((DC_c*(-(DCln2_Vsi_ci*Dzr1)*d10_exp0)))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
  DQ_j3_Vbi_ci_Vb_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vb_ci*Dzr1)*d10_exp0)+0.0*(-DCln2_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln2*Dzr1))*(DCln2_Vb_ci*Dzr1)*DCln2_Vbi_ci*Dzr1+d10_exp0*(+DCln2_Vbi_ci_Vb_ci*Dzr1+DCln2_Vbi_ci*0.0+DCln2_Vb_ci*0.0+DCln2*0.0))))/Dzr1-((DC_c*(-DCln2_Vbi_ci*Dzr1*d10_exp0))*0.0+((DC_c*(-(DCln2_Vb_ci*Dzr1)*d10_exp0)))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
  DQ_j3_Vbi_ci_Vbp_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vbp_ci*Dzr1)*d10_exp0)+0.0*(-DCln2_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln2*Dzr1))*(DCln2_Vbp_ci*Dzr1)*DCln2_Vbi_ci*Dzr1+d10_exp0*(+DCln2_Vbi_ci_Vbp_ci*Dzr1+DCln2_Vbi_ci*0.0+DCln2_Vbp_ci*0.0+DCln2*0.0))))/Dzr1-((DC_c*(-DCln2_Vbi_ci*Dzr1*d10_exp0))*0.0+((DC_c*(-(DCln2_Vbp_ci*Dzr1)*d10_exp0)))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
  DQ_j3_Vbi_ci_Vtnode_GND=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vtnode_GND*Dzr1)*d10_exp0)+DC_c_Vtnode_GND*(-DCln2_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln2*Dzr1))*(DCln2_Vtnode_GND*Dzr1)*DCln2_Vbi_ci*Dzr1+d10_exp0*(+DCln2_Vbi_ci_Vtnode_GND*Dzr1+DCln2_Vbi_ci*0.0+DCln2_Vtnode_GND*0.0+DCln2*0.0))))/Dzr1-((DC_c*(-DCln2_Vbi_ci*Dzr1*d10_exp0))*0.0+(((DC_c_Vtnode_GND*(1.0-d00_exp0))+(DC_c*(-(DCln2_Vtnode_GND*Dzr1)*d10_exp0))))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
  DQ_j3_Vbi_ci_Vbi_ci=((+0.0*(1.0-d00_exp0)+0.0*(-(DCln2_Vbi_ci*Dzr1)*d10_exp0)+0.0*(-DCln2_Vbi_ci*Dzr1*d10_exp0)+DC_c*(+0.0-(m20_exp((DCln2*Dzr1))*(DCln2_Vbi_ci*Dzr1)*DCln2_Vbi_ci*Dzr1+d10_exp0*(+DCln2_Vbi_ci_Vbi_ci*Dzr1+DCln2_Vbi_ci*0.0+DCln2_Vbi_ci*0.0+DCln2*0.0))))/Dzr1-((DC_c*(-DCln2_Vbi_ci*Dzr1*d10_exp0))*0.0+((DC_c*(-(DCln2_Vbi_ci*Dzr1)*d10_exp0)))*0.0+(DC_c*(1.0-d00_exp0))*0.0)/Dzr1/Dzr1+2*(DC_c*(1.0-d00_exp0))*0.0*0.0/Dzr1/Dzr1/Dzr1);
#endif
#endif
DQ_j3=((DC_c*(1.0-d00_exp0))/Dzr1);
}
#if defined(_DERIVATEFORDDX)
Qjci_Vbi_ei=0.0;
#if defined(_DERIVATE)
  Qjci_Vbi_ei_Vbi_ei=0.0;
  Qjci_Vbi_ei_Vtnode_GND=0.0;
  Qjci_Vbi_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Qjci_Vtnode_GND=(((((DQ_j1_Vtnode_GND+DQ_j2_Vtnode_GND)-DQ_j3_Vtnode_GND)*vdci_t)+(((DQ_j1+DQ_j2)-DQ_j3)*vdci_t_Vtnode_GND))+((DC_max_Vtnode_GND*Dv_j4)+(DC_max*Dv_j4_Vtnode_GND)));
#endif
Qjci_Vbi_ci=(((DQ_j1_Vbi_ci+DQ_j2_Vbi_ci)-DQ_j3_Vbi_ci)*vdci_t+(DC_max*Dv_j4_Vbi_ci));
#if defined(_DERIVATE)
  Qjci_Vbi_ci_Vbi_ei=(+(+(+(+0.0+0.0)-0.0)*vdci_t+((DQ_j1_Vbi_ci+DQ_j2_Vbi_ci)-DQ_j3_Vbi_ci)*0.0+0.0*0.0+((DQ_j1+DQ_j2)-DQ_j3)*0.0)+(+0.0*Dv_j4+0.0*0.0+0.0*Dv_j4_Vbi_ci+DC_max*0.0));
  Qjci_Vbi_ci_Vtnode_GND=(+(+(+(+DQ_j1_Vbi_ci_Vtnode_GND+DQ_j2_Vbi_ci_Vtnode_GND)-DQ_j3_Vbi_ci_Vtnode_GND)*vdci_t+((DQ_j1_Vbi_ci+DQ_j2_Vbi_ci)-DQ_j3_Vbi_ci)*vdci_t_Vtnode_GND+((DQ_j1_Vtnode_GND+DQ_j2_Vtnode_GND)-DQ_j3_Vtnode_GND)*0.0+((DQ_j1+DQ_j2)-DQ_j3)*0.0)+(+0.0*Dv_j4+0.0*Dv_j4_Vtnode_GND+DC_max_Vtnode_GND*Dv_j4_Vbi_ci+DC_max*Dv_j4_Vbi_ci_Vtnode_GND));
  Qjci_Vbi_ci_Vbi_ci=(+(+(+(+DQ_j1_Vbi_ci_Vbi_ci+DQ_j2_Vbi_ci_Vbi_ci)-DQ_j3_Vbi_ci_Vbi_ci)*vdci_t+((DQ_j1_Vbi_ci+DQ_j2_Vbi_ci)-DQ_j3_Vbi_ci)*0.0+((DQ_j1_Vbi_ci+DQ_j2_Vbi_ci)-DQ_j3_Vbi_ci)*0.0+((DQ_j1+DQ_j2)-DQ_j3)*0.0)+(+0.0*Dv_j4+0.0*Dv_j4_Vbi_ci+0.0*Dv_j4_Vbi_ci+DC_max*Dv_j4_Vbi_ci_Vbi_ci));
#endif
#endif
Qjci=((((DQ_j1+DQ_j2)-DQ_j3)*vdci_t)+(DC_max*Dv_j4));
}
else
{
#if defined(_DERIVATEFORDDX)
Qjci_Vbi_ei=0.0;
#if defined(_DERIVATE)
  Qjci_Vbi_ei_Vbi_ei=0.0;
  Qjci_Vbi_ei_Vtnode_GND=0.0;
  Qjci_Vbi_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Qjci_Vtnode_GND=0.0;
#endif
Qjci_Vbi_ci=0.0;
#if defined(_DERIVATE)
  Qjci_Vbi_ci_Vbi_ei=0.0;
  Qjci_Vbi_ci_Vtnode_GND=0.0;
  Qjci_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
Qjci=0.0;
}
}
else
{
if
((cjci0_t>0.0))
{
{
double m00_logE(d00_logE0,2.4)
double m00_exp(d00_exp1,((-d00_logE0)/zci))
#if defined(_DERIVATE)
DFV_f_Vtnode_GND=vdci_t_Vtnode_GND*(1.0-d00_exp1);
#endif
DFV_f=(vdci_t*(1.0-d00_exp1));
}
#if defined(_DERIVATEFORDDX)
DFv_e_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFv_e_Vsi_ci_Vsi_ci=0.0;
  DFv_e_Vsi_ci_Vb_ci=0.0;
  DFv_e_Vsi_ci_Vbp_ci=0.0;
  DFv_e_Vsi_ci_Vbi_ci=0.0;
  DFv_e_Vsi_ci_Vtnode_GND=0.0;
  DFv_e_Vsi_ci_Vbi_ei=0.0;
#endif
DFv_e_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFv_e_Vb_ci_Vsi_ci=0.0;
  DFv_e_Vb_ci_Vb_ci=0.0;
  DFv_e_Vb_ci_Vbp_ci=0.0;
  DFv_e_Vb_ci_Vbi_ci=0.0;
  DFv_e_Vb_ci_Vtnode_GND=0.0;
  DFv_e_Vb_ci_Vbi_ei=0.0;
#endif
DFv_e_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFv_e_Vbp_ci_Vsi_ci=0.0;
  DFv_e_Vbp_ci_Vb_ci=0.0;
  DFv_e_Vbp_ci_Vbp_ci=0.0;
  DFv_e_Vbp_ci_Vbi_ci=0.0;
  DFv_e_Vbp_ci_Vtnode_GND=0.0;
  DFv_e_Vbp_ci_Vbi_ei=0.0;
#endif
DFv_e_Vbi_ci=((-1.0)/VT);
#if defined(_DERIVATE)
  DFv_e_Vbi_ci_Vsi_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DFV_f-BP(bi,ci))*0.0)/VT/VT+2*(DFV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
  DFv_e_Vbi_ci_Vb_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DFV_f-BP(bi,ci))*0.0)/VT/VT+2*(DFV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
  DFv_e_Vbi_ci_Vbp_ci=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DFV_f-BP(bi,ci))*0.0)/VT/VT+2*(DFV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
  DFv_e_Vbi_ci_Vbi_ci=((+0.0-0.0)/VT-((-1.0)*0.0+(-1.0)*0.0+(DFV_f-BP(bi,ci))*0.0)/VT/VT+2*(DFV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
  DFv_e_Vbi_ci_Vtnode_GND=((+0.0-0.0)/VT-((-1.0)*VT_Vtnode_GND+DFV_f_Vtnode_GND*0.0+(DFV_f-BP(bi,ci))*0.0)/VT/VT+2*(DFV_f-BP(bi,ci))*0.0*VT_Vtnode_GND/VT/VT/VT);
  DFv_e_Vbi_ci_Vbi_ei=((+0.0-0.0)/VT-((-1.0)*0.0+0.0*0.0+(DFV_f-BP(bi,ci))*0.0)/VT/VT+2*(DFV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
#endif
#if defined(_DERIVATE)
DFv_e_Vtnode_GND=((DFV_f_Vtnode_GND*VT-(DFV_f-BP(bi,ci))*VT_Vtnode_GND)/VT/VT);
#endif
DFv_e_Vbi_ei=0.0;
#if defined(_DERIVATE)
  DFv_e_Vbi_ei_Vsi_ci=0.0;
  DFv_e_Vbi_ei_Vb_ci=0.0;
  DFv_e_Vbi_ei_Vbp_ci=0.0;
  DFv_e_Vbi_ei_Vbi_ci=0.0;
  DFv_e_Vbi_ei_Vtnode_GND=0.0;
  DFv_e_Vbi_ei_Vbi_ei=0.0;
#endif
#endif
DFv_e=((DFV_f-BP(bi,ci))/VT);
{
double m00_sqrt(d00_sqrt0,((DFv_e*DFv_e)+1.921812))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((DFv_e*DFv_e)+1.921812))
#endif
#if defined(_DERIVATEFORDDX)
DFs_q_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFs_q_Vsi_ci_Vsi_ci=0.0;
  DFs_q_Vsi_ci_Vb_ci=0.0;
  DFs_q_Vsi_ci_Vbp_ci=0.0;
  DFs_q_Vsi_ci_Vbi_ci=0.0;
  DFs_q_Vsi_ci_Vtnode_GND=0.0;
  DFs_q_Vsi_ci_Vbi_ei=0.0;
#endif
DFs_q_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFs_q_Vb_ci_Vsi_ci=0.0;
  DFs_q_Vb_ci_Vb_ci=0.0;
  DFs_q_Vb_ci_Vbp_ci=0.0;
  DFs_q_Vb_ci_Vbi_ci=0.0;
  DFs_q_Vb_ci_Vtnode_GND=0.0;
  DFs_q_Vb_ci_Vbi_ei=0.0;
#endif
DFs_q_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFs_q_Vbp_ci_Vsi_ci=0.0;
  DFs_q_Vbp_ci_Vb_ci=0.0;
  DFs_q_Vbp_ci_Vbp_ci=0.0;
  DFs_q_Vbp_ci_Vbi_ci=0.0;
  DFs_q_Vbp_ci_Vtnode_GND=0.0;
  DFs_q_Vbp_ci_Vbi_ei=0.0;
#endif
DFs_q_Vbi_ci=((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci))*d10_sqrt0;
#if defined(_DERIVATE)
  DFs_q_Vbi_ci_Vsi_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vsi_ci*DFv_e)+(DFv_e*DFv_e_Vsi_ci)))*((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci))+d10_sqrt0*(+(+DFv_e_Vbi_ci_Vsi_ci*DFv_e+DFv_e_Vbi_ci*DFv_e_Vsi_ci+DFv_e_Vsi_ci*DFv_e_Vbi_ci+DFv_e*DFv_e_Vbi_ci_Vsi_ci)+0.0));
  DFs_q_Vbi_ci_Vb_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vb_ci*DFv_e)+(DFv_e*DFv_e_Vb_ci)))*((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci))+d10_sqrt0*(+(+DFv_e_Vbi_ci_Vb_ci*DFv_e+DFv_e_Vbi_ci*DFv_e_Vb_ci+DFv_e_Vb_ci*DFv_e_Vbi_ci+DFv_e*DFv_e_Vbi_ci_Vb_ci)+0.0));
  DFs_q_Vbi_ci_Vbp_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vbp_ci*DFv_e)+(DFv_e*DFv_e_Vbp_ci)))*((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci))+d10_sqrt0*(+(+DFv_e_Vbi_ci_Vbp_ci*DFv_e+DFv_e_Vbi_ci*DFv_e_Vbp_ci+DFv_e_Vbp_ci*DFv_e_Vbi_ci+DFv_e*DFv_e_Vbi_ci_Vbp_ci)+0.0));
  DFs_q_Vbi_ci_Vbi_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci)))*((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci))+d10_sqrt0*(+(+DFv_e_Vbi_ci_Vbi_ci*DFv_e+DFv_e_Vbi_ci*DFv_e_Vbi_ci+DFv_e_Vbi_ci*DFv_e_Vbi_ci+DFv_e*DFv_e_Vbi_ci_Vbi_ci)+0.0));
  DFs_q_Vbi_ci_Vtnode_GND=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vtnode_GND*DFv_e)+(DFv_e*DFv_e_Vtnode_GND)))*((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci))+d10_sqrt0*(+(+DFv_e_Vbi_ci_Vtnode_GND*DFv_e+DFv_e_Vbi_ci*DFv_e_Vtnode_GND+DFv_e_Vtnode_GND*DFv_e_Vbi_ci+DFv_e*DFv_e_Vbi_ci_Vtnode_GND)+0.0));
  DFs_q_Vbi_ci_Vbi_ei=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei)))*((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci))+d10_sqrt0*(+(+DFv_e_Vbi_ci_Vbi_ei*DFv_e+DFv_e_Vbi_ci*DFv_e_Vbi_ei+DFv_e_Vbi_ei*DFv_e_Vbi_ci+DFv_e*DFv_e_Vbi_ci_Vbi_ei)+0.0));
#endif
#if defined(_DERIVATE)
DFs_q_Vtnode_GND=((DFv_e_Vtnode_GND*DFv_e)+(DFv_e*DFv_e_Vtnode_GND))*d10_sqrt0;
#endif
DFs_q_Vbi_ei=((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  DFs_q_Vbi_ei_Vsi_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vsi_ci*DFv_e)+(DFv_e*DFv_e_Vsi_ci)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vsi_ci*DFv_e+DFv_e_Vbi_ei*DFv_e_Vsi_ci+DFv_e_Vsi_ci*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vsi_ci)+0.0));
  DFs_q_Vbi_ei_Vb_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vb_ci*DFv_e)+(DFv_e*DFv_e_Vb_ci)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vb_ci*DFv_e+DFv_e_Vbi_ei*DFv_e_Vb_ci+DFv_e_Vb_ci*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vb_ci)+0.0));
  DFs_q_Vbi_ei_Vbp_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vbp_ci*DFv_e)+(DFv_e*DFv_e_Vbp_ci)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vbp_ci*DFv_e+DFv_e_Vbi_ei*DFv_e_Vbp_ci+DFv_e_Vbp_ci*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vbp_ci)+0.0));
  DFs_q_Vbi_ei_Vbi_ci=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vbi_ci*DFv_e)+(DFv_e*DFv_e_Vbi_ci)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vbi_ci*DFv_e+DFv_e_Vbi_ei*DFv_e_Vbi_ci+DFv_e_Vbi_ci*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vbi_ci)+0.0));
  DFs_q_Vbi_ei_Vtnode_GND=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vtnode_GND*DFv_e)+(DFv_e*DFv_e_Vtnode_GND)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vtnode_GND*DFv_e+DFv_e_Vbi_ei*DFv_e_Vtnode_GND+DFv_e_Vtnode_GND*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vtnode_GND)+0.0));
  DFs_q_Vbi_ei_Vbi_ei=(m20_sqrt(((DFv_e*DFv_e)+1.921812))*(((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei)))*((DFv_e_Vbi_ei*DFv_e)+(DFv_e*DFv_e_Vbi_ei))+d10_sqrt0*(+(+DFv_e_Vbi_ei_Vbi_ei*DFv_e+DFv_e_Vbi_ei*DFv_e_Vbi_ei+DFv_e_Vbi_ei*DFv_e_Vbi_ei+DFv_e*DFv_e_Vbi_ei_Vbi_ei)+0.0));
#endif
#endif
DFs_q=d00_sqrt0;
}
#if defined(_DERIVATEFORDDX)
DFs_q2_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFs_q2_Vsi_ci_Vsi_ci=0.0;
  DFs_q2_Vsi_ci_Vb_ci=0.0;
  DFs_q2_Vsi_ci_Vbp_ci=0.0;
  DFs_q2_Vsi_ci_Vbi_ci=0.0;
  DFs_q2_Vsi_ci_Vtnode_GND=0.0;
  DFs_q2_Vsi_ci_Vbi_ei=0.0;
#endif
DFs_q2_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFs_q2_Vb_ci_Vsi_ci=0.0;
  DFs_q2_Vb_ci_Vb_ci=0.0;
  DFs_q2_Vb_ci_Vbp_ci=0.0;
  DFs_q2_Vb_ci_Vbi_ci=0.0;
  DFs_q2_Vb_ci_Vtnode_GND=0.0;
  DFs_q2_Vb_ci_Vbi_ei=0.0;
#endif
DFs_q2_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFs_q2_Vbp_ci_Vsi_ci=0.0;
  DFs_q2_Vbp_ci_Vb_ci=0.0;
  DFs_q2_Vbp_ci_Vbp_ci=0.0;
  DFs_q2_Vbp_ci_Vbi_ci=0.0;
  DFs_q2_Vbp_ci_Vtnode_GND=0.0;
  DFs_q2_Vbp_ci_Vbi_ei=0.0;
#endif
DFs_q2_Vbi_ci=(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.5;
#if defined(_DERIVATE)
  DFs_q2_Vbi_ci_Vsi_ci=(+(+DFv_e_Vbi_ci_Vsi_ci+DFs_q_Vbi_ci_Vsi_ci)*0.5+(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.0+(DFv_e_Vsi_ci+DFs_q_Vsi_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ci_Vb_ci=(+(+DFv_e_Vbi_ci_Vb_ci+DFs_q_Vbi_ci_Vb_ci)*0.5+(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.0+(DFv_e_Vb_ci+DFs_q_Vb_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ci_Vbp_ci=(+(+DFv_e_Vbi_ci_Vbp_ci+DFs_q_Vbi_ci_Vbp_ci)*0.5+(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.0+(DFv_e_Vbp_ci+DFs_q_Vbp_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ci_Vbi_ci=(+(+DFv_e_Vbi_ci_Vbi_ci+DFs_q_Vbi_ci_Vbi_ci)*0.5+(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.0+(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ci_Vtnode_GND=(+(+DFv_e_Vbi_ci_Vtnode_GND+DFs_q_Vbi_ci_Vtnode_GND)*0.5+(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.0+(DFv_e_Vtnode_GND+DFs_q_Vtnode_GND)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ci_Vbi_ei=(+(+DFv_e_Vbi_ci_Vbi_ei+DFs_q_Vbi_ci_Vbi_ei)*0.5+(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.0+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e+DFs_q)*0.0);
#endif
#if defined(_DERIVATE)
DFs_q2_Vtnode_GND=(DFv_e_Vtnode_GND+DFs_q_Vtnode_GND)*0.5;
#endif
DFs_q2_Vbi_ei=(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.5;
#if defined(_DERIVATE)
  DFs_q2_Vbi_ei_Vsi_ci=(+(+DFv_e_Vbi_ei_Vsi_ci+DFs_q_Vbi_ei_Vsi_ci)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vsi_ci+DFs_q_Vsi_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vb_ci=(+(+DFv_e_Vbi_ei_Vb_ci+DFs_q_Vbi_ei_Vb_ci)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vb_ci+DFs_q_Vb_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vbp_ci=(+(+DFv_e_Vbi_ei_Vbp_ci+DFs_q_Vbi_ei_Vbp_ci)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vbp_ci+DFs_q_Vbp_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vbi_ci=(+(+DFv_e_Vbi_ei_Vbi_ci+DFs_q_Vbi_ei_Vbi_ci)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vbi_ci+DFs_q_Vbi_ci)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vtnode_GND=(+(+DFv_e_Vbi_ei_Vtnode_GND+DFs_q_Vbi_ei_Vtnode_GND)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vtnode_GND+DFs_q_Vtnode_GND)*0.0+(DFv_e+DFs_q)*0.0);
  DFs_q2_Vbi_ei_Vbi_ei=(+(+DFv_e_Vbi_ei_Vbi_ei+DFs_q_Vbi_ei_Vbi_ei)*0.5+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e_Vbi_ei+DFs_q_Vbi_ei)*0.0+(DFv_e+DFs_q)*0.0);
#endif
#endif
DFs_q2=((DFv_e+DFs_q)*0.5);
#if defined(_DERIVATEFORDDX)
DFv_j_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFv_j_Vsi_ci_Vsi_ci=0.0;
  DFv_j_Vsi_ci_Vb_ci=0.0;
  DFv_j_Vsi_ci_Vbp_ci=0.0;
  DFv_j_Vsi_ci_Vbi_ci=0.0;
  DFv_j_Vsi_ci_Vtnode_GND=0.0;
  DFv_j_Vsi_ci_Vbi_ei=0.0;
#endif
DFv_j_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFv_j_Vb_ci_Vsi_ci=0.0;
  DFv_j_Vb_ci_Vb_ci=0.0;
  DFv_j_Vb_ci_Vbp_ci=0.0;
  DFv_j_Vb_ci_Vbi_ci=0.0;
  DFv_j_Vb_ci_Vtnode_GND=0.0;
  DFv_j_Vb_ci_Vbi_ei=0.0;
#endif
DFv_j_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFv_j_Vbp_ci_Vsi_ci=0.0;
  DFv_j_Vbp_ci_Vb_ci=0.0;
  DFv_j_Vbp_ci_Vbp_ci=0.0;
  DFv_j_Vbp_ci_Vbi_ci=0.0;
  DFv_j_Vbp_ci_Vtnode_GND=0.0;
  DFv_j_Vbp_ci_Vbi_ei=0.0;
#endif
DFv_j_Vbi_ci=(-(VT*DFs_q2_Vbi_ci));
#if defined(_DERIVATE)
  DFv_j_Vbi_ci_Vsi_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vsi_ci+0.0*DFs_q2_Vbi_ci+VT*DFs_q2_Vbi_ci_Vsi_ci));
  DFv_j_Vbi_ci_Vb_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vb_ci+0.0*DFs_q2_Vbi_ci+VT*DFs_q2_Vbi_ci_Vb_ci));
  DFv_j_Vbi_ci_Vbp_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vbp_ci+0.0*DFs_q2_Vbi_ci+VT*DFs_q2_Vbi_ci_Vbp_ci));
  DFv_j_Vbi_ci_Vbi_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vbi_ci+0.0*DFs_q2_Vbi_ci+VT*DFs_q2_Vbi_ci_Vbi_ci));
  DFv_j_Vbi_ci_Vtnode_GND=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vtnode_GND+VT_Vtnode_GND*DFs_q2_Vbi_ci+VT*DFs_q2_Vbi_ci_Vtnode_GND));
  DFv_j_Vbi_ci_Vbi_ei=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vbi_ei+0.0*DFs_q2_Vbi_ci+VT*DFs_q2_Vbi_ci_Vbi_ei));
#endif
#if defined(_DERIVATE)
DFv_j_Vtnode_GND=(DFV_f_Vtnode_GND-((VT_Vtnode_GND*DFs_q2)+(VT*DFs_q2_Vtnode_GND)));
#endif
DFv_j_Vbi_ei=(-(VT*DFs_q2_Vbi_ei));
#if defined(_DERIVATE)
  DFv_j_Vbi_ei_Vsi_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vsi_ci+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vsi_ci));
  DFv_j_Vbi_ei_Vb_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vb_ci+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vb_ci));
  DFv_j_Vbi_ei_Vbp_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vbp_ci+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vbp_ci));
  DFv_j_Vbi_ei_Vbi_ci=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vbi_ci+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vbi_ci));
  DFv_j_Vbi_ei_Vtnode_GND=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vtnode_GND+VT_Vtnode_GND*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vtnode_GND));
  DFv_j_Vbi_ei_Vbi_ei=(+0.0-(+0.0*DFs_q2+0.0*DFs_q2_Vbi_ei+0.0*DFs_q2_Vbi_ei+VT*DFs_q2_Vbi_ei_Vbi_ei));
#endif
#endif
DFv_j=(DFV_f-(VT*DFs_q2));
{
double m00_logE(d00_logE0,(1.0-(DFv_j/vdci_t)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1.0-(DFv_j/vdci_t)))
#endif
#if defined(_DERIVATEFORDDX)
DFb_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFb_Vsi_ci_Vsi_ci=0.0;
  DFb_Vsi_ci_Vb_ci=0.0;
  DFb_Vsi_ci_Vbp_ci=0.0;
  DFb_Vsi_ci_Vbi_ci=0.0;
  DFb_Vsi_ci_Vtnode_GND=0.0;
  DFb_Vsi_ci_Vbi_ei=0.0;
#endif
DFb_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFb_Vb_ci_Vsi_ci=0.0;
  DFb_Vb_ci_Vb_ci=0.0;
  DFb_Vb_ci_Vbp_ci=0.0;
  DFb_Vb_ci_Vbi_ci=0.0;
  DFb_Vb_ci_Vtnode_GND=0.0;
  DFb_Vb_ci_Vbi_ei=0.0;
#endif
DFb_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFb_Vbp_ci_Vsi_ci=0.0;
  DFb_Vbp_ci_Vb_ci=0.0;
  DFb_Vbp_ci_Vbp_ci=0.0;
  DFb_Vbp_ci_Vbi_ci=0.0;
  DFb_Vbp_ci_Vtnode_GND=0.0;
  DFb_Vbp_ci_Vbi_ei=0.0;
#endif
DFb_Vbi_ci=(-(DFv_j_Vbi_ci/vdci_t))*d10_logE0;
#if defined(_DERIVATE)
  DFb_Vbi_ci_Vsi_ci=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vsi_ci/vdci_t))*(-(DFv_j_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ci_Vsi_ci/vdci_t-(DFv_j_Vbi_ci*0.0+DFv_j_Vsi_ci*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ci_Vb_ci=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vb_ci/vdci_t))*(-(DFv_j_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ci_Vb_ci/vdci_t-(DFv_j_Vbi_ci*0.0+DFv_j_Vb_ci*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ci_Vbp_ci=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vbp_ci/vdci_t))*(-(DFv_j_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ci_Vbp_ci/vdci_t-(DFv_j_Vbi_ci*0.0+DFv_j_Vbp_ci*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ci_Vbi_ci=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vbi_ci/vdci_t))*(-(DFv_j_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ci_Vbi_ci/vdci_t-(DFv_j_Vbi_ci*0.0+DFv_j_Vbi_ci*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ci_Vtnode_GND=(m20_logE((1.0-(DFv_j/vdci_t)))*(-((DFv_j_Vtnode_GND*vdci_t-DFv_j*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*(-(DFv_j_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ci_Vtnode_GND/vdci_t-(DFv_j_Vbi_ci*vdci_t_Vtnode_GND+DFv_j_Vtnode_GND*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*vdci_t_Vtnode_GND/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ci_Vbi_ei=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vbi_ei/vdci_t))*(-(DFv_j_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ci_Vbi_ei/vdci_t-(DFv_j_Vbi_ci*0.0+DFv_j_Vbi_ei*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
#endif
#if defined(_DERIVATE)
DFb_Vtnode_GND=(-((DFv_j_Vtnode_GND*vdci_t-DFv_j*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*d10_logE0;
#endif
DFb_Vbi_ei=(-(DFv_j_Vbi_ei/vdci_t))*d10_logE0;
#if defined(_DERIVATE)
  DFb_Vbi_ei_Vsi_ci=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vsi_ci/vdci_t))*(-(DFv_j_Vbi_ei/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vsi_ci/vdci_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vsi_ci*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ei_Vb_ci=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vb_ci/vdci_t))*(-(DFv_j_Vbi_ei/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vb_ci/vdci_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vb_ci*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ei_Vbp_ci=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vbp_ci/vdci_t))*(-(DFv_j_Vbi_ei/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vbp_ci/vdci_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vbp_ci*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ei_Vbi_ci=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vbi_ci/vdci_t))*(-(DFv_j_Vbi_ei/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vbi_ci/vdci_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vbi_ci*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ei_Vtnode_GND=(m20_logE((1.0-(DFv_j/vdci_t)))*(-((DFv_j_Vtnode_GND*vdci_t-DFv_j*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*(-(DFv_j_Vbi_ei/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vtnode_GND/vdci_t-(DFv_j_Vbi_ei*vdci_t_Vtnode_GND+DFv_j_Vtnode_GND*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*vdci_t_Vtnode_GND/vdci_t/vdci_t/vdci_t)));
  DFb_Vbi_ei_Vbi_ei=(m20_logE((1.0-(DFv_j/vdci_t)))*(-(DFv_j_Vbi_ei/vdci_t))*(-(DFv_j_Vbi_ei/vdci_t))+d10_logE0*(+0.0-(DFv_j_Vbi_ei_Vbi_ei/vdci_t-(DFv_j_Vbi_ei*0.0+DFv_j_Vbi_ei*0.0+DFv_j*0.0)/vdci_t/vdci_t+2*DFv_j*0.0*0.0/vdci_t/vdci_t/vdci_t)));
#endif
#endif
DFb=d00_logE0;
}
{
double m00_exp(d00_exp0,(DFb*(1.0-zci)))
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
DFQ_j_Vsi_ci=0.0;
#if defined(_DERIVATE)
  DFQ_j_Vsi_ci_Vsi_ci=0.0;
  DFQ_j_Vsi_ci_Vb_ci=0.0;
  DFQ_j_Vsi_ci_Vbp_ci=0.0;
  DFQ_j_Vsi_ci_Vbi_ci=0.0;
  DFQ_j_Vsi_ci_Vtnode_GND=0.0;
  DFQ_j_Vsi_ci_Vbi_ei=0.0;
#endif
DFQ_j_Vb_ci=0.0;
#if defined(_DERIVATE)
  DFQ_j_Vb_ci_Vsi_ci=0.0;
  DFQ_j_Vb_ci_Vb_ci=0.0;
  DFQ_j_Vb_ci_Vbp_ci=0.0;
  DFQ_j_Vb_ci_Vbi_ci=0.0;
  DFQ_j_Vb_ci_Vtnode_GND=0.0;
  DFQ_j_Vb_ci_Vbi_ei=0.0;
#endif
DFQ_j_Vbp_ci=0.0;
#if defined(_DERIVATE)
  DFQ_j_Vbp_ci_Vsi_ci=0.0;
  DFQ_j_Vbp_ci_Vb_ci=0.0;
  DFQ_j_Vbp_ci_Vbp_ci=0.0;
  DFQ_j_Vbp_ci_Vbi_ci=0.0;
  DFQ_j_Vbp_ci_Vtnode_GND=0.0;
  DFQ_j_Vbp_ci_Vbi_ei=0.0;
#endif
DFQ_j_Vbi_ci=(((cjci0_t*vdci_t)*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0))/(1.0-zci));
#if defined(_DERIVATE)
  DFQ_j_Vbi_ci_Vsi_ci=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vsi_ci*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vsi_ci*(1.0-zci))*DFb_Vbi_ci*(1.0-zci)+d10_exp0*(+DFb_Vbi_ci_Vsi_ci*(1.0-zci)+DFb_Vbi_ci*0.0+DFb_Vsi_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vsi_ci*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ci_Vb_ci=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vb_ci*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vb_ci*(1.0-zci))*DFb_Vbi_ci*(1.0-zci)+d10_exp0*(+DFb_Vbi_ci_Vb_ci*(1.0-zci)+DFb_Vbi_ci*0.0+DFb_Vb_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vb_ci*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ci_Vbp_ci=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vbp_ci*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vbp_ci*(1.0-zci))*DFb_Vbi_ci*(1.0-zci)+d10_exp0*(+DFb_Vbi_ci_Vbp_ci*(1.0-zci)+DFb_Vbi_ci*0.0+DFb_Vbp_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vbp_ci*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ci_Vbi_ci=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vbi_ci*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vbi_ci*(1.0-zci))*DFb_Vbi_ci*(1.0-zci)+d10_exp0*(+DFb_Vbi_ci_Vbi_ci*(1.0-zci)+DFb_Vbi_ci*0.0+DFb_Vbi_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vbi_ci*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ci_Vtnode_GND=((+(+0.0*vdci_t+0.0*vdci_t_Vtnode_GND+cjci0_t_Vtnode_GND*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vtnode_GND*(1.0-zci))*d10_exp0)+(((cjci0_t_Vtnode_GND*vdci_t)+(cjci0_t*vdci_t_Vtnode_GND)))*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vtnode_GND*(1.0-zci))*DFb_Vbi_ci*(1.0-zci)+d10_exp0*(+DFb_Vbi_ci_Vtnode_GND*(1.0-zci)+DFb_Vbi_ci*0.0+DFb_Vtnode_GND*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0))*0.0+((((((cjci0_t_Vtnode_GND*vdci_t)+(cjci0_t*vdci_t_Vtnode_GND)))*(1.0-d00_exp0))+((cjci0_t*vdci_t)*(-(DFb_Vtnode_GND*(1.0-zci))*d10_exp0))))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ci_Vbi_ei=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vbi_ei*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vbi_ei*(1.0-zci))*DFb_Vbi_ci*(1.0-zci)+d10_exp0*(+DFb_Vbi_ci_Vbi_ei*(1.0-zci)+DFb_Vbi_ci*0.0+DFb_Vbi_ei*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ci*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vbi_ei*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
#endif
#if defined(_DERIVATE)
DFQ_j_Vtnode_GND=(((((cjci0_t_Vtnode_GND*vdci_t)+(cjci0_t*vdci_t_Vtnode_GND))*(1.0-d00_exp0))+((cjci0_t*vdci_t)*(-DFb_Vtnode_GND*(1.0-zci)*d10_exp0)))/(1.0-zci));
#endif
DFQ_j_Vbi_ei=(((cjci0_t*vdci_t)*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0))/(1.0-zci));
#if defined(_DERIVATE)
  DFQ_j_Vbi_ei_Vsi_ci=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vsi_ci*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vsi_ci*(1.0-zci))*DFb_Vbi_ei*(1.0-zci)+d10_exp0*(+DFb_Vbi_ei_Vsi_ci*(1.0-zci)+DFb_Vbi_ei*0.0+DFb_Vsi_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vsi_ci*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ei_Vb_ci=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vb_ci*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vb_ci*(1.0-zci))*DFb_Vbi_ei*(1.0-zci)+d10_exp0*(+DFb_Vbi_ei_Vb_ci*(1.0-zci)+DFb_Vbi_ei*0.0+DFb_Vb_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vb_ci*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ei_Vbp_ci=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vbp_ci*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vbp_ci*(1.0-zci))*DFb_Vbi_ei*(1.0-zci)+d10_exp0*(+DFb_Vbi_ei_Vbp_ci*(1.0-zci)+DFb_Vbi_ei*0.0+DFb_Vbp_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vbp_ci*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ei_Vbi_ci=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vbi_ci*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vbi_ci*(1.0-zci))*DFb_Vbi_ei*(1.0-zci)+d10_exp0*(+DFb_Vbi_ei_Vbi_ci*(1.0-zci)+DFb_Vbi_ei*0.0+DFb_Vbi_ci*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vbi_ci*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ei_Vtnode_GND=((+(+0.0*vdci_t+0.0*vdci_t_Vtnode_GND+cjci0_t_Vtnode_GND*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vtnode_GND*(1.0-zci))*d10_exp0)+(((cjci0_t_Vtnode_GND*vdci_t)+(cjci0_t*vdci_t_Vtnode_GND)))*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vtnode_GND*(1.0-zci))*DFb_Vbi_ei*(1.0-zci)+d10_exp0*(+DFb_Vbi_ei_Vtnode_GND*(1.0-zci)+DFb_Vbi_ei*0.0+DFb_Vtnode_GND*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0))*0.0+((((((cjci0_t_Vtnode_GND*vdci_t)+(cjci0_t*vdci_t_Vtnode_GND)))*(1.0-d00_exp0))+((cjci0_t*vdci_t)*(-(DFb_Vtnode_GND*(1.0-zci))*d10_exp0))))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
  DFQ_j_Vbi_ei_Vbi_ei=((+(+0.0*vdci_t+0.0*0.0+0.0*0.0+cjci0_t*0.0)*(1.0-d00_exp0)+0.0*(-(DFb_Vbi_ei*(1.0-zci))*d10_exp0)+0.0*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0)+(cjci0_t*vdci_t)*(+0.0-(m20_exp((DFb*(1.0-zci)))*(DFb_Vbi_ei*(1.0-zci))*DFb_Vbi_ei*(1.0-zci)+d10_exp0*(+DFb_Vbi_ei_Vbi_ei*(1.0-zci)+DFb_Vbi_ei*0.0+DFb_Vbi_ei*0.0+DFb*(+0.0-0.0)))))/(1.0-zci)-(((cjci0_t*vdci_t)*(-DFb_Vbi_ei*(1.0-zci)*d10_exp0))*0.0+(((cjci0_t*vdci_t)*(-(DFb_Vbi_ei*(1.0-zci))*d10_exp0)))*0.0+((cjci0_t*vdci_t)*(1.0-d00_exp0))*(+0.0-0.0))/(1.0-zci)/(1.0-zci)+2*((cjci0_t*vdci_t)*(1.0-d00_exp0))*0.0*0.0/(1.0-zci)/(1.0-zci)/(1.0-zci));
#endif
#endif
DFQ_j=(((cjci0_t*vdci_t)*(1.0-d00_exp0))/(1.0-zci));
}
#if defined(_DERIVATEFORDDX)
Qjci_Vbi_ei=(DFQ_j_Vbi_ei+((2.4*cjci0_t)*(-DFv_j_Vbi_ei)));
#if defined(_DERIVATE)
  Qjci_Vbi_ei_Vbi_ei=(+DFQ_j_Vbi_ei_Vbi_ei+(+(+0.0*cjci0_t+0.0*0.0+0.0*0.0+2.4*0.0)*(BP(bi,ci)-DFv_j)+0.0*(-DFv_j_Vbi_ei)+0.0*(-DFv_j_Vbi_ei)+(2.4*cjci0_t)*(+0.0-DFv_j_Vbi_ei_Vbi_ei)));
  Qjci_Vbi_ei_Vtnode_GND=(+DFQ_j_Vbi_ei_Vtnode_GND+(+(+0.0*cjci0_t+0.0*cjci0_t_Vtnode_GND+0.0*0.0+2.4*0.0)*(BP(bi,ci)-DFv_j)+0.0*(-DFv_j_Vtnode_GND)+((2.4*cjci0_t_Vtnode_GND))*(-DFv_j_Vbi_ei)+(2.4*cjci0_t)*(+0.0-DFv_j_Vbi_ei_Vtnode_GND)));
  Qjci_Vbi_ei_Vbi_ci=(+DFQ_j_Vbi_ei_Vbi_ci+(+(+0.0*cjci0_t+0.0*0.0+0.0*0.0+2.4*0.0)*(BP(bi,ci)-DFv_j)+0.0*(1.0-DFv_j_Vbi_ci)+0.0*(-DFv_j_Vbi_ei)+(2.4*cjci0_t)*(+0.0-DFv_j_Vbi_ei_Vbi_ci)));
#endif
#if defined(_DERIVATE)
Qjci_Vtnode_GND=(DFQ_j_Vtnode_GND+(((2.4*cjci0_t_Vtnode_GND)*(BP(bi,ci)-DFv_j))+((2.4*cjci0_t)*(-DFv_j_Vtnode_GND))));
#endif
Qjci_Vbi_ci=(DFQ_j_Vbi_ci+((2.4*cjci0_t)*(1.0-DFv_j_Vbi_ci)));
#if defined(_DERIVATE)
  Qjci_Vbi_ci_Vbi_ei=(+DFQ_j_Vbi_ci_Vbi_ei+(+(+0.0*cjci0_t+0.0*0.0+0.0*0.0+2.4*0.0)*(BP(bi,ci)-DFv_j)+0.0*(-DFv_j_Vbi_ei)+0.0*(1.0-DFv_j_Vbi_ci)+(2.4*cjci0_t)*(+0.0-DFv_j_Vbi_ci_Vbi_ei)));
  Qjci_Vbi_ci_Vtnode_GND=(+DFQ_j_Vbi_ci_Vtnode_GND+(+(+0.0*cjci0_t+0.0*cjci0_t_Vtnode_GND+0.0*0.0+2.4*0.0)*(BP(bi,ci)-DFv_j)+0.0*(-DFv_j_Vtnode_GND)+((2.4*cjci0_t_Vtnode_GND))*(1.0-DFv_j_Vbi_ci)+(2.4*cjci0_t)*(+0.0-DFv_j_Vbi_ci_Vtnode_GND)));
  Qjci_Vbi_ci_Vbi_ci=(+DFQ_j_Vbi_ci_Vbi_ci+(+(+0.0*cjci0_t+0.0*0.0+0.0*0.0+2.4*0.0)*(BP(bi,ci)-DFv_j)+0.0*(1.0-DFv_j_Vbi_ci)+0.0*(1.0-DFv_j_Vbi_ci)+(2.4*cjci0_t)*(+0.0-DFv_j_Vbi_ci_Vbi_ci)));
#endif
#endif
Qjci=(DFQ_j+((2.4*cjci0_t)*(BP(bi,ci)-DFv_j)));
}
else
{
#if defined(_DERIVATEFORDDX)
Qjci_Vbi_ei=0.0;
#if defined(_DERIVATE)
  Qjci_Vbi_ei_Vbi_ei=0.0;
  Qjci_Vbi_ei_Vtnode_GND=0.0;
  Qjci_Vbi_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Qjci_Vtnode_GND=0.0;
#endif
Qjci_Vbi_ci=0.0;
#if defined(_DERIVATE)
  Qjci_Vbi_ci_Vbi_ei=0.0;
  Qjci_Vbi_ci_Vtnode_GND=0.0;
  Qjci_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
Qjci=0.0;
}
}
#if defined(_DDX)
#if defined(_DERIVATE)
Cjci_Vbi_ei=+(Qjci_Vbi_ei_Vbi_ei)+(Qjci_Vbi_ci_Vbi_ei);
Cjci_Vtnode_GND=+(Qjci_Vbi_ei_Vtnode_GND)+(Qjci_Vbi_ci_Vtnode_GND);
Cjci_Vbi_ci=+(Qjci_Vbi_ei_Vbi_ci)+(Qjci_Vbi_ci_Vbi_ci);
#endif
Cjci=+(Qjci_Vbi_ei)+(Qjci_Vbi_ci);
#endif
a_bpt=0.05;
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
Q_0_Vtnode_GND=((qp0_t_Vtnode_GND+(hjei*Qjei_Vtnode_GND))+(hjci*Qjci_Vtnode_GND));
#endif
Q_0_Vbi_ei=((hjei*Qjei_Vbi_ei)+(hjci*Qjci_Vbi_ei));
#if defined(_DERIVATE)
  Q_0_Vbi_ei_Vtnode_GND=(+(+0.0+(+0.0*Qjei+0.0*Qjei_Vtnode_GND+0.0*Qjei_Vbi_ei+hjei*Qjei_Vbi_ei_Vtnode_GND))+(+0.0*Qjci+0.0*Qjci_Vtnode_GND+0.0*Qjci_Vbi_ei+hjci*Qjci_Vbi_ei_Vtnode_GND));
  Q_0_Vbi_ei_Vbi_ei=(+(+0.0+(+0.0*Qjei+0.0*Qjei_Vbi_ei+0.0*Qjei_Vbi_ei+hjei*Qjei_Vbi_ei_Vbi_ei))+(+0.0*Qjci+0.0*Qjci_Vbi_ei+0.0*Qjci_Vbi_ei+hjci*Qjci_Vbi_ei_Vbi_ei));
  Q_0_Vbi_ei_Vbi_ci=(+(+0.0+(+0.0*Qjei+0.0*0.0+0.0*Qjei_Vbi_ei+hjei*0.0))+(+0.0*Qjci+0.0*Qjci_Vbi_ci+0.0*Qjci_Vbi_ei+hjci*Qjci_Vbi_ei_Vbi_ci));
#endif
Q_0_Vbi_ci=(hjci*Qjci_Vbi_ci);
#if defined(_DERIVATE)
  Q_0_Vbi_ci_Vtnode_GND=(+(+0.0+(+0.0*Qjei+0.0*Qjei_Vtnode_GND+0.0*0.0+hjei*0.0))+(+0.0*Qjci+0.0*Qjci_Vtnode_GND+0.0*Qjci_Vbi_ci+hjci*Qjci_Vbi_ci_Vtnode_GND));
  Q_0_Vbi_ci_Vbi_ei=(+(+0.0+(+0.0*Qjei+0.0*Qjei_Vbi_ei+0.0*0.0+hjei*0.0))+(+0.0*Qjci+0.0*Qjci_Vbi_ei+0.0*Qjci_Vbi_ci+hjci*Qjci_Vbi_ci_Vbi_ei));
  Q_0_Vbi_ci_Vbi_ci=(+(+0.0+(+0.0*Qjei+0.0*0.0+0.0*0.0+hjei*0.0))+(+0.0*Qjci+0.0*Qjci_Vbi_ci+0.0*Qjci_Vbi_ci+hjci*Qjci_Vbi_ci_Vbi_ci));
#endif
#endif
Q_0=((qp0_t+(hjei*Qjei))+(hjci*Qjci));
#if defined(_DERIVATE)
Q_bpt_Vtnode_GND=(a_bpt*qp0_t_Vtnode_GND);
#endif
Q_bpt=(a_bpt*qp0_t);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
b_q_Vtnode_GND=((Q_0_Vtnode_GND*Q_bpt-Q_0*Q_bpt_Vtnode_GND)/Q_bpt/Q_bpt);
#endif
b_q_Vbi_ei=(Q_0_Vbi_ei/Q_bpt);
#if defined(_DERIVATE)
  b_q_Vbi_ei_Vtnode_GND=(+(Q_0_Vbi_ei_Vtnode_GND/Q_bpt-(Q_0_Vbi_ei*Q_bpt_Vtnode_GND+Q_0_Vtnode_GND*0.0+Q_0*0.0)/Q_bpt/Q_bpt+2*Q_0*0.0*Q_bpt_Vtnode_GND/Q_bpt/Q_bpt/Q_bpt)-0.0);
  b_q_Vbi_ei_Vbi_ei=(+(Q_0_Vbi_ei_Vbi_ei/Q_bpt-(Q_0_Vbi_ei*0.0+Q_0_Vbi_ei*0.0+Q_0*0.0)/Q_bpt/Q_bpt+2*Q_0*0.0*0.0/Q_bpt/Q_bpt/Q_bpt)-0.0);
  b_q_Vbi_ei_Vbi_ci=(+(Q_0_Vbi_ei_Vbi_ci/Q_bpt-(Q_0_Vbi_ei*0.0+Q_0_Vbi_ci*0.0+Q_0*0.0)/Q_bpt/Q_bpt+2*Q_0*0.0*0.0/Q_bpt/Q_bpt/Q_bpt)-0.0);
#endif
b_q_Vbi_ci=(Q_0_Vbi_ci/Q_bpt);
#if defined(_DERIVATE)
  b_q_Vbi_ci_Vtnode_GND=(+(Q_0_Vbi_ci_Vtnode_GND/Q_bpt-(Q_0_Vbi_ci*Q_bpt_Vtnode_GND+Q_0_Vtnode_GND*0.0+Q_0*0.0)/Q_bpt/Q_bpt+2*Q_0*0.0*Q_bpt_Vtnode_GND/Q_bpt/Q_bpt/Q_bpt)-0.0);
  b_q_Vbi_ci_Vbi_ei=(+(Q_0_Vbi_ci_Vbi_ei/Q_bpt-(Q_0_Vbi_ci*0.0+Q_0_Vbi_ei*0.0+Q_0*0.0)/Q_bpt/Q_bpt+2*Q_0*0.0*0.0/Q_bpt/Q_bpt/Q_bpt)-0.0);
  b_q_Vbi_ci_Vbi_ci=(+(Q_0_Vbi_ci_Vbi_ci/Q_bpt-(Q_0_Vbi_ci*0.0+Q_0_Vbi_ci*0.0+Q_0*0.0)/Q_bpt/Q_bpt+2*Q_0*0.0*0.0/Q_bpt/Q_bpt/Q_bpt)-0.0);
#endif
#endif
b_q=((Q_0/Q_bpt)-1);
{
double m00_sqrt(d00_sqrt0,((b_q*b_q)+1.921812))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((b_q*b_q)+1.921812))
#endif
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
Q_0_Vtnode_GND=((Q_bpt_Vtnode_GND*(1+((b_q+d00_sqrt0)/2)))+(Q_bpt*((b_q_Vtnode_GND+((b_q_Vtnode_GND*b_q)+(b_q*b_q_Vtnode_GND))*d10_sqrt0)/2)));
#endif
Q_0_Vbi_ei=(Q_bpt*((b_q_Vbi_ei+((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))*d10_sqrt0)/2));
#if defined(_DERIVATE)
  Q_0_Vbi_ei_Vtnode_GND=(+0.0*(1+((b_q+d00_sqrt0)/2))+0.0*((b_q_Vtnode_GND+(((b_q_Vtnode_GND*b_q)+(b_q*b_q_Vtnode_GND)))*d10_sqrt0)/2)+Q_bpt_Vtnode_GND*((b_q_Vbi_ei+((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))*d10_sqrt0)/2)+Q_bpt*(+0.0+((+b_q_Vbi_ei_Vtnode_GND+(m20_sqrt(((b_q*b_q)+1.921812))*(((b_q_Vtnode_GND*b_q)+(b_q*b_q_Vtnode_GND)))*((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))+d10_sqrt0*(+(+b_q_Vbi_ei_Vtnode_GND*b_q+b_q_Vbi_ei*b_q_Vtnode_GND+b_q_Vtnode_GND*b_q_Vbi_ei+b_q*b_q_Vbi_ei_Vtnode_GND)+0.0)))/2-((b_q_Vbi_ei+((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))*d10_sqrt0)*0.0+(b_q_Vtnode_GND+(((b_q_Vtnode_GND*b_q)+(b_q*b_q_Vtnode_GND)))*d10_sqrt0)*0.0+(b_q+d00_sqrt0)*0.0)/2/2+2*(b_q+d00_sqrt0)*0.0*0.0/2/2/2)));
  Q_0_Vbi_ei_Vbi_ei=(+0.0*(1+((b_q+d00_sqrt0)/2))+0.0*((b_q_Vbi_ei+(((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei)))*d10_sqrt0)/2)+0.0*((b_q_Vbi_ei+((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))*d10_sqrt0)/2)+Q_bpt*(+0.0+((+b_q_Vbi_ei_Vbi_ei+(m20_sqrt(((b_q*b_q)+1.921812))*(((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei)))*((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))+d10_sqrt0*(+(+b_q_Vbi_ei_Vbi_ei*b_q+b_q_Vbi_ei*b_q_Vbi_ei+b_q_Vbi_ei*b_q_Vbi_ei+b_q*b_q_Vbi_ei_Vbi_ei)+0.0)))/2-((b_q_Vbi_ei+((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))*d10_sqrt0)*0.0+(b_q_Vbi_ei+(((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei)))*d10_sqrt0)*0.0+(b_q+d00_sqrt0)*0.0)/2/2+2*(b_q+d00_sqrt0)*0.0*0.0/2/2/2)));
  Q_0_Vbi_ei_Vbi_ci=(+0.0*(1+((b_q+d00_sqrt0)/2))+0.0*((b_q_Vbi_ci+(((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci)))*d10_sqrt0)/2)+0.0*((b_q_Vbi_ei+((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))*d10_sqrt0)/2)+Q_bpt*(+0.0+((+b_q_Vbi_ei_Vbi_ci+(m20_sqrt(((b_q*b_q)+1.921812))*(((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci)))*((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))+d10_sqrt0*(+(+b_q_Vbi_ei_Vbi_ci*b_q+b_q_Vbi_ei*b_q_Vbi_ci+b_q_Vbi_ci*b_q_Vbi_ei+b_q*b_q_Vbi_ei_Vbi_ci)+0.0)))/2-((b_q_Vbi_ei+((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei))*d10_sqrt0)*0.0+(b_q_Vbi_ci+(((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci)))*d10_sqrt0)*0.0+(b_q+d00_sqrt0)*0.0)/2/2+2*(b_q+d00_sqrt0)*0.0*0.0/2/2/2)));
#endif
Q_0_Vbi_ci=(Q_bpt*((b_q_Vbi_ci+((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))*d10_sqrt0)/2));
#if defined(_DERIVATE)
  Q_0_Vbi_ci_Vtnode_GND=(+0.0*(1+((b_q+d00_sqrt0)/2))+0.0*((b_q_Vtnode_GND+(((b_q_Vtnode_GND*b_q)+(b_q*b_q_Vtnode_GND)))*d10_sqrt0)/2)+Q_bpt_Vtnode_GND*((b_q_Vbi_ci+((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))*d10_sqrt0)/2)+Q_bpt*(+0.0+((+b_q_Vbi_ci_Vtnode_GND+(m20_sqrt(((b_q*b_q)+1.921812))*(((b_q_Vtnode_GND*b_q)+(b_q*b_q_Vtnode_GND)))*((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))+d10_sqrt0*(+(+b_q_Vbi_ci_Vtnode_GND*b_q+b_q_Vbi_ci*b_q_Vtnode_GND+b_q_Vtnode_GND*b_q_Vbi_ci+b_q*b_q_Vbi_ci_Vtnode_GND)+0.0)))/2-((b_q_Vbi_ci+((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))*d10_sqrt0)*0.0+(b_q_Vtnode_GND+(((b_q_Vtnode_GND*b_q)+(b_q*b_q_Vtnode_GND)))*d10_sqrt0)*0.0+(b_q+d00_sqrt0)*0.0)/2/2+2*(b_q+d00_sqrt0)*0.0*0.0/2/2/2)));
  Q_0_Vbi_ci_Vbi_ei=(+0.0*(1+((b_q+d00_sqrt0)/2))+0.0*((b_q_Vbi_ei+(((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei)))*d10_sqrt0)/2)+0.0*((b_q_Vbi_ci+((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))*d10_sqrt0)/2)+Q_bpt*(+0.0+((+b_q_Vbi_ci_Vbi_ei+(m20_sqrt(((b_q*b_q)+1.921812))*(((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei)))*((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))+d10_sqrt0*(+(+b_q_Vbi_ci_Vbi_ei*b_q+b_q_Vbi_ci*b_q_Vbi_ei+b_q_Vbi_ei*b_q_Vbi_ci+b_q*b_q_Vbi_ci_Vbi_ei)+0.0)))/2-((b_q_Vbi_ci+((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))*d10_sqrt0)*0.0+(b_q_Vbi_ei+(((b_q_Vbi_ei*b_q)+(b_q*b_q_Vbi_ei)))*d10_sqrt0)*0.0+(b_q+d00_sqrt0)*0.0)/2/2+2*(b_q+d00_sqrt0)*0.0*0.0/2/2/2)));
  Q_0_Vbi_ci_Vbi_ci=(+0.0*(1+((b_q+d00_sqrt0)/2))+0.0*((b_q_Vbi_ci+(((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci)))*d10_sqrt0)/2)+0.0*((b_q_Vbi_ci+((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))*d10_sqrt0)/2)+Q_bpt*(+0.0+((+b_q_Vbi_ci_Vbi_ci+(m20_sqrt(((b_q*b_q)+1.921812))*(((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci)))*((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))+d10_sqrt0*(+(+b_q_Vbi_ci_Vbi_ci*b_q+b_q_Vbi_ci*b_q_Vbi_ci+b_q_Vbi_ci*b_q_Vbi_ci+b_q*b_q_Vbi_ci_Vbi_ci)+0.0)))/2-((b_q_Vbi_ci+((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci))*d10_sqrt0)*0.0+(b_q_Vbi_ci+(((b_q_Vbi_ci*b_q)+(b_q*b_q_Vbi_ci)))*d10_sqrt0)*0.0+(b_q+d00_sqrt0)*0.0)/2/2+2*(b_q+d00_sqrt0)*0.0*0.0/2/2/2)));
#endif
#endif
Q_0=(Q_bpt*(1+((b_q+d00_sqrt0)/2)));
}
if
((cjci0_t>0.0))
{
double cV_f;
double cv_e;
double cs_q;
double cs_q2;
double cv_j;
double cdvj_dv;
#if defined(_DERIVATE)
double cV_f_Vtnode_GND;
#endif
#if defined(_DERIVATE)
double cv_e_Vtnode_GND;
#endif
#if defined(_DERIVATEFORDDX)
double cv_e_Vbi_ci;
#endif
#if defined(_DERIVATE)
double cs_q_Vtnode_GND;
#endif
#if defined(_DERIVATEFORDDX)
double cs_q_Vbi_ci;
#endif
#if defined(_DERIVATE)
double cs_q2_Vtnode_GND;
#endif
#if defined(_DERIVATEFORDDX)
double cs_q2_Vbi_ci;
#endif
#if defined(_DERIVATE)
double cv_j_Vtnode_GND;
#endif
#if defined(_DERIVATEFORDDX)
double cv_j_Vbi_ci;
#endif
#if defined(_DERIVATE)
double cdvj_dv_Vtnode_GND;
#endif
#if defined(_DERIVATEFORDDX)
double cdvj_dv_Vbi_ci;
#endif
#if defined(_DERIVATE)
  double cv_e_Vbi_ci_Vtnode_GND;
  double cv_e_Vbi_ci_Vbi_ci;
#endif
#if defined(_DERIVATE)
  double cs_q_Vbi_ci_Vtnode_GND;
  double cs_q_Vbi_ci_Vbi_ci;
#endif
#if defined(_DERIVATE)
  double cs_q2_Vbi_ci_Vtnode_GND;
  double cs_q2_Vbi_ci_Vbi_ci;
#endif
#if defined(_DERIVATE)
  double cv_j_Vbi_ci_Vtnode_GND;
  double cv_j_Vbi_ci_Vbi_ci;
#endif
#if defined(_DERIVATE)
  double cdvj_dv_Vbi_ci_Vtnode_GND;
  double cdvj_dv_Vbi_ci_Vbi_ci;
#endif
{
double m00_logE(d00_logE0,2.4)
double m00_exp(d00_exp1,((-d00_logE0)/zci))
#if defined(_DERIVATE)
cV_f_Vtnode_GND=vdci_t_Vtnode_GND*(1.0-d00_exp1);
#endif
cV_f=(vdci_t*(1.0-d00_exp1));
}
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
cv_e_Vtnode_GND=((cV_f_Vtnode_GND*VT-(cV_f-BP(bi,ci))*VT_Vtnode_GND)/VT/VT);
#endif
cv_e_Vbi_ci=((-1.0)/VT);
#if defined(_DERIVATE)
  cv_e_Vbi_ci_Vtnode_GND=((+0.0-0.0)/VT-((-1.0)*VT_Vtnode_GND+cV_f_Vtnode_GND*0.0+(cV_f-BP(bi,ci))*0.0)/VT/VT+2*(cV_f-BP(bi,ci))*0.0*VT_Vtnode_GND/VT/VT/VT);
  cv_e_Vbi_ci_Vbi_ci=((+0.0-0.0)/VT-((-1.0)*0.0+(-1.0)*0.0+(cV_f-BP(bi,ci))*0.0)/VT/VT+2*(cV_f-BP(bi,ci))*0.0*0.0/VT/VT/VT);
#endif
#endif
cv_e=((cV_f-BP(bi,ci))/VT);
{
double m00_sqrt(d00_sqrt0,((cv_e*cv_e)+1.921812))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((cv_e*cv_e)+1.921812))
#endif
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
cs_q_Vtnode_GND=((cv_e_Vtnode_GND*cv_e)+(cv_e*cv_e_Vtnode_GND))*d10_sqrt0;
#endif
cs_q_Vbi_ci=((cv_e_Vbi_ci*cv_e)+(cv_e*cv_e_Vbi_ci))*d10_sqrt0;
#if defined(_DERIVATE)
  cs_q_Vbi_ci_Vtnode_GND=(m20_sqrt(((cv_e*cv_e)+1.921812))*(((cv_e_Vtnode_GND*cv_e)+(cv_e*cv_e_Vtnode_GND)))*((cv_e_Vbi_ci*cv_e)+(cv_e*cv_e_Vbi_ci))+d10_sqrt0*(+(+cv_e_Vbi_ci_Vtnode_GND*cv_e+cv_e_Vbi_ci*cv_e_Vtnode_GND+cv_e_Vtnode_GND*cv_e_Vbi_ci+cv_e*cv_e_Vbi_ci_Vtnode_GND)+0.0));
  cs_q_Vbi_ci_Vbi_ci=(m20_sqrt(((cv_e*cv_e)+1.921812))*(((cv_e_Vbi_ci*cv_e)+(cv_e*cv_e_Vbi_ci)))*((cv_e_Vbi_ci*cv_e)+(cv_e*cv_e_Vbi_ci))+d10_sqrt0*(+(+cv_e_Vbi_ci_Vbi_ci*cv_e+cv_e_Vbi_ci*cv_e_Vbi_ci+cv_e_Vbi_ci*cv_e_Vbi_ci+cv_e*cv_e_Vbi_ci_Vbi_ci)+0.0));
#endif
#endif
cs_q=d00_sqrt0;
}
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
cs_q2_Vtnode_GND=(cv_e_Vtnode_GND+cs_q_Vtnode_GND)*0.5;
#endif
cs_q2_Vbi_ci=(cv_e_Vbi_ci+cs_q_Vbi_ci)*0.5;
#if defined(_DERIVATE)
  cs_q2_Vbi_ci_Vtnode_GND=(+(+cv_e_Vbi_ci_Vtnode_GND+cs_q_Vbi_ci_Vtnode_GND)*0.5+(cv_e_Vbi_ci+cs_q_Vbi_ci)*0.0+(cv_e_Vtnode_GND+cs_q_Vtnode_GND)*0.0+(cv_e+cs_q)*0.0);
  cs_q2_Vbi_ci_Vbi_ci=(+(+cv_e_Vbi_ci_Vbi_ci+cs_q_Vbi_ci_Vbi_ci)*0.5+(cv_e_Vbi_ci+cs_q_Vbi_ci)*0.0+(cv_e_Vbi_ci+cs_q_Vbi_ci)*0.0+(cv_e+cs_q)*0.0);
#endif
#endif
cs_q2=((cv_e+cs_q)*0.5);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
cv_j_Vtnode_GND=(cV_f_Vtnode_GND-((VT_Vtnode_GND*cs_q2)+(VT*cs_q2_Vtnode_GND)));
#endif
cv_j_Vbi_ci=(-(VT*cs_q2_Vbi_ci));
#if defined(_DERIVATE)
  cv_j_Vbi_ci_Vtnode_GND=(+0.0-(+0.0*cs_q2+0.0*cs_q2_Vtnode_GND+VT_Vtnode_GND*cs_q2_Vbi_ci+VT*cs_q2_Vbi_ci_Vtnode_GND));
  cv_j_Vbi_ci_Vbi_ci=(+0.0-(+0.0*cs_q2+0.0*cs_q2_Vbi_ci+0.0*cs_q2_Vbi_ci+VT*cs_q2_Vbi_ci_Vbi_ci));
#endif
#endif
cv_j=(cV_f-(VT*cs_q2));
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
cdvj_dv_Vtnode_GND=((cs_q2_Vtnode_GND*cs_q-cs_q2*cs_q_Vtnode_GND)/cs_q/cs_q);
#endif
cdvj_dv_Vbi_ci=((cs_q2_Vbi_ci*cs_q-cs_q2*cs_q_Vbi_ci)/cs_q/cs_q);
#if defined(_DERIVATE)
  cdvj_dv_Vbi_ci_Vtnode_GND=(cs_q2_Vbi_ci_Vtnode_GND/cs_q-(cs_q2_Vbi_ci*cs_q_Vtnode_GND+cs_q2_Vtnode_GND*cs_q_Vbi_ci+cs_q2*cs_q_Vbi_ci_Vtnode_GND)/cs_q/cs_q+2*cs_q2*cs_q_Vbi_ci*cs_q_Vtnode_GND/cs_q/cs_q/cs_q);
  cdvj_dv_Vbi_ci_Vbi_ci=(cs_q2_Vbi_ci_Vbi_ci/cs_q-(cs_q2_Vbi_ci*cs_q_Vbi_ci+cs_q2_Vbi_ci*cs_q_Vbi_ci+cs_q2*cs_q_Vbi_ci_Vbi_ci)/cs_q/cs_q+2*cs_q2*cs_q_Vbi_ci*cs_q_Vbi_ci/cs_q/cs_q/cs_q);
#endif
#endif
cdvj_dv=(cs_q2/cs_q);
{
double m00_logE(d00_logE0,(1.0-(cv_j/vdci_t)))
double m00_exp(d00_exp1,((-zci)*d00_logE0))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1.0-(cv_j/vdci_t)))
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
Cjcit_Vtnode_GND=(((((cjci0_t_Vtnode_GND*d00_exp1)+(cjci0_t*((-zci)*(-((cv_j_Vtnode_GND*vdci_t-cv_j*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*d10_logE0)*d10_exp1))*cdvj_dv)+((cjci0_t*d00_exp1)*cdvj_dv_Vtnode_GND))+(((2.4*cjci0_t_Vtnode_GND)*(1.0-cdvj_dv))+((2.4*cjci0_t)*(-cdvj_dv_Vtnode_GND))));
#endif
Cjcit_Vbi_ci=((((cjci0_t*((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0)*d10_exp1)*cdvj_dv)+((cjci0_t*d00_exp1)*cdvj_dv_Vbi_ci))+((2.4*cjci0_t)*(-cdvj_dv_Vbi_ci)));
#if defined(_DERIVATE)
  Cjcit_Vbi_ci_Vtnode_GND=(+(+(+0.0*d00_exp1+0.0*(((-zci)*(-((cv_j_Vtnode_GND*vdci_t-cv_j*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*d10_logE0))*d10_exp1+cjci0_t_Vtnode_GND*((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0)*d10_exp1+cjci0_t*(m20_exp(((-zci)*d00_logE0))*(((-zci)*(-((cv_j_Vtnode_GND*vdci_t-cv_j*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*d10_logE0))*((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*(-((cv_j_Vtnode_GND*vdci_t-cv_j*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*d10_logE0+0.0*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0+(-zci)*(m20_logE((1.0-(cv_j/vdci_t)))*(-((cv_j_Vtnode_GND*vdci_t-cv_j*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*(-(cv_j_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(cv_j_Vbi_ci_Vtnode_GND/vdci_t-(cv_j_Vbi_ci*vdci_t_Vtnode_GND+cv_j_Vtnode_GND*0.0+cv_j*0.0)/vdci_t/vdci_t+2*cv_j*0.0*vdci_t_Vtnode_GND/vdci_t/vdci_t/vdci_t))))))*cdvj_dv+(cjci0_t*((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0)*d10_exp1)*cdvj_dv_Vtnode_GND+(((cjci0_t_Vtnode_GND*d00_exp1)+(cjci0_t*(((-zci)*(-((cv_j_Vtnode_GND*vdci_t-cv_j*vdci_t_Vtnode_GND)/vdci_t/vdci_t))*d10_logE0))*d10_exp1)))*cdvj_dv_Vbi_ci+(cjci0_t*d00_exp1)*cdvj_dv_Vbi_ci_Vtnode_GND)+(+(+0.0*cjci0_t+0.0*cjci0_t_Vtnode_GND+0.0*0.0+2.4*0.0)*(1.0-cdvj_dv)+0.0*(-cdvj_dv_Vtnode_GND)+((2.4*cjci0_t_Vtnode_GND))*(-cdvj_dv_Vbi_ci)+(2.4*cjci0_t)*(+0.0-cdvj_dv_Vbi_ci_Vtnode_GND)));
  Cjcit_Vbi_ci_Vbi_ci=(+(+(+0.0*d00_exp1+0.0*(((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0))*d10_exp1+0.0*((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0)*d10_exp1+cjci0_t*(m20_exp(((-zci)*d00_logE0))*(((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0))*((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0+0.0*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0+(-zci)*(m20_logE((1.0-(cv_j/vdci_t)))*(-(cv_j_Vbi_ci/vdci_t))*(-(cv_j_Vbi_ci/vdci_t))+d10_logE0*(+0.0-(cv_j_Vbi_ci_Vbi_ci/vdci_t-(cv_j_Vbi_ci*0.0+cv_j_Vbi_ci*0.0+cv_j*0.0)/vdci_t/vdci_t+2*cv_j*0.0*0.0/vdci_t/vdci_t/vdci_t))))))*cdvj_dv+(cjci0_t*((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0)*d10_exp1)*cdvj_dv_Vbi_ci+((cjci0_t*(((-zci)*(-(cv_j_Vbi_ci/vdci_t))*d10_logE0))*d10_exp1))*cdvj_dv_Vbi_ci+(cjci0_t*d00_exp1)*cdvj_dv_Vbi_ci_Vbi_ci)+(+(+0.0*cjci0_t+0.0*0.0+0.0*0.0+2.4*0.0)*(1.0-cdvj_dv)+0.0*(-cdvj_dv_Vbi_ci)+0.0*(-cdvj_dv_Vbi_ci)+(2.4*cjci0_t)*(+0.0-cdvj_dv_Vbi_ci_Vbi_ci)));
#endif
#endif
Cjcit=(((cjci0_t*d00_exp1)*cdvj_dv)+((2.4*cjci0_t)*(1.0-cdvj_dv)));
}
}
else
{
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
Cjcit_Vtnode_GND=0.0;
#endif
Cjcit_Vbi_ci=0.0;
#if defined(_DERIVATE)
  Cjcit_Vbi_ci_Vtnode_GND=0.0;
  Cjcit_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
Cjcit=0.0;
}
if
((Cjcit>0.0))
{
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
cc_Vtnode_GND=((cjci0_t_Vtnode_GND*Cjcit-cjci0_t*Cjcit_Vtnode_GND)/Cjcit/Cjcit);
#endif
cc_Vbi_ci=(-cjci0_t*Cjcit_Vbi_ci/Cjcit/Cjcit);
#if defined(_DERIVATE)
  cc_Vbi_ci_Vtnode_GND=(0.0/Cjcit-(0.0*Cjcit_Vtnode_GND+cjci0_t_Vtnode_GND*Cjcit_Vbi_ci+cjci0_t*Cjcit_Vbi_ci_Vtnode_GND)/Cjcit/Cjcit+2*cjci0_t*Cjcit_Vbi_ci*Cjcit_Vtnode_GND/Cjcit/Cjcit/Cjcit);
  cc_Vbi_ci_Vbi_ci=(0.0/Cjcit-(0.0*Cjcit_Vbi_ci+0.0*Cjcit_Vbi_ci+cjci0_t*Cjcit_Vbi_ci_Vbi_ci)/Cjcit/Cjcit+2*cjci0_t*Cjcit_Vbi_ci*Cjcit_Vbi_ci/Cjcit/Cjcit/Cjcit);
#endif
#endif
cc=(cjci0_t/Cjcit);
}
else
{
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
cc_Vtnode_GND=0.0;
#endif
cc_Vbi_ci=0.0;
#if defined(_DERIVATE)
  cc_Vbi_ci_Vtnode_GND=0.0;
  cc_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
cc=1.0;
}
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
T_f0_Vtnode_GND=((t0_t_Vtnode_GND+(dt0h*cc_Vtnode_GND))+(tbvl*(-1*cc_Vtnode_GND/cc/cc)));
#endif
T_f0_Vbi_ci=((dt0h*cc_Vbi_ci)+(tbvl*(-1*cc_Vbi_ci/cc/cc)));
#if defined(_DERIVATE)
  T_f0_Vbi_ci_Vtnode_GND=(+(+0.0+(+0.0*(cc-1.0)+0.0*cc_Vtnode_GND+0.0*cc_Vbi_ci+dt0h*(+cc_Vbi_ci_Vtnode_GND-0.0)))+(+0.0*((1/cc)-1.0)+0.0*(-1*cc_Vtnode_GND/cc/cc)+0.0*(-1*cc_Vbi_ci/cc/cc)+tbvl*(+(0.0/cc-(0.0*cc_Vtnode_GND+0.0*cc_Vbi_ci+1*cc_Vbi_ci_Vtnode_GND)/cc/cc+2*1*cc_Vbi_ci*cc_Vtnode_GND/cc/cc/cc)-0.0)));
  T_f0_Vbi_ci_Vbi_ci=(+(+0.0+(+0.0*(cc-1.0)+0.0*cc_Vbi_ci+0.0*cc_Vbi_ci+dt0h*(+cc_Vbi_ci_Vbi_ci-0.0)))+(+0.0*((1/cc)-1.0)+0.0*(-1*cc_Vbi_ci/cc/cc)+0.0*(-1*cc_Vbi_ci/cc/cc)+tbvl*(+(0.0/cc-(0.0*cc_Vbi_ci+0.0*cc_Vbi_ci+1*cc_Vbi_ci_Vbi_ci)/cc/cc+2*1*cc_Vbi_ci*cc_Vbi_ci/cc/cc/cc)-0.0)));
#endif
#endif
T_f0=((t0_t+(dt0h*(cc-1.0)))+(tbvl*((1/cc)-1.0)));
#if defined(_DERIVATEFORDDX)
vc_Vci_ei=1.0;
#if defined(_DERIVATE)
  vc_Vci_ei_Vci_ei=(+0.0-0.0);
  vc_Vci_ei_Vtnode_GND=(+0.0-0.0);
#endif
#if defined(_DERIVATE)
vc_Vtnode_GND=(-vces_t_Vtnode_GND);
#endif
#endif
vc=(BP(ci,ei)-vces_t);
{
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=(vc_Vci_ei/VT);
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(0.0/VT-(vc_Vci_ei*0.0+0.0*0.0+vc*0.0)/VT/VT+2*vc*0.0*0.0/VT/VT/VT);
  a_Vci_ei_Vbi_ci=(0.0/VT-(vc_Vci_ei*0.0+0.0*0.0+vc*0.0)/VT/VT+2*vc*0.0*0.0/VT/VT/VT);
  a_Vci_ei_Vci_ei=(vc_Vci_ei_Vci_ei/VT-(vc_Vci_ei*0.0+vc_Vci_ei*0.0+vc*0.0)/VT/VT+2*vc*0.0*0.0/VT/VT/VT);
  a_Vci_ei_Vtnode_GND=(vc_Vci_ei_Vtnode_GND/VT-(vc_Vci_ei*VT_Vtnode_GND+vc_Vtnode_GND*0.0+vc*0.0)/VT/VT+2*vc*0.0*VT_Vtnode_GND/VT/VT/VT);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((vc_Vtnode_GND*VT-vc*VT_Vtnode_GND)/VT/VT);
#endif
#endif
a=(vc/VT);
#if defined(_DERIVATEFORDDX)
d1_Vci_ei=a_Vci_ei;
#if defined(_DERIVATE)
  d1_Vci_ei_Vci_ei=(+a_Vci_ei_Vci_ei-0.0);
  d1_Vci_ei_Vtnode_GND=(+a_Vci_ei_Vtnode_GND-0.0);
#endif
#if defined(_DERIVATE)
d1_Vtnode_GND=a_Vtnode_GND;
#endif
#endif
d1=(a-1);
{
double m00_sqrt(d00_sqrt0,((d1*d1)+1.921812))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((d1*d1)+1.921812))
#endif
#if defined(_DERIVATEFORDDX)
vceff_Vci_ei=((d1_Vci_ei+((d1_Vci_ei*d1)+(d1*d1_Vci_ei))*d10_sqrt0)/2)*VT;
#if defined(_DERIVATE)
  vceff_Vci_ei_Vci_ei=(+(+0.0+((+d1_Vci_ei_Vci_ei+(m20_sqrt(((d1*d1)+1.921812))*(((d1_Vci_ei*d1)+(d1*d1_Vci_ei)))*((d1_Vci_ei*d1)+(d1*d1_Vci_ei))+d10_sqrt0*(+(+d1_Vci_ei_Vci_ei*d1+d1_Vci_ei*d1_Vci_ei+d1_Vci_ei*d1_Vci_ei+d1*d1_Vci_ei_Vci_ei)+0.0)))/2-((d1_Vci_ei+((d1_Vci_ei*d1)+(d1*d1_Vci_ei))*d10_sqrt0)*0.0+(d1_Vci_ei+(((d1_Vci_ei*d1)+(d1*d1_Vci_ei)))*d10_sqrt0)*0.0+(d1+d00_sqrt0)*0.0)/2/2+2*(d1+d00_sqrt0)*0.0*0.0/2/2/2))*VT+((d1_Vci_ei+((d1_Vci_ei*d1)+(d1*d1_Vci_ei))*d10_sqrt0)/2)*0.0+((d1_Vci_ei+(((d1_Vci_ei*d1)+(d1*d1_Vci_ei)))*d10_sqrt0)/2)*0.0+(1.0+((d1+d00_sqrt0)/2))*0.0);
  vceff_Vci_ei_Vtnode_GND=(+(+0.0+((+d1_Vci_ei_Vtnode_GND+(m20_sqrt(((d1*d1)+1.921812))*(((d1_Vtnode_GND*d1)+(d1*d1_Vtnode_GND)))*((d1_Vci_ei*d1)+(d1*d1_Vci_ei))+d10_sqrt0*(+(+d1_Vci_ei_Vtnode_GND*d1+d1_Vci_ei*d1_Vtnode_GND+d1_Vtnode_GND*d1_Vci_ei+d1*d1_Vci_ei_Vtnode_GND)+0.0)))/2-((d1_Vci_ei+((d1_Vci_ei*d1)+(d1*d1_Vci_ei))*d10_sqrt0)*0.0+(d1_Vtnode_GND+(((d1_Vtnode_GND*d1)+(d1*d1_Vtnode_GND)))*d10_sqrt0)*0.0+(d1+d00_sqrt0)*0.0)/2/2+2*(d1+d00_sqrt0)*0.0*0.0/2/2/2))*VT+((d1_Vci_ei+((d1_Vci_ei*d1)+(d1*d1_Vci_ei))*d10_sqrt0)/2)*VT_Vtnode_GND+((d1_Vtnode_GND+(((d1_Vtnode_GND*d1)+(d1*d1_Vtnode_GND)))*d10_sqrt0)/2)*0.0+(1.0+((d1+d00_sqrt0)/2))*0.0);
#endif
#if defined(_DERIVATE)
vceff_Vtnode_GND=((((d1_Vtnode_GND+((d1_Vtnode_GND*d1)+(d1*d1_Vtnode_GND))*d10_sqrt0)/2)*VT)+((1.0+((d1+d00_sqrt0)/2))*VT_Vtnode_GND));
#endif
#endif
vceff=((1.0+((d1+d00_sqrt0)/2))*VT);
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=0.0;
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=0.0;
  a_Vbi_ei_Vbi_ci=0.0;
  a_Vbi_ei_Vci_ei=0.0;
  a_Vbi_ei_Vtnode_GND=0.0;
#endif
a_Vbi_ci=0.0;
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=0.0;
  a_Vbi_ci_Vbi_ci=0.0;
  a_Vbi_ci_Vci_ei=0.0;
  a_Vbi_ci_Vtnode_GND=0.0;
#endif
a_Vci_ei=(vceff_Vci_ei/vlim_t);
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(0.0/vlim_t-(vceff_Vci_ei*0.0+0.0*0.0+vceff*0.0)/vlim_t/vlim_t+2*vceff*0.0*0.0/vlim_t/vlim_t/vlim_t);
  a_Vci_ei_Vbi_ci=(0.0/vlim_t-(vceff_Vci_ei*0.0+0.0*0.0+vceff*0.0)/vlim_t/vlim_t+2*vceff*0.0*0.0/vlim_t/vlim_t/vlim_t);
  a_Vci_ei_Vci_ei=(vceff_Vci_ei_Vci_ei/vlim_t-(vceff_Vci_ei*0.0+vceff_Vci_ei*0.0+vceff*0.0)/vlim_t/vlim_t+2*vceff*0.0*0.0/vlim_t/vlim_t/vlim_t);
  a_Vci_ei_Vtnode_GND=(vceff_Vci_ei_Vtnode_GND/vlim_t-(vceff_Vci_ei*vlim_t_Vtnode_GND+vceff_Vtnode_GND*0.0+vceff*0.0)/vlim_t/vlim_t+2*vceff*0.0*vlim_t_Vtnode_GND/vlim_t/vlim_t/vlim_t);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((vceff_Vtnode_GND*vlim_t-vceff*vlim_t_Vtnode_GND)/vlim_t/vlim_t);
#endif
#endif
a=(vceff/vlim_t);
{
double m00_sqrt(d00_sqrt0,(1.0+(a*a)))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,(1.0+(a*a)))
#endif
#if defined(_DERIVATEFORDDX)
ick_Vci_ei=((vceff_Vci_ei*Orci0_t*d00_sqrt0-(vceff*Orci0_t)*((a_Vci_ei*a)+(a*a_Vci_ei))*d10_sqrt0)/d00_sqrt0/d00_sqrt0);
#if defined(_DERIVATE)
  ick_Vci_ei_Vci_ei=((+vceff_Vci_ei_Vci_ei*Orci0_t+vceff_Vci_ei*0.0+vceff_Vci_ei*0.0+vceff*0.0)/d00_sqrt0-(vceff_Vci_ei*Orci0_t*(((a_Vci_ei*a)+(a*a_Vci_ei)))*d10_sqrt0+(vceff_Vci_ei*Orci0_t)*((a_Vci_ei*a)+(a*a_Vci_ei))*d10_sqrt0+(vceff*Orci0_t)*(m20_sqrt((1.0+(a*a)))*(((a_Vci_ei*a)+(a*a_Vci_ei)))*((a_Vci_ei*a)+(a*a_Vci_ei))+d10_sqrt0*(+0.0+(+a_Vci_ei_Vci_ei*a+a_Vci_ei*a_Vci_ei+a_Vci_ei*a_Vci_ei+a*a_Vci_ei_Vci_ei))))/d00_sqrt0/d00_sqrt0+2*(vceff*Orci0_t)*((a_Vci_ei*a)+(a*a_Vci_ei))*d10_sqrt0*(((a_Vci_ei*a)+(a*a_Vci_ei)))*d10_sqrt0/d00_sqrt0/d00_sqrt0/d00_sqrt0);
  ick_Vci_ei_Vtnode_GND=((+vceff_Vci_ei_Vtnode_GND*Orci0_t+vceff_Vci_ei*Orci0_t_Vtnode_GND+vceff_Vtnode_GND*0.0+vceff*0.0)/d00_sqrt0-(vceff_Vci_ei*Orci0_t*(((a_Vtnode_GND*a)+(a*a_Vtnode_GND)))*d10_sqrt0+(((vceff_Vtnode_GND*Orci0_t)+(vceff*Orci0_t_Vtnode_GND)))*((a_Vci_ei*a)+(a*a_Vci_ei))*d10_sqrt0+(vceff*Orci0_t)*(m20_sqrt((1.0+(a*a)))*(((a_Vtnode_GND*a)+(a*a_Vtnode_GND)))*((a_Vci_ei*a)+(a*a_Vci_ei))+d10_sqrt0*(+0.0+(+a_Vci_ei_Vtnode_GND*a+a_Vci_ei*a_Vtnode_GND+a_Vtnode_GND*a_Vci_ei+a*a_Vci_ei_Vtnode_GND))))/d00_sqrt0/d00_sqrt0+2*(vceff*Orci0_t)*((a_Vci_ei*a)+(a*a_Vci_ei))*d10_sqrt0*(((a_Vtnode_GND*a)+(a*a_Vtnode_GND)))*d10_sqrt0/d00_sqrt0/d00_sqrt0/d00_sqrt0);
#endif
#if defined(_DERIVATE)
ick_Vtnode_GND=((((vceff_Vtnode_GND*Orci0_t)+(vceff*Orci0_t_Vtnode_GND))*d00_sqrt0-(vceff*Orci0_t)*((a_Vtnode_GND*a)+(a*a_Vtnode_GND))*d10_sqrt0)/d00_sqrt0/d00_sqrt0);
#endif
#endif
ick=((vceff*Orci0_t)/d00_sqrt0);
}
#if defined(_DERIVATEFORDDX)
ICKa_Vci_ei=vceff_Vci_ei*Ovpt;
#if defined(_DERIVATE)
  ICKa_Vci_ei_Vci_ei=(+(+vceff_Vci_ei_Vci_ei-0.0)*Ovpt+vceff_Vci_ei*0.0+vceff_Vci_ei*0.0+(vceff-vlim_t)*0.0);
  ICKa_Vci_ei_Vtnode_GND=(+(+vceff_Vci_ei_Vtnode_GND-0.0)*Ovpt+vceff_Vci_ei*0.0+(vceff_Vtnode_GND-vlim_t_Vtnode_GND)*0.0+(vceff-vlim_t)*0.0);
#endif
#if defined(_DERIVATE)
ICKa_Vtnode_GND=(vceff_Vtnode_GND-vlim_t_Vtnode_GND)*Ovpt;
#endif
#endif
ICKa=((vceff-vlim_t)*Ovpt);
{
double m00_sqrt(d00_sqrt0,((ICKa*ICKa)+1.0e-3))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((ICKa*ICKa)+1.0e-3))
#endif
#if defined(_DERIVATEFORDDX)
ick_Vci_ei=((ick_Vci_ei*(1.0+(0.5*(ICKa+d00_sqrt0))))+(ick*(0.5*(ICKa_Vci_ei+((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei))*d10_sqrt0))));
#if defined(_DERIVATE)
  ick_Vci_ei_Vci_ei=(+ick_Vci_ei_Vci_ei*(1.0+(0.5*(ICKa+d00_sqrt0)))+ick_Vci_ei*((0.5*(ICKa_Vci_ei+(((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei)))*d10_sqrt0)))+ick_Vci_ei*(0.5*(ICKa_Vci_ei+((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei))*d10_sqrt0))+ick*(+0.0+(+0.0*(ICKa+d00_sqrt0)+0.0*(ICKa_Vci_ei+(((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei)))*d10_sqrt0)+0.0*(ICKa_Vci_ei+((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei))*d10_sqrt0)+0.5*(+ICKa_Vci_ei_Vci_ei+(m20_sqrt(((ICKa*ICKa)+1.0e-3))*(((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei)))*((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei))+d10_sqrt0*(+(+ICKa_Vci_ei_Vci_ei*ICKa+ICKa_Vci_ei*ICKa_Vci_ei+ICKa_Vci_ei*ICKa_Vci_ei+ICKa*ICKa_Vci_ei_Vci_ei)+0.0))))));
  ick_Vci_ei_Vtnode_GND=(+ick_Vci_ei_Vtnode_GND*(1.0+(0.5*(ICKa+d00_sqrt0)))+ick_Vci_ei*((0.5*(ICKa_Vtnode_GND+(((ICKa_Vtnode_GND*ICKa)+(ICKa*ICKa_Vtnode_GND)))*d10_sqrt0)))+ick_Vtnode_GND*(0.5*(ICKa_Vci_ei+((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei))*d10_sqrt0))+ick*(+0.0+(+0.0*(ICKa+d00_sqrt0)+0.0*(ICKa_Vtnode_GND+(((ICKa_Vtnode_GND*ICKa)+(ICKa*ICKa_Vtnode_GND)))*d10_sqrt0)+0.0*(ICKa_Vci_ei+((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei))*d10_sqrt0)+0.5*(+ICKa_Vci_ei_Vtnode_GND+(m20_sqrt(((ICKa*ICKa)+1.0e-3))*(((ICKa_Vtnode_GND*ICKa)+(ICKa*ICKa_Vtnode_GND)))*((ICKa_Vci_ei*ICKa)+(ICKa*ICKa_Vci_ei))+d10_sqrt0*(+(+ICKa_Vci_ei_Vtnode_GND*ICKa+ICKa_Vci_ei*ICKa_Vtnode_GND+ICKa_Vtnode_GND*ICKa_Vci_ei+ICKa*ICKa_Vci_ei_Vtnode_GND)+0.0))))));
#endif
#if defined(_DERIVATE)
ick_Vtnode_GND=((ick_Vtnode_GND*(1.0+(0.5*(ICKa+d00_sqrt0))))+(ick*(0.5*(ICKa_Vtnode_GND+((ICKa_Vtnode_GND*ICKa)+(ICKa*ICKa_Vtnode_GND))*d10_sqrt0))));
#endif
#endif
ick=(ick*(1.0+(0.5*(ICKa+d00_sqrt0))));
}
}
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
Q_p_Vtnode_GND=Q_0_Vtnode_GND;
#endif
Q_p_Vbi_ei=Q_0_Vbi_ei;
#if defined(_DERIVATE)
  Q_p_Vbi_ei_Vtnode_GND=Q_0_Vbi_ei_Vtnode_GND;
  Q_p_Vbi_ei_Vbi_ei=Q_0_Vbi_ei_Vbi_ei;
  Q_p_Vbi_ei_Vbi_ci=Q_0_Vbi_ei_Vbi_ci;
#endif
Q_p_Vbi_ci=Q_0_Vbi_ci;
#if defined(_DERIVATE)
  Q_p_Vbi_ci_Vtnode_GND=Q_0_Vbi_ci_Vtnode_GND;
  Q_p_Vbi_ci_Vbi_ei=Q_0_Vbi_ci_Vbi_ei;
  Q_p_Vbi_ci_Vbi_ci=Q_0_Vbi_ci_Vbi_ci;
#endif
#endif
Q_p=Q_0;
if
(((T_f0>0.0)||(Tr>0.0)))
{
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
A_Vtnode_GND=(0.5*Q_0_Vtnode_GND);
#endif
A_Vbi_ei=(0.5*Q_0_Vbi_ei);
#if defined(_DERIVATE)
  A_Vbi_ei_Vtnode_GND=(+0.0*Q_0+0.0*Q_0_Vtnode_GND+0.0*Q_0_Vbi_ei+0.5*Q_0_Vbi_ei_Vtnode_GND);
  A_Vbi_ei_Vbi_ei=(+0.0*Q_0+0.0*Q_0_Vbi_ei+0.0*Q_0_Vbi_ei+0.5*Q_0_Vbi_ei_Vbi_ei);
  A_Vbi_ei_Vbi_ci=(+0.0*Q_0+0.0*Q_0_Vbi_ci+0.0*Q_0_Vbi_ei+0.5*Q_0_Vbi_ei_Vbi_ci);
#endif
A_Vbi_ci=(0.5*Q_0_Vbi_ci);
#if defined(_DERIVATE)
  A_Vbi_ci_Vtnode_GND=(+0.0*Q_0+0.0*Q_0_Vtnode_GND+0.0*Q_0_Vbi_ci+0.5*Q_0_Vbi_ci_Vtnode_GND);
  A_Vbi_ci_Vbi_ei=(+0.0*Q_0+0.0*Q_0_Vbi_ei+0.0*Q_0_Vbi_ci+0.5*Q_0_Vbi_ci_Vbi_ei);
  A_Vbi_ci_Vbi_ci=(+0.0*Q_0+0.0*Q_0_Vbi_ci+0.0*Q_0_Vbi_ci+0.5*Q_0_Vbi_ci_Vbi_ci);
#endif
#endif
A=(0.5*Q_0);
{
double m00_sqrt(d00_sqrt0,(((A*A)+(T_f0*i_0f))+(Tr*i_0r)))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,(((A*A)+(T_f0*i_0f))+(Tr*i_0r)))
#endif
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
Q_p_Vtnode_GND=(A_Vtnode_GND+((((A_Vtnode_GND*A)+(A*A_Vtnode_GND))+((T_f0_Vtnode_GND*i_0f)+(T_f0*i_0f_Vtnode_GND)))+(Tr*i_0r_Vtnode_GND))*d10_sqrt0);
#endif
Q_p_Vbi_ei=(A_Vbi_ei+(((A_Vbi_ei*A)+(A*A_Vbi_ei))+(T_f0*i_0f_Vbi_ei))*d10_sqrt0);
#if defined(_DERIVATE)
  Q_p_Vbi_ei_Vtnode_GND=(+A_Vbi_ei_Vtnode_GND+(m20_sqrt((((A*A)+(T_f0*i_0f))+(Tr*i_0r)))*(((((A_Vtnode_GND*A)+(A*A_Vtnode_GND)))+(((T_f0_Vtnode_GND*i_0f)+(T_f0*i_0f_Vtnode_GND))))+((Tr*i_0r_Vtnode_GND)))*(((A_Vbi_ei*A)+(A*A_Vbi_ei))+(T_f0*i_0f_Vbi_ei))+d10_sqrt0*(+(+(+A_Vbi_ei_Vtnode_GND*A+A_Vbi_ei*A_Vtnode_GND+A_Vtnode_GND*A_Vbi_ei+A*A_Vbi_ei_Vtnode_GND)+(+0.0*i_0f+0.0*i_0f_Vtnode_GND+T_f0_Vtnode_GND*i_0f_Vbi_ei+T_f0*i_0f_Vbi_ei_Vtnode_GND))+(+0.0*i_0r+0.0*i_0r_Vtnode_GND+0.0*0.0+Tr*0.0))));
  Q_p_Vbi_ei_Vbi_ei=(+A_Vbi_ei_Vbi_ei+(m20_sqrt((((A*A)+(T_f0*i_0f))+(Tr*i_0r)))*((((A_Vbi_ei*A)+(A*A_Vbi_ei)))+((T_f0*i_0f_Vbi_ei)))*(((A_Vbi_ei*A)+(A*A_Vbi_ei))+(T_f0*i_0f_Vbi_ei))+d10_sqrt0*(+(+(+A_Vbi_ei_Vbi_ei*A+A_Vbi_ei*A_Vbi_ei+A_Vbi_ei*A_Vbi_ei+A*A_Vbi_ei_Vbi_ei)+(+0.0*i_0f+0.0*i_0f_Vbi_ei+0.0*i_0f_Vbi_ei+T_f0*i_0f_Vbi_ei_Vbi_ei))+(+0.0*i_0r+0.0*0.0+0.0*0.0+Tr*0.0))));
  Q_p_Vbi_ei_Vbi_ci=(+A_Vbi_ei_Vbi_ci+(m20_sqrt((((A*A)+(T_f0*i_0f))+(Tr*i_0r)))*(((((A_Vbi_ci*A)+(A*A_Vbi_ci)))+(T_f0_Vbi_ci*i_0f))+((Tr*i_0r_Vbi_ci)))*(((A_Vbi_ei*A)+(A*A_Vbi_ei))+(T_f0*i_0f_Vbi_ei))+d10_sqrt0*(+(+(+A_Vbi_ei_Vbi_ci*A+A_Vbi_ei*A_Vbi_ci+A_Vbi_ci*A_Vbi_ei+A*A_Vbi_ei_Vbi_ci)+(+0.0*i_0f+0.0*0.0+T_f0_Vbi_ci*i_0f_Vbi_ei+T_f0*0.0))+(+0.0*i_0r+0.0*i_0r_Vbi_ci+0.0*0.0+Tr*0.0))));
#endif
Q_p_Vbi_ci=(A_Vbi_ci+((((A_Vbi_ci*A)+(A*A_Vbi_ci))+T_f0_Vbi_ci*i_0f)+(Tr*i_0r_Vbi_ci))*d10_sqrt0);
#if defined(_DERIVATE)
  Q_p_Vbi_ci_Vtnode_GND=(+A_Vbi_ci_Vtnode_GND+(m20_sqrt((((A*A)+(T_f0*i_0f))+(Tr*i_0r)))*(((((A_Vtnode_GND*A)+(A*A_Vtnode_GND)))+(((T_f0_Vtnode_GND*i_0f)+(T_f0*i_0f_Vtnode_GND))))+((Tr*i_0r_Vtnode_GND)))*((((A_Vbi_ci*A)+(A*A_Vbi_ci))+T_f0_Vbi_ci*i_0f)+(Tr*i_0r_Vbi_ci))+d10_sqrt0*(+(+(+A_Vbi_ci_Vtnode_GND*A+A_Vbi_ci*A_Vtnode_GND+A_Vtnode_GND*A_Vbi_ci+A*A_Vbi_ci_Vtnode_GND)+(+T_f0_Vbi_ci_Vtnode_GND*i_0f+T_f0_Vbi_ci*i_0f_Vtnode_GND+T_f0_Vtnode_GND*0.0+T_f0*0.0))+(+0.0*i_0r+0.0*i_0r_Vtnode_GND+0.0*i_0r_Vbi_ci+Tr*i_0r_Vbi_ci_Vtnode_GND))));
  Q_p_Vbi_ci_Vbi_ei=(+A_Vbi_ci_Vbi_ei+(m20_sqrt((((A*A)+(T_f0*i_0f))+(Tr*i_0r)))*((((A_Vbi_ei*A)+(A*A_Vbi_ei)))+((T_f0*i_0f_Vbi_ei)))*((((A_Vbi_ci*A)+(A*A_Vbi_ci))+T_f0_Vbi_ci*i_0f)+(Tr*i_0r_Vbi_ci))+d10_sqrt0*(+(+(+A_Vbi_ci_Vbi_ei*A+A_Vbi_ci*A_Vbi_ei+A_Vbi_ei*A_Vbi_ci+A*A_Vbi_ci_Vbi_ei)+(+0.0*i_0f+T_f0_Vbi_ci*i_0f_Vbi_ei+0.0*0.0+T_f0*0.0))+(+0.0*i_0r+0.0*0.0+0.0*i_0r_Vbi_ci+Tr*0.0))));
  Q_p_Vbi_ci_Vbi_ci=(+A_Vbi_ci_Vbi_ci+(m20_sqrt((((A*A)+(T_f0*i_0f))+(Tr*i_0r)))*(((((A_Vbi_ci*A)+(A*A_Vbi_ci)))+(T_f0_Vbi_ci*i_0f))+((Tr*i_0r_Vbi_ci)))*((((A_Vbi_ci*A)+(A*A_Vbi_ci))+T_f0_Vbi_ci*i_0f)+(Tr*i_0r_Vbi_ci))+d10_sqrt0*(+(+(+A_Vbi_ci_Vbi_ci*A+A_Vbi_ci*A_Vbi_ci+A_Vbi_ci*A_Vbi_ci+A*A_Vbi_ci_Vbi_ci)+(+T_f0_Vbi_ci_Vbi_ci*i_0f+T_f0_Vbi_ci*0.0+T_f0_Vbi_ci*0.0+T_f0*0.0))+(+0.0*i_0r+0.0*i_0r_Vbi_ci+0.0*i_0r_Vbi_ci+Tr*i_0r_Vbi_ci_Vbi_ci))));
#endif
#endif
Q_p=(A+d00_sqrt0);
}
}
#if defined(_DERIVATEFORDDX)
I_Tf1_Vci_ei=0.0;
#if defined(_DERIVATE)
  I_Tf1_Vci_ei_Vci_ei=0.0;
  I_Tf1_Vci_ei_Vtnode_GND=0.0;
  I_Tf1_Vci_ei_Vbi_ei=0.0;
  I_Tf1_Vci_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
I_Tf1_Vtnode_GND=((i_0f_Vtnode_GND*Q_p-i_0f*Q_p_Vtnode_GND)/Q_p/Q_p);
#endif
I_Tf1_Vbi_ei=((i_0f_Vbi_ei*Q_p-i_0f*Q_p_Vbi_ei)/Q_p/Q_p);
#if defined(_DERIVATE)
  I_Tf1_Vbi_ei_Vci_ei=(0.0/Q_p-(i_0f_Vbi_ei*0.0+0.0*Q_p_Vbi_ei+i_0f*0.0)/Q_p/Q_p+2*i_0f*Q_p_Vbi_ei*0.0/Q_p/Q_p/Q_p);
  I_Tf1_Vbi_ei_Vtnode_GND=(i_0f_Vbi_ei_Vtnode_GND/Q_p-(i_0f_Vbi_ei*Q_p_Vtnode_GND+i_0f_Vtnode_GND*Q_p_Vbi_ei+i_0f*Q_p_Vbi_ei_Vtnode_GND)/Q_p/Q_p+2*i_0f*Q_p_Vbi_ei*Q_p_Vtnode_GND/Q_p/Q_p/Q_p);
  I_Tf1_Vbi_ei_Vbi_ei=(i_0f_Vbi_ei_Vbi_ei/Q_p-(i_0f_Vbi_ei*Q_p_Vbi_ei+i_0f_Vbi_ei*Q_p_Vbi_ei+i_0f*Q_p_Vbi_ei_Vbi_ei)/Q_p/Q_p+2*i_0f*Q_p_Vbi_ei*Q_p_Vbi_ei/Q_p/Q_p/Q_p);
  I_Tf1_Vbi_ei_Vbi_ci=(0.0/Q_p-(i_0f_Vbi_ei*Q_p_Vbi_ci+0.0*Q_p_Vbi_ei+i_0f*Q_p_Vbi_ei_Vbi_ci)/Q_p/Q_p+2*i_0f*Q_p_Vbi_ei*Q_p_Vbi_ci/Q_p/Q_p/Q_p);
#endif
I_Tf1_Vbi_ci=(-i_0f*Q_p_Vbi_ci/Q_p/Q_p);
#if defined(_DERIVATE)
  I_Tf1_Vbi_ci_Vci_ei=(0.0/Q_p-(0.0*0.0+0.0*Q_p_Vbi_ci+i_0f*0.0)/Q_p/Q_p+2*i_0f*Q_p_Vbi_ci*0.0/Q_p/Q_p/Q_p);
  I_Tf1_Vbi_ci_Vtnode_GND=(0.0/Q_p-(0.0*Q_p_Vtnode_GND+i_0f_Vtnode_GND*Q_p_Vbi_ci+i_0f*Q_p_Vbi_ci_Vtnode_GND)/Q_p/Q_p+2*i_0f*Q_p_Vbi_ci*Q_p_Vtnode_GND/Q_p/Q_p/Q_p);
  I_Tf1_Vbi_ci_Vbi_ei=(0.0/Q_p-(0.0*Q_p_Vbi_ei+i_0f_Vbi_ei*Q_p_Vbi_ci+i_0f*Q_p_Vbi_ci_Vbi_ei)/Q_p/Q_p+2*i_0f*Q_p_Vbi_ci*Q_p_Vbi_ei/Q_p/Q_p/Q_p);
  I_Tf1_Vbi_ci_Vbi_ci=(0.0/Q_p-(0.0*Q_p_Vbi_ci+0.0*Q_p_Vbi_ci+i_0f*Q_p_Vbi_ci_Vbi_ci)/Q_p/Q_p+2*i_0f*Q_p_Vbi_ci*Q_p_Vbi_ci/Q_p/Q_p/Q_p);
#endif
#endif
I_Tf1=(i_0f/Q_p);
#if defined(_DERIVATEFORDDX)
a_h_Vci_ei=0.0;
#if defined(_DERIVATE)
  a_h_Vci_ei_Vci_ei=0.0;
  a_h_Vci_ei_Vtnode_GND=0.0;
  a_h_Vci_ei_Vbi_ei=0.0;
  a_h_Vci_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
a_h_Vtnode_GND=(Oich*I_Tf1_Vtnode_GND);
#endif
a_h_Vbi_ei=(Oich*I_Tf1_Vbi_ei);
#if defined(_DERIVATE)
  a_h_Vbi_ei_Vci_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vci_ei+0.0*I_Tf1_Vbi_ei+Oich*I_Tf1_Vbi_ei_Vci_ei);
  a_h_Vbi_ei_Vtnode_GND=(+0.0*I_Tf1+0.0*I_Tf1_Vtnode_GND+0.0*I_Tf1_Vbi_ei+Oich*I_Tf1_Vbi_ei_Vtnode_GND);
  a_h_Vbi_ei_Vbi_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ei+0.0*I_Tf1_Vbi_ei+Oich*I_Tf1_Vbi_ei_Vbi_ei);
  a_h_Vbi_ei_Vbi_ci=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ci+0.0*I_Tf1_Vbi_ei+Oich*I_Tf1_Vbi_ei_Vbi_ci);
#endif
a_h_Vbi_ci=(Oich*I_Tf1_Vbi_ci);
#if defined(_DERIVATE)
  a_h_Vbi_ci_Vci_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vci_ei+0.0*I_Tf1_Vbi_ci+Oich*I_Tf1_Vbi_ci_Vci_ei);
  a_h_Vbi_ci_Vtnode_GND=(+0.0*I_Tf1+0.0*I_Tf1_Vtnode_GND+0.0*I_Tf1_Vbi_ci+Oich*I_Tf1_Vbi_ci_Vtnode_GND);
  a_h_Vbi_ci_Vbi_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ei+0.0*I_Tf1_Vbi_ci+Oich*I_Tf1_Vbi_ci_Vbi_ei);
  a_h_Vbi_ci_Vbi_ci=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ci+0.0*I_Tf1_Vbi_ci+Oich*I_Tf1_Vbi_ci_Vbi_ci);
#endif
#endif
a_h=(Oich*I_Tf1);
#if defined(_DERIVATEFORDDX)
itf_Vci_ei=0.0;
#if defined(_DERIVATE)
  itf_Vci_ei_Vci_ei=0.0;
  itf_Vci_ei_Vtnode_GND=0.0;
  itf_Vci_ei_Vbi_ei=0.0;
  itf_Vci_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
itf_Vtnode_GND=((I_Tf1_Vtnode_GND*(1.0+a_h))+(I_Tf1*a_h_Vtnode_GND));
#endif
itf_Vbi_ei=((I_Tf1_Vbi_ei*(1.0+a_h))+(I_Tf1*a_h_Vbi_ei));
#if defined(_DERIVATE)
  itf_Vbi_ei_Vci_ei=(+I_Tf1_Vbi_ei_Vci_ei*(1.0+a_h)+I_Tf1_Vbi_ei*a_h_Vci_ei+I_Tf1_Vci_ei*a_h_Vbi_ei+I_Tf1*(+0.0+a_h_Vbi_ei_Vci_ei));
  itf_Vbi_ei_Vtnode_GND=(+I_Tf1_Vbi_ei_Vtnode_GND*(1.0+a_h)+I_Tf1_Vbi_ei*a_h_Vtnode_GND+I_Tf1_Vtnode_GND*a_h_Vbi_ei+I_Tf1*(+0.0+a_h_Vbi_ei_Vtnode_GND));
  itf_Vbi_ei_Vbi_ei=(+I_Tf1_Vbi_ei_Vbi_ei*(1.0+a_h)+I_Tf1_Vbi_ei*a_h_Vbi_ei+I_Tf1_Vbi_ei*a_h_Vbi_ei+I_Tf1*(+0.0+a_h_Vbi_ei_Vbi_ei));
  itf_Vbi_ei_Vbi_ci=(+I_Tf1_Vbi_ei_Vbi_ci*(1.0+a_h)+I_Tf1_Vbi_ei*a_h_Vbi_ci+I_Tf1_Vbi_ci*a_h_Vbi_ei+I_Tf1*(+0.0+a_h_Vbi_ei_Vbi_ci));
#endif
itf_Vbi_ci=((I_Tf1_Vbi_ci*(1.0+a_h))+(I_Tf1*a_h_Vbi_ci));
#if defined(_DERIVATE)
  itf_Vbi_ci_Vci_ei=(+I_Tf1_Vbi_ci_Vci_ei*(1.0+a_h)+I_Tf1_Vbi_ci*a_h_Vci_ei+I_Tf1_Vci_ei*a_h_Vbi_ci+I_Tf1*(+0.0+a_h_Vbi_ci_Vci_ei));
  itf_Vbi_ci_Vtnode_GND=(+I_Tf1_Vbi_ci_Vtnode_GND*(1.0+a_h)+I_Tf1_Vbi_ci*a_h_Vtnode_GND+I_Tf1_Vtnode_GND*a_h_Vbi_ci+I_Tf1*(+0.0+a_h_Vbi_ci_Vtnode_GND));
  itf_Vbi_ci_Vbi_ei=(+I_Tf1_Vbi_ci_Vbi_ei*(1.0+a_h)+I_Tf1_Vbi_ci*a_h_Vbi_ei+I_Tf1_Vbi_ei*a_h_Vbi_ci+I_Tf1*(+0.0+a_h_Vbi_ci_Vbi_ei));
  itf_Vbi_ci_Vbi_ci=(+I_Tf1_Vbi_ci_Vbi_ci*(1.0+a_h)+I_Tf1_Vbi_ci*a_h_Vbi_ci+I_Tf1_Vbi_ci*a_h_Vbi_ci+I_Tf1*(+0.0+a_h_Vbi_ci_Vbi_ci));
#endif
#endif
itf=(I_Tf1*(1.0+a_h));
#if defined(_DERIVATEFORDDX)
itr_Vci_ei=0.0;
#if defined(_DERIVATE)
  itr_Vci_ei_Vci_ei=0.0;
  itr_Vci_ei_Vtnode_GND=0.0;
  itr_Vci_ei_Vbi_ci=0.0;
  itr_Vci_ei_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
itr_Vtnode_GND=((i_0r_Vtnode_GND*Q_p-i_0r*Q_p_Vtnode_GND)/Q_p/Q_p);
#endif
itr_Vbi_ci=((i_0r_Vbi_ci*Q_p-i_0r*Q_p_Vbi_ci)/Q_p/Q_p);
#if defined(_DERIVATE)
  itr_Vbi_ci_Vci_ei=(0.0/Q_p-(i_0r_Vbi_ci*0.0+0.0*Q_p_Vbi_ci+i_0r*0.0)/Q_p/Q_p+2*i_0r*Q_p_Vbi_ci*0.0/Q_p/Q_p/Q_p);
  itr_Vbi_ci_Vtnode_GND=(i_0r_Vbi_ci_Vtnode_GND/Q_p-(i_0r_Vbi_ci*Q_p_Vtnode_GND+i_0r_Vtnode_GND*Q_p_Vbi_ci+i_0r*Q_p_Vbi_ci_Vtnode_GND)/Q_p/Q_p+2*i_0r*Q_p_Vbi_ci*Q_p_Vtnode_GND/Q_p/Q_p/Q_p);
  itr_Vbi_ci_Vbi_ci=(i_0r_Vbi_ci_Vbi_ci/Q_p-(i_0r_Vbi_ci*Q_p_Vbi_ci+i_0r_Vbi_ci*Q_p_Vbi_ci+i_0r*Q_p_Vbi_ci_Vbi_ci)/Q_p/Q_p+2*i_0r*Q_p_Vbi_ci*Q_p_Vbi_ci/Q_p/Q_p/Q_p);
  itr_Vbi_ci_Vbi_ei=(0.0/Q_p-(i_0r_Vbi_ci*Q_p_Vbi_ei+0.0*Q_p_Vbi_ci+i_0r*Q_p_Vbi_ci_Vbi_ei)/Q_p/Q_p+2*i_0r*Q_p_Vbi_ci*Q_p_Vbi_ei/Q_p/Q_p/Q_p);
#endif
itr_Vbi_ei=(-i_0r*Q_p_Vbi_ei/Q_p/Q_p);
#if defined(_DERIVATE)
  itr_Vbi_ei_Vci_ei=(0.0/Q_p-(0.0*0.0+0.0*Q_p_Vbi_ei+i_0r*0.0)/Q_p/Q_p+2*i_0r*Q_p_Vbi_ei*0.0/Q_p/Q_p/Q_p);
  itr_Vbi_ei_Vtnode_GND=(0.0/Q_p-(0.0*Q_p_Vtnode_GND+i_0r_Vtnode_GND*Q_p_Vbi_ei+i_0r*Q_p_Vbi_ei_Vtnode_GND)/Q_p/Q_p+2*i_0r*Q_p_Vbi_ei*Q_p_Vtnode_GND/Q_p/Q_p/Q_p);
  itr_Vbi_ei_Vbi_ci=(0.0/Q_p-(0.0*Q_p_Vbi_ci+i_0r_Vbi_ci*Q_p_Vbi_ei+i_0r*Q_p_Vbi_ei_Vbi_ci)/Q_p/Q_p+2*i_0r*Q_p_Vbi_ei*Q_p_Vbi_ci/Q_p/Q_p/Q_p);
  itr_Vbi_ei_Vbi_ei=(0.0/Q_p-(0.0*Q_p_Vbi_ei+0.0*Q_p_Vbi_ei+i_0r*Q_p_Vbi_ei_Vbi_ei)/Q_p/Q_p+2*i_0r*Q_p_Vbi_ei*Q_p_Vbi_ei/Q_p/Q_p/Q_p);
#endif
#endif
itr=(i_0r/Q_p);
#if defined(_DERIVATE)
Q_bf_Vtnode_GND=0.0;
Q_bf_Vbi_ei=0.0;
Q_bf_Vbi_ci=0.0;
Q_bf_Vci_ei=0.0;
#endif
Q_bf=0.0;
#if defined(_DERIVATEFORDDX)
Tf_Vci_ei=0.0;
#if defined(_DERIVATE)
  Tf_Vci_ei_Vci_ei=0.0;
  Tf_Vci_ei_Vbi_ei=0.0;
  Tf_Vci_ei_Vtnode_GND=0.0;
  Tf_Vci_ei_Vbi_ci=0.0;
#endif
Tf_Vbi_ei=0.0;
#if defined(_DERIVATE)
  Tf_Vbi_ei_Vci_ei=0.0;
  Tf_Vbi_ei_Vbi_ei=0.0;
  Tf_Vbi_ei_Vtnode_GND=0.0;
  Tf_Vbi_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Tf_Vtnode_GND=T_f0_Vtnode_GND;
#endif
Tf_Vbi_ci=T_f0_Vbi_ci;
#if defined(_DERIVATE)
  Tf_Vbi_ci_Vci_ei=0.0;
  Tf_Vbi_ci_Vbi_ei=0.0;
  Tf_Vbi_ci_Vtnode_GND=T_f0_Vbi_ci_Vtnode_GND;
  Tf_Vbi_ci_Vbi_ci=T_f0_Vbi_ci_Vbi_ci;
#endif
#endif
Tf=T_f0;
#if defined(_DERIVATEFORDDX)
Qf_Vci_ei=0.0;
#if defined(_DERIVATE)
  Qf_Vci_ei_Vci_ei=0.0;
  Qf_Vci_ei_Vtnode_GND=0.0;
  Qf_Vci_ei_Vbi_ci=0.0;
  Qf_Vci_ei_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
Qf_Vtnode_GND=((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND));
#endif
Qf_Vbi_ci=((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci));
#if defined(_DERIVATE)
  Qf_Vbi_ci_Vci_ei=(+0.0*itf+T_f0_Vbi_ci*itf_Vci_ei+0.0*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vci_ei);
  Qf_Vbi_ci_Vtnode_GND=(+T_f0_Vbi_ci_Vtnode_GND*itf+T_f0_Vbi_ci*itf_Vtnode_GND+T_f0_Vtnode_GND*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vtnode_GND);
  Qf_Vbi_ci_Vbi_ci=(+T_f0_Vbi_ci_Vbi_ci*itf+T_f0_Vbi_ci*itf_Vbi_ci+T_f0_Vbi_ci*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vbi_ci);
  Qf_Vbi_ci_Vbi_ei=(+0.0*itf+T_f0_Vbi_ci*itf_Vbi_ei+0.0*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vbi_ei);
#endif
Qf_Vbi_ei=(T_f0*itf_Vbi_ei);
#if defined(_DERIVATE)
  Qf_Vbi_ei_Vci_ei=(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vci_ei);
  Qf_Vbi_ei_Vtnode_GND=(+0.0*itf+0.0*itf_Vtnode_GND+T_f0_Vtnode_GND*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vtnode_GND);
  Qf_Vbi_ei_Vbi_ci=(+0.0*itf+0.0*itf_Vbi_ci+T_f0_Vbi_ci*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vbi_ci);
  Qf_Vbi_ei_Vbi_ei=(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vbi_ei);
#endif
#endif
Qf=(T_f0*itf);
if
((itf<(1.0e-6*ick)))
{
#if defined(_DERIVATEFORDDX)
Q_fT_Vci_ei=0.0;
#if defined(_DERIVATE)
  Q_fT_Vci_ei_Vci_ei=0.0;
  Q_fT_Vci_ei_Vtnode_GND=0.0;
  Q_fT_Vci_ei_Vbi_ci=0.0;
  Q_fT_Vci_ei_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
Q_fT_Vtnode_GND=Qf_Vtnode_GND;
#endif
Q_fT_Vbi_ci=Qf_Vbi_ci;
#if defined(_DERIVATE)
  Q_fT_Vbi_ci_Vci_ei=Qf_Vbi_ci_Vci_ei;
  Q_fT_Vbi_ci_Vtnode_GND=Qf_Vbi_ci_Vtnode_GND;
  Q_fT_Vbi_ci_Vbi_ci=Qf_Vbi_ci_Vbi_ci;
  Q_fT_Vbi_ci_Vbi_ei=Qf_Vbi_ci_Vbi_ei;
#endif
Q_fT_Vbi_ei=Qf_Vbi_ei;
#if defined(_DERIVATE)
  Q_fT_Vbi_ei_Vci_ei=Qf_Vbi_ei_Vci_ei;
  Q_fT_Vbi_ei_Vtnode_GND=Qf_Vbi_ei_Vtnode_GND;
  Q_fT_Vbi_ei_Vbi_ci=Qf_Vbi_ei_Vbi_ci;
  Q_fT_Vbi_ei_Vbi_ei=Qf_Vbi_ei_Vbi_ei;
#endif
#endif
Q_fT=Qf;
#if defined(_DERIVATEFORDDX)
T_fT_Vci_ei=0.0;
#if defined(_DERIVATE)
  T_fT_Vci_ei_Vci_ei=0.0;
  T_fT_Vci_ei_Vbi_ei=0.0;
  T_fT_Vci_ei_Vtnode_GND=0.0;
  T_fT_Vci_ei_Vbi_ci=0.0;
#endif
T_fT_Vbi_ei=0.0;
#if defined(_DERIVATE)
  T_fT_Vbi_ei_Vci_ei=0.0;
  T_fT_Vbi_ei_Vbi_ei=0.0;
  T_fT_Vbi_ei_Vtnode_GND=0.0;
  T_fT_Vbi_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
T_fT_Vtnode_GND=Tf_Vtnode_GND;
#endif
T_fT_Vbi_ci=Tf_Vbi_ci;
#if defined(_DERIVATE)
  T_fT_Vbi_ci_Vci_ei=Tf_Vbi_ci_Vci_ei;
  T_fT_Vbi_ci_Vbi_ei=Tf_Vbi_ci_Vbi_ei;
  T_fT_Vbi_ci_Vtnode_GND=Tf_Vbi_ci_Vtnode_GND;
  T_fT_Vbi_ci_Vbi_ci=Tf_Vbi_ci_Vbi_ci;
#endif
#endif
T_fT=Tf;
}
else
{
#if defined(_DERIVATEFORDDX)
FFa_Vci_ei=((ick_Vci_ei*itf-ick*itf_Vci_ei)/itf/itf);
#if defined(_DERIVATE)
  FFa_Vci_ei_Vci_ei=(ick_Vci_ei_Vci_ei/itf-(ick_Vci_ei*itf_Vci_ei+ick_Vci_ei*itf_Vci_ei+ick*itf_Vci_ei_Vci_ei)/itf/itf+2*ick*itf_Vci_ei*itf_Vci_ei/itf/itf/itf);
  FFa_Vci_ei_Vtnode_GND=(ick_Vci_ei_Vtnode_GND/itf-(ick_Vci_ei*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vci_ei+ick*itf_Vci_ei_Vtnode_GND)/itf/itf+2*ick*itf_Vci_ei*itf_Vtnode_GND/itf/itf/itf);
  FFa_Vci_ei_Vbi_ei=(0.0/itf-(ick_Vci_ei*itf_Vbi_ei+0.0*itf_Vci_ei+ick*itf_Vci_ei_Vbi_ei)/itf/itf+2*ick*itf_Vci_ei*itf_Vbi_ei/itf/itf/itf);
  FFa_Vci_ei_Vbi_ci=(0.0/itf-(ick_Vci_ei*itf_Vbi_ci+0.0*itf_Vci_ei+ick*itf_Vci_ei_Vbi_ci)/itf/itf+2*ick*itf_Vci_ei*itf_Vbi_ci/itf/itf/itf);
#endif
#if defined(_DERIVATE)
FFa_Vtnode_GND=((ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/itf/itf);
#endif
FFa_Vbi_ei=(-ick*itf_Vbi_ei/itf/itf);
#if defined(_DERIVATE)
  FFa_Vbi_ei_Vci_ei=(0.0/itf-(0.0*itf_Vci_ei+ick_Vci_ei*itf_Vbi_ei+ick*itf_Vbi_ei_Vci_ei)/itf/itf+2*ick*itf_Vbi_ei*itf_Vci_ei/itf/itf/itf);
  FFa_Vbi_ei_Vtnode_GND=(0.0/itf-(0.0*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vbi_ei+ick*itf_Vbi_ei_Vtnode_GND)/itf/itf+2*ick*itf_Vbi_ei*itf_Vtnode_GND/itf/itf/itf);
  FFa_Vbi_ei_Vbi_ei=(0.0/itf-(0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+ick*itf_Vbi_ei_Vbi_ei)/itf/itf+2*ick*itf_Vbi_ei*itf_Vbi_ei/itf/itf/itf);
  FFa_Vbi_ei_Vbi_ci=(0.0/itf-(0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+ick*itf_Vbi_ei_Vbi_ci)/itf/itf+2*ick*itf_Vbi_ei*itf_Vbi_ci/itf/itf/itf);
#endif
FFa_Vbi_ci=(-ick*itf_Vbi_ci/itf/itf);
#if defined(_DERIVATE)
  FFa_Vbi_ci_Vci_ei=(0.0/itf-(0.0*itf_Vci_ei+ick_Vci_ei*itf_Vbi_ci+ick*itf_Vbi_ci_Vci_ei)/itf/itf+2*ick*itf_Vbi_ci*itf_Vci_ei/itf/itf/itf);
  FFa_Vbi_ci_Vtnode_GND=(0.0/itf-(0.0*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vbi_ci+ick*itf_Vbi_ci_Vtnode_GND)/itf/itf+2*ick*itf_Vbi_ci*itf_Vtnode_GND/itf/itf/itf);
  FFa_Vbi_ci_Vbi_ei=(0.0/itf-(0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+ick*itf_Vbi_ci_Vbi_ei)/itf/itf+2*ick*itf_Vbi_ci*itf_Vbi_ei/itf/itf/itf);
  FFa_Vbi_ci_Vbi_ci=(0.0/itf-(0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+ick*itf_Vbi_ci_Vbi_ci)/itf/itf+2*ick*itf_Vbi_ci*itf_Vbi_ci/itf/itf/itf);
#endif
#endif
FFa=(ick/itf);
{
double m00_logE(d00_logE0,FFa)
double m00_exp(d00_exp1,((-gtfe)*d00_logE0))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,FFa)
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFd_TfE_Vtnode_GND=((tef0_t_Vtnode_GND*d00_exp1)+(tef0_t*((-gtfe)*FFa_Vtnode_GND*d10_logE0)*d10_exp1));
#endif
FFd_TfE_Vci_ei=(tef0_t*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1);
#if defined(_DERIVATE)
  FFd_TfE_Vci_ei_Vtnode_GND=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*d10_exp1+tef0_t_Vtnode_GND*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*((-gtfe)*FFa_Vci_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vtnode_GND*d10_logE0+0.0*FFa_Vci_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vtnode_GND*FFa_Vci_ei+d10_logE0*FFa_Vci_ei_Vtnode_GND))));
  FFd_TfE_Vci_ei_Vci_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vci_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vci_ei*d10_logE0))*((-gtfe)*FFa_Vci_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vci_ei*d10_logE0+0.0*FFa_Vci_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vci_ei*FFa_Vci_ei+d10_logE0*FFa_Vci_ei_Vci_ei))));
  FFd_TfE_Vci_ei_Vbi_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*((-gtfe)*FFa_Vci_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ei*d10_logE0+0.0*FFa_Vci_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ei*FFa_Vci_ei+d10_logE0*FFa_Vci_ei_Vbi_ei))));
  FFd_TfE_Vci_ei_Vbi_ci=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*((-gtfe)*FFa_Vci_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ci*d10_logE0+0.0*FFa_Vci_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ci*FFa_Vci_ei+d10_logE0*FFa_Vci_ei_Vbi_ci))));
#endif
FFd_TfE_Vbi_ei=(tef0_t*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1);
#if defined(_DERIVATE)
  FFd_TfE_Vbi_ei_Vtnode_GND=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*d10_exp1+tef0_t_Vtnode_GND*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*((-gtfe)*FFa_Vbi_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vtnode_GND*d10_logE0+0.0*FFa_Vbi_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vtnode_GND*FFa_Vbi_ei+d10_logE0*FFa_Vbi_ei_Vtnode_GND))));
  FFd_TfE_Vbi_ei_Vci_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vci_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vci_ei*d10_logE0))*((-gtfe)*FFa_Vbi_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vci_ei*d10_logE0+0.0*FFa_Vbi_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vci_ei*FFa_Vbi_ei+d10_logE0*FFa_Vbi_ei_Vci_ei))));
  FFd_TfE_Vbi_ei_Vbi_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*((-gtfe)*FFa_Vbi_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ei*d10_logE0+0.0*FFa_Vbi_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ei*FFa_Vbi_ei+d10_logE0*FFa_Vbi_ei_Vbi_ei))));
  FFd_TfE_Vbi_ei_Vbi_ci=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*((-gtfe)*FFa_Vbi_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ci*d10_logE0+0.0*FFa_Vbi_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ci*FFa_Vbi_ei+d10_logE0*FFa_Vbi_ei_Vbi_ci))));
#endif
FFd_TfE_Vbi_ci=(tef0_t*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1);
#if defined(_DERIVATE)
  FFd_TfE_Vbi_ci_Vtnode_GND=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*d10_exp1+tef0_t_Vtnode_GND*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*((-gtfe)*FFa_Vbi_ci*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vtnode_GND*d10_logE0+0.0*FFa_Vbi_ci*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vtnode_GND*FFa_Vbi_ci+d10_logE0*FFa_Vbi_ci_Vtnode_GND))));
  FFd_TfE_Vbi_ci_Vci_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vci_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vci_ei*d10_logE0))*((-gtfe)*FFa_Vbi_ci*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vci_ei*d10_logE0+0.0*FFa_Vbi_ci*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vci_ei*FFa_Vbi_ci+d10_logE0*FFa_Vbi_ci_Vci_ei))));
  FFd_TfE_Vbi_ci_Vbi_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*((-gtfe)*FFa_Vbi_ci*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ei*d10_logE0+0.0*FFa_Vbi_ci*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ei*FFa_Vbi_ci+d10_logE0*FFa_Vbi_ci_Vbi_ei))));
  FFd_TfE_Vbi_ci_Vbi_ci=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*((-gtfe)*FFa_Vbi_ci*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ci*d10_logE0+0.0*FFa_Vbi_ci*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ci*FFa_Vbi_ci+d10_logE0*FFa_Vbi_ci_Vbi_ci))));
#endif
#endif
FFd_TfE=(tef0_t*d00_exp1);
}
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFd_QfE_Vtnode_GND=(((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND))/(gtfe+1.0));
#endif
FFd_QfE_Vci_ei=(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))/(gtfe+1.0));
#if defined(_DERIVATE)
  FFd_QfE_Vci_ei_Vtnode_GND=((+FFd_TfE_Vci_ei_Vtnode_GND*itf+FFd_TfE_Vci_ei*itf_Vtnode_GND+FFd_TfE_Vtnode_GND*itf_Vci_ei+FFd_TfE*itf_Vci_ei_Vtnode_GND)/(gtfe+1.0)-(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))*0.0+(((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vci_ei_Vci_ei=((+FFd_TfE_Vci_ei_Vci_ei*itf+FFd_TfE_Vci_ei*itf_Vci_ei+FFd_TfE_Vci_ei*itf_Vci_ei+FFd_TfE*itf_Vci_ei_Vci_ei)/(gtfe+1.0)-(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))*0.0+(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vci_ei_Vbi_ei=((+FFd_TfE_Vci_ei_Vbi_ei*itf+FFd_TfE_Vci_ei*itf_Vbi_ei+FFd_TfE_Vbi_ei*itf_Vci_ei+FFd_TfE*itf_Vci_ei_Vbi_ei)/(gtfe+1.0)-(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))*0.0+(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vci_ei_Vbi_ci=((+FFd_TfE_Vci_ei_Vbi_ci*itf+FFd_TfE_Vci_ei*itf_Vbi_ci+FFd_TfE_Vbi_ci*itf_Vci_ei+FFd_TfE*itf_Vci_ei_Vbi_ci)/(gtfe+1.0)-(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))*0.0+(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
#endif
FFd_QfE_Vbi_ei=(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))/(gtfe+1.0));
#if defined(_DERIVATE)
  FFd_QfE_Vbi_ei_Vtnode_GND=((+FFd_TfE_Vbi_ei_Vtnode_GND*itf+FFd_TfE_Vbi_ei*itf_Vtnode_GND+FFd_TfE_Vtnode_GND*itf_Vbi_ei+FFd_TfE*itf_Vbi_ei_Vtnode_GND)/(gtfe+1.0)-(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))*0.0+(((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ei_Vci_ei=((+FFd_TfE_Vbi_ei_Vci_ei*itf+FFd_TfE_Vbi_ei*itf_Vci_ei+FFd_TfE_Vci_ei*itf_Vbi_ei+FFd_TfE*itf_Vbi_ei_Vci_ei)/(gtfe+1.0)-(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))*0.0+(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ei_Vbi_ei=((+FFd_TfE_Vbi_ei_Vbi_ei*itf+FFd_TfE_Vbi_ei*itf_Vbi_ei+FFd_TfE_Vbi_ei*itf_Vbi_ei+FFd_TfE*itf_Vbi_ei_Vbi_ei)/(gtfe+1.0)-(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))*0.0+(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ei_Vbi_ci=((+FFd_TfE_Vbi_ei_Vbi_ci*itf+FFd_TfE_Vbi_ei*itf_Vbi_ci+FFd_TfE_Vbi_ci*itf_Vbi_ei+FFd_TfE*itf_Vbi_ei_Vbi_ci)/(gtfe+1.0)-(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))*0.0+(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
#endif
FFd_QfE_Vbi_ci=(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))/(gtfe+1.0));
#if defined(_DERIVATE)
  FFd_QfE_Vbi_ci_Vtnode_GND=((+FFd_TfE_Vbi_ci_Vtnode_GND*itf+FFd_TfE_Vbi_ci*itf_Vtnode_GND+FFd_TfE_Vtnode_GND*itf_Vbi_ci+FFd_TfE*itf_Vbi_ci_Vtnode_GND)/(gtfe+1.0)-(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))*0.0+(((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ci_Vci_ei=((+FFd_TfE_Vbi_ci_Vci_ei*itf+FFd_TfE_Vbi_ci*itf_Vci_ei+FFd_TfE_Vci_ei*itf_Vbi_ci+FFd_TfE*itf_Vbi_ci_Vci_ei)/(gtfe+1.0)-(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))*0.0+(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ci_Vbi_ei=((+FFd_TfE_Vbi_ci_Vbi_ei*itf+FFd_TfE_Vbi_ci*itf_Vbi_ei+FFd_TfE_Vbi_ei*itf_Vbi_ci+FFd_TfE*itf_Vbi_ci_Vbi_ei)/(gtfe+1.0)-(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))*0.0+(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ci_Vbi_ci=((+FFd_TfE_Vbi_ci_Vbi_ci*itf+FFd_TfE_Vbi_ci*itf_Vbi_ci+FFd_TfE_Vbi_ci*itf_Vbi_ci+FFd_TfE*itf_Vbi_ci_Vbi_ci)/(gtfe+1.0)-(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))*0.0+(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
#endif
#endif
FFd_QfE=((FFd_TfE*itf)/(gtfe+1.0));
#if defined(_DERIVATE)
FFT_fbS_Vtnode_GND=((1.0-fthc)*thcs_t_Vtnode_GND);
#endif
FFT_fbS=((1.0-fthc)*thcs_t);
#if defined(_DERIVATEFORDDX)
FFx_Vci_ei=(-FFa_Vci_ei);
#if defined(_DERIVATE)
  FFx_Vci_ei_Vci_ei=(+0.0-FFa_Vci_ei_Vci_ei);
  FFx_Vci_ei_Vtnode_GND=(+0.0-FFa_Vci_ei_Vtnode_GND);
  FFx_Vci_ei_Vbi_ei=(+0.0-FFa_Vci_ei_Vbi_ei);
  FFx_Vci_ei_Vbi_ci=(+0.0-FFa_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FFx_Vtnode_GND=(-FFa_Vtnode_GND);
#endif
FFx_Vbi_ei=(-FFa_Vbi_ei);
#if defined(_DERIVATE)
  FFx_Vbi_ei_Vci_ei=(+0.0-FFa_Vbi_ei_Vci_ei);
  FFx_Vbi_ei_Vtnode_GND=(+0.0-FFa_Vbi_ei_Vtnode_GND);
  FFx_Vbi_ei_Vbi_ei=(+0.0-FFa_Vbi_ei_Vbi_ei);
  FFx_Vbi_ei_Vbi_ci=(+0.0-FFa_Vbi_ei_Vbi_ci);
#endif
FFx_Vbi_ci=(-FFa_Vbi_ci);
#if defined(_DERIVATE)
  FFx_Vbi_ci_Vci_ei=(+0.0-FFa_Vbi_ci_Vci_ei);
  FFx_Vbi_ci_Vtnode_GND=(+0.0-FFa_Vbi_ci_Vtnode_GND);
  FFx_Vbi_ci_Vbi_ei=(+0.0-FFa_Vbi_ci_Vbi_ei);
  FFx_Vbi_ci_Vbi_ci=(+0.0-FFa_Vbi_ci_Vbi_ci);
#endif
#endif
FFx=(1.0-FFa);
{
double m00_sqrt(d00_sqrt0,((FFx*FFx)+ahc))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((FFx*FFx)+ahc))
#endif
#if defined(_DERIVATEFORDDX)
FFs_Vci_ei=((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  FFs_Vci_ei_Vci_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei)))*((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))+d10_sqrt0*(+(+FFx_Vci_ei_Vci_ei*FFx+FFx_Vci_ei*FFx_Vci_ei+FFx_Vci_ei*FFx_Vci_ei+FFx*FFx_Vci_ei_Vci_ei)+0.0));
  FFs_Vci_ei_Vtnode_GND=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND)))*((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))+d10_sqrt0*(+(+FFx_Vci_ei_Vtnode_GND*FFx+FFx_Vci_ei*FFx_Vtnode_GND+FFx_Vtnode_GND*FFx_Vci_ei+FFx*FFx_Vci_ei_Vtnode_GND)+0.0));
  FFs_Vci_ei_Vbi_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei)))*((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))+d10_sqrt0*(+(+FFx_Vci_ei_Vbi_ei*FFx+FFx_Vci_ei*FFx_Vbi_ei+FFx_Vbi_ei*FFx_Vci_ei+FFx*FFx_Vci_ei_Vbi_ei)+0.0));
  FFs_Vci_ei_Vbi_ci=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci)))*((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))+d10_sqrt0*(+(+FFx_Vci_ei_Vbi_ci*FFx+FFx_Vci_ei*FFx_Vbi_ci+FFx_Vbi_ci*FFx_Vci_ei+FFx*FFx_Vci_ei_Vbi_ci)+0.0));
#endif
#if defined(_DERIVATE)
FFs_Vtnode_GND=((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND))*d10_sqrt0;
#endif
FFs_Vbi_ei=((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  FFs_Vbi_ei_Vci_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei)))*((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))+d10_sqrt0*(+(+FFx_Vbi_ei_Vci_ei*FFx+FFx_Vbi_ei*FFx_Vci_ei+FFx_Vci_ei*FFx_Vbi_ei+FFx*FFx_Vbi_ei_Vci_ei)+0.0));
  FFs_Vbi_ei_Vtnode_GND=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND)))*((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))+d10_sqrt0*(+(+FFx_Vbi_ei_Vtnode_GND*FFx+FFx_Vbi_ei*FFx_Vtnode_GND+FFx_Vtnode_GND*FFx_Vbi_ei+FFx*FFx_Vbi_ei_Vtnode_GND)+0.0));
  FFs_Vbi_ei_Vbi_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei)))*((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))+d10_sqrt0*(+(+FFx_Vbi_ei_Vbi_ei*FFx+FFx_Vbi_ei*FFx_Vbi_ei+FFx_Vbi_ei*FFx_Vbi_ei+FFx*FFx_Vbi_ei_Vbi_ei)+0.0));
  FFs_Vbi_ei_Vbi_ci=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci)))*((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))+d10_sqrt0*(+(+FFx_Vbi_ei_Vbi_ci*FFx+FFx_Vbi_ei*FFx_Vbi_ci+FFx_Vbi_ci*FFx_Vbi_ei+FFx*FFx_Vbi_ei_Vbi_ci)+0.0));
#endif
FFs_Vbi_ci=((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))*d10_sqrt0;
#if defined(_DERIVATE)
  FFs_Vbi_ci_Vci_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei)))*((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))+d10_sqrt0*(+(+FFx_Vbi_ci_Vci_ei*FFx+FFx_Vbi_ci*FFx_Vci_ei+FFx_Vci_ei*FFx_Vbi_ci+FFx*FFx_Vbi_ci_Vci_ei)+0.0));
  FFs_Vbi_ci_Vtnode_GND=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND)))*((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))+d10_sqrt0*(+(+FFx_Vbi_ci_Vtnode_GND*FFx+FFx_Vbi_ci*FFx_Vtnode_GND+FFx_Vtnode_GND*FFx_Vbi_ci+FFx*FFx_Vbi_ci_Vtnode_GND)+0.0));
  FFs_Vbi_ci_Vbi_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei)))*((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))+d10_sqrt0*(+(+FFx_Vbi_ci_Vbi_ei*FFx+FFx_Vbi_ci*FFx_Vbi_ei+FFx_Vbi_ei*FFx_Vbi_ci+FFx*FFx_Vbi_ci_Vbi_ei)+0.0));
  FFs_Vbi_ci_Vbi_ci=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci)))*((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))+d10_sqrt0*(+(+FFx_Vbi_ci_Vbi_ci*FFx+FFx_Vbi_ci*FFx_Vbi_ci+FFx_Vbi_ci*FFx_Vbi_ci+FFx*FFx_Vbi_ci_Vbi_ci)+0.0));
#endif
#endif
FFs=d00_sqrt0;
}
{
double m00_sqrt(d00_sqrt0,(1.0+ahc))
#if defined(_DERIVATEFORDDX)
FFw_Vci_ei=((FFx_Vci_ei+FFs_Vci_ei)/(1.0+d00_sqrt0));
#if defined(_DERIVATE)
  FFw_Vci_ei_Vci_ei=((+FFx_Vci_ei_Vci_ei+FFs_Vci_ei_Vci_ei)/(1.0+d00_sqrt0)-((FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vci_ei_Vtnode_GND=((+FFx_Vci_ei_Vtnode_GND+FFs_Vci_ei_Vtnode_GND)/(1.0+d00_sqrt0)-((FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx_Vtnode_GND+FFs_Vtnode_GND)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vci_ei_Vbi_ei=((+FFx_Vci_ei_Vbi_ei+FFs_Vci_ei_Vbi_ei)/(1.0+d00_sqrt0)-((FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vci_ei_Vbi_ci=((+FFx_Vci_ei_Vbi_ci+FFs_Vci_ei_Vbi_ci)/(1.0+d00_sqrt0)-((FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
#endif
#if defined(_DERIVATE)
FFw_Vtnode_GND=((FFx_Vtnode_GND+FFs_Vtnode_GND)/(1.0+d00_sqrt0));
#endif
FFw_Vbi_ei=((FFx_Vbi_ei+FFs_Vbi_ei)/(1.0+d00_sqrt0));
#if defined(_DERIVATE)
  FFw_Vbi_ei_Vci_ei=((+FFx_Vbi_ei_Vci_ei+FFs_Vbi_ei_Vci_ei)/(1.0+d00_sqrt0)-((FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ei_Vtnode_GND=((+FFx_Vbi_ei_Vtnode_GND+FFs_Vbi_ei_Vtnode_GND)/(1.0+d00_sqrt0)-((FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx_Vtnode_GND+FFs_Vtnode_GND)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ei_Vbi_ei=((+FFx_Vbi_ei_Vbi_ei+FFs_Vbi_ei_Vbi_ei)/(1.0+d00_sqrt0)-((FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ei_Vbi_ci=((+FFx_Vbi_ei_Vbi_ci+FFs_Vbi_ei_Vbi_ci)/(1.0+d00_sqrt0)-((FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
#endif
FFw_Vbi_ci=((FFx_Vbi_ci+FFs_Vbi_ci)/(1.0+d00_sqrt0));
#if defined(_DERIVATE)
  FFw_Vbi_ci_Vci_ei=((+FFx_Vbi_ci_Vci_ei+FFs_Vbi_ci_Vci_ei)/(1.0+d00_sqrt0)-((FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ci_Vtnode_GND=((+FFx_Vbi_ci_Vtnode_GND+FFs_Vbi_ci_Vtnode_GND)/(1.0+d00_sqrt0)-((FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx_Vtnode_GND+FFs_Vtnode_GND)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ci_Vbi_ei=((+FFx_Vbi_ci_Vbi_ei+FFs_Vbi_ci_Vbi_ei)/(1.0+d00_sqrt0)-((FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ci_Vbi_ci=((+FFx_Vbi_ci_Vbi_ci+FFs_Vbi_ci_Vbi_ci)/(1.0+d00_sqrt0)-((FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
#endif
#endif
FFw=((FFx+FFs)/(1.0+d00_sqrt0));
}
#if defined(_DERIVATEFORDDX)
FFw_2_Vci_ei=((FFw_Vci_ei*FFw)+(FFw*FFw_Vci_ei));
#if defined(_DERIVATE)
  FFw_2_Vci_ei_Vci_ei=(+FFw_Vci_ei_Vci_ei*FFw+FFw_Vci_ei*FFw_Vci_ei+FFw_Vci_ei*FFw_Vci_ei+FFw*FFw_Vci_ei_Vci_ei);
  FFw_2_Vci_ei_Vtnode_GND=(+FFw_Vci_ei_Vtnode_GND*FFw+FFw_Vci_ei*FFw_Vtnode_GND+FFw_Vtnode_GND*FFw_Vci_ei+FFw*FFw_Vci_ei_Vtnode_GND);
  FFw_2_Vci_ei_Vbi_ei=(+FFw_Vci_ei_Vbi_ei*FFw+FFw_Vci_ei*FFw_Vbi_ei+FFw_Vbi_ei*FFw_Vci_ei+FFw*FFw_Vci_ei_Vbi_ei);
  FFw_2_Vci_ei_Vbi_ci=(+FFw_Vci_ei_Vbi_ci*FFw+FFw_Vci_ei*FFw_Vbi_ci+FFw_Vbi_ci*FFw_Vci_ei+FFw*FFw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FFw_2_Vtnode_GND=((FFw_Vtnode_GND*FFw)+(FFw*FFw_Vtnode_GND));
#endif
FFw_2_Vbi_ei=((FFw_Vbi_ei*FFw)+(FFw*FFw_Vbi_ei));
#if defined(_DERIVATE)
  FFw_2_Vbi_ei_Vci_ei=(+FFw_Vbi_ei_Vci_ei*FFw+FFw_Vbi_ei*FFw_Vci_ei+FFw_Vci_ei*FFw_Vbi_ei+FFw*FFw_Vbi_ei_Vci_ei);
  FFw_2_Vbi_ei_Vtnode_GND=(+FFw_Vbi_ei_Vtnode_GND*FFw+FFw_Vbi_ei*FFw_Vtnode_GND+FFw_Vtnode_GND*FFw_Vbi_ei+FFw*FFw_Vbi_ei_Vtnode_GND);
  FFw_2_Vbi_ei_Vbi_ei=(+FFw_Vbi_ei_Vbi_ei*FFw+FFw_Vbi_ei*FFw_Vbi_ei+FFw_Vbi_ei*FFw_Vbi_ei+FFw*FFw_Vbi_ei_Vbi_ei);
  FFw_2_Vbi_ei_Vbi_ci=(+FFw_Vbi_ei_Vbi_ci*FFw+FFw_Vbi_ei*FFw_Vbi_ci+FFw_Vbi_ci*FFw_Vbi_ei+FFw*FFw_Vbi_ei_Vbi_ci);
#endif
FFw_2_Vbi_ci=((FFw_Vbi_ci*FFw)+(FFw*FFw_Vbi_ci));
#if defined(_DERIVATE)
  FFw_2_Vbi_ci_Vci_ei=(+FFw_Vbi_ci_Vci_ei*FFw+FFw_Vbi_ci*FFw_Vci_ei+FFw_Vci_ei*FFw_Vbi_ci+FFw*FFw_Vbi_ci_Vci_ei);
  FFw_2_Vbi_ci_Vtnode_GND=(+FFw_Vbi_ci_Vtnode_GND*FFw+FFw_Vbi_ci*FFw_Vtnode_GND+FFw_Vtnode_GND*FFw_Vbi_ci+FFw*FFw_Vbi_ci_Vtnode_GND);
  FFw_2_Vbi_ci_Vbi_ei=(+FFw_Vbi_ci_Vbi_ei*FFw+FFw_Vbi_ci*FFw_Vbi_ei+FFw_Vbi_ei*FFw_Vbi_ci+FFw*FFw_Vbi_ci_Vbi_ei);
  FFw_2_Vbi_ci_Vbi_ci=(+FFw_Vbi_ci_Vbi_ci*FFw+FFw_Vbi_ci*FFw_Vbi_ci+FFw_Vbi_ci*FFw_Vbi_ci+FFw*FFw_Vbi_ci_Vbi_ci);
#endif
#endif
FFw_2=(FFw*FFw);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFd_QfB_Vtnode_GND=((((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND))*FFw_2)+((FFT_fbS*itf)*FFw_2_Vtnode_GND));
#endif
FFd_QfB_Vbi_ei=(((FFT_fbS*itf_Vbi_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ei));
#if defined(_DERIVATE)
  FFd_QfB_Vbi_ei_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_fbS_Vtnode_GND*itf_Vbi_ei+FFT_fbS*itf_Vbi_ei_Vtnode_GND)*FFw_2+(FFT_fbS*itf_Vbi_ei)*FFw_2_Vtnode_GND+(((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND)))*FFw_2_Vbi_ei+(FFT_fbS*itf)*FFw_2_Vbi_ei_Vtnode_GND);
  FFd_QfB_Vbi_ei_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+FFT_fbS*itf_Vbi_ei_Vbi_ei)*FFw_2+(FFT_fbS*itf_Vbi_ei)*FFw_2_Vbi_ei+((FFT_fbS*itf_Vbi_ei))*FFw_2_Vbi_ei+(FFT_fbS*itf)*FFw_2_Vbi_ei_Vbi_ei);
  FFd_QfB_Vbi_ei_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+FFT_fbS*itf_Vbi_ei_Vbi_ci)*FFw_2+(FFT_fbS*itf_Vbi_ei)*FFw_2_Vbi_ci+((FFT_fbS*itf_Vbi_ci))*FFw_2_Vbi_ei+(FFT_fbS*itf)*FFw_2_Vbi_ei_Vbi_ci);
  FFd_QfB_Vbi_ei_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ei+FFT_fbS*itf_Vbi_ei_Vci_ei)*FFw_2+(FFT_fbS*itf_Vbi_ei)*FFw_2_Vci_ei+((FFT_fbS*itf_Vci_ei))*FFw_2_Vbi_ei+(FFT_fbS*itf)*FFw_2_Vbi_ei_Vci_ei);
#endif
FFd_QfB_Vbi_ci=(((FFT_fbS*itf_Vbi_ci)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ci));
#if defined(_DERIVATE)
  FFd_QfB_Vbi_ci_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_fbS_Vtnode_GND*itf_Vbi_ci+FFT_fbS*itf_Vbi_ci_Vtnode_GND)*FFw_2+(FFT_fbS*itf_Vbi_ci)*FFw_2_Vtnode_GND+(((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND)))*FFw_2_Vbi_ci+(FFT_fbS*itf)*FFw_2_Vbi_ci_Vtnode_GND);
  FFd_QfB_Vbi_ci_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+FFT_fbS*itf_Vbi_ci_Vbi_ei)*FFw_2+(FFT_fbS*itf_Vbi_ci)*FFw_2_Vbi_ei+((FFT_fbS*itf_Vbi_ei))*FFw_2_Vbi_ci+(FFT_fbS*itf)*FFw_2_Vbi_ci_Vbi_ei);
  FFd_QfB_Vbi_ci_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+FFT_fbS*itf_Vbi_ci_Vbi_ci)*FFw_2+(FFT_fbS*itf_Vbi_ci)*FFw_2_Vbi_ci+((FFT_fbS*itf_Vbi_ci))*FFw_2_Vbi_ci+(FFT_fbS*itf)*FFw_2_Vbi_ci_Vbi_ci);
  FFd_QfB_Vbi_ci_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ci+FFT_fbS*itf_Vbi_ci_Vci_ei)*FFw_2+(FFT_fbS*itf_Vbi_ci)*FFw_2_Vci_ei+((FFT_fbS*itf_Vci_ei))*FFw_2_Vbi_ci+(FFT_fbS*itf)*FFw_2_Vbi_ci_Vci_ei);
#endif
FFd_QfB_Vci_ei=(((FFT_fbS*itf_Vci_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vci_ei));
#if defined(_DERIVATE)
  FFd_QfB_Vci_ei_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_fbS_Vtnode_GND*itf_Vci_ei+FFT_fbS*itf_Vci_ei_Vtnode_GND)*FFw_2+(FFT_fbS*itf_Vci_ei)*FFw_2_Vtnode_GND+(((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND)))*FFw_2_Vci_ei+(FFT_fbS*itf)*FFw_2_Vci_ei_Vtnode_GND);
  FFd_QfB_Vci_ei_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vci_ei+FFT_fbS*itf_Vci_ei_Vbi_ei)*FFw_2+(FFT_fbS*itf_Vci_ei)*FFw_2_Vbi_ei+((FFT_fbS*itf_Vbi_ei))*FFw_2_Vci_ei+(FFT_fbS*itf)*FFw_2_Vci_ei_Vbi_ei);
  FFd_QfB_Vci_ei_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vci_ei+FFT_fbS*itf_Vci_ei_Vbi_ci)*FFw_2+(FFT_fbS*itf_Vci_ei)*FFw_2_Vbi_ci+((FFT_fbS*itf_Vbi_ci))*FFw_2_Vci_ei+(FFT_fbS*itf)*FFw_2_Vci_ei_Vbi_ci);
  FFd_QfB_Vci_ei_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vci_ei+FFT_fbS*itf_Vci_ei_Vci_ei)*FFw_2+(FFT_fbS*itf_Vci_ei)*FFw_2_Vci_ei+((FFT_fbS*itf_Vci_ei))*FFw_2_Vci_ei+(FFT_fbS*itf)*FFw_2_Vci_ei_Vci_ei);
#endif
#endif
FFd_QfB=((FFT_fbS*itf)*FFw_2);
#if defined(_DERIVATE)
Q_bf_Vtnode_GND=FFd_QfB_Vtnode_GND;
Q_bf_Vbi_ei=FFd_QfB_Vbi_ei;
Q_bf_Vbi_ci=FFd_QfB_Vbi_ci;
Q_bf_Vci_ei=FFd_QfB_Vci_ei;
#endif
Q_bf=FFd_QfB;
#if defined(_DERIVATEFORDDX)
FFa_w_Vci_ei=((FFw_2_Vci_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)));
#if defined(_DERIVATE)
  FFa_w_Vci_ei_Vci_ei=(+FFw_2_Vci_ei_Vci_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vci_ei*((((2.0*FFa_Vci_ei))*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2_Vci_ei*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vci_ei+0.0*FFa_Vci_ei+2.0*FFa_Vci_ei_Vci_ei)/FFs-((2.0*FFa_Vci_ei)*FFs_Vci_ei+((2.0*FFa_Vci_ei))*FFs_Vci_ei+(2.0*FFa)*FFs_Vci_ei_Vci_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vci_ei*FFs_Vci_ei/FFs/FFs/FFs)));
  FFa_w_Vci_ei_Vtnode_GND=(+FFw_2_Vci_ei_Vtnode_GND*(1.0+((2.0*FFa)/FFs))+FFw_2_Vci_ei*((((2.0*FFa_Vtnode_GND))*FFs-(2.0*FFa)*FFs_Vtnode_GND)/FFs/FFs)+FFw_2_Vtnode_GND*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vtnode_GND+0.0*FFa_Vci_ei+2.0*FFa_Vci_ei_Vtnode_GND)/FFs-((2.0*FFa_Vci_ei)*FFs_Vtnode_GND+((2.0*FFa_Vtnode_GND))*FFs_Vci_ei+(2.0*FFa)*FFs_Vci_ei_Vtnode_GND)/FFs/FFs+2*(2.0*FFa)*FFs_Vci_ei*FFs_Vtnode_GND/FFs/FFs/FFs)));
  FFa_w_Vci_ei_Vbi_ei=(+FFw_2_Vci_ei_Vbi_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vci_ei*((((2.0*FFa_Vbi_ei))*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2_Vbi_ei*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ei+0.0*FFa_Vci_ei+2.0*FFa_Vci_ei_Vbi_ei)/FFs-((2.0*FFa_Vci_ei)*FFs_Vbi_ei+((2.0*FFa_Vbi_ei))*FFs_Vci_ei+(2.0*FFa)*FFs_Vci_ei_Vbi_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vci_ei*FFs_Vbi_ei/FFs/FFs/FFs)));
  FFa_w_Vci_ei_Vbi_ci=(+FFw_2_Vci_ei_Vbi_ci*(1.0+((2.0*FFa)/FFs))+FFw_2_Vci_ei*((((2.0*FFa_Vbi_ci))*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2_Vbi_ci*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ci+0.0*FFa_Vci_ei+2.0*FFa_Vci_ei_Vbi_ci)/FFs-((2.0*FFa_Vci_ei)*FFs_Vbi_ci+((2.0*FFa_Vbi_ci))*FFs_Vci_ei+(2.0*FFa)*FFs_Vci_ei_Vbi_ci)/FFs/FFs+2*(2.0*FFa)*FFs_Vci_ei*FFs_Vbi_ci/FFs/FFs/FFs)));
#endif
#if defined(_DERIVATE)
FFa_w_Vtnode_GND=((FFw_2_Vtnode_GND*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(((2.0*FFa_Vtnode_GND)*FFs-(2.0*FFa)*FFs_Vtnode_GND)/FFs/FFs)));
#endif
FFa_w_Vbi_ei=((FFw_2_Vbi_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)));
#if defined(_DERIVATE)
  FFa_w_Vbi_ei_Vci_ei=(+FFw_2_Vbi_ei_Vci_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ei*((((2.0*FFa_Vci_ei))*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2_Vci_ei*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vci_ei+0.0*FFa_Vbi_ei+2.0*FFa_Vbi_ei_Vci_ei)/FFs-((2.0*FFa_Vbi_ei)*FFs_Vci_ei+((2.0*FFa_Vci_ei))*FFs_Vbi_ei+(2.0*FFa)*FFs_Vbi_ei_Vci_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ei*FFs_Vci_ei/FFs/FFs/FFs)));
  FFa_w_Vbi_ei_Vtnode_GND=(+FFw_2_Vbi_ei_Vtnode_GND*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ei*((((2.0*FFa_Vtnode_GND))*FFs-(2.0*FFa)*FFs_Vtnode_GND)/FFs/FFs)+FFw_2_Vtnode_GND*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vtnode_GND+0.0*FFa_Vbi_ei+2.0*FFa_Vbi_ei_Vtnode_GND)/FFs-((2.0*FFa_Vbi_ei)*FFs_Vtnode_GND+((2.0*FFa_Vtnode_GND))*FFs_Vbi_ei+(2.0*FFa)*FFs_Vbi_ei_Vtnode_GND)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ei*FFs_Vtnode_GND/FFs/FFs/FFs)));
  FFa_w_Vbi_ei_Vbi_ei=(+FFw_2_Vbi_ei_Vbi_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ei*((((2.0*FFa_Vbi_ei))*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2_Vbi_ei*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ei+0.0*FFa_Vbi_ei+2.0*FFa_Vbi_ei_Vbi_ei)/FFs-((2.0*FFa_Vbi_ei)*FFs_Vbi_ei+((2.0*FFa_Vbi_ei))*FFs_Vbi_ei+(2.0*FFa)*FFs_Vbi_ei_Vbi_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ei*FFs_Vbi_ei/FFs/FFs/FFs)));
  FFa_w_Vbi_ei_Vbi_ci=(+FFw_2_Vbi_ei_Vbi_ci*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ei*((((2.0*FFa_Vbi_ci))*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2_Vbi_ci*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ci+0.0*FFa_Vbi_ei+2.0*FFa_Vbi_ei_Vbi_ci)/FFs-((2.0*FFa_Vbi_ei)*FFs_Vbi_ci+((2.0*FFa_Vbi_ci))*FFs_Vbi_ei+(2.0*FFa)*FFs_Vbi_ei_Vbi_ci)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ei*FFs_Vbi_ci/FFs/FFs/FFs)));
#endif
FFa_w_Vbi_ci=((FFw_2_Vbi_ci*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)));
#if defined(_DERIVATE)
  FFa_w_Vbi_ci_Vci_ei=(+FFw_2_Vbi_ci_Vci_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ci*((((2.0*FFa_Vci_ei))*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2_Vci_ei*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vci_ei+0.0*FFa_Vbi_ci+2.0*FFa_Vbi_ci_Vci_ei)/FFs-((2.0*FFa_Vbi_ci)*FFs_Vci_ei+((2.0*FFa_Vci_ei))*FFs_Vbi_ci+(2.0*FFa)*FFs_Vbi_ci_Vci_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ci*FFs_Vci_ei/FFs/FFs/FFs)));
  FFa_w_Vbi_ci_Vtnode_GND=(+FFw_2_Vbi_ci_Vtnode_GND*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ci*((((2.0*FFa_Vtnode_GND))*FFs-(2.0*FFa)*FFs_Vtnode_GND)/FFs/FFs)+FFw_2_Vtnode_GND*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vtnode_GND+0.0*FFa_Vbi_ci+2.0*FFa_Vbi_ci_Vtnode_GND)/FFs-((2.0*FFa_Vbi_ci)*FFs_Vtnode_GND+((2.0*FFa_Vtnode_GND))*FFs_Vbi_ci+(2.0*FFa)*FFs_Vbi_ci_Vtnode_GND)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ci*FFs_Vtnode_GND/FFs/FFs/FFs)));
  FFa_w_Vbi_ci_Vbi_ei=(+FFw_2_Vbi_ci_Vbi_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ci*((((2.0*FFa_Vbi_ei))*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2_Vbi_ei*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ei+0.0*FFa_Vbi_ci+2.0*FFa_Vbi_ci_Vbi_ei)/FFs-((2.0*FFa_Vbi_ci)*FFs_Vbi_ei+((2.0*FFa_Vbi_ei))*FFs_Vbi_ci+(2.0*FFa)*FFs_Vbi_ci_Vbi_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ci*FFs_Vbi_ei/FFs/FFs/FFs)));
  FFa_w_Vbi_ci_Vbi_ci=(+FFw_2_Vbi_ci_Vbi_ci*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ci*((((2.0*FFa_Vbi_ci))*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2_Vbi_ci*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ci+0.0*FFa_Vbi_ci+2.0*FFa_Vbi_ci_Vbi_ci)/FFs-((2.0*FFa_Vbi_ci)*FFs_Vbi_ci+((2.0*FFa_Vbi_ci))*FFs_Vbi_ci+(2.0*FFa)*FFs_Vbi_ci_Vbi_ci)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ci*FFs_Vbi_ci/FFs/FFs/FFs)));
#endif
#endif
FFa_w=(FFw_2*(1.0+((2.0*FFa)/FFs)));
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFd_TfB_Vtnode_GND=((FFT_fbS_Vtnode_GND*FFa_w)+(FFT_fbS*FFa_w_Vtnode_GND));
#endif
FFd_TfB_Vci_ei=(FFT_fbS*FFa_w_Vci_ei);
#if defined(_DERIVATE)
  FFd_TfB_Vci_ei_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_fbS_Vtnode_GND*FFa_w_Vci_ei+FFT_fbS*FFa_w_Vci_ei_Vtnode_GND);
  FFd_TfB_Vci_ei_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vci_ei+FFT_fbS*FFa_w_Vci_ei_Vci_ei);
  FFd_TfB_Vci_ei_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vci_ei+FFT_fbS*FFa_w_Vci_ei_Vbi_ei);
  FFd_TfB_Vci_ei_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vci_ei+FFT_fbS*FFa_w_Vci_ei_Vbi_ci);
#endif
FFd_TfB_Vbi_ei=(FFT_fbS*FFa_w_Vbi_ei);
#if defined(_DERIVATE)
  FFd_TfB_Vbi_ei_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_fbS_Vtnode_GND*FFa_w_Vbi_ei+FFT_fbS*FFa_w_Vbi_ei_Vtnode_GND);
  FFd_TfB_Vbi_ei_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vbi_ei+FFT_fbS*FFa_w_Vbi_ei_Vci_ei);
  FFd_TfB_Vbi_ei_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vbi_ei+FFT_fbS*FFa_w_Vbi_ei_Vbi_ei);
  FFd_TfB_Vbi_ei_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vbi_ei+FFT_fbS*FFa_w_Vbi_ei_Vbi_ci);
#endif
FFd_TfB_Vbi_ci=(FFT_fbS*FFa_w_Vbi_ci);
#if defined(_DERIVATE)
  FFd_TfB_Vbi_ci_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_fbS_Vtnode_GND*FFa_w_Vbi_ci+FFT_fbS*FFa_w_Vbi_ci_Vtnode_GND);
  FFd_TfB_Vbi_ci_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vbi_ci+FFT_fbS*FFa_w_Vbi_ci_Vci_ei);
  FFd_TfB_Vbi_ci_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vbi_ci+FFT_fbS*FFa_w_Vbi_ci_Vbi_ei);
  FFd_TfB_Vbi_ci_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vbi_ci+FFT_fbS*FFa_w_Vbi_ci_Vbi_ci);
#endif
#endif
FFd_TfB=(FFT_fbS*FFa_w);
#if defined(_DERIVATE)
FFT_pcS_Vtnode_GND=(fthc*thcs_t_Vtnode_GND);
#endif
FFT_pcS=(fthc*thcs_t);
if
(((latb<=0.0)&&(latl<=0.0)))
{
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFQ_fC_Vtnode_GND=((((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND))*FFw_2)+((FFT_pcS*itf)*FFw_2_Vtnode_GND));
#endif
FFQ_fC_Vbi_ei=(((FFT_pcS*itf_Vbi_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ei));
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ei_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vtnode_GND)*FFw_2+(FFT_pcS*itf_Vbi_ei)*FFw_2_Vtnode_GND+(((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND)))*FFw_2_Vbi_ei+(FFT_pcS*itf)*FFw_2_Vbi_ei_Vtnode_GND);
  FFQ_fC_Vbi_ei_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vbi_ei)*FFw_2+(FFT_pcS*itf_Vbi_ei)*FFw_2_Vbi_ei+((FFT_pcS*itf_Vbi_ei))*FFw_2_Vbi_ei+(FFT_pcS*itf)*FFw_2_Vbi_ei_Vbi_ei);
  FFQ_fC_Vbi_ei_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vbi_ci)*FFw_2+(FFT_pcS*itf_Vbi_ei)*FFw_2_Vbi_ci+((FFT_pcS*itf_Vbi_ci))*FFw_2_Vbi_ei+(FFT_pcS*itf)*FFw_2_Vbi_ei_Vbi_ci);
  FFQ_fC_Vbi_ei_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vci_ei)*FFw_2+(FFT_pcS*itf_Vbi_ei)*FFw_2_Vci_ei+((FFT_pcS*itf_Vci_ei))*FFw_2_Vbi_ei+(FFT_pcS*itf)*FFw_2_Vbi_ei_Vci_ei);
#endif
FFQ_fC_Vbi_ci=(((FFT_pcS*itf_Vbi_ci)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ci));
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ci_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vtnode_GND)*FFw_2+(FFT_pcS*itf_Vbi_ci)*FFw_2_Vtnode_GND+(((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND)))*FFw_2_Vbi_ci+(FFT_pcS*itf)*FFw_2_Vbi_ci_Vtnode_GND);
  FFQ_fC_Vbi_ci_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vbi_ei)*FFw_2+(FFT_pcS*itf_Vbi_ci)*FFw_2_Vbi_ei+((FFT_pcS*itf_Vbi_ei))*FFw_2_Vbi_ci+(FFT_pcS*itf)*FFw_2_Vbi_ci_Vbi_ei);
  FFQ_fC_Vbi_ci_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vbi_ci)*FFw_2+(FFT_pcS*itf_Vbi_ci)*FFw_2_Vbi_ci+((FFT_pcS*itf_Vbi_ci))*FFw_2_Vbi_ci+(FFT_pcS*itf)*FFw_2_Vbi_ci_Vbi_ci);
  FFQ_fC_Vbi_ci_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vci_ei)*FFw_2+(FFT_pcS*itf_Vbi_ci)*FFw_2_Vci_ei+((FFT_pcS*itf_Vci_ei))*FFw_2_Vbi_ci+(FFT_pcS*itf)*FFw_2_Vbi_ci_Vci_ei);
#endif
FFQ_fC_Vci_ei=(((FFT_pcS*itf_Vci_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vci_ei));
#if defined(_DERIVATE)
  FFQ_fC_Vci_ei_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vtnode_GND)*FFw_2+(FFT_pcS*itf_Vci_ei)*FFw_2_Vtnode_GND+(((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND)))*FFw_2_Vci_ei+(FFT_pcS*itf)*FFw_2_Vci_ei_Vtnode_GND);
  FFQ_fC_Vci_ei_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vbi_ei)*FFw_2+(FFT_pcS*itf_Vci_ei)*FFw_2_Vbi_ei+((FFT_pcS*itf_Vbi_ei))*FFw_2_Vci_ei+(FFT_pcS*itf)*FFw_2_Vci_ei_Vbi_ei);
  FFQ_fC_Vci_ei_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vbi_ci)*FFw_2+(FFT_pcS*itf_Vci_ei)*FFw_2_Vbi_ci+((FFT_pcS*itf_Vbi_ci))*FFw_2_Vci_ei+(FFT_pcS*itf)*FFw_2_Vci_ei_Vbi_ci);
  FFQ_fC_Vci_ei_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vci_ei)*FFw_2+(FFT_pcS*itf_Vci_ei)*FFw_2_Vci_ei+((FFT_pcS*itf_Vci_ei))*FFw_2_Vci_ei+(FFT_pcS*itf)*FFw_2_Vci_ei_Vci_ei);
#endif
#endif
FFQ_fC=((FFT_pcS*itf)*FFw_2);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFT_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*FFa_w)+(FFT_pcS*FFa_w_Vtnode_GND));
#endif
FFT_fC_Vci_ei=(FFT_pcS*FFa_w_Vci_ei);
#if defined(_DERIVATE)
  FFT_fC_Vci_ei_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_pcS_Vtnode_GND*FFa_w_Vci_ei+FFT_pcS*FFa_w_Vci_ei_Vtnode_GND);
  FFT_fC_Vci_ei_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vci_ei+FFT_pcS*FFa_w_Vci_ei_Vci_ei);
  FFT_fC_Vci_ei_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vci_ei+FFT_pcS*FFa_w_Vci_ei_Vbi_ei);
  FFT_fC_Vci_ei_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vci_ei+FFT_pcS*FFa_w_Vci_ei_Vbi_ci);
#endif
FFT_fC_Vbi_ei=(FFT_pcS*FFa_w_Vbi_ei);
#if defined(_DERIVATE)
  FFT_fC_Vbi_ei_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_pcS_Vtnode_GND*FFa_w_Vbi_ei+FFT_pcS*FFa_w_Vbi_ei_Vtnode_GND);
  FFT_fC_Vbi_ei_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vbi_ei+FFT_pcS*FFa_w_Vbi_ei_Vci_ei);
  FFT_fC_Vbi_ei_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vbi_ei+FFT_pcS*FFa_w_Vbi_ei_Vbi_ei);
  FFT_fC_Vbi_ei_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vbi_ei+FFT_pcS*FFa_w_Vbi_ei_Vbi_ci);
#endif
FFT_fC_Vbi_ci=(FFT_pcS*FFa_w_Vbi_ci);
#if defined(_DERIVATE)
  FFT_fC_Vbi_ci_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_pcS_Vtnode_GND*FFa_w_Vbi_ci+FFT_pcS*FFa_w_Vbi_ci_Vtnode_GND);
  FFT_fC_Vbi_ci_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vbi_ci+FFT_pcS*FFa_w_Vbi_ci_Vci_ei);
  FFT_fC_Vbi_ci_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vbi_ci+FFT_pcS*FFa_w_Vbi_ci_Vbi_ei);
  FFT_fC_Vbi_ci_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vbi_ci+FFT_pcS*FFa_w_Vbi_ci_Vbi_ci);
#endif
#endif
FFT_fC=(FFT_pcS*FFa_w);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFQ_cT_Vtnode_GND=FFQ_fC_Vtnode_GND;
#endif
FFQ_cT_Vbi_ei=FFQ_fC_Vbi_ei;
#if defined(_DERIVATE)
  FFQ_cT_Vbi_ei_Vtnode_GND=FFQ_fC_Vbi_ei_Vtnode_GND;
  FFQ_cT_Vbi_ei_Vbi_ei=FFQ_fC_Vbi_ei_Vbi_ei;
  FFQ_cT_Vbi_ei_Vbi_ci=FFQ_fC_Vbi_ei_Vbi_ci;
  FFQ_cT_Vbi_ei_Vci_ei=FFQ_fC_Vbi_ei_Vci_ei;
#endif
FFQ_cT_Vbi_ci=FFQ_fC_Vbi_ci;
#if defined(_DERIVATE)
  FFQ_cT_Vbi_ci_Vtnode_GND=FFQ_fC_Vbi_ci_Vtnode_GND;
  FFQ_cT_Vbi_ci_Vbi_ei=FFQ_fC_Vbi_ci_Vbi_ei;
  FFQ_cT_Vbi_ci_Vbi_ci=FFQ_fC_Vbi_ci_Vbi_ci;
  FFQ_cT_Vbi_ci_Vci_ei=FFQ_fC_Vbi_ci_Vci_ei;
#endif
FFQ_cT_Vci_ei=FFQ_fC_Vci_ei;
#if defined(_DERIVATE)
  FFQ_cT_Vci_ei_Vtnode_GND=FFQ_fC_Vci_ei_Vtnode_GND;
  FFQ_cT_Vci_ei_Vbi_ei=FFQ_fC_Vci_ei_Vbi_ei;
  FFQ_cT_Vci_ei_Vbi_ci=FFQ_fC_Vci_ei_Vbi_ci;
  FFQ_cT_Vci_ei_Vci_ei=FFQ_fC_Vci_ei_Vci_ei;
#endif
#endif
FFQ_cT=FFQ_fC;
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFT_cT_Vtnode_GND=FFT_fC_Vtnode_GND;
#endif
FFT_cT_Vci_ei=FFT_fC_Vci_ei;
#if defined(_DERIVATE)
  FFT_cT_Vci_ei_Vtnode_GND=FFT_fC_Vci_ei_Vtnode_GND;
  FFT_cT_Vci_ei_Vci_ei=FFT_fC_Vci_ei_Vci_ei;
  FFT_cT_Vci_ei_Vbi_ei=FFT_fC_Vci_ei_Vbi_ei;
  FFT_cT_Vci_ei_Vbi_ci=FFT_fC_Vci_ei_Vbi_ci;
#endif
FFT_cT_Vbi_ei=FFT_fC_Vbi_ei;
#if defined(_DERIVATE)
  FFT_cT_Vbi_ei_Vtnode_GND=FFT_fC_Vbi_ei_Vtnode_GND;
  FFT_cT_Vbi_ei_Vci_ei=FFT_fC_Vbi_ei_Vci_ei;
  FFT_cT_Vbi_ei_Vbi_ei=FFT_fC_Vbi_ei_Vbi_ei;
  FFT_cT_Vbi_ei_Vbi_ci=FFT_fC_Vbi_ei_Vbi_ci;
#endif
FFT_cT_Vbi_ci=FFT_fC_Vbi_ci;
#if defined(_DERIVATE)
  FFT_cT_Vbi_ci_Vtnode_GND=FFT_fC_Vbi_ci_Vtnode_GND;
  FFT_cT_Vbi_ci_Vci_ei=FFT_fC_Vbi_ci_Vci_ei;
  FFT_cT_Vbi_ci_Vbi_ei=FFT_fC_Vbi_ci_Vbi_ei;
  FFT_cT_Vbi_ci_Vbi_ci=FFT_fC_Vbi_ci_Vbi_ci;
#endif
#endif
FFT_cT=FFT_fC;
}
else
{
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFQ_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND));
#endif
FFQ_fC_Vbi_ei=(FFT_pcS*itf_Vbi_ei);
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ei_Vtnode_GND=(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vtnode_GND);
  FFQ_fC_Vbi_ei_Vbi_ei=(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vbi_ei);
  FFQ_fC_Vbi_ei_Vbi_ci=(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vbi_ci);
  FFQ_fC_Vbi_ei_Vci_ei=(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vci_ei);
#endif
FFQ_fC_Vbi_ci=(FFT_pcS*itf_Vbi_ci);
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ci_Vtnode_GND=(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vtnode_GND);
  FFQ_fC_Vbi_ci_Vbi_ei=(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vbi_ei);
  FFQ_fC_Vbi_ci_Vbi_ci=(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vbi_ci);
  FFQ_fC_Vbi_ci_Vci_ei=(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vci_ei);
#endif
FFQ_fC_Vci_ei=0.0;
#if defined(_DERIVATE)
  FFQ_fC_Vci_ei_Vtnode_GND=0.0;
  FFQ_fC_Vci_ei_Vbi_ei=0.0;
  FFQ_fC_Vci_ei_Vbi_ci=0.0;
  FFQ_fC_Vci_ei_Vci_ei=0.0;
#endif
#endif
FFQ_fC=(FFT_pcS*itf);
#if defined(_DERIVATEFORDDX)
FCa_Vci_ei=(-((ick_Vci_ei*itf-ick*itf_Vci_ei)/itf/itf));
#if defined(_DERIVATE)
  FCa_Vci_ei_Vci_ei=(+0.0-(ick_Vci_ei_Vci_ei/itf-(ick_Vci_ei*itf_Vci_ei+ick_Vci_ei*itf_Vci_ei+ick*itf_Vci_ei_Vci_ei)/itf/itf+2*ick*itf_Vci_ei*itf_Vci_ei/itf/itf/itf));
  FCa_Vci_ei_Vtnode_GND=(+0.0-(ick_Vci_ei_Vtnode_GND/itf-(ick_Vci_ei*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vci_ei+ick*itf_Vci_ei_Vtnode_GND)/itf/itf+2*ick*itf_Vci_ei*itf_Vtnode_GND/itf/itf/itf));
  FCa_Vci_ei_Vbi_ei=(+0.0-(0.0/itf-(ick_Vci_ei*itf_Vbi_ei+0.0*itf_Vci_ei+ick*itf_Vci_ei_Vbi_ei)/itf/itf+2*ick*itf_Vci_ei*itf_Vbi_ei/itf/itf/itf));
  FCa_Vci_ei_Vbi_ci=(+0.0-(0.0/itf-(ick_Vci_ei*itf_Vbi_ci+0.0*itf_Vci_ei+ick*itf_Vci_ei_Vbi_ci)/itf/itf+2*ick*itf_Vci_ei*itf_Vbi_ci/itf/itf/itf));
#endif
#if defined(_DERIVATE)
FCa_Vtnode_GND=(-((ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/itf/itf));
#endif
FCa_Vbi_ei=(-(-ick*itf_Vbi_ei/itf/itf));
#if defined(_DERIVATE)
  FCa_Vbi_ei_Vci_ei=(+0.0-(0.0/itf-(0.0*itf_Vci_ei+ick_Vci_ei*itf_Vbi_ei+ick*itf_Vbi_ei_Vci_ei)/itf/itf+2*ick*itf_Vbi_ei*itf_Vci_ei/itf/itf/itf));
  FCa_Vbi_ei_Vtnode_GND=(+0.0-(0.0/itf-(0.0*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vbi_ei+ick*itf_Vbi_ei_Vtnode_GND)/itf/itf+2*ick*itf_Vbi_ei*itf_Vtnode_GND/itf/itf/itf));
  FCa_Vbi_ei_Vbi_ei=(+0.0-(0.0/itf-(0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+ick*itf_Vbi_ei_Vbi_ei)/itf/itf+2*ick*itf_Vbi_ei*itf_Vbi_ei/itf/itf/itf));
  FCa_Vbi_ei_Vbi_ci=(+0.0-(0.0/itf-(0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+ick*itf_Vbi_ei_Vbi_ci)/itf/itf+2*ick*itf_Vbi_ei*itf_Vbi_ci/itf/itf/itf));
#endif
FCa_Vbi_ci=(-(-ick*itf_Vbi_ci/itf/itf));
#if defined(_DERIVATE)
  FCa_Vbi_ci_Vci_ei=(+0.0-(0.0/itf-(0.0*itf_Vci_ei+ick_Vci_ei*itf_Vbi_ci+ick*itf_Vbi_ci_Vci_ei)/itf/itf+2*ick*itf_Vbi_ci*itf_Vci_ei/itf/itf/itf));
  FCa_Vbi_ci_Vtnode_GND=(+0.0-(0.0/itf-(0.0*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vbi_ci+ick*itf_Vbi_ci_Vtnode_GND)/itf/itf+2*ick*itf_Vbi_ci*itf_Vtnode_GND/itf/itf/itf));
  FCa_Vbi_ci_Vbi_ei=(+0.0-(0.0/itf-(0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+ick*itf_Vbi_ci_Vbi_ei)/itf/itf+2*ick*itf_Vbi_ci*itf_Vbi_ei/itf/itf/itf));
  FCa_Vbi_ci_Vbi_ci=(+0.0-(0.0/itf-(0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+ick*itf_Vbi_ci_Vbi_ci)/itf/itf+2*ick*itf_Vbi_ci*itf_Vbi_ci/itf/itf/itf));
#endif
#endif
FCa=(1.0-(ick/itf));
{
double m00_sqrt(d00_sqrt0,((FCa*FCa)+ahc))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((FCa*FCa)+ahc))
#endif
#if defined(_DERIVATEFORDDX)
FCrt_Vci_ei=((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  FCrt_Vci_ei_Vci_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei)))*((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))+d10_sqrt0*(+(+FCa_Vci_ei_Vci_ei*FCa+FCa_Vci_ei*FCa_Vci_ei+FCa_Vci_ei*FCa_Vci_ei+FCa*FCa_Vci_ei_Vci_ei)+0.0));
  FCrt_Vci_ei_Vtnode_GND=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND)))*((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))+d10_sqrt0*(+(+FCa_Vci_ei_Vtnode_GND*FCa+FCa_Vci_ei*FCa_Vtnode_GND+FCa_Vtnode_GND*FCa_Vci_ei+FCa*FCa_Vci_ei_Vtnode_GND)+0.0));
  FCrt_Vci_ei_Vbi_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei)))*((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))+d10_sqrt0*(+(+FCa_Vci_ei_Vbi_ei*FCa+FCa_Vci_ei*FCa_Vbi_ei+FCa_Vbi_ei*FCa_Vci_ei+FCa*FCa_Vci_ei_Vbi_ei)+0.0));
  FCrt_Vci_ei_Vbi_ci=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci)))*((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))+d10_sqrt0*(+(+FCa_Vci_ei_Vbi_ci*FCa+FCa_Vci_ei*FCa_Vbi_ci+FCa_Vbi_ci*FCa_Vci_ei+FCa*FCa_Vci_ei_Vbi_ci)+0.0));
#endif
#if defined(_DERIVATE)
FCrt_Vtnode_GND=((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND))*d10_sqrt0;
#endif
FCrt_Vbi_ei=((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  FCrt_Vbi_ei_Vci_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei)))*((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))+d10_sqrt0*(+(+FCa_Vbi_ei_Vci_ei*FCa+FCa_Vbi_ei*FCa_Vci_ei+FCa_Vci_ei*FCa_Vbi_ei+FCa*FCa_Vbi_ei_Vci_ei)+0.0));
  FCrt_Vbi_ei_Vtnode_GND=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND)))*((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))+d10_sqrt0*(+(+FCa_Vbi_ei_Vtnode_GND*FCa+FCa_Vbi_ei*FCa_Vtnode_GND+FCa_Vtnode_GND*FCa_Vbi_ei+FCa*FCa_Vbi_ei_Vtnode_GND)+0.0));
  FCrt_Vbi_ei_Vbi_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei)))*((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))+d10_sqrt0*(+(+FCa_Vbi_ei_Vbi_ei*FCa+FCa_Vbi_ei*FCa_Vbi_ei+FCa_Vbi_ei*FCa_Vbi_ei+FCa*FCa_Vbi_ei_Vbi_ei)+0.0));
  FCrt_Vbi_ei_Vbi_ci=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci)))*((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))+d10_sqrt0*(+(+FCa_Vbi_ei_Vbi_ci*FCa+FCa_Vbi_ei*FCa_Vbi_ci+FCa_Vbi_ci*FCa_Vbi_ei+FCa*FCa_Vbi_ei_Vbi_ci)+0.0));
#endif
FCrt_Vbi_ci=((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))*d10_sqrt0;
#if defined(_DERIVATE)
  FCrt_Vbi_ci_Vci_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei)))*((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))+d10_sqrt0*(+(+FCa_Vbi_ci_Vci_ei*FCa+FCa_Vbi_ci*FCa_Vci_ei+FCa_Vci_ei*FCa_Vbi_ci+FCa*FCa_Vbi_ci_Vci_ei)+0.0));
  FCrt_Vbi_ci_Vtnode_GND=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND)))*((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))+d10_sqrt0*(+(+FCa_Vbi_ci_Vtnode_GND*FCa+FCa_Vbi_ci*FCa_Vtnode_GND+FCa_Vtnode_GND*FCa_Vbi_ci+FCa*FCa_Vbi_ci_Vtnode_GND)+0.0));
  FCrt_Vbi_ci_Vbi_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei)))*((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))+d10_sqrt0*(+(+FCa_Vbi_ci_Vbi_ei*FCa+FCa_Vbi_ci*FCa_Vbi_ei+FCa_Vbi_ei*FCa_Vbi_ci+FCa*FCa_Vbi_ci_Vbi_ei)+0.0));
  FCrt_Vbi_ci_Vbi_ci=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci)))*((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))+d10_sqrt0*(+(+FCa_Vbi_ci_Vbi_ci*FCa+FCa_Vbi_ci*FCa_Vbi_ci+FCa_Vbi_ci*FCa_Vbi_ci+FCa*FCa_Vbi_ci_Vbi_ci)+0.0));
#endif
#endif
FCrt=d00_sqrt0;
}
{
double m00_sqrt(d00_sqrt0,(1.0+ahc))
#if defined(_DERIVATEFORDDX)
FCa_ck_Vci_ei=(-((FCa_Vci_ei+FCrt_Vci_ei)/(1.0+d00_sqrt0)));
#if defined(_DERIVATE)
  FCa_ck_Vci_ei_Vci_ei=(+0.0-((+FCa_Vci_ei_Vci_ei+FCrt_Vci_ei_Vci_ei)/(1.0+d00_sqrt0)-((FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vci_ei_Vtnode_GND=(+0.0-((+FCa_Vci_ei_Vtnode_GND+FCrt_Vci_ei_Vtnode_GND)/(1.0+d00_sqrt0)-((FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa_Vtnode_GND+FCrt_Vtnode_GND)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vci_ei_Vbi_ei=(+0.0-((+FCa_Vci_ei_Vbi_ei+FCrt_Vci_ei_Vbi_ei)/(1.0+d00_sqrt0)-((FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vci_ei_Vbi_ci=(+0.0-((+FCa_Vci_ei_Vbi_ci+FCrt_Vci_ei_Vbi_ci)/(1.0+d00_sqrt0)-((FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
#endif
#if defined(_DERIVATE)
FCa_ck_Vtnode_GND=(-((FCa_Vtnode_GND+FCrt_Vtnode_GND)/(1.0+d00_sqrt0)));
#endif
FCa_ck_Vbi_ei=(-((FCa_Vbi_ei+FCrt_Vbi_ei)/(1.0+d00_sqrt0)));
#if defined(_DERIVATE)
  FCa_ck_Vbi_ei_Vci_ei=(+0.0-((+FCa_Vbi_ei_Vci_ei+FCrt_Vbi_ei_Vci_ei)/(1.0+d00_sqrt0)-((FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ei_Vtnode_GND=(+0.0-((+FCa_Vbi_ei_Vtnode_GND+FCrt_Vbi_ei_Vtnode_GND)/(1.0+d00_sqrt0)-((FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa_Vtnode_GND+FCrt_Vtnode_GND)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ei_Vbi_ei=(+0.0-((+FCa_Vbi_ei_Vbi_ei+FCrt_Vbi_ei_Vbi_ei)/(1.0+d00_sqrt0)-((FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ei_Vbi_ci=(+0.0-((+FCa_Vbi_ei_Vbi_ci+FCrt_Vbi_ei_Vbi_ci)/(1.0+d00_sqrt0)-((FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
#endif
FCa_ck_Vbi_ci=(-((FCa_Vbi_ci+FCrt_Vbi_ci)/(1.0+d00_sqrt0)));
#if defined(_DERIVATE)
  FCa_ck_Vbi_ci_Vci_ei=(+0.0-((+FCa_Vbi_ci_Vci_ei+FCrt_Vbi_ci_Vci_ei)/(1.0+d00_sqrt0)-((FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ci_Vtnode_GND=(+0.0-((+FCa_Vbi_ci_Vtnode_GND+FCrt_Vbi_ci_Vtnode_GND)/(1.0+d00_sqrt0)-((FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa_Vtnode_GND+FCrt_Vtnode_GND)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ci_Vbi_ei=(+0.0-((+FCa_Vbi_ci_Vbi_ei+FCrt_Vbi_ci_Vbi_ei)/(1.0+d00_sqrt0)-((FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ci_Vbi_ci=(+0.0-((+FCa_Vbi_ci_Vbi_ci+FCrt_Vbi_ci_Vbi_ci)/(1.0+d00_sqrt0)-((FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
#endif
#endif
FCa_ck=(1.0-((FCa+FCrt)/(1.0+d00_sqrt0)));
}
#if defined(_DERIVATEFORDDX)
FCdaick_ditf_Vci_ei=((((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/(FCrt*itf)/(FCrt*itf));
#if defined(_DERIVATE)
  FCdaick_ditf_Vci_ei_Vci_ei=((+(+FCa_ck_Vci_ei_Vci_ei-0.0)*(1-FCa)+FCa_ck_Vci_ei*(-FCa_Vci_ei)+FCa_ck_Vci_ei*(-FCa_Vci_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vci_ei_Vci_ei))/(FCrt*itf)-(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))+(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei))))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vci_ei_Vci_ei*itf+FCrt_Vci_ei*itf_Vci_ei+FCrt_Vci_ei*itf_Vci_ei+FCrt*itf_Vci_ei_Vci_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vci_ei_Vtnode_GND=((+(+FCa_ck_Vci_ei_Vtnode_GND-0.0)*(1-FCa)+FCa_ck_Vci_ei*(-FCa_Vtnode_GND)+FCa_ck_Vtnode_GND*(-FCa_Vci_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vci_ei_Vtnode_GND))/(FCrt*itf)-(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))+(((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND))))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vci_ei_Vtnode_GND*itf+FCrt_Vci_ei*itf_Vtnode_GND+FCrt_Vtnode_GND*itf_Vci_ei+FCrt*itf_Vci_ei_Vtnode_GND))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vci_ei_Vbi_ei=((+(+FCa_ck_Vci_ei_Vbi_ei-0.0)*(1-FCa)+FCa_ck_Vci_ei*(-FCa_Vbi_ei)+FCa_ck_Vbi_ei*(-FCa_Vci_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vci_ei_Vbi_ei))/(FCrt*itf)-(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))+(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei))))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vci_ei_Vbi_ei*itf+FCrt_Vci_ei*itf_Vbi_ei+FCrt_Vbi_ei*itf_Vci_ei+FCrt*itf_Vci_ei_Vbi_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vci_ei_Vbi_ci=((+(+FCa_ck_Vci_ei_Vbi_ci-0.0)*(1-FCa)+FCa_ck_Vci_ei*(-FCa_Vbi_ci)+FCa_ck_Vbi_ci*(-FCa_Vci_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vci_ei_Vbi_ci))/(FCrt*itf)-(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))+(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci))))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vci_ei_Vbi_ci*itf+FCrt_Vci_ei*itf_Vbi_ci+FCrt_Vbi_ci*itf_Vci_ei+FCrt*itf_Vci_ei_Vbi_ci))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
#endif
#if defined(_DERIVATE)
FCdaick_ditf_Vtnode_GND=((((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/(FCrt*itf)/(FCrt*itf));
#endif
FCdaick_ditf_Vbi_ei=((((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/(FCrt*itf)/(FCrt*itf));
#if defined(_DERIVATE)
  FCdaick_ditf_Vbi_ei_Vci_ei=((+(+FCa_ck_Vbi_ei_Vci_ei-0.0)*(1-FCa)+FCa_ck_Vbi_ei*(-FCa_Vci_ei)+FCa_ck_Vci_ei*(-FCa_Vbi_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ei_Vci_ei))/(FCrt*itf)-(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))+(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei))))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ei_Vci_ei*itf+FCrt_Vbi_ei*itf_Vci_ei+FCrt_Vci_ei*itf_Vbi_ei+FCrt*itf_Vbi_ei_Vci_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ei_Vtnode_GND=((+(+FCa_ck_Vbi_ei_Vtnode_GND-0.0)*(1-FCa)+FCa_ck_Vbi_ei*(-FCa_Vtnode_GND)+FCa_ck_Vtnode_GND*(-FCa_Vbi_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ei_Vtnode_GND))/(FCrt*itf)-(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))+(((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND))))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ei_Vtnode_GND*itf+FCrt_Vbi_ei*itf_Vtnode_GND+FCrt_Vtnode_GND*itf_Vbi_ei+FCrt*itf_Vbi_ei_Vtnode_GND))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ei_Vbi_ei=((+(+FCa_ck_Vbi_ei_Vbi_ei-0.0)*(1-FCa)+FCa_ck_Vbi_ei*(-FCa_Vbi_ei)+FCa_ck_Vbi_ei*(-FCa_Vbi_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ei_Vbi_ei))/(FCrt*itf)-(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))+(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei))))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ei_Vbi_ei*itf+FCrt_Vbi_ei*itf_Vbi_ei+FCrt_Vbi_ei*itf_Vbi_ei+FCrt*itf_Vbi_ei_Vbi_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ei_Vbi_ci=((+(+FCa_ck_Vbi_ei_Vbi_ci-0.0)*(1-FCa)+FCa_ck_Vbi_ei*(-FCa_Vbi_ci)+FCa_ck_Vbi_ci*(-FCa_Vbi_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ei_Vbi_ci))/(FCrt*itf)-(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))+(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci))))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ei_Vbi_ci*itf+FCrt_Vbi_ei*itf_Vbi_ci+FCrt_Vbi_ci*itf_Vbi_ei+FCrt*itf_Vbi_ei_Vbi_ci))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
#endif
FCdaick_ditf_Vbi_ci=((((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/(FCrt*itf)/(FCrt*itf));
#if defined(_DERIVATE)
  FCdaick_ditf_Vbi_ci_Vci_ei=((+(+FCa_ck_Vbi_ci_Vci_ei-0.0)*(1-FCa)+FCa_ck_Vbi_ci*(-FCa_Vci_ei)+FCa_ck_Vci_ei*(-FCa_Vbi_ci)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ci_Vci_ei))/(FCrt*itf)-(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))+(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei))))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ci_Vci_ei*itf+FCrt_Vbi_ci*itf_Vci_ei+FCrt_Vci_ei*itf_Vbi_ci+FCrt*itf_Vbi_ci_Vci_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ci_Vtnode_GND=((+(+FCa_ck_Vbi_ci_Vtnode_GND-0.0)*(1-FCa)+FCa_ck_Vbi_ci*(-FCa_Vtnode_GND)+FCa_ck_Vtnode_GND*(-FCa_Vbi_ci)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ci_Vtnode_GND))/(FCrt*itf)-(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))+(((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND))))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ci_Vtnode_GND*itf+FCrt_Vbi_ci*itf_Vtnode_GND+FCrt_Vtnode_GND*itf_Vbi_ci+FCrt*itf_Vbi_ci_Vtnode_GND))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ci_Vbi_ei=((+(+FCa_ck_Vbi_ci_Vbi_ei-0.0)*(1-FCa)+FCa_ck_Vbi_ci*(-FCa_Vbi_ei)+FCa_ck_Vbi_ei*(-FCa_Vbi_ci)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ci_Vbi_ei))/(FCrt*itf)-(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))+(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei))))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ci_Vbi_ei*itf+FCrt_Vbi_ci*itf_Vbi_ei+FCrt_Vbi_ei*itf_Vbi_ci+FCrt*itf_Vbi_ci_Vbi_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ci_Vbi_ci=((+(+FCa_ck_Vbi_ci_Vbi_ci-0.0)*(1-FCa)+FCa_ck_Vbi_ci*(-FCa_Vbi_ci)+FCa_ck_Vbi_ci*(-FCa_Vbi_ci)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ci_Vbi_ci))/(FCrt*itf)-(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))+(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci))))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ci_Vbi_ci*itf+FCrt_Vbi_ci*itf_Vbi_ci+FCrt_Vbi_ci*itf_Vbi_ci+FCrt*itf_Vbi_ci_Vbi_ci))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
#endif
#endif
FCdaick_ditf=(((FCa_ck-1.0)*(1-FCa))/(FCrt*itf));
if
((latb>latl))
{
#if defined(_DERIVATEFORDDX)
FCz_Vci_ei=0.0;
#if defined(_DERIVATE)
  FCz_Vci_ei_Vci_ei=0.0;
  FCz_Vci_ei_Vtnode_GND=0.0;
  FCz_Vci_ei_Vbi_ei=0.0;
  FCz_Vci_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
FCz_Vtnode_GND=0.0;
#endif
FCz_Vbi_ei=0.0;
#if defined(_DERIVATE)
  FCz_Vbi_ei_Vci_ei=0.0;
  FCz_Vbi_ei_Vtnode_GND=0.0;
  FCz_Vbi_ei_Vbi_ei=0.0;
  FCz_Vbi_ei_Vbi_ci=0.0;
#endif
FCz_Vbi_ci=0.0;
#if defined(_DERIVATE)
  FCz_Vbi_ci_Vci_ei=0.0;
  FCz_Vbi_ci_Vtnode_GND=0.0;
  FCz_Vbi_ci_Vbi_ei=0.0;
  FCz_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
FCz=(latb-latl);
FCxl=(1.0+latl);
FCxb=(1.0+latb);
if
((latb>0.01))
{
{
double m00_logE(d00_logE0,(FCxb/FCxl))
FCln=d00_logE0;
}
{
double m00_exp(d00_exp0,((FCa_ck-1.0)*FCln))
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
FCa1_Vci_ei=FCa_ck_Vci_ei*FCln*d10_exp0;
#if defined(_DERIVATE)
  FCa1_Vci_ei_Vci_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vci_ei*FCln)*FCa_ck_Vci_ei*FCln+d10_exp0*(+(+FCa_ck_Vci_ei_Vci_ei-0.0)*FCln+FCa_ck_Vci_ei*0.0+FCa_ck_Vci_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vci_ei_Vtnode_GND=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vtnode_GND*FCln)*FCa_ck_Vci_ei*FCln+d10_exp0*(+(+FCa_ck_Vci_ei_Vtnode_GND-0.0)*FCln+FCa_ck_Vci_ei*0.0+FCa_ck_Vtnode_GND*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vci_ei_Vbi_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ei*FCln)*FCa_ck_Vci_ei*FCln+d10_exp0*(+(+FCa_ck_Vci_ei_Vbi_ei-0.0)*FCln+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vci_ei_Vbi_ci=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ci*FCln)*FCa_ck_Vci_ei*FCln+d10_exp0*(+(+FCa_ck_Vci_ei_Vbi_ci-0.0)*FCln+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ci*0.0+(FCa_ck-1.0)*0.0));
#endif
#if defined(_DERIVATE)
FCa1_Vtnode_GND=FCa_ck_Vtnode_GND*FCln*d10_exp0;
#endif
FCa1_Vbi_ei=FCa_ck_Vbi_ei*FCln*d10_exp0;
#if defined(_DERIVATE)
  FCa1_Vbi_ei_Vci_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vci_ei*FCln)*FCa_ck_Vbi_ei*FCln+d10_exp0*(+(+FCa_ck_Vbi_ei_Vci_ei-0.0)*FCln+FCa_ck_Vbi_ei*0.0+FCa_ck_Vci_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ei_Vtnode_GND=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vtnode_GND*FCln)*FCa_ck_Vbi_ei*FCln+d10_exp0*(+(+FCa_ck_Vbi_ei_Vtnode_GND-0.0)*FCln+FCa_ck_Vbi_ei*0.0+FCa_ck_Vtnode_GND*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ei_Vbi_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ei*FCln)*FCa_ck_Vbi_ei*FCln+d10_exp0*(+(+FCa_ck_Vbi_ei_Vbi_ei-0.0)*FCln+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ei_Vbi_ci=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ci*FCln)*FCa_ck_Vbi_ei*FCln+d10_exp0*(+(+FCa_ck_Vbi_ei_Vbi_ci-0.0)*FCln+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ci*0.0+(FCa_ck-1.0)*0.0));
#endif
FCa1_Vbi_ci=FCa_ck_Vbi_ci*FCln*d10_exp0;
#if defined(_DERIVATE)
  FCa1_Vbi_ci_Vci_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vci_ei*FCln)*FCa_ck_Vbi_ci*FCln+d10_exp0*(+(+FCa_ck_Vbi_ci_Vci_ei-0.0)*FCln+FCa_ck_Vbi_ci*0.0+FCa_ck_Vci_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ci_Vtnode_GND=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vtnode_GND*FCln)*FCa_ck_Vbi_ci*FCln+d10_exp0*(+(+FCa_ck_Vbi_ci_Vtnode_GND-0.0)*FCln+FCa_ck_Vbi_ci*0.0+FCa_ck_Vtnode_GND*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ci_Vbi_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ei*FCln)*FCa_ck_Vbi_ci*FCln+d10_exp0*(+(+FCa_ck_Vbi_ci_Vbi_ei-0.0)*FCln+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ci_Vbi_ci=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ci*FCln)*FCa_ck_Vbi_ci*FCln+d10_exp0*(+(+FCa_ck_Vbi_ci_Vbi_ci-0.0)*FCln+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ci*0.0+(FCa_ck-1.0)*0.0));
#endif
#endif
FCa1=d00_exp0;
}
#if defined(_DERIVATEFORDDX)
FCd_a_Vci_ei=(-(-FCa1_Vci_ei*latb)/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#if defined(_DERIVATE)
  FCd_a_Vci_ei_Vci_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vci_ei*latb))+0.0*(-FCa1_Vci_ei*latb)+1.0*(+0.0-(+FCa1_Vci_ei_Vci_ei*latb+FCa1_Vci_ei*0.0+FCa1_Vci_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vci_ei*latb)*(-(FCa1_Vci_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vci_ei_Vtnode_GND=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vtnode_GND*latb))+0.0*(-FCa1_Vci_ei*latb)+1.0*(+0.0-(+FCa1_Vci_ei_Vtnode_GND*latb+FCa1_Vci_ei*0.0+FCa1_Vtnode_GND*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vci_ei*latb)*(-(FCa1_Vtnode_GND*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vci_ei_Vbi_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ei*latb))+0.0*(-FCa1_Vci_ei*latb)+1.0*(+0.0-(+FCa1_Vci_ei_Vbi_ei*latb+FCa1_Vci_ei*0.0+FCa1_Vbi_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vci_ei*latb)*(-(FCa1_Vbi_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vci_ei_Vbi_ci=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ci*latb))+0.0*(-FCa1_Vci_ei*latb)+1.0*(+0.0-(+FCa1_Vci_ei_Vbi_ci*latb+FCa1_Vci_ei*0.0+FCa1_Vbi_ci*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vci_ei*latb)*(-(FCa1_Vbi_ci*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#endif
#if defined(_DERIVATE)
FCd_a_Vtnode_GND=(-(-FCa1_Vtnode_GND*latb)/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#endif
FCd_a_Vbi_ei=(-(-FCa1_Vbi_ei*latb)/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ei_Vci_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vci_ei*latb))+0.0*(-FCa1_Vbi_ei*latb)+1.0*(+0.0-(+FCa1_Vbi_ei_Vci_ei*latb+FCa1_Vbi_ei*0.0+FCa1_Vci_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ei*latb)*(-(FCa1_Vci_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ei_Vtnode_GND=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vtnode_GND*latb))+0.0*(-FCa1_Vbi_ei*latb)+1.0*(+0.0-(+FCa1_Vbi_ei_Vtnode_GND*latb+FCa1_Vbi_ei*0.0+FCa1_Vtnode_GND*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ei*latb)*(-(FCa1_Vtnode_GND*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ei_Vbi_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ei*latb))+0.0*(-FCa1_Vbi_ei*latb)+1.0*(+0.0-(+FCa1_Vbi_ei_Vbi_ei*latb+FCa1_Vbi_ei*0.0+FCa1_Vbi_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ei*latb)*(-(FCa1_Vbi_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ei_Vbi_ci=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ci*latb))+0.0*(-FCa1_Vbi_ei*latb)+1.0*(+0.0-(+FCa1_Vbi_ei_Vbi_ci*latb+FCa1_Vbi_ei*0.0+FCa1_Vbi_ci*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ei*latb)*(-(FCa1_Vbi_ci*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#endif
FCd_a_Vbi_ci=(-(-FCa1_Vbi_ci*latb)/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ci_Vci_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vci_ei*latb))+0.0*(-FCa1_Vbi_ci*latb)+1.0*(+0.0-(+FCa1_Vbi_ci_Vci_ei*latb+FCa1_Vbi_ci*0.0+FCa1_Vci_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ci*latb)*(-(FCa1_Vci_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ci_Vtnode_GND=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vtnode_GND*latb))+0.0*(-FCa1_Vbi_ci*latb)+1.0*(+0.0-(+FCa1_Vbi_ci_Vtnode_GND*latb+FCa1_Vbi_ci*0.0+FCa1_Vtnode_GND*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ci*latb)*(-(FCa1_Vtnode_GND*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ci_Vbi_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ei*latb))+0.0*(-FCa1_Vbi_ci*latb)+1.0*(+0.0-(+FCa1_Vbi_ci_Vbi_ei*latb+FCa1_Vbi_ci*0.0+FCa1_Vbi_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ci*latb)*(-(FCa1_Vbi_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ci_Vbi_ci=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ci*latb))+0.0*(-FCa1_Vbi_ci*latb)+1.0*(+0.0-(+FCa1_Vbi_ci_Vbi_ci*latb+FCa1_Vbi_ci*0.0+FCa1_Vbi_ci*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ci*latb)*(-(FCa1_Vbi_ci*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#endif
#endif
FCd_a=(1.0/(latl-(FCa1*latb)));
#if defined(_DERIVATEFORDDX)
FCw_Vci_ei=((FCa1_Vci_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCw_Vci_ei_Vci_ei=(+(+FCa1_Vci_ei_Vci_ei-0.0)*FCd_a+FCa1_Vci_ei*FCd_a_Vci_ei+FCa1_Vci_ei*FCd_a_Vci_ei+(FCa1-1.0)*FCd_a_Vci_ei_Vci_ei);
  FCw_Vci_ei_Vtnode_GND=(+(+FCa1_Vci_ei_Vtnode_GND-0.0)*FCd_a+FCa1_Vci_ei*FCd_a_Vtnode_GND+FCa1_Vtnode_GND*FCd_a_Vci_ei+(FCa1-1.0)*FCd_a_Vci_ei_Vtnode_GND);
  FCw_Vci_ei_Vbi_ei=(+(+FCa1_Vci_ei_Vbi_ei-0.0)*FCd_a+FCa1_Vci_ei*FCd_a_Vbi_ei+FCa1_Vbi_ei*FCd_a_Vci_ei+(FCa1-1.0)*FCd_a_Vci_ei_Vbi_ei);
  FCw_Vci_ei_Vbi_ci=(+(+FCa1_Vci_ei_Vbi_ci-0.0)*FCd_a+FCa1_Vci_ei*FCd_a_Vbi_ci+FCa1_Vbi_ci*FCd_a_Vci_ei+(FCa1-1.0)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw_Vtnode_GND=((FCa1_Vtnode_GND*FCd_a)+((FCa1-1.0)*FCd_a_Vtnode_GND));
#endif
FCw_Vbi_ei=((FCa1_Vbi_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCw_Vbi_ei_Vci_ei=(+(+FCa1_Vbi_ei_Vci_ei-0.0)*FCd_a+FCa1_Vbi_ei*FCd_a_Vci_ei+FCa1_Vci_ei*FCd_a_Vbi_ei+(FCa1-1.0)*FCd_a_Vbi_ei_Vci_ei);
  FCw_Vbi_ei_Vtnode_GND=(+(+FCa1_Vbi_ei_Vtnode_GND-0.0)*FCd_a+FCa1_Vbi_ei*FCd_a_Vtnode_GND+FCa1_Vtnode_GND*FCd_a_Vbi_ei+(FCa1-1.0)*FCd_a_Vbi_ei_Vtnode_GND);
  FCw_Vbi_ei_Vbi_ei=(+(+FCa1_Vbi_ei_Vbi_ei-0.0)*FCd_a+FCa1_Vbi_ei*FCd_a_Vbi_ei+FCa1_Vbi_ei*FCd_a_Vbi_ei+(FCa1-1.0)*FCd_a_Vbi_ei_Vbi_ei);
  FCw_Vbi_ei_Vbi_ci=(+(+FCa1_Vbi_ei_Vbi_ci-0.0)*FCd_a+FCa1_Vbi_ei*FCd_a_Vbi_ci+FCa1_Vbi_ci*FCd_a_Vbi_ei+(FCa1-1.0)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCw_Vbi_ci=((FCa1_Vbi_ci*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCw_Vbi_ci_Vci_ei=(+(+FCa1_Vbi_ci_Vci_ei-0.0)*FCd_a+FCa1_Vbi_ci*FCd_a_Vci_ei+FCa1_Vci_ei*FCd_a_Vbi_ci+(FCa1-1.0)*FCd_a_Vbi_ci_Vci_ei);
  FCw_Vbi_ci_Vtnode_GND=(+(+FCa1_Vbi_ci_Vtnode_GND-0.0)*FCd_a+FCa1_Vbi_ci*FCd_a_Vtnode_GND+FCa1_Vtnode_GND*FCd_a_Vbi_ci+(FCa1-1.0)*FCd_a_Vbi_ci_Vtnode_GND);
  FCw_Vbi_ci_Vbi_ei=(+(+FCa1_Vbi_ci_Vbi_ei-0.0)*FCd_a+FCa1_Vbi_ci*FCd_a_Vbi_ei+FCa1_Vbi_ei*FCd_a_Vbi_ci+(FCa1-1.0)*FCd_a_Vbi_ci_Vbi_ei);
  FCw_Vbi_ci_Vbi_ci=(+(+FCa1_Vbi_ci_Vbi_ci-0.0)*FCd_a+FCa1_Vbi_ci*FCd_a_Vbi_ci+FCa1_Vbi_ci*FCd_a_Vbi_ci+(FCa1-1.0)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCw=((FCa1-1.0)*FCd_a);
#if defined(_DERIVATEFORDDX)
FCdw_daick_Vci_ei=(((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vci_ei_Vci_ei=(+(+(+(+0.0*FCa1+(-FCz_Vci_ei)*FCa1_Vci_ei+(-FCz_Vci_ei)*FCa1_Vci_ei+(-FCz)*FCa1_Vci_ei_Vci_ei)*FCln+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*0.0+((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a_Vci_ei+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a_Vci_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei_Vci_ei)*FCd_a+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a_Vci_ei+((((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei)))*FCd_a_Vci_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei_Vci_ei);
  FCdw_daick_Vci_ei_Vtnode_GND=(+(+(+(+0.0*FCa1+(-FCz_Vci_ei)*FCa1_Vtnode_GND+(-FCz_Vtnode_GND)*FCa1_Vci_ei+(-FCz)*FCa1_Vci_ei_Vtnode_GND)*FCln+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*0.0+((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a_Vtnode_GND+(((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a_Vci_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei_Vtnode_GND)*FCd_a+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a_Vtnode_GND+((((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND)))*FCd_a_Vci_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei_Vtnode_GND);
  FCdw_daick_Vci_ei_Vbi_ei=(+(+(+(+0.0*FCa1+(-FCz_Vci_ei)*FCa1_Vbi_ei+(-FCz_Vbi_ei)*FCa1_Vci_ei+(-FCz)*FCa1_Vci_ei_Vbi_ei)*FCln+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*0.0+((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a_Vbi_ei+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a_Vci_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei_Vbi_ei)*FCd_a+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a_Vbi_ei+((((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei)))*FCd_a_Vci_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei_Vbi_ei);
  FCdw_daick_Vci_ei_Vbi_ci=(+(+(+(+0.0*FCa1+(-FCz_Vci_ei)*FCa1_Vbi_ci+(-FCz_Vbi_ci)*FCa1_Vci_ei+(-FCz)*FCa1_Vci_ei_Vbi_ci)*FCln+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*0.0+((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a_Vbi_ci+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a_Vci_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei_Vbi_ci)*FCd_a+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a_Vbi_ci+((((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci)))*FCd_a_Vci_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdw_daick_Vtnode_GND=(((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vtnode_GND));
#endif
FCdw_daick_Vbi_ei=(((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ei_Vci_ei=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ei)*FCa1_Vci_ei+(-FCz_Vci_ei)*FCa1_Vbi_ei+(-FCz)*FCa1_Vbi_ei_Vci_ei)*FCln+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*0.0+((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a_Vci_ei+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a_Vbi_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei_Vci_ei)*FCd_a+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a_Vci_ei+((((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei)))*FCd_a_Vbi_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei_Vci_ei);
  FCdw_daick_Vbi_ei_Vtnode_GND=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ei)*FCa1_Vtnode_GND+(-FCz_Vtnode_GND)*FCa1_Vbi_ei+(-FCz)*FCa1_Vbi_ei_Vtnode_GND)*FCln+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*0.0+((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a_Vtnode_GND+(((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a_Vbi_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei_Vtnode_GND)*FCd_a+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a_Vtnode_GND+((((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND)))*FCd_a_Vbi_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei_Vtnode_GND);
  FCdw_daick_Vbi_ei_Vbi_ei=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ei)*FCa1_Vbi_ei+(-FCz_Vbi_ei)*FCa1_Vbi_ei+(-FCz)*FCa1_Vbi_ei_Vbi_ei)*FCln+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*0.0+((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a_Vbi_ei+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a_Vbi_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei_Vbi_ei)*FCd_a+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a_Vbi_ei+((((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei)))*FCd_a_Vbi_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei_Vbi_ei);
  FCdw_daick_Vbi_ei_Vbi_ci=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ei)*FCa1_Vbi_ci+(-FCz_Vbi_ci)*FCa1_Vbi_ei+(-FCz)*FCa1_Vbi_ei_Vbi_ci)*FCln+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*0.0+((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a_Vbi_ci+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a_Vbi_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei_Vbi_ci)*FCd_a+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a_Vbi_ci+((((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci)))*FCd_a_Vbi_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCdw_daick_Vbi_ci=(((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ci_Vci_ei=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ci)*FCa1_Vci_ei+(-FCz_Vci_ei)*FCa1_Vbi_ci+(-FCz)*FCa1_Vbi_ci_Vci_ei)*FCln+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*0.0+((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a_Vci_ei+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a_Vbi_ci+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci_Vci_ei)*FCd_a+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a_Vci_ei+((((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei)))*FCd_a_Vbi_ci+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci_Vci_ei);
  FCdw_daick_Vbi_ci_Vtnode_GND=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ci)*FCa1_Vtnode_GND+(-FCz_Vtnode_GND)*FCa1_Vbi_ci+(-FCz)*FCa1_Vbi_ci_Vtnode_GND)*FCln+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*0.0+((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a_Vtnode_GND+(((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a_Vbi_ci+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci_Vtnode_GND)*FCd_a+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a_Vtnode_GND+((((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND)))*FCd_a_Vbi_ci+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci_Vtnode_GND);
  FCdw_daick_Vbi_ci_Vbi_ei=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ci)*FCa1_Vbi_ei+(-FCz_Vbi_ei)*FCa1_Vbi_ci+(-FCz)*FCa1_Vbi_ci_Vbi_ei)*FCln+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*0.0+((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a_Vbi_ei+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a_Vbi_ci+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci_Vbi_ei)*FCd_a+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a_Vbi_ei+((((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei)))*FCd_a_Vbi_ci+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci_Vbi_ei);
  FCdw_daick_Vbi_ci_Vbi_ci=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ci)*FCa1_Vbi_ci+(-FCz_Vbi_ci)*FCa1_Vbi_ci+(-FCz)*FCa1_Vbi_ci_Vbi_ci)*FCln+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*0.0+((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a_Vbi_ci+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a_Vbi_ci+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci_Vbi_ci)*FCd_a+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a_Vbi_ci+((((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci)))*FCd_a_Vbi_ci+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCdw_daick=(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a);
{
double m00_logE(d00_logE0,((1.0+(latb*FCw))/(1.0+(latl*FCw))))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,((1.0+(latb*FCw))/(1.0+(latl*FCw))))
#endif
#if defined(_DERIVATEFORDDX)
FCa1_Vci_ei=(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*d10_logE0;
#if defined(_DERIVATE)
  FCa1_Vci_ei_Vci_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vci_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei))/(1.0+(latl*FCw))-((latb*FCw_Vci_ei)*((latl*FCw_Vci_ei))+((latb*FCw_Vci_ei))*(latl*FCw_Vci_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vci_ei)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vci_ei_Vtnode_GND=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vtnode_GND))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND))/(1.0+(latl*FCw))-((latb*FCw_Vci_ei)*((latl*FCw_Vtnode_GND))+((latb*FCw_Vtnode_GND))*(latl*FCw_Vci_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vci_ei)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vci_ei_Vbi_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei))/(1.0+(latl*FCw))-((latb*FCw_Vci_ei)*((latl*FCw_Vbi_ei))+((latb*FCw_Vbi_ei))*(latl*FCw_Vci_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vci_ei)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vci_ei_Vbi_ci=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ci))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci))/(1.0+(latl*FCw))-((latb*FCw_Vci_ei)*((latl*FCw_Vbi_ci))+((latb*FCw_Vbi_ci))*(latl*FCw_Vci_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vci_ei)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
#if defined(_DERIVATE)
FCa1_Vtnode_GND=(((latb*FCw_Vtnode_GND)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*d10_logE0;
#endif
FCa1_Vbi_ei=(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*d10_logE0;
#if defined(_DERIVATE)
  FCa1_Vbi_ei_Vci_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vci_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ei)*((latl*FCw_Vci_ei))+((latb*FCw_Vci_ei))*(latl*FCw_Vbi_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ei)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ei_Vtnode_GND=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vtnode_GND))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ei)*((latl*FCw_Vtnode_GND))+((latb*FCw_Vtnode_GND))*(latl*FCw_Vbi_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ei)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ei_Vbi_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ei)*((latl*FCw_Vbi_ei))+((latb*FCw_Vbi_ei))*(latl*FCw_Vbi_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ei)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ei_Vbi_ci=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ci))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ei)*((latl*FCw_Vbi_ci))+((latb*FCw_Vbi_ci))*(latl*FCw_Vbi_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ei)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
FCa1_Vbi_ci=(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*d10_logE0;
#if defined(_DERIVATE)
  FCa1_Vbi_ci_Vci_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vci_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ci)*((latl*FCw_Vci_ei))+((latb*FCw_Vci_ei))*(latl*FCw_Vbi_ci)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ci)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ci_Vtnode_GND=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vtnode_GND))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ci)*((latl*FCw_Vtnode_GND))+((latb*FCw_Vtnode_GND))*(latl*FCw_Vbi_ci)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ci)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ci_Vbi_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ci)*((latl*FCw_Vbi_ei))+((latb*FCw_Vbi_ei))*(latl*FCw_Vbi_ci)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ci)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ci_Vbi_ci=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ci))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ci)*((latl*FCw_Vbi_ci))+((latb*FCw_Vbi_ci))*(latl*FCw_Vbi_ci)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ci)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
#endif
FCa1=d00_logE0;
}
#if defined(_DERIVATEFORDDX)
FCda1_dw_Vci_ei=((-latb*(latb*FCw_Vci_ei)/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(-latl*(latl*FCw_Vci_ei)/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#if defined(_DERIVATE)
  FCda1_dw_Vci_ei_Vci_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vci_ei))+0.0*(latb*FCw_Vci_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vci_ei)*((latb*FCw_Vci_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vci_ei))+0.0*(latl*FCw_Vci_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vci_ei)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vci_ei_Vtnode_GND=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vtnode_GND))+0.0*(latb*FCw_Vci_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vci_ei)*((latb*FCw_Vtnode_GND))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vtnode_GND))+0.0*(latl*FCw_Vci_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vci_ei)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vci_ei_Vbi_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ei))+0.0*(latb*FCw_Vci_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vci_ei)*((latb*FCw_Vbi_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ei))+0.0*(latl*FCw_Vci_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vci_ei)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vci_ei_Vbi_ci=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ci))+0.0*(latb*FCw_Vci_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vci_ei)*((latb*FCw_Vbi_ci))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ci))+0.0*(latl*FCw_Vci_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vci_ei)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
#if defined(_DERIVATE)
FCda1_dw_Vtnode_GND=((-latb*(latb*FCw_Vtnode_GND)/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(-latl*(latl*FCw_Vtnode_GND)/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
FCda1_dw_Vbi_ei=((-latb*(latb*FCw_Vbi_ei)/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(-latl*(latl*FCw_Vbi_ei)/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#if defined(_DERIVATE)
  FCda1_dw_Vbi_ei_Vci_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vci_ei))+0.0*(latb*FCw_Vbi_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ei)*((latb*FCw_Vci_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vci_ei))+0.0*(latl*FCw_Vbi_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ei)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ei_Vtnode_GND=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vtnode_GND))+0.0*(latb*FCw_Vbi_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ei)*((latb*FCw_Vtnode_GND))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vtnode_GND))+0.0*(latl*FCw_Vbi_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ei)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ei_Vbi_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ei))+0.0*(latb*FCw_Vbi_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ei)*((latb*FCw_Vbi_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ei))+0.0*(latl*FCw_Vbi_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ei)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ei_Vbi_ci=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ci))+0.0*(latb*FCw_Vbi_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ei)*((latb*FCw_Vbi_ci))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ci))+0.0*(latl*FCw_Vbi_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ei)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
FCda1_dw_Vbi_ci=((-latb*(latb*FCw_Vbi_ci)/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(-latl*(latl*FCw_Vbi_ci)/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#if defined(_DERIVATE)
  FCda1_dw_Vbi_ci_Vci_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vci_ei))+0.0*(latb*FCw_Vbi_ci)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ci)*((latb*FCw_Vci_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vci_ei))+0.0*(latl*FCw_Vbi_ci)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ci)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ci_Vtnode_GND=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vtnode_GND))+0.0*(latb*FCw_Vbi_ci)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ci)*((latb*FCw_Vtnode_GND))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vtnode_GND))+0.0*(latl*FCw_Vbi_ci)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ci)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ci_Vbi_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ei))+0.0*(latb*FCw_Vbi_ci)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ci)*((latb*FCw_Vbi_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ei))+0.0*(latl*FCw_Vbi_ci)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ci)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ci_Vbi_ci=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ci))+0.0*(latb*FCw_Vbi_ci)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ci)*((latb*FCw_Vbi_ci))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ci))+0.0*(latl*FCw_Vbi_ci)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ci)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
#endif
FCda1_dw=((latb/(1.0+(latb*FCw)))-(latl/(1.0+(latl*FCw))));
}
else
{
#if defined(_DERIVATEFORDDX)
FCf1_Vci_ei=(-FCa_ck_Vci_ei);
#if defined(_DERIVATE)
  FCf1_Vci_ei_Vci_ei=(+0.0-FCa_ck_Vci_ei_Vci_ei);
  FCf1_Vci_ei_Vtnode_GND=(+0.0-FCa_ck_Vci_ei_Vtnode_GND);
  FCf1_Vci_ei_Vbi_ei=(+0.0-FCa_ck_Vci_ei_Vbi_ei);
  FCf1_Vci_ei_Vbi_ci=(+0.0-FCa_ck_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCf1_Vtnode_GND=(-FCa_ck_Vtnode_GND);
#endif
FCf1_Vbi_ei=(-FCa_ck_Vbi_ei);
#if defined(_DERIVATE)
  FCf1_Vbi_ei_Vci_ei=(+0.0-FCa_ck_Vbi_ei_Vci_ei);
  FCf1_Vbi_ei_Vtnode_GND=(+0.0-FCa_ck_Vbi_ei_Vtnode_GND);
  FCf1_Vbi_ei_Vbi_ei=(+0.0-FCa_ck_Vbi_ei_Vbi_ei);
  FCf1_Vbi_ei_Vbi_ci=(+0.0-FCa_ck_Vbi_ei_Vbi_ci);
#endif
FCf1_Vbi_ci=(-FCa_ck_Vbi_ci);
#if defined(_DERIVATE)
  FCf1_Vbi_ci_Vci_ei=(+0.0-FCa_ck_Vbi_ci_Vci_ei);
  FCf1_Vbi_ci_Vtnode_GND=(+0.0-FCa_ck_Vbi_ci_Vtnode_GND);
  FCf1_Vbi_ci_Vbi_ei=(+0.0-FCa_ck_Vbi_ci_Vbi_ei);
  FCf1_Vbi_ci_Vbi_ci=(+0.0-FCa_ck_Vbi_ci_Vbi_ci);
#endif
#endif
FCf1=(1.0-FCa_ck);
#if defined(_DERIVATEFORDDX)
FCd_a_Vci_ei=(-FCa_ck_Vci_ei*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vci_ei_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vci_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vtnode_GND*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vbi_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vbi_ci*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
#if defined(_DERIVATE)
FCd_a_Vtnode_GND=(-FCa_ck_Vtnode_GND*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
FCd_a_Vbi_ei=(-FCa_ck_Vbi_ei*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ei_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vci_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vtnode_GND*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vbi_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vbi_ci*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
FCd_a_Vbi_ci=(-FCa_ck_Vbi_ci*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ci_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vci_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vtnode_GND*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vbi_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vbi_ci*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
#endif
FCd_a=(1.0/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATEFORDDX)
FCw_Vci_ei=((FCf1_Vci_ei*FCd_a)+(FCf1*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCw_Vci_ei_Vci_ei=(+FCf1_Vci_ei_Vci_ei*FCd_a+FCf1_Vci_ei*FCd_a_Vci_ei+FCf1_Vci_ei*FCd_a_Vci_ei+FCf1*FCd_a_Vci_ei_Vci_ei);
  FCw_Vci_ei_Vtnode_GND=(+FCf1_Vci_ei_Vtnode_GND*FCd_a+FCf1_Vci_ei*FCd_a_Vtnode_GND+FCf1_Vtnode_GND*FCd_a_Vci_ei+FCf1*FCd_a_Vci_ei_Vtnode_GND);
  FCw_Vci_ei_Vbi_ei=(+FCf1_Vci_ei_Vbi_ei*FCd_a+FCf1_Vci_ei*FCd_a_Vbi_ei+FCf1_Vbi_ei*FCd_a_Vci_ei+FCf1*FCd_a_Vci_ei_Vbi_ei);
  FCw_Vci_ei_Vbi_ci=(+FCf1_Vci_ei_Vbi_ci*FCd_a+FCf1_Vci_ei*FCd_a_Vbi_ci+FCf1_Vbi_ci*FCd_a_Vci_ei+FCf1*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw_Vtnode_GND=((FCf1_Vtnode_GND*FCd_a)+(FCf1*FCd_a_Vtnode_GND));
#endif
FCw_Vbi_ei=((FCf1_Vbi_ei*FCd_a)+(FCf1*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCw_Vbi_ei_Vci_ei=(+FCf1_Vbi_ei_Vci_ei*FCd_a+FCf1_Vbi_ei*FCd_a_Vci_ei+FCf1_Vci_ei*FCd_a_Vbi_ei+FCf1*FCd_a_Vbi_ei_Vci_ei);
  FCw_Vbi_ei_Vtnode_GND=(+FCf1_Vbi_ei_Vtnode_GND*FCd_a+FCf1_Vbi_ei*FCd_a_Vtnode_GND+FCf1_Vtnode_GND*FCd_a_Vbi_ei+FCf1*FCd_a_Vbi_ei_Vtnode_GND);
  FCw_Vbi_ei_Vbi_ei=(+FCf1_Vbi_ei_Vbi_ei*FCd_a+FCf1_Vbi_ei*FCd_a_Vbi_ei+FCf1_Vbi_ei*FCd_a_Vbi_ei+FCf1*FCd_a_Vbi_ei_Vbi_ei);
  FCw_Vbi_ei_Vbi_ci=(+FCf1_Vbi_ei_Vbi_ci*FCd_a+FCf1_Vbi_ei*FCd_a_Vbi_ci+FCf1_Vbi_ci*FCd_a_Vbi_ei+FCf1*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCw_Vbi_ci=((FCf1_Vbi_ci*FCd_a)+(FCf1*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCw_Vbi_ci_Vci_ei=(+FCf1_Vbi_ci_Vci_ei*FCd_a+FCf1_Vbi_ci*FCd_a_Vci_ei+FCf1_Vci_ei*FCd_a_Vbi_ci+FCf1*FCd_a_Vbi_ci_Vci_ei);
  FCw_Vbi_ci_Vtnode_GND=(+FCf1_Vbi_ci_Vtnode_GND*FCd_a+FCf1_Vbi_ci*FCd_a_Vtnode_GND+FCf1_Vtnode_GND*FCd_a_Vbi_ci+FCf1*FCd_a_Vbi_ci_Vtnode_GND);
  FCw_Vbi_ci_Vbi_ei=(+FCf1_Vbi_ci_Vbi_ei*FCd_a+FCf1_Vbi_ci*FCd_a_Vbi_ei+FCf1_Vbi_ei*FCd_a_Vbi_ci+FCf1*FCd_a_Vbi_ci_Vbi_ei);
  FCw_Vbi_ci_Vbi_ci=(+FCf1_Vbi_ci_Vbi_ci*FCd_a+FCf1_Vbi_ci*FCd_a_Vbi_ci+FCf1_Vbi_ci*FCd_a_Vbi_ci+FCf1*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCw=(FCf1*FCd_a);
#if defined(_DERIVATEFORDDX)
FCdw_daick_Vci_ei=((((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a)+(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vci_ei_Vci_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vci_ei+(-1.0)*FCd_a_Vci_ei_Vci_ei)*FCd_a+((-1.0)*FCd_a_Vci_ei)*FCd_a_Vci_ei+(((-1.0)*FCd_a_Vci_ei))*FCd_a_Vci_ei+((-1.0)*FCd_a)*FCd_a_Vci_ei_Vci_ei)*FCxb+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*0.0+((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a_Vci_ei+(((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*FCxb)*FCd_a_Vci_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei_Vci_ei);
  FCdw_daick_Vci_ei_Vtnode_GND=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vci_ei+(-1.0)*FCd_a_Vci_ei_Vtnode_GND)*FCd_a+((-1.0)*FCd_a_Vci_ei)*FCd_a_Vtnode_GND+(((-1.0)*FCd_a_Vtnode_GND))*FCd_a_Vci_ei+((-1.0)*FCd_a)*FCd_a_Vci_ei_Vtnode_GND)*FCxb+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*0.0+((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a_Vtnode_GND+(((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*FCxb)*FCd_a_Vci_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei_Vtnode_GND);
  FCdw_daick_Vci_ei_Vbi_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vci_ei+(-1.0)*FCd_a_Vci_ei_Vbi_ei)*FCd_a+((-1.0)*FCd_a_Vci_ei)*FCd_a_Vbi_ei+(((-1.0)*FCd_a_Vbi_ei))*FCd_a_Vci_ei+((-1.0)*FCd_a)*FCd_a_Vci_ei_Vbi_ei)*FCxb+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*0.0+((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a_Vbi_ei+(((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*FCxb)*FCd_a_Vci_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei_Vbi_ei);
  FCdw_daick_Vci_ei_Vbi_ci=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vci_ei+(-1.0)*FCd_a_Vci_ei_Vbi_ci)*FCd_a+((-1.0)*FCd_a_Vci_ei)*FCd_a_Vbi_ci+(((-1.0)*FCd_a_Vbi_ci))*FCd_a_Vci_ei+((-1.0)*FCd_a)*FCd_a_Vci_ei_Vbi_ci)*FCxb+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*0.0+((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a_Vbi_ci+(((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*FCxb)*FCd_a_Vci_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdw_daick_Vtnode_GND=((((((-1.0)*FCd_a_Vtnode_GND)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND))*FCxb*FCd_a)+(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vtnode_GND));
#endif
FCdw_daick_Vbi_ei=((((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a)+(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ei_Vci_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vbi_ei+(-1.0)*FCd_a_Vbi_ei_Vci_ei)*FCd_a+((-1.0)*FCd_a_Vbi_ei)*FCd_a_Vci_ei+(((-1.0)*FCd_a_Vci_ei))*FCd_a_Vbi_ei+((-1.0)*FCd_a)*FCd_a_Vbi_ei_Vci_ei)*FCxb+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*0.0+((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a_Vci_ei+(((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*FCxb)*FCd_a_Vbi_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei_Vci_ei);
  FCdw_daick_Vbi_ei_Vtnode_GND=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vbi_ei+(-1.0)*FCd_a_Vbi_ei_Vtnode_GND)*FCd_a+((-1.0)*FCd_a_Vbi_ei)*FCd_a_Vtnode_GND+(((-1.0)*FCd_a_Vtnode_GND))*FCd_a_Vbi_ei+((-1.0)*FCd_a)*FCd_a_Vbi_ei_Vtnode_GND)*FCxb+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*0.0+((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a_Vtnode_GND+(((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*FCxb)*FCd_a_Vbi_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei_Vtnode_GND);
  FCdw_daick_Vbi_ei_Vbi_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vbi_ei+(-1.0)*FCd_a_Vbi_ei_Vbi_ei)*FCd_a+((-1.0)*FCd_a_Vbi_ei)*FCd_a_Vbi_ei+(((-1.0)*FCd_a_Vbi_ei))*FCd_a_Vbi_ei+((-1.0)*FCd_a)*FCd_a_Vbi_ei_Vbi_ei)*FCxb+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*0.0+((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a_Vbi_ei+(((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*FCxb)*FCd_a_Vbi_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei_Vbi_ei);
  FCdw_daick_Vbi_ei_Vbi_ci=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vbi_ei+(-1.0)*FCd_a_Vbi_ei_Vbi_ci)*FCd_a+((-1.0)*FCd_a_Vbi_ei)*FCd_a_Vbi_ci+(((-1.0)*FCd_a_Vbi_ci))*FCd_a_Vbi_ei+((-1.0)*FCd_a)*FCd_a_Vbi_ei_Vbi_ci)*FCxb+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*0.0+((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a_Vbi_ci+(((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*FCxb)*FCd_a_Vbi_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCdw_daick_Vbi_ci=((((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a)+(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ci_Vci_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vbi_ci+(-1.0)*FCd_a_Vbi_ci_Vci_ei)*FCd_a+((-1.0)*FCd_a_Vbi_ci)*FCd_a_Vci_ei+(((-1.0)*FCd_a_Vci_ei))*FCd_a_Vbi_ci+((-1.0)*FCd_a)*FCd_a_Vbi_ci_Vci_ei)*FCxb+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*0.0+((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a_Vci_ei+(((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*FCxb)*FCd_a_Vbi_ci+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci_Vci_ei);
  FCdw_daick_Vbi_ci_Vtnode_GND=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vbi_ci+(-1.0)*FCd_a_Vbi_ci_Vtnode_GND)*FCd_a+((-1.0)*FCd_a_Vbi_ci)*FCd_a_Vtnode_GND+(((-1.0)*FCd_a_Vtnode_GND))*FCd_a_Vbi_ci+((-1.0)*FCd_a)*FCd_a_Vbi_ci_Vtnode_GND)*FCxb+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*0.0+((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a_Vtnode_GND+(((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*FCxb)*FCd_a_Vbi_ci+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci_Vtnode_GND);
  FCdw_daick_Vbi_ci_Vbi_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vbi_ci+(-1.0)*FCd_a_Vbi_ci_Vbi_ei)*FCd_a+((-1.0)*FCd_a_Vbi_ci)*FCd_a_Vbi_ei+(((-1.0)*FCd_a_Vbi_ei))*FCd_a_Vbi_ci+((-1.0)*FCd_a)*FCd_a_Vbi_ci_Vbi_ei)*FCxb+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*0.0+((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a_Vbi_ei+(((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*FCxb)*FCd_a_Vbi_ci+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci_Vbi_ei);
  FCdw_daick_Vbi_ci_Vbi_ci=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vbi_ci+(-1.0)*FCd_a_Vbi_ci_Vbi_ci)*FCd_a+((-1.0)*FCd_a_Vbi_ci)*FCd_a_Vbi_ci+(((-1.0)*FCd_a_Vbi_ci))*FCd_a_Vbi_ci+((-1.0)*FCd_a)*FCd_a_Vbi_ci_Vbi_ci)*FCxb+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*0.0+((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a_Vbi_ci+(((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*FCxb)*FCd_a_Vbi_ci+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCdw_daick=(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a);
#if defined(_DERIVATEFORDDX)
FCa1_Vci_ei=((FCz_Vci_ei*FCw)+(FCz*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCa1_Vci_ei_Vci_ei=(+FCz_Vci_ei_Vci_ei*FCw+FCz_Vci_ei*FCw_Vci_ei+FCz_Vci_ei*FCw_Vci_ei+FCz*FCw_Vci_ei_Vci_ei);
  FCa1_Vci_ei_Vtnode_GND=(+FCz_Vci_ei_Vtnode_GND*FCw+FCz_Vci_ei*FCw_Vtnode_GND+FCz_Vtnode_GND*FCw_Vci_ei+FCz*FCw_Vci_ei_Vtnode_GND);
  FCa1_Vci_ei_Vbi_ei=(+FCz_Vci_ei_Vbi_ei*FCw+FCz_Vci_ei*FCw_Vbi_ei+FCz_Vbi_ei*FCw_Vci_ei+FCz*FCw_Vci_ei_Vbi_ei);
  FCa1_Vci_ei_Vbi_ci=(+FCz_Vci_ei_Vbi_ci*FCw+FCz_Vci_ei*FCw_Vbi_ci+FCz_Vbi_ci*FCw_Vci_ei+FCz*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCa1_Vtnode_GND=((FCz_Vtnode_GND*FCw)+(FCz*FCw_Vtnode_GND));
#endif
FCa1_Vbi_ei=((FCz_Vbi_ei*FCw)+(FCz*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCa1_Vbi_ei_Vci_ei=(+FCz_Vbi_ei_Vci_ei*FCw+FCz_Vbi_ei*FCw_Vci_ei+FCz_Vci_ei*FCw_Vbi_ei+FCz*FCw_Vbi_ei_Vci_ei);
  FCa1_Vbi_ei_Vtnode_GND=(+FCz_Vbi_ei_Vtnode_GND*FCw+FCz_Vbi_ei*FCw_Vtnode_GND+FCz_Vtnode_GND*FCw_Vbi_ei+FCz*FCw_Vbi_ei_Vtnode_GND);
  FCa1_Vbi_ei_Vbi_ei=(+FCz_Vbi_ei_Vbi_ei*FCw+FCz_Vbi_ei*FCw_Vbi_ei+FCz_Vbi_ei*FCw_Vbi_ei+FCz*FCw_Vbi_ei_Vbi_ei);
  FCa1_Vbi_ei_Vbi_ci=(+FCz_Vbi_ei_Vbi_ci*FCw+FCz_Vbi_ei*FCw_Vbi_ci+FCz_Vbi_ci*FCw_Vbi_ei+FCz*FCw_Vbi_ei_Vbi_ci);
#endif
FCa1_Vbi_ci=((FCz_Vbi_ci*FCw)+(FCz*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCa1_Vbi_ci_Vci_ei=(+FCz_Vbi_ci_Vci_ei*FCw+FCz_Vbi_ci*FCw_Vci_ei+FCz_Vci_ei*FCw_Vbi_ci+FCz*FCw_Vbi_ci_Vci_ei);
  FCa1_Vbi_ci_Vtnode_GND=(+FCz_Vbi_ci_Vtnode_GND*FCw+FCz_Vbi_ci*FCw_Vtnode_GND+FCz_Vtnode_GND*FCw_Vbi_ci+FCz*FCw_Vbi_ci_Vtnode_GND);
  FCa1_Vbi_ci_Vbi_ei=(+FCz_Vbi_ci_Vbi_ei*FCw+FCz_Vbi_ci*FCw_Vbi_ei+FCz_Vbi_ei*FCw_Vbi_ci+FCz*FCw_Vbi_ci_Vbi_ei);
  FCa1_Vbi_ci_Vbi_ci=(+FCz_Vbi_ci_Vbi_ci*FCw+FCz_Vbi_ci*FCw_Vbi_ci+FCz_Vbi_ci*FCw_Vbi_ci+FCz*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCa1=(FCz*FCw);
#if defined(_DERIVATEFORDDX)
FCda1_dw_Vci_ei=0.0;
#if defined(_DERIVATE)
  FCda1_dw_Vci_ei_Vci_ei=0.0;
  FCda1_dw_Vci_ei_Vtnode_GND=0.0;
  FCda1_dw_Vci_ei_Vbi_ei=0.0;
  FCda1_dw_Vci_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
FCda1_dw_Vtnode_GND=0.0;
#endif
FCda1_dw_Vbi_ei=0.0;
#if defined(_DERIVATE)
  FCda1_dw_Vbi_ei_Vci_ei=0.0;
  FCda1_dw_Vbi_ei_Vtnode_GND=0.0;
  FCda1_dw_Vbi_ei_Vbi_ei=0.0;
  FCda1_dw_Vbi_ei_Vbi_ci=0.0;
#endif
FCda1_dw_Vbi_ci=0.0;
#if defined(_DERIVATE)
  FCda1_dw_Vbi_ci_Vci_ei=0.0;
  FCda1_dw_Vbi_ci_Vtnode_GND=0.0;
  FCda1_dw_Vbi_ci_Vbi_ei=0.0;
  FCda1_dw_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
FCda1_dw=FCz;
}
#if defined(_DERIVATEFORDDX)
FCf_CT_Vbi_ei=0.0;
#if defined(_DERIVATE)
  FCf_CT_Vbi_ei_Vbi_ei=0.0;
  FCf_CT_Vbi_ei_Vbi_ci=0.0;
  FCf_CT_Vbi_ei_Vci_ei=0.0;
  FCf_CT_Vbi_ei_Vtnode_GND=0.0;
#endif
FCf_CT_Vbi_ci=0.0;
#if defined(_DERIVATE)
  FCf_CT_Vbi_ci_Vbi_ei=0.0;
  FCf_CT_Vbi_ci_Vbi_ci=0.0;
  FCf_CT_Vbi_ci_Vci_ei=0.0;
  FCf_CT_Vbi_ci_Vtnode_GND=0.0;
#endif
FCf_CT_Vci_ei=0.0;
#if defined(_DERIVATE)
  FCf_CT_Vci_ei_Vbi_ei=0.0;
  FCf_CT_Vci_ei_Vbi_ci=0.0;
  FCf_CT_Vci_ei_Vci_ei=0.0;
  FCf_CT_Vci_ei_Vtnode_GND=0.0;
#endif
#if defined(_DERIVATE)
FCf_CT_Vtnode_GND=0.0;
#endif
#endif
FCf_CT=(2.0/FCz);
#if defined(_DERIVATEFORDDX)
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCw2_Vci_ei_Vci_ei=(+FCw_Vci_ei_Vci_ei*FCw+FCw_Vci_ei*FCw_Vci_ei+FCw_Vci_ei*FCw_Vci_ei+FCw*FCw_Vci_ei_Vci_ei);
  FCw2_Vci_ei_Vtnode_GND=(+FCw_Vci_ei_Vtnode_GND*FCw+FCw_Vci_ei*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vci_ei+FCw*FCw_Vci_ei_Vtnode_GND);
  FCw2_Vci_ei_Vbi_ei=(+FCw_Vci_ei_Vbi_ei*FCw+FCw_Vci_ei*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vci_ei+FCw*FCw_Vci_ei_Vbi_ei);
  FCw2_Vci_ei_Vbi_ci=(+FCw_Vci_ei_Vbi_ci*FCw+FCw_Vci_ei*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vci_ei+FCw*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
#endif
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCw2_Vbi_ei_Vci_ei=(+FCw_Vbi_ei_Vci_ei*FCw+FCw_Vbi_ei*FCw_Vci_ei+FCw_Vci_ei*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vci_ei);
  FCw2_Vbi_ei_Vtnode_GND=(+FCw_Vbi_ei_Vtnode_GND*FCw+FCw_Vbi_ei*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vtnode_GND);
  FCw2_Vbi_ei_Vbi_ei=(+FCw_Vbi_ei_Vbi_ei*FCw+FCw_Vbi_ei*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vbi_ei);
  FCw2_Vbi_ei_Vbi_ci=(+FCw_Vbi_ei_Vbi_ci*FCw+FCw_Vbi_ei*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vbi_ci);
#endif
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCw2_Vbi_ci_Vci_ei=(+FCw_Vbi_ci_Vci_ei*FCw+FCw_Vbi_ci*FCw_Vci_ei+FCw_Vci_ei*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vci_ei);
  FCw2_Vbi_ci_Vtnode_GND=(+FCw_Vbi_ci_Vtnode_GND*FCw+FCw_Vbi_ci*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vtnode_GND);
  FCw2_Vbi_ci_Vbi_ei=(+FCw_Vbi_ci_Vbi_ei*FCw+FCw_Vbi_ci*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vbi_ei);
  FCw2_Vbi_ci_Vbi_ci=(+FCw_Vbi_ci_Vbi_ci*FCw+FCw_Vbi_ci*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCw2=(FCw*FCw);
#if defined(_DERIVATEFORDDX)
FCf1_Vci_ei=(((((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))/3.0)+(((latb+latl)*FCw2_Vci_ei)/2.0))+FCw_Vci_ei);
#if defined(_DERIVATE)
  FCf1_Vci_ei_Vci_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+(latb*latl)*FCw_Vci_ei_Vci_ei)*FCw2+((latb*latl)*FCw_Vci_ei)*FCw2_Vci_ei+(((latb*latl)*FCw_Vci_ei))*FCw2_Vci_ei+((latb*latl)*FCw)*FCw2_Vci_ei_Vci_ei)/3.0-(((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))*0.0+((((((latb*latl)*FCw_Vci_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vci_ei+(latb+latl)*FCw2_Vci_ei_Vci_ei)/2.0-(((latb+latl)*FCw2_Vci_ei)*0.0+(((latb+latl)*FCw2_Vci_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vci_ei_Vci_ei);
  FCf1_Vci_ei_Vtnode_GND=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+(latb*latl)*FCw_Vci_ei_Vtnode_GND)*FCw2+((latb*latl)*FCw_Vci_ei)*FCw2_Vtnode_GND+(((latb*latl)*FCw_Vtnode_GND))*FCw2_Vci_ei+((latb*latl)*FCw)*FCw2_Vci_ei_Vtnode_GND)/3.0-(((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))*0.0+((((((latb*latl)*FCw_Vtnode_GND))*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vci_ei+(latb+latl)*FCw2_Vci_ei_Vtnode_GND)/2.0-(((latb+latl)*FCw2_Vci_ei)*0.0+(((latb+latl)*FCw2_Vtnode_GND))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vci_ei_Vtnode_GND);
  FCf1_Vci_ei_Vbi_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+(latb*latl)*FCw_Vci_ei_Vbi_ei)*FCw2+((latb*latl)*FCw_Vci_ei)*FCw2_Vbi_ei+(((latb*latl)*FCw_Vbi_ei))*FCw2_Vci_ei+((latb*latl)*FCw)*FCw2_Vci_ei_Vbi_ei)/3.0-(((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))*0.0+((((((latb*latl)*FCw_Vbi_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vci_ei+(latb+latl)*FCw2_Vci_ei_Vbi_ei)/2.0-(((latb+latl)*FCw2_Vci_ei)*0.0+(((latb+latl)*FCw2_Vbi_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vci_ei_Vbi_ei);
  FCf1_Vci_ei_Vbi_ci=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+(latb*latl)*FCw_Vci_ei_Vbi_ci)*FCw2+((latb*latl)*FCw_Vci_ei)*FCw2_Vbi_ci+(((latb*latl)*FCw_Vbi_ci))*FCw2_Vci_ei+((latb*latl)*FCw)*FCw2_Vci_ei_Vbi_ci)/3.0-(((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))*0.0+((((((latb*latl)*FCw_Vbi_ci))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vci_ei+(latb+latl)*FCw2_Vci_ei_Vbi_ci)/2.0-(((latb+latl)*FCw2_Vci_ei)*0.0+(((latb+latl)*FCw2_Vbi_ci))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCf1_Vtnode_GND=(((((((latb*latl)*FCw_Vtnode_GND)*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND))/3.0)+(((latb+latl)*FCw2_Vtnode_GND)/2.0))+FCw_Vtnode_GND);
#endif
FCf1_Vbi_ei=(((((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))/3.0)+(((latb+latl)*FCw2_Vbi_ei)/2.0))+FCw_Vbi_ei);
#if defined(_DERIVATE)
  FCf1_Vbi_ei_Vci_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+(latb*latl)*FCw_Vbi_ei_Vci_ei)*FCw2+((latb*latl)*FCw_Vbi_ei)*FCw2_Vci_ei+(((latb*latl)*FCw_Vci_ei))*FCw2_Vbi_ei+((latb*latl)*FCw)*FCw2_Vbi_ei_Vci_ei)/3.0-(((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))*0.0+((((((latb*latl)*FCw_Vci_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vbi_ei+(latb+latl)*FCw2_Vbi_ei_Vci_ei)/2.0-(((latb+latl)*FCw2_Vbi_ei)*0.0+(((latb+latl)*FCw2_Vci_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ei_Vci_ei);
  FCf1_Vbi_ei_Vtnode_GND=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+(latb*latl)*FCw_Vbi_ei_Vtnode_GND)*FCw2+((latb*latl)*FCw_Vbi_ei)*FCw2_Vtnode_GND+(((latb*latl)*FCw_Vtnode_GND))*FCw2_Vbi_ei+((latb*latl)*FCw)*FCw2_Vbi_ei_Vtnode_GND)/3.0-(((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))*0.0+((((((latb*latl)*FCw_Vtnode_GND))*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vbi_ei+(latb+latl)*FCw2_Vbi_ei_Vtnode_GND)/2.0-(((latb+latl)*FCw2_Vbi_ei)*0.0+(((latb+latl)*FCw2_Vtnode_GND))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ei_Vtnode_GND);
  FCf1_Vbi_ei_Vbi_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+(latb*latl)*FCw_Vbi_ei_Vbi_ei)*FCw2+((latb*latl)*FCw_Vbi_ei)*FCw2_Vbi_ei+(((latb*latl)*FCw_Vbi_ei))*FCw2_Vbi_ei+((latb*latl)*FCw)*FCw2_Vbi_ei_Vbi_ei)/3.0-(((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))*0.0+((((((latb*latl)*FCw_Vbi_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vbi_ei+(latb+latl)*FCw2_Vbi_ei_Vbi_ei)/2.0-(((latb+latl)*FCw2_Vbi_ei)*0.0+(((latb+latl)*FCw2_Vbi_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ei_Vbi_ei);
  FCf1_Vbi_ei_Vbi_ci=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+(latb*latl)*FCw_Vbi_ei_Vbi_ci)*FCw2+((latb*latl)*FCw_Vbi_ei)*FCw2_Vbi_ci+(((latb*latl)*FCw_Vbi_ci))*FCw2_Vbi_ei+((latb*latl)*FCw)*FCw2_Vbi_ei_Vbi_ci)/3.0-(((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))*0.0+((((((latb*latl)*FCw_Vbi_ci))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vbi_ei+(latb+latl)*FCw2_Vbi_ei_Vbi_ci)/2.0-(((latb+latl)*FCw2_Vbi_ei)*0.0+(((latb+latl)*FCw2_Vbi_ci))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ei_Vbi_ci);
#endif
FCf1_Vbi_ci=(((((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))/3.0)+(((latb+latl)*FCw2_Vbi_ci)/2.0))+FCw_Vbi_ci);
#if defined(_DERIVATE)
  FCf1_Vbi_ci_Vci_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+(latb*latl)*FCw_Vbi_ci_Vci_ei)*FCw2+((latb*latl)*FCw_Vbi_ci)*FCw2_Vci_ei+(((latb*latl)*FCw_Vci_ei))*FCw2_Vbi_ci+((latb*latl)*FCw)*FCw2_Vbi_ci_Vci_ei)/3.0-(((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))*0.0+((((((latb*latl)*FCw_Vci_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vbi_ci+(latb+latl)*FCw2_Vbi_ci_Vci_ei)/2.0-(((latb+latl)*FCw2_Vbi_ci)*0.0+(((latb+latl)*FCw2_Vci_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ci_Vci_ei);
  FCf1_Vbi_ci_Vtnode_GND=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+(latb*latl)*FCw_Vbi_ci_Vtnode_GND)*FCw2+((latb*latl)*FCw_Vbi_ci)*FCw2_Vtnode_GND+(((latb*latl)*FCw_Vtnode_GND))*FCw2_Vbi_ci+((latb*latl)*FCw)*FCw2_Vbi_ci_Vtnode_GND)/3.0-(((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))*0.0+((((((latb*latl)*FCw_Vtnode_GND))*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vbi_ci+(latb+latl)*FCw2_Vbi_ci_Vtnode_GND)/2.0-(((latb+latl)*FCw2_Vbi_ci)*0.0+(((latb+latl)*FCw2_Vtnode_GND))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ci_Vtnode_GND);
  FCf1_Vbi_ci_Vbi_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+(latb*latl)*FCw_Vbi_ci_Vbi_ei)*FCw2+((latb*latl)*FCw_Vbi_ci)*FCw2_Vbi_ei+(((latb*latl)*FCw_Vbi_ei))*FCw2_Vbi_ci+((latb*latl)*FCw)*FCw2_Vbi_ci_Vbi_ei)/3.0-(((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))*0.0+((((((latb*latl)*FCw_Vbi_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vbi_ci+(latb+latl)*FCw2_Vbi_ci_Vbi_ei)/2.0-(((latb+latl)*FCw2_Vbi_ci)*0.0+(((latb+latl)*FCw2_Vbi_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ci_Vbi_ei);
  FCf1_Vbi_ci_Vbi_ci=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+(latb*latl)*FCw_Vbi_ci_Vbi_ci)*FCw2+((latb*latl)*FCw_Vbi_ci)*FCw2_Vbi_ci+(((latb*latl)*FCw_Vbi_ci))*FCw2_Vbi_ci+((latb*latl)*FCw)*FCw2_Vbi_ci_Vbi_ci)/3.0-(((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))*0.0+((((((latb*latl)*FCw_Vbi_ci))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vbi_ci+(latb+latl)*FCw2_Vbi_ci_Vbi_ci)/2.0-(((latb+latl)*FCw2_Vbi_ci)*0.0+(((latb+latl)*FCw2_Vbi_ci))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCf1=((((((latb*latl)*FCw)*FCw2)/3.0)+(((latb+latl)*FCw2)/2.0))+FCw);
#if defined(_DERIVATEFORDDX)
FCdf1_dw_Vci_ei=(((latb*latl)*FCw2_Vci_ei)+((latb+latl)*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCdf1_dw_Vci_ei_Vci_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vci_ei+(latb*latl)*FCw2_Vci_ei_Vci_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+(latb+latl)*FCw_Vci_ei_Vci_ei))+0.0);
  FCdf1_dw_Vci_ei_Vtnode_GND=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vci_ei+(latb*latl)*FCw2_Vci_ei_Vtnode_GND)+(+(+0.0+0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+(latb+latl)*FCw_Vci_ei_Vtnode_GND))+0.0);
  FCdf1_dw_Vci_ei_Vbi_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vci_ei+(latb*latl)*FCw2_Vci_ei_Vbi_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+(latb+latl)*FCw_Vci_ei_Vbi_ei))+0.0);
  FCdf1_dw_Vci_ei_Vbi_ci=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vci_ei+(latb*latl)*FCw2_Vci_ei_Vbi_ci)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+(latb+latl)*FCw_Vci_ei_Vbi_ci))+0.0);
#endif
#if defined(_DERIVATE)
FCdf1_dw_Vtnode_GND=(((latb*latl)*FCw2_Vtnode_GND)+((latb+latl)*FCw_Vtnode_GND));
#endif
FCdf1_dw_Vbi_ei=(((latb*latl)*FCw2_Vbi_ei)+((latb+latl)*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCdf1_dw_Vbi_ei_Vci_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vbi_ei+(latb*latl)*FCw2_Vbi_ei_Vci_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+(latb+latl)*FCw_Vbi_ei_Vci_ei))+0.0);
  FCdf1_dw_Vbi_ei_Vtnode_GND=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vbi_ei+(latb*latl)*FCw2_Vbi_ei_Vtnode_GND)+(+(+0.0+0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+(latb+latl)*FCw_Vbi_ei_Vtnode_GND))+0.0);
  FCdf1_dw_Vbi_ei_Vbi_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vbi_ei+(latb*latl)*FCw2_Vbi_ei_Vbi_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+(latb+latl)*FCw_Vbi_ei_Vbi_ei))+0.0);
  FCdf1_dw_Vbi_ei_Vbi_ci=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vbi_ei+(latb*latl)*FCw2_Vbi_ei_Vbi_ci)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+(latb+latl)*FCw_Vbi_ei_Vbi_ci))+0.0);
#endif
FCdf1_dw_Vbi_ci=(((latb*latl)*FCw2_Vbi_ci)+((latb+latl)*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCdf1_dw_Vbi_ci_Vci_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vbi_ci+(latb*latl)*FCw2_Vbi_ci_Vci_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+(latb+latl)*FCw_Vbi_ci_Vci_ei))+0.0);
  FCdf1_dw_Vbi_ci_Vtnode_GND=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vbi_ci+(latb*latl)*FCw2_Vbi_ci_Vtnode_GND)+(+(+0.0+0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+(latb+latl)*FCw_Vbi_ci_Vtnode_GND))+0.0);
  FCdf1_dw_Vbi_ci_Vbi_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vbi_ci+(latb*latl)*FCw2_Vbi_ci_Vbi_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+(latb+latl)*FCw_Vbi_ci_Vbi_ei))+0.0);
  FCdf1_dw_Vbi_ci_Vbi_ci=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vbi_ci+(latb*latl)*FCw2_Vbi_ci_Vbi_ci)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+(latb+latl)*FCw_Vbi_ci_Vbi_ci))+0.0);
#endif
#endif
FCdf1_dw=((((latb*latl)*FCw2)+((latb+latl)*FCw))+1.0);
#if defined(_DERIVATEFORDDX)
z_Vci_ei=(latb*FCw_Vci_ei);
#if defined(_DERIVATE)
  z_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei);
  z_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND);
  z_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei);
  z_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
z_Vtnode_GND=(latb*FCw_Vtnode_GND);
#endif
z_Vbi_ei=(latb*FCw_Vbi_ei);
#if defined(_DERIVATE)
  z_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei);
  z_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND);
  z_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei);
  z_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci);
#endif
z_Vbi_ci=(latb*FCw_Vbi_ci);
#if defined(_DERIVATE)
  z_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei);
  z_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND);
  z_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei);
  z_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
z=(latb*FCw);
{
double m00_logE(d00_logE0,(1+(latb*FCw)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1+(latb*FCw)))
#endif
#if defined(_DERIVATEFORDDX)
lnzb_Vci_ei=(latb*FCw_Vci_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vci_ei_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei)));
  lnzb_Vci_ei_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND)));
  lnzb_Vci_ei_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei)));
  lnzb_Vci_ei_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci)));
#endif
#if defined(_DERIVATE)
lnzb_Vtnode_GND=(latb*FCw_Vtnode_GND)*d10_logE0;
#endif
lnzb_Vbi_ei=(latb*FCw_Vbi_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vbi_ei_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei)));
  lnzb_Vbi_ei_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND)));
  lnzb_Vbi_ei_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei)));
  lnzb_Vbi_ei_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci)));
#endif
lnzb_Vbi_ci=(latb*FCw_Vbi_ci)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vbi_ci_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei)));
  lnzb_Vbi_ci_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND)));
  lnzb_Vbi_ci_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei)));
  lnzb_Vbi_ci_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci)));
#endif
#endif
lnzb=d00_logE0;
}
if
((z>1.0e-6))
{
#if defined(_DERIVATEFORDDX)
x_Vci_ei=z_Vci_ei;
#if defined(_DERIVATE)
  x_Vci_ei_Vci_ei=(+0.0+z_Vci_ei_Vci_ei);
  x_Vci_ei_Vtnode_GND=(+0.0+z_Vci_ei_Vtnode_GND);
  x_Vci_ei_Vbi_ei=(+0.0+z_Vci_ei_Vbi_ei);
  x_Vci_ei_Vbi_ci=(+0.0+z_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
x_Vtnode_GND=z_Vtnode_GND;
#endif
x_Vbi_ei=z_Vbi_ei;
#if defined(_DERIVATE)
  x_Vbi_ei_Vci_ei=(+0.0+z_Vbi_ei_Vci_ei);
  x_Vbi_ei_Vtnode_GND=(+0.0+z_Vbi_ei_Vtnode_GND);
  x_Vbi_ei_Vbi_ei=(+0.0+z_Vbi_ei_Vbi_ei);
  x_Vbi_ei_Vbi_ci=(+0.0+z_Vbi_ei_Vbi_ci);
#endif
x_Vbi_ci=z_Vbi_ci;
#if defined(_DERIVATE)
  x_Vbi_ci_Vci_ei=(+0.0+z_Vbi_ci_Vci_ei);
  x_Vbi_ci_Vtnode_GND=(+0.0+z_Vbi_ci_Vtnode_GND);
  x_Vbi_ci_Vbi_ei=(+0.0+z_Vbi_ci_Vbi_ei);
  x_Vbi_ci_Vbi_ci=(+0.0+z_Vbi_ci_Vbi_ci);
#endif
#endif
x=(1.0+z);
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+x_Vbi_ei_Vbi_ei*x+x_Vbi_ei*x_Vbi_ei+x_Vbi_ei*x_Vbi_ei+x*x_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+x_Vbi_ei_Vbi_ci*x+x_Vbi_ei*x_Vbi_ci+x_Vbi_ci*x_Vbi_ei+x*x_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+x_Vbi_ei_Vci_ei*x+x_Vbi_ei*x_Vci_ei+x_Vci_ei*x_Vbi_ei+x*x_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+x_Vbi_ei_Vtnode_GND*x+x_Vbi_ei*x_Vtnode_GND+x_Vtnode_GND*x_Vbi_ei+x*x_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+x_Vbi_ci_Vbi_ei*x+x_Vbi_ci*x_Vbi_ei+x_Vbi_ei*x_Vbi_ci+x*x_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+x_Vbi_ci_Vbi_ci*x+x_Vbi_ci*x_Vbi_ci+x_Vbi_ci*x_Vbi_ci+x*x_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+x_Vbi_ci_Vci_ei*x+x_Vbi_ci*x_Vci_ei+x_Vci_ei*x_Vbi_ci+x*x_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+x_Vbi_ci_Vtnode_GND*x+x_Vbi_ci*x_Vtnode_GND+x_Vtnode_GND*x_Vbi_ci+x*x_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+x_Vci_ei_Vbi_ei*x+x_Vci_ei*x_Vbi_ei+x_Vbi_ei*x_Vci_ei+x*x_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+x_Vci_ei_Vbi_ci*x+x_Vci_ei*x_Vbi_ci+x_Vbi_ci*x_Vci_ei+x*x_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+x_Vci_ei_Vci_ei*x+x_Vci_ei*x_Vci_ei+x_Vci_ei*x_Vci_ei+x*x_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+x_Vci_ei_Vtnode_GND*x+x_Vci_ei*x_Vtnode_GND+x_Vtnode_GND*x_Vci_ei+x*x_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
#endif
#endif
a=(x*x);
#if defined(_DERIVATEFORDDX)
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei))));
#if defined(_DERIVATE)
  a2_Vbi_ei_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vbi_ei*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vbi_ei)-0.0))+0.0));
  a2_Vbi_ei_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vbi_ci*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vbi_ci)-0.0))+0.0));
  a2_Vbi_ei_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vci_ei*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vci_ei)-0.0))+0.0));
  a2_Vbi_ei_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vtnode_GND)-0.0))+0.0));
#endif
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci))));
#if defined(_DERIVATE)
  a2_Vbi_ci_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vbi_ei*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vbi_ei)-0.0))+0.0));
  a2_Vbi_ci_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vbi_ci*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vbi_ci)-0.0))+0.0));
  a2_Vbi_ci_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vci_ei*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vci_ei)-0.0))+0.0));
  a2_Vbi_ci_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vtnode_GND)-0.0))+0.0));
#endif
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei))));
#if defined(_DERIVATE)
  a2_Vci_ei_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vbi_ei*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vbi_ei)-0.0))+0.0));
  a2_Vci_ei_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vbi_ci*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vbi_ci)-0.0))+0.0));
  a2_Vci_ei_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vci_ei*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vci_ei)-0.0))+0.0));
  a2_Vci_ei_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vtnode_GND)-0.0))+0.0));
#endif
#if defined(_DERIVATE)
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vtnode_GND))));
#endif
#endif
a2=(0.250*((a*((2.0*lnzb)-1.0))+1.0));
#if defined(_DERIVATEFORDDX)
a3_Vbi_ei=(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))/9.0);
#if defined(_DERIVATE)
  a3_Vbi_ei_Vbi_ei=((+(+(+a_Vbi_ei_Vbi_ei*x+a_Vbi_ei*x_Vbi_ei+a_Vbi_ei*x_Vbi_ei+a*x_Vbi_ei_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vbi_ci=((+(+(+a_Vbi_ei_Vbi_ci*x+a_Vbi_ei*x_Vbi_ci+a_Vbi_ci*x_Vbi_ei+a*x_Vbi_ei_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vci_ei=((+(+(+a_Vbi_ei_Vci_ei*x+a_Vbi_ei*x_Vci_ei+a_Vci_ei*x_Vbi_ei+a*x_Vbi_ei_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vtnode_GND=((+(+(+a_Vbi_ei_Vtnode_GND*x+a_Vbi_ei*x_Vtnode_GND+a_Vtnode_GND*x_Vbi_ei+a*x_Vbi_ei_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
a3_Vbi_ci=(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))/9.0);
#if defined(_DERIVATE)
  a3_Vbi_ci_Vbi_ei=((+(+(+a_Vbi_ci_Vbi_ei*x+a_Vbi_ci*x_Vbi_ei+a_Vbi_ei*x_Vbi_ci+a*x_Vbi_ci_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vbi_ci=((+(+(+a_Vbi_ci_Vbi_ci*x+a_Vbi_ci*x_Vbi_ci+a_Vbi_ci*x_Vbi_ci+a*x_Vbi_ci_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vci_ei=((+(+(+a_Vbi_ci_Vci_ei*x+a_Vbi_ci*x_Vci_ei+a_Vci_ei*x_Vbi_ci+a*x_Vbi_ci_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vtnode_GND=((+(+(+a_Vbi_ci_Vtnode_GND*x+a_Vbi_ci*x_Vtnode_GND+a_Vtnode_GND*x_Vbi_ci+a*x_Vbi_ci_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
a3_Vci_ei=(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))/9.0);
#if defined(_DERIVATE)
  a3_Vci_ei_Vbi_ei=((+(+(+a_Vci_ei_Vbi_ei*x+a_Vci_ei*x_Vbi_ei+a_Vbi_ei*x_Vci_ei+a*x_Vci_ei_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vbi_ci=((+(+(+a_Vci_ei_Vbi_ci*x+a_Vci_ei*x_Vbi_ci+a_Vbi_ci*x_Vci_ei+a*x_Vci_ei_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vci_ei=((+(+(+a_Vci_ei_Vci_ei*x+a_Vci_ei*x_Vci_ei+a_Vci_ei*x_Vci_ei+a*x_Vci_ei_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vtnode_GND=((+(+(+a_Vci_ei_Vtnode_GND*x+a_Vci_ei*x_Vtnode_GND+a_Vtnode_GND*x_Vci_ei+a*x_Vci_ei_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
#if defined(_DERIVATE)
a3_Vtnode_GND=(((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vtnode_GND)))/9.0);
#endif
#endif
a3=((((a*x)*((3.0*lnzb)-1.0))+1.0)/9.0);
r=(latl/latb);
#if defined(_DERIVATEFORDDX)
FCf2_Vbi_ei=((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latb);
#if defined(_DERIVATE)
  FCf2_Vbi_ei_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vbi_ei))/latb-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vbi_ci))/latb-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vci_ei))/latb-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vtnode_GND))/latb-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
#endif
FCf2_Vbi_ci=((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latb);
#if defined(_DERIVATE)
  FCf2_Vbi_ci_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vbi_ei))/latb-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vbi_ci))/latb-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vci_ei))/latb-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vtnode_GND))/latb-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
#endif
FCf2_Vci_ei=((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latb);
#if defined(_DERIVATE)
  FCf2_Vci_ei_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vci_ei+r*a3_Vci_ei_Vbi_ei))/latb-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vci_ei+r*a3_Vci_ei_Vbi_ci))/latb-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vci_ei+r*a3_Vci_ei_Vci_ei))/latb-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vci_ei+r*a3_Vci_ei_Vtnode_GND))/latb-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
#endif
#if defined(_DERIVATE)
FCf2_Vtnode_GND=((((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latb);
#endif
#endif
FCf2=((((1.0-r)*a2)+(r*a3))/latb);
#if defined(_DERIVATEFORDDX)
FCdf2_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vci_ei));
#if defined(_DERIVATE)
  FCdf2_dw_Vci_ei_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+r*a_Vci_ei_Vci_ei))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vci_ei);
  FCdf2_dw_Vci_ei_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+r*a_Vci_ei_Vtnode_GND))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vtnode_GND);
  FCdf2_dw_Vci_ei_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+r*a_Vci_ei_Vbi_ei))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vbi_ei);
  FCdf2_dw_Vci_ei_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+r*a_Vci_ei_Vbi_ci))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdf2_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vtnode_GND));
#endif
FCdf2_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vbi_ei));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ei_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+r*a_Vbi_ei_Vci_ei))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vci_ei);
  FCdf2_dw_Vbi_ei_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+r*a_Vbi_ei_Vtnode_GND))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vtnode_GND);
  FCdf2_dw_Vbi_ei_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+r*a_Vbi_ei_Vbi_ei))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vbi_ei);
  FCdf2_dw_Vbi_ei_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+r*a_Vbi_ei_Vbi_ci))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vbi_ci);
#endif
FCdf2_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vbi_ci));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ci_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+r*a_Vbi_ci_Vci_ei))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vci_ei);
  FCdf2_dw_Vbi_ci_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+r*a_Vbi_ci_Vtnode_GND))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vtnode_GND);
  FCdf2_dw_Vbi_ci_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+r*a_Vbi_ci_Vbi_ei))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vbi_ei);
  FCdf2_dw_Vbi_ci_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+r*a_Vbi_ci_Vbi_ci))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vbi_ci);
#endif
#endif
FCdf2_dw=((((1.0-r)*x)+(r*a))*lnzb);
}
else
{
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+z_Vbi_ei_Vbi_ei*z+z_Vbi_ei*z_Vbi_ei+z_Vbi_ei*z_Vbi_ei+z*z_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+z_Vbi_ei_Vbi_ci*z+z_Vbi_ei*z_Vbi_ci+z_Vbi_ci*z_Vbi_ei+z*z_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+z_Vbi_ei_Vci_ei*z+z_Vbi_ei*z_Vci_ei+z_Vci_ei*z_Vbi_ei+z*z_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+z_Vbi_ei_Vtnode_GND*z+z_Vbi_ei*z_Vtnode_GND+z_Vtnode_GND*z_Vbi_ei+z*z_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+z_Vbi_ci_Vbi_ei*z+z_Vbi_ci*z_Vbi_ei+z_Vbi_ei*z_Vbi_ci+z*z_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+z_Vbi_ci_Vbi_ci*z+z_Vbi_ci*z_Vbi_ci+z_Vbi_ci*z_Vbi_ci+z*z_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+z_Vbi_ci_Vci_ei*z+z_Vbi_ci*z_Vci_ei+z_Vci_ei*z_Vbi_ci+z*z_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+z_Vbi_ci_Vtnode_GND*z+z_Vbi_ci*z_Vtnode_GND+z_Vtnode_GND*z_Vbi_ci+z*z_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+z_Vci_ei_Vbi_ei*z+z_Vci_ei*z_Vbi_ei+z_Vbi_ei*z_Vci_ei+z*z_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+z_Vci_ei_Vbi_ci*z+z_Vci_ei*z_Vbi_ci+z_Vbi_ci*z_Vci_ei+z*z_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+z_Vci_ei_Vci_ei*z+z_Vci_ei*z_Vci_ei+z_Vci_ei*z_Vci_ei+z*z_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+z_Vci_ei_Vtnode_GND*z+z_Vci_ei*z_Vtnode_GND+z_Vtnode_GND*z_Vci_ei+z*z_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
#endif
#endif
a=(z*z);
#if defined(_DERIVATEFORDDX)
a2_Vbi_ei=((z_Vbi_ei-(0.25*a_Vbi_ei))+(((0.10*z_Vbi_ei)*a)+((0.10*z)*a_Vbi_ei)));
#if defined(_DERIVATE)
  a2_Vbi_ei_Vbi_ei=(+(+(+0.0+z_Vbi_ei_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vbi_ei)*a+(0.10*z_Vbi_ei)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vbi_ei));
  a2_Vbi_ei_Vbi_ci=(+(+(+0.0+z_Vbi_ei_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vbi_ci)*a+(0.10*z_Vbi_ei)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vbi_ci));
  a2_Vbi_ei_Vci_ei=(+(+(+0.0+z_Vbi_ei_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vci_ei)*a+(0.10*z_Vbi_ei)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vci_ei));
  a2_Vbi_ei_Vtnode_GND=(+(+(+0.0+z_Vbi_ei_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vtnode_GND)*a+(0.10*z_Vbi_ei)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vtnode_GND));
#endif
a2_Vbi_ci=((z_Vbi_ci-(0.25*a_Vbi_ci))+(((0.10*z_Vbi_ci)*a)+((0.10*z)*a_Vbi_ci)));
#if defined(_DERIVATE)
  a2_Vbi_ci_Vbi_ei=(+(+(+0.0+z_Vbi_ci_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vbi_ei)*a+(0.10*z_Vbi_ci)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vbi_ei));
  a2_Vbi_ci_Vbi_ci=(+(+(+0.0+z_Vbi_ci_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vbi_ci)*a+(0.10*z_Vbi_ci)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vbi_ci));
  a2_Vbi_ci_Vci_ei=(+(+(+0.0+z_Vbi_ci_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vci_ei)*a+(0.10*z_Vbi_ci)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vci_ei));
  a2_Vbi_ci_Vtnode_GND=(+(+(+0.0+z_Vbi_ci_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vtnode_GND)*a+(0.10*z_Vbi_ci)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vtnode_GND));
#endif
a2_Vci_ei=((z_Vci_ei-(0.25*a_Vci_ei))+(((0.10*z_Vci_ei)*a)+((0.10*z)*a_Vci_ei)));
#if defined(_DERIVATE)
  a2_Vci_ei_Vbi_ei=(+(+(+0.0+z_Vci_ei_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.25*a_Vci_ei_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vci_ei+0.10*z_Vci_ei_Vbi_ei)*a+(0.10*z_Vci_ei)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vbi_ei));
  a2_Vci_ei_Vbi_ci=(+(+(+0.0+z_Vci_ei_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.25*a_Vci_ei_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vci_ei+0.10*z_Vci_ei_Vbi_ci)*a+(0.10*z_Vci_ei)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vbi_ci));
  a2_Vci_ei_Vci_ei=(+(+(+0.0+z_Vci_ei_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.25*a_Vci_ei_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vci_ei+0.10*z_Vci_ei_Vci_ei)*a+(0.10*z_Vci_ei)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vci_ei));
  a2_Vci_ei_Vtnode_GND=(+(+(+0.0+z_Vci_ei_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.25*a_Vci_ei_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vci_ei+0.10*z_Vci_ei_Vtnode_GND)*a+(0.10*z_Vci_ei)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
a2_Vtnode_GND=((z_Vtnode_GND-(0.25*a_Vtnode_GND))+(((0.10*z_Vtnode_GND)*a)+((0.10*z)*a_Vtnode_GND)));
#endif
#endif
a2=(((3.0+z)-(0.25*a))+((0.10*z)*a));
#if defined(_DERIVATEFORDDX)
a3_Vbi_ei=(((2.0*z_Vbi_ei)+(0.75*a_Vbi_ei))-(((0.20*a_Vbi_ei)*z)+((0.20*a)*z_Vbi_ei)));
#if defined(_DERIVATE)
  a3_Vbi_ei_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vbi_ei)*z+(0.20*a_Vbi_ei)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vbi_ei));
  a3_Vbi_ei_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vbi_ci)*z+(0.20*a_Vbi_ei)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vbi_ci));
  a3_Vbi_ei_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vci_ei)*z+(0.20*a_Vbi_ei)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vci_ei));
  a3_Vbi_ei_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vtnode_GND)*z+(0.20*a_Vbi_ei)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vtnode_GND));
#endif
a3_Vbi_ci=(((2.0*z_Vbi_ci)+(0.75*a_Vbi_ci))-(((0.20*a_Vbi_ci)*z)+((0.20*a)*z_Vbi_ci)));
#if defined(_DERIVATE)
  a3_Vbi_ci_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vbi_ei)*z+(0.20*a_Vbi_ci)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vbi_ei));
  a3_Vbi_ci_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vbi_ci)*z+(0.20*a_Vbi_ci)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vbi_ci));
  a3_Vbi_ci_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vci_ei)*z+(0.20*a_Vbi_ci)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vci_ei));
  a3_Vbi_ci_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vtnode_GND)*z+(0.20*a_Vbi_ci)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vtnode_GND));
#endif
a3_Vci_ei=(((2.0*z_Vci_ei)+(0.75*a_Vci_ei))-(((0.20*a_Vci_ei)*z)+((0.20*a)*z_Vci_ei)));
#if defined(_DERIVATE)
  a3_Vci_ei_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vci_ei+2.0*z_Vci_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.75*a_Vci_ei_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.20*a_Vci_ei_Vbi_ei)*z+(0.20*a_Vci_ei)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vbi_ei));
  a3_Vci_ei_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vci_ei+2.0*z_Vci_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.75*a_Vci_ei_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.20*a_Vci_ei_Vbi_ci)*z+(0.20*a_Vci_ei)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vbi_ci));
  a3_Vci_ei_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vci_ei+2.0*z_Vci_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.75*a_Vci_ei_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.20*a_Vci_ei_Vci_ei)*z+(0.20*a_Vci_ei)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vci_ei));
  a3_Vci_ei_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vci_ei+2.0*z_Vci_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.75*a_Vci_ei_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.20*a_Vci_ei_Vtnode_GND)*z+(0.20*a_Vci_ei)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
a3_Vtnode_GND=(((2.0*z_Vtnode_GND)+(0.75*a_Vtnode_GND))-(((0.20*a_Vtnode_GND)*z)+((0.20*a)*z_Vtnode_GND)));
#endif
#endif
a3=(((2.0*z)+(0.75*a))-((0.20*a)*z));
#if defined(_DERIVATEFORDDX)
FCf2_Vbi_ei=(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))/6.0);
#if defined(_DERIVATE)
  FCf2_Vbi_ei_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ei+latb*a2_Vbi_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ei+latl*a3_Vbi_ei_Vbi_ei))*FCw+((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw_Vbi_ei+(((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw_Vbi_ei+((latb*a2)+(latl*a3))*FCw_Vbi_ei_Vbi_ei)*FCw+((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw_Vbi_ei+((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw_Vbi_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei_Vbi_ei)/6.0-(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ei_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ei+latb*a2_Vbi_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ei+latl*a3_Vbi_ei_Vbi_ci))*FCw+((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw_Vbi_ci+(((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw_Vbi_ei+((latb*a2)+(latl*a3))*FCw_Vbi_ei_Vbi_ci)*FCw+((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw_Vbi_ci+((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw_Vbi_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei_Vbi_ci)/6.0-(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ei_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ei+latb*a2_Vbi_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ei+latl*a3_Vbi_ei_Vci_ei))*FCw+((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw_Vci_ei+(((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw_Vbi_ei+((latb*a2)+(latl*a3))*FCw_Vbi_ei_Vci_ei)*FCw+((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw_Vci_ei+((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw_Vbi_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei_Vci_ei)/6.0-(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ei_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ei+latb*a2_Vbi_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ei+latl*a3_Vbi_ei_Vtnode_GND))*FCw+((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw_Vtnode_GND+(((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw_Vbi_ei+((latb*a2)+(latl*a3))*FCw_Vbi_ei_Vtnode_GND)*FCw+((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw_Vtnode_GND+((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw_Vbi_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei_Vtnode_GND)/6.0-(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
FCf2_Vbi_ci=(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))/6.0);
#if defined(_DERIVATE)
  FCf2_Vbi_ci_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ci+latb*a2_Vbi_ci_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ci+latl*a3_Vbi_ci_Vbi_ei))*FCw+((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw_Vbi_ei+(((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw_Vbi_ci+((latb*a2)+(latl*a3))*FCw_Vbi_ci_Vbi_ei)*FCw+((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw_Vbi_ei+((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw_Vbi_ci+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci_Vbi_ei)/6.0-(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ci_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ci+latb*a2_Vbi_ci_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ci+latl*a3_Vbi_ci_Vbi_ci))*FCw+((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw_Vbi_ci+(((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw_Vbi_ci+((latb*a2)+(latl*a3))*FCw_Vbi_ci_Vbi_ci)*FCw+((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw_Vbi_ci+((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw_Vbi_ci+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci_Vbi_ci)/6.0-(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ci_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ci+latb*a2_Vbi_ci_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ci+latl*a3_Vbi_ci_Vci_ei))*FCw+((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw_Vci_ei+(((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw_Vbi_ci+((latb*a2)+(latl*a3))*FCw_Vbi_ci_Vci_ei)*FCw+((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw_Vci_ei+((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw_Vbi_ci+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci_Vci_ei)/6.0-(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ci_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ci+latb*a2_Vbi_ci_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ci+latl*a3_Vbi_ci_Vtnode_GND))*FCw+((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw_Vtnode_GND+(((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw_Vbi_ci+((latb*a2)+(latl*a3))*FCw_Vbi_ci_Vtnode_GND)*FCw+((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw_Vtnode_GND+((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw_Vbi_ci+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci_Vtnode_GND)/6.0-(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
FCf2_Vci_ei=(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))/6.0);
#if defined(_DERIVATE)
  FCf2_Vci_ei_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vci_ei+latb*a2_Vci_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vci_ei+latl*a3_Vci_ei_Vbi_ei))*FCw+((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw_Vbi_ei+(((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw_Vci_ei+((latb*a2)+(latl*a3))*FCw_Vci_ei_Vbi_ei)*FCw+((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw_Vbi_ei+((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw_Vci_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei_Vbi_ei)/6.0-(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vci_ei_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vci_ei+latb*a2_Vci_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vci_ei+latl*a3_Vci_ei_Vbi_ci))*FCw+((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw_Vbi_ci+(((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw_Vci_ei+((latb*a2)+(latl*a3))*FCw_Vci_ei_Vbi_ci)*FCw+((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw_Vbi_ci+((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw_Vci_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei_Vbi_ci)/6.0-(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vci_ei_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vci_ei+latb*a2_Vci_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vci_ei+latl*a3_Vci_ei_Vci_ei))*FCw+((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw_Vci_ei+(((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw_Vci_ei+((latb*a2)+(latl*a3))*FCw_Vci_ei_Vci_ei)*FCw+((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw_Vci_ei+((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw_Vci_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei_Vci_ei)/6.0-(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vci_ei_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vci_ei+latb*a2_Vci_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vci_ei+latl*a3_Vci_ei_Vtnode_GND))*FCw+((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw_Vtnode_GND+(((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw_Vci_ei+((latb*a2)+(latl*a3))*FCw_Vci_ei_Vtnode_GND)*FCw+((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw_Vtnode_GND+((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw_Vci_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei_Vtnode_GND)/6.0-(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
#if defined(_DERIVATE)
FCf2_Vtnode_GND=(((((((latb*a2_Vtnode_GND)+(latl*a3_Vtnode_GND))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND))/6.0);
#endif
#endif
FCf2=(((((latb*a2)+(latl*a3))*FCw)*FCw)/6.0);
#if defined(_DERIVATEFORDDX)
FCdf2_dw_Vci_ei=(((((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb)+(((1+(latl*FCw))*(1+z))*lnzb_Vci_ei));
#if defined(_DERIVATE)
  FCdf2_dw_Vci_ei_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei))*(1+z)+(latl*FCw_Vci_ei)*z_Vci_ei+((latl*FCw_Vci_ei))*z_Vci_ei+(1+(latl*FCw))*(+0.0+z_Vci_ei_Vci_ei))*lnzb+(((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb_Vci_ei+(((((latl*FCw_Vci_ei))*(1+z))+((1+(latl*FCw))*z_Vci_ei)))*lnzb_Vci_ei+((1+(latl*FCw))*(1+z))*lnzb_Vci_ei_Vci_ei);
  FCdf2_dw_Vci_ei_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND))*(1+z)+(latl*FCw_Vci_ei)*z_Vtnode_GND+((latl*FCw_Vtnode_GND))*z_Vci_ei+(1+(latl*FCw))*(+0.0+z_Vci_ei_Vtnode_GND))*lnzb+(((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb_Vtnode_GND+(((((latl*FCw_Vtnode_GND))*(1+z))+((1+(latl*FCw))*z_Vtnode_GND)))*lnzb_Vci_ei+((1+(latl*FCw))*(1+z))*lnzb_Vci_ei_Vtnode_GND);
  FCdf2_dw_Vci_ei_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei))*(1+z)+(latl*FCw_Vci_ei)*z_Vbi_ei+((latl*FCw_Vbi_ei))*z_Vci_ei+(1+(latl*FCw))*(+0.0+z_Vci_ei_Vbi_ei))*lnzb+(((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb_Vbi_ei+(((((latl*FCw_Vbi_ei))*(1+z))+((1+(latl*FCw))*z_Vbi_ei)))*lnzb_Vci_ei+((1+(latl*FCw))*(1+z))*lnzb_Vci_ei_Vbi_ei);
  FCdf2_dw_Vci_ei_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci))*(1+z)+(latl*FCw_Vci_ei)*z_Vbi_ci+((latl*FCw_Vbi_ci))*z_Vci_ei+(1+(latl*FCw))*(+0.0+z_Vci_ei_Vbi_ci))*lnzb+(((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb_Vbi_ci+(((((latl*FCw_Vbi_ci))*(1+z))+((1+(latl*FCw))*z_Vbi_ci)))*lnzb_Vci_ei+((1+(latl*FCw))*(1+z))*lnzb_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdf2_dw_Vtnode_GND=(((((latl*FCw_Vtnode_GND)*(1+z))+((1+(latl*FCw))*z_Vtnode_GND))*lnzb)+(((1+(latl*FCw))*(1+z))*lnzb_Vtnode_GND));
#endif
FCdf2_dw_Vbi_ei=(((((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb)+(((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ei_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei))*(1+z)+(latl*FCw_Vbi_ei)*z_Vci_ei+((latl*FCw_Vci_ei))*z_Vbi_ei+(1+(latl*FCw))*(+0.0+z_Vbi_ei_Vci_ei))*lnzb+(((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb_Vci_ei+(((((latl*FCw_Vci_ei))*(1+z))+((1+(latl*FCw))*z_Vci_ei)))*lnzb_Vbi_ei+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei_Vci_ei);
  FCdf2_dw_Vbi_ei_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND))*(1+z)+(latl*FCw_Vbi_ei)*z_Vtnode_GND+((latl*FCw_Vtnode_GND))*z_Vbi_ei+(1+(latl*FCw))*(+0.0+z_Vbi_ei_Vtnode_GND))*lnzb+(((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb_Vtnode_GND+(((((latl*FCw_Vtnode_GND))*(1+z))+((1+(latl*FCw))*z_Vtnode_GND)))*lnzb_Vbi_ei+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei_Vtnode_GND);
  FCdf2_dw_Vbi_ei_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei))*(1+z)+(latl*FCw_Vbi_ei)*z_Vbi_ei+((latl*FCw_Vbi_ei))*z_Vbi_ei+(1+(latl*FCw))*(+0.0+z_Vbi_ei_Vbi_ei))*lnzb+(((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb_Vbi_ei+(((((latl*FCw_Vbi_ei))*(1+z))+((1+(latl*FCw))*z_Vbi_ei)))*lnzb_Vbi_ei+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei_Vbi_ei);
  FCdf2_dw_Vbi_ei_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci))*(1+z)+(latl*FCw_Vbi_ei)*z_Vbi_ci+((latl*FCw_Vbi_ci))*z_Vbi_ei+(1+(latl*FCw))*(+0.0+z_Vbi_ei_Vbi_ci))*lnzb+(((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb_Vbi_ci+(((((latl*FCw_Vbi_ci))*(1+z))+((1+(latl*FCw))*z_Vbi_ci)))*lnzb_Vbi_ei+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei_Vbi_ci);
#endif
FCdf2_dw_Vbi_ci=(((((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb)+(((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ci_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei))*(1+z)+(latl*FCw_Vbi_ci)*z_Vci_ei+((latl*FCw_Vci_ei))*z_Vbi_ci+(1+(latl*FCw))*(+0.0+z_Vbi_ci_Vci_ei))*lnzb+(((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb_Vci_ei+(((((latl*FCw_Vci_ei))*(1+z))+((1+(latl*FCw))*z_Vci_ei)))*lnzb_Vbi_ci+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci_Vci_ei);
  FCdf2_dw_Vbi_ci_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND))*(1+z)+(latl*FCw_Vbi_ci)*z_Vtnode_GND+((latl*FCw_Vtnode_GND))*z_Vbi_ci+(1+(latl*FCw))*(+0.0+z_Vbi_ci_Vtnode_GND))*lnzb+(((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb_Vtnode_GND+(((((latl*FCw_Vtnode_GND))*(1+z))+((1+(latl*FCw))*z_Vtnode_GND)))*lnzb_Vbi_ci+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci_Vtnode_GND);
  FCdf2_dw_Vbi_ci_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei))*(1+z)+(latl*FCw_Vbi_ci)*z_Vbi_ei+((latl*FCw_Vbi_ei))*z_Vbi_ci+(1+(latl*FCw))*(+0.0+z_Vbi_ci_Vbi_ei))*lnzb+(((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb_Vbi_ei+(((((latl*FCw_Vbi_ei))*(1+z))+((1+(latl*FCw))*z_Vbi_ei)))*lnzb_Vbi_ci+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci_Vbi_ei);
  FCdf2_dw_Vbi_ci_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci))*(1+z)+(latl*FCw_Vbi_ci)*z_Vbi_ci+((latl*FCw_Vbi_ci))*z_Vbi_ci+(1+(latl*FCw))*(+0.0+z_Vbi_ci_Vbi_ci))*lnzb+(((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb_Vbi_ci+(((((latl*FCw_Vbi_ci))*(1+z))+((1+(latl*FCw))*z_Vbi_ci)))*lnzb_Vbi_ci+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci_Vbi_ci);
#endif
#endif
FCdf2_dw=(((1+(latl*FCw))*(1+z))*lnzb);
}
#if defined(_DERIVATEFORDDX)
z_Vci_ei=(latl*FCw_Vci_ei);
#if defined(_DERIVATE)
  z_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei);
  z_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND);
  z_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei);
  z_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
z_Vtnode_GND=(latl*FCw_Vtnode_GND);
#endif
z_Vbi_ei=(latl*FCw_Vbi_ei);
#if defined(_DERIVATE)
  z_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei);
  z_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND);
  z_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei);
  z_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci);
#endif
z_Vbi_ci=(latl*FCw_Vbi_ci);
#if defined(_DERIVATE)
  z_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei);
  z_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND);
  z_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei);
  z_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
z=(latl*FCw);
{
double m00_logE(d00_logE0,(1+(latl*FCw)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1+(latl*FCw)))
#endif
#if defined(_DERIVATEFORDDX)
lnzb_Vci_ei=(latl*FCw_Vci_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vci_ei_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei)));
  lnzb_Vci_ei_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND)));
  lnzb_Vci_ei_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei)));
  lnzb_Vci_ei_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci)));
#endif
#if defined(_DERIVATE)
lnzb_Vtnode_GND=(latl*FCw_Vtnode_GND)*d10_logE0;
#endif
lnzb_Vbi_ei=(latl*FCw_Vbi_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vbi_ei_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei)));
  lnzb_Vbi_ei_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND)));
  lnzb_Vbi_ei_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei)));
  lnzb_Vbi_ei_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci)));
#endif
lnzb_Vbi_ci=(latl*FCw_Vbi_ci)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vbi_ci_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei)));
  lnzb_Vbi_ci_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND)));
  lnzb_Vbi_ci_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei)));
  lnzb_Vbi_ci_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci)));
#endif
#endif
lnzb=d00_logE0;
}
if
((z>1.0e-6))
{
#if defined(_DERIVATEFORDDX)
x_Vci_ei=z_Vci_ei;
#if defined(_DERIVATE)
  x_Vci_ei_Vci_ei=(+0.0+z_Vci_ei_Vci_ei);
  x_Vci_ei_Vtnode_GND=(+0.0+z_Vci_ei_Vtnode_GND);
  x_Vci_ei_Vbi_ei=(+0.0+z_Vci_ei_Vbi_ei);
  x_Vci_ei_Vbi_ci=(+0.0+z_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
x_Vtnode_GND=z_Vtnode_GND;
#endif
x_Vbi_ei=z_Vbi_ei;
#if defined(_DERIVATE)
  x_Vbi_ei_Vci_ei=(+0.0+z_Vbi_ei_Vci_ei);
  x_Vbi_ei_Vtnode_GND=(+0.0+z_Vbi_ei_Vtnode_GND);
  x_Vbi_ei_Vbi_ei=(+0.0+z_Vbi_ei_Vbi_ei);
  x_Vbi_ei_Vbi_ci=(+0.0+z_Vbi_ei_Vbi_ci);
#endif
x_Vbi_ci=z_Vbi_ci;
#if defined(_DERIVATE)
  x_Vbi_ci_Vci_ei=(+0.0+z_Vbi_ci_Vci_ei);
  x_Vbi_ci_Vtnode_GND=(+0.0+z_Vbi_ci_Vtnode_GND);
  x_Vbi_ci_Vbi_ei=(+0.0+z_Vbi_ci_Vbi_ei);
  x_Vbi_ci_Vbi_ci=(+0.0+z_Vbi_ci_Vbi_ci);
#endif
#endif
x=(1.0+z);
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+x_Vbi_ei_Vbi_ei*x+x_Vbi_ei*x_Vbi_ei+x_Vbi_ei*x_Vbi_ei+x*x_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+x_Vbi_ei_Vbi_ci*x+x_Vbi_ei*x_Vbi_ci+x_Vbi_ci*x_Vbi_ei+x*x_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+x_Vbi_ei_Vci_ei*x+x_Vbi_ei*x_Vci_ei+x_Vci_ei*x_Vbi_ei+x*x_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+x_Vbi_ei_Vtnode_GND*x+x_Vbi_ei*x_Vtnode_GND+x_Vtnode_GND*x_Vbi_ei+x*x_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+x_Vbi_ci_Vbi_ei*x+x_Vbi_ci*x_Vbi_ei+x_Vbi_ei*x_Vbi_ci+x*x_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+x_Vbi_ci_Vbi_ci*x+x_Vbi_ci*x_Vbi_ci+x_Vbi_ci*x_Vbi_ci+x*x_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+x_Vbi_ci_Vci_ei*x+x_Vbi_ci*x_Vci_ei+x_Vci_ei*x_Vbi_ci+x*x_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+x_Vbi_ci_Vtnode_GND*x+x_Vbi_ci*x_Vtnode_GND+x_Vtnode_GND*x_Vbi_ci+x*x_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+x_Vci_ei_Vbi_ei*x+x_Vci_ei*x_Vbi_ei+x_Vbi_ei*x_Vci_ei+x*x_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+x_Vci_ei_Vbi_ci*x+x_Vci_ei*x_Vbi_ci+x_Vbi_ci*x_Vci_ei+x*x_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+x_Vci_ei_Vci_ei*x+x_Vci_ei*x_Vci_ei+x_Vci_ei*x_Vci_ei+x*x_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+x_Vci_ei_Vtnode_GND*x+x_Vci_ei*x_Vtnode_GND+x_Vtnode_GND*x_Vci_ei+x*x_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
#endif
#endif
a=(x*x);
#if defined(_DERIVATEFORDDX)
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei))));
#if defined(_DERIVATE)
  a2_Vbi_ei_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vbi_ei*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vbi_ei)-0.0))+0.0));
  a2_Vbi_ei_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vbi_ci*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vbi_ci)-0.0))+0.0));
  a2_Vbi_ei_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vci_ei*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vci_ei)-0.0))+0.0));
  a2_Vbi_ei_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vtnode_GND)-0.0))+0.0));
#endif
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci))));
#if defined(_DERIVATE)
  a2_Vbi_ci_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vbi_ei*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vbi_ei)-0.0))+0.0));
  a2_Vbi_ci_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vbi_ci*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vbi_ci)-0.0))+0.0));
  a2_Vbi_ci_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vci_ei*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vci_ei)-0.0))+0.0));
  a2_Vbi_ci_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vtnode_GND)-0.0))+0.0));
#endif
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei))));
#if defined(_DERIVATE)
  a2_Vci_ei_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vbi_ei*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vbi_ei)-0.0))+0.0));
  a2_Vci_ei_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vbi_ci*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vbi_ci)-0.0))+0.0));
  a2_Vci_ei_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vci_ei*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vci_ei)-0.0))+0.0));
  a2_Vci_ei_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vtnode_GND)-0.0))+0.0));
#endif
#if defined(_DERIVATE)
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vtnode_GND))));
#endif
#endif
a2=(0.250*((a*((2.0*lnzb)-1.0))+1.0));
#if defined(_DERIVATEFORDDX)
a3_Vbi_ei=(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))/9.0);
#if defined(_DERIVATE)
  a3_Vbi_ei_Vbi_ei=((+(+(+a_Vbi_ei_Vbi_ei*x+a_Vbi_ei*x_Vbi_ei+a_Vbi_ei*x_Vbi_ei+a*x_Vbi_ei_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vbi_ci=((+(+(+a_Vbi_ei_Vbi_ci*x+a_Vbi_ei*x_Vbi_ci+a_Vbi_ci*x_Vbi_ei+a*x_Vbi_ei_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vci_ei=((+(+(+a_Vbi_ei_Vci_ei*x+a_Vbi_ei*x_Vci_ei+a_Vci_ei*x_Vbi_ei+a*x_Vbi_ei_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vtnode_GND=((+(+(+a_Vbi_ei_Vtnode_GND*x+a_Vbi_ei*x_Vtnode_GND+a_Vtnode_GND*x_Vbi_ei+a*x_Vbi_ei_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
a3_Vbi_ci=(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))/9.0);
#if defined(_DERIVATE)
  a3_Vbi_ci_Vbi_ei=((+(+(+a_Vbi_ci_Vbi_ei*x+a_Vbi_ci*x_Vbi_ei+a_Vbi_ei*x_Vbi_ci+a*x_Vbi_ci_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vbi_ci=((+(+(+a_Vbi_ci_Vbi_ci*x+a_Vbi_ci*x_Vbi_ci+a_Vbi_ci*x_Vbi_ci+a*x_Vbi_ci_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vci_ei=((+(+(+a_Vbi_ci_Vci_ei*x+a_Vbi_ci*x_Vci_ei+a_Vci_ei*x_Vbi_ci+a*x_Vbi_ci_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vtnode_GND=((+(+(+a_Vbi_ci_Vtnode_GND*x+a_Vbi_ci*x_Vtnode_GND+a_Vtnode_GND*x_Vbi_ci+a*x_Vbi_ci_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
a3_Vci_ei=(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))/9.0);
#if defined(_DERIVATE)
  a3_Vci_ei_Vbi_ei=((+(+(+a_Vci_ei_Vbi_ei*x+a_Vci_ei*x_Vbi_ei+a_Vbi_ei*x_Vci_ei+a*x_Vci_ei_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vbi_ci=((+(+(+a_Vci_ei_Vbi_ci*x+a_Vci_ei*x_Vbi_ci+a_Vbi_ci*x_Vci_ei+a*x_Vci_ei_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vci_ei=((+(+(+a_Vci_ei_Vci_ei*x+a_Vci_ei*x_Vci_ei+a_Vci_ei*x_Vci_ei+a*x_Vci_ei_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vtnode_GND=((+(+(+a_Vci_ei_Vtnode_GND*x+a_Vci_ei*x_Vtnode_GND+a_Vtnode_GND*x_Vci_ei+a*x_Vci_ei_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
#if defined(_DERIVATE)
a3_Vtnode_GND=(((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vtnode_GND)))/9.0);
#endif
#endif
a3=((((a*x)*((3.0*lnzb)-1.0))+1.0)/9.0);
r=(latb/latl);
#if defined(_DERIVATEFORDDX)
FCf3_Vbi_ei=((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latl);
#if defined(_DERIVATE)
  FCf3_Vbi_ei_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vbi_ei))/latl-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vbi_ci))/latl-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vci_ei))/latl-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vtnode_GND))/latl-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
#endif
FCf3_Vbi_ci=((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latl);
#if defined(_DERIVATE)
  FCf3_Vbi_ci_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vbi_ei))/latl-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vbi_ci))/latl-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vci_ei))/latl-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vtnode_GND))/latl-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
#endif
FCf3_Vci_ei=((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latl);
#if defined(_DERIVATE)
  FCf3_Vci_ei_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vci_ei+r*a3_Vci_ei_Vbi_ei))/latl-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vci_ei+r*a3_Vci_ei_Vbi_ci))/latl-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vci_ei+r*a3_Vci_ei_Vci_ei))/latl-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vci_ei+r*a3_Vci_ei_Vtnode_GND))/latl-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
#endif
#if defined(_DERIVATE)
FCf3_Vtnode_GND=((((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latl);
#endif
#endif
FCf3=((((1.0-r)*a2)+(r*a3))/latl);
#if defined(_DERIVATEFORDDX)
FCdf3_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vci_ei));
#if defined(_DERIVATE)
  FCdf3_dw_Vci_ei_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+r*a_Vci_ei_Vci_ei))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vci_ei);
  FCdf3_dw_Vci_ei_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+r*a_Vci_ei_Vtnode_GND))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vtnode_GND);
  FCdf3_dw_Vci_ei_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+r*a_Vci_ei_Vbi_ei))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vbi_ei);
  FCdf3_dw_Vci_ei_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+r*a_Vci_ei_Vbi_ci))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdf3_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vtnode_GND));
#endif
FCdf3_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vbi_ei));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ei_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+r*a_Vbi_ei_Vci_ei))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vci_ei);
  FCdf3_dw_Vbi_ei_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+r*a_Vbi_ei_Vtnode_GND))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vtnode_GND);
  FCdf3_dw_Vbi_ei_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+r*a_Vbi_ei_Vbi_ei))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vbi_ei);
  FCdf3_dw_Vbi_ei_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+r*a_Vbi_ei_Vbi_ci))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vbi_ci);
#endif
FCdf3_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vbi_ci));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ci_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+r*a_Vbi_ci_Vci_ei))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vci_ei);
  FCdf3_dw_Vbi_ci_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+r*a_Vbi_ci_Vtnode_GND))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vtnode_GND);
  FCdf3_dw_Vbi_ci_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+r*a_Vbi_ci_Vbi_ei))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vbi_ei);
  FCdf3_dw_Vbi_ci_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+r*a_Vbi_ci_Vbi_ci))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vbi_ci);
#endif
#endif
FCdf3_dw=((((1.0-r)*x)+(r*a))*lnzb);
}
else
{
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+z_Vbi_ei_Vbi_ei*z+z_Vbi_ei*z_Vbi_ei+z_Vbi_ei*z_Vbi_ei+z*z_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+z_Vbi_ei_Vbi_ci*z+z_Vbi_ei*z_Vbi_ci+z_Vbi_ci*z_Vbi_ei+z*z_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+z_Vbi_ei_Vci_ei*z+z_Vbi_ei*z_Vci_ei+z_Vci_ei*z_Vbi_ei+z*z_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+z_Vbi_ei_Vtnode_GND*z+z_Vbi_ei*z_Vtnode_GND+z_Vtnode_GND*z_Vbi_ei+z*z_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+z_Vbi_ci_Vbi_ei*z+z_Vbi_ci*z_Vbi_ei+z_Vbi_ei*z_Vbi_ci+z*z_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+z_Vbi_ci_Vbi_ci*z+z_Vbi_ci*z_Vbi_ci+z_Vbi_ci*z_Vbi_ci+z*z_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+z_Vbi_ci_Vci_ei*z+z_Vbi_ci*z_Vci_ei+z_Vci_ei*z_Vbi_ci+z*z_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+z_Vbi_ci_Vtnode_GND*z+z_Vbi_ci*z_Vtnode_GND+z_Vtnode_GND*z_Vbi_ci+z*z_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+z_Vci_ei_Vbi_ei*z+z_Vci_ei*z_Vbi_ei+z_Vbi_ei*z_Vci_ei+z*z_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+z_Vci_ei_Vbi_ci*z+z_Vci_ei*z_Vbi_ci+z_Vbi_ci*z_Vci_ei+z*z_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+z_Vci_ei_Vci_ei*z+z_Vci_ei*z_Vci_ei+z_Vci_ei*z_Vci_ei+z*z_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+z_Vci_ei_Vtnode_GND*z+z_Vci_ei*z_Vtnode_GND+z_Vtnode_GND*z_Vci_ei+z*z_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
#endif
#endif
a=(z*z);
#if defined(_DERIVATEFORDDX)
a2_Vbi_ei=((z_Vbi_ei-(0.25*a_Vbi_ei))+(((0.10*z_Vbi_ei)*a)+((0.10*z)*a_Vbi_ei)));
#if defined(_DERIVATE)
  a2_Vbi_ei_Vbi_ei=(+(+(+0.0+z_Vbi_ei_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vbi_ei)*a+(0.10*z_Vbi_ei)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vbi_ei));
  a2_Vbi_ei_Vbi_ci=(+(+(+0.0+z_Vbi_ei_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vbi_ci)*a+(0.10*z_Vbi_ei)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vbi_ci));
  a2_Vbi_ei_Vci_ei=(+(+(+0.0+z_Vbi_ei_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vci_ei)*a+(0.10*z_Vbi_ei)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vci_ei));
  a2_Vbi_ei_Vtnode_GND=(+(+(+0.0+z_Vbi_ei_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vtnode_GND)*a+(0.10*z_Vbi_ei)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vtnode_GND));
#endif
a2_Vbi_ci=((z_Vbi_ci-(0.25*a_Vbi_ci))+(((0.10*z_Vbi_ci)*a)+((0.10*z)*a_Vbi_ci)));
#if defined(_DERIVATE)
  a2_Vbi_ci_Vbi_ei=(+(+(+0.0+z_Vbi_ci_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vbi_ei)*a+(0.10*z_Vbi_ci)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vbi_ei));
  a2_Vbi_ci_Vbi_ci=(+(+(+0.0+z_Vbi_ci_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vbi_ci)*a+(0.10*z_Vbi_ci)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vbi_ci));
  a2_Vbi_ci_Vci_ei=(+(+(+0.0+z_Vbi_ci_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vci_ei)*a+(0.10*z_Vbi_ci)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vci_ei));
  a2_Vbi_ci_Vtnode_GND=(+(+(+0.0+z_Vbi_ci_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vtnode_GND)*a+(0.10*z_Vbi_ci)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vtnode_GND));
#endif
a2_Vci_ei=((z_Vci_ei-(0.25*a_Vci_ei))+(((0.10*z_Vci_ei)*a)+((0.10*z)*a_Vci_ei)));
#if defined(_DERIVATE)
  a2_Vci_ei_Vbi_ei=(+(+(+0.0+z_Vci_ei_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.25*a_Vci_ei_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vci_ei+0.10*z_Vci_ei_Vbi_ei)*a+(0.10*z_Vci_ei)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vbi_ei));
  a2_Vci_ei_Vbi_ci=(+(+(+0.0+z_Vci_ei_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.25*a_Vci_ei_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vci_ei+0.10*z_Vci_ei_Vbi_ci)*a+(0.10*z_Vci_ei)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vbi_ci));
  a2_Vci_ei_Vci_ei=(+(+(+0.0+z_Vci_ei_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.25*a_Vci_ei_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vci_ei+0.10*z_Vci_ei_Vci_ei)*a+(0.10*z_Vci_ei)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vci_ei));
  a2_Vci_ei_Vtnode_GND=(+(+(+0.0+z_Vci_ei_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.25*a_Vci_ei_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vci_ei+0.10*z_Vci_ei_Vtnode_GND)*a+(0.10*z_Vci_ei)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
a2_Vtnode_GND=((z_Vtnode_GND-(0.25*a_Vtnode_GND))+(((0.10*z_Vtnode_GND)*a)+((0.10*z)*a_Vtnode_GND)));
#endif
#endif
a2=(((3.0+z)-(0.25*a))+((0.10*z)*a));
#if defined(_DERIVATEFORDDX)
a3_Vbi_ei=(((2.0*z_Vbi_ei)+(0.75*a_Vbi_ei))-(((0.20*a_Vbi_ei)*z)+((0.20*a)*z_Vbi_ei)));
#if defined(_DERIVATE)
  a3_Vbi_ei_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vbi_ei)*z+(0.20*a_Vbi_ei)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vbi_ei));
  a3_Vbi_ei_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vbi_ci)*z+(0.20*a_Vbi_ei)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vbi_ci));
  a3_Vbi_ei_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vci_ei)*z+(0.20*a_Vbi_ei)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vci_ei));
  a3_Vbi_ei_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vtnode_GND)*z+(0.20*a_Vbi_ei)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vtnode_GND));
#endif
a3_Vbi_ci=(((2.0*z_Vbi_ci)+(0.75*a_Vbi_ci))-(((0.20*a_Vbi_ci)*z)+((0.20*a)*z_Vbi_ci)));
#if defined(_DERIVATE)
  a3_Vbi_ci_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vbi_ei)*z+(0.20*a_Vbi_ci)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vbi_ei));
  a3_Vbi_ci_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vbi_ci)*z+(0.20*a_Vbi_ci)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vbi_ci));
  a3_Vbi_ci_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vci_ei)*z+(0.20*a_Vbi_ci)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vci_ei));
  a3_Vbi_ci_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vtnode_GND)*z+(0.20*a_Vbi_ci)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vtnode_GND));
#endif
a3_Vci_ei=(((2.0*z_Vci_ei)+(0.75*a_Vci_ei))-(((0.20*a_Vci_ei)*z)+((0.20*a)*z_Vci_ei)));
#if defined(_DERIVATE)
  a3_Vci_ei_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vci_ei+2.0*z_Vci_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.75*a_Vci_ei_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.20*a_Vci_ei_Vbi_ei)*z+(0.20*a_Vci_ei)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vbi_ei));
  a3_Vci_ei_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vci_ei+2.0*z_Vci_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.75*a_Vci_ei_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.20*a_Vci_ei_Vbi_ci)*z+(0.20*a_Vci_ei)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vbi_ci));
  a3_Vci_ei_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vci_ei+2.0*z_Vci_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.75*a_Vci_ei_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.20*a_Vci_ei_Vci_ei)*z+(0.20*a_Vci_ei)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vci_ei));
  a3_Vci_ei_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vci_ei+2.0*z_Vci_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.75*a_Vci_ei_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.20*a_Vci_ei_Vtnode_GND)*z+(0.20*a_Vci_ei)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
a3_Vtnode_GND=(((2.0*z_Vtnode_GND)+(0.75*a_Vtnode_GND))-(((0.20*a_Vtnode_GND)*z)+((0.20*a)*z_Vtnode_GND)));
#endif
#endif
a3=(((2.0*z)+(0.75*a))-((0.20*a)*z));
#if defined(_DERIVATEFORDDX)
FCf3_Vbi_ei=(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))/6.0);
#if defined(_DERIVATE)
  FCf3_Vbi_ei_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ei+latl*a2_Vbi_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ei+latb*a3_Vbi_ei_Vbi_ei))*FCw+((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw_Vbi_ei+(((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw_Vbi_ei+((latl*a2)+(latb*a3))*FCw_Vbi_ei_Vbi_ei)*FCw+((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw_Vbi_ei+((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw_Vbi_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei_Vbi_ei)/6.0-(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ei_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ei+latl*a2_Vbi_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ei+latb*a3_Vbi_ei_Vbi_ci))*FCw+((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw_Vbi_ci+(((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw_Vbi_ei+((latl*a2)+(latb*a3))*FCw_Vbi_ei_Vbi_ci)*FCw+((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw_Vbi_ci+((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw_Vbi_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei_Vbi_ci)/6.0-(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ei_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ei+latl*a2_Vbi_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ei+latb*a3_Vbi_ei_Vci_ei))*FCw+((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw_Vci_ei+(((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw_Vbi_ei+((latl*a2)+(latb*a3))*FCw_Vbi_ei_Vci_ei)*FCw+((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw_Vci_ei+((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw_Vbi_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei_Vci_ei)/6.0-(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ei_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ei+latl*a2_Vbi_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ei+latb*a3_Vbi_ei_Vtnode_GND))*FCw+((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw_Vtnode_GND+(((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw_Vbi_ei+((latl*a2)+(latb*a3))*FCw_Vbi_ei_Vtnode_GND)*FCw+((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw_Vtnode_GND+((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw_Vbi_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei_Vtnode_GND)/6.0-(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
FCf3_Vbi_ci=(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))/6.0);
#if defined(_DERIVATE)
  FCf3_Vbi_ci_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ci+latl*a2_Vbi_ci_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ci+latb*a3_Vbi_ci_Vbi_ei))*FCw+((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw_Vbi_ei+(((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw_Vbi_ci+((latl*a2)+(latb*a3))*FCw_Vbi_ci_Vbi_ei)*FCw+((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw_Vbi_ei+((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw_Vbi_ci+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci_Vbi_ei)/6.0-(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ci_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ci+latl*a2_Vbi_ci_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ci+latb*a3_Vbi_ci_Vbi_ci))*FCw+((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw_Vbi_ci+(((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw_Vbi_ci+((latl*a2)+(latb*a3))*FCw_Vbi_ci_Vbi_ci)*FCw+((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw_Vbi_ci+((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw_Vbi_ci+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci_Vbi_ci)/6.0-(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ci_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ci+latl*a2_Vbi_ci_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ci+latb*a3_Vbi_ci_Vci_ei))*FCw+((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw_Vci_ei+(((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw_Vbi_ci+((latl*a2)+(latb*a3))*FCw_Vbi_ci_Vci_ei)*FCw+((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw_Vci_ei+((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw_Vbi_ci+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci_Vci_ei)/6.0-(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ci_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ci+latl*a2_Vbi_ci_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ci+latb*a3_Vbi_ci_Vtnode_GND))*FCw+((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw_Vtnode_GND+(((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw_Vbi_ci+((latl*a2)+(latb*a3))*FCw_Vbi_ci_Vtnode_GND)*FCw+((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw_Vtnode_GND+((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw_Vbi_ci+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci_Vtnode_GND)/6.0-(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
FCf3_Vci_ei=(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))/6.0);
#if defined(_DERIVATE)
  FCf3_Vci_ei_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vci_ei+latl*a2_Vci_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vci_ei+latb*a3_Vci_ei_Vbi_ei))*FCw+((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw_Vbi_ei+(((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw_Vci_ei+((latl*a2)+(latb*a3))*FCw_Vci_ei_Vbi_ei)*FCw+((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw_Vbi_ei+((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw_Vci_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei_Vbi_ei)/6.0-(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vci_ei_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vci_ei+latl*a2_Vci_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vci_ei+latb*a3_Vci_ei_Vbi_ci))*FCw+((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw_Vbi_ci+(((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw_Vci_ei+((latl*a2)+(latb*a3))*FCw_Vci_ei_Vbi_ci)*FCw+((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw_Vbi_ci+((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw_Vci_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei_Vbi_ci)/6.0-(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vci_ei_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vci_ei+latl*a2_Vci_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vci_ei+latb*a3_Vci_ei_Vci_ei))*FCw+((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw_Vci_ei+(((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw_Vci_ei+((latl*a2)+(latb*a3))*FCw_Vci_ei_Vci_ei)*FCw+((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw_Vci_ei+((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw_Vci_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei_Vci_ei)/6.0-(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vci_ei_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vci_ei+latl*a2_Vci_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vci_ei+latb*a3_Vci_ei_Vtnode_GND))*FCw+((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw_Vtnode_GND+(((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw_Vci_ei+((latl*a2)+(latb*a3))*FCw_Vci_ei_Vtnode_GND)*FCw+((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw_Vtnode_GND+((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw_Vci_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei_Vtnode_GND)/6.0-(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
#if defined(_DERIVATE)
FCf3_Vtnode_GND=(((((((latl*a2_Vtnode_GND)+(latb*a3_Vtnode_GND))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND))/6.0);
#endif
#endif
FCf3=(((((latl*a2)+(latb*a3))*FCw)*FCw)/6.0);
#if defined(_DERIVATEFORDDX)
FCdf3_dw_Vci_ei=(((((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb)+(((1+(latb*FCw))*(1+z))*lnzb_Vci_ei));
#if defined(_DERIVATE)
  FCdf3_dw_Vci_ei_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei))*(1+z)+(latb*FCw_Vci_ei)*z_Vci_ei+((latb*FCw_Vci_ei))*z_Vci_ei+(1+(latb*FCw))*(+0.0+z_Vci_ei_Vci_ei))*lnzb+(((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb_Vci_ei+(((((latb*FCw_Vci_ei))*(1+z))+((1+(latb*FCw))*z_Vci_ei)))*lnzb_Vci_ei+((1+(latb*FCw))*(1+z))*lnzb_Vci_ei_Vci_ei);
  FCdf3_dw_Vci_ei_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND))*(1+z)+(latb*FCw_Vci_ei)*z_Vtnode_GND+((latb*FCw_Vtnode_GND))*z_Vci_ei+(1+(latb*FCw))*(+0.0+z_Vci_ei_Vtnode_GND))*lnzb+(((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb_Vtnode_GND+(((((latb*FCw_Vtnode_GND))*(1+z))+((1+(latb*FCw))*z_Vtnode_GND)))*lnzb_Vci_ei+((1+(latb*FCw))*(1+z))*lnzb_Vci_ei_Vtnode_GND);
  FCdf3_dw_Vci_ei_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei))*(1+z)+(latb*FCw_Vci_ei)*z_Vbi_ei+((latb*FCw_Vbi_ei))*z_Vci_ei+(1+(latb*FCw))*(+0.0+z_Vci_ei_Vbi_ei))*lnzb+(((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb_Vbi_ei+(((((latb*FCw_Vbi_ei))*(1+z))+((1+(latb*FCw))*z_Vbi_ei)))*lnzb_Vci_ei+((1+(latb*FCw))*(1+z))*lnzb_Vci_ei_Vbi_ei);
  FCdf3_dw_Vci_ei_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci))*(1+z)+(latb*FCw_Vci_ei)*z_Vbi_ci+((latb*FCw_Vbi_ci))*z_Vci_ei+(1+(latb*FCw))*(+0.0+z_Vci_ei_Vbi_ci))*lnzb+(((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb_Vbi_ci+(((((latb*FCw_Vbi_ci))*(1+z))+((1+(latb*FCw))*z_Vbi_ci)))*lnzb_Vci_ei+((1+(latb*FCw))*(1+z))*lnzb_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdf3_dw_Vtnode_GND=(((((latb*FCw_Vtnode_GND)*(1+z))+((1+(latb*FCw))*z_Vtnode_GND))*lnzb)+(((1+(latb*FCw))*(1+z))*lnzb_Vtnode_GND));
#endif
FCdf3_dw_Vbi_ei=(((((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb)+(((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ei_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei))*(1+z)+(latb*FCw_Vbi_ei)*z_Vci_ei+((latb*FCw_Vci_ei))*z_Vbi_ei+(1+(latb*FCw))*(+0.0+z_Vbi_ei_Vci_ei))*lnzb+(((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb_Vci_ei+(((((latb*FCw_Vci_ei))*(1+z))+((1+(latb*FCw))*z_Vci_ei)))*lnzb_Vbi_ei+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei_Vci_ei);
  FCdf3_dw_Vbi_ei_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND))*(1+z)+(latb*FCw_Vbi_ei)*z_Vtnode_GND+((latb*FCw_Vtnode_GND))*z_Vbi_ei+(1+(latb*FCw))*(+0.0+z_Vbi_ei_Vtnode_GND))*lnzb+(((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb_Vtnode_GND+(((((latb*FCw_Vtnode_GND))*(1+z))+((1+(latb*FCw))*z_Vtnode_GND)))*lnzb_Vbi_ei+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei_Vtnode_GND);
  FCdf3_dw_Vbi_ei_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei))*(1+z)+(latb*FCw_Vbi_ei)*z_Vbi_ei+((latb*FCw_Vbi_ei))*z_Vbi_ei+(1+(latb*FCw))*(+0.0+z_Vbi_ei_Vbi_ei))*lnzb+(((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb_Vbi_ei+(((((latb*FCw_Vbi_ei))*(1+z))+((1+(latb*FCw))*z_Vbi_ei)))*lnzb_Vbi_ei+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei_Vbi_ei);
  FCdf3_dw_Vbi_ei_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci))*(1+z)+(latb*FCw_Vbi_ei)*z_Vbi_ci+((latb*FCw_Vbi_ci))*z_Vbi_ei+(1+(latb*FCw))*(+0.0+z_Vbi_ei_Vbi_ci))*lnzb+(((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb_Vbi_ci+(((((latb*FCw_Vbi_ci))*(1+z))+((1+(latb*FCw))*z_Vbi_ci)))*lnzb_Vbi_ei+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei_Vbi_ci);
#endif
FCdf3_dw_Vbi_ci=(((((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb)+(((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ci_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei))*(1+z)+(latb*FCw_Vbi_ci)*z_Vci_ei+((latb*FCw_Vci_ei))*z_Vbi_ci+(1+(latb*FCw))*(+0.0+z_Vbi_ci_Vci_ei))*lnzb+(((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb_Vci_ei+(((((latb*FCw_Vci_ei))*(1+z))+((1+(latb*FCw))*z_Vci_ei)))*lnzb_Vbi_ci+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci_Vci_ei);
  FCdf3_dw_Vbi_ci_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND))*(1+z)+(latb*FCw_Vbi_ci)*z_Vtnode_GND+((latb*FCw_Vtnode_GND))*z_Vbi_ci+(1+(latb*FCw))*(+0.0+z_Vbi_ci_Vtnode_GND))*lnzb+(((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb_Vtnode_GND+(((((latb*FCw_Vtnode_GND))*(1+z))+((1+(latb*FCw))*z_Vtnode_GND)))*lnzb_Vbi_ci+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci_Vtnode_GND);
  FCdf3_dw_Vbi_ci_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei))*(1+z)+(latb*FCw_Vbi_ci)*z_Vbi_ei+((latb*FCw_Vbi_ei))*z_Vbi_ci+(1+(latb*FCw))*(+0.0+z_Vbi_ci_Vbi_ei))*lnzb+(((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb_Vbi_ei+(((((latb*FCw_Vbi_ei))*(1+z))+((1+(latb*FCw))*z_Vbi_ei)))*lnzb_Vbi_ci+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci_Vbi_ei);
  FCdf3_dw_Vbi_ci_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci))*(1+z)+(latb*FCw_Vbi_ci)*z_Vbi_ci+((latb*FCw_Vbi_ci))*z_Vbi_ci+(1+(latb*FCw))*(+0.0+z_Vbi_ci_Vbi_ci))*lnzb+(((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb_Vbi_ci+(((((latb*FCw_Vbi_ci))*(1+z))+((1+(latb*FCw))*z_Vbi_ci)))*lnzb_Vbi_ci+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci_Vbi_ci);
#endif
#endif
FCdf3_dw=(((1+(latb*FCw))*(1+z))*lnzb);
}
#if defined(_DERIVATEFORDDX)
FCf_ci_Vci_ei=((FCf_CT_Vci_ei*(((FCa1*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)));
#if defined(_DERIVATE)
  FCf_ci_Vci_ei_Vci_ei=(+FCf_CT_Vci_ei_Vci_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vci_ei*(((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei)))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT_Vci_ei*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT*(+(+(+FCa1_Vci_ei_Vci_ei*FCf1+FCa1_Vci_ei*FCf1_Vci_ei+FCa1_Vci_ei*FCf1_Vci_ei+FCa1*FCf1_Vci_ei_Vci_ei)-FCf2_Vci_ei_Vci_ei)+FCf3_Vci_ei_Vci_ei));
  FCf_ci_Vci_ei_Vtnode_GND=(+FCf_CT_Vci_ei_Vtnode_GND*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vci_ei*(((((FCa1_Vtnode_GND*FCf1)+(FCa1*FCf1_Vtnode_GND)))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT*(+(+(+FCa1_Vci_ei_Vtnode_GND*FCf1+FCa1_Vci_ei*FCf1_Vtnode_GND+FCa1_Vtnode_GND*FCf1_Vci_ei+FCa1*FCf1_Vci_ei_Vtnode_GND)-FCf2_Vci_ei_Vtnode_GND)+FCf3_Vci_ei_Vtnode_GND));
  FCf_ci_Vci_ei_Vbi_ei=(+FCf_CT_Vci_ei_Vbi_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vci_ei*(((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei)))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT_Vbi_ei*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT*(+(+(+FCa1_Vci_ei_Vbi_ei*FCf1+FCa1_Vci_ei*FCf1_Vbi_ei+FCa1_Vbi_ei*FCf1_Vci_ei+FCa1*FCf1_Vci_ei_Vbi_ei)-FCf2_Vci_ei_Vbi_ei)+FCf3_Vci_ei_Vbi_ei));
  FCf_ci_Vci_ei_Vbi_ci=(+FCf_CT_Vci_ei_Vbi_ci*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vci_ei*(((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci)))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT_Vbi_ci*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT*(+(+(+FCa1_Vci_ei_Vbi_ci*FCf1+FCa1_Vci_ei*FCf1_Vbi_ci+FCa1_Vbi_ci*FCf1_Vci_ei+FCa1*FCf1_Vci_ei_Vbi_ci)-FCf2_Vci_ei_Vbi_ci)+FCf3_Vci_ei_Vbi_ci));
#endif
#if defined(_DERIVATE)
FCf_ci_Vtnode_GND=((FCf_CT_Vtnode_GND*(((FCa1*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa1_Vtnode_GND*FCf1)+(FCa1*FCf1_Vtnode_GND))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)));
#endif
FCf_ci_Vbi_ei=((FCf_CT_Vbi_ei*(((FCa1*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)));
#if defined(_DERIVATE)
  FCf_ci_Vbi_ei_Vci_ei=(+FCf_CT_Vbi_ei_Vci_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ei*(((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei)))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT_Vci_ei*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT*(+(+(+FCa1_Vbi_ei_Vci_ei*FCf1+FCa1_Vbi_ei*FCf1_Vci_ei+FCa1_Vci_ei*FCf1_Vbi_ei+FCa1*FCf1_Vbi_ei_Vci_ei)-FCf2_Vbi_ei_Vci_ei)+FCf3_Vbi_ei_Vci_ei));
  FCf_ci_Vbi_ei_Vtnode_GND=(+FCf_CT_Vbi_ei_Vtnode_GND*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ei*(((((FCa1_Vtnode_GND*FCf1)+(FCa1*FCf1_Vtnode_GND)))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT*(+(+(+FCa1_Vbi_ei_Vtnode_GND*FCf1+FCa1_Vbi_ei*FCf1_Vtnode_GND+FCa1_Vtnode_GND*FCf1_Vbi_ei+FCa1*FCf1_Vbi_ei_Vtnode_GND)-FCf2_Vbi_ei_Vtnode_GND)+FCf3_Vbi_ei_Vtnode_GND));
  FCf_ci_Vbi_ei_Vbi_ei=(+FCf_CT_Vbi_ei_Vbi_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ei*(((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei)))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT_Vbi_ei*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT*(+(+(+FCa1_Vbi_ei_Vbi_ei*FCf1+FCa1_Vbi_ei*FCf1_Vbi_ei+FCa1_Vbi_ei*FCf1_Vbi_ei+FCa1*FCf1_Vbi_ei_Vbi_ei)-FCf2_Vbi_ei_Vbi_ei)+FCf3_Vbi_ei_Vbi_ei));
  FCf_ci_Vbi_ei_Vbi_ci=(+FCf_CT_Vbi_ei_Vbi_ci*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ei*(((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci)))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT_Vbi_ci*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT*(+(+(+FCa1_Vbi_ei_Vbi_ci*FCf1+FCa1_Vbi_ei*FCf1_Vbi_ci+FCa1_Vbi_ci*FCf1_Vbi_ei+FCa1*FCf1_Vbi_ei_Vbi_ci)-FCf2_Vbi_ei_Vbi_ci)+FCf3_Vbi_ei_Vbi_ci));
#endif
FCf_ci_Vbi_ci=((FCf_CT_Vbi_ci*(((FCa1*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)));
#if defined(_DERIVATE)
  FCf_ci_Vbi_ci_Vci_ei=(+FCf_CT_Vbi_ci_Vci_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ci*(((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei)))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT_Vci_ei*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT*(+(+(+FCa1_Vbi_ci_Vci_ei*FCf1+FCa1_Vbi_ci*FCf1_Vci_ei+FCa1_Vci_ei*FCf1_Vbi_ci+FCa1*FCf1_Vbi_ci_Vci_ei)-FCf2_Vbi_ci_Vci_ei)+FCf3_Vbi_ci_Vci_ei));
  FCf_ci_Vbi_ci_Vtnode_GND=(+FCf_CT_Vbi_ci_Vtnode_GND*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ci*(((((FCa1_Vtnode_GND*FCf1)+(FCa1*FCf1_Vtnode_GND)))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT*(+(+(+FCa1_Vbi_ci_Vtnode_GND*FCf1+FCa1_Vbi_ci*FCf1_Vtnode_GND+FCa1_Vtnode_GND*FCf1_Vbi_ci+FCa1*FCf1_Vbi_ci_Vtnode_GND)-FCf2_Vbi_ci_Vtnode_GND)+FCf3_Vbi_ci_Vtnode_GND));
  FCf_ci_Vbi_ci_Vbi_ei=(+FCf_CT_Vbi_ci_Vbi_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ci*(((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei)))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT_Vbi_ei*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT*(+(+(+FCa1_Vbi_ci_Vbi_ei*FCf1+FCa1_Vbi_ci*FCf1_Vbi_ei+FCa1_Vbi_ei*FCf1_Vbi_ci+FCa1*FCf1_Vbi_ci_Vbi_ei)-FCf2_Vbi_ci_Vbi_ei)+FCf3_Vbi_ci_Vbi_ei));
  FCf_ci_Vbi_ci_Vbi_ci=(+FCf_CT_Vbi_ci_Vbi_ci*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ci*(((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci)))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT_Vbi_ci*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT*(+(+(+FCa1_Vbi_ci_Vbi_ci*FCf1+FCa1_Vbi_ci*FCf1_Vbi_ci+FCa1_Vbi_ci*FCf1_Vbi_ci+FCa1*FCf1_Vbi_ci_Vbi_ci)-FCf2_Vbi_ci_Vbi_ci)+FCf3_Vbi_ci_Vbi_ci));
#endif
#endif
FCf_ci=(FCf_CT*(((FCa1*FCf1)-FCf2)+FCf3));
#if defined(_DERIVATEFORDDX)
FCdfc_dw_Vci_ei=((FCf_CT_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)));
#if defined(_DERIVATE)
  FCdfc_dw_Vci_ei_Vci_ei=(+FCf_CT_Vci_ei_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vci_ei*((((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei)))+(((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei))))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT*(+(+(+(+FCa1_Vci_ei_Vci_ei*FCdf1_dw+FCa1_Vci_ei*FCdf1_dw_Vci_ei+FCa1_Vci_ei*FCdf1_dw_Vci_ei+FCa1*FCdf1_dw_Vci_ei_Vci_ei)+(+FCda1_dw_Vci_ei_Vci_ei*FCf1+FCda1_dw_Vci_ei*FCf1_Vci_ei+FCda1_dw_Vci_ei*FCf1_Vci_ei+FCda1_dw*FCf1_Vci_ei_Vci_ei))-FCdf2_dw_Vci_ei_Vci_ei)+FCdf3_dw_Vci_ei_Vci_ei));
  FCdfc_dw_Vci_ei_Vtnode_GND=(+FCf_CT_Vci_ei_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vci_ei*((((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND)))+(((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND))))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT*(+(+(+(+FCa1_Vci_ei_Vtnode_GND*FCdf1_dw+FCa1_Vci_ei*FCdf1_dw_Vtnode_GND+FCa1_Vtnode_GND*FCdf1_dw_Vci_ei+FCa1*FCdf1_dw_Vci_ei_Vtnode_GND)+(+FCda1_dw_Vci_ei_Vtnode_GND*FCf1+FCda1_dw_Vci_ei*FCf1_Vtnode_GND+FCda1_dw_Vtnode_GND*FCf1_Vci_ei+FCda1_dw*FCf1_Vci_ei_Vtnode_GND))-FCdf2_dw_Vci_ei_Vtnode_GND)+FCdf3_dw_Vci_ei_Vtnode_GND));
  FCdfc_dw_Vci_ei_Vbi_ei=(+FCf_CT_Vci_ei_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vci_ei*((((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei)))+(((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei))))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT*(+(+(+(+FCa1_Vci_ei_Vbi_ei*FCdf1_dw+FCa1_Vci_ei*FCdf1_dw_Vbi_ei+FCa1_Vbi_ei*FCdf1_dw_Vci_ei+FCa1*FCdf1_dw_Vci_ei_Vbi_ei)+(+FCda1_dw_Vci_ei_Vbi_ei*FCf1+FCda1_dw_Vci_ei*FCf1_Vbi_ei+FCda1_dw_Vbi_ei*FCf1_Vci_ei+FCda1_dw*FCf1_Vci_ei_Vbi_ei))-FCdf2_dw_Vci_ei_Vbi_ei)+FCdf3_dw_Vci_ei_Vbi_ei));
  FCdfc_dw_Vci_ei_Vbi_ci=(+FCf_CT_Vci_ei_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vci_ei*((((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci)))+(((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci))))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT*(+(+(+(+FCa1_Vci_ei_Vbi_ci*FCdf1_dw+FCa1_Vci_ei*FCdf1_dw_Vbi_ci+FCa1_Vbi_ci*FCdf1_dw_Vci_ei+FCa1*FCdf1_dw_Vci_ei_Vbi_ci)+(+FCda1_dw_Vci_ei_Vbi_ci*FCf1+FCda1_dw_Vci_ei*FCf1_Vbi_ci+FCda1_dw_Vbi_ci*FCf1_Vci_ei+FCda1_dw*FCf1_Vci_ei_Vbi_ci))-FCdf2_dw_Vci_ei_Vbi_ci)+FCdf3_dw_Vci_ei_Vbi_ci));
#endif
#if defined(_DERIVATE)
FCdfc_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND))+((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND)))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)));
#endif
FCdfc_dw_Vbi_ei=((FCf_CT_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)));
#if defined(_DERIVATE)
  FCdfc_dw_Vbi_ei_Vci_ei=(+FCf_CT_Vbi_ei_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ei*((((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei)))+(((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei))))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT*(+(+(+(+FCa1_Vbi_ei_Vci_ei*FCdf1_dw+FCa1_Vbi_ei*FCdf1_dw_Vci_ei+FCa1_Vci_ei*FCdf1_dw_Vbi_ei+FCa1*FCdf1_dw_Vbi_ei_Vci_ei)+(+FCda1_dw_Vbi_ei_Vci_ei*FCf1+FCda1_dw_Vbi_ei*FCf1_Vci_ei+FCda1_dw_Vci_ei*FCf1_Vbi_ei+FCda1_dw*FCf1_Vbi_ei_Vci_ei))-FCdf2_dw_Vbi_ei_Vci_ei)+FCdf3_dw_Vbi_ei_Vci_ei));
  FCdfc_dw_Vbi_ei_Vtnode_GND=(+FCf_CT_Vbi_ei_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ei*((((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND)))+(((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND))))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT*(+(+(+(+FCa1_Vbi_ei_Vtnode_GND*FCdf1_dw+FCa1_Vbi_ei*FCdf1_dw_Vtnode_GND+FCa1_Vtnode_GND*FCdf1_dw_Vbi_ei+FCa1*FCdf1_dw_Vbi_ei_Vtnode_GND)+(+FCda1_dw_Vbi_ei_Vtnode_GND*FCf1+FCda1_dw_Vbi_ei*FCf1_Vtnode_GND+FCda1_dw_Vtnode_GND*FCf1_Vbi_ei+FCda1_dw*FCf1_Vbi_ei_Vtnode_GND))-FCdf2_dw_Vbi_ei_Vtnode_GND)+FCdf3_dw_Vbi_ei_Vtnode_GND));
  FCdfc_dw_Vbi_ei_Vbi_ei=(+FCf_CT_Vbi_ei_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ei*((((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei)))+(((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei))))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT*(+(+(+(+FCa1_Vbi_ei_Vbi_ei*FCdf1_dw+FCa1_Vbi_ei*FCdf1_dw_Vbi_ei+FCa1_Vbi_ei*FCdf1_dw_Vbi_ei+FCa1*FCdf1_dw_Vbi_ei_Vbi_ei)+(+FCda1_dw_Vbi_ei_Vbi_ei*FCf1+FCda1_dw_Vbi_ei*FCf1_Vbi_ei+FCda1_dw_Vbi_ei*FCf1_Vbi_ei+FCda1_dw*FCf1_Vbi_ei_Vbi_ei))-FCdf2_dw_Vbi_ei_Vbi_ei)+FCdf3_dw_Vbi_ei_Vbi_ei));
  FCdfc_dw_Vbi_ei_Vbi_ci=(+FCf_CT_Vbi_ei_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ei*((((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci)))+(((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci))))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT*(+(+(+(+FCa1_Vbi_ei_Vbi_ci*FCdf1_dw+FCa1_Vbi_ei*FCdf1_dw_Vbi_ci+FCa1_Vbi_ci*FCdf1_dw_Vbi_ei+FCa1*FCdf1_dw_Vbi_ei_Vbi_ci)+(+FCda1_dw_Vbi_ei_Vbi_ci*FCf1+FCda1_dw_Vbi_ei*FCf1_Vbi_ci+FCda1_dw_Vbi_ci*FCf1_Vbi_ei+FCda1_dw*FCf1_Vbi_ei_Vbi_ci))-FCdf2_dw_Vbi_ei_Vbi_ci)+FCdf3_dw_Vbi_ei_Vbi_ci));
#endif
FCdfc_dw_Vbi_ci=((FCf_CT_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)));
#if defined(_DERIVATE)
  FCdfc_dw_Vbi_ci_Vci_ei=(+FCf_CT_Vbi_ci_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ci*((((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei)))+(((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei))))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT*(+(+(+(+FCa1_Vbi_ci_Vci_ei*FCdf1_dw+FCa1_Vbi_ci*FCdf1_dw_Vci_ei+FCa1_Vci_ei*FCdf1_dw_Vbi_ci+FCa1*FCdf1_dw_Vbi_ci_Vci_ei)+(+FCda1_dw_Vbi_ci_Vci_ei*FCf1+FCda1_dw_Vbi_ci*FCf1_Vci_ei+FCda1_dw_Vci_ei*FCf1_Vbi_ci+FCda1_dw*FCf1_Vbi_ci_Vci_ei))-FCdf2_dw_Vbi_ci_Vci_ei)+FCdf3_dw_Vbi_ci_Vci_ei));
  FCdfc_dw_Vbi_ci_Vtnode_GND=(+FCf_CT_Vbi_ci_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ci*((((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND)))+(((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND))))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT*(+(+(+(+FCa1_Vbi_ci_Vtnode_GND*FCdf1_dw+FCa1_Vbi_ci*FCdf1_dw_Vtnode_GND+FCa1_Vtnode_GND*FCdf1_dw_Vbi_ci+FCa1*FCdf1_dw_Vbi_ci_Vtnode_GND)+(+FCda1_dw_Vbi_ci_Vtnode_GND*FCf1+FCda1_dw_Vbi_ci*FCf1_Vtnode_GND+FCda1_dw_Vtnode_GND*FCf1_Vbi_ci+FCda1_dw*FCf1_Vbi_ci_Vtnode_GND))-FCdf2_dw_Vbi_ci_Vtnode_GND)+FCdf3_dw_Vbi_ci_Vtnode_GND));
  FCdfc_dw_Vbi_ci_Vbi_ei=(+FCf_CT_Vbi_ci_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ci*((((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei)))+(((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei))))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT*(+(+(+(+FCa1_Vbi_ci_Vbi_ei*FCdf1_dw+FCa1_Vbi_ci*FCdf1_dw_Vbi_ei+FCa1_Vbi_ei*FCdf1_dw_Vbi_ci+FCa1*FCdf1_dw_Vbi_ci_Vbi_ei)+(+FCda1_dw_Vbi_ci_Vbi_ei*FCf1+FCda1_dw_Vbi_ci*FCf1_Vbi_ei+FCda1_dw_Vbi_ei*FCf1_Vbi_ci+FCda1_dw*FCf1_Vbi_ci_Vbi_ei))-FCdf2_dw_Vbi_ci_Vbi_ei)+FCdf3_dw_Vbi_ci_Vbi_ei));
  FCdfc_dw_Vbi_ci_Vbi_ci=(+FCf_CT_Vbi_ci_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ci*((((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci)))+(((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci))))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT*(+(+(+(+FCa1_Vbi_ci_Vbi_ci*FCdf1_dw+FCa1_Vbi_ci*FCdf1_dw_Vbi_ci+FCa1_Vbi_ci*FCdf1_dw_Vbi_ci+FCa1*FCdf1_dw_Vbi_ci_Vbi_ci)+(+FCda1_dw_Vbi_ci_Vbi_ci*FCf1+FCda1_dw_Vbi_ci*FCf1_Vbi_ci+FCda1_dw_Vbi_ci*FCf1_Vbi_ci+FCda1_dw*FCf1_Vbi_ci_Vbi_ci))-FCdf2_dw_Vbi_ci_Vbi_ci)+FCdf3_dw_Vbi_ci_Vbi_ci));
#endif
#endif
FCdfc_dw=(FCf_CT*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw));
#if defined(_DERIVATEFORDDX)
FCdw_ditf_Vci_ei=((FCdw_daick_Vci_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vci_ei));
#if defined(_DERIVATE)
  FCdw_ditf_Vci_ei_Vci_ei=(+FCdw_daick_Vci_ei_Vci_ei*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vci_ei+FCdw_daick_Vci_ei*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vci_ei);
  FCdw_ditf_Vci_ei_Vtnode_GND=(+FCdw_daick_Vci_ei_Vtnode_GND*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vtnode_GND+FCdw_daick_Vtnode_GND*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vtnode_GND);
  FCdw_ditf_Vci_ei_Vbi_ei=(+FCdw_daick_Vci_ei_Vbi_ei*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ei+FCdw_daick_Vbi_ei*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vbi_ei);
  FCdw_ditf_Vci_ei_Vbi_ci=(+FCdw_daick_Vci_ei_Vbi_ci*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ci+FCdw_daick_Vbi_ci*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdw_ditf_Vtnode_GND=((FCdw_daick_Vtnode_GND*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vtnode_GND));
#endif
FCdw_ditf_Vbi_ei=((FCdw_daick_Vbi_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ei));
#if defined(_DERIVATE)
  FCdw_ditf_Vbi_ei_Vci_ei=(+FCdw_daick_Vbi_ei_Vci_ei*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vci_ei+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vci_ei);
  FCdw_ditf_Vbi_ei_Vtnode_GND=(+FCdw_daick_Vbi_ei_Vtnode_GND*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vtnode_GND+FCdw_daick_Vtnode_GND*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vtnode_GND);
  FCdw_ditf_Vbi_ei_Vbi_ei=(+FCdw_daick_Vbi_ei_Vbi_ei*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ei+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vbi_ei);
  FCdw_ditf_Vbi_ei_Vbi_ci=(+FCdw_daick_Vbi_ei_Vbi_ci*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ci+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vbi_ci);
#endif
FCdw_ditf_Vbi_ci=((FCdw_daick_Vbi_ci*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ci));
#if defined(_DERIVATE)
  FCdw_ditf_Vbi_ci_Vci_ei=(+FCdw_daick_Vbi_ci_Vci_ei*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vci_ei+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vci_ei);
  FCdw_ditf_Vbi_ci_Vtnode_GND=(+FCdw_daick_Vbi_ci_Vtnode_GND*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vtnode_GND+FCdw_daick_Vtnode_GND*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vtnode_GND);
  FCdw_ditf_Vbi_ci_Vbi_ei=(+FCdw_daick_Vbi_ci_Vbi_ei*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ei+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vbi_ei);
  FCdw_ditf_Vbi_ci_Vbi_ci=(+FCdw_daick_Vbi_ci_Vbi_ci*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ci+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vbi_ci);
#endif
#endif
FCdw_ditf=(FCdw_daick*FCdaick_ditf);
#if defined(_DERIVATEFORDDX)
FCdfc_ditf_Vci_ei=((FCdfc_dw_Vci_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vci_ei));
#if defined(_DERIVATE)
  FCdfc_ditf_Vci_ei_Vci_ei=(+FCdfc_dw_Vci_ei_Vci_ei*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfc_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vci_ei);
  FCdfc_ditf_Vci_ei_Vtnode_GND=(+FCdfc_dw_Vci_ei_Vtnode_GND*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vtnode_GND+FCdfc_dw_Vtnode_GND*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vtnode_GND);
  FCdfc_ditf_Vci_ei_Vbi_ei=(+FCdfc_dw_Vci_ei_Vbi_ei*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfc_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vbi_ei);
  FCdfc_ditf_Vci_ei_Vbi_ci=(+FCdfc_dw_Vci_ei_Vbi_ci*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfc_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdfc_ditf_Vtnode_GND=((FCdfc_dw_Vtnode_GND*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vtnode_GND));
#endif
FCdfc_ditf_Vbi_ei=((FCdfc_dw_Vbi_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ei));
#if defined(_DERIVATE)
  FCdfc_ditf_Vbi_ei_Vci_ei=(+FCdfc_dw_Vbi_ei_Vci_ei*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vci_ei);
  FCdfc_ditf_Vbi_ei_Vtnode_GND=(+FCdfc_dw_Vbi_ei_Vtnode_GND*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vtnode_GND+FCdfc_dw_Vtnode_GND*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vtnode_GND);
  FCdfc_ditf_Vbi_ei_Vbi_ei=(+FCdfc_dw_Vbi_ei_Vbi_ei*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vbi_ei);
  FCdfc_ditf_Vbi_ei_Vbi_ci=(+FCdfc_dw_Vbi_ei_Vbi_ci*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vbi_ci);
#endif
FCdfc_ditf_Vbi_ci=((FCdfc_dw_Vbi_ci*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ci));
#if defined(_DERIVATE)
  FCdfc_ditf_Vbi_ci_Vci_ei=(+FCdfc_dw_Vbi_ci_Vci_ei*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vci_ei);
  FCdfc_ditf_Vbi_ci_Vtnode_GND=(+FCdfc_dw_Vbi_ci_Vtnode_GND*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vtnode_GND+FCdfc_dw_Vtnode_GND*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vtnode_GND);
  FCdfc_ditf_Vbi_ci_Vbi_ei=(+FCdfc_dw_Vbi_ci_Vbi_ei*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vbi_ei);
  FCdfc_ditf_Vbi_ci_Vbi_ci=(+FCdfc_dw_Vbi_ci_Vbi_ci*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vbi_ci);
#endif
#endif
FCdfc_ditf=(FCdfc_dw*FCdw_ditf);
if
(((flcomp==0.0)||(flcomp==2.1)))
{
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=(latb*FCw_Vbi_ei);
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=(latb*FCw_Vbi_ci);
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=(latb*FCw_Vci_ei);
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(latb*FCw_Vtnode_GND);
#endif
#endif
a=(latb*FCw);
{
double m00_logE(d00_logE0,(1+(latb*FCw)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1+(latb*FCw)))
#endif
#if defined(_DERIVATEFORDDX)
lnz_Vci_ei=(latb*FCw_Vci_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vci_ei_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei)));
  lnz_Vci_ei_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND)));
  lnz_Vci_ei_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei)));
  lnz_Vci_ei_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci)));
#endif
#if defined(_DERIVATE)
lnz_Vtnode_GND=(latb*FCw_Vtnode_GND)*d10_logE0;
#endif
lnz_Vbi_ei=(latb*FCw_Vbi_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vbi_ei_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei)));
  lnz_Vbi_ei_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND)));
  lnz_Vbi_ei_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei)));
  lnz_Vbi_ei_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci)));
#endif
lnz_Vbi_ci=(latb*FCw_Vbi_ci)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vbi_ci_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei)));
  lnz_Vbi_ci_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND)));
  lnz_Vbi_ci_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei)));
  lnz_Vbi_ci_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci)));
#endif
#endif
lnz=d00_logE0;
}
if
((a>1.0e-6))
{
#if defined(_DERIVATEFORDDX)
FCf2_Vbi_ei=((a_Vbi_ei-lnz_Vbi_ei)/latb);
#if defined(_DERIVATE)
  FCf2_Vbi_ei_Vbi_ei=((+a_Vbi_ei_Vbi_ei-lnz_Vbi_ei_Vbi_ei)/latb-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vbi_ci=((+a_Vbi_ei_Vbi_ci-lnz_Vbi_ei_Vbi_ci)/latb-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vci_ei=((+a_Vbi_ei_Vci_ei-lnz_Vbi_ei_Vci_ei)/latb-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vtnode_GND=((+a_Vbi_ei_Vtnode_GND-lnz_Vbi_ei_Vtnode_GND)/latb-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
#endif
FCf2_Vbi_ci=((a_Vbi_ci-lnz_Vbi_ci)/latb);
#if defined(_DERIVATE)
  FCf2_Vbi_ci_Vbi_ei=((+a_Vbi_ci_Vbi_ei-lnz_Vbi_ci_Vbi_ei)/latb-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vbi_ci=((+a_Vbi_ci_Vbi_ci-lnz_Vbi_ci_Vbi_ci)/latb-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vci_ei=((+a_Vbi_ci_Vci_ei-lnz_Vbi_ci_Vci_ei)/latb-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vtnode_GND=((+a_Vbi_ci_Vtnode_GND-lnz_Vbi_ci_Vtnode_GND)/latb-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
#endif
FCf2_Vci_ei=((a_Vci_ei-lnz_Vci_ei)/latb);
#if defined(_DERIVATE)
  FCf2_Vci_ei_Vbi_ei=((+a_Vci_ei_Vbi_ei-lnz_Vci_ei_Vbi_ei)/latb-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vbi_ci=((+a_Vci_ei_Vbi_ci-lnz_Vci_ei_Vbi_ci)/latb-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vci_ei=((+a_Vci_ei_Vci_ei-lnz_Vci_ei_Vci_ei)/latb-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vtnode_GND=((+a_Vci_ei_Vtnode_GND-lnz_Vci_ei_Vtnode_GND)/latb-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
#endif
#if defined(_DERIVATE)
FCf2_Vtnode_GND=((a_Vtnode_GND-lnz_Vtnode_GND)/latb);
#endif
#endif
FCf2=((a-lnz)/latb);
#if defined(_DERIVATEFORDDX)
FCdf2_dw_Vci_ei=((a_Vci_ei*(1.0+a)-a*a_Vci_ei)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf2_dw_Vci_ei_Vci_ei=(a_Vci_ei_Vci_ei/(1.0+a)-(a_Vci_ei*a_Vci_ei+a_Vci_ei*a_Vci_ei+a*(+0.0+a_Vci_ei_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vci_ei_Vtnode_GND=(a_Vci_ei_Vtnode_GND/(1.0+a)-(a_Vci_ei*a_Vtnode_GND+a_Vtnode_GND*a_Vci_ei+a*(+0.0+a_Vci_ei_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vci_ei_Vbi_ei=(a_Vci_ei_Vbi_ei/(1.0+a)-(a_Vci_ei*a_Vbi_ei+a_Vbi_ei*a_Vci_ei+a*(+0.0+a_Vci_ei_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vci_ei_Vbi_ci=(a_Vci_ei_Vbi_ci/(1.0+a)-(a_Vci_ei*a_Vbi_ci+a_Vbi_ci*a_Vci_ei+a*(+0.0+a_Vci_ei_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
#if defined(_DERIVATE)
FCdf2_dw_Vtnode_GND=((a_Vtnode_GND*(1.0+a)-a*a_Vtnode_GND)/(1.0+a)/(1.0+a));
#endif
FCdf2_dw_Vbi_ei=((a_Vbi_ei*(1.0+a)-a*a_Vbi_ei)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ei_Vci_ei=(a_Vbi_ei_Vci_ei/(1.0+a)-(a_Vbi_ei*a_Vci_ei+a_Vci_ei*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ei_Vtnode_GND=(a_Vbi_ei_Vtnode_GND/(1.0+a)-(a_Vbi_ei*a_Vtnode_GND+a_Vtnode_GND*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ei_Vbi_ei=(a_Vbi_ei_Vbi_ei/(1.0+a)-(a_Vbi_ei*a_Vbi_ei+a_Vbi_ei*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ei_Vbi_ci=(a_Vbi_ei_Vbi_ci/(1.0+a)-(a_Vbi_ei*a_Vbi_ci+a_Vbi_ci*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
FCdf2_dw_Vbi_ci=((a_Vbi_ci*(1.0+a)-a*a_Vbi_ci)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ci_Vci_ei=(a_Vbi_ci_Vci_ei/(1.0+a)-(a_Vbi_ci*a_Vci_ei+a_Vci_ei*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ci_Vtnode_GND=(a_Vbi_ci_Vtnode_GND/(1.0+a)-(a_Vbi_ci*a_Vtnode_GND+a_Vtnode_GND*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ci_Vbi_ei=(a_Vbi_ci_Vbi_ei/(1.0+a)-(a_Vbi_ci*a_Vbi_ei+a_Vbi_ei*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ci_Vbi_ci=(a_Vbi_ci_Vbi_ci/(1.0+a)-(a_Vbi_ci*a_Vbi_ci+a_Vbi_ci*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
#endif
FCdf2_dw=(a/(1.0+a));
}
else
{
#if defined(_DERIVATEFORDDX)
FCf2_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCf2_Vbi_ei_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vbi_ei)*FCw+(0.5*a_Vbi_ei)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vbi_ei);
  FCf2_Vbi_ei_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vbi_ci)*FCw+(0.5*a_Vbi_ei)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vbi_ci);
  FCf2_Vbi_ei_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vci_ei)*FCw+(0.5*a_Vbi_ei)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vci_ei);
  FCf2_Vbi_ei_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vtnode_GND)*FCw+(0.5*a_Vbi_ei)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vtnode_GND);
#endif
FCf2_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCf2_Vbi_ci_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vbi_ei)*FCw+(0.5*a_Vbi_ci)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vbi_ei);
  FCf2_Vbi_ci_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vbi_ci)*FCw+(0.5*a_Vbi_ci)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vbi_ci);
  FCf2_Vbi_ci_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vci_ei)*FCw+(0.5*a_Vbi_ci)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vci_ei);
  FCf2_Vbi_ci_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vtnode_GND)*FCw+(0.5*a_Vbi_ci)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vtnode_GND);
#endif
FCf2_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCf2_Vci_ei_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.5*a_Vci_ei_Vbi_ei)*FCw+(0.5*a_Vci_ei)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vbi_ei);
  FCf2_Vci_ei_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.5*a_Vci_ei_Vbi_ci)*FCw+(0.5*a_Vci_ei)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vbi_ci);
  FCf2_Vci_ei_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.5*a_Vci_ei_Vci_ei)*FCw+(0.5*a_Vci_ei)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vci_ei);
  FCf2_Vci_ei_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.5*a_Vci_ei_Vtnode_GND)*FCw+(0.5*a_Vci_ei)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCf2_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
#endif
#endif
FCf2=((0.5*a)*FCw);
#if defined(_DERIVATEFORDDX)
FCdf2_dw_Vci_ei=a_Vci_ei;
#if defined(_DERIVATE)
  FCdf2_dw_Vci_ei_Vci_ei=a_Vci_ei_Vci_ei;
  FCdf2_dw_Vci_ei_Vtnode_GND=a_Vci_ei_Vtnode_GND;
  FCdf2_dw_Vci_ei_Vbi_ei=a_Vci_ei_Vbi_ei;
  FCdf2_dw_Vci_ei_Vbi_ci=a_Vci_ei_Vbi_ci;
#endif
#if defined(_DERIVATE)
FCdf2_dw_Vtnode_GND=a_Vtnode_GND;
#endif
FCdf2_dw_Vbi_ei=a_Vbi_ei;
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ei_Vci_ei=a_Vbi_ei_Vci_ei;
  FCdf2_dw_Vbi_ei_Vtnode_GND=a_Vbi_ei_Vtnode_GND;
  FCdf2_dw_Vbi_ei_Vbi_ei=a_Vbi_ei_Vbi_ei;
  FCdf2_dw_Vbi_ei_Vbi_ci=a_Vbi_ei_Vbi_ci;
#endif
FCdf2_dw_Vbi_ci=a_Vbi_ci;
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ci_Vci_ei=a_Vbi_ci_Vci_ei;
  FCdf2_dw_Vbi_ci_Vtnode_GND=a_Vbi_ci_Vtnode_GND;
  FCdf2_dw_Vbi_ci_Vbi_ei=a_Vbi_ci_Vbi_ei;
  FCdf2_dw_Vbi_ci_Vbi_ci=a_Vbi_ci_Vbi_ci;
#endif
#endif
FCdf2_dw=a;
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=(latl*FCw_Vbi_ei);
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=(latl*FCw_Vbi_ci);
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=(latl*FCw_Vci_ei);
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(latl*FCw_Vtnode_GND);
#endif
#endif
a=(latl*FCw);
{
double m00_logE(d00_logE0,(1+(latl*FCw)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1+(latl*FCw)))
#endif
#if defined(_DERIVATEFORDDX)
lnz_Vci_ei=(latl*FCw_Vci_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vci_ei_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei)));
  lnz_Vci_ei_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND)));
  lnz_Vci_ei_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei)));
  lnz_Vci_ei_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci)));
#endif
#if defined(_DERIVATE)
lnz_Vtnode_GND=(latl*FCw_Vtnode_GND)*d10_logE0;
#endif
lnz_Vbi_ei=(latl*FCw_Vbi_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vbi_ei_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei)));
  lnz_Vbi_ei_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND)));
  lnz_Vbi_ei_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei)));
  lnz_Vbi_ei_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci)));
#endif
lnz_Vbi_ci=(latl*FCw_Vbi_ci)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vbi_ci_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei)));
  lnz_Vbi_ci_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND)));
  lnz_Vbi_ci_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei)));
  lnz_Vbi_ci_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci)));
#endif
#endif
lnz=d00_logE0;
}
if
((a>1.0e-6))
{
#if defined(_DERIVATEFORDDX)
FCf3_Vbi_ei=((a_Vbi_ei-lnz_Vbi_ei)/latl);
#if defined(_DERIVATE)
  FCf3_Vbi_ei_Vbi_ei=((+a_Vbi_ei_Vbi_ei-lnz_Vbi_ei_Vbi_ei)/latl-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vbi_ci=((+a_Vbi_ei_Vbi_ci-lnz_Vbi_ei_Vbi_ci)/latl-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vci_ei=((+a_Vbi_ei_Vci_ei-lnz_Vbi_ei_Vci_ei)/latl-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vtnode_GND=((+a_Vbi_ei_Vtnode_GND-lnz_Vbi_ei_Vtnode_GND)/latl-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
#endif
FCf3_Vbi_ci=((a_Vbi_ci-lnz_Vbi_ci)/latl);
#if defined(_DERIVATE)
  FCf3_Vbi_ci_Vbi_ei=((+a_Vbi_ci_Vbi_ei-lnz_Vbi_ci_Vbi_ei)/latl-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vbi_ci=((+a_Vbi_ci_Vbi_ci-lnz_Vbi_ci_Vbi_ci)/latl-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vci_ei=((+a_Vbi_ci_Vci_ei-lnz_Vbi_ci_Vci_ei)/latl-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vtnode_GND=((+a_Vbi_ci_Vtnode_GND-lnz_Vbi_ci_Vtnode_GND)/latl-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
#endif
FCf3_Vci_ei=((a_Vci_ei-lnz_Vci_ei)/latl);
#if defined(_DERIVATE)
  FCf3_Vci_ei_Vbi_ei=((+a_Vci_ei_Vbi_ei-lnz_Vci_ei_Vbi_ei)/latl-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vbi_ci=((+a_Vci_ei_Vbi_ci-lnz_Vci_ei_Vbi_ci)/latl-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vci_ei=((+a_Vci_ei_Vci_ei-lnz_Vci_ei_Vci_ei)/latl-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vtnode_GND=((+a_Vci_ei_Vtnode_GND-lnz_Vci_ei_Vtnode_GND)/latl-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
#endif
#if defined(_DERIVATE)
FCf3_Vtnode_GND=((a_Vtnode_GND-lnz_Vtnode_GND)/latl);
#endif
#endif
FCf3=((a-lnz)/latl);
#if defined(_DERIVATEFORDDX)
FCdf3_dw_Vci_ei=((a_Vci_ei*(1.0+a)-a*a_Vci_ei)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf3_dw_Vci_ei_Vci_ei=(a_Vci_ei_Vci_ei/(1.0+a)-(a_Vci_ei*a_Vci_ei+a_Vci_ei*a_Vci_ei+a*(+0.0+a_Vci_ei_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vci_ei_Vtnode_GND=(a_Vci_ei_Vtnode_GND/(1.0+a)-(a_Vci_ei*a_Vtnode_GND+a_Vtnode_GND*a_Vci_ei+a*(+0.0+a_Vci_ei_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vci_ei_Vbi_ei=(a_Vci_ei_Vbi_ei/(1.0+a)-(a_Vci_ei*a_Vbi_ei+a_Vbi_ei*a_Vci_ei+a*(+0.0+a_Vci_ei_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vci_ei_Vbi_ci=(a_Vci_ei_Vbi_ci/(1.0+a)-(a_Vci_ei*a_Vbi_ci+a_Vbi_ci*a_Vci_ei+a*(+0.0+a_Vci_ei_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
#if defined(_DERIVATE)
FCdf3_dw_Vtnode_GND=((a_Vtnode_GND*(1.0+a)-a*a_Vtnode_GND)/(1.0+a)/(1.0+a));
#endif
FCdf3_dw_Vbi_ei=((a_Vbi_ei*(1.0+a)-a*a_Vbi_ei)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ei_Vci_ei=(a_Vbi_ei_Vci_ei/(1.0+a)-(a_Vbi_ei*a_Vci_ei+a_Vci_ei*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ei_Vtnode_GND=(a_Vbi_ei_Vtnode_GND/(1.0+a)-(a_Vbi_ei*a_Vtnode_GND+a_Vtnode_GND*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ei_Vbi_ei=(a_Vbi_ei_Vbi_ei/(1.0+a)-(a_Vbi_ei*a_Vbi_ei+a_Vbi_ei*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ei_Vbi_ci=(a_Vbi_ei_Vbi_ci/(1.0+a)-(a_Vbi_ei*a_Vbi_ci+a_Vbi_ci*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
FCdf3_dw_Vbi_ci=((a_Vbi_ci*(1.0+a)-a*a_Vbi_ci)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ci_Vci_ei=(a_Vbi_ci_Vci_ei/(1.0+a)-(a_Vbi_ci*a_Vci_ei+a_Vci_ei*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ci_Vtnode_GND=(a_Vbi_ci_Vtnode_GND/(1.0+a)-(a_Vbi_ci*a_Vtnode_GND+a_Vtnode_GND*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ci_Vbi_ei=(a_Vbi_ci_Vbi_ei/(1.0+a)-(a_Vbi_ci*a_Vbi_ei+a_Vbi_ei*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ci_Vbi_ci=(a_Vbi_ci_Vbi_ci/(1.0+a)-(a_Vbi_ci*a_Vbi_ci+a_Vbi_ci*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
#endif
FCdf3_dw=(a/(1.0+a));
}
else
{
#if defined(_DERIVATEFORDDX)
FCf3_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCf3_Vbi_ei_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vbi_ei)*FCw+(0.5*a_Vbi_ei)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vbi_ei);
  FCf3_Vbi_ei_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vbi_ci)*FCw+(0.5*a_Vbi_ei)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vbi_ci);
  FCf3_Vbi_ei_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vci_ei)*FCw+(0.5*a_Vbi_ei)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vci_ei);
  FCf3_Vbi_ei_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vtnode_GND)*FCw+(0.5*a_Vbi_ei)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vtnode_GND);
#endif
FCf3_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCf3_Vbi_ci_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vbi_ei)*FCw+(0.5*a_Vbi_ci)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vbi_ei);
  FCf3_Vbi_ci_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vbi_ci)*FCw+(0.5*a_Vbi_ci)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vbi_ci);
  FCf3_Vbi_ci_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vci_ei)*FCw+(0.5*a_Vbi_ci)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vci_ei);
  FCf3_Vbi_ci_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vtnode_GND)*FCw+(0.5*a_Vbi_ci)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vtnode_GND);
#endif
FCf3_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCf3_Vci_ei_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.5*a_Vci_ei_Vbi_ei)*FCw+(0.5*a_Vci_ei)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vbi_ei);
  FCf3_Vci_ei_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.5*a_Vci_ei_Vbi_ci)*FCw+(0.5*a_Vci_ei)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vbi_ci);
  FCf3_Vci_ei_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.5*a_Vci_ei_Vci_ei)*FCw+(0.5*a_Vci_ei)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vci_ei);
  FCf3_Vci_ei_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.5*a_Vci_ei_Vtnode_GND)*FCw+(0.5*a_Vci_ei)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCf3_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
#endif
#endif
FCf3=((0.5*a)*FCw);
#if defined(_DERIVATEFORDDX)
FCdf3_dw_Vci_ei=a_Vci_ei;
#if defined(_DERIVATE)
  FCdf3_dw_Vci_ei_Vci_ei=a_Vci_ei_Vci_ei;
  FCdf3_dw_Vci_ei_Vtnode_GND=a_Vci_ei_Vtnode_GND;
  FCdf3_dw_Vci_ei_Vbi_ei=a_Vci_ei_Vbi_ei;
  FCdf3_dw_Vci_ei_Vbi_ci=a_Vci_ei_Vbi_ci;
#endif
#if defined(_DERIVATE)
FCdf3_dw_Vtnode_GND=a_Vtnode_GND;
#endif
FCdf3_dw_Vbi_ei=a_Vbi_ei;
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ei_Vci_ei=a_Vbi_ei_Vci_ei;
  FCdf3_dw_Vbi_ei_Vtnode_GND=a_Vbi_ei_Vtnode_GND;
  FCdf3_dw_Vbi_ei_Vbi_ei=a_Vbi_ei_Vbi_ei;
  FCdf3_dw_Vbi_ei_Vbi_ci=a_Vbi_ei_Vbi_ci;
#endif
FCdf3_dw_Vbi_ci=a_Vbi_ci;
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ci_Vci_ei=a_Vbi_ci_Vci_ei;
  FCdf3_dw_Vbi_ci_Vtnode_GND=a_Vbi_ci_Vtnode_GND;
  FCdf3_dw_Vbi_ci_Vbi_ei=a_Vbi_ci_Vbi_ei;
  FCdf3_dw_Vbi_ci_Vbi_ci=a_Vbi_ci_Vbi_ci;
#endif
#endif
FCdf3_dw=a;
}
#if defined(_DERIVATEFORDDX)
FCf_CT_Vbi_ei=((FCf_CT_Vbi_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ei-FCf3_Vbi_ei)));
#if defined(_DERIVATE)
  FCf_CT_Vbi_ei_Vbi_ei=(+FCf_CT_Vbi_ei_Vbi_ei*(FCf2-FCf3)+FCf_CT_Vbi_ei*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT_Vbi_ei*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT*(+FCf2_Vbi_ei_Vbi_ei-FCf3_Vbi_ei_Vbi_ei));
  FCf_CT_Vbi_ei_Vbi_ci=(+FCf_CT_Vbi_ei_Vbi_ci*(FCf2-FCf3)+FCf_CT_Vbi_ei*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT_Vbi_ci*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT*(+FCf2_Vbi_ei_Vbi_ci-FCf3_Vbi_ei_Vbi_ci));
  FCf_CT_Vbi_ei_Vci_ei=(+FCf_CT_Vbi_ei_Vci_ei*(FCf2-FCf3)+FCf_CT_Vbi_ei*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT_Vci_ei*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT*(+FCf2_Vbi_ei_Vci_ei-FCf3_Vbi_ei_Vci_ei));
  FCf_CT_Vbi_ei_Vtnode_GND=(+FCf_CT_Vbi_ei_Vtnode_GND*(FCf2-FCf3)+FCf_CT_Vbi_ei*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT*(+FCf2_Vbi_ei_Vtnode_GND-FCf3_Vbi_ei_Vtnode_GND));
#endif
FCf_CT_Vbi_ci=((FCf_CT_Vbi_ci*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ci-FCf3_Vbi_ci)));
#if defined(_DERIVATE)
  FCf_CT_Vbi_ci_Vbi_ei=(+FCf_CT_Vbi_ci_Vbi_ei*(FCf2-FCf3)+FCf_CT_Vbi_ci*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT_Vbi_ei*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT*(+FCf2_Vbi_ci_Vbi_ei-FCf3_Vbi_ci_Vbi_ei));
  FCf_CT_Vbi_ci_Vbi_ci=(+FCf_CT_Vbi_ci_Vbi_ci*(FCf2-FCf3)+FCf_CT_Vbi_ci*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT_Vbi_ci*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT*(+FCf2_Vbi_ci_Vbi_ci-FCf3_Vbi_ci_Vbi_ci));
  FCf_CT_Vbi_ci_Vci_ei=(+FCf_CT_Vbi_ci_Vci_ei*(FCf2-FCf3)+FCf_CT_Vbi_ci*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT_Vci_ei*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT*(+FCf2_Vbi_ci_Vci_ei-FCf3_Vbi_ci_Vci_ei));
  FCf_CT_Vbi_ci_Vtnode_GND=(+FCf_CT_Vbi_ci_Vtnode_GND*(FCf2-FCf3)+FCf_CT_Vbi_ci*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT*(+FCf2_Vbi_ci_Vtnode_GND-FCf3_Vbi_ci_Vtnode_GND));
#endif
FCf_CT_Vci_ei=((FCf_CT_Vci_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vci_ei-FCf3_Vci_ei)));
#if defined(_DERIVATE)
  FCf_CT_Vci_ei_Vbi_ei=(+FCf_CT_Vci_ei_Vbi_ei*(FCf2-FCf3)+FCf_CT_Vci_ei*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT_Vbi_ei*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT*(+FCf2_Vci_ei_Vbi_ei-FCf3_Vci_ei_Vbi_ei));
  FCf_CT_Vci_ei_Vbi_ci=(+FCf_CT_Vci_ei_Vbi_ci*(FCf2-FCf3)+FCf_CT_Vci_ei*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT_Vbi_ci*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT*(+FCf2_Vci_ei_Vbi_ci-FCf3_Vci_ei_Vbi_ci));
  FCf_CT_Vci_ei_Vci_ei=(+FCf_CT_Vci_ei_Vci_ei*(FCf2-FCf3)+FCf_CT_Vci_ei*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT_Vci_ei*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT*(+FCf2_Vci_ei_Vci_ei-FCf3_Vci_ei_Vci_ei));
  FCf_CT_Vci_ei_Vtnode_GND=(+FCf_CT_Vci_ei_Vtnode_GND*(FCf2-FCf3)+FCf_CT_Vci_ei*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT*(+FCf2_Vci_ei_Vtnode_GND-FCf3_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
FCf_CT_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCf2-FCf3))+(FCf_CT*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)));
#endif
#endif
FCf_CT=(FCf_CT*(FCf2-FCf3));
#if defined(_DERIVATEFORDDX)
FCdfCT_dw_Vbi_ei=((FCf_CT_Vbi_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)));
#if defined(_DERIVATE)
  FCdfCT_dw_Vbi_ei_Vbi_ei=(+FCf_CT_Vbi_ei_Vbi_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ei*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT*(+FCdf2_dw_Vbi_ei_Vbi_ei-FCdf3_dw_Vbi_ei_Vbi_ei));
  FCdfCT_dw_Vbi_ei_Vbi_ci=(+FCf_CT_Vbi_ei_Vbi_ci*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ei*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT*(+FCdf2_dw_Vbi_ei_Vbi_ci-FCdf3_dw_Vbi_ei_Vbi_ci));
  FCdfCT_dw_Vbi_ei_Vci_ei=(+FCf_CT_Vbi_ei_Vci_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ei*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT*(+FCdf2_dw_Vbi_ei_Vci_ei-FCdf3_dw_Vbi_ei_Vci_ei));
  FCdfCT_dw_Vbi_ei_Vtnode_GND=(+FCf_CT_Vbi_ei_Vtnode_GND*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ei*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT*(+FCdf2_dw_Vbi_ei_Vtnode_GND-FCdf3_dw_Vbi_ei_Vtnode_GND));
#endif
FCdfCT_dw_Vbi_ci=((FCf_CT_Vbi_ci*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)));
#if defined(_DERIVATE)
  FCdfCT_dw_Vbi_ci_Vbi_ei=(+FCf_CT_Vbi_ci_Vbi_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ci*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT*(+FCdf2_dw_Vbi_ci_Vbi_ei-FCdf3_dw_Vbi_ci_Vbi_ei));
  FCdfCT_dw_Vbi_ci_Vbi_ci=(+FCf_CT_Vbi_ci_Vbi_ci*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ci*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT*(+FCdf2_dw_Vbi_ci_Vbi_ci-FCdf3_dw_Vbi_ci_Vbi_ci));
  FCdfCT_dw_Vbi_ci_Vci_ei=(+FCf_CT_Vbi_ci_Vci_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ci*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT*(+FCdf2_dw_Vbi_ci_Vci_ei-FCdf3_dw_Vbi_ci_Vci_ei));
  FCdfCT_dw_Vbi_ci_Vtnode_GND=(+FCf_CT_Vbi_ci_Vtnode_GND*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ci*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT*(+FCdf2_dw_Vbi_ci_Vtnode_GND-FCdf3_dw_Vbi_ci_Vtnode_GND));
#endif
FCdfCT_dw_Vci_ei=((FCf_CT_Vci_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)));
#if defined(_DERIVATE)
  FCdfCT_dw_Vci_ei_Vbi_ei=(+FCf_CT_Vci_ei_Vbi_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vci_ei*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT*(+FCdf2_dw_Vci_ei_Vbi_ei-FCdf3_dw_Vci_ei_Vbi_ei));
  FCdfCT_dw_Vci_ei_Vbi_ci=(+FCf_CT_Vci_ei_Vbi_ci*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vci_ei*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT*(+FCdf2_dw_Vci_ei_Vbi_ci-FCdf3_dw_Vci_ei_Vbi_ci));
  FCdfCT_dw_Vci_ei_Vci_ei=(+FCf_CT_Vci_ei_Vci_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vci_ei*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT*(+FCdf2_dw_Vci_ei_Vci_ei-FCdf3_dw_Vci_ei_Vci_ei));
  FCdfCT_dw_Vci_ei_Vtnode_GND=(+FCf_CT_Vci_ei_Vtnode_GND*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vci_ei*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT*(+FCdf2_dw_Vci_ei_Vtnode_GND-FCdf3_dw_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
FCdfCT_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)));
#endif
#endif
FCdfCT_dw=(FCf_CT*(FCdf2_dw-FCdf3_dw));
#if defined(_DERIVATEFORDDX)
FCdfCT_ditf_Vbi_ei=((FCdfCT_dw_Vbi_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ei));
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ei_Vbi_ei=(+FCdfCT_dw_Vbi_ei_Vbi_ei*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vbi_ei);
  FCdfCT_ditf_Vbi_ei_Vbi_ci=(+FCdfCT_dw_Vbi_ei_Vbi_ci*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vbi_ci);
  FCdfCT_ditf_Vbi_ei_Vci_ei=(+FCdfCT_dw_Vbi_ei_Vci_ei*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vci_ei);
  FCdfCT_ditf_Vbi_ei_Vtnode_GND=(+FCdfCT_dw_Vbi_ei_Vtnode_GND*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vtnode_GND+FCdfCT_dw_Vtnode_GND*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vtnode_GND);
#endif
FCdfCT_ditf_Vbi_ci=((FCdfCT_dw_Vbi_ci*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ci));
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ci_Vbi_ei=(+FCdfCT_dw_Vbi_ci_Vbi_ei*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vbi_ei);
  FCdfCT_ditf_Vbi_ci_Vbi_ci=(+FCdfCT_dw_Vbi_ci_Vbi_ci*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vbi_ci);
  FCdfCT_ditf_Vbi_ci_Vci_ei=(+FCdfCT_dw_Vbi_ci_Vci_ei*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vci_ei);
  FCdfCT_ditf_Vbi_ci_Vtnode_GND=(+FCdfCT_dw_Vbi_ci_Vtnode_GND*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vtnode_GND+FCdfCT_dw_Vtnode_GND*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vtnode_GND);
#endif
FCdfCT_ditf_Vci_ei=((FCdfCT_dw_Vci_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vci_ei));
#if defined(_DERIVATE)
  FCdfCT_ditf_Vci_ei_Vbi_ei=(+FCdfCT_dw_Vci_ei_Vbi_ei*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vbi_ei);
  FCdfCT_ditf_Vci_ei_Vbi_ci=(+FCdfCT_dw_Vci_ei_Vbi_ci*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vbi_ci);
  FCdfCT_ditf_Vci_ei_Vci_ei=(+FCdfCT_dw_Vci_ei_Vci_ei*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfCT_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vci_ei);
  FCdfCT_ditf_Vci_ei_Vtnode_GND=(+FCdfCT_dw_Vci_ei_Vtnode_GND*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vtnode_GND+FCdfCT_dw_Vtnode_GND*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCdfCT_ditf_Vtnode_GND=((FCdfCT_dw_Vtnode_GND*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vtnode_GND));
#endif
#endif
FCdfCT_ditf=(FCdfCT_dw*FCdw_ditf);
}
else
{
#if defined(_DERIVATEFORDDX)
FCf_CT_Vbi_ei=FCf_ci_Vbi_ei;
#if defined(_DERIVATE)
  FCf_CT_Vbi_ei_Vbi_ei=FCf_ci_Vbi_ei_Vbi_ei;
  FCf_CT_Vbi_ei_Vbi_ci=FCf_ci_Vbi_ei_Vbi_ci;
  FCf_CT_Vbi_ei_Vci_ei=FCf_ci_Vbi_ei_Vci_ei;
  FCf_CT_Vbi_ei_Vtnode_GND=FCf_ci_Vbi_ei_Vtnode_GND;
#endif
FCf_CT_Vbi_ci=FCf_ci_Vbi_ci;
#if defined(_DERIVATE)
  FCf_CT_Vbi_ci_Vbi_ei=FCf_ci_Vbi_ci_Vbi_ei;
  FCf_CT_Vbi_ci_Vbi_ci=FCf_ci_Vbi_ci_Vbi_ci;
  FCf_CT_Vbi_ci_Vci_ei=FCf_ci_Vbi_ci_Vci_ei;
  FCf_CT_Vbi_ci_Vtnode_GND=FCf_ci_Vbi_ci_Vtnode_GND;
#endif
FCf_CT_Vci_ei=FCf_ci_Vci_ei;
#if defined(_DERIVATE)
  FCf_CT_Vci_ei_Vbi_ei=FCf_ci_Vci_ei_Vbi_ei;
  FCf_CT_Vci_ei_Vbi_ci=FCf_ci_Vci_ei_Vbi_ci;
  FCf_CT_Vci_ei_Vci_ei=FCf_ci_Vci_ei_Vci_ei;
  FCf_CT_Vci_ei_Vtnode_GND=FCf_ci_Vci_ei_Vtnode_GND;
#endif
#if defined(_DERIVATE)
FCf_CT_Vtnode_GND=FCf_ci_Vtnode_GND;
#endif
#endif
FCf_CT=FCf_ci;
#if defined(_DERIVATEFORDDX)
FCdfCT_ditf_Vbi_ei=FCdfc_ditf_Vbi_ei;
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ei_Vbi_ei=FCdfc_ditf_Vbi_ei_Vbi_ei;
  FCdfCT_ditf_Vbi_ei_Vbi_ci=FCdfc_ditf_Vbi_ei_Vbi_ci;
  FCdfCT_ditf_Vbi_ei_Vci_ei=FCdfc_ditf_Vbi_ei_Vci_ei;
  FCdfCT_ditf_Vbi_ei_Vtnode_GND=FCdfc_ditf_Vbi_ei_Vtnode_GND;
#endif
FCdfCT_ditf_Vbi_ci=FCdfc_ditf_Vbi_ci;
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ci_Vbi_ei=FCdfc_ditf_Vbi_ci_Vbi_ei;
  FCdfCT_ditf_Vbi_ci_Vbi_ci=FCdfc_ditf_Vbi_ci_Vbi_ci;
  FCdfCT_ditf_Vbi_ci_Vci_ei=FCdfc_ditf_Vbi_ci_Vci_ei;
  FCdfCT_ditf_Vbi_ci_Vtnode_GND=FCdfc_ditf_Vbi_ci_Vtnode_GND;
#endif
FCdfCT_ditf_Vci_ei=FCdfc_ditf_Vci_ei;
#if defined(_DERIVATE)
  FCdfCT_ditf_Vci_ei_Vbi_ei=FCdfc_ditf_Vci_ei_Vbi_ei;
  FCdfCT_ditf_Vci_ei_Vbi_ci=FCdfc_ditf_Vci_ei_Vbi_ci;
  FCdfCT_ditf_Vci_ei_Vci_ei=FCdfc_ditf_Vci_ei_Vci_ei;
  FCdfCT_ditf_Vci_ei_Vtnode_GND=FCdfc_ditf_Vci_ei_Vtnode_GND;
#endif
#if defined(_DERIVATE)
FCdfCT_ditf_Vtnode_GND=FCdfc_ditf_Vtnode_GND;
#endif
#endif
FCdfCT_ditf=FCdfc_ditf;
}
}
else
{
if
((latb>0.01))
{
#if defined(_DERIVATEFORDDX)
FCd_a_Vci_ei=(-FCa_ck_Vci_ei*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vci_ei_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vci_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vtnode_GND*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vbi_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vbi_ci*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
#if defined(_DERIVATE)
FCd_a_Vtnode_GND=(-FCa_ck_Vtnode_GND*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
FCd_a_Vbi_ei=(-FCa_ck_Vbi_ei*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ei_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vci_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vtnode_GND*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vbi_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vbi_ci*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
FCd_a_Vbi_ci=(-FCa_ck_Vbi_ci*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ci_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vci_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vtnode_GND*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vbi_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vbi_ci*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
#endif
FCd_a=(1.0/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATEFORDDX)
FCw_Vci_ei=(((-FCa_ck_Vci_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCw_Vci_ei_Vci_ei=(+(+0.0-FCa_ck_Vci_ei_Vci_ei)*FCd_a+(-FCa_ck_Vci_ei)*FCd_a_Vci_ei+(-FCa_ck_Vci_ei)*FCd_a_Vci_ei+(1.0-FCa_ck)*FCd_a_Vci_ei_Vci_ei);
  FCw_Vci_ei_Vtnode_GND=(+(+0.0-FCa_ck_Vci_ei_Vtnode_GND)*FCd_a+(-FCa_ck_Vci_ei)*FCd_a_Vtnode_GND+(-FCa_ck_Vtnode_GND)*FCd_a_Vci_ei+(1.0-FCa_ck)*FCd_a_Vci_ei_Vtnode_GND);
  FCw_Vci_ei_Vbi_ei=(+(+0.0-FCa_ck_Vci_ei_Vbi_ei)*FCd_a+(-FCa_ck_Vci_ei)*FCd_a_Vbi_ei+(-FCa_ck_Vbi_ei)*FCd_a_Vci_ei+(1.0-FCa_ck)*FCd_a_Vci_ei_Vbi_ei);
  FCw_Vci_ei_Vbi_ci=(+(+0.0-FCa_ck_Vci_ei_Vbi_ci)*FCd_a+(-FCa_ck_Vci_ei)*FCd_a_Vbi_ci+(-FCa_ck_Vbi_ci)*FCd_a_Vci_ei+(1.0-FCa_ck)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw_Vtnode_GND=(((-FCa_ck_Vtnode_GND)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vtnode_GND));
#endif
FCw_Vbi_ei=(((-FCa_ck_Vbi_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCw_Vbi_ei_Vci_ei=(+(+0.0-FCa_ck_Vbi_ei_Vci_ei)*FCd_a+(-FCa_ck_Vbi_ei)*FCd_a_Vci_ei+(-FCa_ck_Vci_ei)*FCd_a_Vbi_ei+(1.0-FCa_ck)*FCd_a_Vbi_ei_Vci_ei);
  FCw_Vbi_ei_Vtnode_GND=(+(+0.0-FCa_ck_Vbi_ei_Vtnode_GND)*FCd_a+(-FCa_ck_Vbi_ei)*FCd_a_Vtnode_GND+(-FCa_ck_Vtnode_GND)*FCd_a_Vbi_ei+(1.0-FCa_ck)*FCd_a_Vbi_ei_Vtnode_GND);
  FCw_Vbi_ei_Vbi_ei=(+(+0.0-FCa_ck_Vbi_ei_Vbi_ei)*FCd_a+(-FCa_ck_Vbi_ei)*FCd_a_Vbi_ei+(-FCa_ck_Vbi_ei)*FCd_a_Vbi_ei+(1.0-FCa_ck)*FCd_a_Vbi_ei_Vbi_ei);
  FCw_Vbi_ei_Vbi_ci=(+(+0.0-FCa_ck_Vbi_ei_Vbi_ci)*FCd_a+(-FCa_ck_Vbi_ei)*FCd_a_Vbi_ci+(-FCa_ck_Vbi_ci)*FCd_a_Vbi_ei+(1.0-FCa_ck)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCw_Vbi_ci=(((-FCa_ck_Vbi_ci)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCw_Vbi_ci_Vci_ei=(+(+0.0-FCa_ck_Vbi_ci_Vci_ei)*FCd_a+(-FCa_ck_Vbi_ci)*FCd_a_Vci_ei+(-FCa_ck_Vci_ei)*FCd_a_Vbi_ci+(1.0-FCa_ck)*FCd_a_Vbi_ci_Vci_ei);
  FCw_Vbi_ci_Vtnode_GND=(+(+0.0-FCa_ck_Vbi_ci_Vtnode_GND)*FCd_a+(-FCa_ck_Vbi_ci)*FCd_a_Vtnode_GND+(-FCa_ck_Vtnode_GND)*FCd_a_Vbi_ci+(1.0-FCa_ck)*FCd_a_Vbi_ci_Vtnode_GND);
  FCw_Vbi_ci_Vbi_ei=(+(+0.0-FCa_ck_Vbi_ci_Vbi_ei)*FCd_a+(-FCa_ck_Vbi_ci)*FCd_a_Vbi_ei+(-FCa_ck_Vbi_ei)*FCd_a_Vbi_ci+(1.0-FCa_ck)*FCd_a_Vbi_ci_Vbi_ei);
  FCw_Vbi_ci_Vbi_ci=(+(+0.0-FCa_ck_Vbi_ci_Vbi_ci)*FCd_a+(-FCa_ck_Vbi_ci)*FCd_a_Vbi_ci+(-FCa_ck_Vbi_ci)*FCd_a_Vbi_ci+(1.0-FCa_ck)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCw=((1.0-FCa_ck)*FCd_a);
#if defined(_DERIVATEFORDDX)
FCdw_daick_Vci_ei=((((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vci_ei_Vci_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vci_ei+(-(1.0+latb))*FCd_a_Vci_ei_Vci_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a_Vci_ei+(((-(1.0+latb))*FCd_a_Vci_ei))*FCd_a_Vci_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei_Vci_ei);
  FCdw_daick_Vci_ei_Vtnode_GND=(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vci_ei+(-(1.0+latb))*FCd_a_Vci_ei_Vtnode_GND)*FCd_a+((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a_Vtnode_GND+(((-(1.0+latb))*FCd_a_Vtnode_GND))*FCd_a_Vci_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei_Vtnode_GND);
  FCdw_daick_Vci_ei_Vbi_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vci_ei+(-(1.0+latb))*FCd_a_Vci_ei_Vbi_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a_Vbi_ei+(((-(1.0+latb))*FCd_a_Vbi_ei))*FCd_a_Vci_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei_Vbi_ei);
  FCdw_daick_Vci_ei_Vbi_ci=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vci_ei+(-(1.0+latb))*FCd_a_Vci_ei_Vbi_ci)*FCd_a+((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a_Vbi_ci+(((-(1.0+latb))*FCd_a_Vbi_ci))*FCd_a_Vci_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdw_daick_Vtnode_GND=((((-(1.0+latb))*FCd_a_Vtnode_GND)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vtnode_GND));
#endif
FCdw_daick_Vbi_ei=((((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ei_Vci_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vbi_ei+(-(1.0+latb))*FCd_a_Vbi_ei_Vci_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a_Vci_ei+(((-(1.0+latb))*FCd_a_Vci_ei))*FCd_a_Vbi_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei_Vci_ei);
  FCdw_daick_Vbi_ei_Vtnode_GND=(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vbi_ei+(-(1.0+latb))*FCd_a_Vbi_ei_Vtnode_GND)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a_Vtnode_GND+(((-(1.0+latb))*FCd_a_Vtnode_GND))*FCd_a_Vbi_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei_Vtnode_GND);
  FCdw_daick_Vbi_ei_Vbi_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vbi_ei+(-(1.0+latb))*FCd_a_Vbi_ei_Vbi_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a_Vbi_ei+(((-(1.0+latb))*FCd_a_Vbi_ei))*FCd_a_Vbi_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei_Vbi_ei);
  FCdw_daick_Vbi_ei_Vbi_ci=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vbi_ei+(-(1.0+latb))*FCd_a_Vbi_ei_Vbi_ci)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a_Vbi_ci+(((-(1.0+latb))*FCd_a_Vbi_ci))*FCd_a_Vbi_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCdw_daick_Vbi_ci=((((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ci_Vci_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vbi_ci+(-(1.0+latb))*FCd_a_Vbi_ci_Vci_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a_Vci_ei+(((-(1.0+latb))*FCd_a_Vci_ei))*FCd_a_Vbi_ci+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci_Vci_ei);
  FCdw_daick_Vbi_ci_Vtnode_GND=(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vbi_ci+(-(1.0+latb))*FCd_a_Vbi_ci_Vtnode_GND)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a_Vtnode_GND+(((-(1.0+latb))*FCd_a_Vtnode_GND))*FCd_a_Vbi_ci+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci_Vtnode_GND);
  FCdw_daick_Vbi_ci_Vbi_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vbi_ci+(-(1.0+latb))*FCd_a_Vbi_ci_Vbi_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a_Vbi_ei+(((-(1.0+latb))*FCd_a_Vbi_ei))*FCd_a_Vbi_ci+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci_Vbi_ei);
  FCdw_daick_Vbi_ci_Vbi_ci=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vbi_ci+(-(1.0+latb))*FCd_a_Vbi_ci_Vbi_ci)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a_Vbi_ci+(((-(1.0+latb))*FCd_a_Vbi_ci))*FCd_a_Vbi_ci+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCdw_daick=(((-(1.0+latb))*FCd_a)*FCd_a);
}
else
{
#if defined(_DERIVATEFORDDX)
FCw_Vci_ei=((-FCa_ck_Vci_ei)-FCa_ck_Vci_ei*latb);
#if defined(_DERIVATE)
  FCw_Vci_ei_Vci_ei=(+(+0.0-FCa_ck_Vci_ei_Vci_ei)-(+FCa_ck_Vci_ei_Vci_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0));
  FCw_Vci_ei_Vtnode_GND=(+(+0.0-FCa_ck_Vci_ei_Vtnode_GND)-(+FCa_ck_Vci_ei_Vtnode_GND*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0));
  FCw_Vci_ei_Vbi_ei=(+(+0.0-FCa_ck_Vci_ei_Vbi_ei)-(+FCa_ck_Vci_ei_Vbi_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0));
  FCw_Vci_ei_Vbi_ci=(+(+0.0-FCa_ck_Vci_ei_Vbi_ci)-(+FCa_ck_Vci_ei_Vbi_ci*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0));
#endif
#if defined(_DERIVATE)
FCw_Vtnode_GND=((-FCa_ck_Vtnode_GND)-FCa_ck_Vtnode_GND*latb);
#endif
FCw_Vbi_ei=((-FCa_ck_Vbi_ei)-FCa_ck_Vbi_ei*latb);
#if defined(_DERIVATE)
  FCw_Vbi_ei_Vci_ei=(+(+0.0-FCa_ck_Vbi_ei_Vci_ei)-(+FCa_ck_Vbi_ei_Vci_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0));
  FCw_Vbi_ei_Vtnode_GND=(+(+0.0-FCa_ck_Vbi_ei_Vtnode_GND)-(+FCa_ck_Vbi_ei_Vtnode_GND*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0));
  FCw_Vbi_ei_Vbi_ei=(+(+0.0-FCa_ck_Vbi_ei_Vbi_ei)-(+FCa_ck_Vbi_ei_Vbi_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0));
  FCw_Vbi_ei_Vbi_ci=(+(+0.0-FCa_ck_Vbi_ei_Vbi_ci)-(+FCa_ck_Vbi_ei_Vbi_ci*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0));
#endif
FCw_Vbi_ci=((-FCa_ck_Vbi_ci)-FCa_ck_Vbi_ci*latb);
#if defined(_DERIVATE)
  FCw_Vbi_ci_Vci_ei=(+(+0.0-FCa_ck_Vbi_ci_Vci_ei)-(+FCa_ck_Vbi_ci_Vci_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0));
  FCw_Vbi_ci_Vtnode_GND=(+(+0.0-FCa_ck_Vbi_ci_Vtnode_GND)-(+FCa_ck_Vbi_ci_Vtnode_GND*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0));
  FCw_Vbi_ci_Vbi_ei=(+(+0.0-FCa_ck_Vbi_ci_Vbi_ei)-(+FCa_ck_Vbi_ci_Vbi_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0));
  FCw_Vbi_ci_Vbi_ci=(+(+0.0-FCa_ck_Vbi_ci_Vbi_ci)-(+FCa_ck_Vbi_ci_Vbi_ci*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0));
#endif
#endif
FCw=((1.0-FCa_ck)-(FCa_ck*latb));
#if defined(_DERIVATEFORDDX)
FCdw_daick_Vci_ei=0.0;
#if defined(_DERIVATE)
  FCdw_daick_Vci_ei_Vci_ei=0.0;
  FCdw_daick_Vci_ei_Vtnode_GND=0.0;
  FCdw_daick_Vci_ei_Vbi_ei=0.0;
  FCdw_daick_Vci_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
FCdw_daick_Vtnode_GND=0.0;
#endif
FCdw_daick_Vbi_ei=0.0;
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ei_Vci_ei=0.0;
  FCdw_daick_Vbi_ei_Vtnode_GND=0.0;
  FCdw_daick_Vbi_ei_Vbi_ei=0.0;
  FCdw_daick_Vbi_ei_Vbi_ci=0.0;
#endif
FCdw_daick_Vbi_ci=0.0;
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ci_Vci_ei=0.0;
  FCdw_daick_Vbi_ci_Vtnode_GND=0.0;
  FCdw_daick_Vbi_ci_Vbi_ei=0.0;
  FCdw_daick_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
FCdw_daick=(-(1.0+latb));
}
#if defined(_DERIVATEFORDDX)
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCw2_Vci_ei_Vci_ei=(+FCw_Vci_ei_Vci_ei*FCw+FCw_Vci_ei*FCw_Vci_ei+FCw_Vci_ei*FCw_Vci_ei+FCw*FCw_Vci_ei_Vci_ei);
  FCw2_Vci_ei_Vtnode_GND=(+FCw_Vci_ei_Vtnode_GND*FCw+FCw_Vci_ei*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vci_ei+FCw*FCw_Vci_ei_Vtnode_GND);
  FCw2_Vci_ei_Vbi_ei=(+FCw_Vci_ei_Vbi_ei*FCw+FCw_Vci_ei*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vci_ei+FCw*FCw_Vci_ei_Vbi_ei);
  FCw2_Vci_ei_Vbi_ci=(+FCw_Vci_ei_Vbi_ci*FCw+FCw_Vci_ei*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vci_ei+FCw*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
#endif
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCw2_Vbi_ei_Vci_ei=(+FCw_Vbi_ei_Vci_ei*FCw+FCw_Vbi_ei*FCw_Vci_ei+FCw_Vci_ei*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vci_ei);
  FCw2_Vbi_ei_Vtnode_GND=(+FCw_Vbi_ei_Vtnode_GND*FCw+FCw_Vbi_ei*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vtnode_GND);
  FCw2_Vbi_ei_Vbi_ei=(+FCw_Vbi_ei_Vbi_ei*FCw+FCw_Vbi_ei*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vbi_ei);
  FCw2_Vbi_ei_Vbi_ci=(+FCw_Vbi_ei_Vbi_ci*FCw+FCw_Vbi_ei*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vbi_ci);
#endif
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCw2_Vbi_ci_Vci_ei=(+FCw_Vbi_ci_Vci_ei*FCw+FCw_Vbi_ci*FCw_Vci_ei+FCw_Vci_ei*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vci_ei);
  FCw2_Vbi_ci_Vtnode_GND=(+FCw_Vbi_ci_Vtnode_GND*FCw+FCw_Vbi_ci*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vtnode_GND);
  FCw2_Vbi_ci_Vbi_ei=(+FCw_Vbi_ci_Vbi_ei*FCw+FCw_Vbi_ci*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vbi_ei);
  FCw2_Vbi_ci_Vbi_ci=(+FCw_Vbi_ci_Vbi_ci*FCw+FCw_Vbi_ci*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCw2=(FCw*FCw);
#if defined(_DERIVATEFORDDX)
FCz_Vci_ei=(latb*FCw_Vci_ei);
#if defined(_DERIVATE)
  FCz_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei);
  FCz_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND);
  FCz_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei);
  FCz_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCz_Vtnode_GND=(latb*FCw_Vtnode_GND);
#endif
FCz_Vbi_ei=(latb*FCw_Vbi_ei);
#if defined(_DERIVATE)
  FCz_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei);
  FCz_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND);
  FCz_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei);
  FCz_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci);
#endif
FCz_Vbi_ci=(latb*FCw_Vbi_ci);
#if defined(_DERIVATE)
  FCz_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei);
  FCz_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND);
  FCz_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei);
  FCz_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCz=(latb*FCw);
#if defined(_DERIVATEFORDDX)
FCz_1_Vci_ei=FCz_Vci_ei;
#if defined(_DERIVATE)
  FCz_1_Vci_ei_Vci_ei=(+0.0+FCz_Vci_ei_Vci_ei);
  FCz_1_Vci_ei_Vtnode_GND=(+0.0+FCz_Vci_ei_Vtnode_GND);
  FCz_1_Vci_ei_Vbi_ei=(+0.0+FCz_Vci_ei_Vbi_ei);
  FCz_1_Vci_ei_Vbi_ci=(+0.0+FCz_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCz_1_Vtnode_GND=FCz_Vtnode_GND;
#endif
FCz_1_Vbi_ei=FCz_Vbi_ei;
#if defined(_DERIVATE)
  FCz_1_Vbi_ei_Vci_ei=(+0.0+FCz_Vbi_ei_Vci_ei);
  FCz_1_Vbi_ei_Vtnode_GND=(+0.0+FCz_Vbi_ei_Vtnode_GND);
  FCz_1_Vbi_ei_Vbi_ei=(+0.0+FCz_Vbi_ei_Vbi_ei);
  FCz_1_Vbi_ei_Vbi_ci=(+0.0+FCz_Vbi_ei_Vbi_ci);
#endif
FCz_1_Vbi_ci=FCz_Vbi_ci;
#if defined(_DERIVATE)
  FCz_1_Vbi_ci_Vci_ei=(+0.0+FCz_Vbi_ci_Vci_ei);
  FCz_1_Vbi_ci_Vtnode_GND=(+0.0+FCz_Vbi_ci_Vtnode_GND);
  FCz_1_Vbi_ci_Vbi_ei=(+0.0+FCz_Vbi_ci_Vbi_ei);
  FCz_1_Vbi_ci_Vbi_ci=(+0.0+FCz_Vbi_ci_Vbi_ci);
#endif
#endif
FCz_1=(1.0+FCz);
#if defined(_DERIVATEFORDDX)
FCd_f_Vci_ei=(-FCz_1_Vci_ei/FCz_1/FCz_1);
#if defined(_DERIVATE)
  FCd_f_Vci_ei_Vci_ei=(0.0/FCz_1-(0.0*FCz_1_Vci_ei+0.0*FCz_1_Vci_ei+1.0*FCz_1_Vci_ei_Vci_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vci_ei*FCz_1_Vci_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vci_ei_Vtnode_GND=(0.0/FCz_1-(0.0*FCz_1_Vtnode_GND+0.0*FCz_1_Vci_ei+1.0*FCz_1_Vci_ei_Vtnode_GND)/FCz_1/FCz_1+2*1.0*FCz_1_Vci_ei*FCz_1_Vtnode_GND/FCz_1/FCz_1/FCz_1);
  FCd_f_Vci_ei_Vbi_ei=(0.0/FCz_1-(0.0*FCz_1_Vbi_ei+0.0*FCz_1_Vci_ei+1.0*FCz_1_Vci_ei_Vbi_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vci_ei*FCz_1_Vbi_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vci_ei_Vbi_ci=(0.0/FCz_1-(0.0*FCz_1_Vbi_ci+0.0*FCz_1_Vci_ei+1.0*FCz_1_Vci_ei_Vbi_ci)/FCz_1/FCz_1+2*1.0*FCz_1_Vci_ei*FCz_1_Vbi_ci/FCz_1/FCz_1/FCz_1);
#endif
#if defined(_DERIVATE)
FCd_f_Vtnode_GND=(-FCz_1_Vtnode_GND/FCz_1/FCz_1);
#endif
FCd_f_Vbi_ei=(-FCz_1_Vbi_ei/FCz_1/FCz_1);
#if defined(_DERIVATE)
  FCd_f_Vbi_ei_Vci_ei=(0.0/FCz_1-(0.0*FCz_1_Vci_ei+0.0*FCz_1_Vbi_ei+1.0*FCz_1_Vbi_ei_Vci_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ei*FCz_1_Vci_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ei_Vtnode_GND=(0.0/FCz_1-(0.0*FCz_1_Vtnode_GND+0.0*FCz_1_Vbi_ei+1.0*FCz_1_Vbi_ei_Vtnode_GND)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ei*FCz_1_Vtnode_GND/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ei_Vbi_ei=(0.0/FCz_1-(0.0*FCz_1_Vbi_ei+0.0*FCz_1_Vbi_ei+1.0*FCz_1_Vbi_ei_Vbi_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ei*FCz_1_Vbi_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ei_Vbi_ci=(0.0/FCz_1-(0.0*FCz_1_Vbi_ci+0.0*FCz_1_Vbi_ei+1.0*FCz_1_Vbi_ei_Vbi_ci)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ei*FCz_1_Vbi_ci/FCz_1/FCz_1/FCz_1);
#endif
FCd_f_Vbi_ci=(-FCz_1_Vbi_ci/FCz_1/FCz_1);
#if defined(_DERIVATE)
  FCd_f_Vbi_ci_Vci_ei=(0.0/FCz_1-(0.0*FCz_1_Vci_ei+0.0*FCz_1_Vbi_ci+1.0*FCz_1_Vbi_ci_Vci_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ci*FCz_1_Vci_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ci_Vtnode_GND=(0.0/FCz_1-(0.0*FCz_1_Vtnode_GND+0.0*FCz_1_Vbi_ci+1.0*FCz_1_Vbi_ci_Vtnode_GND)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ci*FCz_1_Vtnode_GND/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ci_Vbi_ei=(0.0/FCz_1-(0.0*FCz_1_Vbi_ei+0.0*FCz_1_Vbi_ci+1.0*FCz_1_Vbi_ci_Vbi_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ci*FCz_1_Vbi_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ci_Vbi_ci=(0.0/FCz_1-(0.0*FCz_1_Vbi_ci+0.0*FCz_1_Vbi_ci+1.0*FCz_1_Vbi_ci_Vbi_ci)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ci*FCz_1_Vbi_ci/FCz_1/FCz_1/FCz_1);
#endif
#endif
FCd_f=(1.0/FCz_1);
#if defined(_DERIVATEFORDDX)
FCf_ci_Vci_ei=((((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei));
#if defined(_DERIVATE)
  FCf_ci_Vci_ei_Vci_ei=(+(+FCw2_Vci_ei_Vci_ei*(1.0+(FCz/3.0))+FCw2_Vci_ei*(FCz_Vci_ei/3.0)+FCw2_Vci_ei*(FCz_Vci_ei/3.0)+FCw2*(+0.0+(FCz_Vci_ei_Vci_ei/3.0-(FCz_Vci_ei*0.0+FCz_Vci_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f_Vci_ei+(((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0))))*FCd_f_Vci_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei_Vci_ei);
  FCf_ci_Vci_ei_Vtnode_GND=(+(+FCw2_Vci_ei_Vtnode_GND*(1.0+(FCz/3.0))+FCw2_Vci_ei*(FCz_Vtnode_GND/3.0)+FCw2_Vtnode_GND*(FCz_Vci_ei/3.0)+FCw2*(+0.0+(FCz_Vci_ei_Vtnode_GND/3.0-(FCz_Vci_ei*0.0+FCz_Vtnode_GND*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f_Vtnode_GND+(((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vtnode_GND/3.0))))*FCd_f_Vci_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei_Vtnode_GND);
  FCf_ci_Vci_ei_Vbi_ei=(+(+FCw2_Vci_ei_Vbi_ei*(1.0+(FCz/3.0))+FCw2_Vci_ei*(FCz_Vbi_ei/3.0)+FCw2_Vbi_ei*(FCz_Vci_ei/3.0)+FCw2*(+0.0+(FCz_Vci_ei_Vbi_ei/3.0-(FCz_Vci_ei*0.0+FCz_Vbi_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f_Vbi_ei+(((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0))))*FCd_f_Vci_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei_Vbi_ei);
  FCf_ci_Vci_ei_Vbi_ci=(+(+FCw2_Vci_ei_Vbi_ci*(1.0+(FCz/3.0))+FCw2_Vci_ei*(FCz_Vbi_ci/3.0)+FCw2_Vbi_ci*(FCz_Vci_ei/3.0)+FCw2*(+0.0+(FCz_Vci_ei_Vbi_ci/3.0-(FCz_Vci_ei*0.0+FCz_Vbi_ci*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f_Vbi_ci+(((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0))))*FCd_f_Vci_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCf_ci_Vtnode_GND=((((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vtnode_GND/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vtnode_GND));
#endif
FCf_ci_Vbi_ei=((((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei));
#if defined(_DERIVATE)
  FCf_ci_Vbi_ei_Vci_ei=(+(+FCw2_Vbi_ei_Vci_ei*(1.0+(FCz/3.0))+FCw2_Vbi_ei*(FCz_Vci_ei/3.0)+FCw2_Vci_ei*(FCz_Vbi_ei/3.0)+FCw2*(+0.0+(FCz_Vbi_ei_Vci_ei/3.0-(FCz_Vbi_ei*0.0+FCz_Vci_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f_Vci_ei+(((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0))))*FCd_f_Vbi_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei_Vci_ei);
  FCf_ci_Vbi_ei_Vtnode_GND=(+(+FCw2_Vbi_ei_Vtnode_GND*(1.0+(FCz/3.0))+FCw2_Vbi_ei*(FCz_Vtnode_GND/3.0)+FCw2_Vtnode_GND*(FCz_Vbi_ei/3.0)+FCw2*(+0.0+(FCz_Vbi_ei_Vtnode_GND/3.0-(FCz_Vbi_ei*0.0+FCz_Vtnode_GND*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f_Vtnode_GND+(((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vtnode_GND/3.0))))*FCd_f_Vbi_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei_Vtnode_GND);
  FCf_ci_Vbi_ei_Vbi_ei=(+(+FCw2_Vbi_ei_Vbi_ei*(1.0+(FCz/3.0))+FCw2_Vbi_ei*(FCz_Vbi_ei/3.0)+FCw2_Vbi_ei*(FCz_Vbi_ei/3.0)+FCw2*(+0.0+(FCz_Vbi_ei_Vbi_ei/3.0-(FCz_Vbi_ei*0.0+FCz_Vbi_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f_Vbi_ei+(((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0))))*FCd_f_Vbi_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei_Vbi_ei);
  FCf_ci_Vbi_ei_Vbi_ci=(+(+FCw2_Vbi_ei_Vbi_ci*(1.0+(FCz/3.0))+FCw2_Vbi_ei*(FCz_Vbi_ci/3.0)+FCw2_Vbi_ci*(FCz_Vbi_ei/3.0)+FCw2*(+0.0+(FCz_Vbi_ei_Vbi_ci/3.0-(FCz_Vbi_ei*0.0+FCz_Vbi_ci*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f_Vbi_ci+(((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0))))*FCd_f_Vbi_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei_Vbi_ci);
#endif
FCf_ci_Vbi_ci=((((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ci));
#if defined(_DERIVATE)
  FCf_ci_Vbi_ci_Vci_ei=(+(+FCw2_Vbi_ci_Vci_ei*(1.0+(FCz/3.0))+FCw2_Vbi_ci*(FCz_Vci_ei/3.0)+FCw2_Vci_ei*(FCz_Vbi_ci/3.0)+FCw2*(+0.0+(FCz_Vbi_ci_Vci_ei/3.0-(FCz_Vbi_ci*0.0+FCz_Vci_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0)))*FCd_f_Vci_ei+(((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0))))*FCd_f_Vbi_ci+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ci_Vci_ei);
  FCf_ci_Vbi_ci_Vtnode_GND=(+(+FCw2_Vbi_ci_Vtnode_GND*(1.0+(FCz/3.0))+FCw2_Vbi_ci*(FCz_Vtnode_GND/3.0)+FCw2_Vtnode_GND*(FCz_Vbi_ci/3.0)+FCw2*(+0.0+(FCz_Vbi_ci_Vtnode_GND/3.0-(FCz_Vbi_ci*0.0+FCz_Vtnode_GND*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0)))*FCd_f_Vtnode_GND+(((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vtnode_GND/3.0))))*FCd_f_Vbi_ci+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ci_Vtnode_GND);
  FCf_ci_Vbi_ci_Vbi_ei=(+(+FCw2_Vbi_ci_Vbi_ei*(1.0+(FCz/3.0))+FCw2_Vbi_ci*(FCz_Vbi_ei/3.0)+FCw2_Vbi_ei*(FCz_Vbi_ci/3.0)+FCw2*(+0.0+(FCz_Vbi_ci_Vbi_ei/3.0-(FCz_Vbi_ci*0.0+FCz_Vbi_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0)))*FCd_f_Vbi_ei+(((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0))))*FCd_f_Vbi_ci+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ci_Vbi_ei);
  FCf_ci_Vbi_ci_Vbi_ci=(+(+FCw2_Vbi_ci_Vbi_ci*(1.0+(FCz/3.0))+FCw2_Vbi_ci*(FCz_Vbi_ci/3.0)+FCw2_Vbi_ci*(FCz_Vbi_ci/3.0)+FCw2*(+0.0+(FCz_Vbi_ci_Vbi_ci/3.0-(FCz_Vbi_ci*0.0+FCz_Vbi_ci*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0)))*FCd_f_Vbi_ci+(((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0))))*FCd_f_Vbi_ci+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ci_Vbi_ci);
#endif
#endif
FCf_ci=((FCw2*(1.0+(FCz/3.0)))*FCd_f);
#if defined(_DERIVATEFORDDX)
FCdfc_dw_Vci_ei=(((((((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei));
#if defined(_DERIVATE)
  FCdfc_dw_Vci_ei_Vci_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vci_ei)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vci_ei)*(FCz_1_Vci_ei+((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0))+((2.0*FCw_Vci_ei))*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))+(2.0*FCw)*(+FCz_1_Vci_ei_Vci_ei+((+FCz_Vci_ei_Vci_ei*FCz+FCz_Vci_ei*FCz_Vci_ei+FCz_Vci_ei*FCz_Vci_ei+FCz*FCz_Vci_ei_Vci_ei)/3.0-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))*0.0+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f_Vci_ei+(((((2.0*FCw_Vci_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f_Vci_ei+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei_Vci_ei)*FCd_f+(((((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f_Vci_ei+((((((((2.0*FCw_Vci_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei)))*FCd_f_Vci_ei+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei_Vci_ei);
  FCdfc_dw_Vci_ei_Vtnode_GND=(+(+(+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vtnode_GND)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vci_ei)*(FCz_1_Vtnode_GND+((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0))+((2.0*FCw_Vtnode_GND))*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))+(2.0*FCw)*(+FCz_1_Vci_ei_Vtnode_GND+((+FCz_Vci_ei_Vtnode_GND*FCz+FCz_Vci_ei*FCz_Vtnode_GND+FCz_Vtnode_GND*FCz_Vci_ei+FCz*FCz_Vci_ei_Vtnode_GND)/3.0-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))*0.0+(((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f_Vtnode_GND+(((((2.0*FCw_Vtnode_GND))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f_Vci_ei+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei_Vtnode_GND)*FCd_f+(((((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f_Vtnode_GND+((((((((2.0*FCw_Vtnode_GND))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND)))*FCd_f_Vci_ei+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei_Vtnode_GND);
  FCdfc_dw_Vci_ei_Vbi_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vci_ei)*(FCz_1_Vbi_ei+((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0))+((2.0*FCw_Vbi_ei))*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))+(2.0*FCw)*(+FCz_1_Vci_ei_Vbi_ei+((+FCz_Vci_ei_Vbi_ei*FCz+FCz_Vci_ei*FCz_Vbi_ei+FCz_Vbi_ei*FCz_Vci_ei+FCz*FCz_Vci_ei_Vbi_ei)/3.0-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))*0.0+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f_Vbi_ei+(((((2.0*FCw_Vbi_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f_Vci_ei+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei_Vbi_ei)*FCd_f+(((((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f_Vbi_ei+((((((((2.0*FCw_Vbi_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei)))*FCd_f_Vci_ei+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei_Vbi_ei);
  FCdfc_dw_Vci_ei_Vbi_ci=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vci_ei)*(FCz_1_Vbi_ci+((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0))+((2.0*FCw_Vbi_ci))*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))+(2.0*FCw)*(+FCz_1_Vci_ei_Vbi_ci+((+FCz_Vci_ei_Vbi_ci*FCz+FCz_Vci_ei*FCz_Vbi_ci+FCz_Vbi_ci*FCz_Vci_ei+FCz*FCz_Vci_ei_Vbi_ci)/3.0-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))*0.0+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f_Vbi_ci+(((((2.0*FCw_Vbi_ci))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f_Vci_ei+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei_Vbi_ci)*FCd_f+(((((2.0*FCw_Vci_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f_Vbi_ci+((((((((2.0*FCw_Vbi_ci))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci)))*FCd_f_Vci_ei+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdfc_dw_Vtnode_GND=(((((((2.0*FCw_Vtnode_GND)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+(((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vtnode_GND));
#endif
FCdfc_dw_Vbi_ei=(((((((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei));
#if defined(_DERIVATE)
  FCdfc_dw_Vbi_ei_Vci_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vci_ei)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ei)*(FCz_1_Vci_ei+((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0))+((2.0*FCw_Vci_ei))*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))+(2.0*FCw)*(+FCz_1_Vbi_ei_Vci_ei+((+FCz_Vbi_ei_Vci_ei*FCz+FCz_Vbi_ei*FCz_Vci_ei+FCz_Vci_ei*FCz_Vbi_ei+FCz*FCz_Vbi_ei_Vci_ei)/3.0-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))*0.0+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f_Vci_ei+(((((2.0*FCw_Vci_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f_Vbi_ei+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei_Vci_ei)*FCd_f+(((((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f_Vci_ei+((((((((2.0*FCw_Vci_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei)))*FCd_f_Vbi_ei+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei_Vci_ei);
  FCdfc_dw_Vbi_ei_Vtnode_GND=(+(+(+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vtnode_GND)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ei)*(FCz_1_Vtnode_GND+((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0))+((2.0*FCw_Vtnode_GND))*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))+(2.0*FCw)*(+FCz_1_Vbi_ei_Vtnode_GND+((+FCz_Vbi_ei_Vtnode_GND*FCz+FCz_Vbi_ei*FCz_Vtnode_GND+FCz_Vtnode_GND*FCz_Vbi_ei+FCz*FCz_Vbi_ei_Vtnode_GND)/3.0-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))*0.0+(((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f_Vtnode_GND+(((((2.0*FCw_Vtnode_GND))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f_Vbi_ei+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei_Vtnode_GND)*FCd_f+(((((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f_Vtnode_GND+((((((((2.0*FCw_Vtnode_GND))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND)))*FCd_f_Vbi_ei+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei_Vtnode_GND);
  FCdfc_dw_Vbi_ei_Vbi_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ei)*(FCz_1_Vbi_ei+((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0))+((2.0*FCw_Vbi_ei))*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))+(2.0*FCw)*(+FCz_1_Vbi_ei_Vbi_ei+((+FCz_Vbi_ei_Vbi_ei*FCz+FCz_Vbi_ei*FCz_Vbi_ei+FCz_Vbi_ei*FCz_Vbi_ei+FCz*FCz_Vbi_ei_Vbi_ei)/3.0-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))*0.0+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f_Vbi_ei+(((((2.0*FCw_Vbi_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f_Vbi_ei+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei_Vbi_ei)*FCd_f+(((((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f_Vbi_ei+((((((((2.0*FCw_Vbi_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei)))*FCd_f_Vbi_ei+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei_Vbi_ei);
  FCdfc_dw_Vbi_ei_Vbi_ci=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ei)*(FCz_1_Vbi_ci+((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0))+((2.0*FCw_Vbi_ci))*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))+(2.0*FCw)*(+FCz_1_Vbi_ei_Vbi_ci+((+FCz_Vbi_ei_Vbi_ci*FCz+FCz_Vbi_ei*FCz_Vbi_ci+FCz_Vbi_ci*FCz_Vbi_ei+FCz*FCz_Vbi_ei_Vbi_ci)/3.0-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))*0.0+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f_Vbi_ci+(((((2.0*FCw_Vbi_ci))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f_Vbi_ei+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei_Vbi_ci)*FCd_f+(((((2.0*FCw_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f_Vbi_ci+((((((((2.0*FCw_Vbi_ci))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci)))*FCd_f_Vbi_ei+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei_Vbi_ci);
#endif
FCdfc_dw_Vbi_ci=(((((((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f)+((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci));
#if defined(_DERIVATE)
  FCdfc_dw_Vbi_ci_Vci_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vci_ei)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ci)*(FCz_1_Vci_ei+((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0))+((2.0*FCw_Vci_ei))*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))+(2.0*FCw)*(+FCz_1_Vbi_ci_Vci_ei+((+FCz_Vbi_ci_Vci_ei*FCz+FCz_Vbi_ci*FCz_Vci_ei+FCz_Vci_ei*FCz_Vbi_ci+FCz*FCz_Vbi_ci_Vci_ei)/3.0-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))*0.0+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f_Vci_ei+(((((2.0*FCw_Vci_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f_Vbi_ci+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci_Vci_ei)*FCd_f+(((((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f_Vci_ei+((((((((2.0*FCw_Vci_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vci_ei+((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vci_ei)))*FCd_f_Vbi_ci+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci_Vci_ei);
  FCdfc_dw_Vbi_ci_Vtnode_GND=(+(+(+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vtnode_GND)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ci)*(FCz_1_Vtnode_GND+((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0))+((2.0*FCw_Vtnode_GND))*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))+(2.0*FCw)*(+FCz_1_Vbi_ci_Vtnode_GND+((+FCz_Vbi_ci_Vtnode_GND*FCz+FCz_Vbi_ci*FCz_Vtnode_GND+FCz_Vtnode_GND*FCz_Vbi_ci+FCz*FCz_Vbi_ci_Vtnode_GND)/3.0-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))*0.0+(((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f_Vtnode_GND+(((((2.0*FCw_Vtnode_GND))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f_Vbi_ci+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci_Vtnode_GND)*FCd_f+(((((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f_Vtnode_GND+((((((((2.0*FCw_Vtnode_GND))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vtnode_GND+((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND)))*FCd_f_Vbi_ci+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci_Vtnode_GND);
  FCdfc_dw_Vbi_ci_Vbi_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vbi_ei)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ci)*(FCz_1_Vbi_ei+((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0))+((2.0*FCw_Vbi_ei))*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))+(2.0*FCw)*(+FCz_1_Vbi_ci_Vbi_ei+((+FCz_Vbi_ci_Vbi_ei*FCz+FCz_Vbi_ci*FCz_Vbi_ei+FCz_Vbi_ei*FCz_Vbi_ci+FCz*FCz_Vbi_ci_Vbi_ei)/3.0-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))*0.0+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f_Vbi_ei+(((((2.0*FCw_Vbi_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f_Vbi_ci+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci_Vbi_ei)*FCd_f+(((((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f_Vbi_ei+((((((((2.0*FCw_Vbi_ei))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ei+((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ei)))*FCd_f_Vbi_ci+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci_Vbi_ei);
  FCdfc_dw_Vbi_ci_Vbi_ci=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ci)*(FCz_1_Vbi_ci+((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0))+((2.0*FCw_Vbi_ci))*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))+(2.0*FCw)*(+FCz_1_Vbi_ci_Vbi_ci+((+FCz_Vbi_ci_Vbi_ci*FCz+FCz_Vbi_ci*FCz_Vbi_ci+FCz_Vbi_ci*FCz_Vbi_ci+FCz*FCz_Vbi_ci_Vbi_ci)/3.0-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))*0.0+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f_Vbi_ci+(((((2.0*FCw_Vbi_ci))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f_Vbi_ci+((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci_Vbi_ci)*FCd_f+(((((2.0*FCw_Vbi_ci)*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f_Vbi_ci+((((((((2.0*FCw_Vbi_ci))*(FCz_1+((FCz*FCz)/3.0)))+((2.0*FCw)*(FCz_1_Vbi_ci+((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f)+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f_Vbi_ci)))*FCd_f_Vbi_ci+(((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci_Vbi_ci);
#endif
#endif
FCdfc_dw=((((2.0*FCw)*(FCz_1+((FCz*FCz)/3.0)))*FCd_f)*FCd_f);
#if defined(_DERIVATEFORDDX)
FCdw_ditf_Vci_ei=((FCdw_daick_Vci_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vci_ei));
#if defined(_DERIVATE)
  FCdw_ditf_Vci_ei_Vci_ei=(+FCdw_daick_Vci_ei_Vci_ei*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vci_ei+FCdw_daick_Vci_ei*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vci_ei);
  FCdw_ditf_Vci_ei_Vtnode_GND=(+FCdw_daick_Vci_ei_Vtnode_GND*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vtnode_GND+FCdw_daick_Vtnode_GND*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vtnode_GND);
  FCdw_ditf_Vci_ei_Vbi_ei=(+FCdw_daick_Vci_ei_Vbi_ei*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ei+FCdw_daick_Vbi_ei*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vbi_ei);
  FCdw_ditf_Vci_ei_Vbi_ci=(+FCdw_daick_Vci_ei_Vbi_ci*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ci+FCdw_daick_Vbi_ci*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdw_ditf_Vtnode_GND=((FCdw_daick_Vtnode_GND*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vtnode_GND));
#endif
FCdw_ditf_Vbi_ei=((FCdw_daick_Vbi_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ei));
#if defined(_DERIVATE)
  FCdw_ditf_Vbi_ei_Vci_ei=(+FCdw_daick_Vbi_ei_Vci_ei*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vci_ei+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vci_ei);
  FCdw_ditf_Vbi_ei_Vtnode_GND=(+FCdw_daick_Vbi_ei_Vtnode_GND*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vtnode_GND+FCdw_daick_Vtnode_GND*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vtnode_GND);
  FCdw_ditf_Vbi_ei_Vbi_ei=(+FCdw_daick_Vbi_ei_Vbi_ei*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ei+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vbi_ei);
  FCdw_ditf_Vbi_ei_Vbi_ci=(+FCdw_daick_Vbi_ei_Vbi_ci*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ci+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vbi_ci);
#endif
FCdw_ditf_Vbi_ci=((FCdw_daick_Vbi_ci*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ci));
#if defined(_DERIVATE)
  FCdw_ditf_Vbi_ci_Vci_ei=(+FCdw_daick_Vbi_ci_Vci_ei*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vci_ei+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vci_ei);
  FCdw_ditf_Vbi_ci_Vtnode_GND=(+FCdw_daick_Vbi_ci_Vtnode_GND*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vtnode_GND+FCdw_daick_Vtnode_GND*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vtnode_GND);
  FCdw_ditf_Vbi_ci_Vbi_ei=(+FCdw_daick_Vbi_ci_Vbi_ei*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ei+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vbi_ei);
  FCdw_ditf_Vbi_ci_Vbi_ci=(+FCdw_daick_Vbi_ci_Vbi_ci*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ci+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vbi_ci);
#endif
#endif
FCdw_ditf=(FCdw_daick*FCdaick_ditf);
#if defined(_DERIVATEFORDDX)
FCdfc_ditf_Vci_ei=((FCdfc_dw_Vci_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vci_ei));
#if defined(_DERIVATE)
  FCdfc_ditf_Vci_ei_Vci_ei=(+FCdfc_dw_Vci_ei_Vci_ei*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfc_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vci_ei);
  FCdfc_ditf_Vci_ei_Vtnode_GND=(+FCdfc_dw_Vci_ei_Vtnode_GND*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vtnode_GND+FCdfc_dw_Vtnode_GND*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vtnode_GND);
  FCdfc_ditf_Vci_ei_Vbi_ei=(+FCdfc_dw_Vci_ei_Vbi_ei*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfc_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vbi_ei);
  FCdfc_ditf_Vci_ei_Vbi_ci=(+FCdfc_dw_Vci_ei_Vbi_ci*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfc_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdfc_ditf_Vtnode_GND=((FCdfc_dw_Vtnode_GND*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vtnode_GND));
#endif
FCdfc_ditf_Vbi_ei=((FCdfc_dw_Vbi_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ei));
#if defined(_DERIVATE)
  FCdfc_ditf_Vbi_ei_Vci_ei=(+FCdfc_dw_Vbi_ei_Vci_ei*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vci_ei);
  FCdfc_ditf_Vbi_ei_Vtnode_GND=(+FCdfc_dw_Vbi_ei_Vtnode_GND*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vtnode_GND+FCdfc_dw_Vtnode_GND*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vtnode_GND);
  FCdfc_ditf_Vbi_ei_Vbi_ei=(+FCdfc_dw_Vbi_ei_Vbi_ei*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vbi_ei);
  FCdfc_ditf_Vbi_ei_Vbi_ci=(+FCdfc_dw_Vbi_ei_Vbi_ci*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vbi_ci);
#endif
FCdfc_ditf_Vbi_ci=((FCdfc_dw_Vbi_ci*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ci));
#if defined(_DERIVATE)
  FCdfc_ditf_Vbi_ci_Vci_ei=(+FCdfc_dw_Vbi_ci_Vci_ei*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vci_ei);
  FCdfc_ditf_Vbi_ci_Vtnode_GND=(+FCdfc_dw_Vbi_ci_Vtnode_GND*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vtnode_GND+FCdfc_dw_Vtnode_GND*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vtnode_GND);
  FCdfc_ditf_Vbi_ci_Vbi_ei=(+FCdfc_dw_Vbi_ci_Vbi_ei*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vbi_ei);
  FCdfc_ditf_Vbi_ci_Vbi_ci=(+FCdfc_dw_Vbi_ci_Vbi_ci*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vbi_ci);
#endif
#endif
FCdfc_ditf=(FCdfc_dw*FCdw_ditf);
if
(((flcomp==0.0)||(flcomp==2.1)))
{
if
((FCz>0.001))
{
{
double m00_logE(d00_logE0,FCz_1)
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,FCz_1)
#endif
#if defined(_DERIVATEFORDDX)
FCf_CT_Vbi_ei=(((2.0*(((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0))-FCz_Vbi_ei))*((latb*latb)*FCz_1)-(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
#if defined(_DERIVATE)
  FCf_CT_Vbi_ei_Vbi_ei=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0)))-FCz_Vbi_ei)+0.0*(((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0))-FCz_Vbi_ei)+2.0*(+(+FCz_1_Vbi_ei_Vbi_ei*d00_logE0+FCz_1_Vbi_ei*FCz_1_Vbi_ei*d10_logE0+FCz_1_Vbi_ei*FCz_1_Vbi_ei*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vbi_ei*FCz_1_Vbi_ei+d10_logE0*FCz_1_Vbi_ei_Vbi_ei))-FCz_Vbi_ei_Vbi_ei))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0))-FCz_Vbi_ei))*(((latb*latb)*FCz_1_Vbi_ei))+((2.0*((((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0)))-FCz_Vbi_ei)))*((latb*latb)*FCz_1_Vbi_ei)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vbi_ei+0.0*FCz_1_Vbi_ei+(latb*latb)*FCz_1_Vbi_ei_Vbi_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ei)*(((latb*latb)*FCz_1_Vbi_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
  FCf_CT_Vbi_ei_Vbi_ci=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0)))-FCz_Vbi_ci)+0.0*(((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0))-FCz_Vbi_ei)+2.0*(+(+FCz_1_Vbi_ei_Vbi_ci*d00_logE0+FCz_1_Vbi_ei*FCz_1_Vbi_ci*d10_logE0+FCz_1_Vbi_ci*FCz_1_Vbi_ei*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vbi_ci*FCz_1_Vbi_ei+d10_logE0*FCz_1_Vbi_ei_Vbi_ci))-FCz_Vbi_ei_Vbi_ci))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0))-FCz_Vbi_ei))*(((latb*latb)*FCz_1_Vbi_ci))+((2.0*((((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0)))-FCz_Vbi_ci)))*((latb*latb)*FCz_1_Vbi_ei)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vbi_ci+0.0*FCz_1_Vbi_ei+(latb*latb)*FCz_1_Vbi_ei_Vbi_ci))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ei)*(((latb*latb)*FCz_1_Vbi_ci))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
  FCf_CT_Vbi_ei_Vci_ei=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0)))-FCz_Vci_ei)+0.0*(((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0))-FCz_Vbi_ei)+2.0*(+(+FCz_1_Vbi_ei_Vci_ei*d00_logE0+FCz_1_Vbi_ei*FCz_1_Vci_ei*d10_logE0+FCz_1_Vci_ei*FCz_1_Vbi_ei*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vci_ei*FCz_1_Vbi_ei+d10_logE0*FCz_1_Vbi_ei_Vci_ei))-FCz_Vbi_ei_Vci_ei))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0))-FCz_Vbi_ei))*(((latb*latb)*FCz_1_Vci_ei))+((2.0*((((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0)))-FCz_Vci_ei)))*((latb*latb)*FCz_1_Vbi_ei)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vci_ei+0.0*FCz_1_Vbi_ei+(latb*latb)*FCz_1_Vbi_ei_Vci_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ei)*(((latb*latb)*FCz_1_Vci_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
  FCf_CT_Vbi_ei_Vtnode_GND=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vtnode_GND*d00_logE0)+(FCz_1*FCz_1_Vtnode_GND*d10_logE0)))-FCz_Vtnode_GND)+0.0*(((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0))-FCz_Vbi_ei)+2.0*(+(+FCz_1_Vbi_ei_Vtnode_GND*d00_logE0+FCz_1_Vbi_ei*FCz_1_Vtnode_GND*d10_logE0+FCz_1_Vtnode_GND*FCz_1_Vbi_ei*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vtnode_GND*FCz_1_Vbi_ei+d10_logE0*FCz_1_Vbi_ei_Vtnode_GND))-FCz_Vbi_ei_Vtnode_GND))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0))-FCz_Vbi_ei))*(((latb*latb)*FCz_1_Vtnode_GND))+((2.0*((((FCz_1_Vtnode_GND*d00_logE0)+(FCz_1*FCz_1_Vtnode_GND*d10_logE0)))-FCz_Vtnode_GND)))*((latb*latb)*FCz_1_Vbi_ei)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vtnode_GND+0.0*FCz_1_Vbi_ei+(latb*latb)*FCz_1_Vbi_ei_Vtnode_GND))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ei)*(((latb*latb)*FCz_1_Vtnode_GND))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
#endif
FCf_CT_Vbi_ci=(((2.0*(((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0))-FCz_Vbi_ci))*((latb*latb)*FCz_1)-(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ci))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
#if defined(_DERIVATE)
  FCf_CT_Vbi_ci_Vbi_ei=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0)))-FCz_Vbi_ei)+0.0*(((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0))-FCz_Vbi_ci)+2.0*(+(+FCz_1_Vbi_ci_Vbi_ei*d00_logE0+FCz_1_Vbi_ci*FCz_1_Vbi_ei*d10_logE0+FCz_1_Vbi_ei*FCz_1_Vbi_ci*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vbi_ei*FCz_1_Vbi_ci+d10_logE0*FCz_1_Vbi_ci_Vbi_ei))-FCz_Vbi_ci_Vbi_ei))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0))-FCz_Vbi_ci))*(((latb*latb)*FCz_1_Vbi_ei))+((2.0*((((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0)))-FCz_Vbi_ei)))*((latb*latb)*FCz_1_Vbi_ci)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vbi_ei+0.0*FCz_1_Vbi_ci+(latb*latb)*FCz_1_Vbi_ci_Vbi_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ci)*(((latb*latb)*FCz_1_Vbi_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
  FCf_CT_Vbi_ci_Vbi_ci=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0)))-FCz_Vbi_ci)+0.0*(((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0))-FCz_Vbi_ci)+2.0*(+(+FCz_1_Vbi_ci_Vbi_ci*d00_logE0+FCz_1_Vbi_ci*FCz_1_Vbi_ci*d10_logE0+FCz_1_Vbi_ci*FCz_1_Vbi_ci*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vbi_ci*FCz_1_Vbi_ci+d10_logE0*FCz_1_Vbi_ci_Vbi_ci))-FCz_Vbi_ci_Vbi_ci))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0))-FCz_Vbi_ci))*(((latb*latb)*FCz_1_Vbi_ci))+((2.0*((((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0)))-FCz_Vbi_ci)))*((latb*latb)*FCz_1_Vbi_ci)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vbi_ci+0.0*FCz_1_Vbi_ci+(latb*latb)*FCz_1_Vbi_ci_Vbi_ci))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ci)*(((latb*latb)*FCz_1_Vbi_ci))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
  FCf_CT_Vbi_ci_Vci_ei=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0)))-FCz_Vci_ei)+0.0*(((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0))-FCz_Vbi_ci)+2.0*(+(+FCz_1_Vbi_ci_Vci_ei*d00_logE0+FCz_1_Vbi_ci*FCz_1_Vci_ei*d10_logE0+FCz_1_Vci_ei*FCz_1_Vbi_ci*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vci_ei*FCz_1_Vbi_ci+d10_logE0*FCz_1_Vbi_ci_Vci_ei))-FCz_Vbi_ci_Vci_ei))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0))-FCz_Vbi_ci))*(((latb*latb)*FCz_1_Vci_ei))+((2.0*((((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0)))-FCz_Vci_ei)))*((latb*latb)*FCz_1_Vbi_ci)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vci_ei+0.0*FCz_1_Vbi_ci+(latb*latb)*FCz_1_Vbi_ci_Vci_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ci)*(((latb*latb)*FCz_1_Vci_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
  FCf_CT_Vbi_ci_Vtnode_GND=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vtnode_GND*d00_logE0)+(FCz_1*FCz_1_Vtnode_GND*d10_logE0)))-FCz_Vtnode_GND)+0.0*(((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0))-FCz_Vbi_ci)+2.0*(+(+FCz_1_Vbi_ci_Vtnode_GND*d00_logE0+FCz_1_Vbi_ci*FCz_1_Vtnode_GND*d10_logE0+FCz_1_Vtnode_GND*FCz_1_Vbi_ci*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vtnode_GND*FCz_1_Vbi_ci+d10_logE0*FCz_1_Vbi_ci_Vtnode_GND))-FCz_Vbi_ci_Vtnode_GND))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0))-FCz_Vbi_ci))*(((latb*latb)*FCz_1_Vtnode_GND))+((2.0*((((FCz_1_Vtnode_GND*d00_logE0)+(FCz_1*FCz_1_Vtnode_GND*d10_logE0)))-FCz_Vtnode_GND)))*((latb*latb)*FCz_1_Vbi_ci)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vtnode_GND+0.0*FCz_1_Vbi_ci+(latb*latb)*FCz_1_Vbi_ci_Vtnode_GND))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vbi_ci)*(((latb*latb)*FCz_1_Vtnode_GND))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
#endif
FCf_CT_Vci_ei=(((2.0*(((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0))-FCz_Vci_ei))*((latb*latb)*FCz_1)-(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vci_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
#if defined(_DERIVATE)
  FCf_CT_Vci_ei_Vbi_ei=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0)))-FCz_Vbi_ei)+0.0*(((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0))-FCz_Vci_ei)+2.0*(+(+FCz_1_Vci_ei_Vbi_ei*d00_logE0+FCz_1_Vci_ei*FCz_1_Vbi_ei*d10_logE0+FCz_1_Vbi_ei*FCz_1_Vci_ei*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vbi_ei*FCz_1_Vci_ei+d10_logE0*FCz_1_Vci_ei_Vbi_ei))-FCz_Vci_ei_Vbi_ei))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0))-FCz_Vci_ei))*(((latb*latb)*FCz_1_Vbi_ei))+((2.0*((((FCz_1_Vbi_ei*d00_logE0)+(FCz_1*FCz_1_Vbi_ei*d10_logE0)))-FCz_Vbi_ei)))*((latb*latb)*FCz_1_Vci_ei)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vbi_ei+0.0*FCz_1_Vci_ei+(latb*latb)*FCz_1_Vci_ei_Vbi_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vci_ei)*(((latb*latb)*FCz_1_Vbi_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
  FCf_CT_Vci_ei_Vbi_ci=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0)))-FCz_Vbi_ci)+0.0*(((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0))-FCz_Vci_ei)+2.0*(+(+FCz_1_Vci_ei_Vbi_ci*d00_logE0+FCz_1_Vci_ei*FCz_1_Vbi_ci*d10_logE0+FCz_1_Vbi_ci*FCz_1_Vci_ei*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vbi_ci*FCz_1_Vci_ei+d10_logE0*FCz_1_Vci_ei_Vbi_ci))-FCz_Vci_ei_Vbi_ci))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0))-FCz_Vci_ei))*(((latb*latb)*FCz_1_Vbi_ci))+((2.0*((((FCz_1_Vbi_ci*d00_logE0)+(FCz_1*FCz_1_Vbi_ci*d10_logE0)))-FCz_Vbi_ci)))*((latb*latb)*FCz_1_Vci_ei)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vbi_ci+0.0*FCz_1_Vci_ei+(latb*latb)*FCz_1_Vci_ei_Vbi_ci))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vci_ei)*(((latb*latb)*FCz_1_Vbi_ci))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
  FCf_CT_Vci_ei_Vci_ei=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0)))-FCz_Vci_ei)+0.0*(((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0))-FCz_Vci_ei)+2.0*(+(+FCz_1_Vci_ei_Vci_ei*d00_logE0+FCz_1_Vci_ei*FCz_1_Vci_ei*d10_logE0+FCz_1_Vci_ei*FCz_1_Vci_ei*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vci_ei*FCz_1_Vci_ei+d10_logE0*FCz_1_Vci_ei_Vci_ei))-FCz_Vci_ei_Vci_ei))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0))-FCz_Vci_ei))*(((latb*latb)*FCz_1_Vci_ei))+((2.0*((((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0)))-FCz_Vci_ei)))*((latb*latb)*FCz_1_Vci_ei)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vci_ei+0.0*FCz_1_Vci_ei+(latb*latb)*FCz_1_Vci_ei_Vci_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vci_ei)*(((latb*latb)*FCz_1_Vci_ei))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
  FCf_CT_Vci_ei_Vtnode_GND=((+0.0*((FCz_1*d00_logE0)-FCz)+0.0*((((FCz_1_Vtnode_GND*d00_logE0)+(FCz_1*FCz_1_Vtnode_GND*d10_logE0)))-FCz_Vtnode_GND)+0.0*(((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0))-FCz_Vci_ei)+2.0*(+(+FCz_1_Vci_ei_Vtnode_GND*d00_logE0+FCz_1_Vci_ei*FCz_1_Vtnode_GND*d10_logE0+FCz_1_Vtnode_GND*FCz_1_Vci_ei*d10_logE0+FCz_1*(m20_logE(FCz_1)*FCz_1_Vtnode_GND*FCz_1_Vci_ei+d10_logE0*FCz_1_Vci_ei_Vtnode_GND))-FCz_Vci_ei_Vtnode_GND))/((latb*latb)*FCz_1)-((2.0*(((FCz_1_Vci_ei*d00_logE0)+(FCz_1*FCz_1_Vci_ei*d10_logE0))-FCz_Vci_ei))*(((latb*latb)*FCz_1_Vtnode_GND))+((2.0*((((FCz_1_Vtnode_GND*d00_logE0)+(FCz_1*FCz_1_Vtnode_GND*d10_logE0)))-FCz_Vtnode_GND)))*((latb*latb)*FCz_1_Vci_ei)+(2.0*((FCz_1*d00_logE0)-FCz))*(+(+0.0*latb+0.0*0.0+0.0*0.0+latb*0.0)*FCz_1+0.0*FCz_1_Vtnode_GND+0.0*FCz_1_Vci_ei+(latb*latb)*FCz_1_Vci_ei_Vtnode_GND))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)+2*(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vci_ei)*(((latb*latb)*FCz_1_Vtnode_GND))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
#endif
#if defined(_DERIVATE)
FCf_CT_Vtnode_GND=(((2.0*(((FCz_1_Vtnode_GND*d00_logE0)+(FCz_1*FCz_1_Vtnode_GND*d10_logE0))-FCz_Vtnode_GND))*((latb*latb)*FCz_1)-(2.0*((FCz_1*d00_logE0)-FCz))*((latb*latb)*FCz_1_Vtnode_GND))/((latb*latb)*FCz_1)/((latb*latb)*FCz_1));
#endif
#endif
FCf_CT=((2.0*((FCz_1*d00_logE0)-FCz))/((latb*latb)*FCz_1));
}
#if defined(_DERIVATEFORDDX)
FCdfCT_dw_Vbi_ei=(((((2.0*FCw_Vbi_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vbi_ei));
#if defined(_DERIVATE)
  FCdfCT_dw_Vbi_ei_Vbi_ei=(+(+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vbi_ei)*FCd_f+(2.0*FCw_Vbi_ei)*FCd_f_Vbi_ei+((2.0*FCw_Vbi_ei))*FCd_f_Vbi_ei+(2.0*FCw)*FCd_f_Vbi_ei_Vbi_ei)*FCd_f+(((2.0*FCw_Vbi_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei))*FCd_f_Vbi_ei+(((((2.0*FCw_Vbi_ei))*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei)))*FCd_f_Vbi_ei+((2.0*FCw)*FCd_f)*FCd_f_Vbi_ei_Vbi_ei);
  FCdfCT_dw_Vbi_ei_Vbi_ci=(+(+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vbi_ci)*FCd_f+(2.0*FCw_Vbi_ei)*FCd_f_Vbi_ci+((2.0*FCw_Vbi_ci))*FCd_f_Vbi_ei+(2.0*FCw)*FCd_f_Vbi_ei_Vbi_ci)*FCd_f+(((2.0*FCw_Vbi_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei))*FCd_f_Vbi_ci+(((((2.0*FCw_Vbi_ci))*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci)))*FCd_f_Vbi_ei+((2.0*FCw)*FCd_f)*FCd_f_Vbi_ei_Vbi_ci);
  FCdfCT_dw_Vbi_ei_Vci_ei=(+(+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vci_ei)*FCd_f+(2.0*FCw_Vbi_ei)*FCd_f_Vci_ei+((2.0*FCw_Vci_ei))*FCd_f_Vbi_ei+(2.0*FCw)*FCd_f_Vbi_ei_Vci_ei)*FCd_f+(((2.0*FCw_Vbi_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei))*FCd_f_Vci_ei+(((((2.0*FCw_Vci_ei))*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei)))*FCd_f_Vbi_ei+((2.0*FCw)*FCd_f)*FCd_f_Vbi_ei_Vci_ei);
  FCdfCT_dw_Vbi_ei_Vtnode_GND=(+(+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vtnode_GND)*FCd_f+(2.0*FCw_Vbi_ei)*FCd_f_Vtnode_GND+((2.0*FCw_Vtnode_GND))*FCd_f_Vbi_ei+(2.0*FCw)*FCd_f_Vbi_ei_Vtnode_GND)*FCd_f+(((2.0*FCw_Vbi_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei))*FCd_f_Vtnode_GND+(((((2.0*FCw_Vtnode_GND))*FCd_f)+((2.0*FCw)*FCd_f_Vtnode_GND)))*FCd_f_Vbi_ei+((2.0*FCw)*FCd_f)*FCd_f_Vbi_ei_Vtnode_GND);
#endif
FCdfCT_dw_Vbi_ci=(((((2.0*FCw_Vbi_ci)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vbi_ci));
#if defined(_DERIVATE)
  FCdfCT_dw_Vbi_ci_Vbi_ei=(+(+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vbi_ei)*FCd_f+(2.0*FCw_Vbi_ci)*FCd_f_Vbi_ei+((2.0*FCw_Vbi_ei))*FCd_f_Vbi_ci+(2.0*FCw)*FCd_f_Vbi_ci_Vbi_ei)*FCd_f+(((2.0*FCw_Vbi_ci)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci))*FCd_f_Vbi_ei+(((((2.0*FCw_Vbi_ei))*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei)))*FCd_f_Vbi_ci+((2.0*FCw)*FCd_f)*FCd_f_Vbi_ci_Vbi_ei);
  FCdfCT_dw_Vbi_ci_Vbi_ci=(+(+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vbi_ci)*FCd_f+(2.0*FCw_Vbi_ci)*FCd_f_Vbi_ci+((2.0*FCw_Vbi_ci))*FCd_f_Vbi_ci+(2.0*FCw)*FCd_f_Vbi_ci_Vbi_ci)*FCd_f+(((2.0*FCw_Vbi_ci)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci))*FCd_f_Vbi_ci+(((((2.0*FCw_Vbi_ci))*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci)))*FCd_f_Vbi_ci+((2.0*FCw)*FCd_f)*FCd_f_Vbi_ci_Vbi_ci);
  FCdfCT_dw_Vbi_ci_Vci_ei=(+(+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vci_ei)*FCd_f+(2.0*FCw_Vbi_ci)*FCd_f_Vci_ei+((2.0*FCw_Vci_ei))*FCd_f_Vbi_ci+(2.0*FCw)*FCd_f_Vbi_ci_Vci_ei)*FCd_f+(((2.0*FCw_Vbi_ci)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci))*FCd_f_Vci_ei+(((((2.0*FCw_Vci_ei))*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei)))*FCd_f_Vbi_ci+((2.0*FCw)*FCd_f)*FCd_f_Vbi_ci_Vci_ei);
  FCdfCT_dw_Vbi_ci_Vtnode_GND=(+(+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vtnode_GND)*FCd_f+(2.0*FCw_Vbi_ci)*FCd_f_Vtnode_GND+((2.0*FCw_Vtnode_GND))*FCd_f_Vbi_ci+(2.0*FCw)*FCd_f_Vbi_ci_Vtnode_GND)*FCd_f+(((2.0*FCw_Vbi_ci)*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci))*FCd_f_Vtnode_GND+(((((2.0*FCw_Vtnode_GND))*FCd_f)+((2.0*FCw)*FCd_f_Vtnode_GND)))*FCd_f_Vbi_ci+((2.0*FCw)*FCd_f)*FCd_f_Vbi_ci_Vtnode_GND);
#endif
FCdfCT_dw_Vci_ei=(((((2.0*FCw_Vci_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vci_ei));
#if defined(_DERIVATE)
  FCdfCT_dw_Vci_ei_Vbi_ei=(+(+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vbi_ei)*FCd_f+(2.0*FCw_Vci_ei)*FCd_f_Vbi_ei+((2.0*FCw_Vbi_ei))*FCd_f_Vci_ei+(2.0*FCw)*FCd_f_Vci_ei_Vbi_ei)*FCd_f+(((2.0*FCw_Vci_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei))*FCd_f_Vbi_ei+(((((2.0*FCw_Vbi_ei))*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ei)))*FCd_f_Vci_ei+((2.0*FCw)*FCd_f)*FCd_f_Vci_ei_Vbi_ei);
  FCdfCT_dw_Vci_ei_Vbi_ci=(+(+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vbi_ci)*FCd_f+(2.0*FCw_Vci_ei)*FCd_f_Vbi_ci+((2.0*FCw_Vbi_ci))*FCd_f_Vci_ei+(2.0*FCw)*FCd_f_Vci_ei_Vbi_ci)*FCd_f+(((2.0*FCw_Vci_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei))*FCd_f_Vbi_ci+(((((2.0*FCw_Vbi_ci))*FCd_f)+((2.0*FCw)*FCd_f_Vbi_ci)))*FCd_f_Vci_ei+((2.0*FCw)*FCd_f)*FCd_f_Vci_ei_Vbi_ci);
  FCdfCT_dw_Vci_ei_Vci_ei=(+(+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vci_ei)*FCd_f+(2.0*FCw_Vci_ei)*FCd_f_Vci_ei+((2.0*FCw_Vci_ei))*FCd_f_Vci_ei+(2.0*FCw)*FCd_f_Vci_ei_Vci_ei)*FCd_f+(((2.0*FCw_Vci_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei))*FCd_f_Vci_ei+(((((2.0*FCw_Vci_ei))*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei)))*FCd_f_Vci_ei+((2.0*FCw)*FCd_f)*FCd_f_Vci_ei_Vci_ei);
  FCdfCT_dw_Vci_ei_Vtnode_GND=(+(+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vtnode_GND)*FCd_f+(2.0*FCw_Vci_ei)*FCd_f_Vtnode_GND+((2.0*FCw_Vtnode_GND))*FCd_f_Vci_ei+(2.0*FCw)*FCd_f_Vci_ei_Vtnode_GND)*FCd_f+(((2.0*FCw_Vci_ei)*FCd_f)+((2.0*FCw)*FCd_f_Vci_ei))*FCd_f_Vtnode_GND+(((((2.0*FCw_Vtnode_GND))*FCd_f)+((2.0*FCw)*FCd_f_Vtnode_GND)))*FCd_f_Vci_ei+((2.0*FCw)*FCd_f)*FCd_f_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCdfCT_dw_Vtnode_GND=(((((2.0*FCw_Vtnode_GND)*FCd_f)+((2.0*FCw)*FCd_f_Vtnode_GND))*FCd_f)+(((2.0*FCw)*FCd_f)*FCd_f_Vtnode_GND));
#endif
#endif
FCdfCT_dw=(((2.0*FCw)*FCd_f)*FCd_f);
}
else
{
#if defined(_DERIVATEFORDDX)
FCf_CT_Vbi_ei=((((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ei/3.0))))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ei));
#if defined(_DERIVATE)
  FCf_CT_Vbi_ei_Vbi_ei=(+(+FCw2_Vbi_ei_Vbi_ei*(1.0-(FCz/3.0))+FCw2_Vbi_ei*(-(FCz_Vbi_ei/3.0))+FCw2_Vbi_ei*(-(FCz_Vbi_ei/3.0))+FCw2*(+0.0-(FCz_Vbi_ei_Vbi_ei/3.0-(FCz_Vbi_ei*0.0+FCz_Vbi_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ei/3.0))))*FCd_f_Vbi_ei+(((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ei/3.0)))))*FCd_f_Vbi_ei+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ei_Vbi_ei);
  FCf_CT_Vbi_ei_Vbi_ci=(+(+FCw2_Vbi_ei_Vbi_ci*(1.0-(FCz/3.0))+FCw2_Vbi_ei*(-(FCz_Vbi_ci/3.0))+FCw2_Vbi_ci*(-(FCz_Vbi_ei/3.0))+FCw2*(+0.0-(FCz_Vbi_ei_Vbi_ci/3.0-(FCz_Vbi_ei*0.0+FCz_Vbi_ci*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ei/3.0))))*FCd_f_Vbi_ci+(((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ci/3.0)))))*FCd_f_Vbi_ei+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ei_Vbi_ci);
  FCf_CT_Vbi_ei_Vci_ei=(+(+FCw2_Vbi_ei_Vci_ei*(1.0-(FCz/3.0))+FCw2_Vbi_ei*(-(FCz_Vci_ei/3.0))+FCw2_Vci_ei*(-(FCz_Vbi_ei/3.0))+FCw2*(+0.0-(FCz_Vbi_ei_Vci_ei/3.0-(FCz_Vbi_ei*0.0+FCz_Vci_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ei/3.0))))*FCd_f_Vci_ei+(((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vci_ei/3.0)))))*FCd_f_Vbi_ei+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ei_Vci_ei);
  FCf_CT_Vbi_ei_Vtnode_GND=(+(+FCw2_Vbi_ei_Vtnode_GND*(1.0-(FCz/3.0))+FCw2_Vbi_ei*(-(FCz_Vtnode_GND/3.0))+FCw2_Vtnode_GND*(-(FCz_Vbi_ei/3.0))+FCw2*(+0.0-(FCz_Vbi_ei_Vtnode_GND/3.0-(FCz_Vbi_ei*0.0+FCz_Vtnode_GND*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ei/3.0))))*FCd_f_Vtnode_GND+(((FCw2_Vtnode_GND*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vtnode_GND/3.0)))))*FCd_f_Vbi_ei+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ei_Vtnode_GND);
#endif
FCf_CT_Vbi_ci=((((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ci/3.0))))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ci));
#if defined(_DERIVATE)
  FCf_CT_Vbi_ci_Vbi_ei=(+(+FCw2_Vbi_ci_Vbi_ei*(1.0-(FCz/3.0))+FCw2_Vbi_ci*(-(FCz_Vbi_ei/3.0))+FCw2_Vbi_ei*(-(FCz_Vbi_ci/3.0))+FCw2*(+0.0-(FCz_Vbi_ci_Vbi_ei/3.0-(FCz_Vbi_ci*0.0+FCz_Vbi_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ci/3.0))))*FCd_f_Vbi_ei+(((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ei/3.0)))))*FCd_f_Vbi_ci+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ci_Vbi_ei);
  FCf_CT_Vbi_ci_Vbi_ci=(+(+FCw2_Vbi_ci_Vbi_ci*(1.0-(FCz/3.0))+FCw2_Vbi_ci*(-(FCz_Vbi_ci/3.0))+FCw2_Vbi_ci*(-(FCz_Vbi_ci/3.0))+FCw2*(+0.0-(FCz_Vbi_ci_Vbi_ci/3.0-(FCz_Vbi_ci*0.0+FCz_Vbi_ci*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ci/3.0))))*FCd_f_Vbi_ci+(((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ci/3.0)))))*FCd_f_Vbi_ci+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ci_Vbi_ci);
  FCf_CT_Vbi_ci_Vci_ei=(+(+FCw2_Vbi_ci_Vci_ei*(1.0-(FCz/3.0))+FCw2_Vbi_ci*(-(FCz_Vci_ei/3.0))+FCw2_Vci_ei*(-(FCz_Vbi_ci/3.0))+FCw2*(+0.0-(FCz_Vbi_ci_Vci_ei/3.0-(FCz_Vbi_ci*0.0+FCz_Vci_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ci/3.0))))*FCd_f_Vci_ei+(((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vci_ei/3.0)))))*FCd_f_Vbi_ci+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ci_Vci_ei);
  FCf_CT_Vbi_ci_Vtnode_GND=(+(+FCw2_Vbi_ci_Vtnode_GND*(1.0-(FCz/3.0))+FCw2_Vbi_ci*(-(FCz_Vtnode_GND/3.0))+FCw2_Vtnode_GND*(-(FCz_Vbi_ci/3.0))+FCw2*(+0.0-(FCz_Vbi_ci_Vtnode_GND/3.0-(FCz_Vbi_ci*0.0+FCz_Vtnode_GND*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ci/3.0))))*FCd_f_Vtnode_GND+(((FCw2_Vtnode_GND*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vtnode_GND/3.0)))))*FCd_f_Vbi_ci+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vbi_ci_Vtnode_GND);
#endif
FCf_CT_Vci_ei=((((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vci_ei/3.0))))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vci_ei));
#if defined(_DERIVATE)
  FCf_CT_Vci_ei_Vbi_ei=(+(+FCw2_Vci_ei_Vbi_ei*(1.0-(FCz/3.0))+FCw2_Vci_ei*(-(FCz_Vbi_ei/3.0))+FCw2_Vbi_ei*(-(FCz_Vci_ei/3.0))+FCw2*(+0.0-(FCz_Vci_ei_Vbi_ei/3.0-(FCz_Vci_ei*0.0+FCz_Vbi_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vci_ei/3.0))))*FCd_f_Vbi_ei+(((FCw2_Vbi_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ei/3.0)))))*FCd_f_Vci_ei+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vci_ei_Vbi_ei);
  FCf_CT_Vci_ei_Vbi_ci=(+(+FCw2_Vci_ei_Vbi_ci*(1.0-(FCz/3.0))+FCw2_Vci_ei*(-(FCz_Vbi_ci/3.0))+FCw2_Vbi_ci*(-(FCz_Vci_ei/3.0))+FCw2*(+0.0-(FCz_Vci_ei_Vbi_ci/3.0-(FCz_Vci_ei*0.0+FCz_Vbi_ci*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vci_ei/3.0))))*FCd_f_Vbi_ci+(((FCw2_Vbi_ci*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vbi_ci/3.0)))))*FCd_f_Vci_ei+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vci_ei_Vbi_ci);
  FCf_CT_Vci_ei_Vci_ei=(+(+FCw2_Vci_ei_Vci_ei*(1.0-(FCz/3.0))+FCw2_Vci_ei*(-(FCz_Vci_ei/3.0))+FCw2_Vci_ei*(-(FCz_Vci_ei/3.0))+FCw2*(+0.0-(FCz_Vci_ei_Vci_ei/3.0-(FCz_Vci_ei*0.0+FCz_Vci_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vci_ei/3.0))))*FCd_f_Vci_ei+(((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vci_ei/3.0)))))*FCd_f_Vci_ei+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vci_ei_Vci_ei);
  FCf_CT_Vci_ei_Vtnode_GND=(+(+FCw2_Vci_ei_Vtnode_GND*(1.0-(FCz/3.0))+FCw2_Vci_ei*(-(FCz_Vtnode_GND/3.0))+FCw2_Vtnode_GND*(-(FCz_Vci_ei/3.0))+FCw2*(+0.0-(FCz_Vci_ei_Vtnode_GND/3.0-(FCz_Vci_ei*0.0+FCz_Vtnode_GND*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vci_ei/3.0))))*FCd_f_Vtnode_GND+(((FCw2_Vtnode_GND*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vtnode_GND/3.0)))))*FCd_f_Vci_ei+(FCw2*(1.0-(FCz/3.0)))*FCd_f_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCf_CT_Vtnode_GND=((((FCw2_Vtnode_GND*(1.0-(FCz/3.0)))+(FCw2*(-(FCz_Vtnode_GND/3.0))))*FCd_f)+((FCw2*(1.0-(FCz/3.0)))*FCd_f_Vtnode_GND));
#endif
#endif
FCf_CT=((FCw2*(1.0-(FCz/3.0)))*FCd_f);
#if defined(_DERIVATEFORDDX)
FCdfCT_dw_Vbi_ei=(((((((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei));
#if defined(_DERIVATE)
  FCdfCT_dw_Vbi_ei_Vbi_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vbi_ei)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ei)*(-((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0))+((2.0*FCw_Vbi_ei))*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vbi_ei_Vbi_ei*FCz+FCz_Vbi_ei*FCz_Vbi_ei+FCz_Vbi_ei*FCz_Vbi_ei+FCz*FCz_Vbi_ei_Vbi_ei)/3.0-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))*0.0+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f_Vbi_ei+(((((2.0*FCw_Vbi_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f_Vbi_ei+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei_Vbi_ei)*FCd_f+(((((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f_Vbi_ei+((((((((2.0*FCw_Vbi_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei)))*FCd_f_Vbi_ei+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei_Vbi_ei);
  FCdfCT_dw_Vbi_ei_Vbi_ci=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vbi_ci)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ei)*(-((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0))+((2.0*FCw_Vbi_ci))*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vbi_ei_Vbi_ci*FCz+FCz_Vbi_ei*FCz_Vbi_ci+FCz_Vbi_ci*FCz_Vbi_ei+FCz*FCz_Vbi_ei_Vbi_ci)/3.0-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))*0.0+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f_Vbi_ci+(((((2.0*FCw_Vbi_ci))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f_Vbi_ei+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei_Vbi_ci)*FCd_f+(((((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f_Vbi_ci+((((((((2.0*FCw_Vbi_ci))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci)))*FCd_f_Vbi_ei+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei_Vbi_ci);
  FCdfCT_dw_Vbi_ei_Vci_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vci_ei)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ei)*(-((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0))+((2.0*FCw_Vci_ei))*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vbi_ei_Vci_ei*FCz+FCz_Vbi_ei*FCz_Vci_ei+FCz_Vci_ei*FCz_Vbi_ei+FCz*FCz_Vbi_ei_Vci_ei)/3.0-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))*0.0+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f_Vci_ei+(((((2.0*FCw_Vci_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f_Vbi_ei+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei_Vci_ei)*FCd_f+(((((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f_Vci_ei+((((((((2.0*FCw_Vci_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei)))*FCd_f_Vbi_ei+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei_Vci_ei);
  FCdfCT_dw_Vbi_ei_Vtnode_GND=(+(+(+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+2.0*FCw_Vbi_ei_Vtnode_GND)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ei)*(-((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0))+((2.0*FCw_Vtnode_GND))*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vbi_ei_Vtnode_GND*FCz+FCz_Vbi_ei*FCz_Vtnode_GND+FCz_Vtnode_GND*FCz_Vbi_ei+FCz*FCz_Vbi_ei_Vtnode_GND)/3.0-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))*0.0+(((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f_Vtnode_GND+(((((2.0*FCw_Vtnode_GND))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f_Vbi_ei+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei_Vtnode_GND)*FCd_f+(((((2.0*FCw_Vbi_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei))*FCd_f_Vtnode_GND+((((((((2.0*FCw_Vtnode_GND))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND)))*FCd_f_Vbi_ei+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ei_Vtnode_GND);
#endif
FCdfCT_dw_Vbi_ci=(((((((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci));
#if defined(_DERIVATE)
  FCdfCT_dw_Vbi_ci_Vbi_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vbi_ei)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ci)*(-((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0))+((2.0*FCw_Vbi_ei))*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vbi_ci_Vbi_ei*FCz+FCz_Vbi_ci*FCz_Vbi_ei+FCz_Vbi_ei*FCz_Vbi_ci+FCz*FCz_Vbi_ci_Vbi_ei)/3.0-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))*0.0+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f_Vbi_ei+(((((2.0*FCw_Vbi_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f_Vbi_ci+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci_Vbi_ei)*FCd_f+(((((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f_Vbi_ei+((((((((2.0*FCw_Vbi_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei)))*FCd_f_Vbi_ci+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci_Vbi_ei);
  FCdfCT_dw_Vbi_ci_Vbi_ci=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vbi_ci)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ci)*(-((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0))+((2.0*FCw_Vbi_ci))*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vbi_ci_Vbi_ci*FCz+FCz_Vbi_ci*FCz_Vbi_ci+FCz_Vbi_ci*FCz_Vbi_ci+FCz*FCz_Vbi_ci_Vbi_ci)/3.0-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))*0.0+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f_Vbi_ci+(((((2.0*FCw_Vbi_ci))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f_Vbi_ci+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci_Vbi_ci)*FCd_f+(((((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f_Vbi_ci+((((((((2.0*FCw_Vbi_ci))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci)))*FCd_f_Vbi_ci+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci_Vbi_ci);
  FCdfCT_dw_Vbi_ci_Vci_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vci_ei)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ci)*(-((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0))+((2.0*FCw_Vci_ei))*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vbi_ci_Vci_ei*FCz+FCz_Vbi_ci*FCz_Vci_ei+FCz_Vci_ei*FCz_Vbi_ci+FCz*FCz_Vbi_ci_Vci_ei)/3.0-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))*0.0+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f_Vci_ei+(((((2.0*FCw_Vci_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f_Vbi_ci+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci_Vci_ei)*FCd_f+(((((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f_Vci_ei+((((((((2.0*FCw_Vci_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei)))*FCd_f_Vbi_ci+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci_Vci_ei);
  FCdfCT_dw_Vbi_ci_Vtnode_GND=(+(+(+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+2.0*FCw_Vbi_ci_Vtnode_GND)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vbi_ci)*(-((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0))+((2.0*FCw_Vtnode_GND))*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vbi_ci_Vtnode_GND*FCz+FCz_Vbi_ci*FCz_Vtnode_GND+FCz_Vtnode_GND*FCz_Vbi_ci+FCz*FCz_Vbi_ci_Vtnode_GND)/3.0-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))*0.0+(((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f_Vtnode_GND+(((((2.0*FCw_Vtnode_GND))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f_Vbi_ci+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci_Vtnode_GND)*FCd_f+(((((2.0*FCw_Vbi_ci)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci))*FCd_f_Vtnode_GND+((((((((2.0*FCw_Vtnode_GND))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND)))*FCd_f_Vbi_ci+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vbi_ci_Vtnode_GND);
#endif
FCdfCT_dw_Vci_ei=(((((((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei));
#if defined(_DERIVATE)
  FCdfCT_dw_Vci_ei_Vbi_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vbi_ei)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vci_ei)*(-((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0))+((2.0*FCw_Vbi_ei))*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vci_ei_Vbi_ei*FCz+FCz_Vci_ei*FCz_Vbi_ei+FCz_Vbi_ei*FCz_Vci_ei+FCz*FCz_Vci_ei_Vbi_ei)/3.0-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))*0.0+(((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f_Vbi_ei+(((((2.0*FCw_Vbi_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f_Vci_ei+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei_Vbi_ei)*FCd_f+(((((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f_Vbi_ei+((((((((2.0*FCw_Vbi_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ei*FCz)+(FCz*FCz_Vbi_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ei)))*FCd_f_Vci_ei+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei_Vbi_ei);
  FCdfCT_dw_Vci_ei_Vbi_ci=(+(+(+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vbi_ci)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vci_ei)*(-((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0))+((2.0*FCw_Vbi_ci))*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vci_ei_Vbi_ci*FCz+FCz_Vci_ei*FCz_Vbi_ci+FCz_Vbi_ci*FCz_Vci_ei+FCz*FCz_Vci_ei_Vbi_ci)/3.0-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))*0.0+(((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f_Vbi_ci+(((((2.0*FCw_Vbi_ci))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f_Vci_ei+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei_Vbi_ci)*FCd_f+(((((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f_Vbi_ci+((((((((2.0*FCw_Vbi_ci))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vbi_ci*FCz)+(FCz*FCz_Vbi_ci)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vbi_ci)))*FCd_f_Vci_ei+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei_Vbi_ci);
  FCdfCT_dw_Vci_ei_Vci_ei=(+(+(+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vci_ei)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vci_ei)*(-((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0))+((2.0*FCw_Vci_ei))*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vci_ei_Vci_ei*FCz+FCz_Vci_ei*FCz_Vci_ei+FCz_Vci_ei*FCz_Vci_ei+FCz*FCz_Vci_ei_Vci_ei)/3.0-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))*0.0+(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f_Vci_ei+(((((2.0*FCw_Vci_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f_Vci_ei+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei_Vci_ei)*FCd_f+(((((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f_Vci_ei+((((((((2.0*FCw_Vci_ei))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei)))*FCd_f_Vci_ei+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei_Vci_ei);
  FCdfCT_dw_Vci_ei_Vtnode_GND=(+(+(+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+2.0*FCw_Vci_ei_Vtnode_GND)*(1.0-((FCz*FCz)/3.0))+(2.0*FCw_Vci_ei)*(-((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0))+((2.0*FCw_Vtnode_GND))*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))+(2.0*FCw)*(+0.0-((+FCz_Vci_ei_Vtnode_GND*FCz+FCz_Vci_ei*FCz_Vtnode_GND+FCz_Vtnode_GND*FCz_Vci_ei+FCz*FCz_Vci_ei_Vtnode_GND)/3.0-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))*0.0+(((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))*0.0+(FCz*FCz)*0.0)/3.0/3.0+2*(FCz*FCz)*0.0*0.0/3.0/3.0/3.0)))*FCd_f+(((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f_Vtnode_GND+(((((2.0*FCw_Vtnode_GND))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f_Vci_ei+((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei_Vtnode_GND)*FCd_f+(((((2.0*FCw_Vci_ei)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vci_ei*FCz)+(FCz*FCz_Vci_ei))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vci_ei))*FCd_f_Vtnode_GND+((((((((2.0*FCw_Vtnode_GND))*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-((((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND)))/3.0)))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND)))*FCd_f_Vci_ei+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCdfCT_dw_Vtnode_GND=(((((((2.0*FCw_Vtnode_GND)*(1.0-((FCz*FCz)/3.0)))+((2.0*FCw)*(-(((FCz_Vtnode_GND*FCz)+(FCz*FCz_Vtnode_GND))/3.0))))*FCd_f)+(((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f_Vtnode_GND))*FCd_f)+((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f_Vtnode_GND));
#endif
#endif
FCdfCT_dw=((((2.0*FCw)*(1.0-((FCz*FCz)/3.0)))*FCd_f)*FCd_f);
}
#if defined(_DERIVATEFORDDX)
FCdfCT_ditf_Vbi_ei=((FCdfCT_dw_Vbi_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ei));
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ei_Vbi_ei=(+FCdfCT_dw_Vbi_ei_Vbi_ei*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vbi_ei);
  FCdfCT_ditf_Vbi_ei_Vbi_ci=(+FCdfCT_dw_Vbi_ei_Vbi_ci*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vbi_ci);
  FCdfCT_ditf_Vbi_ei_Vci_ei=(+FCdfCT_dw_Vbi_ei_Vci_ei*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vci_ei);
  FCdfCT_ditf_Vbi_ei_Vtnode_GND=(+FCdfCT_dw_Vbi_ei_Vtnode_GND*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vtnode_GND+FCdfCT_dw_Vtnode_GND*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vtnode_GND);
#endif
FCdfCT_ditf_Vbi_ci=((FCdfCT_dw_Vbi_ci*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ci));
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ci_Vbi_ei=(+FCdfCT_dw_Vbi_ci_Vbi_ei*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vbi_ei);
  FCdfCT_ditf_Vbi_ci_Vbi_ci=(+FCdfCT_dw_Vbi_ci_Vbi_ci*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vbi_ci);
  FCdfCT_ditf_Vbi_ci_Vci_ei=(+FCdfCT_dw_Vbi_ci_Vci_ei*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vci_ei);
  FCdfCT_ditf_Vbi_ci_Vtnode_GND=(+FCdfCT_dw_Vbi_ci_Vtnode_GND*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vtnode_GND+FCdfCT_dw_Vtnode_GND*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vtnode_GND);
#endif
FCdfCT_ditf_Vci_ei=((FCdfCT_dw_Vci_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vci_ei));
#if defined(_DERIVATE)
  FCdfCT_ditf_Vci_ei_Vbi_ei=(+FCdfCT_dw_Vci_ei_Vbi_ei*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vbi_ei);
  FCdfCT_ditf_Vci_ei_Vbi_ci=(+FCdfCT_dw_Vci_ei_Vbi_ci*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vbi_ci);
  FCdfCT_ditf_Vci_ei_Vci_ei=(+FCdfCT_dw_Vci_ei_Vci_ei*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfCT_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vci_ei);
  FCdfCT_ditf_Vci_ei_Vtnode_GND=(+FCdfCT_dw_Vci_ei_Vtnode_GND*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vtnode_GND+FCdfCT_dw_Vtnode_GND*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCdfCT_ditf_Vtnode_GND=((FCdfCT_dw_Vtnode_GND*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vtnode_GND));
#endif
#endif
FCdfCT_ditf=(FCdfCT_dw*FCdw_ditf);
}
else
{
#if defined(_DERIVATEFORDDX)
FCf_CT_Vbi_ei=FCf_ci_Vbi_ei;
#if defined(_DERIVATE)
  FCf_CT_Vbi_ei_Vbi_ei=FCf_ci_Vbi_ei_Vbi_ei;
  FCf_CT_Vbi_ei_Vbi_ci=FCf_ci_Vbi_ei_Vbi_ci;
  FCf_CT_Vbi_ei_Vci_ei=FCf_ci_Vbi_ei_Vci_ei;
  FCf_CT_Vbi_ei_Vtnode_GND=FCf_ci_Vbi_ei_Vtnode_GND;
#endif
FCf_CT_Vbi_ci=FCf_ci_Vbi_ci;
#if defined(_DERIVATE)
  FCf_CT_Vbi_ci_Vbi_ei=FCf_ci_Vbi_ci_Vbi_ei;
  FCf_CT_Vbi_ci_Vbi_ci=FCf_ci_Vbi_ci_Vbi_ci;
  FCf_CT_Vbi_ci_Vci_ei=FCf_ci_Vbi_ci_Vci_ei;
  FCf_CT_Vbi_ci_Vtnode_GND=FCf_ci_Vbi_ci_Vtnode_GND;
#endif
FCf_CT_Vci_ei=FCf_ci_Vci_ei;
#if defined(_DERIVATE)
  FCf_CT_Vci_ei_Vbi_ei=FCf_ci_Vci_ei_Vbi_ei;
  FCf_CT_Vci_ei_Vbi_ci=FCf_ci_Vci_ei_Vbi_ci;
  FCf_CT_Vci_ei_Vci_ei=FCf_ci_Vci_ei_Vci_ei;
  FCf_CT_Vci_ei_Vtnode_GND=FCf_ci_Vci_ei_Vtnode_GND;
#endif
#if defined(_DERIVATE)
FCf_CT_Vtnode_GND=FCf_ci_Vtnode_GND;
#endif
#endif
FCf_CT=FCf_ci;
#if defined(_DERIVATEFORDDX)
FCdfCT_ditf_Vbi_ei=FCdfc_ditf_Vbi_ei;
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ei_Vbi_ei=FCdfc_ditf_Vbi_ei_Vbi_ei;
  FCdfCT_ditf_Vbi_ei_Vbi_ci=FCdfc_ditf_Vbi_ei_Vbi_ci;
  FCdfCT_ditf_Vbi_ei_Vci_ei=FCdfc_ditf_Vbi_ei_Vci_ei;
  FCdfCT_ditf_Vbi_ei_Vtnode_GND=FCdfc_ditf_Vbi_ei_Vtnode_GND;
#endif
FCdfCT_ditf_Vbi_ci=FCdfc_ditf_Vbi_ci;
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ci_Vbi_ei=FCdfc_ditf_Vbi_ci_Vbi_ei;
  FCdfCT_ditf_Vbi_ci_Vbi_ci=FCdfc_ditf_Vbi_ci_Vbi_ci;
  FCdfCT_ditf_Vbi_ci_Vci_ei=FCdfc_ditf_Vbi_ci_Vci_ei;
  FCdfCT_ditf_Vbi_ci_Vtnode_GND=FCdfc_ditf_Vbi_ci_Vtnode_GND;
#endif
FCdfCT_ditf_Vci_ei=FCdfc_ditf_Vci_ei;
#if defined(_DERIVATE)
  FCdfCT_ditf_Vci_ei_Vbi_ei=FCdfc_ditf_Vci_ei_Vbi_ei;
  FCdfCT_ditf_Vci_ei_Vbi_ci=FCdfc_ditf_Vci_ei_Vbi_ci;
  FCdfCT_ditf_Vci_ei_Vci_ei=FCdfc_ditf_Vci_ei_Vci_ei;
  FCdfCT_ditf_Vci_ei_Vtnode_GND=FCdfc_ditf_Vci_ei_Vtnode_GND;
#endif
#if defined(_DERIVATE)
FCdfCT_ditf_Vtnode_GND=FCdfc_ditf_Vtnode_GND;
#endif
#endif
FCdfCT_ditf=FCdfc_ditf;
}
}
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFQ_cT_Vtnode_GND=((FFQ_fC_Vtnode_GND*FCf_CT)+(FFQ_fC*FCf_CT_Vtnode_GND));
#endif
FFQ_cT_Vbi_ei=((FFQ_fC_Vbi_ei*FCf_CT)+(FFQ_fC*FCf_CT_Vbi_ei));
#if defined(_DERIVATE)
  FFQ_cT_Vbi_ei_Vtnode_GND=(+FFQ_fC_Vbi_ei_Vtnode_GND*FCf_CT+FFQ_fC_Vbi_ei*FCf_CT_Vtnode_GND+FFQ_fC_Vtnode_GND*FCf_CT_Vbi_ei+FFQ_fC*FCf_CT_Vbi_ei_Vtnode_GND);
  FFQ_cT_Vbi_ei_Vbi_ei=(+FFQ_fC_Vbi_ei_Vbi_ei*FCf_CT+FFQ_fC_Vbi_ei*FCf_CT_Vbi_ei+FFQ_fC_Vbi_ei*FCf_CT_Vbi_ei+FFQ_fC*FCf_CT_Vbi_ei_Vbi_ei);
  FFQ_cT_Vbi_ei_Vbi_ci=(+FFQ_fC_Vbi_ei_Vbi_ci*FCf_CT+FFQ_fC_Vbi_ei*FCf_CT_Vbi_ci+FFQ_fC_Vbi_ci*FCf_CT_Vbi_ei+FFQ_fC*FCf_CT_Vbi_ei_Vbi_ci);
  FFQ_cT_Vbi_ei_Vci_ei=(+FFQ_fC_Vbi_ei_Vci_ei*FCf_CT+FFQ_fC_Vbi_ei*FCf_CT_Vci_ei+FFQ_fC_Vci_ei*FCf_CT_Vbi_ei+FFQ_fC*FCf_CT_Vbi_ei_Vci_ei);
#endif
FFQ_cT_Vbi_ci=((FFQ_fC_Vbi_ci*FCf_CT)+(FFQ_fC*FCf_CT_Vbi_ci));
#if defined(_DERIVATE)
  FFQ_cT_Vbi_ci_Vtnode_GND=(+FFQ_fC_Vbi_ci_Vtnode_GND*FCf_CT+FFQ_fC_Vbi_ci*FCf_CT_Vtnode_GND+FFQ_fC_Vtnode_GND*FCf_CT_Vbi_ci+FFQ_fC*FCf_CT_Vbi_ci_Vtnode_GND);
  FFQ_cT_Vbi_ci_Vbi_ei=(+FFQ_fC_Vbi_ci_Vbi_ei*FCf_CT+FFQ_fC_Vbi_ci*FCf_CT_Vbi_ei+FFQ_fC_Vbi_ei*FCf_CT_Vbi_ci+FFQ_fC*FCf_CT_Vbi_ci_Vbi_ei);
  FFQ_cT_Vbi_ci_Vbi_ci=(+FFQ_fC_Vbi_ci_Vbi_ci*FCf_CT+FFQ_fC_Vbi_ci*FCf_CT_Vbi_ci+FFQ_fC_Vbi_ci*FCf_CT_Vbi_ci+FFQ_fC*FCf_CT_Vbi_ci_Vbi_ci);
  FFQ_cT_Vbi_ci_Vci_ei=(+FFQ_fC_Vbi_ci_Vci_ei*FCf_CT+FFQ_fC_Vbi_ci*FCf_CT_Vci_ei+FFQ_fC_Vci_ei*FCf_CT_Vbi_ci+FFQ_fC*FCf_CT_Vbi_ci_Vci_ei);
#endif
FFQ_cT_Vci_ei=((FFQ_fC_Vci_ei*FCf_CT)+(FFQ_fC*FCf_CT_Vci_ei));
#if defined(_DERIVATE)
  FFQ_cT_Vci_ei_Vtnode_GND=(+FFQ_fC_Vci_ei_Vtnode_GND*FCf_CT+FFQ_fC_Vci_ei*FCf_CT_Vtnode_GND+FFQ_fC_Vtnode_GND*FCf_CT_Vci_ei+FFQ_fC*FCf_CT_Vci_ei_Vtnode_GND);
  FFQ_cT_Vci_ei_Vbi_ei=(+FFQ_fC_Vci_ei_Vbi_ei*FCf_CT+FFQ_fC_Vci_ei*FCf_CT_Vbi_ei+FFQ_fC_Vbi_ei*FCf_CT_Vci_ei+FFQ_fC*FCf_CT_Vci_ei_Vbi_ei);
  FFQ_cT_Vci_ei_Vbi_ci=(+FFQ_fC_Vci_ei_Vbi_ci*FCf_CT+FFQ_fC_Vci_ei*FCf_CT_Vbi_ci+FFQ_fC_Vbi_ci*FCf_CT_Vci_ei+FFQ_fC*FCf_CT_Vci_ei_Vbi_ci);
  FFQ_cT_Vci_ei_Vci_ei=(+FFQ_fC_Vci_ei_Vci_ei*FCf_CT+FFQ_fC_Vci_ei*FCf_CT_Vci_ei+FFQ_fC_Vci_ei*FCf_CT_Vci_ei+FFQ_fC*FCf_CT_Vci_ei_Vci_ei);
#endif
#endif
FFQ_cT=(FFQ_fC*FCf_CT);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFQ_fC_Vtnode_GND=((FFQ_fC_Vtnode_GND*FCf_ci)+(FFQ_fC*FCf_ci_Vtnode_GND));
#endif
FFQ_fC_Vbi_ei=((FFQ_fC_Vbi_ei*FCf_ci)+(FFQ_fC*FCf_ci_Vbi_ei));
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ei_Vtnode_GND=(+FFQ_fC_Vbi_ei_Vtnode_GND*FCf_ci+FFQ_fC_Vbi_ei*FCf_ci_Vtnode_GND+FFQ_fC_Vtnode_GND*FCf_ci_Vbi_ei+FFQ_fC*FCf_ci_Vbi_ei_Vtnode_GND);
  FFQ_fC_Vbi_ei_Vbi_ei=(+FFQ_fC_Vbi_ei_Vbi_ei*FCf_ci+FFQ_fC_Vbi_ei*FCf_ci_Vbi_ei+FFQ_fC_Vbi_ei*FCf_ci_Vbi_ei+FFQ_fC*FCf_ci_Vbi_ei_Vbi_ei);
  FFQ_fC_Vbi_ei_Vbi_ci=(+FFQ_fC_Vbi_ei_Vbi_ci*FCf_ci+FFQ_fC_Vbi_ei*FCf_ci_Vbi_ci+FFQ_fC_Vbi_ci*FCf_ci_Vbi_ei+FFQ_fC*FCf_ci_Vbi_ei_Vbi_ci);
  FFQ_fC_Vbi_ei_Vci_ei=(+FFQ_fC_Vbi_ei_Vci_ei*FCf_ci+FFQ_fC_Vbi_ei*FCf_ci_Vci_ei+FFQ_fC_Vci_ei*FCf_ci_Vbi_ei+FFQ_fC*FCf_ci_Vbi_ei_Vci_ei);
#endif
FFQ_fC_Vbi_ci=((FFQ_fC_Vbi_ci*FCf_ci)+(FFQ_fC*FCf_ci_Vbi_ci));
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ci_Vtnode_GND=(+FFQ_fC_Vbi_ci_Vtnode_GND*FCf_ci+FFQ_fC_Vbi_ci*FCf_ci_Vtnode_GND+FFQ_fC_Vtnode_GND*FCf_ci_Vbi_ci+FFQ_fC*FCf_ci_Vbi_ci_Vtnode_GND);
  FFQ_fC_Vbi_ci_Vbi_ei=(+FFQ_fC_Vbi_ci_Vbi_ei*FCf_ci+FFQ_fC_Vbi_ci*FCf_ci_Vbi_ei+FFQ_fC_Vbi_ei*FCf_ci_Vbi_ci+FFQ_fC*FCf_ci_Vbi_ci_Vbi_ei);
  FFQ_fC_Vbi_ci_Vbi_ci=(+FFQ_fC_Vbi_ci_Vbi_ci*FCf_ci+FFQ_fC_Vbi_ci*FCf_ci_Vbi_ci+FFQ_fC_Vbi_ci*FCf_ci_Vbi_ci+FFQ_fC*FCf_ci_Vbi_ci_Vbi_ci);
  FFQ_fC_Vbi_ci_Vci_ei=(+FFQ_fC_Vbi_ci_Vci_ei*FCf_ci+FFQ_fC_Vbi_ci*FCf_ci_Vci_ei+FFQ_fC_Vci_ei*FCf_ci_Vbi_ci+FFQ_fC*FCf_ci_Vbi_ci_Vci_ei);
#endif
FFQ_fC_Vci_ei=((FFQ_fC_Vci_ei*FCf_ci)+(FFQ_fC*FCf_ci_Vci_ei));
#if defined(_DERIVATE)
  FFQ_fC_Vci_ei_Vtnode_GND=(+FFQ_fC_Vci_ei_Vtnode_GND*FCf_ci+FFQ_fC_Vci_ei*FCf_ci_Vtnode_GND+FFQ_fC_Vtnode_GND*FCf_ci_Vci_ei+FFQ_fC*FCf_ci_Vci_ei_Vtnode_GND);
  FFQ_fC_Vci_ei_Vbi_ei=(+FFQ_fC_Vci_ei_Vbi_ei*FCf_ci+FFQ_fC_Vci_ei*FCf_ci_Vbi_ei+FFQ_fC_Vbi_ei*FCf_ci_Vci_ei+FFQ_fC*FCf_ci_Vci_ei_Vbi_ei);
  FFQ_fC_Vci_ei_Vbi_ci=(+FFQ_fC_Vci_ei_Vbi_ci*FCf_ci+FFQ_fC_Vci_ei*FCf_ci_Vbi_ci+FFQ_fC_Vbi_ci*FCf_ci_Vci_ei+FFQ_fC*FCf_ci_Vci_ei_Vbi_ci);
  FFQ_fC_Vci_ei_Vci_ei=(+FFQ_fC_Vci_ei_Vci_ei*FCf_ci+FFQ_fC_Vci_ei*FCf_ci_Vci_ei+FFQ_fC_Vci_ei*FCf_ci_Vci_ei+FFQ_fC*FCf_ci_Vci_ei_Vci_ei);
#endif
#endif
FFQ_fC=(FFQ_fC*FCf_ci);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFT_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*(FCf_ci+(itf*FCdfc_ditf)))+(FFT_pcS*(FCf_ci_Vtnode_GND+((itf_Vtnode_GND*FCdfc_ditf)+(itf*FCdfc_ditf_Vtnode_GND)))));
#endif
FFT_fC_Vci_ei=(FFT_pcS*(FCf_ci_Vci_ei+((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei))));
#if defined(_DERIVATE)
  FFT_fC_Vci_ei_Vtnode_GND=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vtnode_GND+(((itf_Vtnode_GND*FCdfc_ditf)+(itf*FCdfc_ditf_Vtnode_GND))))+FFT_pcS_Vtnode_GND*(FCf_ci_Vci_ei+((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei)))+FFT_pcS*(+FCf_ci_Vci_ei_Vtnode_GND+(+itf_Vci_ei_Vtnode_GND*FCdfc_ditf+itf_Vci_ei*FCdfc_ditf_Vtnode_GND+itf_Vtnode_GND*FCdfc_ditf_Vci_ei+itf*FCdfc_ditf_Vci_ei_Vtnode_GND)));
  FFT_fC_Vci_ei_Vci_ei=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vci_ei+(((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei))))+0.0*(FCf_ci_Vci_ei+((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei)))+FFT_pcS*(+FCf_ci_Vci_ei_Vci_ei+(+itf_Vci_ei_Vci_ei*FCdfc_ditf+itf_Vci_ei*FCdfc_ditf_Vci_ei+itf_Vci_ei*FCdfc_ditf_Vci_ei+itf*FCdfc_ditf_Vci_ei_Vci_ei)));
  FFT_fC_Vci_ei_Vbi_ei=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vbi_ei+(((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei))))+0.0*(FCf_ci_Vci_ei+((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei)))+FFT_pcS*(+FCf_ci_Vci_ei_Vbi_ei+(+itf_Vci_ei_Vbi_ei*FCdfc_ditf+itf_Vci_ei*FCdfc_ditf_Vbi_ei+itf_Vbi_ei*FCdfc_ditf_Vci_ei+itf*FCdfc_ditf_Vci_ei_Vbi_ei)));
  FFT_fC_Vci_ei_Vbi_ci=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vbi_ci+(((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci))))+0.0*(FCf_ci_Vci_ei+((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei)))+FFT_pcS*(+FCf_ci_Vci_ei_Vbi_ci+(+itf_Vci_ei_Vbi_ci*FCdfc_ditf+itf_Vci_ei*FCdfc_ditf_Vbi_ci+itf_Vbi_ci*FCdfc_ditf_Vci_ei+itf*FCdfc_ditf_Vci_ei_Vbi_ci)));
#endif
FFT_fC_Vbi_ei=(FFT_pcS*(FCf_ci_Vbi_ei+((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei))));
#if defined(_DERIVATE)
  FFT_fC_Vbi_ei_Vtnode_GND=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vtnode_GND+(((itf_Vtnode_GND*FCdfc_ditf)+(itf*FCdfc_ditf_Vtnode_GND))))+FFT_pcS_Vtnode_GND*(FCf_ci_Vbi_ei+((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei)))+FFT_pcS*(+FCf_ci_Vbi_ei_Vtnode_GND+(+itf_Vbi_ei_Vtnode_GND*FCdfc_ditf+itf_Vbi_ei*FCdfc_ditf_Vtnode_GND+itf_Vtnode_GND*FCdfc_ditf_Vbi_ei+itf*FCdfc_ditf_Vbi_ei_Vtnode_GND)));
  FFT_fC_Vbi_ei_Vci_ei=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vci_ei+(((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei))))+0.0*(FCf_ci_Vbi_ei+((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei)))+FFT_pcS*(+FCf_ci_Vbi_ei_Vci_ei+(+itf_Vbi_ei_Vci_ei*FCdfc_ditf+itf_Vbi_ei*FCdfc_ditf_Vci_ei+itf_Vci_ei*FCdfc_ditf_Vbi_ei+itf*FCdfc_ditf_Vbi_ei_Vci_ei)));
  FFT_fC_Vbi_ei_Vbi_ei=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vbi_ei+(((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei))))+0.0*(FCf_ci_Vbi_ei+((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei)))+FFT_pcS*(+FCf_ci_Vbi_ei_Vbi_ei+(+itf_Vbi_ei_Vbi_ei*FCdfc_ditf+itf_Vbi_ei*FCdfc_ditf_Vbi_ei+itf_Vbi_ei*FCdfc_ditf_Vbi_ei+itf*FCdfc_ditf_Vbi_ei_Vbi_ei)));
  FFT_fC_Vbi_ei_Vbi_ci=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vbi_ci+(((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci))))+0.0*(FCf_ci_Vbi_ei+((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei)))+FFT_pcS*(+FCf_ci_Vbi_ei_Vbi_ci+(+itf_Vbi_ei_Vbi_ci*FCdfc_ditf+itf_Vbi_ei*FCdfc_ditf_Vbi_ci+itf_Vbi_ci*FCdfc_ditf_Vbi_ei+itf*FCdfc_ditf_Vbi_ei_Vbi_ci)));
#endif
FFT_fC_Vbi_ci=(FFT_pcS*(FCf_ci_Vbi_ci+((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci))));
#if defined(_DERIVATE)
  FFT_fC_Vbi_ci_Vtnode_GND=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vtnode_GND+(((itf_Vtnode_GND*FCdfc_ditf)+(itf*FCdfc_ditf_Vtnode_GND))))+FFT_pcS_Vtnode_GND*(FCf_ci_Vbi_ci+((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci)))+FFT_pcS*(+FCf_ci_Vbi_ci_Vtnode_GND+(+itf_Vbi_ci_Vtnode_GND*FCdfc_ditf+itf_Vbi_ci*FCdfc_ditf_Vtnode_GND+itf_Vtnode_GND*FCdfc_ditf_Vbi_ci+itf*FCdfc_ditf_Vbi_ci_Vtnode_GND)));
  FFT_fC_Vbi_ci_Vci_ei=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vci_ei+(((itf_Vci_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vci_ei))))+0.0*(FCf_ci_Vbi_ci+((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci)))+FFT_pcS*(+FCf_ci_Vbi_ci_Vci_ei+(+itf_Vbi_ci_Vci_ei*FCdfc_ditf+itf_Vbi_ci*FCdfc_ditf_Vci_ei+itf_Vci_ei*FCdfc_ditf_Vbi_ci+itf*FCdfc_ditf_Vbi_ci_Vci_ei)));
  FFT_fC_Vbi_ci_Vbi_ei=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vbi_ei+(((itf_Vbi_ei*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ei))))+0.0*(FCf_ci_Vbi_ci+((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci)))+FFT_pcS*(+FCf_ci_Vbi_ci_Vbi_ei+(+itf_Vbi_ci_Vbi_ei*FCdfc_ditf+itf_Vbi_ci*FCdfc_ditf_Vbi_ei+itf_Vbi_ei*FCdfc_ditf_Vbi_ci+itf*FCdfc_ditf_Vbi_ci_Vbi_ei)));
  FFT_fC_Vbi_ci_Vbi_ci=(+0.0*(FCf_ci+(itf*FCdfc_ditf))+0.0*(FCf_ci_Vbi_ci+(((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci))))+0.0*(FCf_ci_Vbi_ci+((itf_Vbi_ci*FCdfc_ditf)+(itf*FCdfc_ditf_Vbi_ci)))+FFT_pcS*(+FCf_ci_Vbi_ci_Vbi_ci+(+itf_Vbi_ci_Vbi_ci*FCdfc_ditf+itf_Vbi_ci*FCdfc_ditf_Vbi_ci+itf_Vbi_ci*FCdfc_ditf_Vbi_ci+itf*FCdfc_ditf_Vbi_ci_Vbi_ci)));
#endif
#endif
FFT_fC=(FFT_pcS*(FCf_ci+(itf*FCdfc_ditf)));
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFT_cT_Vtnode_GND=((FFT_pcS_Vtnode_GND*(FCf_CT+(itf*FCdfCT_ditf)))+(FFT_pcS*(FCf_CT_Vtnode_GND+((itf_Vtnode_GND*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vtnode_GND)))));
#endif
FFT_cT_Vci_ei=(FFT_pcS*(FCf_CT_Vci_ei+((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei))));
#if defined(_DERIVATE)
  FFT_cT_Vci_ei_Vtnode_GND=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vtnode_GND+(((itf_Vtnode_GND*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vtnode_GND))))+FFT_pcS_Vtnode_GND*(FCf_CT_Vci_ei+((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei)))+FFT_pcS*(+FCf_CT_Vci_ei_Vtnode_GND+(+itf_Vci_ei_Vtnode_GND*FCdfCT_ditf+itf_Vci_ei*FCdfCT_ditf_Vtnode_GND+itf_Vtnode_GND*FCdfCT_ditf_Vci_ei+itf*FCdfCT_ditf_Vci_ei_Vtnode_GND)));
  FFT_cT_Vci_ei_Vci_ei=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vci_ei+(((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei))))+0.0*(FCf_CT_Vci_ei+((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei)))+FFT_pcS*(+FCf_CT_Vci_ei_Vci_ei+(+itf_Vci_ei_Vci_ei*FCdfCT_ditf+itf_Vci_ei*FCdfCT_ditf_Vci_ei+itf_Vci_ei*FCdfCT_ditf_Vci_ei+itf*FCdfCT_ditf_Vci_ei_Vci_ei)));
  FFT_cT_Vci_ei_Vbi_ei=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vbi_ei+(((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei))))+0.0*(FCf_CT_Vci_ei+((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei)))+FFT_pcS*(+FCf_CT_Vci_ei_Vbi_ei+(+itf_Vci_ei_Vbi_ei*FCdfCT_ditf+itf_Vci_ei*FCdfCT_ditf_Vbi_ei+itf_Vbi_ei*FCdfCT_ditf_Vci_ei+itf*FCdfCT_ditf_Vci_ei_Vbi_ei)));
  FFT_cT_Vci_ei_Vbi_ci=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vbi_ci+(((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci))))+0.0*(FCf_CT_Vci_ei+((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei)))+FFT_pcS*(+FCf_CT_Vci_ei_Vbi_ci+(+itf_Vci_ei_Vbi_ci*FCdfCT_ditf+itf_Vci_ei*FCdfCT_ditf_Vbi_ci+itf_Vbi_ci*FCdfCT_ditf_Vci_ei+itf*FCdfCT_ditf_Vci_ei_Vbi_ci)));
#endif
FFT_cT_Vbi_ei=(FFT_pcS*(FCf_CT_Vbi_ei+((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei))));
#if defined(_DERIVATE)
  FFT_cT_Vbi_ei_Vtnode_GND=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vtnode_GND+(((itf_Vtnode_GND*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vtnode_GND))))+FFT_pcS_Vtnode_GND*(FCf_CT_Vbi_ei+((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei)))+FFT_pcS*(+FCf_CT_Vbi_ei_Vtnode_GND+(+itf_Vbi_ei_Vtnode_GND*FCdfCT_ditf+itf_Vbi_ei*FCdfCT_ditf_Vtnode_GND+itf_Vtnode_GND*FCdfCT_ditf_Vbi_ei+itf*FCdfCT_ditf_Vbi_ei_Vtnode_GND)));
  FFT_cT_Vbi_ei_Vci_ei=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vci_ei+(((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei))))+0.0*(FCf_CT_Vbi_ei+((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei)))+FFT_pcS*(+FCf_CT_Vbi_ei_Vci_ei+(+itf_Vbi_ei_Vci_ei*FCdfCT_ditf+itf_Vbi_ei*FCdfCT_ditf_Vci_ei+itf_Vci_ei*FCdfCT_ditf_Vbi_ei+itf*FCdfCT_ditf_Vbi_ei_Vci_ei)));
  FFT_cT_Vbi_ei_Vbi_ei=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vbi_ei+(((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei))))+0.0*(FCf_CT_Vbi_ei+((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei)))+FFT_pcS*(+FCf_CT_Vbi_ei_Vbi_ei+(+itf_Vbi_ei_Vbi_ei*FCdfCT_ditf+itf_Vbi_ei*FCdfCT_ditf_Vbi_ei+itf_Vbi_ei*FCdfCT_ditf_Vbi_ei+itf*FCdfCT_ditf_Vbi_ei_Vbi_ei)));
  FFT_cT_Vbi_ei_Vbi_ci=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vbi_ci+(((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci))))+0.0*(FCf_CT_Vbi_ei+((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei)))+FFT_pcS*(+FCf_CT_Vbi_ei_Vbi_ci+(+itf_Vbi_ei_Vbi_ci*FCdfCT_ditf+itf_Vbi_ei*FCdfCT_ditf_Vbi_ci+itf_Vbi_ci*FCdfCT_ditf_Vbi_ei+itf*FCdfCT_ditf_Vbi_ei_Vbi_ci)));
#endif
FFT_cT_Vbi_ci=(FFT_pcS*(FCf_CT_Vbi_ci+((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci))));
#if defined(_DERIVATE)
  FFT_cT_Vbi_ci_Vtnode_GND=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vtnode_GND+(((itf_Vtnode_GND*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vtnode_GND))))+FFT_pcS_Vtnode_GND*(FCf_CT_Vbi_ci+((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci)))+FFT_pcS*(+FCf_CT_Vbi_ci_Vtnode_GND+(+itf_Vbi_ci_Vtnode_GND*FCdfCT_ditf+itf_Vbi_ci*FCdfCT_ditf_Vtnode_GND+itf_Vtnode_GND*FCdfCT_ditf_Vbi_ci+itf*FCdfCT_ditf_Vbi_ci_Vtnode_GND)));
  FFT_cT_Vbi_ci_Vci_ei=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vci_ei+(((itf_Vci_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vci_ei))))+0.0*(FCf_CT_Vbi_ci+((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci)))+FFT_pcS*(+FCf_CT_Vbi_ci_Vci_ei+(+itf_Vbi_ci_Vci_ei*FCdfCT_ditf+itf_Vbi_ci*FCdfCT_ditf_Vci_ei+itf_Vci_ei*FCdfCT_ditf_Vbi_ci+itf*FCdfCT_ditf_Vbi_ci_Vci_ei)));
  FFT_cT_Vbi_ci_Vbi_ei=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vbi_ei+(((itf_Vbi_ei*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ei))))+0.0*(FCf_CT_Vbi_ci+((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci)))+FFT_pcS*(+FCf_CT_Vbi_ci_Vbi_ei+(+itf_Vbi_ci_Vbi_ei*FCdfCT_ditf+itf_Vbi_ci*FCdfCT_ditf_Vbi_ei+itf_Vbi_ei*FCdfCT_ditf_Vbi_ci+itf*FCdfCT_ditf_Vbi_ci_Vbi_ei)));
  FFT_cT_Vbi_ci_Vbi_ci=(+0.0*(FCf_CT+(itf*FCdfCT_ditf))+0.0*(FCf_CT_Vbi_ci+(((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci))))+0.0*(FCf_CT_Vbi_ci+((itf_Vbi_ci*FCdfCT_ditf)+(itf*FCdfCT_ditf_Vbi_ci)))+FFT_pcS*(+FCf_CT_Vbi_ci_Vbi_ci+(+itf_Vbi_ci_Vbi_ci*FCdfCT_ditf+itf_Vbi_ci*FCdfCT_ditf_Vbi_ci+itf_Vbi_ci*FCdfCT_ditf_Vbi_ci+itf*FCdfCT_ditf_Vbi_ci_Vbi_ci)));
#endif
#endif
FFT_cT=(FFT_pcS*(FCf_CT+(itf*FCdfCT_ditf)));
}
#if defined(_DERIVATEFORDDX)
Qf_Vci_ei=(Qf_Vci_ei+FFd_QfB_Vci_ei);
#if defined(_DERIVATE)
  Qf_Vci_ei_Vci_ei=(+Qf_Vci_ei_Vci_ei+FFd_QfB_Vci_ei_Vci_ei);
  Qf_Vci_ei_Vtnode_GND=(+Qf_Vci_ei_Vtnode_GND+FFd_QfB_Vci_ei_Vtnode_GND);
  Qf_Vci_ei_Vbi_ci=(+Qf_Vci_ei_Vbi_ci+FFd_QfB_Vci_ei_Vbi_ci);
  Qf_Vci_ei_Vbi_ei=(+Qf_Vci_ei_Vbi_ei+FFd_QfB_Vci_ei_Vbi_ei);
#endif
#if defined(_DERIVATE)
Qf_Vtnode_GND=(Qf_Vtnode_GND+FFd_QfB_Vtnode_GND);
#endif
Qf_Vbi_ci=(Qf_Vbi_ci+FFd_QfB_Vbi_ci);
#if defined(_DERIVATE)
  Qf_Vbi_ci_Vci_ei=(+Qf_Vbi_ci_Vci_ei+FFd_QfB_Vbi_ci_Vci_ei);
  Qf_Vbi_ci_Vtnode_GND=(+Qf_Vbi_ci_Vtnode_GND+FFd_QfB_Vbi_ci_Vtnode_GND);
  Qf_Vbi_ci_Vbi_ci=(+Qf_Vbi_ci_Vbi_ci+FFd_QfB_Vbi_ci_Vbi_ci);
  Qf_Vbi_ci_Vbi_ei=(+Qf_Vbi_ci_Vbi_ei+FFd_QfB_Vbi_ci_Vbi_ei);
#endif
Qf_Vbi_ei=(Qf_Vbi_ei+FFd_QfB_Vbi_ei);
#if defined(_DERIVATE)
  Qf_Vbi_ei_Vci_ei=(+Qf_Vbi_ei_Vci_ei+FFd_QfB_Vbi_ei_Vci_ei);
  Qf_Vbi_ei_Vtnode_GND=(+Qf_Vbi_ei_Vtnode_GND+FFd_QfB_Vbi_ei_Vtnode_GND);
  Qf_Vbi_ei_Vbi_ci=(+Qf_Vbi_ei_Vbi_ci+FFd_QfB_Vbi_ei_Vbi_ci);
  Qf_Vbi_ei_Vbi_ei=(+Qf_Vbi_ei_Vbi_ei+FFd_QfB_Vbi_ei_Vbi_ei);
#endif
#endif
Qf=(Qf+FFd_QfB);
#if defined(_DERIVATEFORDDX)
Tf_Vci_ei=(Tf_Vci_ei+FFd_TfB_Vci_ei);
#if defined(_DERIVATE)
  Tf_Vci_ei_Vci_ei=(+Tf_Vci_ei_Vci_ei+FFd_TfB_Vci_ei_Vci_ei);
  Tf_Vci_ei_Vbi_ei=(+Tf_Vci_ei_Vbi_ei+FFd_TfB_Vci_ei_Vbi_ei);
  Tf_Vci_ei_Vtnode_GND=(+Tf_Vci_ei_Vtnode_GND+FFd_TfB_Vci_ei_Vtnode_GND);
  Tf_Vci_ei_Vbi_ci=(+Tf_Vci_ei_Vbi_ci+FFd_TfB_Vci_ei_Vbi_ci);
#endif
Tf_Vbi_ei=(Tf_Vbi_ei+FFd_TfB_Vbi_ei);
#if defined(_DERIVATE)
  Tf_Vbi_ei_Vci_ei=(+Tf_Vbi_ei_Vci_ei+FFd_TfB_Vbi_ei_Vci_ei);
  Tf_Vbi_ei_Vbi_ei=(+Tf_Vbi_ei_Vbi_ei+FFd_TfB_Vbi_ei_Vbi_ei);
  Tf_Vbi_ei_Vtnode_GND=(+Tf_Vbi_ei_Vtnode_GND+FFd_TfB_Vbi_ei_Vtnode_GND);
  Tf_Vbi_ei_Vbi_ci=(+Tf_Vbi_ei_Vbi_ci+FFd_TfB_Vbi_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
Tf_Vtnode_GND=(Tf_Vtnode_GND+FFd_TfB_Vtnode_GND);
#endif
Tf_Vbi_ci=(Tf_Vbi_ci+FFd_TfB_Vbi_ci);
#if defined(_DERIVATE)
  Tf_Vbi_ci_Vci_ei=(+Tf_Vbi_ci_Vci_ei+FFd_TfB_Vbi_ci_Vci_ei);
  Tf_Vbi_ci_Vbi_ei=(+Tf_Vbi_ci_Vbi_ei+FFd_TfB_Vbi_ci_Vbi_ei);
  Tf_Vbi_ci_Vtnode_GND=(+Tf_Vbi_ci_Vtnode_GND+FFd_TfB_Vbi_ci_Vtnode_GND);
  Tf_Vbi_ci_Vbi_ci=(+Tf_Vbi_ci_Vbi_ci+FFd_TfB_Vbi_ci_Vbi_ci);
#endif
#endif
Tf=(Tf+FFd_TfB);
#if defined(_DERIVATEFORDDX)
Q_fT_Vci_ei=((Qf_Vci_ei+(hfe*FFd_QfE_Vci_ei))+(hfc*FFQ_cT_Vci_ei));
#if defined(_DERIVATE)
  Q_fT_Vci_ei_Vci_ei=(+(+Qf_Vci_ei_Vci_ei+(+0.0*FFd_QfE+0.0*FFd_QfE_Vci_ei+0.0*FFd_QfE_Vci_ei+hfe*FFd_QfE_Vci_ei_Vci_ei))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vci_ei+0.0*FFQ_cT_Vci_ei+hfc*FFQ_cT_Vci_ei_Vci_ei));
  Q_fT_Vci_ei_Vtnode_GND=(+(+Qf_Vci_ei_Vtnode_GND+(+0.0*FFd_QfE+0.0*FFd_QfE_Vtnode_GND+0.0*FFd_QfE_Vci_ei+hfe*FFd_QfE_Vci_ei_Vtnode_GND))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vtnode_GND+0.0*FFQ_cT_Vci_ei+hfc*FFQ_cT_Vci_ei_Vtnode_GND));
  Q_fT_Vci_ei_Vbi_ci=(+(+Qf_Vci_ei_Vbi_ci+(+0.0*FFd_QfE+0.0*FFd_QfE_Vbi_ci+0.0*FFd_QfE_Vci_ei+hfe*FFd_QfE_Vci_ei_Vbi_ci))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vbi_ci+0.0*FFQ_cT_Vci_ei+hfc*FFQ_cT_Vci_ei_Vbi_ci));
  Q_fT_Vci_ei_Vbi_ei=(+(+Qf_Vci_ei_Vbi_ei+(+0.0*FFd_QfE+0.0*FFd_QfE_Vbi_ei+0.0*FFd_QfE_Vci_ei+hfe*FFd_QfE_Vci_ei_Vbi_ei))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vbi_ei+0.0*FFQ_cT_Vci_ei+hfc*FFQ_cT_Vci_ei_Vbi_ei));
#endif
#if defined(_DERIVATE)
Q_fT_Vtnode_GND=((Qf_Vtnode_GND+(hfe*FFd_QfE_Vtnode_GND))+(hfc*FFQ_cT_Vtnode_GND));
#endif
Q_fT_Vbi_ci=((Qf_Vbi_ci+(hfe*FFd_QfE_Vbi_ci))+(hfc*FFQ_cT_Vbi_ci));
#if defined(_DERIVATE)
  Q_fT_Vbi_ci_Vci_ei=(+(+Qf_Vbi_ci_Vci_ei+(+0.0*FFd_QfE+0.0*FFd_QfE_Vci_ei+0.0*FFd_QfE_Vbi_ci+hfe*FFd_QfE_Vbi_ci_Vci_ei))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vci_ei+0.0*FFQ_cT_Vbi_ci+hfc*FFQ_cT_Vbi_ci_Vci_ei));
  Q_fT_Vbi_ci_Vtnode_GND=(+(+Qf_Vbi_ci_Vtnode_GND+(+0.0*FFd_QfE+0.0*FFd_QfE_Vtnode_GND+0.0*FFd_QfE_Vbi_ci+hfe*FFd_QfE_Vbi_ci_Vtnode_GND))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vtnode_GND+0.0*FFQ_cT_Vbi_ci+hfc*FFQ_cT_Vbi_ci_Vtnode_GND));
  Q_fT_Vbi_ci_Vbi_ci=(+(+Qf_Vbi_ci_Vbi_ci+(+0.0*FFd_QfE+0.0*FFd_QfE_Vbi_ci+0.0*FFd_QfE_Vbi_ci+hfe*FFd_QfE_Vbi_ci_Vbi_ci))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vbi_ci+0.0*FFQ_cT_Vbi_ci+hfc*FFQ_cT_Vbi_ci_Vbi_ci));
  Q_fT_Vbi_ci_Vbi_ei=(+(+Qf_Vbi_ci_Vbi_ei+(+0.0*FFd_QfE+0.0*FFd_QfE_Vbi_ei+0.0*FFd_QfE_Vbi_ci+hfe*FFd_QfE_Vbi_ci_Vbi_ei))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vbi_ei+0.0*FFQ_cT_Vbi_ci+hfc*FFQ_cT_Vbi_ci_Vbi_ei));
#endif
Q_fT_Vbi_ei=((Qf_Vbi_ei+(hfe*FFd_QfE_Vbi_ei))+(hfc*FFQ_cT_Vbi_ei));
#if defined(_DERIVATE)
  Q_fT_Vbi_ei_Vci_ei=(+(+Qf_Vbi_ei_Vci_ei+(+0.0*FFd_QfE+0.0*FFd_QfE_Vci_ei+0.0*FFd_QfE_Vbi_ei+hfe*FFd_QfE_Vbi_ei_Vci_ei))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vci_ei+0.0*FFQ_cT_Vbi_ei+hfc*FFQ_cT_Vbi_ei_Vci_ei));
  Q_fT_Vbi_ei_Vtnode_GND=(+(+Qf_Vbi_ei_Vtnode_GND+(+0.0*FFd_QfE+0.0*FFd_QfE_Vtnode_GND+0.0*FFd_QfE_Vbi_ei+hfe*FFd_QfE_Vbi_ei_Vtnode_GND))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vtnode_GND+0.0*FFQ_cT_Vbi_ei+hfc*FFQ_cT_Vbi_ei_Vtnode_GND));
  Q_fT_Vbi_ei_Vbi_ci=(+(+Qf_Vbi_ei_Vbi_ci+(+0.0*FFd_QfE+0.0*FFd_QfE_Vbi_ci+0.0*FFd_QfE_Vbi_ei+hfe*FFd_QfE_Vbi_ei_Vbi_ci))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vbi_ci+0.0*FFQ_cT_Vbi_ei+hfc*FFQ_cT_Vbi_ei_Vbi_ci));
  Q_fT_Vbi_ei_Vbi_ei=(+(+Qf_Vbi_ei_Vbi_ei+(+0.0*FFd_QfE+0.0*FFd_QfE_Vbi_ei+0.0*FFd_QfE_Vbi_ei+hfe*FFd_QfE_Vbi_ei_Vbi_ei))+(+0.0*FFQ_cT+0.0*FFQ_cT_Vbi_ei+0.0*FFQ_cT_Vbi_ei+hfc*FFQ_cT_Vbi_ei_Vbi_ei));
#endif
#endif
Q_fT=((Qf+(hfe*FFd_QfE))+(hfc*FFQ_cT));
#if defined(_DERIVATEFORDDX)
T_fT_Vci_ei=((Tf_Vci_ei+(hfe*FFd_TfE_Vci_ei))+(hfc*FFT_cT_Vci_ei));
#if defined(_DERIVATE)
  T_fT_Vci_ei_Vci_ei=(+(+Tf_Vci_ei_Vci_ei+(+0.0*FFd_TfE+0.0*FFd_TfE_Vci_ei+0.0*FFd_TfE_Vci_ei+hfe*FFd_TfE_Vci_ei_Vci_ei))+(+0.0*FFT_cT+0.0*FFT_cT_Vci_ei+0.0*FFT_cT_Vci_ei+hfc*FFT_cT_Vci_ei_Vci_ei));
  T_fT_Vci_ei_Vbi_ei=(+(+Tf_Vci_ei_Vbi_ei+(+0.0*FFd_TfE+0.0*FFd_TfE_Vbi_ei+0.0*FFd_TfE_Vci_ei+hfe*FFd_TfE_Vci_ei_Vbi_ei))+(+0.0*FFT_cT+0.0*FFT_cT_Vbi_ei+0.0*FFT_cT_Vci_ei+hfc*FFT_cT_Vci_ei_Vbi_ei));
  T_fT_Vci_ei_Vtnode_GND=(+(+Tf_Vci_ei_Vtnode_GND+(+0.0*FFd_TfE+0.0*FFd_TfE_Vtnode_GND+0.0*FFd_TfE_Vci_ei+hfe*FFd_TfE_Vci_ei_Vtnode_GND))+(+0.0*FFT_cT+0.0*FFT_cT_Vtnode_GND+0.0*FFT_cT_Vci_ei+hfc*FFT_cT_Vci_ei_Vtnode_GND));
  T_fT_Vci_ei_Vbi_ci=(+(+Tf_Vci_ei_Vbi_ci+(+0.0*FFd_TfE+0.0*FFd_TfE_Vbi_ci+0.0*FFd_TfE_Vci_ei+hfe*FFd_TfE_Vci_ei_Vbi_ci))+(+0.0*FFT_cT+0.0*FFT_cT_Vbi_ci+0.0*FFT_cT_Vci_ei+hfc*FFT_cT_Vci_ei_Vbi_ci));
#endif
T_fT_Vbi_ei=((Tf_Vbi_ei+(hfe*FFd_TfE_Vbi_ei))+(hfc*FFT_cT_Vbi_ei));
#if defined(_DERIVATE)
  T_fT_Vbi_ei_Vci_ei=(+(+Tf_Vbi_ei_Vci_ei+(+0.0*FFd_TfE+0.0*FFd_TfE_Vci_ei+0.0*FFd_TfE_Vbi_ei+hfe*FFd_TfE_Vbi_ei_Vci_ei))+(+0.0*FFT_cT+0.0*FFT_cT_Vci_ei+0.0*FFT_cT_Vbi_ei+hfc*FFT_cT_Vbi_ei_Vci_ei));
  T_fT_Vbi_ei_Vbi_ei=(+(+Tf_Vbi_ei_Vbi_ei+(+0.0*FFd_TfE+0.0*FFd_TfE_Vbi_ei+0.0*FFd_TfE_Vbi_ei+hfe*FFd_TfE_Vbi_ei_Vbi_ei))+(+0.0*FFT_cT+0.0*FFT_cT_Vbi_ei+0.0*FFT_cT_Vbi_ei+hfc*FFT_cT_Vbi_ei_Vbi_ei));
  T_fT_Vbi_ei_Vtnode_GND=(+(+Tf_Vbi_ei_Vtnode_GND+(+0.0*FFd_TfE+0.0*FFd_TfE_Vtnode_GND+0.0*FFd_TfE_Vbi_ei+hfe*FFd_TfE_Vbi_ei_Vtnode_GND))+(+0.0*FFT_cT+0.0*FFT_cT_Vtnode_GND+0.0*FFT_cT_Vbi_ei+hfc*FFT_cT_Vbi_ei_Vtnode_GND));
  T_fT_Vbi_ei_Vbi_ci=(+(+Tf_Vbi_ei_Vbi_ci+(+0.0*FFd_TfE+0.0*FFd_TfE_Vbi_ci+0.0*FFd_TfE_Vbi_ei+hfe*FFd_TfE_Vbi_ei_Vbi_ci))+(+0.0*FFT_cT+0.0*FFT_cT_Vbi_ci+0.0*FFT_cT_Vbi_ei+hfc*FFT_cT_Vbi_ei_Vbi_ci));
#endif
#if defined(_DERIVATE)
T_fT_Vtnode_GND=((Tf_Vtnode_GND+(hfe*FFd_TfE_Vtnode_GND))+(hfc*FFT_cT_Vtnode_GND));
#endif
T_fT_Vbi_ci=((Tf_Vbi_ci+(hfe*FFd_TfE_Vbi_ci))+(hfc*FFT_cT_Vbi_ci));
#if defined(_DERIVATE)
  T_fT_Vbi_ci_Vci_ei=(+(+Tf_Vbi_ci_Vci_ei+(+0.0*FFd_TfE+0.0*FFd_TfE_Vci_ei+0.0*FFd_TfE_Vbi_ci+hfe*FFd_TfE_Vbi_ci_Vci_ei))+(+0.0*FFT_cT+0.0*FFT_cT_Vci_ei+0.0*FFT_cT_Vbi_ci+hfc*FFT_cT_Vbi_ci_Vci_ei));
  T_fT_Vbi_ci_Vbi_ei=(+(+Tf_Vbi_ci_Vbi_ei+(+0.0*FFd_TfE+0.0*FFd_TfE_Vbi_ei+0.0*FFd_TfE_Vbi_ci+hfe*FFd_TfE_Vbi_ci_Vbi_ei))+(+0.0*FFT_cT+0.0*FFT_cT_Vbi_ei+0.0*FFT_cT_Vbi_ci+hfc*FFT_cT_Vbi_ci_Vbi_ei));
  T_fT_Vbi_ci_Vtnode_GND=(+(+Tf_Vbi_ci_Vtnode_GND+(+0.0*FFd_TfE+0.0*FFd_TfE_Vtnode_GND+0.0*FFd_TfE_Vbi_ci+hfe*FFd_TfE_Vbi_ci_Vtnode_GND))+(+0.0*FFT_cT+0.0*FFT_cT_Vtnode_GND+0.0*FFT_cT_Vbi_ci+hfc*FFT_cT_Vbi_ci_Vtnode_GND));
  T_fT_Vbi_ci_Vbi_ci=(+(+Tf_Vbi_ci_Vbi_ci+(+0.0*FFd_TfE+0.0*FFd_TfE_Vbi_ci+0.0*FFd_TfE_Vbi_ci+hfe*FFd_TfE_Vbi_ci_Vbi_ci))+(+0.0*FFT_cT+0.0*FFT_cT_Vbi_ci+0.0*FFT_cT_Vbi_ci+hfc*FFT_cT_Vbi_ci_Vbi_ci));
#endif
#endif
T_fT=((Tf+(hfe*FFd_TfE))+(hfc*FFT_cT));
#if defined(_DERIVATEFORDDX)
Qf_Vci_ei=((Qf_Vci_ei+FFd_QfE_Vci_ei)+FFQ_fC_Vci_ei);
#if defined(_DERIVATE)
  Qf_Vci_ei_Vci_ei=(+(+Qf_Vci_ei_Vci_ei+FFd_QfE_Vci_ei_Vci_ei)+FFQ_fC_Vci_ei_Vci_ei);
  Qf_Vci_ei_Vtnode_GND=(+(+Qf_Vci_ei_Vtnode_GND+FFd_QfE_Vci_ei_Vtnode_GND)+FFQ_fC_Vci_ei_Vtnode_GND);
  Qf_Vci_ei_Vbi_ci=(+(+Qf_Vci_ei_Vbi_ci+FFd_QfE_Vci_ei_Vbi_ci)+FFQ_fC_Vci_ei_Vbi_ci);
  Qf_Vci_ei_Vbi_ei=(+(+Qf_Vci_ei_Vbi_ei+FFd_QfE_Vci_ei_Vbi_ei)+FFQ_fC_Vci_ei_Vbi_ei);
#endif
#if defined(_DERIVATE)
Qf_Vtnode_GND=((Qf_Vtnode_GND+FFd_QfE_Vtnode_GND)+FFQ_fC_Vtnode_GND);
#endif
Qf_Vbi_ci=((Qf_Vbi_ci+FFd_QfE_Vbi_ci)+FFQ_fC_Vbi_ci);
#if defined(_DERIVATE)
  Qf_Vbi_ci_Vci_ei=(+(+Qf_Vbi_ci_Vci_ei+FFd_QfE_Vbi_ci_Vci_ei)+FFQ_fC_Vbi_ci_Vci_ei);
  Qf_Vbi_ci_Vtnode_GND=(+(+Qf_Vbi_ci_Vtnode_GND+FFd_QfE_Vbi_ci_Vtnode_GND)+FFQ_fC_Vbi_ci_Vtnode_GND);
  Qf_Vbi_ci_Vbi_ci=(+(+Qf_Vbi_ci_Vbi_ci+FFd_QfE_Vbi_ci_Vbi_ci)+FFQ_fC_Vbi_ci_Vbi_ci);
  Qf_Vbi_ci_Vbi_ei=(+(+Qf_Vbi_ci_Vbi_ei+FFd_QfE_Vbi_ci_Vbi_ei)+FFQ_fC_Vbi_ci_Vbi_ei);
#endif
Qf_Vbi_ei=((Qf_Vbi_ei+FFd_QfE_Vbi_ei)+FFQ_fC_Vbi_ei);
#if defined(_DERIVATE)
  Qf_Vbi_ei_Vci_ei=(+(+Qf_Vbi_ei_Vci_ei+FFd_QfE_Vbi_ei_Vci_ei)+FFQ_fC_Vbi_ei_Vci_ei);
  Qf_Vbi_ei_Vtnode_GND=(+(+Qf_Vbi_ei_Vtnode_GND+FFd_QfE_Vbi_ei_Vtnode_GND)+FFQ_fC_Vbi_ei_Vtnode_GND);
  Qf_Vbi_ei_Vbi_ci=(+(+Qf_Vbi_ei_Vbi_ci+FFd_QfE_Vbi_ei_Vbi_ci)+FFQ_fC_Vbi_ei_Vbi_ci);
  Qf_Vbi_ei_Vbi_ei=(+(+Qf_Vbi_ei_Vbi_ei+FFd_QfE_Vbi_ei_Vbi_ei)+FFQ_fC_Vbi_ei_Vbi_ei);
#endif
#endif
Qf=((Qf+FFd_QfE)+FFQ_fC);
#if defined(_DERIVATEFORDDX)
Tf_Vci_ei=((Tf_Vci_ei+FFd_TfE_Vci_ei)+FFT_fC_Vci_ei);
#if defined(_DERIVATE)
  Tf_Vci_ei_Vci_ei=(+(+Tf_Vci_ei_Vci_ei+FFd_TfE_Vci_ei_Vci_ei)+FFT_fC_Vci_ei_Vci_ei);
  Tf_Vci_ei_Vbi_ei=(+(+Tf_Vci_ei_Vbi_ei+FFd_TfE_Vci_ei_Vbi_ei)+FFT_fC_Vci_ei_Vbi_ei);
  Tf_Vci_ei_Vtnode_GND=(+(+Tf_Vci_ei_Vtnode_GND+FFd_TfE_Vci_ei_Vtnode_GND)+FFT_fC_Vci_ei_Vtnode_GND);
  Tf_Vci_ei_Vbi_ci=(+(+Tf_Vci_ei_Vbi_ci+FFd_TfE_Vci_ei_Vbi_ci)+FFT_fC_Vci_ei_Vbi_ci);
#endif
Tf_Vbi_ei=((Tf_Vbi_ei+FFd_TfE_Vbi_ei)+FFT_fC_Vbi_ei);
#if defined(_DERIVATE)
  Tf_Vbi_ei_Vci_ei=(+(+Tf_Vbi_ei_Vci_ei+FFd_TfE_Vbi_ei_Vci_ei)+FFT_fC_Vbi_ei_Vci_ei);
  Tf_Vbi_ei_Vbi_ei=(+(+Tf_Vbi_ei_Vbi_ei+FFd_TfE_Vbi_ei_Vbi_ei)+FFT_fC_Vbi_ei_Vbi_ei);
  Tf_Vbi_ei_Vtnode_GND=(+(+Tf_Vbi_ei_Vtnode_GND+FFd_TfE_Vbi_ei_Vtnode_GND)+FFT_fC_Vbi_ei_Vtnode_GND);
  Tf_Vbi_ei_Vbi_ci=(+(+Tf_Vbi_ei_Vbi_ci+FFd_TfE_Vbi_ei_Vbi_ci)+FFT_fC_Vbi_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
Tf_Vtnode_GND=((Tf_Vtnode_GND+FFd_TfE_Vtnode_GND)+FFT_fC_Vtnode_GND);
#endif
Tf_Vbi_ci=((Tf_Vbi_ci+FFd_TfE_Vbi_ci)+FFT_fC_Vbi_ci);
#if defined(_DERIVATE)
  Tf_Vbi_ci_Vci_ei=(+(+Tf_Vbi_ci_Vci_ei+FFd_TfE_Vbi_ci_Vci_ei)+FFT_fC_Vbi_ci_Vci_ei);
  Tf_Vbi_ci_Vbi_ei=(+(+Tf_Vbi_ci_Vbi_ei+FFd_TfE_Vbi_ci_Vbi_ei)+FFT_fC_Vbi_ci_Vbi_ei);
  Tf_Vbi_ci_Vtnode_GND=(+(+Tf_Vbi_ci_Vtnode_GND+FFd_TfE_Vbi_ci_Vtnode_GND)+FFT_fC_Vbi_ci_Vtnode_GND);
  Tf_Vbi_ci_Vbi_ci=(+(+Tf_Vbi_ci_Vbi_ci+FFd_TfE_Vbi_ci_Vbi_ci)+FFT_fC_Vbi_ci_Vbi_ci);
#endif
#endif
Tf=((Tf+FFd_TfE)+FFT_fC);
}
#if defined(_DERIVATEFORDDX)
Qr_Vci_ei=0.0;
#if defined(_DERIVATE)
  Qr_Vci_ei_Vci_ei=0.0;
  Qr_Vci_ei_Vtnode_GND=0.0;
  Qr_Vci_ei_Vbi_ci=0.0;
  Qr_Vci_ei_Vbi_ei=0.0;
#endif
#if defined(_DERIVATE)
Qr_Vtnode_GND=(Tr*itr_Vtnode_GND);
#endif
Qr_Vbi_ci=(Tr*itr_Vbi_ci);
#if defined(_DERIVATE)
  Qr_Vbi_ci_Vci_ei=(+0.0*itr+0.0*itr_Vci_ei+0.0*itr_Vbi_ci+Tr*itr_Vbi_ci_Vci_ei);
  Qr_Vbi_ci_Vtnode_GND=(+0.0*itr+0.0*itr_Vtnode_GND+0.0*itr_Vbi_ci+Tr*itr_Vbi_ci_Vtnode_GND);
  Qr_Vbi_ci_Vbi_ci=(+0.0*itr+0.0*itr_Vbi_ci+0.0*itr_Vbi_ci+Tr*itr_Vbi_ci_Vbi_ci);
  Qr_Vbi_ci_Vbi_ei=(+0.0*itr+0.0*itr_Vbi_ei+0.0*itr_Vbi_ci+Tr*itr_Vbi_ci_Vbi_ei);
#endif
Qr_Vbi_ei=(Tr*itr_Vbi_ei);
#if defined(_DERIVATE)
  Qr_Vbi_ei_Vci_ei=(+0.0*itr+0.0*itr_Vci_ei+0.0*itr_Vbi_ei+Tr*itr_Vbi_ei_Vci_ei);
  Qr_Vbi_ei_Vtnode_GND=(+0.0*itr+0.0*itr_Vtnode_GND+0.0*itr_Vbi_ei+Tr*itr_Vbi_ei_Vtnode_GND);
  Qr_Vbi_ei_Vbi_ci=(+0.0*itr+0.0*itr_Vbi_ci+0.0*itr_Vbi_ei+Tr*itr_Vbi_ei_Vbi_ci);
  Qr_Vbi_ei_Vbi_ei=(+0.0*itr+0.0*itr_Vbi_ei+0.0*itr_Vbi_ei+Tr*itr_Vbi_ei_Vbi_ei);
#endif
#endif
Qr=(Tr*itr);
l_it=0;
if
(((Qf>(1.0e-5*Q_p))||(a_h>1.0e-5)))
{
{
double m00_sqrt(d00_sqrt0,((T_f0*itf)*Q_fT))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((T_f0*itf)*Q_fT))
#endif
#if defined(_DERIVATEFORDDX)
Qf_Vci_ei=(((T_f0*itf_Vci_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vci_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  Qf_Vci_ei_Vci_ei=(m20_sqrt(((T_f0*itf)*Q_fT))*(((((T_f0*itf_Vci_ei))*Q_fT)+((T_f0*itf)*Q_fT_Vci_ei)))*(((T_f0*itf_Vci_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vci_ei))+d10_sqrt0*(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vci_ei+T_f0*itf_Vci_ei_Vci_ei)*Q_fT+(T_f0*itf_Vci_ei)*Q_fT_Vci_ei+((T_f0*itf_Vci_ei))*Q_fT_Vci_ei+(T_f0*itf)*Q_fT_Vci_ei_Vci_ei));
  Qf_Vci_ei_Vtnode_GND=(m20_sqrt(((T_f0*itf)*Q_fT))*((((((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND)))*Q_fT)+((T_f0*itf)*Q_fT_Vtnode_GND)))*(((T_f0*itf_Vci_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vci_ei))+d10_sqrt0*(+(+0.0*itf+0.0*itf_Vtnode_GND+T_f0_Vtnode_GND*itf_Vci_ei+T_f0*itf_Vci_ei_Vtnode_GND)*Q_fT+(T_f0*itf_Vci_ei)*Q_fT_Vtnode_GND+(((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND)))*Q_fT_Vci_ei+(T_f0*itf)*Q_fT_Vci_ei_Vtnode_GND));
  Qf_Vci_ei_Vbi_ci=(m20_sqrt(((T_f0*itf)*Q_fT))*((((((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci)))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ci)))*(((T_f0*itf_Vci_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vci_ei))+d10_sqrt0*(+(+0.0*itf+0.0*itf_Vbi_ci+T_f0_Vbi_ci*itf_Vci_ei+T_f0*itf_Vci_ei_Vbi_ci)*Q_fT+(T_f0*itf_Vci_ei)*Q_fT_Vbi_ci+(((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci)))*Q_fT_Vci_ei+(T_f0*itf)*Q_fT_Vci_ei_Vbi_ci));
  Qf_Vci_ei_Vbi_ei=(m20_sqrt(((T_f0*itf)*Q_fT))*(((((T_f0*itf_Vbi_ei))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ei)))*(((T_f0*itf_Vci_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vci_ei))+d10_sqrt0*(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vci_ei+T_f0*itf_Vci_ei_Vbi_ei)*Q_fT+(T_f0*itf_Vci_ei)*Q_fT_Vbi_ei+((T_f0*itf_Vbi_ei))*Q_fT_Vci_ei+(T_f0*itf)*Q_fT_Vci_ei_Vbi_ei));
#endif
#if defined(_DERIVATE)
Qf_Vtnode_GND=((((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND))*Q_fT)+((T_f0*itf)*Q_fT_Vtnode_GND))*d10_sqrt0;
#endif
Qf_Vbi_ci=((((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ci))*d10_sqrt0;
#if defined(_DERIVATE)
  Qf_Vbi_ci_Vci_ei=(m20_sqrt(((T_f0*itf)*Q_fT))*(((((T_f0*itf_Vci_ei))*Q_fT)+((T_f0*itf)*Q_fT_Vci_ei)))*((((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ci))+d10_sqrt0*(+(+0.0*itf+T_f0_Vbi_ci*itf_Vci_ei+0.0*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vci_ei)*Q_fT+((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT_Vci_ei+((T_f0*itf_Vci_ei))*Q_fT_Vbi_ci+(T_f0*itf)*Q_fT_Vbi_ci_Vci_ei));
  Qf_Vbi_ci_Vtnode_GND=(m20_sqrt(((T_f0*itf)*Q_fT))*((((((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND)))*Q_fT)+((T_f0*itf)*Q_fT_Vtnode_GND)))*((((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ci))+d10_sqrt0*(+(+T_f0_Vbi_ci_Vtnode_GND*itf+T_f0_Vbi_ci*itf_Vtnode_GND+T_f0_Vtnode_GND*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vtnode_GND)*Q_fT+((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT_Vtnode_GND+(((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND)))*Q_fT_Vbi_ci+(T_f0*itf)*Q_fT_Vbi_ci_Vtnode_GND));
  Qf_Vbi_ci_Vbi_ci=(m20_sqrt(((T_f0*itf)*Q_fT))*((((((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci)))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ci)))*((((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ci))+d10_sqrt0*(+(+T_f0_Vbi_ci_Vbi_ci*itf+T_f0_Vbi_ci*itf_Vbi_ci+T_f0_Vbi_ci*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vbi_ci)*Q_fT+((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT_Vbi_ci+(((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci)))*Q_fT_Vbi_ci+(T_f0*itf)*Q_fT_Vbi_ci_Vbi_ci));
  Qf_Vbi_ci_Vbi_ei=(m20_sqrt(((T_f0*itf)*Q_fT))*(((((T_f0*itf_Vbi_ei))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ei)))*((((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ci))+d10_sqrt0*(+(+0.0*itf+T_f0_Vbi_ci*itf_Vbi_ei+0.0*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vbi_ei)*Q_fT+((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci))*Q_fT_Vbi_ei+((T_f0*itf_Vbi_ei))*Q_fT_Vbi_ci+(T_f0*itf)*Q_fT_Vbi_ci_Vbi_ei));
#endif
Qf_Vbi_ei=(((T_f0*itf_Vbi_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  Qf_Vbi_ei_Vci_ei=(m20_sqrt(((T_f0*itf)*Q_fT))*(((((T_f0*itf_Vci_ei))*Q_fT)+((T_f0*itf)*Q_fT_Vci_ei)))*(((T_f0*itf_Vbi_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ei))+d10_sqrt0*(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vci_ei)*Q_fT+(T_f0*itf_Vbi_ei)*Q_fT_Vci_ei+((T_f0*itf_Vci_ei))*Q_fT_Vbi_ei+(T_f0*itf)*Q_fT_Vbi_ei_Vci_ei));
  Qf_Vbi_ei_Vtnode_GND=(m20_sqrt(((T_f0*itf)*Q_fT))*((((((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND)))*Q_fT)+((T_f0*itf)*Q_fT_Vtnode_GND)))*(((T_f0*itf_Vbi_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ei))+d10_sqrt0*(+(+0.0*itf+0.0*itf_Vtnode_GND+T_f0_Vtnode_GND*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vtnode_GND)*Q_fT+(T_f0*itf_Vbi_ei)*Q_fT_Vtnode_GND+(((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND)))*Q_fT_Vbi_ei+(T_f0*itf)*Q_fT_Vbi_ei_Vtnode_GND));
  Qf_Vbi_ei_Vbi_ci=(m20_sqrt(((T_f0*itf)*Q_fT))*((((((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci)))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ci)))*(((T_f0*itf_Vbi_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ei))+d10_sqrt0*(+(+0.0*itf+0.0*itf_Vbi_ci+T_f0_Vbi_ci*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vbi_ci)*Q_fT+(T_f0*itf_Vbi_ei)*Q_fT_Vbi_ci+(((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci)))*Q_fT_Vbi_ei+(T_f0*itf)*Q_fT_Vbi_ei_Vbi_ci));
  Qf_Vbi_ei_Vbi_ei=(m20_sqrt(((T_f0*itf)*Q_fT))*(((((T_f0*itf_Vbi_ei))*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ei)))*(((T_f0*itf_Vbi_ei)*Q_fT)+((T_f0*itf)*Q_fT_Vbi_ei))+d10_sqrt0*(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vbi_ei)*Q_fT+(T_f0*itf_Vbi_ei)*Q_fT_Vbi_ei+((T_f0*itf_Vbi_ei))*Q_fT_Vbi_ei+(T_f0*itf)*Q_fT_Vbi_ei_Vbi_ei));
#endif
#endif
Qf=d00_sqrt0;
}
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
Q_pT_Vtnode_GND=((Q_0_Vtnode_GND+Qf_Vtnode_GND)+Qr_Vtnode_GND);
#endif
Q_pT_Vbi_ei=((Q_0_Vbi_ei+Qf_Vbi_ei)+Qr_Vbi_ei);
#if defined(_DERIVATE)
  Q_pT_Vbi_ei_Vtnode_GND=(+(+Q_0_Vbi_ei_Vtnode_GND+Qf_Vbi_ei_Vtnode_GND)+Qr_Vbi_ei_Vtnode_GND);
  Q_pT_Vbi_ei_Vbi_ei=(+(+Q_0_Vbi_ei_Vbi_ei+Qf_Vbi_ei_Vbi_ei)+Qr_Vbi_ei_Vbi_ei);
  Q_pT_Vbi_ei_Vbi_ci=(+(+Q_0_Vbi_ei_Vbi_ci+Qf_Vbi_ei_Vbi_ci)+Qr_Vbi_ei_Vbi_ci);
  Q_pT_Vbi_ei_Vci_ei=(+(+0.0+Qf_Vbi_ei_Vci_ei)+Qr_Vbi_ei_Vci_ei);
#endif
Q_pT_Vbi_ci=((Q_0_Vbi_ci+Qf_Vbi_ci)+Qr_Vbi_ci);
#if defined(_DERIVATE)
  Q_pT_Vbi_ci_Vtnode_GND=(+(+Q_0_Vbi_ci_Vtnode_GND+Qf_Vbi_ci_Vtnode_GND)+Qr_Vbi_ci_Vtnode_GND);
  Q_pT_Vbi_ci_Vbi_ei=(+(+Q_0_Vbi_ci_Vbi_ei+Qf_Vbi_ci_Vbi_ei)+Qr_Vbi_ci_Vbi_ei);
  Q_pT_Vbi_ci_Vbi_ci=(+(+Q_0_Vbi_ci_Vbi_ci+Qf_Vbi_ci_Vbi_ci)+Qr_Vbi_ci_Vbi_ci);
  Q_pT_Vbi_ci_Vci_ei=(+(+0.0+Qf_Vbi_ci_Vci_ei)+Qr_Vbi_ci_Vci_ei);
#endif
Q_pT_Vci_ei=(Qf_Vci_ei+Qr_Vci_ei);
#if defined(_DERIVATE)
  Q_pT_Vci_ei_Vtnode_GND=(+(+0.0+Qf_Vci_ei_Vtnode_GND)+Qr_Vci_ei_Vtnode_GND);
  Q_pT_Vci_ei_Vbi_ei=(+(+0.0+Qf_Vci_ei_Vbi_ei)+Qr_Vci_ei_Vbi_ei);
  Q_pT_Vci_ei_Vbi_ci=(+(+0.0+Qf_Vci_ei_Vbi_ci)+Qr_Vci_ei_Vbi_ci);
  Q_pT_Vci_ei_Vci_ei=(+(+0.0+Qf_Vci_ei_Vci_ei)+Qr_Vci_ei_Vci_ei);
#endif
#endif
Q_pT=((Q_0+Qf)+Qr);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
d_Q_Vtnode_GND=Q_pT_Vtnode_GND;
#endif
d_Q_Vbi_ei=Q_pT_Vbi_ei;
#if defined(_DERIVATE)
  d_Q_Vbi_ei_Vtnode_GND=Q_pT_Vbi_ei_Vtnode_GND;
  d_Q_Vbi_ei_Vbi_ei=Q_pT_Vbi_ei_Vbi_ei;
  d_Q_Vbi_ei_Vbi_ci=Q_pT_Vbi_ei_Vbi_ci;
  d_Q_Vbi_ei_Vci_ei=Q_pT_Vbi_ei_Vci_ei;
#endif
d_Q_Vbi_ci=Q_pT_Vbi_ci;
#if defined(_DERIVATE)
  d_Q_Vbi_ci_Vtnode_GND=Q_pT_Vbi_ci_Vtnode_GND;
  d_Q_Vbi_ci_Vbi_ei=Q_pT_Vbi_ci_Vbi_ei;
  d_Q_Vbi_ci_Vbi_ci=Q_pT_Vbi_ci_Vbi_ci;
  d_Q_Vbi_ci_Vci_ei=Q_pT_Vbi_ci_Vci_ei;
#endif
d_Q_Vci_ei=Q_pT_Vci_ei;
#if defined(_DERIVATE)
  d_Q_Vci_ei_Vtnode_GND=Q_pT_Vci_ei_Vtnode_GND;
  d_Q_Vci_ei_Vbi_ei=Q_pT_Vci_ei_Vbi_ei;
  d_Q_Vci_ei_Vbi_ci=Q_pT_Vci_ei_Vbi_ci;
  d_Q_Vci_ei_Vci_ei=Q_pT_Vci_ei_Vci_ei;
#endif
#endif
d_Q=Q_pT;
while
(((fabs(d_Q)>=(1.0e-5*fabs(Q_pT)))&&(l_it<=100)))
{
#if defined(_DYNAMIC)
d_Q0=d_Q;
#endif
#if defined(_DERIVATEFORDDX)
I_Tf1_Vci_ei=(-i_0f*Q_pT_Vci_ei/Q_pT/Q_pT);
#if defined(_DERIVATE)
  I_Tf1_Vci_ei_Vci_ei=(0.0/Q_pT-(0.0*Q_pT_Vci_ei+0.0*Q_pT_Vci_ei+i_0f*Q_pT_Vci_ei_Vci_ei)/Q_pT/Q_pT+2*i_0f*Q_pT_Vci_ei*Q_pT_Vci_ei/Q_pT/Q_pT/Q_pT);
  I_Tf1_Vci_ei_Vtnode_GND=(0.0/Q_pT-(0.0*Q_pT_Vtnode_GND+i_0f_Vtnode_GND*Q_pT_Vci_ei+i_0f*Q_pT_Vci_ei_Vtnode_GND)/Q_pT/Q_pT+2*i_0f*Q_pT_Vci_ei*Q_pT_Vtnode_GND/Q_pT/Q_pT/Q_pT);
  I_Tf1_Vci_ei_Vbi_ei=(0.0/Q_pT-(0.0*Q_pT_Vbi_ei+i_0f_Vbi_ei*Q_pT_Vci_ei+i_0f*Q_pT_Vci_ei_Vbi_ei)/Q_pT/Q_pT+2*i_0f*Q_pT_Vci_ei*Q_pT_Vbi_ei/Q_pT/Q_pT/Q_pT);
  I_Tf1_Vci_ei_Vbi_ci=(0.0/Q_pT-(0.0*Q_pT_Vbi_ci+0.0*Q_pT_Vci_ei+i_0f*Q_pT_Vci_ei_Vbi_ci)/Q_pT/Q_pT+2*i_0f*Q_pT_Vci_ei*Q_pT_Vbi_ci/Q_pT/Q_pT/Q_pT);
#endif
#if defined(_DERIVATE)
I_Tf1_Vtnode_GND=((i_0f_Vtnode_GND*Q_pT-i_0f*Q_pT_Vtnode_GND)/Q_pT/Q_pT);
#endif
I_Tf1_Vbi_ei=((i_0f_Vbi_ei*Q_pT-i_0f*Q_pT_Vbi_ei)/Q_pT/Q_pT);
#if defined(_DERIVATE)
  I_Tf1_Vbi_ei_Vci_ei=(0.0/Q_pT-(i_0f_Vbi_ei*Q_pT_Vci_ei+0.0*Q_pT_Vbi_ei+i_0f*Q_pT_Vbi_ei_Vci_ei)/Q_pT/Q_pT+2*i_0f*Q_pT_Vbi_ei*Q_pT_Vci_ei/Q_pT/Q_pT/Q_pT);
  I_Tf1_Vbi_ei_Vtnode_GND=(i_0f_Vbi_ei_Vtnode_GND/Q_pT-(i_0f_Vbi_ei*Q_pT_Vtnode_GND+i_0f_Vtnode_GND*Q_pT_Vbi_ei+i_0f*Q_pT_Vbi_ei_Vtnode_GND)/Q_pT/Q_pT+2*i_0f*Q_pT_Vbi_ei*Q_pT_Vtnode_GND/Q_pT/Q_pT/Q_pT);
  I_Tf1_Vbi_ei_Vbi_ei=(i_0f_Vbi_ei_Vbi_ei/Q_pT-(i_0f_Vbi_ei*Q_pT_Vbi_ei+i_0f_Vbi_ei*Q_pT_Vbi_ei+i_0f*Q_pT_Vbi_ei_Vbi_ei)/Q_pT/Q_pT+2*i_0f*Q_pT_Vbi_ei*Q_pT_Vbi_ei/Q_pT/Q_pT/Q_pT);
  I_Tf1_Vbi_ei_Vbi_ci=(0.0/Q_pT-(i_0f_Vbi_ei*Q_pT_Vbi_ci+0.0*Q_pT_Vbi_ei+i_0f*Q_pT_Vbi_ei_Vbi_ci)/Q_pT/Q_pT+2*i_0f*Q_pT_Vbi_ei*Q_pT_Vbi_ci/Q_pT/Q_pT/Q_pT);
#endif
I_Tf1_Vbi_ci=(-i_0f*Q_pT_Vbi_ci/Q_pT/Q_pT);
#if defined(_DERIVATE)
  I_Tf1_Vbi_ci_Vci_ei=(0.0/Q_pT-(0.0*Q_pT_Vci_ei+0.0*Q_pT_Vbi_ci+i_0f*Q_pT_Vbi_ci_Vci_ei)/Q_pT/Q_pT+2*i_0f*Q_pT_Vbi_ci*Q_pT_Vci_ei/Q_pT/Q_pT/Q_pT);
  I_Tf1_Vbi_ci_Vtnode_GND=(0.0/Q_pT-(0.0*Q_pT_Vtnode_GND+i_0f_Vtnode_GND*Q_pT_Vbi_ci+i_0f*Q_pT_Vbi_ci_Vtnode_GND)/Q_pT/Q_pT+2*i_0f*Q_pT_Vbi_ci*Q_pT_Vtnode_GND/Q_pT/Q_pT/Q_pT);
  I_Tf1_Vbi_ci_Vbi_ei=(0.0/Q_pT-(0.0*Q_pT_Vbi_ei+i_0f_Vbi_ei*Q_pT_Vbi_ci+i_0f*Q_pT_Vbi_ci_Vbi_ei)/Q_pT/Q_pT+2*i_0f*Q_pT_Vbi_ci*Q_pT_Vbi_ei/Q_pT/Q_pT/Q_pT);
  I_Tf1_Vbi_ci_Vbi_ci=(0.0/Q_pT-(0.0*Q_pT_Vbi_ci+0.0*Q_pT_Vbi_ci+i_0f*Q_pT_Vbi_ci_Vbi_ci)/Q_pT/Q_pT+2*i_0f*Q_pT_Vbi_ci*Q_pT_Vbi_ci/Q_pT/Q_pT/Q_pT);
#endif
#endif
I_Tf1=(i_0f/Q_pT);
#if defined(_DERIVATEFORDDX)
a_h_Vci_ei=(Oich*I_Tf1_Vci_ei);
#if defined(_DERIVATE)
  a_h_Vci_ei_Vci_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vci_ei+0.0*I_Tf1_Vci_ei+Oich*I_Tf1_Vci_ei_Vci_ei);
  a_h_Vci_ei_Vtnode_GND=(+0.0*I_Tf1+0.0*I_Tf1_Vtnode_GND+0.0*I_Tf1_Vci_ei+Oich*I_Tf1_Vci_ei_Vtnode_GND);
  a_h_Vci_ei_Vbi_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ei+0.0*I_Tf1_Vci_ei+Oich*I_Tf1_Vci_ei_Vbi_ei);
  a_h_Vci_ei_Vbi_ci=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ci+0.0*I_Tf1_Vci_ei+Oich*I_Tf1_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
a_h_Vtnode_GND=(Oich*I_Tf1_Vtnode_GND);
#endif
a_h_Vbi_ei=(Oich*I_Tf1_Vbi_ei);
#if defined(_DERIVATE)
  a_h_Vbi_ei_Vci_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vci_ei+0.0*I_Tf1_Vbi_ei+Oich*I_Tf1_Vbi_ei_Vci_ei);
  a_h_Vbi_ei_Vtnode_GND=(+0.0*I_Tf1+0.0*I_Tf1_Vtnode_GND+0.0*I_Tf1_Vbi_ei+Oich*I_Tf1_Vbi_ei_Vtnode_GND);
  a_h_Vbi_ei_Vbi_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ei+0.0*I_Tf1_Vbi_ei+Oich*I_Tf1_Vbi_ei_Vbi_ei);
  a_h_Vbi_ei_Vbi_ci=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ci+0.0*I_Tf1_Vbi_ei+Oich*I_Tf1_Vbi_ei_Vbi_ci);
#endif
a_h_Vbi_ci=(Oich*I_Tf1_Vbi_ci);
#if defined(_DERIVATE)
  a_h_Vbi_ci_Vci_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vci_ei+0.0*I_Tf1_Vbi_ci+Oich*I_Tf1_Vbi_ci_Vci_ei);
  a_h_Vbi_ci_Vtnode_GND=(+0.0*I_Tf1+0.0*I_Tf1_Vtnode_GND+0.0*I_Tf1_Vbi_ci+Oich*I_Tf1_Vbi_ci_Vtnode_GND);
  a_h_Vbi_ci_Vbi_ei=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ei+0.0*I_Tf1_Vbi_ci+Oich*I_Tf1_Vbi_ci_Vbi_ei);
  a_h_Vbi_ci_Vbi_ci=(+0.0*I_Tf1+0.0*I_Tf1_Vbi_ci+0.0*I_Tf1_Vbi_ci+Oich*I_Tf1_Vbi_ci_Vbi_ci);
#endif
#endif
a_h=(Oich*I_Tf1);
#if defined(_DERIVATEFORDDX)
itf_Vci_ei=((I_Tf1_Vci_ei*(1.0+a_h))+(I_Tf1*a_h_Vci_ei));
#if defined(_DERIVATE)
  itf_Vci_ei_Vci_ei=(+I_Tf1_Vci_ei_Vci_ei*(1.0+a_h)+I_Tf1_Vci_ei*a_h_Vci_ei+I_Tf1_Vci_ei*a_h_Vci_ei+I_Tf1*(+0.0+a_h_Vci_ei_Vci_ei));
  itf_Vci_ei_Vtnode_GND=(+I_Tf1_Vci_ei_Vtnode_GND*(1.0+a_h)+I_Tf1_Vci_ei*a_h_Vtnode_GND+I_Tf1_Vtnode_GND*a_h_Vci_ei+I_Tf1*(+0.0+a_h_Vci_ei_Vtnode_GND));
  itf_Vci_ei_Vbi_ei=(+I_Tf1_Vci_ei_Vbi_ei*(1.0+a_h)+I_Tf1_Vci_ei*a_h_Vbi_ei+I_Tf1_Vbi_ei*a_h_Vci_ei+I_Tf1*(+0.0+a_h_Vci_ei_Vbi_ei));
  itf_Vci_ei_Vbi_ci=(+I_Tf1_Vci_ei_Vbi_ci*(1.0+a_h)+I_Tf1_Vci_ei*a_h_Vbi_ci+I_Tf1_Vbi_ci*a_h_Vci_ei+I_Tf1*(+0.0+a_h_Vci_ei_Vbi_ci));
#endif
#if defined(_DERIVATE)
itf_Vtnode_GND=((I_Tf1_Vtnode_GND*(1.0+a_h))+(I_Tf1*a_h_Vtnode_GND));
#endif
itf_Vbi_ei=((I_Tf1_Vbi_ei*(1.0+a_h))+(I_Tf1*a_h_Vbi_ei));
#if defined(_DERIVATE)
  itf_Vbi_ei_Vci_ei=(+I_Tf1_Vbi_ei_Vci_ei*(1.0+a_h)+I_Tf1_Vbi_ei*a_h_Vci_ei+I_Tf1_Vci_ei*a_h_Vbi_ei+I_Tf1*(+0.0+a_h_Vbi_ei_Vci_ei));
  itf_Vbi_ei_Vtnode_GND=(+I_Tf1_Vbi_ei_Vtnode_GND*(1.0+a_h)+I_Tf1_Vbi_ei*a_h_Vtnode_GND+I_Tf1_Vtnode_GND*a_h_Vbi_ei+I_Tf1*(+0.0+a_h_Vbi_ei_Vtnode_GND));
  itf_Vbi_ei_Vbi_ei=(+I_Tf1_Vbi_ei_Vbi_ei*(1.0+a_h)+I_Tf1_Vbi_ei*a_h_Vbi_ei+I_Tf1_Vbi_ei*a_h_Vbi_ei+I_Tf1*(+0.0+a_h_Vbi_ei_Vbi_ei));
  itf_Vbi_ei_Vbi_ci=(+I_Tf1_Vbi_ei_Vbi_ci*(1.0+a_h)+I_Tf1_Vbi_ei*a_h_Vbi_ci+I_Tf1_Vbi_ci*a_h_Vbi_ei+I_Tf1*(+0.0+a_h_Vbi_ei_Vbi_ci));
#endif
itf_Vbi_ci=((I_Tf1_Vbi_ci*(1.0+a_h))+(I_Tf1*a_h_Vbi_ci));
#if defined(_DERIVATE)
  itf_Vbi_ci_Vci_ei=(+I_Tf1_Vbi_ci_Vci_ei*(1.0+a_h)+I_Tf1_Vbi_ci*a_h_Vci_ei+I_Tf1_Vci_ei*a_h_Vbi_ci+I_Tf1*(+0.0+a_h_Vbi_ci_Vci_ei));
  itf_Vbi_ci_Vtnode_GND=(+I_Tf1_Vbi_ci_Vtnode_GND*(1.0+a_h)+I_Tf1_Vbi_ci*a_h_Vtnode_GND+I_Tf1_Vtnode_GND*a_h_Vbi_ci+I_Tf1*(+0.0+a_h_Vbi_ci_Vtnode_GND));
  itf_Vbi_ci_Vbi_ei=(+I_Tf1_Vbi_ci_Vbi_ei*(1.0+a_h)+I_Tf1_Vbi_ci*a_h_Vbi_ei+I_Tf1_Vbi_ei*a_h_Vbi_ci+I_Tf1*(+0.0+a_h_Vbi_ci_Vbi_ei));
  itf_Vbi_ci_Vbi_ci=(+I_Tf1_Vbi_ci_Vbi_ci*(1.0+a_h)+I_Tf1_Vbi_ci*a_h_Vbi_ci+I_Tf1_Vbi_ci*a_h_Vbi_ci+I_Tf1*(+0.0+a_h_Vbi_ci_Vbi_ci));
#endif
#endif
itf=(I_Tf1*(1.0+a_h));
#if defined(_DERIVATEFORDDX)
itr_Vci_ei=(-i_0r*Q_pT_Vci_ei/Q_pT/Q_pT);
#if defined(_DERIVATE)
  itr_Vci_ei_Vci_ei=(0.0/Q_pT-(0.0*Q_pT_Vci_ei+0.0*Q_pT_Vci_ei+i_0r*Q_pT_Vci_ei_Vci_ei)/Q_pT/Q_pT+2*i_0r*Q_pT_Vci_ei*Q_pT_Vci_ei/Q_pT/Q_pT/Q_pT);
  itr_Vci_ei_Vtnode_GND=(0.0/Q_pT-(0.0*Q_pT_Vtnode_GND+i_0r_Vtnode_GND*Q_pT_Vci_ei+i_0r*Q_pT_Vci_ei_Vtnode_GND)/Q_pT/Q_pT+2*i_0r*Q_pT_Vci_ei*Q_pT_Vtnode_GND/Q_pT/Q_pT/Q_pT);
  itr_Vci_ei_Vbi_ci=(0.0/Q_pT-(0.0*Q_pT_Vbi_ci+i_0r_Vbi_ci*Q_pT_Vci_ei+i_0r*Q_pT_Vci_ei_Vbi_ci)/Q_pT/Q_pT+2*i_0r*Q_pT_Vci_ei*Q_pT_Vbi_ci/Q_pT/Q_pT/Q_pT);
  itr_Vci_ei_Vbi_ei=(0.0/Q_pT-(0.0*Q_pT_Vbi_ei+0.0*Q_pT_Vci_ei+i_0r*Q_pT_Vci_ei_Vbi_ei)/Q_pT/Q_pT+2*i_0r*Q_pT_Vci_ei*Q_pT_Vbi_ei/Q_pT/Q_pT/Q_pT);
#endif
#if defined(_DERIVATE)
itr_Vtnode_GND=((i_0r_Vtnode_GND*Q_pT-i_0r*Q_pT_Vtnode_GND)/Q_pT/Q_pT);
#endif
itr_Vbi_ci=((i_0r_Vbi_ci*Q_pT-i_0r*Q_pT_Vbi_ci)/Q_pT/Q_pT);
#if defined(_DERIVATE)
  itr_Vbi_ci_Vci_ei=(0.0/Q_pT-(i_0r_Vbi_ci*Q_pT_Vci_ei+0.0*Q_pT_Vbi_ci+i_0r*Q_pT_Vbi_ci_Vci_ei)/Q_pT/Q_pT+2*i_0r*Q_pT_Vbi_ci*Q_pT_Vci_ei/Q_pT/Q_pT/Q_pT);
  itr_Vbi_ci_Vtnode_GND=(i_0r_Vbi_ci_Vtnode_GND/Q_pT-(i_0r_Vbi_ci*Q_pT_Vtnode_GND+i_0r_Vtnode_GND*Q_pT_Vbi_ci+i_0r*Q_pT_Vbi_ci_Vtnode_GND)/Q_pT/Q_pT+2*i_0r*Q_pT_Vbi_ci*Q_pT_Vtnode_GND/Q_pT/Q_pT/Q_pT);
  itr_Vbi_ci_Vbi_ci=(i_0r_Vbi_ci_Vbi_ci/Q_pT-(i_0r_Vbi_ci*Q_pT_Vbi_ci+i_0r_Vbi_ci*Q_pT_Vbi_ci+i_0r*Q_pT_Vbi_ci_Vbi_ci)/Q_pT/Q_pT+2*i_0r*Q_pT_Vbi_ci*Q_pT_Vbi_ci/Q_pT/Q_pT/Q_pT);
  itr_Vbi_ci_Vbi_ei=(0.0/Q_pT-(i_0r_Vbi_ci*Q_pT_Vbi_ei+0.0*Q_pT_Vbi_ci+i_0r*Q_pT_Vbi_ci_Vbi_ei)/Q_pT/Q_pT+2*i_0r*Q_pT_Vbi_ci*Q_pT_Vbi_ei/Q_pT/Q_pT/Q_pT);
#endif
itr_Vbi_ei=(-i_0r*Q_pT_Vbi_ei/Q_pT/Q_pT);
#if defined(_DERIVATE)
  itr_Vbi_ei_Vci_ei=(0.0/Q_pT-(0.0*Q_pT_Vci_ei+0.0*Q_pT_Vbi_ei+i_0r*Q_pT_Vbi_ei_Vci_ei)/Q_pT/Q_pT+2*i_0r*Q_pT_Vbi_ei*Q_pT_Vci_ei/Q_pT/Q_pT/Q_pT);
  itr_Vbi_ei_Vtnode_GND=(0.0/Q_pT-(0.0*Q_pT_Vtnode_GND+i_0r_Vtnode_GND*Q_pT_Vbi_ei+i_0r*Q_pT_Vbi_ei_Vtnode_GND)/Q_pT/Q_pT+2*i_0r*Q_pT_Vbi_ei*Q_pT_Vtnode_GND/Q_pT/Q_pT/Q_pT);
  itr_Vbi_ei_Vbi_ci=(0.0/Q_pT-(0.0*Q_pT_Vbi_ci+i_0r_Vbi_ci*Q_pT_Vbi_ei+i_0r*Q_pT_Vbi_ei_Vbi_ci)/Q_pT/Q_pT+2*i_0r*Q_pT_Vbi_ei*Q_pT_Vbi_ci/Q_pT/Q_pT/Q_pT);
  itr_Vbi_ei_Vbi_ei=(0.0/Q_pT-(0.0*Q_pT_Vbi_ei+0.0*Q_pT_Vbi_ei+i_0r*Q_pT_Vbi_ei_Vbi_ei)/Q_pT/Q_pT+2*i_0r*Q_pT_Vbi_ei*Q_pT_Vbi_ei/Q_pT/Q_pT/Q_pT);
#endif
#endif
itr=(i_0r/Q_pT);
#if defined(_DERIVATEFORDDX)
Tf_Vci_ei=0.0;
#if defined(_DERIVATE)
  Tf_Vci_ei_Vci_ei=0.0;
  Tf_Vci_ei_Vbi_ei=0.0;
  Tf_Vci_ei_Vtnode_GND=0.0;
  Tf_Vci_ei_Vbi_ci=0.0;
#endif
Tf_Vbi_ei=0.0;
#if defined(_DERIVATE)
  Tf_Vbi_ei_Vci_ei=0.0;
  Tf_Vbi_ei_Vbi_ei=0.0;
  Tf_Vbi_ei_Vtnode_GND=0.0;
  Tf_Vbi_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
Tf_Vtnode_GND=T_f0_Vtnode_GND;
#endif
Tf_Vbi_ci=T_f0_Vbi_ci;
#if defined(_DERIVATE)
  Tf_Vbi_ci_Vci_ei=0.0;
  Tf_Vbi_ci_Vbi_ei=0.0;
  Tf_Vbi_ci_Vtnode_GND=T_f0_Vbi_ci_Vtnode_GND;
  Tf_Vbi_ci_Vbi_ci=T_f0_Vbi_ci_Vbi_ci;
#endif
#endif
Tf=T_f0;
#if defined(_DERIVATEFORDDX)
Qf_Vci_ei=(T_f0*itf_Vci_ei);
#if defined(_DERIVATE)
  Qf_Vci_ei_Vci_ei=(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vci_ei+T_f0*itf_Vci_ei_Vci_ei);
  Qf_Vci_ei_Vtnode_GND=(+0.0*itf+0.0*itf_Vtnode_GND+T_f0_Vtnode_GND*itf_Vci_ei+T_f0*itf_Vci_ei_Vtnode_GND);
  Qf_Vci_ei_Vbi_ci=(+0.0*itf+0.0*itf_Vbi_ci+T_f0_Vbi_ci*itf_Vci_ei+T_f0*itf_Vci_ei_Vbi_ci);
  Qf_Vci_ei_Vbi_ei=(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vci_ei+T_f0*itf_Vci_ei_Vbi_ei);
#endif
#if defined(_DERIVATE)
Qf_Vtnode_GND=((T_f0_Vtnode_GND*itf)+(T_f0*itf_Vtnode_GND));
#endif
Qf_Vbi_ci=((T_f0_Vbi_ci*itf)+(T_f0*itf_Vbi_ci));
#if defined(_DERIVATE)
  Qf_Vbi_ci_Vci_ei=(+0.0*itf+T_f0_Vbi_ci*itf_Vci_ei+0.0*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vci_ei);
  Qf_Vbi_ci_Vtnode_GND=(+T_f0_Vbi_ci_Vtnode_GND*itf+T_f0_Vbi_ci*itf_Vtnode_GND+T_f0_Vtnode_GND*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vtnode_GND);
  Qf_Vbi_ci_Vbi_ci=(+T_f0_Vbi_ci_Vbi_ci*itf+T_f0_Vbi_ci*itf_Vbi_ci+T_f0_Vbi_ci*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vbi_ci);
  Qf_Vbi_ci_Vbi_ei=(+0.0*itf+T_f0_Vbi_ci*itf_Vbi_ei+0.0*itf_Vbi_ci+T_f0*itf_Vbi_ci_Vbi_ei);
#endif
Qf_Vbi_ei=(T_f0*itf_Vbi_ei);
#if defined(_DERIVATE)
  Qf_Vbi_ei_Vci_ei=(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vci_ei);
  Qf_Vbi_ei_Vtnode_GND=(+0.0*itf+0.0*itf_Vtnode_GND+T_f0_Vtnode_GND*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vtnode_GND);
  Qf_Vbi_ei_Vbi_ci=(+0.0*itf+0.0*itf_Vbi_ci+T_f0_Vbi_ci*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vbi_ci);
  Qf_Vbi_ei_Vbi_ei=(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+T_f0*itf_Vbi_ei_Vbi_ei);
#endif
#endif
Qf=(T_f0*itf);
if
((itf<(1.0e-6*ick)))
{
#if defined(_DERIVATEFORDDX)
Q_fT_Vci_ei=Qf_Vci_ei;
#if defined(_DERIVATE)
  Q_fT_Vci_ei_Vci_ei=Qf_Vci_ei_Vci_ei;
  Q_fT_Vci_ei_Vtnode_GND=Qf_Vci_ei_Vtnode_GND;
  Q_fT_Vci_ei_Vbi_ci=Qf_Vci_ei_Vbi_ci;
  Q_fT_Vci_ei_Vbi_ei=Qf_Vci_ei_Vbi_ei;
#endif
#if defined(_DERIVATE)
Q_fT_Vtnode_GND=Qf_Vtnode_GND;
#endif
Q_fT_Vbi_ci=Qf_Vbi_ci;
#if defined(_DERIVATE)
  Q_fT_Vbi_ci_Vci_ei=Qf_Vbi_ci_Vci_ei;
  Q_fT_Vbi_ci_Vtnode_GND=Qf_Vbi_ci_Vtnode_GND;
  Q_fT_Vbi_ci_Vbi_ci=Qf_Vbi_ci_Vbi_ci;
  Q_fT_Vbi_ci_Vbi_ei=Qf_Vbi_ci_Vbi_ei;
#endif
Q_fT_Vbi_ei=Qf_Vbi_ei;
#if defined(_DERIVATE)
  Q_fT_Vbi_ei_Vci_ei=Qf_Vbi_ei_Vci_ei;
  Q_fT_Vbi_ei_Vtnode_GND=Qf_Vbi_ei_Vtnode_GND;
  Q_fT_Vbi_ei_Vbi_ci=Qf_Vbi_ei_Vbi_ci;
  Q_fT_Vbi_ei_Vbi_ei=Qf_Vbi_ei_Vbi_ei;
#endif
#endif
Q_fT=Qf;
#if defined(_DERIVATEFORDDX)
T_fT_Vci_ei=Tf_Vci_ei;
#if defined(_DERIVATE)
  T_fT_Vci_ei_Vci_ei=Tf_Vci_ei_Vci_ei;
  T_fT_Vci_ei_Vbi_ei=Tf_Vci_ei_Vbi_ei;
  T_fT_Vci_ei_Vtnode_GND=Tf_Vci_ei_Vtnode_GND;
  T_fT_Vci_ei_Vbi_ci=Tf_Vci_ei_Vbi_ci;
#endif
T_fT_Vbi_ei=Tf_Vbi_ei;
#if defined(_DERIVATE)
  T_fT_Vbi_ei_Vci_ei=Tf_Vbi_ei_Vci_ei;
  T_fT_Vbi_ei_Vbi_ei=Tf_Vbi_ei_Vbi_ei;
  T_fT_Vbi_ei_Vtnode_GND=Tf_Vbi_ei_Vtnode_GND;
  T_fT_Vbi_ei_Vbi_ci=Tf_Vbi_ei_Vbi_ci;
#endif
#if defined(_DERIVATE)
T_fT_Vtnode_GND=Tf_Vtnode_GND;
#endif
T_fT_Vbi_ci=Tf_Vbi_ci;
#if defined(_DERIVATE)
  T_fT_Vbi_ci_Vci_ei=Tf_Vbi_ci_Vci_ei;
  T_fT_Vbi_ci_Vbi_ei=Tf_Vbi_ci_Vbi_ei;
  T_fT_Vbi_ci_Vtnode_GND=Tf_Vbi_ci_Vtnode_GND;
  T_fT_Vbi_ci_Vbi_ci=Tf_Vbi_ci_Vbi_ci;
#endif
#endif
T_fT=Tf;
}
else
{
#if defined(_DERIVATEFORDDX)
FFa_Vci_ei=((ick_Vci_ei*itf-ick*itf_Vci_ei)/itf/itf);
#if defined(_DERIVATE)
  FFa_Vci_ei_Vci_ei=(ick_Vci_ei_Vci_ei/itf-(ick_Vci_ei*itf_Vci_ei+ick_Vci_ei*itf_Vci_ei+ick*itf_Vci_ei_Vci_ei)/itf/itf+2*ick*itf_Vci_ei*itf_Vci_ei/itf/itf/itf);
  FFa_Vci_ei_Vtnode_GND=(ick_Vci_ei_Vtnode_GND/itf-(ick_Vci_ei*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vci_ei+ick*itf_Vci_ei_Vtnode_GND)/itf/itf+2*ick*itf_Vci_ei*itf_Vtnode_GND/itf/itf/itf);
  FFa_Vci_ei_Vbi_ei=(0.0/itf-(ick_Vci_ei*itf_Vbi_ei+0.0*itf_Vci_ei+ick*itf_Vci_ei_Vbi_ei)/itf/itf+2*ick*itf_Vci_ei*itf_Vbi_ei/itf/itf/itf);
  FFa_Vci_ei_Vbi_ci=(0.0/itf-(ick_Vci_ei*itf_Vbi_ci+0.0*itf_Vci_ei+ick*itf_Vci_ei_Vbi_ci)/itf/itf+2*ick*itf_Vci_ei*itf_Vbi_ci/itf/itf/itf);
#endif
#if defined(_DERIVATE)
FFa_Vtnode_GND=((ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/itf/itf);
#endif
FFa_Vbi_ei=(-ick*itf_Vbi_ei/itf/itf);
#if defined(_DERIVATE)
  FFa_Vbi_ei_Vci_ei=(0.0/itf-(0.0*itf_Vci_ei+ick_Vci_ei*itf_Vbi_ei+ick*itf_Vbi_ei_Vci_ei)/itf/itf+2*ick*itf_Vbi_ei*itf_Vci_ei/itf/itf/itf);
  FFa_Vbi_ei_Vtnode_GND=(0.0/itf-(0.0*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vbi_ei+ick*itf_Vbi_ei_Vtnode_GND)/itf/itf+2*ick*itf_Vbi_ei*itf_Vtnode_GND/itf/itf/itf);
  FFa_Vbi_ei_Vbi_ei=(0.0/itf-(0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+ick*itf_Vbi_ei_Vbi_ei)/itf/itf+2*ick*itf_Vbi_ei*itf_Vbi_ei/itf/itf/itf);
  FFa_Vbi_ei_Vbi_ci=(0.0/itf-(0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+ick*itf_Vbi_ei_Vbi_ci)/itf/itf+2*ick*itf_Vbi_ei*itf_Vbi_ci/itf/itf/itf);
#endif
FFa_Vbi_ci=(-ick*itf_Vbi_ci/itf/itf);
#if defined(_DERIVATE)
  FFa_Vbi_ci_Vci_ei=(0.0/itf-(0.0*itf_Vci_ei+ick_Vci_ei*itf_Vbi_ci+ick*itf_Vbi_ci_Vci_ei)/itf/itf+2*ick*itf_Vbi_ci*itf_Vci_ei/itf/itf/itf);
  FFa_Vbi_ci_Vtnode_GND=(0.0/itf-(0.0*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vbi_ci+ick*itf_Vbi_ci_Vtnode_GND)/itf/itf+2*ick*itf_Vbi_ci*itf_Vtnode_GND/itf/itf/itf);
  FFa_Vbi_ci_Vbi_ei=(0.0/itf-(0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+ick*itf_Vbi_ci_Vbi_ei)/itf/itf+2*ick*itf_Vbi_ci*itf_Vbi_ei/itf/itf/itf);
  FFa_Vbi_ci_Vbi_ci=(0.0/itf-(0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+ick*itf_Vbi_ci_Vbi_ci)/itf/itf+2*ick*itf_Vbi_ci*itf_Vbi_ci/itf/itf/itf);
#endif
#endif
FFa=(ick/itf);
{
double m00_logE(d00_logE0,FFa)
double m00_exp(d00_exp1,((-gtfe)*d00_logE0))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,FFa)
#define d10_exp1 d00_exp1
#endif
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFd_TfE_Vtnode_GND=((tef0_t_Vtnode_GND*d00_exp1)+(tef0_t*((-gtfe)*FFa_Vtnode_GND*d10_logE0)*d10_exp1));
#endif
FFd_TfE_Vci_ei=(tef0_t*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1);
#if defined(_DERIVATE)
  FFd_TfE_Vci_ei_Vtnode_GND=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*d10_exp1+tef0_t_Vtnode_GND*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*((-gtfe)*FFa_Vci_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vtnode_GND*d10_logE0+0.0*FFa_Vci_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vtnode_GND*FFa_Vci_ei+d10_logE0*FFa_Vci_ei_Vtnode_GND))));
  FFd_TfE_Vci_ei_Vci_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vci_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vci_ei*d10_logE0))*((-gtfe)*FFa_Vci_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vci_ei*d10_logE0+0.0*FFa_Vci_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vci_ei*FFa_Vci_ei+d10_logE0*FFa_Vci_ei_Vci_ei))));
  FFd_TfE_Vci_ei_Vbi_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*((-gtfe)*FFa_Vci_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ei*d10_logE0+0.0*FFa_Vci_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ei*FFa_Vci_ei+d10_logE0*FFa_Vci_ei_Vbi_ei))));
  FFd_TfE_Vci_ei_Vbi_ci=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vci_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*((-gtfe)*FFa_Vci_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ci*d10_logE0+0.0*FFa_Vci_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ci*FFa_Vci_ei+d10_logE0*FFa_Vci_ei_Vbi_ci))));
#endif
FFd_TfE_Vbi_ei=(tef0_t*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1);
#if defined(_DERIVATE)
  FFd_TfE_Vbi_ei_Vtnode_GND=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*d10_exp1+tef0_t_Vtnode_GND*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*((-gtfe)*FFa_Vbi_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vtnode_GND*d10_logE0+0.0*FFa_Vbi_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vtnode_GND*FFa_Vbi_ei+d10_logE0*FFa_Vbi_ei_Vtnode_GND))));
  FFd_TfE_Vbi_ei_Vci_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vci_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vci_ei*d10_logE0))*((-gtfe)*FFa_Vbi_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vci_ei*d10_logE0+0.0*FFa_Vbi_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vci_ei*FFa_Vbi_ei+d10_logE0*FFa_Vbi_ei_Vci_ei))));
  FFd_TfE_Vbi_ei_Vbi_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*((-gtfe)*FFa_Vbi_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ei*d10_logE0+0.0*FFa_Vbi_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ei*FFa_Vbi_ei+d10_logE0*FFa_Vbi_ei_Vbi_ei))));
  FFd_TfE_Vbi_ei_Vbi_ci=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ei*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*((-gtfe)*FFa_Vbi_ei*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ci*d10_logE0+0.0*FFa_Vbi_ei*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ci*FFa_Vbi_ei+d10_logE0*FFa_Vbi_ei_Vbi_ci))));
#endif
FFd_TfE_Vbi_ci=(tef0_t*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1);
#if defined(_DERIVATE)
  FFd_TfE_Vbi_ci_Vtnode_GND=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*d10_exp1+tef0_t_Vtnode_GND*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vtnode_GND*d10_logE0))*((-gtfe)*FFa_Vbi_ci*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vtnode_GND*d10_logE0+0.0*FFa_Vbi_ci*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vtnode_GND*FFa_Vbi_ci+d10_logE0*FFa_Vbi_ci_Vtnode_GND))));
  FFd_TfE_Vbi_ci_Vci_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vci_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vci_ei*d10_logE0))*((-gtfe)*FFa_Vbi_ci*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vci_ei*d10_logE0+0.0*FFa_Vbi_ci*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vci_ei*FFa_Vbi_ci+d10_logE0*FFa_Vbi_ci_Vci_ei))));
  FFd_TfE_Vbi_ci_Vbi_ei=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ei*d10_logE0))*((-gtfe)*FFa_Vbi_ci*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ei*d10_logE0+0.0*FFa_Vbi_ci*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ei*FFa_Vbi_ci+d10_logE0*FFa_Vbi_ci_Vbi_ei))));
  FFd_TfE_Vbi_ci_Vbi_ci=(+0.0*d00_exp1+0.0*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*d10_exp1+0.0*((-gtfe)*FFa_Vbi_ci*d10_logE0)*d10_exp1+tef0_t*(m20_exp(((-gtfe)*d00_logE0))*(((-gtfe)*FFa_Vbi_ci*d10_logE0))*((-gtfe)*FFa_Vbi_ci*d10_logE0)+d10_exp1*(+0.0*d00_logE0+0.0*FFa_Vbi_ci*d10_logE0+0.0*FFa_Vbi_ci*d10_logE0+(-gtfe)*(m20_logE(FFa)*FFa_Vbi_ci*FFa_Vbi_ci+d10_logE0*FFa_Vbi_ci_Vbi_ci))));
#endif
#endif
FFd_TfE=(tef0_t*d00_exp1);
}
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFd_QfE_Vtnode_GND=(((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND))/(gtfe+1.0));
#endif
FFd_QfE_Vci_ei=(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))/(gtfe+1.0));
#if defined(_DERIVATE)
  FFd_QfE_Vci_ei_Vtnode_GND=((+FFd_TfE_Vci_ei_Vtnode_GND*itf+FFd_TfE_Vci_ei*itf_Vtnode_GND+FFd_TfE_Vtnode_GND*itf_Vci_ei+FFd_TfE*itf_Vci_ei_Vtnode_GND)/(gtfe+1.0)-(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))*0.0+(((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vci_ei_Vci_ei=((+FFd_TfE_Vci_ei_Vci_ei*itf+FFd_TfE_Vci_ei*itf_Vci_ei+FFd_TfE_Vci_ei*itf_Vci_ei+FFd_TfE*itf_Vci_ei_Vci_ei)/(gtfe+1.0)-(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))*0.0+(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vci_ei_Vbi_ei=((+FFd_TfE_Vci_ei_Vbi_ei*itf+FFd_TfE_Vci_ei*itf_Vbi_ei+FFd_TfE_Vbi_ei*itf_Vci_ei+FFd_TfE*itf_Vci_ei_Vbi_ei)/(gtfe+1.0)-(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))*0.0+(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vci_ei_Vbi_ci=((+FFd_TfE_Vci_ei_Vbi_ci*itf+FFd_TfE_Vci_ei*itf_Vbi_ci+FFd_TfE_Vbi_ci*itf_Vci_ei+FFd_TfE*itf_Vci_ei_Vbi_ci)/(gtfe+1.0)-(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei))*0.0+(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
#endif
FFd_QfE_Vbi_ei=(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))/(gtfe+1.0));
#if defined(_DERIVATE)
  FFd_QfE_Vbi_ei_Vtnode_GND=((+FFd_TfE_Vbi_ei_Vtnode_GND*itf+FFd_TfE_Vbi_ei*itf_Vtnode_GND+FFd_TfE_Vtnode_GND*itf_Vbi_ei+FFd_TfE*itf_Vbi_ei_Vtnode_GND)/(gtfe+1.0)-(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))*0.0+(((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ei_Vci_ei=((+FFd_TfE_Vbi_ei_Vci_ei*itf+FFd_TfE_Vbi_ei*itf_Vci_ei+FFd_TfE_Vci_ei*itf_Vbi_ei+FFd_TfE*itf_Vbi_ei_Vci_ei)/(gtfe+1.0)-(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))*0.0+(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ei_Vbi_ei=((+FFd_TfE_Vbi_ei_Vbi_ei*itf+FFd_TfE_Vbi_ei*itf_Vbi_ei+FFd_TfE_Vbi_ei*itf_Vbi_ei+FFd_TfE*itf_Vbi_ei_Vbi_ei)/(gtfe+1.0)-(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))*0.0+(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ei_Vbi_ci=((+FFd_TfE_Vbi_ei_Vbi_ci*itf+FFd_TfE_Vbi_ei*itf_Vbi_ci+FFd_TfE_Vbi_ci*itf_Vbi_ei+FFd_TfE*itf_Vbi_ei_Vbi_ci)/(gtfe+1.0)-(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei))*0.0+(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
#endif
FFd_QfE_Vbi_ci=(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))/(gtfe+1.0));
#if defined(_DERIVATE)
  FFd_QfE_Vbi_ci_Vtnode_GND=((+FFd_TfE_Vbi_ci_Vtnode_GND*itf+FFd_TfE_Vbi_ci*itf_Vtnode_GND+FFd_TfE_Vtnode_GND*itf_Vbi_ci+FFd_TfE*itf_Vbi_ci_Vtnode_GND)/(gtfe+1.0)-(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))*0.0+(((FFd_TfE_Vtnode_GND*itf)+(FFd_TfE*itf_Vtnode_GND)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ci_Vci_ei=((+FFd_TfE_Vbi_ci_Vci_ei*itf+FFd_TfE_Vbi_ci*itf_Vci_ei+FFd_TfE_Vci_ei*itf_Vbi_ci+FFd_TfE*itf_Vbi_ci_Vci_ei)/(gtfe+1.0)-(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))*0.0+(((FFd_TfE_Vci_ei*itf)+(FFd_TfE*itf_Vci_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ci_Vbi_ei=((+FFd_TfE_Vbi_ci_Vbi_ei*itf+FFd_TfE_Vbi_ci*itf_Vbi_ei+FFd_TfE_Vbi_ei*itf_Vbi_ci+FFd_TfE*itf_Vbi_ci_Vbi_ei)/(gtfe+1.0)-(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))*0.0+(((FFd_TfE_Vbi_ei*itf)+(FFd_TfE*itf_Vbi_ei)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
  FFd_QfE_Vbi_ci_Vbi_ci=((+FFd_TfE_Vbi_ci_Vbi_ci*itf+FFd_TfE_Vbi_ci*itf_Vbi_ci+FFd_TfE_Vbi_ci*itf_Vbi_ci+FFd_TfE*itf_Vbi_ci_Vbi_ci)/(gtfe+1.0)-(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci))*0.0+(((FFd_TfE_Vbi_ci*itf)+(FFd_TfE*itf_Vbi_ci)))*0.0+(FFd_TfE*itf)*(+0.0+0.0))/(gtfe+1.0)/(gtfe+1.0)+2*(FFd_TfE*itf)*0.0*0.0/(gtfe+1.0)/(gtfe+1.0)/(gtfe+1.0));
#endif
#endif
FFd_QfE=((FFd_TfE*itf)/(gtfe+1.0));
#if defined(_DERIVATE)
FFT_fbS_Vtnode_GND=((1.0-fthc)*thcs_t_Vtnode_GND);
#endif
FFT_fbS=((1.0-fthc)*thcs_t);
#if defined(_DERIVATEFORDDX)
FFx_Vci_ei=(-FFa_Vci_ei);
#if defined(_DERIVATE)
  FFx_Vci_ei_Vci_ei=(+0.0-FFa_Vci_ei_Vci_ei);
  FFx_Vci_ei_Vtnode_GND=(+0.0-FFa_Vci_ei_Vtnode_GND);
  FFx_Vci_ei_Vbi_ei=(+0.0-FFa_Vci_ei_Vbi_ei);
  FFx_Vci_ei_Vbi_ci=(+0.0-FFa_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FFx_Vtnode_GND=(-FFa_Vtnode_GND);
#endif
FFx_Vbi_ei=(-FFa_Vbi_ei);
#if defined(_DERIVATE)
  FFx_Vbi_ei_Vci_ei=(+0.0-FFa_Vbi_ei_Vci_ei);
  FFx_Vbi_ei_Vtnode_GND=(+0.0-FFa_Vbi_ei_Vtnode_GND);
  FFx_Vbi_ei_Vbi_ei=(+0.0-FFa_Vbi_ei_Vbi_ei);
  FFx_Vbi_ei_Vbi_ci=(+0.0-FFa_Vbi_ei_Vbi_ci);
#endif
FFx_Vbi_ci=(-FFa_Vbi_ci);
#if defined(_DERIVATE)
  FFx_Vbi_ci_Vci_ei=(+0.0-FFa_Vbi_ci_Vci_ei);
  FFx_Vbi_ci_Vtnode_GND=(+0.0-FFa_Vbi_ci_Vtnode_GND);
  FFx_Vbi_ci_Vbi_ei=(+0.0-FFa_Vbi_ci_Vbi_ei);
  FFx_Vbi_ci_Vbi_ci=(+0.0-FFa_Vbi_ci_Vbi_ci);
#endif
#endif
FFx=(1.0-FFa);
{
double m00_sqrt(d00_sqrt0,((FFx*FFx)+ahc))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((FFx*FFx)+ahc))
#endif
#if defined(_DERIVATEFORDDX)
FFs_Vci_ei=((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  FFs_Vci_ei_Vci_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei)))*((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))+d10_sqrt0*(+(+FFx_Vci_ei_Vci_ei*FFx+FFx_Vci_ei*FFx_Vci_ei+FFx_Vci_ei*FFx_Vci_ei+FFx*FFx_Vci_ei_Vci_ei)+0.0));
  FFs_Vci_ei_Vtnode_GND=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND)))*((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))+d10_sqrt0*(+(+FFx_Vci_ei_Vtnode_GND*FFx+FFx_Vci_ei*FFx_Vtnode_GND+FFx_Vtnode_GND*FFx_Vci_ei+FFx*FFx_Vci_ei_Vtnode_GND)+0.0));
  FFs_Vci_ei_Vbi_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei)))*((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))+d10_sqrt0*(+(+FFx_Vci_ei_Vbi_ei*FFx+FFx_Vci_ei*FFx_Vbi_ei+FFx_Vbi_ei*FFx_Vci_ei+FFx*FFx_Vci_ei_Vbi_ei)+0.0));
  FFs_Vci_ei_Vbi_ci=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci)))*((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei))+d10_sqrt0*(+(+FFx_Vci_ei_Vbi_ci*FFx+FFx_Vci_ei*FFx_Vbi_ci+FFx_Vbi_ci*FFx_Vci_ei+FFx*FFx_Vci_ei_Vbi_ci)+0.0));
#endif
#if defined(_DERIVATE)
FFs_Vtnode_GND=((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND))*d10_sqrt0;
#endif
FFs_Vbi_ei=((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  FFs_Vbi_ei_Vci_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei)))*((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))+d10_sqrt0*(+(+FFx_Vbi_ei_Vci_ei*FFx+FFx_Vbi_ei*FFx_Vci_ei+FFx_Vci_ei*FFx_Vbi_ei+FFx*FFx_Vbi_ei_Vci_ei)+0.0));
  FFs_Vbi_ei_Vtnode_GND=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND)))*((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))+d10_sqrt0*(+(+FFx_Vbi_ei_Vtnode_GND*FFx+FFx_Vbi_ei*FFx_Vtnode_GND+FFx_Vtnode_GND*FFx_Vbi_ei+FFx*FFx_Vbi_ei_Vtnode_GND)+0.0));
  FFs_Vbi_ei_Vbi_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei)))*((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))+d10_sqrt0*(+(+FFx_Vbi_ei_Vbi_ei*FFx+FFx_Vbi_ei*FFx_Vbi_ei+FFx_Vbi_ei*FFx_Vbi_ei+FFx*FFx_Vbi_ei_Vbi_ei)+0.0));
  FFs_Vbi_ei_Vbi_ci=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci)))*((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei))+d10_sqrt0*(+(+FFx_Vbi_ei_Vbi_ci*FFx+FFx_Vbi_ei*FFx_Vbi_ci+FFx_Vbi_ci*FFx_Vbi_ei+FFx*FFx_Vbi_ei_Vbi_ci)+0.0));
#endif
FFs_Vbi_ci=((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))*d10_sqrt0;
#if defined(_DERIVATE)
  FFs_Vbi_ci_Vci_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vci_ei*FFx)+(FFx*FFx_Vci_ei)))*((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))+d10_sqrt0*(+(+FFx_Vbi_ci_Vci_ei*FFx+FFx_Vbi_ci*FFx_Vci_ei+FFx_Vci_ei*FFx_Vbi_ci+FFx*FFx_Vbi_ci_Vci_ei)+0.0));
  FFs_Vbi_ci_Vtnode_GND=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vtnode_GND*FFx)+(FFx*FFx_Vtnode_GND)))*((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))+d10_sqrt0*(+(+FFx_Vbi_ci_Vtnode_GND*FFx+FFx_Vbi_ci*FFx_Vtnode_GND+FFx_Vtnode_GND*FFx_Vbi_ci+FFx*FFx_Vbi_ci_Vtnode_GND)+0.0));
  FFs_Vbi_ci_Vbi_ei=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ei*FFx)+(FFx*FFx_Vbi_ei)))*((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))+d10_sqrt0*(+(+FFx_Vbi_ci_Vbi_ei*FFx+FFx_Vbi_ci*FFx_Vbi_ei+FFx_Vbi_ei*FFx_Vbi_ci+FFx*FFx_Vbi_ci_Vbi_ei)+0.0));
  FFs_Vbi_ci_Vbi_ci=(m20_sqrt(((FFx*FFx)+ahc))*(((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci)))*((FFx_Vbi_ci*FFx)+(FFx*FFx_Vbi_ci))+d10_sqrt0*(+(+FFx_Vbi_ci_Vbi_ci*FFx+FFx_Vbi_ci*FFx_Vbi_ci+FFx_Vbi_ci*FFx_Vbi_ci+FFx*FFx_Vbi_ci_Vbi_ci)+0.0));
#endif
#endif
FFs=d00_sqrt0;
}
{
double m00_sqrt(d00_sqrt0,(1.0+ahc))
#if defined(_DERIVATEFORDDX)
FFw_Vci_ei=((FFx_Vci_ei+FFs_Vci_ei)/(1.0+d00_sqrt0));
#if defined(_DERIVATE)
  FFw_Vci_ei_Vci_ei=((+FFx_Vci_ei_Vci_ei+FFs_Vci_ei_Vci_ei)/(1.0+d00_sqrt0)-((FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vci_ei_Vtnode_GND=((+FFx_Vci_ei_Vtnode_GND+FFs_Vci_ei_Vtnode_GND)/(1.0+d00_sqrt0)-((FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx_Vtnode_GND+FFs_Vtnode_GND)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vci_ei_Vbi_ei=((+FFx_Vci_ei_Vbi_ei+FFs_Vci_ei_Vbi_ei)/(1.0+d00_sqrt0)-((FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vci_ei_Vbi_ci=((+FFx_Vci_ei_Vbi_ci+FFs_Vci_ei_Vbi_ci)/(1.0+d00_sqrt0)-((FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
#endif
#if defined(_DERIVATE)
FFw_Vtnode_GND=((FFx_Vtnode_GND+FFs_Vtnode_GND)/(1.0+d00_sqrt0));
#endif
FFw_Vbi_ei=((FFx_Vbi_ei+FFs_Vbi_ei)/(1.0+d00_sqrt0));
#if defined(_DERIVATE)
  FFw_Vbi_ei_Vci_ei=((+FFx_Vbi_ei_Vci_ei+FFs_Vbi_ei_Vci_ei)/(1.0+d00_sqrt0)-((FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ei_Vtnode_GND=((+FFx_Vbi_ei_Vtnode_GND+FFs_Vbi_ei_Vtnode_GND)/(1.0+d00_sqrt0)-((FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx_Vtnode_GND+FFs_Vtnode_GND)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ei_Vbi_ei=((+FFx_Vbi_ei_Vbi_ei+FFs_Vbi_ei_Vbi_ei)/(1.0+d00_sqrt0)-((FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ei_Vbi_ci=((+FFx_Vbi_ei_Vbi_ci+FFs_Vbi_ei_Vbi_ci)/(1.0+d00_sqrt0)-((FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
#endif
FFw_Vbi_ci=((FFx_Vbi_ci+FFs_Vbi_ci)/(1.0+d00_sqrt0));
#if defined(_DERIVATE)
  FFw_Vbi_ci_Vci_ei=((+FFx_Vbi_ci_Vci_ei+FFs_Vbi_ci_Vci_ei)/(1.0+d00_sqrt0)-((FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx_Vci_ei+FFs_Vci_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ci_Vtnode_GND=((+FFx_Vbi_ci_Vtnode_GND+FFs_Vbi_ci_Vtnode_GND)/(1.0+d00_sqrt0)-((FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx_Vtnode_GND+FFs_Vtnode_GND)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ci_Vbi_ei=((+FFx_Vbi_ci_Vbi_ei+FFs_Vbi_ci_Vbi_ei)/(1.0+d00_sqrt0)-((FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx_Vbi_ei+FFs_Vbi_ei)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
  FFw_Vbi_ci_Vbi_ci=((+FFx_Vbi_ci_Vbi_ci+FFs_Vbi_ci_Vbi_ci)/(1.0+d00_sqrt0)-((FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx_Vbi_ci+FFs_Vbi_ci)*0.0+(FFx+FFs)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FFx+FFs)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0));
#endif
#endif
FFw=((FFx+FFs)/(1.0+d00_sqrt0));
}
#if defined(_DERIVATEFORDDX)
FFw_2_Vci_ei=((FFw_Vci_ei*FFw)+(FFw*FFw_Vci_ei));
#if defined(_DERIVATE)
  FFw_2_Vci_ei_Vci_ei=(+FFw_Vci_ei_Vci_ei*FFw+FFw_Vci_ei*FFw_Vci_ei+FFw_Vci_ei*FFw_Vci_ei+FFw*FFw_Vci_ei_Vci_ei);
  FFw_2_Vci_ei_Vtnode_GND=(+FFw_Vci_ei_Vtnode_GND*FFw+FFw_Vci_ei*FFw_Vtnode_GND+FFw_Vtnode_GND*FFw_Vci_ei+FFw*FFw_Vci_ei_Vtnode_GND);
  FFw_2_Vci_ei_Vbi_ei=(+FFw_Vci_ei_Vbi_ei*FFw+FFw_Vci_ei*FFw_Vbi_ei+FFw_Vbi_ei*FFw_Vci_ei+FFw*FFw_Vci_ei_Vbi_ei);
  FFw_2_Vci_ei_Vbi_ci=(+FFw_Vci_ei_Vbi_ci*FFw+FFw_Vci_ei*FFw_Vbi_ci+FFw_Vbi_ci*FFw_Vci_ei+FFw*FFw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FFw_2_Vtnode_GND=((FFw_Vtnode_GND*FFw)+(FFw*FFw_Vtnode_GND));
#endif
FFw_2_Vbi_ei=((FFw_Vbi_ei*FFw)+(FFw*FFw_Vbi_ei));
#if defined(_DERIVATE)
  FFw_2_Vbi_ei_Vci_ei=(+FFw_Vbi_ei_Vci_ei*FFw+FFw_Vbi_ei*FFw_Vci_ei+FFw_Vci_ei*FFw_Vbi_ei+FFw*FFw_Vbi_ei_Vci_ei);
  FFw_2_Vbi_ei_Vtnode_GND=(+FFw_Vbi_ei_Vtnode_GND*FFw+FFw_Vbi_ei*FFw_Vtnode_GND+FFw_Vtnode_GND*FFw_Vbi_ei+FFw*FFw_Vbi_ei_Vtnode_GND);
  FFw_2_Vbi_ei_Vbi_ei=(+FFw_Vbi_ei_Vbi_ei*FFw+FFw_Vbi_ei*FFw_Vbi_ei+FFw_Vbi_ei*FFw_Vbi_ei+FFw*FFw_Vbi_ei_Vbi_ei);
  FFw_2_Vbi_ei_Vbi_ci=(+FFw_Vbi_ei_Vbi_ci*FFw+FFw_Vbi_ei*FFw_Vbi_ci+FFw_Vbi_ci*FFw_Vbi_ei+FFw*FFw_Vbi_ei_Vbi_ci);
#endif
FFw_2_Vbi_ci=((FFw_Vbi_ci*FFw)+(FFw*FFw_Vbi_ci));
#if defined(_DERIVATE)
  FFw_2_Vbi_ci_Vci_ei=(+FFw_Vbi_ci_Vci_ei*FFw+FFw_Vbi_ci*FFw_Vci_ei+FFw_Vci_ei*FFw_Vbi_ci+FFw*FFw_Vbi_ci_Vci_ei);
  FFw_2_Vbi_ci_Vtnode_GND=(+FFw_Vbi_ci_Vtnode_GND*FFw+FFw_Vbi_ci*FFw_Vtnode_GND+FFw_Vtnode_GND*FFw_Vbi_ci+FFw*FFw_Vbi_ci_Vtnode_GND);
  FFw_2_Vbi_ci_Vbi_ei=(+FFw_Vbi_ci_Vbi_ei*FFw+FFw_Vbi_ci*FFw_Vbi_ei+FFw_Vbi_ei*FFw_Vbi_ci+FFw*FFw_Vbi_ci_Vbi_ei);
  FFw_2_Vbi_ci_Vbi_ci=(+FFw_Vbi_ci_Vbi_ci*FFw+FFw_Vbi_ci*FFw_Vbi_ci+FFw_Vbi_ci*FFw_Vbi_ci+FFw*FFw_Vbi_ci_Vbi_ci);
#endif
#endif
FFw_2=(FFw*FFw);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFd_QfB_Vtnode_GND=((((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND))*FFw_2)+((FFT_fbS*itf)*FFw_2_Vtnode_GND));
#endif
FFd_QfB_Vbi_ei=(((FFT_fbS*itf_Vbi_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ei));
#if defined(_DERIVATE)
  FFd_QfB_Vbi_ei_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_fbS_Vtnode_GND*itf_Vbi_ei+FFT_fbS*itf_Vbi_ei_Vtnode_GND)*FFw_2+(FFT_fbS*itf_Vbi_ei)*FFw_2_Vtnode_GND+(((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND)))*FFw_2_Vbi_ei+(FFT_fbS*itf)*FFw_2_Vbi_ei_Vtnode_GND);
  FFd_QfB_Vbi_ei_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+FFT_fbS*itf_Vbi_ei_Vbi_ei)*FFw_2+(FFT_fbS*itf_Vbi_ei)*FFw_2_Vbi_ei+((FFT_fbS*itf_Vbi_ei))*FFw_2_Vbi_ei+(FFT_fbS*itf)*FFw_2_Vbi_ei_Vbi_ei);
  FFd_QfB_Vbi_ei_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+FFT_fbS*itf_Vbi_ei_Vbi_ci)*FFw_2+(FFT_fbS*itf_Vbi_ei)*FFw_2_Vbi_ci+((FFT_fbS*itf_Vbi_ci))*FFw_2_Vbi_ei+(FFT_fbS*itf)*FFw_2_Vbi_ei_Vbi_ci);
  FFd_QfB_Vbi_ei_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ei+FFT_fbS*itf_Vbi_ei_Vci_ei)*FFw_2+(FFT_fbS*itf_Vbi_ei)*FFw_2_Vci_ei+((FFT_fbS*itf_Vci_ei))*FFw_2_Vbi_ei+(FFT_fbS*itf)*FFw_2_Vbi_ei_Vci_ei);
#endif
FFd_QfB_Vbi_ci=(((FFT_fbS*itf_Vbi_ci)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vbi_ci));
#if defined(_DERIVATE)
  FFd_QfB_Vbi_ci_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_fbS_Vtnode_GND*itf_Vbi_ci+FFT_fbS*itf_Vbi_ci_Vtnode_GND)*FFw_2+(FFT_fbS*itf_Vbi_ci)*FFw_2_Vtnode_GND+(((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND)))*FFw_2_Vbi_ci+(FFT_fbS*itf)*FFw_2_Vbi_ci_Vtnode_GND);
  FFd_QfB_Vbi_ci_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+FFT_fbS*itf_Vbi_ci_Vbi_ei)*FFw_2+(FFT_fbS*itf_Vbi_ci)*FFw_2_Vbi_ei+((FFT_fbS*itf_Vbi_ei))*FFw_2_Vbi_ci+(FFT_fbS*itf)*FFw_2_Vbi_ci_Vbi_ei);
  FFd_QfB_Vbi_ci_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+FFT_fbS*itf_Vbi_ci_Vbi_ci)*FFw_2+(FFT_fbS*itf_Vbi_ci)*FFw_2_Vbi_ci+((FFT_fbS*itf_Vbi_ci))*FFw_2_Vbi_ci+(FFT_fbS*itf)*FFw_2_Vbi_ci_Vbi_ci);
  FFd_QfB_Vbi_ci_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ci+FFT_fbS*itf_Vbi_ci_Vci_ei)*FFw_2+(FFT_fbS*itf_Vbi_ci)*FFw_2_Vci_ei+((FFT_fbS*itf_Vci_ei))*FFw_2_Vbi_ci+(FFT_fbS*itf)*FFw_2_Vbi_ci_Vci_ei);
#endif
FFd_QfB_Vci_ei=(((FFT_fbS*itf_Vci_ei)*FFw_2)+((FFT_fbS*itf)*FFw_2_Vci_ei));
#if defined(_DERIVATE)
  FFd_QfB_Vci_ei_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_fbS_Vtnode_GND*itf_Vci_ei+FFT_fbS*itf_Vci_ei_Vtnode_GND)*FFw_2+(FFT_fbS*itf_Vci_ei)*FFw_2_Vtnode_GND+(((FFT_fbS_Vtnode_GND*itf)+(FFT_fbS*itf_Vtnode_GND)))*FFw_2_Vci_ei+(FFT_fbS*itf)*FFw_2_Vci_ei_Vtnode_GND);
  FFd_QfB_Vci_ei_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vci_ei+FFT_fbS*itf_Vci_ei_Vbi_ei)*FFw_2+(FFT_fbS*itf_Vci_ei)*FFw_2_Vbi_ei+((FFT_fbS*itf_Vbi_ei))*FFw_2_Vci_ei+(FFT_fbS*itf)*FFw_2_Vci_ei_Vbi_ei);
  FFd_QfB_Vci_ei_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vci_ei+FFT_fbS*itf_Vci_ei_Vbi_ci)*FFw_2+(FFT_fbS*itf_Vci_ei)*FFw_2_Vbi_ci+((FFT_fbS*itf_Vbi_ci))*FFw_2_Vci_ei+(FFT_fbS*itf)*FFw_2_Vci_ei_Vbi_ci);
  FFd_QfB_Vci_ei_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vci_ei+FFT_fbS*itf_Vci_ei_Vci_ei)*FFw_2+(FFT_fbS*itf_Vci_ei)*FFw_2_Vci_ei+((FFT_fbS*itf_Vci_ei))*FFw_2_Vci_ei+(FFT_fbS*itf)*FFw_2_Vci_ei_Vci_ei);
#endif
#endif
FFd_QfB=((FFT_fbS*itf)*FFw_2);
#if defined(_DERIVATE)
Q_bf_Vtnode_GND=FFd_QfB_Vtnode_GND;
Q_bf_Vbi_ei=FFd_QfB_Vbi_ei;
Q_bf_Vbi_ci=FFd_QfB_Vbi_ci;
Q_bf_Vci_ei=FFd_QfB_Vci_ei;
#endif
Q_bf=FFd_QfB;
#if defined(_DERIVATEFORDDX)
FFa_w_Vci_ei=((FFw_2_Vci_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)));
#if defined(_DERIVATE)
  FFa_w_Vci_ei_Vci_ei=(+FFw_2_Vci_ei_Vci_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vci_ei*((((2.0*FFa_Vci_ei))*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2_Vci_ei*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vci_ei+0.0*FFa_Vci_ei+2.0*FFa_Vci_ei_Vci_ei)/FFs-((2.0*FFa_Vci_ei)*FFs_Vci_ei+((2.0*FFa_Vci_ei))*FFs_Vci_ei+(2.0*FFa)*FFs_Vci_ei_Vci_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vci_ei*FFs_Vci_ei/FFs/FFs/FFs)));
  FFa_w_Vci_ei_Vtnode_GND=(+FFw_2_Vci_ei_Vtnode_GND*(1.0+((2.0*FFa)/FFs))+FFw_2_Vci_ei*((((2.0*FFa_Vtnode_GND))*FFs-(2.0*FFa)*FFs_Vtnode_GND)/FFs/FFs)+FFw_2_Vtnode_GND*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vtnode_GND+0.0*FFa_Vci_ei+2.0*FFa_Vci_ei_Vtnode_GND)/FFs-((2.0*FFa_Vci_ei)*FFs_Vtnode_GND+((2.0*FFa_Vtnode_GND))*FFs_Vci_ei+(2.0*FFa)*FFs_Vci_ei_Vtnode_GND)/FFs/FFs+2*(2.0*FFa)*FFs_Vci_ei*FFs_Vtnode_GND/FFs/FFs/FFs)));
  FFa_w_Vci_ei_Vbi_ei=(+FFw_2_Vci_ei_Vbi_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vci_ei*((((2.0*FFa_Vbi_ei))*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2_Vbi_ei*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ei+0.0*FFa_Vci_ei+2.0*FFa_Vci_ei_Vbi_ei)/FFs-((2.0*FFa_Vci_ei)*FFs_Vbi_ei+((2.0*FFa_Vbi_ei))*FFs_Vci_ei+(2.0*FFa)*FFs_Vci_ei_Vbi_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vci_ei*FFs_Vbi_ei/FFs/FFs/FFs)));
  FFa_w_Vci_ei_Vbi_ci=(+FFw_2_Vci_ei_Vbi_ci*(1.0+((2.0*FFa)/FFs))+FFw_2_Vci_ei*((((2.0*FFa_Vbi_ci))*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2_Vbi_ci*(((2.0*FFa_Vci_ei)*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ci+0.0*FFa_Vci_ei+2.0*FFa_Vci_ei_Vbi_ci)/FFs-((2.0*FFa_Vci_ei)*FFs_Vbi_ci+((2.0*FFa_Vbi_ci))*FFs_Vci_ei+(2.0*FFa)*FFs_Vci_ei_Vbi_ci)/FFs/FFs+2*(2.0*FFa)*FFs_Vci_ei*FFs_Vbi_ci/FFs/FFs/FFs)));
#endif
#if defined(_DERIVATE)
FFa_w_Vtnode_GND=((FFw_2_Vtnode_GND*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(((2.0*FFa_Vtnode_GND)*FFs-(2.0*FFa)*FFs_Vtnode_GND)/FFs/FFs)));
#endif
FFa_w_Vbi_ei=((FFw_2_Vbi_ei*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)));
#if defined(_DERIVATE)
  FFa_w_Vbi_ei_Vci_ei=(+FFw_2_Vbi_ei_Vci_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ei*((((2.0*FFa_Vci_ei))*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2_Vci_ei*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vci_ei+0.0*FFa_Vbi_ei+2.0*FFa_Vbi_ei_Vci_ei)/FFs-((2.0*FFa_Vbi_ei)*FFs_Vci_ei+((2.0*FFa_Vci_ei))*FFs_Vbi_ei+(2.0*FFa)*FFs_Vbi_ei_Vci_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ei*FFs_Vci_ei/FFs/FFs/FFs)));
  FFa_w_Vbi_ei_Vtnode_GND=(+FFw_2_Vbi_ei_Vtnode_GND*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ei*((((2.0*FFa_Vtnode_GND))*FFs-(2.0*FFa)*FFs_Vtnode_GND)/FFs/FFs)+FFw_2_Vtnode_GND*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vtnode_GND+0.0*FFa_Vbi_ei+2.0*FFa_Vbi_ei_Vtnode_GND)/FFs-((2.0*FFa_Vbi_ei)*FFs_Vtnode_GND+((2.0*FFa_Vtnode_GND))*FFs_Vbi_ei+(2.0*FFa)*FFs_Vbi_ei_Vtnode_GND)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ei*FFs_Vtnode_GND/FFs/FFs/FFs)));
  FFa_w_Vbi_ei_Vbi_ei=(+FFw_2_Vbi_ei_Vbi_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ei*((((2.0*FFa_Vbi_ei))*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2_Vbi_ei*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ei+0.0*FFa_Vbi_ei+2.0*FFa_Vbi_ei_Vbi_ei)/FFs-((2.0*FFa_Vbi_ei)*FFs_Vbi_ei+((2.0*FFa_Vbi_ei))*FFs_Vbi_ei+(2.0*FFa)*FFs_Vbi_ei_Vbi_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ei*FFs_Vbi_ei/FFs/FFs/FFs)));
  FFa_w_Vbi_ei_Vbi_ci=(+FFw_2_Vbi_ei_Vbi_ci*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ei*((((2.0*FFa_Vbi_ci))*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2_Vbi_ci*(((2.0*FFa_Vbi_ei)*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ci+0.0*FFa_Vbi_ei+2.0*FFa_Vbi_ei_Vbi_ci)/FFs-((2.0*FFa_Vbi_ei)*FFs_Vbi_ci+((2.0*FFa_Vbi_ci))*FFs_Vbi_ei+(2.0*FFa)*FFs_Vbi_ei_Vbi_ci)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ei*FFs_Vbi_ci/FFs/FFs/FFs)));
#endif
FFa_w_Vbi_ci=((FFw_2_Vbi_ci*(1.0+((2.0*FFa)/FFs)))+(FFw_2*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)));
#if defined(_DERIVATE)
  FFa_w_Vbi_ci_Vci_ei=(+FFw_2_Vbi_ci_Vci_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ci*((((2.0*FFa_Vci_ei))*FFs-(2.0*FFa)*FFs_Vci_ei)/FFs/FFs)+FFw_2_Vci_ei*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vci_ei+0.0*FFa_Vbi_ci+2.0*FFa_Vbi_ci_Vci_ei)/FFs-((2.0*FFa_Vbi_ci)*FFs_Vci_ei+((2.0*FFa_Vci_ei))*FFs_Vbi_ci+(2.0*FFa)*FFs_Vbi_ci_Vci_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ci*FFs_Vci_ei/FFs/FFs/FFs)));
  FFa_w_Vbi_ci_Vtnode_GND=(+FFw_2_Vbi_ci_Vtnode_GND*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ci*((((2.0*FFa_Vtnode_GND))*FFs-(2.0*FFa)*FFs_Vtnode_GND)/FFs/FFs)+FFw_2_Vtnode_GND*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vtnode_GND+0.0*FFa_Vbi_ci+2.0*FFa_Vbi_ci_Vtnode_GND)/FFs-((2.0*FFa_Vbi_ci)*FFs_Vtnode_GND+((2.0*FFa_Vtnode_GND))*FFs_Vbi_ci+(2.0*FFa)*FFs_Vbi_ci_Vtnode_GND)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ci*FFs_Vtnode_GND/FFs/FFs/FFs)));
  FFa_w_Vbi_ci_Vbi_ei=(+FFw_2_Vbi_ci_Vbi_ei*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ci*((((2.0*FFa_Vbi_ei))*FFs-(2.0*FFa)*FFs_Vbi_ei)/FFs/FFs)+FFw_2_Vbi_ei*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ei+0.0*FFa_Vbi_ci+2.0*FFa_Vbi_ci_Vbi_ei)/FFs-((2.0*FFa_Vbi_ci)*FFs_Vbi_ei+((2.0*FFa_Vbi_ei))*FFs_Vbi_ci+(2.0*FFa)*FFs_Vbi_ci_Vbi_ei)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ci*FFs_Vbi_ei/FFs/FFs/FFs)));
  FFa_w_Vbi_ci_Vbi_ci=(+FFw_2_Vbi_ci_Vbi_ci*(1.0+((2.0*FFa)/FFs))+FFw_2_Vbi_ci*((((2.0*FFa_Vbi_ci))*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2_Vbi_ci*(((2.0*FFa_Vbi_ci)*FFs-(2.0*FFa)*FFs_Vbi_ci)/FFs/FFs)+FFw_2*(+0.0+((+0.0*FFa+0.0*FFa_Vbi_ci+0.0*FFa_Vbi_ci+2.0*FFa_Vbi_ci_Vbi_ci)/FFs-((2.0*FFa_Vbi_ci)*FFs_Vbi_ci+((2.0*FFa_Vbi_ci))*FFs_Vbi_ci+(2.0*FFa)*FFs_Vbi_ci_Vbi_ci)/FFs/FFs+2*(2.0*FFa)*FFs_Vbi_ci*FFs_Vbi_ci/FFs/FFs/FFs)));
#endif
#endif
FFa_w=(FFw_2*(1.0+((2.0*FFa)/FFs)));
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFd_TfB_Vtnode_GND=((FFT_fbS_Vtnode_GND*FFa_w)+(FFT_fbS*FFa_w_Vtnode_GND));
#endif
FFd_TfB_Vci_ei=(FFT_fbS*FFa_w_Vci_ei);
#if defined(_DERIVATE)
  FFd_TfB_Vci_ei_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_fbS_Vtnode_GND*FFa_w_Vci_ei+FFT_fbS*FFa_w_Vci_ei_Vtnode_GND);
  FFd_TfB_Vci_ei_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vci_ei+FFT_fbS*FFa_w_Vci_ei_Vci_ei);
  FFd_TfB_Vci_ei_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vci_ei+FFT_fbS*FFa_w_Vci_ei_Vbi_ei);
  FFd_TfB_Vci_ei_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vci_ei+FFT_fbS*FFa_w_Vci_ei_Vbi_ci);
#endif
FFd_TfB_Vbi_ei=(FFT_fbS*FFa_w_Vbi_ei);
#if defined(_DERIVATE)
  FFd_TfB_Vbi_ei_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_fbS_Vtnode_GND*FFa_w_Vbi_ei+FFT_fbS*FFa_w_Vbi_ei_Vtnode_GND);
  FFd_TfB_Vbi_ei_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vbi_ei+FFT_fbS*FFa_w_Vbi_ei_Vci_ei);
  FFd_TfB_Vbi_ei_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vbi_ei+FFT_fbS*FFa_w_Vbi_ei_Vbi_ei);
  FFd_TfB_Vbi_ei_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vbi_ei+FFT_fbS*FFa_w_Vbi_ei_Vbi_ci);
#endif
FFd_TfB_Vbi_ci=(FFT_fbS*FFa_w_Vbi_ci);
#if defined(_DERIVATE)
  FFd_TfB_Vbi_ci_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_fbS_Vtnode_GND*FFa_w_Vbi_ci+FFT_fbS*FFa_w_Vbi_ci_Vtnode_GND);
  FFd_TfB_Vbi_ci_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vbi_ci+FFT_fbS*FFa_w_Vbi_ci_Vci_ei);
  FFd_TfB_Vbi_ci_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vbi_ci+FFT_fbS*FFa_w_Vbi_ci_Vbi_ei);
  FFd_TfB_Vbi_ci_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vbi_ci+FFT_fbS*FFa_w_Vbi_ci_Vbi_ci);
#endif
#endif
FFd_TfB=(FFT_fbS*FFa_w);
#if defined(_DERIVATE)
FFT_pcS_Vtnode_GND=(fthc*thcs_t_Vtnode_GND);
#endif
FFT_pcS=(fthc*thcs_t);
if
(((latb<=0.0)&&(latl<=0.0)))
{
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFQ_fC_Vtnode_GND=((((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND))*FFw_2)+((FFT_pcS*itf)*FFw_2_Vtnode_GND));
#endif
FFQ_fC_Vbi_ei=(((FFT_pcS*itf_Vbi_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ei));
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ei_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vtnode_GND)*FFw_2+(FFT_pcS*itf_Vbi_ei)*FFw_2_Vtnode_GND+(((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND)))*FFw_2_Vbi_ei+(FFT_pcS*itf)*FFw_2_Vbi_ei_Vtnode_GND);
  FFQ_fC_Vbi_ei_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vbi_ei)*FFw_2+(FFT_pcS*itf_Vbi_ei)*FFw_2_Vbi_ei+((FFT_pcS*itf_Vbi_ei))*FFw_2_Vbi_ei+(FFT_pcS*itf)*FFw_2_Vbi_ei_Vbi_ei);
  FFQ_fC_Vbi_ei_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vbi_ci)*FFw_2+(FFT_pcS*itf_Vbi_ei)*FFw_2_Vbi_ci+((FFT_pcS*itf_Vbi_ci))*FFw_2_Vbi_ei+(FFT_pcS*itf)*FFw_2_Vbi_ei_Vbi_ci);
  FFQ_fC_Vbi_ei_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vci_ei)*FFw_2+(FFT_pcS*itf_Vbi_ei)*FFw_2_Vci_ei+((FFT_pcS*itf_Vci_ei))*FFw_2_Vbi_ei+(FFT_pcS*itf)*FFw_2_Vbi_ei_Vci_ei);
#endif
FFQ_fC_Vbi_ci=(((FFT_pcS*itf_Vbi_ci)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vbi_ci));
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ci_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vtnode_GND)*FFw_2+(FFT_pcS*itf_Vbi_ci)*FFw_2_Vtnode_GND+(((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND)))*FFw_2_Vbi_ci+(FFT_pcS*itf)*FFw_2_Vbi_ci_Vtnode_GND);
  FFQ_fC_Vbi_ci_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vbi_ei)*FFw_2+(FFT_pcS*itf_Vbi_ci)*FFw_2_Vbi_ei+((FFT_pcS*itf_Vbi_ei))*FFw_2_Vbi_ci+(FFT_pcS*itf)*FFw_2_Vbi_ci_Vbi_ei);
  FFQ_fC_Vbi_ci_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vbi_ci)*FFw_2+(FFT_pcS*itf_Vbi_ci)*FFw_2_Vbi_ci+((FFT_pcS*itf_Vbi_ci))*FFw_2_Vbi_ci+(FFT_pcS*itf)*FFw_2_Vbi_ci_Vbi_ci);
  FFQ_fC_Vbi_ci_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vci_ei)*FFw_2+(FFT_pcS*itf_Vbi_ci)*FFw_2_Vci_ei+((FFT_pcS*itf_Vci_ei))*FFw_2_Vbi_ci+(FFT_pcS*itf)*FFw_2_Vbi_ci_Vci_ei);
#endif
FFQ_fC_Vci_ei=(((FFT_pcS*itf_Vci_ei)*FFw_2)+((FFT_pcS*itf)*FFw_2_Vci_ei));
#if defined(_DERIVATE)
  FFQ_fC_Vci_ei_Vtnode_GND=(+(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vtnode_GND)*FFw_2+(FFT_pcS*itf_Vci_ei)*FFw_2_Vtnode_GND+(((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND)))*FFw_2_Vci_ei+(FFT_pcS*itf)*FFw_2_Vci_ei_Vtnode_GND);
  FFQ_fC_Vci_ei_Vbi_ei=(+(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vbi_ei)*FFw_2+(FFT_pcS*itf_Vci_ei)*FFw_2_Vbi_ei+((FFT_pcS*itf_Vbi_ei))*FFw_2_Vci_ei+(FFT_pcS*itf)*FFw_2_Vci_ei_Vbi_ei);
  FFQ_fC_Vci_ei_Vbi_ci=(+(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vbi_ci)*FFw_2+(FFT_pcS*itf_Vci_ei)*FFw_2_Vbi_ci+((FFT_pcS*itf_Vbi_ci))*FFw_2_Vci_ei+(FFT_pcS*itf)*FFw_2_Vci_ei_Vbi_ci);
  FFQ_fC_Vci_ei_Vci_ei=(+(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vci_ei)*FFw_2+(FFT_pcS*itf_Vci_ei)*FFw_2_Vci_ei+((FFT_pcS*itf_Vci_ei))*FFw_2_Vci_ei+(FFT_pcS*itf)*FFw_2_Vci_ei_Vci_ei);
#endif
#endif
FFQ_fC=((FFT_pcS*itf)*FFw_2);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFT_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*FFa_w)+(FFT_pcS*FFa_w_Vtnode_GND));
#endif
FFT_fC_Vci_ei=(FFT_pcS*FFa_w_Vci_ei);
#if defined(_DERIVATE)
  FFT_fC_Vci_ei_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_pcS_Vtnode_GND*FFa_w_Vci_ei+FFT_pcS*FFa_w_Vci_ei_Vtnode_GND);
  FFT_fC_Vci_ei_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vci_ei+FFT_pcS*FFa_w_Vci_ei_Vci_ei);
  FFT_fC_Vci_ei_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vci_ei+FFT_pcS*FFa_w_Vci_ei_Vbi_ei);
  FFT_fC_Vci_ei_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vci_ei+FFT_pcS*FFa_w_Vci_ei_Vbi_ci);
#endif
FFT_fC_Vbi_ei=(FFT_pcS*FFa_w_Vbi_ei);
#if defined(_DERIVATE)
  FFT_fC_Vbi_ei_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_pcS_Vtnode_GND*FFa_w_Vbi_ei+FFT_pcS*FFa_w_Vbi_ei_Vtnode_GND);
  FFT_fC_Vbi_ei_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vbi_ei+FFT_pcS*FFa_w_Vbi_ei_Vci_ei);
  FFT_fC_Vbi_ei_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vbi_ei+FFT_pcS*FFa_w_Vbi_ei_Vbi_ei);
  FFT_fC_Vbi_ei_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vbi_ei+FFT_pcS*FFa_w_Vbi_ei_Vbi_ci);
#endif
FFT_fC_Vbi_ci=(FFT_pcS*FFa_w_Vbi_ci);
#if defined(_DERIVATE)
  FFT_fC_Vbi_ci_Vtnode_GND=(+0.0*FFa_w+0.0*FFa_w_Vtnode_GND+FFT_pcS_Vtnode_GND*FFa_w_Vbi_ci+FFT_pcS*FFa_w_Vbi_ci_Vtnode_GND);
  FFT_fC_Vbi_ci_Vci_ei=(+0.0*FFa_w+0.0*FFa_w_Vci_ei+0.0*FFa_w_Vbi_ci+FFT_pcS*FFa_w_Vbi_ci_Vci_ei);
  FFT_fC_Vbi_ci_Vbi_ei=(+0.0*FFa_w+0.0*FFa_w_Vbi_ei+0.0*FFa_w_Vbi_ci+FFT_pcS*FFa_w_Vbi_ci_Vbi_ei);
  FFT_fC_Vbi_ci_Vbi_ci=(+0.0*FFa_w+0.0*FFa_w_Vbi_ci+0.0*FFa_w_Vbi_ci+FFT_pcS*FFa_w_Vbi_ci_Vbi_ci);
#endif
#endif
FFT_fC=(FFT_pcS*FFa_w);
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFQ_cT_Vtnode_GND=FFQ_fC_Vtnode_GND;
#endif
FFQ_cT_Vbi_ei=FFQ_fC_Vbi_ei;
#if defined(_DERIVATE)
  FFQ_cT_Vbi_ei_Vtnode_GND=FFQ_fC_Vbi_ei_Vtnode_GND;
  FFQ_cT_Vbi_ei_Vbi_ei=FFQ_fC_Vbi_ei_Vbi_ei;
  FFQ_cT_Vbi_ei_Vbi_ci=FFQ_fC_Vbi_ei_Vbi_ci;
  FFQ_cT_Vbi_ei_Vci_ei=FFQ_fC_Vbi_ei_Vci_ei;
#endif
FFQ_cT_Vbi_ci=FFQ_fC_Vbi_ci;
#if defined(_DERIVATE)
  FFQ_cT_Vbi_ci_Vtnode_GND=FFQ_fC_Vbi_ci_Vtnode_GND;
  FFQ_cT_Vbi_ci_Vbi_ei=FFQ_fC_Vbi_ci_Vbi_ei;
  FFQ_cT_Vbi_ci_Vbi_ci=FFQ_fC_Vbi_ci_Vbi_ci;
  FFQ_cT_Vbi_ci_Vci_ei=FFQ_fC_Vbi_ci_Vci_ei;
#endif
FFQ_cT_Vci_ei=FFQ_fC_Vci_ei;
#if defined(_DERIVATE)
  FFQ_cT_Vci_ei_Vtnode_GND=FFQ_fC_Vci_ei_Vtnode_GND;
  FFQ_cT_Vci_ei_Vbi_ei=FFQ_fC_Vci_ei_Vbi_ei;
  FFQ_cT_Vci_ei_Vbi_ci=FFQ_fC_Vci_ei_Vbi_ci;
  FFQ_cT_Vci_ei_Vci_ei=FFQ_fC_Vci_ei_Vci_ei;
#endif
#endif
FFQ_cT=FFQ_fC;
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFT_cT_Vtnode_GND=FFT_fC_Vtnode_GND;
#endif
FFT_cT_Vci_ei=FFT_fC_Vci_ei;
#if defined(_DERIVATE)
  FFT_cT_Vci_ei_Vtnode_GND=FFT_fC_Vci_ei_Vtnode_GND;
  FFT_cT_Vci_ei_Vci_ei=FFT_fC_Vci_ei_Vci_ei;
  FFT_cT_Vci_ei_Vbi_ei=FFT_fC_Vci_ei_Vbi_ei;
  FFT_cT_Vci_ei_Vbi_ci=FFT_fC_Vci_ei_Vbi_ci;
#endif
FFT_cT_Vbi_ei=FFT_fC_Vbi_ei;
#if defined(_DERIVATE)
  FFT_cT_Vbi_ei_Vtnode_GND=FFT_fC_Vbi_ei_Vtnode_GND;
  FFT_cT_Vbi_ei_Vci_ei=FFT_fC_Vbi_ei_Vci_ei;
  FFT_cT_Vbi_ei_Vbi_ei=FFT_fC_Vbi_ei_Vbi_ei;
  FFT_cT_Vbi_ei_Vbi_ci=FFT_fC_Vbi_ei_Vbi_ci;
#endif
FFT_cT_Vbi_ci=FFT_fC_Vbi_ci;
#if defined(_DERIVATE)
  FFT_cT_Vbi_ci_Vtnode_GND=FFT_fC_Vbi_ci_Vtnode_GND;
  FFT_cT_Vbi_ci_Vci_ei=FFT_fC_Vbi_ci_Vci_ei;
  FFT_cT_Vbi_ci_Vbi_ei=FFT_fC_Vbi_ci_Vbi_ei;
  FFT_cT_Vbi_ci_Vbi_ci=FFT_fC_Vbi_ci_Vbi_ci;
#endif
#endif
FFT_cT=FFT_fC;
}
else
{
#if defined(_DERIVATEFORDDX)
#if defined(_DERIVATE)
FFQ_fC_Vtnode_GND=((FFT_pcS_Vtnode_GND*itf)+(FFT_pcS*itf_Vtnode_GND));
#endif
FFQ_fC_Vbi_ei=(FFT_pcS*itf_Vbi_ei);
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ei_Vtnode_GND=(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vtnode_GND);
  FFQ_fC_Vbi_ei_Vbi_ei=(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vbi_ei);
  FFQ_fC_Vbi_ei_Vbi_ci=(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vbi_ci);
  FFQ_fC_Vbi_ei_Vci_ei=(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ei+FFT_pcS*itf_Vbi_ei_Vci_ei);
#endif
FFQ_fC_Vbi_ci=(FFT_pcS*itf_Vbi_ci);
#if defined(_DERIVATE)
  FFQ_fC_Vbi_ci_Vtnode_GND=(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vtnode_GND);
  FFQ_fC_Vbi_ci_Vbi_ei=(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vbi_ei);
  FFQ_fC_Vbi_ci_Vbi_ci=(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vbi_ci);
  FFQ_fC_Vbi_ci_Vci_ei=(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vbi_ci+FFT_pcS*itf_Vbi_ci_Vci_ei);
#endif
FFQ_fC_Vci_ei=(FFT_pcS*itf_Vci_ei);
#if defined(_DERIVATE)
  FFQ_fC_Vci_ei_Vtnode_GND=(+0.0*itf+0.0*itf_Vtnode_GND+FFT_pcS_Vtnode_GND*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vtnode_GND);
  FFQ_fC_Vci_ei_Vbi_ei=(+0.0*itf+0.0*itf_Vbi_ei+0.0*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vbi_ei);
  FFQ_fC_Vci_ei_Vbi_ci=(+0.0*itf+0.0*itf_Vbi_ci+0.0*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vbi_ci);
  FFQ_fC_Vci_ei_Vci_ei=(+0.0*itf+0.0*itf_Vci_ei+0.0*itf_Vci_ei+FFT_pcS*itf_Vci_ei_Vci_ei);
#endif
#endif
FFQ_fC=(FFT_pcS*itf);
#if defined(_DERIVATEFORDDX)
FCa_Vci_ei=(-((ick_Vci_ei*itf-ick*itf_Vci_ei)/itf/itf));
#if defined(_DERIVATE)
  FCa_Vci_ei_Vci_ei=(+0.0-(ick_Vci_ei_Vci_ei/itf-(ick_Vci_ei*itf_Vci_ei+ick_Vci_ei*itf_Vci_ei+ick*itf_Vci_ei_Vci_ei)/itf/itf+2*ick*itf_Vci_ei*itf_Vci_ei/itf/itf/itf));
  FCa_Vci_ei_Vtnode_GND=(+0.0-(ick_Vci_ei_Vtnode_GND/itf-(ick_Vci_ei*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vci_ei+ick*itf_Vci_ei_Vtnode_GND)/itf/itf+2*ick*itf_Vci_ei*itf_Vtnode_GND/itf/itf/itf));
  FCa_Vci_ei_Vbi_ei=(+0.0-(0.0/itf-(ick_Vci_ei*itf_Vbi_ei+0.0*itf_Vci_ei+ick*itf_Vci_ei_Vbi_ei)/itf/itf+2*ick*itf_Vci_ei*itf_Vbi_ei/itf/itf/itf));
  FCa_Vci_ei_Vbi_ci=(+0.0-(0.0/itf-(ick_Vci_ei*itf_Vbi_ci+0.0*itf_Vci_ei+ick*itf_Vci_ei_Vbi_ci)/itf/itf+2*ick*itf_Vci_ei*itf_Vbi_ci/itf/itf/itf));
#endif
#if defined(_DERIVATE)
FCa_Vtnode_GND=(-((ick_Vtnode_GND*itf-ick*itf_Vtnode_GND)/itf/itf));
#endif
FCa_Vbi_ei=(-(-ick*itf_Vbi_ei/itf/itf));
#if defined(_DERIVATE)
  FCa_Vbi_ei_Vci_ei=(+0.0-(0.0/itf-(0.0*itf_Vci_ei+ick_Vci_ei*itf_Vbi_ei+ick*itf_Vbi_ei_Vci_ei)/itf/itf+2*ick*itf_Vbi_ei*itf_Vci_ei/itf/itf/itf));
  FCa_Vbi_ei_Vtnode_GND=(+0.0-(0.0/itf-(0.0*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vbi_ei+ick*itf_Vbi_ei_Vtnode_GND)/itf/itf+2*ick*itf_Vbi_ei*itf_Vtnode_GND/itf/itf/itf));
  FCa_Vbi_ei_Vbi_ei=(+0.0-(0.0/itf-(0.0*itf_Vbi_ei+0.0*itf_Vbi_ei+ick*itf_Vbi_ei_Vbi_ei)/itf/itf+2*ick*itf_Vbi_ei*itf_Vbi_ei/itf/itf/itf));
  FCa_Vbi_ei_Vbi_ci=(+0.0-(0.0/itf-(0.0*itf_Vbi_ci+0.0*itf_Vbi_ei+ick*itf_Vbi_ei_Vbi_ci)/itf/itf+2*ick*itf_Vbi_ei*itf_Vbi_ci/itf/itf/itf));
#endif
FCa_Vbi_ci=(-(-ick*itf_Vbi_ci/itf/itf));
#if defined(_DERIVATE)
  FCa_Vbi_ci_Vci_ei=(+0.0-(0.0/itf-(0.0*itf_Vci_ei+ick_Vci_ei*itf_Vbi_ci+ick*itf_Vbi_ci_Vci_ei)/itf/itf+2*ick*itf_Vbi_ci*itf_Vci_ei/itf/itf/itf));
  FCa_Vbi_ci_Vtnode_GND=(+0.0-(0.0/itf-(0.0*itf_Vtnode_GND+ick_Vtnode_GND*itf_Vbi_ci+ick*itf_Vbi_ci_Vtnode_GND)/itf/itf+2*ick*itf_Vbi_ci*itf_Vtnode_GND/itf/itf/itf));
  FCa_Vbi_ci_Vbi_ei=(+0.0-(0.0/itf-(0.0*itf_Vbi_ei+0.0*itf_Vbi_ci+ick*itf_Vbi_ci_Vbi_ei)/itf/itf+2*ick*itf_Vbi_ci*itf_Vbi_ei/itf/itf/itf));
  FCa_Vbi_ci_Vbi_ci=(+0.0-(0.0/itf-(0.0*itf_Vbi_ci+0.0*itf_Vbi_ci+ick*itf_Vbi_ci_Vbi_ci)/itf/itf+2*ick*itf_Vbi_ci*itf_Vbi_ci/itf/itf/itf));
#endif
#endif
FCa=(1.0-(ick/itf));
{
double m00_sqrt(d00_sqrt0,((FCa*FCa)+ahc))
#if defined(_DERIVATEFORDDX)
double m10_sqrt(d10_sqrt0,d00_sqrt0,((FCa*FCa)+ahc))
#endif
#if defined(_DERIVATEFORDDX)
FCrt_Vci_ei=((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  FCrt_Vci_ei_Vci_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei)))*((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))+d10_sqrt0*(+(+FCa_Vci_ei_Vci_ei*FCa+FCa_Vci_ei*FCa_Vci_ei+FCa_Vci_ei*FCa_Vci_ei+FCa*FCa_Vci_ei_Vci_ei)+0.0));
  FCrt_Vci_ei_Vtnode_GND=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND)))*((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))+d10_sqrt0*(+(+FCa_Vci_ei_Vtnode_GND*FCa+FCa_Vci_ei*FCa_Vtnode_GND+FCa_Vtnode_GND*FCa_Vci_ei+FCa*FCa_Vci_ei_Vtnode_GND)+0.0));
  FCrt_Vci_ei_Vbi_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei)))*((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))+d10_sqrt0*(+(+FCa_Vci_ei_Vbi_ei*FCa+FCa_Vci_ei*FCa_Vbi_ei+FCa_Vbi_ei*FCa_Vci_ei+FCa*FCa_Vci_ei_Vbi_ei)+0.0));
  FCrt_Vci_ei_Vbi_ci=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci)))*((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei))+d10_sqrt0*(+(+FCa_Vci_ei_Vbi_ci*FCa+FCa_Vci_ei*FCa_Vbi_ci+FCa_Vbi_ci*FCa_Vci_ei+FCa*FCa_Vci_ei_Vbi_ci)+0.0));
#endif
#if defined(_DERIVATE)
FCrt_Vtnode_GND=((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND))*d10_sqrt0;
#endif
FCrt_Vbi_ei=((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))*d10_sqrt0;
#if defined(_DERIVATE)
  FCrt_Vbi_ei_Vci_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei)))*((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))+d10_sqrt0*(+(+FCa_Vbi_ei_Vci_ei*FCa+FCa_Vbi_ei*FCa_Vci_ei+FCa_Vci_ei*FCa_Vbi_ei+FCa*FCa_Vbi_ei_Vci_ei)+0.0));
  FCrt_Vbi_ei_Vtnode_GND=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND)))*((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))+d10_sqrt0*(+(+FCa_Vbi_ei_Vtnode_GND*FCa+FCa_Vbi_ei*FCa_Vtnode_GND+FCa_Vtnode_GND*FCa_Vbi_ei+FCa*FCa_Vbi_ei_Vtnode_GND)+0.0));
  FCrt_Vbi_ei_Vbi_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei)))*((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))+d10_sqrt0*(+(+FCa_Vbi_ei_Vbi_ei*FCa+FCa_Vbi_ei*FCa_Vbi_ei+FCa_Vbi_ei*FCa_Vbi_ei+FCa*FCa_Vbi_ei_Vbi_ei)+0.0));
  FCrt_Vbi_ei_Vbi_ci=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci)))*((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei))+d10_sqrt0*(+(+FCa_Vbi_ei_Vbi_ci*FCa+FCa_Vbi_ei*FCa_Vbi_ci+FCa_Vbi_ci*FCa_Vbi_ei+FCa*FCa_Vbi_ei_Vbi_ci)+0.0));
#endif
FCrt_Vbi_ci=((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))*d10_sqrt0;
#if defined(_DERIVATE)
  FCrt_Vbi_ci_Vci_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vci_ei*FCa)+(FCa*FCa_Vci_ei)))*((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))+d10_sqrt0*(+(+FCa_Vbi_ci_Vci_ei*FCa+FCa_Vbi_ci*FCa_Vci_ei+FCa_Vci_ei*FCa_Vbi_ci+FCa*FCa_Vbi_ci_Vci_ei)+0.0));
  FCrt_Vbi_ci_Vtnode_GND=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vtnode_GND*FCa)+(FCa*FCa_Vtnode_GND)))*((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))+d10_sqrt0*(+(+FCa_Vbi_ci_Vtnode_GND*FCa+FCa_Vbi_ci*FCa_Vtnode_GND+FCa_Vtnode_GND*FCa_Vbi_ci+FCa*FCa_Vbi_ci_Vtnode_GND)+0.0));
  FCrt_Vbi_ci_Vbi_ei=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ei*FCa)+(FCa*FCa_Vbi_ei)))*((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))+d10_sqrt0*(+(+FCa_Vbi_ci_Vbi_ei*FCa+FCa_Vbi_ci*FCa_Vbi_ei+FCa_Vbi_ei*FCa_Vbi_ci+FCa*FCa_Vbi_ci_Vbi_ei)+0.0));
  FCrt_Vbi_ci_Vbi_ci=(m20_sqrt(((FCa*FCa)+ahc))*(((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci)))*((FCa_Vbi_ci*FCa)+(FCa*FCa_Vbi_ci))+d10_sqrt0*(+(+FCa_Vbi_ci_Vbi_ci*FCa+FCa_Vbi_ci*FCa_Vbi_ci+FCa_Vbi_ci*FCa_Vbi_ci+FCa*FCa_Vbi_ci_Vbi_ci)+0.0));
#endif
#endif
FCrt=d00_sqrt0;
}
{
double m00_sqrt(d00_sqrt0,(1.0+ahc))
#if defined(_DERIVATEFORDDX)
FCa_ck_Vci_ei=(-((FCa_Vci_ei+FCrt_Vci_ei)/(1.0+d00_sqrt0)));
#if defined(_DERIVATE)
  FCa_ck_Vci_ei_Vci_ei=(+0.0-((+FCa_Vci_ei_Vci_ei+FCrt_Vci_ei_Vci_ei)/(1.0+d00_sqrt0)-((FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vci_ei_Vtnode_GND=(+0.0-((+FCa_Vci_ei_Vtnode_GND+FCrt_Vci_ei_Vtnode_GND)/(1.0+d00_sqrt0)-((FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa_Vtnode_GND+FCrt_Vtnode_GND)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vci_ei_Vbi_ei=(+0.0-((+FCa_Vci_ei_Vbi_ei+FCrt_Vci_ei_Vbi_ei)/(1.0+d00_sqrt0)-((FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vci_ei_Vbi_ci=(+0.0-((+FCa_Vci_ei_Vbi_ci+FCrt_Vci_ei_Vbi_ci)/(1.0+d00_sqrt0)-((FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
#endif
#if defined(_DERIVATE)
FCa_ck_Vtnode_GND=(-((FCa_Vtnode_GND+FCrt_Vtnode_GND)/(1.0+d00_sqrt0)));
#endif
FCa_ck_Vbi_ei=(-((FCa_Vbi_ei+FCrt_Vbi_ei)/(1.0+d00_sqrt0)));
#if defined(_DERIVATE)
  FCa_ck_Vbi_ei_Vci_ei=(+0.0-((+FCa_Vbi_ei_Vci_ei+FCrt_Vbi_ei_Vci_ei)/(1.0+d00_sqrt0)-((FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ei_Vtnode_GND=(+0.0-((+FCa_Vbi_ei_Vtnode_GND+FCrt_Vbi_ei_Vtnode_GND)/(1.0+d00_sqrt0)-((FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa_Vtnode_GND+FCrt_Vtnode_GND)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ei_Vbi_ei=(+0.0-((+FCa_Vbi_ei_Vbi_ei+FCrt_Vbi_ei_Vbi_ei)/(1.0+d00_sqrt0)-((FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ei_Vbi_ci=(+0.0-((+FCa_Vbi_ei_Vbi_ci+FCrt_Vbi_ei_Vbi_ci)/(1.0+d00_sqrt0)-((FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
#endif
FCa_ck_Vbi_ci=(-((FCa_Vbi_ci+FCrt_Vbi_ci)/(1.0+d00_sqrt0)));
#if defined(_DERIVATE)
  FCa_ck_Vbi_ci_Vci_ei=(+0.0-((+FCa_Vbi_ci_Vci_ei+FCrt_Vbi_ci_Vci_ei)/(1.0+d00_sqrt0)-((FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa_Vci_ei+FCrt_Vci_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ci_Vtnode_GND=(+0.0-((+FCa_Vbi_ci_Vtnode_GND+FCrt_Vbi_ci_Vtnode_GND)/(1.0+d00_sqrt0)-((FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa_Vtnode_GND+FCrt_Vtnode_GND)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ci_Vbi_ei=(+0.0-((+FCa_Vbi_ci_Vbi_ei+FCrt_Vbi_ci_Vbi_ei)/(1.0+d00_sqrt0)-((FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa_Vbi_ei+FCrt_Vbi_ei)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
  FCa_ck_Vbi_ci_Vbi_ci=(+0.0-((+FCa_Vbi_ci_Vbi_ci+FCrt_Vbi_ci_Vbi_ci)/(1.0+d00_sqrt0)-((FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa_Vbi_ci+FCrt_Vbi_ci)*0.0+(FCa+FCrt)*(+0.0+0.0))/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)+2*(FCa+FCrt)*0.0*0.0/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)/(1.0+d00_sqrt0)));
#endif
#endif
FCa_ck=(1.0-((FCa+FCrt)/(1.0+d00_sqrt0)));
}
#if defined(_DERIVATEFORDDX)
FCdaick_ditf_Vci_ei=((((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/(FCrt*itf)/(FCrt*itf));
#if defined(_DERIVATE)
  FCdaick_ditf_Vci_ei_Vci_ei=((+(+FCa_ck_Vci_ei_Vci_ei-0.0)*(1-FCa)+FCa_ck_Vci_ei*(-FCa_Vci_ei)+FCa_ck_Vci_ei*(-FCa_Vci_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vci_ei_Vci_ei))/(FCrt*itf)-(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))+(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei))))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vci_ei_Vci_ei*itf+FCrt_Vci_ei*itf_Vci_ei+FCrt_Vci_ei*itf_Vci_ei+FCrt*itf_Vci_ei_Vci_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vci_ei_Vtnode_GND=((+(+FCa_ck_Vci_ei_Vtnode_GND-0.0)*(1-FCa)+FCa_ck_Vci_ei*(-FCa_Vtnode_GND)+FCa_ck_Vtnode_GND*(-FCa_Vci_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vci_ei_Vtnode_GND))/(FCrt*itf)-(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))+(((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND))))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vci_ei_Vtnode_GND*itf+FCrt_Vci_ei*itf_Vtnode_GND+FCrt_Vtnode_GND*itf_Vci_ei+FCrt*itf_Vci_ei_Vtnode_GND))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vci_ei_Vbi_ei=((+(+FCa_ck_Vci_ei_Vbi_ei-0.0)*(1-FCa)+FCa_ck_Vci_ei*(-FCa_Vbi_ei)+FCa_ck_Vbi_ei*(-FCa_Vci_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vci_ei_Vbi_ei))/(FCrt*itf)-(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))+(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei))))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vci_ei_Vbi_ei*itf+FCrt_Vci_ei*itf_Vbi_ei+FCrt_Vbi_ei*itf_Vci_ei+FCrt*itf_Vci_ei_Vbi_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vci_ei_Vbi_ci=((+(+FCa_ck_Vci_ei_Vbi_ci-0.0)*(1-FCa)+FCa_ck_Vci_ei*(-FCa_Vbi_ci)+FCa_ck_Vbi_ci*(-FCa_Vci_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vci_ei_Vbi_ci))/(FCrt*itf)-(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei)))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))+(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci))))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vci_ei_Vbi_ci*itf+FCrt_Vci_ei*itf_Vbi_ci+FCrt_Vbi_ci*itf_Vci_ei+FCrt*itf_Vci_ei_Vbi_ci))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
#endif
#if defined(_DERIVATE)
FCdaick_ditf_Vtnode_GND=((((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/(FCrt*itf)/(FCrt*itf));
#endif
FCdaick_ditf_Vbi_ei=((((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/(FCrt*itf)/(FCrt*itf));
#if defined(_DERIVATE)
  FCdaick_ditf_Vbi_ei_Vci_ei=((+(+FCa_ck_Vbi_ei_Vci_ei-0.0)*(1-FCa)+FCa_ck_Vbi_ei*(-FCa_Vci_ei)+FCa_ck_Vci_ei*(-FCa_Vbi_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ei_Vci_ei))/(FCrt*itf)-(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))+(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei))))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ei_Vci_ei*itf+FCrt_Vbi_ei*itf_Vci_ei+FCrt_Vci_ei*itf_Vbi_ei+FCrt*itf_Vbi_ei_Vci_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ei_Vtnode_GND=((+(+FCa_ck_Vbi_ei_Vtnode_GND-0.0)*(1-FCa)+FCa_ck_Vbi_ei*(-FCa_Vtnode_GND)+FCa_ck_Vtnode_GND*(-FCa_Vbi_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ei_Vtnode_GND))/(FCrt*itf)-(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))+(((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND))))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ei_Vtnode_GND*itf+FCrt_Vbi_ei*itf_Vtnode_GND+FCrt_Vtnode_GND*itf_Vbi_ei+FCrt*itf_Vbi_ei_Vtnode_GND))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ei_Vbi_ei=((+(+FCa_ck_Vbi_ei_Vbi_ei-0.0)*(1-FCa)+FCa_ck_Vbi_ei*(-FCa_Vbi_ei)+FCa_ck_Vbi_ei*(-FCa_Vbi_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ei_Vbi_ei))/(FCrt*itf)-(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))+(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei))))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ei_Vbi_ei*itf+FCrt_Vbi_ei*itf_Vbi_ei+FCrt_Vbi_ei*itf_Vbi_ei+FCrt*itf_Vbi_ei_Vbi_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ei_Vbi_ci=((+(+FCa_ck_Vbi_ei_Vbi_ci-0.0)*(1-FCa)+FCa_ck_Vbi_ei*(-FCa_Vbi_ci)+FCa_ck_Vbi_ci*(-FCa_Vbi_ei)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ei_Vbi_ci))/(FCrt*itf)-(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei)))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))+(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci))))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ei_Vbi_ci*itf+FCrt_Vbi_ei*itf_Vbi_ci+FCrt_Vbi_ci*itf_Vbi_ei+FCrt*itf_Vbi_ei_Vbi_ci))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
#endif
FCdaick_ditf_Vbi_ci=((((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(FCrt*itf)-((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/(FCrt*itf)/(FCrt*itf));
#if defined(_DERIVATE)
  FCdaick_ditf_Vbi_ci_Vci_ei=((+(+FCa_ck_Vbi_ci_Vci_ei-0.0)*(1-FCa)+FCa_ck_Vbi_ci*(-FCa_Vci_ei)+FCa_ck_Vci_ei*(-FCa_Vbi_ci)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ci_Vci_ei))/(FCrt*itf)-(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))+(((FCa_ck_Vci_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vci_ei))))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ci_Vci_ei*itf+FCrt_Vbi_ci*itf_Vci_ei+FCrt_Vci_ei*itf_Vbi_ci+FCrt*itf_Vbi_ci_Vci_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))*(((FCrt_Vci_ei*itf)+(FCrt*itf_Vci_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ci_Vtnode_GND=((+(+FCa_ck_Vbi_ci_Vtnode_GND-0.0)*(1-FCa)+FCa_ck_Vbi_ci*(-FCa_Vtnode_GND)+FCa_ck_Vtnode_GND*(-FCa_Vbi_ci)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ci_Vtnode_GND))/(FCrt*itf)-(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))+(((FCa_ck_Vtnode_GND*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vtnode_GND))))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ci_Vtnode_GND*itf+FCrt_Vbi_ci*itf_Vtnode_GND+FCrt_Vtnode_GND*itf_Vbi_ci+FCrt*itf_Vbi_ci_Vtnode_GND))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))*(((FCrt_Vtnode_GND*itf)+(FCrt*itf_Vtnode_GND)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ci_Vbi_ei=((+(+FCa_ck_Vbi_ci_Vbi_ei-0.0)*(1-FCa)+FCa_ck_Vbi_ci*(-FCa_Vbi_ei)+FCa_ck_Vbi_ei*(-FCa_Vbi_ci)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ci_Vbi_ei))/(FCrt*itf)-(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))+(((FCa_ck_Vbi_ei*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ei))))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ci_Vbi_ei*itf+FCrt_Vbi_ci*itf_Vbi_ei+FCrt_Vbi_ei*itf_Vbi_ci+FCrt*itf_Vbi_ci_Vbi_ei))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))*(((FCrt_Vbi_ei*itf)+(FCrt*itf_Vbi_ei)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
  FCdaick_ditf_Vbi_ci_Vbi_ci=((+(+FCa_ck_Vbi_ci_Vbi_ci-0.0)*(1-FCa)+FCa_ck_Vbi_ci*(-FCa_Vbi_ci)+FCa_ck_Vbi_ci*(-FCa_Vbi_ci)+(FCa_ck-1.0)*(+0.0-FCa_Vbi_ci_Vbi_ci))/(FCrt*itf)-(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci)))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))+(((FCa_ck_Vbi_ci*(1-FCa))+((FCa_ck-1.0)*(-FCa_Vbi_ci))))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))+((FCa_ck-1.0)*(1-FCa))*(+FCrt_Vbi_ci_Vbi_ci*itf+FCrt_Vbi_ci*itf_Vbi_ci+FCrt_Vbi_ci*itf_Vbi_ci+FCrt*itf_Vbi_ci_Vbi_ci))/(FCrt*itf)/(FCrt*itf)+2*((FCa_ck-1.0)*(1-FCa))*((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci))*(((FCrt_Vbi_ci*itf)+(FCrt*itf_Vbi_ci)))/(FCrt*itf)/(FCrt*itf)/(FCrt*itf));
#endif
#endif
FCdaick_ditf=(((FCa_ck-1.0)*(1-FCa))/(FCrt*itf));
if
((latb>latl))
{
#if defined(_DERIVATEFORDDX)
FCz_Vci_ei=0.0;
#if defined(_DERIVATE)
  FCz_Vci_ei_Vci_ei=0.0;
  FCz_Vci_ei_Vtnode_GND=0.0;
  FCz_Vci_ei_Vbi_ei=0.0;
  FCz_Vci_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
FCz_Vtnode_GND=0.0;
#endif
FCz_Vbi_ei=0.0;
#if defined(_DERIVATE)
  FCz_Vbi_ei_Vci_ei=0.0;
  FCz_Vbi_ei_Vtnode_GND=0.0;
  FCz_Vbi_ei_Vbi_ei=0.0;
  FCz_Vbi_ei_Vbi_ci=0.0;
#endif
FCz_Vbi_ci=0.0;
#if defined(_DERIVATE)
  FCz_Vbi_ci_Vci_ei=0.0;
  FCz_Vbi_ci_Vtnode_GND=0.0;
  FCz_Vbi_ci_Vbi_ei=0.0;
  FCz_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
FCz=(latb-latl);
FCxl=(1.0+latl);
FCxb=(1.0+latb);
if
((latb>0.01))
{
{
double m00_logE(d00_logE0,(FCxb/FCxl))
FCln=d00_logE0;
}
{
double m00_exp(d00_exp0,((FCa_ck-1.0)*FCln))
#if defined(_DERIVATEFORDDX)
#define d10_exp0 d00_exp0
#endif
#if defined(_DERIVATEFORDDX)
FCa1_Vci_ei=FCa_ck_Vci_ei*FCln*d10_exp0;
#if defined(_DERIVATE)
  FCa1_Vci_ei_Vci_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vci_ei*FCln)*FCa_ck_Vci_ei*FCln+d10_exp0*(+(+FCa_ck_Vci_ei_Vci_ei-0.0)*FCln+FCa_ck_Vci_ei*0.0+FCa_ck_Vci_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vci_ei_Vtnode_GND=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vtnode_GND*FCln)*FCa_ck_Vci_ei*FCln+d10_exp0*(+(+FCa_ck_Vci_ei_Vtnode_GND-0.0)*FCln+FCa_ck_Vci_ei*0.0+FCa_ck_Vtnode_GND*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vci_ei_Vbi_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ei*FCln)*FCa_ck_Vci_ei*FCln+d10_exp0*(+(+FCa_ck_Vci_ei_Vbi_ei-0.0)*FCln+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vci_ei_Vbi_ci=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ci*FCln)*FCa_ck_Vci_ei*FCln+d10_exp0*(+(+FCa_ck_Vci_ei_Vbi_ci-0.0)*FCln+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ci*0.0+(FCa_ck-1.0)*0.0));
#endif
#if defined(_DERIVATE)
FCa1_Vtnode_GND=FCa_ck_Vtnode_GND*FCln*d10_exp0;
#endif
FCa1_Vbi_ei=FCa_ck_Vbi_ei*FCln*d10_exp0;
#if defined(_DERIVATE)
  FCa1_Vbi_ei_Vci_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vci_ei*FCln)*FCa_ck_Vbi_ei*FCln+d10_exp0*(+(+FCa_ck_Vbi_ei_Vci_ei-0.0)*FCln+FCa_ck_Vbi_ei*0.0+FCa_ck_Vci_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ei_Vtnode_GND=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vtnode_GND*FCln)*FCa_ck_Vbi_ei*FCln+d10_exp0*(+(+FCa_ck_Vbi_ei_Vtnode_GND-0.0)*FCln+FCa_ck_Vbi_ei*0.0+FCa_ck_Vtnode_GND*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ei_Vbi_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ei*FCln)*FCa_ck_Vbi_ei*FCln+d10_exp0*(+(+FCa_ck_Vbi_ei_Vbi_ei-0.0)*FCln+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ei_Vbi_ci=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ci*FCln)*FCa_ck_Vbi_ei*FCln+d10_exp0*(+(+FCa_ck_Vbi_ei_Vbi_ci-0.0)*FCln+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ci*0.0+(FCa_ck-1.0)*0.0));
#endif
FCa1_Vbi_ci=FCa_ck_Vbi_ci*FCln*d10_exp0;
#if defined(_DERIVATE)
  FCa1_Vbi_ci_Vci_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vci_ei*FCln)*FCa_ck_Vbi_ci*FCln+d10_exp0*(+(+FCa_ck_Vbi_ci_Vci_ei-0.0)*FCln+FCa_ck_Vbi_ci*0.0+FCa_ck_Vci_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ci_Vtnode_GND=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vtnode_GND*FCln)*FCa_ck_Vbi_ci*FCln+d10_exp0*(+(+FCa_ck_Vbi_ci_Vtnode_GND-0.0)*FCln+FCa_ck_Vbi_ci*0.0+FCa_ck_Vtnode_GND*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ci_Vbi_ei=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ei*FCln)*FCa_ck_Vbi_ci*FCln+d10_exp0*(+(+FCa_ck_Vbi_ci_Vbi_ei-0.0)*FCln+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ei*0.0+(FCa_ck-1.0)*0.0));
  FCa1_Vbi_ci_Vbi_ci=(m20_exp(((FCa_ck-1.0)*FCln))*(FCa_ck_Vbi_ci*FCln)*FCa_ck_Vbi_ci*FCln+d10_exp0*(+(+FCa_ck_Vbi_ci_Vbi_ci-0.0)*FCln+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ci*0.0+(FCa_ck-1.0)*0.0));
#endif
#endif
FCa1=d00_exp0;
}
#if defined(_DERIVATEFORDDX)
FCd_a_Vci_ei=(-(-FCa1_Vci_ei*latb)/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#if defined(_DERIVATE)
  FCd_a_Vci_ei_Vci_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vci_ei*latb))+0.0*(-FCa1_Vci_ei*latb)+1.0*(+0.0-(+FCa1_Vci_ei_Vci_ei*latb+FCa1_Vci_ei*0.0+FCa1_Vci_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vci_ei*latb)*(-(FCa1_Vci_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vci_ei_Vtnode_GND=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vtnode_GND*latb))+0.0*(-FCa1_Vci_ei*latb)+1.0*(+0.0-(+FCa1_Vci_ei_Vtnode_GND*latb+FCa1_Vci_ei*0.0+FCa1_Vtnode_GND*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vci_ei*latb)*(-(FCa1_Vtnode_GND*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vci_ei_Vbi_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ei*latb))+0.0*(-FCa1_Vci_ei*latb)+1.0*(+0.0-(+FCa1_Vci_ei_Vbi_ei*latb+FCa1_Vci_ei*0.0+FCa1_Vbi_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vci_ei*latb)*(-(FCa1_Vbi_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vci_ei_Vbi_ci=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ci*latb))+0.0*(-FCa1_Vci_ei*latb)+1.0*(+0.0-(+FCa1_Vci_ei_Vbi_ci*latb+FCa1_Vci_ei*0.0+FCa1_Vbi_ci*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vci_ei*latb)*(-(FCa1_Vbi_ci*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#endif
#if defined(_DERIVATE)
FCd_a_Vtnode_GND=(-(-FCa1_Vtnode_GND*latb)/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#endif
FCd_a_Vbi_ei=(-(-FCa1_Vbi_ei*latb)/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ei_Vci_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vci_ei*latb))+0.0*(-FCa1_Vbi_ei*latb)+1.0*(+0.0-(+FCa1_Vbi_ei_Vci_ei*latb+FCa1_Vbi_ei*0.0+FCa1_Vci_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ei*latb)*(-(FCa1_Vci_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ei_Vtnode_GND=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vtnode_GND*latb))+0.0*(-FCa1_Vbi_ei*latb)+1.0*(+0.0-(+FCa1_Vbi_ei_Vtnode_GND*latb+FCa1_Vbi_ei*0.0+FCa1_Vtnode_GND*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ei*latb)*(-(FCa1_Vtnode_GND*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ei_Vbi_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ei*latb))+0.0*(-FCa1_Vbi_ei*latb)+1.0*(+0.0-(+FCa1_Vbi_ei_Vbi_ei*latb+FCa1_Vbi_ei*0.0+FCa1_Vbi_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ei*latb)*(-(FCa1_Vbi_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ei_Vbi_ci=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ci*latb))+0.0*(-FCa1_Vbi_ei*latb)+1.0*(+0.0-(+FCa1_Vbi_ei_Vbi_ci*latb+FCa1_Vbi_ei*0.0+FCa1_Vbi_ci*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ei*latb)*(-(FCa1_Vbi_ci*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#endif
FCd_a_Vbi_ci=(-(-FCa1_Vbi_ci*latb)/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ci_Vci_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vci_ei*latb))+0.0*(-FCa1_Vbi_ci*latb)+1.0*(+0.0-(+FCa1_Vbi_ci_Vci_ei*latb+FCa1_Vbi_ci*0.0+FCa1_Vci_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ci*latb)*(-(FCa1_Vci_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ci_Vtnode_GND=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vtnode_GND*latb))+0.0*(-FCa1_Vbi_ci*latb)+1.0*(+0.0-(+FCa1_Vbi_ci_Vtnode_GND*latb+FCa1_Vbi_ci*0.0+FCa1_Vtnode_GND*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ci*latb)*(-(FCa1_Vtnode_GND*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ci_Vbi_ei=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ei*latb))+0.0*(-FCa1_Vbi_ci*latb)+1.0*(+0.0-(+FCa1_Vbi_ci_Vbi_ei*latb+FCa1_Vbi_ci*0.0+FCa1_Vbi_ei*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ci*latb)*(-(FCa1_Vbi_ei*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
  FCd_a_Vbi_ci_Vbi_ci=(0.0/(latl-(FCa1*latb))-(0.0*(-(FCa1_Vbi_ci*latb))+0.0*(-FCa1_Vbi_ci*latb)+1.0*(+0.0-(+FCa1_Vbi_ci_Vbi_ci*latb+FCa1_Vbi_ci*0.0+FCa1_Vbi_ci*0.0+FCa1*0.0)))/(latl-(FCa1*latb))/(latl-(FCa1*latb))+2*1.0*(-FCa1_Vbi_ci*latb)*(-(FCa1_Vbi_ci*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb))/(latl-(FCa1*latb)));
#endif
#endif
FCd_a=(1.0/(latl-(FCa1*latb)));
#if defined(_DERIVATEFORDDX)
FCw_Vci_ei=((FCa1_Vci_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCw_Vci_ei_Vci_ei=(+(+FCa1_Vci_ei_Vci_ei-0.0)*FCd_a+FCa1_Vci_ei*FCd_a_Vci_ei+FCa1_Vci_ei*FCd_a_Vci_ei+(FCa1-1.0)*FCd_a_Vci_ei_Vci_ei);
  FCw_Vci_ei_Vtnode_GND=(+(+FCa1_Vci_ei_Vtnode_GND-0.0)*FCd_a+FCa1_Vci_ei*FCd_a_Vtnode_GND+FCa1_Vtnode_GND*FCd_a_Vci_ei+(FCa1-1.0)*FCd_a_Vci_ei_Vtnode_GND);
  FCw_Vci_ei_Vbi_ei=(+(+FCa1_Vci_ei_Vbi_ei-0.0)*FCd_a+FCa1_Vci_ei*FCd_a_Vbi_ei+FCa1_Vbi_ei*FCd_a_Vci_ei+(FCa1-1.0)*FCd_a_Vci_ei_Vbi_ei);
  FCw_Vci_ei_Vbi_ci=(+(+FCa1_Vci_ei_Vbi_ci-0.0)*FCd_a+FCa1_Vci_ei*FCd_a_Vbi_ci+FCa1_Vbi_ci*FCd_a_Vci_ei+(FCa1-1.0)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw_Vtnode_GND=((FCa1_Vtnode_GND*FCd_a)+((FCa1-1.0)*FCd_a_Vtnode_GND));
#endif
FCw_Vbi_ei=((FCa1_Vbi_ei*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCw_Vbi_ei_Vci_ei=(+(+FCa1_Vbi_ei_Vci_ei-0.0)*FCd_a+FCa1_Vbi_ei*FCd_a_Vci_ei+FCa1_Vci_ei*FCd_a_Vbi_ei+(FCa1-1.0)*FCd_a_Vbi_ei_Vci_ei);
  FCw_Vbi_ei_Vtnode_GND=(+(+FCa1_Vbi_ei_Vtnode_GND-0.0)*FCd_a+FCa1_Vbi_ei*FCd_a_Vtnode_GND+FCa1_Vtnode_GND*FCd_a_Vbi_ei+(FCa1-1.0)*FCd_a_Vbi_ei_Vtnode_GND);
  FCw_Vbi_ei_Vbi_ei=(+(+FCa1_Vbi_ei_Vbi_ei-0.0)*FCd_a+FCa1_Vbi_ei*FCd_a_Vbi_ei+FCa1_Vbi_ei*FCd_a_Vbi_ei+(FCa1-1.0)*FCd_a_Vbi_ei_Vbi_ei);
  FCw_Vbi_ei_Vbi_ci=(+(+FCa1_Vbi_ei_Vbi_ci-0.0)*FCd_a+FCa1_Vbi_ei*FCd_a_Vbi_ci+FCa1_Vbi_ci*FCd_a_Vbi_ei+(FCa1-1.0)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCw_Vbi_ci=((FCa1_Vbi_ci*FCd_a)+((FCa1-1.0)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCw_Vbi_ci_Vci_ei=(+(+FCa1_Vbi_ci_Vci_ei-0.0)*FCd_a+FCa1_Vbi_ci*FCd_a_Vci_ei+FCa1_Vci_ei*FCd_a_Vbi_ci+(FCa1-1.0)*FCd_a_Vbi_ci_Vci_ei);
  FCw_Vbi_ci_Vtnode_GND=(+(+FCa1_Vbi_ci_Vtnode_GND-0.0)*FCd_a+FCa1_Vbi_ci*FCd_a_Vtnode_GND+FCa1_Vtnode_GND*FCd_a_Vbi_ci+(FCa1-1.0)*FCd_a_Vbi_ci_Vtnode_GND);
  FCw_Vbi_ci_Vbi_ei=(+(+FCa1_Vbi_ci_Vbi_ei-0.0)*FCd_a+FCa1_Vbi_ci*FCd_a_Vbi_ei+FCa1_Vbi_ei*FCd_a_Vbi_ci+(FCa1-1.0)*FCd_a_Vbi_ci_Vbi_ei);
  FCw_Vbi_ci_Vbi_ci=(+(+FCa1_Vbi_ci_Vbi_ci-0.0)*FCd_a+FCa1_Vbi_ci*FCd_a_Vbi_ci+FCa1_Vbi_ci*FCd_a_Vbi_ci+(FCa1-1.0)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCw=((FCa1-1.0)*FCd_a);
#if defined(_DERIVATEFORDDX)
FCdw_daick_Vci_ei=(((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vci_ei_Vci_ei=(+(+(+(+0.0*FCa1+(-FCz_Vci_ei)*FCa1_Vci_ei+(-FCz_Vci_ei)*FCa1_Vci_ei+(-FCz)*FCa1_Vci_ei_Vci_ei)*FCln+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*0.0+((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a_Vci_ei+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a_Vci_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei_Vci_ei)*FCd_a+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a_Vci_ei+((((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei)))*FCd_a_Vci_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei_Vci_ei);
  FCdw_daick_Vci_ei_Vtnode_GND=(+(+(+(+0.0*FCa1+(-FCz_Vci_ei)*FCa1_Vtnode_GND+(-FCz_Vtnode_GND)*FCa1_Vci_ei+(-FCz)*FCa1_Vci_ei_Vtnode_GND)*FCln+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*0.0+((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a_Vtnode_GND+(((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a_Vci_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei_Vtnode_GND)*FCd_a+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a_Vtnode_GND+((((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND)))*FCd_a_Vci_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei_Vtnode_GND);
  FCdw_daick_Vci_ei_Vbi_ei=(+(+(+(+0.0*FCa1+(-FCz_Vci_ei)*FCa1_Vbi_ei+(-FCz_Vbi_ei)*FCa1_Vci_ei+(-FCz)*FCa1_Vci_ei_Vbi_ei)*FCln+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*0.0+((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a_Vbi_ei+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a_Vci_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei_Vbi_ei)*FCd_a+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a_Vbi_ei+((((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei)))*FCd_a_Vci_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei_Vbi_ei);
  FCdw_daick_Vci_ei_Vbi_ci=(+(+(+(+0.0*FCa1+(-FCz_Vci_ei)*FCa1_Vbi_ci+(-FCz_Vbi_ci)*FCa1_Vci_ei+(-FCz)*FCa1_Vci_ei_Vbi_ci)*FCln+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*0.0+((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a_Vbi_ci+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a_Vci_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei_Vbi_ci)*FCd_a+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei))*FCd_a_Vbi_ci+((((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci)))*FCd_a_Vci_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdw_daick_Vtnode_GND=(((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vtnode_GND));
#endif
FCdw_daick_Vbi_ei=(((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ei_Vci_ei=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ei)*FCa1_Vci_ei+(-FCz_Vci_ei)*FCa1_Vbi_ei+(-FCz)*FCa1_Vbi_ei_Vci_ei)*FCln+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*0.0+((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a_Vci_ei+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a_Vbi_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei_Vci_ei)*FCd_a+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a_Vci_ei+((((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei)))*FCd_a_Vbi_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei_Vci_ei);
  FCdw_daick_Vbi_ei_Vtnode_GND=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ei)*FCa1_Vtnode_GND+(-FCz_Vtnode_GND)*FCa1_Vbi_ei+(-FCz)*FCa1_Vbi_ei_Vtnode_GND)*FCln+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*0.0+((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a_Vtnode_GND+(((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a_Vbi_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei_Vtnode_GND)*FCd_a+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a_Vtnode_GND+((((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND)))*FCd_a_Vbi_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei_Vtnode_GND);
  FCdw_daick_Vbi_ei_Vbi_ei=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ei)*FCa1_Vbi_ei+(-FCz_Vbi_ei)*FCa1_Vbi_ei+(-FCz)*FCa1_Vbi_ei_Vbi_ei)*FCln+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*0.0+((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a_Vbi_ei+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a_Vbi_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei_Vbi_ei)*FCd_a+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a_Vbi_ei+((((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei)))*FCd_a_Vbi_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei_Vbi_ei);
  FCdw_daick_Vbi_ei_Vbi_ci=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ei)*FCa1_Vbi_ci+(-FCz_Vbi_ci)*FCa1_Vbi_ei+(-FCz)*FCa1_Vbi_ei_Vbi_ci)*FCln+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*0.0+((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a_Vbi_ci+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a_Vbi_ei+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei_Vbi_ci)*FCd_a+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei))*FCd_a_Vbi_ci+((((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci)))*FCd_a_Vbi_ei+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCdw_daick_Vbi_ci=(((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a)+(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ci_Vci_ei=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ci)*FCa1_Vci_ei+(-FCz_Vci_ei)*FCa1_Vbi_ci+(-FCz)*FCa1_Vbi_ci_Vci_ei)*FCln+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*0.0+((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a_Vci_ei+(((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a_Vbi_ci+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci_Vci_ei)*FCd_a+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a_Vci_ei+((((((((-FCz_Vci_ei)*FCa1)+((-FCz)*FCa1_Vci_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vci_ei)))*FCd_a_Vbi_ci+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci_Vci_ei);
  FCdw_daick_Vbi_ci_Vtnode_GND=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ci)*FCa1_Vtnode_GND+(-FCz_Vtnode_GND)*FCa1_Vbi_ci+(-FCz)*FCa1_Vbi_ci_Vtnode_GND)*FCln+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*0.0+((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a_Vtnode_GND+(((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a_Vbi_ci+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci_Vtnode_GND)*FCd_a+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a_Vtnode_GND+((((((((-FCz_Vtnode_GND)*FCa1)+((-FCz)*FCa1_Vtnode_GND)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vtnode_GND)))*FCd_a_Vbi_ci+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci_Vtnode_GND);
  FCdw_daick_Vbi_ci_Vbi_ei=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ci)*FCa1_Vbi_ei+(-FCz_Vbi_ei)*FCa1_Vbi_ci+(-FCz)*FCa1_Vbi_ci_Vbi_ei)*FCln+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*0.0+((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a_Vbi_ei+(((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a_Vbi_ci+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci_Vbi_ei)*FCd_a+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a_Vbi_ei+((((((((-FCz_Vbi_ei)*FCa1)+((-FCz)*FCa1_Vbi_ei)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ei)))*FCd_a_Vbi_ci+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci_Vbi_ei);
  FCdw_daick_Vbi_ci_Vbi_ci=(+(+(+(+0.0*FCa1+(-FCz_Vbi_ci)*FCa1_Vbi_ci+(-FCz_Vbi_ci)*FCa1_Vbi_ci+(-FCz)*FCa1_Vbi_ci_Vbi_ci)*FCln+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*0.0+((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*0.0+((-FCz)*FCa1)*0.0)*FCd_a+(((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a_Vbi_ci+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a_Vbi_ci+(((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci_Vbi_ci)*FCd_a+(((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci))*FCln*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci))*FCd_a_Vbi_ci+((((((((-FCz_Vbi_ci)*FCa1)+((-FCz)*FCa1_Vbi_ci)))*FCln)*FCd_a)+((((-FCz)*FCa1)*FCln)*FCd_a_Vbi_ci)))*FCd_a_Vbi_ci+((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCdw_daick=(((((-FCz)*FCa1)*FCln)*FCd_a)*FCd_a);
{
double m00_logE(d00_logE0,((1.0+(latb*FCw))/(1.0+(latl*FCw))))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,((1.0+(latb*FCw))/(1.0+(latl*FCw))))
#endif
#if defined(_DERIVATEFORDDX)
FCa1_Vci_ei=(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*d10_logE0;
#if defined(_DERIVATE)
  FCa1_Vci_ei_Vci_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vci_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei))/(1.0+(latl*FCw))-((latb*FCw_Vci_ei)*((latl*FCw_Vci_ei))+((latb*FCw_Vci_ei))*(latl*FCw_Vci_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vci_ei)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vci_ei_Vtnode_GND=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vtnode_GND))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND))/(1.0+(latl*FCw))-((latb*FCw_Vci_ei)*((latl*FCw_Vtnode_GND))+((latb*FCw_Vtnode_GND))*(latl*FCw_Vci_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vci_ei)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vci_ei_Vbi_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei))/(1.0+(latl*FCw))-((latb*FCw_Vci_ei)*((latl*FCw_Vbi_ei))+((latb*FCw_Vbi_ei))*(latl*FCw_Vci_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vci_ei)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vci_ei_Vbi_ci=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ci))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vci_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci))/(1.0+(latl*FCw))-((latb*FCw_Vci_ei)*((latl*FCw_Vbi_ci))+((latb*FCw_Vbi_ci))*(latl*FCw_Vci_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vci_ei)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
#if defined(_DERIVATE)
FCa1_Vtnode_GND=(((latb*FCw_Vtnode_GND)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*d10_logE0;
#endif
FCa1_Vbi_ei=(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*d10_logE0;
#if defined(_DERIVATE)
  FCa1_Vbi_ei_Vci_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vci_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ei)*((latl*FCw_Vci_ei))+((latb*FCw_Vci_ei))*(latl*FCw_Vbi_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ei)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ei_Vtnode_GND=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vtnode_GND))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ei)*((latl*FCw_Vtnode_GND))+((latb*FCw_Vtnode_GND))*(latl*FCw_Vbi_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ei)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ei_Vbi_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ei)*((latl*FCw_Vbi_ei))+((latb*FCw_Vbi_ei))*(latl*FCw_Vbi_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ei)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ei_Vbi_ci=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ci))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ei)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ei)*((latl*FCw_Vbi_ci))+((latb*FCw_Vbi_ci))*(latl*FCw_Vbi_ei)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ei)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
FCa1_Vbi_ci=(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*d10_logE0;
#if defined(_DERIVATE)
  FCa1_Vbi_ci_Vci_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vci_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ci)*((latl*FCw_Vci_ei))+((latb*FCw_Vci_ei))*(latl*FCw_Vbi_ci)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ci)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ci_Vtnode_GND=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vtnode_GND))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ci)*((latl*FCw_Vtnode_GND))+((latb*FCw_Vtnode_GND))*(latl*FCw_Vbi_ci)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ci)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ci_Vbi_ei=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ei))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ci)*((latl*FCw_Vbi_ei))+((latb*FCw_Vbi_ei))*(latl*FCw_Vbi_ci)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ci)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCa1_Vbi_ci_Vbi_ci=(m20_logE(((1.0+(latb*FCw))/(1.0+(latl*FCw))))*((((latb*FCw_Vbi_ci))*(1.0+(latl*FCw))-(1.0+(latb*FCw))*((latl*FCw_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))*(((latb*FCw_Vbi_ci)*(1.0+(latl*FCw))-(1.0+(latb*FCw))*(latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw)))+d10_logE0*((+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci))/(1.0+(latl*FCw))-((latb*FCw_Vbi_ci)*((latl*FCw_Vbi_ci))+((latb*FCw_Vbi_ci))*(latl*FCw_Vbi_ci)+(1.0+(latb*FCw))*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*(1.0+(latb*FCw))*(latl*FCw_Vbi_ci)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
#endif
FCa1=d00_logE0;
}
#if defined(_DERIVATEFORDDX)
FCda1_dw_Vci_ei=((-latb*(latb*FCw_Vci_ei)/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(-latl*(latl*FCw_Vci_ei)/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#if defined(_DERIVATE)
  FCda1_dw_Vci_ei_Vci_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vci_ei))+0.0*(latb*FCw_Vci_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vci_ei)*((latb*FCw_Vci_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vci_ei))+0.0*(latl*FCw_Vci_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vci_ei)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vci_ei_Vtnode_GND=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vtnode_GND))+0.0*(latb*FCw_Vci_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vci_ei)*((latb*FCw_Vtnode_GND))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vtnode_GND))+0.0*(latl*FCw_Vci_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vci_ei)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vci_ei_Vbi_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ei))+0.0*(latb*FCw_Vci_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vci_ei)*((latb*FCw_Vbi_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ei))+0.0*(latl*FCw_Vci_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vci_ei)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vci_ei_Vbi_ci=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ci))+0.0*(latb*FCw_Vci_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vci_ei)*((latb*FCw_Vbi_ci))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ci))+0.0*(latl*FCw_Vci_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vci_ei)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
#if defined(_DERIVATE)
FCda1_dw_Vtnode_GND=((-latb*(latb*FCw_Vtnode_GND)/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(-latl*(latl*FCw_Vtnode_GND)/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
FCda1_dw_Vbi_ei=((-latb*(latb*FCw_Vbi_ei)/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(-latl*(latl*FCw_Vbi_ei)/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#if defined(_DERIVATE)
  FCda1_dw_Vbi_ei_Vci_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vci_ei))+0.0*(latb*FCw_Vbi_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ei)*((latb*FCw_Vci_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vci_ei))+0.0*(latl*FCw_Vbi_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ei)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ei_Vtnode_GND=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vtnode_GND))+0.0*(latb*FCw_Vbi_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ei)*((latb*FCw_Vtnode_GND))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vtnode_GND))+0.0*(latl*FCw_Vbi_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ei)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ei_Vbi_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ei))+0.0*(latb*FCw_Vbi_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ei)*((latb*FCw_Vbi_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ei))+0.0*(latl*FCw_Vbi_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ei)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ei_Vbi_ci=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ci))+0.0*(latb*FCw_Vbi_ei)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ei)*((latb*FCw_Vbi_ci))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ci))+0.0*(latl*FCw_Vbi_ei)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ei)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
FCda1_dw_Vbi_ci=((-latb*(latb*FCw_Vbi_ci)/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(-latl*(latl*FCw_Vbi_ci)/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#if defined(_DERIVATE)
  FCda1_dw_Vbi_ci_Vci_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vci_ei))+0.0*(latb*FCw_Vbi_ci)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ci)*((latb*FCw_Vci_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vci_ei))+0.0*(latl*FCw_Vbi_ci)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ci)*((latl*FCw_Vci_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ci_Vtnode_GND=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vtnode_GND))+0.0*(latb*FCw_Vbi_ci)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ci)*((latb*FCw_Vtnode_GND))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vtnode_GND))+0.0*(latl*FCw_Vbi_ci)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ci)*((latl*FCw_Vtnode_GND))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ci_Vbi_ei=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ei))+0.0*(latb*FCw_Vbi_ci)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ci)*((latb*FCw_Vbi_ei))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ei))+0.0*(latl*FCw_Vbi_ci)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ci)*((latl*FCw_Vbi_ei))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
  FCda1_dw_Vbi_ci_Vbi_ci=(+(0.0/(1.0+(latb*FCw))-(0.0*((latb*FCw_Vbi_ci))+0.0*(latb*FCw_Vbi_ci)+latb*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci)))/(1.0+(latb*FCw))/(1.0+(latb*FCw))+2*latb*(latb*FCw_Vbi_ci)*((latb*FCw_Vbi_ci))/(1.0+(latb*FCw))/(1.0+(latb*FCw))/(1.0+(latb*FCw)))-(0.0/(1.0+(latl*FCw))-(0.0*((latl*FCw_Vbi_ci))+0.0*(latl*FCw_Vbi_ci)+latl*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci)))/(1.0+(latl*FCw))/(1.0+(latl*FCw))+2*latl*(latl*FCw_Vbi_ci)*((latl*FCw_Vbi_ci))/(1.0+(latl*FCw))/(1.0+(latl*FCw))/(1.0+(latl*FCw))));
#endif
#endif
FCda1_dw=((latb/(1.0+(latb*FCw)))-(latl/(1.0+(latl*FCw))));
}
else
{
#if defined(_DERIVATEFORDDX)
FCf1_Vci_ei=(-FCa_ck_Vci_ei);
#if defined(_DERIVATE)
  FCf1_Vci_ei_Vci_ei=(+0.0-FCa_ck_Vci_ei_Vci_ei);
  FCf1_Vci_ei_Vtnode_GND=(+0.0-FCa_ck_Vci_ei_Vtnode_GND);
  FCf1_Vci_ei_Vbi_ei=(+0.0-FCa_ck_Vci_ei_Vbi_ei);
  FCf1_Vci_ei_Vbi_ci=(+0.0-FCa_ck_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCf1_Vtnode_GND=(-FCa_ck_Vtnode_GND);
#endif
FCf1_Vbi_ei=(-FCa_ck_Vbi_ei);
#if defined(_DERIVATE)
  FCf1_Vbi_ei_Vci_ei=(+0.0-FCa_ck_Vbi_ei_Vci_ei);
  FCf1_Vbi_ei_Vtnode_GND=(+0.0-FCa_ck_Vbi_ei_Vtnode_GND);
  FCf1_Vbi_ei_Vbi_ei=(+0.0-FCa_ck_Vbi_ei_Vbi_ei);
  FCf1_Vbi_ei_Vbi_ci=(+0.0-FCa_ck_Vbi_ei_Vbi_ci);
#endif
FCf1_Vbi_ci=(-FCa_ck_Vbi_ci);
#if defined(_DERIVATE)
  FCf1_Vbi_ci_Vci_ei=(+0.0-FCa_ck_Vbi_ci_Vci_ei);
  FCf1_Vbi_ci_Vtnode_GND=(+0.0-FCa_ck_Vbi_ci_Vtnode_GND);
  FCf1_Vbi_ci_Vbi_ei=(+0.0-FCa_ck_Vbi_ci_Vbi_ei);
  FCf1_Vbi_ci_Vbi_ci=(+0.0-FCa_ck_Vbi_ci_Vbi_ci);
#endif
#endif
FCf1=(1.0-FCa_ck);
#if defined(_DERIVATEFORDDX)
FCd_a_Vci_ei=(-FCa_ck_Vci_ei*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vci_ei_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vci_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vtnode_GND*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vbi_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vbi_ci*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
#if defined(_DERIVATE)
FCd_a_Vtnode_GND=(-FCa_ck_Vtnode_GND*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
FCd_a_Vbi_ei=(-FCa_ck_Vbi_ei*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ei_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vci_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vtnode_GND*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vbi_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vbi_ci*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
FCd_a_Vbi_ci=(-FCa_ck_Vbi_ci*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ci_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vci_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vtnode_GND*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vbi_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vbi_ci*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
#endif
FCd_a=(1.0/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATEFORDDX)
FCw_Vci_ei=((FCf1_Vci_ei*FCd_a)+(FCf1*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCw_Vci_ei_Vci_ei=(+FCf1_Vci_ei_Vci_ei*FCd_a+FCf1_Vci_ei*FCd_a_Vci_ei+FCf1_Vci_ei*FCd_a_Vci_ei+FCf1*FCd_a_Vci_ei_Vci_ei);
  FCw_Vci_ei_Vtnode_GND=(+FCf1_Vci_ei_Vtnode_GND*FCd_a+FCf1_Vci_ei*FCd_a_Vtnode_GND+FCf1_Vtnode_GND*FCd_a_Vci_ei+FCf1*FCd_a_Vci_ei_Vtnode_GND);
  FCw_Vci_ei_Vbi_ei=(+FCf1_Vci_ei_Vbi_ei*FCd_a+FCf1_Vci_ei*FCd_a_Vbi_ei+FCf1_Vbi_ei*FCd_a_Vci_ei+FCf1*FCd_a_Vci_ei_Vbi_ei);
  FCw_Vci_ei_Vbi_ci=(+FCf1_Vci_ei_Vbi_ci*FCd_a+FCf1_Vci_ei*FCd_a_Vbi_ci+FCf1_Vbi_ci*FCd_a_Vci_ei+FCf1*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw_Vtnode_GND=((FCf1_Vtnode_GND*FCd_a)+(FCf1*FCd_a_Vtnode_GND));
#endif
FCw_Vbi_ei=((FCf1_Vbi_ei*FCd_a)+(FCf1*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCw_Vbi_ei_Vci_ei=(+FCf1_Vbi_ei_Vci_ei*FCd_a+FCf1_Vbi_ei*FCd_a_Vci_ei+FCf1_Vci_ei*FCd_a_Vbi_ei+FCf1*FCd_a_Vbi_ei_Vci_ei);
  FCw_Vbi_ei_Vtnode_GND=(+FCf1_Vbi_ei_Vtnode_GND*FCd_a+FCf1_Vbi_ei*FCd_a_Vtnode_GND+FCf1_Vtnode_GND*FCd_a_Vbi_ei+FCf1*FCd_a_Vbi_ei_Vtnode_GND);
  FCw_Vbi_ei_Vbi_ei=(+FCf1_Vbi_ei_Vbi_ei*FCd_a+FCf1_Vbi_ei*FCd_a_Vbi_ei+FCf1_Vbi_ei*FCd_a_Vbi_ei+FCf1*FCd_a_Vbi_ei_Vbi_ei);
  FCw_Vbi_ei_Vbi_ci=(+FCf1_Vbi_ei_Vbi_ci*FCd_a+FCf1_Vbi_ei*FCd_a_Vbi_ci+FCf1_Vbi_ci*FCd_a_Vbi_ei+FCf1*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCw_Vbi_ci=((FCf1_Vbi_ci*FCd_a)+(FCf1*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCw_Vbi_ci_Vci_ei=(+FCf1_Vbi_ci_Vci_ei*FCd_a+FCf1_Vbi_ci*FCd_a_Vci_ei+FCf1_Vci_ei*FCd_a_Vbi_ci+FCf1*FCd_a_Vbi_ci_Vci_ei);
  FCw_Vbi_ci_Vtnode_GND=(+FCf1_Vbi_ci_Vtnode_GND*FCd_a+FCf1_Vbi_ci*FCd_a_Vtnode_GND+FCf1_Vtnode_GND*FCd_a_Vbi_ci+FCf1*FCd_a_Vbi_ci_Vtnode_GND);
  FCw_Vbi_ci_Vbi_ei=(+FCf1_Vbi_ci_Vbi_ei*FCd_a+FCf1_Vbi_ci*FCd_a_Vbi_ei+FCf1_Vbi_ei*FCd_a_Vbi_ci+FCf1*FCd_a_Vbi_ci_Vbi_ei);
  FCw_Vbi_ci_Vbi_ci=(+FCf1_Vbi_ci_Vbi_ci*FCd_a+FCf1_Vbi_ci*FCd_a_Vbi_ci+FCf1_Vbi_ci*FCd_a_Vbi_ci+FCf1*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCw=(FCf1*FCd_a);
#if defined(_DERIVATEFORDDX)
FCdw_daick_Vci_ei=((((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a)+(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vci_ei_Vci_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vci_ei+(-1.0)*FCd_a_Vci_ei_Vci_ei)*FCd_a+((-1.0)*FCd_a_Vci_ei)*FCd_a_Vci_ei+(((-1.0)*FCd_a_Vci_ei))*FCd_a_Vci_ei+((-1.0)*FCd_a)*FCd_a_Vci_ei_Vci_ei)*FCxb+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*0.0+((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a_Vci_ei+(((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*FCxb)*FCd_a_Vci_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei_Vci_ei);
  FCdw_daick_Vci_ei_Vtnode_GND=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vci_ei+(-1.0)*FCd_a_Vci_ei_Vtnode_GND)*FCd_a+((-1.0)*FCd_a_Vci_ei)*FCd_a_Vtnode_GND+(((-1.0)*FCd_a_Vtnode_GND))*FCd_a_Vci_ei+((-1.0)*FCd_a)*FCd_a_Vci_ei_Vtnode_GND)*FCxb+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*0.0+((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a_Vtnode_GND+(((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*FCxb)*FCd_a_Vci_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei_Vtnode_GND);
  FCdw_daick_Vci_ei_Vbi_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vci_ei+(-1.0)*FCd_a_Vci_ei_Vbi_ei)*FCd_a+((-1.0)*FCd_a_Vci_ei)*FCd_a_Vbi_ei+(((-1.0)*FCd_a_Vbi_ei))*FCd_a_Vci_ei+((-1.0)*FCd_a)*FCd_a_Vci_ei_Vbi_ei)*FCxb+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*0.0+((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a_Vbi_ei+(((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*FCxb)*FCd_a_Vci_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei_Vbi_ei);
  FCdw_daick_Vci_ei_Vbi_ci=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vci_ei+(-1.0)*FCd_a_Vci_ei_Vbi_ci)*FCd_a+((-1.0)*FCd_a_Vci_ei)*FCd_a_Vbi_ci+(((-1.0)*FCd_a_Vbi_ci))*FCd_a_Vci_ei+((-1.0)*FCd_a)*FCd_a_Vci_ei_Vbi_ci)*FCxb+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*0.0+((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vci_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei))*FCxb*FCd_a_Vbi_ci+(((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*FCxb)*FCd_a_Vci_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdw_daick_Vtnode_GND=((((((-1.0)*FCd_a_Vtnode_GND)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND))*FCxb*FCd_a)+(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vtnode_GND));
#endif
FCdw_daick_Vbi_ei=((((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a)+(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ei_Vci_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vbi_ei+(-1.0)*FCd_a_Vbi_ei_Vci_ei)*FCd_a+((-1.0)*FCd_a_Vbi_ei)*FCd_a_Vci_ei+(((-1.0)*FCd_a_Vci_ei))*FCd_a_Vbi_ei+((-1.0)*FCd_a)*FCd_a_Vbi_ei_Vci_ei)*FCxb+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*0.0+((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a_Vci_ei+(((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*FCxb)*FCd_a_Vbi_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei_Vci_ei);
  FCdw_daick_Vbi_ei_Vtnode_GND=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vbi_ei+(-1.0)*FCd_a_Vbi_ei_Vtnode_GND)*FCd_a+((-1.0)*FCd_a_Vbi_ei)*FCd_a_Vtnode_GND+(((-1.0)*FCd_a_Vtnode_GND))*FCd_a_Vbi_ei+((-1.0)*FCd_a)*FCd_a_Vbi_ei_Vtnode_GND)*FCxb+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*0.0+((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a_Vtnode_GND+(((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*FCxb)*FCd_a_Vbi_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei_Vtnode_GND);
  FCdw_daick_Vbi_ei_Vbi_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vbi_ei+(-1.0)*FCd_a_Vbi_ei_Vbi_ei)*FCd_a+((-1.0)*FCd_a_Vbi_ei)*FCd_a_Vbi_ei+(((-1.0)*FCd_a_Vbi_ei))*FCd_a_Vbi_ei+((-1.0)*FCd_a)*FCd_a_Vbi_ei_Vbi_ei)*FCxb+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*0.0+((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a_Vbi_ei+(((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*FCxb)*FCd_a_Vbi_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei_Vbi_ei);
  FCdw_daick_Vbi_ei_Vbi_ci=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vbi_ei+(-1.0)*FCd_a_Vbi_ei_Vbi_ci)*FCd_a+((-1.0)*FCd_a_Vbi_ei)*FCd_a_Vbi_ci+(((-1.0)*FCd_a_Vbi_ci))*FCd_a_Vbi_ei+((-1.0)*FCd_a)*FCd_a_Vbi_ei_Vbi_ci)*FCxb+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*0.0+((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ei)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei))*FCxb*FCd_a_Vbi_ci+(((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*FCxb)*FCd_a_Vbi_ei+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCdw_daick_Vbi_ci=((((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a)+(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ci_Vci_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vbi_ci+(-1.0)*FCd_a_Vbi_ci_Vci_ei)*FCd_a+((-1.0)*FCd_a_Vbi_ci)*FCd_a_Vci_ei+(((-1.0)*FCd_a_Vci_ei))*FCd_a_Vbi_ci+((-1.0)*FCd_a)*FCd_a_Vbi_ci_Vci_ei)*FCxb+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*0.0+((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a_Vci_ei+(((((((-1.0)*FCd_a_Vci_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vci_ei)))*FCxb)*FCd_a_Vbi_ci+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci_Vci_ei);
  FCdw_daick_Vbi_ci_Vtnode_GND=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vbi_ci+(-1.0)*FCd_a_Vbi_ci_Vtnode_GND)*FCd_a+((-1.0)*FCd_a_Vbi_ci)*FCd_a_Vtnode_GND+(((-1.0)*FCd_a_Vtnode_GND))*FCd_a_Vbi_ci+((-1.0)*FCd_a)*FCd_a_Vbi_ci_Vtnode_GND)*FCxb+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*0.0+((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a_Vtnode_GND+(((((((-1.0)*FCd_a_Vtnode_GND))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vtnode_GND)))*FCxb)*FCd_a_Vbi_ci+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci_Vtnode_GND);
  FCdw_daick_Vbi_ci_Vbi_ei=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vbi_ci+(-1.0)*FCd_a_Vbi_ci_Vbi_ei)*FCd_a+((-1.0)*FCd_a_Vbi_ci)*FCd_a_Vbi_ei+(((-1.0)*FCd_a_Vbi_ei))*FCd_a_Vbi_ci+((-1.0)*FCd_a)*FCd_a_Vbi_ci_Vbi_ei)*FCxb+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*0.0+((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a_Vbi_ei+(((((((-1.0)*FCd_a_Vbi_ei))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ei)))*FCxb)*FCd_a_Vbi_ci+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci_Vbi_ei);
  FCdw_daick_Vbi_ci_Vbi_ci=(+(+(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vbi_ci+(-1.0)*FCd_a_Vbi_ci_Vbi_ci)*FCd_a+((-1.0)*FCd_a_Vbi_ci)*FCd_a_Vbi_ci+(((-1.0)*FCd_a_Vbi_ci))*FCd_a_Vbi_ci+((-1.0)*FCd_a)*FCd_a_Vbi_ci_Vbi_ci)*FCxb+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*0.0+((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*0.0+(((-1.0)*FCd_a)*FCd_a)*0.0)*FCd_a+((((-1.0)*FCd_a_Vbi_ci)*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci))*FCxb*FCd_a_Vbi_ci+(((((((-1.0)*FCd_a_Vbi_ci))*FCd_a)+(((-1.0)*FCd_a)*FCd_a_Vbi_ci)))*FCxb)*FCd_a_Vbi_ci+((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCdw_daick=(((((-1.0)*FCd_a)*FCd_a)*FCxb)*FCd_a);
#if defined(_DERIVATEFORDDX)
FCa1_Vci_ei=((FCz_Vci_ei*FCw)+(FCz*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCa1_Vci_ei_Vci_ei=(+FCz_Vci_ei_Vci_ei*FCw+FCz_Vci_ei*FCw_Vci_ei+FCz_Vci_ei*FCw_Vci_ei+FCz*FCw_Vci_ei_Vci_ei);
  FCa1_Vci_ei_Vtnode_GND=(+FCz_Vci_ei_Vtnode_GND*FCw+FCz_Vci_ei*FCw_Vtnode_GND+FCz_Vtnode_GND*FCw_Vci_ei+FCz*FCw_Vci_ei_Vtnode_GND);
  FCa1_Vci_ei_Vbi_ei=(+FCz_Vci_ei_Vbi_ei*FCw+FCz_Vci_ei*FCw_Vbi_ei+FCz_Vbi_ei*FCw_Vci_ei+FCz*FCw_Vci_ei_Vbi_ei);
  FCa1_Vci_ei_Vbi_ci=(+FCz_Vci_ei_Vbi_ci*FCw+FCz_Vci_ei*FCw_Vbi_ci+FCz_Vbi_ci*FCw_Vci_ei+FCz*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCa1_Vtnode_GND=((FCz_Vtnode_GND*FCw)+(FCz*FCw_Vtnode_GND));
#endif
FCa1_Vbi_ei=((FCz_Vbi_ei*FCw)+(FCz*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCa1_Vbi_ei_Vci_ei=(+FCz_Vbi_ei_Vci_ei*FCw+FCz_Vbi_ei*FCw_Vci_ei+FCz_Vci_ei*FCw_Vbi_ei+FCz*FCw_Vbi_ei_Vci_ei);
  FCa1_Vbi_ei_Vtnode_GND=(+FCz_Vbi_ei_Vtnode_GND*FCw+FCz_Vbi_ei*FCw_Vtnode_GND+FCz_Vtnode_GND*FCw_Vbi_ei+FCz*FCw_Vbi_ei_Vtnode_GND);
  FCa1_Vbi_ei_Vbi_ei=(+FCz_Vbi_ei_Vbi_ei*FCw+FCz_Vbi_ei*FCw_Vbi_ei+FCz_Vbi_ei*FCw_Vbi_ei+FCz*FCw_Vbi_ei_Vbi_ei);
  FCa1_Vbi_ei_Vbi_ci=(+FCz_Vbi_ei_Vbi_ci*FCw+FCz_Vbi_ei*FCw_Vbi_ci+FCz_Vbi_ci*FCw_Vbi_ei+FCz*FCw_Vbi_ei_Vbi_ci);
#endif
FCa1_Vbi_ci=((FCz_Vbi_ci*FCw)+(FCz*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCa1_Vbi_ci_Vci_ei=(+FCz_Vbi_ci_Vci_ei*FCw+FCz_Vbi_ci*FCw_Vci_ei+FCz_Vci_ei*FCw_Vbi_ci+FCz*FCw_Vbi_ci_Vci_ei);
  FCa1_Vbi_ci_Vtnode_GND=(+FCz_Vbi_ci_Vtnode_GND*FCw+FCz_Vbi_ci*FCw_Vtnode_GND+FCz_Vtnode_GND*FCw_Vbi_ci+FCz*FCw_Vbi_ci_Vtnode_GND);
  FCa1_Vbi_ci_Vbi_ei=(+FCz_Vbi_ci_Vbi_ei*FCw+FCz_Vbi_ci*FCw_Vbi_ei+FCz_Vbi_ei*FCw_Vbi_ci+FCz*FCw_Vbi_ci_Vbi_ei);
  FCa1_Vbi_ci_Vbi_ci=(+FCz_Vbi_ci_Vbi_ci*FCw+FCz_Vbi_ci*FCw_Vbi_ci+FCz_Vbi_ci*FCw_Vbi_ci+FCz*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCa1=(FCz*FCw);
#if defined(_DERIVATEFORDDX)
FCda1_dw_Vci_ei=FCz_Vci_ei;
#if defined(_DERIVATE)
  FCda1_dw_Vci_ei_Vci_ei=FCz_Vci_ei_Vci_ei;
  FCda1_dw_Vci_ei_Vtnode_GND=FCz_Vci_ei_Vtnode_GND;
  FCda1_dw_Vci_ei_Vbi_ei=FCz_Vci_ei_Vbi_ei;
  FCda1_dw_Vci_ei_Vbi_ci=FCz_Vci_ei_Vbi_ci;
#endif
#if defined(_DERIVATE)
FCda1_dw_Vtnode_GND=FCz_Vtnode_GND;
#endif
FCda1_dw_Vbi_ei=FCz_Vbi_ei;
#if defined(_DERIVATE)
  FCda1_dw_Vbi_ei_Vci_ei=FCz_Vbi_ei_Vci_ei;
  FCda1_dw_Vbi_ei_Vtnode_GND=FCz_Vbi_ei_Vtnode_GND;
  FCda1_dw_Vbi_ei_Vbi_ei=FCz_Vbi_ei_Vbi_ei;
  FCda1_dw_Vbi_ei_Vbi_ci=FCz_Vbi_ei_Vbi_ci;
#endif
FCda1_dw_Vbi_ci=FCz_Vbi_ci;
#if defined(_DERIVATE)
  FCda1_dw_Vbi_ci_Vci_ei=FCz_Vbi_ci_Vci_ei;
  FCda1_dw_Vbi_ci_Vtnode_GND=FCz_Vbi_ci_Vtnode_GND;
  FCda1_dw_Vbi_ci_Vbi_ei=FCz_Vbi_ci_Vbi_ei;
  FCda1_dw_Vbi_ci_Vbi_ci=FCz_Vbi_ci_Vbi_ci;
#endif
#endif
FCda1_dw=FCz;
}
#if defined(_DERIVATEFORDDX)
FCf_CT_Vbi_ei=(-2.0*FCz_Vbi_ei/FCz/FCz);
#if defined(_DERIVATE)
  FCf_CT_Vbi_ei_Vbi_ei=(0.0/FCz-(0.0*FCz_Vbi_ei+0.0*FCz_Vbi_ei+2.0*FCz_Vbi_ei_Vbi_ei)/FCz/FCz+2*2.0*FCz_Vbi_ei*FCz_Vbi_ei/FCz/FCz/FCz);
  FCf_CT_Vbi_ei_Vbi_ci=(0.0/FCz-(0.0*FCz_Vbi_ci+0.0*FCz_Vbi_ei+2.0*FCz_Vbi_ei_Vbi_ci)/FCz/FCz+2*2.0*FCz_Vbi_ei*FCz_Vbi_ci/FCz/FCz/FCz);
  FCf_CT_Vbi_ei_Vci_ei=(0.0/FCz-(0.0*FCz_Vci_ei+0.0*FCz_Vbi_ei+2.0*FCz_Vbi_ei_Vci_ei)/FCz/FCz+2*2.0*FCz_Vbi_ei*FCz_Vci_ei/FCz/FCz/FCz);
  FCf_CT_Vbi_ei_Vtnode_GND=(0.0/FCz-(0.0*FCz_Vtnode_GND+0.0*FCz_Vbi_ei+2.0*FCz_Vbi_ei_Vtnode_GND)/FCz/FCz+2*2.0*FCz_Vbi_ei*FCz_Vtnode_GND/FCz/FCz/FCz);
#endif
FCf_CT_Vbi_ci=(-2.0*FCz_Vbi_ci/FCz/FCz);
#if defined(_DERIVATE)
  FCf_CT_Vbi_ci_Vbi_ei=(0.0/FCz-(0.0*FCz_Vbi_ei+0.0*FCz_Vbi_ci+2.0*FCz_Vbi_ci_Vbi_ei)/FCz/FCz+2*2.0*FCz_Vbi_ci*FCz_Vbi_ei/FCz/FCz/FCz);
  FCf_CT_Vbi_ci_Vbi_ci=(0.0/FCz-(0.0*FCz_Vbi_ci+0.0*FCz_Vbi_ci+2.0*FCz_Vbi_ci_Vbi_ci)/FCz/FCz+2*2.0*FCz_Vbi_ci*FCz_Vbi_ci/FCz/FCz/FCz);
  FCf_CT_Vbi_ci_Vci_ei=(0.0/FCz-(0.0*FCz_Vci_ei+0.0*FCz_Vbi_ci+2.0*FCz_Vbi_ci_Vci_ei)/FCz/FCz+2*2.0*FCz_Vbi_ci*FCz_Vci_ei/FCz/FCz/FCz);
  FCf_CT_Vbi_ci_Vtnode_GND=(0.0/FCz-(0.0*FCz_Vtnode_GND+0.0*FCz_Vbi_ci+2.0*FCz_Vbi_ci_Vtnode_GND)/FCz/FCz+2*2.0*FCz_Vbi_ci*FCz_Vtnode_GND/FCz/FCz/FCz);
#endif
FCf_CT_Vci_ei=(-2.0*FCz_Vci_ei/FCz/FCz);
#if defined(_DERIVATE)
  FCf_CT_Vci_ei_Vbi_ei=(0.0/FCz-(0.0*FCz_Vbi_ei+0.0*FCz_Vci_ei+2.0*FCz_Vci_ei_Vbi_ei)/FCz/FCz+2*2.0*FCz_Vci_ei*FCz_Vbi_ei/FCz/FCz/FCz);
  FCf_CT_Vci_ei_Vbi_ci=(0.0/FCz-(0.0*FCz_Vbi_ci+0.0*FCz_Vci_ei+2.0*FCz_Vci_ei_Vbi_ci)/FCz/FCz+2*2.0*FCz_Vci_ei*FCz_Vbi_ci/FCz/FCz/FCz);
  FCf_CT_Vci_ei_Vci_ei=(0.0/FCz-(0.0*FCz_Vci_ei+0.0*FCz_Vci_ei+2.0*FCz_Vci_ei_Vci_ei)/FCz/FCz+2*2.0*FCz_Vci_ei*FCz_Vci_ei/FCz/FCz/FCz);
  FCf_CT_Vci_ei_Vtnode_GND=(0.0/FCz-(0.0*FCz_Vtnode_GND+0.0*FCz_Vci_ei+2.0*FCz_Vci_ei_Vtnode_GND)/FCz/FCz+2*2.0*FCz_Vci_ei*FCz_Vtnode_GND/FCz/FCz/FCz);
#endif
#if defined(_DERIVATE)
FCf_CT_Vtnode_GND=(-2.0*FCz_Vtnode_GND/FCz/FCz);
#endif
#endif
FCf_CT=(2.0/FCz);
#if defined(_DERIVATEFORDDX)
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCw2_Vci_ei_Vci_ei=(+FCw_Vci_ei_Vci_ei*FCw+FCw_Vci_ei*FCw_Vci_ei+FCw_Vci_ei*FCw_Vci_ei+FCw*FCw_Vci_ei_Vci_ei);
  FCw2_Vci_ei_Vtnode_GND=(+FCw_Vci_ei_Vtnode_GND*FCw+FCw_Vci_ei*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vci_ei+FCw*FCw_Vci_ei_Vtnode_GND);
  FCw2_Vci_ei_Vbi_ei=(+FCw_Vci_ei_Vbi_ei*FCw+FCw_Vci_ei*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vci_ei+FCw*FCw_Vci_ei_Vbi_ei);
  FCw2_Vci_ei_Vbi_ci=(+FCw_Vci_ei_Vbi_ci*FCw+FCw_Vci_ei*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vci_ei+FCw*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
#endif
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCw2_Vbi_ei_Vci_ei=(+FCw_Vbi_ei_Vci_ei*FCw+FCw_Vbi_ei*FCw_Vci_ei+FCw_Vci_ei*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vci_ei);
  FCw2_Vbi_ei_Vtnode_GND=(+FCw_Vbi_ei_Vtnode_GND*FCw+FCw_Vbi_ei*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vtnode_GND);
  FCw2_Vbi_ei_Vbi_ei=(+FCw_Vbi_ei_Vbi_ei*FCw+FCw_Vbi_ei*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vbi_ei);
  FCw2_Vbi_ei_Vbi_ci=(+FCw_Vbi_ei_Vbi_ci*FCw+FCw_Vbi_ei*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vbi_ci);
#endif
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCw2_Vbi_ci_Vci_ei=(+FCw_Vbi_ci_Vci_ei*FCw+FCw_Vbi_ci*FCw_Vci_ei+FCw_Vci_ei*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vci_ei);
  FCw2_Vbi_ci_Vtnode_GND=(+FCw_Vbi_ci_Vtnode_GND*FCw+FCw_Vbi_ci*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vtnode_GND);
  FCw2_Vbi_ci_Vbi_ei=(+FCw_Vbi_ci_Vbi_ei*FCw+FCw_Vbi_ci*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vbi_ei);
  FCw2_Vbi_ci_Vbi_ci=(+FCw_Vbi_ci_Vbi_ci*FCw+FCw_Vbi_ci*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCw2=(FCw*FCw);
#if defined(_DERIVATEFORDDX)
FCf1_Vci_ei=(((((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))/3.0)+(((latb+latl)*FCw2_Vci_ei)/2.0))+FCw_Vci_ei);
#if defined(_DERIVATE)
  FCf1_Vci_ei_Vci_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+(latb*latl)*FCw_Vci_ei_Vci_ei)*FCw2+((latb*latl)*FCw_Vci_ei)*FCw2_Vci_ei+(((latb*latl)*FCw_Vci_ei))*FCw2_Vci_ei+((latb*latl)*FCw)*FCw2_Vci_ei_Vci_ei)/3.0-(((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))*0.0+((((((latb*latl)*FCw_Vci_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vci_ei+(latb+latl)*FCw2_Vci_ei_Vci_ei)/2.0-(((latb+latl)*FCw2_Vci_ei)*0.0+(((latb+latl)*FCw2_Vci_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vci_ei_Vci_ei);
  FCf1_Vci_ei_Vtnode_GND=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+(latb*latl)*FCw_Vci_ei_Vtnode_GND)*FCw2+((latb*latl)*FCw_Vci_ei)*FCw2_Vtnode_GND+(((latb*latl)*FCw_Vtnode_GND))*FCw2_Vci_ei+((latb*latl)*FCw)*FCw2_Vci_ei_Vtnode_GND)/3.0-(((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))*0.0+((((((latb*latl)*FCw_Vtnode_GND))*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vci_ei+(latb+latl)*FCw2_Vci_ei_Vtnode_GND)/2.0-(((latb+latl)*FCw2_Vci_ei)*0.0+(((latb+latl)*FCw2_Vtnode_GND))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vci_ei_Vtnode_GND);
  FCf1_Vci_ei_Vbi_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+(latb*latl)*FCw_Vci_ei_Vbi_ei)*FCw2+((latb*latl)*FCw_Vci_ei)*FCw2_Vbi_ei+(((latb*latl)*FCw_Vbi_ei))*FCw2_Vci_ei+((latb*latl)*FCw)*FCw2_Vci_ei_Vbi_ei)/3.0-(((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))*0.0+((((((latb*latl)*FCw_Vbi_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vci_ei+(latb+latl)*FCw2_Vci_ei_Vbi_ei)/2.0-(((latb+latl)*FCw2_Vci_ei)*0.0+(((latb+latl)*FCw2_Vbi_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vci_ei_Vbi_ei);
  FCf1_Vci_ei_Vbi_ci=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+(latb*latl)*FCw_Vci_ei_Vbi_ci)*FCw2+((latb*latl)*FCw_Vci_ei)*FCw2_Vbi_ci+(((latb*latl)*FCw_Vbi_ci))*FCw2_Vci_ei+((latb*latl)*FCw)*FCw2_Vci_ei_Vbi_ci)/3.0-(((((latb*latl)*FCw_Vci_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei))*0.0+((((((latb*latl)*FCw_Vbi_ci))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vci_ei+(latb+latl)*FCw2_Vci_ei_Vbi_ci)/2.0-(((latb+latl)*FCw2_Vci_ei)*0.0+(((latb+latl)*FCw2_Vbi_ci))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCf1_Vtnode_GND=(((((((latb*latl)*FCw_Vtnode_GND)*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND))/3.0)+(((latb+latl)*FCw2_Vtnode_GND)/2.0))+FCw_Vtnode_GND);
#endif
FCf1_Vbi_ei=(((((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))/3.0)+(((latb+latl)*FCw2_Vbi_ei)/2.0))+FCw_Vbi_ei);
#if defined(_DERIVATE)
  FCf1_Vbi_ei_Vci_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+(latb*latl)*FCw_Vbi_ei_Vci_ei)*FCw2+((latb*latl)*FCw_Vbi_ei)*FCw2_Vci_ei+(((latb*latl)*FCw_Vci_ei))*FCw2_Vbi_ei+((latb*latl)*FCw)*FCw2_Vbi_ei_Vci_ei)/3.0-(((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))*0.0+((((((latb*latl)*FCw_Vci_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vbi_ei+(latb+latl)*FCw2_Vbi_ei_Vci_ei)/2.0-(((latb+latl)*FCw2_Vbi_ei)*0.0+(((latb+latl)*FCw2_Vci_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ei_Vci_ei);
  FCf1_Vbi_ei_Vtnode_GND=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+(latb*latl)*FCw_Vbi_ei_Vtnode_GND)*FCw2+((latb*latl)*FCw_Vbi_ei)*FCw2_Vtnode_GND+(((latb*latl)*FCw_Vtnode_GND))*FCw2_Vbi_ei+((latb*latl)*FCw)*FCw2_Vbi_ei_Vtnode_GND)/3.0-(((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))*0.0+((((((latb*latl)*FCw_Vtnode_GND))*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vbi_ei+(latb+latl)*FCw2_Vbi_ei_Vtnode_GND)/2.0-(((latb+latl)*FCw2_Vbi_ei)*0.0+(((latb+latl)*FCw2_Vtnode_GND))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ei_Vtnode_GND);
  FCf1_Vbi_ei_Vbi_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+(latb*latl)*FCw_Vbi_ei_Vbi_ei)*FCw2+((latb*latl)*FCw_Vbi_ei)*FCw2_Vbi_ei+(((latb*latl)*FCw_Vbi_ei))*FCw2_Vbi_ei+((latb*latl)*FCw)*FCw2_Vbi_ei_Vbi_ei)/3.0-(((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))*0.0+((((((latb*latl)*FCw_Vbi_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vbi_ei+(latb+latl)*FCw2_Vbi_ei_Vbi_ei)/2.0-(((latb+latl)*FCw2_Vbi_ei)*0.0+(((latb+latl)*FCw2_Vbi_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ei_Vbi_ei);
  FCf1_Vbi_ei_Vbi_ci=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+(latb*latl)*FCw_Vbi_ei_Vbi_ci)*FCw2+((latb*latl)*FCw_Vbi_ei)*FCw2_Vbi_ci+(((latb*latl)*FCw_Vbi_ci))*FCw2_Vbi_ei+((latb*latl)*FCw)*FCw2_Vbi_ei_Vbi_ci)/3.0-(((((latb*latl)*FCw_Vbi_ei)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei))*0.0+((((((latb*latl)*FCw_Vbi_ci))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vbi_ei+(latb+latl)*FCw2_Vbi_ei_Vbi_ci)/2.0-(((latb+latl)*FCw2_Vbi_ei)*0.0+(((latb+latl)*FCw2_Vbi_ci))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ei_Vbi_ci);
#endif
FCf1_Vbi_ci=(((((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))/3.0)+(((latb+latl)*FCw2_Vbi_ci)/2.0))+FCw_Vbi_ci);
#if defined(_DERIVATE)
  FCf1_Vbi_ci_Vci_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+(latb*latl)*FCw_Vbi_ci_Vci_ei)*FCw2+((latb*latl)*FCw_Vbi_ci)*FCw2_Vci_ei+(((latb*latl)*FCw_Vci_ei))*FCw2_Vbi_ci+((latb*latl)*FCw)*FCw2_Vbi_ci_Vci_ei)/3.0-(((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))*0.0+((((((latb*latl)*FCw_Vci_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vci_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vbi_ci+(latb+latl)*FCw2_Vbi_ci_Vci_ei)/2.0-(((latb+latl)*FCw2_Vbi_ci)*0.0+(((latb+latl)*FCw2_Vci_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ci_Vci_ei);
  FCf1_Vbi_ci_Vtnode_GND=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+(latb*latl)*FCw_Vbi_ci_Vtnode_GND)*FCw2+((latb*latl)*FCw_Vbi_ci)*FCw2_Vtnode_GND+(((latb*latl)*FCw_Vtnode_GND))*FCw2_Vbi_ci+((latb*latl)*FCw)*FCw2_Vbi_ci_Vtnode_GND)/3.0-(((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))*0.0+((((((latb*latl)*FCw_Vtnode_GND))*FCw2)+(((latb*latl)*FCw)*FCw2_Vtnode_GND)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vbi_ci+(latb+latl)*FCw2_Vbi_ci_Vtnode_GND)/2.0-(((latb+latl)*FCw2_Vbi_ci)*0.0+(((latb+latl)*FCw2_Vtnode_GND))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ci_Vtnode_GND);
  FCf1_Vbi_ci_Vbi_ei=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+(latb*latl)*FCw_Vbi_ci_Vbi_ei)*FCw2+((latb*latl)*FCw_Vbi_ci)*FCw2_Vbi_ei+(((latb*latl)*FCw_Vbi_ei))*FCw2_Vbi_ci+((latb*latl)*FCw)*FCw2_Vbi_ci_Vbi_ei)/3.0-(((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))*0.0+((((((latb*latl)*FCw_Vbi_ei))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ei)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vbi_ci+(latb+latl)*FCw2_Vbi_ci_Vbi_ei)/2.0-(((latb+latl)*FCw2_Vbi_ci)*0.0+(((latb+latl)*FCw2_Vbi_ei))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ci_Vbi_ei);
  FCf1_Vbi_ci_Vbi_ci=(+(+((+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+(latb*latl)*FCw_Vbi_ci_Vbi_ci)*FCw2+((latb*latl)*FCw_Vbi_ci)*FCw2_Vbi_ci+(((latb*latl)*FCw_Vbi_ci))*FCw2_Vbi_ci+((latb*latl)*FCw)*FCw2_Vbi_ci_Vbi_ci)/3.0-(((((latb*latl)*FCw_Vbi_ci)*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci))*0.0+((((((latb*latl)*FCw_Vbi_ci))*FCw2)+(((latb*latl)*FCw)*FCw2_Vbi_ci)))*0.0+(((latb*latl)*FCw)*FCw2)*0.0)/3.0/3.0+2*(((latb*latl)*FCw)*FCw2)*0.0*0.0/3.0/3.0/3.0)+((+(+0.0+0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vbi_ci+(latb+latl)*FCw2_Vbi_ci_Vbi_ci)/2.0-(((latb+latl)*FCw2_Vbi_ci)*0.0+(((latb+latl)*FCw2_Vbi_ci))*0.0+((latb+latl)*FCw2)*0.0)/2.0/2.0+2*((latb+latl)*FCw2)*0.0*0.0/2.0/2.0/2.0))+FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCf1=((((((latb*latl)*FCw)*FCw2)/3.0)+(((latb+latl)*FCw2)/2.0))+FCw);
#if defined(_DERIVATEFORDDX)
FCdf1_dw_Vci_ei=(((latb*latl)*FCw2_Vci_ei)+((latb+latl)*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCdf1_dw_Vci_ei_Vci_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vci_ei+(latb*latl)*FCw2_Vci_ei_Vci_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+(latb+latl)*FCw_Vci_ei_Vci_ei))+0.0);
  FCdf1_dw_Vci_ei_Vtnode_GND=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vci_ei+(latb*latl)*FCw2_Vci_ei_Vtnode_GND)+(+(+0.0+0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+(latb+latl)*FCw_Vci_ei_Vtnode_GND))+0.0);
  FCdf1_dw_Vci_ei_Vbi_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vci_ei+(latb*latl)*FCw2_Vci_ei_Vbi_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+(latb+latl)*FCw_Vci_ei_Vbi_ei))+0.0);
  FCdf1_dw_Vci_ei_Vbi_ci=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vci_ei+(latb*latl)*FCw2_Vci_ei_Vbi_ci)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+(latb+latl)*FCw_Vci_ei_Vbi_ci))+0.0);
#endif
#if defined(_DERIVATE)
FCdf1_dw_Vtnode_GND=(((latb*latl)*FCw2_Vtnode_GND)+((latb+latl)*FCw_Vtnode_GND));
#endif
FCdf1_dw_Vbi_ei=(((latb*latl)*FCw2_Vbi_ei)+((latb+latl)*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCdf1_dw_Vbi_ei_Vci_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vbi_ei+(latb*latl)*FCw2_Vbi_ei_Vci_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+(latb+latl)*FCw_Vbi_ei_Vci_ei))+0.0);
  FCdf1_dw_Vbi_ei_Vtnode_GND=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vbi_ei+(latb*latl)*FCw2_Vbi_ei_Vtnode_GND)+(+(+0.0+0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+(latb+latl)*FCw_Vbi_ei_Vtnode_GND))+0.0);
  FCdf1_dw_Vbi_ei_Vbi_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vbi_ei+(latb*latl)*FCw2_Vbi_ei_Vbi_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+(latb+latl)*FCw_Vbi_ei_Vbi_ei))+0.0);
  FCdf1_dw_Vbi_ei_Vbi_ci=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vbi_ei+(latb*latl)*FCw2_Vbi_ei_Vbi_ci)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+(latb+latl)*FCw_Vbi_ei_Vbi_ci))+0.0);
#endif
FCdf1_dw_Vbi_ci=(((latb*latl)*FCw2_Vbi_ci)+((latb+latl)*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCdf1_dw_Vbi_ci_Vci_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vci_ei+0.0*FCw2_Vbi_ci+(latb*latl)*FCw2_Vbi_ci_Vci_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+(latb+latl)*FCw_Vbi_ci_Vci_ei))+0.0);
  FCdf1_dw_Vbi_ci_Vtnode_GND=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vtnode_GND+0.0*FCw2_Vbi_ci+(latb*latl)*FCw2_Vbi_ci_Vtnode_GND)+(+(+0.0+0.0)*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+(latb+latl)*FCw_Vbi_ci_Vtnode_GND))+0.0);
  FCdf1_dw_Vbi_ci_Vbi_ei=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ei+0.0*FCw2_Vbi_ci+(latb*latl)*FCw2_Vbi_ci_Vbi_ei)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+(latb+latl)*FCw_Vbi_ci_Vbi_ei))+0.0);
  FCdf1_dw_Vbi_ci_Vbi_ci=(+(+(+(+0.0*latl+0.0*0.0+0.0*0.0+latb*0.0)*FCw2+0.0*FCw2_Vbi_ci+0.0*FCw2_Vbi_ci+(latb*latl)*FCw2_Vbi_ci_Vbi_ci)+(+(+0.0+0.0)*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+(latb+latl)*FCw_Vbi_ci_Vbi_ci))+0.0);
#endif
#endif
FCdf1_dw=((((latb*latl)*FCw2)+((latb+latl)*FCw))+1.0);
#if defined(_DERIVATEFORDDX)
z_Vci_ei=(latb*FCw_Vci_ei);
#if defined(_DERIVATE)
  z_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei);
  z_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND);
  z_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei);
  z_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
z_Vtnode_GND=(latb*FCw_Vtnode_GND);
#endif
z_Vbi_ei=(latb*FCw_Vbi_ei);
#if defined(_DERIVATE)
  z_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei);
  z_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND);
  z_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei);
  z_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci);
#endif
z_Vbi_ci=(latb*FCw_Vbi_ci);
#if defined(_DERIVATE)
  z_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei);
  z_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND);
  z_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei);
  z_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
z=(latb*FCw);
{
double m00_logE(d00_logE0,(1+(latb*FCw)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1+(latb*FCw)))
#endif
#if defined(_DERIVATEFORDDX)
lnzb_Vci_ei=(latb*FCw_Vci_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vci_ei_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei)));
  lnzb_Vci_ei_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND)));
  lnzb_Vci_ei_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei)));
  lnzb_Vci_ei_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci)));
#endif
#if defined(_DERIVATE)
lnzb_Vtnode_GND=(latb*FCw_Vtnode_GND)*d10_logE0;
#endif
lnzb_Vbi_ei=(latb*FCw_Vbi_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vbi_ei_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei)));
  lnzb_Vbi_ei_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND)));
  lnzb_Vbi_ei_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei)));
  lnzb_Vbi_ei_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci)));
#endif
lnzb_Vbi_ci=(latb*FCw_Vbi_ci)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vbi_ci_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei)));
  lnzb_Vbi_ci_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND)));
  lnzb_Vbi_ci_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei)));
  lnzb_Vbi_ci_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci)));
#endif
#endif
lnzb=d00_logE0;
}
if
((z>1.0e-6))
{
#if defined(_DERIVATEFORDDX)
x_Vci_ei=z_Vci_ei;
#if defined(_DERIVATE)
  x_Vci_ei_Vci_ei=(+0.0+z_Vci_ei_Vci_ei);
  x_Vci_ei_Vtnode_GND=(+0.0+z_Vci_ei_Vtnode_GND);
  x_Vci_ei_Vbi_ei=(+0.0+z_Vci_ei_Vbi_ei);
  x_Vci_ei_Vbi_ci=(+0.0+z_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
x_Vtnode_GND=z_Vtnode_GND;
#endif
x_Vbi_ei=z_Vbi_ei;
#if defined(_DERIVATE)
  x_Vbi_ei_Vci_ei=(+0.0+z_Vbi_ei_Vci_ei);
  x_Vbi_ei_Vtnode_GND=(+0.0+z_Vbi_ei_Vtnode_GND);
  x_Vbi_ei_Vbi_ei=(+0.0+z_Vbi_ei_Vbi_ei);
  x_Vbi_ei_Vbi_ci=(+0.0+z_Vbi_ei_Vbi_ci);
#endif
x_Vbi_ci=z_Vbi_ci;
#if defined(_DERIVATE)
  x_Vbi_ci_Vci_ei=(+0.0+z_Vbi_ci_Vci_ei);
  x_Vbi_ci_Vtnode_GND=(+0.0+z_Vbi_ci_Vtnode_GND);
  x_Vbi_ci_Vbi_ei=(+0.0+z_Vbi_ci_Vbi_ei);
  x_Vbi_ci_Vbi_ci=(+0.0+z_Vbi_ci_Vbi_ci);
#endif
#endif
x=(1.0+z);
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+x_Vbi_ei_Vbi_ei*x+x_Vbi_ei*x_Vbi_ei+x_Vbi_ei*x_Vbi_ei+x*x_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+x_Vbi_ei_Vbi_ci*x+x_Vbi_ei*x_Vbi_ci+x_Vbi_ci*x_Vbi_ei+x*x_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+x_Vbi_ei_Vci_ei*x+x_Vbi_ei*x_Vci_ei+x_Vci_ei*x_Vbi_ei+x*x_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+x_Vbi_ei_Vtnode_GND*x+x_Vbi_ei*x_Vtnode_GND+x_Vtnode_GND*x_Vbi_ei+x*x_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+x_Vbi_ci_Vbi_ei*x+x_Vbi_ci*x_Vbi_ei+x_Vbi_ei*x_Vbi_ci+x*x_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+x_Vbi_ci_Vbi_ci*x+x_Vbi_ci*x_Vbi_ci+x_Vbi_ci*x_Vbi_ci+x*x_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+x_Vbi_ci_Vci_ei*x+x_Vbi_ci*x_Vci_ei+x_Vci_ei*x_Vbi_ci+x*x_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+x_Vbi_ci_Vtnode_GND*x+x_Vbi_ci*x_Vtnode_GND+x_Vtnode_GND*x_Vbi_ci+x*x_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+x_Vci_ei_Vbi_ei*x+x_Vci_ei*x_Vbi_ei+x_Vbi_ei*x_Vci_ei+x*x_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+x_Vci_ei_Vbi_ci*x+x_Vci_ei*x_Vbi_ci+x_Vbi_ci*x_Vci_ei+x*x_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+x_Vci_ei_Vci_ei*x+x_Vci_ei*x_Vci_ei+x_Vci_ei*x_Vci_ei+x*x_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+x_Vci_ei_Vtnode_GND*x+x_Vci_ei*x_Vtnode_GND+x_Vtnode_GND*x_Vci_ei+x*x_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
#endif
#endif
a=(x*x);
#if defined(_DERIVATEFORDDX)
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei))));
#if defined(_DERIVATE)
  a2_Vbi_ei_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vbi_ei*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vbi_ei)-0.0))+0.0));
  a2_Vbi_ei_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vbi_ci*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vbi_ci)-0.0))+0.0));
  a2_Vbi_ei_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vci_ei*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vci_ei)-0.0))+0.0));
  a2_Vbi_ei_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vtnode_GND)-0.0))+0.0));
#endif
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci))));
#if defined(_DERIVATE)
  a2_Vbi_ci_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vbi_ei*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vbi_ei)-0.0))+0.0));
  a2_Vbi_ci_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vbi_ci*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vbi_ci)-0.0))+0.0));
  a2_Vbi_ci_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vci_ei*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vci_ei)-0.0))+0.0));
  a2_Vbi_ci_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vtnode_GND)-0.0))+0.0));
#endif
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei))));
#if defined(_DERIVATE)
  a2_Vci_ei_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vbi_ei*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vbi_ei)-0.0))+0.0));
  a2_Vci_ei_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vbi_ci*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vbi_ci)-0.0))+0.0));
  a2_Vci_ei_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vci_ei*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vci_ei)-0.0))+0.0));
  a2_Vci_ei_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vtnode_GND)-0.0))+0.0));
#endif
#if defined(_DERIVATE)
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vtnode_GND))));
#endif
#endif
a2=(0.250*((a*((2.0*lnzb)-1.0))+1.0));
#if defined(_DERIVATEFORDDX)
a3_Vbi_ei=(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))/9.0);
#if defined(_DERIVATE)
  a3_Vbi_ei_Vbi_ei=((+(+(+a_Vbi_ei_Vbi_ei*x+a_Vbi_ei*x_Vbi_ei+a_Vbi_ei*x_Vbi_ei+a*x_Vbi_ei_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vbi_ci=((+(+(+a_Vbi_ei_Vbi_ci*x+a_Vbi_ei*x_Vbi_ci+a_Vbi_ci*x_Vbi_ei+a*x_Vbi_ei_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vci_ei=((+(+(+a_Vbi_ei_Vci_ei*x+a_Vbi_ei*x_Vci_ei+a_Vci_ei*x_Vbi_ei+a*x_Vbi_ei_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vtnode_GND=((+(+(+a_Vbi_ei_Vtnode_GND*x+a_Vbi_ei*x_Vtnode_GND+a_Vtnode_GND*x_Vbi_ei+a*x_Vbi_ei_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
a3_Vbi_ci=(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))/9.0);
#if defined(_DERIVATE)
  a3_Vbi_ci_Vbi_ei=((+(+(+a_Vbi_ci_Vbi_ei*x+a_Vbi_ci*x_Vbi_ei+a_Vbi_ei*x_Vbi_ci+a*x_Vbi_ci_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vbi_ci=((+(+(+a_Vbi_ci_Vbi_ci*x+a_Vbi_ci*x_Vbi_ci+a_Vbi_ci*x_Vbi_ci+a*x_Vbi_ci_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vci_ei=((+(+(+a_Vbi_ci_Vci_ei*x+a_Vbi_ci*x_Vci_ei+a_Vci_ei*x_Vbi_ci+a*x_Vbi_ci_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vtnode_GND=((+(+(+a_Vbi_ci_Vtnode_GND*x+a_Vbi_ci*x_Vtnode_GND+a_Vtnode_GND*x_Vbi_ci+a*x_Vbi_ci_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
a3_Vci_ei=(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))/9.0);
#if defined(_DERIVATE)
  a3_Vci_ei_Vbi_ei=((+(+(+a_Vci_ei_Vbi_ei*x+a_Vci_ei*x_Vbi_ei+a_Vbi_ei*x_Vci_ei+a*x_Vci_ei_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vbi_ci=((+(+(+a_Vci_ei_Vbi_ci*x+a_Vci_ei*x_Vbi_ci+a_Vbi_ci*x_Vci_ei+a*x_Vci_ei_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vci_ei=((+(+(+a_Vci_ei_Vci_ei*x+a_Vci_ei*x_Vci_ei+a_Vci_ei*x_Vci_ei+a*x_Vci_ei_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vtnode_GND=((+(+(+a_Vci_ei_Vtnode_GND*x+a_Vci_ei*x_Vtnode_GND+a_Vtnode_GND*x_Vci_ei+a*x_Vci_ei_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
#if defined(_DERIVATE)
a3_Vtnode_GND=(((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vtnode_GND)))/9.0);
#endif
#endif
a3=((((a*x)*((3.0*lnzb)-1.0))+1.0)/9.0);
r=(latl/latb);
#if defined(_DERIVATEFORDDX)
FCf2_Vbi_ei=((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latb);
#if defined(_DERIVATE)
  FCf2_Vbi_ei_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vbi_ei))/latb-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vbi_ci))/latb-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vci_ei))/latb-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vtnode_GND))/latb-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
#endif
FCf2_Vbi_ci=((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latb);
#if defined(_DERIVATE)
  FCf2_Vbi_ci_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vbi_ei))/latb-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vbi_ci))/latb-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vci_ei))/latb-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vtnode_GND))/latb-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
#endif
FCf2_Vci_ei=((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latb);
#if defined(_DERIVATE)
  FCf2_Vci_ei_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vci_ei+r*a3_Vci_ei_Vbi_ei))/latb-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vci_ei+r*a3_Vci_ei_Vbi_ci))/latb-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vci_ei+r*a3_Vci_ei_Vci_ei))/latb-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vci_ei+r*a3_Vci_ei_Vtnode_GND))/latb-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latb/latb+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latb/latb/latb);
#endif
#if defined(_DERIVATE)
FCf2_Vtnode_GND=((((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latb);
#endif
#endif
FCf2=((((1.0-r)*a2)+(r*a3))/latb);
#if defined(_DERIVATEFORDDX)
FCdf2_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vci_ei));
#if defined(_DERIVATE)
  FCdf2_dw_Vci_ei_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+r*a_Vci_ei_Vci_ei))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vci_ei);
  FCdf2_dw_Vci_ei_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+r*a_Vci_ei_Vtnode_GND))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vtnode_GND);
  FCdf2_dw_Vci_ei_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+r*a_Vci_ei_Vbi_ei))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vbi_ei);
  FCdf2_dw_Vci_ei_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+r*a_Vci_ei_Vbi_ci))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdf2_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vtnode_GND));
#endif
FCdf2_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vbi_ei));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ei_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+r*a_Vbi_ei_Vci_ei))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vci_ei);
  FCdf2_dw_Vbi_ei_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+r*a_Vbi_ei_Vtnode_GND))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vtnode_GND);
  FCdf2_dw_Vbi_ei_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+r*a_Vbi_ei_Vbi_ei))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vbi_ei);
  FCdf2_dw_Vbi_ei_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+r*a_Vbi_ei_Vbi_ci))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vbi_ci);
#endif
FCdf2_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vbi_ci));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ci_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+r*a_Vbi_ci_Vci_ei))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vci_ei);
  FCdf2_dw_Vbi_ci_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+r*a_Vbi_ci_Vtnode_GND))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vtnode_GND);
  FCdf2_dw_Vbi_ci_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+r*a_Vbi_ci_Vbi_ei))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vbi_ei);
  FCdf2_dw_Vbi_ci_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+r*a_Vbi_ci_Vbi_ci))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vbi_ci);
#endif
#endif
FCdf2_dw=((((1.0-r)*x)+(r*a))*lnzb);
}
else
{
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+z_Vbi_ei_Vbi_ei*z+z_Vbi_ei*z_Vbi_ei+z_Vbi_ei*z_Vbi_ei+z*z_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+z_Vbi_ei_Vbi_ci*z+z_Vbi_ei*z_Vbi_ci+z_Vbi_ci*z_Vbi_ei+z*z_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+z_Vbi_ei_Vci_ei*z+z_Vbi_ei*z_Vci_ei+z_Vci_ei*z_Vbi_ei+z*z_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+z_Vbi_ei_Vtnode_GND*z+z_Vbi_ei*z_Vtnode_GND+z_Vtnode_GND*z_Vbi_ei+z*z_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+z_Vbi_ci_Vbi_ei*z+z_Vbi_ci*z_Vbi_ei+z_Vbi_ei*z_Vbi_ci+z*z_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+z_Vbi_ci_Vbi_ci*z+z_Vbi_ci*z_Vbi_ci+z_Vbi_ci*z_Vbi_ci+z*z_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+z_Vbi_ci_Vci_ei*z+z_Vbi_ci*z_Vci_ei+z_Vci_ei*z_Vbi_ci+z*z_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+z_Vbi_ci_Vtnode_GND*z+z_Vbi_ci*z_Vtnode_GND+z_Vtnode_GND*z_Vbi_ci+z*z_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+z_Vci_ei_Vbi_ei*z+z_Vci_ei*z_Vbi_ei+z_Vbi_ei*z_Vci_ei+z*z_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+z_Vci_ei_Vbi_ci*z+z_Vci_ei*z_Vbi_ci+z_Vbi_ci*z_Vci_ei+z*z_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+z_Vci_ei_Vci_ei*z+z_Vci_ei*z_Vci_ei+z_Vci_ei*z_Vci_ei+z*z_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+z_Vci_ei_Vtnode_GND*z+z_Vci_ei*z_Vtnode_GND+z_Vtnode_GND*z_Vci_ei+z*z_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
#endif
#endif
a=(z*z);
#if defined(_DERIVATEFORDDX)
a2_Vbi_ei=((z_Vbi_ei-(0.25*a_Vbi_ei))+(((0.10*z_Vbi_ei)*a)+((0.10*z)*a_Vbi_ei)));
#if defined(_DERIVATE)
  a2_Vbi_ei_Vbi_ei=(+(+(+0.0+z_Vbi_ei_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vbi_ei)*a+(0.10*z_Vbi_ei)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vbi_ei));
  a2_Vbi_ei_Vbi_ci=(+(+(+0.0+z_Vbi_ei_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vbi_ci)*a+(0.10*z_Vbi_ei)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vbi_ci));
  a2_Vbi_ei_Vci_ei=(+(+(+0.0+z_Vbi_ei_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vci_ei)*a+(0.10*z_Vbi_ei)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vci_ei));
  a2_Vbi_ei_Vtnode_GND=(+(+(+0.0+z_Vbi_ei_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vtnode_GND)*a+(0.10*z_Vbi_ei)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vtnode_GND));
#endif
a2_Vbi_ci=((z_Vbi_ci-(0.25*a_Vbi_ci))+(((0.10*z_Vbi_ci)*a)+((0.10*z)*a_Vbi_ci)));
#if defined(_DERIVATE)
  a2_Vbi_ci_Vbi_ei=(+(+(+0.0+z_Vbi_ci_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vbi_ei)*a+(0.10*z_Vbi_ci)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vbi_ei));
  a2_Vbi_ci_Vbi_ci=(+(+(+0.0+z_Vbi_ci_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vbi_ci)*a+(0.10*z_Vbi_ci)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vbi_ci));
  a2_Vbi_ci_Vci_ei=(+(+(+0.0+z_Vbi_ci_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vci_ei)*a+(0.10*z_Vbi_ci)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vci_ei));
  a2_Vbi_ci_Vtnode_GND=(+(+(+0.0+z_Vbi_ci_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vtnode_GND)*a+(0.10*z_Vbi_ci)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vtnode_GND));
#endif
a2_Vci_ei=((z_Vci_ei-(0.25*a_Vci_ei))+(((0.10*z_Vci_ei)*a)+((0.10*z)*a_Vci_ei)));
#if defined(_DERIVATE)
  a2_Vci_ei_Vbi_ei=(+(+(+0.0+z_Vci_ei_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.25*a_Vci_ei_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vci_ei+0.10*z_Vci_ei_Vbi_ei)*a+(0.10*z_Vci_ei)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vbi_ei));
  a2_Vci_ei_Vbi_ci=(+(+(+0.0+z_Vci_ei_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.25*a_Vci_ei_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vci_ei+0.10*z_Vci_ei_Vbi_ci)*a+(0.10*z_Vci_ei)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vbi_ci));
  a2_Vci_ei_Vci_ei=(+(+(+0.0+z_Vci_ei_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.25*a_Vci_ei_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vci_ei+0.10*z_Vci_ei_Vci_ei)*a+(0.10*z_Vci_ei)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vci_ei));
  a2_Vci_ei_Vtnode_GND=(+(+(+0.0+z_Vci_ei_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.25*a_Vci_ei_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vci_ei+0.10*z_Vci_ei_Vtnode_GND)*a+(0.10*z_Vci_ei)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
a2_Vtnode_GND=((z_Vtnode_GND-(0.25*a_Vtnode_GND))+(((0.10*z_Vtnode_GND)*a)+((0.10*z)*a_Vtnode_GND)));
#endif
#endif
a2=(((3.0+z)-(0.25*a))+((0.10*z)*a));
#if defined(_DERIVATEFORDDX)
a3_Vbi_ei=(((2.0*z_Vbi_ei)+(0.75*a_Vbi_ei))-(((0.20*a_Vbi_ei)*z)+((0.20*a)*z_Vbi_ei)));
#if defined(_DERIVATE)
  a3_Vbi_ei_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vbi_ei)*z+(0.20*a_Vbi_ei)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vbi_ei));
  a3_Vbi_ei_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vbi_ci)*z+(0.20*a_Vbi_ei)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vbi_ci));
  a3_Vbi_ei_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vci_ei)*z+(0.20*a_Vbi_ei)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vci_ei));
  a3_Vbi_ei_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vtnode_GND)*z+(0.20*a_Vbi_ei)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vtnode_GND));
#endif
a3_Vbi_ci=(((2.0*z_Vbi_ci)+(0.75*a_Vbi_ci))-(((0.20*a_Vbi_ci)*z)+((0.20*a)*z_Vbi_ci)));
#if defined(_DERIVATE)
  a3_Vbi_ci_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vbi_ei)*z+(0.20*a_Vbi_ci)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vbi_ei));
  a3_Vbi_ci_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vbi_ci)*z+(0.20*a_Vbi_ci)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vbi_ci));
  a3_Vbi_ci_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vci_ei)*z+(0.20*a_Vbi_ci)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vci_ei));
  a3_Vbi_ci_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vtnode_GND)*z+(0.20*a_Vbi_ci)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vtnode_GND));
#endif
a3_Vci_ei=(((2.0*z_Vci_ei)+(0.75*a_Vci_ei))-(((0.20*a_Vci_ei)*z)+((0.20*a)*z_Vci_ei)));
#if defined(_DERIVATE)
  a3_Vci_ei_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vci_ei+2.0*z_Vci_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.75*a_Vci_ei_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.20*a_Vci_ei_Vbi_ei)*z+(0.20*a_Vci_ei)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vbi_ei));
  a3_Vci_ei_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vci_ei+2.0*z_Vci_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.75*a_Vci_ei_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.20*a_Vci_ei_Vbi_ci)*z+(0.20*a_Vci_ei)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vbi_ci));
  a3_Vci_ei_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vci_ei+2.0*z_Vci_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.75*a_Vci_ei_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.20*a_Vci_ei_Vci_ei)*z+(0.20*a_Vci_ei)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vci_ei));
  a3_Vci_ei_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vci_ei+2.0*z_Vci_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.75*a_Vci_ei_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.20*a_Vci_ei_Vtnode_GND)*z+(0.20*a_Vci_ei)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
a3_Vtnode_GND=(((2.0*z_Vtnode_GND)+(0.75*a_Vtnode_GND))-(((0.20*a_Vtnode_GND)*z)+((0.20*a)*z_Vtnode_GND)));
#endif
#endif
a3=(((2.0*z)+(0.75*a))-((0.20*a)*z));
#if defined(_DERIVATEFORDDX)
FCf2_Vbi_ei=(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))/6.0);
#if defined(_DERIVATE)
  FCf2_Vbi_ei_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ei+latb*a2_Vbi_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ei+latl*a3_Vbi_ei_Vbi_ei))*FCw+((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw_Vbi_ei+(((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw_Vbi_ei+((latb*a2)+(latl*a3))*FCw_Vbi_ei_Vbi_ei)*FCw+((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw_Vbi_ei+((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw_Vbi_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei_Vbi_ei)/6.0-(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ei_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ei+latb*a2_Vbi_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ei+latl*a3_Vbi_ei_Vbi_ci))*FCw+((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw_Vbi_ci+(((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw_Vbi_ei+((latb*a2)+(latl*a3))*FCw_Vbi_ei_Vbi_ci)*FCw+((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw_Vbi_ci+((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw_Vbi_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei_Vbi_ci)/6.0-(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ei_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ei+latb*a2_Vbi_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ei+latl*a3_Vbi_ei_Vci_ei))*FCw+((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw_Vci_ei+(((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw_Vbi_ei+((latb*a2)+(latl*a3))*FCw_Vbi_ei_Vci_ei)*FCw+((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw_Vci_ei+((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw_Vbi_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei_Vci_ei)/6.0-(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ei_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ei+latb*a2_Vbi_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ei+latl*a3_Vbi_ei_Vtnode_GND))*FCw+((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw_Vtnode_GND+(((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw_Vbi_ei+((latb*a2)+(latl*a3))*FCw_Vbi_ei_Vtnode_GND)*FCw+((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw_Vtnode_GND+((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw_Vbi_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei_Vtnode_GND)/6.0-(((((((latb*a2_Vbi_ei)+(latl*a3_Vbi_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
FCf2_Vbi_ci=(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))/6.0);
#if defined(_DERIVATE)
  FCf2_Vbi_ci_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ci+latb*a2_Vbi_ci_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ci+latl*a3_Vbi_ci_Vbi_ei))*FCw+((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw_Vbi_ei+(((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw_Vbi_ci+((latb*a2)+(latl*a3))*FCw_Vbi_ci_Vbi_ei)*FCw+((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw_Vbi_ei+((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw_Vbi_ci+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci_Vbi_ei)/6.0-(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ci_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ci+latb*a2_Vbi_ci_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ci+latl*a3_Vbi_ci_Vbi_ci))*FCw+((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw_Vbi_ci+(((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw_Vbi_ci+((latb*a2)+(latl*a3))*FCw_Vbi_ci_Vbi_ci)*FCw+((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw_Vbi_ci+((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw_Vbi_ci+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci_Vbi_ci)/6.0-(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ci_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ci+latb*a2_Vbi_ci_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ci+latl*a3_Vbi_ci_Vci_ei))*FCw+((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw_Vci_ei+(((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw_Vbi_ci+((latb*a2)+(latl*a3))*FCw_Vbi_ci_Vci_ei)*FCw+((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw_Vci_ei+((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw_Vbi_ci+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci_Vci_ei)/6.0-(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vbi_ci_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ci+latb*a2_Vbi_ci_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ci+latl*a3_Vbi_ci_Vtnode_GND))*FCw+((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw_Vtnode_GND+(((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw_Vbi_ci+((latb*a2)+(latl*a3))*FCw_Vbi_ci_Vtnode_GND)*FCw+((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw_Vtnode_GND+((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw_Vbi_ci+(((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci_Vtnode_GND)/6.0-(((((((latb*a2_Vbi_ci)+(latl*a3_Vbi_ci))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
FCf2_Vci_ei=(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))/6.0);
#if defined(_DERIVATE)
  FCf2_Vci_ei_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vci_ei+latb*a2_Vci_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vci_ei+latl*a3_Vci_ei_Vbi_ei))*FCw+((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw_Vbi_ei+(((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw_Vci_ei+((latb*a2)+(latl*a3))*FCw_Vci_ei_Vbi_ei)*FCw+((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw_Vbi_ei+((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw_Vci_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei_Vbi_ei)/6.0-(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latb*a2_Vbi_ei))+((latl*a3_Vbi_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vci_ei_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vci_ei+latb*a2_Vci_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vci_ei+latl*a3_Vci_ei_Vbi_ci))*FCw+((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw_Vbi_ci+(((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw_Vci_ei+((latb*a2)+(latl*a3))*FCw_Vci_ei_Vbi_ci)*FCw+((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw_Vbi_ci+((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw_Vci_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei_Vbi_ci)/6.0-(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latb*a2_Vbi_ci))+((latl*a3_Vbi_ci)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vbi_ci)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vci_ei_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vci_ei+latb*a2_Vci_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vci_ei+latl*a3_Vci_ei_Vci_ei))*FCw+((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw_Vci_ei+(((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw_Vci_ei+((latb*a2)+(latl*a3))*FCw_Vci_ei_Vci_ei)*FCw+((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw_Vci_ei+((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw_Vci_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei_Vci_ei)/6.0-(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latb*a2_Vci_ei))+((latl*a3_Vci_ei)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf2_Vci_ei_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vci_ei+latb*a2_Vci_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vci_ei+latl*a3_Vci_ei_Vtnode_GND))*FCw+((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw_Vtnode_GND+(((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw_Vci_ei+((latb*a2)+(latl*a3))*FCw_Vci_ei_Vtnode_GND)*FCw+((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw_Vtnode_GND+((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw_Vci_ei+(((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei_Vtnode_GND)/6.0-(((((((latb*a2_Vci_ei)+(latl*a3_Vci_ei))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vci_ei))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latb*a2_Vtnode_GND))+((latl*a3_Vtnode_GND)))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND)))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latb*a2)+(latl*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
#if defined(_DERIVATE)
FCf2_Vtnode_GND=(((((((latb*a2_Vtnode_GND)+(latl*a3_Vtnode_GND))*FCw)+(((latb*a2)+(latl*a3))*FCw_Vtnode_GND))*FCw)+((((latb*a2)+(latl*a3))*FCw)*FCw_Vtnode_GND))/6.0);
#endif
#endif
FCf2=(((((latb*a2)+(latl*a3))*FCw)*FCw)/6.0);
#if defined(_DERIVATEFORDDX)
FCdf2_dw_Vci_ei=(((((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb)+(((1+(latl*FCw))*(1+z))*lnzb_Vci_ei));
#if defined(_DERIVATE)
  FCdf2_dw_Vci_ei_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei))*(1+z)+(latl*FCw_Vci_ei)*z_Vci_ei+((latl*FCw_Vci_ei))*z_Vci_ei+(1+(latl*FCw))*(+0.0+z_Vci_ei_Vci_ei))*lnzb+(((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb_Vci_ei+(((((latl*FCw_Vci_ei))*(1+z))+((1+(latl*FCw))*z_Vci_ei)))*lnzb_Vci_ei+((1+(latl*FCw))*(1+z))*lnzb_Vci_ei_Vci_ei);
  FCdf2_dw_Vci_ei_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND))*(1+z)+(latl*FCw_Vci_ei)*z_Vtnode_GND+((latl*FCw_Vtnode_GND))*z_Vci_ei+(1+(latl*FCw))*(+0.0+z_Vci_ei_Vtnode_GND))*lnzb+(((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb_Vtnode_GND+(((((latl*FCw_Vtnode_GND))*(1+z))+((1+(latl*FCw))*z_Vtnode_GND)))*lnzb_Vci_ei+((1+(latl*FCw))*(1+z))*lnzb_Vci_ei_Vtnode_GND);
  FCdf2_dw_Vci_ei_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei))*(1+z)+(latl*FCw_Vci_ei)*z_Vbi_ei+((latl*FCw_Vbi_ei))*z_Vci_ei+(1+(latl*FCw))*(+0.0+z_Vci_ei_Vbi_ei))*lnzb+(((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb_Vbi_ei+(((((latl*FCw_Vbi_ei))*(1+z))+((1+(latl*FCw))*z_Vbi_ei)))*lnzb_Vci_ei+((1+(latl*FCw))*(1+z))*lnzb_Vci_ei_Vbi_ei);
  FCdf2_dw_Vci_ei_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci))*(1+z)+(latl*FCw_Vci_ei)*z_Vbi_ci+((latl*FCw_Vbi_ci))*z_Vci_ei+(1+(latl*FCw))*(+0.0+z_Vci_ei_Vbi_ci))*lnzb+(((latl*FCw_Vci_ei)*(1+z))+((1+(latl*FCw))*z_Vci_ei))*lnzb_Vbi_ci+(((((latl*FCw_Vbi_ci))*(1+z))+((1+(latl*FCw))*z_Vbi_ci)))*lnzb_Vci_ei+((1+(latl*FCw))*(1+z))*lnzb_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdf2_dw_Vtnode_GND=(((((latl*FCw_Vtnode_GND)*(1+z))+((1+(latl*FCw))*z_Vtnode_GND))*lnzb)+(((1+(latl*FCw))*(1+z))*lnzb_Vtnode_GND));
#endif
FCdf2_dw_Vbi_ei=(((((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb)+(((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ei_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei))*(1+z)+(latl*FCw_Vbi_ei)*z_Vci_ei+((latl*FCw_Vci_ei))*z_Vbi_ei+(1+(latl*FCw))*(+0.0+z_Vbi_ei_Vci_ei))*lnzb+(((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb_Vci_ei+(((((latl*FCw_Vci_ei))*(1+z))+((1+(latl*FCw))*z_Vci_ei)))*lnzb_Vbi_ei+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei_Vci_ei);
  FCdf2_dw_Vbi_ei_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND))*(1+z)+(latl*FCw_Vbi_ei)*z_Vtnode_GND+((latl*FCw_Vtnode_GND))*z_Vbi_ei+(1+(latl*FCw))*(+0.0+z_Vbi_ei_Vtnode_GND))*lnzb+(((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb_Vtnode_GND+(((((latl*FCw_Vtnode_GND))*(1+z))+((1+(latl*FCw))*z_Vtnode_GND)))*lnzb_Vbi_ei+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei_Vtnode_GND);
  FCdf2_dw_Vbi_ei_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei))*(1+z)+(latl*FCw_Vbi_ei)*z_Vbi_ei+((latl*FCw_Vbi_ei))*z_Vbi_ei+(1+(latl*FCw))*(+0.0+z_Vbi_ei_Vbi_ei))*lnzb+(((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb_Vbi_ei+(((((latl*FCw_Vbi_ei))*(1+z))+((1+(latl*FCw))*z_Vbi_ei)))*lnzb_Vbi_ei+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei_Vbi_ei);
  FCdf2_dw_Vbi_ei_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci))*(1+z)+(latl*FCw_Vbi_ei)*z_Vbi_ci+((latl*FCw_Vbi_ci))*z_Vbi_ei+(1+(latl*FCw))*(+0.0+z_Vbi_ei_Vbi_ci))*lnzb+(((latl*FCw_Vbi_ei)*(1+z))+((1+(latl*FCw))*z_Vbi_ei))*lnzb_Vbi_ci+(((((latl*FCw_Vbi_ci))*(1+z))+((1+(latl*FCw))*z_Vbi_ci)))*lnzb_Vbi_ei+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ei_Vbi_ci);
#endif
FCdf2_dw_Vbi_ci=(((((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb)+(((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ci_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei))*(1+z)+(latl*FCw_Vbi_ci)*z_Vci_ei+((latl*FCw_Vci_ei))*z_Vbi_ci+(1+(latl*FCw))*(+0.0+z_Vbi_ci_Vci_ei))*lnzb+(((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb_Vci_ei+(((((latl*FCw_Vci_ei))*(1+z))+((1+(latl*FCw))*z_Vci_ei)))*lnzb_Vbi_ci+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci_Vci_ei);
  FCdf2_dw_Vbi_ci_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND))*(1+z)+(latl*FCw_Vbi_ci)*z_Vtnode_GND+((latl*FCw_Vtnode_GND))*z_Vbi_ci+(1+(latl*FCw))*(+0.0+z_Vbi_ci_Vtnode_GND))*lnzb+(((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb_Vtnode_GND+(((((latl*FCw_Vtnode_GND))*(1+z))+((1+(latl*FCw))*z_Vtnode_GND)))*lnzb_Vbi_ci+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci_Vtnode_GND);
  FCdf2_dw_Vbi_ci_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei))*(1+z)+(latl*FCw_Vbi_ci)*z_Vbi_ei+((latl*FCw_Vbi_ei))*z_Vbi_ci+(1+(latl*FCw))*(+0.0+z_Vbi_ci_Vbi_ei))*lnzb+(((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb_Vbi_ei+(((((latl*FCw_Vbi_ei))*(1+z))+((1+(latl*FCw))*z_Vbi_ei)))*lnzb_Vbi_ci+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci_Vbi_ei);
  FCdf2_dw_Vbi_ci_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci))*(1+z)+(latl*FCw_Vbi_ci)*z_Vbi_ci+((latl*FCw_Vbi_ci))*z_Vbi_ci+(1+(latl*FCw))*(+0.0+z_Vbi_ci_Vbi_ci))*lnzb+(((latl*FCw_Vbi_ci)*(1+z))+((1+(latl*FCw))*z_Vbi_ci))*lnzb_Vbi_ci+(((((latl*FCw_Vbi_ci))*(1+z))+((1+(latl*FCw))*z_Vbi_ci)))*lnzb_Vbi_ci+((1+(latl*FCw))*(1+z))*lnzb_Vbi_ci_Vbi_ci);
#endif
#endif
FCdf2_dw=(((1+(latl*FCw))*(1+z))*lnzb);
}
#if defined(_DERIVATEFORDDX)
z_Vci_ei=(latl*FCw_Vci_ei);
#if defined(_DERIVATE)
  z_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei);
  z_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND);
  z_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei);
  z_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
z_Vtnode_GND=(latl*FCw_Vtnode_GND);
#endif
z_Vbi_ei=(latl*FCw_Vbi_ei);
#if defined(_DERIVATE)
  z_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei);
  z_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND);
  z_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei);
  z_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci);
#endif
z_Vbi_ci=(latl*FCw_Vbi_ci);
#if defined(_DERIVATE)
  z_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei);
  z_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND);
  z_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei);
  z_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
z=(latl*FCw);
{
double m00_logE(d00_logE0,(1+(latl*FCw)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1+(latl*FCw)))
#endif
#if defined(_DERIVATEFORDDX)
lnzb_Vci_ei=(latl*FCw_Vci_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vci_ei_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei)));
  lnzb_Vci_ei_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND)));
  lnzb_Vci_ei_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei)));
  lnzb_Vci_ei_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci)));
#endif
#if defined(_DERIVATE)
lnzb_Vtnode_GND=(latl*FCw_Vtnode_GND)*d10_logE0;
#endif
lnzb_Vbi_ei=(latl*FCw_Vbi_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vbi_ei_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei)));
  lnzb_Vbi_ei_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND)));
  lnzb_Vbi_ei_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei)));
  lnzb_Vbi_ei_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci)));
#endif
lnzb_Vbi_ci=(latl*FCw_Vbi_ci)*d10_logE0;
#if defined(_DERIVATE)
  lnzb_Vbi_ci_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei)));
  lnzb_Vbi_ci_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND)));
  lnzb_Vbi_ci_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei)));
  lnzb_Vbi_ci_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci)));
#endif
#endif
lnzb=d00_logE0;
}
if
((z>1.0e-6))
{
#if defined(_DERIVATEFORDDX)
x_Vci_ei=z_Vci_ei;
#if defined(_DERIVATE)
  x_Vci_ei_Vci_ei=(+0.0+z_Vci_ei_Vci_ei);
  x_Vci_ei_Vtnode_GND=(+0.0+z_Vci_ei_Vtnode_GND);
  x_Vci_ei_Vbi_ei=(+0.0+z_Vci_ei_Vbi_ei);
  x_Vci_ei_Vbi_ci=(+0.0+z_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
x_Vtnode_GND=z_Vtnode_GND;
#endif
x_Vbi_ei=z_Vbi_ei;
#if defined(_DERIVATE)
  x_Vbi_ei_Vci_ei=(+0.0+z_Vbi_ei_Vci_ei);
  x_Vbi_ei_Vtnode_GND=(+0.0+z_Vbi_ei_Vtnode_GND);
  x_Vbi_ei_Vbi_ei=(+0.0+z_Vbi_ei_Vbi_ei);
  x_Vbi_ei_Vbi_ci=(+0.0+z_Vbi_ei_Vbi_ci);
#endif
x_Vbi_ci=z_Vbi_ci;
#if defined(_DERIVATE)
  x_Vbi_ci_Vci_ei=(+0.0+z_Vbi_ci_Vci_ei);
  x_Vbi_ci_Vtnode_GND=(+0.0+z_Vbi_ci_Vtnode_GND);
  x_Vbi_ci_Vbi_ei=(+0.0+z_Vbi_ci_Vbi_ei);
  x_Vbi_ci_Vbi_ci=(+0.0+z_Vbi_ci_Vbi_ci);
#endif
#endif
x=(1.0+z);
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=((x_Vbi_ei*x)+(x*x_Vbi_ei));
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+x_Vbi_ei_Vbi_ei*x+x_Vbi_ei*x_Vbi_ei+x_Vbi_ei*x_Vbi_ei+x*x_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+x_Vbi_ei_Vbi_ci*x+x_Vbi_ei*x_Vbi_ci+x_Vbi_ci*x_Vbi_ei+x*x_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+x_Vbi_ei_Vci_ei*x+x_Vbi_ei*x_Vci_ei+x_Vci_ei*x_Vbi_ei+x*x_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+x_Vbi_ei_Vtnode_GND*x+x_Vbi_ei*x_Vtnode_GND+x_Vtnode_GND*x_Vbi_ei+x*x_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=((x_Vbi_ci*x)+(x*x_Vbi_ci));
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+x_Vbi_ci_Vbi_ei*x+x_Vbi_ci*x_Vbi_ei+x_Vbi_ei*x_Vbi_ci+x*x_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+x_Vbi_ci_Vbi_ci*x+x_Vbi_ci*x_Vbi_ci+x_Vbi_ci*x_Vbi_ci+x*x_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+x_Vbi_ci_Vci_ei*x+x_Vbi_ci*x_Vci_ei+x_Vci_ei*x_Vbi_ci+x*x_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+x_Vbi_ci_Vtnode_GND*x+x_Vbi_ci*x_Vtnode_GND+x_Vtnode_GND*x_Vbi_ci+x*x_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=((x_Vci_ei*x)+(x*x_Vci_ei));
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+x_Vci_ei_Vbi_ei*x+x_Vci_ei*x_Vbi_ei+x_Vbi_ei*x_Vci_ei+x*x_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+x_Vci_ei_Vbi_ci*x+x_Vci_ei*x_Vbi_ci+x_Vbi_ci*x_Vci_ei+x*x_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+x_Vci_ei_Vci_ei*x+x_Vci_ei*x_Vci_ei+x_Vci_ei*x_Vci_ei+x*x_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+x_Vci_ei_Vtnode_GND*x+x_Vci_ei*x_Vtnode_GND+x_Vtnode_GND*x_Vci_ei+x*x_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((x_Vtnode_GND*x)+(x*x_Vtnode_GND));
#endif
#endif
a=(x*x);
#if defined(_DERIVATEFORDDX)
a2_Vbi_ei=(0.250*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei))));
#if defined(_DERIVATE)
  a2_Vbi_ei_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vbi_ei*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vbi_ei)-0.0))+0.0));
  a2_Vbi_ei_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vbi_ci*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vbi_ci)-0.0))+0.0));
  a2_Vbi_ei_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vci_ei*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vci_ei)-0.0))+0.0));
  a2_Vbi_ei_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ei)))+0.250*(+(+a_Vbi_ei_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vbi_ei*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vbi_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ei+2.0*lnzb_Vbi_ei_Vtnode_GND)-0.0))+0.0));
#endif
a2_Vbi_ci=(0.250*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci))));
#if defined(_DERIVATE)
  a2_Vbi_ci_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vbi_ei*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vbi_ei)-0.0))+0.0));
  a2_Vbi_ci_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vbi_ci*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vbi_ci)-0.0))+0.0));
  a2_Vbi_ci_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vci_ei*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vci_ei)-0.0))+0.0));
  a2_Vbi_ci_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vbi_ci)))+0.250*(+(+a_Vbi_ci_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vbi_ci*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vbi_ci)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ci+2.0*lnzb_Vbi_ci_Vtnode_GND)-0.0))+0.0));
#endif
a2_Vci_ei=(0.250*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei))));
#if defined(_DERIVATE)
  a2_Vci_ei_Vbi_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ei)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vbi_ei*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vbi_ei))+a_Vbi_ei*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vbi_ei)-0.0))+0.0));
  a2_Vci_ei_Vbi_ci=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vbi_ci*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vbi_ci)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vbi_ci*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vbi_ci))+a_Vbi_ci*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vbi_ci)-0.0))+0.0));
  a2_Vci_ei_Vci_ei=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vci_ei*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vci_ei)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vci_ei*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vci_ei))+a_Vci_ei*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vci_ei)-0.0))+0.0));
  a2_Vci_ei_Vtnode_GND=(+0.0*((a*((2.0*lnzb)-1.0))+1.0)+0.0*(((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*((2.0*lnzb_Vtnode_GND)))))+0.0*((a_Vci_ei*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vci_ei)))+0.250*(+(+a_Vci_ei_Vtnode_GND*((2.0*lnzb)-1.0)+a_Vci_ei*((2.0*lnzb_Vtnode_GND))+a_Vtnode_GND*(2.0*lnzb_Vci_ei)+a*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vci_ei+2.0*lnzb_Vci_ei_Vtnode_GND)-0.0))+0.0));
#endif
#if defined(_DERIVATE)
a2_Vtnode_GND=(0.250*((a_Vtnode_GND*((2.0*lnzb)-1.0))+(a*(2.0*lnzb_Vtnode_GND))));
#endif
#endif
a2=(0.250*((a*((2.0*lnzb)-1.0))+1.0));
#if defined(_DERIVATEFORDDX)
a3_Vbi_ei=(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))/9.0);
#if defined(_DERIVATE)
  a3_Vbi_ei_Vbi_ei=((+(+(+a_Vbi_ei_Vbi_ei*x+a_Vbi_ei*x_Vbi_ei+a_Vbi_ei*x_Vbi_ei+a*x_Vbi_ei_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vbi_ci=((+(+(+a_Vbi_ei_Vbi_ci*x+a_Vbi_ei*x_Vbi_ci+a_Vbi_ci*x_Vbi_ei+a*x_Vbi_ei_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vci_ei=((+(+(+a_Vbi_ei_Vci_ei*x+a_Vbi_ei*x_Vci_ei+a_Vci_ei*x_Vbi_ei+a*x_Vbi_ei_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ei_Vtnode_GND=((+(+(+a_Vbi_ei_Vtnode_GND*x+a_Vbi_ei*x_Vtnode_GND+a_Vtnode_GND*x_Vbi_ei+a*x_Vbi_ei_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vbi_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ei+3.0*lnzb_Vbi_ei_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vbi_ei*x)+(a*x_Vbi_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ei)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
a3_Vbi_ci=(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))/9.0);
#if defined(_DERIVATE)
  a3_Vbi_ci_Vbi_ei=((+(+(+a_Vbi_ci_Vbi_ei*x+a_Vbi_ci*x_Vbi_ei+a_Vbi_ei*x_Vbi_ci+a*x_Vbi_ci_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vbi_ci=((+(+(+a_Vbi_ci_Vbi_ci*x+a_Vbi_ci*x_Vbi_ci+a_Vbi_ci*x_Vbi_ci+a*x_Vbi_ci_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vci_ei=((+(+(+a_Vbi_ci_Vci_ei*x+a_Vbi_ci*x_Vci_ei+a_Vci_ei*x_Vbi_ci+a*x_Vbi_ci_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vbi_ci_Vtnode_GND=((+(+(+a_Vbi_ci_Vtnode_GND*x+a_Vbi_ci*x_Vtnode_GND+a_Vtnode_GND*x_Vbi_ci+a*x_Vbi_ci_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vbi_ci)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vbi_ci+3.0*lnzb_Vbi_ci_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vbi_ci*x)+(a*x_Vbi_ci))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vbi_ci)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
a3_Vci_ei=(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))/9.0);
#if defined(_DERIVATE)
  a3_Vci_ei_Vbi_ei=((+(+(+a_Vci_ei_Vbi_ei*x+a_Vci_ei*x_Vbi_ei+a_Vbi_ei*x_Vci_ei+a*x_Vci_ei_Vbi_ei)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vbi_ei))+(((a_Vbi_ei*x)+(a*x_Vbi_ei)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ei+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vbi_ei)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vbi_ei*x)+(a*x_Vbi_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vbi_ci=((+(+(+a_Vci_ei_Vbi_ci*x+a_Vci_ei*x_Vbi_ci+a_Vbi_ci*x_Vci_ei+a*x_Vci_ei_Vbi_ci)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vbi_ci))+(((a_Vbi_ci*x)+(a*x_Vbi_ci)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vbi_ci+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vbi_ci)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vbi_ci*x)+(a*x_Vbi_ci)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vbi_ci)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vci_ei=((+(+(+a_Vci_ei_Vci_ei*x+a_Vci_ei*x_Vci_ei+a_Vci_ei*x_Vci_ei+a*x_Vci_ei_Vci_ei)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vci_ei))+(((a_Vci_ei*x)+(a*x_Vci_ei)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vci_ei+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vci_ei)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vci_ei*x)+(a*x_Vci_ei)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vci_ei)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
  a3_Vci_ei_Vtnode_GND=((+(+(+a_Vci_ei_Vtnode_GND*x+a_Vci_ei*x_Vtnode_GND+a_Vtnode_GND*x_Vci_ei+a*x_Vci_ei_Vtnode_GND)*((3.0*lnzb)-1.0)+((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb_Vtnode_GND))+(((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*(3.0*lnzb_Vci_ei)+(a*x)*(+(+0.0*lnzb+0.0*lnzb_Vtnode_GND+0.0*lnzb_Vci_ei+3.0*lnzb_Vci_ei_Vtnode_GND)-0.0))+0.0)/9.0-(((((a_Vci_ei*x)+(a*x_Vci_ei))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vci_ei)))*0.0+((((((a_Vtnode_GND*x)+(a*x_Vtnode_GND)))*((3.0*lnzb)-1.0))+((a*x)*((3.0*lnzb_Vtnode_GND)))))*0.0+(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0)/9.0/9.0+2*(((a*x)*((3.0*lnzb)-1.0))+1.0)*0.0*0.0/9.0/9.0/9.0);
#endif
#if defined(_DERIVATE)
a3_Vtnode_GND=(((((a_Vtnode_GND*x)+(a*x_Vtnode_GND))*((3.0*lnzb)-1.0))+((a*x)*(3.0*lnzb_Vtnode_GND)))/9.0);
#endif
#endif
a3=((((a*x)*((3.0*lnzb)-1.0))+1.0)/9.0);
r=(latb/latl);
#if defined(_DERIVATEFORDDX)
FCf3_Vbi_ei=((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))/latl);
#if defined(_DERIVATE)
  FCf3_Vbi_ei_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vbi_ei))/latl-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vbi_ci))/latl-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vci_ei))/latl-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ei+(1.0-r)*a2_Vbi_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ei+r*a3_Vbi_ei_Vtnode_GND))/latl-((((1.0-r)*a2_Vbi_ei)+(r*a3_Vbi_ei))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
#endif
FCf3_Vbi_ci=((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))/latl);
#if defined(_DERIVATE)
  FCf3_Vbi_ci_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vbi_ei))/latl-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vbi_ci))/latl-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vci_ei))/latl-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ci+(1.0-r)*a2_Vbi_ci_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ci+r*a3_Vbi_ci_Vtnode_GND))/latl-((((1.0-r)*a2_Vbi_ci)+(r*a3_Vbi_ci))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
#endif
FCf3_Vci_ei=((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))/latl);
#if defined(_DERIVATE)
  FCf3_Vci_ei_Vbi_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ei+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vci_ei+r*a3_Vci_ei_Vbi_ei))/latl-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vbi_ei))+((r*a3_Vbi_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vbi_ci=((+(+(+0.0-0.0)*a2+0.0*a2_Vbi_ci+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vci_ei+r*a3_Vci_ei_Vbi_ci))/latl-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vbi_ci))+((r*a3_Vbi_ci)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vci_ei=((+(+(+0.0-0.0)*a2+0.0*a2_Vci_ei+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vci_ei+r*a3_Vci_ei_Vci_ei))/latl-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vci_ei))+((r*a3_Vci_ei)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vtnode_GND=((+(+(+0.0-0.0)*a2+0.0*a2_Vtnode_GND+0.0*a2_Vci_ei+(1.0-r)*a2_Vci_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vci_ei+r*a3_Vci_ei_Vtnode_GND))/latl-((((1.0-r)*a2_Vci_ei)+(r*a3_Vci_ei))*0.0+((((1.0-r)*a2_Vtnode_GND))+((r*a3_Vtnode_GND)))*0.0+(((1.0-r)*a2)+(r*a3))*0.0)/latl/latl+2*(((1.0-r)*a2)+(r*a3))*0.0*0.0/latl/latl/latl);
#endif
#if defined(_DERIVATE)
FCf3_Vtnode_GND=((((1.0-r)*a2_Vtnode_GND)+(r*a3_Vtnode_GND))/latl);
#endif
#endif
FCf3=((((1.0-r)*a2)+(r*a3))/latl);
#if defined(_DERIVATEFORDDX)
FCdf3_dw_Vci_ei=(((((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vci_ei));
#if defined(_DERIVATE)
  FCdf3_dw_Vci_ei_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+r*a_Vci_ei_Vci_ei))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vci_ei);
  FCdf3_dw_Vci_ei_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+r*a_Vci_ei_Vtnode_GND))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vtnode_GND);
  FCdf3_dw_Vci_ei_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+r*a_Vci_ei_Vbi_ei))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vbi_ei);
  FCdf3_dw_Vci_ei_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vci_ei+(1.0-r)*x_Vci_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+r*a_Vci_ei_Vbi_ci))*lnzb+(((1.0-r)*x_Vci_ei)+(r*a_Vci_ei))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vci_ei+(((1.0-r)*x)+(r*a))*lnzb_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdf3_dw_Vtnode_GND=(((((1.0-r)*x_Vtnode_GND)+(r*a_Vtnode_GND))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vtnode_GND));
#endif
FCdf3_dw_Vbi_ei=(((((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vbi_ei));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ei_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+r*a_Vbi_ei_Vci_ei))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vci_ei);
  FCdf3_dw_Vbi_ei_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+r*a_Vbi_ei_Vtnode_GND))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vtnode_GND);
  FCdf3_dw_Vbi_ei_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+r*a_Vbi_ei_Vbi_ei))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vbi_ei);
  FCdf3_dw_Vbi_ei_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vbi_ei+(1.0-r)*x_Vbi_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+r*a_Vbi_ei_Vbi_ci))*lnzb+(((1.0-r)*x_Vbi_ei)+(r*a_Vbi_ei))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vbi_ei+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ei_Vbi_ci);
#endif
FCdf3_dw_Vbi_ci=(((((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb)+((((1.0-r)*x)+(r*a))*lnzb_Vbi_ci));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ci_Vci_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vci_ei+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+r*a_Vbi_ci_Vci_ei))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vci_ei+((((1.0-r)*x_Vci_ei))+((r*a_Vci_ei)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vci_ei);
  FCdf3_dw_Vbi_ci_Vtnode_GND=(+(+(+(+0.0-0.0)*x+0.0*x_Vtnode_GND+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+r*a_Vbi_ci_Vtnode_GND))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vtnode_GND+((((1.0-r)*x_Vtnode_GND))+((r*a_Vtnode_GND)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vtnode_GND);
  FCdf3_dw_Vbi_ci_Vbi_ei=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ei+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+r*a_Vbi_ci_Vbi_ei))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vbi_ei+((((1.0-r)*x_Vbi_ei))+((r*a_Vbi_ei)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vbi_ei);
  FCdf3_dw_Vbi_ci_Vbi_ci=(+(+(+(+0.0-0.0)*x+0.0*x_Vbi_ci+0.0*x_Vbi_ci+(1.0-r)*x_Vbi_ci_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+r*a_Vbi_ci_Vbi_ci))*lnzb+(((1.0-r)*x_Vbi_ci)+(r*a_Vbi_ci))*lnzb_Vbi_ci+((((1.0-r)*x_Vbi_ci))+((r*a_Vbi_ci)))*lnzb_Vbi_ci+(((1.0-r)*x)+(r*a))*lnzb_Vbi_ci_Vbi_ci);
#endif
#endif
FCdf3_dw=((((1.0-r)*x)+(r*a))*lnzb);
}
else
{
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=((z_Vbi_ei*z)+(z*z_Vbi_ei));
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+z_Vbi_ei_Vbi_ei*z+z_Vbi_ei*z_Vbi_ei+z_Vbi_ei*z_Vbi_ei+z*z_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+z_Vbi_ei_Vbi_ci*z+z_Vbi_ei*z_Vbi_ci+z_Vbi_ci*z_Vbi_ei+z*z_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+z_Vbi_ei_Vci_ei*z+z_Vbi_ei*z_Vci_ei+z_Vci_ei*z_Vbi_ei+z*z_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+z_Vbi_ei_Vtnode_GND*z+z_Vbi_ei*z_Vtnode_GND+z_Vtnode_GND*z_Vbi_ei+z*z_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=((z_Vbi_ci*z)+(z*z_Vbi_ci));
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+z_Vbi_ci_Vbi_ei*z+z_Vbi_ci*z_Vbi_ei+z_Vbi_ei*z_Vbi_ci+z*z_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+z_Vbi_ci_Vbi_ci*z+z_Vbi_ci*z_Vbi_ci+z_Vbi_ci*z_Vbi_ci+z*z_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+z_Vbi_ci_Vci_ei*z+z_Vbi_ci*z_Vci_ei+z_Vci_ei*z_Vbi_ci+z*z_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+z_Vbi_ci_Vtnode_GND*z+z_Vbi_ci*z_Vtnode_GND+z_Vtnode_GND*z_Vbi_ci+z*z_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=((z_Vci_ei*z)+(z*z_Vci_ei));
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+z_Vci_ei_Vbi_ei*z+z_Vci_ei*z_Vbi_ei+z_Vbi_ei*z_Vci_ei+z*z_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+z_Vci_ei_Vbi_ci*z+z_Vci_ei*z_Vbi_ci+z_Vbi_ci*z_Vci_ei+z*z_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+z_Vci_ei_Vci_ei*z+z_Vci_ei*z_Vci_ei+z_Vci_ei*z_Vci_ei+z*z_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+z_Vci_ei_Vtnode_GND*z+z_Vci_ei*z_Vtnode_GND+z_Vtnode_GND*z_Vci_ei+z*z_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=((z_Vtnode_GND*z)+(z*z_Vtnode_GND));
#endif
#endif
a=(z*z);
#if defined(_DERIVATEFORDDX)
a2_Vbi_ei=((z_Vbi_ei-(0.25*a_Vbi_ei))+(((0.10*z_Vbi_ei)*a)+((0.10*z)*a_Vbi_ei)));
#if defined(_DERIVATE)
  a2_Vbi_ei_Vbi_ei=(+(+(+0.0+z_Vbi_ei_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vbi_ei)*a+(0.10*z_Vbi_ei)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vbi_ei));
  a2_Vbi_ei_Vbi_ci=(+(+(+0.0+z_Vbi_ei_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vbi_ci)*a+(0.10*z_Vbi_ei)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vbi_ci));
  a2_Vbi_ei_Vci_ei=(+(+(+0.0+z_Vbi_ei_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vci_ei)*a+(0.10*z_Vbi_ei)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vci_ei));
  a2_Vbi_ei_Vtnode_GND=(+(+(+0.0+z_Vbi_ei_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.25*a_Vbi_ei_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ei+0.10*z_Vbi_ei_Vtnode_GND)*a+(0.10*z_Vbi_ei)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vbi_ei+(0.10*z)*a_Vbi_ei_Vtnode_GND));
#endif
a2_Vbi_ci=((z_Vbi_ci-(0.25*a_Vbi_ci))+(((0.10*z_Vbi_ci)*a)+((0.10*z)*a_Vbi_ci)));
#if defined(_DERIVATE)
  a2_Vbi_ci_Vbi_ei=(+(+(+0.0+z_Vbi_ci_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vbi_ei)*a+(0.10*z_Vbi_ci)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vbi_ei));
  a2_Vbi_ci_Vbi_ci=(+(+(+0.0+z_Vbi_ci_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vbi_ci)*a+(0.10*z_Vbi_ci)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vbi_ci));
  a2_Vbi_ci_Vci_ei=(+(+(+0.0+z_Vbi_ci_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vci_ei)*a+(0.10*z_Vbi_ci)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vci_ei));
  a2_Vbi_ci_Vtnode_GND=(+(+(+0.0+z_Vbi_ci_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.25*a_Vbi_ci_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ci+0.10*z_Vbi_ci_Vtnode_GND)*a+(0.10*z_Vbi_ci)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vbi_ci+(0.10*z)*a_Vbi_ci_Vtnode_GND));
#endif
a2_Vci_ei=((z_Vci_ei-(0.25*a_Vci_ei))+(((0.10*z_Vci_ei)*a)+((0.10*z)*a_Vci_ei)));
#if defined(_DERIVATE)
  a2_Vci_ei_Vbi_ei=(+(+(+0.0+z_Vci_ei_Vbi_ei)-(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.25*a_Vci_ei_Vbi_ei))+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vci_ei+0.10*z_Vci_ei_Vbi_ei)*a+(0.10*z_Vci_ei)*a_Vbi_ei+((0.10*z_Vbi_ei))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vbi_ei));
  a2_Vci_ei_Vbi_ci=(+(+(+0.0+z_Vci_ei_Vbi_ci)-(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.25*a_Vci_ei_Vbi_ci))+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vci_ei+0.10*z_Vci_ei_Vbi_ci)*a+(0.10*z_Vci_ei)*a_Vbi_ci+((0.10*z_Vbi_ci))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vbi_ci));
  a2_Vci_ei_Vci_ei=(+(+(+0.0+z_Vci_ei_Vci_ei)-(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.25*a_Vci_ei_Vci_ei))+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vci_ei+0.10*z_Vci_ei_Vci_ei)*a+(0.10*z_Vci_ei)*a_Vci_ei+((0.10*z_Vci_ei))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vci_ei));
  a2_Vci_ei_Vtnode_GND=(+(+(+0.0+z_Vci_ei_Vtnode_GND)-(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.25*a_Vci_ei_Vtnode_GND))+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vci_ei+0.10*z_Vci_ei_Vtnode_GND)*a+(0.10*z_Vci_ei)*a_Vtnode_GND+((0.10*z_Vtnode_GND))*a_Vci_ei+(0.10*z)*a_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
a2_Vtnode_GND=((z_Vtnode_GND-(0.25*a_Vtnode_GND))+(((0.10*z_Vtnode_GND)*a)+((0.10*z)*a_Vtnode_GND)));
#endif
#endif
a2=(((3.0+z)-(0.25*a))+((0.10*z)*a));
#if defined(_DERIVATEFORDDX)
a3_Vbi_ei=(((2.0*z_Vbi_ei)+(0.75*a_Vbi_ei))-(((0.20*a_Vbi_ei)*z)+((0.20*a)*z_Vbi_ei)));
#if defined(_DERIVATE)
  a3_Vbi_ei_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vbi_ei)*z+(0.20*a_Vbi_ei)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vbi_ei));
  a3_Vbi_ei_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vbi_ci)*z+(0.20*a_Vbi_ei)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vbi_ci));
  a3_Vbi_ei_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vci_ei)*z+(0.20*a_Vbi_ei)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vci_ei));
  a3_Vbi_ei_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ei+2.0*z_Vbi_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.75*a_Vbi_ei_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.20*a_Vbi_ei_Vtnode_GND)*z+(0.20*a_Vbi_ei)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vbi_ei+(0.20*a)*z_Vbi_ei_Vtnode_GND));
#endif
a3_Vbi_ci=(((2.0*z_Vbi_ci)+(0.75*a_Vbi_ci))-(((0.20*a_Vbi_ci)*z)+((0.20*a)*z_Vbi_ci)));
#if defined(_DERIVATE)
  a3_Vbi_ci_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vbi_ei)*z+(0.20*a_Vbi_ci)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vbi_ei));
  a3_Vbi_ci_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vbi_ci)*z+(0.20*a_Vbi_ci)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vbi_ci));
  a3_Vbi_ci_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vci_ei)*z+(0.20*a_Vbi_ci)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vci_ei));
  a3_Vbi_ci_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vbi_ci+2.0*z_Vbi_ci_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.75*a_Vbi_ci_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.20*a_Vbi_ci_Vtnode_GND)*z+(0.20*a_Vbi_ci)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vbi_ci+(0.20*a)*z_Vbi_ci_Vtnode_GND));
#endif
a3_Vci_ei=(((2.0*z_Vci_ei)+(0.75*a_Vci_ei))-(((0.20*a_Vci_ei)*z)+((0.20*a)*z_Vci_ei)));
#if defined(_DERIVATE)
  a3_Vci_ei_Vbi_ei=(+(+(+0.0*z+0.0*z_Vbi_ei+0.0*z_Vci_ei+2.0*z_Vci_ei_Vbi_ei)+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.75*a_Vci_ei_Vbi_ei))-(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.20*a_Vci_ei_Vbi_ei)*z+(0.20*a_Vci_ei)*z_Vbi_ei+((0.20*a_Vbi_ei))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vbi_ei));
  a3_Vci_ei_Vbi_ci=(+(+(+0.0*z+0.0*z_Vbi_ci+0.0*z_Vci_ei+2.0*z_Vci_ei_Vbi_ci)+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.75*a_Vci_ei_Vbi_ci))-(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.20*a_Vci_ei_Vbi_ci)*z+(0.20*a_Vci_ei)*z_Vbi_ci+((0.20*a_Vbi_ci))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vbi_ci));
  a3_Vci_ei_Vci_ei=(+(+(+0.0*z+0.0*z_Vci_ei+0.0*z_Vci_ei+2.0*z_Vci_ei_Vci_ei)+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.75*a_Vci_ei_Vci_ei))-(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.20*a_Vci_ei_Vci_ei)*z+(0.20*a_Vci_ei)*z_Vci_ei+((0.20*a_Vci_ei))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vci_ei));
  a3_Vci_ei_Vtnode_GND=(+(+(+0.0*z+0.0*z_Vtnode_GND+0.0*z_Vci_ei+2.0*z_Vci_ei_Vtnode_GND)+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.75*a_Vci_ei_Vtnode_GND))-(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.20*a_Vci_ei_Vtnode_GND)*z+(0.20*a_Vci_ei)*z_Vtnode_GND+((0.20*a_Vtnode_GND))*z_Vci_ei+(0.20*a)*z_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
a3_Vtnode_GND=(((2.0*z_Vtnode_GND)+(0.75*a_Vtnode_GND))-(((0.20*a_Vtnode_GND)*z)+((0.20*a)*z_Vtnode_GND)));
#endif
#endif
a3=(((2.0*z)+(0.75*a))-((0.20*a)*z));
#if defined(_DERIVATEFORDDX)
FCf3_Vbi_ei=(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))/6.0);
#if defined(_DERIVATE)
  FCf3_Vbi_ei_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ei+latl*a2_Vbi_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ei+latb*a3_Vbi_ei_Vbi_ei))*FCw+((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw_Vbi_ei+(((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw_Vbi_ei+((latl*a2)+(latb*a3))*FCw_Vbi_ei_Vbi_ei)*FCw+((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw_Vbi_ei+((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw_Vbi_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei_Vbi_ei)/6.0-(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ei_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ei+latl*a2_Vbi_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ei+latb*a3_Vbi_ei_Vbi_ci))*FCw+((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw_Vbi_ci+(((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw_Vbi_ei+((latl*a2)+(latb*a3))*FCw_Vbi_ei_Vbi_ci)*FCw+((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw_Vbi_ci+((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw_Vbi_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei_Vbi_ci)/6.0-(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ei_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ei+latl*a2_Vbi_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ei+latb*a3_Vbi_ei_Vci_ei))*FCw+((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw_Vci_ei+(((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw_Vbi_ei+((latl*a2)+(latb*a3))*FCw_Vbi_ei_Vci_ei)*FCw+((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw_Vci_ei+((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw_Vbi_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei_Vci_ei)/6.0-(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ei_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ei+latl*a2_Vbi_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ei+latb*a3_Vbi_ei_Vtnode_GND))*FCw+((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw_Vtnode_GND+(((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw_Vbi_ei+((latl*a2)+(latb*a3))*FCw_Vbi_ei_Vtnode_GND)*FCw+((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw_Vtnode_GND+((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw_Vbi_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei_Vtnode_GND)/6.0-(((((((latl*a2_Vbi_ei)+(latb*a3_Vbi_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei))*0.0+(((((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
FCf3_Vbi_ci=(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))/6.0);
#if defined(_DERIVATE)
  FCf3_Vbi_ci_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vbi_ci+latl*a2_Vbi_ci_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vbi_ci+latb*a3_Vbi_ci_Vbi_ei))*FCw+((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw_Vbi_ei+(((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw_Vbi_ci+((latl*a2)+(latb*a3))*FCw_Vbi_ci_Vbi_ei)*FCw+((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw_Vbi_ei+((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw_Vbi_ci+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci_Vbi_ei)/6.0-(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ci_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vbi_ci+latl*a2_Vbi_ci_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vbi_ci+latb*a3_Vbi_ci_Vbi_ci))*FCw+((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw_Vbi_ci+(((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw_Vbi_ci+((latl*a2)+(latb*a3))*FCw_Vbi_ci_Vbi_ci)*FCw+((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw_Vbi_ci+((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw_Vbi_ci+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci_Vbi_ci)/6.0-(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ci_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vbi_ci+latl*a2_Vbi_ci_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vbi_ci+latb*a3_Vbi_ci_Vci_ei))*FCw+((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw_Vci_ei+(((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw_Vbi_ci+((latl*a2)+(latb*a3))*FCw_Vbi_ci_Vci_ei)*FCw+((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw_Vci_ei+((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw_Vbi_ci+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci_Vci_ei)/6.0-(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vbi_ci_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vbi_ci+latl*a2_Vbi_ci_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vbi_ci+latb*a3_Vbi_ci_Vtnode_GND))*FCw+((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw_Vtnode_GND+(((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw_Vbi_ci+((latl*a2)+(latb*a3))*FCw_Vbi_ci_Vtnode_GND)*FCw+((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw_Vtnode_GND+((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw_Vbi_ci+(((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci_Vtnode_GND)/6.0-(((((((latl*a2_Vbi_ci)+(latb*a3_Vbi_ci))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci))*0.0+(((((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
FCf3_Vci_ei=(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))/6.0);
#if defined(_DERIVATE)
  FCf3_Vci_ei_Vbi_ei=((+(+(+(+0.0*a2+0.0*a2_Vbi_ei+0.0*a2_Vci_ei+latl*a2_Vci_ei_Vbi_ei)+(+0.0*a3+0.0*a3_Vbi_ei+0.0*a3_Vci_ei+latb*a3_Vci_ei_Vbi_ei))*FCw+((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw_Vbi_ei+(((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw_Vci_ei+((latl*a2)+(latb*a3))*FCw_Vci_ei_Vbi_ei)*FCw+((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw_Vbi_ei+((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw_Vci_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei_Vbi_ei)/6.0-(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latl*a2_Vbi_ei))+((latb*a3_Vbi_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vci_ei_Vbi_ci=((+(+(+(+0.0*a2+0.0*a2_Vbi_ci+0.0*a2_Vci_ei+latl*a2_Vci_ei_Vbi_ci)+(+0.0*a3+0.0*a3_Vbi_ci+0.0*a3_Vci_ei+latb*a3_Vci_ei_Vbi_ci))*FCw+((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw_Vbi_ci+(((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw_Vci_ei+((latl*a2)+(latb*a3))*FCw_Vci_ei_Vbi_ci)*FCw+((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw_Vbi_ci+((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw_Vci_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei_Vbi_ci)/6.0-(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latl*a2_Vbi_ci))+((latb*a3_Vbi_ci)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vbi_ci)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vbi_ci)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vci_ei_Vci_ei=((+(+(+(+0.0*a2+0.0*a2_Vci_ei+0.0*a2_Vci_ei+latl*a2_Vci_ei_Vci_ei)+(+0.0*a3+0.0*a3_Vci_ei+0.0*a3_Vci_ei+latb*a3_Vci_ei_Vci_ei))*FCw+((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw_Vci_ei+(((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw_Vci_ei+((latl*a2)+(latb*a3))*FCw_Vci_ei_Vci_ei)*FCw+((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw_Vci_ei+((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw_Vci_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei_Vci_ei)/6.0-(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latl*a2_Vci_ei))+((latb*a3_Vci_ei)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
  FCf3_Vci_ei_Vtnode_GND=((+(+(+(+0.0*a2+0.0*a2_Vtnode_GND+0.0*a2_Vci_ei+latl*a2_Vci_ei_Vtnode_GND)+(+0.0*a3+0.0*a3_Vtnode_GND+0.0*a3_Vci_ei+latb*a3_Vci_ei_Vtnode_GND))*FCw+((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw_Vtnode_GND+(((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw_Vci_ei+((latl*a2)+(latb*a3))*FCw_Vci_ei_Vtnode_GND)*FCw+((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw_Vtnode_GND+((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw_Vci_ei+(((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei_Vtnode_GND)/6.0-(((((((latl*a2_Vci_ei)+(latb*a3_Vci_ei))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vci_ei))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vci_ei))*0.0+(((((((((latl*a2_Vtnode_GND))+((latb*a3_Vtnode_GND)))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND)))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND)))*0.0+((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0)/6.0/6.0+2*((((latl*a2)+(latb*a3))*FCw)*FCw)*0.0*0.0/6.0/6.0/6.0);
#endif
#if defined(_DERIVATE)
FCf3_Vtnode_GND=(((((((latl*a2_Vtnode_GND)+(latb*a3_Vtnode_GND))*FCw)+(((latl*a2)+(latb*a3))*FCw_Vtnode_GND))*FCw)+((((latl*a2)+(latb*a3))*FCw)*FCw_Vtnode_GND))/6.0);
#endif
#endif
FCf3=(((((latl*a2)+(latb*a3))*FCw)*FCw)/6.0);
#if defined(_DERIVATEFORDDX)
FCdf3_dw_Vci_ei=(((((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb)+(((1+(latb*FCw))*(1+z))*lnzb_Vci_ei));
#if defined(_DERIVATE)
  FCdf3_dw_Vci_ei_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei))*(1+z)+(latb*FCw_Vci_ei)*z_Vci_ei+((latb*FCw_Vci_ei))*z_Vci_ei+(1+(latb*FCw))*(+0.0+z_Vci_ei_Vci_ei))*lnzb+(((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb_Vci_ei+(((((latb*FCw_Vci_ei))*(1+z))+((1+(latb*FCw))*z_Vci_ei)))*lnzb_Vci_ei+((1+(latb*FCw))*(1+z))*lnzb_Vci_ei_Vci_ei);
  FCdf3_dw_Vci_ei_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND))*(1+z)+(latb*FCw_Vci_ei)*z_Vtnode_GND+((latb*FCw_Vtnode_GND))*z_Vci_ei+(1+(latb*FCw))*(+0.0+z_Vci_ei_Vtnode_GND))*lnzb+(((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb_Vtnode_GND+(((((latb*FCw_Vtnode_GND))*(1+z))+((1+(latb*FCw))*z_Vtnode_GND)))*lnzb_Vci_ei+((1+(latb*FCw))*(1+z))*lnzb_Vci_ei_Vtnode_GND);
  FCdf3_dw_Vci_ei_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei))*(1+z)+(latb*FCw_Vci_ei)*z_Vbi_ei+((latb*FCw_Vbi_ei))*z_Vci_ei+(1+(latb*FCw))*(+0.0+z_Vci_ei_Vbi_ei))*lnzb+(((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb_Vbi_ei+(((((latb*FCw_Vbi_ei))*(1+z))+((1+(latb*FCw))*z_Vbi_ei)))*lnzb_Vci_ei+((1+(latb*FCw))*(1+z))*lnzb_Vci_ei_Vbi_ei);
  FCdf3_dw_Vci_ei_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci))*(1+z)+(latb*FCw_Vci_ei)*z_Vbi_ci+((latb*FCw_Vbi_ci))*z_Vci_ei+(1+(latb*FCw))*(+0.0+z_Vci_ei_Vbi_ci))*lnzb+(((latb*FCw_Vci_ei)*(1+z))+((1+(latb*FCw))*z_Vci_ei))*lnzb_Vbi_ci+(((((latb*FCw_Vbi_ci))*(1+z))+((1+(latb*FCw))*z_Vbi_ci)))*lnzb_Vci_ei+((1+(latb*FCw))*(1+z))*lnzb_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdf3_dw_Vtnode_GND=(((((latb*FCw_Vtnode_GND)*(1+z))+((1+(latb*FCw))*z_Vtnode_GND))*lnzb)+(((1+(latb*FCw))*(1+z))*lnzb_Vtnode_GND));
#endif
FCdf3_dw_Vbi_ei=(((((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb)+(((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ei_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei))*(1+z)+(latb*FCw_Vbi_ei)*z_Vci_ei+((latb*FCw_Vci_ei))*z_Vbi_ei+(1+(latb*FCw))*(+0.0+z_Vbi_ei_Vci_ei))*lnzb+(((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb_Vci_ei+(((((latb*FCw_Vci_ei))*(1+z))+((1+(latb*FCw))*z_Vci_ei)))*lnzb_Vbi_ei+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei_Vci_ei);
  FCdf3_dw_Vbi_ei_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND))*(1+z)+(latb*FCw_Vbi_ei)*z_Vtnode_GND+((latb*FCw_Vtnode_GND))*z_Vbi_ei+(1+(latb*FCw))*(+0.0+z_Vbi_ei_Vtnode_GND))*lnzb+(((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb_Vtnode_GND+(((((latb*FCw_Vtnode_GND))*(1+z))+((1+(latb*FCw))*z_Vtnode_GND)))*lnzb_Vbi_ei+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei_Vtnode_GND);
  FCdf3_dw_Vbi_ei_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei))*(1+z)+(latb*FCw_Vbi_ei)*z_Vbi_ei+((latb*FCw_Vbi_ei))*z_Vbi_ei+(1+(latb*FCw))*(+0.0+z_Vbi_ei_Vbi_ei))*lnzb+(((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb_Vbi_ei+(((((latb*FCw_Vbi_ei))*(1+z))+((1+(latb*FCw))*z_Vbi_ei)))*lnzb_Vbi_ei+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei_Vbi_ei);
  FCdf3_dw_Vbi_ei_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci))*(1+z)+(latb*FCw_Vbi_ei)*z_Vbi_ci+((latb*FCw_Vbi_ci))*z_Vbi_ei+(1+(latb*FCw))*(+0.0+z_Vbi_ei_Vbi_ci))*lnzb+(((latb*FCw_Vbi_ei)*(1+z))+((1+(latb*FCw))*z_Vbi_ei))*lnzb_Vbi_ci+(((((latb*FCw_Vbi_ci))*(1+z))+((1+(latb*FCw))*z_Vbi_ci)))*lnzb_Vbi_ei+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ei_Vbi_ci);
#endif
FCdf3_dw_Vbi_ci=(((((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb)+(((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ci_Vci_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei))*(1+z)+(latb*FCw_Vbi_ci)*z_Vci_ei+((latb*FCw_Vci_ei))*z_Vbi_ci+(1+(latb*FCw))*(+0.0+z_Vbi_ci_Vci_ei))*lnzb+(((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb_Vci_ei+(((((latb*FCw_Vci_ei))*(1+z))+((1+(latb*FCw))*z_Vci_ei)))*lnzb_Vbi_ci+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci_Vci_ei);
  FCdf3_dw_Vbi_ci_Vtnode_GND=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND))*(1+z)+(latb*FCw_Vbi_ci)*z_Vtnode_GND+((latb*FCw_Vtnode_GND))*z_Vbi_ci+(1+(latb*FCw))*(+0.0+z_Vbi_ci_Vtnode_GND))*lnzb+(((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb_Vtnode_GND+(((((latb*FCw_Vtnode_GND))*(1+z))+((1+(latb*FCw))*z_Vtnode_GND)))*lnzb_Vbi_ci+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci_Vtnode_GND);
  FCdf3_dw_Vbi_ci_Vbi_ei=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei))*(1+z)+(latb*FCw_Vbi_ci)*z_Vbi_ei+((latb*FCw_Vbi_ei))*z_Vbi_ci+(1+(latb*FCw))*(+0.0+z_Vbi_ci_Vbi_ei))*lnzb+(((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb_Vbi_ei+(((((latb*FCw_Vbi_ei))*(1+z))+((1+(latb*FCw))*z_Vbi_ei)))*lnzb_Vbi_ci+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci_Vbi_ei);
  FCdf3_dw_Vbi_ci_Vbi_ci=(+(+(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci))*(1+z)+(latb*FCw_Vbi_ci)*z_Vbi_ci+((latb*FCw_Vbi_ci))*z_Vbi_ci+(1+(latb*FCw))*(+0.0+z_Vbi_ci_Vbi_ci))*lnzb+(((latb*FCw_Vbi_ci)*(1+z))+((1+(latb*FCw))*z_Vbi_ci))*lnzb_Vbi_ci+(((((latb*FCw_Vbi_ci))*(1+z))+((1+(latb*FCw))*z_Vbi_ci)))*lnzb_Vbi_ci+((1+(latb*FCw))*(1+z))*lnzb_Vbi_ci_Vbi_ci);
#endif
#endif
FCdf3_dw=(((1+(latb*FCw))*(1+z))*lnzb);
}
#if defined(_DERIVATEFORDDX)
FCf_ci_Vci_ei=((FCf_CT_Vci_ei*(((FCa1*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)));
#if defined(_DERIVATE)
  FCf_ci_Vci_ei_Vci_ei=(+FCf_CT_Vci_ei_Vci_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vci_ei*(((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei)))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT_Vci_ei*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT*(+(+(+FCa1_Vci_ei_Vci_ei*FCf1+FCa1_Vci_ei*FCf1_Vci_ei+FCa1_Vci_ei*FCf1_Vci_ei+FCa1*FCf1_Vci_ei_Vci_ei)-FCf2_Vci_ei_Vci_ei)+FCf3_Vci_ei_Vci_ei));
  FCf_ci_Vci_ei_Vtnode_GND=(+FCf_CT_Vci_ei_Vtnode_GND*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vci_ei*(((((FCa1_Vtnode_GND*FCf1)+(FCa1*FCf1_Vtnode_GND)))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT*(+(+(+FCa1_Vci_ei_Vtnode_GND*FCf1+FCa1_Vci_ei*FCf1_Vtnode_GND+FCa1_Vtnode_GND*FCf1_Vci_ei+FCa1*FCf1_Vci_ei_Vtnode_GND)-FCf2_Vci_ei_Vtnode_GND)+FCf3_Vci_ei_Vtnode_GND));
  FCf_ci_Vci_ei_Vbi_ei=(+FCf_CT_Vci_ei_Vbi_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vci_ei*(((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei)))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT_Vbi_ei*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT*(+(+(+FCa1_Vci_ei_Vbi_ei*FCf1+FCa1_Vci_ei*FCf1_Vbi_ei+FCa1_Vbi_ei*FCf1_Vci_ei+FCa1*FCf1_Vci_ei_Vbi_ei)-FCf2_Vci_ei_Vbi_ei)+FCf3_Vci_ei_Vbi_ei));
  FCf_ci_Vci_ei_Vbi_ci=(+FCf_CT_Vci_ei_Vbi_ci*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vci_ei*(((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci)))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT_Vbi_ci*((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT*(+(+(+FCa1_Vci_ei_Vbi_ci*FCf1+FCa1_Vci_ei*FCf1_Vbi_ci+FCa1_Vbi_ci*FCf1_Vci_ei+FCa1*FCf1_Vci_ei_Vbi_ci)-FCf2_Vci_ei_Vbi_ci)+FCf3_Vci_ei_Vbi_ci));
#endif
#if defined(_DERIVATE)
FCf_ci_Vtnode_GND=((FCf_CT_Vtnode_GND*(((FCa1*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa1_Vtnode_GND*FCf1)+(FCa1*FCf1_Vtnode_GND))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)));
#endif
FCf_ci_Vbi_ei=((FCf_CT_Vbi_ei*(((FCa1*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)));
#if defined(_DERIVATE)
  FCf_ci_Vbi_ei_Vci_ei=(+FCf_CT_Vbi_ei_Vci_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ei*(((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei)))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT_Vci_ei*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT*(+(+(+FCa1_Vbi_ei_Vci_ei*FCf1+FCa1_Vbi_ei*FCf1_Vci_ei+FCa1_Vci_ei*FCf1_Vbi_ei+FCa1*FCf1_Vbi_ei_Vci_ei)-FCf2_Vbi_ei_Vci_ei)+FCf3_Vbi_ei_Vci_ei));
  FCf_ci_Vbi_ei_Vtnode_GND=(+FCf_CT_Vbi_ei_Vtnode_GND*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ei*(((((FCa1_Vtnode_GND*FCf1)+(FCa1*FCf1_Vtnode_GND)))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT*(+(+(+FCa1_Vbi_ei_Vtnode_GND*FCf1+FCa1_Vbi_ei*FCf1_Vtnode_GND+FCa1_Vtnode_GND*FCf1_Vbi_ei+FCa1*FCf1_Vbi_ei_Vtnode_GND)-FCf2_Vbi_ei_Vtnode_GND)+FCf3_Vbi_ei_Vtnode_GND));
  FCf_ci_Vbi_ei_Vbi_ei=(+FCf_CT_Vbi_ei_Vbi_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ei*(((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei)))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT_Vbi_ei*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT*(+(+(+FCa1_Vbi_ei_Vbi_ei*FCf1+FCa1_Vbi_ei*FCf1_Vbi_ei+FCa1_Vbi_ei*FCf1_Vbi_ei+FCa1*FCf1_Vbi_ei_Vbi_ei)-FCf2_Vbi_ei_Vbi_ei)+FCf3_Vbi_ei_Vbi_ei));
  FCf_ci_Vbi_ei_Vbi_ci=(+FCf_CT_Vbi_ei_Vbi_ci*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ei*(((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci)))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT_Vbi_ci*((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT*(+(+(+FCa1_Vbi_ei_Vbi_ci*FCf1+FCa1_Vbi_ei*FCf1_Vbi_ci+FCa1_Vbi_ci*FCf1_Vbi_ei+FCa1*FCf1_Vbi_ei_Vbi_ci)-FCf2_Vbi_ei_Vbi_ci)+FCf3_Vbi_ei_Vbi_ci));
#endif
FCf_ci_Vbi_ci=((FCf_CT_Vbi_ci*(((FCa1*FCf1)-FCf2)+FCf3))+(FCf_CT*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)));
#if defined(_DERIVATE)
  FCf_ci_Vbi_ci_Vci_ei=(+FCf_CT_Vbi_ci_Vci_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ci*(((((FCa1_Vci_ei*FCf1)+(FCa1*FCf1_Vci_ei)))-FCf2_Vci_ei)+FCf3_Vci_ei)+FCf_CT_Vci_ei*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT*(+(+(+FCa1_Vbi_ci_Vci_ei*FCf1+FCa1_Vbi_ci*FCf1_Vci_ei+FCa1_Vci_ei*FCf1_Vbi_ci+FCa1*FCf1_Vbi_ci_Vci_ei)-FCf2_Vbi_ci_Vci_ei)+FCf3_Vbi_ci_Vci_ei));
  FCf_ci_Vbi_ci_Vtnode_GND=(+FCf_CT_Vbi_ci_Vtnode_GND*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ci*(((((FCa1_Vtnode_GND*FCf1)+(FCa1*FCf1_Vtnode_GND)))-FCf2_Vtnode_GND)+FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT*(+(+(+FCa1_Vbi_ci_Vtnode_GND*FCf1+FCa1_Vbi_ci*FCf1_Vtnode_GND+FCa1_Vtnode_GND*FCf1_Vbi_ci+FCa1*FCf1_Vbi_ci_Vtnode_GND)-FCf2_Vbi_ci_Vtnode_GND)+FCf3_Vbi_ci_Vtnode_GND));
  FCf_ci_Vbi_ci_Vbi_ei=(+FCf_CT_Vbi_ci_Vbi_ei*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ci*(((((FCa1_Vbi_ei*FCf1)+(FCa1*FCf1_Vbi_ei)))-FCf2_Vbi_ei)+FCf3_Vbi_ei)+FCf_CT_Vbi_ei*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT*(+(+(+FCa1_Vbi_ci_Vbi_ei*FCf1+FCa1_Vbi_ci*FCf1_Vbi_ei+FCa1_Vbi_ei*FCf1_Vbi_ci+FCa1*FCf1_Vbi_ci_Vbi_ei)-FCf2_Vbi_ci_Vbi_ei)+FCf3_Vbi_ci_Vbi_ei));
  FCf_ci_Vbi_ci_Vbi_ci=(+FCf_CT_Vbi_ci_Vbi_ci*(((FCa1*FCf1)-FCf2)+FCf3)+FCf_CT_Vbi_ci*(((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci)))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT_Vbi_ci*((((FCa1_Vbi_ci*FCf1)+(FCa1*FCf1_Vbi_ci))-FCf2_Vbi_ci)+FCf3_Vbi_ci)+FCf_CT*(+(+(+FCa1_Vbi_ci_Vbi_ci*FCf1+FCa1_Vbi_ci*FCf1_Vbi_ci+FCa1_Vbi_ci*FCf1_Vbi_ci+FCa1*FCf1_Vbi_ci_Vbi_ci)-FCf2_Vbi_ci_Vbi_ci)+FCf3_Vbi_ci_Vbi_ci));
#endif
#endif
FCf_ci=(FCf_CT*(((FCa1*FCf1)-FCf2)+FCf3));
#if defined(_DERIVATEFORDDX)
FCdfc_dw_Vci_ei=((FCf_CT_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)));
#if defined(_DERIVATE)
  FCdfc_dw_Vci_ei_Vci_ei=(+FCf_CT_Vci_ei_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vci_ei*((((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei)))+(((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei))))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT*(+(+(+(+FCa1_Vci_ei_Vci_ei*FCdf1_dw+FCa1_Vci_ei*FCdf1_dw_Vci_ei+FCa1_Vci_ei*FCdf1_dw_Vci_ei+FCa1*FCdf1_dw_Vci_ei_Vci_ei)+(+FCda1_dw_Vci_ei_Vci_ei*FCf1+FCda1_dw_Vci_ei*FCf1_Vci_ei+FCda1_dw_Vci_ei*FCf1_Vci_ei+FCda1_dw*FCf1_Vci_ei_Vci_ei))-FCdf2_dw_Vci_ei_Vci_ei)+FCdf3_dw_Vci_ei_Vci_ei));
  FCdfc_dw_Vci_ei_Vtnode_GND=(+FCf_CT_Vci_ei_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vci_ei*((((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND)))+(((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND))))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT*(+(+(+(+FCa1_Vci_ei_Vtnode_GND*FCdf1_dw+FCa1_Vci_ei*FCdf1_dw_Vtnode_GND+FCa1_Vtnode_GND*FCdf1_dw_Vci_ei+FCa1*FCdf1_dw_Vci_ei_Vtnode_GND)+(+FCda1_dw_Vci_ei_Vtnode_GND*FCf1+FCda1_dw_Vci_ei*FCf1_Vtnode_GND+FCda1_dw_Vtnode_GND*FCf1_Vci_ei+FCda1_dw*FCf1_Vci_ei_Vtnode_GND))-FCdf2_dw_Vci_ei_Vtnode_GND)+FCdf3_dw_Vci_ei_Vtnode_GND));
  FCdfc_dw_Vci_ei_Vbi_ei=(+FCf_CT_Vci_ei_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vci_ei*((((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei)))+(((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei))))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT*(+(+(+(+FCa1_Vci_ei_Vbi_ei*FCdf1_dw+FCa1_Vci_ei*FCdf1_dw_Vbi_ei+FCa1_Vbi_ei*FCdf1_dw_Vci_ei+FCa1*FCdf1_dw_Vci_ei_Vbi_ei)+(+FCda1_dw_Vci_ei_Vbi_ei*FCf1+FCda1_dw_Vci_ei*FCf1_Vbi_ei+FCda1_dw_Vbi_ei*FCf1_Vci_ei+FCda1_dw*FCf1_Vci_ei_Vbi_ei))-FCdf2_dw_Vci_ei_Vbi_ei)+FCdf3_dw_Vci_ei_Vbi_ei));
  FCdfc_dw_Vci_ei_Vbi_ci=(+FCf_CT_Vci_ei_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vci_ei*((((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci)))+(((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci))))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei))+((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei)))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT*(+(+(+(+FCa1_Vci_ei_Vbi_ci*FCdf1_dw+FCa1_Vci_ei*FCdf1_dw_Vbi_ci+FCa1_Vbi_ci*FCdf1_dw_Vci_ei+FCa1*FCdf1_dw_Vci_ei_Vbi_ci)+(+FCda1_dw_Vci_ei_Vbi_ci*FCf1+FCda1_dw_Vci_ei*FCf1_Vbi_ci+FCda1_dw_Vbi_ci*FCf1_Vci_ei+FCda1_dw*FCf1_Vci_ei_Vbi_ci))-FCdf2_dw_Vci_ei_Vbi_ci)+FCdf3_dw_Vci_ei_Vbi_ci));
#endif
#if defined(_DERIVATE)
FCdfc_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND))+((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND)))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)));
#endif
FCdfc_dw_Vbi_ei=((FCf_CT_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)));
#if defined(_DERIVATE)
  FCdfc_dw_Vbi_ei_Vci_ei=(+FCf_CT_Vbi_ei_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ei*((((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei)))+(((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei))))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT*(+(+(+(+FCa1_Vbi_ei_Vci_ei*FCdf1_dw+FCa1_Vbi_ei*FCdf1_dw_Vci_ei+FCa1_Vci_ei*FCdf1_dw_Vbi_ei+FCa1*FCdf1_dw_Vbi_ei_Vci_ei)+(+FCda1_dw_Vbi_ei_Vci_ei*FCf1+FCda1_dw_Vbi_ei*FCf1_Vci_ei+FCda1_dw_Vci_ei*FCf1_Vbi_ei+FCda1_dw*FCf1_Vbi_ei_Vci_ei))-FCdf2_dw_Vbi_ei_Vci_ei)+FCdf3_dw_Vbi_ei_Vci_ei));
  FCdfc_dw_Vbi_ei_Vtnode_GND=(+FCf_CT_Vbi_ei_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ei*((((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND)))+(((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND))))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT*(+(+(+(+FCa1_Vbi_ei_Vtnode_GND*FCdf1_dw+FCa1_Vbi_ei*FCdf1_dw_Vtnode_GND+FCa1_Vtnode_GND*FCdf1_dw_Vbi_ei+FCa1*FCdf1_dw_Vbi_ei_Vtnode_GND)+(+FCda1_dw_Vbi_ei_Vtnode_GND*FCf1+FCda1_dw_Vbi_ei*FCf1_Vtnode_GND+FCda1_dw_Vtnode_GND*FCf1_Vbi_ei+FCda1_dw*FCf1_Vbi_ei_Vtnode_GND))-FCdf2_dw_Vbi_ei_Vtnode_GND)+FCdf3_dw_Vbi_ei_Vtnode_GND));
  FCdfc_dw_Vbi_ei_Vbi_ei=(+FCf_CT_Vbi_ei_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ei*((((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei)))+(((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei))))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT*(+(+(+(+FCa1_Vbi_ei_Vbi_ei*FCdf1_dw+FCa1_Vbi_ei*FCdf1_dw_Vbi_ei+FCa1_Vbi_ei*FCdf1_dw_Vbi_ei+FCa1*FCdf1_dw_Vbi_ei_Vbi_ei)+(+FCda1_dw_Vbi_ei_Vbi_ei*FCf1+FCda1_dw_Vbi_ei*FCf1_Vbi_ei+FCda1_dw_Vbi_ei*FCf1_Vbi_ei+FCda1_dw*FCf1_Vbi_ei_Vbi_ei))-FCdf2_dw_Vbi_ei_Vbi_ei)+FCdf3_dw_Vbi_ei_Vbi_ei));
  FCdfc_dw_Vbi_ei_Vbi_ci=(+FCf_CT_Vbi_ei_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ei*((((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci)))+(((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci))))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei))+((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei)))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT*(+(+(+(+FCa1_Vbi_ei_Vbi_ci*FCdf1_dw+FCa1_Vbi_ei*FCdf1_dw_Vbi_ci+FCa1_Vbi_ci*FCdf1_dw_Vbi_ei+FCa1*FCdf1_dw_Vbi_ei_Vbi_ci)+(+FCda1_dw_Vbi_ei_Vbi_ci*FCf1+FCda1_dw_Vbi_ei*FCf1_Vbi_ci+FCda1_dw_Vbi_ci*FCf1_Vbi_ei+FCda1_dw*FCf1_Vbi_ei_Vbi_ci))-FCdf2_dw_Vbi_ei_Vbi_ci)+FCdf3_dw_Vbi_ei_Vbi_ci));
#endif
FCdfc_dw_Vbi_ci=((FCf_CT_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw))+(FCf_CT*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)));
#if defined(_DERIVATE)
  FCdfc_dw_Vbi_ci_Vci_ei=(+FCf_CT_Vbi_ci_Vci_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ci*((((((FCa1_Vci_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vci_ei)))+(((FCda1_dw_Vci_ei*FCf1)+(FCda1_dw*FCf1_Vci_ei))))-FCdf2_dw_Vci_ei)+FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT*(+(+(+(+FCa1_Vbi_ci_Vci_ei*FCdf1_dw+FCa1_Vbi_ci*FCdf1_dw_Vci_ei+FCa1_Vci_ei*FCdf1_dw_Vbi_ci+FCa1*FCdf1_dw_Vbi_ci_Vci_ei)+(+FCda1_dw_Vbi_ci_Vci_ei*FCf1+FCda1_dw_Vbi_ci*FCf1_Vci_ei+FCda1_dw_Vci_ei*FCf1_Vbi_ci+FCda1_dw*FCf1_Vbi_ci_Vci_ei))-FCdf2_dw_Vbi_ci_Vci_ei)+FCdf3_dw_Vbi_ci_Vci_ei));
  FCdfc_dw_Vbi_ci_Vtnode_GND=(+FCf_CT_Vbi_ci_Vtnode_GND*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ci*((((((FCa1_Vtnode_GND*FCdf1_dw)+(FCa1*FCdf1_dw_Vtnode_GND)))+(((FCda1_dw_Vtnode_GND*FCf1)+(FCda1_dw*FCf1_Vtnode_GND))))-FCdf2_dw_Vtnode_GND)+FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT*(+(+(+(+FCa1_Vbi_ci_Vtnode_GND*FCdf1_dw+FCa1_Vbi_ci*FCdf1_dw_Vtnode_GND+FCa1_Vtnode_GND*FCdf1_dw_Vbi_ci+FCa1*FCdf1_dw_Vbi_ci_Vtnode_GND)+(+FCda1_dw_Vbi_ci_Vtnode_GND*FCf1+FCda1_dw_Vbi_ci*FCf1_Vtnode_GND+FCda1_dw_Vtnode_GND*FCf1_Vbi_ci+FCda1_dw*FCf1_Vbi_ci_Vtnode_GND))-FCdf2_dw_Vbi_ci_Vtnode_GND)+FCdf3_dw_Vbi_ci_Vtnode_GND));
  FCdfc_dw_Vbi_ci_Vbi_ei=(+FCf_CT_Vbi_ci_Vbi_ei*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ci*((((((FCa1_Vbi_ei*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ei)))+(((FCda1_dw_Vbi_ei*FCf1)+(FCda1_dw*FCf1_Vbi_ei))))-FCdf2_dw_Vbi_ei)+FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT*(+(+(+(+FCa1_Vbi_ci_Vbi_ei*FCdf1_dw+FCa1_Vbi_ci*FCdf1_dw_Vbi_ei+FCa1_Vbi_ei*FCdf1_dw_Vbi_ci+FCa1*FCdf1_dw_Vbi_ci_Vbi_ei)+(+FCda1_dw_Vbi_ci_Vbi_ei*FCf1+FCda1_dw_Vbi_ci*FCf1_Vbi_ei+FCda1_dw_Vbi_ei*FCf1_Vbi_ci+FCda1_dw*FCf1_Vbi_ci_Vbi_ei))-FCdf2_dw_Vbi_ci_Vbi_ei)+FCdf3_dw_Vbi_ci_Vbi_ei));
  FCdfc_dw_Vbi_ci_Vbi_ci=(+FCf_CT_Vbi_ci_Vbi_ci*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw)+FCf_CT_Vbi_ci*((((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci)))+(((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci))))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(((((FCa1_Vbi_ci*FCdf1_dw)+(FCa1*FCdf1_dw_Vbi_ci))+((FCda1_dw_Vbi_ci*FCf1)+(FCda1_dw*FCf1_Vbi_ci)))-FCdf2_dw_Vbi_ci)+FCdf3_dw_Vbi_ci)+FCf_CT*(+(+(+(+FCa1_Vbi_ci_Vbi_ci*FCdf1_dw+FCa1_Vbi_ci*FCdf1_dw_Vbi_ci+FCa1_Vbi_ci*FCdf1_dw_Vbi_ci+FCa1*FCdf1_dw_Vbi_ci_Vbi_ci)+(+FCda1_dw_Vbi_ci_Vbi_ci*FCf1+FCda1_dw_Vbi_ci*FCf1_Vbi_ci+FCda1_dw_Vbi_ci*FCf1_Vbi_ci+FCda1_dw*FCf1_Vbi_ci_Vbi_ci))-FCdf2_dw_Vbi_ci_Vbi_ci)+FCdf3_dw_Vbi_ci_Vbi_ci));
#endif
#endif
FCdfc_dw=(FCf_CT*((((FCa1*FCdf1_dw)+(FCda1_dw*FCf1))-FCdf2_dw)+FCdf3_dw));
#if defined(_DERIVATEFORDDX)
FCdw_ditf_Vci_ei=((FCdw_daick_Vci_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vci_ei));
#if defined(_DERIVATE)
  FCdw_ditf_Vci_ei_Vci_ei=(+FCdw_daick_Vci_ei_Vci_ei*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vci_ei+FCdw_daick_Vci_ei*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vci_ei);
  FCdw_ditf_Vci_ei_Vtnode_GND=(+FCdw_daick_Vci_ei_Vtnode_GND*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vtnode_GND+FCdw_daick_Vtnode_GND*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vtnode_GND);
  FCdw_ditf_Vci_ei_Vbi_ei=(+FCdw_daick_Vci_ei_Vbi_ei*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ei+FCdw_daick_Vbi_ei*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vbi_ei);
  FCdw_ditf_Vci_ei_Vbi_ci=(+FCdw_daick_Vci_ei_Vbi_ci*FCdaick_ditf+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ci+FCdw_daick_Vbi_ci*FCdaick_ditf_Vci_ei+FCdw_daick*FCdaick_ditf_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdw_ditf_Vtnode_GND=((FCdw_daick_Vtnode_GND*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vtnode_GND));
#endif
FCdw_ditf_Vbi_ei=((FCdw_daick_Vbi_ei*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ei));
#if defined(_DERIVATE)
  FCdw_ditf_Vbi_ei_Vci_ei=(+FCdw_daick_Vbi_ei_Vci_ei*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vci_ei+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vci_ei);
  FCdw_ditf_Vbi_ei_Vtnode_GND=(+FCdw_daick_Vbi_ei_Vtnode_GND*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vtnode_GND+FCdw_daick_Vtnode_GND*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vtnode_GND);
  FCdw_ditf_Vbi_ei_Vbi_ei=(+FCdw_daick_Vbi_ei_Vbi_ei*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ei+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vbi_ei);
  FCdw_ditf_Vbi_ei_Vbi_ci=(+FCdw_daick_Vbi_ei_Vbi_ci*FCdaick_ditf+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ci+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ei+FCdw_daick*FCdaick_ditf_Vbi_ei_Vbi_ci);
#endif
FCdw_ditf_Vbi_ci=((FCdw_daick_Vbi_ci*FCdaick_ditf)+(FCdw_daick*FCdaick_ditf_Vbi_ci));
#if defined(_DERIVATE)
  FCdw_ditf_Vbi_ci_Vci_ei=(+FCdw_daick_Vbi_ci_Vci_ei*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vci_ei+FCdw_daick_Vci_ei*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vci_ei);
  FCdw_ditf_Vbi_ci_Vtnode_GND=(+FCdw_daick_Vbi_ci_Vtnode_GND*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vtnode_GND+FCdw_daick_Vtnode_GND*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vtnode_GND);
  FCdw_ditf_Vbi_ci_Vbi_ei=(+FCdw_daick_Vbi_ci_Vbi_ei*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ei+FCdw_daick_Vbi_ei*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vbi_ei);
  FCdw_ditf_Vbi_ci_Vbi_ci=(+FCdw_daick_Vbi_ci_Vbi_ci*FCdaick_ditf+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ci+FCdw_daick_Vbi_ci*FCdaick_ditf_Vbi_ci+FCdw_daick*FCdaick_ditf_Vbi_ci_Vbi_ci);
#endif
#endif
FCdw_ditf=(FCdw_daick*FCdaick_ditf);
#if defined(_DERIVATEFORDDX)
FCdfc_ditf_Vci_ei=((FCdfc_dw_Vci_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vci_ei));
#if defined(_DERIVATE)
  FCdfc_ditf_Vci_ei_Vci_ei=(+FCdfc_dw_Vci_ei_Vci_ei*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfc_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vci_ei);
  FCdfc_ditf_Vci_ei_Vtnode_GND=(+FCdfc_dw_Vci_ei_Vtnode_GND*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vtnode_GND+FCdfc_dw_Vtnode_GND*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vtnode_GND);
  FCdfc_ditf_Vci_ei_Vbi_ei=(+FCdfc_dw_Vci_ei_Vbi_ei*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfc_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vbi_ei);
  FCdfc_ditf_Vci_ei_Vbi_ci=(+FCdfc_dw_Vci_ei_Vbi_ci*FCdw_ditf+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfc_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfc_dw*FCdw_ditf_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdfc_ditf_Vtnode_GND=((FCdfc_dw_Vtnode_GND*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vtnode_GND));
#endif
FCdfc_ditf_Vbi_ei=((FCdfc_dw_Vbi_ei*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ei));
#if defined(_DERIVATE)
  FCdfc_ditf_Vbi_ei_Vci_ei=(+FCdfc_dw_Vbi_ei_Vci_ei*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vci_ei);
  FCdfc_ditf_Vbi_ei_Vtnode_GND=(+FCdfc_dw_Vbi_ei_Vtnode_GND*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vtnode_GND+FCdfc_dw_Vtnode_GND*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vtnode_GND);
  FCdfc_ditf_Vbi_ei_Vbi_ei=(+FCdfc_dw_Vbi_ei_Vbi_ei*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vbi_ei);
  FCdfc_ditf_Vbi_ei_Vbi_ci=(+FCdfc_dw_Vbi_ei_Vbi_ci*FCdw_ditf+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfc_dw*FCdw_ditf_Vbi_ei_Vbi_ci);
#endif
FCdfc_ditf_Vbi_ci=((FCdfc_dw_Vbi_ci*FCdw_ditf)+(FCdfc_dw*FCdw_ditf_Vbi_ci));
#if defined(_DERIVATE)
  FCdfc_ditf_Vbi_ci_Vci_ei=(+FCdfc_dw_Vbi_ci_Vci_ei*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfc_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vci_ei);
  FCdfc_ditf_Vbi_ci_Vtnode_GND=(+FCdfc_dw_Vbi_ci_Vtnode_GND*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vtnode_GND+FCdfc_dw_Vtnode_GND*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vtnode_GND);
  FCdfc_ditf_Vbi_ci_Vbi_ei=(+FCdfc_dw_Vbi_ci_Vbi_ei*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfc_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vbi_ei);
  FCdfc_ditf_Vbi_ci_Vbi_ci=(+FCdfc_dw_Vbi_ci_Vbi_ci*FCdw_ditf+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfc_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfc_dw*FCdw_ditf_Vbi_ci_Vbi_ci);
#endif
#endif
FCdfc_ditf=(FCdfc_dw*FCdw_ditf);
if
(((flcomp==0.0)||(flcomp==2.1)))
{
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=(latb*FCw_Vbi_ei);
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=(latb*FCw_Vbi_ci);
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=(latb*FCw_Vci_ei);
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(latb*FCw_Vtnode_GND);
#endif
#endif
a=(latb*FCw);
{
double m00_logE(d00_logE0,(1+(latb*FCw)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1+(latb*FCw)))
#endif
#if defined(_DERIVATEFORDDX)
lnz_Vci_ei=(latb*FCw_Vci_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vci_ei_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei)));
  lnz_Vci_ei_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND)));
  lnz_Vci_ei_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei)));
  lnz_Vci_ei_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci)));
#endif
#if defined(_DERIVATE)
lnz_Vtnode_GND=(latb*FCw_Vtnode_GND)*d10_logE0;
#endif
lnz_Vbi_ei=(latb*FCw_Vbi_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vbi_ei_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei)));
  lnz_Vbi_ei_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND)));
  lnz_Vbi_ei_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei)));
  lnz_Vbi_ei_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci)));
#endif
lnz_Vbi_ci=(latb*FCw_Vbi_ci)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vbi_ci_Vci_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vci_ei))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei)));
  lnz_Vbi_ci_Vtnode_GND=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vtnode_GND))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND)));
  lnz_Vbi_ci_Vbi_ei=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ei))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei)));
  lnz_Vbi_ci_Vbi_ci=(m20_logE((1+(latb*FCw)))*((latb*FCw_Vbi_ci))*(latb*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci)));
#endif
#endif
lnz=d00_logE0;
}
if
((a>1.0e-6))
{
#if defined(_DERIVATEFORDDX)
FCf2_Vbi_ei=((a_Vbi_ei-lnz_Vbi_ei)/latb);
#if defined(_DERIVATE)
  FCf2_Vbi_ei_Vbi_ei=((+a_Vbi_ei_Vbi_ei-lnz_Vbi_ei_Vbi_ei)/latb-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vbi_ci=((+a_Vbi_ei_Vbi_ci-lnz_Vbi_ei_Vbi_ci)/latb-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vci_ei=((+a_Vbi_ei_Vci_ei-lnz_Vbi_ei_Vci_ei)/latb-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ei_Vtnode_GND=((+a_Vbi_ei_Vtnode_GND-lnz_Vbi_ei_Vtnode_GND)/latb-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
#endif
FCf2_Vbi_ci=((a_Vbi_ci-lnz_Vbi_ci)/latb);
#if defined(_DERIVATE)
  FCf2_Vbi_ci_Vbi_ei=((+a_Vbi_ci_Vbi_ei-lnz_Vbi_ci_Vbi_ei)/latb-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vbi_ci=((+a_Vbi_ci_Vbi_ci-lnz_Vbi_ci_Vbi_ci)/latb-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vci_ei=((+a_Vbi_ci_Vci_ei-lnz_Vbi_ci_Vci_ei)/latb-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vbi_ci_Vtnode_GND=((+a_Vbi_ci_Vtnode_GND-lnz_Vbi_ci_Vtnode_GND)/latb-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
#endif
FCf2_Vci_ei=((a_Vci_ei-lnz_Vci_ei)/latb);
#if defined(_DERIVATE)
  FCf2_Vci_ei_Vbi_ei=((+a_Vci_ei_Vbi_ei-lnz_Vci_ei_Vbi_ei)/latb-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vbi_ci=((+a_Vci_ei_Vbi_ci-lnz_Vci_ei_Vbi_ci)/latb-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vci_ei=((+a_Vci_ei_Vci_ei-lnz_Vci_ei_Vci_ei)/latb-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
  FCf2_Vci_ei_Vtnode_GND=((+a_Vci_ei_Vtnode_GND-lnz_Vci_ei_Vtnode_GND)/latb-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latb/latb+2*(a-lnz)*0.0*0.0/latb/latb/latb);
#endif
#if defined(_DERIVATE)
FCf2_Vtnode_GND=((a_Vtnode_GND-lnz_Vtnode_GND)/latb);
#endif
#endif
FCf2=((a-lnz)/latb);
#if defined(_DERIVATEFORDDX)
FCdf2_dw_Vci_ei=((a_Vci_ei*(1.0+a)-a*a_Vci_ei)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf2_dw_Vci_ei_Vci_ei=(a_Vci_ei_Vci_ei/(1.0+a)-(a_Vci_ei*a_Vci_ei+a_Vci_ei*a_Vci_ei+a*(+0.0+a_Vci_ei_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vci_ei_Vtnode_GND=(a_Vci_ei_Vtnode_GND/(1.0+a)-(a_Vci_ei*a_Vtnode_GND+a_Vtnode_GND*a_Vci_ei+a*(+0.0+a_Vci_ei_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vci_ei_Vbi_ei=(a_Vci_ei_Vbi_ei/(1.0+a)-(a_Vci_ei*a_Vbi_ei+a_Vbi_ei*a_Vci_ei+a*(+0.0+a_Vci_ei_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vci_ei_Vbi_ci=(a_Vci_ei_Vbi_ci/(1.0+a)-(a_Vci_ei*a_Vbi_ci+a_Vbi_ci*a_Vci_ei+a*(+0.0+a_Vci_ei_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
#if defined(_DERIVATE)
FCdf2_dw_Vtnode_GND=((a_Vtnode_GND*(1.0+a)-a*a_Vtnode_GND)/(1.0+a)/(1.0+a));
#endif
FCdf2_dw_Vbi_ei=((a_Vbi_ei*(1.0+a)-a*a_Vbi_ei)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ei_Vci_ei=(a_Vbi_ei_Vci_ei/(1.0+a)-(a_Vbi_ei*a_Vci_ei+a_Vci_ei*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ei_Vtnode_GND=(a_Vbi_ei_Vtnode_GND/(1.0+a)-(a_Vbi_ei*a_Vtnode_GND+a_Vtnode_GND*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ei_Vbi_ei=(a_Vbi_ei_Vbi_ei/(1.0+a)-(a_Vbi_ei*a_Vbi_ei+a_Vbi_ei*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ei_Vbi_ci=(a_Vbi_ei_Vbi_ci/(1.0+a)-(a_Vbi_ei*a_Vbi_ci+a_Vbi_ci*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
FCdf2_dw_Vbi_ci=((a_Vbi_ci*(1.0+a)-a*a_Vbi_ci)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ci_Vci_ei=(a_Vbi_ci_Vci_ei/(1.0+a)-(a_Vbi_ci*a_Vci_ei+a_Vci_ei*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ci_Vtnode_GND=(a_Vbi_ci_Vtnode_GND/(1.0+a)-(a_Vbi_ci*a_Vtnode_GND+a_Vtnode_GND*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ci_Vbi_ei=(a_Vbi_ci_Vbi_ei/(1.0+a)-(a_Vbi_ci*a_Vbi_ei+a_Vbi_ei*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf2_dw_Vbi_ci_Vbi_ci=(a_Vbi_ci_Vbi_ci/(1.0+a)-(a_Vbi_ci*a_Vbi_ci+a_Vbi_ci*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
#endif
FCdf2_dw=(a/(1.0+a));
}
else
{
#if defined(_DERIVATEFORDDX)
FCf2_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCf2_Vbi_ei_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vbi_ei)*FCw+(0.5*a_Vbi_ei)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vbi_ei);
  FCf2_Vbi_ei_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vbi_ci)*FCw+(0.5*a_Vbi_ei)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vbi_ci);
  FCf2_Vbi_ei_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vci_ei)*FCw+(0.5*a_Vbi_ei)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vci_ei);
  FCf2_Vbi_ei_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vtnode_GND)*FCw+(0.5*a_Vbi_ei)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vtnode_GND);
#endif
FCf2_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCf2_Vbi_ci_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vbi_ei)*FCw+(0.5*a_Vbi_ci)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vbi_ei);
  FCf2_Vbi_ci_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vbi_ci)*FCw+(0.5*a_Vbi_ci)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vbi_ci);
  FCf2_Vbi_ci_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vci_ei)*FCw+(0.5*a_Vbi_ci)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vci_ei);
  FCf2_Vbi_ci_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vtnode_GND)*FCw+(0.5*a_Vbi_ci)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vtnode_GND);
#endif
FCf2_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCf2_Vci_ei_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.5*a_Vci_ei_Vbi_ei)*FCw+(0.5*a_Vci_ei)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vbi_ei);
  FCf2_Vci_ei_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.5*a_Vci_ei_Vbi_ci)*FCw+(0.5*a_Vci_ei)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vbi_ci);
  FCf2_Vci_ei_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.5*a_Vci_ei_Vci_ei)*FCw+(0.5*a_Vci_ei)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vci_ei);
  FCf2_Vci_ei_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.5*a_Vci_ei_Vtnode_GND)*FCw+(0.5*a_Vci_ei)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCf2_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
#endif
#endif
FCf2=((0.5*a)*FCw);
#if defined(_DERIVATEFORDDX)
FCdf2_dw_Vci_ei=a_Vci_ei;
#if defined(_DERIVATE)
  FCdf2_dw_Vci_ei_Vci_ei=a_Vci_ei_Vci_ei;
  FCdf2_dw_Vci_ei_Vtnode_GND=a_Vci_ei_Vtnode_GND;
  FCdf2_dw_Vci_ei_Vbi_ei=a_Vci_ei_Vbi_ei;
  FCdf2_dw_Vci_ei_Vbi_ci=a_Vci_ei_Vbi_ci;
#endif
#if defined(_DERIVATE)
FCdf2_dw_Vtnode_GND=a_Vtnode_GND;
#endif
FCdf2_dw_Vbi_ei=a_Vbi_ei;
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ei_Vci_ei=a_Vbi_ei_Vci_ei;
  FCdf2_dw_Vbi_ei_Vtnode_GND=a_Vbi_ei_Vtnode_GND;
  FCdf2_dw_Vbi_ei_Vbi_ei=a_Vbi_ei_Vbi_ei;
  FCdf2_dw_Vbi_ei_Vbi_ci=a_Vbi_ei_Vbi_ci;
#endif
FCdf2_dw_Vbi_ci=a_Vbi_ci;
#if defined(_DERIVATE)
  FCdf2_dw_Vbi_ci_Vci_ei=a_Vbi_ci_Vci_ei;
  FCdf2_dw_Vbi_ci_Vtnode_GND=a_Vbi_ci_Vtnode_GND;
  FCdf2_dw_Vbi_ci_Vbi_ei=a_Vbi_ci_Vbi_ei;
  FCdf2_dw_Vbi_ci_Vbi_ci=a_Vbi_ci_Vbi_ci;
#endif
#endif
FCdf2_dw=a;
}
#if defined(_DERIVATEFORDDX)
a_Vbi_ei=(latl*FCw_Vbi_ei);
#if defined(_DERIVATE)
  a_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei);
  a_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci);
  a_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei);
  a_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND);
#endif
a_Vbi_ci=(latl*FCw_Vbi_ci);
#if defined(_DERIVATE)
  a_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei);
  a_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci);
  a_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei);
  a_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND);
#endif
a_Vci_ei=(latl*FCw_Vci_ei);
#if defined(_DERIVATE)
  a_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei);
  a_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci);
  a_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei);
  a_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
a_Vtnode_GND=(latl*FCw_Vtnode_GND);
#endif
#endif
a=(latl*FCw);
{
double m00_logE(d00_logE0,(1+(latl*FCw)))
#if defined(_DERIVATEFORDDX)
double m10_logE(d10_logE0,d00_logE0,(1+(latl*FCw)))
#endif
#if defined(_DERIVATEFORDDX)
lnz_Vci_ei=(latl*FCw_Vci_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vci_ei_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vci_ei)));
  lnz_Vci_ei_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vtnode_GND)));
  lnz_Vci_ei_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ei)));
  lnz_Vci_ei_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vci_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latl*FCw_Vci_ei_Vbi_ci)));
#endif
#if defined(_DERIVATE)
lnz_Vtnode_GND=(latl*FCw_Vtnode_GND)*d10_logE0;
#endif
lnz_Vbi_ei=(latl*FCw_Vbi_ei)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vbi_ei_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vci_ei)));
  lnz_Vbi_ei_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vtnode_GND)));
  lnz_Vbi_ei_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ei)));
  lnz_Vbi_ei_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vbi_ei)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latl*FCw_Vbi_ei_Vbi_ci)));
#endif
lnz_Vbi_ci=(latl*FCw_Vbi_ci)*d10_logE0;
#if defined(_DERIVATE)
  lnz_Vbi_ci_Vci_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vci_ei))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vci_ei)));
  lnz_Vbi_ci_Vtnode_GND=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vtnode_GND))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vtnode_GND)));
  lnz_Vbi_ci_Vbi_ei=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ei))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ei)));
  lnz_Vbi_ci_Vbi_ci=(m20_logE((1+(latl*FCw)))*((latl*FCw_Vbi_ci))*(latl*FCw_Vbi_ci)+d10_logE0*(+0.0+(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latl*FCw_Vbi_ci_Vbi_ci)));
#endif
#endif
lnz=d00_logE0;
}
if
((a>1.0e-6))
{
#if defined(_DERIVATEFORDDX)
FCf3_Vbi_ei=((a_Vbi_ei-lnz_Vbi_ei)/latl);
#if defined(_DERIVATE)
  FCf3_Vbi_ei_Vbi_ei=((+a_Vbi_ei_Vbi_ei-lnz_Vbi_ei_Vbi_ei)/latl-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vbi_ci=((+a_Vbi_ei_Vbi_ci-lnz_Vbi_ei_Vbi_ci)/latl-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vci_ei=((+a_Vbi_ei_Vci_ei-lnz_Vbi_ei_Vci_ei)/latl-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ei_Vtnode_GND=((+a_Vbi_ei_Vtnode_GND-lnz_Vbi_ei_Vtnode_GND)/latl-((a_Vbi_ei-lnz_Vbi_ei)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
#endif
FCf3_Vbi_ci=((a_Vbi_ci-lnz_Vbi_ci)/latl);
#if defined(_DERIVATE)
  FCf3_Vbi_ci_Vbi_ei=((+a_Vbi_ci_Vbi_ei-lnz_Vbi_ci_Vbi_ei)/latl-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vbi_ci=((+a_Vbi_ci_Vbi_ci-lnz_Vbi_ci_Vbi_ci)/latl-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vci_ei=((+a_Vbi_ci_Vci_ei-lnz_Vbi_ci_Vci_ei)/latl-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vbi_ci_Vtnode_GND=((+a_Vbi_ci_Vtnode_GND-lnz_Vbi_ci_Vtnode_GND)/latl-((a_Vbi_ci-lnz_Vbi_ci)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
#endif
FCf3_Vci_ei=((a_Vci_ei-lnz_Vci_ei)/latl);
#if defined(_DERIVATE)
  FCf3_Vci_ei_Vbi_ei=((+a_Vci_ei_Vbi_ei-lnz_Vci_ei_Vbi_ei)/latl-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vbi_ei-lnz_Vbi_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vbi_ci=((+a_Vci_ei_Vbi_ci-lnz_Vci_ei_Vbi_ci)/latl-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vbi_ci-lnz_Vbi_ci)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vci_ei=((+a_Vci_ei_Vci_ei-lnz_Vci_ei_Vci_ei)/latl-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vci_ei-lnz_Vci_ei)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
  FCf3_Vci_ei_Vtnode_GND=((+a_Vci_ei_Vtnode_GND-lnz_Vci_ei_Vtnode_GND)/latl-((a_Vci_ei-lnz_Vci_ei)*0.0+(a_Vtnode_GND-lnz_Vtnode_GND)*0.0+(a-lnz)*0.0)/latl/latl+2*(a-lnz)*0.0*0.0/latl/latl/latl);
#endif
#if defined(_DERIVATE)
FCf3_Vtnode_GND=((a_Vtnode_GND-lnz_Vtnode_GND)/latl);
#endif
#endif
FCf3=((a-lnz)/latl);
#if defined(_DERIVATEFORDDX)
FCdf3_dw_Vci_ei=((a_Vci_ei*(1.0+a)-a*a_Vci_ei)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf3_dw_Vci_ei_Vci_ei=(a_Vci_ei_Vci_ei/(1.0+a)-(a_Vci_ei*a_Vci_ei+a_Vci_ei*a_Vci_ei+a*(+0.0+a_Vci_ei_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vci_ei_Vtnode_GND=(a_Vci_ei_Vtnode_GND/(1.0+a)-(a_Vci_ei*a_Vtnode_GND+a_Vtnode_GND*a_Vci_ei+a*(+0.0+a_Vci_ei_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vci_ei_Vbi_ei=(a_Vci_ei_Vbi_ei/(1.0+a)-(a_Vci_ei*a_Vbi_ei+a_Vbi_ei*a_Vci_ei+a*(+0.0+a_Vci_ei_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vci_ei_Vbi_ci=(a_Vci_ei_Vbi_ci/(1.0+a)-(a_Vci_ei*a_Vbi_ci+a_Vbi_ci*a_Vci_ei+a*(+0.0+a_Vci_ei_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vci_ei*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
#if defined(_DERIVATE)
FCdf3_dw_Vtnode_GND=((a_Vtnode_GND*(1.0+a)-a*a_Vtnode_GND)/(1.0+a)/(1.0+a));
#endif
FCdf3_dw_Vbi_ei=((a_Vbi_ei*(1.0+a)-a*a_Vbi_ei)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ei_Vci_ei=(a_Vbi_ei_Vci_ei/(1.0+a)-(a_Vbi_ei*a_Vci_ei+a_Vci_ei*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ei_Vtnode_GND=(a_Vbi_ei_Vtnode_GND/(1.0+a)-(a_Vbi_ei*a_Vtnode_GND+a_Vtnode_GND*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ei_Vbi_ei=(a_Vbi_ei_Vbi_ei/(1.0+a)-(a_Vbi_ei*a_Vbi_ei+a_Vbi_ei*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ei_Vbi_ci=(a_Vbi_ei_Vbi_ci/(1.0+a)-(a_Vbi_ei*a_Vbi_ci+a_Vbi_ci*a_Vbi_ei+a*(+0.0+a_Vbi_ei_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ei*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
FCdf3_dw_Vbi_ci=((a_Vbi_ci*(1.0+a)-a*a_Vbi_ci)/(1.0+a)/(1.0+a));
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ci_Vci_ei=(a_Vbi_ci_Vci_ei/(1.0+a)-(a_Vbi_ci*a_Vci_ei+a_Vci_ei*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vci_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vci_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ci_Vtnode_GND=(a_Vbi_ci_Vtnode_GND/(1.0+a)-(a_Vbi_ci*a_Vtnode_GND+a_Vtnode_GND*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vtnode_GND))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vtnode_GND/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ci_Vbi_ei=(a_Vbi_ci_Vbi_ei/(1.0+a)-(a_Vbi_ci*a_Vbi_ei+a_Vbi_ei*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vbi_ei))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vbi_ei/(1.0+a)/(1.0+a)/(1.0+a));
  FCdf3_dw_Vbi_ci_Vbi_ci=(a_Vbi_ci_Vbi_ci/(1.0+a)-(a_Vbi_ci*a_Vbi_ci+a_Vbi_ci*a_Vbi_ci+a*(+0.0+a_Vbi_ci_Vbi_ci))/(1.0+a)/(1.0+a)+2*a*a_Vbi_ci*a_Vbi_ci/(1.0+a)/(1.0+a)/(1.0+a));
#endif
#endif
FCdf3_dw=(a/(1.0+a));
}
else
{
#if defined(_DERIVATEFORDDX)
FCf3_Vbi_ei=(((0.5*a_Vbi_ei)*FCw)+((0.5*a)*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCf3_Vbi_ei_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vbi_ei)*FCw+(0.5*a_Vbi_ei)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vbi_ei);
  FCf3_Vbi_ei_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vbi_ci)*FCw+(0.5*a_Vbi_ei)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vbi_ci);
  FCf3_Vbi_ei_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vci_ei)*FCw+(0.5*a_Vbi_ei)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vci_ei);
  FCf3_Vbi_ei_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ei+0.5*a_Vbi_ei_Vtnode_GND)*FCw+(0.5*a_Vbi_ei)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vbi_ei+(0.5*a)*FCw_Vbi_ei_Vtnode_GND);
#endif
FCf3_Vbi_ci=(((0.5*a_Vbi_ci)*FCw)+((0.5*a)*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCf3_Vbi_ci_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vbi_ei)*FCw+(0.5*a_Vbi_ci)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vbi_ei);
  FCf3_Vbi_ci_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vbi_ci)*FCw+(0.5*a_Vbi_ci)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vbi_ci);
  FCf3_Vbi_ci_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vci_ei)*FCw+(0.5*a_Vbi_ci)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vci_ei);
  FCf3_Vbi_ci_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vbi_ci+0.5*a_Vbi_ci_Vtnode_GND)*FCw+(0.5*a_Vbi_ci)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vbi_ci+(0.5*a)*FCw_Vbi_ci_Vtnode_GND);
#endif
FCf3_Vci_ei=(((0.5*a_Vci_ei)*FCw)+((0.5*a)*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCf3_Vci_ei_Vbi_ei=(+(+0.0*a+0.0*a_Vbi_ei+0.0*a_Vci_ei+0.5*a_Vci_ei_Vbi_ei)*FCw+(0.5*a_Vci_ei)*FCw_Vbi_ei+((0.5*a_Vbi_ei))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vbi_ei);
  FCf3_Vci_ei_Vbi_ci=(+(+0.0*a+0.0*a_Vbi_ci+0.0*a_Vci_ei+0.5*a_Vci_ei_Vbi_ci)*FCw+(0.5*a_Vci_ei)*FCw_Vbi_ci+((0.5*a_Vbi_ci))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vbi_ci);
  FCf3_Vci_ei_Vci_ei=(+(+0.0*a+0.0*a_Vci_ei+0.0*a_Vci_ei+0.5*a_Vci_ei_Vci_ei)*FCw+(0.5*a_Vci_ei)*FCw_Vci_ei+((0.5*a_Vci_ei))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vci_ei);
  FCf3_Vci_ei_Vtnode_GND=(+(+0.0*a+0.0*a_Vtnode_GND+0.0*a_Vci_ei+0.5*a_Vci_ei_Vtnode_GND)*FCw+(0.5*a_Vci_ei)*FCw_Vtnode_GND+((0.5*a_Vtnode_GND))*FCw_Vci_ei+(0.5*a)*FCw_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCf3_Vtnode_GND=(((0.5*a_Vtnode_GND)*FCw)+((0.5*a)*FCw_Vtnode_GND));
#endif
#endif
FCf3=((0.5*a)*FCw);
#if defined(_DERIVATEFORDDX)
FCdf3_dw_Vci_ei=a_Vci_ei;
#if defined(_DERIVATE)
  FCdf3_dw_Vci_ei_Vci_ei=a_Vci_ei_Vci_ei;
  FCdf3_dw_Vci_ei_Vtnode_GND=a_Vci_ei_Vtnode_GND;
  FCdf3_dw_Vci_ei_Vbi_ei=a_Vci_ei_Vbi_ei;
  FCdf3_dw_Vci_ei_Vbi_ci=a_Vci_ei_Vbi_ci;
#endif
#if defined(_DERIVATE)
FCdf3_dw_Vtnode_GND=a_Vtnode_GND;
#endif
FCdf3_dw_Vbi_ei=a_Vbi_ei;
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ei_Vci_ei=a_Vbi_ei_Vci_ei;
  FCdf3_dw_Vbi_ei_Vtnode_GND=a_Vbi_ei_Vtnode_GND;
  FCdf3_dw_Vbi_ei_Vbi_ei=a_Vbi_ei_Vbi_ei;
  FCdf3_dw_Vbi_ei_Vbi_ci=a_Vbi_ei_Vbi_ci;
#endif
FCdf3_dw_Vbi_ci=a_Vbi_ci;
#if defined(_DERIVATE)
  FCdf3_dw_Vbi_ci_Vci_ei=a_Vbi_ci_Vci_ei;
  FCdf3_dw_Vbi_ci_Vtnode_GND=a_Vbi_ci_Vtnode_GND;
  FCdf3_dw_Vbi_ci_Vbi_ei=a_Vbi_ci_Vbi_ei;
  FCdf3_dw_Vbi_ci_Vbi_ci=a_Vbi_ci_Vbi_ci;
#endif
#endif
FCdf3_dw=a;
}
#if defined(_DERIVATEFORDDX)
FCf_CT_Vbi_ei=((FCf_CT_Vbi_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ei-FCf3_Vbi_ei)));
#if defined(_DERIVATE)
  FCf_CT_Vbi_ei_Vbi_ei=(+FCf_CT_Vbi_ei_Vbi_ei*(FCf2-FCf3)+FCf_CT_Vbi_ei*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT_Vbi_ei*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT*(+FCf2_Vbi_ei_Vbi_ei-FCf3_Vbi_ei_Vbi_ei));
  FCf_CT_Vbi_ei_Vbi_ci=(+FCf_CT_Vbi_ei_Vbi_ci*(FCf2-FCf3)+FCf_CT_Vbi_ei*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT_Vbi_ci*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT*(+FCf2_Vbi_ei_Vbi_ci-FCf3_Vbi_ei_Vbi_ci));
  FCf_CT_Vbi_ei_Vci_ei=(+FCf_CT_Vbi_ei_Vci_ei*(FCf2-FCf3)+FCf_CT_Vbi_ei*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT_Vci_ei*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT*(+FCf2_Vbi_ei_Vci_ei-FCf3_Vbi_ei_Vci_ei));
  FCf_CT_Vbi_ei_Vtnode_GND=(+FCf_CT_Vbi_ei_Vtnode_GND*(FCf2-FCf3)+FCf_CT_Vbi_ei*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT*(+FCf2_Vbi_ei_Vtnode_GND-FCf3_Vbi_ei_Vtnode_GND));
#endif
FCf_CT_Vbi_ci=((FCf_CT_Vbi_ci*(FCf2-FCf3))+(FCf_CT*(FCf2_Vbi_ci-FCf3_Vbi_ci)));
#if defined(_DERIVATE)
  FCf_CT_Vbi_ci_Vbi_ei=(+FCf_CT_Vbi_ci_Vbi_ei*(FCf2-FCf3)+FCf_CT_Vbi_ci*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT_Vbi_ei*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT*(+FCf2_Vbi_ci_Vbi_ei-FCf3_Vbi_ci_Vbi_ei));
  FCf_CT_Vbi_ci_Vbi_ci=(+FCf_CT_Vbi_ci_Vbi_ci*(FCf2-FCf3)+FCf_CT_Vbi_ci*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT_Vbi_ci*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT*(+FCf2_Vbi_ci_Vbi_ci-FCf3_Vbi_ci_Vbi_ci));
  FCf_CT_Vbi_ci_Vci_ei=(+FCf_CT_Vbi_ci_Vci_ei*(FCf2-FCf3)+FCf_CT_Vbi_ci*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT_Vci_ei*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT*(+FCf2_Vbi_ci_Vci_ei-FCf3_Vbi_ci_Vci_ei));
  FCf_CT_Vbi_ci_Vtnode_GND=(+FCf_CT_Vbi_ci_Vtnode_GND*(FCf2-FCf3)+FCf_CT_Vbi_ci*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT*(+FCf2_Vbi_ci_Vtnode_GND-FCf3_Vbi_ci_Vtnode_GND));
#endif
FCf_CT_Vci_ei=((FCf_CT_Vci_ei*(FCf2-FCf3))+(FCf_CT*(FCf2_Vci_ei-FCf3_Vci_ei)));
#if defined(_DERIVATE)
  FCf_CT_Vci_ei_Vbi_ei=(+FCf_CT_Vci_ei_Vbi_ei*(FCf2-FCf3)+FCf_CT_Vci_ei*(FCf2_Vbi_ei-FCf3_Vbi_ei)+FCf_CT_Vbi_ei*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT*(+FCf2_Vci_ei_Vbi_ei-FCf3_Vci_ei_Vbi_ei));
  FCf_CT_Vci_ei_Vbi_ci=(+FCf_CT_Vci_ei_Vbi_ci*(FCf2-FCf3)+FCf_CT_Vci_ei*(FCf2_Vbi_ci-FCf3_Vbi_ci)+FCf_CT_Vbi_ci*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT*(+FCf2_Vci_ei_Vbi_ci-FCf3_Vci_ei_Vbi_ci));
  FCf_CT_Vci_ei_Vci_ei=(+FCf_CT_Vci_ei_Vci_ei*(FCf2-FCf3)+FCf_CT_Vci_ei*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT_Vci_ei*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT*(+FCf2_Vci_ei_Vci_ei-FCf3_Vci_ei_Vci_ei));
  FCf_CT_Vci_ei_Vtnode_GND=(+FCf_CT_Vci_ei_Vtnode_GND*(FCf2-FCf3)+FCf_CT_Vci_ei*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCf2_Vci_ei-FCf3_Vci_ei)+FCf_CT*(+FCf2_Vci_ei_Vtnode_GND-FCf3_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
FCf_CT_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCf2-FCf3))+(FCf_CT*(FCf2_Vtnode_GND-FCf3_Vtnode_GND)));
#endif
#endif
FCf_CT=(FCf_CT*(FCf2-FCf3));
#if defined(_DERIVATEFORDDX)
FCdfCT_dw_Vbi_ei=((FCf_CT_Vbi_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)));
#if defined(_DERIVATE)
  FCdfCT_dw_Vbi_ei_Vbi_ei=(+FCf_CT_Vbi_ei_Vbi_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ei*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT*(+FCdf2_dw_Vbi_ei_Vbi_ei-FCdf3_dw_Vbi_ei_Vbi_ei));
  FCdfCT_dw_Vbi_ei_Vbi_ci=(+FCf_CT_Vbi_ei_Vbi_ci*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ei*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT*(+FCdf2_dw_Vbi_ei_Vbi_ci-FCdf3_dw_Vbi_ei_Vbi_ci));
  FCdfCT_dw_Vbi_ei_Vci_ei=(+FCf_CT_Vbi_ei_Vci_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ei*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT*(+FCdf2_dw_Vbi_ei_Vci_ei-FCdf3_dw_Vbi_ei_Vci_ei));
  FCdfCT_dw_Vbi_ei_Vtnode_GND=(+FCf_CT_Vbi_ei_Vtnode_GND*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ei*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT*(+FCdf2_dw_Vbi_ei_Vtnode_GND-FCdf3_dw_Vbi_ei_Vtnode_GND));
#endif
FCdfCT_dw_Vbi_ci=((FCf_CT_Vbi_ci*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)));
#if defined(_DERIVATE)
  FCdfCT_dw_Vbi_ci_Vbi_ei=(+FCf_CT_Vbi_ci_Vbi_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ci*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT*(+FCdf2_dw_Vbi_ci_Vbi_ei-FCdf3_dw_Vbi_ci_Vbi_ei));
  FCdfCT_dw_Vbi_ci_Vbi_ci=(+FCf_CT_Vbi_ci_Vbi_ci*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ci*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT*(+FCdf2_dw_Vbi_ci_Vbi_ci-FCdf3_dw_Vbi_ci_Vbi_ci));
  FCdfCT_dw_Vbi_ci_Vci_ei=(+FCf_CT_Vbi_ci_Vci_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ci*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT*(+FCdf2_dw_Vbi_ci_Vci_ei-FCdf3_dw_Vbi_ci_Vci_ei));
  FCdfCT_dw_Vbi_ci_Vtnode_GND=(+FCf_CT_Vbi_ci_Vtnode_GND*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vbi_ci*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT*(+FCdf2_dw_Vbi_ci_Vtnode_GND-FCdf3_dw_Vbi_ci_Vtnode_GND));
#endif
FCdfCT_dw_Vci_ei=((FCf_CT_Vci_ei*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)));
#if defined(_DERIVATE)
  FCdfCT_dw_Vci_ei_Vbi_ei=(+FCf_CT_Vci_ei_Vbi_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vci_ei*(FCdf2_dw_Vbi_ei-FCdf3_dw_Vbi_ei)+FCf_CT_Vbi_ei*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT*(+FCdf2_dw_Vci_ei_Vbi_ei-FCdf3_dw_Vci_ei_Vbi_ei));
  FCdfCT_dw_Vci_ei_Vbi_ci=(+FCf_CT_Vci_ei_Vbi_ci*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vci_ei*(FCdf2_dw_Vbi_ci-FCdf3_dw_Vbi_ci)+FCf_CT_Vbi_ci*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT*(+FCdf2_dw_Vci_ei_Vbi_ci-FCdf3_dw_Vci_ei_Vbi_ci));
  FCdfCT_dw_Vci_ei_Vci_ei=(+FCf_CT_Vci_ei_Vci_ei*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vci_ei*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT_Vci_ei*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT*(+FCdf2_dw_Vci_ei_Vci_ei-FCdf3_dw_Vci_ei_Vci_ei));
  FCdfCT_dw_Vci_ei_Vtnode_GND=(+FCf_CT_Vci_ei_Vtnode_GND*(FCdf2_dw-FCdf3_dw)+FCf_CT_Vci_ei*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)+FCf_CT_Vtnode_GND*(FCdf2_dw_Vci_ei-FCdf3_dw_Vci_ei)+FCf_CT*(+FCdf2_dw_Vci_ei_Vtnode_GND-FCdf3_dw_Vci_ei_Vtnode_GND));
#endif
#if defined(_DERIVATE)
FCdfCT_dw_Vtnode_GND=((FCf_CT_Vtnode_GND*(FCdf2_dw-FCdf3_dw))+(FCf_CT*(FCdf2_dw_Vtnode_GND-FCdf3_dw_Vtnode_GND)));
#endif
#endif
FCdfCT_dw=(FCf_CT*(FCdf2_dw-FCdf3_dw));
#if defined(_DERIVATEFORDDX)
FCdfCT_ditf_Vbi_ei=((FCdfCT_dw_Vbi_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ei));
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ei_Vbi_ei=(+FCdfCT_dw_Vbi_ei_Vbi_ei*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vbi_ei);
  FCdfCT_ditf_Vbi_ei_Vbi_ci=(+FCdfCT_dw_Vbi_ei_Vbi_ci*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vbi_ci);
  FCdfCT_ditf_Vbi_ei_Vci_ei=(+FCdfCT_dw_Vbi_ei_Vci_ei*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vci_ei);
  FCdfCT_ditf_Vbi_ei_Vtnode_GND=(+FCdfCT_dw_Vbi_ei_Vtnode_GND*FCdw_ditf+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vtnode_GND+FCdfCT_dw_Vtnode_GND*FCdw_ditf_Vbi_ei+FCdfCT_dw*FCdw_ditf_Vbi_ei_Vtnode_GND);
#endif
FCdfCT_ditf_Vbi_ci=((FCdfCT_dw_Vbi_ci*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vbi_ci));
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ci_Vbi_ei=(+FCdfCT_dw_Vbi_ci_Vbi_ei*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ei+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vbi_ei);
  FCdfCT_ditf_Vbi_ci_Vbi_ci=(+FCdfCT_dw_Vbi_ci_Vbi_ci*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vbi_ci);
  FCdfCT_ditf_Vbi_ci_Vci_ei=(+FCdfCT_dw_Vbi_ci_Vci_ei*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vci_ei);
  FCdfCT_ditf_Vbi_ci_Vtnode_GND=(+FCdfCT_dw_Vbi_ci_Vtnode_GND*FCdw_ditf+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vtnode_GND+FCdfCT_dw_Vtnode_GND*FCdw_ditf_Vbi_ci+FCdfCT_dw*FCdw_ditf_Vbi_ci_Vtnode_GND);
#endif
FCdfCT_ditf_Vci_ei=((FCdfCT_dw_Vci_ei*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vci_ei));
#if defined(_DERIVATE)
  FCdfCT_ditf_Vci_ei_Vbi_ei=(+FCdfCT_dw_Vci_ei_Vbi_ei*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ei+FCdfCT_dw_Vbi_ei*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vbi_ei);
  FCdfCT_ditf_Vci_ei_Vbi_ci=(+FCdfCT_dw_Vci_ei_Vbi_ci*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vbi_ci+FCdfCT_dw_Vbi_ci*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vbi_ci);
  FCdfCT_ditf_Vci_ei_Vci_ei=(+FCdfCT_dw_Vci_ei_Vci_ei*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfCT_dw_Vci_ei*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vci_ei);
  FCdfCT_ditf_Vci_ei_Vtnode_GND=(+FCdfCT_dw_Vci_ei_Vtnode_GND*FCdw_ditf+FCdfCT_dw_Vci_ei*FCdw_ditf_Vtnode_GND+FCdfCT_dw_Vtnode_GND*FCdw_ditf_Vci_ei+FCdfCT_dw*FCdw_ditf_Vci_ei_Vtnode_GND);
#endif
#if defined(_DERIVATE)
FCdfCT_ditf_Vtnode_GND=((FCdfCT_dw_Vtnode_GND*FCdw_ditf)+(FCdfCT_dw*FCdw_ditf_Vtnode_GND));
#endif
#endif
FCdfCT_ditf=(FCdfCT_dw*FCdw_ditf);
}
else
{
#if defined(_DERIVATEFORDDX)
FCf_CT_Vbi_ei=FCf_ci_Vbi_ei;
#if defined(_DERIVATE)
  FCf_CT_Vbi_ei_Vbi_ei=FCf_ci_Vbi_ei_Vbi_ei;
  FCf_CT_Vbi_ei_Vbi_ci=FCf_ci_Vbi_ei_Vbi_ci;
  FCf_CT_Vbi_ei_Vci_ei=FCf_ci_Vbi_ei_Vci_ei;
  FCf_CT_Vbi_ei_Vtnode_GND=FCf_ci_Vbi_ei_Vtnode_GND;
#endif
FCf_CT_Vbi_ci=FCf_ci_Vbi_ci;
#if defined(_DERIVATE)
  FCf_CT_Vbi_ci_Vbi_ei=FCf_ci_Vbi_ci_Vbi_ei;
  FCf_CT_Vbi_ci_Vbi_ci=FCf_ci_Vbi_ci_Vbi_ci;
  FCf_CT_Vbi_ci_Vci_ei=FCf_ci_Vbi_ci_Vci_ei;
  FCf_CT_Vbi_ci_Vtnode_GND=FCf_ci_Vbi_ci_Vtnode_GND;
#endif
FCf_CT_Vci_ei=FCf_ci_Vci_ei;
#if defined(_DERIVATE)
  FCf_CT_Vci_ei_Vbi_ei=FCf_ci_Vci_ei_Vbi_ei;
  FCf_CT_Vci_ei_Vbi_ci=FCf_ci_Vci_ei_Vbi_ci;
  FCf_CT_Vci_ei_Vci_ei=FCf_ci_Vci_ei_Vci_ei;
  FCf_CT_Vci_ei_Vtnode_GND=FCf_ci_Vci_ei_Vtnode_GND;
#endif
#if defined(_DERIVATE)
FCf_CT_Vtnode_GND=FCf_ci_Vtnode_GND;
#endif
#endif
FCf_CT=FCf_ci;
#if defined(_DERIVATEFORDDX)
FCdfCT_ditf_Vbi_ei=FCdfc_ditf_Vbi_ei;
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ei_Vbi_ei=FCdfc_ditf_Vbi_ei_Vbi_ei;
  FCdfCT_ditf_Vbi_ei_Vbi_ci=FCdfc_ditf_Vbi_ei_Vbi_ci;
  FCdfCT_ditf_Vbi_ei_Vci_ei=FCdfc_ditf_Vbi_ei_Vci_ei;
  FCdfCT_ditf_Vbi_ei_Vtnode_GND=FCdfc_ditf_Vbi_ei_Vtnode_GND;
#endif
FCdfCT_ditf_Vbi_ci=FCdfc_ditf_Vbi_ci;
#if defined(_DERIVATE)
  FCdfCT_ditf_Vbi_ci_Vbi_ei=FCdfc_ditf_Vbi_ci_Vbi_ei;
  FCdfCT_ditf_Vbi_ci_Vbi_ci=FCdfc_ditf_Vbi_ci_Vbi_ci;
  FCdfCT_ditf_Vbi_ci_Vci_ei=FCdfc_ditf_Vbi_ci_Vci_ei;
  FCdfCT_ditf_Vbi_ci_Vtnode_GND=FCdfc_ditf_Vbi_ci_Vtnode_GND;
#endif
FCdfCT_ditf_Vci_ei=FCdfc_ditf_Vci_ei;
#if defined(_DERIVATE)
  FCdfCT_ditf_Vci_ei_Vbi_ei=FCdfc_ditf_Vci_ei_Vbi_ei;
  FCdfCT_ditf_Vci_ei_Vbi_ci=FCdfc_ditf_Vci_ei_Vbi_ci;
  FCdfCT_ditf_Vci_ei_Vci_ei=FCdfc_ditf_Vci_ei_Vci_ei;
  FCdfCT_ditf_Vci_ei_Vtnode_GND=FCdfc_ditf_Vci_ei_Vtnode_GND;
#endif
#if defined(_DERIVATE)
FCdfCT_ditf_Vtnode_GND=FCdfc_ditf_Vtnode_GND;
#endif
#endif
FCdfCT_ditf=FCdfc_ditf;
}
}
else
{
if
((latb>0.01))
{
#if defined(_DERIVATEFORDDX)
FCd_a_Vci_ei=(-FCa_ck_Vci_ei*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vci_ei_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vci_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vtnode_GND*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vbi_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vci_ei_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vci_ei*latb+1.0*(+0.0+(+FCa_ck_Vci_ei_Vbi_ci*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vci_ei*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
#if defined(_DERIVATE)
FCd_a_Vtnode_GND=(-FCa_ck_Vtnode_GND*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
FCd_a_Vbi_ei=(-FCa_ck_Vbi_ei*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ei_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vci_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vtnode_GND*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vbi_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ei_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vbi_ei*latb+1.0*(+0.0+(+FCa_ck_Vbi_ei_Vbi_ci*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ei*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
FCd_a_Vbi_ci=(-FCa_ck_Vbi_ci*latb/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATE)
  FCd_a_Vbi_ci_Vci_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vci_ei*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vci_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vci_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vtnode_GND=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vtnode_GND*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vtnode_GND*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vtnode_GND*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vbi_ei=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ei*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vbi_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vbi_ei*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
  FCd_a_Vbi_ci_Vbi_ci=(0.0/(1.0+(FCa_ck*latb))-(0.0*(FCa_ck_Vbi_ci*latb)+0.0*FCa_ck_Vbi_ci*latb+1.0*(+0.0+(+FCa_ck_Vbi_ci_Vbi_ci*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0)))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))+2*1.0*FCa_ck_Vbi_ci*latb*(FCa_ck_Vbi_ci*latb)/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb))/(1.0+(FCa_ck*latb)));
#endif
#endif
FCd_a=(1.0/(1.0+(FCa_ck*latb)));
#if defined(_DERIVATEFORDDX)
FCw_Vci_ei=(((-FCa_ck_Vci_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCw_Vci_ei_Vci_ei=(+(+0.0-FCa_ck_Vci_ei_Vci_ei)*FCd_a+(-FCa_ck_Vci_ei)*FCd_a_Vci_ei+(-FCa_ck_Vci_ei)*FCd_a_Vci_ei+(1.0-FCa_ck)*FCd_a_Vci_ei_Vci_ei);
  FCw_Vci_ei_Vtnode_GND=(+(+0.0-FCa_ck_Vci_ei_Vtnode_GND)*FCd_a+(-FCa_ck_Vci_ei)*FCd_a_Vtnode_GND+(-FCa_ck_Vtnode_GND)*FCd_a_Vci_ei+(1.0-FCa_ck)*FCd_a_Vci_ei_Vtnode_GND);
  FCw_Vci_ei_Vbi_ei=(+(+0.0-FCa_ck_Vci_ei_Vbi_ei)*FCd_a+(-FCa_ck_Vci_ei)*FCd_a_Vbi_ei+(-FCa_ck_Vbi_ei)*FCd_a_Vci_ei+(1.0-FCa_ck)*FCd_a_Vci_ei_Vbi_ei);
  FCw_Vci_ei_Vbi_ci=(+(+0.0-FCa_ck_Vci_ei_Vbi_ci)*FCd_a+(-FCa_ck_Vci_ei)*FCd_a_Vbi_ci+(-FCa_ck_Vbi_ci)*FCd_a_Vci_ei+(1.0-FCa_ck)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw_Vtnode_GND=(((-FCa_ck_Vtnode_GND)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vtnode_GND));
#endif
FCw_Vbi_ei=(((-FCa_ck_Vbi_ei)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCw_Vbi_ei_Vci_ei=(+(+0.0-FCa_ck_Vbi_ei_Vci_ei)*FCd_a+(-FCa_ck_Vbi_ei)*FCd_a_Vci_ei+(-FCa_ck_Vci_ei)*FCd_a_Vbi_ei+(1.0-FCa_ck)*FCd_a_Vbi_ei_Vci_ei);
  FCw_Vbi_ei_Vtnode_GND=(+(+0.0-FCa_ck_Vbi_ei_Vtnode_GND)*FCd_a+(-FCa_ck_Vbi_ei)*FCd_a_Vtnode_GND+(-FCa_ck_Vtnode_GND)*FCd_a_Vbi_ei+(1.0-FCa_ck)*FCd_a_Vbi_ei_Vtnode_GND);
  FCw_Vbi_ei_Vbi_ei=(+(+0.0-FCa_ck_Vbi_ei_Vbi_ei)*FCd_a+(-FCa_ck_Vbi_ei)*FCd_a_Vbi_ei+(-FCa_ck_Vbi_ei)*FCd_a_Vbi_ei+(1.0-FCa_ck)*FCd_a_Vbi_ei_Vbi_ei);
  FCw_Vbi_ei_Vbi_ci=(+(+0.0-FCa_ck_Vbi_ei_Vbi_ci)*FCd_a+(-FCa_ck_Vbi_ei)*FCd_a_Vbi_ci+(-FCa_ck_Vbi_ci)*FCd_a_Vbi_ei+(1.0-FCa_ck)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCw_Vbi_ci=(((-FCa_ck_Vbi_ci)*FCd_a)+((1.0-FCa_ck)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCw_Vbi_ci_Vci_ei=(+(+0.0-FCa_ck_Vbi_ci_Vci_ei)*FCd_a+(-FCa_ck_Vbi_ci)*FCd_a_Vci_ei+(-FCa_ck_Vci_ei)*FCd_a_Vbi_ci+(1.0-FCa_ck)*FCd_a_Vbi_ci_Vci_ei);
  FCw_Vbi_ci_Vtnode_GND=(+(+0.0-FCa_ck_Vbi_ci_Vtnode_GND)*FCd_a+(-FCa_ck_Vbi_ci)*FCd_a_Vtnode_GND+(-FCa_ck_Vtnode_GND)*FCd_a_Vbi_ci+(1.0-FCa_ck)*FCd_a_Vbi_ci_Vtnode_GND);
  FCw_Vbi_ci_Vbi_ei=(+(+0.0-FCa_ck_Vbi_ci_Vbi_ei)*FCd_a+(-FCa_ck_Vbi_ci)*FCd_a_Vbi_ei+(-FCa_ck_Vbi_ei)*FCd_a_Vbi_ci+(1.0-FCa_ck)*FCd_a_Vbi_ci_Vbi_ei);
  FCw_Vbi_ci_Vbi_ci=(+(+0.0-FCa_ck_Vbi_ci_Vbi_ci)*FCd_a+(-FCa_ck_Vbi_ci)*FCd_a_Vbi_ci+(-FCa_ck_Vbi_ci)*FCd_a_Vbi_ci+(1.0-FCa_ck)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCw=((1.0-FCa_ck)*FCd_a);
#if defined(_DERIVATEFORDDX)
FCdw_daick_Vci_ei=((((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vci_ei_Vci_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vci_ei+(-(1.0+latb))*FCd_a_Vci_ei_Vci_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a_Vci_ei+(((-(1.0+latb))*FCd_a_Vci_ei))*FCd_a_Vci_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei_Vci_ei);
  FCdw_daick_Vci_ei_Vtnode_GND=(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vci_ei+(-(1.0+latb))*FCd_a_Vci_ei_Vtnode_GND)*FCd_a+((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a_Vtnode_GND+(((-(1.0+latb))*FCd_a_Vtnode_GND))*FCd_a_Vci_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei_Vtnode_GND);
  FCdw_daick_Vci_ei_Vbi_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vci_ei+(-(1.0+latb))*FCd_a_Vci_ei_Vbi_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a_Vbi_ei+(((-(1.0+latb))*FCd_a_Vbi_ei))*FCd_a_Vci_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei_Vbi_ei);
  FCdw_daick_Vci_ei_Vbi_ci=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vci_ei+(-(1.0+latb))*FCd_a_Vci_ei_Vbi_ci)*FCd_a+((-(1.0+latb))*FCd_a_Vci_ei)*FCd_a_Vbi_ci+(((-(1.0+latb))*FCd_a_Vbi_ci))*FCd_a_Vci_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCdw_daick_Vtnode_GND=((((-(1.0+latb))*FCd_a_Vtnode_GND)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vtnode_GND));
#endif
FCdw_daick_Vbi_ei=((((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ei_Vci_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vbi_ei+(-(1.0+latb))*FCd_a_Vbi_ei_Vci_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a_Vci_ei+(((-(1.0+latb))*FCd_a_Vci_ei))*FCd_a_Vbi_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei_Vci_ei);
  FCdw_daick_Vbi_ei_Vtnode_GND=(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vbi_ei+(-(1.0+latb))*FCd_a_Vbi_ei_Vtnode_GND)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a_Vtnode_GND+(((-(1.0+latb))*FCd_a_Vtnode_GND))*FCd_a_Vbi_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei_Vtnode_GND);
  FCdw_daick_Vbi_ei_Vbi_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vbi_ei+(-(1.0+latb))*FCd_a_Vbi_ei_Vbi_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a_Vbi_ei+(((-(1.0+latb))*FCd_a_Vbi_ei))*FCd_a_Vbi_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei_Vbi_ei);
  FCdw_daick_Vbi_ei_Vbi_ci=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vbi_ei+(-(1.0+latb))*FCd_a_Vbi_ei_Vbi_ci)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ei)*FCd_a_Vbi_ci+(((-(1.0+latb))*FCd_a_Vbi_ci))*FCd_a_Vbi_ei+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ei_Vbi_ci);
#endif
FCdw_daick_Vbi_ci=((((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a)+(((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci));
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ci_Vci_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vci_ei+0.0*FCd_a_Vbi_ci+(-(1.0+latb))*FCd_a_Vbi_ci_Vci_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a_Vci_ei+(((-(1.0+latb))*FCd_a_Vci_ei))*FCd_a_Vbi_ci+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci_Vci_ei);
  FCdw_daick_Vbi_ci_Vtnode_GND=(+(+0.0*FCd_a+0.0*FCd_a_Vtnode_GND+0.0*FCd_a_Vbi_ci+(-(1.0+latb))*FCd_a_Vbi_ci_Vtnode_GND)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a_Vtnode_GND+(((-(1.0+latb))*FCd_a_Vtnode_GND))*FCd_a_Vbi_ci+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci_Vtnode_GND);
  FCdw_daick_Vbi_ci_Vbi_ei=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ei+0.0*FCd_a_Vbi_ci+(-(1.0+latb))*FCd_a_Vbi_ci_Vbi_ei)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a_Vbi_ei+(((-(1.0+latb))*FCd_a_Vbi_ei))*FCd_a_Vbi_ci+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci_Vbi_ei);
  FCdw_daick_Vbi_ci_Vbi_ci=(+(+0.0*FCd_a+0.0*FCd_a_Vbi_ci+0.0*FCd_a_Vbi_ci+(-(1.0+latb))*FCd_a_Vbi_ci_Vbi_ci)*FCd_a+((-(1.0+latb))*FCd_a_Vbi_ci)*FCd_a_Vbi_ci+(((-(1.0+latb))*FCd_a_Vbi_ci))*FCd_a_Vbi_ci+((-(1.0+latb))*FCd_a)*FCd_a_Vbi_ci_Vbi_ci);
#endif
#endif
FCdw_daick=(((-(1.0+latb))*FCd_a)*FCd_a);
}
else
{
#if defined(_DERIVATEFORDDX)
FCw_Vci_ei=((-FCa_ck_Vci_ei)-FCa_ck_Vci_ei*latb);
#if defined(_DERIVATE)
  FCw_Vci_ei_Vci_ei=(+(+0.0-FCa_ck_Vci_ei_Vci_ei)-(+FCa_ck_Vci_ei_Vci_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0));
  FCw_Vci_ei_Vtnode_GND=(+(+0.0-FCa_ck_Vci_ei_Vtnode_GND)-(+FCa_ck_Vci_ei_Vtnode_GND*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0));
  FCw_Vci_ei_Vbi_ei=(+(+0.0-FCa_ck_Vci_ei_Vbi_ei)-(+FCa_ck_Vci_ei_Vbi_ei*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0));
  FCw_Vci_ei_Vbi_ci=(+(+0.0-FCa_ck_Vci_ei_Vbi_ci)-(+FCa_ck_Vci_ei_Vbi_ci*latb+FCa_ck_Vci_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0));
#endif
#if defined(_DERIVATE)
FCw_Vtnode_GND=((-FCa_ck_Vtnode_GND)-FCa_ck_Vtnode_GND*latb);
#endif
FCw_Vbi_ei=((-FCa_ck_Vbi_ei)-FCa_ck_Vbi_ei*latb);
#if defined(_DERIVATE)
  FCw_Vbi_ei_Vci_ei=(+(+0.0-FCa_ck_Vbi_ei_Vci_ei)-(+FCa_ck_Vbi_ei_Vci_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0));
  FCw_Vbi_ei_Vtnode_GND=(+(+0.0-FCa_ck_Vbi_ei_Vtnode_GND)-(+FCa_ck_Vbi_ei_Vtnode_GND*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0));
  FCw_Vbi_ei_Vbi_ei=(+(+0.0-FCa_ck_Vbi_ei_Vbi_ei)-(+FCa_ck_Vbi_ei_Vbi_ei*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0));
  FCw_Vbi_ei_Vbi_ci=(+(+0.0-FCa_ck_Vbi_ei_Vbi_ci)-(+FCa_ck_Vbi_ei_Vbi_ci*latb+FCa_ck_Vbi_ei*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0));
#endif
FCw_Vbi_ci=((-FCa_ck_Vbi_ci)-FCa_ck_Vbi_ci*latb);
#if defined(_DERIVATE)
  FCw_Vbi_ci_Vci_ei=(+(+0.0-FCa_ck_Vbi_ci_Vci_ei)-(+FCa_ck_Vbi_ci_Vci_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vci_ei*0.0+FCa_ck*0.0));
  FCw_Vbi_ci_Vtnode_GND=(+(+0.0-FCa_ck_Vbi_ci_Vtnode_GND)-(+FCa_ck_Vbi_ci_Vtnode_GND*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vtnode_GND*0.0+FCa_ck*0.0));
  FCw_Vbi_ci_Vbi_ei=(+(+0.0-FCa_ck_Vbi_ci_Vbi_ei)-(+FCa_ck_Vbi_ci_Vbi_ei*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ei*0.0+FCa_ck*0.0));
  FCw_Vbi_ci_Vbi_ci=(+(+0.0-FCa_ck_Vbi_ci_Vbi_ci)-(+FCa_ck_Vbi_ci_Vbi_ci*latb+FCa_ck_Vbi_ci*0.0+FCa_ck_Vbi_ci*0.0+FCa_ck*0.0));
#endif
#endif
FCw=((1.0-FCa_ck)-(FCa_ck*latb));
#if defined(_DERIVATEFORDDX)
FCdw_daick_Vci_ei=0.0;
#if defined(_DERIVATE)
  FCdw_daick_Vci_ei_Vci_ei=0.0;
  FCdw_daick_Vci_ei_Vtnode_GND=0.0;
  FCdw_daick_Vci_ei_Vbi_ei=0.0;
  FCdw_daick_Vci_ei_Vbi_ci=0.0;
#endif
#if defined(_DERIVATE)
FCdw_daick_Vtnode_GND=0.0;
#endif
FCdw_daick_Vbi_ei=0.0;
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ei_Vci_ei=0.0;
  FCdw_daick_Vbi_ei_Vtnode_GND=0.0;
  FCdw_daick_Vbi_ei_Vbi_ei=0.0;
  FCdw_daick_Vbi_ei_Vbi_ci=0.0;
#endif
FCdw_daick_Vbi_ci=0.0;
#if defined(_DERIVATE)
  FCdw_daick_Vbi_ci_Vci_ei=0.0;
  FCdw_daick_Vbi_ci_Vtnode_GND=0.0;
  FCdw_daick_Vbi_ci_Vbi_ei=0.0;
  FCdw_daick_Vbi_ci_Vbi_ci=0.0;
#endif
#endif
FCdw_daick=(-(1.0+latb));
}
#if defined(_DERIVATEFORDDX)
FCw2_Vci_ei=((FCw_Vci_ei*FCw)+(FCw*FCw_Vci_ei));
#if defined(_DERIVATE)
  FCw2_Vci_ei_Vci_ei=(+FCw_Vci_ei_Vci_ei*FCw+FCw_Vci_ei*FCw_Vci_ei+FCw_Vci_ei*FCw_Vci_ei+FCw*FCw_Vci_ei_Vci_ei);
  FCw2_Vci_ei_Vtnode_GND=(+FCw_Vci_ei_Vtnode_GND*FCw+FCw_Vci_ei*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vci_ei+FCw*FCw_Vci_ei_Vtnode_GND);
  FCw2_Vci_ei_Vbi_ei=(+FCw_Vci_ei_Vbi_ei*FCw+FCw_Vci_ei*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vci_ei+FCw*FCw_Vci_ei_Vbi_ei);
  FCw2_Vci_ei_Vbi_ci=(+FCw_Vci_ei_Vbi_ci*FCw+FCw_Vci_ei*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vci_ei+FCw*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCw2_Vtnode_GND=((FCw_Vtnode_GND*FCw)+(FCw*FCw_Vtnode_GND));
#endif
FCw2_Vbi_ei=((FCw_Vbi_ei*FCw)+(FCw*FCw_Vbi_ei));
#if defined(_DERIVATE)
  FCw2_Vbi_ei_Vci_ei=(+FCw_Vbi_ei_Vci_ei*FCw+FCw_Vbi_ei*FCw_Vci_ei+FCw_Vci_ei*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vci_ei);
  FCw2_Vbi_ei_Vtnode_GND=(+FCw_Vbi_ei_Vtnode_GND*FCw+FCw_Vbi_ei*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vtnode_GND);
  FCw2_Vbi_ei_Vbi_ei=(+FCw_Vbi_ei_Vbi_ei*FCw+FCw_Vbi_ei*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vbi_ei);
  FCw2_Vbi_ei_Vbi_ci=(+FCw_Vbi_ei_Vbi_ci*FCw+FCw_Vbi_ei*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vbi_ei+FCw*FCw_Vbi_ei_Vbi_ci);
#endif
FCw2_Vbi_ci=((FCw_Vbi_ci*FCw)+(FCw*FCw_Vbi_ci));
#if defined(_DERIVATE)
  FCw2_Vbi_ci_Vci_ei=(+FCw_Vbi_ci_Vci_ei*FCw+FCw_Vbi_ci*FCw_Vci_ei+FCw_Vci_ei*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vci_ei);
  FCw2_Vbi_ci_Vtnode_GND=(+FCw_Vbi_ci_Vtnode_GND*FCw+FCw_Vbi_ci*FCw_Vtnode_GND+FCw_Vtnode_GND*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vtnode_GND);
  FCw2_Vbi_ci_Vbi_ei=(+FCw_Vbi_ci_Vbi_ei*FCw+FCw_Vbi_ci*FCw_Vbi_ei+FCw_Vbi_ei*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vbi_ei);
  FCw2_Vbi_ci_Vbi_ci=(+FCw_Vbi_ci_Vbi_ci*FCw+FCw_Vbi_ci*FCw_Vbi_ci+FCw_Vbi_ci*FCw_Vbi_ci+FCw*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCw2=(FCw*FCw);
#if defined(_DERIVATEFORDDX)
FCz_Vci_ei=(latb*FCw_Vci_ei);
#if defined(_DERIVATE)
  FCz_Vci_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vci_ei);
  FCz_Vci_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vtnode_GND);
  FCz_Vci_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ei);
  FCz_Vci_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vci_ei+latb*FCw_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCz_Vtnode_GND=(latb*FCw_Vtnode_GND);
#endif
FCz_Vbi_ei=(latb*FCw_Vbi_ei);
#if defined(_DERIVATE)
  FCz_Vbi_ei_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vci_ei);
  FCz_Vbi_ei_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vtnode_GND);
  FCz_Vbi_ei_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ei);
  FCz_Vbi_ei_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ei+latb*FCw_Vbi_ei_Vbi_ci);
#endif
FCz_Vbi_ci=(latb*FCw_Vbi_ci);
#if defined(_DERIVATE)
  FCz_Vbi_ci_Vci_ei=(+0.0*FCw+0.0*FCw_Vci_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vci_ei);
  FCz_Vbi_ci_Vtnode_GND=(+0.0*FCw+0.0*FCw_Vtnode_GND+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vtnode_GND);
  FCz_Vbi_ci_Vbi_ei=(+0.0*FCw+0.0*FCw_Vbi_ei+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ei);
  FCz_Vbi_ci_Vbi_ci=(+0.0*FCw+0.0*FCw_Vbi_ci+0.0*FCw_Vbi_ci+latb*FCw_Vbi_ci_Vbi_ci);
#endif
#endif
FCz=(latb*FCw);
#if defined(_DERIVATEFORDDX)
FCz_1_Vci_ei=FCz_Vci_ei;
#if defined(_DERIVATE)
  FCz_1_Vci_ei_Vci_ei=(+0.0+FCz_Vci_ei_Vci_ei);
  FCz_1_Vci_ei_Vtnode_GND=(+0.0+FCz_Vci_ei_Vtnode_GND);
  FCz_1_Vci_ei_Vbi_ei=(+0.0+FCz_Vci_ei_Vbi_ei);
  FCz_1_Vci_ei_Vbi_ci=(+0.0+FCz_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCz_1_Vtnode_GND=FCz_Vtnode_GND;
#endif
FCz_1_Vbi_ei=FCz_Vbi_ei;
#if defined(_DERIVATE)
  FCz_1_Vbi_ei_Vci_ei=(+0.0+FCz_Vbi_ei_Vci_ei);
  FCz_1_Vbi_ei_Vtnode_GND=(+0.0+FCz_Vbi_ei_Vtnode_GND);
  FCz_1_Vbi_ei_Vbi_ei=(+0.0+FCz_Vbi_ei_Vbi_ei);
  FCz_1_Vbi_ei_Vbi_ci=(+0.0+FCz_Vbi_ei_Vbi_ci);
#endif
FCz_1_Vbi_ci=FCz_Vbi_ci;
#if defined(_DERIVATE)
  FCz_1_Vbi_ci_Vci_ei=(+0.0+FCz_Vbi_ci_Vci_ei);
  FCz_1_Vbi_ci_Vtnode_GND=(+0.0+FCz_Vbi_ci_Vtnode_GND);
  FCz_1_Vbi_ci_Vbi_ei=(+0.0+FCz_Vbi_ci_Vbi_ei);
  FCz_1_Vbi_ci_Vbi_ci=(+0.0+FCz_Vbi_ci_Vbi_ci);
#endif
#endif
FCz_1=(1.0+FCz);
#if defined(_DERIVATEFORDDX)
FCd_f_Vci_ei=(-FCz_1_Vci_ei/FCz_1/FCz_1);
#if defined(_DERIVATE)
  FCd_f_Vci_ei_Vci_ei=(0.0/FCz_1-(0.0*FCz_1_Vci_ei+0.0*FCz_1_Vci_ei+1.0*FCz_1_Vci_ei_Vci_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vci_ei*FCz_1_Vci_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vci_ei_Vtnode_GND=(0.0/FCz_1-(0.0*FCz_1_Vtnode_GND+0.0*FCz_1_Vci_ei+1.0*FCz_1_Vci_ei_Vtnode_GND)/FCz_1/FCz_1+2*1.0*FCz_1_Vci_ei*FCz_1_Vtnode_GND/FCz_1/FCz_1/FCz_1);
  FCd_f_Vci_ei_Vbi_ei=(0.0/FCz_1-(0.0*FCz_1_Vbi_ei+0.0*FCz_1_Vci_ei+1.0*FCz_1_Vci_ei_Vbi_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vci_ei*FCz_1_Vbi_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vci_ei_Vbi_ci=(0.0/FCz_1-(0.0*FCz_1_Vbi_ci+0.0*FCz_1_Vci_ei+1.0*FCz_1_Vci_ei_Vbi_ci)/FCz_1/FCz_1+2*1.0*FCz_1_Vci_ei*FCz_1_Vbi_ci/FCz_1/FCz_1/FCz_1);
#endif
#if defined(_DERIVATE)
FCd_f_Vtnode_GND=(-FCz_1_Vtnode_GND/FCz_1/FCz_1);
#endif
FCd_f_Vbi_ei=(-FCz_1_Vbi_ei/FCz_1/FCz_1);
#if defined(_DERIVATE)
  FCd_f_Vbi_ei_Vci_ei=(0.0/FCz_1-(0.0*FCz_1_Vci_ei+0.0*FCz_1_Vbi_ei+1.0*FCz_1_Vbi_ei_Vci_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ei*FCz_1_Vci_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ei_Vtnode_GND=(0.0/FCz_1-(0.0*FCz_1_Vtnode_GND+0.0*FCz_1_Vbi_ei+1.0*FCz_1_Vbi_ei_Vtnode_GND)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ei*FCz_1_Vtnode_GND/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ei_Vbi_ei=(0.0/FCz_1-(0.0*FCz_1_Vbi_ei+0.0*FCz_1_Vbi_ei+1.0*FCz_1_Vbi_ei_Vbi_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ei*FCz_1_Vbi_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ei_Vbi_ci=(0.0/FCz_1-(0.0*FCz_1_Vbi_ci+0.0*FCz_1_Vbi_ei+1.0*FCz_1_Vbi_ei_Vbi_ci)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ei*FCz_1_Vbi_ci/FCz_1/FCz_1/FCz_1);
#endif
FCd_f_Vbi_ci=(-FCz_1_Vbi_ci/FCz_1/FCz_1);
#if defined(_DERIVATE)
  FCd_f_Vbi_ci_Vci_ei=(0.0/FCz_1-(0.0*FCz_1_Vci_ei+0.0*FCz_1_Vbi_ci+1.0*FCz_1_Vbi_ci_Vci_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ci*FCz_1_Vci_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ci_Vtnode_GND=(0.0/FCz_1-(0.0*FCz_1_Vtnode_GND+0.0*FCz_1_Vbi_ci+1.0*FCz_1_Vbi_ci_Vtnode_GND)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ci*FCz_1_Vtnode_GND/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ci_Vbi_ei=(0.0/FCz_1-(0.0*FCz_1_Vbi_ei+0.0*FCz_1_Vbi_ci+1.0*FCz_1_Vbi_ci_Vbi_ei)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ci*FCz_1_Vbi_ei/FCz_1/FCz_1/FCz_1);
  FCd_f_Vbi_ci_Vbi_ci=(0.0/FCz_1-(0.0*FCz_1_Vbi_ci+0.0*FCz_1_Vbi_ci+1.0*FCz_1_Vbi_ci_Vbi_ci)/FCz_1/FCz_1+2*1.0*FCz_1_Vbi_ci*FCz_1_Vbi_ci/FCz_1/FCz_1/FCz_1);
#endif
#endif
FCd_f=(1.0/FCz_1);
#if defined(_DERIVATEFORDDX)
FCf_ci_Vci_ei=((((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei));
#if defined(_DERIVATE)
  FCf_ci_Vci_ei_Vci_ei=(+(+FCw2_Vci_ei_Vci_ei*(1.0+(FCz/3.0))+FCw2_Vci_ei*(FCz_Vci_ei/3.0)+FCw2_Vci_ei*(FCz_Vci_ei/3.0)+FCw2*(+0.0+(FCz_Vci_ei_Vci_ei/3.0-(FCz_Vci_ei*0.0+FCz_Vci_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f_Vci_ei+(((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0))))*FCd_f_Vci_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei_Vci_ei);
  FCf_ci_Vci_ei_Vtnode_GND=(+(+FCw2_Vci_ei_Vtnode_GND*(1.0+(FCz/3.0))+FCw2_Vci_ei*(FCz_Vtnode_GND/3.0)+FCw2_Vtnode_GND*(FCz_Vci_ei/3.0)+FCw2*(+0.0+(FCz_Vci_ei_Vtnode_GND/3.0-(FCz_Vci_ei*0.0+FCz_Vtnode_GND*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f_Vtnode_GND+(((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vtnode_GND/3.0))))*FCd_f_Vci_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei_Vtnode_GND);
  FCf_ci_Vci_ei_Vbi_ei=(+(+FCw2_Vci_ei_Vbi_ei*(1.0+(FCz/3.0))+FCw2_Vci_ei*(FCz_Vbi_ei/3.0)+FCw2_Vbi_ei*(FCz_Vci_ei/3.0)+FCw2*(+0.0+(FCz_Vci_ei_Vbi_ei/3.0-(FCz_Vci_ei*0.0+FCz_Vbi_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f_Vbi_ei+(((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0))))*FCd_f_Vci_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei_Vbi_ei);
  FCf_ci_Vci_ei_Vbi_ci=(+(+FCw2_Vci_ei_Vbi_ci*(1.0+(FCz/3.0))+FCw2_Vci_ei*(FCz_Vbi_ci/3.0)+FCw2_Vbi_ci*(FCz_Vci_ei/3.0)+FCw2*(+0.0+(FCz_Vci_ei_Vbi_ci/3.0-(FCz_Vci_ei*0.0+FCz_Vbi_ci*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0)))*FCd_f_Vbi_ci+(((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0))))*FCd_f_Vci_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vci_ei_Vbi_ci);
#endif
#if defined(_DERIVATE)
FCf_ci_Vtnode_GND=((((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vtnode_GND/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vtnode_GND));
#endif
FCf_ci_Vbi_ei=((((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f)+((FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei));
#if defined(_DERIVATE)
  FCf_ci_Vbi_ei_Vci_ei=(+(+FCw2_Vbi_ei_Vci_ei*(1.0+(FCz/3.0))+FCw2_Vbi_ei*(FCz_Vci_ei/3.0)+FCw2_Vci_ei*(FCz_Vbi_ei/3.0)+FCw2*(+0.0+(FCz_Vbi_ei_Vci_ei/3.0-(FCz_Vbi_ei*0.0+FCz_Vci_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f_Vci_ei+(((FCw2_Vci_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vci_ei/3.0))))*FCd_f_Vbi_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei_Vci_ei);
  FCf_ci_Vbi_ei_Vtnode_GND=(+(+FCw2_Vbi_ei_Vtnode_GND*(1.0+(FCz/3.0))+FCw2_Vbi_ei*(FCz_Vtnode_GND/3.0)+FCw2_Vtnode_GND*(FCz_Vbi_ei/3.0)+FCw2*(+0.0+(FCz_Vbi_ei_Vtnode_GND/3.0-(FCz_Vbi_ei*0.0+FCz_Vtnode_GND*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f_Vtnode_GND+(((FCw2_Vtnode_GND*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vtnode_GND/3.0))))*FCd_f_Vbi_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei_Vtnode_GND);
  FCf_ci_Vbi_ei_Vbi_ei=(+(+FCw2_Vbi_ei_Vbi_ei*(1.0+(FCz/3.0))+FCw2_Vbi_ei*(FCz_Vbi_ei/3.0)+FCw2_Vbi_ei*(FCz_Vbi_ei/3.0)+FCw2*(+0.0+(FCz_Vbi_ei_Vbi_ei/3.0-(FCz_Vbi_ei*0.0+FCz_Vbi_ei*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f_Vbi_ei+(((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0))))*FCd_f_Vbi_ei+(FCw2*(1.0+(FCz/3.0)))*FCd_f_Vbi_ei_Vbi_ei);
  FCf_ci_Vbi_ei_Vbi_ci=(+(+FCw2_Vbi_ei_Vbi_ci*(1.0+(FCz/3.0))+FCw2_Vbi_ei*(FCz_Vbi_ci/3.0)+FCw2_Vbi_ci*(FCz_Vbi_ei/3.0)+FCw2*(+0.0+(FCz_Vbi_ei_Vbi_ci/3.0-(FCz_Vbi_ei*0.0+FCz_Vbi_ci*0.0+FCz*0.0)/3.0/3.0+2*FCz*0.0*0.0/3.0/3.0/3.0)))*FCd_f+((FCw2_Vbi_ei*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ei/3.0)))*FCd_f_Vbi_ci+(((FCw2_Vbi_ci*(1.0+(FCz/3.0)))+(FCw2*(FCz_Vbi_ci/3.0))))*FCd_f_Vbi_ei+(FCw2*(1.0+(FCz/3.0