//                               -*- Mode: Asm -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uSwitch-mip.s -- 
// 
// Author           : Peter A. Buhr
// Created On       : Wed Nov  9 10:16:30 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Aug 12 09:05:29 2004
// Update Count     : 25
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 

// This context switch routine depends on the fact that the stack of a new
// thread has been set up to look like the thread has saved its context in
// the normal manner.
//
// void uSwitch( uMachContext *to, uMachContext *from );

	.text
	.align 2
	.globl uSwitch
	.ent uSwitch
uSwitch:
	.frame	$sp,0,$31
	.mask	0x00000000,0
	.fmask	0x00000000,0

	// Save volatile registers (16-23,30,31) on the stack.

#ifdef _ABIN32
	subu $sp,48				// multiple of 16
	sw $16,0($sp)
	sw $17,4($sp)
	sw $18,8($sp)
	sw $19,12($sp)
	sw $20,16($sp)
	sw $21,20($sp)
	sw $22,24($sp)
	sw $23,28($sp)
	sw $30,32($sp)
	sw $31,36($sp)

	// Save stack pointer in the "from" area at offset 0.

	sw $sp,0($5)

	// Load stack pointer from the "to" area at offset 0.

	lw $sp,0($4)

	// Load volatile registers (16-23,30,31) from the stack.

	lw $31,36($sp)
	lw $30,32($sp)
	lw $23,28($sp)
	lw $22,24($sp)
	lw $21,20($sp)
	lw $20,16($sp)
	lw $19,12($sp)
	lw $18,8($sp)
	lw $17,4($sp)
	lw $16,0($sp)
	addu $sp,48

	// Load the procedure address for global addressability from new context
	// offset 4. Only significant when a new thread starts.

	lw $25,4($4)
#elif _ABI64
	dsubu $sp,96				// multiple of 16
	sd $16,0($sp)
	sd $17,8($sp)
	sd $18,16($sp)
	sd $19,24($sp)
	sd $20,32($sp)
	sd $21,40($sp)
	sd $22,48($sp)
	sd $23,56($sp)
	sd $30,64($sp)
	sd $31,72($sp)

	// Save stack pointer in the "from" area at offset 0.

	sd $sp,0($5)

	// Load stack pointer from the "to" area at offset 0.

	ld $sp,0($4)

	// Load volatile registers (16-23,30,31) from the stack.

	ld $31,72($sp)
	ld $30,64($sp)
	ld $23,56($sp)
	ld $22,48($sp)
	ld $21,40($sp)
	ld $20,32($sp)
	ld $19,24($sp)
	ld $18,16($sp)
	ld $17,8($sp)
	ld $16,0($sp)
	daddu $sp,96

	// Load the procedure address for global addressability from new context
	// offset 8. Only significant when a new thread starts.

	ld $25,8($4)
#else
    #error uC++ internal error : unsupported architecture
#endif

	// As well, the "to" parameter in $4 magically becomes the "This"
	// argument for uMachContext::uInvoke. Only significant when a new
	// thread starts.

	// Return to thread.

	j $31

// define end of routine

 	.end	uSwitch

// Local Variables: //
// compile-command: "gmake install" //
// End: //
