//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.0.1, Copyright (C) Peter A. Buhr 1994
// 
// uPoll.h -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 17:01:20 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Thu Jul 24 22:14:03 2003
// Update Count     : 24
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#ifndef __POLL_H__
#define __POLL_H__

#pragma __U_NOT_USER_CODE__


#if defined( __solaris__ ) || defined( __irix__ )

#define U_FNDELAY O_NONBLOCK				// POSIX non-blocking

// ENOBUFS : system could not allocate an internal buffer. The operation may
// succeed when buffers become available.
#define U_EWOULDBLOCK EWOULDBLOCK || errno == ENOBUFS

#elif defined( __hp__ )

#define U_FNDELAY O_NONBLOCK				// POSIX non-blocking
#define U_EWOULDBLOCK EAGAIN

#else

#define U_FNDELAY FNDELAY
#define U_EWOULDBLOCK EWOULDBLOCK

#endif

class uPoll {
  public:
    enum uPollStatus { uNeverPoll, uPollOnDemand, uAlwaysPoll };
  private:
    uPollStatus uStatus;
  public:
    uPollStatus uGetStatus();
    void uComputeStatus( int fd );
    void uSetStatus( uPollStatus status );
    void uSetPollFlag( int fd );
    void uClearPollFlag( int fd );
};


#pragma __U_USER_CODE__

#endif // __POLL_H__


// Local Variables: //
// compile-command: "gmake install" //
// End: //
