//                              -*- Mode: C++ -*- 
// 
// uC++ Version 5.3.0, Copyright (C) Peter A. Buhr 1994
// 
// uPoll.cc -- 
// 
// Author           : Peter Buhr
// Created On       : Tue Mar 29 17:02:07 1994
// Last Modified By : Peter A. Buhr
// Last Modified On : Wed Aug 11 12:18:18 2004
// Update Count     : 30
//
// This  library is free  software; you  can redistribute  it and/or  modify it
// under the terms of the GNU Lesser General Public License as published by the
// Free Software  Foundation; either  version 2.1 of  the License, or  (at your
// option) any later version.
// 
// This library is distributed in the  hope that it will be useful, but WITHOUT
// ANY  WARRANTY;  without even  the  implied  warranty  of MERCHANTABILITY  or
// FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
// for more details.
// 
// You should  have received a  copy of the  GNU Lesser General  Public License
// along  with this library.
// 


#define __U_KERNEL__
#include <uC++.h>
//#include <uDebug.h>
#include <uPoll.h>

#include <sys/stat.h>
#include <fcntl.h>


void uPoll::uSetPollFlag( int fd ) {
    int flags;

    for ( ;; ) {
	flags = ::fcntl( fd, F_GETFL, 0 );
      if ( flags != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    if ( flags == -1 ) {
	uStatus = uNeverPoll;
    } else {
	for ( ;; ) {
	    flags = ::fcntl( fd, F_SETFL, flags | U_FNDELAY );
	  if ( flags != -1 ) break;
	  if ( errno != EINTR ) break;			// timer interrupt ?
	} // for
	if ( flags == -1 ) {
	    uStatus = uNeverPoll;
	} // if
    } // if
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uPoll &)0x%p.uSetPollFlag( %d ), uStatus:%d\n", this, fd, uStatus );
#endif // __U_DEBUG_H__
} // uPoll::uSetPollFlag


void uPoll::uClearPollFlag( int fd ) {
    int flags;

    for ( ;; ) {
	flags = ::fcntl( fd, F_GETFL, 0 );
      if ( flags != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
    if ( flags == -1 ) {
	uStatus = uNeverPoll;
    } else {
	for ( ;; ) {
	    flags = ::fcntl( fd, F_SETFL, flags & ~ U_FNDELAY );
	  if ( flags != -1 ) break;
	  if ( errno != EINTR ) break;			// timer interrupt ?
	} // for
	if ( flags == -1 ) {
	    uStatus = uNeverPoll;
	} // if
    } // if
} // uPoll::uClearPollFlag


void uPoll::uComputeStatus( int fd ) {
    struct stat buf;
    int flags;

    for ( ;; ) {
	flags = ::fstat( fd, &buf );
      if ( flags != -1 ) break;
      if ( errno != EINTR ) break;			// timer interrupt ?
    } // for
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uPoll &)0x%p.uComputeStatus( %d ), flags:%d, st_mode:0x%p\n", this, fd, flags, buf.st_mode );
#endif // __U_DEBUG_H__
    if ( flags ) {
	uStatus = uNeverPoll;				// if the file cannot be stat'ed, never poll
    } else if ( S_ISCHR(buf.st_mode) ) {
	uStatus = uPollOnDemand;			// if a tty, poll on demand
#ifdef S_IFIFO
    } else if ( S_ISFIFO(buf.st_mode) ) {
	uStatus = uAlwaysPoll;				// if a pipe, always poll
#endif
    } else if ( S_ISSOCK(buf.st_mode) ) {
	uStatus = uAlwaysPoll;				// if a socket, always poll
    } else {
	uStatus = uNeverPoll;				// otherwise, never
    } // if
#ifdef __U_DEBUG_H__
    uDebugPrt( "(uPoll &)0x%p.uComputeStatus( %d ), uStatus:%d\n", this, fd, uStatus );
#endif // __U_DEBUG_H__
} // uPoll::uComputeStatus


void uPoll::uSetStatus( uPollStatus s ) {
    uStatus = s;
} // uPoll::uSetStatus


uPoll::uPollStatus uPoll::uGetStatus() {
    return uStatus;
} // uPoll::uGetStatus


// Local Variables: //
// compile-command: "gmake install" //
// End: //
