/* ==================================================== ======== ======= *
 *
 *  uucall.cc
 *  Ubit Project  [Elc2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)ucall.cc	ubit:03.04.00"
#include <udefs.hpp>
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uprop.hpp>
#include <ubox.hpp>
#include <uevent.hpp>
#include <uwin.hpp>
#include <uview.hpp>
#include <umenu.hpp>
 
/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

void UGenCallImpl::addingTo(ULink *selflink, UGroup *parent) {
  // valeur par defaut
  if (!selflink->getCond()) selflink->setCond(UOn::action);
  // ensuite!
  UBrick::addingTo(selflink, parent);
  //NB: cette fct fera: parent->setModes(selflink->cond);
}

void UGenCallImpl::removingFrom(ULink *selflink, UGroup *parent) {
  // ne PAS faire " par->setCmodes(on, false) " car il peut y avoir
  // plusieurs callbacks avec la meme condition
  // (et de toute facon ce n'est pas une erreur, juste un peu plus long)
  UBrick::removingFrom(selflink, parent);
}

//{return ucall(&UGroup::closeWin, status, (const UClass)null);}
//UCall& ucloseDialog() 
//{return ucall(&UGroup::closeWin, UDialog::uclass);}
//UCall& ucloseMenu() 
//{return ucall(&UGroup::closeWin, UMenu::uclass);}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:01] ======= */

