/* ==================================================== ======== ======= *
 *
 *  uunatgraph.cpp  [Native Layer: platform dependent implementation]
 *  Ubit Project [Elc][2003]
 *  Author: Eric Lecolinet
 *
 *  Part of the Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *
 *  (C) 1999-2003 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 *
 * ==================================================== [Elc:03] ======= *
 * ==================================================== ======== ======= */

//pragma ident	"@(#)uunatgraph.cpp	ubit:03.06.04"
#include <ubrick.hpp>
#include <ucall.hpp>
#include <uerror.hpp>
#include <unatdisp.hpp>
#include <ugraph.hpp>

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */
// Error handler qui ne fait rien : ca sert a eviter des catastrophes
// dans certains cas (X etant particuliermenet bien concu en ce qui
// concerne la gestion des erreurs comme chacun sait ...)

//malheureusement cette var. est static car quietErrorHandler doit l'etre
int UXtry::xerror;

extern "C" {
typedef int (*UX_ErrorHandler)(Display*, XErrorEvent*);
}

UXtry::UXtry() {
  xerror = Success; 
  xhandler = XSetErrorHandler((UX_ErrorHandler)quietErrorHandler);
}

UXtry::~UXtry(){
  XSetErrorHandler(xhandler);
}

bool UXtry::status() {
  return xerror == Success;
}

int UXtry::quietErrorHandler(Display*, XErrorEvent *xer) {
  xerror = xer->error_code;
  return 0;
}

/* ==================================================== [Elc:03] ======= */
/* ==================================================== ======== ======= */

UNatGraph::UNatGraph(UNatDisp *natdisp) {
  graph_lock = null;
  xor_mode = false;
  font_styles = 0;
  thickness = 0;
  color   = BlackPixelOfScreen(natdisp->getXScreen());
  bgcolor = WhitePixelOfScreen(natdisp->getXScreen());
  font    = null;
#ifdef WITH_GL
  glFontList = 0;
#endif

  XGCValues gcval;
  gcval.function   = GXcopy;
  gcval.foreground = color;
  gcval.background = bgcolor;
  // graphics_exposures = true means that events are generated when
  // XCopyArea or XCopyPlanes is called and a part of the view is obscured
  // This is useless here except when scrolling data (the last argument 
  // of the UGraph::copyArea function can be used to change this
  // behavior (see fct. copyArea() in ugraph.hpp for details)
  gcval.graphics_exposures = false;

  //Note: The GC can be used with any destination drawable having 
  //the same root and depth as the specified drawable. 
  gc = XCreateGC(natdisp->getXDisplay(), 
		 natdisp->getXWindow(),
		 GCFunction | GCForeground | GCBackground | GCGraphicsExposures,
		 &gcval);
}

void UNatGraph::reset() {
  xor_mode = false;
  font_styles = 0;
  thickness = 0;
  //...
}

void UNatGraph::lock(UGraph* g) {
  ///if (graph_lock) graph_lock->natgraph = null; // !!!
  graph_lock = g;
#ifdef WITH_GL
  glPushAttrib(GL_LINE_BIT);
#endif

  XGCValues gcval;
  gcval.function = GXcopy;
  gcval.line_width = 0;
  XChangeGC(g->getNatDisp()->getXDisplay(), gc, GCFunction|GCLineWidth, &gcval);
#ifdef WITH_GL
  glLineWidth((GLfloat)thickness);
#endif
}

void UNatGraph::unlock() {
  graph_lock = null;
#ifdef WITH_GL
  glPopAttrib();
#endif
}

/* ==================================================== [TheEnd] ======= */
/* ==================================================== [Elc:03] ======= */
