/* Ubuntulooks Engine
 * Copyright (C) 2005 Richard Stellingwerff.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Written by Owen Taylor <otaylor@redhat.com>
 * and by Alexander Larsson <alexl@redhat.com>
 * Modified by Richard Stellingwerff <remenic@gmail.com>
 */
#include <gtk/gtkstyle.h>

#include "animation.h"
#include "ubuntulooks_types.h"

typedef struct _UbuntulooksStyle UbuntulooksStyle;
typedef struct _UbuntulooksStyleClass UbuntulooksStyleClass;

extern GType ubuntulooks_type_style;

#define UBUNTULOOKS_TYPE_STYLE              ubuntulooks_type_style
#define UBUNTULOOKS_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST ((object), UBUNTULOOKS_TYPE_STYLE, UbuntulooksStyle))
#define UBUNTULOOKS_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), UBUNTULOOKS_TYPE_STYLE, UbuntulooksStyleClass))
#define UBUNTULOOKS_IS_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE ((object), UBUNTULOOKS_TYPE_STYLE))
#define UBUNTULOOKS_IS_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), UBUNTULOOKS_TYPE_STYLE))
#define UBUNTULOOKS_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), UBUNTULOOKS_TYPE_STYLE, UbuntulooksStyleClass))

struct _UbuntulooksStyle
{
	GtkStyle parent_instance;

	UbuntulooksColors colors;
	
	guint8   progressbarstyle;
	guint8   menubarstyle;
	guint8   menuitemstyle;
	guint8   listviewitemstyle;
	GdkColor scrollbar_color;
	gboolean has_scrollbar_color;
	gboolean animation;
	gboolean gdm;
};

struct _UbuntulooksStyleClass
{
  GtkStyleClass parent_class;
};


void ubuntulooks_style_register_type (GTypeModule *module);
