/***************************************************************************
 *   Copyright (C) 2008 by Alexey Balakin                                  *
 *   mathgl.abalakin@gmail.com                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include <qsettings.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <QCloseEvent>
#include <QTextEdit>
#include "finddialog.h"
//-----------------------------------------------------------------------------
FindDialog::FindDialog(QWidget *parent) : QDialog(parent)
{
	QLabel *lbl;
	QHBoxLayout *a;
	setWindowTitle(tr("UDAV - Find"));
	QVBoxLayout *o = new QVBoxLayout;
	a = new QHBoxLayout;	o->addLayout(a);
	lbl = new QLabel(tr("Find &what:"), this);			a->addWidget(lbl);
	line = new QLineEdit(this);	lbl->setBuddy(line);	a->addWidget(line);
	a = new QHBoxLayout;	o->addLayout(a);
	lbl = new QLabel(tr("Replace &by:"), this);			a->addWidget(lbl);
	text = new QLineEdit(this);	lbl->setBuddy(text);	a->addWidget(text);

	caseUse = new QCheckBox(tr("Match &case"), this);	o->addWidget(caseUse);
	backward = new QCheckBox(tr("Search &backward"), this);	o->addWidget(backward);

	a = new QHBoxLayout(this);	a->setMargin(11);
	a->setSpacing(6);			a->addLayout(o);
	o = new QVBoxLayout;		a->addLayout(o);
	find = new QPushButton(tr("&Find"), this);		o->addWidget(find);
	find->setDefault(true);	find->setEnabled(false);
	repl= new QPushButton(tr("&Replace"), this);	o->addWidget(repl);
	repl->setEnabled(false);
	cancel = new QPushButton(tr("Close"), this);	o->addWidget(cancel);
	o->addStretch(1);
	connect(line, SIGNAL(textChanged(const QString &)), this, SLOT(enableFind(const QString &)));
	connect(find, SIGNAL(clicked()), this, SLOT(findClicked()));
	connect(repl, SIGNAL(clicked()), this, SLOT(replClicked()));
	connect(cancel, SIGNAL(clicked()),this, SLOT(close()));
}
//-----------------------------------------------------------------------------
FindDialog::~FindDialog()	{}
//-----------------------------------------------------------------------------
void FindDialog::findClicked()
{	emit findText(line->text(), caseUse->isChecked(), backward->isChecked());	}
//-----------------------------------------------------------------------------
void FindDialog::replClicked()
{	emit replText(line->text(), text->text(), caseUse->isChecked(), backward->isChecked());	}
//-----------------------------------------------------------------------------
void FindDialog::enableFind(const QString &txt)
{	find->setEnabled(!txt.isEmpty());	repl->setEnabled(!txt.isEmpty());	}
//-----------------------------------------------------------------------------
void FindDialog::closeEvent(QCloseEvent *event)
{
	emit replText("", "", false, false);
	event->accept();
}
//-----------------------------------------------------------------------------
//
//	Hint dialog
//
//-----------------------------------------------------------------------------
#define qtr		HintDialog::tr
int numHints=-1;
QString hints[] = {	qtr("You can rotate plot by mouse. Just press 'Rotate' toolbutton, click image and hold a mouse button: left button for rotation, right button for zooming/perspective, middle button for shifting."),
	qtr("You may quickly draw the data from file. Just use: udav 'filename.dat' in command line."),
	qtr("You can copy the current image to clipboard by pressing Ctrl-Shift-C. Later you can paste it directly into yours document or presentation."),
	qtr("You can export image into a set of format (EPS, SVG, PNG, JPEG) by pressing right mouse button inside image and selecting 'Export as ...'."),
	qtr("You can setup colors for script highlighting in Property dialog. Just select menu item 'Edit/Properties'."),
	qtr("You can save the parameter of animation inside MGL script by using comment started from '##a '."),
	qtr("New drawing never clears things drawn already. For example, you can make a surface with contour lines by calling commands 'surf' and 'cont' one after another (in any order). "),
	qtr("You can put several plots in the same image by help of commands 'subplot' or 'inplot'."),
	qtr("All indexes (of data arrays, subplots and so on) are always start from 0."),
	qtr("You can edit MGL file in any text editor."),
	qtr("You can use command 'once on|off' for marking the block which should be executed only once. For example, the block of large data reading/creating/handling. Press F9 (or menu item 'Graphics/Reload') to re-execute this block."),
	qtr("You can use command 'stop' for terminating script parsing. It is useful if you don't want to execute a part of script."),
	qtr("")};

//-----------------------------------------------------------------------------
double mgl_rnd();
HintDialog::HintDialog(QWidget *parent) : QDialog(parent)
{
	if(numHints<0)
		for(numHints=0;!hints[numHints].isEmpty();numHints++){};
	cur = int(mgl_rnd()*numHints);
	setWindowTitle(tr("UDAV - Hint"));
	QHBoxLayout *a;
	QPushButton *b;
	QVBoxLayout *o = new QVBoxLayout(this);
	text = new QTextEdit(this);	o->addWidget(text);
	text->setReadOnly(true);	text->setText(hints[cur]);

	start = new QCheckBox(tr("&Show at startup"), this);	o->addWidget(start);
	start->setChecked(true);

	a = new QHBoxLayout;	o->addLayout(a);
	b = new QPushButton(tr("&Prev"), this);		a->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(prevClicked()));
	b = new QPushButton(tr("&Next"), this);		a->addWidget(b);
	connect(b, SIGNAL(clicked()), this, SLOT(nextClicked()));
	b = new QPushButton(tr("&Close"), this);	a->addWidget(b);
	connect(b, SIGNAL(clicked()),this, SLOT(close()));
}
//-----------------------------------------------------------------------------
HintDialog::~HintDialog()	{}
//-----------------------------------------------------------------------------
void HintDialog::nextClicked()
{	cur = (cur+1)%numHints;	text->setText(hints[cur]);	}
//-----------------------------------------------------------------------------
void HintDialog::prevClicked()
{	cur--;	if(cur<0)	cur=numHints-1;	text->setText(hints[cur]);	}
//-----------------------------------------------------------------------------
void HintDialog::closeEvent(QCloseEvent *)
{
	QSettings settings("abalakin","UDAV");
	settings.setPath(QSettings::IniFormat, QSettings::UserScope, "UDAV");
	settings.beginGroup("/UDAV");
	settings.setValue("/showHint", start->isChecked());
	settings.endGroup();
}
//-----------------------------------------------------------------------------
