#ifndef UWM_H

#define UWM_H

#include <stdio.h>
#include <sys/types.h>
#include <sys/ipc.h>

#include <X11/cursorfont.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/xpm.h>

#include "nodes.h"
#include "menu.h"
#include "lib/desktop.h"
#include "MwmUtil.h"

/*** some debugging and developement settings ***/

/*** DEVELOPERS PRIVILEGE: makes /dev/tty10 to be the standard
     error output... ***/
/*#define DEVEL  */

/*** will remove debugging code if not defined (defineing this will
     make the program REALLY verbose...) ***/
/*#define DEBUG */

/* no changes necessary below this point */
#ifdef DEBUG
#define DBG(arg) arg
#else
#define DBG(arg)
#endif


/*** some predefinitions... ***/

#define HANDLED_EVENTS KeyPressMask|KeyReleaseMask|ButtonPressMask|ButtonReleaseMask|EnterWindowMask|LeaveWindowMask|PropertyChangeMask|SubstructureNotifyMask|SubstructureRedirectMask

#define INPUTWIN_EVENTS KeyPressMask

#define WINDOW_EVENTS PropertyChangeMask /*PropertyChangeMask*/

#define BORDER_EVENTS ButtonPressMask|ButtonReleaseMask|ExposureMask

#define TITLE_EVENTS ExposureMask|ButtonPressMask|ButtonReleaseMask|EnterWindowMask

#define FRAME_EVENTS EnterWindowMask|LeaveWindowMask|SubstructureRedirectMask|SubstructureNotifyMask

/*** used structures ***/ 

/* UDEScreen describes the managed screen */
#define CURSORS 12
#define C_DEFAULT 0
#define C_N 1
#define C_NO 2
#define C_O 3
#define C_SO 4
#define C_S 5
#define C_SW 6
#define C_W 7
#define C_NW 8
#define C_DRAG 9
#define C_BORDER 10
#define C_WINDOW 11

#define ICONWINS 7
#define I_ICONIFY 0
#define I_CLOSE 1
#define I_AUTORISE 2
#define I_BACK 3
#define I_KILL 4
#define I_MENU 5
#define I_REALLY 6

typedef char WSName[32];

typedef struct
{ int Screen;
  unsigned int width,height;
  Window root, inputwin;
  struct {
    Window IconWins[ICONWINS];
    Pixmap IconPixs[ICONWINS];
    Pixmap IconSelectPixs[ICONWINS];
    Pixmap shape;
    Window IconParent;
  } icons;

  Menu *AppsMenu;
  Menu *UWMMenu;
  GC rubbercontext,blackcontext;
  WSName *WorkSpace;
  NodeList *UltimateList;        /* contains all ultimized windows,
                                    data of type UltimateContext * */
  int BorderWidth1,BorderWidth2,TitleHeight;
  int MaxWinWidth,MaxWinHeight;
  Cursor Mice[CURSORS];
  Colormap colormap;
  float FrameBevelFactor;
  /* if SetBackground[ws#] is set to 0 the background of that ws is not
     changed unless BackPixmap[ws#] is not NULL */
  unsigned char *SetBackground;
  unsigned long *Background;
  unsigned long *InactiveBorder, *InactiveLight, *InactiveShadow;
  unsigned long *ActiveBorder, *ActiveLight, *ActiveShadow;
  unsigned long *ActiveTitleFont, *InactiveTitleFont;
  XFontStruct *TitleFont;
  char **BackCommand;
  Pixmap *BackPixmap;
  XpmAttributes *BackPixmapAttributes;
  XContext MenuContext;
  XFontStruct *MenuFont;
  UDEColors *Colors;
  UDEDesktop desktop;
  char udedir[256];
  char *Home;

  Atom UDE_WORKSPACES_PROPERTY, UDE_SETTINGS_PROPERTY, UDE_WINDOW_PROPERTY;

  FILE *errout;
} UDEScreen;


/*** Window-Context structure ***/

/* status-flags */
#define REPARENTING  (1<<0)
#define RISEN        (1<<1)    /* window autorisen? */
#define ICONIFIED    (1<<2)    /* window iconified */
#define MAPPED       (1<<3)    /* window mapped */
#define KEEPMAPPED   (1<<4)    /* window still mapped, only changeing WS? */
#define PLACEIT      (1<<5)    /* Autoplace window before mapping? */
#define KEEPENBORDERED (1<<6)  /* Don't disenborder unmapped window? */
#define SHAPED       (1<<7)  /* window shaped? */

/* wm-protocol-flags */
#define TAKE_FOCUS    (1<<0)
#define DELETE_WINDOW (1<<1)

typedef struct _UltimateContext
{ Window win,frame; /* frame: if created: Frame-Window else: None */
  Window parent;
  Window border;    /* a child of the frame to set the Mouse pointer right... */
  Window title;    /* a child of the frame containing the window's title... */
  int BorderWidth,OldBorderWidth;
  int TitleWidth,TitleHeight;
  unsigned char status;   /* status flags */
  XWindowAttributes Attributes,Attr;  /* Attributes: window; Attr: Frame */
  struct {
    int x,y,w,h;               /* original window coordinates before autorise */
    int minw,minh,maxw,maxh;          /* How big can I get? */
    int wi,hi;                        /* increases */
    int bw,bh;                        /* offsets considering the increases... */
  } ra;                           /*** ResizeAttributes ***/
  char *name;
  unsigned char ProtocolFlags;
  XWMHints *WMHints;              /* some information... */
  PropMotifWmHints *MotifWMHints;
  short WorkSpace;
  NodeList *SiblingTo;            /* who am I a sibling to? Data Type is UltimateContext */
  struct _UltimateContext *MySibling;     /* who's my sibling? */
  int StackMode;                  /* StackMode of the Window */
} UltimateContext;


/*** Structure describeing an application programm that can be called by uwm ***/
typedef struct {
  char *command;
} AppStruct;

typedef void (*HandlerTable)();

/*** prototypes ***/

void CleanUp(Bool StopScript);
                    /* Procedure to clean up, only needed before Restart */
void SeeYa(int ecode, char *vocalz);   /* Procedure to say good bye */

#endif
