/*

  Copyright (c) 2003,2004 uim Project http://uim.freedesktop.org/

  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of authors nor the names of its contributors
     may be used to endorse or promote products derived from this software
     without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
  OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
  HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
  LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
  OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
  SUCH DAMAGE.

*/

#ifndef CALLBACKS_H
#define CALLBACKS_H

#include <uim/uim.h>

struct preedit_tag {
  /* ʸ */
  int width;
  /* ֤ˤʸ */
  int cursor;
  /* pseg礭 */
  int nr_psegs;
  /* ٤ꤢpsegattrϰۤʤ褦ˤ */
  struct preedit_segment_tag {
    int attr;
    char *str;
  } *pseg;
};

void init_callbacks(uim_context context, int status_type, int cursor_no_reverse, int statusline_width);
int press_key(int key, int key_state);
char *get_commit_str(void);
char *get_statusline_str(void);
char *get_candidate_str(void);
int get_candidate_col(void);
char *get_index_str(void);
int get_index_col(void);
struct preedit_tag *get_preedit(void);
int get_mode(void);
void commit_cb(void *ptr, const char *commit_str);
struct preedit_tag *create_preedit(void);
void free_preedit(struct preedit_tag *p);
void callbacks_winch(void);
void callbacks_set_mode(int mode);

#endif
