/*
 * uncc - The ultimate C decompiler
 * Copyright (C) 2003  Megabug <megabug@autistici.org>,
 *                     Little-John <littlejohn@autistici.org>
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <stdlib.h>
#include <string.h>

#include "registers.h"
#include "functions.h"
#include "expressions.h"

static Register *regs = NULL;

void REGS_add(Register *r)
{
	r->next=regs;
	regs=r;
}

Register *REGS_new(char *r)
{
	Register *n=(Register *)malloc(sizeof(Register));
	n->name = strdup(r);
	n->value = NULL;
	n->must_drop = 0;
	REGS_add(n);
	return n;
}

Register *REGS_find(char *r)
{
	Register *i;
	for (i=regs; i; i=i->next)
		if (!strcmp(i->name,r))
			return i;
	return NULL;
}

Register *REGS_find_or_new(char *r)
{
	Register *i;
	i = REGS_find(r);
	if (i!=NULL)
		return i;
	return REGS_new(r);
}

void REGS_flush(Register *r)
{
	if (r->value==NULL) return;
	if (r->must_drop)
	{
		FUNCTIONS_add_body_line( r->drop_to, EXPR_copy(r->value) );
		r->must_drop=0;
	}
	EXPR_free(r->value);
}

void REGS_link(Register *r, Expr *e)
{
	r->value = e;
}

void REGS_drop_to(Register *r, Function *f)
{
	r->must_drop = 1;
	r->drop_to = f;
}

Expr *REGS_expr(Register *r)
{
	if (r->must_drop)
		r->must_drop=0;
	return r->value;
}

char *REGS_name(Register *r)
{	return r->name; }

void REGS_dump_all()
{
	Register *r;
	for ( r=regs; r; r=r->next )
	{
		printf( "   %s => ", REGS_name(r) );
		EXPR_print_tree(REGS_expr(r),stdout);
		printf("\n");
	}
}

