/*
 * UnixCW - Unix CW (Morse code) training program
 * Copyright (C) 2001, 2002  Simon Baldwin (simonb@caldera.com)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * XcwcpMultiLineEdit.cpp - Subclass of QMultiLineEdit for catching events. 
 *
 */

/* Include files. */
#include "XcwcpMultiLineEdit.h"
#include "XcwcpApplication.h"

#include <qwidget.h>
#include <qmultilineedit.h>
#include <qevent.h>


/*
 * Constructor.  Call the superclass constructor, and if the parent widget
 * is an instance of XcwcpApplication, save it for sending on key events.
 */
XcwcpMultiLineEdit::XcwcpMultiLineEdit (QWidget *parent, const char *name)
	: QMultiLineEdit (parent, name)
{
	parent_xcwcp_reference = dynamic_cast<XcwcpApplication*> (parent);
}


/*
 * Catch key events and pass them to our parent XcwcpApplication.  Both press
 * and release events are merged into one *_event() call.
 */
void
XcwcpMultiLineEdit::keyPressEvent (QKeyEvent *event)
{
	if (parent_xcwcp_reference != NULL)
		parent_xcwcp_reference->key_event (event);
}
void
XcwcpMultiLineEdit::keyReleaseEvent (QKeyEvent *event)
{
	if (parent_xcwcp_reference != NULL)
		parent_xcwcp_reference->key_event (event);
}


/*
 * Do the same for mouse button events.  We need to catch both press and
 * double-click, since for keying we don't use or care about double-
 * clicks, just any form of button press, any time.
 */
void
XcwcpMultiLineEdit::mousePressEvent (QMouseEvent *event)
{
	if (parent_xcwcp_reference != NULL)
		parent_xcwcp_reference->mouse_event (event);
}
void
XcwcpMultiLineEdit::mouseDoubleClickEvent (QMouseEvent *event)
{
	if (parent_xcwcp_reference != NULL)
		parent_xcwcp_reference->mouse_event (event);
}
void
XcwcpMultiLineEdit::mouseReleaseEvent (QMouseEvent *event)
{
	if (parent_xcwcp_reference != NULL)
		parent_xcwcp_reference->mouse_event (event);
}


/*
 * backspace()
 *
 * Public backspace call entry point.  This allows an external class to
 * call backspace().  I'm not really sure why backspace() is protected in
 * QMultiLineEdit in the first case, but anyway, this defeats it.
 */
void
XcwcpMultiLineEdit::backspace ()
{
	QMultiLineEdit::backspace ();
}
