/*********************************************************************
 *
 * unixODBC Cursor Library
 *
 * Created by Nick Gorham
 * (nick@easysoft.com).
 *
 * copyright (c) 1999 Nick Gorham
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 **********************************************************************
 *
 * $Id: SQLGetStmtAttr.c,v 1.1.1.1 2001/10/17 16:40:15 lurcher Exp $
 *
 * $Log: SQLGetStmtAttr.c,v $
 * Revision 1.1.1.1  2001/10/17 16:40:15  lurcher
 *
 * First upload to SourceForge
 *
 * Revision 1.1.1.1  2000/09/04 16:42:52  nick
 * Imported Sources
 *
 * Revision 1.2  1999/12/04 17:01:26  ngorham
 *
 * Remove C++ comments from the Postgres code
 *
 * Revision 1.1  1999/09/19 22:22:50  ngorham
 *
 *
 * Added first cursor library work, read only at the moment and only works
 * with selects with no where clause
 *
 *
 **********************************************************************/

#include "cursorlibrary.h"

SQLRETURN CLGetStmtAttr( SQLHSTMT statement_handle,
           SQLINTEGER attribute,
           SQLPOINTER value,
           SQLINTEGER buffer_length,
           SQLINTEGER *string_length )
{
    CLHSTMT cl_statement = (CLHSTMT) statement_handle; 

    switch( attribute )
    {
      case SQL_ATTR_CONCURRENCY:
        *(( SQLUINTEGER * ) value ) = cl_statement -> concurrency;
        break;
        
      case SQL_ATTR_CURSOR_TYPE:
        *(( SQLUINTEGER * ) value ) = cl_statement -> cursor_type;
        break;

      case SQL_ATTR_PARAM_BIND_OFFSET_PTR:
        *(( SQLPOINTER * ) value ) = cl_statement -> param_bind_offset_ptr;
        break;

      case SQL_ATTR_PARAM_BIND_TYPE:
        *(( SQLUINTEGER * ) value ) = cl_statement -> param_bind_type;
        break;

      case SQL_ATTR_ROW_BIND_OFFSET_PTR:
        *(( SQLPOINTER * ) value ) = cl_statement -> row_bind_offset_ptr;
        break;

      case SQL_ATTR_ROW_BIND_TYPE:
        *(( SQLUINTEGER * ) value ) = cl_statement -> row_bind_type;
        break;

      case SQL_ATTR_ROW_ARRAY_SIZE:
        *(( SQLUINTEGER * ) value ) = cl_statement -> rowset_array_size;
        break;

      case SQL_ATTR_SIMULATE_CURSOR:
        *(( SQLUINTEGER * ) value ) = cl_statement -> simulate_cursor;
        break;
            
      case SQL_ATTR_USE_BOOKMARKS:
        *(( SQLUINTEGER * ) value ) = cl_statement -> use_bookmarks;
        break;

      case SQL_ATTR_ROW_STATUS_PTR:
        *(( SQLUSMALLINT ** ) value ) = cl_statement -> row_status_ptr;
        break;

      case SQL_ATTR_ROWS_FETCHED_PTR:
        *(( SQLUINTEGER ** ) value ) = cl_statement -> rows_fetched_ptr;
        break;

      default:
        return SQLGETSTMTATTR( cl_statement -> cl_connection,
               cl_statement -> driver_stmt,
               attribute,
               value,
               buffer_length,
               string_length );
    }

    return SQL_SUCCESS;
}
