/* $Id: mgavb.c,v 1.28 2000/06/22 17:14:14 ehliar Exp $ */
/*
 * GLX Hardware Device Driver for Matrox Millenium G200
 * Copyright (C) 1999 Wittawat Yamwong
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * WITTAWAT YAMWONG, OR ANY OTHER CONTRIBUTORS BE LIABLE FOR ANY CLAIM, 
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR 
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE 
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 *
 *    Wittawat Yamwong <Wittawat.Yamwong@stud.uni-hannover.de>
 */

#include <stdlib.h>
#include <stdio.h>
 
#include "mgalib.h"
#include "mgavb.h"
#include "hwlog.h"
#include "mgadma.h"
#include "mgawarp.h"
#include "xsmesaP.h"
#include "xsmesa.h"

#include "stages.h"

#include "os.h"

extern mgaContextPtr mgaCtx;
extern mgaBufferPtr mgaDB;

#define TEX0 {					\
  v->warp2.tu0 = tc0[i][0];			\
  v->warp2.tv0 = tc0[i][1];			\
}

#define TEX1 {					\
  v->warp2.tu1 = tc1[i][0];			\
  v->warp2.tv1 = tc1[i][1];			\
}

#define SPC {					\
  GLubyte *spec = &(VB->Spec[0][i][0]);		\
  v->warp2.specular.red = spec[0];		\
  v->warp2.specular.green = spec[1];		\
  v->warp2.specular.blue = spec[2];		\
}

#define FOG {					\
  GLubyte *spec = &(VB->Spec[0][i][0]);		\
  v->warp2.specular.alpha = spec[3];		\
}

#define COL {					\
  GLubyte *col = &(VB->Color[0]->data[i][0]);	\
  v->warp2.color.blue  = col[2];		\
  v->warp2.color.green = col[1];		\
  v->warp2.color.red   = col[0];		\
  v->warp2.color.alpha = col[3];		\
}

/* The warp2 code we have doesn't seem to support projective texturing
 * in the multitexture case.  (Would require another 1/w value for the
 * second set of texcoords).  This may be a problem for the g400.  
 */
#define TEX0_4						\
  if (VB->TexCoordPtr[0]->size == 4)			\
  {							\
     GLfloat (*tc)[4] = VB->TexCoordPtr[0]->data;	\
     v = &(MGA_DRIVER_DATA(VB)->verts[start]);		\
     mgaCtx->setupdone &= ~MGA_WIN_BIT;			\
     for (i=start; i < end; i++, v++)	{		\
        float oow = 1.0 / tc[i][3];			\
	v->warp2.rhw *= tc[i][3];			\
	v->warp2.tu0 *= oow;				\
	v->warp2.tv0 *= oow;				\
     }							\
  }


#define COORD							\
      GLfloat *win = VB->Win.data[i];				\
      v->warp2.rhw =               win[3];			\
      v->warp2.z = (1.0/0x10000) * win[2];			\
      v->warp2.x =                 win[0] - 0.5F;		\
      v->warp2.y =          -      win[1] + mgaHeightFloat; 

#define NOP




#define SETUPFUNC(name,win,col,tex0,tex1,tex0_4,spec,fog)		\
static void name(struct vertex_buffer *VB, GLuint start, GLuint end)	\
{									\
   mgaVertexPtr v;							\
   GLfloat (*tc0)[4];							\
   GLfloat (*tc1)[4];							\
   GLfloat mgaHeightFloat = mgaDB->height - 0.5;			\
   int i;								\
   (void) mgaHeightFloat;						\
									\
   CHECK_CONTEXT( return; );						\
									\
   gl_import_client_data( VB, VB->ctx->RenderFlags,			\
			  (VB->ClipOrMask				\
			   ? VEC_WRITABLE|VEC_GOOD_STRIDE		\
			   : VEC_GOOD_STRIDE));				\
									\
   tc0 = VB->TexCoordPtr[mgaCtx->tmu_source[0]]->data;			\
   tc1 = VB->TexCoordPtr[mgaCtx->tmu_source[1]]->data;			\
									\
   v = &(MGA_DRIVER_DATA(VB)->verts[start]);				\
									\
   if (VB->ClipOrMask == 0)						\
      for (i=start; i < end; i++, v++) {				\
	 win;								\
	 col;								\
	 tex0;								\
	 tex1;								\
	 spec;								\
	 fog;								\
      }									\
   else									\
      for (i=start; i < end; i++, v++) {				\
	 if (VB->ClipMask[i] == 0) {					\
	    win;							\
	    tex0;							\
	    tex1;							\
	    spec;							\
	    fog;							\
	 }								\
	    col;							\
      }									\
   tex0_4;								\
}



SETUPFUNC(rs_wt0,	COORD,NOP,TEX0,NOP,TEX0_4,NOP,NOP)
SETUPFUNC(rs_wt0t1,	COORD,NOP,TEX0,TEX1,TEX0_4,NOP,NOP)
SETUPFUNC(rs_wft0,	COORD,NOP,TEX0,NOP,TEX0_4,NOP,FOG)
SETUPFUNC(rs_wft0t1,	COORD,NOP,TEX0,TEX1,TEX0_4,NOP,FOG)
SETUPFUNC(rs_wg,	COORD,COL,NOP,NOP,NOP,NOP,NOP)
SETUPFUNC(rs_wgs,	COORD,COL,NOP,NOP,NOP,SPC,NOP)
SETUPFUNC(rs_wgt0,	COORD,COL,TEX0,NOP,TEX0_4,NOP,NOP)
SETUPFUNC(rs_wgt0t1,	COORD,COL,TEX0,TEX1,TEX0_4,NOP,NOP)
SETUPFUNC(rs_wgst0,	COORD,COL,TEX0,NOP,TEX0_4,SPC,NOP)
SETUPFUNC(rs_wgst0t1,	COORD,COL,TEX0,TEX1,TEX0_4,SPC,NOP)
SETUPFUNC(rs_wgf,	COORD,COL,NOP,NOP,NOP,NOP,FOG)
SETUPFUNC(rs_wgfs,	COORD,COL,NOP,NOP,NOP,SPC,FOG)
SETUPFUNC(rs_wgft0,	COORD,COL,TEX0,NOP,TEX0_4,NOP,FOG)
SETUPFUNC(rs_wgft0t1,	COORD,COL,TEX0,TEX1,TEX0_4,NOP,FOG)
SETUPFUNC(rs_wgfst0,	COORD,COL,TEX0,NOP,TEX0_4,SPC,FOG)
SETUPFUNC(rs_wgfst0t1,	COORD,COL,TEX0,TEX1,TEX0_4,SPC,FOG)

SETUPFUNC(rs_t0,	NOP,NOP,TEX0,NOP,TEX0_4,NOP,NOP)
SETUPFUNC(rs_t0t1,	NOP,NOP,TEX0,TEX1,TEX0_4,NOP,NOP)
SETUPFUNC(rs_f,		NOP,NOP,NOP,NOP,NOP,NOP,FOG)
SETUPFUNC(rs_ft0,	NOP,NOP,TEX0,NOP,TEX0_4,NOP,FOG)
SETUPFUNC(rs_ft0t1,	NOP,NOP,TEX0,TEX1,TEX0_4,NOP,FOG)
SETUPFUNC(rs_g,		NOP,COL,NOP,NOP,NOP,NOP,NOP)
SETUPFUNC(rs_gs,	NOP,COL,NOP,NOP,NOP,SPC,NOP)
SETUPFUNC(rs_gt0,	NOP,COL,TEX0,NOP,TEX0_4,NOP,NOP)
SETUPFUNC(rs_gt0t1,	NOP,COL,TEX0,TEX1,TEX0_4,NOP,NOP)
SETUPFUNC(rs_gst0,	NOP,COL,TEX0,NOP,TEX0_4,SPC,NOP)
SETUPFUNC(rs_gst0t1,	NOP,COL,TEX0,TEX1,TEX0_4,SPC,NOP)
SETUPFUNC(rs_gf,	NOP,COL,NOP,NOP,NOP,NOP,FOG)
SETUPFUNC(rs_gfs,	NOP,COL,NOP,NOP,NOP,SPC,FOG)
SETUPFUNC(rs_gft0,	NOP,COL,TEX0,NOP,TEX0_4,NOP,FOG)
SETUPFUNC(rs_gft0t1,	NOP,COL,TEX0,TEX1,TEX0_4,NOP,FOG)
SETUPFUNC(rs_gfst0,	NOP,COL,TEX0,NOP,TEX0_4,SPC,FOG)
SETUPFUNC(rs_gfst0t1,	NOP,COL,TEX0,TEX1,TEX0_4,SPC,FOG)


static void rs_invalid(struct vertex_buffer *VB, GLuint start, GLuint end)
{
  hwError("mgaRasterSetup(): invalid combination\n");
}

typedef void (*setupFunc)(struct vertex_buffer *,GLuint,GLuint);

static setupFunc setup_func[0x80];

void mgaDDSetupInit( void )
{
   int i;

   for (i = 0 ; i < 0x80 ; i++)
      setup_func[i] = rs_invalid;
   
   /* Functions to build vert's from scratch */
   setup_func[MGA_WIN_BIT|MGA_TEX0_BIT] = rs_wt0;
   setup_func[MGA_WIN_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_wt0t1;
   setup_func[MGA_WIN_BIT|MGA_FOG_BIT|MGA_TEX0_BIT] = rs_wft0;
   setup_func[MGA_WIN_BIT|MGA_FOG_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_wft0t1;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT] = rs_wg;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_SPEC_BIT] = rs_wgs;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_TEX0_BIT] = rs_wgt0;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_wgt0t1;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_SPEC_BIT|MGA_TEX0_BIT] = rs_wgst0;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_SPEC_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_wgst0t1;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_FOG_BIT] = rs_wgf;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_FOG_BIT|MGA_SPEC_BIT] = rs_wgfs;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_FOG_BIT|MGA_TEX0_BIT] = rs_wgft0;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_FOG_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_wgft0t1;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_FOG_BIT|MGA_SPEC_BIT|MGA_TEX0_BIT] = rs_wgfst0;
   setup_func[MGA_WIN_BIT|MGA_RGBA_BIT|MGA_FOG_BIT|MGA_SPEC_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_wgfst0t1;

   /* Repair functions */
   setup_func[MGA_TEX0_BIT] = rs_t0;
   setup_func[MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_t0t1;
   setup_func[MGA_FOG_BIT] = rs_f;
   setup_func[MGA_FOG_BIT|MGA_TEX0_BIT] = rs_ft0;
   setup_func[MGA_FOG_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_ft0t1;
   setup_func[MGA_RGBA_BIT] = rs_g;
   setup_func[MGA_RGBA_BIT|MGA_SPEC_BIT] = rs_gs;
   setup_func[MGA_RGBA_BIT|MGA_TEX0_BIT] = rs_gt0;
   setup_func[MGA_RGBA_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_gt0t1;
   setup_func[MGA_RGBA_BIT|MGA_SPEC_BIT|MGA_TEX0_BIT] = rs_gst0;
   setup_func[MGA_RGBA_BIT|MGA_SPEC_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_gst0t1;
   setup_func[MGA_RGBA_BIT|MGA_FOG_BIT] = rs_gf;
   setup_func[MGA_RGBA_BIT|MGA_FOG_BIT|MGA_SPEC_BIT] = rs_gfs;
   setup_func[MGA_RGBA_BIT|MGA_FOG_BIT|MGA_TEX0_BIT] = rs_gft0;
   setup_func[MGA_RGBA_BIT|MGA_FOG_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_gft0t1;
   setup_func[MGA_RGBA_BIT|MGA_FOG_BIT|MGA_SPEC_BIT|MGA_TEX0_BIT] = rs_gfst0;
   setup_func[MGA_RGBA_BIT|MGA_FOG_BIT|MGA_SPEC_BIT|MGA_TEX0_BIT|MGA_TEX1_BIT] = rs_gfst0t1;

}


void mgaPrintSetupFlags(char *msg, GLuint flags )
{
   fprintf(stderr, "%s: %d %s%s%s%s%s%s%s\n",
	   msg,
	   flags,
	   (flags & MGA_WIN_BIT)      ? " xyzw," : "", 
	   (flags & MGA_RGBA_BIT)     ? " rgba," : "",
	   (flags & MGA_SPEC_BIT)     ? " spec," : "",
	   (flags & MGA_FOG_BIT)      ? " fog," : "",
	   (flags & MGA_TEX0_BIT)     ? " tex-0," : "",
	   (flags & MGA_TEX1_BIT)     ? " tex-1," : "",
	   (flags & MGA_ALPHA_BIT)    ? " alpha," : "");
}




void mgaChooseRasterSetupFunc(GLcontext *ctx)
{
  int funcindex = (MGA_WIN_BIT | MGA_RGBA_BIT);

  mgaCtx->vertsize = 8;
  mgaCtx->tmu_source[0] = 0;
  mgaCtx->tmu_source[1] = 1;
  mgaCtx->tex_dest[0] = MGA_TEX0_BIT;
  mgaCtx->tex_dest[1] = MGA_TEX1_BIT;
  mgaCtx->multitex = 0;

  if (ctx->Texture.Enabled & 0xf) {
      /* This doesn't work for non-RGBA textures
      if (ctx->Texture.Unit[0].EnvMode == GL_REPLACE)
	 funcindex &= ~MGA_RGBA_BIT;
      */
     funcindex |= MGA_TEX0_BIT;
  }

  if (ctx->Texture.Enabled & 0xf0) {     
     if (ctx->Texture.Enabled & 0xf) {
	mgaCtx->multitex = 1;
	mgaCtx->vertsize = 10;
	funcindex |= MGA_TEX1_BIT;
     } else {
	/* Just a funny way of doing single texturing 
	 */
	mgaCtx->tmu_source[0] = 1;
	mgaCtx->tex_dest[1] = MGA_TEX0_BIT;

	/* This doesn't work for non-RGBA textures
	if (ctx->Texture.Unit[1].EnvMode == GL_REPLACE)
	   funcindex &= ~MGA_RGBA_BIT;
	*/

	funcindex |= MGA_TEX0_BIT;
     }
  }

  if (ctx->Color.BlendEnabled)
     funcindex |= MGA_ALPHA_BIT;

  if (ctx->Light.Model.ColorControl == GL_SEPARATE_SPECULAR_COLOR)
     funcindex |= MGA_SPEC_BIT;

  if (ctx->Fog.Enabled)
     funcindex |= MGA_FOG_BIT;

  if (0)
     mgaPrintSetupFlags("xsmesa: full setup function", funcindex); 

  mgaCtx->setupindex = funcindex;
  ctx->Driver.RasterSetup = setup_func[funcindex & ~MGA_ALPHA_BIT];
}


void mgaDDViewport( GLcontext *ctx, 
		    GLint x, GLint y, 
		    GLsizei width, GLsizei height )
{
  hwMsg(10, "mgaDDViewport %d %d %d %d\n", x,y, width,height);
  hwMsg(10, "\tmgaDB = %p\n", mgaDB);
  if (mgaDB) 
    hwMsg(10, "\tmagic = %x\n", mgaDB->magic);
}


void mgaDDDepthRange( GLcontext *ctx, GLclampd nearval, GLclampd farval )
{
}




void mgaDDCheckPartialRasterSetup( GLcontext *ctx, struct gl_pipeline_stage *d )
{
   GLuint tmp = mgaCtx->setupdone;

   d->type = 0;
   mgaCtx->setupdone = 0;	/* cleared if we return */

   if ((ctx->Array.Summary & VERT_OBJ_ANY) == 0)
      return;

   if (ctx->IndirectTriangles) 
      return;

   mgaCtx->setupdone = tmp;

   /* disabled until we have a merge&render op */
   /*     d->inputs = available; */
   /*     d->outputs = VERT_RAST_SETUP_PART; */
   /*     d->type = PIPE_PRECALC; */
}


/* Repair existing precalculated vertices with new data.
 */
void mgaDDPartialRasterSetup( struct vertex_buffer *VB )
{
   GLuint new = VB->pipeline->new_outputs;
   GLuint available = VB->pipeline->outputs;
   GLuint ind = 0;

   if (new & VERT_WIN) {
      new = available;
      ind |= MGA_WIN_BIT | MGA_FOG_BIT;
   }

   if (new & VERT_RGBA)
      ind |= MGA_RGBA_BIT | MGA_SPEC_BIT;

   if (new & VERT_TEX0_ANY) 
      ind |= MGA_TEX0_BIT;

   if (new & VERT_TEX1_ANY)
      ind |= mgaCtx->tex_dest[1];

   if (new & VERT_FOG_COORD)
      ind |= MGA_FOG_BIT;

   mgaCtx->setupdone &= ~ind;
   ind &= mgaCtx->setupindex;
   mgaCtx->setupdone |= ind;

   if (0)
      mgaPrintSetupFlags("xsmesa: partial setup function", ind);

   if (ind) 
      setup_func[ind&~MGA_ALPHA_BIT]( VB, VB->Start, VB->Count );   
}


void mgaDDDoRasterSetup( struct vertex_buffer *VB )
{
   GLcontext *ctx = VB->ctx;

   if (VB->Type == VB_CVA_PRECALC) 
      mgaDDPartialRasterSetup( VB );
   else if (ctx->Driver.RasterSetup)
      ctx->Driver.RasterSetup( VB, VB->CopyStart, VB->Count );
}




void mgaDDResizeVB( struct vertex_buffer *VB, GLuint size )
{
   mgaVertexBufferPtr mvb = MGA_DRIVER_DATA(VB);

   while (mvb->size < size)
      mvb->size *= 2;

   free( mvb->vert_store );
   mvb->vert_store = malloc( sizeof(mgaVertex) * mvb->size + 31);
   if (!mvb->vert_store) 
      FatalError("mga-glx: out of memory !\n");

   mvb->verts = (mgaVertexPtr)(((unsigned long)mvb->vert_store + 31) & ~31);

   gl_vector1ui_free( &mvb->clipped_elements );
   gl_vector1ui_alloc( &mvb->clipped_elements, VEC_WRITABLE, mvb->size, 32 );   
   if (!mvb->clipped_elements.start) 
      FatalError("mga-glx: out of memory !\n");

   free( VB->ClipMask );
   VB->ClipMask = (GLubyte *)malloc(sizeof(GLubyte) * mvb->size);
   if (!VB->ClipMask) 
      FatalError("mga-glx: out of memory !\n");

   if (VB->Type == VB_IMMEDIATE) {
      free( mvb->primitive );
      free( mvb->next_primitive );
      mvb->primitive = (GLuint *)malloc( sizeof(GLuint) * mvb->size );
      mvb->next_primitive = (GLuint *)malloc( sizeof(GLuint) * mvb->size );
      if (!mvb->primitive || !mvb->next_primitive)
	 FatalError("mga-glx: out of memory!");
   }
}


void mgaDDRegisterVB( struct vertex_buffer *VB )
{
   mgaVertexBufferPtr mvb;

   mvb = (mgaVertexBufferPtr)calloc( 1, sizeof(*mvb) );

   /* This looks like it allocates a lot of memory, but it basically
    * just sets an upper limit on how much can be used - nothing like
    * this amount will ever be turned into 'real' memory.
    */
   mvb->size = VB->Size * 5;
   mvb->vert_store = malloc( sizeof(mgaVertex) * mvb->size + 31);
   if (!mvb->vert_store) 
      FatalError("mga-glx: out of memory !\n");
   
   mvb->verts = (mgaVertexPtr)(((unsigned long)mvb->vert_store + 31) & ~31);

   gl_vector1ui_alloc( &mvb->clipped_elements, VEC_WRITABLE, mvb->size, 32 );
   if (!mvb->clipped_elements.start) 
      FatalError("mga-glx: out of memory !\n");

   free( VB->ClipMask );
   VB->ClipMask = (GLubyte *)malloc(sizeof(GLubyte) * mvb->size);
   if (!VB->ClipMask) 
      FatalError("mga-glx: out of memory !\n");

   mvb->primitive = (GLuint *)malloc( sizeof(GLuint) * mvb->size );
   mvb->next_primitive = (GLuint *)malloc( sizeof(GLuint) * mvb->size );
   if (!mvb->primitive || !mvb->next_primitive)
      FatalError("mga-glx: out of memory!");
   
   VB->driver_data = mvb;
}


void mgaDDUnregisterVB( struct vertex_buffer *VB )
{
   mgaVertexBufferPtr mvb = MGA_DRIVER_DATA(VB);
   
   if (mvb) {
      if (mvb->vert_store) free(mvb->vert_store);
      if (mvb->primitive) free(mvb->primitive);
      if (mvb->next_primitive) free(mvb->next_primitive);
      gl_vector1ui_free( &mvb->clipped_elements );
      free(mvb);
      VB->driver_data = 0;
   }      
}
