/*   EXTRAITS DE LA LICENCE
	Copyright CEA, contributeurs : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)
  
	Adresse ml :
	BILLARD, non joignable par ml ;
	CALISTE, damien P caliste AT cea P fr.

	Ce logiciel est un programme informatique servant  visualiser des
	structures atomiques dans un rendu pseudo-3D. 

	Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
	respectant les principes de diffusion des logiciels libres. Vous pouvez
	utiliser, modifier et/ou redistribuer ce programme sous les conditions
	de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA 
	sur le site "http://www.cecill.info".

	Le fait que vous puissiez accder  cet en-tte signifie que vous avez 
	pris connaissance de la licence CeCILL, et que vous en avez accept les
	termes (cf. le fichier Documentation/licence.fr.txt fourni avec ce logiciel).
*/

/*   LICENCE SUM UP
	Copyright CEA, contributors : Luc BILLARD et Damien
	CALISTE, laboratoire L_Sim, (2001-2005)

	E-mail address:
	BILLARD, not reachable any more ;
	CALISTE, damien P caliste AT cea P fr.

	This software is a computer program whose purpose is to visualize atomic
	configurations in 3D.

	This software is governed by the CeCILL  license under French law and
	abiding by the rules of distribution of free software.  You can  use, 
	modify and/ or redistribute the software under the terms of the CeCILL
	license as circulated by CEA, CNRS and INRIA at the following URL
	"http://www.cecill.info". 

	The fact that you are presently reading this means that you have had
	knowledge of the CeCILL license and that you accept its terms. You can
	find a copy of this licence shipped with this software at Documentation/licence.en.txt.
*/
#ifndef OPENGL_H
#define OPENGL_H

#include <GL/gl.h>
#include <GL/glu.h> 

#include <glib.h>

#include "visu_data.h"
#include "openGLFunctions/light.h"
#include "openGLFunctions/view.h"

/***************/
/* Public part */
/***************/

/**
 * setOpenGlMaterial:
 * @material: a 5 elements array with the material properties ;
 * @rgba: a 4 elements array with the color values.
 *
 * This method call glMaterial to create the right shiningness, emission, diffuse...
 */
void setOpenGlMaterial(float* material, float* rgba);


/* Object to deal with quadrics. */
GLUquadricObj *obj;

/**
 * initOpengl:
 *
 * This initialises the drawing window and all the variables used
 * by this module. It must be called once by the main program and should
 * not be used otherwise.
 *
 * Returns: 1 if everything goes right.
 */
int initOpengl();

/* Objects to play with lights. */
LightEnvironnement *currentLights;


/* Draw methods */

/**
 * setAntialias:
 * @value: a boolean to activate or not the lines antialias.
 *
 * To set the antialiasing on lines.
 *
 * Returns: TRUE if the signal OpenGLAskForReDraw should be emitted.
 */
int setAntialias(int value);
/**
 * getAntialias:
 *
 * Get the value of the antialiasing parameter.
 *
 * Returns: wether or not the antialising for lines is activated.
 */
int getAntialias();

/**
 * openGLSet_immediate:
 * @bool: a boolean to set or not the immediateDrawing option.
 *
 * If true all changes are applied only when the refresh button
 * is pushed.
 */
void openGLSet_immediate(int bool);
/**
 * openGLGet_immediate:
 *
 * Get the value of the immediateDrawing option.
 *
 * Returns: the value of the immediateDrawing option.
 */
int openGLGet_immediate();
/**
 * openGLSet_trueTransparency:
 * @status: a boolean.
 *
 * If true the rendering is done twice to respect the transparency.
 *
 * Returns: TRUE if redraw should be done.
 */
gboolean openGLSet_trueTransparency(gboolean status);
/**
 * openGLGet_trueTransparency:
 *
 * The drawing can be done in one pass or two to respect transparency.
 *
 * Returns: TRUE if the drawing is done twice.
 */
gboolean openGLGet_trueTransparency();
/**
 * openGLSet_stereoAngle:
 * @angle: a positive floating point value.
 *
 * Change the angle of the eyes in the stereo output.
 *
 * Returns: TRUE if redraw should be done.
 */
gboolean openGLSet_stereoAngle(float angle);
/**
 * openGLGet_stereoAngle:
 *
 * Retrieve the angle of the eyes in the stereo output.
 *
 * Returns: the angle.
 */
float openGLGet_stereoAngle();
/**
 * openGLGet_stereoCapability:
 *
 * Retrieve if the OpenGL window can render in stereo or not.
 *
 * Returns: TRUE if the OpenGL surface can draw in stereo.
 */
gboolean openGLGet_stereoCapability();
/**
 * openGLSet_stereo:
 * @status: a boolean.
 *
 * Change the type of rendering. The surface can be switch to stereo,
 * only if the OpenGL has stereo capabilities (see
 * openGLGet_stereoCapability()).
 */
void openGLSet_stereo(gboolean status);
/**
 * openGLGet_stereo:
 *
 * Retrieve the status of the OpenGL surface.
 *
 * Returns: TRUE if the surface try to draw in stereo (may be TRUE,
 *          even if openGLGet_stereoCapability() returns FALSE, in
 *          that case the stereo capability is not used).
 */
gboolean openGLGet_stereo();

/* redraw methods */
/**
 * openGL_reDraw:
 * @lists: a string array, NULL terminated.
 * @data: some associated data.
 *
 * Basic drawing method : it clears the OpenGL area and call all lists if @lists
 * is NULL, or draw only the given lists.
 */
void openGL_reDraw(const char **lists, gpointer data);
/**
 * openGL_drawToEmpty:
 * @lists: a string array, NULL terminated.
 * @data: some associated data.
 *
 * Basic drawing method when no data is loaded: it draws the V_Sim logo.
 */
void openGL_drawToEmpty(const char **lists, gpointer data);
/**
 * openGLInit_context:
 *
 * This method is called when an OpenGL surface is created for the first time.
 * It sets basic OpenGL options and calls other OpenGLFunctions used in V_Sim.
 */
void openGLInit_context();


#endif
